#! /usr/bin/env false

use v6.d;

unit grammar IRC::Client::Plugin::Reminders::Grammar;

regex TOP {
	<.preamble>
	<.ws>
	<subject>
}

token preamble {
	:i
	'remind me to'
}

rule subject {
	.+
	<.ws>
	<delay>
}

regex delay {
	'in'
	<.ws>
	<delay-minutes>?
	<delay-hours>?
	<delay-days>?
	<delay-weeks>?
}

token delay-minutes {
	<( \d+ )>
	<.ws>
	'm' [ 'in' [ 'ute' 's'? ]? ]?
}

token delay-hours {
	<( \d+ )>
	<.ws>
	'h' [ 'our' 's'? ]?
}

token delay-days {
	<( \d+ )>
	<.ws>
	'd' [ 'ay' 's'? ]?
}

token delay-weeks {
	<( \d+ )>
	<.ws>
	'w' [ 'eek' 's'? ]?
}

=begin pod

=NAME    IRC::Client::Plugin::Reminders::Grammar
=VERSION 0.1.0
=AUTHOR  Patrick Spek <p.spek@tyil.nl>

=begin LICENSE
Copyright © 2020

This program is free software: you can redistribute it and/or modify it under
the terms of the GNU Affero General Public License as published by the Free
Software Foundation, either version 3 of the License, or (at your option) any
later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
details.

You should have received a copy of the GNU Affero General Public License along
with this program.  If not, see http://www.gnu.org/licenses/.
=end LICENSE

=end pod

# vim: ft=raku noet sw=8 ts=8
