use Test;
use File::Temp;

use lib './t/lib';

use Module2Rpm::Package;
use Module2Rpm::Spec;
use Mocks;

my $module-name-prefix = "perl6-";

my $metadata = {
    name => 'Module::Name',
    version => '1.1.1',
    source-url => 'http://www.cpan.org/authors/id/A/AR/ARNE/Perl6/p6-time-repeat-0.0101.tar.gz',
}

my $spec = Module2Rpm::Spec.new(metadata => $metadata);

my $tempdir = tempdir().IO;
my $package;
lives-ok {$package = Module2Rpm::Package.new(spec => $spec, path => $tempdir)}, "Creating Package object works without exception";

is-deeply $package.spec, $spec, "Metadata are the expected one";
is $package.module-name, "{$module-name-prefix}Module-Name", "Module name is the expected one";
is $package.path.absolute, $tempdir.add($package.module-name), "Package directory path is the expected one";
ok $package.path.e, "Package directory was created";
is $package.tar-name, "{$module-name-prefix}Module-Name-1.1.1.tar.xz", "Tar name is the expected one";
is $package.tar-archive-path, "{$tempdir.add($package.module-name).add($package.tar-name)}", "Tar path is the expected one";
is $package.source-url, 'http://www.cpan.org/authors/id/A/AR/ARNE/Perl6/p6-time-repeat-0.0101.tar.gz', "Source url is the expected one";
is $package.spec-file-name, "{$module-name-prefix}Module-Name.spec", "Spec file name is the expected one";
is $package.spec-file-path, "{$tempdir.add($package.module-name).add($package.spec-file-name)}", "Spec file path is the expected one";
is $package.client.WHAT, Module2Rpm::Cro::Client.WHAT, "Proper Client default class is used";
is $package.git.WHAT, Module2Rpm::Download::Git.WHAT, "Proper Git default class is used";
is $package.tar.WHAT, Module2Rpm::Archive::Tar.WHAT, "Proper Tar default class is used";

{
    my $client = Mocks::ClientReplacement.new;
    my $package = Module2Rpm::Package.new(spec => $spec, path => $tempdir, client => $client, git => Mocks::GitReplacement.new, tar => Mocks::TarReplacement.new);

    lives-ok { $package.Download() }, "Download does not die";
}
{
    my $client = Mocks::ClientReplacement.new(fail => True, error => "Test exception");
    my $package = Module2Rpm::Package.new(spec => $spec, path => $tempdir, client => $client, git => Mocks::GitReplacement.new, tar => Mocks::TarReplacement.new);
    throws-like {$package.Download()}, X::AdHoc, payload => /'Test exception'/, "Package dies when something goes wrong";
}

done-testing;
