

Class QAbstractButton
---------------------
	imported by
		use Qt::QtWidgets::QAbstractButton;

	inherits QWidget

	inherited by QPushButton


#### Method activateWindow()
	inherited from QWidget
	calls Qt method void activateWindow()

#### Method click()
	[slot] 
	calls Qt method void click()

#### Method clicked(Bool $checked = False)
	[signal] 
	calls Qt method void clicked(bool checked = false)

#### Method enterEvent(QEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void enterEvent(QEvent* event)

#### Method font( --> QFont)
	inherited from QWidget
	calls Qt method QFont & font()

#### Method height( --> Int)
	inherited from QWidget
	calls Qt method int height()

#### Method isActiveWindow( --> Bool)
	inherited from QWidget
	calls Qt method bool isActiveWindow()

#### Method leaveEvent(QEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void leaveEvent(QEvent* event)

#### Method mouseMoveEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mouseMoveEvent(QMouseEvent* event)

#### Method mousePressEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mousePressEvent(QMouseEvent* event)

#### Method mouseReleaseEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mouseReleaseEvent(QMouseEvent* event)

#### Method paintEvent(QPaintEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void paintEvent(QPaintEvent* event)

#### Method pressed()
	[signal] 
	calls Qt method void pressed()

#### Method render(QPaintDevice $target, QPoint $targetOffset = QPoint.new(), QRegion $sourceRegion = QRegion.new(), Int $renderFlags = RenderFlags(DrawWindowBackground +| DrawChildren))
	inherited from QWidget
	calls Qt method void render(QPaintDevice* target, const QPoint& targetOffset = QPoint(), const QRegion& sourceRegion = QRegion(), RenderFlags renderFlags = RenderFlags(DrawWindowBackground | DrawChildren))

#### Method resizeEvent(QResizeEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void resizeEvent(QResizeEvent* event)

#### Method setDisabled(Bool $arg1)
	[slot] inherited from QWidget
	calls Qt method void setDisabled(bool arg1)

#### Method setFixedHeight(Int $h)
	inherited from QWidget
	calls Qt method void setFixedHeight(int h)

#### Method setFixedSize(Int $w, Int $h)
	inherited from QWidget
	calls Qt method void setFixedSize(int w, int h)

#### Method setFixedWidth(Int $w)
	inherited from QWidget
	calls Qt method void setFixedWidth(int w)

#### Method setFocus()
	[slot] inherited from QWidget
	calls Qt method void setFocus()

#### Method setFocus(Qt::FocusReason $reason)
	inherited from QWidget
	calls Qt method void setFocus(Qt::FocusReason reason)

#### Method setFocusPolicy(Qt::FocusPolicy $policy)
	inherited from QWidget
	calls Qt method void setFocusPolicy(Qt::FocusPolicy policy)

#### Method setFont(QFont $arg1)
	inherited from QWidget
	calls Qt method void setFont(const QFont& arg1)

#### Method setLayout(QLayout $arg1)
	inherited from QWidget
	calls Qt method void setLayout(QLayout* arg1)

#### Method setMinimumSize(Int $minw, Int $minh)
	inherited from QWidget
	calls Qt method void setMinimumSize(int minw, int minh)

#### Method setText(Str $text)
	calls Qt method void setText(const QString& text)

#### Method setToolTip(Str $arg1)
	inherited from QWidget
	calls Qt method void setToolTip(const QString& arg1)

#### Method setWindowTitle(Str $arg1)
	[slot] inherited from QWidget
	calls Qt method void setWindowTitle(const QString& arg1)

#### Method show()
	[slot] inherited from QWidget
	calls Qt method void show()

#### Method text( --> Str)
	calls Qt method QString text()

#### Method update()
	[slot] inherited from QWidget
	calls Qt method void update()

#### Method update(Int $x, Int $y, Int $w, Int $h)
	inherited from QWidget
	calls Qt method void update(int x, int y, int w, int h)

#### Method width( --> Int)
	inherited from QWidget
	calls Qt method int width()


Class QAbstractScrollArea
-------------------------
	imported by
		use Qt::QtWidgets::QAbstractScrollArea;

	inherits QFrame

	inherited by QTextEdit


#### Method activateWindow()
	inherited from QWidget
	calls Qt method void activateWindow()

#### Method enterEvent(QEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void enterEvent(QEvent* event)

#### Method font( --> QFont)
	inherited from QWidget
	calls Qt method QFont & font()

#### Method height( --> Int)
	inherited from QWidget
	calls Qt method int height()

#### Method isActiveWindow( --> Bool)
	inherited from QWidget
	calls Qt method bool isActiveWindow()

#### Method leaveEvent(QEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void leaveEvent(QEvent* event)

#### Method mouseMoveEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mouseMoveEvent(QMouseEvent* event)

#### Method mousePressEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mousePressEvent(QMouseEvent* event)

#### Method mouseReleaseEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mouseReleaseEvent(QMouseEvent* event)

#### Method paintEvent(QPaintEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void paintEvent(QPaintEvent* event)

#### Method render(QPaintDevice $target, QPoint $targetOffset = QPoint.new(), QRegion $sourceRegion = QRegion.new(), Int $renderFlags = RenderFlags(DrawWindowBackground +| DrawChildren))
	inherited from QWidget
	calls Qt method void render(QPaintDevice* target, const QPoint& targetOffset = QPoint(), const QRegion& sourceRegion = QRegion(), RenderFlags renderFlags = RenderFlags(DrawWindowBackground | DrawChildren))

#### Method resizeEvent(QResizeEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void resizeEvent(QResizeEvent* event)

#### Method setDisabled(Bool $arg1)
	[slot] inherited from QWidget
	calls Qt method void setDisabled(bool arg1)

#### Method setFixedHeight(Int $h)
	inherited from QWidget
	calls Qt method void setFixedHeight(int h)

#### Method setFixedSize(Int $w, Int $h)
	inherited from QWidget
	calls Qt method void setFixedSize(int w, int h)

#### Method setFixedWidth(Int $w)
	inherited from QWidget
	calls Qt method void setFixedWidth(int w)

#### Method setFocus()
	[slot] inherited from QWidget
	calls Qt method void setFocus()

#### Method setFocus(Qt::FocusReason $reason)
	inherited from QWidget
	calls Qt method void setFocus(Qt::FocusReason reason)

#### Method setFocusPolicy(Qt::FocusPolicy $policy)
	inherited from QWidget
	calls Qt method void setFocusPolicy(Qt::FocusPolicy policy)

#### Method setFont(QFont $arg1)
	inherited from QWidget
	calls Qt method void setFont(const QFont& arg1)

#### Method setLayout(QLayout $arg1)
	inherited from QWidget
	calls Qt method void setLayout(QLayout* arg1)

#### Method setMinimumSize(Int $minw, Int $minh)
	inherited from QWidget
	calls Qt method void setMinimumSize(int minw, int minh)

#### Method setToolTip(Str $arg1)
	inherited from QWidget
	calls Qt method void setToolTip(const QString& arg1)

#### Method setWindowTitle(Str $arg1)
	[slot] inherited from QWidget
	calls Qt method void setWindowTitle(const QString& arg1)

#### Method show()
	[slot] inherited from QWidget
	calls Qt method void show()

#### Method update()
	[slot] inherited from QWidget
	calls Qt method void update()

#### Method update(Int $x, Int $y, Int $w, Int $h)
	inherited from QWidget
	calls Qt method void update(int x, int y, int w, int h)

#### Method width( --> Int)
	inherited from QWidget
	calls Qt method int width()


Class QAction
-------------
	imported by
		use Qt::QtWidgets::QAction;

	inherits QObject




#### Method QAction.new(QObject $parent = (QObject) --> QAction))
	calls Qt method  QAction(QObject* parent = nullptr)

#### Method setDisabled(Bool $b)
	[slot] 
	calls Qt method void setDisabled(bool b)

#### Method setEnabled(Bool $arg1)
	[slot] 
	calls Qt method void setEnabled(bool arg1)

#### Method trigger()
	[slot] 
	calls Qt method void trigger()

#### Method triggered(Bool $checked = False)
	[signal] 
	calls Qt method void triggered(bool checked = false)


Class QBoxLayout
----------------
	imported by
		use Qt::QtWidgets::QBoxLayout;

	inherits QLayout

	inherited by QHBoxLayout, QVBoxLayout


#### Method addLayout(QLayout $layout, Int $stretch = 0)
	calls Qt method void addLayout(QLayout* layout, int stretch = 0)

#### Method addWidget(QWidget $w)
	inherited from QLayout
	calls Qt method void addWidget(QWidget* w)

#### Method setAlignment(QWidget $w, Int $alignment --> Bool)
	inherited from QLayout
	calls Qt method bool setAlignment(QWidget* w, Qt::Alignment alignment)

#### Method setAlignment(QLayout $l, Int $alignment --> Bool)
	inherited from QLayout
	calls Qt method bool setAlignment(QLayout* l, Qt::Alignment alignment)


Class QBrush
------------
	imported by
		use Qt::QtWidgets::QBrush;





#### Method QBrush.new( --> QBrush))
	calls Qt method  QBrush()

#### Method QBrush.new(Qt::BrushStyle $bs --> QBrush))
	calls Qt method  QBrush(Qt::BrushStyle bs)

#### Method QBrush.new(QColor $color, Qt::BrushStyle $bs = Qt::SolidPattern --> QBrush))
	calls Qt method  QBrush(const QColor& color, Qt::BrushStyle bs = Qt::SolidPattern)

#### Method setColor(QColor $color)
	calls Qt method void setColor(const QColor& color)

#### Method setStyle(Qt::BrushStyle $arg1)
	calls Qt method void setStyle(Qt::BrushStyle arg1)


Class QColor
------------
	imported by
		use Qt::QtWidgets::QColor;





#### Method alpha( --> Int)
	calls Qt method int alpha()

#### Method blue( --> Int)
	calls Qt method int blue()

#### Method QColor.new(Qt::GlobalColor $color --> QColor))
	calls Qt method  QColor(Qt::GlobalColor color)

#### Method QColor.new(Int $r, Int $g, Int $b, Int $a = 255 --> QColor))
	calls Qt method  QColor(int r, int g, int b, int a = 255)

#### Method green( --> Int)
	calls Qt method int green()

#### Method red( --> Int)
	calls Qt method int red()


Class QCoreApplication
----------------------
	imported by
		use Qt::QtWidgets::QCoreApplication;

	inherits QObject

	inherited by QGuiApplication


#### Method quit()
	[slot] [static] 
	calls Qt method void quit()

#### Method sendEvent(QObject $receiver, QEvent $event --> Bool)
	[static] 
	calls Qt method bool sendEvent(QObject* receiver, QEvent* event)


Class QDialog
-------------
	imported by
		use Qt::QtWidgets::QDialog;

	inherits QWidget

	inherited by QFileDialog


#### Method activateWindow()
	inherited from QWidget
	calls Qt method void activateWindow()

#### Method enterEvent(QEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void enterEvent(QEvent* event)

#### Method font( --> QFont)
	inherited from QWidget
	calls Qt method QFont & font()

#### Method height( --> Int)
	inherited from QWidget
	calls Qt method int height()

#### Method isActiveWindow( --> Bool)
	inherited from QWidget
	calls Qt method bool isActiveWindow()

#### Method leaveEvent(QEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void leaveEvent(QEvent* event)

#### Method mouseMoveEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mouseMoveEvent(QMouseEvent* event)

#### Method mousePressEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mousePressEvent(QMouseEvent* event)

#### Method mouseReleaseEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mouseReleaseEvent(QMouseEvent* event)

#### Method paintEvent(QPaintEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void paintEvent(QPaintEvent* event)

#### Method render(QPaintDevice $target, QPoint $targetOffset = QPoint.new(), QRegion $sourceRegion = QRegion.new(), Int $renderFlags = RenderFlags(DrawWindowBackground +| DrawChildren))
	inherited from QWidget
	calls Qt method void render(QPaintDevice* target, const QPoint& targetOffset = QPoint(), const QRegion& sourceRegion = QRegion(), RenderFlags renderFlags = RenderFlags(DrawWindowBackground | DrawChildren))

#### Method resizeEvent(QResizeEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void resizeEvent(QResizeEvent* event)

#### Method setDisabled(Bool $arg1)
	[slot] inherited from QWidget
	calls Qt method void setDisabled(bool arg1)

#### Method setFixedHeight(Int $h)
	inherited from QWidget
	calls Qt method void setFixedHeight(int h)

#### Method setFixedSize(Int $w, Int $h)
	inherited from QWidget
	calls Qt method void setFixedSize(int w, int h)

#### Method setFixedWidth(Int $w)
	inherited from QWidget
	calls Qt method void setFixedWidth(int w)

#### Method setFocus()
	[slot] inherited from QWidget
	calls Qt method void setFocus()

#### Method setFocus(Qt::FocusReason $reason)
	inherited from QWidget
	calls Qt method void setFocus(Qt::FocusReason reason)

#### Method setFocusPolicy(Qt::FocusPolicy $policy)
	inherited from QWidget
	calls Qt method void setFocusPolicy(Qt::FocusPolicy policy)

#### Method setFont(QFont $arg1)
	inherited from QWidget
	calls Qt method void setFont(const QFont& arg1)

#### Method setLayout(QLayout $arg1)
	inherited from QWidget
	calls Qt method void setLayout(QLayout* arg1)

#### Method setMinimumSize(Int $minw, Int $minh)
	inherited from QWidget
	calls Qt method void setMinimumSize(int minw, int minh)

#### Method setToolTip(Str $arg1)
	inherited from QWidget
	calls Qt method void setToolTip(const QString& arg1)

#### Method setWindowTitle(Str $arg1)
	[slot] inherited from QWidget
	calls Qt method void setWindowTitle(const QString& arg1)

#### Method show()
	[slot] inherited from QWidget
	calls Qt method void show()

#### Method update()
	[slot] inherited from QWidget
	calls Qt method void update()

#### Method update(Int $x, Int $y, Int $w, Int $h)
	inherited from QWidget
	calls Qt method void update(int x, int y, int w, int h)

#### Method width( --> Int)
	inherited from QWidget
	calls Qt method int width()


Class QEvent
------------
	imported by
		use Qt::QtWidgets::QEvent;


	inherited by QInputEvent, QPaintEvent, QResizeEvent

    enum Type 

#### Method accept()
	calls Qt method void accept()

#### Method QEvent.new(QEvent::Type $type --> QEvent))
	calls Qt method  QEvent(Type type)

#### Method QEvent.new(QEvent $other --> QEvent))
	calls Qt method  QEvent(const QEvent& other)

#### Method ignore()
	calls Qt method void ignore()

#### Method isAccepted( --> Bool)
	calls Qt method bool isAccepted()

#### Method spontaneous( --> Bool)
	calls Qt method bool spontaneous()

#### Method type( --> QEvent::Type)
	calls Qt method Type type()


Class QFileDialog
-----------------
	imported by
		use Qt::QtWidgets::QFileDialog;

	inherits QDialog



    enum Option 

#### Method activateWindow()
	inherited from QWidget
	calls Qt method void activateWindow()

#### Method enterEvent(QEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void enterEvent(QEvent* event)

#### Method font( --> QFont)
	inherited from QWidget
	calls Qt method QFont & font()

#### Method getOpenFileName(QWidget $parent = (QWidget), Str $caption = "", Str $dir = "", Str $filter = "", Str $selectedFilter = (Str), Int $options = Options() --> Str)
	[static] 
	calls Qt method QString getOpenFileName(QWidget* parent = nullptr, const QString& caption = QString(), const QString& dir = QString(), const QString& filter = QString(), QString* selectedFilter = nullptr, Options options = Options())

#### Method getSaveFileName(QWidget $parent = (QWidget), Str $caption = "", Str $dir = "", Str $filter = "", Str $selectedFilter = (Str), Int $options = Options() --> Str)
	[static] 
	calls Qt method QString getSaveFileName(QWidget* parent = nullptr, const QString& caption = QString(), const QString& dir = QString(), const QString& filter = QString(), QString* selectedFilter = nullptr, Options options = Options())

#### Method height( --> Int)
	inherited from QWidget
	calls Qt method int height()

#### Method isActiveWindow( --> Bool)
	inherited from QWidget
	calls Qt method bool isActiveWindow()

#### Method leaveEvent(QEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void leaveEvent(QEvent* event)

#### Method mouseMoveEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mouseMoveEvent(QMouseEvent* event)

#### Method mousePressEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mousePressEvent(QMouseEvent* event)

#### Method mouseReleaseEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mouseReleaseEvent(QMouseEvent* event)

#### Method paintEvent(QPaintEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void paintEvent(QPaintEvent* event)

#### Method render(QPaintDevice $target, QPoint $targetOffset = QPoint.new(), QRegion $sourceRegion = QRegion.new(), Int $renderFlags = RenderFlags(DrawWindowBackground +| DrawChildren))
	inherited from QWidget
	calls Qt method void render(QPaintDevice* target, const QPoint& targetOffset = QPoint(), const QRegion& sourceRegion = QRegion(), RenderFlags renderFlags = RenderFlags(DrawWindowBackground | DrawChildren))

#### Method resizeEvent(QResizeEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void resizeEvent(QResizeEvent* event)

#### Method setDisabled(Bool $arg1)
	[slot] inherited from QWidget
	calls Qt method void setDisabled(bool arg1)

#### Method setFixedHeight(Int $h)
	inherited from QWidget
	calls Qt method void setFixedHeight(int h)

#### Method setFixedSize(Int $w, Int $h)
	inherited from QWidget
	calls Qt method void setFixedSize(int w, int h)

#### Method setFixedWidth(Int $w)
	inherited from QWidget
	calls Qt method void setFixedWidth(int w)

#### Method setFocus()
	[slot] inherited from QWidget
	calls Qt method void setFocus()

#### Method setFocus(Qt::FocusReason $reason)
	inherited from QWidget
	calls Qt method void setFocus(Qt::FocusReason reason)

#### Method setFocusPolicy(Qt::FocusPolicy $policy)
	inherited from QWidget
	calls Qt method void setFocusPolicy(Qt::FocusPolicy policy)

#### Method setFont(QFont $arg1)
	inherited from QWidget
	calls Qt method void setFont(const QFont& arg1)

#### Method setLayout(QLayout $arg1)
	inherited from QWidget
	calls Qt method void setLayout(QLayout* arg1)

#### Method setMinimumSize(Int $minw, Int $minh)
	inherited from QWidget
	calls Qt method void setMinimumSize(int minw, int minh)

#### Method setToolTip(Str $arg1)
	inherited from QWidget
	calls Qt method void setToolTip(const QString& arg1)

#### Method setWindowTitle(Str $arg1)
	[slot] inherited from QWidget
	calls Qt method void setWindowTitle(const QString& arg1)

#### Method show()
	[slot] inherited from QWidget
	calls Qt method void show()

#### Method update()
	[slot] inherited from QWidget
	calls Qt method void update()

#### Method update(Int $x, Int $y, Int $w, Int $h)
	inherited from QWidget
	calls Qt method void update(int x, int y, int w, int h)

#### Method width( --> Int)
	inherited from QWidget
	calls Qt method int width()


Class QFont
-----------
	imported by
		use Qt::QtWidgets::QFont;





#### Method QFont.new( --> QFont))
	calls Qt method  QFont()

#### Method setBold(Bool $arg1)
	calls Qt method void setBold(bool arg1)

#### Method setFamily(Str $arg1)
	calls Qt method void setFamily(const QString& arg1)

#### Method setItalic(Bool $b)
	calls Qt method void setItalic(bool b)

#### Method setPointSize(Int $arg1)
	calls Qt method void setPointSize(int arg1)

#### Method setStretch(Int $arg1)
	calls Qt method void setStretch(int arg1)

#### Method stretch( --> Int)
	calls Qt method int stretch()


Class QFrame
------------
	imported by
		use Qt::QtWidgets::QFrame;

	inherits QWidget

	inherited by QAbstractScrollArea, QLabel


#### Method activateWindow()
	inherited from QWidget
	calls Qt method void activateWindow()

#### Method enterEvent(QEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void enterEvent(QEvent* event)

#### Method font( --> QFont)
	inherited from QWidget
	calls Qt method QFont & font()

#### Method height( --> Int)
	inherited from QWidget
	calls Qt method int height()

#### Method isActiveWindow( --> Bool)
	inherited from QWidget
	calls Qt method bool isActiveWindow()

#### Method leaveEvent(QEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void leaveEvent(QEvent* event)

#### Method mouseMoveEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mouseMoveEvent(QMouseEvent* event)

#### Method mousePressEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mousePressEvent(QMouseEvent* event)

#### Method mouseReleaseEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mouseReleaseEvent(QMouseEvent* event)

#### Method paintEvent(QPaintEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void paintEvent(QPaintEvent* event)

#### Method render(QPaintDevice $target, QPoint $targetOffset = QPoint.new(), QRegion $sourceRegion = QRegion.new(), Int $renderFlags = RenderFlags(DrawWindowBackground +| DrawChildren))
	inherited from QWidget
	calls Qt method void render(QPaintDevice* target, const QPoint& targetOffset = QPoint(), const QRegion& sourceRegion = QRegion(), RenderFlags renderFlags = RenderFlags(DrawWindowBackground | DrawChildren))

#### Method resizeEvent(QResizeEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void resizeEvent(QResizeEvent* event)

#### Method setDisabled(Bool $arg1)
	[slot] inherited from QWidget
	calls Qt method void setDisabled(bool arg1)

#### Method setFixedHeight(Int $h)
	inherited from QWidget
	calls Qt method void setFixedHeight(int h)

#### Method setFixedSize(Int $w, Int $h)
	inherited from QWidget
	calls Qt method void setFixedSize(int w, int h)

#### Method setFixedWidth(Int $w)
	inherited from QWidget
	calls Qt method void setFixedWidth(int w)

#### Method setFocus()
	[slot] inherited from QWidget
	calls Qt method void setFocus()

#### Method setFocus(Qt::FocusReason $reason)
	inherited from QWidget
	calls Qt method void setFocus(Qt::FocusReason reason)

#### Method setFocusPolicy(Qt::FocusPolicy $policy)
	inherited from QWidget
	calls Qt method void setFocusPolicy(Qt::FocusPolicy policy)

#### Method setFont(QFont $arg1)
	inherited from QWidget
	calls Qt method void setFont(const QFont& arg1)

#### Method setLayout(QLayout $arg1)
	inherited from QWidget
	calls Qt method void setLayout(QLayout* arg1)

#### Method setMinimumSize(Int $minw, Int $minh)
	inherited from QWidget
	calls Qt method void setMinimumSize(int minw, int minh)

#### Method setToolTip(Str $arg1)
	inherited from QWidget
	calls Qt method void setToolTip(const QString& arg1)

#### Method setWindowTitle(Str $arg1)
	[slot] inherited from QWidget
	calls Qt method void setWindowTitle(const QString& arg1)

#### Method show()
	[slot] inherited from QWidget
	calls Qt method void show()

#### Method update()
	[slot] inherited from QWidget
	calls Qt method void update()

#### Method update(Int $x, Int $y, Int $w, Int $h)
	inherited from QWidget
	calls Qt method void update(int x, int y, int w, int h)

#### Method width( --> Int)
	inherited from QWidget
	calls Qt method int width()


Class QGuiApplication
---------------------
	imported by
		use Qt::QtWidgets::QGuiApplication;

	inherits QCoreApplication




#### Method quit()
	[slot] [static] inherited from QCoreApplication
	calls Qt method void quit()

#### Method sendEvent(QObject $receiver, QEvent $event --> Bool)
	[static] inherited from QCoreApplication
	calls Qt method bool sendEvent(QObject* receiver, QEvent* event)


Class QHBoxLayout
-----------------
	imported by
		use Qt::QtWidgets::QHBoxLayout;

	inherits QBoxLayout




#### Method addLayout(QLayout $layout, Int $stretch = 0)
	inherited from QBoxLayout
	calls Qt method void addLayout(QLayout* layout, int stretch = 0)

#### Method addWidget(QWidget $w)
	inherited from QLayout
	calls Qt method void addWidget(QWidget* w)

#### Method QHBoxLayout.new( --> QHBoxLayout))
	calls Qt method  QHBoxLayout()

#### Method setAlignment(QWidget $w, Int $alignment --> Bool)
	inherited from QLayout
	calls Qt method bool setAlignment(QWidget* w, Qt::Alignment alignment)

#### Method setAlignment(QLayout $l, Int $alignment --> Bool)
	inherited from QLayout
	calls Qt method bool setAlignment(QLayout* l, Qt::Alignment alignment)


Class QImage
------------
	imported by
		use Qt::QtWidgets::QImage;

	inherits QPaintDevice



    enum Format 

#### Method QImage.new(Int $width, Int $height, QImage::Format $format --> QImage))
	calls Qt method  QImage(int width, int height, Format format)

#### Method fill(QColor $color)
	calls Qt method void fill(const QColor& color)

#### Method height( --> Int)
	calls Qt method int height()

#### Method pixelColor(Int $x, Int $y --> QColor)
	calls Qt method QColor pixelColor(int x, int y)

#### Method width( --> Int)
	calls Qt method int width()


Class QInputEvent
-----------------
	imported by
		use Qt::QtWidgets::QInputEvent;

	inherits QEvent

	inherited by QMouseEvent


#### Method accept()
	inherited from QEvent
	calls Qt method void accept()

#### Method ignore()
	inherited from QEvent
	calls Qt method void ignore()

#### Method isAccepted( --> Bool)
	inherited from QEvent
	calls Qt method bool isAccepted()

#### Method spontaneous( --> Bool)
	inherited from QEvent
	calls Qt method bool spontaneous()

#### Method type( --> QEvent::Type)
	inherited from QEvent
	calls Qt method Type type()


Class QLabel
------------
	imported by
		use Qt::QtWidgets::QLabel;

	inherits QFrame




#### Method activateWindow()
	inherited from QWidget
	calls Qt method void activateWindow()

#### Method clear()
	[slot] 
	calls Qt method void clear()

#### Method QLabel.new(QWidget $parent = (QWidget), Int $f = Qt::WindowFlags() --> QLabel))
	calls Qt method  QLabel(QWidget* parent = nullptr, Qt::WindowFlags f = Qt::WindowFlags())

#### Method QLabel.new(Str $text, QWidget $parent = (QWidget), Int $f = Qt::WindowFlags() --> QLabel))
	calls Qt method  QLabel(const QString& text, QWidget* parent = nullptr, Qt::WindowFlags f = Qt::WindowFlags())

#### Method enterEvent(QEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void enterEvent(QEvent* event)

#### Method font( --> QFont)
	inherited from QWidget
	calls Qt method QFont & font()

#### Method height( --> Int)
	inherited from QWidget
	calls Qt method int height()

#### Method isActiveWindow( --> Bool)
	inherited from QWidget
	calls Qt method bool isActiveWindow()

#### Method leaveEvent(QEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void leaveEvent(QEvent* event)

#### Method mouseMoveEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mouseMoveEvent(QMouseEvent* event)

#### Method mousePressEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mousePressEvent(QMouseEvent* event)

#### Method mouseReleaseEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mouseReleaseEvent(QMouseEvent* event)

#### Method paintEvent(QPaintEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void paintEvent(QPaintEvent* event)

#### Method render(QPaintDevice $target, QPoint $targetOffset = QPoint.new(), QRegion $sourceRegion = QRegion.new(), Int $renderFlags = RenderFlags(DrawWindowBackground +| DrawChildren))
	inherited from QWidget
	calls Qt method void render(QPaintDevice* target, const QPoint& targetOffset = QPoint(), const QRegion& sourceRegion = QRegion(), RenderFlags renderFlags = RenderFlags(DrawWindowBackground | DrawChildren))

#### Method resizeEvent(QResizeEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void resizeEvent(QResizeEvent* event)

#### Method setAlignment(Int $arg1)
	calls Qt method void setAlignment(Qt::Alignment arg1)

#### Method setDisabled(Bool $arg1)
	[slot] inherited from QWidget
	calls Qt method void setDisabled(bool arg1)

#### Method setFixedHeight(Int $h)
	inherited from QWidget
	calls Qt method void setFixedHeight(int h)

#### Method setFixedSize(Int $w, Int $h)
	inherited from QWidget
	calls Qt method void setFixedSize(int w, int h)

#### Method setFixedWidth(Int $w)
	inherited from QWidget
	calls Qt method void setFixedWidth(int w)

#### Method setFocus()
	[slot] inherited from QWidget
	calls Qt method void setFocus()

#### Method setFocus(Qt::FocusReason $reason)
	inherited from QWidget
	calls Qt method void setFocus(Qt::FocusReason reason)

#### Method setFocusPolicy(Qt::FocusPolicy $policy)
	inherited from QWidget
	calls Qt method void setFocusPolicy(Qt::FocusPolicy policy)

#### Method setFont(QFont $arg1)
	inherited from QWidget
	calls Qt method void setFont(const QFont& arg1)

#### Method setLayout(QLayout $arg1)
	inherited from QWidget
	calls Qt method void setLayout(QLayout* arg1)

#### Method setMargin(Int $arg1)
	calls Qt method void setMargin(int arg1)

#### Method setMinimumSize(Int $minw, Int $minh)
	inherited from QWidget
	calls Qt method void setMinimumSize(int minw, int minh)

#### Method setText(Str $arg1)
	[slot] 
	calls Qt method void setText(const QString& arg1)

#### Method setTextFormat(Qt::TextFormat $arg1)
	calls Qt method void setTextFormat(Qt::TextFormat arg1)

#### Method setToolTip(Str $arg1)
	inherited from QWidget
	calls Qt method void setToolTip(const QString& arg1)

#### Method setWindowTitle(Str $arg1)
	[slot] inherited from QWidget
	calls Qt method void setWindowTitle(const QString& arg1)

#### Method show()
	[slot] inherited from QWidget
	calls Qt method void show()

#### Method update()
	[slot] inherited from QWidget
	calls Qt method void update()

#### Method update(Int $x, Int $y, Int $w, Int $h)
	inherited from QWidget
	calls Qt method void update(int x, int y, int w, int h)

#### Method width( --> Int)
	inherited from QWidget
	calls Qt method int width()


Class QLayout
-------------
	imported by
		use Qt::QtWidgets::QLayout;

	inherits QLayoutItem
	inherits QObject

	inherited by QBoxLayout


#### Method addWidget(QWidget $w)
	calls Qt method void addWidget(QWidget* w)

#### Method setAlignment(QWidget $w, Int $alignment --> Bool)
	calls Qt method bool setAlignment(QWidget* w, Qt::Alignment alignment)

#### Method setAlignment(QLayout $l, Int $alignment --> Bool)
	calls Qt method bool setAlignment(QLayout* l, Qt::Alignment alignment)


Class QLayoutItem
-----------------
	imported by
		use Qt::QtWidgets::QLayoutItem;


	inherited by QLayout



Class QLineEdit
---------------
	imported by
		use Qt::QtWidgets::QLineEdit;

	inherits QWidget




#### Method activateWindow()
	inherited from QWidget
	calls Qt method void activateWindow()

#### Method clear()
	[slot] 
	calls Qt method void clear()

#### Method QLineEdit.new(QWidget $parent = (QWidget) --> QLineEdit))
	calls Qt method  QLineEdit(QWidget* parent = nullptr)

#### Method QLineEdit.new(Str $arg1, QWidget $parent = (QWidget) --> QLineEdit))
	calls Qt method  QLineEdit(const QString& arg1, QWidget* parent = nullptr)

#### Method editingFinished()
	[signal] 
	calls Qt method void editingFinished()

#### Method enterEvent(QEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void enterEvent(QEvent* event)

#### Method font( --> QFont)
	inherited from QWidget
	calls Qt method QFont & font()

#### Method height( --> Int)
	inherited from QWidget
	calls Qt method int height()

#### Method isActiveWindow( --> Bool)
	inherited from QWidget
	calls Qt method bool isActiveWindow()

#### Method leaveEvent(QEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void leaveEvent(QEvent* event)

#### Method mouseMoveEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mouseMoveEvent(QMouseEvent* event)

#### Method mousePressEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mousePressEvent(QMouseEvent* event)

#### Method mouseReleaseEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mouseReleaseEvent(QMouseEvent* event)

#### Method paintEvent(QPaintEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void paintEvent(QPaintEvent* event)

#### Method render(QPaintDevice $target, QPoint $targetOffset = QPoint.new(), QRegion $sourceRegion = QRegion.new(), Int $renderFlags = RenderFlags(DrawWindowBackground +| DrawChildren))
	inherited from QWidget
	calls Qt method void render(QPaintDevice* target, const QPoint& targetOffset = QPoint(), const QRegion& sourceRegion = QRegion(), RenderFlags renderFlags = RenderFlags(DrawWindowBackground | DrawChildren))

#### Method resizeEvent(QResizeEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void resizeEvent(QResizeEvent* event)

#### Method returnPressed()
	[signal] 
	calls Qt method void returnPressed()

#### Method setAlignment(Int $flag)
	calls Qt method void setAlignment(Qt::Alignment flag)

#### Method setDisabled(Bool $arg1)
	[slot] inherited from QWidget
	calls Qt method void setDisabled(bool arg1)

#### Method setFixedHeight(Int $h)
	inherited from QWidget
	calls Qt method void setFixedHeight(int h)

#### Method setFixedSize(Int $w, Int $h)
	inherited from QWidget
	calls Qt method void setFixedSize(int w, int h)

#### Method setFixedWidth(Int $w)
	inherited from QWidget
	calls Qt method void setFixedWidth(int w)

#### Method setFocus()
	[slot] inherited from QWidget
	calls Qt method void setFocus()

#### Method setFocus(Qt::FocusReason $reason)
	inherited from QWidget
	calls Qt method void setFocus(Qt::FocusReason reason)

#### Method setFocusPolicy(Qt::FocusPolicy $policy)
	inherited from QWidget
	calls Qt method void setFocusPolicy(Qt::FocusPolicy policy)

#### Method setFont(QFont $arg1)
	inherited from QWidget
	calls Qt method void setFont(const QFont& arg1)

#### Method setLayout(QLayout $arg1)
	inherited from QWidget
	calls Qt method void setLayout(QLayout* arg1)

#### Method setMinimumSize(Int $minw, Int $minh)
	inherited from QWidget
	calls Qt method void setMinimumSize(int minw, int minh)

#### Method setText(Str $arg1)
	[slot] 
	calls Qt method void setText(const QString& arg1)

#### Method setToolTip(Str $arg1)
	inherited from QWidget
	calls Qt method void setToolTip(const QString& arg1)

#### Method setWindowTitle(Str $arg1)
	[slot] inherited from QWidget
	calls Qt method void setWindowTitle(const QString& arg1)

#### Method show()
	[slot] inherited from QWidget
	calls Qt method void show()

#### Method text( --> Str)
	calls Qt method QString text()

#### Method update()
	[slot] inherited from QWidget
	calls Qt method void update()

#### Method update(Int $x, Int $y, Int $w, Int $h)
	inherited from QWidget
	calls Qt method void update(int x, int y, int w, int h)

#### Method width( --> Int)
	inherited from QWidget
	calls Qt method int width()


Class QMenu
-----------
	imported by
		use Qt::QtWidgets::QMenu;

	inherits QWidget




#### Method activateWindow()
	inherited from QWidget
	calls Qt method void activateWindow()

#### Method addAction(Str $text --> QAction)
	calls Qt method QAction * addAction(const QString& text)

#### Method QMenu.new(QWidget $parent = (QWidget) --> QMenu))
	calls Qt method  QMenu(QWidget* parent = nullptr)

#### Method QMenu.new(Str $title, QWidget $parent = (QWidget) --> QMenu))
	calls Qt method  QMenu(const QString& title, QWidget* parent = nullptr)

#### Method enterEvent(QEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void enterEvent(QEvent* event)

#### Method exec( --> QAction)
	calls Qt method QAction * exec()

#### Method font( --> QFont)
	inherited from QWidget
	calls Qt method QFont & font()

#### Method height( --> Int)
	inherited from QWidget
	calls Qt method int height()

#### Method isActiveWindow( --> Bool)
	inherited from QWidget
	calls Qt method bool isActiveWindow()

#### Method leaveEvent(QEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void leaveEvent(QEvent* event)

#### Method mouseMoveEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mouseMoveEvent(QMouseEvent* event)

#### Method mousePressEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mousePressEvent(QMouseEvent* event)

#### Method mouseReleaseEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mouseReleaseEvent(QMouseEvent* event)

#### Method paintEvent(QPaintEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void paintEvent(QPaintEvent* event)

#### Method render(QPaintDevice $target, QPoint $targetOffset = QPoint.new(), QRegion $sourceRegion = QRegion.new(), Int $renderFlags = RenderFlags(DrawWindowBackground +| DrawChildren))
	inherited from QWidget
	calls Qt method void render(QPaintDevice* target, const QPoint& targetOffset = QPoint(), const QRegion& sourceRegion = QRegion(), RenderFlags renderFlags = RenderFlags(DrawWindowBackground | DrawChildren))

#### Method resizeEvent(QResizeEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void resizeEvent(QResizeEvent* event)

#### Method setDisabled(Bool $arg1)
	[slot] inherited from QWidget
	calls Qt method void setDisabled(bool arg1)

#### Method setFixedHeight(Int $h)
	inherited from QWidget
	calls Qt method void setFixedHeight(int h)

#### Method setFixedSize(Int $w, Int $h)
	inherited from QWidget
	calls Qt method void setFixedSize(int w, int h)

#### Method setFixedWidth(Int $w)
	inherited from QWidget
	calls Qt method void setFixedWidth(int w)

#### Method setFocus()
	[slot] inherited from QWidget
	calls Qt method void setFocus()

#### Method setFocus(Qt::FocusReason $reason)
	inherited from QWidget
	calls Qt method void setFocus(Qt::FocusReason reason)

#### Method setFocusPolicy(Qt::FocusPolicy $policy)
	inherited from QWidget
	calls Qt method void setFocusPolicy(Qt::FocusPolicy policy)

#### Method setFont(QFont $arg1)
	inherited from QWidget
	calls Qt method void setFont(const QFont& arg1)

#### Method setLayout(QLayout $arg1)
	inherited from QWidget
	calls Qt method void setLayout(QLayout* arg1)

#### Method setMinimumSize(Int $minw, Int $minh)
	inherited from QWidget
	calls Qt method void setMinimumSize(int minw, int minh)

#### Method setToolTip(Str $arg1)
	inherited from QWidget
	calls Qt method void setToolTip(const QString& arg1)

#### Method setWindowTitle(Str $arg1)
	[slot] inherited from QWidget
	calls Qt method void setWindowTitle(const QString& arg1)

#### Method show()
	[slot] inherited from QWidget
	calls Qt method void show()

#### Method update()
	[slot] inherited from QWidget
	calls Qt method void update()

#### Method update(Int $x, Int $y, Int $w, Int $h)
	inherited from QWidget
	calls Qt method void update(int x, int y, int w, int h)

#### Method width( --> Int)
	inherited from QWidget
	calls Qt method int width()


Class QMouseEvent
-----------------
	imported by
		use Qt::QtWidgets::QMouseEvent;

	inherits QInputEvent




#### Method accept()
	inherited from QEvent
	calls Qt method void accept()

#### Method button( --> Qt::MouseButton)
	calls Qt method Qt::MouseButton button()

#### Method QMouseEvent.new(QEvent::Type $type, QPointF $localPos, Qt::MouseButton $button, Int $buttons, Int $modifiers --> QMouseEvent))
	calls Qt method  QMouseEvent(Type type, const QPointF& localPos, Qt::MouseButton button, Qt::MouseButtons buttons, Qt::KeyboardModifiers modifiers)

#### Method QMouseEvent.new(QEvent::Type $type, QPointF $localPos, QPointF $screenPos, Qt::MouseButton $button, Int $buttons, Int $modifiers --> QMouseEvent))
	calls Qt method  QMouseEvent(Type type, const QPointF& localPos, const QPointF& screenPos, Qt::MouseButton button, Qt::MouseButtons buttons, Qt::KeyboardModifiers modifiers)

#### Method QMouseEvent.new(QEvent::Type $type, QPointF $localPos, QPointF $windowPos, QPointF $screenPos, Qt::MouseButton $button, Int $buttons, Int $modifiers --> QMouseEvent))
	calls Qt method  QMouseEvent(Type type, const QPointF& localPos, const QPointF& windowPos, const QPointF& screenPos, Qt::MouseButton button, Qt::MouseButtons buttons, Qt::KeyboardModifiers modifiers)

#### Method QMouseEvent.new(QEvent::Type $type, QPointF $localPos, QPointF $windowPos, QPointF $screenPos, Qt::MouseButton $button, Int $buttons, Int $modifiers, Qt::MouseEventSource $source --> QMouseEvent))
	calls Qt method  QMouseEvent(Type type, const QPointF& localPos, const QPointF& windowPos, const QPointF& screenPos, Qt::MouseButton button, Qt::MouseButtons buttons, Qt::KeyboardModifiers modifiers, Qt::MouseEventSource source)

#### Method ignore()
	inherited from QEvent
	calls Qt method void ignore()

#### Method isAccepted( --> Bool)
	inherited from QEvent
	calls Qt method bool isAccepted()

#### Method spontaneous( --> Bool)
	inherited from QEvent
	calls Qt method bool spontaneous()

#### Method type( --> QEvent::Type)
	inherited from QEvent
	calls Qt method Type type()

#### Method x( --> Int)
	calls Qt method int x()

#### Method y( --> Int)
	calls Qt method int y()


Class QPaintDevice
------------------
	imported by
		use Qt::QtWidgets::QPaintDevice;


	inherited by QImage, QWidget



Class QPaintEvent
-----------------
	imported by
		use Qt::QtWidgets::QPaintEvent;

	inherits QEvent




#### Method accept()
	inherited from QEvent
	calls Qt method void accept()

#### Method QPaintEvent.new(QRect $paintRect --> QPaintEvent))
	calls Qt method  QPaintEvent(const QRect& paintRect)

#### Method ignore()
	inherited from QEvent
	calls Qt method void ignore()

#### Method isAccepted( --> Bool)
	inherited from QEvent
	calls Qt method bool isAccepted()

#### Method rect( --> QRect)
	calls Qt method QRect & rect()

#### Method spontaneous( --> Bool)
	inherited from QEvent
	calls Qt method bool spontaneous()

#### Method type( --> QEvent::Type)
	inherited from QEvent
	calls Qt method Type type()


Class QPainter
--------------
	imported by
		use Qt::QtWidgets::QPainter;





#### Method begin(QPaintDevice $arg1 --> Bool)
	calls Qt method bool begin(QPaintDevice* arg1)

#### Method QPainter.new( --> QPainter))
	calls Qt method  QPainter()

#### Method QPainter.new(QPaintDevice $arg1 --> QPainter))
	calls Qt method  QPainter(QPaintDevice* arg1)

#### Method drawEllipse(Int $x, Int $y, Int $w, Int $h)
	calls Qt method void drawEllipse(int x, int y, int w, int h)

#### Method drawLine(Int $x1, Int $y1, Int $x2, Int $y2)
	calls Qt method void drawLine(int x1, int y1, int x2, int y2)

#### Method drawRect(Int $x1, Int $y1, Int $w, Int $h)
	calls Qt method void drawRect(int x1, int y1, int w, int h)

#### Method end( --> Bool)
	calls Qt method bool end()

#### Method restore()
	calls Qt method void restore()

#### Method save()
	calls Qt method void save()

#### Method setBrush(QBrush $brush)
	calls Qt method void setBrush(const QBrush& brush)

#### Method setPen(QColor $color)
	calls Qt method void setPen(const QColor& color)

#### Method setPen(QPen $pen)
	calls Qt method void setPen(const QPen& pen)

#### Method setPen(Qt::PenStyle $style)
	calls Qt method void setPen(Qt::PenStyle style)


Class QPen
----------
	imported by
		use Qt::QtWidgets::QPen;





#### Method QPen.new( --> QPen))
	calls Qt method  QPen()

#### Method QPen.new(Qt::PenStyle $arg1 --> QPen))
	calls Qt method  QPen(Qt::PenStyle arg1)

#### Method QPen.new(QColor $color --> QPen))
	calls Qt method  QPen(const QColor& color)

#### Method setBrush(QBrush $brush)
	calls Qt method void setBrush(const QBrush& brush)

#### Method setColor(QColor $color)
	calls Qt method void setColor(const QColor& color)

#### Method setWidth(Int $width)
	calls Qt method void setWidth(int width)


Class QPoint
------------
	imported by
		use Qt::QtWidgets::QPoint;





#### Method QPoint.new( --> QPoint))
	calls Qt method  QPoint()

#### Method QPoint.new(Int $xpos, Int $ypos --> QPoint))
	calls Qt method  QPoint(int xpos, int ypos)

#### Method isNull( --> Bool)
	calls Qt method bool isNull()

#### Method manhattanLength( --> Int)
	calls Qt method int manhattanLength()

#### Method setX(Int $x)
	calls Qt method void setX(int x)

#### Method setY(Int $y)
	calls Qt method void setY(int y)

#### Method x( --> Int)
	calls Qt method int x()

#### Method y( --> Int)
	calls Qt method int y()


Class QPointF
-------------
	imported by
		use Qt::QtWidgets::QPointF;





#### Method QPointF.new( --> QPointF))
	calls Qt method  QPointF()

#### Method QPointF.new(QPoint $p --> QPointF))
	calls Qt method  QPointF(const QPoint& p)

#### Method QPointF.new(Real $xpos, Real $ypos --> QPointF))
	calls Qt method  QPointF(qreal xpos, qreal ypos)

#### Method isNull( --> Bool)
	calls Qt method bool isNull()

#### Method manhattanLength( --> Real)
	calls Qt method qreal manhattanLength()

#### Method setX(Real $x)
	calls Qt method void setX(qreal x)

#### Method setY(Real $y)
	calls Qt method void setY(qreal y)

#### Method x( --> Real)
	calls Qt method qreal x()

#### Method y( --> Real)
	calls Qt method qreal y()


Class QPushButton
-----------------
	imported by
		use Qt::QtWidgets::QPushButton;

	inherits QAbstractButton




#### Method activateWindow()
	inherited from QWidget
	calls Qt method void activateWindow()

#### Method click()
	[slot] inherited from QAbstractButton
	calls Qt method void click()

#### Method clicked(Bool $checked = False)
	[signal] inherited from QAbstractButton
	calls Qt method void clicked(bool checked = false)

#### Method QPushButton.new(Str $text, QWidget $parent = (QWidget) --> QPushButton))
	calls Qt method  QPushButton(const QString& text, QWidget* parent = nullptr)

#### Method enterEvent(QEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void enterEvent(QEvent* event)

#### Method font( --> QFont)
	inherited from QWidget
	calls Qt method QFont & font()

#### Method height( --> Int)
	inherited from QWidget
	calls Qt method int height()

#### Method isActiveWindow( --> Bool)
	inherited from QWidget
	calls Qt method bool isActiveWindow()

#### Method leaveEvent(QEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void leaveEvent(QEvent* event)

#### Method mouseMoveEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mouseMoveEvent(QMouseEvent* event)

#### Method mousePressEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mousePressEvent(QMouseEvent* event)

#### Method mouseReleaseEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mouseReleaseEvent(QMouseEvent* event)

#### Method paintEvent(QPaintEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void paintEvent(QPaintEvent* event)

#### Method pressed()
	[signal] inherited from QAbstractButton
	calls Qt method void pressed()

#### Method render(QPaintDevice $target, QPoint $targetOffset = QPoint.new(), QRegion $sourceRegion = QRegion.new(), Int $renderFlags = RenderFlags(DrawWindowBackground +| DrawChildren))
	inherited from QWidget
	calls Qt method void render(QPaintDevice* target, const QPoint& targetOffset = QPoint(), const QRegion& sourceRegion = QRegion(), RenderFlags renderFlags = RenderFlags(DrawWindowBackground | DrawChildren))

#### Method resizeEvent(QResizeEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void resizeEvent(QResizeEvent* event)

#### Method setDisabled(Bool $arg1)
	[slot] inherited from QWidget
	calls Qt method void setDisabled(bool arg1)

#### Method setFixedHeight(Int $h)
	inherited from QWidget
	calls Qt method void setFixedHeight(int h)

#### Method setFixedSize(Int $w, Int $h)
	inherited from QWidget
	calls Qt method void setFixedSize(int w, int h)

#### Method setFixedWidth(Int $w)
	inherited from QWidget
	calls Qt method void setFixedWidth(int w)

#### Method setFocus()
	[slot] inherited from QWidget
	calls Qt method void setFocus()

#### Method setFocus(Qt::FocusReason $reason)
	inherited from QWidget
	calls Qt method void setFocus(Qt::FocusReason reason)

#### Method setFocusPolicy(Qt::FocusPolicy $policy)
	inherited from QWidget
	calls Qt method void setFocusPolicy(Qt::FocusPolicy policy)

#### Method setFont(QFont $arg1)
	inherited from QWidget
	calls Qt method void setFont(const QFont& arg1)

#### Method setLayout(QLayout $arg1)
	inherited from QWidget
	calls Qt method void setLayout(QLayout* arg1)

#### Method setMenu(QMenu $menu)
	calls Qt method void setMenu(QMenu* menu)

#### Method setMinimumSize(Int $minw, Int $minh)
	inherited from QWidget
	calls Qt method void setMinimumSize(int minw, int minh)

#### Method setText(Str $text)
	inherited from QAbstractButton
	calls Qt method void setText(const QString& text)

#### Method setToolTip(Str $arg1)
	inherited from QWidget
	calls Qt method void setToolTip(const QString& arg1)

#### Method setWindowTitle(Str $arg1)
	[slot] inherited from QWidget
	calls Qt method void setWindowTitle(const QString& arg1)

#### Method show()
	[slot] inherited from QWidget
	calls Qt method void show()

#### Method text( --> Str)
	inherited from QAbstractButton
	calls Qt method QString text()

#### Method update()
	[slot] inherited from QWidget
	calls Qt method void update()

#### Method update(Int $x, Int $y, Int $w, Int $h)
	inherited from QWidget
	calls Qt method void update(int x, int y, int w, int h)

#### Method width( --> Int)
	inherited from QWidget
	calls Qt method int width()


Class QRect
-----------
	imported by
		use Qt::QtWidgets::QRect;





#### Method QRect.new( --> QRect))
	calls Qt method  QRect()

#### Method QRect.new(QPoint $topleft, QPoint $bottomright --> QRect))
	calls Qt method  QRect(const QPoint& topleft, const QPoint& bottomright)

#### Method QRect.new(Int $left, Int $top, Int $width, Int $height --> QRect))
	calls Qt method  QRect(int left, int top, int width, int height)

#### Method height( --> Int)
	calls Qt method int height()

#### Method width( --> Int)
	calls Qt method int width()

#### Method x( --> Int)
	calls Qt method int x()

#### Method y( --> Int)
	calls Qt method int y()


Class QRegion
-------------
	imported by
		use Qt::QtWidgets::QRegion;





#### Method QRegion.new( --> QRegion))
	calls Qt method  QRegion()


Class QResizeEvent
------------------
	imported by
		use Qt::QtWidgets::QResizeEvent;

	inherits QEvent




#### Method accept()
	inherited from QEvent
	calls Qt method void accept()

#### Method QResizeEvent.new(QSize $size, QSize $oldSize --> QResizeEvent))
	calls Qt method  QResizeEvent(const QSize& size, const QSize& oldSize)

#### Method ignore()
	inherited from QEvent
	calls Qt method void ignore()

#### Method isAccepted( --> Bool)
	inherited from QEvent
	calls Qt method bool isAccepted()

#### Method oldSize( --> QSize)
	calls Qt method QSize & oldSize()

#### Method size( --> QSize)
	calls Qt method QSize & size()

#### Method spontaneous( --> Bool)
	inherited from QEvent
	calls Qt method bool spontaneous()

#### Method type( --> QEvent::Type)
	inherited from QEvent
	calls Qt method Type type()


Class QSize
-----------
	imported by
		use Qt::QtWidgets::QSize;





#### Method boundedTo(QSize $arg1 --> QSize)
	calls Qt method QSize boundedTo(const QSize& arg1)

#### Method QSize.new( --> QSize))
	calls Qt method  QSize()

#### Method QSize.new(Int $w, Int $h --> QSize))
	calls Qt method  QSize(int w, int h)

#### Method expandedTo(QSize $arg1 --> QSize)
	calls Qt method QSize expandedTo(const QSize& arg1)

#### Method height( --> Int)
	calls Qt method int height()

#### Method isEmpty( --> Bool)
	calls Qt method bool isEmpty()

#### Method isNull( --> Bool)
	calls Qt method bool isNull()

#### Method isValid( --> Bool)
	calls Qt method bool isValid()

#### Method setHeight(Int $h)
	calls Qt method void setHeight(int h)

#### Method setWidth(Int $w)
	calls Qt method void setWidth(int w)

#### Method width( --> Int)
	calls Qt method int width()


Class QTextEdit
---------------
	imported by
		use Qt::QtWidgets::QTextEdit;

	inherits QAbstractScrollArea




#### Method activateWindow()
	inherited from QWidget
	calls Qt method void activateWindow()

#### Method QTextEdit.new(QWidget $parent = (QWidget) --> QTextEdit))
	calls Qt method  QTextEdit(QWidget* parent = nullptr)

#### Method enterEvent(QEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void enterEvent(QEvent* event)

#### Method font( --> QFont)
	inherited from QWidget
	calls Qt method QFont & font()

#### Method height( --> Int)
	inherited from QWidget
	calls Qt method int height()

#### Method isActiveWindow( --> Bool)
	inherited from QWidget
	calls Qt method bool isActiveWindow()

#### Method leaveEvent(QEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void leaveEvent(QEvent* event)

#### Method mouseMoveEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mouseMoveEvent(QMouseEvent* event)

#### Method mousePressEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mousePressEvent(QMouseEvent* event)

#### Method mouseReleaseEvent(QMouseEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void mouseReleaseEvent(QMouseEvent* event)

#### Method paintEvent(QPaintEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void paintEvent(QPaintEvent* event)

#### Method render(QPaintDevice $target, QPoint $targetOffset = QPoint.new(), QRegion $sourceRegion = QRegion.new(), Int $renderFlags = RenderFlags(DrawWindowBackground +| DrawChildren))
	inherited from QWidget
	calls Qt method void render(QPaintDevice* target, const QPoint& targetOffset = QPoint(), const QRegion& sourceRegion = QRegion(), RenderFlags renderFlags = RenderFlags(DrawWindowBackground | DrawChildren))

#### Method resizeEvent(QResizeEvent $event)
	[virtual] [protected] inherited from QWidget
	calls Qt method void resizeEvent(QResizeEvent* event)

#### Method setDisabled(Bool $arg1)
	[slot] inherited from QWidget
	calls Qt method void setDisabled(bool arg1)

#### Method setFixedHeight(Int $h)
	inherited from QWidget
	calls Qt method void setFixedHeight(int h)

#### Method setFixedSize(Int $w, Int $h)
	inherited from QWidget
	calls Qt method void setFixedSize(int w, int h)

#### Method setFixedWidth(Int $w)
	inherited from QWidget
	calls Qt method void setFixedWidth(int w)

#### Method setFocus()
	[slot] inherited from QWidget
	calls Qt method void setFocus()

#### Method setFocus(Qt::FocusReason $reason)
	inherited from QWidget
	calls Qt method void setFocus(Qt::FocusReason reason)

#### Method setFocusPolicy(Qt::FocusPolicy $policy)
	inherited from QWidget
	calls Qt method void setFocusPolicy(Qt::FocusPolicy policy)

#### Method setFont(QFont $arg1)
	inherited from QWidget
	calls Qt method void setFont(const QFont& arg1)

#### Method setLayout(QLayout $arg1)
	inherited from QWidget
	calls Qt method void setLayout(QLayout* arg1)

#### Method setMinimumSize(Int $minw, Int $minh)
	inherited from QWidget
	calls Qt method void setMinimumSize(int minw, int minh)

#### Method setPlainText(Str $text)
	[slot] 
	calls Qt method void setPlainText(const QString& text)

#### Method setReadOnly(Bool $ro)
	calls Qt method void setReadOnly(bool ro)

#### Method setToolTip(Str $arg1)
	inherited from QWidget
	calls Qt method void setToolTip(const QString& arg1)

#### Method setWindowTitle(Str $arg1)
	[slot] inherited from QWidget
	calls Qt method void setWindowTitle(const QString& arg1)

#### Method show()
	[slot] inherited from QWidget
	calls Qt method void show()

#### Method textChanged()
	[signal] 
	calls Qt method void textChanged()

#### Method toPlainText( --> Str)
	calls Qt method QString toPlainText()

#### Method update()
	[slot] inherited from QWidget
	calls Qt method void update()

#### Method update(Int $x, Int $y, Int $w, Int $h)
	inherited from QWidget
	calls Qt method void update(int x, int y, int w, int h)

#### Method width( --> Int)
	inherited from QWidget
	calls Qt method int width()


Class QTimer
------------
	imported by
		use Qt::QtWidgets::QTimer;

	inherits QObject




#### Method QTimer.new(QObject $parent = (QObject) --> QTimer))
	calls Qt method  QTimer(QObject* parent = nullptr)

#### Method setInterval(Int $msec)
	calls Qt method void setInterval(int msec)

#### Method start()
	[slot] 
	calls Qt method void start()

#### Method stop()
	[slot] 
	calls Qt method void stop()

#### Method timeout()
	[private signal] 
	calls Qt method void timeout()


Class QVBoxLayout
-----------------
	imported by
		use Qt::QtWidgets::QVBoxLayout;

	inherits QBoxLayout




#### Method addLayout(QLayout $layout, Int $stretch = 0)
	inherited from QBoxLayout
	calls Qt method void addLayout(QLayout* layout, int stretch = 0)

#### Method addWidget(QWidget $w)
	inherited from QLayout
	calls Qt method void addWidget(QWidget* w)

#### Method QVBoxLayout.new( --> QVBoxLayout))
	calls Qt method  QVBoxLayout()

#### Method setAlignment(QWidget $w, Int $alignment --> Bool)
	inherited from QLayout
	calls Qt method bool setAlignment(QWidget* w, Qt::Alignment alignment)

#### Method setAlignment(QLayout $l, Int $alignment --> Bool)
	inherited from QLayout
	calls Qt method bool setAlignment(QLayout* l, Qt::Alignment alignment)


Class QWidget
-------------
	imported by
		use Qt::QtWidgets::QWidget;

	inherits QObject
	inherits QPaintDevice

	inherited by QAbstractButton, QDialog, QFrame, QLineEdit, QMenu

    enum RenderFlag 

#### Method activateWindow()
	calls Qt method void activateWindow()

#### Method QWidget.new(QWidget $parent = (QWidget), Int $f = Qt::WindowFlags() --> QWidget))
	calls Qt method  QWidget(QWidget* parent = nullptr, Qt::WindowFlags f = Qt::WindowFlags())

#### Method enterEvent(QEvent $event)
	[virtual] [protected] 
	calls Qt method void enterEvent(QEvent* event)

#### Method font( --> QFont)
	calls Qt method QFont & font()

#### Method height( --> Int)
	calls Qt method int height()

#### Method isActiveWindow( --> Bool)
	calls Qt method bool isActiveWindow()

#### Method leaveEvent(QEvent $event)
	[virtual] [protected] 
	calls Qt method void leaveEvent(QEvent* event)

#### Method mouseMoveEvent(QMouseEvent $event)
	[virtual] [protected] 
	calls Qt method void mouseMoveEvent(QMouseEvent* event)

#### Method mousePressEvent(QMouseEvent $event)
	[virtual] [protected] 
	calls Qt method void mousePressEvent(QMouseEvent* event)

#### Method mouseReleaseEvent(QMouseEvent $event)
	[virtual] [protected] 
	calls Qt method void mouseReleaseEvent(QMouseEvent* event)

#### Method paintEvent(QPaintEvent $event)
	[virtual] [protected] 
	calls Qt method void paintEvent(QPaintEvent* event)

#### Method render(QPaintDevice $target, QPoint $targetOffset = QPoint.new(), QRegion $sourceRegion = QRegion.new(), Int $renderFlags = RenderFlags(DrawWindowBackground +| DrawChildren))
	calls Qt method void render(QPaintDevice* target, const QPoint& targetOffset = QPoint(), const QRegion& sourceRegion = QRegion(), RenderFlags renderFlags = RenderFlags(DrawWindowBackground | DrawChildren))

#### Method resizeEvent(QResizeEvent $event)
	[virtual] [protected] 
	calls Qt method void resizeEvent(QResizeEvent* event)

#### Method setDisabled(Bool $arg1)
	[slot] 
	calls Qt method void setDisabled(bool arg1)

#### Method setFixedHeight(Int $h)
	calls Qt method void setFixedHeight(int h)

#### Method setFixedSize(Int $w, Int $h)
	calls Qt method void setFixedSize(int w, int h)

#### Method setFixedWidth(Int $w)
	calls Qt method void setFixedWidth(int w)

#### Method setFocus()
	[slot] 
	calls Qt method void setFocus()

#### Method setFocus(Qt::FocusReason $reason)
	calls Qt method void setFocus(Qt::FocusReason reason)

#### Method setFocusPolicy(Qt::FocusPolicy $policy)
	calls Qt method void setFocusPolicy(Qt::FocusPolicy policy)

#### Method setFont(QFont $arg1)
	calls Qt method void setFont(const QFont& arg1)

#### Method setLayout(QLayout $arg1)
	calls Qt method void setLayout(QLayout* arg1)

#### Method setMinimumSize(Int $minw, Int $minh)
	calls Qt method void setMinimumSize(int minw, int minh)

#### Method setToolTip(Str $arg1)
	calls Qt method void setToolTip(const QString& arg1)

#### Method setWindowTitle(Str $arg1)
	[slot] 
	calls Qt method void setWindowTitle(const QString& arg1)

#### Method show()
	[slot] 
	calls Qt method void show()

#### Method update()
	[slot] 
	calls Qt method void update()

#### Method update(Int $x, Int $y, Int $w, Int $h)
	calls Qt method void update(int x, int y, int w, int h)

#### Method width( --> Int)
	calls Qt method int width()


Class Qt
--------
	imported by
		use Qt::QtWidgets::Qt;




    enum AlignmentFlag 
    enum BrushStyle 
    enum FocusPolicy 
    enum FocusReason 
    enum GlobalColor 
    enum KeyboardModifier 
    enum MouseButton 
    enum MouseEventSource 
    enum PenStyle 
    enum TextFormat 
    enum WindowType 

