=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut

package AsposeSlidesCloud::Object::ColorScheme;

require 5.6.0;
use strict;
use warnings;
use utf8;
use JSON qw(decode_json);
use Data::Dumper;
use Module::Runtime qw(use_module);
use Log::Any qw($log);
use Date::Parse;
use DateTime;

use AsposeSlidesCloud::Object::ResourceBase;
use AsposeSlidesCloud::Object::ResourceUri;

use base ("Class::Accessor", "Class::Data::Inheritable");


#
#Slide&#39;s color scheme DTO
#
# NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
# REF: https://github.com/swagger-api/swagger-codegen
#

=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut
#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
__PACKAGE__->mk_classdata('attribute_map' => {});
__PACKAGE__->mk_classdata('swagger_types' => {});
__PACKAGE__->mk_classdata('method_documentation' => {}); 
__PACKAGE__->mk_classdata('class_documentation' => {});

# new object
sub new { 
    my ($class, %args) = @_; 

	my $self = bless {}, $class;
	
	foreach my $attribute (keys %{$class->attribute_map}) {
		my $args_key = $class->attribute_map->{$attribute};
		$self->$attribute( $args{ $args_key } );
	}
	
	return $self;
}  

# return perl hash
sub to_hash {
    return decode_json(JSON->new->convert_blessed->encode( shift ));
}

# used by JSON for serialization
sub TO_JSON { 
    my $self = shift;
    my $_data = {};
    foreach my $_key (keys %{$self->attribute_map}) {
        if (defined $self->{$_key}) {
            $_data->{$self->attribute_map->{$_key}} = $self->{$_key};
        }
    }
    return $_data;
}

# from Perl hashref
sub from_hash {
    my ($self, $hash) = @_;

    # loop through attributes and use swagger_types to deserialize the data
    while ( my ($_key, $_type) = each %{$self->swagger_types} ) {
    	my $_json_attribute = $self->attribute_map->{$_key}; 
        if ($_type =~ /^array\[/i) { # array
            my $_subclass = substr($_type, 6, -1);
            my @_array = ();
            foreach my $_element (@{$hash->{$_json_attribute}}) {
                push @_array, $self->_deserialize($_subclass, $_element);
            }
            foreach my $_element (@{$hash->{$_json_attribute}}) {
                push @_array, $self->_deserialize(lcfirst($_subclass), $_element);
            }
            $self->{$_key} = \@_array;
        } elsif (exists $hash->{$_json_attribute}) { #hash(model), primitive, datetime
            $self->{$_key} = $self->_deserialize($_type, $hash->{$_json_attribute});
        } elsif (exists $hash->{lcfirst($_json_attribute)}) { #hash(model), primitive, datetime
            $self->{$_key} = $self->_deserialize($_type, $hash->{lcfirst($_json_attribute)});
        }
    }
  
    return $self;
}

# deserialize non-array data
sub _deserialize {
    my ($self, $type, $data) = @_;
        
    if ($type eq 'DateTime') {
        return DateTime->from_epoch(epoch => str2time($data));
    } elsif ( grep( /^$type$/, ('int', 'double', 'string', 'boolean'))) {
        return $data;
    } else { # hash(model)
        my $_instance = eval "AsposeSlidesCloud::Object::$type->new()";
        return $_instance->from_hash($data);
    }
}



__PACKAGE__->class_documentation({description => 'Slide&#39;s color scheme DTO',
                                  class => 'ColorScheme',
                                  required => [], # TODO
}                                 );

__PACKAGE__->method_documentation({
    'self_uri' => {
    	datatype => 'ResourceUri',
    	base_name => 'SelfUri',
    	description => 'Gets or sets the link to this resource.',
    	format => '',
    	read_only => '',
    		},
    'alternate_links' => {
    	datatype => 'ARRAY[ResourceUri]',
    	base_name => 'AlternateLinks',
    	description => 'List of alternate links.',
    	format => '',
    	read_only => '',
    		},
    'accent1' => {
    	datatype => 'string',
    	base_name => 'Accent1',
    	description => 'First accent color.',
    	format => '',
    	read_only => '',
    		},
    'accent2' => {
    	datatype => 'string',
    	base_name => 'Accent2',
    	description => 'Second accent color.',
    	format => '',
    	read_only => '',
    		},
    'accent3' => {
    	datatype => 'string',
    	base_name => 'Accent3',
    	description => 'Third accent color.',
    	format => '',
    	read_only => '',
    		},
    'accent4' => {
    	datatype => 'string',
    	base_name => 'Accent4',
    	description => 'Fourth accent color.',
    	format => '',
    	read_only => '',
    		},
    'accent5' => {
    	datatype => 'string',
    	base_name => 'Accent5',
    	description => 'Fifth accent color.',
    	format => '',
    	read_only => '',
    		},
    'accent6' => {
    	datatype => 'string',
    	base_name => 'Accent6',
    	description => 'Sixth accent color.',
    	format => '',
    	read_only => '',
    		},
    'dark1' => {
    	datatype => 'string',
    	base_name => 'Dark1',
    	description => 'First dark color.',
    	format => '',
    	read_only => '',
    		},
    'dark2' => {
    	datatype => 'string',
    	base_name => 'Dark2',
    	description => 'Second dark color.',
    	format => '',
    	read_only => '',
    		},
    'followed_hyperlink' => {
    	datatype => 'string',
    	base_name => 'FollowedHyperlink',
    	description => 'Visited hyperlink color.',
    	format => '',
    	read_only => '',
    		},
    'hyperlink' => {
    	datatype => 'string',
    	base_name => 'Hyperlink',
    	description => 'Hyperlink color/',
    	format => '',
    	read_only => '',
    		},
    'light1' => {
    	datatype => 'string',
    	base_name => 'Light1',
    	description => 'First light color.',
    	format => '',
    	read_only => '',
    		},
    'light2' => {
    	datatype => 'string',
    	base_name => 'Light2',
    	description => 'Second light color.',
    	format => '',
    	read_only => '',
    		},
});

__PACKAGE__->swagger_types( {
    'self_uri' => 'ResourceUri',
    'alternate_links' => 'ARRAY[ResourceUri]',
    'accent1' => 'string',
    'accent2' => 'string',
    'accent3' => 'string',
    'accent4' => 'string',
    'accent5' => 'string',
    'accent6' => 'string',
    'dark1' => 'string',
    'dark2' => 'string',
    'followed_hyperlink' => 'string',
    'hyperlink' => 'string',
    'light1' => 'string',
    'light2' => 'string'
} );

__PACKAGE__->attribute_map( {
    'self_uri' => 'SelfUri',
    'alternate_links' => 'AlternateLinks',
    'accent1' => 'Accent1',
    'accent2' => 'Accent2',
    'accent3' => 'Accent3',
    'accent4' => 'Accent4',
    'accent5' => 'Accent5',
    'accent6' => 'Accent6',
    'dark1' => 'Dark1',
    'dark2' => 'Dark2',
    'followed_hyperlink' => 'FollowedHyperlink',
    'hyperlink' => 'Hyperlink',
    'light1' => 'Light1',
    'light2' => 'Light2'
} );

__PACKAGE__->mk_accessors(keys %{__PACKAGE__->attribute_map});


1;
