=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut

package AsposeSlidesCloud::Object::TableCell;

require 5.6.0;
use strict;
use warnings;
use utf8;
use JSON qw(decode_json);
use Data::Dumper;
use Module::Runtime qw(use_module);
use Log::Any qw($log);
use Date::Parse;
use DateTime;

use AsposeSlidesCloud::Object::FillFormat;
use AsposeSlidesCloud::Object::LineFormat;

use base ("Class::Accessor", "Class::Data::Inheritable");


#
#Represents one cell of table.
#
# NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
# REF: https://github.com/swagger-api/swagger-codegen
#

=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut
#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
__PACKAGE__->mk_classdata('attribute_map' => {});
__PACKAGE__->mk_classdata('swagger_types' => {});
__PACKAGE__->mk_classdata('method_documentation' => {}); 
__PACKAGE__->mk_classdata('class_documentation' => {});

# new object
sub new { 
    my ($class, %args) = @_; 

	my $self = bless {}, $class;
	
	foreach my $attribute (keys %{$class->attribute_map}) {
		my $args_key = $class->attribute_map->{$attribute};
		$self->$attribute( $args{ $args_key } );
	}
	return $self;
}  

# return perl hash
sub to_hash {
    return decode_json(JSON->new->convert_blessed->encode( shift ));
}

# used by JSON for serialization
sub TO_JSON { 
    my $self = shift;
    my $_data = {};
    foreach my $_key (keys %{$self->attribute_map}) {
        if (defined $self->{$_key}) {
            $_data->{$self->attribute_map->{$_key}} = $self->{$_key};
        }
    }
    return $_data;
}

# from Perl hashref
sub from_hash {
    my ($self, $hash) = @_;

    # loop through attributes and use swagger_types to deserialize the data
    my $current_types = {};
    while ( my ($_key, $_type) = each %{$self->swagger_types} ) {
        $current_types->{$_key} = $_type;
    }
    while ( my ($_key, $_type) = each %{$current_types} ) {
    	my $_json_attribute = $self->attribute_map->{$_key}; 
        if ($_type =~ /^array\[/i) { # array
            my $_subclass = substr($_type, 6, -1);
            my @_array = ();
            foreach my $_element (@{$hash->{$_json_attribute}}) {
                if (defined $_element) {
                    push @_array, $self->_deserialize($_subclass, $_element);
                } else {
                    push @_array, undef;
                }
            }
            foreach my $_element (@{$hash->{lcfirst($_json_attribute)}}) {
                if (defined $_element) {
                    push @_array, $self->_deserialize(lcfirst($_subclass), $_element);
                } else {
                    push @_array, undef;
                }
            }
            $self->{$_key} = \@_array;
        } elsif (exists $hash->{$_json_attribute}) { #hash(model), primitive, datetime
            $self->{$_key} = $self->_deserialize($_type, $hash->{$_json_attribute});
        } elsif (exists $hash->{lcfirst($_json_attribute)}) { #hash(model), primitive, datetime
            $self->{$_key} = $self->_deserialize($_type, $hash->{lcfirst($_json_attribute)});
        }
    }
  
    return $self;
}

# deserialize non-array data
sub _deserialize {
    my ($self, $type, $data) = @_;
        
    if ($type eq 'DateTime') {
        return DateTime->from_epoch(epoch => str2time($data));
    } elsif ( grep( /^$type$/, ('int', 'double', 'string', 'boolean'))) {
        return $data;
    } else { # hash(model)
        my $class = AsposeSlidesCloud::ClassRegistry->get_class_name(ucfirst($type), $data);
        my $_instance = use_module("AsposeSlidesCloud::Object::$class")->new();
        return $_instance->from_hash($data);
    }
}



__PACKAGE__->class_documentation({description => 'Represents one cell of table.',
                                  class => 'TableCell',
                                  required => [], # TODO
}                                 );

__PACKAGE__->method_documentation({
    'text' => {
    	datatype => 'string',
    	base_name => 'Text',
    	description => 'Cell text.',
    	format => '',
    	read_only => '',
    		},
    'row_span' => {
    	datatype => 'int',
    	base_name => 'RowSpan',
    	description => 'The number of rows spanned by a merged cell.',
    	format => '',
    	read_only => '',
    		},
    'col_span' => {
    	datatype => 'int',
    	base_name => 'ColSpan',
    	description => 'The number of columns spanned by a merged cell.',
    	format => '',
    	read_only => '',
    		},
    'margin_top' => {
    	datatype => 'double',
    	base_name => 'MarginTop',
    	description => 'The top margin of the cell.',
    	format => '',
    	read_only => '',
    		},
    'margin_right' => {
    	datatype => 'double',
    	base_name => 'MarginRight',
    	description => 'The right margin of the cell.',
    	format => '',
    	read_only => '',
    		},
    'margin_left' => {
    	datatype => 'double',
    	base_name => 'MarginLeft',
    	description => 'The left margin of the cell.',
    	format => '',
    	read_only => '',
    		},
    'margin_bottom' => {
    	datatype => 'double',
    	base_name => 'MarginBottom',
    	description => 'The bottom margin of the cell.',
    	format => '',
    	read_only => '',
    		},
    'text_anchor_type' => {
    	datatype => 'string',
    	base_name => 'TextAnchorType',
    	description => 'Text anchor type.',
    	format => '',
    	read_only => '',
    		},
    'text_vertical_type' => {
    	datatype => 'string',
    	base_name => 'TextVerticalType',
    	description => 'The type of vertical text.',
    	format => '',
    	read_only => '',
    		},
    'fill_format' => {
    	datatype => 'FillFormat',
    	base_name => 'FillFormat',
    	description => 'Fill properties set of the cell.',
    	format => '',
    	read_only => '',
    		},
    'border_top' => {
    	datatype => 'LineFormat',
    	base_name => 'BorderTop',
    	description => 'Line properties set for the top border of the cell.',
    	format => '',
    	read_only => '',
    		},
    'border_right' => {
    	datatype => 'LineFormat',
    	base_name => 'BorderRight',
    	description => 'Line properties set for the right border of the cell.',
    	format => '',
    	read_only => '',
    		},
    'border_left' => {
    	datatype => 'LineFormat',
    	base_name => 'BorderLeft',
    	description => 'Line properties set for the left border of the cell.',
    	format => '',
    	read_only => '',
    		},
    'border_bottom' => {
    	datatype => 'LineFormat',
    	base_name => 'BorderBottom',
    	description => 'Line properties set for the bottom border of the cell.',
    	format => '',
    	read_only => '',
    		},
    'border_diagonal_up' => {
    	datatype => 'LineFormat',
    	base_name => 'BorderDiagonalUp',
    	description => 'Line properties set for the diagonal up border of the cell.',
    	format => '',
    	read_only => '',
    		},
    'border_diagonal_down' => {
    	datatype => 'LineFormat',
    	base_name => 'BorderDiagonalDown',
    	description => 'Line properties set for the diagonal down border of the cell.',
    	format => '',
    	read_only => '',
    		},
    'column_index' => {
    	datatype => 'int',
    	base_name => 'ColumnIndex',
    	description => 'Cell column index',
    	format => '',
    	read_only => '',
    		},
    'row_index' => {
    	datatype => 'int',
    	base_name => 'RowIndex',
    	description => 'Cell row index',
    	format => '',
    	read_only => '',
    		},
});

__PACKAGE__->swagger_types( {
    'text' => 'string',
    'row_span' => 'int',
    'col_span' => 'int',
    'margin_top' => 'double',
    'margin_right' => 'double',
    'margin_left' => 'double',
    'margin_bottom' => 'double',
    'text_anchor_type' => 'string',
    'text_vertical_type' => 'string',
    'fill_format' => 'FillFormat',
    'border_top' => 'LineFormat',
    'border_right' => 'LineFormat',
    'border_left' => 'LineFormat',
    'border_bottom' => 'LineFormat',
    'border_diagonal_up' => 'LineFormat',
    'border_diagonal_down' => 'LineFormat',
    'column_index' => 'int',
    'row_index' => 'int'
} );

__PACKAGE__->attribute_map( {
    'text' => 'Text',
    'row_span' => 'RowSpan',
    'col_span' => 'ColSpan',
    'margin_top' => 'MarginTop',
    'margin_right' => 'MarginRight',
    'margin_left' => 'MarginLeft',
    'margin_bottom' => 'MarginBottom',
    'text_anchor_type' => 'TextAnchorType',
    'text_vertical_type' => 'TextVerticalType',
    'fill_format' => 'FillFormat',
    'border_top' => 'BorderTop',
    'border_right' => 'BorderRight',
    'border_left' => 'BorderLeft',
    'border_bottom' => 'BorderBottom',
    'border_diagonal_up' => 'BorderDiagonalUp',
    'border_diagonal_down' => 'BorderDiagonalDown',
    'column_index' => 'ColumnIndex',
    'row_index' => 'RowIndex'
} );

__PACKAGE__->mk_accessors(keys %{__PACKAGE__->attribute_map});


1;
