package Crypt::HSXKPasswd::Dictionary::IT;

use parent Crypt::HSXKPasswd::Dictionary;

# NOTE:
# -----
# This module was Auto-generated at 2015-06-07T19:39:49Z by
# Crypt::HSXKPasswd::Util->dictionary_from_text_file()

# import required modules
use strict;
use warnings;
use English qw( -no_match_vars ); # for more readable code
use Fatal qw( :void open close binmode ); # make builtins throw exceptions on failure
use Readonly; # for truly constant constants

# HSXKPasswd stuff
use Crypt::HSXKPasswd::Helper;

# set things up for using UTF-8
use 5.016; # min Perl for good UTF-8 support, implies feature 'unicode_strings'
use Encode qw(encode decode);
use utf8;
binmode STDOUT, ':encoding(UTF-8)';

#
# === Constants ===============================================================#
#

# version info
use version; our $VERSION = qv('3.002_001');

# utility constants
Readonly my $_CLASS => 'Crypt::HSXKPasswd::Dictionary::IT';

# the word list
my @_WORDS = ( ## no critic (ProhibitQuotedWordLists)
    'abaca',
    'abache',
    'abachi',
    'abachista',
    'abachiste',
    'abachisti',
    'abacista',
    'abaciste',
    'abacisti',
    'abaco',
    'abadessa',
    'abadia',
    'abaliena',
    'abalienando',
    'abalienano',
    'abalienare',
    'abalienarono',
    'abalienato',
    'abalienava',
    'abalienavano',
    'abalieno',
    'abalieta',
    'abano',
    'abarica',
    'abariche',
    'abarici',
    'abarico',
    'abasia',
    'abasie',
    'abassiale',
    'abassiali',
    'abat',
    'abate',
    'abati',
    'abatini',
    'abatino',
    'abaton',
    'abatone',
    'abatoni',
    'abatonzoli',
    'abatonzolo',
    'abatterica',
    'abatterici',
    'abatterico',
    'abatucoli',
    'abatucolo',
    'abavi',
    'abavo',
    'abazia',
    'abaziale',
    'abbaca',
    'abbacai',
    'abbacammo',
    'abbacando',
    'abbacano',
    'abbacante',
    'abbacanti',
    'abbacare',
    'abbacarono',
    'abbacasse',
    'abbacassero',
    'abbacassi',
    'abbacassimo',
    'abbacaste',
    'abbacasti',
    'abbacata',
    'abbacate',
    'abbacati',
    'abbacato',
    'abbacava',
    'abbacavamo',
    'abbacavano',
    'abbacavate',
    'abbacavi',
    'abbacavo',
    'abbacchi',
    'abbacchia',
    'abbacchiai',
    'abbacchiammo',
    'abbacchiamo',
    'abbacchiando',
    'abbacchiano',
    'abbacchiante',
    'abbacchianti',
    'abbacchiarci',
    'abbacchiare',
    'abbacchiarmi',
    'abbacchiarsi',
    'abbacchiarti',
    'abbacchiarvi',
    'abbacchiasse',
    'abbacchiassi',
    'abbacchiaste',
    'abbacchiasti',
    'abbacchiata',
    'abbacchiate',
    'abbacchiati',
    'abbacchiato',
    'abbacchiava',
    'abbacchiavi',
    'abbacchiavo',
    'abbacchiera',
    'abbacchierai',
    'abbacchierei',
    'abbacchiero',
    'abbacchino',
    'abbacchio',
    'abbachera',
    'abbacherai',
    'abbacheranno',
    'abbacherebbe',
    'abbacherei',
    'abbacheremmo',
    'abbacheremo',
    'abbachereste',
    'abbacheresti',
    'abbacherete',
    'abbachero',
    'abbachi',
    'abbachiamo',
    'abbachiate',
    'abbachino',
    'abbachista',
    'abbacina',
    'abbacinai',
    'abbacinammo',
    'abbacinando',
    'abbacinano',
    'abbacinante',
    'abbacinanti',
    'abbacinare',
    'abbacinarono',
    'abbacinasse',
    'abbacinassi',
    'abbacinaste',
    'abbacinasti',
    'abbacinata',
    'abbacinate',
    'abbacinati',
    'abbacinato',
    'abbacinava',
    'abbacinavamo',
    'abbacinavano',
    'abbacinavate',
    'abbacinavi',
    'abbacinavo',
    'abbacinera',
    'abbacinerai',
    'abbacinerei',
    'abbacineremo',
    'abbacinerete',
    'abbacinero',
    'abbacini',
    'abbaciniamo',
    'abbaciniate',
    'abbacinino',
    'abbacino',
    'abbaco',
    'abbacona',
    'abbacone',
    'abbaconi',
    'abbada',
    'abbadai',
    'abbadammo',
    'abbadando',
    'abbadano',
    'abbadante',
    'abbadanti',
    'abbadare',
    'abbadarono',
    'abbadasse',
    'abbadassero',
    'abbadassi',
    'abbadassimo',
    'abbadaste',
    'abbadasti',
    'abbadata',
    'abbadate',
    'abbadati',
    'abbadato',
    'abbadatore',
    'abbadatori',
    'abbadava',
    'abbadavamo',
    'abbadavano',
    'abbadavate',
    'abbadavi',
    'abbadavo',
    'abbadenga',
    'abbadenghe',
    'abbadenghi',
    'abbadengo',
    'abbadera',
    'abbaderai',
    'abbaderanno',
    'abbaderebbe',
    'abbaderei',
    'abbaderemmo',
    'abbaderemo',
    'abbadereste',
    'abbaderesti',
    'abbaderete',
    'abbadero',
    'abbadessa',
    'abbadi',
    'abbadia',
    'abbadiamo',
    'abbadiate',
    'abbadie',
    'abbadino',
    'abbado',
    'abbagli',
    'abbaglia',
    'abbagliai',
    'abbagliammo',
    'abbagliamo',
    'abbagliamoci',
    'abbagliando',
    'abbagliano',
    'abbagliante',
    'abbaglianti',
    'abbagliarci',
    'abbagliare',
    'abbagliarmi',
    'abbagliarono',
    'abbagliarsi',
    'abbagliarti',
    'abbagliarvi',
    'abbagliasse',
    'abbagliassi',
    'abbagliaste',
    'abbagliasti',
    'abbagliata',
    'abbagliate',
    'abbagliatevi',
    'abbagliati',
    'abbagliato',
    'abbagliatomi',
    'abbagliatoti',
    'abbagliava',
    'abbagliavamo',
    'abbagliavano',
    'abbagliavate',
    'abbagliavi',
    'abbagliavo',
    'abbagliera',
    'abbaglierai',
    'abbaglierei',
    'abbaglieremo',
    'abbaglierete',
    'abbagliero',
    'abbaglii',
    'abbaglino',
    'abbaglio',
    'abbai',
    'abbaia',
    'abbaiai',
    'abbaiamenti',
    'abbaiamento',
    'abbaiammo',
    'abbaiamo',
    'abbaiando',
    'abbaiano',
    'abbaiante',
    'abbaianti',
    'abbaiare',
    'abbaiarono',
    'abbaiasse',
    'abbaiassero',
    'abbaiassi',
    'abbaiassimo',
    'abbaiaste',
    'abbaiasti',
    'abbaiata',
    'abbaiate',
    'abbaiati',
    'abbaiato',
    'abbaiatore',
    'abbaiatori',
    'abbaiatrice',
    'abbaiatrici',
    'abbaiava',
    'abbaiavamo',
    'abbaiavano',
    'abbaiavate',
    'abbaiavi',
    'abbaiavo',
    'abbaiera',
    'abbaierai',
    'abbaieranno',
    'abbaierebbe',
    'abbaierei',
    'abbaieremmo',
    'abbaieremo',
    'abbaiereste',
    'abbaieresti',
    'abbaierete',
    'abbaiero',
    'abbaii',
    'abbaini',
    'abbaino',
    'abbaio',
    'abbaiona',
    'abbaione',
    'abbaioni',
    'abballa',
    'abballai',
    'abballammo',
    'abballando',
    'abballano',
    'abballante',
    'abballanti',
    'abballare',
    'abballarono',
    'abballasse',
    'abballassero',
    'abballassi',
    'abballassimo',
    'abballaste',
    'abballasti',
    'abballata',
    'abballate',
    'abballati',
    'abballato',
    'abballava',
    'abballavamo',
    'abballavano',
    'abballavate',
    'abballavi',
    'abballavo',
    'abballera',
    'abballerai',
    'abballeranno',
    'abballerebbe',
    'abballerei',
    'abballeremmo',
    'abballeremo',
    'abballereste',
    'abballeresti',
    'abballerete',
    'abballero',
    'abballi',
    'abballiamo',
    'abballiate',
    'abballina',
    'abballinai',
    'abballinammo',
    'abballinando',
    'abballinano',
    'abballinante',
    'abballinanti',
    'abballinare',
    'abballinasse',
    'abballinassi',
    'abballinaste',
    'abballinasti',
    'abballinata',
    'abballinate',
    'abballinati',
    'abballinato',
    'abballinava',
    'abballinavi',
    'abballinavo',
    'abballinera',
    'abballinerai',
    'abballinerei',
    'abballinero',
    'abballini',
    'abballiniamo',
    'abballiniate',
    'abballinino',
    'abballino',
    'abballo',
    'abbambina',
    'abbambinai',
    'abbambinammo',
    'abbambinando',
    'abbambinano',
    'abbambinante',
    'abbambinanti',
    'abbambinare',
    'abbambinasse',
    'abbambinassi',
    'abbambinaste',
    'abbambinasti',
    'abbambinata',
    'abbambinate',
    'abbambinati',
    'abbambinato',
    'abbambinava',
    'abbambinavi',
    'abbambinavo',
    'abbambinera',
    'abbambinerai',
    'abbambinerei',
    'abbambinero',
    'abbambini',
    'abbambiniamo',
    'abbambiniate',
    'abbambinino',
    'abbambino',
    'abbambolata',
    'abbambolate',
    'abbambolati',
    'abbambolato',
    'abbanca',
    'abbancai',
    'abbancammo',
    'abbancando',
    'abbancano',
    'abbancante',
    'abbancanti',
    'abbancare',
    'abbancarono',
    'abbancasse',
    'abbancassero',
    'abbancassi',
    'abbancassimo',
    'abbancaste',
    'abbancasti',
    'abbancata',
    'abbancate',
    'abbancati',
    'abbancato',
    'abbancava',
    'abbancavamo',
    'abbancavano',
    'abbancavate',
    'abbancavi',
    'abbancavo',
    'abbanchera',
    'abbancherai',
    'abbancherei',
    'abbancheremo',
    'abbancherete',
    'abbanchero',
    'abbanchi',
    'abbanchiamo',
    'abbanchiate',
    'abbanchino',
    'abbanco',
    'abbandona',
    'abbandonai',
    'abbandonami',
    'abbandonammo',
    'abbandonando',
    'abbandonano',
    'abbandonante',
    'abbandonanti',
    'abbandonarci',
    'abbandonare',
    'abbandonarla',
    'abbandonarle',
    'abbandonarli',
    'abbandonarlo',
    'abbandonarmi',
    'abbandonarsi',
    'abbandonarti',
    'abbandonarvi',
    'abbandonasse',
    'abbandonassi',
    'abbandonaste',
    'abbandonasti',
    'abbandonata',
    'abbandonate',
    'abbandonati',
    'abbandonato',
    'abbandonava',
    'abbandonavi',
    'abbandonavo',
    'abbandonera',
    'abbandonerai',
    'abbandonerei',
    'abbandonero',
    'abbandonerà',
    'abbandoni',
    'abbandoniamo',
    'abbandoniate',
    'abbandonica',
    'abbandoniche',
    'abbandonici',
    'abbandonico',
    'abbandonino',
    'abbandonismi',
    'abbandonismo',
    'abbandono',
    'abbandonò',
    'abbarba',
    'abbarbagli',
    'abbarbaglia',
    'abbarbagliai',
    'abbarbaglii',
    'abbarbaglino',
    'abbarbaglio',
    'abbarbai',
    'abbarbammo',
    'abbarbando',
    'abbarbandoci',
    'abbarbandomi',
    'abbarbandosi',
    'abbarbandoti',
    'abbarbandovi',
    'abbarbano',
    'abbarbante',
    'abbarbanti',
    'abbarbantisi',
    'abbarbarci',
    'abbarbare',
    'abbarbarmi',
    'abbarbarono',
    'abbarbarsi',
    'abbarbarti',
    'abbarbarvi',
    'abbarbasse',
    'abbarbassero',
    'abbarbassi',
    'abbarbassimo',
    'abbarbaste',
    'abbarbasti',
    'abbarbata',
    'abbarbate',
    'abbarbatevi',
    'abbarbati',
    'abbarbato',
    'abbarbatomi',
    'abbarbatoti',
    'abbarbava',
    'abbarbavamo',
    'abbarbavano',
    'abbarbavate',
    'abbarbavi',
    'abbarbavo',
    'abbarbera',
    'abbarberai',
    'abbarberanno',
    'abbarberebbe',
    'abbarberei',
    'abbarberemmo',
    'abbarberemo',
    'abbarbereste',
    'abbarberesti',
    'abbarberete',
    'abbarbero',
    'abbarbi',
    'abbarbiamo',
    'abbarbiamoci',
    'abbarbiate',
    'abbarbica',
    'abbarbicai',
    'abbarbicammo',
    'abbarbicando',
    'abbarbicano',
    'abbarbicante',
    'abbarbicanti',
    'abbarbicarci',
    'abbarbicare',
    'abbarbicarmi',
    'abbarbicarsi',
    'abbarbicarti',
    'abbarbicarvi',
    'abbarbicasse',
    'abbarbicassi',
    'abbarbicaste',
    'abbarbicasti',
    'abbarbicata',
    'abbarbicate',
    'abbarbicati',
    'abbarbicato',
    'abbarbicava',
    'abbarbicavi',
    'abbarbicavo',
    'abbarbichera',
    'abbarbichero',
    'abbarbichi',
    'abbarbichino',
    'abbarbico',
    'abbarbino',
    'abbarbo',
    'abbarca',
    'abbarcai',
    'abbarcammo',
    'abbarcando',
    'abbarcano',
    'abbarcante',
    'abbarcanti',
    'abbarcare',
    'abbarcarono',
    'abbarcasse',
    'abbarcassero',
    'abbarcassi',
    'abbarcassimo',
    'abbarcaste',
    'abbarcasti',
    'abbarcata',
    'abbarcate',
    'abbarcati',
    'abbarcato',
    'abbarcatura',
    'abbarcava',
    'abbarcavamo',
    'abbarcavano',
    'abbarcavate',
    'abbarcavi',
    'abbarcavo',
    'abbarchera',
    'abbarcherai',
    'abbarcherei',
    'abbarcheremo',
    'abbarcherete',
    'abbarchero',
    'abbarchi',
    'abbarchiamo',
    'abbarchiate',
    'abbarchino',
    'abbarco',
    'abbarra',
    'abbarrai',
    'abbarrammo',
    'abbarrando',
    'abbarrano',
    'abbarrante',
    'abbarranti',
    'abbarrare',
    'abbarrarono',
    'abbarrasse',
    'abbarrassero',
    'abbarrassi',
    'abbarrassimo',
    'abbarraste',
    'abbarrasti',
    'abbarrata',
    'abbarrate',
    'abbarrati',
    'abbarrato',
    'abbarrava',
    'abbarravamo',
    'abbarravano',
    'abbarravate',
    'abbarravi',
    'abbarravo',
    'abbarrera',
    'abbarrerai',
    'abbarreranno',
    'abbarrerebbe',
    'abbarrerei',
    'abbarreremmo',
    'abbarreremo',
    'abbarrereste',
    'abbarreresti',
    'abbarrerete',
    'abbarrero',
    'abbarri',
    'abbarriamo',
    'abbarriate',
    'abbarrino',
    'abbarro',
    'abbarruffii',
    'abbarruffio',
    'abbaruffa',
    'abbaruffai',
    'abbaruffammo',
    'abbaruffando',
    'abbaruffano',
    'abbaruffante',
    'abbaruffanti',
    'abbaruffarci',
    'abbaruffare',
    'abbaruffarmi',
    'abbaruffarsi',
    'abbaruffarti',
    'abbaruffarvi',
    'abbaruffasse',
    'abbaruffassi',
    'abbaruffaste',
    'abbaruffasti',
    'abbaruffata',
    'abbaruffate',
    'abbaruffati',
    'abbaruffato',
    'abbaruffava',
    'abbaruffavi',
    'abbaruffavo',
    'abbaruffera',
    'abbarufferai',
    'abbarufferei',
    'abbaruffero',
    'abbaruffi',
    'abbaruffiamo',
    'abbaruffiate',
    'abbaruffii',
    'abbaruffino',
    'abbaruffio',
    'abbaruffo',
    'abbas',
    'abbassa',
    'abbassabile',
    'abbassabili',
    'abbassai',
    'abbassamenti',
    'abbassamento',
    'abbassammo',
    'abbassando',
    'abbassandoci',
    'abbassandomi',
    'abbassandosi',
    'abbassandoti',
    'abbassandovi',
    'abbassano',
    'abbassante',
    'abbassanti',
    'abbassantisi',
    'abbassarci',
    'abbassare',
    'abbassarmi',
    'abbassarono',
    'abbassarsi',
    'abbassarti',
    'abbassarvi',
    'abbassasse',
    'abbassassero',
    'abbassassi',
    'abbassassimo',
    'abbassaste',
    'abbassasti',
    'abbassata',
    'abbassate',
    'abbassatevi',
    'abbassati',
    'abbassatina',
    'abbassatine',
    'abbassato',
    'abbassatomi',
    'abbassatoti',
    'abbassava',
    'abbassavamo',
    'abbassavano',
    'abbassavate',
    'abbassavi',
    'abbassavo',
    'abbassera',
    'abbasserai',
    'abbasseranno',
    'abbasserebbe',
    'abbasserei',
    'abbasseremmo',
    'abbasseremo',
    'abbassereste',
    'abbasseresti',
    'abbasserete',
    'abbassero',
    'abbassi',
    'abbassiamo',
    'abbassiamoci',
    'abbassiate',
    'abbassino',
    'abbasso',
    'abbasta',
    'abbastai',
    'abbastammo',
    'abbastando',
    'abbastano',
    'abbastante',
    'abbastanti',
    'abbastanza',
    'abbastare',
    'abbastarono',
    'abbastasse',
    'abbastassero',
    'abbastassi',
    'abbastassimo',
    'abbastaste',
    'abbastasti',
    'abbastata',
    'abbastate',
    'abbastati',
    'abbastato',
    'abbastava',
    'abbastavamo',
    'abbastavano',
    'abbastavate',
    'abbastavi',
    'abbastavo',
    'abbastera',
    'abbasterai',
    'abbasteranno',
    'abbasterebbe',
    'abbasterei',
    'abbasteremmo',
    'abbasteremo',
    'abbastereste',
    'abbasteresti',
    'abbasterete',
    'abbastero',
    'abbasti',
    'abbastiamo',
    'abbastiate',
    'abbastino',
    'abbasto',
    'abbate',
    'abbati',
    'abbatta',
    'abbattano',
    'abbatte',
    'abbattei',
    'abbattemmo',
    'abbattendo',
    'abbattendoci',
    'abbattendomi',
    'abbattendosi',
    'abbattendoti',
    'abbattendovi',
    'abbattente',
    'abbattenti',
    'abbattentisi',
    'abbattera',
    'abbatterai',
    'abbatteranno',
    'abbatterci',
    'abbattere',
    'abbatterebbe',
    'abbatterei',
    'abbatteremmo',
    'abbatteremo',
    'abbattereste',
    'abbatteresti',
    'abbatterete',
    'abbattermi',
    'abbattero',
    'abbatterono',
    'abbattersi',
    'abbatterti',
    'abbattervi',
    'abbattesse',
    'abbattessero',
    'abbattessi',
    'abbattessimo',
    'abbatteste',
    'abbattesti',
    'abbattete',
    'abbattetevi',
    'abbattette',
    'abbattetti',
    'abbatteva',
    'abbattevamo',
    'abbattevano',
    'abbattevate',
    'abbattevi',
    'abbattevo',
    'abbatti',
    'abbattiamo',
    'abbattiamoci',
    'abbattiate',
    'abbattibile',
    'abbattibili',
    'abbattifieno',
    'abbattimenti',
    'abbattimento',
    'abbattiti',
    'abbattitore',
    'abbattitori',
    'abbattitrice',
    'abbattitrici',
    'abbatto',
    'abbattono',
    'abbattuta',
    'abbattute',
    'abbattuti',
    'abbattuto',
    'abbattutomi',
    'abbattutoti',
    'abbatuffola',
    'abbatuffolai',
    'abbatuffoli',
    'abbatuffolo',
    'abbazia',
    'abbaziale',
    'abbaziali',
    'abbazie',
    'abbecedari',
    'abbecedario',
    'abbella',
    'abbellai',
    'abbellammo',
    'abbellando',
    'abbellano',
    'abbellante',
    'abbellanti',
    'abbellare',
    'abbellarono',
    'abbellasse',
    'abbellassero',
    'abbellassi',
    'abbellassimo',
    'abbellaste',
    'abbellasti',
    'abbellata',
    'abbellate',
    'abbellati',
    'abbellato',
    'abbellava',
    'abbellavamo',
    'abbellavano',
    'abbellavate',
    'abbellavi',
    'abbellavo',
    'abbellendo',
    'abbellendoci',
    'abbellendomi',
    'abbellendosi',
    'abbellendoti',
    'abbellendovi',
    'abbellente',
    'abbellenti',
    'abbellentisi',
    'abbellera',
    'abbellerai',
    'abbelleranno',
    'abbellerebbe',
    'abbellerei',
    'abbelleremmo',
    'abbelleremo',
    'abbellereste',
    'abbelleresti',
    'abbellerete',
    'abbellero',
    'abbelli',
    'abbelliamo',
    'abbelliamoci',
    'abbelliate',
    'abbellii',
    'abbellimenti',
    'abbellimento',
    'abbellimmo',
    'abbellino',
    'abbellira',
    'abbellirai',
    'abbelliranno',
    'abbellirci',
    'abbellire',
    'abbellirebbe',
    'abbellirei',
    'abbelliremmo',
    'abbelliremo',
    'abbellireste',
    'abbelliresti',
    'abbellirete',
    'abbellirla',
    'abbellirmi',
    'abbelliro',
    'abbellirono',
    'abbellirsi',
    'abbellirti',
    'abbellirvi',
    'abbellisca',
    'abbelliscano',
    'abbellisce',
    'abbellisci',
    'abbellisciti',
    'abbellisco',
    'abbelliscono',
    'abbellisse',
    'abbellissero',
    'abbellissi',
    'abbellissimo',
    'abbelliste',
    'abbellisti',
    'abbellita',
    'abbellite',
    'abbellitevi',
    'abbelliti',
    'abbellito',
    'abbellitomi',
    'abbellitoti',
    'abbellitura',
    'abbelliture',
    'abbelliva',
    'abbellivamo',
    'abbellivano',
    'abbellivate',
    'abbellivi',
    'abbellivo',
    'abbello',
    'abbenche',
    'abbevera',
    'abbeveraggi',
    'abbeveraggio',
    'abbeverai',
    'abbeverammo',
    'abbeverando',
    'abbeverano',
    'abbeverante',
    'abbeveranti',
    'abbeverarci',
    'abbeverare',
    'abbeverarmi',
    'abbeverarono',
    'abbeverarsi',
    'abbeverarti',
    'abbeverarvi',
    'abbeverasse',
    'abbeverassi',
    'abbeveraste',
    'abbeverasti',
    'abbeverata',
    'abbeverate',
    'abbeveratevi',
    'abbeverati',
    'abbeverato',
    'abbeveratoi',
    'abbeveratoio',
    'abbeveratomi',
    'abbeveratoti',
    'abbeverava',
    'abbeveravamo',
    'abbeveravano',
    'abbeveravate',
    'abbeveravi',
    'abbeveravo',
    'abbeverera',
    'abbevererai',
    'abbevererei',
    'abbevereremo',
    'abbevererete',
    'abbeverero',
    'abbeveri',
    'abbeveriamo',
    'abbeveriate',
    'abbeverino',
    'abbevero',
    'abbeviliana',
    'abbeviliane',
    'abbeviliani',
    'abbeviliano',
    'abbevilliana',
    'abbevilliane',
    'abbevilliani',
    'abbevilliano',
    'abbi',
    'abbia',
    'abbiada',
    'abbiadai',
    'abbiadammo',
    'abbiadando',
    'abbiadano',
    'abbiadante',
    'abbiadanti',
    'abbiadare',
    'abbiadarono',
    'abbiadasse',
    'abbiadassero',
    'abbiadassi',
    'abbiadassimo',
    'abbiadaste',
    'abbiadasti',
    'abbiadata',
    'abbiadate',
    'abbiadati',
    'abbiadato',
    'abbiadava',
    'abbiadavamo',
    'abbiadavano',
    'abbiadavate',
    'abbiadavi',
    'abbiadavo',
    'abbiadera',
    'abbiaderai',
    'abbiaderanno',
    'abbiaderebbe',
    'abbiaderei',
    'abbiaderemmo',
    'abbiaderemo',
    'abbiadereste',
    'abbiaderesti',
    'abbiaderete',
    'abbiadero',
    'abbiadi',
    'abbiadiamo',
    'abbiadiate',
    'abbiadino',
    'abbiado',
    'abbiam',
    'abbiamo',
    'abbiano',
    'abbiasi',
    'abbiate',
    'abbiatela',
    'abbiatelo',
    'abbiatene',
    'abbiatevi',
    'abbiatico',
    'abbica',
    'abbicai',
    'abbicammo',
    'abbicando',
    'abbicandoci',
    'abbicandomi',
    'abbicandosi',
    'abbicandoti',
    'abbicandovi',
    'abbicano',
    'abbicante',
    'abbicanti',
    'abbicantisi',
    'abbicarci',
    'abbicare',
    'abbicarmi',
    'abbicarono',
    'abbicarsi',
    'abbicarti',
    'abbicarvi',
    'abbicasse',
    'abbicassero',
    'abbicassi',
    'abbicassimo',
    'abbicaste',
    'abbicasti',
    'abbicata',
    'abbicate',
    'abbicatevi',
    'abbicati',
    'abbicato',
    'abbicatomi',
    'abbicatoti',
    'abbicatura',
    'abbicature',
    'abbicava',
    'abbicavamo',
    'abbicavano',
    'abbicavate',
    'abbicavi',
    'abbicavo',
    'abbicci',
    'abbiccì',
    'abbichera',
    'abbicherai',
    'abbicheranno',
    'abbicherebbe',
    'abbicherei',
    'abbicheremmo',
    'abbicheremo',
    'abbichereste',
    'abbicheresti',
    'abbicherete',
    'abbichero',
    'abbichi',
    'abbichiamo',
    'abbichiamoci',
    'abbichiate',
    'abbichino',
    'abbico',
    'abbiente',
    'abbienti',
    'abbietta',
    'abbiette',
    'abbiettezza',
    'abbietti',
    'abbietto',
    'abbiezione',
    'abbigli',
    'abbiglia',
    'abbigliai',
    'abbigliammo',
    'abbigliamo',
    'abbigliamoci',
    'abbigliando',
    'abbigliano',
    'abbigliante',
    'abbiglianti',
    'abbigliarci',
    'abbigliare',
    'abbigliarmi',
    'abbigliarono',
    'abbigliarsi',
    'abbigliarti',
    'abbigliarvi',
    'abbigliasse',
    'abbigliassi',
    'abbigliaste',
    'abbigliasti',
    'abbigliata',
    'abbigliate',
    'abbigliatevi',
    'abbigliati',
    'abbigliato',
    'abbigliatoi',
    'abbigliatoio',
    'abbigliatomi',
    'abbigliatoti',
    'abbigliatura',
    'abbigliature',
    'abbigliava',
    'abbigliavamo',
    'abbigliavano',
    'abbigliavate',
    'abbigliavi',
    'abbigliavo',
    'abbigliera',
    'abbiglierai',
    'abbiglierei',
    'abbiglieremo',
    'abbiglierete',
    'abbigliero',
    'abbiglino',
    'abbiglio',
    'abbiglitura',
    'abbigliture',
    'abbina',
    'abbinabile',
    'abbinabili',
    'abbinai',
    'abbinamenti',
    'abbinamento',
    'abbinammo',
    'abbinando',
    'abbinandola',
    'abbinandolo',
    'abbinano',
    'abbinante',
    'abbinanti',
    'abbinare',
    'abbinarono',
    'abbinasse',
    'abbinassero',
    'abbinassi',
    'abbinassimo',
    'abbinaste',
    'abbinasti',
    'abbinata',
    'abbinate',
    'abbinati',
    'abbinato',
    'abbinatrice',
    'abbinatrici',
    'abbinatura',
    'abbinature',
    'abbinava',
    'abbinavamo',
    'abbinavano',
    'abbinavate',
    'abbinavi',
    'abbinavo',
    'abbindola',
    'abbindolai',
    'abbindolammo',
    'abbindolando',
    'abbindolano',
    'abbindolante',
    'abbindolanti',
    'abbindolarci',
    'abbindolare',
    'abbindolarmi',
    'abbindolarsi',
    'abbindolarti',
    'abbindolarvi',
    'abbindolasse',
    'abbindolassi',
    'abbindolaste',
    'abbindolasti',
    'abbindolata',
    'abbindolate',
    'abbindolati',
    'abbindolato',
    'abbindolava',
    'abbindolavi',
    'abbindolavo',
    'abbindolera',
    'abbindolerai',
    'abbindolerei',
    'abbindolero',
    'abbindoli',
    'abbindoliamo',
    'abbindoliate',
    'abbindolino',
    'abbindolo',
    'abbinera',
    'abbinerai',
    'abbineranno',
    'abbinerebbe',
    'abbinerei',
    'abbineremmo',
    'abbineremo',
    'abbinereste',
    'abbineresti',
    'abbinerete',
    'abbinero',
    'abbini',
    'abbiniamo',
    'abbiniate',
    'abbinino',
    'abbino',
    'abbiocca',
    'abbioccai',
    'abbioccammo',
    'abbioccando',
    'abbioccano',
    'abbioccante',
    'abbioccanti',
    'abbioccarci',
    'abbioccare',
    'abbioccarmi',
    'abbioccarono',
    'abbioccarsi',
    'abbioccarti',
    'abbioccarvi',
    'abbioccasse',
    'abbioccassi',
    'abbioccaste',
    'abbioccasti',
    'abbioccata',
    'abbioccate',
    'abbioccatevi',
    'abbioccati',
    'abbioccato',
    'abbioccatomi',
    'abbioccatoti',
    'abbioccava',
    'abbioccavamo',
    'abbioccavano',
    'abbioccavate',
    'abbioccavi',
    'abbioccavo',
    'abbiocchera',
    'abbioccherai',
    'abbioccherei',
    'abbiocchero',
    'abbiocchi',
    'abbiocchiamo',
    'abbiocchiate',
    'abbiocchino',
    'abbiocco',
    'abbioscera',
    'abbioscerai',
    'abbioscerei',
    'abbiosceremo',
    'abbioscerete',
    'abbioscero',
    'abbiosci',
    'abbioscia',
    'abbiosciai',
    'abbiosciammo',
    'abbiosciamo',
    'abbiosciando',
    'abbiosciano',
    'abbiosciarci',
    'abbiosciare',
    'abbiosciarmi',
    'abbiosciarsi',
    'abbiosciarti',
    'abbiosciarvi',
    'abbiosciasse',
    'abbiosciassi',
    'abbiosciaste',
    'abbiosciasti',
    'abbiosciata',
    'abbiosciate',
    'abbiosciati',
    'abbiosciato',
    'abbiosciava',
    'abbiosciavi',
    'abbiosciavo',
    'abbioscino',
    'abbioscio',
    'abbiscera',
    'abbiscerai',
    'abbisceranno',
    'abbiscerebbe',
    'abbiscerei',
    'abbisceremmo',
    'abbisceremo',
    'abbiscereste',
    'abbisceresti',
    'abbiscerete',
    'abbiscero',
    'abbisci',
    'abbiscia',
    'abbisciai',
    'abbisciammo',
    'abbisciamo',
    'abbisciamoci',
    'abbisciando',
    'abbisciano',
    'abbisciante',
    'abbiscianti',
    'abbisciarci',
    'abbisciare',
    'abbisciarmi',
    'abbisciarono',
    'abbisciarsi',
    'abbisciarti',
    'abbisciarvi',
    'abbisciasse',
    'abbisciassi',
    'abbisciaste',
    'abbisciasti',
    'abbisciata',
    'abbisciate',
    'abbisciatevi',
    'abbisciati',
    'abbisciato',
    'abbisciatomi',
    'abbisciatoti',
    'abbisciava',
    'abbisciavamo',
    'abbisciavano',
    'abbisciavate',
    'abbisciavi',
    'abbisciavo',
    'abbiscino',
    'abbiscio',
    'abbisogna',
    'abbisognai',
    'abbisognammo',
    'abbisognando',
    'abbisognano',
    'abbisognante',
    'abbisognanti',
    'abbisognare',
    'abbisognasse',
    'abbisognassi',
    'abbisognaste',
    'abbisognasti',
    'abbisognata',
    'abbisognate',
    'abbisognati',
    'abbisognato',
    'abbisognava',
    'abbisognavi',
    'abbisognavo',
    'abbisognera',
    'abbisognerai',
    'abbisognerei',
    'abbisognero',
    'abbisogni',
    'abbisogniamo',
    'abbisogniate',
    'abbisognino',
    'abbisogno',
    'abbiti',
    'abbitta',
    'abbittai',
    'abbittammo',
    'abbittando',
    'abbittano',
    'abbittante',
    'abbittanti',
    'abbittare',
    'abbittarono',
    'abbittasse',
    'abbittassero',
    'abbittassi',
    'abbittassimo',
    'abbittaste',
    'abbittasti',
    'abbittata',
    'abbittate',
    'abbittati',
    'abbittato',
    'abbittatura',
    'abbittature',
    'abbittava',
    'abbittavamo',
    'abbittavano',
    'abbittavate',
    'abbittavi',
    'abbittavo',
    'abbittera',
    'abbitterai',
    'abbitteranno',
    'abbitterebbe',
    'abbitterei',
    'abbitteremmo',
    'abbitteremo',
    'abbittereste',
    'abbitteresti',
    'abbitterete',
    'abbittero',
    'abbitti',
    'abbittiamo',
    'abbittiate',
    'abbittino',
    'abbitto',
    'abbocca',
    'abboccai',
    'abboccamenti',
    'abboccamento',
    'abboccammo',
    'abboccando',
    'abboccandoci',
    'abboccandomi',
    'abboccandosi',
    'abboccandoti',
    'abboccandovi',
    'abboccano',
    'abboccante',
    'abboccanti',
    'abboccantisi',
    'abboccarci',
    'abboccare',
    'abboccarmi',
    'abboccarono',
    'abboccarsi',
    'abboccarti',
    'abboccarvi',
    'abboccasse',
    'abboccassero',
    'abboccassi',
    'abboccassimo',
    'abboccaste',
    'abboccasti',
    'abboccata',
    'abboccate',
    'abboccatevi',
    'abboccati',
    'abboccato',
    'abboccatoi',
    'abboccatoio',
    'abboccatomi',
    'abboccatoti',
    'abboccatura',
    'abboccature',
    'abboccava',
    'abboccavamo',
    'abboccavano',
    'abboccavate',
    'abboccavi',
    'abboccavo',
    'abbocchera',
    'abboccherai',
    'abboccherei',
    'abboccheremo',
    'abboccherete',
    'abbocchero',
    'abbocchevole',
    'abbocchevoli',
    'abbocchi',
    'abbocchiamo',
    'abbocchiate',
    'abbocchino',
    'abbocco',
    'abboffa',
    'abboffandosi',
    'abboffano',
    'abboffarsi',
    'abboffata',
    'abboffate',
    'abboffati',
    'abboffato',
    'abboffavamo',
    'abbomina',
    'abbominabile',
    'abbominai',
    'abbominammo',
    'abbominando',
    'abbominano',
    'abbominante',
    'abbominanti',
    'abbominare',
    'abbominarono',
    'abbominasse',
    'abbominassi',
    'abbominaste',
    'abbominasti',
    'abbominata',
    'abbominate',
    'abbominati',
    'abbominato',
    'abbominava',
    'abbominavamo',
    'abbominavano',
    'abbominavate',
    'abbominavi',
    'abbominavo',
    'abbominera',
    'abbominerai',
    'abbominerei',
    'abbomineremo',
    'abbominerete',
    'abbominero',
    'abbominevole',
    'abbominevoli',
    'abbomini',
    'abbominiamo',
    'abbominiate',
    'abbominino',
    'abbominio',
    'abbomino',
    'abbona',
    'abbonaccera',
    'abbonaccerai',
    'abbonaccerei',
    'abbonaccero',
    'abbonacci',
    'abbonaccia',
    'abbonacciai',
    'abbonacciamo',
    'abbonacciano',
    'abbonacciare',
    'abbonacciata',
    'abbonacciate',
    'abbonacciati',
    'abbonacciato',
    'abbonacciava',
    'abbonacciavi',
    'abbonacciavo',
    'abbonaccino',
    'abbonaccio',
    'abbonai',
    'abbonamenti',
    'abbonamento',
    'abbonami',
    'abbonammo',
    'abbonando',
    'abbonandoci',
    'abbonandomi',
    'abbonandosi',
    'abbonandoti',
    'abbonandovi',
    'abbonano',
    'abbonante',
    'abbonanti',
    'abbonantisi',
    'abbonarci',
    'abbonare',
    'abbonarmi',
    'abbonarono',
    'abbonarsi',
    'abbonarti',
    'abbonarvi',
    'abbonasse',
    'abbonassero',
    'abbonassi',
    'abbonassimo',
    'abbonaste',
    'abbonasti',
    'abbonata',
    'abbonate',
    'abbonatevi',
    'abbonati',
    'abbonato',
    'abbonatomi',
    'abbonatoti',
    'abbonava',
    'abbonavamo',
    'abbonavano',
    'abbonavate',
    'abbonavi',
    'abbonavo',
    'abbonda',
    'abbondai',
    'abbondammo',
    'abbondando',
    'abbondano',
    'abbondante',
    'abbondanti',
    'abbondanza',
    'abbondanze',
    'abbondanzia',
    'abbondanzio',
    'abbondare',
    'abbondarono',
    'abbondasse',
    'abbondassero',
    'abbondassi',
    'abbondassimo',
    'abbondaste',
    'abbondasti',
    'abbondata',
    'abbondate',
    'abbondati',
    'abbondato',
    'abbondava',
    'abbondavamo',
    'abbondavano',
    'abbondavate',
    'abbondavi',
    'abbondavo',
    'abbondazio',
    'abbondera',
    'abbonderai',
    'abbonderanno',
    'abbonderebbe',
    'abbonderei',
    'abbonderemmo',
    'abbonderemo',
    'abbondereste',
    'abbonderesti',
    'abbonderete',
    'abbondero',
    'abbondevole',
    'abbondevoli',
    'abbondi',
    'abbondia',
    'abbondiamo',
    'abbondiate',
    'abbondina',
    'abbondino',
    'abbondio',
    'abbondo',
    'abbonendo',
    'abbonendoci',
    'abbonendomi',
    'abbonendosi',
    'abbonendoti',
    'abbonendovi',
    'abbonente',
    'abbonenti',
    'abbonentisi',
    'abbonera',
    'abbonerai',
    'abboneranno',
    'abbonerebbe',
    'abbonerei',
    'abboneremmo',
    'abboneremo',
    'abbonereste',
    'abboneresti',
    'abbonerete',
    'abbonero',
    'abboni',
    'abboniamo',
    'abboniamoci',
    'abboniate',
    'abbonii',
    'abbonimenti',
    'abbonimento',
    'abbonimmo',
    'abbonino',
    'abbonira',
    'abbonirai',
    'abboniranno',
    'abbonirci',
    'abbonire',
    'abbonirebbe',
    'abbonirei',
    'abboniremmo',
    'abboniremo',
    'abbonireste',
    'abboniresti',
    'abbonirete',
    'abbonirmi',
    'abboniro',
    'abbonirono',
    'abbonirsi',
    'abbonirti',
    'abbonirvi',
    'abbonisca',
    'abboniscano',
    'abbonisce',
    'abbonisci',
    'abbonisciti',
    'abbonisco',
    'abboniscono',
    'abbonisse',
    'abbonissero',
    'abbonissi',
    'abbonissimo',
    'abboniste',
    'abbonisti',
    'abbonita',
    'abbonite',
    'abbonitevi',
    'abboniti',
    'abbonito',
    'abbonitomi',
    'abbonitoti',
    'abboniva',
    'abbonivamo',
    'abbonivano',
    'abbonivate',
    'abbonivi',
    'abbonivo',
    'abbono',
    'abborda',
    'abbordabile',
    'abbordabili',
    'abbordaggi',
    'abbordaggio',
    'abbordai',
    'abbordammo',
    'abbordando',
    'abbordandola',
    'abbordandole',
    'abbordandoli',
    'abbordandolo',
    'abbordano',
    'abbordante',
    'abbordanti',
    'abbordare',
    'abbordarla',
    'abbordarle',
    'abbordarli',
    'abbordarlo',
    'abbordarmi',
    'abbordarono',
    'abbordarti',
    'abbordasse',
    'abbordassero',
    'abbordassi',
    'abbordassimo',
    'abbordaste',
    'abbordasti',
    'abbordata',
    'abbordate',
    'abbordati',
    'abbordato',
    'abbordatore',
    'abbordatori',
    'abbordatrice',
    'abbordatrici',
    'abbordava',
    'abbordavamo',
    'abbordavano',
    'abbordavate',
    'abbordavi',
    'abbordavo',
    'abbordera',
    'abborderai',
    'abborderanno',
    'abborderebbe',
    'abborderei',
    'abborderemmo',
    'abborderemo',
    'abbordereste',
    'abborderesti',
    'abborderete',
    'abbordero',
    'abbordi',
    'abbordiamo',
    'abbordiate',
    'abbordino',
    'abbordo',
    'abborra',
    'abborraccera',
    'abborraccero',
    'abborracci',
    'abborraccia',
    'abborracciai',
    'abborraccino',
    'abborraccio',
    'abborrano',
    'abborrare',
    'abborre',
    'abborrendo',
    'abborrente',
    'abborrenti',
    'abborri',
    'abborriamo',
    'abborriate',
    'abborrii',
    'abborrimento',
    'abborrimmo',
    'abborrira',
    'abborrirai',
    'abborriranno',
    'abborrire',
    'abborrirebbe',
    'abborrirei',
    'abborriremmo',
    'abborriremo',
    'abborrireste',
    'abborriresti',
    'abborrirete',
    'abborriro',
    'abborrirono',
    'abborrisca',
    'abborriscano',
    'abborrisce',
    'abborrisci',
    'abborrisco',
    'abborriscono',
    'abborrisse',
    'abborrissero',
    'abborrissi',
    'abborrissimo',
    'abborriste',
    'abborristi',
    'abborrita',
    'abborrite',
    'abborriti',
    'abborrito',
    'abborritore',
    'abborriva',
    'abborrivamo',
    'abborrivano',
    'abborrivate',
    'abborrivi',
    'abborrivo',
    'abborro',
    'abborrono',
    'abbotta',
    'abbottai',
    'abbottammo',
    'abbottando',
    'abbottandoci',
    'abbottandomi',
    'abbottandosi',
    'abbottandoti',
    'abbottandovi',
    'abbottano',
    'abbottante',
    'abbottanti',
    'abbottantisi',
    'abbottarci',
    'abbottare',
    'abbottarmi',
    'abbottarono',
    'abbottarsi',
    'abbottarti',
    'abbottarvi',
    'abbottasse',
    'abbottassero',
    'abbottassi',
    'abbottassimo',
    'abbottaste',
    'abbottasti',
    'abbottata',
    'abbottate',
    'abbottatevi',
    'abbottati',
    'abbottato',
    'abbottatomi',
    'abbottatoti',
    'abbottava',
    'abbottavamo',
    'abbottavano',
    'abbottavate',
    'abbottavi',
    'abbottavo',
    'abbottera',
    'abbotterai',
    'abbotteranno',
    'abbotterebbe',
    'abbotterei',
    'abbotteremmo',
    'abbotteremo',
    'abbottereste',
    'abbotteresti',
    'abbotterete',
    'abbottero',
    'abbotti',
    'abbottiamo',
    'abbottiamoci',
    'abbottiate',
    'abbottino',
    'abbotto',
    'abbottona',
    'abbottonai',
    'abbottonammo',
    'abbottonando',
    'abbottonano',
    'abbottonante',
    'abbottonanti',
    'abbottonarci',
    'abbottonare',
    'abbottonarmi',
    'abbottonarsi',
    'abbottonarti',
    'abbottonarvi',
    'abbottonasse',
    'abbottonassi',
    'abbottonaste',
    'abbottonasti',
    'abbottonata',
    'abbottonate',
    'abbottonati',
    'abbottonato',
    'abbottonava',
    'abbottonavi',
    'abbottonavo',
    'abbottonera',
    'abbottonerai',
    'abbottonerei',
    'abbottonero',
    'abbottoni',
    'abbottoniamo',
    'abbottoniate',
    'abbottonino',
    'abbottono',
    'abbozza',
    'abbozzai',
    'abbozzamenti',
    'abbozzamento',
    'abbozzammo',
    'abbozzando',
    'abbozzandola',
    'abbozzandolo',
    'abbozzano',
    'abbozzante',
    'abbozzanti',
    'abbozzare',
    'abbozzarla',
    'abbozzarlo',
    'abbozzarono',
    'abbozzasse',
    'abbozzassero',
    'abbozzassi',
    'abbozzassimo',
    'abbozzaste',
    'abbozzasti',
    'abbozzata',
    'abbozzate',
    'abbozzati',
    'abbozzaticce',
    'abbozzaticci',
    'abbozzato',
    'abbozzatore',
    'abbozzatori',
    'abbozzatrice',
    'abbozzatrici',
    'abbozzatura',
    'abbozzature',
    'abbozzava',
    'abbozzavamo',
    'abbozzavano',
    'abbozzavate',
    'abbozzavi',
    'abbozzavo',
    'abbozzera',
    'abbozzerai',
    'abbozzeranno',
    'abbozzerebbe',
    'abbozzerei',
    'abbozzeremmo',
    'abbozzeremo',
    'abbozzereste',
    'abbozzeresti',
    'abbozzerete',
    'abbozzero',
    'abbozzi',
    'abbozziamo',
    'abbozziate',
    'abbozzino',
    'abbozzo',
    'abbozzola',
    'abbozzolai',
    'abbozzolammo',
    'abbozzolando',
    'abbozzolano',
    'abbozzolarci',
    'abbozzolare',
    'abbozzolarmi',
    'abbozzolarsi',
    'abbozzolarti',
    'abbozzolarvi',
    'abbozzolasse',
    'abbozzolassi',
    'abbozzolaste',
    'abbozzolasti',
    'abbozzolata',
    'abbozzolate',
    'abbozzolati',
    'abbozzolato',
    'abbozzolava',
    'abbozzolavi',
    'abbozzolavo',
    'abbozzolera',
    'abbozzolerai',
    'abbozzolerei',
    'abbozzolero',
    'abbozzoli',
    'abbozzoliamo',
    'abbozzoliate',
    'abbozzolino',
    'abbozzolo',
    'abbraccera',
    'abbraccerai',
    'abbraccerei',
    'abbracceremo',
    'abbraccerete',
    'abbraccero',
    'abbracci',
    'abbraccia',
    'abbracciai',
    'abbracciami',
    'abbracciammo',
    'abbracciamo',
    'abbracciando',
    'abbracciano',
    'abbracciante',
    'abbraccianti',
    'abbracciar',
    'abbracciarci',
    'abbracciare',
    'abbracciarla',
    'abbracciarle',
    'abbracciarli',
    'abbracciarlo',
    'abbracciarmi',
    'abbracciarsi',
    'abbracciarti',
    'abbracciarvi',
    'abbracciasse',
    'abbracciassi',
    'abbracciaste',
    'abbracciasti',
    'abbracciata',
    'abbracciate',
    'abbracciati',
    'abbracciato',
    'abbracciava',
    'abbracciavi',
    'abbracciavo',
    'abbraccino',
    'abbraccio',
    'abbraccione',
    'abbraccioni',
    'abbranca',
    'abbrancai',
    'abbrancammo',
    'abbrancando',
    'abbrancano',
    'abbrancante',
    'abbrancanti',
    'abbrancarci',
    'abbrancare',
    'abbrancarmi',
    'abbrancarono',
    'abbrancarsi',
    'abbrancarti',
    'abbrancarvi',
    'abbrancasse',
    'abbrancassi',
    'abbrancaste',
    'abbrancasti',
    'abbrancata',
    'abbrancate',
    'abbrancatevi',
    'abbrancati',
    'abbrancato',
    'abbrancatomi',
    'abbrancatoti',
    'abbrancava',
    'abbrancavamo',
    'abbrancavano',
    'abbrancavate',
    'abbrancavi',
    'abbrancavo',
    'abbranchera',
    'abbrancherai',
    'abbrancherei',
    'abbranchero',
    'abbranchi',
    'abbranchiamo',
    'abbranchiate',
    'abbranchino',
    'abbranco',
    'abbrevi',
    'abbrevia',
    'abbreviai',
    'abbreviammo',
    'abbreviamo',
    'abbreviando',
    'abbreviano',
    'abbreviante',
    'abbrevianti',
    'abbreviare',
    'abbreviarono',
    'abbreviarsi',
    'abbreviasse',
    'abbreviassi',
    'abbreviaste',
    'abbreviasti',
    'abbreviata',
    'abbreviate',
    'abbreviati',
    'abbreviativa',
    'abbreviative',
    'abbreviativi',
    'abbreviativo',
    'abbreviato',
    'abbreviatore',
    'abbreviatori',
    'abbreviatura',
    'abbreviature',
    'abbreviava',
    'abbreviavamo',
    'abbreviavano',
    'abbreviavate',
    'abbreviavi',
    'abbreviavo',
    'abbreviera',
    'abbrevierai',
    'abbrevierei',
    'abbrevieremo',
    'abbrevierete',
    'abbreviero',
    'abbrevino',
    'abbrevio',
    'abbriccai',
    'abbriccando',
    'abbriccare',
    'abbriccarono',
    'abbriccarsi',
    'abbriccato',
    'abbricco',
    'abbriva',
    'abbrivai',
    'abbrivammo',
    'abbrivando',
    'abbrivano',
    'abbrivante',
    'abbrivanti',
    'abbrivare',
    'abbrivarono',
    'abbrivasse',
    'abbrivassero',
    'abbrivassi',
    'abbrivassimo',
    'abbrivaste',
    'abbrivasti',
    'abbrivata',
    'abbrivate',
    'abbrivati',
    'abbrivato',
    'abbrivava',
    'abbrivavamo',
    'abbrivavano',
    'abbrivavate',
    'abbrivavi',
    'abbrivavo',
    'abbrivera',
    'abbriverai',
    'abbriveranno',
    'abbriverebbe',
    'abbriverei',
    'abbriveremmo',
    'abbriveremo',
    'abbrivereste',
    'abbriveresti',
    'abbriverete',
    'abbrivero',
    'abbrivi',
    'abbriviamo',
    'abbriviate',
    'abbrividendo',
    'abbrividente',
    'abbrividenti',
    'abbrividi',
    'abbrividiamo',
    'abbrividiate',
    'abbrividii',
    'abbrividimmo',
    'abbrividira',
    'abbrividirai',
    'abbrividire',
    'abbrividirei',
    'abbrividiro',
    'abbrividisca',
    'abbrividisce',
    'abbrividisci',
    'abbrividisco',
    'abbrividisse',
    'abbrividissi',
    'abbrividiste',
    'abbrividisti',
    'abbrividita',
    'abbrividite',
    'abbrividiti',
    'abbrividito',
    'abbrividiva',
    'abbrividivi',
    'abbrividivo',
    'abbrivii',
    'abbrivino',
    'abbrivio',
    'abbrivo',
    'abbronza',
    'abbronzai',
    'abbronzammo',
    'abbronzando',
    'abbronzano',
    'abbronzante',
    'abbronzanti',
    'abbronzarci',
    'abbronzare',
    'abbronzarmi',
    'abbronzarono',
    'abbronzarsi',
    'abbronzarti',
    'abbronzarvi',
    'abbronzasse',
    'abbronzassi',
    'abbronzaste',
    'abbronzasti',
    'abbronzata',
    'abbronzate',
    'abbronzatevi',
    'abbronzati',
    'abbronzatina',
    'abbronzatine',
    'abbronzato',
    'abbronzatomi',
    'abbronzatoti',
    'abbronzatura',
    'abbronzature',
    'abbronzava',
    'abbronzavamo',
    'abbronzavano',
    'abbronzavate',
    'abbronzavi',
    'abbronzavo',
    'abbronzera',
    'abbronzerai',
    'abbronzerei',
    'abbronzeremo',
    'abbronzerete',
    'abbronzero',
    'abbronzi',
    'abbronziamo',
    'abbronziate',
    'abbronzino',
    'abbronzo',
    'abbrucera',
    'abbrucerai',
    'abbruceranno',
    'abbrucerebbe',
    'abbrucerei',
    'abbruceremmo',
    'abbruceremo',
    'abbrucereste',
    'abbruceresti',
    'abbrucerete',
    'abbrucero',
    'abbruci',
    'abbrucia',
    'abbruciacchi',
    'abbruciai',
    'abbruciammo',
    'abbruciamo',
    'abbruciando',
    'abbruciano',
    'abbruciante',
    'abbrucianti',
    'abbruciare',
    'abbruciarono',
    'abbruciasse',
    'abbruciassi',
    'abbruciaste',
    'abbruciasti',
    'abbruciata',
    'abbruciate',
    'abbruciati',
    'abbruciato',
    'abbruciava',
    'abbruciavamo',
    'abbruciavano',
    'abbruciavate',
    'abbruciavi',
    'abbruciavo',
    'abbrucino',
    'abbrucio',
    'abbruma',
    'abbrumai',
    'abbrumammo',
    'abbrumando',
    'abbrumano',
    'abbrumante',
    'abbrumanti',
    'abbrumare',
    'abbrumarono',
    'abbrumasse',
    'abbrumassero',
    'abbrumassi',
    'abbrumassimo',
    'abbrumaste',
    'abbrumasti',
    'abbrumata',
    'abbrumate',
    'abbrumati',
    'abbrumato',
    'abbrumava',
    'abbrumavamo',
    'abbrumavano',
    'abbrumavate',
    'abbrumavi',
    'abbrumavo',
    'abbrumera',
    'abbrumerai',
    'abbrumeranno',
    'abbrumerebbe',
    'abbrumerei',
    'abbrumeremmo',
    'abbrumeremo',
    'abbrumereste',
    'abbrumeresti',
    'abbrumerete',
    'abbrumero',
    'abbrumi',
    'abbrumiamo',
    'abbrumiate',
    'abbrumino',
    'abbrumo',
    'abbruna',
    'abbrunai',
    'abbrunamenti',
    'abbrunamento',
    'abbrunammo',
    'abbrunando',
    'abbrunandoci',
    'abbrunandomi',
    'abbrunandosi',
    'abbrunandoti',
    'abbrunandovi',
    'abbrunano',
    'abbrunante',
    'abbrunanti',
    'abbrunantisi',
    'abbrunarci',
    'abbrunare',
    'abbrunarmi',
    'abbrunarono',
    'abbrunarsi',
    'abbrunarti',
    'abbrunarvi',
    'abbrunasse',
    'abbrunassero',
    'abbrunassi',
    'abbrunassimo',
    'abbrunaste',
    'abbrunasti',
    'abbrunata',
    'abbrunate',
    'abbrunatevi',
    'abbrunati',
    'abbrunato',
    'abbrunatomi',
    'abbrunatoti',
    'abbrunava',
    'abbrunavamo',
    'abbrunavano',
    'abbrunavate',
    'abbrunavi',
    'abbrunavo',
    'abbrunendo',
    'abbrunente',
    'abbrunenti',
    'abbrunera',
    'abbrunerai',
    'abbruneranno',
    'abbrunerebbe',
    'abbrunerei',
    'abbruneremmo',
    'abbruneremo',
    'abbrunereste',
    'abbruneresti',
    'abbrunerete',
    'abbrunero',
    'abbruni',
    'abbruniamo',
    'abbruniamoci',
    'abbruniate',
    'abbrunii',
    'abbrunimmo',
    'abbrunino',
    'abbrunira',
    'abbrunirai',
    'abbruniranno',
    'abbrunire',
    'abbrunirebbe',
    'abbrunirei',
    'abbruniremmo',
    'abbruniremo',
    'abbrunireste',
    'abbruniresti',
    'abbrunirete',
    'abbruniro',
    'abbrunirono',
    'abbrunisca',
    'abbruniscano',
    'abbrunisce',
    'abbrunisci',
    'abbrunisco',
    'abbruniscono',
    'abbrunisse',
    'abbrunissero',
    'abbrunissi',
    'abbrunissimo',
    'abbruniste',
    'abbrunisti',
    'abbrunita',
    'abbrunite',
    'abbruniti',
    'abbrunito',
    'abbruniva',
    'abbrunivamo',
    'abbrunivano',
    'abbrunivate',
    'abbrunivi',
    'abbrunivo',
    'abbruno',
    'abbruscatura',
    'abbruscature',
    'abbrusti',
    'abbrustia',
    'abbrustiai',
    'abbrustiammo',
    'abbrustiamo',
    'abbrustiando',
    'abbrustiano',
    'abbrustiante',
    'abbrustianti',
    'abbrustiare',
    'abbrustiasse',
    'abbrustiassi',
    'abbrustiaste',
    'abbrustiasti',
    'abbrustiata',
    'abbrustiate',
    'abbrustiati',
    'abbrustiato',
    'abbrustiava',
    'abbrustiavi',
    'abbrustiavo',
    'abbrustiera',
    'abbrustierai',
    'abbrustierei',
    'abbrustiero',
    'abbrustino',
    'abbrustio',
    'abbrustola',
    'abbrustolai',
    'abbrustolano',
    'abbrustolare',
    'abbrustolata',
    'abbrustolate',
    'abbrustolati',
    'abbrustolato',
    'abbrustolava',
    'abbrustolavi',
    'abbrustolavo',
    'abbrustolera',
    'abbrustolero',
    'abbrustoli',
    'abbrustolii',
    'abbrustolino',
    'abbrustolira',
    'abbrustolire',
    'abbrustoliro',
    'abbrustolita',
    'abbrustolite',
    'abbrustoliti',
    'abbrustolito',
    'abbrustoliva',
    'abbrustolivi',
    'abbrustolivo',
    'abbrustolo',
    'abbrustolì',
    'abbrutendo',
    'abbrutendoci',
    'abbrutendomi',
    'abbrutendosi',
    'abbrutendoti',
    'abbrutendovi',
    'abbrutente',
    'abbrutenti',
    'abbrutentisi',
    'abbruti',
    'abbrutiamo',
    'abbrutiamoci',
    'abbrutiate',
    'abbrutii',
    'abbrutimenti',
    'abbrutimento',
    'abbrutimmo',
    'abbrutira',
    'abbrutirai',
    'abbrutiranno',
    'abbrutirci',
    'abbrutire',
    'abbrutirebbe',
    'abbrutirei',
    'abbrutiremmo',
    'abbrutiremo',
    'abbrutireste',
    'abbrutiresti',
    'abbrutirete',
    'abbrutirmi',
    'abbrutiro',
    'abbrutirono',
    'abbrutirsi',
    'abbrutirti',
    'abbrutirvi',
    'abbrutisca',
    'abbrutiscano',
    'abbrutisce',
    'abbrutisci',
    'abbrutisciti',
    'abbrutisco',
    'abbrutiscono',
    'abbrutisse',
    'abbrutissero',
    'abbrutissi',
    'abbrutissimo',
    'abbrutiste',
    'abbrutisti',
    'abbrutita',
    'abbrutite',
    'abbrutitevi',
    'abbrutiti',
    'abbrutito',
    'abbrutitomi',
    'abbrutitoti',
    'abbrutiva',
    'abbrutivamo',
    'abbrutivano',
    'abbrutivate',
    'abbrutivi',
    'abbrutivo',
    'abbruttendo',
    'abbruttente',
    'abbruttenti',
    'abbrutti',
    'abbruttiamo',
    'abbruttiate',
    'abbruttii',
    'abbruttimmo',
    'abbruttira',
    'abbruttirai',
    'abbruttirci',
    'abbruttire',
    'abbruttirei',
    'abbruttiremo',
    'abbruttirete',
    'abbruttirmi',
    'abbruttiro',
    'abbruttirono',
    'abbruttirsi',
    'abbruttirti',
    'abbruttirvi',
    'abbruttisca',
    'abbruttisce',
    'abbruttisci',
    'abbruttisco',
    'abbruttisse',
    'abbruttissi',
    'abbruttiste',
    'abbruttisti',
    'abbruttita',
    'abbruttite',
    'abbruttitevi',
    'abbruttiti',
    'abbruttito',
    'abbruttitomi',
    'abbruttitoti',
    'abbruttiva',
    'abbruttivamo',
    'abbruttivano',
    'abbruttivate',
    'abbruttivi',
    'abbruttivo',
    'abbuffa',
    'abbuffai',
    'abbuffammo',
    'abbuffando',
    'abbuffandoci',
    'abbuffandomi',
    'abbuffandosi',
    'abbuffandoti',
    'abbuffandovi',
    'abbuffano',
    'abbuffantesi',
    'abbuffantisi',
    'abbuffarci',
    'abbuffare',
    'abbuffarmi',
    'abbuffarono',
    'abbuffarsi',
    'abbuffarti',
    'abbuffarvi',
    'abbuffasse',
    'abbuffassero',
    'abbuffassi',
    'abbuffassimo',
    'abbuffaste',
    'abbuffasti',
    'abbuffata',
    'abbuffate',
    'abbuffatevi',
    'abbuffati',
    'abbuffato',
    'abbuffatomi',
    'abbuffatoti',
    'abbuffava',
    'abbuffavamo',
    'abbuffavano',
    'abbuffavate',
    'abbuffavi',
    'abbuffavo',
    'abbuffera',
    'abbufferai',
    'abbufferanno',
    'abbufferebbe',
    'abbufferei',
    'abbufferemmo',
    'abbufferemo',
    'abbuffereste',
    'abbufferesti',
    'abbufferete',
    'abbuffero',
    'abbuffi',
    'abbuffiamo',
    'abbuffiamoci',
    'abbuffiate',
    'abbuffino',
    'abbuffo',
    'abbui',
    'abbuia',
    'abbuiai',
    'abbuiammo',
    'abbuiamo',
    'abbuiamoci',
    'abbuiando',
    'abbuiandoci',
    'abbuiandomi',
    'abbuiandosi',
    'abbuiandoti',
    'abbuiandovi',
    'abbuiano',
    'abbuiante',
    'abbuianti',
    'abbuiantisi',
    'abbuiarci',
    'abbuiare',
    'abbuiarmi',
    'abbuiarono',
    'abbuiarsi',
    'abbuiarti',
    'abbuiarvi',
    'abbuiasse',
    'abbuiassero',
    'abbuiassi',
    'abbuiassimo',
    'abbuiaste',
    'abbuiasti',
    'abbuiata',
    'abbuiate',
    'abbuiatevi',
    'abbuiati',
    'abbuiato',
    'abbuiatomi',
    'abbuiatoti',
    'abbuiava',
    'abbuiavamo',
    'abbuiavano',
    'abbuiavate',
    'abbuiavi',
    'abbuiavo',
    'abbuiera',
    'abbuierai',
    'abbuieranno',
    'abbuierebbe',
    'abbuierei',
    'abbuieremmo',
    'abbuieremo',
    'abbuiereste',
    'abbuieresti',
    'abbuierete',
    'abbuiero',
    'abbuino',
    'abbuio',
    'abbuona',
    'abbuonai',
    'abbuonammo',
    'abbuonando',
    'abbuonandoci',
    'abbuonandomi',
    'abbuonandosi',
    'abbuonandoti',
    'abbuonandovi',
    'abbuonano',
    'abbuonante',
    'abbuonanti',
    'abbuonantisi',
    'abbuonarci',
    'abbuonare',
    'abbuonarmi',
    'abbuonarono',
    'abbuonarsi',
    'abbuonarti',
    'abbuonarvi',
    'abbuonasse',
    'abbuonassero',
    'abbuonassi',
    'abbuonassimo',
    'abbuonaste',
    'abbuonasti',
    'abbuonata',
    'abbuonate',
    'abbuonatevi',
    'abbuonati',
    'abbuonato',
    'abbuonatomi',
    'abbuonatoti',
    'abbuonava',
    'abbuonavamo',
    'abbuonavano',
    'abbuonavate',
    'abbuonavi',
    'abbuonavo',
    'abbuonera',
    'abbuonerai',
    'abbuoneranno',
    'abbuonerebbe',
    'abbuonerei',
    'abbuoneremmo',
    'abbuoneremo',
    'abbuonereste',
    'abbuoneresti',
    'abbuonerete',
    'abbuonero',
    'abbuoni',
    'abbuoniamo',
    'abbuoniamoci',
    'abbuoniate',
    'abbuonino',
    'abbuono',
    'abburatta',
    'abburattai',
    'abburattammo',
    'abburattando',
    'abburattano',
    'abburattante',
    'abburattanti',
    'abburattare',
    'abburattasse',
    'abburattassi',
    'abburattaste',
    'abburattasti',
    'abburattata',
    'abburattate',
    'abburattati',
    'abburattato',
    'abburattava',
    'abburattavi',
    'abburattavo',
    'abburattera',
    'abburatterai',
    'abburatterei',
    'abburattero',
    'abburatti',
    'abburattiamo',
    'abburattiate',
    'abburattino',
    'abburatto',
    'abdenago',
    'abdera',
    'abderita',
    'abderite',
    'abderiti',
    'abdica',
    'abdicabile',
    'abdicai',
    'abdicammo',
    'abdicando',
    'abdicano',
    'abdicante',
    'abdicanti',
    'abdicare',
    'abdicarono',
    'abdicasse',
    'abdicassero',
    'abdicassi',
    'abdicassimo',
    'abdicaste',
    'abdicasti',
    'abdicata',
    'abdicatari',
    'abdicataria',
    'abdicatarie',
    'abdicatario',
    'abdicate',
    'abdicati',
    'abdicato',
    'abdicatore',
    'abdicava',
    'abdicavamo',
    'abdicavano',
    'abdicavate',
    'abdicavi',
    'abdicavo',
    'abdicazione',
    'abdicazioni',
    'abdichera',
    'abdicherai',
    'abdicheranno',
    'abdicherebbe',
    'abdicherei',
    'abdicheremmo',
    'abdicheremo',
    'abdichereste',
    'abdicheresti',
    'abdicherete',
    'abdichero',
    'abdichi',
    'abdichiamo',
    'abdichiate',
    'abdichino',
    'abdico',
    'abdon',
    'abdone',
    'abdotta',
    'abdotte',
    'abdotti',
    'abdotto',
    'abduana',
    'abduane',
    'abduani',
    'abduano',
    'abduca',
    'abducano',
    'abduce',
    'abducemmo',
    'abducendo',
    'abducente',
    'abducenti',
    'abducesse',
    'abducessero',
    'abducessi',
    'abducessimo',
    'abduceste',
    'abducesti',
    'abducete',
    'abduceva',
    'abducevamo',
    'abducevano',
    'abducevate',
    'abducevi',
    'abducevo',
    'abduci',
    'abduciamo',
    'abduciate',
    'abduco',
    'abducono',
    'abdurra',
    'abdurrai',
    'abdurranno',
    'abdurre',
    'abdurrebbe',
    'abdurrebbero',
    'abdurrei',
    'abdurremmo',
    'abdurremo',
    'abdurreste',
    'abdurresti',
    'abdurrete',
    'abdurro',
    'abdusse',
    'abdussero',
    'abdussi',
    'abduttiva',
    'abduttive',
    'abduttivi',
    'abduttivo',
    'abduttore',
    'abduttori',
    'abduzione',
    'abduzioni',
    'abecedari',
    'abecedario',
    'abel',
    'abela',
    'abelarda',
    'abelardo',
    'abele',
    'abelia',
    'abeliana',
    'abeliane',
    'abeliani',
    'abeliano',
    'abelie',
    'abelina',
    'abelino',
    'abelmoschi',
    'abelmosco',
    'abelson',
    'abenula',
    'abenulare',
    'abenulari',
    'abenule',
    'aberardo',
    'aberdeen',
    'aberra',
    'aberrai',
    'aberrammo',
    'aberrando',
    'aberrano',
    'aberrante',
    'aberranti',
    'aberrare',
    'aberrarono',
    'aberrasse',
    'aberrassero',
    'aberrassi',
    'aberrassimo',
    'aberraste',
    'aberrasti',
    'aberrata',
    'aberrate',
    'aberrati',
    'aberrato',
    'aberrava',
    'aberravamo',
    'aberravano',
    'aberravate',
    'aberravi',
    'aberravo',
    'aberrazione',
    'aberrazioni',
    'aberrera',
    'aberrerai',
    'aberreranno',
    'aberrerebbe',
    'aberrerei',
    'aberreremmo',
    'aberreremo',
    'aberrereste',
    'aberreresti',
    'aberrerete',
    'aberrero',
    'aberri',
    'aberriamo',
    'aberriate',
    'aberrino',
    'aberro',
    'aberrometri',
    'aberrometro',
    'abetaia',
    'abetaie',
    'abete',
    'abetella',
    'abetelle',
    'abeti',
    'abetina',
    'abetine',
    'abetini',
    'abetino',
    'abeto',
    'abetone',
    'abetoni',
    'abiatica',
    'abiatiche',
    'abiatici',
    'abiatico',
    'abici',
    'abietta',
    'abiettamente',
    'abiettando',
    'abiettare',
    'abiette',
    'abiettezza',
    'abiettezze',
    'abietti',
    'abietto',
    'abiezione',
    'abiezioni',
    'abigeatari',
    'abigeataria',
    'abigeatarie',
    'abigeatario',
    'abigeati',
    'abigeato',
    'abigei',
    'abigeo',
    'abile',
    'abili',
    'abilio',
    'abilissima',
    'abilissimo',
    'abilita',
    'abilitai',
    'abilitammo',
    'abilitando',
    'abilitandoci',
    'abilitandomi',
    'abilitandosi',
    'abilitandoti',
    'abilitandovi',
    'abilitano',
    'abilitante',
    'abilitanti',
    'abilitantisi',
    'abilitarci',
    'abilitare',
    'abilitarmi',
    'abilitarono',
    'abilitarsi',
    'abilitarti',
    'abilitarvi',
    'abilitasse',
    'abilitassero',
    'abilitassi',
    'abilitassimo',
    'abilitaste',
    'abilitasti',
    'abilitata',
    'abilitate',
    'abilitatevi',
    'abilitati',
    'abilitativa',
    'abilitative',
    'abilitativi',
    'abilitativo',
    'abilitato',
    'abilitatomi',
    'abilitatoti',
    'abilitava',
    'abilitavamo',
    'abilitavano',
    'abilitavate',
    'abilitavi',
    'abilitavo',
    'abilitazione',
    'abilitazioni',
    'abilitera',
    'abiliterai',
    'abiliteranno',
    'abiliterebbe',
    'abiliterei',
    'abiliteremmo',
    'abiliteremo',
    'abilitereste',
    'abiliteresti',
    'abiliterete',
    'abilitero',
    'abiliti',
    'abilitiamo',
    'abilitiamoci',
    'abilitiate',
    'abilitino',
    'abilito',
    'abilità',
    'abilmente',
    'abio',
    'abiogenesi',
    'abiogenetica',
    'abiogenetico',
    'abiologia',
    'abiologie',
    'abiosfera',
    'abiosfere',
    'abiotica',
    'abiotiche',
    'abiotici',
    'abiotico',
    'abissale',
    'abissali',
    'abissalmente',
    'abissi',
    'abissina',
    'abissine',
    'abissini',
    'abissinia',
    'abissino',
    'abisso',
    'abita',
    'abitabile',
    'abitabili',
    'abitabilita',
    'abitabilità',
    'abitacoli',
    'abitacolo',
    'abitai',
    'abitammo',
    'abitando',
    'abitano',
    'abitante',
    'abitanti',
    'abitare',
    'abitari',
    'abitarono',
    'abitarvi',
    'abitasse',
    'abitassero',
    'abitassi',
    'abitassimo',
    'abitaste',
    'abitasti',
    'abitata',
    'abitate',
    'abitati',
    'abitativa',
    'abitative',
    'abitativi',
    'abitativo',
    'abitato',
    'abitatore',
    'abitatori',
    'abitatrice',
    'abitatrici',
    'abitava',
    'abitavamo',
    'abitavano',
    'abitavate',
    'abitavi',
    'abitavo',
    'abitazione',
    'abitazioni',
    'abitera',
    'abiterai',
    'abiteranno',
    'abiterebbe',
    'abiterebbero',
    'abiterei',
    'abiteremmo',
    'abiteremo',
    'abitereste',
    'abiteresti',
    'abiterete',
    'abitero',
    'abiti',
    'abitiamo',
    'abitiate',
    'abitini',
    'abitino',
    'abito',
    'abitua',
    'abituai',
    'abituale',
    'abituali',
    'abitualita',
    'abitualità',
    'abitualmente',
    'abituammo',
    'abituando',
    'abituandoci',
    'abituandomi',
    'abituandosi',
    'abituandoti',
    'abituandovi',
    'abituano',
    'abituante',
    'abituanti',
    'abituantisi',
    'abituarci',
    'abituare',
    'abituarmi',
    'abituarono',
    'abituarsi',
    'abituarti',
    'abituarvi',
    'abituasse',
    'abituassero',
    'abituassi',
    'abituassimo',
    'abituaste',
    'abituasti',
    'abituata',
    'abituate',
    'abituatevi',
    'abituati',
    'abituato',
    'abituatomi',
    'abituatoti',
    'abituava',
    'abituavamo',
    'abituavano',
    'abituavate',
    'abituavi',
    'abituavo',
    'abituazione',
    'abituazioni',
    'abitucci',
    'abituccio',
    'abitudinari',
    'abitudinaria',
    'abitudinarie',
    'abitudinario',
    'abitudine',
    'abitudini',
    'abituera',
    'abituerai',
    'abitueranno',
    'abituerebbe',
    'abituerei',
    'abitueremmo',
    'abitueremo',
    'abituereste',
    'abitueresti',
    'abituerete',
    'abituero',
    'abitui',
    'abituiamo',
    'abituiamoci',
    'abituiate',
    'abituino',
    'abituo',
    'abituri',
    'abituro',
    'abituò',
    'abiura',
    'abiurai',
    'abiurammo',
    'abiurando',
    'abiurano',
    'abiurante',
    'abiuranti',
    'abiurare',
    'abiurarono',
    'abiurasse',
    'abiurassero',
    'abiurassi',
    'abiurassimo',
    'abiuraste',
    'abiurasti',
    'abiurata',
    'abiurate',
    'abiurati',
    'abiurato',
    'abiurava',
    'abiuravamo',
    'abiuravano',
    'abiuravate',
    'abiuravi',
    'abiuravo',
    'abiure',
    'abiurera',
    'abiurerai',
    'abiureranno',
    'abiurerebbe',
    'abiurerei',
    'abiureremmo',
    'abiureremo',
    'abiurereste',
    'abiureresti',
    'abiurerete',
    'abiurero',
    'abiuri',
    'abiuriamo',
    'abiuriate',
    'abiurino',
    'abiuro',
    'ablativa',
    'ablative',
    'ablativi',
    'ablativo',
    'ablatore',
    'ablatori',
    'ablatoria',
    'ablatorie',
    'ablatorio',
    'ablazione',
    'ablazioni',
    'ablefaria',
    'ablefarie',
    'ablegati',
    'ablegato',
    'ablegazione',
    'ablegazioni',
    'ablutori',
    'ablutoria',
    'ablutorie',
    'ablutorio',
    'abluzione',
    'abluzioni',
    'abnega',
    'abnegai',
    'abnegammo',
    'abnegando',
    'abnegano',
    'abnegante',
    'abneganti',
    'abnegare',
    'abnegarono',
    'abnegasse',
    'abnegassero',
    'abnegassi',
    'abnegassimo',
    'abnegaste',
    'abnegasti',
    'abnegata',
    'abnegate',
    'abnegati',
    'abnegato',
    'abnegatosi',
    'abnegava',
    'abnegavamo',
    'abnegavano',
    'abnegavate',
    'abnegavi',
    'abnegavo',
    'abnegazione',
    'abnegazioni',
    'abneghera',
    'abnegherai',
    'abnegheranno',
    'abnegherebbe',
    'abnegherei',
    'abnegheremmo',
    'abnegheremo',
    'abneghereste',
    'abnegheresti',
    'abnegherete',
    'abneghero',
    'abneghi',
    'abneghiamo',
    'abneghiate',
    'abneghino',
    'abnego',
    'abnorme',
    'abnormemente',
    'abnormi',
    'abolano',
    'abolendo',
    'abolente',
    'abolenti',
    'aboli',
    'aboliamo',
    'aboliate',
    'abolibile',
    'abolibili',
    'abolii',
    'abolimmo',
    'abolira',
    'abolirai',
    'aboliranno',
    'abolire',
    'abolirebbe',
    'abolirebbero',
    'abolirei',
    'aboliremmo',
    'aboliremo',
    'abolireste',
    'aboliresti',
    'abolirete',
    'aboliro',
    'abolirono',
    'abolisca',
    'aboliscano',
    'abolisce',
    'abolisci',
    'abolisco',
    'aboliscono',
    'abolisse',
    'abolissero',
    'abolissi',
    'abolissimo',
    'aboliste',
    'abolisti',
    'abolita',
    'abolite',
    'aboliti',
    'abolitiva',
    'abolitive',
    'abolitivi',
    'abolitivo',
    'abolito',
    'abolitore',
    'abolitori',
    'abolitrice',
    'abolitrici',
    'aboliva',
    'abolivamo',
    'abolivano',
    'abolivate',
    'abolivi',
    'abolivo',
    'abolizione',
    'abolizioni',
    'abolla',
    'abolle',
    'abomasale',
    'abomasi',
    'abomaso',
    'abomina',
    'abominabile',
    'abominabili',
    'abominai',
    'abominammo',
    'abominanda',
    'abominande',
    'abominandi',
    'abominando',
    'abominano',
    'abominante',
    'abominanti',
    'abominare',
    'abominarono',
    'abominasse',
    'abominassero',
    'abominassi',
    'abominassimo',
    'abominaste',
    'abominasti',
    'abominata',
    'abominate',
    'abominati',
    'abominato',
    'abominava',
    'abominavamo',
    'abominavano',
    'abominavate',
    'abominavi',
    'abominavo',
    'abominazione',
    'abominazioni',
    'abominera',
    'abominerai',
    'abomineranno',
    'abominerebbe',
    'abominerei',
    'abomineremmo',
    'abomineremo',
    'abominereste',
    'abomineresti',
    'abominerete',
    'abominero',
    'abominevole',
    'abominevoli',
    'abomini',
    'abominiamo',
    'abominiate',
    'abominino',
    'abominio',
    'abomino',
    'abominosa',
    'abominose',
    'abominosi',
    'abominoso',
    'abondante',
    'abondanza',
    'abondare',
    'abondevole',
    'abondio',
    'aborale',
    'aborali',
    'aborigena',
    'aborigene',
    'aborigeni',
    'aborigeno',
    'aborra',
    'aborrano',
    'aborre',
    'aborrendo',
    'aborrente',
    'aborrenti',
    'aborrevole',
    'aborrevoli',
    'aborri',
    'aborriamo',
    'aborriate',
    'aborrii',
    'aborrimenti',
    'aborrimento',
    'aborrimmo',
    'aborrira',
    'aborrirai',
    'aborriranno',
    'aborrire',
    'aborrirebbe',
    'aborrirei',
    'aborriremmo',
    'aborriremo',
    'aborrireste',
    'aborriresti',
    'aborrirete',
    'aborriro',
    'aborrirono',
    'aborrisca',
    'aborriscano',
    'aborrisce',
    'aborrisci',
    'aborrisco',
    'aborriscono',
    'aborrisse',
    'aborrissero',
    'aborrissi',
    'aborrissimo',
    'aborriste',
    'aborristi',
    'aborrita',
    'aborrite',
    'aborriti',
    'aborrito',
    'aborritore',
    'aborritori',
    'aborritrice',
    'aborritrici',
    'aborriva',
    'aborrivamo',
    'aborrivano',
    'aborrivate',
    'aborrivi',
    'aborrivo',
    'aborro',
    'aborrono',
    'abortendo',
    'abortente',
    'abortenti',
    'aborti',
    'abortiamo',
    'abortiate',
    'abortii',
    'abortimmo',
    'abortira',
    'abortirai',
    'abortiranno',
    'abortire',
    'abortirebbe',
    'abortirei',
    'abortiremmo',
    'abortiremo',
    'abortireste',
    'abortiresti',
    'abortirete',
    'abortiro',
    'abortirono',
    'abortisca',
    'abortiscano',
    'abortisce',
    'abortisci',
    'abortisco',
    'abortiscono',
    'abortisse',
    'abortissero',
    'abortissi',
    'abortissimo',
    'abortista',
    'abortiste',
    'abortisti',
    'abortita',
    'abortite',
    'abortiti',
    'abortito',
    'abortiva',
    'abortivamo',
    'abortivano',
    'abortivate',
    'abortive',
    'abortivi',
    'abortivo',
    'aborto',
    'abortus',
    'aboto',
    'abracadabra',
    'abrada',
    'abradano',
    'abrade',
    'abrademmo',
    'abradendo',
    'abradente',
    'abradenti',
    'abradera',
    'abraderai',
    'abraderanno',
    'abradere',
    'abraderebbe',
    'abraderei',
    'abraderemmo',
    'abraderemo',
    'abradereste',
    'abraderesti',
    'abraderete',
    'abradero',
    'abradesse',
    'abradessero',
    'abradessi',
    'abradessimo',
    'abradeste',
    'abradesti',
    'abradete',
    'abradeva',
    'abradevamo',
    'abradevano',
    'abradevate',
    'abradevi',
    'abradevo',
    'abradi',
    'abradiamo',
    'abradiate',
    'abrado',
    'abradono',
    'abrama',
    'abramina',
    'abramino',
    'abramo',
    'abrasa',
    'abrase',
    'abrasero',
    'abrasi',
    'abrasione',
    'abrasioni',
    'abrasiva',
    'abrasive',
    'abrasivi',
    'abrasivita',
    'abrasività',
    'abrasivo',
    'abraso',
    'abreazione',
    'abreazioni',
    'abrege',
    'abri',
    'abro',
    'abroga',
    'abrogabile',
    'abrogabili',
    'abrogai',
    'abrogammo',
    'abrogando',
    'abrogano',
    'abrogante',
    'abroganti',
    'abrogare',
    'abrogarono',
    'abrogasse',
    'abrogassero',
    'abrogassi',
    'abrogassimo',
    'abrogaste',
    'abrogasti',
    'abrogata',
    'abrogate',
    'abrogati',
    'abrogativa',
    'abrogative',
    'abrogativi',
    'abrogativo',
    'abrogato',
    'abrogatori',
    'abrogatoria',
    'abrogatorie',
    'abrogatorio',
    'abrogava',
    'abrogavamo',
    'abrogavano',
    'abrogavate',
    'abrogavi',
    'abrogavo',
    'abrogazione',
    'abrogazioni',
    'abroghera',
    'abrogherai',
    'abrogheranno',
    'abrogherebbe',
    'abrogherei',
    'abrogheremmo',
    'abrogheremo',
    'abroghereste',
    'abrogheresti',
    'abrogherete',
    'abroghero',
    'abroghi',
    'abroghiamo',
    'abroghiate',
    'abroghino',
    'abrogo',
    'abrostine',
    'abrostini',
    'abrotani',
    'abrotano',
    'abruptio',
    'abrupto',
    'abruzzese',
    'abruzzesi',
    'abruzzi',
    'abruzzo',
    'absburgica',
    'absburgiche',
    'absburgici',
    'absburgico',
    'abscissione',
    'abscissioni',
    'absidale',
    'absidali',
    'absidata',
    'absidate',
    'absidati',
    'absidato',
    'abside',
    'absidi',
    'absidia',
    'absidiola',
    'absidiole',
    'absintina',
    'absintine',
    'absintismi',
    'absintismo',
    'absintoli',
    'absintolo',
    'absorbimento',
    'abstract',
    'abulia',
    'abulica',
    'abulicamente',
    'abuliche',
    'abulici',
    'abulico',
    'abulie',
    'abuna',
    'abundantiam',
    'abusa',
    'abusabile',
    'abusai',
    'abusammo',
    'abusando',
    'abusandone',
    'abusano',
    'abusante',
    'abusanti',
    'abusare',
    'abusarne',
    'abusarono',
    'abusasse',
    'abusassero',
    'abusassi',
    'abusassimo',
    'abusaste',
    'abusasti',
    'abusata',
    'abusate',
    'abusati',
    'abusato',
    'abusava',
    'abusavamo',
    'abusavano',
    'abusavate',
    'abusavi',
    'abusavo',
    'abusera',
    'abuserai',
    'abuseranno',
    'abuserebbe',
    'abuserebbero',
    'abuserei',
    'abuseremmo',
    'abuseremo',
    'abusereste',
    'abuseresti',
    'abuserete',
    'abusero',
    'abusi',
    'abusiamo',
    'abusiate',
    'abusino',
    'abusione',
    'abusioni',
    'abusiva',
    'abusivamente',
    'abusive',
    'abusivi',
    'abusivismi',
    'abusivismo',
    'abusivista',
    'abusiviste',
    'abusivisti',
    'abusivita',
    'abusivo',
    'abuso',
    'abutilon',
    'acacia',
    'acacie',
    'academia',
    'academico',
    'acagiu',
    'acaia',
    'acaica',
    'acaiche',
    'acaici',
    'acaico',
    'acajou',
    'acalasia',
    'acalefa',
    'acalefe',
    'acalipteri',
    'acaliptero',
    'acaliptrati',
    'acaliptrato',
    'acalitteri',
    'acalittero',
    'acalittrati',
    'acalittrato',
    'acantacea',
    'acantacee',
    'acanthamoeba',
    'acanthosis',
    'acanti',
    'acanto',
    'acantocefali',
    'acantocefalo',
    'acantociti',
    'acantofaga',
    'acantofaghe',
    'acantofagi',
    'acantofago',
    'acantofide',
    'acantofidi',
    'acantolisi',
    'acantoma',
    'acantomi',
    'acantopelvi',
    'acantosi',
    'acantotteri',
    'acantottero',
    'acanturide',
    'acanturidi',
    'acanzi',
    'acanzio',
    'acapnia',
    'acapnie',
    'acapulco',
    'acardia',
    'acardie',
    'acari',
    'acariasi',
    'acaricida',
    'acaricide',
    'acaricidi',
    'acarina',
    'acariosi',
    'acaro',
    'acarocecidi',
    'acarocecidio',
    'acaroide',
    'acaroidi',
    'acarosi',
    'acarpa',
    'acarpe',
    'acarpi',
    'acarpo',
    'acatalessi',
    'acatalessia',
    'acatalessie',
    'acataletta',
    'acatalette',
    'acataletti',
    'acatalettica',
    'acatalettici',
    'acatalettico',
    'acataletto',
    'acati',
    'acatisia',
    'acatista',
    'acatiste',
    'acatisti',
    'acatisto',
    'acato',
    'acattolica',
    'acattoliche',
    'acattolici',
    'acattolico',
    'acaule',
    'acauli',
    'acazi',
    'acazio',
    'acca',
    'accada',
    'accadano',
    'accadda',
    'accadde',
    'accaddero',
    'accaddi',
    'accade',
    'accademia',
    'accademica',
    'accademiche',
    'accademici',
    'accademico',
    'accademie',
    'accademismi',
    'accademismo',
    'accademista',
    'accademiste',
    'accademisti',
    'accademiucce',
    'accademmo',
    'accadendo',
    'accadente',
    'accadenti',
    'accadere',
    'accadersi',
    'accadesse',
    'accadessero',
    'accadessi',
    'accadessimo',
    'accadeste',
    'accadesti',
    'accadete',
    'accadeva',
    'accadevamo',
    'accadevano',
    'accadevate',
    'accadevi',
    'accadevo',
    'accadi',
    'accadiamo',
    'accadiate',
    'accadica',
    'accadiche',
    'accadici',
    'accadico',
    'accadimenti',
    'accadimento',
    'accado',
    'accadono',
    'accadra',
    'accadrai',
    'accadranno',
    'accadrebbe',
    'accadrebbero',
    'accadrei',
    'accadremmo',
    'accadremo',
    'accadreste',
    'accadresti',
    'accadrete',
    'accadro',
    'accadrà',
    'accaduta',
    'accadute',
    'accaduti',
    'accaduto',
    'accadutomi',
    'accaffare',
    'accaffi',
    'accagiona',
    'accagionai',
    'accagionammo',
    'accagionando',
    'accagionano',
    'accagionante',
    'accagionanti',
    'accagionare',
    'accagionasse',
    'accagionassi',
    'accagionaste',
    'accagionasti',
    'accagionata',
    'accagionate',
    'accagionati',
    'accagionato',
    'accagionava',
    'accagionavi',
    'accagionavo',
    'accagionera',
    'accagionerai',
    'accagionerei',
    'accagionero',
    'accagioni',
    'accagioniamo',
    'accagioniate',
    'accagionino',
    'accagiono',
    'accagli',
    'accaglia',
    'accagliai',
    'accagliammo',
    'accagliamo',
    'accagliamoci',
    'accagliando',
    'accagliano',
    'accagliante',
    'accaglianti',
    'accagliarci',
    'accagliare',
    'accagliarmi',
    'accagliarono',
    'accagliarsi',
    'accagliarti',
    'accagliarvi',
    'accagliasse',
    'accagliassi',
    'accagliaste',
    'accagliasti',
    'accagliata',
    'accagliate',
    'accagliatevi',
    'accagliati',
    'accagliato',
    'accagliatomi',
    'accagliatoti',
    'accagliatura',
    'accagliature',
    'accagliava',
    'accagliavamo',
    'accagliavano',
    'accagliavate',
    'accagliavi',
    'accagliavo',
    'accagliera',
    'accaglierai',
    'accaglierei',
    'accaglieremo',
    'accaglierete',
    'accagliero',
    'accaglino',
    'accaglio',
    'accalappi',
    'accalappia',
    'accalappiai',
    'accalappiamo',
    'accalappiano',
    'accalappiare',
    'accalappiata',
    'accalappiate',
    'accalappiati',
    'accalappiato',
    'accalappiava',
    'accalappiavi',
    'accalappiavo',
    'accalappiera',
    'accalappiero',
    'accalappino',
    'accalappio',
    'accalca',
    'accalcai',
    'accalcammo',
    'accalcando',
    'accalcandoci',
    'accalcandomi',
    'accalcandosi',
    'accalcandoti',
    'accalcandovi',
    'accalcano',
    'accalcante',
    'accalcanti',
    'accalcantisi',
    'accalcarci',
    'accalcare',
    'accalcarmi',
    'accalcarono',
    'accalcarsi',
    'accalcarti',
    'accalcarvi',
    'accalcasse',
    'accalcassero',
    'accalcassi',
    'accalcassimo',
    'accalcaste',
    'accalcasti',
    'accalcata',
    'accalcate',
    'accalcatevi',
    'accalcati',
    'accalcato',
    'accalcatomi',
    'accalcatoti',
    'accalcava',
    'accalcavamo',
    'accalcavano',
    'accalcavate',
    'accalcavi',
    'accalcavo',
    'accalchera',
    'accalcherai',
    'accalcherei',
    'accalcheremo',
    'accalcherete',
    'accalchero',
    'accalchi',
    'accalchiamo',
    'accalchiate',
    'accalchino',
    'accalco',
    'accalda',
    'accaldai',
    'accaldammo',
    'accaldando',
    'accaldandoci',
    'accaldandomi',
    'accaldandosi',
    'accaldandoti',
    'accaldandovi',
    'accaldano',
    'accaldantesi',
    'accaldantisi',
    'accaldarci',
    'accaldare',
    'accaldarmi',
    'accaldarono',
    'accaldarsi',
    'accaldarti',
    'accaldarvi',
    'accaldasse',
    'accaldassero',
    'accaldassi',
    'accaldassimo',
    'accaldaste',
    'accaldasti',
    'accaldata',
    'accaldate',
    'accaldatevi',
    'accaldati',
    'accaldato',
    'accaldatomi',
    'accaldatoti',
    'accaldava',
    'accaldavamo',
    'accaldavano',
    'accaldavate',
    'accaldavi',
    'accaldavo',
    'accaldera',
    'accalderai',
    'accalderanno',
    'accalderebbe',
    'accalderei',
    'accalderemmo',
    'accalderemo',
    'accaldereste',
    'accalderesti',
    'accalderete',
    'accaldero',
    'accaldi',
    'accaldiamo',
    'accaldiamoci',
    'accaldiate',
    'accaldino',
    'accaldo',
    'accalmia',
    'accalmie',
    'accalora',
    'accalorai',
    'accalorammo',
    'accalorando',
    'accalorano',
    'accalorante',
    'accaloranti',
    'accalorarci',
    'accalorare',
    'accalorarmi',
    'accalorarono',
    'accalorarsi',
    'accalorarti',
    'accalorarvi',
    'accalorasse',
    'accalorassi',
    'accaloraste',
    'accalorasti',
    'accalorata',
    'accalorate',
    'accaloratevi',
    'accalorati',
    'accalorato',
    'accaloratomi',
    'accaloratoti',
    'accalorava',
    'accaloravamo',
    'accaloravano',
    'accaloravate',
    'accaloravi',
    'accaloravo',
    'accalorendo',
    'accalorente',
    'accalorenti',
    'accalorera',
    'accalorerai',
    'accalorerei',
    'accaloreremo',
    'accalorerete',
    'accalorero',
    'accalori',
    'accaloriamo',
    'accaloriate',
    'accalorii',
    'accalorimmo',
    'accalorino',
    'accalorira',
    'accalorirai',
    'accalorire',
    'accalorirei',
    'accaloriremo',
    'accalorirete',
    'accaloriro',
    'accalorirono',
    'accalorisca',
    'accalorisce',
    'accalorisci',
    'accalorisco',
    'accalorisse',
    'accalorissi',
    'accaloriste',
    'accaloristi',
    'accalorita',
    'accalorite',
    'accaloriti',
    'accalorito',
    'accaloriva',
    'accalorivamo',
    'accalorivano',
    'accalorivate',
    'accalorivi',
    'accalorivo',
    'accaloro',
    'accampa',
    'accampai',
    'accampamenti',
    'accampamento',
    'accampammo',
    'accampana',
    'accampanai',
    'accampanammo',
    'accampanando',
    'accampanano',
    'accampanante',
    'accampananti',
    'accampanare',
    'accampanasse',
    'accampanassi',
    'accampanaste',
    'accampanasti',
    'accampanata',
    'accampanate',
    'accampanati',
    'accampanato',
    'accampanava',
    'accampanavi',
    'accampanavo',
    'accampando',
    'accampandoci',
    'accampandomi',
    'accampandosi',
    'accampandoti',
    'accampandovi',
    'accampanera',
    'accampanerai',
    'accampanerei',
    'accampanero',
    'accampani',
    'accampaniamo',
    'accampaniate',
    'accampanino',
    'accampano',
    'accampante',
    'accampanti',
    'accampantisi',
    'accamparci',
    'accampare',
    'accamparmi',
    'accamparono',
    'accamparsi',
    'accamparti',
    'accamparvi',
    'accampasse',
    'accampassero',
    'accampassi',
    'accampassimo',
    'accampaste',
    'accampasti',
    'accampata',
    'accampate',
    'accampatevi',
    'accampati',
    'accampato',
    'accampatomi',
    'accampatoti',
    'accampava',
    'accampavamo',
    'accampavano',
    'accampavate',
    'accampavi',
    'accampavo',
    'accampera',
    'accamperai',
    'accamperanno',
    'accamperebbe',
    'accamperei',
    'accamperemmo',
    'accamperemo',
    'accampereste',
    'accamperesti',
    'accamperete',
    'accampero',
    'accampi',
    'accampiamo',
    'accampiamoci',
    'accampiate',
    'accampino',
    'accampiona',
    'accampionai',
    'accampionano',
    'accampionare',
    'accampionata',
    'accampionate',
    'accampionati',
    'accampionato',
    'accampionava',
    'accampionavi',
    'accampionavo',
    'accampionera',
    'accampionero',
    'accampioni',
    'accampionino',
    'accampiono',
    'accampo',
    'accanano',
    'accanendo',
    'accanendoci',
    'accanendomi',
    'accanendosi',
    'accanendoti',
    'accanendovi',
    'accanente',
    'accanenti',
    'accanentisi',
    'accani',
    'accaniamo',
    'accaniamoci',
    'accaniate',
    'accanii',
    'accanimenti',
    'accanimento',
    'accanimmo',
    'accanira',
    'accanirai',
    'accaniranno',
    'accanirci',
    'accanire',
    'accanirebbe',
    'accanirei',
    'accaniremmo',
    'accaniremo',
    'accanireste',
    'accaniresti',
    'accanirete',
    'accanirmi',
    'accaniro',
    'accanirono',
    'accanirsi',
    'accanirti',
    'accanirvi',
    'accanisca',
    'accaniscano',
    'accanisce',
    'accanisci',
    'accanisciti',
    'accanisco',
    'accaniscono',
    'accanisse',
    'accanissero',
    'accanissi',
    'accanissimo',
    'accaniste',
    'accanisti',
    'accanita',
    'accanite',
    'accanitevi',
    'accaniti',
    'accanito',
    'accanitomi',
    'accanitoti',
    'accaniva',
    'accanivamo',
    'accanivano',
    'accanivate',
    'accanivi',
    'accanivo',
    'accannella',
    'accannellai',
    'accannellano',
    'accannellare',
    'accannellata',
    'accannellate',
    'accannellati',
    'accannellato',
    'accannellava',
    'accannellavi',
    'accannellavo',
    'accannellera',
    'accannellero',
    'accannelli',
    'accannellino',
    'accannello',
    'accanto',
    'accantona',
    'accantonai',
    'accantonammo',
    'accantonando',
    'accantonano',
    'accantonante',
    'accantonanti',
    'accantonarci',
    'accantonare',
    'accantonarmi',
    'accantonarsi',
    'accantonarti',
    'accantonarvi',
    'accantonasse',
    'accantonassi',
    'accantonaste',
    'accantonasti',
    'accantonata',
    'accantonate',
    'accantonati',
    'accantonato',
    'accantonava',
    'accantonavi',
    'accantonavo',
    'accantonera',
    'accantonerai',
    'accantonerei',
    'accantonero',
    'accantoni',
    'accantoniamo',
    'accantoniate',
    'accantonino',
    'accantono',
    'accaparra',
    'accaparrai',
    'accaparrammo',
    'accaparrando',
    'accaparrano',
    'accaparrante',
    'accaparranti',
    'accaparrarci',
    'accaparrare',
    'accaparrarmi',
    'accaparrarsi',
    'accaparrarti',
    'accaparrarvi',
    'accaparrasse',
    'accaparrassi',
    'accaparraste',
    'accaparrasti',
    'accaparrata',
    'accaparrate',
    'accaparrati',
    'accaparrato',
    'accaparrava',
    'accaparravi',
    'accaparravo',
    'accaparrera',
    'accaparrerai',
    'accaparrerei',
    'accaparrero',
    'accaparri',
    'accaparriamo',
    'accaparriate',
    'accaparrino',
    'accaparro',
    'accapezza',
    'accapezzai',
    'accapezzammo',
    'accapezzando',
    'accapezzano',
    'accapezzante',
    'accapezzanti',
    'accapezzare',
    'accapezzasse',
    'accapezzassi',
    'accapezzaste',
    'accapezzasti',
    'accapezzata',
    'accapezzate',
    'accapezzati',
    'accapezzato',
    'accapezzava',
    'accapezzavi',
    'accapezzavo',
    'accapezzera',
    'accapezzerai',
    'accapezzerei',
    'accapezzero',
    'accapezzi',
    'accapezziamo',
    'accapezziate',
    'accapezzino',
    'accapezzo',
    'accapigli',
    'accapiglia',
    'accapigliai',
    'accapigliamo',
    'accapigliano',
    'accapigliare',
    'accapigliata',
    'accapigliate',
    'accapigliati',
    'accapigliato',
    'accapigliava',
    'accapigliavi',
    'accapigliavo',
    'accapigliera',
    'accapigliero',
    'accapiglino',
    'accapiglio',
    'accapo',
    'accappatoi',
    'accappatoio',
    'accappi',
    'accappia',
    'accappiai',
    'accappiammo',
    'accappiamo',
    'accappiando',
    'accappiano',
    'accappiante',
    'accappianti',
    'accappiare',
    'accappiarono',
    'accappiasse',
    'accappiassi',
    'accappiaste',
    'accappiasti',
    'accappiata',
    'accappiate',
    'accappiati',
    'accappiato',
    'accappiatura',
    'accappiature',
    'accappiava',
    'accappiavamo',
    'accappiavano',
    'accappiavate',
    'accappiavi',
    'accappiavo',
    'accappiera',
    'accappierai',
    'accappierei',
    'accappieremo',
    'accappierete',
    'accappiero',
    'accappietta',
    'accappiettai',
    'accappietti',
    'accappietto',
    'accappino',
    'accappio',
    'accappona',
    'accapponai',
    'accapponammo',
    'accapponando',
    'accapponano',
    'accapponante',
    'accapponanti',
    'accapponarci',
    'accapponare',
    'accapponarmi',
    'accapponarsi',
    'accapponarti',
    'accapponarvi',
    'accapponasse',
    'accapponassi',
    'accapponaste',
    'accapponasti',
    'accapponata',
    'accapponate',
    'accapponati',
    'accapponato',
    'accapponava',
    'accapponavi',
    'accapponavo',
    'accapponera',
    'accapponerai',
    'accapponerei',
    'accapponero',
    'accapponi',
    'accapponiamo',
    'accapponiate',
    'accapponino',
    'accappono',
    'accapretta',
    'accaprettai',
    'accaprettano',
    'accaprettare',
    'accaprettata',
    'accaprettate',
    'accaprettati',
    'accaprettato',
    'accaprettava',
    'accaprettavi',
    'accaprettavo',
    'accaprettera',
    'accaprettero',
    'accapretti',
    'accaprettino',
    'accapretto',
    'accarezza',
    'accarezzai',
    'accarezzammo',
    'accarezzando',
    'accarezzano',
    'accarezzante',
    'accarezzanti',
    'accarezzarci',
    'accarezzare',
    'accarezzarmi',
    'accarezzarsi',
    'accarezzarti',
    'accarezzarvi',
    'accarezzasse',
    'accarezzassi',
    'accarezzaste',
    'accarezzasti',
    'accarezzata',
    'accarezzate',
    'accarezzati',
    'accarezzato',
    'accarezzava',
    'accarezzavi',
    'accarezzavo',
    'accarezzera',
    'accarezzerai',
    'accarezzerei',
    'accarezzero',
    'accarezzi',
    'accarezziamo',
    'accarezziate',
    'accarezzino',
    'accarezzo',
    'accarna',
    'accarnando',
    'accarnare',
    'accarnato',
    'accarno',
    'accartoccera',
    'accartoccero',
    'accartocci',
    'accartoccia',
    'accartocciai',
    'accartoccino',
    'accartoccio',
    'accasa',
    'accasai',
    'accasamenti',
    'accasamento',
    'accasammo',
    'accasando',
    'accasandoci',
    'accasandomi',
    'accasandosi',
    'accasandoti',
    'accasandovi',
    'accasano',
    'accasante',
    'accasanti',
    'accasantisi',
    'accasarci',
    'accasare',
    'accasarmi',
    'accasarono',
    'accasarsi',
    'accasarti',
    'accasarvi',
    'accasasse',
    'accasassero',
    'accasassi',
    'accasassimo',
    'accasaste',
    'accasasti',
    'accasata',
    'accasate',
    'accasatevi',
    'accasati',
    'accasato',
    'accasatomi',
    'accasatoti',
    'accasava',
    'accasavamo',
    'accasavano',
    'accasavate',
    'accasavi',
    'accasavo',
    'accascera',
    'accascerai',
    'accasceranno',
    'accascerebbe',
    'accascerei',
    'accasceremmo',
    'accasceremo',
    'accascereste',
    'accasceresti',
    'accascerete',
    'accascero',
    'accasci',
    'accascia',
    'accasciai',
    'accasciammo',
    'accasciamo',
    'accasciamoci',
    'accasciando',
    'accasciano',
    'accasciante',
    'accascianti',
    'accasciarci',
    'accasciare',
    'accasciarmi',
    'accasciarono',
    'accasciarsi',
    'accasciarti',
    'accasciarvi',
    'accasciasse',
    'accasciassi',
    'accasciaste',
    'accasciasti',
    'accasciata',
    'accasciate',
    'accasciatevi',
    'accasciati',
    'accasciato',
    'accasciatomi',
    'accasciatoti',
    'accasciava',
    'accasciavamo',
    'accasciavano',
    'accasciavate',
    'accasciavi',
    'accasciavo',
    'accascino',
    'accascio',
    'accasella',
    'accasellai',
    'accasellammo',
    'accasellando',
    'accasellano',
    'accasellante',
    'accasellanti',
    'accasellare',
    'accasellasse',
    'accasellassi',
    'accasellaste',
    'accasellasti',
    'accasellata',
    'accasellate',
    'accasellati',
    'accasellato',
    'accasellava',
    'accasellavi',
    'accasellavo',
    'accasellera',
    'accasellerai',
    'accasellerei',
    'accasellero',
    'accaselli',
    'accaselliamo',
    'accaselliate',
    'accasellino',
    'accasello',
    'accasera',
    'accaserai',
    'accaseranno',
    'accaserebbe',
    'accaserei',
    'accaseremmo',
    'accaseremo',
    'accasereste',
    'accaseresti',
    'accaserete',
    'accaserma',
    'accasermai',
    'accasermammo',
    'accasermando',
    'accasermano',
    'accasermante',
    'accasermanti',
    'accasermare',
    'accasermasse',
    'accasermassi',
    'accasermaste',
    'accasermasti',
    'accasermata',
    'accasermate',
    'accasermati',
    'accasermato',
    'accasermava',
    'accasermavi',
    'accasermavo',
    'accasermera',
    'accasermerai',
    'accasermerei',
    'accasermero',
    'accasermi',
    'accasermiamo',
    'accasermiate',
    'accasermino',
    'accasermo',
    'accasero',
    'accasi',
    'accasiamo',
    'accasiamoci',
    'accasiate',
    'accasino',
    'accaso',
    'accastella',
    'accastellai',
    'accastellano',
    'accastellare',
    'accastellata',
    'accastellate',
    'accastellati',
    'accastellato',
    'accastellava',
    'accastellavi',
    'accastellavo',
    'accastellera',
    'accastellero',
    'accastelli',
    'accastellino',
    'accastello',
    'accatasta',
    'accatastai',
    'accatastammo',
    'accatastando',
    'accatastano',
    'accatastante',
    'accatastanti',
    'accatastare',
    'accatastarle',
    'accatastarli',
    'accatastasse',
    'accatastassi',
    'accatastaste',
    'accatastasti',
    'accatastata',
    'accatastate',
    'accatastati',
    'accatastato',
    'accatastava',
    'accatastavi',
    'accatastavo',
    'accatastera',
    'accatasterai',
    'accatasterei',
    'accatastero',
    'accatasti',
    'accatastiamo',
    'accatastiate',
    'accatastino',
    'accatasto',
    'accatta',
    'accattafieno',
    'accattai',
    'accattammo',
    'accattamori',
    'accattando',
    'accattano',
    'accattante',
    'accattanti',
    'accattapane',
    'accattare',
    'accattarono',
    'accattasse',
    'accattassero',
    'accattassi',
    'accattassimo',
    'accattaste',
    'accattasti',
    'accattata',
    'accattate',
    'accattati',
    'accattato',
    'accattatore',
    'accattatori',
    'accattatozzi',
    'accattatrice',
    'accattatrici',
    'accattava',
    'accattavamo',
    'accattavano',
    'accattavate',
    'accattavi',
    'accattavo',
    'accattera',
    'accatterai',
    'accatteranno',
    'accatterebbe',
    'accatterei',
    'accatteremmo',
    'accatteremo',
    'accattereste',
    'accatteresti',
    'accatterete',
    'accattero',
    'accatti',
    'accattiamo',
    'accattiate',
    'accattini',
    'accattino',
    'accattiva',
    'accattivai',
    'accattivammo',
    'accattivando',
    'accattivano',
    'accattivante',
    'accattivanti',
    'accattivarci',
    'accattivare',
    'accattivarmi',
    'accattivarsi',
    'accattivarti',
    'accattivarvi',
    'accattivasse',
    'accattivassi',
    'accattivaste',
    'accattivasti',
    'accattivata',
    'accattivate',
    'accattivati',
    'accattivato',
    'accattivava',
    'accattivavi',
    'accattivavo',
    'accattivera',
    'accattiverai',
    'accattiverei',
    'accattivero',
    'accattivi',
    'accattiviamo',
    'accattiviate',
    'accattivino',
    'accattivo',
    'accatto',
    'accattolica',
    'accattona',
    'accattonaggi',
    'accattone',
    'accattoneria',
    'accattonerie',
    'accattoni',
    'accavalca',
    'accavalcai',
    'accavalcammo',
    'accavalcando',
    'accavalcano',
    'accavalcante',
    'accavalcanti',
    'accavalcare',
    'accavalcasse',
    'accavalcassi',
    'accavalcaste',
    'accavalcasti',
    'accavalcata',
    'accavalcate',
    'accavalcati',
    'accavalcato',
    'accavalcava',
    'accavalcavi',
    'accavalcavo',
    'accavalcera',
    'accavalcerai',
    'accavalcerei',
    'accavalcero',
    'accavalchera',
    'accavalchero',
    'accavalchi',
    'accavalchino',
    'accavalci',
    'accavalcia',
    'accavalciai',
    'accavalciamo',
    'accavalciano',
    'accavalciare',
    'accavalciata',
    'accavalciate',
    'accavalciati',
    'accavalciato',
    'accavalciava',
    'accavalciavi',
    'accavalciavo',
    'accavalcino',
    'accavalcio',
    'accavalco',
    'accavalla',
    'accavallai',
    'accavallammo',
    'accavallando',
    'accavallano',
    'accavallante',
    'accavallanti',
    'accavallarci',
    'accavallare',
    'accavallarmi',
    'accavallarsi',
    'accavallarti',
    'accavallarvi',
    'accavallasse',
    'accavallassi',
    'accavallaste',
    'accavallasti',
    'accavallata',
    'accavallate',
    'accavallati',
    'accavallato',
    'accavallava',
    'accavallavi',
    'accavallavo',
    'accavallera',
    'accavallerai',
    'accavallerei',
    'accavallero',
    'accavalli',
    'accavalliamo',
    'accavalliate',
    'accavallino',
    'accavallo',
    'accavezza',
    'accavezzai',
    'accavezzammo',
    'accavezzando',
    'accavezzano',
    'accavezzante',
    'accavezzanti',
    'accavezzare',
    'accavezzasse',
    'accavezzassi',
    'accavezzaste',
    'accavezzasti',
    'accavezzata',
    'accavezzate',
    'accavezzati',
    'accavezzato',
    'accavezzava',
    'accavezzavi',
    'accavezzavo',
    'accavezzera',
    'accavezzerai',
    'accavezzerei',
    'accavezzero',
    'accavezzi',
    'accavezziamo',
    'accavezziate',
    'accavezzino',
    'accavezzo',
    'accavigli',
    'accaviglia',
    'accavigliai',
    'accavigliamo',
    'accavigliano',
    'accavigliare',
    'accavigliata',
    'accavigliate',
    'accavigliati',
    'accavigliato',
    'accavigliava',
    'accavigliavi',
    'accavigliavo',
    'accavigliera',
    'accavigliero',
    'accaviglino',
    'accaviglio',
    'acce',
    'acceca',
    'accecai',
    'accecamenti',
    'accecamento',
    'accecammo',
    'accecando',
    'accecandoci',
    'accecandola',
    'accecandole',
    'accecandoli',
    'accecandolo',
    'accecandomi',
    'accecandosi',
    'accecandoti',
    'accecandovi',
    'accecano',
    'accecante',
    'accecanti',
    'accecantisi',
    'accecarci',
    'accecare',
    'accecarla',
    'accecarle',
    'accecarli',
    'accecarlo',
    'accecarmi',
    'accecarono',
    'accecarsi',
    'accecarti',
    'accecarvi',
    'accecasse',
    'accecassero',
    'accecassi',
    'accecassimo',
    'accecaste',
    'accecasti',
    'accecata',
    'accecate',
    'accecatevi',
    'accecati',
    'accecato',
    'accecatoi',
    'accecatoio',
    'accecatomi',
    'accecatore',
    'accecatori',
    'accecatoti',
    'accecatrice',
    'accecatrici',
    'accecatura',
    'accecature',
    'accecava',
    'accecavamo',
    'accecavano',
    'accecavate',
    'accecavi',
    'accecavo',
    'accechera',
    'accecherai',
    'accecheranno',
    'accecherebbe',
    'accecherei',
    'accecheremmo',
    'accecheremo',
    'accechereste',
    'accecheresti',
    'accecherete',
    'accechero',
    'accechi',
    'accechiamo',
    'accechiamoci',
    'accechiate',
    'accechino',
    'acceco',
    'acceda',
    'accedano',
    'accede',
    'accedei',
    'accedemmo',
    'accedendo',
    'accedente',
    'accedenti',
    'accedera',
    'accederai',
    'accederanno',
    'accedere',
    'accederebbe',
    'accederei',
    'accederemmo',
    'accederemo',
    'accedereste',
    'accederesti',
    'accederete',
    'accedero',
    'accederono',
    'accedervi',
    'accedesse',
    'accedessero',
    'accedessi',
    'accedessimo',
    'accedeste',
    'accedesti',
    'accedete',
    'accedette',
    'accedettero',
    'accedetti',
    'accedeva',
    'accedevamo',
    'accedevano',
    'accedevate',
    'accedevi',
    'accedevo',
    'accedi',
    'accediamo',
    'accediate',
    'accedo',
    'accedono',
    'acceduta',
    'accedute',
    'acceduti',
    'acceduto',
    'accelera',
    'accelerai',
    'accelerammo',
    'accelerando',
    'accelerano',
    'accelerante',
    'acceleranti',
    'accelerarci',
    'accelerare',
    'accelerarmi',
    'accelerarne',
    'accelerarono',
    'accelerarsi',
    'accelerarti',
    'accelerarvi',
    'accelerasse',
    'accelerassi',
    'acceleraste',
    'accelerasti',
    'accelerata',
    'accelerate',
    'acceleratevi',
    'accelerati',
    'accelerativa',
    'accelerative',
    'accelerativi',
    'accelerativo',
    'accelerato',
    'acceleratomi',
    'acceleratore',
    'acceleratori',
    'acceleratoti',
    'accelerava',
    'acceleravamo',
    'acceleravano',
    'acceleravate',
    'acceleravi',
    'acceleravo',
    'accelerera',
    'accelererai',
    'accelererei',
    'accelereremo',
    'accelererete',
    'accelerero',
    'acceleri',
    'acceleriamo',
    'acceleriate',
    'accelerina',
    'accelerine',
    'accelerino',
    'accelero',
    'accellero',
    'accenda',
    'accendano',
    'accende',
    'accendemmo',
    'accendendo',
    'accendendoci',
    'accendendola',
    'accendendole',
    'accendendoli',
    'accendendolo',
    'accendendomi',
    'accendendosi',
    'accendendoti',
    'accendendovi',
    'accendente',
    'accendenti',
    'accendentisi',
    'accender',
    'accendera',
    'accenderai',
    'accenderanno',
    'accenderci',
    'accendere',
    'accenderebbe',
    'accenderei',
    'accenderemmo',
    'accenderemo',
    'accendereste',
    'accenderesti',
    'accenderete',
    'accenderla',
    'accenderle',
    'accenderli',
    'accenderlo',
    'accendermi',
    'accendero',
    'accendersi',
    'accenderti',
    'accendervi',
    'accendesse',
    'accendessero',
    'accendessi',
    'accendessimo',
    'accendeste',
    'accendesti',
    'accendete',
    'accendetevi',
    'accendeva',
    'accendevamo',
    'accendevano',
    'accendevate',
    'accendevi',
    'accendevo',
    'accendi',
    'accendiamo',
    'accendiamoci',
    'accendiate',
    'accendibile',
    'accendibili',
    'accendigas',
    'accendimenti',
    'accendimento',
    'accendini',
    'accendino',
    'accenditi',
    'accenditoi',
    'accenditoio',
    'accenditore',
    'accenditori',
    'accenditrice',
    'accenditrici',
    'accendo',
    'accendono',
    'accenna',
    'accennai',
    'accennammo',
    'accennando',
    'accennano',
    'accennante',
    'accennanti',
    'accennare',
    'accennarono',
    'accennasse',
    'accennassero',
    'accennassi',
    'accennassimo',
    'accennaste',
    'accennasti',
    'accennata',
    'accennate',
    'accennati',
    'accennato',
    'accennava',
    'accennavamo',
    'accennavano',
    'accennavate',
    'accennavi',
    'accennavo',
    'accennera',
    'accennerai',
    'accenneranno',
    'accennerebbe',
    'accennerei',
    'accenneremmo',
    'accenneremo',
    'accennereste',
    'accenneresti',
    'accennerete',
    'accennero',
    'accennerò',
    'accenni',
    'accenniamo',
    'accenniate',
    'accennino',
    'accenno',
    'accensa',
    'accensando',
    'accensare',
    'accensato',
    'accense',
    'accensibile',
    'accensibili',
    'accensione',
    'accensioni',
    'accenta',
    'accentai',
    'accentammo',
    'accentando',
    'accentano',
    'accentante',
    'accentanti',
    'accentare',
    'accentarono',
    'accentasse',
    'accentassero',
    'accentassi',
    'accentassimo',
    'accentaste',
    'accentasti',
    'accentata',
    'accentate',
    'accentati',
    'accentato',
    'accentatura',
    'accentature',
    'accentava',
    'accentavamo',
    'accentavano',
    'accentavate',
    'accentavi',
    'accentavo',
    'accentazione',
    'accentazioni',
    'accentera',
    'accenterai',
    'accenteranno',
    'accenterebbe',
    'accenterei',
    'accenteremmo',
    'accenteremo',
    'accentereste',
    'accenteresti',
    'accenterete',
    'accentero',
    'accenti',
    'accentiamo',
    'accentiate',
    'accentino',
    'accento',
    'accentra',
    'accentrai',
    'accentrammo',
    'accentrando',
    'accentrano',
    'accentrante',
    'accentranti',
    'accentrarci',
    'accentrare',
    'accentrarmi',
    'accentrarono',
    'accentrarsi',
    'accentrarti',
    'accentrarvi',
    'accentrasse',
    'accentrassi',
    'accentraste',
    'accentrasti',
    'accentrata',
    'accentrate',
    'accentratevi',
    'accentrati',
    'accentrato',
    'accentratomi',
    'accentratore',
    'accentratori',
    'accentratoti',
    'accentrava',
    'accentravamo',
    'accentravano',
    'accentravate',
    'accentravi',
    'accentravo',
    'accentrera',
    'accentrerai',
    'accentrerei',
    'accentreremo',
    'accentrerete',
    'accentrero',
    'accentri',
    'accentriamo',
    'accentriate',
    'accentrino',
    'accentro',
    'accentua',
    'accentuai',
    'accentuale',
    'accentuali',
    'accentuammo',
    'accentuando',
    'accentuano',
    'accentuante',
    'accentuanti',
    'accentuarci',
    'accentuare',
    'accentuarmi',
    'accentuarono',
    'accentuarsi',
    'accentuarti',
    'accentuarvi',
    'accentuasse',
    'accentuassi',
    'accentuaste',
    'accentuasti',
    'accentuata',
    'accentuate',
    'accentuatevi',
    'accentuati',
    'accentuativa',
    'accentuative',
    'accentuativi',
    'accentuativo',
    'accentuato',
    'accentuatomi',
    'accentuatoti',
    'accentuava',
    'accentuavamo',
    'accentuavano',
    'accentuavate',
    'accentuavi',
    'accentuavo',
    'accentuera',
    'accentuerai',
    'accentuerei',
    'accentueremo',
    'accentuerete',
    'accentuero',
    'accentuerà',
    'accentui',
    'accentuiamo',
    'accentuiate',
    'accentuino',
    'accentuo',
    'acceppa',
    'acceppai',
    'acceppammo',
    'acceppando',
    'acceppano',
    'acceppante',
    'acceppanti',
    'acceppare',
    'accepparono',
    'acceppasse',
    'acceppassero',
    'acceppassi',
    'acceppassimo',
    'acceppaste',
    'acceppasti',
    'acceppata',
    'acceppate',
    'acceppati',
    'acceppato',
    'acceppava',
    'acceppavamo',
    'acceppavano',
    'acceppavate',
    'acceppavi',
    'acceppavo',
    'acceppera',
    'accepperai',
    'accepperanno',
    'accepperebbe',
    'accepperei',
    'accepperemmo',
    'accepperemo',
    'acceppereste',
    'accepperesti',
    'accepperete',
    'acceppero',
    'acceppi',
    'acceppiamo',
    'acceppiate',
    'acceppino',
    'acceppo',
    'accerchi',
    'accerchia',
    'accerchiai',
    'accerchiammo',
    'accerchiamo',
    'accerchiando',
    'accerchiano',
    'accerchiante',
    'accerchianti',
    'accerchiarci',
    'accerchiare',
    'accerchiarle',
    'accerchiarli',
    'accerchiarmi',
    'accerchiarsi',
    'accerchiarti',
    'accerchiarvi',
    'accerchiasse',
    'accerchiassi',
    'accerchiaste',
    'accerchiasti',
    'accerchiata',
    'accerchiate',
    'accerchiati',
    'accerchiato',
    'accerchiava',
    'accerchiavi',
    'accerchiavo',
    'accerchiera',
    'accerchierai',
    'accerchierei',
    'accerchiero',
    'accerchino',
    'accerchio',
    'accercina',
    'accercinai',
    'accercinammo',
    'accercinando',
    'accercinano',
    'accercinante',
    'accercinanti',
    'accercinare',
    'accercinasse',
    'accercinassi',
    'accercinaste',
    'accercinasti',
    'accercinata',
    'accercinate',
    'accercinati',
    'accercinato',
    'accercinava',
    'accercinavi',
    'accercinavo',
    'accercinera',
    'accercinerai',
    'accercinerei',
    'accercinero',
    'accercini',
    'accerciniamo',
    'accerciniate',
    'accercinino',
    'accercino',
    'accerita',
    'accerite',
    'acceriti',
    'accerito',
    'accerta',
    'accertabile',
    'accertabili',
    'accertai',
    'accertamenti',
    'accertamento',
    'accertammo',
    'accertando',
    'accertandoci',
    'accertandomi',
    'accertandosi',
    'accertandoti',
    'accertandovi',
    'accertano',
    'accertante',
    'accertanti',
    'accertantisi',
    'accertar',
    'accertarci',
    'accertare',
    'accertarmi',
    'accertarono',
    'accertarsi',
    'accertarti',
    'accertarvi',
    'accertasse',
    'accertassero',
    'accertassi',
    'accertassimo',
    'accertaste',
    'accertasti',
    'accertata',
    'accertatasi',
    'accertate',
    'accertatesi',
    'accertatevi',
    'accertati',
    'accertatisi',
    'accertato',
    'accertatomi',
    'accertatore',
    'accertatori',
    'accertatosi',
    'accertatoti',
    'accertatrice',
    'accertatrici',
    'accertava',
    'accertavamo',
    'accertavano',
    'accertavate',
    'accertavi',
    'accertavo',
    'accertera',
    'accerterai',
    'accerteranno',
    'accerterebbe',
    'accerterei',
    'accerteremmo',
    'accerteremo',
    'accertereste',
    'accerteresti',
    'accerterete',
    'accertero',
    'accerti',
    'accertiamo',
    'accertiamoci',
    'accertiate',
    'accertino',
    'accerto',
    'accesa',
    'accesamente',
    'accese',
    'accesero',
    'accesi',
    'accesissimo',
    'acceso',
    'accesomi',
    'accesoti',
    'accessi',
    'accessibile',
    'accessibili',
    'accessione',
    'accessioni',
    'accesso',
    'accessori',
    'accessoria',
    'accessoriata',
    'accessoriate',
    'accessoriati',
    'accessoriato',
    'accessorie',
    'accessorieta',
    'accessorietà',
    'accessorio',
    'accessorista',
    'accessoriste',
    'accessoristi',
    'accessuale',
    'accessuali',
    'accestendo',
    'accestente',
    'accestenti',
    'accesti',
    'accestiamo',
    'accestiate',
    'accestii',
    'accestimenti',
    'accestimento',
    'accestimmo',
    'accestira',
    'accestirai',
    'accestiranno',
    'accestire',
    'accestirebbe',
    'accestirei',
    'accestiremmo',
    'accestiremo',
    'accestireste',
    'accestiresti',
    'accestirete',
    'accestiro',
    'accestirono',
    'accestisca',
    'accestiscano',
    'accestisce',
    'accestisci',
    'accestisco',
    'accestiscono',
    'accestisse',
    'accestissero',
    'accestissi',
    'accestissimo',
    'accestiste',
    'accestisti',
    'accestita',
    'accestite',
    'accestiti',
    'accestito',
    'accestiva',
    'accestivamo',
    'accestivano',
    'accestivate',
    'accestivi',
    'accestivo',
    'accetta',
    'accettabile',
    'accettabili',
    'accettai',
    'accettammo',
    'accettando',
    'accettandoci',
    'accettandola',
    'accettandole',
    'accettandoli',
    'accettandolo',
    'accettandomi',
    'accettandosi',
    'accettandoti',
    'accettandovi',
    'accettano',
    'accettante',
    'accettanti',
    'accettantisi',
    'accettanza',
    'accettanze',
    'accettarci',
    'accettare',
    'accettarla',
    'accettarle',
    'accettarli',
    'accettarlo',
    'accettarmi',
    'accettarne',
    'accettarono',
    'accettarsi',
    'accettarti',
    'accettarvi',
    'accettasse',
    'accettassero',
    'accettassi',
    'accettassimo',
    'accettaste',
    'accettasti',
    'accettata',
    'accettate',
    'accettatemi',
    'accettatevi',
    'accettati',
    'accettato',
    'accettatomi',
    'accettatore',
    'accettatori',
    'accettatoti',
    'accettava',
    'accettavamo',
    'accettavano',
    'accettavate',
    'accettavi',
    'accettavo',
    'accettazione',
    'accettazioni',
    'accette',
    'accettera',
    'accetterai',
    'accetteranno',
    'accetterebbe',
    'accetterei',
    'accetteremmo',
    'accetteremo',
    'accettereste',
    'accetteresti',
    'accetterete',
    'accettero',
    'accetterà',
    'accettevole',
    'accettevoli',
    'accetti',
    'accettiamo',
    'accettiamoci',
    'accettiate',
    'accettino',
    'accetto',
    'accettore',
    'accettori',
    'accettò',
    'accezione',
    'accezioni',
    'acche',
    'accheta',
    'acchetai',
    'acchetamenti',
    'acchetamento',
    'acchetammo',
    'acchetando',
    'acchetandoci',
    'acchetandomi',
    'acchetandosi',
    'acchetandoti',
    'acchetandovi',
    'acchetano',
    'acchetante',
    'acchetanti',
    'acchetantisi',
    'acchetarci',
    'acchetare',
    'acchetarmi',
    'acchetarono',
    'acchetarsi',
    'acchetarti',
    'acchetarvi',
    'acchetasse',
    'acchetassero',
    'acchetassi',
    'acchetassimo',
    'acchetaste',
    'acchetasti',
    'acchetata',
    'acchetate',
    'acchetatevi',
    'acchetati',
    'acchetato',
    'acchetatomi',
    'acchetatoti',
    'acchetava',
    'acchetavamo',
    'acchetavano',
    'acchetavate',
    'acchetavi',
    'acchetavo',
    'acchetera',
    'accheterai',
    'accheteranno',
    'accheterebbe',
    'accheterei',
    'accheteremmo',
    'accheteremo',
    'acchetereste',
    'accheteresti',
    'accheterete',
    'acchetero',
    'accheti',
    'acchetiamo',
    'acchetiamoci',
    'acchetiate',
    'acchetino',
    'accheto',
    'acchiappa',
    'acchiappai',
    'acchiappammo',
    'acchiappando',
    'acchiappano',
    'acchiappante',
    'acchiappanti',
    'acchiappanza',
    'acchiappanze',
    'acchiapparci',
    'acchiappare',
    'acchiapparla',
    'acchiapparmi',
    'acchiapparsi',
    'acchiapparti',
    'acchiapparvi',
    'acchiappasse',
    'acchiappassi',
    'acchiappaste',
    'acchiappasti',
    'acchiappata',
    'acchiappate',
    'acchiappati',
    'acchiappato',
    'acchiappava',
    'acchiappavi',
    'acchiappavo',
    'acchiappera',
    'acchiapperai',
    'acchiapperei',
    'acchiappero',
    'acchiappi',
    'acchiappiamo',
    'acchiappiate',
    'acchiappini',
    'acchiappino',
    'acchiappo',
    'acchiocciola',
    'acchioccioli',
    'acchiocciolo',
    'acchita',
    'acchitai',
    'acchitammo',
    'acchitando',
    'acchitandosi',
    'acchitano',
    'acchitante',
    'acchitanti',
    'acchitare',
    'acchitarono',
    'acchitarsi',
    'acchitasse',
    'acchitassero',
    'acchitassi',
    'acchitassimo',
    'acchitaste',
    'acchitasti',
    'acchitata',
    'acchitate',
    'acchitati',
    'acchitato',
    'acchitava',
    'acchitavamo',
    'acchitavano',
    'acchitavate',
    'acchitavi',
    'acchitavo',
    'acchitera',
    'acchiterai',
    'acchiteranno',
    'acchiterebbe',
    'acchiterei',
    'acchiteremmo',
    'acchiteremo',
    'acchitereste',
    'acchiteresti',
    'acchiterete',
    'acchitero',
    'acchiti',
    'acchitiamo',
    'acchitiate',
    'acchitino',
    'acchito',
    'acchitta',
    'acchittai',
    'acchittammo',
    'acchittando',
    'acchittano',
    'acchittarci',
    'acchittare',
    'acchittarmi',
    'acchittarono',
    'acchittarsi',
    'acchittarti',
    'acchittarvi',
    'acchittasse',
    'acchittassi',
    'acchittaste',
    'acchittasti',
    'acchittata',
    'acchittate',
    'acchittatevi',
    'acchittati',
    'acchittato',
    'acchittatomi',
    'acchittatoti',
    'acchittava',
    'acchittavamo',
    'acchittavano',
    'acchittavate',
    'acchittavi',
    'acchittavo',
    'acchittera',
    'acchitterai',
    'acchitterei',
    'acchitteremo',
    'acchitterete',
    'acchittero',
    'acchitti',
    'acchittiamo',
    'acchittiate',
    'acchittino',
    'acchitto',
    'acchiude',
    'acchiudendo',
    'acchiudere',
    'acchiudono',
    'acchiusa',
    'acchiuse',
    'acchiusi',
    'acchiuso',
    'acci',
    'accia',
    'acciabatta',
    'acciabattai',
    'acciabattano',
    'acciabattare',
    'acciabattata',
    'acciabattate',
    'acciabattati',
    'acciabattato',
    'acciabattava',
    'acciabattavi',
    'acciabattavo',
    'acciabattera',
    'acciabattero',
    'acciabatti',
    'acciabattii',
    'acciabattino',
    'acciabattio',
    'acciabatto',
    'acciabattona',
    'acciabattone',
    'acciabattoni',
    'acciacca',
    'acciaccai',
    'acciaccammo',
    'acciaccando',
    'acciaccano',
    'acciaccante',
    'acciaccanti',
    'acciaccare',
    'acciaccarono',
    'acciaccasse',
    'acciaccassi',
    'acciaccaste',
    'acciaccasti',
    'acciaccata',
    'acciaccate',
    'acciaccati',
    'acciaccato',
    'acciaccatura',
    'acciaccature',
    'acciaccava',
    'acciaccavamo',
    'acciaccavano',
    'acciaccavate',
    'acciaccavi',
    'acciaccavo',
    'acciacchera',
    'acciaccherai',
    'acciaccherei',
    'acciacchero',
    'acciacchi',
    'acciacchiamo',
    'acciacchiate',
    'acciacchino',
    'acciacco',
    'acciaccosa',
    'acciaccose',
    'acciaccosi',
    'acciaccoso',
    'acciai',
    'acciaia',
    'acciaiai',
    'acciaiammo',
    'acciaiamo',
    'acciaiando',
    'acciaiano',
    'acciaiante',
    'acciaianti',
    'acciaiare',
    'acciaiarono',
    'acciaiasse',
    'acciaiassero',
    'acciaiassi',
    'acciaiassimo',
    'acciaiaste',
    'acciaiasti',
    'acciaiata',
    'acciaiate',
    'acciaiati',
    'acciaiato',
    'acciaiatura',
    'acciaiature',
    'acciaiava',
    'acciaiavamo',
    'acciaiavano',
    'acciaiavate',
    'acciaiavi',
    'acciaiavo',
    'acciaiera',
    'acciaierai',
    'acciaieranno',
    'acciaierebbe',
    'acciaierei',
    'acciaieremmo',
    'acciaieremo',
    'acciaiereste',
    'acciaieresti',
    'acciaierete',
    'acciaieria',
    'acciaierie',
    'acciaiero',
    'acciaini',
    'acciaino',
    'acciaio',
    'acciaioli',
    'acciaiolo',
    'acciaiuolo',
    'acciambella',
    'acciambellai',
    'acciambelli',
    'acciambello',
    'acciari',
    'acciarini',
    'acciarino',
    'acciarita',
    'acciarite',
    'acciariti',
    'acciarito',
    'acciaro',
    'acciarpa',
    'acciarpando',
    'acciarpano',
    'acciarpante',
    'acciarpare',
    'acciarparono',
    'acciarpato',
    'acciarpatura',
    'acciarpature',
    'acciarpava',
    'acciarpavano',
    'acciarpii',
    'acciarpio',
    'acciarpo',
    'acciarpona',
    'acciarpone',
    'acciarponi',
    'accidempoli',
    'accidentale',
    'accidentali',
    'accidentata',
    'accidentate',
    'accidentati',
    'accidentato',
    'accidente',
    'accidenti',
    'acciderba',
    'accidia',
    'accidie',
    'accidiosa',
    'accidiose',
    'accidiosi',
    'accidioso',
    'accieca',
    'acciecano',
    'acciecare',
    'acciecatore',
    'acciecatura',
    'acciechi',
    'acciechino',
    'accieco',
    'accigli',
    'acciglia',
    'accigliai',
    'accigliammo',
    'accigliamo',
    'accigliamoci',
    'accigliando',
    'accigliano',
    'accigliante',
    'acciglianti',
    'accigliarci',
    'accigliare',
    'accigliarmi',
    'accigliarono',
    'accigliarsi',
    'accigliarti',
    'accigliarvi',
    'accigliasse',
    'accigliassi',
    'accigliaste',
    'accigliasti',
    'accigliata',
    'accigliate',
    'accigliatevi',
    'accigliati',
    'accigliato',
    'accigliatomi',
    'accigliatoti',
    'accigliatura',
    'accigliature',
    'accigliava',
    'accigliavamo',
    'accigliavano',
    'accigliavate',
    'accigliavi',
    'accigliavo',
    'accigliera',
    'acciglierai',
    'acciglierei',
    'acciglieremo',
    'acciglierete',
    'accigliero',
    'acciglino',
    'acciglio',
    'accigliona',
    'acciglionano',
    'acciglionare',
    'acciglionata',
    'acciglionate',
    'acciglionati',
    'acciglionato',
    'accignere',
    'accincignare',
    'accinga',
    'accingano',
    'accinge',
    'accingemmo',
    'accingendo',
    'accingendoci',
    'accingendomi',
    'accingendosi',
    'accingendoti',
    'accingendovi',
    'accingente',
    'accingenti',
    'accingentisi',
    'accingera',
    'accingerai',
    'accingeranno',
    'accingerci',
    'accingere',
    'accingerebbe',
    'accingerei',
    'accingeremmo',
    'accingeremo',
    'accingereste',
    'accingeresti',
    'accingerete',
    'accingermi',
    'accingero',
    'accingersi',
    'accingerti',
    'accingervi',
    'accingesse',
    'accingessero',
    'accingessi',
    'accingessimo',
    'accingeste',
    'accingesti',
    'accingete',
    'accingetevi',
    'accingeva',
    'accingevamo',
    'accingevano',
    'accingevate',
    'accingevi',
    'accingevo',
    'accingi',
    'accingiamo',
    'accingiamoci',
    'accingiate',
    'accingiti',
    'accingo',
    'accingono',
    'accinse',
    'accinsero',
    'accinsi',
    'accinta',
    'accinte',
    'accinti',
    'accinto',
    'accintola',
    'accintolai',
    'accintolammo',
    'accintolando',
    'accintolano',
    'accintolante',
    'accintolanti',
    'accintolare',
    'accintolasse',
    'accintolassi',
    'accintolaste',
    'accintolasti',
    'accintolata',
    'accintolate',
    'accintolati',
    'accintolato',
    'accintolava',
    'accintolavi',
    'accintolavo',
    'accintolera',
    'accintolerai',
    'accintolerei',
    'accintolero',
    'accintoli',
    'accintoliamo',
    'accintoliate',
    'accintolino',
    'accintolo',
    'accintomi',
    'accintoti',
    'accio',
    'acciocche',
    'acciocchendo',
    'acciocchente',
    'acciocchenti',
    'acciocchi',
    'acciocchiamo',
    'acciocchiate',
    'acciocchii',
    'acciocchimmo',
    'acciocchira',
    'acciocchirai',
    'acciocchire',
    'acciocchirei',
    'acciocchiro',
    'acciocchisca',
    'acciocchisce',
    'acciocchisci',
    'acciocchisco',
    'acciocchisse',
    'acciocchissi',
    'acciocchiste',
    'acciocchisti',
    'acciocchita',
    'acciocchite',
    'acciocchiti',
    'acciocchito',
    'acciocchiva',
    'acciocchivi',
    'acciocchivo',
    'acciocché',
    'accioche',
    'acciono',
    'acciottola',
    'acciottolai',
    'acciottolano',
    'acciottolare',
    'acciottolata',
    'acciottolate',
    'acciottolati',
    'acciottolato',
    'acciottolava',
    'acciottolavi',
    'acciottolavo',
    'acciottolera',
    'acciottolero',
    'acciottoli',
    'acciottolii',
    'acciottolino',
    'acciottolio',
    'acciottolo',
    'accipicchia',
    'accipigli',
    'accipiglia',
    'accipigliai',
    'accipigliamo',
    'accipigliano',
    'accipigliare',
    'accipigliata',
    'accipigliate',
    'accipigliati',
    'accipigliato',
    'accipigliava',
    'accipigliavi',
    'accipigliavo',
    'accipigliera',
    'accipigliero',
    'accipiglino',
    'accipiglio',
    'accipitride',
    'accipitridi',
    'accisa',
    'accise',
    'accisma',
    'accismando',
    'accismare',
    'accismato',
    'acciucchendo',
    'acciucchire',
    'acciucchisce',
    'acciucchita',
    'acciucchite',
    'acciucchiti',
    'acciucchito',
    'acciucchiva',
    'acciuffa',
    'acciuffai',
    'acciuffalo',
    'acciuffammo',
    'acciuffando',
    'acciuffano',
    'acciuffante',
    'acciuffanti',
    'acciuffarci',
    'acciuffare',
    'acciuffarla',
    'acciuffarle',
    'acciuffarli',
    'acciuffarlo',
    'acciuffarmi',
    'acciuffarono',
    'acciuffarsi',
    'acciuffarti',
    'acciuffarvi',
    'acciuffasse',
    'acciuffassi',
    'acciuffaste',
    'acciuffasti',
    'acciuffata',
    'acciuffate',
    'acciuffatelo',
    'acciuffatevi',
    'acciuffati',
    'acciuffato',
    'acciuffatomi',
    'acciuffatoti',
    'acciuffava',
    'acciuffavamo',
    'acciuffavano',
    'acciuffavate',
    'acciuffavi',
    'acciuffavo',
    'acciuffera',
    'acciufferai',
    'acciufferei',
    'acciufferemo',
    'acciufferete',
    'acciuffero',
    'acciuffi',
    'acciuffiamo',
    'acciuffiate',
    'acciuffino',
    'acciuffo',
    'acciuga',
    'acciugata',
    'acciugate',
    'acciughe',
    'acciugheri',
    'acciughero',
    'acciughetta',
    'acciughette',
    'acciughina',
    'acciughine',
    'accivetta',
    'accivettai',
    'accivettammo',
    'accivettando',
    'accivettano',
    'accivettante',
    'accivettanti',
    'accivettare',
    'accivettasse',
    'accivettassi',
    'accivettaste',
    'accivettasti',
    'accivettata',
    'accivettate',
    'accivettati',
    'accivettato',
    'accivettava',
    'accivettavi',
    'accivettavo',
    'accivettera',
    'accivetterai',
    'accivetterei',
    'accivettero',
    'accivetti',
    'accivettiamo',
    'accivettiate',
    'accivettino',
    'accivetto',
    'acclama',
    'acclamai',
    'acclamammo',
    'acclamando',
    'acclamandola',
    'acclamandolo',
    'acclamano',
    'acclamante',
    'acclamanti',
    'acclamare',
    'acclamarla',
    'acclamarlo',
    'acclamarono',
    'acclamasse',
    'acclamassero',
    'acclamassi',
    'acclamassimo',
    'acclamaste',
    'acclamasti',
    'acclamata',
    'acclamate',
    'acclamati',
    'acclamato',
    'acclamatore',
    'acclamatori',
    'acclamatrice',
    'acclamatrici',
    'acclamava',
    'acclamavamo',
    'acclamavano',
    'acclamavate',
    'acclamavi',
    'acclamavo',
    'acclamazione',
    'acclamazioni',
    'acclamera',
    'acclamerai',
    'acclameranno',
    'acclamerebbe',
    'acclamerei',
    'acclameremmo',
    'acclameremo',
    'acclamereste',
    'acclameresti',
    'acclamerete',
    'acclamero',
    'acclami',
    'acclamiamo',
    'acclamiate',
    'acclamino',
    'acclamo',
    'acclara',
    'acclarai',
    'acclarammo',
    'acclarando',
    'acclarano',
    'acclarante',
    'acclaranti',
    'acclarare',
    'acclararono',
    'acclararsi',
    'acclarasse',
    'acclarassero',
    'acclarassi',
    'acclarassimo',
    'acclaraste',
    'acclarasti',
    'acclarata',
    'acclarate',
    'acclarati',
    'acclarato',
    'acclarava',
    'acclaravamo',
    'acclaravano',
    'acclaravate',
    'acclaravi',
    'acclaravo',
    'acclarera',
    'acclarerai',
    'acclareranno',
    'acclarerebbe',
    'acclarerei',
    'acclareremmo',
    'acclareremo',
    'acclarereste',
    'acclareresti',
    'acclarerete',
    'acclarero',
    'acclari',
    'acclariamo',
    'acclariate',
    'acclarino',
    'acclaro',
    'acclima',
    'acclimai',
    'acclimamenti',
    'acclimamento',
    'acclimammo',
    'acclimando',
    'acclimano',
    'acclimante',
    'acclimanti',
    'acclimare',
    'acclimarono',
    'acclimasse',
    'acclimassero',
    'acclimassi',
    'acclimassimo',
    'acclimaste',
    'acclimasti',
    'acclimata',
    'acclimatai',
    'acclimatammo',
    'acclimatando',
    'acclimatano',
    'acclimatante',
    'acclimatanti',
    'acclimatarci',
    'acclimatare',
    'acclimatarmi',
    'acclimatarsi',
    'acclimatarti',
    'acclimatarvi',
    'acclimatasse',
    'acclimatassi',
    'acclimataste',
    'acclimatasti',
    'acclimatata',
    'acclimatate',
    'acclimatati',
    'acclimatato',
    'acclimatava',
    'acclimatavi',
    'acclimatavo',
    'acclimate',
    'acclimatera',
    'acclimaterai',
    'acclimaterei',
    'acclimatero',
    'acclimati',
    'acclimatiamo',
    'acclimatiate',
    'acclimatino',
    'acclimato',
    'acclimatore',
    'acclimatori',
    'acclimatrice',
    'acclimatrici',
    'acclimava',
    'acclimavamo',
    'acclimavano',
    'acclimavate',
    'acclimavi',
    'acclimavo',
    'acclimazione',
    'acclimazioni',
    'acclimera',
    'acclimerai',
    'acclimeranno',
    'acclimerebbe',
    'acclimerei',
    'acclimeremmo',
    'acclimeremo',
    'acclimereste',
    'acclimeresti',
    'acclimerete',
    'acclimero',
    'acclimi',
    'acclimiamo',
    'acclimiate',
    'acclimino',
    'acclimo',
    'accline',
    'acclini',
    'acclino',
    'acclive',
    'acclivi',
    'acclivita',
    'accluda',
    'accludano',
    'acclude',
    'accludemmo',
    'accludendo',
    'accludente',
    'accludenti',
    'accludera',
    'accluderai',
    'accluderanno',
    'accludere',
    'accluderebbe',
    'accluderei',
    'accluderemmo',
    'accluderemo',
    'accludereste',
    'accluderesti',
    'accluderete',
    'accluderla',
    'accludero',
    'accludesse',
    'accludessero',
    'accludessi',
    'accludessimo',
    'accludeste',
    'accludesti',
    'accludete',
    'accludeva',
    'accludevamo',
    'accludevano',
    'accludevate',
    'accludevi',
    'accludevo',
    'accludi',
    'accludiamo',
    'accludiate',
    'accludo',
    'accludono',
    'acclusa',
    'accluse',
    'acclusero',
    'acclusi',
    'accluso',
    'accocca',
    'accoccai',
    'accoccammo',
    'accoccando',
    'accoccano',
    'accoccante',
    'accoccanti',
    'accoccare',
    'accoccarono',
    'accoccasse',
    'accoccassero',
    'accoccassi',
    'accoccassimo',
    'accoccaste',
    'accoccasti',
    'accoccata',
    'accoccate',
    'accoccati',
    'accoccato',
    'accoccava',
    'accoccavamo',
    'accoccavano',
    'accoccavate',
    'accoccavi',
    'accoccavo',
    'accocchera',
    'accoccherai',
    'accoccherei',
    'accoccheremo',
    'accoccherete',
    'accocchero',
    'accocchi',
    'accocchiamo',
    'accocchiate',
    'accocchino',
    'accocco',
    'accoccola',
    'accoccolai',
    'accoccolammo',
    'accoccolando',
    'accoccolano',
    'accoccolarci',
    'accoccolare',
    'accoccolarmi',
    'accoccolarsi',
    'accoccolarti',
    'accoccolarvi',
    'accoccolasse',
    'accoccolassi',
    'accoccolaste',
    'accoccolasti',
    'accoccolata',
    'accoccolate',
    'accoccolati',
    'accoccolato',
    'accoccolava',
    'accoccolavi',
    'accoccolavo',
    'accoccolera',
    'accoccolerai',
    'accoccolerei',
    'accoccolero',
    'accoccoli',
    'accoccoliamo',
    'accoccoliate',
    'accoccolino',
    'accoccolo',
    'accoda',
    'accodai',
    'accodamenti',
    'accodamento',
    'accodammo',
    'accodando',
    'accodandoci',
    'accodandomi',
    'accodandosi',
    'accodandoti',
    'accodandovi',
    'accodano',
    'accodante',
    'accodanti',
    'accodantisi',
    'accodarci',
    'accodare',
    'accodarmi',
    'accodarono',
    'accodarsi',
    'accodarti',
    'accodarvi',
    'accodasse',
    'accodassero',
    'accodassi',
    'accodassimo',
    'accodaste',
    'accodasti',
    'accodata',
    'accodate',
    'accodatevi',
    'accodati',
    'accodato',
    'accodatomi',
    'accodatoti',
    'accodatura',
    'accodava',
    'accodavamo',
    'accodavano',
    'accodavate',
    'accodavi',
    'accodavo',
    'accodera',
    'accoderai',
    'accoderanno',
    'accoderebbe',
    'accoderei',
    'accoderemmo',
    'accoderemo',
    'accodereste',
    'accoderesti',
    'accoderete',
    'accodero',
    'accodi',
    'accodiamo',
    'accodiamoci',
    'accodiate',
    'accodino',
    'accodo',
    'accogli',
    'accogliamo',
    'accogliamoci',
    'accogliate',
    'accoglibile',
    'accoglie',
    'accogliemmo',
    'accogliendo',
    'accogliente',
    'accoglienti',
    'accoglienza',
    'accoglienze',
    'accogliera',
    'accoglierai',
    'accoglierci',
    'accogliere',
    'accoglierei',
    'accoglieremo',
    'accoglierete',
    'accoglierla',
    'accoglierle',
    'accoglierli',
    'accoglierlo',
    'accogliermi',
    'accogliero',
    'accogliersi',
    'accoglierti',
    'accogliervi',
    'accoglierà',
    'accogliesse',
    'accogliessi',
    'accoglieste',
    'accogliesti',
    'accogliete',
    'accoglietevi',
    'accoglieva',
    'accoglievamo',
    'accoglievano',
    'accoglievate',
    'accoglievi',
    'accoglievo',
    'accoglimenti',
    'accoglimento',
    'accogliti',
    'accogliticce',
    'accogliticci',
    'accoglitore',
    'accoglitori',
    'accoglitrice',
    'accoglitrici',
    'accolga',
    'accolgano',
    'accolgo',
    'accolgono',
    'accolita',
    'accolitati',
    'accolitato',
    'accolite',
    'accoliti',
    'accolito',
    'accolla',
    'accollai',
    'accollamenti',
    'accollamento',
    'accollammo',
    'accollando',
    'accollandoci',
    'accollandomi',
    'accollandosi',
    'accollandoti',
    'accollandovi',
    'accollano',
    'accollante',
    'accollanti',
    'accollantisi',
    'accollarci',
    'accollare',
    'accollarmi',
    'accollarono',
    'accollarsi',
    'accollarti',
    'accollarvi',
    'accollasse',
    'accollassero',
    'accollassi',
    'accollassimo',
    'accollaste',
    'accollasti',
    'accollata',
    'accollatari',
    'accollataria',
    'accollatarie',
    'accollatario',
    'accollate',
    'accollatevi',
    'accollati',
    'accollato',
    'accollatomi',
    'accollatore',
    'accollatori',
    'accollatoti',
    'accollatrice',
    'accollatrici',
    'accollatura',
    'accollature',
    'accollava',
    'accollavamo',
    'accollavano',
    'accollavate',
    'accollavi',
    'accollavo',
    'accollera',
    'accollerai',
    'accolleranno',
    'accollerebbe',
    'accollerei',
    'accolleremmo',
    'accolleremo',
    'accollereste',
    'accolleresti',
    'accollerete',
    'accollero',
    'accolli',
    'accolliamo',
    'accolliamoci',
    'accolliate',
    'accollino',
    'accollo',
    'accolse',
    'accolsero',
    'accolsi',
    'accolta',
    'accolte',
    'accoltela',
    'accoltelai',
    'accolteli',
    'accoltella',
    'accoltellai',
    'accoltellano',
    'accoltellare',
    'accoltellata',
    'accoltellate',
    'accoltellati',
    'accoltellato',
    'accoltellava',
    'accoltellavi',
    'accoltellavo',
    'accoltellera',
    'accoltellero',
    'accoltelli',
    'accoltellino',
    'accoltello',
    'accoltelo',
    'accolti',
    'accolto',
    'accoltomi',
    'accoltoti',
    'accomadatevi',
    'accomanda',
    'accomandai',
    'accomandammo',
    'accomandando',
    'accomandano',
    'accomandante',
    'accomandanti',
    'accomandare',
    'accomandasse',
    'accomandassi',
    'accomandaste',
    'accomandasti',
    'accomandata',
    'accomandate',
    'accomandati',
    'accomandato',
    'accomandava',
    'accomandavi',
    'accomandavo',
    'accomandera',
    'accomanderai',
    'accomanderei',
    'accomandero',
    'accomandi',
    'accomandiamo',
    'accomandiate',
    'accomandige',
    'accomandigia',
    'accomandigie',
    'accomandino',
    'accomandita',
    'accomandite',
    'accomando',
    'accomandola',
    'accomandolai',
    'accomandoli',
    'accomandolo',
    'accombente',
    'accomiata',
    'accomiatai',
    'accomiatammo',
    'accomiatando',
    'accomiatano',
    'accomiatante',
    'accomiatanti',
    'accomiatarci',
    'accomiatare',
    'accomiatarmi',
    'accomiatarsi',
    'accomiatarti',
    'accomiatarvi',
    'accomiatasse',
    'accomiatassi',
    'accomiataste',
    'accomiatasti',
    'accomiatata',
    'accomiatate',
    'accomiatati',
    'accomiatato',
    'accomiatava',
    'accomiatavi',
    'accomiatavo',
    'accomiatera',
    'accomiaterai',
    'accomiaterei',
    'accomiatero',
    'accomiati',
    'accomiatiamo',
    'accomiatiate',
    'accomiatino',
    'accomiato',
    'accomiatò',
    'accommiata',
    'accommiatai',
    'accommiatano',
    'accommiatare',
    'accommiatata',
    'accommiatate',
    'accommiatati',
    'accommiatato',
    'accommiatava',
    'accommiatavi',
    'accommiatavo',
    'accommiatera',
    'accommiatero',
    'accommiati',
    'accommiatino',
    'accommiato',
    'accomoda',
    'accomodabile',
    'accomodabili',
    'accomodai',
    'accomodammo',
    'accomodando',
    'accomodano',
    'accomodante',
    'accomodanti',
    'accomodarci',
    'accomodare',
    'accomodarmi',
    'accomodarono',
    'accomodarsi',
    'accomodarti',
    'accomodarvi',
    'accomodasse',
    'accomodassi',
    'accomodaste',
    'accomodasti',
    'accomodata',
    'accomodate',
    'accomodatemi',
    'accomodatevi',
    'accomodati',
    'accomodativa',
    'accomodative',
    'accomodativi',
    'accomodativo',
    'accomodato',
    'accomodatomi',
    'accomodatora',
    'accomodatore',
    'accomodatori',
    'accomodatoti',
    'accomodatura',
    'accomodature',
    'accomodava',
    'accomodavamo',
    'accomodavano',
    'accomodavate',
    'accomodavi',
    'accomodavo',
    'accomodera',
    'accomoderai',
    'accomoderei',
    'accomoderemo',
    'accomoderete',
    'accomodero',
    'accomodi',
    'accomodiamo',
    'accomodiate',
    'accomodino',
    'accomodo',
    'accompagna',
    'accompagnai',
    'accompagnano',
    'accompagnare',
    'accompagnata',
    'accompagnate',
    'accompagnati',
    'accompagnato',
    'accompagnava',
    'accompagnavi',
    'accompagnavo',
    'accompagnera',
    'accompagnero',
    'accompagni',
    'accompagnino',
    'accompagno',
    'accomuna',
    'accomunabile',
    'accomunabili',
    'accomunai',
    'accomunammo',
    'accomunando',
    'accomunano',
    'accomunante',
    'accomunanti',
    'accomunarci',
    'accomunare',
    'accomunarmi',
    'accomunarono',
    'accomunarsi',
    'accomunarti',
    'accomunarvi',
    'accomunasse',
    'accomunassi',
    'accomunaste',
    'accomunasti',
    'accomunata',
    'accomunate',
    'accomunatevi',
    'accomunati',
    'accomunato',
    'accomunatomi',
    'accomunatoti',
    'accomunava',
    'accomunavamo',
    'accomunavano',
    'accomunavate',
    'accomunavi',
    'accomunavo',
    'accomunera',
    'accomunerai',
    'accomunerei',
    'accomuneremo',
    'accomunerete',
    'accomunero',
    'accomuni',
    'accomuniamo',
    'accomuniate',
    'accomunino',
    'accomuno',
    'acconce',
    'acconcera',
    'acconcerai',
    'acconceranno',
    'acconcerebbe',
    'acconcerei',
    'acconceremmo',
    'acconceremo',
    'acconcereste',
    'acconceresti',
    'acconcerete',
    'acconcero',
    'acconci',
    'acconcia',
    'acconciabile',
    'acconciabili',
    'acconciai',
    'acconciammo',
    'acconciamo',
    'acconciamoci',
    'acconciando',
    'acconciano',
    'acconciante',
    'acconcianti',
    'acconciarci',
    'acconciare',
    'acconciarmi',
    'acconciarono',
    'acconciarsi',
    'acconciarti',
    'acconciarvi',
    'acconciasse',
    'acconciassi',
    'acconciaste',
    'acconciasti',
    'acconciata',
    'acconciate',
    'acconciatevi',
    'acconciati',
    'acconciato',
    'acconciatomi',
    'acconciatore',
    'acconciatori',
    'acconciatoti',
    'acconciatura',
    'acconciature',
    'acconciava',
    'acconciavamo',
    'acconciavano',
    'acconciavate',
    'acconciavi',
    'acconciavo',
    'acconcie',
    'acconcino',
    'acconcio',
    'accondiscesa',
    'accondiscese',
    'accondiscesi',
    'accondisceso',
    'accone',
    'acconi',
    'acconigli',
    'acconiglia',
    'acconigliano',
    'acconigliare',
    'acconigliata',
    'acconigliate',
    'acconigliati',
    'acconigliato',
    'acconigliava',
    'acconiglino',
    'acconiglio',
    'acconsenta',
    'acconsentano',
    'acconsente',
    'acconsenti',
    'acconsentii',
    'acconsentira',
    'acconsentire',
    'acconsentiro',
    'acconsentita',
    'acconsentite',
    'acconsentiti',
    'acconsentito',
    'acconsentiva',
    'acconsentivi',
    'acconsentivo',
    'acconsento',
    'acconsentono',
    'accontamenti',
    'accontamento',
    'accontandosi',
    'accontarsi',
    'accontata',
    'accontate',
    'accontati',
    'accontato',
    'accontenta',
    'accontentai',
    'accontentano',
    'accontentare',
    'accontentata',
    'accontentate',
    'accontentati',
    'accontentato',
    'accontentava',
    'accontentavi',
    'accontentavo',
    'accontentera',
    'accontentero',
    'accontenti',
    'accontentino',
    'accontento',
    'acconti',
    'acconto',
    'accoppa',
    'accoppai',
    'accoppammo',
    'accoppando',
    'accoppandoci',
    'accoppandomi',
    'accoppandosi',
    'accoppandoti',
    'accoppandovi',
    'accoppano',
    'accoppante',
    'accoppanti',
    'accoppantisi',
    'accopparci',
    'accoppare',
    'accopparmi',
    'accopparono',
    'accopparsi',
    'accopparti',
    'accopparvi',
    'accoppasse',
    'accoppassero',
    'accoppassi',
    'accoppassimo',
    'accoppaste',
    'accoppasti',
    'accoppata',
    'accoppate',
    'accoppatevi',
    'accoppati',
    'accoppato',
    'accoppatomi',
    'accoppatoti',
    'accoppava',
    'accoppavamo',
    'accoppavano',
    'accoppavate',
    'accoppavi',
    'accoppavo',
    'accoppera',
    'accopperai',
    'accopperanno',
    'accopperebbe',
    'accopperei',
    'accopperemmo',
    'accopperemo',
    'accoppereste',
    'accopperesti',
    'accopperete',
    'accoppero',
    'accoppi',
    'accoppia',
    'accoppiabile',
    'accoppiabili',
    'accoppiai',
    'accoppiammo',
    'accoppiamo',
    'accoppiamoci',
    'accoppiando',
    'accoppiano',
    'accoppiante',
    'accoppianti',
    'accoppiarci',
    'accoppiare',
    'accoppiarmi',
    'accoppiarono',
    'accoppiarsi',
    'accoppiarti',
    'accoppiarvi',
    'accoppiasse',
    'accoppiassi',
    'accoppiaste',
    'accoppiasti',
    'accoppiata',
    'accoppiate',
    'accoppiatevi',
    'accoppiati',
    'accoppiato',
    'accoppiatoi',
    'accoppiatoio',
    'accoppiatomi',
    'accoppiatore',
    'accoppiatori',
    'accoppiatoti',
    'accoppiatura',
    'accoppiature',
    'accoppiava',
    'accoppiavamo',
    'accoppiavano',
    'accoppiavate',
    'accoppiavi',
    'accoppiavo',
    'accoppiera',
    'accoppierai',
    'accoppierei',
    'accoppieremo',
    'accoppierete',
    'accoppiero',
    'accoppino',
    'accoppio',
    'accoppo',
    'accora',
    'accorai',
    'accoramenti',
    'accoramento',
    'accorammo',
    'accorando',
    'accorandoci',
    'accorandomi',
    'accorandosi',
    'accorandoti',
    'accorandovi',
    'accorano',
    'accorante',
    'accoranti',
    'accorantisi',
    'accorarci',
    'accorare',
    'accorarmi',
    'accorarono',
    'accorarsi',
    'accorarti',
    'accorarvi',
    'accorasse',
    'accorassero',
    'accorassi',
    'accorassimo',
    'accoraste',
    'accorasti',
    'accorata',
    'accorate',
    'accoratevi',
    'accoratezza',
    'accoratezze',
    'accorati',
    'accorato',
    'accoratoi',
    'accoratoio',
    'accoratomi',
    'accoratoti',
    'accorava',
    'accoravamo',
    'accoravano',
    'accoravate',
    'accoravi',
    'accoravo',
    'accorazione',
    'accorazioni',
    'accorcera',
    'accorcerai',
    'accorceranno',
    'accorcerebbe',
    'accorcerei',
    'accorceremmo',
    'accorceremo',
    'accorcereste',
    'accorceresti',
    'accorcerete',
    'accorcero',
    'accorci',
    'accorcia',
    'accorciabile',
    'accorciabili',
    'accorciai',
    'accorciammo',
    'accorciamo',
    'accorciando',
    'accorciano',
    'accorciante',
    'accorcianti',
    'accorciare',
    'accorciarla',
    'accorciarle',
    'accorciarli',
    'accorciarlo',
    'accorciarono',
    'accorciarsi',
    'accorciasse',
    'accorciassi',
    'accorciaste',
    'accorciasti',
    'accorciata',
    'accorciate',
    'accorciati',
    'accorciativa',
    'accorciative',
    'accorciativi',
    'accorciativo',
    'accorciato',
    'accorciatoia',
    'accorciatoie',
    'accorciatura',
    'accorciature',
    'accorciava',
    'accorciavamo',
    'accorciavano',
    'accorciavate',
    'accorciavi',
    'accorciavo',
    'accorcino',
    'accorcio',
    'accorda',
    'accordabile',
    'accordabili',
    'accordai',
    'accordamenti',
    'accordamento',
    'accordammo',
    'accordando',
    'accordandoci',
    'accordandomi',
    'accordandosi',
    'accordandoti',
    'accordandovi',
    'accordano',
    'accordante',
    'accordanti',
    'accordantisi',
    'accordarci',
    'accordare',
    'accordarmi',
    'accordarono',
    'accordarsi',
    'accordarti',
    'accordarvi',
    'accordasse',
    'accordassero',
    'accordassi',
    'accordassimo',
    'accordaste',
    'accordasti',
    'accordata',
    'accordate',
    'accordategli',
    'accordatevi',
    'accordati',
    'accordato',
    'accordatomi',
    'accordatore',
    'accordatori',
    'accordatoti',
    'accordatrice',
    'accordatrici',
    'accordatura',
    'accordature',
    'accordava',
    'accordavamo',
    'accordavano',
    'accordavate',
    'accordavi',
    'accordavo',
    'accordella',
    'accordellai',
    'accordellano',
    'accordellare',
    'accordellata',
    'accordellate',
    'accordellati',
    'accordellato',
    'accordellava',
    'accordellavi',
    'accordellavo',
    'accordellera',
    'accordellero',
    'accordelli',
    'accordellino',
    'accordello',
    'accordeon',
    'accordera',
    'accorderai',
    'accorderanno',
    'accorderebbe',
    'accorderei',
    'accorderemmo',
    'accorderemo',
    'accordereste',
    'accorderesti',
    'accorderete',
    'accordero',
    'accordi',
    'accordiamo',
    'accordiamoci',
    'accordiate',
    'accordii',
    'accordino',
    'accordio',
    'accordo',
    'accorera',
    'accorerai',
    'accoreranno',
    'accorerebbe',
    'accorerei',
    'accoreremmo',
    'accoreremo',
    'accorereste',
    'accoreresti',
    'accorerete',
    'accorero',
    'accorga',
    'accorgano',
    'accorge',
    'accorgemmo',
    'accorgendo',
    'accorgendoci',
    'accorgendomi',
    'accorgendosi',
    'accorgendoti',
    'accorgendovi',
    'accorgente',
    'accorgentesi',
    'accorgentisi',
    'accorgera',
    'accorgerai',
    'accorgeranno',
    'accorgercene',
    'accorgerci',
    'accorgere',
    'accorgerebbe',
    'accorgerei',
    'accorgeremmo',
    'accorgeremo',
    'accorgereste',
    'accorgeresti',
    'accorgerete',
    'accorgermi',
    'accorgero',
    'accorgersene',
    'accorgersi',
    'accorgerti',
    'accorgervi',
    'accorgesse',
    'accorgessero',
    'accorgessi',
    'accorgessimo',
    'accorgeste',
    'accorgesti',
    'accorgete',
    'accorgetevi',
    'accorgeva',
    'accorgevamo',
    'accorgevano',
    'accorgevate',
    'accorgevi',
    'accorgevo',
    'accorgi',
    'accorgiamo',
    'accorgiamoci',
    'accorgiate',
    'accorgimenti',
    'accorgimento',
    'accorgiti',
    'accorgo',
    'accorgono',
    'accori',
    'accoriamo',
    'accoriamoci',
    'accoriate',
    'accorino',
    'accoro',
    'accorpa',
    'accorpai',
    'accorpamenti',
    'accorpamento',
    'accorpammo',
    'accorpando',
    'accorpano',
    'accorpante',
    'accorpanti',
    'accorpare',
    'accorparono',
    'accorpasse',
    'accorpassero',
    'accorpassi',
    'accorpassimo',
    'accorpaste',
    'accorpasti',
    'accorpata',
    'accorpate',
    'accorpati',
    'accorpato',
    'accorpava',
    'accorpavamo',
    'accorpavano',
    'accorpavate',
    'accorpavi',
    'accorpavo',
    'accorpera',
    'accorperai',
    'accorperanno',
    'accorperebbe',
    'accorperei',
    'accorperemmo',
    'accorperemo',
    'accorpereste',
    'accorperesti',
    'accorperete',
    'accorpero',
    'accorpi',
    'accorpiamo',
    'accorpiate',
    'accorpino',
    'accorpo',
    'accorra',
    'accorrano',
    'accorre',
    'accorremmo',
    'accorrendo',
    'accorrente',
    'accorrenti',
    'accorrera',
    'accorrerai',
    'accorreranno',
    'accorrere',
    'accorrerebbe',
    'accorrerei',
    'accorreremmo',
    'accorreremo',
    'accorrereste',
    'accorreresti',
    'accorrerete',
    'accorrero',
    'accorrervi',
    'accorresse',
    'accorressero',
    'accorressi',
    'accorressimo',
    'accorreste',
    'accorresti',
    'accorrete',
    'accorreva',
    'accorrevamo',
    'accorrevano',
    'accorrevate',
    'accorrevi',
    'accorrevo',
    'accorri',
    'accorriamo',
    'accorriate',
    'accorro',
    'accorrono',
    'accorruomo',
    'accorsa',
    'accorsata',
    'accorsate',
    'accorsati',
    'accorsato',
    'accorse',
    'accorsero',
    'accorsi',
    'accorso',
    'accorta',
    'accortamente',
    'accorte',
    'accortezza',
    'accortezze',
    'accorti',
    'accorto',
    'accortomi',
    'accortosi',
    'accortoti',
    'accoscera',
    'accoscerai',
    'accosceranno',
    'accoscerebbe',
    'accoscerei',
    'accosceremmo',
    'accosceremo',
    'accoscereste',
    'accosceresti',
    'accoscerete',
    'accoscero',
    'accosci',
    'accoscia',
    'accosciai',
    'accosciammo',
    'accosciamo',
    'accosciamoci',
    'accosciando',
    'accosciano',
    'accosciante',
    'accosciarci',
    'accosciare',
    'accosciarmi',
    'accosciarono',
    'accosciarsi',
    'accosciarti',
    'accosciarvi',
    'accosciasse',
    'accosciassi',
    'accosciaste',
    'accosciasti',
    'accosciata',
    'accosciate',
    'accosciatevi',
    'accosciati',
    'accosciato',
    'accosciatomi',
    'accosciatoti',
    'accosciava',
    'accosciavamo',
    'accosciavano',
    'accosciavate',
    'accosciavi',
    'accosciavo',
    'accoscino',
    'accoscio',
    'accosta',
    'accostabile',
    'accostabili',
    'accostai',
    'accostamenti',
    'accostamento',
    'accostammo',
    'accostando',
    'accostandoci',
    'accostandomi',
    'accostandosi',
    'accostandoti',
    'accostandovi',
    'accostano',
    'accostante',
    'accostanti',
    'accostantisi',
    'accostarci',
    'accostare',
    'accostarlo',
    'accostarmi',
    'accostarono',
    'accostarsele',
    'accostarsi',
    'accostarti',
    'accostarvi',
    'accostasse',
    'accostassero',
    'accostassi',
    'accostassimo',
    'accostaste',
    'accostasti',
    'accostata',
    'accostate',
    'accostatevi',
    'accostati',
    'accostato',
    'accostatomi',
    'accostatoti',
    'accostatura',
    'accostature',
    'accostava',
    'accostavamo',
    'accostavano',
    'accostavate',
    'accostavi',
    'accostavo',
    'accoste',
    'accostera',
    'accosterai',
    'accosteranno',
    'accosterebbe',
    'accosterei',
    'accosteremmo',
    'accosteremo',
    'accostereste',
    'accosteresti',
    'accosterete',
    'accostero',
    'accostevole',
    'accostevoli',
    'accosti',
    'accostiamo',
    'accostiamoci',
    'accostiate',
    'accostino',
    'accosto',
    'accostola',
    'accostolai',
    'accostolammo',
    'accostolando',
    'accostolano',
    'accostolante',
    'accostolanti',
    'accostolare',
    'accostolasse',
    'accostolassi',
    'accostolaste',
    'accostolasti',
    'accostolata',
    'accostolate',
    'accostolati',
    'accostolato',
    'accostolava',
    'accostolavi',
    'accostolavo',
    'accostolera',
    'accostolerai',
    'accostolerei',
    'accostolero',
    'accostoli',
    'accostoliamo',
    'accostoliate',
    'accostolino',
    'accostolo',
    'accostuma',
    'accostumai',
    'accostumammo',
    'accostumando',
    'accostumano',
    'accostumante',
    'accostumanti',
    'accostumarci',
    'accostumare',
    'accostumarmi',
    'accostumarsi',
    'accostumarti',
    'accostumarvi',
    'accostumasse',
    'accostumassi',
    'accostumaste',
    'accostumasti',
    'accostumata',
    'accostumate',
    'accostumati',
    'accostumato',
    'accostumava',
    'accostumavi',
    'accostumavo',
    'accostumera',
    'accostumerai',
    'accostumerei',
    'accostumero',
    'accostumi',
    'accostumiamo',
    'accostumiate',
    'accostumino',
    'accostumo',
    'accotona',
    'accotonai',
    'accotonammo',
    'accotonando',
    'accotonano',
    'accotonante',
    'accotonanti',
    'accotonare',
    'accotonarono',
    'accotonasse',
    'accotonassi',
    'accotonaste',
    'accotonasti',
    'accotonata',
    'accotonate',
    'accotonati',
    'accotonato',
    'accotonatore',
    'accotonatori',
    'accotonatura',
    'accotonature',
    'accotonava',
    'accotonavamo',
    'accotonavano',
    'accotonavate',
    'accotonavi',
    'accotonavo',
    'accotonera',
    'accotonerai',
    'accotonerei',
    'accotoneremo',
    'accotonerete',
    'accotonero',
    'accotoni',
    'accotoniamo',
    'accotoniate',
    'accotonino',
    'accotono',
    'accottima',
    'accottimai',
    'accottimammo',
    'accottimando',
    'accottimano',
    'accottimante',
    'accottimanti',
    'accottimare',
    'accottimasse',
    'accottimassi',
    'accottimaste',
    'accottimasti',
    'accottimata',
    'accottimate',
    'accottimati',
    'accottimato',
    'accottimava',
    'accottimavi',
    'accottimavo',
    'accottimera',
    'accottimerai',
    'accottimerei',
    'accottimero',
    'accottimi',
    'accottimiamo',
    'accottimiate',
    'accottimino',
    'accottimo',
    'account',
    'accovaccera',
    'accovaccerai',
    'accovaccerei',
    'accovaccero',
    'accovacci',
    'accovaccia',
    'accovacciai',
    'accovacciamo',
    'accovacciano',
    'accovacciare',
    'accovacciata',
    'accovacciate',
    'accovacciati',
    'accovacciato',
    'accovacciava',
    'accovacciavi',
    'accovacciavo',
    'accovaccino',
    'accovaccio',
    'accovona',
    'accovonai',
    'accovonammo',
    'accovonando',
    'accovonano',
    'accovonante',
    'accovonanti',
    'accovonare',
    'accovonarono',
    'accovonasse',
    'accovonassi',
    'accovonaste',
    'accovonasti',
    'accovonata',
    'accovonate',
    'accovonati',
    'accovonato',
    'accovonatore',
    'accovonatori',
    'accovonava',
    'accovonavamo',
    'accovonavano',
    'accovonavate',
    'accovonavi',
    'accovonavo',
    'accovonera',
    'accovonerai',
    'accovonerei',
    'accovoneremo',
    'accovonerete',
    'accovonero',
    'accovoni',
    'accovoniamo',
    'accovoniate',
    'accovonino',
    'accovono',
    'accozza',
    'accozzabile',
    'accozzabili',
    'accozzaglia',
    'accozzaglie',
    'accozzai',
    'accozzamenti',
    'accozzamento',
    'accozzammo',
    'accozzando',
    'accozzandoci',
    'accozzandomi',
    'accozzandosi',
    'accozzandoti',
    'accozzandovi',
    'accozzano',
    'accozzante',
    'accozzanti',
    'accozzantisi',
    'accozzarci',
    'accozzare',
    'accozzarmi',
    'accozzarono',
    'accozzarsi',
    'accozzarti',
    'accozzarvi',
    'accozzasse',
    'accozzassero',
    'accozzassi',
    'accozzassimo',
    'accozzaste',
    'accozzasti',
    'accozzata',
    'accozzate',
    'accozzatevi',
    'accozzati',
    'accozzaticce',
    'accozzaticci',
    'accozzato',
    'accozzatomi',
    'accozzatore',
    'accozzatori',
    'accozzatoti',
    'accozzatrice',
    'accozzatrici',
    'accozzava',
    'accozzavamo',
    'accozzavano',
    'accozzavate',
    'accozzavi',
    'accozzavo',
    'accozzera',
    'accozzerai',
    'accozzeranno',
    'accozzerebbe',
    'accozzerei',
    'accozzeremmo',
    'accozzeremo',
    'accozzereste',
    'accozzeresti',
    'accozzerete',
    'accozzero',
    'accozzi',
    'accozziamo',
    'accozziamoci',
    'accozziate',
    'accozzino',
    'accozzo',
    'accrebbe',
    'accrebbero',
    'accrebbi',
    'accredita',
    'accreditai',
    'accreditammo',
    'accreditando',
    'accreditano',
    'accreditante',
    'accreditanti',
    'accreditarci',
    'accreditare',
    'accreditari',
    'accreditaria',
    'accreditarie',
    'accreditario',
    'accreditarla',
    'accreditarle',
    'accreditarli',
    'accreditarlo',
    'accreditarmi',
    'accreditarsi',
    'accreditarti',
    'accreditarvi',
    'accreditasse',
    'accreditassi',
    'accreditaste',
    'accreditasti',
    'accreditata',
    'accreditate',
    'accreditati',
    'accreditato',
    'accreditava',
    'accreditavi',
    'accreditavo',
    'accreditera',
    'accrediterai',
    'accrediterei',
    'accreditero',
    'accrediti',
    'accreditiamo',
    'accreditiate',
    'accreditino',
    'accredito',
    'accreditò',
    'accresca',
    'accrescano',
    'accresce',
    'accrescemmo',
    'accrescendo',
    'accrescente',
    'accrescenti',
    'accrescera',
    'accrescerai',
    'accrescerci',
    'accrescere',
    'accrescerei',
    'accresceremo',
    'accrescerete',
    'accrescerla',
    'accrescermi',
    'accrescero',
    'accrescersi',
    'accrescerti',
    'accrescervi',
    'accrescesse',
    'accrescessi',
    'accresceste',
    'accrescesti',
    'accrescete',
    'accrescetevi',
    'accresceva',
    'accrescevamo',
    'accrescevano',
    'accrescevate',
    'accrescevi',
    'accrescevo',
    'accresci',
    'accresciamo',
    'accresciate',
    'accresciti',
    'accrescitiva',
    'accrescitive',
    'accrescitivi',
    'accrescitivo',
    'accrescitore',
    'accrescitori',
    'accresciuta',
    'accresciute',
    'accresciuti',
    'accresciuto',
    'accresco',
    'accrescono',
    'accrespa',
    'accrespai',
    'accrespammo',
    'accrespando',
    'accrespano',
    'accrespante',
    'accrespanti',
    'accrespare',
    'accresparono',
    'accrespasse',
    'accrespassi',
    'accrespaste',
    'accrespasti',
    'accrespata',
    'accrespate',
    'accrespati',
    'accrespato',
    'accrespatura',
    'accrespature',
    'accrespava',
    'accrespavamo',
    'accrespavano',
    'accrespavate',
    'accrespavi',
    'accrespavo',
    'accrespera',
    'accresperai',
    'accresperei',
    'accresperemo',
    'accresperete',
    'accrespero',
    'accrespi',
    'accrespiamo',
    'accrespiate',
    'accrespino',
    'accrespo',
    'accreta',
    'accrezione',
    'accrezioni',
    'accrocca',
    'accroccai',
    'accroccammo',
    'accroccando',
    'accroccano',
    'accroccante',
    'accroccanti',
    'accroccare',
    'accroccarono',
    'accroccasse',
    'accroccassi',
    'accroccaste',
    'accroccasti',
    'accroccata',
    'accroccate',
    'accroccati',
    'accroccato',
    'accroccava',
    'accroccavamo',
    'accroccavano',
    'accroccavate',
    'accroccavi',
    'accroccavo',
    'accrocchera',
    'accroccherai',
    'accroccherei',
    'accrocchero',
    'accrocchi',
    'accrocchiamo',
    'accrocchiate',
    'accrocchino',
    'accrocco',
    'accrochage',
    'accrochages',
    'accubiti',
    'accubito',
    'accuccera',
    'accuccerai',
    'accucceranno',
    'accuccerebbe',
    'accuccerei',
    'accucceremmo',
    'accucceremo',
    'accuccereste',
    'accucceresti',
    'accuccerete',
    'accuccero',
    'accucci',
    'accuccia',
    'accucciai',
    'accucciammo',
    'accucciamo',
    'accucciamoci',
    'accucciando',
    'accucciano',
    'accucciante',
    'accucciarci',
    'accucciare',
    'accucciarmi',
    'accucciarono',
    'accucciarsi',
    'accucciarti',
    'accucciarvi',
    'accucciasse',
    'accucciassi',
    'accucciaste',
    'accucciasti',
    'accucciata',
    'accucciate',
    'accucciatevi',
    'accucciati',
    'accucciato',
    'accucciatomi',
    'accucciatoti',
    'accucciava',
    'accucciavamo',
    'accucciavano',
    'accucciavate',
    'accucciavi',
    'accucciavo',
    'accuccino',
    'accuccio',
    'accucciola',
    'accucciolai',
    'accucciolano',
    'accucciolare',
    'accucciolata',
    'accucciolate',
    'accucciolati',
    'accucciolato',
    'accucciolava',
    'accucciolavi',
    'accucciolavo',
    'accucciolera',
    'accucciolero',
    'accuccioli',
    'accucciolino',
    'accucciolo',
    'accudendo',
    'accudente',
    'accudenti',
    'accudi',
    'accudiamo',
    'accudiate',
    'accudii',
    'accudimmo',
    'accudira',
    'accudirai',
    'accudiranno',
    'accudire',
    'accudirebbe',
    'accudirei',
    'accudiremmo',
    'accudiremo',
    'accudireste',
    'accudiresti',
    'accudirete',
    'accudiro',
    'accudirono',
    'accudisca',
    'accudiscano',
    'accudisce',
    'accudisci',
    'accudisco',
    'accudiscono',
    'accudisse',
    'accudissero',
    'accudissi',
    'accudissimo',
    'accudiste',
    'accudisti',
    'accudita',
    'accudite',
    'accuditi',
    'accudito',
    'accudiva',
    'accudivamo',
    'accudivano',
    'accudivate',
    'accudivi',
    'accudivo',
    'accula',
    'acculai',
    'acculamenti',
    'acculamento',
    'acculammo',
    'acculando',
    'acculandoci',
    'acculandomi',
    'acculandosi',
    'acculandoti',
    'acculandovi',
    'acculano',
    'acculante',
    'acculanti',
    'acculantisi',
    'accularci',
    'acculare',
    'accularmi',
    'accularono',
    'accularsi',
    'accularti',
    'accularvi',
    'acculasse',
    'acculassero',
    'acculassi',
    'acculassimo',
    'acculaste',
    'acculasti',
    'acculata',
    'acculate',
    'acculatevi',
    'acculati',
    'acculato',
    'acculatomi',
    'acculatoti',
    'acculatta',
    'acculattai',
    'acculattammo',
    'acculattando',
    'acculattano',
    'acculattante',
    'acculattanti',
    'acculattare',
    'acculattasse',
    'acculattassi',
    'acculattaste',
    'acculattasti',
    'acculattata',
    'acculattate',
    'acculattati',
    'acculattato',
    'acculattava',
    'acculattavi',
    'acculattavo',
    'acculattera',
    'acculatterai',
    'acculatterei',
    'acculattero',
    'acculatti',
    'acculattiamo',
    'acculattiate',
    'acculattino',
    'acculatto',
    'acculava',
    'acculavamo',
    'acculavano',
    'acculavate',
    'acculavi',
    'acculavo',
    'acculera',
    'acculerai',
    'acculeranno',
    'acculerebbe',
    'acculerei',
    'acculeremmo',
    'acculeremo',
    'acculereste',
    'acculeresti',
    'acculerete',
    'acculero',
    'acculi',
    'acculiamo',
    'acculiamoci',
    'acculiate',
    'acculino',
    'acculo',
    'accultura',
    'acculturai',
    'acculturammo',
    'acculturando',
    'acculturano',
    'acculturante',
    'acculturanti',
    'acculturarci',
    'acculturare',
    'acculturarmi',
    'acculturarsi',
    'acculturarti',
    'acculturarvi',
    'acculturasse',
    'acculturassi',
    'acculturaste',
    'acculturasti',
    'acculturata',
    'acculturate',
    'acculturati',
    'acculturato',
    'acculturava',
    'acculturavi',
    'acculturavo',
    'acculturera',
    'acculturerai',
    'acculturerei',
    'acculturero',
    'acculturi',
    'acculturiamo',
    'acculturiate',
    'acculturino',
    'acculturo',
    'accumula',
    'accumulabile',
    'accumulabili',
    'accumulai',
    'accumulammo',
    'accumulando',
    'accumulano',
    'accumulante',
    'accumulanti',
    'accumularci',
    'accumulare',
    'accumularmi',
    'accumularono',
    'accumularsi',
    'accumularti',
    'accumularvi',
    'accumulasse',
    'accumulassi',
    'accumulaste',
    'accumulasti',
    'accumulata',
    'accumulate',
    'accumulateli',
    'accumulatevi',
    'accumulati',
    'accumulativa',
    'accumulativo',
    'accumulato',
    'accumulatomi',
    'accumulatore',
    'accumulatori',
    'accumulatoti',
    'accumulava',
    'accumulavamo',
    'accumulavano',
    'accumulavate',
    'accumulavi',
    'accumulavo',
    'accumulera',
    'accumulerai',
    'accumulerei',
    'accumuleremo',
    'accumulerete',
    'accumulero',
    'accumuli',
    'accumuliamo',
    'accumuliate',
    'accumulino',
    'accumulo',
    'accurando',
    'accurare',
    'accurarsi',
    'accurata',
    'accurate',
    'accuratezza',
    'accuratezze',
    'accurati',
    'accurato',
    'accursa',
    'accursia',
    'accursio',
    'accurso',
    'accusa',
    'accusabile',
    'accusabili',
    'accusabilita',
    'accusai',
    'accusammo',
    'accusando',
    'accusandoci',
    'accusandola',
    'accusandole',
    'accusandoli',
    'accusandolo',
    'accusandomi',
    'accusandosi',
    'accusandoti',
    'accusandovi',
    'accusano',
    'accusante',
    'accusanti',
    'accusantisi',
    'accusarci',
    'accusare',
    'accusarla',
    'accusarle',
    'accusarli',
    'accusarlo',
    'accusarmi',
    'accusarono',
    'accusarsene',
    'accusarsi',
    'accusarti',
    'accusarvi',
    'accusasse',
    'accusassero',
    'accusassi',
    'accusassimo',
    'accusaste',
    'accusasti',
    'accusata',
    'accusate',
    'accusatevi',
    'accusati',
    'accusativa',
    'accusative',
    'accusativi',
    'accusativo',
    'accusato',
    'accusatomi',
    'accusatore',
    'accusatori',
    'accusatoria',
    'accusatorie',
    'accusatorio',
    'accusatoti',
    'accusatrice',
    'accusatrici',
    'accusava',
    'accusavamo',
    'accusavano',
    'accusavate',
    'accusavi',
    'accusavo',
    'accuse',
    'accusera',
    'accuserai',
    'accuseranno',
    'accuserebbe',
    'accuserei',
    'accuseremmo',
    'accuseremo',
    'accusereste',
    'accuseresti',
    'accuserete',
    'accusero',
    'accusi',
    'accusiamo',
    'accusiamoci',
    'accusiate',
    'accusino',
    'accuso',
    'acedia',
    'acedie',
    'acee',
    'acefala',
    'acefale',
    'acefali',
    'acefalia',
    'acefalie',
    'acefalo',
    'acellulare',
    'acellulari',
    'acelomati',
    'acelomato',
    'acentrata',
    'acentrate',
    'acentrati',
    'acentrato',
    'acentrica',
    'acentriche',
    'acentrici',
    'acentrico',
    'aceracea',
    'aceracee',
    'aceraia',
    'aceraie',
    'acerba',
    'acerbamente',
    'acerbe',
    'acerbezza',
    'acerbezze',
    'acerbi',
    'acerbissima',
    'acerbissimo',
    'acerbita',
    'acerbità',
    'acerbo',
    'acerenza',
    'acereta',
    'acerete',
    'acereti',
    'acereto',
    'aceri',
    'acero',
    'acerosa',
    'acerose',
    'acerosi',
    'aceroso',
    'acerra',
    'acerre',
    'acerrima',
    'acerrime',
    'acerrimi',
    'acerrimo',
    'acervi',
    'acervo',
    'acervoli',
    'acervolo',
    'acervuli',
    'acervulo',
    'acesa',
    'acescente',
    'acescenti',
    'acescenza',
    'acescenze',
    'acese',
    'acesi',
    'aceso',
    'aceta',
    'acetabolare',
    'acetabolari',
    'acetaboli',
    'acetabolo',
    'acetabularia',
    'acetabularie',
    'acetabuli',
    'acetabulo',
    'acetai',
    'acetaldeide',
    'acetaldeidi',
    'acetale',
    'acetali',
    'acetammide',
    'acetammidi',
    'acetammo',
    'acetando',
    'acetano',
    'acetante',
    'acetanti',
    'acetare',
    'acetarono',
    'acetasse',
    'acetassero',
    'acetassi',
    'acetassimo',
    'acetaste',
    'acetasti',
    'acetata',
    'acetate',
    'acetati',
    'acetato',
    'acetava',
    'acetavamo',
    'acetavano',
    'acetavate',
    'acetavi',
    'acetavo',
    'acetendo',
    'acetente',
    'acetenti',
    'acetera',
    'aceterai',
    'aceteranno',
    'aceterebbe',
    'aceterebbero',
    'aceterei',
    'aceteremmo',
    'aceteremo',
    'acetereste',
    'aceteresti',
    'aceterete',
    'acetero',
    'aceti',
    'acetiamo',
    'acetiate',
    'acetica',
    'acetiche',
    'acetici',
    'acetico',
    'acetifica',
    'acetificai',
    'acetificammo',
    'acetificando',
    'acetificano',
    'acetificante',
    'acetificanti',
    'acetificare',
    'acetificasse',
    'acetificassi',
    'acetificaste',
    'acetificasti',
    'acetificata',
    'acetificate',
    'acetificati',
    'acetificato',
    'acetificava',
    'acetificavi',
    'acetificavo',
    'acetifichera',
    'acetifichero',
    'acetifichi',
    'acetifichino',
    'acetifici',
    'acetificio',
    'acetifico',
    'acetii',
    'acetil',
    'acetila',
    'acetilai',
    'acetilammo',
    'acetilando',
    'acetilano',
    'acetilante',
    'acetilanti',
    'acetilare',
    'acetilarono',
    'acetilasse',
    'acetilassero',
    'acetilassi',
    'acetilassimo',
    'acetilaste',
    'acetilasti',
    'acetilata',
    'acetilate',
    'acetilati',
    'acetilato',
    'acetilava',
    'acetilavamo',
    'acetilavano',
    'acetilavate',
    'acetilavi',
    'acetilavo',
    'acetilazione',
    'acetilazioni',
    'acetilcolina',
    'acetilcoline',
    'acetile',
    'acetilene',
    'acetileni',
    'acetilenica',
    'acetileniche',
    'acetilenici',
    'acetilenico',
    'acetilera',
    'acetilerai',
    'acetileranno',
    'acetilerebbe',
    'acetilerei',
    'acetileremmo',
    'acetileremo',
    'acetilereste',
    'acetileresti',
    'acetilerete',
    'acetilero',
    'acetili',
    'acetiliamo',
    'acetiliate',
    'acetilica',
    'acetiliche',
    'acetilici',
    'acetilico',
    'acetilino',
    'acetilo',
    'acetiluri',
    'acetiluro',
    'acetimetri',
    'acetimetria',
    'acetimetro',
    'acetimmo',
    'acetina',
    'acetine',
    'acetini',
    'acetino',
    'acetira',
    'acetirai',
    'acetiranno',
    'acetire',
    'acetirebbe',
    'acetirebbero',
    'acetirei',
    'acetiremmo',
    'acetiremo',
    'acetireste',
    'acetiresti',
    'acetirete',
    'acetiro',
    'acetirono',
    'acetisca',
    'acetiscano',
    'acetisce',
    'acetisci',
    'acetisco',
    'acetiscono',
    'acetisse',
    'acetissero',
    'acetissi',
    'acetissimo',
    'acetiste',
    'acetisti',
    'acetita',
    'acetite',
    'acetiti',
    'acetito',
    'acetiva',
    'acetivamo',
    'acetivano',
    'acetivate',
    'acetivi',
    'acetivo',
    'aceto',
    'acetobacter',
    'acetobatteri',
    'acetone',
    'acetonemia',
    'acetonemica',
    'acetonemiche',
    'acetonemici',
    'acetonemico',
    'acetonemie',
    'acetoni',
    'acetonica',
    'acetoniche',
    'acetonici',
    'acetonico',
    'acetonuria',
    'acetonurie',
    'acetosa',
    'acetose',
    'acetosella',
    'acetoselle',
    'acetosi',
    'acetosita',
    'acetosità',
    'acetoso',
    'achea',
    'achee',
    'achei',
    'acheilia',
    'acheilie',
    'achelia',
    'achelie',
    'acheni',
    'achenio',
    'acheo',
    'acheronte',
    'acherontea',
    'acherontee',
    'acherontei',
    'acheronteo',
    'acheronti',
    'acherontica',
    'acherontiche',
    'acherontici',
    'acherontico',
    'acheronzia',
    'acheronzie',
    'acheropita',
    'acheropite',
    'acheropiti',
    'acheruntina',
    'acheruntine',
    'acheruntini',
    'acheruntino',
    'acherusi',
    'acherusia',
    'acherusie',
    'acherusio',
    'acheul',
    'acheulana',
    'acheulane',
    'acheulani',
    'acheulano',
    'acheuleana',
    'acheuleane',
    'acheuleani',
    'acheuleano',
    'achilia',
    'achilie',
    'achilla',
    'achille',
    'achillea',
    'achillee',
    'achillei',
    'achilleo',
    'achillina',
    'achiria',
    'achirie',
    'achiropita',
    'achiurgia',
    'achiurgie',
    'achiva',
    'achive',
    'achivi',
    'achivo',
    'acholeplasma',
    'aciatici',
    'aciclica',
    'acicliche',
    'aciclici',
    'aciclico',
    'acicolare',
    'acicolari',
    'acicula',
    'aciculare',
    'aciculari',
    'acicule',
    'acid',
    'acida',
    'acidamente',
    'acidari',
    'acidario',
    'acidaro',
    'acide',
    'acidetta',
    'acidette',
    'acidetti',
    'acidetto',
    'acidezza',
    'acidezze',
    'acidi',
    'acidifica',
    'acidificai',
    'acidificammo',
    'acidificando',
    'acidificano',
    'acidificante',
    'acidificanti',
    'acidificare',
    'acidificasse',
    'acidificassi',
    'acidificaste',
    'acidificasti',
    'acidificata',
    'acidificate',
    'acidificati',
    'acidificato',
    'acidificava',
    'acidificavi',
    'acidificavo',
    'acidifichera',
    'acidifichero',
    'acidifichi',
    'acidifichino',
    'acidifico',
    'acidimetri',
    'acidimetria',
    'acidimetrie',
    'acidimetro',
    'acidina',
    'acidine',
    'acidini',
    'acidino',
    'acidita',
    'acidità',
    'acido',
    'acidofila',
    'acidofile',
    'acidofili',
    'acidofilo',
    'acidolisi',
    'acidolo',
    'acidophilus',
    'acidosi',
    'acidula',
    'acidulai',
    'acidulammo',
    'acidulando',
    'acidulano',
    'acidulante',
    'acidulanti',
    'acidulare',
    'acidularono',
    'acidulasse',
    'acidulassero',
    'acidulassi',
    'acidulassimo',
    'acidulaste',
    'acidulasti',
    'acidulata',
    'acidulate',
    'acidulati',
    'acidulato',
    'acidulava',
    'acidulavamo',
    'acidulavano',
    'acidulavate',
    'acidulavi',
    'acidulavo',
    'acidule',
    'acidulera',
    'acidulerai',
    'aciduleranno',
    'acidulerebbe',
    'acidulerei',
    'aciduleremmo',
    'aciduleremo',
    'acidulereste',
    'aciduleresti',
    'acidulerete',
    'acidulero',
    'aciduli',
    'aciduliamo',
    'aciduliate',
    'acidulino',
    'acidulo',
    'acidume',
    'acidumi',
    'aciduria',
    'acidurie',
    'acifilla',
    'acifille',
    'acifilli',
    'acifillo',
    'acilazione',
    'acile',
    'acili',
    'acilia',
    'acilica',
    'aciliche',
    'acilici',
    'acilico',
    'acilio',
    'acinace',
    'acinaci',
    'acinellatura',
    'acinellature',
    'acinelli',
    'acinello',
    'acinesia',
    'acinesie',
    'acineti',
    'acinetica',
    'acinetiche',
    'acinetici',
    'acinetico',
    'acineto',
    'acini',
    'aciniforme',
    'aciniformi',
    'acino',
    'acinosa',
    'acinose',
    'acinosi',
    'acinoso',
    'acireale',
    'acirologia',
    'acirologica',
    'acirologiche',
    'acirologici',
    'acirologico',
    'acirologie',
    'aclamidata',
    'aclamidate',
    'aclamidati',
    'aclamidato',
    'aclamide',
    'aclamidi',
    'aclassismi',
    'aclassismo',
    'aclassista',
    'aclassiste',
    'aclassisti',
    'aclassistica',
    'aclassistici',
    'aclassistico',
    'acline',
    'aclini',
    'aclista',
    'acliste',
    'aclisti',
    'aclistica',
    'aclistiche',
    'aclistici',
    'aclistico',
    'acloridria',
    'acloridrie',
    'aclorurata',
    'aclorurate',
    'aclorurati',
    'aclorurato',
    'acme',
    'acmi',
    'acmonital',
    'acne',
    'acneica',
    'acneiche',
    'acneici',
    'acneico',
    'acneiformi',
    'acnes',
    'acni',
    'acolia',
    'acolica',
    'acoliche',
    'acolici',
    'acolico',
    'acolie',
    'acolito',
    'acomunista',
    'acomuniste',
    'acomunisti',
    'aconcettuale',
    'aconcettuali',
    'aconiti',
    'aconitina',
    'aconitine',
    'aconito',
    'aconzi',
    'aconzio',
    'acori',
    'acoria',
    'acorie',
    'acoro',
    'acotiledone',
    'acotiledoni',
    'acqua',
    'acquacce',
    'acquaccia',
    'acquacedrata',
    'acquacedrate',
    'acquacicli',
    'acquaciclo',
    'acquacoltore',
    'acquacoltori',
    'acquacoltura',
    'acquacolture',
    'acquaforte',
    'acquaforti',
    'acquai',
    'acquaia',
    'acquaie',
    'acquaio',
    'acquaiola',
    'acquaiole',
    'acquaioli',
    'acquaiolo',
    'acquaiuolo',
    'acquamanile',
    'acquamanili',
    'acquamarina',
    'acquametria',
    'acquametrie',
    'acquammo',
    'acquanauta',
    'acquanaute',
    'acquanauti',
    'acquando',
    'acquano',
    'acquante',
    'acquanti',
    'acquapark',
    'acquaplani',
    'acquaplano',
    'acquarage',
    'acquaragia',
    'acquaragie',
    'acquare',
    'acquarella',
    'acquarellai',
    'acquarellano',
    'acquarellare',
    'acquarellata',
    'acquarellate',
    'acquarellati',
    'acquarellato',
    'acquarellava',
    'acquarellavi',
    'acquarellavo',
    'acquarelle',
    'acquarellera',
    'acquarellero',
    'acquarelli',
    'acquarellino',
    'acquarello',
    'acquari',
    'acquario',
    'acquariofila',
    'acquariofile',
    'acquariofili',
    'acquariofilo',
    'acquarono',
    'acquartiera',
    'acquartierai',
    'acquartieri',
    'acquartiero',
    'acquasanta',
    'acquasante',
    'acquascivoli',
    'acquascivolo',
    'acquaseriana',
    'acquaseriane',
    'acquaseriani',
    'acquaseriano',
    'acquasse',
    'acquassero',
    'acquassi',
    'acquassimo',
    'acquaste',
    'acquasti',
    'acquastrina',
    'acquastrine',
    'acquastrini',
    'acquastrino',
    'acquata',
    'acquate',
    'acquati',
    'acquatica',
    'acquatiche',
    'acquatici',
    'acquaticita',
    'acquatico',
    'acquatile',
    'acquatili',
    'acquatinta',
    'acquatinte',
    'acquato',
    'acquatta',
    'acquattai',
    'acquattammo',
    'acquattando',
    'acquattano',
    'acquattante',
    'acquattanti',
    'acquattarci',
    'acquattare',
    'acquattarmi',
    'acquattarono',
    'acquattarsi',
    'acquattarti',
    'acquattarvi',
    'acquattasse',
    'acquattassi',
    'acquattaste',
    'acquattasti',
    'acquattata',
    'acquattate',
    'acquattatevi',
    'acquattati',
    'acquattato',
    'acquattatomi',
    'acquattatoti',
    'acquattava',
    'acquattavamo',
    'acquattavano',
    'acquattavate',
    'acquattavi',
    'acquattavo',
    'acquattera',
    'acquatterai',
    'acquatterei',
    'acquatteremo',
    'acquatterete',
    'acquattero',
    'acquatti',
    'acquattiamo',
    'acquattiate',
    'acquattino',
    'acquatto',
    'acquava',
    'acquavamo',
    'acquavano',
    'acquavate',
    'acquavi',
    'acquavitai',
    'acquavitaio',
    'acquavite',
    'acquaviti',
    'acquavo',
    'acquazzone',
    'acquazzoni',
    'acque',
    'acquea',
    'acquecedrate',
    'acquedotti',
    'acquedotto',
    'acquee',
    'acqueforti',
    'acquei',
    'acquemarine',
    'acqueo',
    'acquera',
    'acquerai',
    'acqueranno',
    'acquerebbe',
    'acquerebbero',
    'acquerei',
    'acquerella',
    'acquerellai',
    'acquerellano',
    'acquerellare',
    'acquerellata',
    'acquerellate',
    'acquerellati',
    'acquerellato',
    'acquerellava',
    'acquerellavi',
    'acquerellavo',
    'acquerelle',
    'acquerellera',
    'acquerellero',
    'acquerelli',
    'acquerellino',
    'acquerello',
    'acqueremmo',
    'acqueremo',
    'acquereste',
    'acqueresti',
    'acquerete',
    'acquero',
    'acquerugiola',
    'acquerugiole',
    'acquesante',
    'acquese',
    'acquesi',
    'acquetando',
    'acquetandosi',
    'acquetare',
    'acquetarsi',
    'acquetata',
    'acquetate',
    'acquetati',
    'acquetato',
    'acquetinte',
    'acquetta',
    'acquette',
    'acqueviti',
    'acqui',
    'acquiamo',
    'acquiate',
    'acquicola',
    'acquicole',
    'acquicoli',
    'acquicolo',
    'acquicoltore',
    'acquicoltori',
    'acquicoltura',
    'acquicolture',
    'acquida',
    'acquide',
    'acquido',
    'acquidocci',
    'acquidoccio',
    'acquidosa',
    'acquidose',
    'acquidosi',
    'acquidoso',
    'acquidotti',
    'acquidotto',
    'acquiebbe',
    'acquiebbero',
    'acquiebbi',
    'acquiesca',
    'acquiescano',
    'acquiesce',
    'acquiescemmo',
    'acquiescendo',
    'acquiescente',
    'acquiescenti',
    'acquiescenza',
    'acquiescenze',
    'acquiescera',
    'acquiescerai',
    'acquiescere',
    'acquiescerei',
    'acquiescero',
    'acquiescesse',
    'acquiescessi',
    'acquiesceste',
    'acquiescesti',
    'acquiescete',
    'acquiesceva',
    'acquiescevi',
    'acquiescevo',
    'acquiesci',
    'acquiesciamo',
    'acquiesciate',
    'acquiesciuta',
    'acquiesciute',
    'acquiesciuti',
    'acquiesciuto',
    'acquiesco',
    'acquiescono',
    'acquieta',
    'acquietai',
    'acquietammo',
    'acquietando',
    'acquietano',
    'acquietante',
    'acquietanti',
    'acquietarci',
    'acquietare',
    'acquietarmi',
    'acquietarono',
    'acquietarsi',
    'acquietarti',
    'acquietarvi',
    'acquietasse',
    'acquietassi',
    'acquietaste',
    'acquietasti',
    'acquietata',
    'acquietate',
    'acquietatevi',
    'acquietati',
    'acquietato',
    'acquietatomi',
    'acquietatoti',
    'acquietava',
    'acquietavamo',
    'acquietavano',
    'acquietavate',
    'acquietavi',
    'acquietavo',
    'acquietera',
    'acquieterai',
    'acquieterei',
    'acquieteremo',
    'acquieterete',
    'acquietero',
    'acquieti',
    'acquietiamo',
    'acquietiate',
    'acquietino',
    'acquieto',
    'acquifera',
    'acquifere',
    'acquiferi',
    'acquifero',
    'acquigiana',
    'acquigiane',
    'acquigiani',
    'acquigiano',
    'acquino',
    'acquirente',
    'acquirenti',
    'acquisendo',
    'acquisente',
    'acquisenti',
    'acquisi',
    'acquisiamo',
    'acquisiate',
    'acquisibili',
    'acquisii',
    'acquisimmo',
    'acquisira',
    'acquisirai',
    'acquisiranno',
    'acquisire',
    'acquisirebbe',
    'acquisirei',
    'acquisiremmo',
    'acquisiremo',
    'acquisireste',
    'acquisiresti',
    'acquisirete',
    'acquisiro',
    'acquisirono',
    'acquisirà',
    'acquisisca',
    'acquisiscano',
    'acquisisce',
    'acquisisci',
    'acquisisco',
    'acquisiscono',
    'acquisisse',
    'acquisissero',
    'acquisissi',
    'acquisissimo',
    'acquisiste',
    'acquisisti',
    'acquisita',
    'acquisite',
    'acquisiti',
    'acquisitiva',
    'acquisitive',
    'acquisitivi',
    'acquisitivo',
    'acquisito',
    'acquisitore',
    'acquisitori',
    'acquisitrice',
    'acquisitrici',
    'acquisiva',
    'acquisivamo',
    'acquisivano',
    'acquisivate',
    'acquisivi',
    'acquisivo',
    'acquisizione',
    'acquisizioni',
    'acquista',
    'acquistabile',
    'acquistabili',
    'acquistai',
    'acquistammo',
    'acquistando',
    'acquistano',
    'acquistante',
    'acquistanti',
    'acquistar',
    'acquistarci',
    'acquistare',
    'acquistarlo',
    'acquistarmi',
    'acquistarne',
    'acquistarono',
    'acquistarsi',
    'acquistarti',
    'acquistarvi',
    'acquistasse',
    'acquistassi',
    'acquistaste',
    'acquistasti',
    'acquistata',
    'acquistate',
    'acquistatevi',
    'acquistati',
    'acquistato',
    'acquistatomi',
    'acquistatoti',
    'acquistava',
    'acquistavamo',
    'acquistavano',
    'acquistavate',
    'acquistavi',
    'acquistavo',
    'acquistera',
    'acquisterai',
    'acquisterei',
    'acquisteremo',
    'acquisterete',
    'acquistero',
    'acquisti',
    'acquistiamo',
    'acquistiate',
    'acquistino',
    'acquisto',
    'acquitrini',
    'acquitrino',
    'acquitrinosa',
    'acquitrinose',
    'acquitrinosi',
    'acquitrinoso',
    'acquo',
    'acquolina',
    'acquoline',
    'acquorea',
    'acquoree',
    'acquorei',
    'acquoreo',
    'acquosa',
    'acquose',
    'acquosi',
    'acquosita',
    'acquosità',
    'acquoso',
    'acra',
    'acrani',
    'acrania',
    'acranie',
    'acranio',
    'acrasiea',
    'acrasiee',
    'acre',
    'acredine',
    'acredini',
    'acremente',
    'acremonium',
    'acrese',
    'acresi',
    'acri',
    'acribia',
    'acribie',
    'acridi',
    'acridina',
    'acridine',
    'acridio',
    'acrilati',
    'acrilato',
    'acrile',
    'acrili',
    'acrilica',
    'acriliche',
    'acrilici',
    'acrilico',
    'acrimonia',
    'acrimonie',
    'acrimoniosa',
    'acrimoniose',
    'acrimoniosi',
    'acrimonioso',
    'acrisia',
    'acrisie',
    'acrisio',
    'acritica',
    'acritiche',
    'acritici',
    'acriticita',
    'acritico',
    'acro',
    'acroamatica',
    'acroamatiche',
    'acroamatici',
    'acroamatico',
    'acrobata',
    'acrobate',
    'acrobati',
    'acrobatica',
    'acrobatiche',
    'acrobatici',
    'acrobatico',
    'acrobatismi',
    'acrobatismo',
    'acrobazia',
    'acrobazie',
    'acrocefala',
    'acrocefale',
    'acrocefali',
    'acrocefalia',
    'acrocefalie',
    'acrocefalo',
    'acrocianosi',
    'acrocori',
    'acrocoro',
    'acrodinia',
    'acrofobia',
    'acrofobie',
    'acrofonia',
    'acrofonica',
    'acrofoniche',
    'acrofonici',
    'acrofonico',
    'acroleina',
    'acroleine',
    'acroliti',
    'acrolito',
    'acroma',
    'acromasia',
    'acromasie',
    'acromatica',
    'acromatiche',
    'acromatici',
    'acromatico',
    'acromatismi',
    'acromatismo',
    'acromatizza',
    'acromatizzai',
    'acromatizzi',
    'acromatizzo',
    'acromatopsia',
    'acromatopsie',
    'acrome',
    'acromegalia',
    'acromegalie',
    'acromi',
    'acromia',
    'acromie',
    'acromio',
    'acromion',
    'acromo',
    'acronica',
    'acroniche',
    'acronici',
    'acronico',
    'acronimi',
    'acronimo',
    'acropoli',
    'acrosoma',
    'acrospiroma',
    'acrostici',
    'acrostico',
    'acrostoli',
    'acrostolio',
    'acroteri',
    'acroterio',
    'acrotonica',
    'acrotoniche',
    'acrotonici',
    'acrotonico',
    'acta',
    'actea',
    'actee',
    'acth',
    'actina',
    'actine',
    'acting',
    'actinia',
    'actinidia',
    'actinidie',
    'actino',
    'actinomicete',
    'actinomiceti',
    'actinomicina',
    'actinomicosi',
    'actinomorfa',
    'actinomorfe',
    'actinomorfi',
    'actinomorfo',
    'actinomyces',
    'acucettore',
    'acucettori',
    'acuendo',
    'acuendoci',
    'acuendomi',
    'acuendosi',
    'acuendoti',
    'acuendovi',
    'acuente',
    'acuenti',
    'acuentisi',
    'acufene',
    'acufeni',
    'acui',
    'acuiamo',
    'acuiamoci',
    'acuiate',
    'acuii',
    'acuimmo',
    'acuira',
    'acuirai',
    'acuiranno',
    'acuirci',
    'acuire',
    'acuirebbe',
    'acuirebbero',
    'acuirei',
    'acuiremmo',
    'acuiremo',
    'acuireste',
    'acuiresti',
    'acuirete',
    'acuirmi',
    'acuiro',
    'acuirono',
    'acuirsi',
    'acuirti',
    'acuirvi',
    'acuisca',
    'acuiscano',
    'acuisce',
    'acuisci',
    'acuisciti',
    'acuisco',
    'acuiscono',
    'acuisse',
    'acuissero',
    'acuissi',
    'acuissimo',
    'acuiste',
    'acuisti',
    'acuita',
    'acuite',
    'acuitevi',
    'acuiti',
    'acuito',
    'acuitomi',
    'acuitoti',
    'acuiva',
    'acuivamo',
    'acuivano',
    'acuivate',
    'acuivi',
    'acuivo',
    'aculeata',
    'aculeate',
    'aculeati',
    'aculeato',
    'aculei',
    'aculeo',
    'aculeoli',
    'aculeolo',
    'acume',
    'acumetria',
    'acumetrie',
    'acumi',
    'acumina',
    'acuminai',
    'acuminammo',
    'acuminando',
    'acuminano',
    'acuminante',
    'acuminanti',
    'acuminare',
    'acuminarono',
    'acuminasse',
    'acuminassero',
    'acuminassi',
    'acuminassimo',
    'acuminaste',
    'acuminasti',
    'acuminata',
    'acuminate',
    'acuminati',
    'acuminato',
    'acuminava',
    'acuminavamo',
    'acuminavano',
    'acuminavate',
    'acuminavi',
    'acuminavo',
    'acuminera',
    'acuminerai',
    'acumineranno',
    'acuminerebbe',
    'acuminerei',
    'acumineremmo',
    'acumineremo',
    'acuminereste',
    'acumineresti',
    'acuminerete',
    'acuminero',
    'acumini',
    'acuminiamo',
    'acuminiate',
    'acuminino',
    'acumino',
    'acupressione',
    'acusma',
    'acusmi',
    'acustica',
    'acustiche',
    'acustici',
    'acustico',
    'acustoottica',
    'acuta',
    'acutamente',
    'acutangola',
    'acutangole',
    'acutangoli',
    'acutangolo',
    'acute',
    'acutezza',
    'acutezze',
    'acuti',
    'acutissima',
    'acutissime',
    'acutissimi',
    'acutissimo',
    'acutizza',
    'acutizzai',
    'acutizzammo',
    'acutizzando',
    'acutizzano',
    'acutizzante',
    'acutizzanti',
    'acutizzarci',
    'acutizzare',
    'acutizzarmi',
    'acutizzarono',
    'acutizzarsi',
    'acutizzarti',
    'acutizzarvi',
    'acutizzasse',
    'acutizzassi',
    'acutizzaste',
    'acutizzasti',
    'acutizzata',
    'acutizzate',
    'acutizzatevi',
    'acutizzati',
    'acutizzato',
    'acutizzatomi',
    'acutizzatoti',
    'acutizzava',
    'acutizzavamo',
    'acutizzavano',
    'acutizzavate',
    'acutizzavi',
    'acutizzavo',
    'acutizzera',
    'acutizzerai',
    'acutizzerei',
    'acutizzeremo',
    'acutizzerete',
    'acutizzero',
    'acutizzi',
    'acutizziamo',
    'acutizziate',
    'acutizzino',
    'acutizzo',
    'acuto',
    'acuzie',
    'adacqua',
    'adacquai',
    'adacquamenti',
    'adacquamento',
    'adacquammo',
    'adacquando',
    'adacquano',
    'adacquante',
    'adacquanti',
    'adacquare',
    'adacquarono',
    'adacquasse',
    'adacquassero',
    'adacquassi',
    'adacquassimo',
    'adacquaste',
    'adacquasti',
    'adacquata',
    'adacquate',
    'adacquati',
    'adacquato',
    'adacquatore',
    'adacquatori',
    'adacquatrice',
    'adacquatrici',
    'adacquava',
    'adacquavamo',
    'adacquavano',
    'adacquavate',
    'adacquavi',
    'adacquavo',
    'adacquera',
    'adacquerai',
    'adacqueranno',
    'adacquerebbe',
    'adacquerei',
    'adacqueremmo',
    'adacqueremo',
    'adacquereste',
    'adacqueresti',
    'adacquerete',
    'adacquero',
    'adacqui',
    'adacquiamo',
    'adacquiate',
    'adacquino',
    'adacquo',
    'adagera',
    'adagerai',
    'adageranno',
    'adagerebbe',
    'adagerebbero',
    'adagerei',
    'adageremmo',
    'adageremo',
    'adagereste',
    'adageresti',
    'adagerete',
    'adagero',
    'adagetti',
    'adagetto',
    'adagi',
    'adagia',
    'adagiai',
    'adagiammo',
    'adagiamo',
    'adagiamoci',
    'adagiando',
    'adagiandoci',
    'adagiandola',
    'adagiandolo',
    'adagiandomi',
    'adagiandosi',
    'adagiandoti',
    'adagiandovi',
    'adagiano',
    'adagiante',
    'adagianti',
    'adagiantisi',
    'adagiarci',
    'adagiare',
    'adagiarla',
    'adagiarlo',
    'adagiarmi',
    'adagiarono',
    'adagiarsi',
    'adagiarti',
    'adagiarvi',
    'adagiasse',
    'adagiassero',
    'adagiassi',
    'adagiassimo',
    'adagiaste',
    'adagiasti',
    'adagiata',
    'adagiate',
    'adagiatevi',
    'adagiati',
    'adagiato',
    'adagiatomi',
    'adagiatoti',
    'adagiava',
    'adagiavamo',
    'adagiavano',
    'adagiavate',
    'adagiavi',
    'adagiavo',
    'adagino',
    'adagio',
    'adalberta',
    'adalberto',
    'adalciso',
    'adale',
    'adalgerio',
    'adalgisa',
    'adalgisio',
    'adalgiso',
    'adali',
    'adalia',
    'adalinda',
    'adalindo',
    'adalio',
    'adalisa',
    'adama',
    'adamante',
    'adamanti',
    'adamantina',
    'adamantine',
    'adamantini',
    'adamantino',
    'adamaria',
    'adamello',
    'adami',
    'adamina',
    'adamino',
    'adamita',
    'adamite',
    'adamiti',
    'adamitica',
    'adamitiche',
    'adamitici',
    'adamitico',
    'adamo',
    'adams',
    'adassiale',
    'adassiali',
    'adastro',
    'adatta',
    'adattabile',
    'adattabili',
    'adattabilita',
    'adattabilità',
    'adattai',
    'adattamenti',
    'adattamento',
    'adattammo',
    'adattando',
    'adattandoci',
    'adattandola',
    'adattandole',
    'adattandoli',
    'adattandolo',
    'adattandomi',
    'adattandosi',
    'adattandoti',
    'adattandovi',
    'adattano',
    'adattante',
    'adattanti',
    'adattantisi',
    'adattarci',
    'adattare',
    'adattarla',
    'adattarle',
    'adattarli',
    'adattarlo',
    'adattarmi',
    'adattarono',
    'adattarsi',
    'adattarti',
    'adattarvi',
    'adattasse',
    'adattassero',
    'adattassi',
    'adattassimo',
    'adattaste',
    'adattasti',
    'adattata',
    'adattate',
    'adattatevi',
    'adattati',
    'adattativa',
    'adattative',
    'adattativi',
    'adattativo',
    'adattato',
    'adattatomi',
    'adattatore',
    'adattatori',
    'adattatoti',
    'adattava',
    'adattavamo',
    'adattavano',
    'adattavate',
    'adattavi',
    'adattavo',
    'adatte',
    'adattera',
    'adatterai',
    'adatteranno',
    'adatterebbe',
    'adatterei',
    'adatteremmo',
    'adatteremo',
    'adattereste',
    'adatteresti',
    'adatterete',
    'adattero',
    'adatti',
    'adattiamo',
    'adattiamoci',
    'adattiate',
    'adattino',
    'adattissima',
    'adattissime',
    'adattissimi',
    'adattissimo',
    'adattiva',
    'adattive',
    'adattivi',
    'adattivo',
    'adatto',
    'adattometria',
    'adattometrie',
    'adda',
    'addace',
    'addaci',
    'addai',
    'addamiano',
    'addando',
    'addandoci',
    'addandomi',
    'addandosi',
    'addandoti',
    'addandovi',
    'addanno',
    'addantesi',
    'addantisi',
    'addara',
    'addarai',
    'addaranno',
    'addarci',
    'addare',
    'addarebbe',
    'addarebbero',
    'addarei',
    'addaremmo',
    'addaremo',
    'addareste',
    'addaresti',
    'addarete',
    'addario',
    'addarmi',
    'addaro',
    'addarsi',
    'addarti',
    'addarvi',
    'addata',
    'addate',
    'addatevi',
    'addati',
    'addato',
    'addatomi',
    'addatoti',
    'addava',
    'addavamo',
    'addavano',
    'addavate',
    'addavi',
    'addavo',
    'addazi',
    'addazia',
    'addaziai',
    'addaziammo',
    'addaziamo',
    'addaziando',
    'addaziano',
    'addaziante',
    'addazianti',
    'addaziare',
    'addaziarono',
    'addaziasse',
    'addaziassero',
    'addaziassi',
    'addaziassimo',
    'addaziaste',
    'addaziasti',
    'addaziata',
    'addaziate',
    'addaziati',
    'addaziato',
    'addaziava',
    'addaziavamo',
    'addaziavano',
    'addaziavate',
    'addaziavi',
    'addaziavo',
    'addaziera',
    'addazierai',
    'addazieranno',
    'addazierebbe',
    'addazierei',
    'addazieremmo',
    'addazieremo',
    'addaziereste',
    'addazieresti',
    'addazierete',
    'addaziero',
    'addazino',
    'addazio',
    'addebbi',
    'addebbia',
    'addebbiai',
    'addebbiammo',
    'addebbiamo',
    'addebbiando',
    'addebbiano',
    'addebbiante',
    'addebbianti',
    'addebbiare',
    'addebbiarono',
    'addebbiasse',
    'addebbiassi',
    'addebbiaste',
    'addebbiasti',
    'addebbiata',
    'addebbiate',
    'addebbiati',
    'addebbiato',
    'addebbiatura',
    'addebbiature',
    'addebbiava',
    'addebbiavamo',
    'addebbiavano',
    'addebbiavate',
    'addebbiavi',
    'addebbiavo',
    'addebbiera',
    'addebbierai',
    'addebbierei',
    'addebbieremo',
    'addebbierete',
    'addebbiero',
    'addebbino',
    'addebbio',
    'addebita',
    'addebitai',
    'addebitammo',
    'addebitando',
    'addebitano',
    'addebitante',
    'addebitanti',
    'addebitare',
    'addebitarono',
    'addebitasse',
    'addebitassi',
    'addebitaste',
    'addebitasti',
    'addebitata',
    'addebitate',
    'addebitati',
    'addebitato',
    'addebitava',
    'addebitavamo',
    'addebitavano',
    'addebitavate',
    'addebitavi',
    'addebitavo',
    'addebitera',
    'addebiterai',
    'addebiterei',
    'addebiteremo',
    'addebiterete',
    'addebitero',
    'addebiti',
    'addebitiamo',
    'addebitiate',
    'addebitino',
    'addebito',
    'addebitta',
    'addebittai',
    'addebitti',
    'addebitto',
    'addecima',
    'addecimai',
    'addecimammo',
    'addecimando',
    'addecimano',
    'addecimante',
    'addecimanti',
    'addecimare',
    'addecimarono',
    'addecimasse',
    'addecimassi',
    'addecimaste',
    'addecimasti',
    'addecimata',
    'addecimate',
    'addecimati',
    'addecimato',
    'addecimava',
    'addecimavamo',
    'addecimavano',
    'addecimavate',
    'addecimavi',
    'addecimavo',
    'addecimera',
    'addecimerai',
    'addecimerei',
    'addecimeremo',
    'addecimerete',
    'addecimero',
    'addecimi',
    'addecimiamo',
    'addecimiate',
    'addecimino',
    'addecimo',
    'addemmo',
    'addenda',
    'addendi',
    'addendo',
    'addendum',
    'addensa',
    'addensai',
    'addensamenti',
    'addensamento',
    'addensammo',
    'addensando',
    'addensandoci',
    'addensandomi',
    'addensandosi',
    'addensandoti',
    'addensandovi',
    'addensano',
    'addensante',
    'addensanti',
    'addensantisi',
    'addensarci',
    'addensare',
    'addensarmi',
    'addensarono',
    'addensarsi',
    'addensarti',
    'addensarvi',
    'addensasse',
    'addensassero',
    'addensassi',
    'addensassimo',
    'addensaste',
    'addensasti',
    'addensata',
    'addensate',
    'addensatevi',
    'addensati',
    'addensato',
    'addensatomi',
    'addensatore',
    'addensatori',
    'addensatoti',
    'addensava',
    'addensavamo',
    'addensavano',
    'addensavate',
    'addensavi',
    'addensavo',
    'addensera',
    'addenserai',
    'addenseranno',
    'addenserebbe',
    'addenserei',
    'addenseremmo',
    'addenseremo',
    'addensereste',
    'addenseresti',
    'addenserete',
    'addensero',
    'addensi',
    'addensiamo',
    'addensiamoci',
    'addensiate',
    'addensino',
    'addenso',
    'addenta',
    'addentai',
    'addentammo',
    'addentando',
    'addentandoci',
    'addentandomi',
    'addentandosi',
    'addentandoti',
    'addentandovi',
    'addentano',
    'addentante',
    'addentanti',
    'addentantisi',
    'addentarci',
    'addentare',
    'addentarmi',
    'addentarono',
    'addentarsi',
    'addentarti',
    'addentarvi',
    'addentasse',
    'addentassero',
    'addentassi',
    'addentassimo',
    'addentaste',
    'addentasti',
    'addentata',
    'addentate',
    'addentatevi',
    'addentati',
    'addentato',
    'addentatomi',
    'addentatoti',
    'addentatura',
    'addentature',
    'addentava',
    'addentavamo',
    'addentavano',
    'addentavate',
    'addentavi',
    'addentavo',
    'addentella',
    'addentellai',
    'addentellano',
    'addentellare',
    'addentellata',
    'addentellate',
    'addentellati',
    'addentellato',
    'addentellava',
    'addentellavi',
    'addentellavo',
    'addentellera',
    'addentellero',
    'addentelli',
    'addentellino',
    'addentello',
    'addentera',
    'addenterai',
    'addenteranno',
    'addenterebbe',
    'addenterei',
    'addenteremmo',
    'addenteremo',
    'addentereste',
    'addenteresti',
    'addenterete',
    'addentero',
    'addenti',
    'addentiamo',
    'addentiamoci',
    'addentiate',
    'addentino',
    'addento',
    'addentra',
    'addentrai',
    'addentrammo',
    'addentrando',
    'addentrano',
    'addentrante',
    'addentranti',
    'addentrarci',
    'addentrare',
    'addentrarmi',
    'addentrarono',
    'addentrarsi',
    'addentrarti',
    'addentrarvi',
    'addentrasse',
    'addentrassi',
    'addentraste',
    'addentrasti',
    'addentrata',
    'addentrate',
    'addentratevi',
    'addentrati',
    'addentrato',
    'addentratomi',
    'addentratoti',
    'addentrava',
    'addentravamo',
    'addentravano',
    'addentravate',
    'addentravi',
    'addentravo',
    'addentrera',
    'addentrerai',
    'addentrerei',
    'addentreremo',
    'addentrerete',
    'addentrero',
    'addentri',
    'addentriamo',
    'addentriate',
    'addentrino',
    'addentro',
    'addesse',
    'addessero',
    'addessi',
    'addessimo',
    'addeste',
    'addesti',
    'addestra',
    'addestrabile',
    'addestrabili',
    'addestrai',
    'addestrammo',
    'addestrando',
    'addestrano',
    'addestrante',
    'addestranti',
    'addestrarci',
    'addestrare',
    'addestrarmi',
    'addestrarono',
    'addestrarsi',
    'addestrarti',
    'addestrarvi',
    'addestrasse',
    'addestrassi',
    'addestraste',
    'addestrasti',
    'addestrata',
    'addestrate',
    'addestratevi',
    'addestrati',
    'addestrativa',
    'addestrative',
    'addestrativi',
    'addestrativo',
    'addestrato',
    'addestratomi',
    'addestratore',
    'addestratori',
    'addestratoti',
    'addestrava',
    'addestravamo',
    'addestravano',
    'addestravate',
    'addestravi',
    'addestravo',
    'addestrera',
    'addestrerai',
    'addestrerei',
    'addestreremo',
    'addestrerete',
    'addestrero',
    'addestri',
    'addestriamo',
    'addestriate',
    'addestrino',
    'addestro',
    'addetta',
    'addette',
    'addettero',
    'addetti',
    'addetto',
    'addi',
    'addia',
    'addiaccera',
    'addiaccerai',
    'addiaccerei',
    'addiacceremo',
    'addiaccerete',
    'addiaccero',
    'addiacci',
    'addiaccia',
    'addiacciai',
    'addiacciammo',
    'addiacciamo',
    'addiacciando',
    'addiacciano',
    'addiacciante',
    'addiaccianti',
    'addiacciare',
    'addiacciasse',
    'addiacciassi',
    'addiacciaste',
    'addiacciasti',
    'addiacciata',
    'addiacciate',
    'addiacciati',
    'addiacciato',
    'addiacciava',
    'addiacciavi',
    'addiacciavo',
    'addiaccino',
    'addiaccio',
    'addiamo',
    'addiamoci',
    'addiano',
    'addiate',
    'addica',
    'addicano',
    'addice',
    'addicemmo',
    'addicendo',
    'addicendosi',
    'addicente',
    'addicenti',
    'addicesse',
    'addicessero',
    'addicessi',
    'addicessimo',
    'addiceste',
    'addicesti',
    'addiceva',
    'addicevamo',
    'addicevano',
    'addicevate',
    'addicevi',
    'addicevo',
    'addici',
    'addiciamo',
    'addiciate',
    'addico',
    'addicono',
    'addiede',
    'addiedero',
    'addiedi',
    'addiego',
    'addietro',
    'addiettivo',
    'addii',
    'addimanda',
    'addimandai',
    'addimandammo',
    'addimandando',
    'addimandano',
    'addimandante',
    'addimandanti',
    'addimandare',
    'addimandasse',
    'addimandassi',
    'addimandaste',
    'addimandasti',
    'addimandata',
    'addimandate',
    'addimandati',
    'addimandato',
    'addimandava',
    'addimandavi',
    'addimandavo',
    'addimandera',
    'addimanderai',
    'addimanderei',
    'addimandero',
    'addimandi',
    'addimandiamo',
    'addimandiate',
    'addimandino',
    'addimando',
    'addimostra',
    'addimostrai',
    'addimostrano',
    'addimostrare',
    'addimostrata',
    'addimostrate',
    'addimostrati',
    'addimostrato',
    'addimostrava',
    'addimostravi',
    'addimostravo',
    'addimostrera',
    'addimostrero',
    'addimostri',
    'addimostrino',
    'addimostro',
    'addio',
    'addipana',
    'addipanai',
    'addipanammo',
    'addipanando',
    'addipanano',
    'addipanante',
    'addipananti',
    'addipanarci',
    'addipanare',
    'addipanarmi',
    'addipanarono',
    'addipanarsi',
    'addipanarti',
    'addipanarvi',
    'addipanasse',
    'addipanassi',
    'addipanaste',
    'addipanasti',
    'addipanata',
    'addipanate',
    'addipanatevi',
    'addipanati',
    'addipanato',
    'addipanatomi',
    'addipanatoti',
    'addipanava',
    'addipanavamo',
    'addipanavano',
    'addipanavate',
    'addipanavi',
    'addipanavo',
    'addipanera',
    'addipanerai',
    'addipanerei',
    'addipaneremo',
    'addipanerete',
    'addipanero',
    'addipani',
    'addipaniamo',
    'addipaniate',
    'addipanino',
    'addipano',
    'addira',
    'addirai',
    'addiranno',
    'addire',
    'addirebbe',
    'addirebbero',
    'addirei',
    'addiremmo',
    'addiremo',
    'addireste',
    'addiresti',
    'addirete',
    'addirittura',
    'addirizza',
    'addirizzai',
    'addirizzammo',
    'addirizzando',
    'addirizzano',
    'addirizzante',
    'addirizzanti',
    'addirizzarci',
    'addirizzare',
    'addirizzarmi',
    'addirizzarsi',
    'addirizzarti',
    'addirizzarvi',
    'addirizzasse',
    'addirizzassi',
    'addirizzaste',
    'addirizzasti',
    'addirizzata',
    'addirizzate',
    'addirizzati',
    'addirizzato',
    'addirizzava',
    'addirizzavi',
    'addirizzavo',
    'addirizzera',
    'addirizzerai',
    'addirizzerei',
    'addirizzero',
    'addirizzi',
    'addirizziamo',
    'addirizziate',
    'addirizzino',
    'addirizzo',
    'addiro',
    'addirsi',
    'addison',
    'addisoniana',
    'addisoniane',
    'addisoniani',
    'addisoniano',
    'addisse',
    'addissero',
    'addissi',
    'addita',
    'additai',
    'additamenti',
    'additamento',
    'additammo',
    'additando',
    'additandoci',
    'additandola',
    'additandole',
    'additandoli',
    'additandolo',
    'additandomi',
    'additandoti',
    'additandovi',
    'additano',
    'additante',
    'additanti',
    'additarci',
    'additare',
    'additarla',
    'additarle',
    'additarli',
    'additarlo',
    'additarmi',
    'additarono',
    'additarti',
    'additarvi',
    'additasse',
    'additassero',
    'additassi',
    'additassimo',
    'additaste',
    'additasti',
    'additata',
    'additate',
    'additati',
    'additato',
    'additatore',
    'additatori',
    'additatrice',
    'additatrici',
    'additava',
    'additavamo',
    'additavano',
    'additavate',
    'additavi',
    'additavo',
    'addite',
    'additera',
    'additerai',
    'additeranno',
    'additerebbe',
    'additerei',
    'additeremmo',
    'additeremo',
    'additereste',
    'additeresti',
    'additerete',
    'additero',
    'additi',
    'additiamo',
    'additiate',
    'additino',
    'additiva',
    'additivai',
    'additivammo',
    'additivando',
    'additivano',
    'additivante',
    'additivanti',
    'additivare',
    'additivarono',
    'additivasse',
    'additivassi',
    'additivaste',
    'additivasti',
    'additivata',
    'additivate',
    'additivati',
    'additivato',
    'additivava',
    'additivavamo',
    'additivavano',
    'additivavate',
    'additivavi',
    'additivavo',
    'additive',
    'additivera',
    'additiverai',
    'additiverei',
    'additiveremo',
    'additiverete',
    'additivero',
    'additivi',
    'additiviamo',
    'additiviate',
    'additivino',
    'additivo',
    'addito',
    'addivenendo',
    'addivenga',
    'addivengano',
    'addivengo',
    'addivengono',
    'addiveniamo',
    'addiveniate',
    'addiveniente',
    'addivenienti',
    'addivenimmo',
    'addivenire',
    'addivenisse',
    'addivenissi',
    'addiveniste',
    'addivenisti',
    'addivenite',
    'addiveniva',
    'addivenivamo',
    'addivenivano',
    'addivenivate',
    'addivenivi',
    'addivenivo',
    'addivenne',
    'addivennero',
    'addivenni',
    'addivenuta',
    'addivenute',
    'addivenuti',
    'addivenuto',
    'addiverra',
    'addiverrai',
    'addiverranno',
    'addiverrebbe',
    'addiverrei',
    'addiverremmo',
    'addiverremo',
    'addiverreste',
    'addiverresti',
    'addiverrete',
    'addiverro',
    'addiviene',
    'addivieni',
    'addiziona',
    'addizionai',
    'addizionale',
    'addizionali',
    'addizionammo',
    'addizionando',
    'addizionano',
    'addizionante',
    'addizionanti',
    'addizionare',
    'addizionasse',
    'addizionassi',
    'addizionaste',
    'addizionasti',
    'addizionata',
    'addizionate',
    'addizionati',
    'addizionato',
    'addizionava',
    'addizionavi',
    'addizionavo',
    'addizione',
    'addizionera',
    'addizionerai',
    'addizionerei',
    'addizionero',
    'addizioni',
    'addizioniamo',
    'addizioniate',
    'addizionino',
    'addiziono',
    'addo',
    'addobba',
    'addobbai',
    'addobbamenti',
    'addobbamento',
    'addobbammo',
    'addobbando',
    'addobbandoci',
    'addobbandomi',
    'addobbandosi',
    'addobbandoti',
    'addobbandovi',
    'addobbano',
    'addobbante',
    'addobbanti',
    'addobbantisi',
    'addobbarci',
    'addobbare',
    'addobbarmi',
    'addobbarono',
    'addobbarsi',
    'addobbarti',
    'addobbarvi',
    'addobbasse',
    'addobbassero',
    'addobbassi',
    'addobbassimo',
    'addobbaste',
    'addobbasti',
    'addobbata',
    'addobbate',
    'addobbatevi',
    'addobbati',
    'addobbato',
    'addobbatomi',
    'addobbatore',
    'addobbatori',
    'addobbatoti',
    'addobbatrice',
    'addobbatrici',
    'addobbava',
    'addobbavamo',
    'addobbavano',
    'addobbavate',
    'addobbavi',
    'addobbavo',
    'addobbera',
    'addobberai',
    'addobberanno',
    'addobberebbe',
    'addobberei',
    'addobberemmo',
    'addobberemo',
    'addobbereste',
    'addobberesti',
    'addobberete',
    'addobbero',
    'addobbi',
    'addobbiamo',
    'addobbiamoci',
    'addobbiate',
    'addobbino',
    'addobbo',
    'addoccera',
    'addoccerai',
    'addocceranno',
    'addoccerebbe',
    'addoccerei',
    'addocceremmo',
    'addocceremo',
    'addoccereste',
    'addocceresti',
    'addoccerete',
    'addoccero',
    'addocci',
    'addoccia',
    'addocciai',
    'addocciammo',
    'addocciamo',
    'addocciando',
    'addocciano',
    'addocciante',
    'addoccianti',
    'addocciare',
    'addocciarono',
    'addocciasse',
    'addocciassi',
    'addocciaste',
    'addocciasti',
    'addocciata',
    'addocciate',
    'addocciati',
    'addocciato',
    'addocciava',
    'addocciavamo',
    'addocciavano',
    'addocciavate',
    'addocciavi',
    'addocciavo',
    'addoccino',
    'addoccio',
    'addocilendo',
    'addocilente',
    'addocilenti',
    'addocili',
    'addociliamo',
    'addociliate',
    'addocilii',
    'addocilimmo',
    'addocilira',
    'addocilirai',
    'addocilire',
    'addocilirei',
    'addociliremo',
    'addocilirete',
    'addociliro',
    'addocilirono',
    'addocilisca',
    'addocilisce',
    'addocilisci',
    'addocilisco',
    'addocilisse',
    'addocilissi',
    'addociliste',
    'addocilisti',
    'addocilita',
    'addocilite',
    'addociliti',
    'addocilito',
    'addociliva',
    'addocilivamo',
    'addocilivano',
    'addocilivate',
    'addocilivi',
    'addocilivo',
    'addoga',
    'addogai',
    'addogammo',
    'addogando',
    'addogano',
    'addogante',
    'addoganti',
    'addogare',
    'addogarono',
    'addogasse',
    'addogassero',
    'addogassi',
    'addogassimo',
    'addogaste',
    'addogasti',
    'addogata',
    'addogate',
    'addogati',
    'addogato',
    'addogava',
    'addogavamo',
    'addogavano',
    'addogavate',
    'addogavi',
    'addogavo',
    'addoghera',
    'addogherai',
    'addogheranno',
    'addogherebbe',
    'addogherei',
    'addogheremmo',
    'addogheremo',
    'addoghereste',
    'addogheresti',
    'addogherete',
    'addoghero',
    'addoghi',
    'addoghiamo',
    'addoghiate',
    'addoghino',
    'addogli',
    'addoglia',
    'addogliai',
    'addogliammo',
    'addogliamo',
    'addogliando',
    'addogliano',
    'addogliante',
    'addoglianti',
    'addogliare',
    'addogliarono',
    'addogliasse',
    'addogliassi',
    'addogliaste',
    'addogliasti',
    'addogliata',
    'addogliate',
    'addogliati',
    'addogliato',
    'addogliava',
    'addogliavamo',
    'addogliavano',
    'addogliavate',
    'addogliavi',
    'addogliavo',
    'addogliera',
    'addoglierai',
    'addoglierei',
    'addoglieremo',
    'addoglierete',
    'addogliero',
    'addoglino',
    'addoglio',
    'addogo',
    'addolca',
    'addolcando',
    'addolcandosi',
    'addolcare',
    'addolcarsi',
    'addolcato',
    'addolcava',
    'addolcendo',
    'addolcendoci',
    'addolcendomi',
    'addolcendosi',
    'addolcendoti',
    'addolcendovi',
    'addolcente',
    'addolcenti',
    'addolcentisi',
    'addolci',
    'addolciamo',
    'addolciamoci',
    'addolciare',
    'addolciate',
    'addolcii',
    'addolcimenti',
    'addolcimento',
    'addolcimmo',
    'addolcira',
    'addolcirai',
    'addolciranno',
    'addolcirci',
    'addolcire',
    'addolcirebbe',
    'addolcirei',
    'addolciremmo',
    'addolciremo',
    'addolcireste',
    'addolciresti',
    'addolcirete',
    'addolcirmi',
    'addolciro',
    'addolcirono',
    'addolcirsi',
    'addolcirti',
    'addolcirvi',
    'addolcisca',
    'addolciscano',
    'addolcisce',
    'addolcisci',
    'addolcisciti',
    'addolcisco',
    'addolciscono',
    'addolcisse',
    'addolcissero',
    'addolcissi',
    'addolcissimo',
    'addolciste',
    'addolcisti',
    'addolcita',
    'addolcite',
    'addolcitevi',
    'addolciti',
    'addolcitiva',
    'addolcitive',
    'addolcitivi',
    'addolcitivo',
    'addolcito',
    'addolcitomi',
    'addolcitore',
    'addolcitori',
    'addolcitoti',
    'addolciva',
    'addolcivamo',
    'addolcivano',
    'addolcivate',
    'addolcivi',
    'addolcivo',
    'addolora',
    'addolorai',
    'addolorammo',
    'addolorando',
    'addolorano',
    'addolorante',
    'addoloranti',
    'addolorarci',
    'addolorare',
    'addolorarla',
    'addolorarle',
    'addolorarli',
    'addolorarlo',
    'addolorarmi',
    'addolorarono',
    'addolorarsi',
    'addolorartci',
    'addolorarti',
    'addolorarvi',
    'addolorasse',
    'addolorassi',
    'addoloraste',
    'addolorasti',
    'addolorata',
    'addolorate',
    'addoloratevi',
    'addolorati',
    'addolorato',
    'addoloratomi',
    'addoloratoti',
    'addolorava',
    'addoloravamo',
    'addoloravano',
    'addoloravate',
    'addoloravi',
    'addoloravo',
    'addolorera',
    'addolorerai',
    'addolorerei',
    'addoloreremo',
    'addolorerete',
    'addolorero',
    'addolori',
    'addoloriamo',
    'addoloriate',
    'addolorino',
    'addoloro',
    'addom',
    'addomanda',
    'addomandai',
    'addomandammo',
    'addomandando',
    'addomandano',
    'addomandante',
    'addomandanti',
    'addomandare',
    'addomandasse',
    'addomandassi',
    'addomandaste',
    'addomandasti',
    'addomandata',
    'addomandate',
    'addomandati',
    'addomandato',
    'addomandava',
    'addomandavi',
    'addomandavo',
    'addomandera',
    'addomanderai',
    'addomanderei',
    'addomandero',
    'addomandi',
    'addomandiamo',
    'addomandiate',
    'addomandino',
    'addomando',
    'addome',
    'addomestica',
    'addomesticai',
    'addomestichi',
    'addomestico',
    'addomi',
    'addominal',
    'addominale',
    'addominali',
    'addomine',
    'addomino',
    'addonizio',
    'addoparsi',
    'addoppi',
    'addoppia',
    'addoppiai',
    'addoppiammo',
    'addoppiamo',
    'addoppiamoci',
    'addoppiando',
    'addoppiano',
    'addoppiante',
    'addoppianti',
    'addoppiarci',
    'addoppiare',
    'addoppiarmi',
    'addoppiarono',
    'addoppiarsi',
    'addoppiarti',
    'addoppiarvi',
    'addoppiasse',
    'addoppiassi',
    'addoppiaste',
    'addoppiasti',
    'addoppiata',
    'addoppiate',
    'addoppiatevi',
    'addoppiati',
    'addoppiato',
    'addoppiatoi',
    'addoppiatoio',
    'addoppiatomi',
    'addoppiatoti',
    'addoppiatura',
    'addoppiature',
    'addoppiava',
    'addoppiavamo',
    'addoppiavano',
    'addoppiavate',
    'addoppiavi',
    'addoppiavo',
    'addoppiera',
    'addoppierai',
    'addoppierei',
    'addoppieremo',
    'addoppierete',
    'addoppiero',
    'addoppino',
    'addoppio',
    'addorma',
    'addormano',
    'addorme',
    'addormendo',
    'addormendoci',
    'addormendomi',
    'addormendosi',
    'addormendoti',
    'addormendovi',
    'addormenta',
    'addormentai',
    'addormentano',
    'addormentare',
    'addormentata',
    'addormentate',
    'addormentati',
    'addormentato',
    'addormentava',
    'addormentavi',
    'addormentavo',
    'addormente',
    'addormentera',
    'addormentero',
    'addormenti',
    'addormentino',
    'addormentisi',
    'addormento',
    'addormi',
    'addormiamo',
    'addormiamoci',
    'addormiate',
    'addormiente',
    'addormienti',
    'addormii',
    'addormimmo',
    'addormira',
    'addormirai',
    'addormiranno',
    'addormirci',
    'addormire',
    'addormirebbe',
    'addormirei',
    'addormiremmo',
    'addormiremo',
    'addormireste',
    'addormiresti',
    'addormirete',
    'addormirmi',
    'addormiro',
    'addormirono',
    'addormirsi',
    'addormirti',
    'addormirvi',
    'addormisse',
    'addormissero',
    'addormissi',
    'addormissimo',
    'addormiste',
    'addormisti',
    'addormita',
    'addormite',
    'addormitevi',
    'addormiti',
    'addormito',
    'addormitomi',
    'addormitoti',
    'addormiva',
    'addormivamo',
    'addormivano',
    'addormivate',
    'addormivi',
    'addormivo',
    'addormo',
    'addormono',
    'addossa',
    'addossabile',
    'addossabili',
    'addossai',
    'addossamenti',
    'addossamento',
    'addossammo',
    'addossando',
    'addossandoci',
    'addossandomi',
    'addossandosi',
    'addossandoti',
    'addossandovi',
    'addossano',
    'addossante',
    'addossanti',
    'addossantisi',
    'addossarci',
    'addossare',
    'addossargli',
    'addossarmi',
    'addossarono',
    'addossarsi',
    'addossarti',
    'addossarvi',
    'addossasse',
    'addossassero',
    'addossassi',
    'addossassimo',
    'addossaste',
    'addossasti',
    'addossata',
    'addossate',
    'addossatevi',
    'addossati',
    'addossato',
    'addossatomi',
    'addossatoti',
    'addossava',
    'addossavamo',
    'addossavano',
    'addossavate',
    'addossavi',
    'addossavo',
    'addossera',
    'addosserai',
    'addosseranno',
    'addosserebbe',
    'addosserei',
    'addosseremmo',
    'addosseremo',
    'addossereste',
    'addosseresti',
    'addosserete',
    'addossero',
    'addossi',
    'addossiamo',
    'addossiamoci',
    'addossiate',
    'addossino',
    'addosso',
    'addotta',
    'addotte',
    'addotti',
    'addotto',
    'addottomi',
    'addottora',
    'addottorai',
    'addottorammo',
    'addottorando',
    'addottorano',
    'addottorante',
    'addottoranti',
    'addottorarci',
    'addottorare',
    'addottorarmi',
    'addottorarsi',
    'addottorarti',
    'addottorarvi',
    'addottorasse',
    'addottorassi',
    'addottoraste',
    'addottorasti',
    'addottorata',
    'addottorate',
    'addottorati',
    'addottorato',
    'addottorava',
    'addottoravi',
    'addottoravo',
    'addottorera',
    'addottorerai',
    'addottorerei',
    'addottorero',
    'addottori',
    'addottoriamo',
    'addottoriate',
    'addottorino',
    'addottoro',
    'addottoti',
    'addottrina',
    'addottrinai',
    'addottrinano',
    'addottrinare',
    'addottrinata',
    'addottrinate',
    'addottrinati',
    'addottrinato',
    'addottrinava',
    'addottrinavi',
    'addottrinavo',
    'addottrinera',
    'addottrinero',
    'addottrini',
    'addottrinino',
    'addottrino',
    'addrento',
    'addrizza',
    'addrizzai',
    'addrizzammo',
    'addrizzando',
    'addrizzano',
    'addrizzante',
    'addrizzanti',
    'addrizzarci',
    'addrizzare',
    'addrizzarmi',
    'addrizzarono',
    'addrizzarsi',
    'addrizzarti',
    'addrizzarvi',
    'addrizzasse',
    'addrizzassi',
    'addrizzaste',
    'addrizzasti',
    'addrizzata',
    'addrizzate',
    'addrizzatevi',
    'addrizzati',
    'addrizzato',
    'addrizzatomi',
    'addrizzatoti',
    'addrizzava',
    'addrizzavamo',
    'addrizzavano',
    'addrizzavate',
    'addrizzavi',
    'addrizzavo',
    'addrizzera',
    'addrizzerai',
    'addrizzerei',
    'addrizzeremo',
    'addrizzerete',
    'addrizzero',
    'addrizzi',
    'addrizziamo',
    'addrizziate',
    'addrizzino',
    'addrizzo',
    'addua',
    'adduando',
    'adduandosi',
    'adduano',
    'adduare',
    'adduarsi',
    'adduca',
    'adducano',
    'adduce',
    'adducemmo',
    'adducendo',
    'adducendoci',
    'adducendomi',
    'adducendosi',
    'adducendoti',
    'adducendovi',
    'adducente',
    'adducenti',
    'adducentisi',
    'adducere',
    'adducesse',
    'adducessero',
    'adducessi',
    'adducessimo',
    'adduceste',
    'adducesti',
    'adducete',
    'adducetevi',
    'adduceva',
    'adducevamo',
    'adducevano',
    'adducevate',
    'adducevi',
    'adducevo',
    'adduci',
    'adduciamo',
    'adduciamoci',
    'adduciate',
    'adducibile',
    'adducibili',
    'adduciti',
    'adduco',
    'adducono',
    'addugli',
    'adduglia',
    'addugliai',
    'addugliammo',
    'addugliamo',
    'addugliando',
    'addugliano',
    'addugliante',
    'adduglianti',
    'addugliare',
    'addugliarono',
    'addugliasse',
    'addugliassi',
    'addugliaste',
    'addugliasti',
    'addugliata',
    'addugliate',
    'addugliati',
    'addugliato',
    'addugliava',
    'addugliavamo',
    'addugliavano',
    'addugliavate',
    'addugliavi',
    'addugliavo',
    'addugliera',
    'adduglierai',
    'adduglierei',
    'adduglieremo',
    'adduglierete',
    'addugliero',
    'adduglino',
    'adduglio',
    'addurci',
    'addurla',
    'addurli',
    'addurlo',
    'addurmi',
    'addurne',
    'addurra',
    'addurrai',
    'addurranno',
    'addurre',
    'addurrebbe',
    'addurrebbero',
    'addurrei',
    'addurremmo',
    'addurremo',
    'addurreste',
    'addurresti',
    'addurrete',
    'addurro',
    'addurrò',
    'addursi',
    'addurti',
    'addurvi',
    'addusse',
    'addussero',
    'addussi',
    'adduttanza',
    'adduttanze',
    'adduttiva',
    'adduttive',
    'adduttivi',
    'adduttivo',
    'adduttore',
    'adduttori',
    'adduttrice',
    'adduttrici',
    'adduzione',
    'adduzioni',
    'addì',
    'adea',
    'adegua',
    'adeguabile',
    'adeguabili',
    'adeguai',
    'adeguamenti',
    'adeguamento',
    'adeguammo',
    'adeguando',
    'adeguandoci',
    'adeguandomi',
    'adeguandosi',
    'adeguandoti',
    'adeguandovi',
    'adeguano',
    'adeguante',
    'adeguanti',
    'adeguantisi',
    'adeguarci',
    'adeguare',
    'adeguarmi',
    'adeguarono',
    'adeguarsi',
    'adeguarti',
    'adeguarvi',
    'adeguasse',
    'adeguassero',
    'adeguassi',
    'adeguassimo',
    'adeguaste',
    'adeguasti',
    'adeguata',
    'adeguate',
    'adeguatevi',
    'adeguatezza',
    'adeguatezze',
    'adeguati',
    'adeguato',
    'adeguatomi',
    'adeguatoti',
    'adeguava',
    'adeguavamo',
    'adeguavano',
    'adeguavate',
    'adeguavi',
    'adeguavo',
    'adeguazione',
    'adeguazioni',
    'adeguera',
    'adeguerai',
    'adegueranno',
    'adeguerebbe',
    'adeguerei',
    'adegueremmo',
    'adegueremo',
    'adeguereste',
    'adegueresti',
    'adeguerete',
    'adeguero',
    'adegui',
    'adeguiamo',
    'adeguiamoci',
    'adeguiate',
    'adeguino',
    'adeguo',
    'adela',
    'adelaida',
    'adelaide',
    'adelaido',
    'adelante',
    'adelasia',
    'adelasio',
    'adelca',
    'adelchi',
    'adelchio',
    'adelcisa',
    'adelco',
    'adele',
    'adelelma',
    'adelelmo',
    'adelfa',
    'adelfe',
    'adelfi',
    'adelfia',
    'adelfie',
    'adelfina',
    'adelfino',
    'adelfio',
    'adelfo',
    'adelia',
    'adelina',
    'adelinda',
    'adelindo',
    'adelino',
    'adelio',
    'adelisa',
    'adelisia',
    'adelisio',
    'adelita',
    'adelma',
    'adelmaro',
    'adelmina',
    'adelmino',
    'adelmira',
    'adelmiro',
    'adelmo',
    'adelo',
    'adema',
    'ademara',
    'ademaro',
    'ademia',
    'ademina',
    'ademio',
    'ademo',
    'adempendo',
    'adempendoci',
    'adempendomi',
    'adempendosi',
    'adempendoti',
    'adempendovi',
    'adempente',
    'adempenti',
    'adempentisi',
    'adempi',
    'adempia',
    'adempiamo',
    'adempiamoci',
    'adempiano',
    'adempiate',
    'adempibile',
    'adempibili',
    'adempie',
    'adempiei',
    'adempiemmo',
    'adempiendo',
    'adempiendoci',
    'adempiendomi',
    'adempiendosi',
    'adempiendoti',
    'adempiendovi',
    'adempiente',
    'adempienti',
    'adempientisi',
    'adempiera',
    'adempierai',
    'adempieranno',
    'adempierci',
    'adempiere',
    'adempierei',
    'adempieremmo',
    'adempieremo',
    'adempiereste',
    'adempieresti',
    'adempierete',
    'adempiermi',
    'adempiero',
    'adempierono',
    'adempiersi',
    'adempierti',
    'adempiervi',
    'adempiesse',
    'adempiessero',
    'adempiessi',
    'adempiessimo',
    'adempieste',
    'adempiesti',
    'adempieva',
    'adempievamo',
    'adempievano',
    'adempievate',
    'adempievi',
    'adempievo',
    'adempii',
    'adempimenti',
    'adempimento',
    'adempimmo',
    'adempio',
    'adempiono',
    'adempira',
    'adempirai',
    'adempiranno',
    'adempirci',
    'adempire',
    'adempirebbe',
    'adempirei',
    'adempiremmo',
    'adempiremo',
    'adempireste',
    'adempiresti',
    'adempirete',
    'adempirmi',
    'adempiro',
    'adempirono',
    'adempirsi',
    'adempirti',
    'adempirvi',
    'adempisca',
    'adempiscano',
    'adempisce',
    'adempisci',
    'adempisciti',
    'adempisco',
    'adempiscono',
    'adempisse',
    'adempissero',
    'adempissi',
    'adempissimo',
    'adempiste',
    'adempisti',
    'adempita',
    'adempite',
    'adempitevi',
    'adempiti',
    'adempito',
    'adempitomi',
    'adempitoti',
    'adempiuta',
    'adempiute',
    'adempiuti',
    'adempiuto',
    'adempiutomi',
    'adempiutoti',
    'adempiva',
    'adempivamo',
    'adempivano',
    'adempivate',
    'adempivi',
    'adempivo',
    'ademprivi',
    'ademprivile',
    'ademprivili',
    'ademprivio',
    'aden',
    'adendo',
    'adenia',
    'adenie',
    'adenilica',
    'adeniliche',
    'adenilici',
    'adenilico',
    'adenina',
    'adenine',
    'adenite',
    'adeniti',
    'adeno',
    'adenoide',
    'adenoidea',
    'adenoidee',
    'adenoidei',
    'adenoideo',
    'adenoidi',
    'adenoidismi',
    'adenoidismo',
    'adenolinfoma',
    'adenoma',
    'adenomatoide',
    'adenomatosi',
    'adenomeri',
    'adenomero',
    'adenomi',
    'adenomioma',
    'adenopatia',
    'adenopatie',
    'adenophorea',
    'adenosarcoma',
    'adenosina',
    'adenosine',
    'adenotomi',
    'adenotomia',
    'adenotomie',
    'adenotomo',
    'adenoviridae',
    'adenovirosi',
    'adenovirus',
    'adente',
    'adenti',
    'adeo',
    'adeodata',
    'adeodato',
    'adepta',
    'adepte',
    'adepti',
    'adepto',
    'adequare',
    'adequarsi',
    'adequata',
    'adequate',
    'adequati',
    'adequato',
    'adequazione',
    'aderba',
    'aderbai',
    'aderbammo',
    'aderbando',
    'aderbano',
    'aderbante',
    'aderbanti',
    'aderbare',
    'aderbarono',
    'aderbasse',
    'aderbassero',
    'aderbassi',
    'aderbassimo',
    'aderbaste',
    'aderbasti',
    'aderbata',
    'aderbate',
    'aderbati',
    'aderbato',
    'aderbava',
    'aderbavamo',
    'aderbavano',
    'aderbavate',
    'aderbavi',
    'aderbavo',
    'aderbera',
    'aderberai',
    'aderberanno',
    'aderberebbe',
    'aderberei',
    'aderberemmo',
    'aderberemo',
    'aderbereste',
    'aderberesti',
    'aderberete',
    'aderbero',
    'aderbi',
    'aderbiamo',
    'aderbiate',
    'aderbino',
    'aderbo',
    'aderendo',
    'aderente',
    'aderenti',
    'aderenza',
    'aderenze',
    'aderga',
    'adergano',
    'aderge',
    'adergemmo',
    'adergendo',
    'adergendosi',
    'adergente',
    'adergenti',
    'adergera',
    'adergerai',
    'adergeranno',
    'adergere',
    'adergerebbe',
    'adergerei',
    'adergeremmo',
    'adergeremo',
    'adergereste',
    'adergeresti',
    'adergerete',
    'adergero',
    'adergersi',
    'adergesse',
    'adergessero',
    'adergessi',
    'adergessimo',
    'adergeste',
    'adergesti',
    'adergete',
    'adergeva',
    'adergevamo',
    'adergevano',
    'adergevate',
    'adergevi',
    'adergevo',
    'adergi',
    'adergiamo',
    'adergiate',
    'adergo',
    'adergono',
    'aderi',
    'aderiamo',
    'aderiate',
    'aderii',
    'aderimenti',
    'aderimento',
    'aderimmo',
    'aderira',
    'aderirai',
    'aderiranno',
    'aderire',
    'aderirebbe',
    'aderirebbero',
    'aderirei',
    'aderiremmo',
    'aderiremo',
    'aderireste',
    'aderiresti',
    'aderirete',
    'aderiro',
    'aderirono',
    'aderirà',
    'aderisca',
    'aderiscano',
    'aderisce',
    'aderisci',
    'aderisco',
    'aderiscono',
    'aderisse',
    'aderissero',
    'aderissi',
    'aderissimo',
    'aderiste',
    'aderisti',
    'aderita',
    'aderite',
    'aderiti',
    'aderito',
    'aderiva',
    'aderivamo',
    'aderivano',
    'aderivate',
    'aderivi',
    'aderivo',
    'aderizza',
    'aderizzai',
    'aderizzammo',
    'aderizzando',
    'aderizzano',
    'aderizzante',
    'aderizzanti',
    'aderizzare',
    'aderizzarono',
    'aderizzasse',
    'aderizzassi',
    'aderizzaste',
    'aderizzasti',
    'aderizzata',
    'aderizzate',
    'aderizzati',
    'aderizzato',
    'aderizzava',
    'aderizzavamo',
    'aderizzavano',
    'aderizzavate',
    'aderizzavi',
    'aderizzavo',
    'aderizzera',
    'aderizzerai',
    'aderizzerei',
    'aderizzeremo',
    'aderizzerete',
    'aderizzero',
    'aderizzi',
    'aderizziamo',
    'aderizziate',
    'aderizzino',
    'aderizzo',
    'adermina',
    'adermine',
    'adermo',
    'aderse',
    'adersero',
    'adersi',
    'aderta',
    'aderte',
    'aderti',
    'aderto',
    'adesa',
    'adesca',
    'adescabile',
    'adescabili',
    'adescai',
    'adescamenti',
    'adescamento',
    'adescammo',
    'adescando',
    'adescandola',
    'adescandole',
    'adescandoli',
    'adescandolo',
    'adescano',
    'adescante',
    'adescanti',
    'adescare',
    'adescarla',
    'adescarle',
    'adescarli',
    'adescarlo',
    'adescarono',
    'adescasse',
    'adescassero',
    'adescassi',
    'adescassimo',
    'adescaste',
    'adescasti',
    'adescata',
    'adescate',
    'adescati',
    'adescato',
    'adescatore',
    'adescatori',
    'adescatrice',
    'adescatrici',
    'adescava',
    'adescavamo',
    'adescavano',
    'adescavate',
    'adescavi',
    'adescavo',
    'adeschera',
    'adescherai',
    'adescheranno',
    'adescherebbe',
    'adescherei',
    'adescheremmo',
    'adescheremo',
    'adeschereste',
    'adescheresti',
    'adescherete',
    'adeschero',
    'adeschi',
    'adeschiamo',
    'adeschiate',
    'adeschino',
    'adesco',
    'adese',
    'adesi',
    'adesione',
    'adesioni',
    'adesiva',
    'adesive',
    'adesivi',
    'adesivita',
    'adesività',
    'adesivo',
    'adeso',
    'adespota',
    'adespote',
    'adespoti',
    'adespoto',
    'adesso',
    'adia',
    'adiabatica',
    'adiabatiche',
    'adiabatici',
    'adiabaticita',
    'adiabatico',
    'adiacente',
    'adiacenti',
    'adiacenza',
    'adiacenze',
    'adiacese',
    'adiacesi',
    'adiafora',
    'adiafore',
    'adiafori',
    'adiaforia',
    'adiaforie',
    'adiaforista',
    'adiaforiste',
    'adiaforisti',
    'adiaforo',
    'adiamo',
    'adianti',
    'adianto',
    'adiate',
    'adiatermana',
    'adiatermane',
    'adiatermani',
    'adiatermano',
    'adibendo',
    'adibente',
    'adibenti',
    'adibi',
    'adibiamo',
    'adibiate',
    'adibii',
    'adibimmo',
    'adibira',
    'adibirai',
    'adibiranno',
    'adibire',
    'adibirebbe',
    'adibirebbero',
    'adibirei',
    'adibiremmo',
    'adibiremo',
    'adibireste',
    'adibiresti',
    'adibirete',
    'adibiro',
    'adibirono',
    'adibirsi',
    'adibisca',
    'adibiscano',
    'adibisce',
    'adibisci',
    'adibisco',
    'adibiscono',
    'adibisse',
    'adibissero',
    'adibissi',
    'adibissimo',
    'adibiste',
    'adibisti',
    'adibita',
    'adibite',
    'adibiti',
    'adibito',
    'adibiva',
    'adibivamo',
    'adibivano',
    'adibivate',
    'adibivi',
    'adibivo',
    'adiettiva',
    'adiettive',
    'adiettivi',
    'adiettivo',
    'adige',
    'adigina',
    'adigrat',
    'adii',
    'adilia',
    'adilio',
    'adima',
    'adimai',
    'adimammo',
    'adimando',
    'adimandosi',
    'adimano',
    'adimante',
    'adimanti',
    'adimare',
    'adimaro',
    'adimarono',
    'adimarsi',
    'adimasse',
    'adimassero',
    'adimassi',
    'adimassimo',
    'adimaste',
    'adimasti',
    'adimata',
    'adimate',
    'adimati',
    'adimato',
    'adimava',
    'adimavamo',
    'adimavano',
    'adimavate',
    'adimavi',
    'adimavo',
    'adimera',
    'adimerai',
    'adimeranno',
    'adimerebbe',
    'adimerebbero',
    'adimerei',
    'adimeremmo',
    'adimeremo',
    'adimereste',
    'adimeresti',
    'adimerete',
    'adimero',
    'adimi',
    'adimiamo',
    'adimiate',
    'adimino',
    'adimiro',
    'adimmo',
    'adimo',
    'adina',
    'adinamia',
    'adinamie',
    'adinati',
    'adinato',
    'adino',
    'adinolfa',
    'adinolfo',
    'adio',
    'adionilla',
    'adipe',
    'adipi',
    'adipica',
    'adipiche',
    'adipici',
    'adipico',
    'adipocera',
    'adipocere',
    'adipociti',
    'adiponecrosi',
    'adiposa',
    'adipose',
    'adiposi',
    'adiposita',
    'adiposità',
    'adiposo',
    'adira',
    'adirai',
    'adirammo',
    'adirando',
    'adirandoci',
    'adirandomi',
    'adirandosi',
    'adirandoti',
    'adirandovi',
    'adiranno',
    'adirano',
    'adirante',
    'adiranti',
    'adirantisi',
    'adirarci',
    'adirare',
    'adirarmi',
    'adirarono',
    'adirarsi',
    'adirarti',
    'adirarvi',
    'adirasse',
    'adirassero',
    'adirassi',
    'adirassimo',
    'adiraste',
    'adirasti',
    'adirata',
    'adiratamente',
    'adirate',
    'adiratevi',
    'adirati',
    'adirato',
    'adiratomi',
    'adiratoti',
    'adirava',
    'adiravamo',
    'adiravano',
    'adiravate',
    'adiravi',
    'adiravo',
    'adire',
    'adirebbe',
    'adirebbero',
    'adirei',
    'adiremmo',
    'adiremo',
    'adirera',
    'adirerai',
    'adireranno',
    'adirerebbe',
    'adirerebbero',
    'adirerei',
    'adireremmo',
    'adireremo',
    'adirereste',
    'adireresti',
    'adirerete',
    'adirero',
    'adireste',
    'adiresti',
    'adirete',
    'adiri',
    'adiriamo',
    'adiriamoci',
    'adiriate',
    'adirino',
    'adiro',
    'adirono',
    'adisca',
    'adiscano',
    'adisce',
    'adisci',
    'adisco',
    'adiscono',
    'adisse',
    'adissero',
    'adissi',
    'adissimo',
    'adiste',
    'adisti',
    'adita',
    'adite',
    'aditi',
    'adito',
    'adiuto',
    'adiutore',
    'adiutori',
    'adiutoria',
    'adiutorie',
    'adiutorio',
    'adiutrice',
    'adiutrici',
    'adiuvante',
    'adiuvanti',
    'adiuvare',
    'adiva',
    'adivamo',
    'adivano',
    'adivate',
    'adivi',
    'adivo',
    'adizione',
    'adizioni',
    'adizzare',
    'admeto',
    'adnominale',
    'adnominali',
    'adocchi',
    'adocchia',
    'adocchiai',
    'adocchiammo',
    'adocchiamo',
    'adocchiando',
    'adocchiano',
    'adocchiante',
    'adocchianti',
    'adocchiare',
    'adocchiarono',
    'adocchiasse',
    'adocchiassi',
    'adocchiaste',
    'adocchiasti',
    'adocchiata',
    'adocchiate',
    'adocchiati',
    'adocchiato',
    'adocchiava',
    'adocchiavamo',
    'adocchiavano',
    'adocchiavate',
    'adocchiavi',
    'adocchiavo',
    'adocchiera',
    'adocchierai',
    'adocchierei',
    'adocchieremo',
    'adocchierete',
    'adocchiero',
    'adocchino',
    'adocchio',
    'adogmatica',
    'adogmatici',
    'adogmatico',
    'adolesc',
    'adolescente',
    'adolescenti',
    'adolescenza',
    'adolescenze',
    'adolfa',
    'adolfina',
    'adolfino',
    'adolfo',
    'adombra',
    'adombrabile',
    'adombrabili',
    'adombrai',
    'adombramenti',
    'adombramento',
    'adombrammo',
    'adombrando',
    'adombrandoci',
    'adombrandomi',
    'adombrandosi',
    'adombrandoti',
    'adombrandovi',
    'adombrano',
    'adombrante',
    'adombranti',
    'adombrantisi',
    'adombrarci',
    'adombrare',
    'adombrarmi',
    'adombrarono',
    'adombrarsi',
    'adombrarti',
    'adombrarvi',
    'adombrasse',
    'adombrassero',
    'adombrassi',
    'adombrassimo',
    'adombraste',
    'adombrasti',
    'adombrata',
    'adombrate',
    'adombratevi',
    'adombrati',
    'adombrato',
    'adombratomi',
    'adombratoti',
    'adombrava',
    'adombravamo',
    'adombravano',
    'adombravate',
    'adombravi',
    'adombravo',
    'adombrera',
    'adombrerai',
    'adombreranno',
    'adombrerebbe',
    'adombrerei',
    'adombreremmo',
    'adombreremo',
    'adombrereste',
    'adombreresti',
    'adombrerete',
    'adombrero',
    'adombri',
    'adombriamo',
    'adombriamoci',
    'adombriate',
    'adombrino',
    'adombro',
    'adona',
    'adonando',
    'adonandosi',
    'adonare',
    'adonarsi',
    'adonato',
    'adone',
    'adonella',
    'adonello',
    'adonesta',
    'adonestai',
    'adonestammo',
    'adonestando',
    'adonestano',
    'adonestante',
    'adonestanti',
    'adonestare',
    'adonestarono',
    'adonestasse',
    'adonestassi',
    'adonestaste',
    'adonestasti',
    'adonestata',
    'adonestate',
    'adonestati',
    'adonestato',
    'adonestava',
    'adonestavamo',
    'adonestavano',
    'adonestavate',
    'adonestavi',
    'adonestavo',
    'adonestera',
    'adonesterai',
    'adonesterei',
    'adonesteremo',
    'adonesterete',
    'adonestero',
    'adonesti',
    'adonestiamo',
    'adonestiate',
    'adonestino',
    'adonesto',
    'adoni',
    'adonide',
    'adonidi',
    'adonio',
    'adonta',
    'adontai',
    'adontamenti',
    'adontamento',
    'adontammo',
    'adontando',
    'adontandoci',
    'adontandomi',
    'adontandosi',
    'adontandoti',
    'adontandovi',
    'adontano',
    'adontante',
    'adontanti',
    'adontantisi',
    'adontarci',
    'adontare',
    'adontarmi',
    'adontarono',
    'adontarsi',
    'adontarti',
    'adontarvi',
    'adontasse',
    'adontassero',
    'adontassi',
    'adontassimo',
    'adontaste',
    'adontasti',
    'adontata',
    'adontate',
    'adontatevi',
    'adontati',
    'adontato',
    'adontatomi',
    'adontatoti',
    'adontava',
    'adontavamo',
    'adontavano',
    'adontavate',
    'adontavi',
    'adontavo',
    'adontera',
    'adonterai',
    'adonteranno',
    'adonterebbe',
    'adonterei',
    'adonteremmo',
    'adonteremo',
    'adontereste',
    'adonteresti',
    'adonterete',
    'adontero',
    'adonti',
    'adontiamo',
    'adontiamoci',
    'adontiate',
    'adontino',
    'adonto',
    'adopera',
    'adoperabile',
    'adoperabili',
    'adoperai',
    'adoperammo',
    'adoperando',
    'adoperandoci',
    'adoperandola',
    'adoperandole',
    'adoperandoli',
    'adoperandolo',
    'adoperandomi',
    'adoperandosi',
    'adoperandoti',
    'adoperandovi',
    'adoperano',
    'adoperante',
    'adoperanti',
    'adoperantisi',
    'adoperarci',
    'adoperare',
    'adoperarla',
    'adoperarle',
    'adoperarli',
    'adoperarlo',
    'adoperarmi',
    'adoperarono',
    'adoperarsi',
    'adoperarti',
    'adoperarvi',
    'adoperasse',
    'adoperassero',
    'adoperassi',
    'adoperassimo',
    'adoperaste',
    'adoperasti',
    'adoperata',
    'adoperate',
    'adoperatevi',
    'adoperati',
    'adoperato',
    'adoperatomi',
    'adoperatoti',
    'adoperava',
    'adoperavamo',
    'adoperavano',
    'adoperavate',
    'adoperavi',
    'adoperavo',
    'adoperera',
    'adopererai',
    'adopereranno',
    'adopererebbe',
    'adopererei',
    'adopereremmo',
    'adopereremo',
    'adoperereste',
    'adopereresti',
    'adopererete',
    'adoperero',
    'adopererà',
    'adoperi',
    'adoperiamo',
    'adoperiamoci',
    'adoperiate',
    'adoperino',
    'adopero',
    'adopra',
    'adoprabile',
    'adoprabili',
    'adoprai',
    'adoprammo',
    'adoprando',
    'adoprandoci',
    'adoprandola',
    'adoprandole',
    'adoprandoli',
    'adoprandolo',
    'adoprandomi',
    'adoprandosi',
    'adoprandoti',
    'adoprandovi',
    'adoprano',
    'adoprarci',
    'adoprare',
    'adoprarla',
    'adoprarle',
    'adoprarli',
    'adoprarlo',
    'adoprarmi',
    'adoprarono',
    'adoprarsi',
    'adoprarti',
    'adoprarvi',
    'adoprasse',
    'adoprassero',
    'adoprassi',
    'adoprassimo',
    'adopraste',
    'adoprasti',
    'adoprata',
    'adoprate',
    'adoprati',
    'adoprato',
    'adoprava',
    'adopravamo',
    'adopravano',
    'adopravate',
    'adopravi',
    'adopravo',
    'adoprera',
    'adoprerai',
    'adopreranno',
    'adoprerebbe',
    'adoprerei',
    'adopreremmo',
    'adopreremo',
    'adoprereste',
    'adopreresti',
    'adoprerete',
    'adoprero',
    'adopri',
    'adopriamo',
    'adopriate',
    'adoprino',
    'adopro',
    'adora',
    'adorabile',
    'adorabili',
    'adorabilita',
    'adorai',
    'adorala',
    'adorale',
    'adorali',
    'adoralo',
    'adorammo',
    'adoranda',
    'adorando',
    'adorandola',
    'adorandole',
    'adorandoli',
    'adorandolo',
    'adorano',
    'adorante',
    'adoranti',
    'adorare',
    'adorarla',
    'adorarle',
    'adorarli',
    'adorarlo',
    'adorarono',
    'adorasse',
    'adorassero',
    'adorassi',
    'adorassimo',
    'adoraste',
    'adorasti',
    'adorata',
    'adorate',
    'adorati',
    'adorato',
    'adoratore',
    'adoratori',
    'adoratrice',
    'adoratrici',
    'adorava',
    'adoravamo',
    'adoravano',
    'adoravate',
    'adoravi',
    'adoravo',
    'adorazione',
    'adorazioni',
    'adorera',
    'adorerai',
    'adoreranno',
    'adorerebbe',
    'adorerebbero',
    'adorerei',
    'adoreremmo',
    'adoreremo',
    'adorereste',
    'adoreresti',
    'adorerete',
    'adorero',
    'adorezza',
    'adorezzando',
    'adorezzare',
    'adori',
    'adoriamo',
    'adoriate',
    'adorino',
    'adorna',
    'adornabile',
    'adornabili',
    'adornai',
    'adornamenti',
    'adornamento',
    'adornammo',
    'adornando',
    'adornandoci',
    'adornandomi',
    'adornandosi',
    'adornandoti',
    'adornandovi',
    'adornano',
    'adornante',
    'adornanti',
    'adornantisi',
    'adornarci',
    'adornare',
    'adornarmi',
    'adornarono',
    'adornarsi',
    'adornarti',
    'adornarvi',
    'adornasse',
    'adornassero',
    'adornassi',
    'adornassimo',
    'adornaste',
    'adornasti',
    'adornata',
    'adornate',
    'adornatevi',
    'adornati',
    'adornato',
    'adornatomi',
    'adornatore',
    'adornatori',
    'adornatoti',
    'adornatrice',
    'adornatrici',
    'adornava',
    'adornavamo',
    'adornavano',
    'adornavate',
    'adornavi',
    'adornavo',
    'adorne',
    'adornera',
    'adornerai',
    'adorneranno',
    'adornerebbe',
    'adornerei',
    'adorneremmo',
    'adorneremo',
    'adornereste',
    'adorneresti',
    'adornerete',
    'adornero',
    'adorni',
    'adorniamo',
    'adorniamoci',
    'adorniate',
    'adornino',
    'adorno',
    'adoro',
    'adotta',
    'adottabile',
    'adottabili',
    'adottabilita',
    'adottai',
    'adottamenti',
    'adottamento',
    'adottammo',
    'adottanda',
    'adottande',
    'adottandi',
    'adottando',
    'adottano',
    'adottante',
    'adottanti',
    'adottare',
    'adottarlo',
    'adottarne',
    'adottarono',
    'adottasse',
    'adottassero',
    'adottassi',
    'adottassimo',
    'adottaste',
    'adottasti',
    'adottata',
    'adottate',
    'adottati',
    'adottato',
    'adottatore',
    'adottatori',
    'adottatrice',
    'adottatrici',
    'adottava',
    'adottavamo',
    'adottavano',
    'adottavate',
    'adottavi',
    'adottavo',
    'adottera',
    'adotterai',
    'adotteranno',
    'adotterebbe',
    'adotterei',
    'adotteremmo',
    'adotteremo',
    'adottereste',
    'adotteresti',
    'adotterete',
    'adottero',
    'adotti',
    'adottiamo',
    'adottiate',
    'adottino',
    'adottiva',
    'adottive',
    'adottivi',
    'adottivo',
    'adotto',
    'adoxa',
    'adozianismi',
    'adozianismo',
    'adozianista',
    'adozianiste',
    'adozianisti',
    'adozione',
    'adozioni',
    'adozionismi',
    'adozionismo',
    'adozionista',
    'adozioniste',
    'adozionisti',
    'adra',
    'adragante',
    'adraganti',
    'adrasta',
    'adrasto',
    'adre',
    'adreano',
    'adrema',
    'adrematrice',
    'adrematrici',
    'adremista',
    'adremiste',
    'adremisti',
    'adrenale',
    'adrenali',
    'adrenalina',
    'adrenaline',
    'adrenalinici',
    'adrenalinico',
    'adrenergica',
    'adrenergiche',
    'adrenergici',
    'adrenergico',
    'adri',
    'adria',
    'adriaca',
    'adriache',
    'adriaci',
    'adriaco',
    'adriana',
    'adriane',
    'adriani',
    'adriano',
    'adrianopoli',
    'adriatica',
    'adriatiche',
    'adriatici',
    'adriatico',
    'adrio',
    'adrizza',
    'adrizzando',
    'adrizzano',
    'adrizzare',
    'adrizzarono',
    'adrizzata',
    'adrizzate',
    'adrizzati',
    'adrizzato',
    'adrizzatrice',
    'adrizzatrici',
    'adrizzava',
    'adrizzavano',
    'adrizzazione',
    'adrizzo',
    'adro',
    'adroma',
    'adromi',
    'adrone',
    'adroni',
    'adronica',
    'adroniche',
    'adronici',
    'adronico',
    'adsorbendo',
    'adsorbente',
    'adsorbenti',
    'adsorbi',
    'adsorbiamo',
    'adsorbiate',
    'adsorbii',
    'adsorbimenti',
    'adsorbimento',
    'adsorbimmo',
    'adsorbira',
    'adsorbirai',
    'adsorbiranno',
    'adsorbire',
    'adsorbirebbe',
    'adsorbirei',
    'adsorbiremmo',
    'adsorbiremo',
    'adsorbireste',
    'adsorbiresti',
    'adsorbirete',
    'adsorbiro',
    'adsorbirono',
    'adsorbisca',
    'adsorbiscano',
    'adsorbisce',
    'adsorbisci',
    'adsorbisco',
    'adsorbiscono',
    'adsorbisse',
    'adsorbissero',
    'adsorbissi',
    'adsorbissimo',
    'adsorbiste',
    'adsorbisti',
    'adsorbita',
    'adsorbite',
    'adsorbiti',
    'adsorbito',
    'adsorbiva',
    'adsorbivamo',
    'adsorbivano',
    'adsorbivate',
    'adsorbivi',
    'adsorbivo',
    'adstrati',
    'adstrato',
    'adstratri',
    'adstratro',
    'adua',
    'aduana',
    'adugge',
    'aduggera',
    'aduggerai',
    'aduggeranno',
    'aduggere',
    'aduggerebbe',
    'aduggerei',
    'aduggeremmo',
    'aduggeremo',
    'aduggereste',
    'aduggeresti',
    'aduggerete',
    'aduggero',
    'aduggi',
    'aduggia',
    'aduggiai',
    'aduggiammo',
    'aduggiamo',
    'aduggiando',
    'aduggiandosi',
    'aduggiano',
    'aduggiante',
    'aduggianti',
    'aduggiare',
    'aduggiarono',
    'aduggiarsi',
    'aduggiasse',
    'aduggiassero',
    'aduggiassi',
    'aduggiassimo',
    'aduggiaste',
    'aduggiasti',
    'aduggiata',
    'aduggiate',
    'aduggiati',
    'aduggiato',
    'aduggiava',
    'aduggiavamo',
    'aduggiavano',
    'aduggiavate',
    'aduggiavi',
    'aduggiavo',
    'aduggimento',
    'aduggino',
    'aduggio',
    'adugnare',
    'aduilio',
    'aduino',
    'adula',
    'adulabile',
    'adulabili',
    'adulai',
    'adulammo',
    'adulando',
    'adulandoci',
    'adulandomi',
    'adulandosi',
    'adulandoti',
    'adulandovi',
    'adulano',
    'adulante',
    'adulanti',
    'adulantisi',
    'adularci',
    'adulare',
    'adularia',
    'adularie',
    'adularli',
    'adularmi',
    'adularono',
    'adularsi',
    'adularti',
    'adularvi',
    'adulasse',
    'adulassero',
    'adulassi',
    'adulassimo',
    'adulaste',
    'adulasti',
    'adulata',
    'adulate',
    'adulatevi',
    'adulati',
    'adulato',
    'adulatomi',
    'adulatore',
    'adulatori',
    'adulatoria',
    'adulatorie',
    'adulatorio',
    'adulatoti',
    'adulatrice',
    'adulatrici',
    'adulava',
    'adulavamo',
    'adulavano',
    'adulavate',
    'adulavi',
    'adulavo',
    'adulazione',
    'adulazioni',
    'adulera',
    'adulerai',
    'aduleranno',
    'adulerebbe',
    'adulerebbero',
    'adulerei',
    'aduleremmo',
    'aduleremo',
    'adulereste',
    'aduleresti',
    'adulerete',
    'adulero',
    'aduli',
    'aduliamo',
    'aduliamoci',
    'aduliate',
    'adulino',
    'adulo',
    'adulta',
    'adulte',
    'adultera',
    'adulterabile',
    'adulterabili',
    'adulterai',
    'adulterammo',
    'adulterando',
    'adulterano',
    'adulterante',
    'adulteranti',
    'adulterare',
    'adulterarono',
    'adulterasse',
    'adulterassi',
    'adulteraste',
    'adulterasti',
    'adulterata',
    'adulterate',
    'adulterati',
    'adulterato',
    'adulteratore',
    'adulteratori',
    'adulterava',
    'adulteravamo',
    'adulteravano',
    'adulteravate',
    'adulteravi',
    'adulteravo',
    'adultere',
    'adulterera',
    'adultererai',
    'adultererei',
    'adultereremo',
    'adultererete',
    'adulterero',
    'adultererà',
    'adulteri',
    'adulteriamo',
    'adulteriate',
    'adulterii',
    'adulterina',
    'adulterine',
    'adulterini',
    'adulterino',
    'adulterio',
    'adultero',
    'adulti',
    'adulto',
    'aduna',
    'adunabile',
    'adunabili',
    'adunai',
    'adunamenti',
    'adunamento',
    'adunammo',
    'adunando',
    'adunandoci',
    'adunandomi',
    'adunandosi',
    'adunandoti',
    'adunandovi',
    'adunano',
    'adunante',
    'adunanti',
    'adunantisi',
    'adunanza',
    'adunanze',
    'adunarci',
    'adunare',
    'adunarmi',
    'adunarono',
    'adunarsi',
    'adunarti',
    'adunarvi',
    'adunasse',
    'adunassero',
    'adunassi',
    'adunassimo',
    'adunaste',
    'adunasti',
    'adunata',
    'adunate',
    'adunatevi',
    'adunati',
    'adunato',
    'adunatomi',
    'adunatore',
    'adunatori',
    'adunatoti',
    'adunatrice',
    'adunatrici',
    'adunava',
    'adunavamo',
    'adunavano',
    'adunavate',
    'adunavi',
    'adunavo',
    'adunazione',
    'adunazioni',
    'adunca',
    'adunche',
    'adunchi',
    'adunco',
    'adunera',
    'adunerai',
    'aduneranno',
    'adunerebbe',
    'adunerebbero',
    'adunerei',
    'aduneremmo',
    'aduneremo',
    'adunereste',
    'aduneresti',
    'adunerete',
    'adunero',
    'adunghi',
    'adunghia',
    'adunghiai',
    'adunghiammo',
    'adunghiamo',
    'adunghiando',
    'adunghiano',
    'adunghiante',
    'adunghianti',
    'adunghiare',
    'adunghiarono',
    'adunghiasse',
    'adunghiassi',
    'adunghiaste',
    'adunghiasti',
    'adunghiata',
    'adunghiate',
    'adunghiati',
    'adunghiato',
    'adunghiava',
    'adunghiavamo',
    'adunghiavano',
    'adunghiavate',
    'adunghiavi',
    'adunghiavo',
    'adunghiera',
    'adunghierai',
    'adunghierei',
    'adunghieremo',
    'adunghierete',
    'adunghiero',
    'adunghino',
    'adunghio',
    'aduni',
    'aduniamo',
    'aduniamoci',
    'aduniate',
    'adunino',
    'aduno',
    'adunque',
    'aduo',
    'adusa',
    'adusai',
    'adusammo',
    'adusando',
    'adusandoci',
    'adusandomi',
    'adusandosi',
    'adusandoti',
    'adusandovi',
    'adusano',
    'adusante',
    'adusanti',
    'adusantisi',
    'adusarci',
    'adusare',
    'adusarmi',
    'adusarono',
    'adusarsi',
    'adusarti',
    'adusarvi',
    'adusasse',
    'adusassero',
    'adusassi',
    'adusassimo',
    'adusaste',
    'adusasti',
    'adusata',
    'adusate',
    'adusatevi',
    'adusati',
    'adusato',
    'adusatomi',
    'adusatoti',
    'adusava',
    'adusavamo',
    'adusavano',
    'adusavate',
    'adusavi',
    'adusavo',
    'aduse',
    'adusera',
    'aduserai',
    'aduseranno',
    'aduserebbe',
    'aduserebbero',
    'aduserei',
    'aduseremmo',
    'aduseremo',
    'adusereste',
    'aduseresti',
    'aduserete',
    'adusero',
    'adusi',
    'adusiamo',
    'adusiamoci',
    'adusiate',
    'adusino',
    'aduso',
    'adusta',
    'aduste',
    'adusti',
    'adustione',
    'adustioni',
    'adusto',
    'adverbale',
    'adverbali',
    'advertising',
    'advertizing',
    'adynaton',
    'aedes',
    'aedi',
    'aedo',
    'aequo',
    'aera',
    'aeraggi',
    'aeraggio',
    'aerai',
    'aeramenti',
    'aeramento',
    'aerammo',
    'aerando',
    'aerandoci',
    'aerandomi',
    'aerandosi',
    'aerandoti',
    'aerandovi',
    'aerano',
    'aerante',
    'aeranti',
    'aerantisi',
    'aerarci',
    'aerare',
    'aerarmi',
    'aerarono',
    'aerarsi',
    'aerarti',
    'aerarvi',
    'aerasse',
    'aerassero',
    'aerassi',
    'aerassimo',
    'aeraste',
    'aerasti',
    'aerata',
    'aerate',
    'aeratevi',
    'aerati',
    'aerato',
    'aeratomi',
    'aeratore',
    'aeratori',
    'aeratoti',
    'aerava',
    'aeravamo',
    'aeravano',
    'aeravate',
    'aeravi',
    'aeravo',
    'aerazione',
    'aerazioni',
    'aere',
    'aerea',
    'aereare',
    'aereatore',
    'aereazione',
    'aeree',
    'aerei',
    'aereo',
    'aereonautica',
    'aereonavale',
    'aereonavali',
    'aerera',
    'aererai',
    'aereranno',
    'aererebbe',
    'aererebbero',
    'aererei',
    'aereremmo',
    'aereremo',
    'aerereste',
    'aereresti',
    'aererete',
    'aerero',
    'aeri',
    'aeriamo',
    'aeriamoci',
    'aeriate',
    'aericola',
    'aericole',
    'aericoli',
    'aericolo',
    'aerifera',
    'aerifere',
    'aeriferi',
    'aerifero',
    'aeriforme',
    'aeriformi',
    'aerina',
    'aerine',
    'aerini',
    'aerino',
    'aero',
    'aerobacter',
    'aerobi',
    'aerobica',
    'aerobiche',
    'aerobici',
    'aerobico',
    'aerobigram',
    'aerobio',
    'aerobiosi',
    'aerobrigata',
    'aerobrigate',
    'aerobus',
    'aerocentri',
    'aerocentro',
    'aerocisterna',
    'aerocisterne',
    'aeroclub',
    'aerodina',
    'aerodinamica',
    'aerodinamici',
    'aerodinamico',
    'aerodine',
    'aerodromi',
    'aerodromo',
    'aerofagia',
    'aerofagie',
    'aerofari',
    'aerofaro',
    'aerofila',
    'aerofile',
    'aerofili',
    'aerofilli',
    'aerofillo',
    'aerofilo',
    'aerofisica',
    'aerofisiche',
    'aerofita',
    'aerofite',
    'aerofiti',
    'aerofito',
    'aerofobia',
    'aerofobie',
    'aerofoni',
    'aerofonista',
    'aerofoniste',
    'aerofonisti',
    'aerofono',
    'aerofori',
    'aeroforo',
    'aerofototeca',
    'aerogenes',
    'aerogetti',
    'aerogetto',
    'aerogiri',
    'aerogiro',
    'aerografi',
    'aerografia',
    'aerografie',
    'aerografista',
    'aerografiste',
    'aerografisti',
    'aerografo',
    'aerogramma',
    'aerogrammi',
    'aerolinea',
    'aerolinee',
    'aerolite',
    'aeroliti',
    'aerolito',
    'aerologa',
    'aerologhe',
    'aerologi',
    'aerologia',
    'aerologica',
    'aerologiche',
    'aerologici',
    'aerologico',
    'aerologie',
    'aerologista',
    'aerologiste',
    'aerologisti',
    'aerologo',
    'aeromante',
    'aeromanti',
    'aeromanzia',
    'aeromanzie',
    'aerometri',
    'aerometria',
    'aerometrie',
    'aerometro',
    'aeromobile',
    'aeromobili',
    'aeromodelli',
    'aeromodello',
    'aeromonas',
    'aeromoti',
    'aeromoto',
    'aeromotore',
    'aeromotori',
    'aeronauta',
    'aeronaute',
    'aeronauti',
    'aeronautica',
    'aeronautiche',
    'aeronautici',
    'aeronautico',
    'aeronavale',
    'aeronavali',
    'aeronave',
    'aeronavi',
    'aeronomia',
    'aeropenna',
    'aeropenne',
    'aeropittura',
    'aeroplancton',
    'aeroplani',
    'aeroplano',
    'aeroponica',
    'aeroponiche',
    'aeroporti',
    'aeroporto',
    'aeroportuale',
    'aeroportuali',
    'aeroposta',
    'aeropostale',
    'aeropostali',
    'aeroposte',
    'aerorazzi',
    'aerorazzo',
    'aeroreattore',
    'aeroreattori',
    'aerorimessa',
    'aerorimesse',
    'aerosa',
    'aerosbarchi',
    'aerosbarco',
    'aeroscali',
    'aeroscalo',
    'aeroscopi',
    'aeroscopio',
    'aerose',
    'aeroservizi',
    'aeroservizio',
    'aerosfera',
    'aerosi',
    'aerosiluri',
    'aerosiluro',
    'aeroso',
    'aerosoccorsi',
    'aerosoccorso',
    'aerosol',
    'aerosolizza',
    'aerosolizzai',
    'aerosolizzi',
    'aerosolizzo',
    'aerospazi',
    'aerospaziale',
    'aerospaziali',
    'aerospazio',
    'aerostati',
    'aerostatica',
    'aerostatiche',
    'aerostatici',
    'aerostatico',
    'aerostato',
    'aerostazione',
    'aerostazioni',
    'aerostiere',
    'aerostieri',
    'aerotassi',
    'aerotaxi',
    'aerotecnica',
    'aerotecniche',
    'aerotecnici',
    'aerotecnico',
    'aeroterapia',
    'aeroterapie',
    'aerotermi',
    'aerotermica',
    'aerotermiche',
    'aerotermici',
    'aerotermico',
    'aerotermo',
    'aerotraina',
    'aerotrainai',
    'aerotrainano',
    'aerotrainare',
    'aerotrainata',
    'aerotrainate',
    'aerotrainati',
    'aerotrainato',
    'aerotrainava',
    'aerotrainavi',
    'aerotrainavo',
    'aerotrainera',
    'aerotrainero',
    'aerotraini',
    'aerotrainino',
    'aerotraino',
    'aerotreni',
    'aerotreno',
    'aerotropismi',
    'aerotropismo',
    'aeroturbina',
    'aeroturbine',
    'aeroturismi',
    'aeroturismo',
    'aerovia',
    'aerovie',
    'aeruginosa',
    'aeterno',
    'aethiops',
    'afaca',
    'afache',
    'afachia',
    'afachie',
    'afaci',
    'afaco',
    'afagia',
    'afagie',
    'afanite',
    'afaniti',
    'afanitica',
    'afanitiche',
    'afanitici',
    'afanitico',
    'afanitteri',
    'afanittero',
    'afasia',
    'afasica',
    'afasiche',
    'afasici',
    'afasico',
    'afasie',
    'afata',
    'afate',
    'afati',
    'afato',
    'afebbrile',
    'afebbrili',
    'afeli',
    'afeliaca',
    'afeliache',
    'afeliaci',
    'afeliaco',
    'afelio',
    'aferesi',
    'aferetica',
    'aferetiche',
    'aferetici',
    'aferetico',
    'afetica',
    'afetiche',
    'afetici',
    'afetico',
    'afetoioidei',
    'afetoioideo',
    'affa',
    'affabile',
    'affabili',
    'affabilita',
    'affabilità',
    'affabilmente',
    'affabula',
    'affabulai',
    'affabulammo',
    'affabulando',
    'affabulano',
    'affabulante',
    'affabulanti',
    'affabulare',
    'affabularono',
    'affabulasse',
    'affabulassi',
    'affabulaste',
    'affabulasti',
    'affabulata',
    'affabulate',
    'affabulati',
    'affabulativa',
    'affabulative',
    'affabulativi',
    'affabulativo',
    'affabulato',
    'affabulatore',
    'affabulatori',
    'affabulava',
    'affabulavamo',
    'affabulavano',
    'affabulavate',
    'affabulavi',
    'affabulavo',
    'affabulera',
    'affabulerai',
    'affabulerei',
    'affabuleremo',
    'affabulerete',
    'affabulero',
    'affabuli',
    'affabuliamo',
    'affabuliate',
    'affabulino',
    'affabulo',
    'affaccenda',
    'affaccendai',
    'affaccendano',
    'affaccendare',
    'affaccendata',
    'affaccendate',
    'affaccendati',
    'affaccendato',
    'affaccendava',
    'affaccendavi',
    'affaccendavo',
    'affaccendera',
    'affaccendero',
    'affaccendi',
    'affaccendino',
    'affaccendo',
    'affaccera',
    'affaccerai',
    'affacceranno',
    'affaccerebbe',
    'affaccerei',
    'affacceremmo',
    'affacceremo',
    'affaccereste',
    'affacceresti',
    'affaccerete',
    'affaccero',
    'affaccetta',
    'affaccettai',
    'affaccettano',
    'affaccettare',
    'affaccettata',
    'affaccettate',
    'affaccettati',
    'affaccettato',
    'affaccettava',
    'affaccettavi',
    'affaccettavo',
    'affaccettera',
    'affaccettero',
    'affaccetti',
    'affaccettino',
    'affaccetto',
    'affacchina',
    'affacchinai',
    'affacchinano',
    'affacchinare',
    'affacchinata',
    'affacchinate',
    'affacchinati',
    'affacchinato',
    'affacchinava',
    'affacchinavi',
    'affacchinavo',
    'affacchinera',
    'affacchinero',
    'affacchini',
    'affacchinino',
    'affacchino',
    'affacci',
    'affaccia',
    'affacciai',
    'affacciammo',
    'affacciamo',
    'affacciamoci',
    'affacciando',
    'affacciano',
    'affacciante',
    'affaccianti',
    'affacciarci',
    'affacciare',
    'affacciarmi',
    'affacciarono',
    'affacciarsi',
    'affacciarti',
    'affacciarvi',
    'affacciasse',
    'affacciassi',
    'affacciaste',
    'affacciasti',
    'affacciata',
    'affacciate',
    'affacciatevi',
    'affacciati',
    'affacciato',
    'affacciatomi',
    'affacciatoti',
    'affacciava',
    'affacciavamo',
    'affacciavano',
    'affacciavate',
    'affacciavi',
    'affacciavo',
    'affaccino',
    'affaccio',
    'affacendosi',
    'affacesse',
    'affacessero',
    'affaceva',
    'affacevano',
    'affagotta',
    'affagottai',
    'affagottammo',
    'affagottando',
    'affagottano',
    'affagottante',
    'affagottanti',
    'affagottarci',
    'affagottare',
    'affagottarmi',
    'affagottarsi',
    'affagottarti',
    'affagottarvi',
    'affagottasse',
    'affagottassi',
    'affagottaste',
    'affagottasti',
    'affagottata',
    'affagottate',
    'affagottati',
    'affagottato',
    'affagottava',
    'affagottavi',
    'affagottavo',
    'affagottera',
    'affagotterai',
    'affagotterei',
    'affagottero',
    'affagotti',
    'affagottiamo',
    'affagottiate',
    'affagottino',
    'affagotto',
    'affaire',
    'affaires',
    'affalda',
    'affaldando',
    'affaldano',
    'affaldare',
    'affaldata',
    'affaldate',
    'affaldati',
    'affaldato',
    'affaldella',
    'affaldellai',
    'affaldellano',
    'affaldellare',
    'affaldellata',
    'affaldellate',
    'affaldellati',
    'affaldellato',
    'affaldellava',
    'affaldellavi',
    'affaldellavo',
    'affaldellera',
    'affaldellero',
    'affaldelli',
    'affaldellino',
    'affaldello',
    'affama',
    'affamai',
    'affamammo',
    'affamando',
    'affamano',
    'affamante',
    'affamanti',
    'affamare',
    'affamarono',
    'affamasse',
    'affamassero',
    'affamassi',
    'affamassimo',
    'affamaste',
    'affamasti',
    'affamata',
    'affamate',
    'affamati',
    'affamato',
    'affamatore',
    'affamatori',
    'affamatrice',
    'affamatrici',
    'affamava',
    'affamavamo',
    'affamavano',
    'affamavate',
    'affamavi',
    'affamavo',
    'affamera',
    'affamerai',
    'affameranno',
    'affamerebbe',
    'affamerei',
    'affameremmo',
    'affameremo',
    'affamereste',
    'affameresti',
    'affamerete',
    'affamero',
    'affami',
    'affamiamo',
    'affamiate',
    'affamino',
    'affamo',
    'affanna',
    'affannai',
    'affannamenti',
    'affannamento',
    'affannammo',
    'affannando',
    'affannandoci',
    'affannandomi',
    'affannandosi',
    'affannandoti',
    'affannandovi',
    'affannano',
    'affannante',
    'affannanti',
    'affannantisi',
    'affannarci',
    'affannare',
    'affannarmi',
    'affannarono',
    'affannarsi',
    'affannarti',
    'affannarvi',
    'affannasse',
    'affannassero',
    'affannassi',
    'affannassimo',
    'affannaste',
    'affannasti',
    'affannata',
    'affannate',
    'affannatevi',
    'affannati',
    'affannato',
    'affannatomi',
    'affannatoti',
    'affannava',
    'affannavamo',
    'affannavano',
    'affannavate',
    'affannavi',
    'affannavo',
    'affannera',
    'affannerai',
    'affanneranno',
    'affannerebbe',
    'affannerei',
    'affanneremmo',
    'affanneremo',
    'affannereste',
    'affanneresti',
    'affannerete',
    'affannero',
    'affanni',
    'affanniamo',
    'affanniamoci',
    'affanniate',
    'affannino',
    'affanno',
    'affannona',
    'affannone',
    'affannoni',
    'affannosa',
    'affannose',
    'affannosi',
    'affannoso',
    'affante',
    'affar',
    'affara',
    'affaracci',
    'affaraccio',
    'affaranno',
    'affardella',
    'affardellai',
    'affardellano',
    'affardellare',
    'affardellata',
    'affardellate',
    'affardellati',
    'affardellato',
    'affardellava',
    'affardellavi',
    'affardellavo',
    'affardellera',
    'affardellero',
    'affardelli',
    'affardellino',
    'affardello',
    'affare',
    'affarebbe',
    'affarebbero',
    'affaretti',
    'affaretto',
    'affari',
    'affarii',
    'affarini',
    'affarino',
    'affario',
    'affarismi',
    'affarismo',
    'affarista',
    'affariste',
    'affaristi',
    'affaristica',
    'affaristiche',
    'affaristici',
    'affaristico',
    'affarone',
    'affaroni',
    'affarsi',
    'affarucci',
    'affaruccio',
    'affascera',
    'affascerai',
    'affasceranno',
    'affascerebbe',
    'affascerei',
    'affasceremmo',
    'affasceremo',
    'affascereste',
    'affasceresti',
    'affascerete',
    'affascero',
    'affasci',
    'affascia',
    'affasciai',
    'affasciammo',
    'affasciamo',
    'affasciando',
    'affasciano',
    'affasciante',
    'affascianti',
    'affasciare',
    'affasciarono',
    'affasciasse',
    'affasciassi',
    'affasciaste',
    'affasciasti',
    'affasciata',
    'affasciate',
    'affasciati',
    'affasciato',
    'affasciatura',
    'affasciature',
    'affasciava',
    'affasciavamo',
    'affasciavano',
    'affasciavate',
    'affasciavi',
    'affasciavo',
    'affascina',
    'affascinai',
    'affascinammo',
    'affascinando',
    'affascinano',
    'affascinante',
    'affascinanti',
    'affascinare',
    'affascinasse',
    'affascinassi',
    'affascinaste',
    'affascinasti',
    'affascinata',
    'affascinate',
    'affascinati',
    'affascinato',
    'affascinava',
    'affascinavi',
    'affascinavo',
    'affascinera',
    'affascinerai',
    'affascinerei',
    'affascinero',
    'affascini',
    'affasciniamo',
    'affasciniate',
    'affascinino',
    'affascino',
    'affascio',
    'affastella',
    'affastellai',
    'affastellano',
    'affastellare',
    'affastellata',
    'affastellate',
    'affastellati',
    'affastellato',
    'affastellava',
    'affastellavi',
    'affastellavo',
    'affastellera',
    'affastellero',
    'affastelli',
    'affastellii',
    'affastellino',
    'affastellio',
    'affastello',
    'affatica',
    'affaticai',
    'affaticammo',
    'affaticando',
    'affaticano',
    'affaticante',
    'affaticanti',
    'affaticarci',
    'affaticare',
    'affaticarmi',
    'affaticarne',
    'affaticarono',
    'affaticarsi',
    'affaticarti',
    'affaticarvi',
    'affaticasse',
    'affaticassi',
    'affaticaste',
    'affaticasti',
    'affaticata',
    'affaticate',
    'affaticatevi',
    'affaticati',
    'affaticato',
    'affaticatomi',
    'affaticatoti',
    'affaticava',
    'affaticavamo',
    'affaticavano',
    'affaticavate',
    'affaticavi',
    'affaticavo',
    'affatichera',
    'affaticherai',
    'affaticherei',
    'affatichero',
    'affatichi',
    'affatichiamo',
    'affatichiate',
    'affatichino',
    'affatico',
    'affatto',
    'affattura',
    'affatturai',
    'affatturammo',
    'affatturando',
    'affatturano',
    'affatturante',
    'affatturanti',
    'affatturare',
    'affatturasse',
    'affatturassi',
    'affatturaste',
    'affatturasti',
    'affatturata',
    'affatturate',
    'affatturati',
    'affatturato',
    'affatturava',
    'affatturavi',
    'affatturavo',
    'affatturera',
    'affatturerai',
    'affatturerei',
    'affatturero',
    'affatturi',
    'affatturiamo',
    'affatturiate',
    'affatturino',
    'affatturo',
    'affazzona',
    'affazzonando',
    'affazzonano',
    'affazzonare',
    'affazzonasse',
    'affazzonata',
    'affazzonate',
    'affazzonati',
    'affazzonato',
    'affazzonava',
    'affazzoni',
    'affazzonino',
    'affazzono',
    'affe',
    'affece',
    'affecero',
    'afferendo',
    'afferente',
    'afferenti',
    'afferenza',
    'afferenze',
    'afferi',
    'afferiamo',
    'afferiate',
    'afferii',
    'afferimmo',
    'afferira',
    'afferirai',
    'afferiranno',
    'afferire',
    'afferirebbe',
    'afferirei',
    'afferiremmo',
    'afferiremo',
    'afferireste',
    'afferiresti',
    'afferirete',
    'afferiro',
    'afferirono',
    'afferisca',
    'afferiscano',
    'afferisce',
    'afferisci',
    'afferisco',
    'afferiscono',
    'afferisse',
    'afferissero',
    'afferissi',
    'afferissimo',
    'afferiste',
    'afferisti',
    'afferita',
    'afferite',
    'afferiti',
    'afferito',
    'afferiva',
    'afferivamo',
    'afferivano',
    'afferivate',
    'afferivi',
    'afferivo',
    'afferma',
    'affermabile',
    'affermabili',
    'affermai',
    'affermammo',
    'affermando',
    'affermandoci',
    'affermandomi',
    'affermandosi',
    'affermandoti',
    'affermandovi',
    'affermano',
    'affermante',
    'affermanti',
    'affermantisi',
    'affermarci',
    'affermare',
    'affermarlo',
    'affermarmi',
    'affermarono',
    'affermarsi',
    'affermarti',
    'affermarvi',
    'affermasse',
    'affermassero',
    'affermassi',
    'affermassimo',
    'affermaste',
    'affermasti',
    'affermata',
    'affermate',
    'affermatevi',
    'affermati',
    'affermativa',
    'affermative',
    'affermativi',
    'affermativo',
    'affermato',
    'affermatomi',
    'affermatore',
    'affermatori',
    'affermatoti',
    'affermatrice',
    'affermatrici',
    'affermava',
    'affermavamo',
    'affermavano',
    'affermavate',
    'affermavi',
    'affermavo',
    'affermazione',
    'affermazioni',
    'affermera',
    'affermerai',
    'affermeranno',
    'affermerebbe',
    'affermerei',
    'affermeremmo',
    'affermeremo',
    'affermereste',
    'affermeresti',
    'affermerete',
    'affermero',
    'affermi',
    'affermiamo',
    'affermiamoci',
    'affermiate',
    'affermino',
    'affermo',
    'affermò',
    'afferra',
    'afferrabile',
    'afferrabili',
    'afferrai',
    'afferrammo',
    'afferrando',
    'afferrandoci',
    'afferrandola',
    'afferrandole',
    'afferrandoli',
    'afferrandolo',
    'afferrandomi',
    'afferrandosi',
    'afferrandoti',
    'afferrandovi',
    'afferrano',
    'afferrante',
    'afferranti',
    'afferrantisi',
    'afferrarci',
    'afferrare',
    'afferrarla',
    'afferrarle',
    'afferrarli',
    'afferrarlo',
    'afferrarmi',
    'afferrarono',
    'afferrarsi',
    'afferrarti',
    'afferrarvi',
    'afferrasse',
    'afferrassero',
    'afferrassi',
    'afferrassimo',
    'afferraste',
    'afferrasti',
    'afferrata',
    'afferrate',
    'afferratevi',
    'afferrati',
    'afferrato',
    'afferratomi',
    'afferratoti',
    'afferrava',
    'afferravamo',
    'afferravano',
    'afferravate',
    'afferravi',
    'afferravo',
    'afferrera',
    'afferrerai',
    'afferreranno',
    'afferrerebbe',
    'afferrerei',
    'afferreremmo',
    'afferreremo',
    'afferrereste',
    'afferreresti',
    'afferrerete',
    'afferrero',
    'afferri',
    'afferriamo',
    'afferriamoci',
    'afferriate',
    'afferrino',
    'afferro',
    'affertilendo',
    'affertilente',
    'affertilenti',
    'affertili',
    'affertiliamo',
    'affertiliate',
    'affertilii',
    'affertilimmo',
    'affertilira',
    'affertilirai',
    'affertilire',
    'affertilirei',
    'affertiliro',
    'affertilisca',
    'affertilisce',
    'affertilisci',
    'affertilisco',
    'affertilisse',
    'affertilissi',
    'affertiliste',
    'affertilisti',
    'affertilita',
    'affertilite',
    'affertiliti',
    'affertilito',
    'affertiliva',
    'affertilivi',
    'affertilivo',
    'affetta',
    'affettai',
    'affettamenti',
    'affettamento',
    'affettammo',
    'affettando',
    'affettandoci',
    'affettandomi',
    'affettandosi',
    'affettandoti',
    'affettandovi',
    'affettano',
    'affettante',
    'affettanti',
    'affettantisi',
    'affettarci',
    'affettare',
    'affettarmi',
    'affettarono',
    'affettarsi',
    'affettarti',
    'affettarvi',
    'affettasse',
    'affettassero',
    'affettassi',
    'affettassimo',
    'affettaste',
    'affettasti',
    'affettata',
    'affettate',
    'affettatevi',
    'affettati',
    'affettato',
    'affettatomi',
    'affettatore',
    'affettatori',
    'affettatoti',
    'affettatrice',
    'affettatrici',
    'affettatura',
    'affettature',
    'affettava',
    'affettavamo',
    'affettavano',
    'affettavate',
    'affettavi',
    'affettavo',
    'affettazione',
    'affettazioni',
    'affette',
    'affettera',
    'affetterai',
    'affetteranno',
    'affetterebbe',
    'affetterei',
    'affetteremmo',
    'affetteremo',
    'affettereste',
    'affetteresti',
    'affetterete',
    'affettero',
    'affetti',
    'affettiamo',
    'affettiamoci',
    'affettiate',
    'affettino',
    'affettiva',
    'affettive',
    'affettivi',
    'affettivita',
    'affettività',
    'affettivo',
    'affetto',
    'affettuosa',
    'affettuose',
    'affettuosi',
    'affettuosita',
    'affettuosità',
    'affettuoso',
    'affeziona',
    'affezionai',
    'affezionammo',
    'affezionando',
    'affezionano',
    'affezionante',
    'affezionanti',
    'affezionarci',
    'affezionare',
    'affezionarmi',
    'affezionarsi',
    'affezionarti',
    'affezionarvi',
    'affezionasse',
    'affezionassi',
    'affezionaste',
    'affezionasti',
    'affezionata',
    'affezionate',
    'affezionati',
    'affezionato',
    'affezionava',
    'affezionavi',
    'affezionavo',
    'affezione',
    'affezionera',
    'affezionerai',
    'affezionerei',
    'affezionero',
    'affezioni',
    'affezioniamo',
    'affezioniate',
    'affezionino',
    'affeziono',
    'affianca',
    'affiancai',
    'affiancammo',
    'affiancando',
    'affiancano',
    'affiancante',
    'affiancanti',
    'affiancarci',
    'affiancare',
    'affiancarmi',
    'affiancarono',
    'affiancarsi',
    'affiancarti',
    'affiancarvi',
    'affiancasse',
    'affiancassi',
    'affiancaste',
    'affiancasti',
    'affiancata',
    'affiancate',
    'affiancatevi',
    'affiancati',
    'affiancato',
    'affiancatomi',
    'affiancatoti',
    'affiancava',
    'affiancavamo',
    'affiancavano',
    'affiancavate',
    'affiancavi',
    'affiancavo',
    'affianchera',
    'affiancherai',
    'affiancherei',
    'affianchero',
    'affianchi',
    'affianchiamo',
    'affianchiate',
    'affianchino',
    'affianco',
    'affiata',
    'affiatai',
    'affiatamenti',
    'affiatamento',
    'affiatammo',
    'affiatando',
    'affiatandosi',
    'affiatano',
    'affiatante',
    'affiatanti',
    'affiatarci',
    'affiatare',
    'affiatarmi',
    'affiatarono',
    'affiatarsi',
    'affiatarti',
    'affiatarvi',
    'affiatasse',
    'affiatassero',
    'affiatassi',
    'affiatassimo',
    'affiataste',
    'affiatasti',
    'affiatata',
    'affiatate',
    'affiatati',
    'affiatato',
    'affiatava',
    'affiatavamo',
    'affiatavano',
    'affiatavate',
    'affiatavi',
    'affiatavo',
    'affiatera',
    'affiaterai',
    'affiateranno',
    'affiaterebbe',
    'affiaterei',
    'affiateremmo',
    'affiateremo',
    'affiatereste',
    'affiateresti',
    'affiaterete',
    'affiatero',
    'affiati',
    'affiatiamo',
    'affiatiate',
    'affiatino',
    'affiato',
    'affibbi',
    'affibbia',
    'affibbiai',
    'affibbiammo',
    'affibbiamo',
    'affibbiamoci',
    'affibbiando',
    'affibbiano',
    'affibbiante',
    'affibbianti',
    'affibbiarci',
    'affibbiare',
    'affibbiargli',
    'affibbiarle',
    'affibbiarmi',
    'affibbiarono',
    'affibbiarsi',
    'affibbiarti',
    'affibbiarvi',
    'affibbiasse',
    'affibbiassi',
    'affibbiaste',
    'affibbiasti',
    'affibbiata',
    'affibbiate',
    'affibbiatevi',
    'affibbiati',
    'affibbiato',
    'affibbiatomi',
    'affibbiatoti',
    'affibbiatura',
    'affibbiature',
    'affibbiava',
    'affibbiavamo',
    'affibbiavano',
    'affibbiavate',
    'affibbiavi',
    'affibbiavo',
    'affibbiera',
    'affibbierai',
    'affibbierei',
    'affibbieremo',
    'affibbierete',
    'affibbiero',
    'affibbino',
    'affibbio',
    'affiche',
    'affiches',
    'affida',
    'affidabile',
    'affidabili',
    'affidabilita',
    'affidabilità',
    'affidai',
    'affidamenti',
    'affidamento',
    'affidammo',
    'affidando',
    'affidandoci',
    'affidandogli',
    'affidandola',
    'affidandole',
    'affidandoli',
    'affidandolo',
    'affidandomi',
    'affidandosi',
    'affidandoti',
    'affidandovi',
    'affidano',
    'affidante',
    'affidanti',
    'affidantisi',
    'affidarci',
    'affidare',
    'affidargli',
    'affidarla',
    'affidarle',
    'affidarli',
    'affidarlo',
    'affidarmi',
    'affidarono',
    'affidarsi',
    'affidarti',
    'affidarvi',
    'affidasse',
    'affidassero',
    'affidassi',
    'affidassimo',
    'affidaste',
    'affidasti',
    'affidata',
    'affidatari',
    'affidataria',
    'affidatarie',
    'affidatario',
    'affidate',
    'affidatevi',
    'affidati',
    'affidativa',
    'affidative',
    'affidativi',
    'affidativo',
    'affidato',
    'affidatoci',
    'affidatomi',
    'affidatoti',
    'affidava',
    'affidavamo',
    'affidavano',
    'affidavate',
    'affidavi',
    'affidavit',
    'affidavo',
    'affidera',
    'affiderai',
    'affideranno',
    'affiderebbe',
    'affiderei',
    'affideremmo',
    'affideremo',
    'affidereste',
    'affideresti',
    'affiderete',
    'affidero',
    'affidi',
    'affidiamo',
    'affidiamoci',
    'affidiate',
    'affidino',
    'affido',
    'affidò',
    'affiena',
    'affienai',
    'affienammo',
    'affienando',
    'affienano',
    'affienante',
    'affienanti',
    'affienare',
    'affienarono',
    'affienasse',
    'affienassero',
    'affienassi',
    'affienassimo',
    'affienaste',
    'affienasti',
    'affienata',
    'affienate',
    'affienati',
    'affienato',
    'affienatura',
    'affienature',
    'affienava',
    'affienavamo',
    'affienavano',
    'affienavate',
    'affienavi',
    'affienavo',
    'affienendo',
    'affienente',
    'affienenti',
    'affienera',
    'affienerai',
    'affieneranno',
    'affienerebbe',
    'affienerei',
    'affieneremmo',
    'affieneremo',
    'affienereste',
    'affieneresti',
    'affienerete',
    'affienero',
    'affieni',
    'affieniamo',
    'affieniate',
    'affienii',
    'affienimmo',
    'affienino',
    'affienira',
    'affienirai',
    'affieniranno',
    'affienire',
    'affienirebbe',
    'affienirei',
    'affieniremmo',
    'affieniremo',
    'affienireste',
    'affieniresti',
    'affienirete',
    'affieniro',
    'affienirono',
    'affienisca',
    'affieniscano',
    'affienisce',
    'affienisci',
    'affienisco',
    'affieniscono',
    'affienisse',
    'affienissero',
    'affienissi',
    'affienissimo',
    'affieniste',
    'affienisti',
    'affienita',
    'affienite',
    'affieniti',
    'affienito',
    'affieniva',
    'affienivamo',
    'affienivano',
    'affienivate',
    'affienivi',
    'affienivo',
    'affieno',
    'affievolendo',
    'affievolente',
    'affievolenti',
    'affievoli',
    'affievoliamo',
    'affievoliate',
    'affievolii',
    'affievolimmo',
    'affievolira',
    'affievolirai',
    'affievolire',
    'affievolirei',
    'affievoliro',
    'affievolirsi',
    'affievolisca',
    'affievolisce',
    'affievolisci',
    'affievolisco',
    'affievolisse',
    'affievolissi',
    'affievoliste',
    'affievolisti',
    'affievolita',
    'affievolite',
    'affievoliti',
    'affievolito',
    'affievoliva',
    'affievolivi',
    'affievolivo',
    'affigga',
    'affiggano',
    'affigge',
    'affiggemmo',
    'affiggendo',
    'affiggendoci',
    'affiggendomi',
    'affiggendosi',
    'affiggendoti',
    'affiggendovi',
    'affiggente',
    'affiggenti',
    'affiggentisi',
    'affiggera',
    'affiggerai',
    'affiggeranno',
    'affiggerci',
    'affiggere',
    'affiggerebbe',
    'affiggerei',
    'affiggeremmo',
    'affiggeremo',
    'affiggereste',
    'affiggeresti',
    'affiggerete',
    'affiggermi',
    'affiggero',
    'affiggersi',
    'affiggerti',
    'affiggervi',
    'affiggesse',
    'affiggessero',
    'affiggessi',
    'affiggessimo',
    'affiggeste',
    'affiggesti',
    'affiggete',
    'affiggetevi',
    'affiggeva',
    'affiggevamo',
    'affiggevano',
    'affiggevate',
    'affiggevi',
    'affiggevo',
    'affiggi',
    'affiggiamo',
    'affiggiamoci',
    'affiggiate',
    'affiggiti',
    'affiggo',
    'affiggono',
    'affigli',
    'affiglia',
    'affigliai',
    'affigliammo',
    'affigliamo',
    'affigliamoci',
    'affigliando',
    'affigliano',
    'affigliante',
    'affiglianti',
    'affigliarci',
    'affigliare',
    'affigliarmi',
    'affigliarono',
    'affigliarsi',
    'affigliarti',
    'affigliarvi',
    'affigliasse',
    'affigliassi',
    'affigliaste',
    'affigliasti',
    'affigliata',
    'affigliate',
    'affigliatevi',
    'affigliati',
    'affigliato',
    'affigliatomi',
    'affigliatoti',
    'affigliava',
    'affigliavamo',
    'affigliavano',
    'affigliavate',
    'affigliavi',
    'affigliavo',
    'affigliera',
    'affiglierai',
    'affiglierei',
    'affiglieremo',
    'affiglierete',
    'affigliero',
    'affiglino',
    'affiglio',
    'affigura',
    'affigurai',
    'affigurammo',
    'affigurando',
    'affigurano',
    'affigurante',
    'affiguranti',
    'affigurare',
    'affigurarono',
    'affigurasse',
    'affigurassi',
    'affiguraste',
    'affigurasti',
    'affigurata',
    'affigurate',
    'affigurati',
    'affigurato',
    'affigurava',
    'affiguravamo',
    'affiguravano',
    'affiguravate',
    'affiguravi',
    'affiguravo',
    'affigurera',
    'affigurerai',
    'affigurerei',
    'affigureremo',
    'affigurerete',
    'affigurero',
    'affiguri',
    'affiguriamo',
    'affiguriate',
    'affigurino',
    'affiguro',
    'affila',
    'affilai',
    'affilalame',
    'affilamenti',
    'affilamento',
    'affilammo',
    'affilando',
    'affilandoci',
    'affilandomi',
    'affilandosi',
    'affilandoti',
    'affilandovi',
    'affilano',
    'affilante',
    'affilanti',
    'affilantisi',
    'affilarasoi',
    'affilarasoio',
    'affilarci',
    'affilare',
    'affilarmi',
    'affilarono',
    'affilarsi',
    'affilarti',
    'affilarvi',
    'affilasse',
    'affilassero',
    'affilassi',
    'affilassimo',
    'affilaste',
    'affilasti',
    'affilata',
    'affilate',
    'affilatevi',
    'affilati',
    'affilato',
    'affilatoi',
    'affilatoio',
    'affilatomi',
    'affilatore',
    'affilatori',
    'affilatoti',
    'affilatrice',
    'affilatrici',
    'affilatura',
    'affilature',
    'affilava',
    'affilavamo',
    'affilavano',
    'affilavate',
    'affilavi',
    'affilavo',
    'affilera',
    'affilerai',
    'affileranno',
    'affilerebbe',
    'affilerei',
    'affileremmo',
    'affileremo',
    'affilereste',
    'affileresti',
    'affilerete',
    'affilero',
    'affiletta',
    'affilettai',
    'affilettammo',
    'affilettando',
    'affilettano',
    'affilettante',
    'affilettanti',
    'affilettare',
    'affilettasse',
    'affilettassi',
    'affilettaste',
    'affilettasti',
    'affilettata',
    'affilettate',
    'affilettati',
    'affilettato',
    'affilettava',
    'affilettavi',
    'affilettavo',
    'affilettera',
    'affiletterai',
    'affiletterei',
    'affilettero',
    'affiletti',
    'affilettiamo',
    'affilettiate',
    'affilettino',
    'affiletto',
    'affili',
    'affilia',
    'affiliai',
    'affiliammo',
    'affiliamo',
    'affiliamoci',
    'affilianda',
    'affiliande',
    'affiliandi',
    'affiliando',
    'affiliandoci',
    'affiliandomi',
    'affiliandosi',
    'affiliandoti',
    'affiliandovi',
    'affiliano',
    'affiliante',
    'affilianti',
    'affiliantisi',
    'affiliarci',
    'affiliare',
    'affiliarmi',
    'affiliarono',
    'affiliarsi',
    'affiliarti',
    'affiliarvi',
    'affiliasse',
    'affiliassero',
    'affiliassi',
    'affiliassimo',
    'affiliaste',
    'affiliasti',
    'affiliata',
    'affiliate',
    'affiliatevi',
    'affiliati',
    'affiliato',
    'affiliatomi',
    'affiliatoti',
    'affiliava',
    'affiliavamo',
    'affiliavano',
    'affiliavate',
    'affiliavi',
    'affiliavo',
    'affiliazione',
    'affiliazioni',
    'affiliera',
    'affilierai',
    'affilieranno',
    'affilierebbe',
    'affilierei',
    'affilieremmo',
    'affilieremo',
    'affiliereste',
    'affilieresti',
    'affilierete',
    'affiliero',
    'affilino',
    'affilio',
    'affilo',
    'affina',
    'affinaggi',
    'affinaggio',
    'affinai',
    'affinamenti',
    'affinamento',
    'affinammo',
    'affinando',
    'affinandoci',
    'affinandomi',
    'affinandosi',
    'affinandoti',
    'affinandovi',
    'affinano',
    'affinante',
    'affinanti',
    'affinantisi',
    'affinarci',
    'affinare',
    'affinarmi',
    'affinarono',
    'affinarsi',
    'affinarti',
    'affinarvi',
    'affinasse',
    'affinassero',
    'affinassi',
    'affinassimo',
    'affinaste',
    'affinasti',
    'affinata',
    'affinate',
    'affinatevi',
    'affinati',
    'affinato',
    'affinatomi',
    'affinatore',
    'affinatori',
    'affinatoti',
    'affinatrice',
    'affinatrici',
    'affinatura',
    'affinature',
    'affinava',
    'affinavamo',
    'affinavano',
    'affinavate',
    'affinavi',
    'affinavo',
    'affinazione',
    'affinazioni',
    'affinche',
    'affinchè',
    'affinché',
    'affine',
    'affinera',
    'affinerai',
    'affineranno',
    'affinerebbe',
    'affinerei',
    'affineremmo',
    'affineremo',
    'affinereste',
    'affineresti',
    'affinerete',
    'affinero',
    'affini',
    'affiniamo',
    'affiniamoci',
    'affiniate',
    'affinino',
    'affinita',
    'affinità',
    'affino',
    'affioca',
    'affiocai',
    'affiocammo',
    'affiocando',
    'affiocano',
    'affiocante',
    'affiocanti',
    'affiocare',
    'affiocarono',
    'affiocasse',
    'affiocassero',
    'affiocassi',
    'affiocassimo',
    'affiocaste',
    'affiocasti',
    'affiocata',
    'affiocate',
    'affiocati',
    'affiocato',
    'affiocava',
    'affiocavamo',
    'affiocavano',
    'affiocavate',
    'affiocavi',
    'affiocavo',
    'affiochendo',
    'affiochente',
    'affiochenti',
    'affiochera',
    'affiocherai',
    'affiocherei',
    'affiocheremo',
    'affiocherete',
    'affiochero',
    'affiochi',
    'affiochiamo',
    'affiochiate',
    'affiochii',
    'affiochimmo',
    'affiochino',
    'affiochira',
    'affiochirai',
    'affiochirci',
    'affiochire',
    'affiochirei',
    'affiochiremo',
    'affiochirete',
    'affiochirmi',
    'affiochiro',
    'affiochirono',
    'affiochirsi',
    'affiochirti',
    'affiochirvi',
    'affiochisca',
    'affiochisce',
    'affiochisci',
    'affiochisco',
    'affiochisse',
    'affiochissi',
    'affiochiste',
    'affiochisti',
    'affiochita',
    'affiochite',
    'affiochitevi',
    'affiochiti',
    'affiochito',
    'affiochitomi',
    'affiochitoti',
    'affiochiva',
    'affiochivamo',
    'affiochivano',
    'affiochivate',
    'affiochivi',
    'affiochivo',
    'affioco',
    'affiora',
    'affiorai',
    'affioramenti',
    'affioramento',
    'affiorammo',
    'affiorando',
    'affiorano',
    'affiorante',
    'affioranti',
    'affiorare',
    'affiorarono',
    'affiorasse',
    'affiorassero',
    'affiorassi',
    'affiorassimo',
    'affioraste',
    'affiorasti',
    'affiorata',
    'affiorate',
    'affiorati',
    'affiorato',
    'affiorava',
    'affioravamo',
    'affioravano',
    'affioravate',
    'affioravi',
    'affioravo',
    'affiorera',
    'affiorerai',
    'affioreranno',
    'affiorerebbe',
    'affiorerei',
    'affioreremmo',
    'affioreremo',
    'affiorereste',
    'affioreresti',
    'affiorerete',
    'affiorero',
    'affiori',
    'affioriamo',
    'affioriate',
    'affiorino',
    'affioro',
    'affisa',
    'affisai',
    'affisammo',
    'affisando',
    'affisano',
    'affisante',
    'affisanti',
    'affisare',
    'affisarono',
    'affisasse',
    'affisassero',
    'affisassi',
    'affisassimo',
    'affisaste',
    'affisasti',
    'affisata',
    'affisate',
    'affisati',
    'affisato',
    'affisava',
    'affisavamo',
    'affisavano',
    'affisavate',
    'affisavi',
    'affisavo',
    'affise',
    'affisera',
    'affiserai',
    'affiseranno',
    'affiserebbe',
    'affiserei',
    'affiseremmo',
    'affiseremo',
    'affisereste',
    'affiseresti',
    'affiserete',
    'affisero',
    'affisi',
    'affisiamo',
    'affisiate',
    'affisino',
    'affiso',
    'affissa',
    'affissamento',
    'affissando',
    'affissandosi',
    'affissano',
    'affissante',
    'affissare',
    'affissarono',
    'affissarsi',
    'affissata',
    'affissate',
    'affissati',
    'affissato',
    'affissava',
    'affissavano',
    'affisse',
    'affissero',
    'affissi',
    'affissino',
    'affissionale',
    'affissionali',
    'affissione',
    'affissioni',
    'affissiva',
    'affissive',
    'affissivi',
    'affissivo',
    'affisso',
    'affissomi',
    'affissoti',
    'affitta',
    'affittabile',
    'affittabili',
    'affittai',
    'affittammo',
    'affittando',
    'affittano',
    'affittansi',
    'affittante',
    'affittanti',
    'affittanza',
    'affittanze',
    'affittare',
    'affittarono',
    'affittasi',
    'affittasse',
    'affittassero',
    'affittassi',
    'affittassimo',
    'affittaste',
    'affittasti',
    'affittata',
    'affittate',
    'affittati',
    'affittato',
    'affittava',
    'affittavamo',
    'affittavano',
    'affittavate',
    'affittavi',
    'affittavo',
    'affittendo',
    'affittendoci',
    'affittendomi',
    'affittendosi',
    'affittendoti',
    'affittendovi',
    'affittente',
    'affittenti',
    'affittentisi',
    'affittera',
    'affitterai',
    'affitteranno',
    'affitterebbe',
    'affitterei',
    'affitteremmo',
    'affitteremo',
    'affittereste',
    'affitteresti',
    'affitterete',
    'affittero',
    'affitti',
    'affittiamo',
    'affittiamoci',
    'affittiate',
    'affittii',
    'affittimmo',
    'affittino',
    'affittira',
    'affittirai',
    'affittiranno',
    'affittirci',
    'affittire',
    'affittirebbe',
    'affittirei',
    'affittiremmo',
    'affittiremo',
    'affittireste',
    'affittiresti',
    'affittirete',
    'affittirmi',
    'affittiro',
    'affittirono',
    'affittirsi',
    'affittirti',
    'affittirvi',
    'affittisca',
    'affittiscano',
    'affittisce',
    'affittisci',
    'affittisciti',
    'affittisco',
    'affittiscono',
    'affittisse',
    'affittissero',
    'affittissi',
    'affittissimo',
    'affittiste',
    'affittisti',
    'affittita',
    'affittite',
    'affittitevi',
    'affittiti',
    'affittito',
    'affittitomi',
    'affittitoti',
    'affittiva',
    'affittivamo',
    'affittivano',
    'affittivate',
    'affittivi',
    'affittivo',
    'affitto',
    'affittuari',
    'affittuaria',
    'affittuarie',
    'affittuario',
    'afflare',
    'afflati',
    'afflato',
    'affligga',
    'affliggano',
    'affligge',
    'affliggemmo',
    'affliggendo',
    'affliggente',
    'affliggenti',
    'affliggera',
    'affliggerai',
    'affliggerci',
    'affliggere',
    'affliggerei',
    'affliggeremo',
    'affliggerete',
    'affliggerla',
    'affliggerle',
    'affliggerli',
    'affliggerlo',
    'affliggermi',
    'affliggero',
    'affliggersi',
    'affliggerti',
    'affliggervi',
    'affliggesse',
    'affliggessi',
    'affliggeste',
    'affliggesti',
    'affliggete',
    'affliggetevi',
    'affliggeva',
    'affliggevamo',
    'affliggevano',
    'affliggevate',
    'affliggevi',
    'affliggevo',
    'affliggi',
    'affliggiamo',
    'affliggiate',
    'affliggiti',
    'affliggo',
    'affliggono',
    'afflisse',
    'afflissero',
    'afflissi',
    'afflitta',
    'afflitte',
    'afflitti',
    'afflittiva',
    'afflittive',
    'afflittivi',
    'afflittivo',
    'afflitto',
    'afflittomi',
    'afflittoti',
    'afflizione',
    'afflizioni',
    'affloscera',
    'affloscerai',
    'affloscerei',
    'afflosceremo',
    'affloscerete',
    'affloscero',
    'afflosci',
    'affloscia',
    'afflosciai',
    'afflosciammo',
    'afflosciamo',
    'afflosciando',
    'afflosciano',
    'afflosciante',
    'affloscianti',
    'afflosciarci',
    'afflosciare',
    'afflosciarmi',
    'afflosciarsi',
    'afflosciarti',
    'afflosciarvi',
    'afflosciasse',
    'afflosciassi',
    'afflosciaste',
    'afflosciasti',
    'afflosciata',
    'afflosciate',
    'afflosciati',
    'afflosciato',
    'afflosciava',
    'afflosciavi',
    'afflosciavo',
    'affloscino',
    'affloscio',
    'affluendo',
    'affluente',
    'affluenti',
    'affluenza',
    'affluenze',
    'afflui',
    'affluiamo',
    'affluiate',
    'affluii',
    'affluimmo',
    'affluira',
    'affluirai',
    'affluiranno',
    'affluire',
    'affluirebbe',
    'affluirei',
    'affluiremmo',
    'affluiremo',
    'affluireste',
    'affluiresti',
    'affluirete',
    'affluiro',
    'affluirono',
    'affluisca',
    'affluiscano',
    'affluisce',
    'affluisci',
    'affluisco',
    'affluiscono',
    'affluisse',
    'affluissero',
    'affluissi',
    'affluissimo',
    'affluiste',
    'affluisti',
    'affluita',
    'affluite',
    'affluiti',
    'affluito',
    'affluiva',
    'affluivamo',
    'affluivano',
    'affluivate',
    'affluivi',
    'affluivo',
    'afflussi',
    'afflusso',
    'affoca',
    'affocai',
    'affocammo',
    'affocando',
    'affocandosi',
    'affocano',
    'affocante',
    'affocanti',
    'affocare',
    'affocarono',
    'affocarsi',
    'affocasse',
    'affocassero',
    'affocassi',
    'affocassimo',
    'affocaste',
    'affocasti',
    'affocata',
    'affocate',
    'affocati',
    'affocato',
    'affocava',
    'affocavamo',
    'affocavano',
    'affocavate',
    'affocavi',
    'affocavo',
    'affochera',
    'affocherai',
    'affocheranno',
    'affocherebbe',
    'affocherei',
    'affocheremmo',
    'affocheremo',
    'affochereste',
    'affocheresti',
    'affocherete',
    'affochero',
    'affochi',
    'affochiamo',
    'affochiate',
    'affochino',
    'affoco',
    'affoga',
    'affogai',
    'affogamenti',
    'affogamento',
    'affogammo',
    'affogando',
    'affogandoci',
    'affogandomi',
    'affogandosi',
    'affogandoti',
    'affogandovi',
    'affogano',
    'affogante',
    'affoganti',
    'affogantisi',
    'affogarci',
    'affogare',
    'affogarmi',
    'affogarono',
    'affogarsi',
    'affogarti',
    'affogarvi',
    'affogasse',
    'affogassero',
    'affogassi',
    'affogassimo',
    'affogaste',
    'affogasti',
    'affogata',
    'affogate',
    'affogatevi',
    'affogati',
    'affogato',
    'affogatomi',
    'affogatoti',
    'affogava',
    'affogavamo',
    'affogavano',
    'affogavate',
    'affogavi',
    'affogavo',
    'affoghera',
    'affogherai',
    'affogheranno',
    'affogherebbe',
    'affogherei',
    'affogheremmo',
    'affogheremo',
    'affoghereste',
    'affogheresti',
    'affogherete',
    'affoghero',
    'affoghi',
    'affoghiamo',
    'affoghiamoci',
    'affoghiate',
    'affoghino',
    'affogo',
    'affolla',
    'affollai',
    'affollamenti',
    'affollamento',
    'affollammo',
    'affollando',
    'affollandoci',
    'affollandomi',
    'affollandosi',
    'affollandoti',
    'affollandovi',
    'affollano',
    'affollante',
    'affollanti',
    'affollantisi',
    'affollarci',
    'affollare',
    'affollarmi',
    'affollarono',
    'affollarsi',
    'affollarti',
    'affollarvi',
    'affollasse',
    'affollassero',
    'affollassi',
    'affollassimo',
    'affollaste',
    'affollasti',
    'affollata',
    'affollate',
    'affollatevi',
    'affollati',
    'affollato',
    'affollatomi',
    'affollatoti',
    'affollava',
    'affollavamo',
    'affollavano',
    'affollavate',
    'affollavi',
    'affollavo',
    'affollera',
    'affollerai',
    'affolleranno',
    'affollerebbe',
    'affollerei',
    'affolleremmo',
    'affolleremo',
    'affollereste',
    'affolleresti',
    'affollerete',
    'affollero',
    'affolli',
    'affolliamo',
    'affolliamoci',
    'affolliate',
    'affollino',
    'affollo',
    'affolta',
    'affoltai',
    'affoltammo',
    'affoltando',
    'affoltandoci',
    'affoltandomi',
    'affoltandosi',
    'affoltandoti',
    'affoltandovi',
    'affoltano',
    'affoltante',
    'affoltanti',
    'affoltantisi',
    'affoltarci',
    'affoltare',
    'affoltarmi',
    'affoltarono',
    'affoltarsi',
    'affoltarti',
    'affoltarvi',
    'affoltasse',
    'affoltassero',
    'affoltassi',
    'affoltassimo',
    'affoltaste',
    'affoltasti',
    'affoltata',
    'affoltate',
    'affoltatevi',
    'affoltati',
    'affoltato',
    'affoltatomi',
    'affoltatoti',
    'affoltava',
    'affoltavamo',
    'affoltavano',
    'affoltavate',
    'affoltavi',
    'affoltavo',
    'affoltera',
    'affolterai',
    'affolteranno',
    'affolterebbe',
    'affolterei',
    'affolteremmo',
    'affolteremo',
    'affoltereste',
    'affolteresti',
    'affolterete',
    'affoltero',
    'affolti',
    'affoltiamo',
    'affoltiamoci',
    'affoltiate',
    'affoltino',
    'affolto',
    'affonda',
    'affondabile',
    'affondai',
    'affondamenti',
    'affondamento',
    'affondamine',
    'affondammo',
    'affondando',
    'affondandoci',
    'affondandomi',
    'affondandosi',
    'affondandoti',
    'affondandovi',
    'affondano',
    'affondante',
    'affondanti',
    'affondantisi',
    'affondarci',
    'affondare',
    'affondarmi',
    'affondarono',
    'affondarsi',
    'affondarti',
    'affondarvi',
    'affondasse',
    'affondassero',
    'affondassi',
    'affondassimo',
    'affondaste',
    'affondasti',
    'affondata',
    'affondate',
    'affondatevi',
    'affondati',
    'affondato',
    'affondatoi',
    'affondatoio',
    'affondatomi',
    'affondatore',
    'affondatori',
    'affondatoti',
    'affondatrice',
    'affondatrici',
    'affondatura',
    'affondature',
    'affondava',
    'affondavamo',
    'affondavano',
    'affondavate',
    'affondavi',
    'affondavo',
    'affondera',
    'affonderai',
    'affonderanno',
    'affonderebbe',
    'affonderei',
    'affonderemmo',
    'affonderemo',
    'affondereste',
    'affonderesti',
    'affonderete',
    'affondero',
    'affonderà',
    'affondi',
    'affondiamo',
    'affondiamoci',
    'affondiate',
    'affondino',
    'affondo',
    'afforca',
    'afforcai',
    'afforcammo',
    'afforcando',
    'afforcano',
    'afforcante',
    'afforcanti',
    'afforcare',
    'afforcarono',
    'afforcasse',
    'afforcassero',
    'afforcassi',
    'afforcassimo',
    'afforcaste',
    'afforcasti',
    'afforcata',
    'afforcate',
    'afforcati',
    'afforcato',
    'afforcava',
    'afforcavamo',
    'afforcavano',
    'afforcavate',
    'afforcavi',
    'afforcavo',
    'afforchera',
    'afforcherai',
    'afforcherei',
    'afforcheremo',
    'afforcherete',
    'afforchero',
    'afforchi',
    'afforchiamo',
    'afforchiate',
    'afforchino',
    'afforco',
    'affortunata',
    'affortunato',
    'afforza',
    'afforzai',
    'afforzamento',
    'afforzammo',
    'afforzando',
    'afforzano',
    'afforzante',
    'afforzanti',
    'afforzare',
    'afforzarono',
    'afforzasse',
    'afforzassero',
    'afforzassi',
    'afforzassimo',
    'afforzaste',
    'afforzasti',
    'afforzata',
    'afforzate',
    'afforzati',
    'afforzato',
    'afforzava',
    'afforzavamo',
    'afforzavano',
    'afforzavate',
    'afforzavi',
    'afforzavo',
    'afforzera',
    'afforzerai',
    'afforzeranno',
    'afforzerebbe',
    'afforzerei',
    'afforzeremmo',
    'afforzeremo',
    'afforzereste',
    'afforzeresti',
    'afforzerete',
    'afforzero',
    'afforzi',
    'afforziamo',
    'afforziate',
    'afforzino',
    'afforzo',
    'affossa',
    'affossai',
    'affossamenti',
    'affossamento',
    'affossammo',
    'affossando',
    'affossandoci',
    'affossandomi',
    'affossandosi',
    'affossandoti',
    'affossandovi',
    'affossano',
    'affossante',
    'affossanti',
    'affossantisi',
    'affossarci',
    'affossare',
    'affossarmi',
    'affossarono',
    'affossarsi',
    'affossarti',
    'affossarvi',
    'affossasse',
    'affossassero',
    'affossassi',
    'affossassimo',
    'affossaste',
    'affossasti',
    'affossata',
    'affossate',
    'affossatevi',
    'affossati',
    'affossato',
    'affossatomi',
    'affossatore',
    'affossatori',
    'affossatoti',
    'affossatrice',
    'affossatrici',
    'affossatura',
    'affossature',
    'affossava',
    'affossavamo',
    'affossavano',
    'affossavate',
    'affossavi',
    'affossavo',
    'affossera',
    'affosserai',
    'affosseranno',
    'affosserebbe',
    'affosserei',
    'affosseremmo',
    'affosseremo',
    'affossereste',
    'affosseresti',
    'affosserete',
    'affossero',
    'affossi',
    'affossiamo',
    'affossiamoci',
    'affossiate',
    'affossino',
    'affosso',
    'affralendo',
    'affralente',
    'affralenti',
    'affrali',
    'affraliamo',
    'affraliate',
    'affralii',
    'affralimmo',
    'affralira',
    'affralirai',
    'affraliranno',
    'affralire',
    'affralirebbe',
    'affralirei',
    'affraliremmo',
    'affraliremo',
    'affralireste',
    'affraliresti',
    'affralirete',
    'affraliro',
    'affralirono',
    'affralisca',
    'affraliscano',
    'affralisce',
    'affralisci',
    'affralisco',
    'affraliscono',
    'affralisse',
    'affralissero',
    'affralissi',
    'affralissimo',
    'affraliste',
    'affralisti',
    'affralita',
    'affralite',
    'affraliti',
    'affralito',
    'affraliva',
    'affralivamo',
    'affralivano',
    'affralivate',
    'affralivi',
    'affralivo',
    'affranca',
    'affrancabile',
    'affrancabili',
    'affrancai',
    'affrancammo',
    'affrancando',
    'affrancano',
    'affrancante',
    'affrancanti',
    'affrancarci',
    'affrancare',
    'affrancarmi',
    'affrancarono',
    'affrancarsi',
    'affrancarti',
    'affrancarvi',
    'affrancasse',
    'affrancassi',
    'affrancaste',
    'affrancasti',
    'affrancata',
    'affrancatasi',
    'affrancate',
    'affrancatevi',
    'affrancati',
    'affrancato',
    'affrancatomi',
    'affrancatore',
    'affrancatori',
    'affrancatoti',
    'affrancatura',
    'affrancature',
    'affrancava',
    'affrancavamo',
    'affrancavano',
    'affrancavate',
    'affrancavi',
    'affrancavo',
    'affranchera',
    'affrancherai',
    'affrancherei',
    'affranchero',
    'affranchi',
    'affranchiamo',
    'affranchiate',
    'affranchino',
    'affranco',
    'affranga',
    'affrangano',
    'affrange',
    'affrangemmo',
    'affrangendo',
    'affrangente',
    'affrangenti',
    'affrangera',
    'affrangerai',
    'affrangere',
    'affrangerei',
    'affrangeremo',
    'affrangerete',
    'affrangero',
    'affrangesse',
    'affrangessi',
    'affrangeste',
    'affrangesti',
    'affrangete',
    'affrangeva',
    'affrangevamo',
    'affrangevano',
    'affrangevate',
    'affrangevi',
    'affrangevo',
    'affrangi',
    'affrangiamo',
    'affrangiate',
    'affrango',
    'affrangono',
    'affranse',
    'affransero',
    'affransi',
    'affranta',
    'affrante',
    'affranti',
    'affranto',
    'affratella',
    'affratellai',
    'affratellano',
    'affratellare',
    'affratellata',
    'affratellate',
    'affratellati',
    'affratellato',
    'affratellava',
    'affratellavi',
    'affratellavo',
    'affratellera',
    'affratellero',
    'affratelli',
    'affratellino',
    'affratello',
    'affrena',
    'affrenai',
    'affrenammo',
    'affrenando',
    'affrenano',
    'affrenante',
    'affrenanti',
    'affrenare',
    'affrenarono',
    'affrenasse',
    'affrenassero',
    'affrenassi',
    'affrenassimo',
    'affrenaste',
    'affrenasti',
    'affrenata',
    'affrenate',
    'affrenati',
    'affrenato',
    'affrenava',
    'affrenavamo',
    'affrenavano',
    'affrenavate',
    'affrenavi',
    'affrenavo',
    'affrenella',
    'affrenellano',
    'affrenellare',
    'affrenellato',
    'affrenello',
    'affrenera',
    'affrenerai',
    'affreneranno',
    'affrenerebbe',
    'affrenerei',
    'affreneremmo',
    'affreneremo',
    'affrenereste',
    'affreneresti',
    'affrenerete',
    'affrenero',
    'affreni',
    'affreniamo',
    'affreniate',
    'affrenino',
    'affreno',
    'affresca',
    'affrescai',
    'affrescammo',
    'affrescando',
    'affrescano',
    'affrescante',
    'affrescanti',
    'affrescare',
    'affrescarono',
    'affrescasse',
    'affrescassi',
    'affrescaste',
    'affrescasti',
    'affrescata',
    'affrescate',
    'affrescati',
    'affrescato',
    'affrescava',
    'affrescavamo',
    'affrescavano',
    'affrescavate',
    'affrescavi',
    'affrescavo',
    'affreschera',
    'affrescherai',
    'affrescherei',
    'affreschero',
    'affreschi',
    'affreschiamo',
    'affreschiate',
    'affreschino',
    'affreschista',
    'affreschiste',
    'affreschisti',
    'affresco',
    'affretta',
    'affrettabile',
    'affrettabili',
    'affrettai',
    'affrettammo',
    'affrettando',
    'affrettano',
    'affrettante',
    'affrettanti',
    'affrettarci',
    'affrettare',
    'affrettarla',
    'affrettarlo',
    'affrettarmi',
    'affrettarono',
    'affrettarsi',
    'affrettarti',
    'affrettarvi',
    'affrettasse',
    'affrettassi',
    'affrettaste',
    'affrettasti',
    'affrettata',
    'affrettate',
    'affrettatevi',
    'affrettati',
    'affrettato',
    'affrettatomi',
    'affrettatoti',
    'affrettava',
    'affrettavamo',
    'affrettavano',
    'affrettavate',
    'affrettavi',
    'affrettavo',
    'affrettera',
    'affretterai',
    'affretterei',
    'affretteremo',
    'affretterete',
    'affrettero',
    'affretti',
    'affrettiamo',
    'affrettiate',
    'affrettino',
    'affretto',
    'affrettò',
    'affricano',
    'affricata',
    'affricate',
    'affricati',
    'affricato',
    'affricazione',
    'affricazioni',
    'affrittella',
    'affrittellai',
    'affrittelli',
    'affrittello',
    'affronta',
    'affrontabile',
    'affrontabili',
    'affrontai',
    'affrontammo',
    'affrontando',
    'affrontano',
    'affrontante',
    'affrontanti',
    'affrontarci',
    'affrontare',
    'affrontarla',
    'affrontarle',
    'affrontarli',
    'affrontarlo',
    'affrontarmi',
    'affrontarne',
    'affrontarono',
    'affrontarsi',
    'affrontarti',
    'affrontarvi',
    'affrontasse',
    'affrontassi',
    'affrontaste',
    'affrontasti',
    'affrontata',
    'affrontate',
    'affrontatevi',
    'affrontati',
    'affrontato',
    'affrontatomi',
    'affrontatore',
    'affrontatori',
    'affrontatoti',
    'affrontatura',
    'affrontature',
    'affrontava',
    'affrontavamo',
    'affrontavano',
    'affrontavate',
    'affrontavi',
    'affrontavo',
    'affrontera',
    'affronterai',
    'affronterei',
    'affronteremo',
    'affronterete',
    'affrontero',
    'affronti',
    'affrontiamo',
    'affrontiate',
    'affrontino',
    'affronto',
    'affuma',
    'affumai',
    'affumammo',
    'affumando',
    'affumano',
    'affumante',
    'affumanti',
    'affumare',
    'affumarono',
    'affumasse',
    'affumassero',
    'affumassi',
    'affumassimo',
    'affumaste',
    'affumasti',
    'affumata',
    'affumate',
    'affumati',
    'affumato',
    'affumava',
    'affumavamo',
    'affumavano',
    'affumavate',
    'affumavi',
    'affumavo',
    'affumera',
    'affumerai',
    'affumeranno',
    'affumerebbe',
    'affumerei',
    'affumeremmo',
    'affumeremo',
    'affumereste',
    'affumeresti',
    'affumerete',
    'affumero',
    'affumi',
    'affumiamo',
    'affumiate',
    'affumica',
    'affumicai',
    'affumicammo',
    'affumicando',
    'affumicano',
    'affumicante',
    'affumicanti',
    'affumicarci',
    'affumicare',
    'affumicarla',
    'affumicarle',
    'affumicarli',
    'affumicarlo',
    'affumicarmi',
    'affumicarono',
    'affumicarsi',
    'affumicarti',
    'affumicarvi',
    'affumicasse',
    'affumicassi',
    'affumicaste',
    'affumicasti',
    'affumicata',
    'affumicate',
    'affumicatevi',
    'affumicati',
    'affumicato',
    'affumicatoi',
    'affumicatoio',
    'affumicatomi',
    'affumicatore',
    'affumicatori',
    'affumicatoti',
    'affumicatura',
    'affumicature',
    'affumicava',
    'affumicavamo',
    'affumicavano',
    'affumicavate',
    'affumicavi',
    'affumicavo',
    'affumichera',
    'affumicherai',
    'affumicherei',
    'affumichero',
    'affumichi',
    'affumichiamo',
    'affumichiate',
    'affumichino',
    'affumico',
    'affumino',
    'affumo',
    'affuoca',
    'affuocai',
    'affuocammo',
    'affuocando',
    'affuocano',
    'affuocante',
    'affuocanti',
    'affuocare',
    'affuocarono',
    'affuocasse',
    'affuocassero',
    'affuocassi',
    'affuocassimo',
    'affuocaste',
    'affuocasti',
    'affuocata',
    'affuocate',
    'affuocati',
    'affuocato',
    'affuocava',
    'affuocavamo',
    'affuocavano',
    'affuocavate',
    'affuocavi',
    'affuocavo',
    'affuochera',
    'affuocherai',
    'affuocherei',
    'affuocheremo',
    'affuocherete',
    'affuochero',
    'affuochi',
    'affuochiamo',
    'affuochiate',
    'affuochino',
    'affuoco',
    'affusola',
    'affusolai',
    'affusolammo',
    'affusolando',
    'affusolano',
    'affusolante',
    'affusolanti',
    'affusolarci',
    'affusolare',
    'affusolarmi',
    'affusolarono',
    'affusolarsi',
    'affusolarti',
    'affusolarvi',
    'affusolasse',
    'affusolassi',
    'affusolaste',
    'affusolasti',
    'affusolata',
    'affusolate',
    'affusolatevi',
    'affusolati',
    'affusolato',
    'affusolatomi',
    'affusolatoti',
    'affusolava',
    'affusolavamo',
    'affusolavano',
    'affusolavate',
    'affusolavi',
    'affusolavo',
    'affusolera',
    'affusolerai',
    'affusolerei',
    'affusoleremo',
    'affusolerete',
    'affusolero',
    'affusoli',
    'affusoliamo',
    'affusoliate',
    'affusolino',
    'affusolo',
    'affusti',
    'affusto',
    'afgana',
    'afgane',
    'afgani',
    'afgano',
    'afghana',
    'afghane',
    'afghani',
    'afghanistan',
    'afghano',
    'aficionado',
    'aficionados',
    'afide',
    'afidi',
    'afididi',
    'afilla',
    'afille',
    'afilli',
    'afillo',
    'aflatossine',
    'afni',
    'afnio',
    'afona',
    'afone',
    'afoni',
    'afonia',
    'afonie',
    'afono',
    'aforisma',
    'aforismi',
    'aforismo',
    'aforistica',
    'aforistiche',
    'aforistici',
    'aforistico',
    'afosa',
    'afose',
    'afosi',
    'afosita',
    'afosità',
    'afoso',
    'afra',
    'aframomo',
    'afre',
    'afrezza',
    'afrezze',
    'afri',
    'africa',
    'africana',
    'africane',
    'africani',
    'africanismi',
    'africanismo',
    'africanista',
    'africaniste',
    'africanisti',
    'africano',
    'afriche',
    'africi',
    'africo',
    'afrikaans',
    'afrikander',
    'afrikaner',
    'afro',
    'afroasiatica',
    'afroasiatici',
    'afroasiatico',
    'afrocubana',
    'afrocubane',
    'afrocubani',
    'afrocubano',
    'afrodisiaca',
    'afrodisiache',
    'afrodisiaci',
    'afrodisiaco',
    'afrodisio',
    'afrodite',
    'afrometri',
    'afrometro',
    'afropavone',
    'afropavoni',
    'afrore',
    'afrori',
    'afrorosa',
    'afrorose',
    'afrorosi',
    'afroroso',
    'afta',
    'afte',
    'after',
    'aftershave',
    'aftosa',
    'aftose',
    'aftosi',
    'aftoso',
    'agabio',
    'agabito',
    'agalactiae',
    'agalassia',
    'agalassie',
    'agalattia',
    'agalattie',
    'agama',
    'agame',
    'agamennone',
    'agami',
    'agamia',
    'agamica',
    'agamicamente',
    'agamiche',
    'agamici',
    'agamico',
    'agamide',
    'agamidi',
    'agamie',
    'agamo',
    'aganippe',
    'agapanti',
    'agapanto',
    'agape',
    'agapi',
    'agapio',
    'agapito',
    'agar',
    'agaricacea',
    'agaricacee',
    'agaricales',
    'agarici',
    'agarico',
    'agaricus',
    'agarosio',
    'agata',
    'agate',
    'agatella',
    'agatina',
    'agatino',
    'agato',
    'agatocle',
    'agatoclia',
    'agatone',
    'agave',
    'agavi',
    'agazia',
    'agazio',
    'agazzini',
    'agazzino',
    'agea',
    'agelenide',
    'agelenidi',
    'agemina',
    'ageminai',
    'ageminammo',
    'ageminando',
    'ageminano',
    'ageminante',
    'ageminanti',
    'ageminare',
    'ageminarono',
    'ageminasse',
    'ageminassero',
    'ageminassi',
    'ageminassimo',
    'ageminaste',
    'ageminasti',
    'ageminata',
    'ageminate',
    'ageminati',
    'ageminato',
    'ageminatore',
    'ageminatori',
    'ageminatrice',
    'ageminatrici',
    'ageminatura',
    'ageminature',
    'ageminava',
    'ageminavamo',
    'ageminavano',
    'ageminavate',
    'ageminavi',
    'ageminavo',
    'agemine',
    'ageminera',
    'ageminerai',
    'agemineranno',
    'ageminerebbe',
    'ageminerei',
    'agemineremmo',
    'agemineremo',
    'ageminereste',
    'agemineresti',
    'ageminerete',
    'ageminero',
    'agemini',
    'ageminiamo',
    'ageminiate',
    'ageminino',
    'agemino',
    'agenda',
    'agende',
    'agendina',
    'agendine',
    'agendo',
    'agenesia',
    'agenesie',
    'agenore',
    'agente',
    'agenti',
    'agentiva',
    'agentive',
    'agentivi',
    'agentivo',
    'agenzia',
    'agenziale',
    'agenziali',
    'agenzie',
    'ageo',
    'agerati',
    'agerato',
    'agesilao',
    'ageusia',
    'ageusie',
    'agevola',
    'agevolai',
    'agevolamenti',
    'agevolamento',
    'agevolammo',
    'agevolando',
    'agevolandola',
    'agevolandole',
    'agevolandoli',
    'agevolandolo',
    'agevolano',
    'agevolante',
    'agevolanti',
    'agevolare',
    'agevolarla',
    'agevolarle',
    'agevolarli',
    'agevolarlo',
    'agevolarmi',
    'agevolarono',
    'agevolasse',
    'agevolassero',
    'agevolassi',
    'agevolassimo',
    'agevolaste',
    'agevolasti',
    'agevolata',
    'agevolate',
    'agevolati',
    'agevolato',
    'agevolatore',
    'agevolatori',
    'agevolatrice',
    'agevolatrici',
    'agevolava',
    'agevolavamo',
    'agevolavano',
    'agevolavate',
    'agevolavi',
    'agevolavo',
    'agevolazione',
    'agevolazioni',
    'agevole',
    'agevolera',
    'agevolerai',
    'agevoleranno',
    'agevolerebbe',
    'agevolerei',
    'agevoleremmo',
    'agevoleremo',
    'agevolereste',
    'agevoleresti',
    'agevolerete',
    'agevolero',
    'agevolezza',
    'agevolezze',
    'agevoli',
    'agevoliamo',
    'agevoliate',
    'agevolino',
    'agevolmente',
    'agevolo',
    'agfa',
    'aggaignare',
    'aggalla',
    'aggallai',
    'aggallammo',
    'aggallando',
    'aggallano',
    'aggallante',
    'aggallanti',
    'aggallare',
    'aggallarono',
    'aggallasse',
    'aggallassero',
    'aggallassi',
    'aggallassimo',
    'aggallaste',
    'aggallasti',
    'aggallata',
    'aggallate',
    'aggallati',
    'aggallato',
    'aggallava',
    'aggallavamo',
    'aggallavano',
    'aggallavate',
    'aggallavi',
    'aggallavo',
    'aggallera',
    'aggallerai',
    'aggalleranno',
    'aggallerebbe',
    'aggallerei',
    'aggalleremmo',
    'aggalleremo',
    'aggallereste',
    'aggalleresti',
    'aggallerete',
    'aggallero',
    'aggalli',
    'aggalliamo',
    'aggalliate',
    'aggallino',
    'aggallo',
    'aggancera',
    'aggancerai',
    'agganceranno',
    'aggancerebbe',
    'aggancerei',
    'agganceremmo',
    'agganceremo',
    'aggancereste',
    'agganceresti',
    'aggancerete',
    'aggancero',
    'agganci',
    'aggancia',
    'agganciai',
    'agganciammo',
    'agganciamo',
    'agganciando',
    'agganciano',
    'agganciante',
    'aggancianti',
    'agganciare',
    'agganciarla',
    'agganciarle',
    'agganciarli',
    'agganciarlo',
    'agganciarono',
    'agganciarsi',
    'agganciasse',
    'agganciassi',
    'agganciaste',
    'agganciasti',
    'agganciata',
    'agganciate',
    'agganciati',
    'agganciato',
    'agganciatore',
    'agganciatori',
    'agganciava',
    'agganciavamo',
    'agganciavano',
    'agganciavate',
    'agganciavi',
    'agganciavo',
    'aggancino',
    'aggancio',
    'agganghera',
    'aggangherai',
    'aggangherano',
    'aggangherare',
    'aggangherata',
    'aggangherate',
    'aggangherati',
    'aggangherato',
    'aggangherava',
    'aggangheravi',
    'aggangheravo',
    'aggangherera',
    'aggangherero',
    'aggangheri',
    'aggangherino',
    'agganghero',
    'aggarba',
    'aggarbai',
    'aggarbammo',
    'aggarbando',
    'aggarbano',
    'aggarbante',
    'aggarbanti',
    'aggarbare',
    'aggarbarono',
    'aggarbasse',
    'aggarbassero',
    'aggarbassi',
    'aggarbassimo',
    'aggarbaste',
    'aggarbasti',
    'aggarbata',
    'aggarbate',
    'aggarbati',
    'aggarbato',
    'aggarbava',
    'aggarbavamo',
    'aggarbavano',
    'aggarbavate',
    'aggarbavi',
    'aggarbavo',
    'aggarbera',
    'aggarberai',
    'aggarberanno',
    'aggarberebbe',
    'aggarberei',
    'aggarberemmo',
    'aggarberemo',
    'aggarbereste',
    'aggarberesti',
    'aggarberete',
    'aggarbero',
    'aggarbi',
    'aggarbiamo',
    'aggarbiate',
    'aggarbino',
    'aggarbo',
    'aggattona',
    'aggattonai',
    'aggattonammo',
    'aggattonando',
    'aggattonano',
    'aggattonante',
    'aggattonanti',
    'aggattonare',
    'aggattonasse',
    'aggattonassi',
    'aggattonaste',
    'aggattonasti',
    'aggattonata',
    'aggattonate',
    'aggattonati',
    'aggattonato',
    'aggattonava',
    'aggattonavi',
    'aggattonavo',
    'aggattonera',
    'aggattonerai',
    'aggattonerei',
    'aggattonero',
    'aggattoni',
    'aggattoniamo',
    'aggattoniate',
    'aggattonino',
    'aggattono',
    'aggavigna',
    'aggavignando',
    'aggavignano',
    'aggavignare',
    'aggavignarsi',
    'aggavignata',
    'aggavignate',
    'aggavignati',
    'aggavignato',
    'aggavignava',
    'aggavigno',
    'aggeggera',
    'aggeggerai',
    'aggeggeranno',
    'aggeggerebbe',
    'aggeggerei',
    'aggeggeremmo',
    'aggeggeremo',
    'aggeggereste',
    'aggeggeresti',
    'aggeggerete',
    'aggeggeria',
    'aggeggerie',
    'aggeggero',
    'aggeggi',
    'aggeggia',
    'aggeggiai',
    'aggeggiammo',
    'aggeggiamo',
    'aggeggiando',
    'aggeggiano',
    'aggeggiante',
    'aggeggianti',
    'aggeggiare',
    'aggeggiarono',
    'aggeggiasse',
    'aggeggiassi',
    'aggeggiaste',
    'aggeggiasti',
    'aggeggiata',
    'aggeggiate',
    'aggeggiati',
    'aggeggiato',
    'aggeggiava',
    'aggeggiavamo',
    'aggeggiavano',
    'aggeggiavate',
    'aggeggiavi',
    'aggeggiavo',
    'aggeggino',
    'aggeggio',
    'aggeggiona',
    'aggeggione',
    'aggeggioni',
    'aggela',
    'aggelai',
    'aggelammo',
    'aggelando',
    'aggelandosi',
    'aggelano',
    'aggelante',
    'aggelanti',
    'aggelare',
    'aggelarono',
    'aggelarsi',
    'aggelasse',
    'aggelassero',
    'aggelassi',
    'aggelassimo',
    'aggelaste',
    'aggelasti',
    'aggelata',
    'aggelate',
    'aggelati',
    'aggelato',
    'aggelava',
    'aggelavamo',
    'aggelavano',
    'aggelavate',
    'aggelavi',
    'aggelavo',
    'aggelera',
    'aggelerai',
    'aggeleranno',
    'aggelerebbe',
    'aggelerei',
    'aggeleremmo',
    'aggeleremo',
    'aggelereste',
    'aggeleresti',
    'aggelerete',
    'aggelero',
    'aggeli',
    'aggeliamo',
    'aggeliate',
    'aggelino',
    'aggelo',
    'aggentilendo',
    'aggentilente',
    'aggentilenti',
    'aggentili',
    'aggentiliamo',
    'aggentiliate',
    'aggentilii',
    'aggentilimmo',
    'aggentilira',
    'aggentilirai',
    'aggentilirci',
    'aggentilire',
    'aggentilirei',
    'aggentilirmi',
    'aggentiliro',
    'aggentilirsi',
    'aggentilirti',
    'aggentilirvi',
    'aggentilisca',
    'aggentilisce',
    'aggentilisci',
    'aggentilisco',
    'aggentilisse',
    'aggentilissi',
    'aggentiliste',
    'aggentilisti',
    'aggentilita',
    'aggentilite',
    'aggentiliti',
    'aggentilito',
    'aggentiliva',
    'aggentilivi',
    'aggentilivo',
    'aggeo',
    'aggere',
    'aggeri',
    'aggetta',
    'aggettai',
    'aggettammo',
    'aggettando',
    'aggettano',
    'aggettante',
    'aggettanti',
    'aggettare',
    'aggettarono',
    'aggettasse',
    'aggettassero',
    'aggettassi',
    'aggettassimo',
    'aggettaste',
    'aggettasti',
    'aggettata',
    'aggettate',
    'aggettati',
    'aggettato',
    'aggettava',
    'aggettavamo',
    'aggettavano',
    'aggettavate',
    'aggettavi',
    'aggettavo',
    'aggettera',
    'aggetterai',
    'aggetteranno',
    'aggetterebbe',
    'aggetterei',
    'aggetteremmo',
    'aggetteremo',
    'aggettereste',
    'aggetteresti',
    'aggetterete',
    'aggettero',
    'aggetti',
    'aggettiamo',
    'aggettiate',
    'aggettino',
    'aggettiva',
    'aggettivai',
    'aggettivale',
    'aggettivali',
    'aggettivammo',
    'aggettivando',
    'aggettivano',
    'aggettivante',
    'aggettivanti',
    'aggettivare',
    'aggettivasse',
    'aggettivassi',
    'aggettivaste',
    'aggettivasti',
    'aggettivata',
    'aggettivate',
    'aggettivati',
    'aggettivato',
    'aggettivava',
    'aggettivavi',
    'aggettivavo',
    'aggettivera',
    'aggettiverai',
    'aggettiverei',
    'aggettivero',
    'aggettivi',
    'aggettiviamo',
    'aggettiviate',
    'aggettivino',
    'aggettivo',
    'aggetto',
    'agghiaccera',
    'agghiaccerai',
    'agghiaccerei',
    'agghiaccero',
    'agghiacci',
    'agghiaccia',
    'agghiacciai',
    'agghiacciamo',
    'agghiacciano',
    'agghiacciare',
    'agghiacciata',
    'agghiacciate',
    'agghiacciati',
    'agghiacciato',
    'agghiacciava',
    'agghiacciavi',
    'agghiacciavo',
    'agghiaccino',
    'agghiaccio',
    'agghiadando',
    'agghiadare',
    'agghiadarsi',
    'agghiadata',
    'agghiadate',
    'agghiadati',
    'agghiadato',
    'agghiadava',
    'agghiadavano',
    'agghiai',
    'agghiaia',
    'agghiaiai',
    'agghiaiammo',
    'agghiaiamo',
    'agghiaiando',
    'agghiaiano',
    'agghiaiante',
    'agghiaianti',
    'agghiaiare',
    'agghiaiarono',
    'agghiaiasse',
    'agghiaiassi',
    'agghiaiaste',
    'agghiaiasti',
    'agghiaiata',
    'agghiaiate',
    'agghiaiati',
    'agghiaiato',
    'agghiaiava',
    'agghiaiavamo',
    'agghiaiavano',
    'agghiaiavate',
    'agghiaiavi',
    'agghiaiavo',
    'agghiaiera',
    'agghiaierai',
    'agghiaierei',
    'agghiaieremo',
    'agghiaierete',
    'agghiaiero',
    'agghiaino',
    'agghiaio',
    'agghinda',
    'agghindai',
    'agghindammo',
    'agghindando',
    'agghindano',
    'agghindante',
    'agghindanti',
    'agghindarci',
    'agghindare',
    'agghindarmi',
    'agghindarono',
    'agghindarsi',
    'agghindarti',
    'agghindarvi',
    'agghindasse',
    'agghindassi',
    'agghindaste',
    'agghindasti',
    'agghindata',
    'agghindate',
    'agghindatevi',
    'agghindati',
    'agghindato',
    'agghindatomi',
    'agghindatoti',
    'agghindava',
    'agghindavamo',
    'agghindavano',
    'agghindavate',
    'agghindavi',
    'agghindavo',
    'agghindera',
    'agghinderai',
    'agghinderei',
    'agghinderemo',
    'agghinderete',
    'agghindero',
    'agghindi',
    'agghindiamo',
    'agghindiate',
    'agghindino',
    'agghindo',
    'aggi',
    'aggiaccio',
    'aggiatore',
    'aggiatori',
    'aggio',
    'aggioga',
    'aggiogai',
    'aggiogamenti',
    'aggiogamento',
    'aggiogammo',
    'aggiogando',
    'aggiogano',
    'aggiogante',
    'aggioganti',
    'aggiogare',
    'aggiogarono',
    'aggiogasse',
    'aggiogassero',
    'aggiogassi',
    'aggiogassimo',
    'aggiogaste',
    'aggiogasti',
    'aggiogata',
    'aggiogate',
    'aggiogati',
    'aggiogato',
    'aggiogava',
    'aggiogavamo',
    'aggiogavano',
    'aggiogavate',
    'aggiogavi',
    'aggiogavo',
    'aggioghera',
    'aggiogherai',
    'aggiogherei',
    'aggiogheremo',
    'aggiogherete',
    'aggioghero',
    'aggioghi',
    'aggioghiamo',
    'aggioghiate',
    'aggioghino',
    'aggiogo',
    'aggiorna',
    'aggiornabile',
    'aggiornabili',
    'aggiornai',
    'aggiornammo',
    'aggiornando',
    'aggiornano',
    'aggiornante',
    'aggiornanti',
    'aggiornarci',
    'aggiornare',
    'aggiornarla',
    'aggiornarle',
    'aggiornarli',
    'aggiornarlo',
    'aggiornarmi',
    'aggiornarono',
    'aggiornarsi',
    'aggiornarti',
    'aggiornarvi',
    'aggiornasse',
    'aggiornassi',
    'aggiornaste',
    'aggiornasti',
    'aggiornata',
    'aggiornate',
    'aggiornatevi',
    'aggiornati',
    'aggiornato',
    'aggiornatomi',
    'aggiornatoti',
    'aggiornava',
    'aggiornavamo',
    'aggiornavano',
    'aggiornavate',
    'aggiornavi',
    'aggiornavo',
    'aggiornera',
    'aggiornerai',
    'aggiornerei',
    'aggiorneremo',
    'aggiornerete',
    'aggiornero',
    'aggiorni',
    'aggiorniamo',
    'aggiorniate',
    'aggiornino',
    'aggiorno',
    'aggiotaggi',
    'aggiotaggio',
    'aggiotatore',
    'aggiotatori',
    'aggiotatrice',
    'aggiotatrici',
    'aggira',
    'aggirai',
    'aggiramenti',
    'aggiramento',
    'aggirammo',
    'aggirando',
    'aggirandoci',
    'aggirandomi',
    'aggirandosi',
    'aggirandoti',
    'aggirandovi',
    'aggirano',
    'aggirante',
    'aggiranti',
    'aggirantisi',
    'aggirarci',
    'aggirare',
    'aggirarmi',
    'aggirarono',
    'aggirarsi',
    'aggirarti',
    'aggirarvi',
    'aggirasse',
    'aggirassero',
    'aggirassi',
    'aggirassimo',
    'aggiraste',
    'aggirasti',
    'aggirata',
    'aggirate',
    'aggiratevi',
    'aggirati',
    'aggirato',
    'aggiratomi',
    'aggiratore',
    'aggiratori',
    'aggiratoti',
    'aggiratrice',
    'aggiratrici',
    'aggirava',
    'aggiravamo',
    'aggiravano',
    'aggiravate',
    'aggiravi',
    'aggiravo',
    'aggirera',
    'aggirerai',
    'aggireranno',
    'aggirerebbe',
    'aggirerei',
    'aggireremmo',
    'aggireremo',
    'aggirereste',
    'aggireresti',
    'aggirerete',
    'aggirero',
    'aggiri',
    'aggiriamo',
    'aggiriamoci',
    'aggiriate',
    'aggirino',
    'aggiro',
    'aggiudica',
    'aggiudicai',
    'aggiudicammo',
    'aggiudicando',
    'aggiudicano',
    'aggiudicante',
    'aggiudicanti',
    'aggiudicarci',
    'aggiudicare',
    'aggiudicarmi',
    'aggiudicarsi',
    'aggiudicarti',
    'aggiudicarvi',
    'aggiudicasse',
    'aggiudicassi',
    'aggiudicaste',
    'aggiudicasti',
    'aggiudicata',
    'aggiudicate',
    'aggiudicati',
    'aggiudicato',
    'aggiudicava',
    'aggiudicavi',
    'aggiudicavo',
    'aggiudichera',
    'aggiudichero',
    'aggiudichi',
    'aggiudichino',
    'aggiudico',
    'aggiugnere',
    'aggiunga',
    'aggiungano',
    'aggiungasi',
    'aggiunge',
    'aggiungemmo',
    'aggiungendo',
    'aggiungente',
    'aggiungenti',
    'aggiungera',
    'aggiungerai',
    'aggiungerci',
    'aggiungere',
    'aggiungerei',
    'aggiungeremo',
    'aggiungerete',
    'aggiungerla',
    'aggiungermi',
    'aggiungero',
    'aggiungersi',
    'aggiungerti',
    'aggiungervi',
    'aggiungerò',
    'aggiungesse',
    'aggiungessi',
    'aggiungeste',
    'aggiungesti',
    'aggiungete',
    'aggiungetevi',
    'aggiungeva',
    'aggiungevamo',
    'aggiungevano',
    'aggiungevate',
    'aggiungevi',
    'aggiungevo',
    'aggiungi',
    'aggiungiamo',
    'aggiungiate',
    'aggiungilo',
    'aggiungimi',
    'aggiungiti',
    'aggiungo',
    'aggiungono',
    'aggiunse',
    'aggiunsero',
    'aggiunsi',
    'aggiunta',
    'aggiuntai',
    'aggiuntammo',
    'aggiuntando',
    'aggiuntano',
    'aggiuntante',
    'aggiuntanti',
    'aggiuntare',
    'aggiuntarono',
    'aggiuntasse',
    'aggiuntassi',
    'aggiuntaste',
    'aggiuntasti',
    'aggiuntata',
    'aggiuntate',
    'aggiuntati',
    'aggiuntato',
    'aggiuntatora',
    'aggiuntatore',
    'aggiuntatori',
    'aggiuntatura',
    'aggiuntature',
    'aggiuntava',
    'aggiuntavamo',
    'aggiuntavano',
    'aggiuntavate',
    'aggiuntavi',
    'aggiuntavo',
    'aggiunte',
    'aggiuntera',
    'aggiunterai',
    'aggiunterei',
    'aggiunteremo',
    'aggiunterete',
    'aggiuntero',
    'aggiunti',
    'aggiuntiamo',
    'aggiuntiate',
    'aggiuntina',
    'aggiuntine',
    'aggiuntino',
    'aggiuntiva',
    'aggiuntive',
    'aggiuntivi',
    'aggiuntivo',
    'aggiunto',
    'aggiuntomi',
    'aggiuntoti',
    'aggiuntovi',
    'aggiunzione',
    'aggiunzioni',
    'aggiusta',
    'aggiustabile',
    'aggiustabili',
    'aggiustaggi',
    'aggiustaggio',
    'aggiustai',
    'aggiustammo',
    'aggiustando',
    'aggiustano',
    'aggiustante',
    'aggiustanti',
    'aggiustarci',
    'aggiustare',
    'aggiustarla',
    'aggiustarle',
    'aggiustarli',
    'aggiustarlo',
    'aggiustarmi',
    'aggiustarono',
    'aggiustarsi',
    'aggiustarti',
    'aggiustarvi',
    'aggiustasse',
    'aggiustassi',
    'aggiustaste',
    'aggiustasti',
    'aggiustata',
    'aggiustate',
    'aggiustatevi',
    'aggiustati',
    'aggiustato',
    'aggiustatomi',
    'aggiustatore',
    'aggiustatori',
    'aggiustatoti',
    'aggiustatura',
    'aggiustature',
    'aggiustava',
    'aggiustavamo',
    'aggiustavano',
    'aggiustavate',
    'aggiustavi',
    'aggiustavo',
    'aggiustera',
    'aggiusterai',
    'aggiusterei',
    'aggiusteremo',
    'aggiusterete',
    'aggiustero',
    'aggiusti',
    'aggiustiamo',
    'aggiustiate',
    'aggiustino',
    'aggiusto',
    'agglomera',
    'agglomerai',
    'agglomerammo',
    'agglomerando',
    'agglomerano',
    'agglomerante',
    'agglomeranti',
    'agglomerarci',
    'agglomerare',
    'agglomerarmi',
    'agglomerarsi',
    'agglomerarti',
    'agglomerarvi',
    'agglomerasse',
    'agglomerassi',
    'agglomeraste',
    'agglomerasti',
    'agglomerata',
    'agglomerate',
    'agglomerati',
    'agglomerato',
    'agglomerava',
    'agglomeravi',
    'agglomeravo',
    'agglomerera',
    'agglomererai',
    'agglomererei',
    'agglomerero',
    'agglomeri',
    'agglomeriamo',
    'agglomeriate',
    'agglomerino',
    'agglomero',
    'agglutina',
    'agglutinai',
    'agglutinammo',
    'agglutinando',
    'agglutinano',
    'agglutinante',
    'agglutinanti',
    'agglutinarci',
    'agglutinare',
    'agglutinarmi',
    'agglutinarsi',
    'agglutinarti',
    'agglutinarvi',
    'agglutinasse',
    'agglutinassi',
    'agglutinaste',
    'agglutinasti',
    'agglutinata',
    'agglutinate',
    'agglutinati',
    'agglutinato',
    'agglutinava',
    'agglutinavi',
    'agglutinavo',
    'agglutinera',
    'agglutinerai',
    'agglutinerei',
    'agglutinero',
    'agglutini',
    'agglutiniamo',
    'agglutiniate',
    'agglutinina',
    'agglutinine',
    'agglutinino',
    'agglutino',
    'aggobbendo',
    'aggobbendoci',
    'aggobbendomi',
    'aggobbendosi',
    'aggobbendoti',
    'aggobbendovi',
    'aggobbente',
    'aggobbenti',
    'aggobbentisi',
    'aggobbi',
    'aggobbiamo',
    'aggobbiamoci',
    'aggobbiate',
    'aggobbii',
    'aggobbimmo',
    'aggobbira',
    'aggobbirai',
    'aggobbiranno',
    'aggobbirci',
    'aggobbire',
    'aggobbirebbe',
    'aggobbirei',
    'aggobbiremmo',
    'aggobbiremo',
    'aggobbireste',
    'aggobbiresti',
    'aggobbirete',
    'aggobbirmi',
    'aggobbiro',
    'aggobbirono',
    'aggobbirsi',
    'aggobbirti',
    'aggobbirvi',
    'aggobbisca',
    'aggobbiscano',
    'aggobbisce',
    'aggobbisci',
    'aggobbisciti',
    'aggobbisco',
    'aggobbiscono',
    'aggobbisse',
    'aggobbissero',
    'aggobbissi',
    'aggobbissimo',
    'aggobbiste',
    'aggobbisti',
    'aggobbita',
    'aggobbite',
    'aggobbitevi',
    'aggobbiti',
    'aggobbito',
    'aggobbitomi',
    'aggobbitoti',
    'aggobbiva',
    'aggobbivamo',
    'aggobbivano',
    'aggobbivate',
    'aggobbivi',
    'aggobbivo',
    'aggomitola',
    'aggomitolai',
    'aggomitolano',
    'aggomitolare',
    'aggomitolata',
    'aggomitolate',
    'aggomitolati',
    'aggomitolato',
    'aggomitolava',
    'aggomitolavi',
    'aggomitolavo',
    'aggomitolera',
    'aggomitolero',
    'aggomitoli',
    'aggomitolino',
    'aggomitolo',
    'aggotta',
    'aggottai',
    'aggottamenti',
    'aggottamento',
    'aggottammo',
    'aggottando',
    'aggottano',
    'aggottante',
    'aggottanti',
    'aggottare',
    'aggottarono',
    'aggottasse',
    'aggottassero',
    'aggottassi',
    'aggottassimo',
    'aggottaste',
    'aggottasti',
    'aggottata',
    'aggottate',
    'aggottati',
    'aggottato',
    'aggottatoi',
    'aggottatoio',
    'aggottava',
    'aggottavamo',
    'aggottavano',
    'aggottavate',
    'aggottavi',
    'aggottavo',
    'aggottera',
    'aggotterai',
    'aggotteranno',
    'aggotterebbe',
    'aggotterei',
    'aggotteremmo',
    'aggotteremo',
    'aggottereste',
    'aggotteresti',
    'aggotterete',
    'aggottero',
    'aggotti',
    'aggottiamo',
    'aggottiate',
    'aggottino',
    'aggotto',
    'aggrada',
    'aggradando',
    'aggradante',
    'aggradare',
    'aggradava',
    'aggradendo',
    'aggradente',
    'aggradenti',
    'aggradevole',
    'aggradevoli',
    'aggradi',
    'aggradiamo',
    'aggradiate',
    'aggradii',
    'aggradimmo',
    'aggradira',
    'aggradirai',
    'aggradiranno',
    'aggradire',
    'aggradirebbe',
    'aggradirei',
    'aggradiremmo',
    'aggradiremo',
    'aggradireste',
    'aggradiresti',
    'aggradirete',
    'aggradiro',
    'aggradirono',
    'aggradisca',
    'aggradiscano',
    'aggradisce',
    'aggradisci',
    'aggradisco',
    'aggradiscono',
    'aggradisse',
    'aggradissero',
    'aggradissi',
    'aggradissimo',
    'aggradiste',
    'aggradisti',
    'aggradita',
    'aggradite',
    'aggraditi',
    'aggradito',
    'aggradiva',
    'aggradivamo',
    'aggradivano',
    'aggradivate',
    'aggradivi',
    'aggradivo',
    'aggrado',
    'aggraffa',
    'aggraffaggi',
    'aggraffaggio',
    'aggraffai',
    'aggraffammo',
    'aggraffando',
    'aggraffano',
    'aggraffante',
    'aggraffanti',
    'aggraffare',
    'aggraffarono',
    'aggraffasse',
    'aggraffassi',
    'aggraffaste',
    'aggraffasti',
    'aggraffata',
    'aggraffate',
    'aggraffati',
    'aggraffato',
    'aggraffatore',
    'aggraffatori',
    'aggraffatura',
    'aggraffature',
    'aggraffava',
    'aggraffavamo',
    'aggraffavano',
    'aggraffavate',
    'aggraffavi',
    'aggraffavo',
    'aggraffera',
    'aggrafferai',
    'aggrafferei',
    'aggrafferemo',
    'aggrafferete',
    'aggraffero',
    'aggraffi',
    'aggraffia',
    'aggraffiai',
    'aggraffiammo',
    'aggraffiamo',
    'aggraffiando',
    'aggraffiano',
    'aggraffiante',
    'aggraffianti',
    'aggraffiare',
    'aggraffiasse',
    'aggraffiassi',
    'aggraffiaste',
    'aggraffiasti',
    'aggraffiata',
    'aggraffiate',
    'aggraffiati',
    'aggraffiato',
    'aggraffiava',
    'aggraffiavi',
    'aggraffiavo',
    'aggraffiera',
    'aggraffierai',
    'aggraffierei',
    'aggraffiero',
    'aggraffino',
    'aggraffio',
    'aggraffo',
    'aggranchendo',
    'aggranchente',
    'aggranchenti',
    'aggranchi',
    'aggranchia',
    'aggranchiai',
    'aggranchiamo',
    'aggranchiano',
    'aggranchiare',
    'aggranchiata',
    'aggranchiate',
    'aggranchiati',
    'aggranchiato',
    'aggranchiava',
    'aggranchiavi',
    'aggranchiavo',
    'aggranchiera',
    'aggranchiero',
    'aggranchii',
    'aggranchimmo',
    'aggranchino',
    'aggranchio',
    'aggranchira',
    'aggranchirai',
    'aggranchirci',
    'aggranchire',
    'aggranchirei',
    'aggranchirmi',
    'aggranchiro',
    'aggranchirsi',
    'aggranchirti',
    'aggranchirvi',
    'aggranchisca',
    'aggranchisce',
    'aggranchisci',
    'aggranchisco',
    'aggranchisse',
    'aggranchissi',
    'aggranchiste',
    'aggranchisti',
    'aggranchita',
    'aggranchite',
    'aggranchiti',
    'aggranchito',
    'aggranchiva',
    'aggranchivi',
    'aggranchivo',
    'aggrandendo',
    'aggrandente',
    'aggrandenti',
    'aggrandi',
    'aggrandiamo',
    'aggrandiate',
    'aggrandii',
    'aggrandimmo',
    'aggrandira',
    'aggrandirai',
    'aggrandirci',
    'aggrandire',
    'aggrandirei',
    'aggrandiremo',
    'aggrandirete',
    'aggrandirmi',
    'aggrandiro',
    'aggrandirono',
    'aggrandirsi',
    'aggrandirti',
    'aggrandirvi',
    'aggrandisca',
    'aggrandisce',
    'aggrandisci',
    'aggrandisco',
    'aggrandisse',
    'aggrandissi',
    'aggrandiste',
    'aggrandisti',
    'aggrandita',
    'aggrandite',
    'aggranditevi',
    'aggranditi',
    'aggrandito',
    'aggranditomi',
    'aggranditoti',
    'aggrandiva',
    'aggrandivamo',
    'aggrandivano',
    'aggrandivate',
    'aggrandivi',
    'aggrandivo',
    'aggranfi',
    'aggranfia',
    'aggranfiai',
    'aggranfiammo',
    'aggranfiamo',
    'aggranfiando',
    'aggranfiano',
    'aggranfiante',
    'aggranfianti',
    'aggranfiare',
    'aggranfiasse',
    'aggranfiassi',
    'aggranfiaste',
    'aggranfiasti',
    'aggranfiata',
    'aggranfiate',
    'aggranfiati',
    'aggranfiato',
    'aggranfiava',
    'aggranfiavi',
    'aggranfiavo',
    'aggranfiera',
    'aggranfierai',
    'aggranfierei',
    'aggranfiero',
    'aggranfino',
    'aggranfio',
    'aggrappa',
    'aggrappai',
    'aggrappammo',
    'aggrappando',
    'aggrappano',
    'aggrappante',
    'aggrappanti',
    'aggrapparci',
    'aggrappare',
    'aggrapparmi',
    'aggrapparono',
    'aggrapparsi',
    'aggrapparti',
    'aggrapparvi',
    'aggrappasse',
    'aggrappassi',
    'aggrappaste',
    'aggrappasti',
    'aggrappata',
    'aggrappate',
    'aggrappatevi',
    'aggrappati',
    'aggrappato',
    'aggrappatomi',
    'aggrappatoti',
    'aggrappava',
    'aggrappavamo',
    'aggrappavano',
    'aggrappavate',
    'aggrappavi',
    'aggrappavo',
    'aggrappera',
    'aggrapperai',
    'aggrapperei',
    'aggrapperemo',
    'aggrapperete',
    'aggrappero',
    'aggrappi',
    'aggrappiamo',
    'aggrappiate',
    'aggrappino',
    'aggrappo',
    'aggraticcera',
    'aggraticcero',
    'aggraticci',
    'aggraticcia',
    'aggraticciai',
    'aggraticcino',
    'aggraticcio',
    'aggrava',
    'aggravai',
    'aggravamenti',
    'aggravamento',
    'aggravammo',
    'aggravando',
    'aggravandoci',
    'aggravandomi',
    'aggravandosi',
    'aggravandoti',
    'aggravandovi',
    'aggravano',
    'aggravante',
    'aggravanti',
    'aggravantisi',
    'aggravarci',
    'aggravare',
    'aggravarmi',
    'aggravarono',
    'aggravarsi',
    'aggravarti',
    'aggravarvi',
    'aggravasse',
    'aggravassero',
    'aggravassi',
    'aggravassimo',
    'aggravaste',
    'aggravasti',
    'aggravata',
    'aggravate',
    'aggravatevi',
    'aggravati',
    'aggravato',
    'aggravatomi',
    'aggravatoti',
    'aggravava',
    'aggravavamo',
    'aggravavano',
    'aggravavate',
    'aggravavi',
    'aggravavo',
    'aggravera',
    'aggraverai',
    'aggraveranno',
    'aggraverebbe',
    'aggraverei',
    'aggraveremmo',
    'aggraveremo',
    'aggravereste',
    'aggraveresti',
    'aggraverete',
    'aggravero',
    'aggraverà',
    'aggravi',
    'aggraviamo',
    'aggraviamoci',
    'aggraviate',
    'aggravino',
    'aggravio',
    'aggravo',
    'aggrazi',
    'aggrazia',
    'aggraziai',
    'aggraziammo',
    'aggraziamo',
    'aggraziamoci',
    'aggraziando',
    'aggraziano',
    'aggraziante',
    'aggrazianti',
    'aggraziarci',
    'aggraziare',
    'aggraziarmi',
    'aggraziarono',
    'aggraziarsi',
    'aggraziarti',
    'aggraziarvi',
    'aggraziasse',
    'aggraziassi',
    'aggraziaste',
    'aggraziasti',
    'aggraziata',
    'aggraziate',
    'aggraziatevi',
    'aggraziati',
    'aggraziato',
    'aggraziatomi',
    'aggraziatoti',
    'aggraziava',
    'aggraziavamo',
    'aggraziavano',
    'aggraziavate',
    'aggraziavi',
    'aggraziavo',
    'aggraziera',
    'aggrazierai',
    'aggrazierei',
    'aggrazieremo',
    'aggrazierete',
    'aggraziero',
    'aggrazino',
    'aggrazio',
    'aggredendo',
    'aggredendoci',
    'aggredendola',
    'aggredendole',
    'aggredendoli',
    'aggredendolo',
    'aggredendomi',
    'aggredendoti',
    'aggredendovi',
    'aggredente',
    'aggredenti',
    'aggredi',
    'aggrediamo',
    'aggrediate',
    'aggredii',
    'aggredimmo',
    'aggredira',
    'aggredirai',
    'aggrediranno',
    'aggredirci',
    'aggredire',
    'aggredirebbe',
    'aggredirei',
    'aggrediremmo',
    'aggrediremo',
    'aggredireste',
    'aggrediresti',
    'aggredirete',
    'aggredirla',
    'aggredirle',
    'aggredirli',
    'aggredirlo',
    'aggredirmi',
    'aggrediro',
    'aggredirono',
    'aggredirti',
    'aggredirvi',
    'aggredisca',
    'aggrediscano',
    'aggredisce',
    'aggredisci',
    'aggredisco',
    'aggrediscono',
    'aggredisse',
    'aggredissero',
    'aggredissi',
    'aggredissimo',
    'aggrediste',
    'aggredisti',
    'aggredita',
    'aggredite',
    'aggrediti',
    'aggredito',
    'aggreditrice',
    'aggreditrici',
    'aggrediva',
    'aggredivamo',
    'aggredivano',
    'aggredivate',
    'aggredivi',
    'aggredivo',
    'aggrega',
    'aggregabile',
    'aggregabili',
    'aggregai',
    'aggregamenti',
    'aggregamento',
    'aggregammo',
    'aggregando',
    'aggregandoci',
    'aggregandola',
    'aggregandole',
    'aggregandoli',
    'aggregandolo',
    'aggregandomi',
    'aggregandosi',
    'aggregandoti',
    'aggregandovi',
    'aggregano',
    'aggregante',
    'aggreganti',
    'aggregantisi',
    'aggregarci',
    'aggregare',
    'aggregarli',
    'aggregarmi',
    'aggregarne',
    'aggregarono',
    'aggregarsi',
    'aggregarti',
    'aggregarvi',
    'aggregasse',
    'aggregassero',
    'aggregassi',
    'aggregassimo',
    'aggregaste',
    'aggregasti',
    'aggregata',
    'aggregate',
    'aggregatevi',
    'aggregati',
    'aggregativa',
    'aggregative',
    'aggregativi',
    'aggregativo',
    'aggregato',
    'aggregatomi',
    'aggregatoti',
    'aggregava',
    'aggregavamo',
    'aggregavano',
    'aggregavate',
    'aggregavi',
    'aggregavo',
    'aggregazione',
    'aggregazioni',
    'aggreghera',
    'aggregherai',
    'aggregherei',
    'aggregheremo',
    'aggregherete',
    'aggreghero',
    'aggreghi',
    'aggreghiamo',
    'aggreghiate',
    'aggreghino',
    'aggrego',
    'aggressina',
    'aggressine',
    'aggressione',
    'aggressioni',
    'aggressiva',
    'aggressive',
    'aggressivi',
    'aggressivita',
    'aggressività',
    'aggressivo',
    'aggressore',
    'aggressori',
    'aggreva',
    'aggrevai',
    'aggrevammo',
    'aggrevando',
    'aggrevano',
    'aggrevante',
    'aggrevanti',
    'aggrevare',
    'aggrevarono',
    'aggrevasse',
    'aggrevassero',
    'aggrevassi',
    'aggrevassimo',
    'aggrevaste',
    'aggrevasti',
    'aggrevata',
    'aggrevate',
    'aggrevati',
    'aggrevato',
    'aggrevava',
    'aggrevavamo',
    'aggrevavano',
    'aggrevavate',
    'aggrevavi',
    'aggrevavo',
    'aggrevera',
    'aggreverai',
    'aggreveranno',
    'aggreverebbe',
    'aggreverei',
    'aggreveremmo',
    'aggreveremo',
    'aggrevereste',
    'aggreveresti',
    'aggreverete',
    'aggrevero',
    'aggrevi',
    'aggreviamo',
    'aggreviate',
    'aggrevino',
    'aggrevo',
    'aggriccera',
    'aggriccerai',
    'aggriccerei',
    'aggricceremo',
    'aggriccerete',
    'aggriccero',
    'aggricci',
    'aggriccia',
    'aggricciai',
    'aggricciammo',
    'aggricciamo',
    'aggricciando',
    'aggricciano',
    'aggricciante',
    'aggriccianti',
    'aggricciarci',
    'aggricciare',
    'aggricciarmi',
    'aggricciarsi',
    'aggricciarti',
    'aggricciarvi',
    'aggricciasse',
    'aggricciassi',
    'aggricciaste',
    'aggricciasti',
    'aggricciata',
    'aggricciate',
    'aggricciati',
    'aggricciato',
    'aggricciava',
    'aggricciavi',
    'aggricciavo',
    'aggriccino',
    'aggriccio',
    'aggrinza',
    'aggrinzai',
    'aggrinzammo',
    'aggrinzando',
    'aggrinzano',
    'aggrinzante',
    'aggrinzanti',
    'aggrinzarci',
    'aggrinzare',
    'aggrinzarmi',
    'aggrinzarono',
    'aggrinzarsi',
    'aggrinzarti',
    'aggrinzarvi',
    'aggrinzasse',
    'aggrinzassi',
    'aggrinzaste',
    'aggrinzasti',
    'aggrinzata',
    'aggrinzate',
    'aggrinzatevi',
    'aggrinzati',
    'aggrinzato',
    'aggrinzatomi',
    'aggrinzatoti',
    'aggrinzava',
    'aggrinzavamo',
    'aggrinzavano',
    'aggrinzavate',
    'aggrinzavi',
    'aggrinzavo',
    'aggrinzendo',
    'aggrinzente',
    'aggrinzenti',
    'aggrinzera',
    'aggrinzerai',
    'aggrinzerei',
    'aggrinzeremo',
    'aggrinzerete',
    'aggrinzero',
    'aggrinzi',
    'aggrinziamo',
    'aggrinziate',
    'aggrinzii',
    'aggrinzimmo',
    'aggrinzino',
    'aggrinzira',
    'aggrinzirai',
    'aggrinzirci',
    'aggrinzire',
    'aggrinzirei',
    'aggrinziremo',
    'aggrinzirete',
    'aggrinzirmi',
    'aggrinziro',
    'aggrinzirono',
    'aggrinzirsi',
    'aggrinzirti',
    'aggrinzirvi',
    'aggrinzisca',
    'aggrinzisce',
    'aggrinzisci',
    'aggrinzisco',
    'aggrinzisse',
    'aggrinzissi',
    'aggrinziste',
    'aggrinzisti',
    'aggrinzita',
    'aggrinzite',
    'aggrinzitevi',
    'aggrinziti',
    'aggrinzito',
    'aggrinzitomi',
    'aggrinzitoti',
    'aggrinziva',
    'aggrinzivamo',
    'aggrinzivano',
    'aggrinzivate',
    'aggrinzivi',
    'aggrinzivo',
    'aggrinzo',
    'aggromma',
    'aggrommai',
    'aggrommammo',
    'aggrommando',
    'aggrommano',
    'aggrommante',
    'aggrommanti',
    'aggrommarci',
    'aggrommare',
    'aggrommarmi',
    'aggrommarono',
    'aggrommarsi',
    'aggrommarti',
    'aggrommarvi',
    'aggrommasse',
    'aggrommassi',
    'aggrommaste',
    'aggrommasti',
    'aggrommata',
    'aggrommate',
    'aggrommatevi',
    'aggrommati',
    'aggrommato',
    'aggrommatomi',
    'aggrommatoti',
    'aggrommava',
    'aggrommavamo',
    'aggrommavano',
    'aggrommavate',
    'aggrommavi',
    'aggrommavo',
    'aggrommera',
    'aggrommerai',
    'aggrommerei',
    'aggrommeremo',
    'aggrommerete',
    'aggrommero',
    'aggrommi',
    'aggrommiamo',
    'aggrommiate',
    'aggrommino',
    'aggrommo',
    'aggronda',
    'aggrondai',
    'aggrondammo',
    'aggrondando',
    'aggrondano',
    'aggrondante',
    'aggrondanti',
    'aggrondare',
    'aggrondarono',
    'aggrondarsi',
    'aggrondasse',
    'aggrondassi',
    'aggrondaste',
    'aggrondasti',
    'aggrondata',
    'aggrondate',
    'aggrondati',
    'aggrondato',
    'aggrondava',
    'aggrondavamo',
    'aggrondavano',
    'aggrondavate',
    'aggrondavi',
    'aggrondavo',
    'aggrondera',
    'aggronderai',
    'aggronderei',
    'aggronderemo',
    'aggronderete',
    'aggrondero',
    'aggrondi',
    'aggrondiamo',
    'aggrondiate',
    'aggrondino',
    'aggrondo',
    'aggroppa',
    'aggroppai',
    'aggroppammo',
    'aggroppando',
    'aggroppano',
    'aggroppante',
    'aggroppanti',
    'aggropparci',
    'aggroppare',
    'aggropparmi',
    'aggropparono',
    'aggropparsi',
    'aggropparti',
    'aggropparvi',
    'aggroppasse',
    'aggroppassi',
    'aggroppaste',
    'aggroppasti',
    'aggroppata',
    'aggroppate',
    'aggroppatevi',
    'aggroppati',
    'aggroppato',
    'aggroppatomi',
    'aggroppatoti',
    'aggroppava',
    'aggroppavamo',
    'aggroppavano',
    'aggroppavate',
    'aggroppavi',
    'aggroppavo',
    'aggroppera',
    'aggropperai',
    'aggropperei',
    'aggropperemo',
    'aggropperete',
    'aggroppero',
    'aggroppi',
    'aggroppiamo',
    'aggroppiate',
    'aggroppino',
    'aggroppo',
    'aggrotta',
    'aggrottai',
    'aggrottammo',
    'aggrottando',
    'aggrottano',
    'aggrottante',
    'aggrottanti',
    'aggrottare',
    'aggrottarono',
    'aggrottasse',
    'aggrottassi',
    'aggrottaste',
    'aggrottasti',
    'aggrottata',
    'aggrottate',
    'aggrottati',
    'aggrottato',
    'aggrottava',
    'aggrottavamo',
    'aggrottavano',
    'aggrottavate',
    'aggrottavi',
    'aggrottavo',
    'aggrottera',
    'aggrotterai',
    'aggrotterei',
    'aggrotteremo',
    'aggrotterete',
    'aggrottero',
    'aggrotti',
    'aggrottiamo',
    'aggrottiate',
    'aggrottino',
    'aggrotto',
    'aggrovigli',
    'aggroviglia',
    'aggrovigliai',
    'aggroviglino',
    'aggroviglio',
    'aggruma',
    'aggrumai',
    'aggrumammo',
    'aggrumando',
    'aggrumandoci',
    'aggrumandomi',
    'aggrumandosi',
    'aggrumandoti',
    'aggrumandovi',
    'aggrumano',
    'aggrumante',
    'aggrumanti',
    'aggrumantisi',
    'aggrumarci',
    'aggrumare',
    'aggrumarmi',
    'aggrumarono',
    'aggrumarsi',
    'aggrumarti',
    'aggrumarvi',
    'aggrumasse',
    'aggrumassero',
    'aggrumassi',
    'aggrumassimo',
    'aggrumaste',
    'aggrumasti',
    'aggrumata',
    'aggrumate',
    'aggrumatevi',
    'aggrumati',
    'aggrumato',
    'aggrumatomi',
    'aggrumatoti',
    'aggrumava',
    'aggrumavamo',
    'aggrumavano',
    'aggrumavate',
    'aggrumavi',
    'aggrumavo',
    'aggrumera',
    'aggrumerai',
    'aggrumeranno',
    'aggrumerebbe',
    'aggrumerei',
    'aggrumeremmo',
    'aggrumeremo',
    'aggrumereste',
    'aggrumeresti',
    'aggrumerete',
    'aggrumero',
    'aggrumi',
    'aggrumiamo',
    'aggrumiamoci',
    'aggrumiate',
    'aggrumino',
    'aggrumo',
    'aggrumola',
    'aggrumolai',
    'aggrumolammo',
    'aggrumolando',
    'aggrumolano',
    'aggrumolante',
    'aggrumolanti',
    'aggrumolarci',
    'aggrumolare',
    'aggrumolarmi',
    'aggrumolarsi',
    'aggrumolarti',
    'aggrumolarvi',
    'aggrumolasse',
    'aggrumolassi',
    'aggrumolaste',
    'aggrumolasti',
    'aggrumolata',
    'aggrumolate',
    'aggrumolati',
    'aggrumolato',
    'aggrumolava',
    'aggrumolavi',
    'aggrumolavo',
    'aggrumolera',
    'aggrumolerai',
    'aggrumolerei',
    'aggrumolero',
    'aggrumoli',
    'aggrumoliamo',
    'aggrumoliate',
    'aggrumolino',
    'aggrumolo',
    'aggruppa',
    'aggruppai',
    'aggruppammo',
    'aggruppando',
    'aggruppano',
    'aggruppante',
    'aggruppanti',
    'aggrupparci',
    'aggruppare',
    'aggrupparmi',
    'aggrupparono',
    'aggrupparsi',
    'aggrupparti',
    'aggrupparvi',
    'aggruppasse',
    'aggruppassi',
    'aggruppaste',
    'aggruppasti',
    'aggruppata',
    'aggruppate',
    'aggruppatevi',
    'aggruppati',
    'aggruppato',
    'aggruppatomi',
    'aggruppatoti',
    'aggruppava',
    'aggruppavamo',
    'aggruppavano',
    'aggruppavate',
    'aggruppavi',
    'aggruppavo',
    'aggruppera',
    'aggrupperai',
    'aggrupperei',
    'aggrupperemo',
    'aggrupperete',
    'aggruppero',
    'aggruppi',
    'aggruppiamo',
    'aggruppiate',
    'aggruppino',
    'aggruppo',
    'aggruzzola',
    'aggruzzolai',
    'aggruzzolano',
    'aggruzzolare',
    'aggruzzolata',
    'aggruzzolate',
    'aggruzzolati',
    'aggruzzolato',
    'aggruzzolava',
    'aggruzzolavi',
    'aggruzzolavo',
    'aggruzzolera',
    'aggruzzolero',
    'aggruzzoli',
    'aggruzzolino',
    'aggruzzolo',
    'agguagli',
    'agguaglia',
    'agguagliai',
    'agguagliammo',
    'agguagliamo',
    'agguagliando',
    'agguagliano',
    'agguagliante',
    'agguaglianti',
    'agguagliare',
    'agguagliarsi',
    'agguagliasse',
    'agguagliassi',
    'agguagliaste',
    'agguagliasti',
    'agguagliata',
    'agguagliate',
    'agguagliati',
    'agguagliato',
    'agguagliava',
    'agguagliavi',
    'agguagliavo',
    'agguagliera',
    'agguaglierai',
    'agguaglierei',
    'agguagliero',
    'agguaglino',
    'agguaglio',
    'agguanta',
    'agguantai',
    'agguantammo',
    'agguantando',
    'agguantano',
    'agguantante',
    'agguantanti',
    'agguantarci',
    'agguantare',
    'agguantarla',
    'agguantarle',
    'agguantarli',
    'agguantarlo',
    'agguantarmi',
    'agguantarono',
    'agguantarsi',
    'agguantarti',
    'agguantarvi',
    'agguantasse',
    'agguantassi',
    'agguantaste',
    'agguantasti',
    'agguantata',
    'agguantate',
    'agguantatevi',
    'agguantati',
    'agguantato',
    'agguantatomi',
    'agguantatoti',
    'agguantava',
    'agguantavamo',
    'agguantavano',
    'agguantavate',
    'agguantavi',
    'agguantavo',
    'agguantera',
    'agguanterai',
    'agguanterei',
    'agguanteremo',
    'agguanterete',
    'agguantero',
    'agguanti',
    'agguantiamo',
    'agguantiate',
    'agguantino',
    'agguanto',
    'agguata',
    'agguatai',
    'agguatammo',
    'agguatando',
    'agguatandoci',
    'agguatandomi',
    'agguatandosi',
    'agguatandoti',
    'agguatandovi',
    'agguatano',
    'agguatante',
    'agguatanti',
    'agguatantisi',
    'agguatarci',
    'agguatare',
    'agguatarmi',
    'agguatarono',
    'agguatarsi',
    'agguatarti',
    'agguatarvi',
    'agguatasse',
    'agguatassero',
    'agguatassi',
    'agguatassimo',
    'agguataste',
    'agguatasti',
    'agguatata',
    'agguatate',
    'agguatatevi',
    'agguatati',
    'agguatato',
    'agguatatomi',
    'agguatatoti',
    'agguatava',
    'agguatavamo',
    'agguatavano',
    'agguatavate',
    'agguatavi',
    'agguatavo',
    'agguatera',
    'agguaterai',
    'agguateranno',
    'agguaterebbe',
    'agguaterei',
    'agguateremmo',
    'agguateremo',
    'agguatereste',
    'agguateresti',
    'agguaterete',
    'agguatero',
    'agguati',
    'agguatiamo',
    'agguatiamoci',
    'agguatiate',
    'agguatino',
    'agguato',
    'aggueffare',
    'agguerrendo',
    'agguerrente',
    'agguerrenti',
    'agguerri',
    'agguerriamo',
    'agguerriate',
    'agguerrii',
    'agguerrimmo',
    'agguerrira',
    'agguerrirai',
    'agguerrirci',
    'agguerrire',
    'agguerrirei',
    'agguerriremo',
    'agguerrirete',
    'agguerrirmi',
    'agguerriro',
    'agguerrirono',
    'agguerrirsi',
    'agguerrirti',
    'agguerrirvi',
    'agguerrisca',
    'agguerrisce',
    'agguerrisci',
    'agguerrisco',
    'agguerrisse',
    'agguerrissi',
    'agguerriste',
    'agguerristi',
    'agguerrita',
    'agguerrite',
    'agguerritevi',
    'agguerriti',
    'agguerrito',
    'agguerritomi',
    'agguerritoti',
    'agguerriva',
    'agguerrivamo',
    'agguerrivano',
    'agguerrivate',
    'agguerrivi',
    'agguerrivo',
    'agha',
    'aghetti',
    'aghetto',
    'aghi',
    'aghifogli',
    'aghifoglia',
    'aghifoglie',
    'aghifoglio',
    'aghiforme',
    'aghiformi',
    'aghini',
    'aghino',
    'agiamo',
    'agiare',
    'agiata',
    'agiatamente',
    'agiate',
    'agiatezza',
    'agiatezze',
    'agiati',
    'agiato',
    'agibile',
    'agibili',
    'agibilita',
    'agibilità',
    'agide',
    'agiea',
    'agiee',
    'agiei',
    'agieo',
    'agii',
    'agile',
    'agili',
    'agilita',
    'agilità',
    'agilmente',
    'agilulfo',
    'agimmo',
    'agio',
    'agiografa',
    'agiografe',
    'agiografi',
    'agiografia',
    'agiografica',
    'agiografiche',
    'agiografici',
    'agiografico',
    'agiografie',
    'agiografo',
    'agiologa',
    'agiologhe',
    'agiologi',
    'agiologia',
    'agiologica',
    'agiologiche',
    'agiologici',
    'agiologico',
    'agiologie',
    'agiologo',
    'agir',
    'agira',
    'agirai',
    'agiranno',
    'agire',
    'agirebbe',
    'agirebbero',
    'agirei',
    'agiremmo',
    'agiremo',
    'agireste',
    'agiresti',
    'agirete',
    'agiro',
    'agirono',
    'agirà',
    'agisca',
    'agiscano',
    'agisce',
    'agisci',
    'agisco',
    'agiscono',
    'agisse',
    'agissero',
    'agissi',
    'agissimo',
    'agiste',
    'agisti',
    'agit',
    'agita',
    'agitabile',
    'agitabili',
    'agitai',
    'agitamenti',
    'agitamento',
    'agitammo',
    'agitando',
    'agitandoci',
    'agitandola',
    'agitandole',
    'agitandoli',
    'agitandolo',
    'agitandomi',
    'agitandosi',
    'agitandoti',
    'agitandovi',
    'agitano',
    'agitante',
    'agitanti',
    'agitantisi',
    'agitarci',
    'agitare',
    'agitarla',
    'agitarle',
    'agitarli',
    'agitarlo',
    'agitarmi',
    'agitarono',
    'agitarsi',
    'agitarti',
    'agitarvi',
    'agitasse',
    'agitassero',
    'agitassi',
    'agitassimo',
    'agitaste',
    'agitasti',
    'agitata',
    'agitate',
    'agitatevi',
    'agitati',
    'agitatissima',
    'agitatissime',
    'agitatissimi',
    'agitatissimo',
    'agitato',
    'agitatomi',
    'agitatore',
    'agitatori',
    'agitatoria',
    'agitatorie',
    'agitatorio',
    'agitatoti',
    'agitatrice',
    'agitatrici',
    'agitava',
    'agitavamo',
    'agitavano',
    'agitavate',
    'agitavi',
    'agitavo',
    'agitazione',
    'agitazioni',
    'agite',
    'agitera',
    'agiterai',
    'agiteranno',
    'agiterebbe',
    'agiterebbero',
    'agiterei',
    'agiteremmo',
    'agiteremo',
    'agitereste',
    'agiteresti',
    'agiterete',
    'agitero',
    'agiti',
    'agitiamo',
    'agitiamoci',
    'agitiate',
    'agitino',
    'agito',
    'agiva',
    'agivamo',
    'agivano',
    'agivate',
    'agivi',
    'agivo',
    'agkistrodon',
    'aglaia',
    'aglaonema',
    'aglaonemi',
    'agli',
    'aglia',
    'agliacea',
    'agliacee',
    'agliacei',
    'agliaceo',
    'agliai',
    'agliaio',
    'aglianici',
    'aglianico',
    'agliata',
    'agliate',
    'aglietti',
    'aglietto',
    'aglifa',
    'aglife',
    'aglifi',
    'aglifo',
    'aglio',
    'agnati',
    'agnatizi',
    'agnatizia',
    'agnatizie',
    'agnatizio',
    'agnato',
    'agnazione',
    'agnazioni',
    'agnella',
    'agnellai',
    'agnellaia',
    'agnellaie',
    'agnellaio',
    'agnellatura',
    'agnellature',
    'agnelletti',
    'agnelletto',
    'agnelli',
    'agnellina',
    'agnelline',
    'agnellini',
    'agnellino',
    'agnello',
    'agnellone',
    'agnelloni',
    'agnellotti',
    'agnellotto',
    'agnes',
    'agnese',
    'agnesina',
    'agnesio',
    'agni',
    'agnina',
    'agnine',
    'agnini',
    'agnino',
    'agnizione',
    'agnizioni',
    'agno',
    'agnocasti',
    'agnocasto',
    'agnoli',
    'agnolo',
    'agnolotti',
    'agnolotto',
    'agnonese',
    'agnonesi',
    'agnosia',
    'agnosie',
    'agnostica',
    'agnostiche',
    'agnostici',
    'agnosticismi',
    'agnosticismo',
    'agnostico',
    'agnus',
    'agoaspirati',
    'agoaspirato',
    'agobiopsia',
    'agogica',
    'agogiche',
    'agogna',
    'agognai',
    'agognammo',
    'agognando',
    'agognano',
    'agognante',
    'agognanti',
    'agognare',
    'agognarono',
    'agognasse',
    'agognassero',
    'agognassi',
    'agognassimo',
    'agognaste',
    'agognasti',
    'agognata',
    'agognate',
    'agognati',
    'agognato',
    'agognava',
    'agognavamo',
    'agognavano',
    'agognavate',
    'agognavi',
    'agognavo',
    'agognera',
    'agognerai',
    'agogneranno',
    'agognerebbe',
    'agognerei',
    'agogneremmo',
    'agogneremo',
    'agognereste',
    'agogneresti',
    'agognerete',
    'agognero',
    'agogni',
    'agogniamo',
    'agogniate',
    'agognino',
    'agogno',
    'agonale',
    'agonali',
    'agone',
    'agoni',
    'agonia',
    'agonica',
    'agoniche',
    'agonici',
    'agonico',
    'agonie',
    'agonismi',
    'agonismo',
    'agonista',
    'agoniste',
    'agonisti',
    'agonistica',
    'agonistiche',
    'agonistici',
    'agonistico',
    'agonizza',
    'agonizzai',
    'agonizzammo',
    'agonizzando',
    'agonizzano',
    'agonizzante',
    'agonizzanti',
    'agonizzare',
    'agonizzarono',
    'agonizzasse',
    'agonizzassi',
    'agonizzaste',
    'agonizzasti',
    'agonizzata',
    'agonizzate',
    'agonizzati',
    'agonizzato',
    'agonizzava',
    'agonizzavamo',
    'agonizzavano',
    'agonizzavate',
    'agonizzavi',
    'agonizzavo',
    'agonizzera',
    'agonizzerai',
    'agonizzerei',
    'agonizzeremo',
    'agonizzerete',
    'agonizzero',
    'agonizzi',
    'agonizziamo',
    'agonizziate',
    'agonizzino',
    'agonizzo',
    'agopuntore',
    'agopuntori',
    'agopuntrice',
    'agopuntrici',
    'agopuntura',
    'agopunture',
    'agora',
    'agorafoba',
    'agorafobe',
    'agorafobi',
    'agorafobia',
    'agorafobica',
    'agorafobiche',
    'agorafobici',
    'agorafobico',
    'agorafobie',
    'agorafobo',
    'agorai',
    'agoraio',
    'agore',
    'agorà',
    'agosta',
    'agostamenti',
    'agostamento',
    'agostana',
    'agostane',
    'agostani',
    'agostano',
    'agoste',
    'agostenga',
    'agostenghe',
    'agostenghi',
    'agostengo',
    'agosti',
    'agostina',
    'agostine',
    'agostinelli',
    'agostini',
    'agostiniana',
    'agostiniane',
    'agostiniani',
    'agostiniano',
    'agostinismi',
    'agostinismo',
    'agostino',
    'agosto',
    'agra',
    'agrafe',
    'agrafia',
    'agrafie',
    'agramente',
    'agrammatismi',
    'agrammatismo',
    'agrari',
    'agraria',
    'agrarie',
    'agrario',
    'agrarista',
    'agrariste',
    'agraristi',
    'agrave',
    'agre',
    'agreement',
    'agremani',
    'agremano',
    'agresta',
    'agreste',
    'agresti',
    'agrestini',
    'agrestino',
    'agresto',
    'agretta',
    'agrette',
    'agretti',
    'agretto',
    'agrezza',
    'agrezze',
    'agri',
    'agricola',
    'agricole',
    'agricoli',
    'agricolo',
    'agricoltore',
    'agricoltori',
    'agricoltrice',
    'agricoltrici',
    'agricoltura',
    'agricolture',
    'agricultura',
    'agrifogli',
    'agrifoglio',
    'agrigenetica',
    'agrigentina',
    'agrigentine',
    'agrigentini',
    'agrigentino',
    'agrigento',
    'agrigna',
    'agrigne',
    'agrigni',
    'agrigno',
    'agrimani',
    'agrimano',
    'agrimensora',
    'agrimensore',
    'agrimensori',
    'agrimensura',
    'agrimensure',
    'agrimonia',
    'agriotta',
    'agriotte',
    'agriotti',
    'agriotto',
    'agrippina',
    'agrippine',
    'agrippino',
    'agrisio',
    'agriturismi',
    'agriturismo',
    'agriturista',
    'agrituriste',
    'agrituristi',
    'agro',
    'agrobiologa',
    'agrobiologhe',
    'agrobiologi',
    'agrobiologia',
    'agrobiologie',
    'agrobiologo',
    'agrochimica',
    'agrochimiche',
    'agrochimici',
    'agrochimico',
    'agrocotti',
    'agrocotto',
    'agrodolca',
    'agrodolce',
    'agrodolche',
    'agrodolci',
    'agrologia',
    'agrologie',
    'agronica',
    'agroniche',
    'agronici',
    'agronico',
    'agronoma',
    'agronome',
    'agronomi',
    'agronomia',
    'agronomica',
    'agronomiche',
    'agronomici',
    'agronomico',
    'agronomie',
    'agronomo',
    'agrore',
    'agrori',
    'agrosistema',
    'agrosistemi',
    'agrostemma',
    'agrostemmi',
    'agrostide',
    'agrostidi',
    'agrotecnica',
    'agrotecniche',
    'agrotecnici',
    'agrotecnico',
    'agrumari',
    'agrumaria',
    'agrumarie',
    'agrumario',
    'agrume',
    'agrumeti',
    'agrumeto',
    'agrumi',
    'agrumicola',
    'agrumicole',
    'agrumicoli',
    'agrumicolo',
    'aguagliare',
    'aguale',
    'aguaplani',
    'aguaplano',
    'aguardiente',
    'agucchi',
    'agucchia',
    'agucchiai',
    'agucchiammo',
    'agucchiamo',
    'agucchiando',
    'agucchiano',
    'agucchiante',
    'agucchianti',
    'agucchiare',
    'agucchiarono',
    'agucchiasse',
    'agucchiassi',
    'agucchiaste',
    'agucchiasti',
    'agucchiata',
    'agucchiate',
    'agucchiati',
    'agucchiato',
    'agucchiava',
    'agucchiavamo',
    'agucchiavano',
    'agucchiavate',
    'agucchiavi',
    'agucchiavo',
    'agucchie',
    'agucchiera',
    'agucchierai',
    'agucchierei',
    'agucchieremo',
    'agucchierete',
    'agucchiero',
    'agucchino',
    'agucchio',
    'aguglia',
    'agugliara',
    'agugliare',
    'agugliata',
    'agugliate',
    'agugliati',
    'agugliato',
    'aguglie',
    'aguglieria',
    'aguglierie',
    'aguglione',
    'aguglioni',
    'agugliotti',
    'agugliotto',
    'aguinaldo',
    'agunanza',
    'agunare',
    'aguti',
    'aguto',
    'agutoli',
    'aguzza',
    'aguzzai',
    'aguzzamenti',
    'aguzzamento',
    'aguzzammo',
    'aguzzando',
    'aguzzandoci',
    'aguzzandola',
    'aguzzandolo',
    'aguzzandomi',
    'aguzzandosi',
    'aguzzandoti',
    'aguzzandovi',
    'aguzzano',
    'aguzzante',
    'aguzzanti',
    'aguzzantisi',
    'aguzzarci',
    'aguzzare',
    'aguzzarla',
    'aguzzarlo',
    'aguzzarmi',
    'aguzzarono',
    'aguzzarsi',
    'aguzzarti',
    'aguzzarvi',
    'aguzzasse',
    'aguzzassero',
    'aguzzassi',
    'aguzzassimo',
    'aguzzaste',
    'aguzzasti',
    'aguzzata',
    'aguzzate',
    'aguzzatevi',
    'aguzzati',
    'aguzzato',
    'aguzzatomi',
    'aguzzatore',
    'aguzzatori',
    'aguzzatoti',
    'aguzzatrice',
    'aguzzatrici',
    'aguzzatura',
    'aguzzature',
    'aguzzava',
    'aguzzavamo',
    'aguzzavano',
    'aguzzavate',
    'aguzzavi',
    'aguzzavo',
    'aguzze',
    'aguzzera',
    'aguzzerai',
    'aguzzeranno',
    'aguzzerebbe',
    'aguzzerei',
    'aguzzeremmo',
    'aguzzeremo',
    'aguzzereste',
    'aguzzeresti',
    'aguzzerete',
    'aguzzero',
    'aguzzi',
    'aguzziamo',
    'aguzziamoci',
    'aguzziate',
    'aguzzina',
    'aguzzine',
    'aguzzini',
    'aguzzino',
    'aguzzo',
    'ahia',
    'ahime',
    'ahimè',
    'ahimé',
    'ahinoi',
    'ahio',
    'aiace',
    'aiata',
    'aiate',
    'aica',
    'aicardo',
    'aicd',
    'aida',
    'aide',
    'aido',
    'aids',
    'aiducchi',
    'aiducco',
    'aiduchi',
    'aiduco',
    'aierina',
    'aierine',
    'aierini',
    'aierino',
    'aigrette',
    'aigrettes',
    'aiguille',
    'aikido',
    'ailanti',
    'ailanto',
    'ailurofila',
    'ailurofile',
    'ailurofili',
    'ailurofilia',
    'ailurofilo',
    'ailurofoba',
    'ailurofobe',
    'ailurofobi',
    'ailurofobia',
    'ailurofobie',
    'ailurofobo',
    'aime',
    'aimo',
    'aimone',
    'ainhum',
    'aino',
    'ainoi',
    'aiola',
    'aiole',
    'aioli',
    'aiolo',
    'aione',
    'aioni',
    'aira',
    'airaldo',
    'airbus',
    'aire',
    'airedale',
    'aires',
    'airglow',
    'airi',
    'airone',
    'aironi',
    'aita',
    'aitante',
    'aitanti',
    'aitare',
    'aite',
    'aiuola',
    'aiuole',
    'aiuolo',
    'aiurvedica',
    'aiuta',
    'aiutaci',
    'aiutai',
    'aiutami',
    'aiutammo',
    'aiutando',
    'aiutandoci',
    'aiutandola',
    'aiutandole',
    'aiutandoli',
    'aiutandolo',
    'aiutandomi',
    'aiutandosi',
    'aiutandoti',
    'aiutandovi',
    'aiutano',
    'aiutante',
    'aiutanti',
    'aiutantisi',
    'aiutarci',
    'aiutare',
    'aiutarla',
    'aiutarle',
    'aiutarli',
    'aiutarlo',
    'aiutarmi',
    'aiutarono',
    'aiutarsi',
    'aiutarti',
    'aiutarvi',
    'aiutasse',
    'aiutassero',
    'aiutassi',
    'aiutassimo',
    'aiutaste',
    'aiutasti',
    'aiutata',
    'aiutate',
    'aiutateci',
    'aiutatela',
    'aiutatele',
    'aiutateli',
    'aiutatelo',
    'aiutatemelo',
    'aiutatemi',
    'aiutatevi',
    'aiutati',
    'aiutato',
    'aiutatomi',
    'aiutatoti',
    'aiutava',
    'aiutavamo',
    'aiutavano',
    'aiutavate',
    'aiutavi',
    'aiutavo',
    'aiutera',
    'aiuterai',
    'aiuteranno',
    'aiuterebbe',
    'aiuterebbero',
    'aiuterei',
    'aiuteremmo',
    'aiuteremo',
    'aiutereste',
    'aiuteresti',
    'aiuterete',
    'aiutero',
    'aiuti',
    'aiutiamo',
    'aiutiamoci',
    'aiutiate',
    'aiutini',
    'aiutino',
    'aiuto',
    'aiutorio',
    'aiutò',
    'aizoacea',
    'aizoacee',
    'aizza',
    'aizzai',
    'aizzamenti',
    'aizzamento',
    'aizzammo',
    'aizzando',
    'aizzandoci',
    'aizzandola',
    'aizzandole',
    'aizzandoli',
    'aizzandolo',
    'aizzandomi',
    'aizzandosi',
    'aizzandoti',
    'aizzandovi',
    'aizzano',
    'aizzante',
    'aizzanti',
    'aizzantisi',
    'aizzarci',
    'aizzare',
    'aizzarla',
    'aizzarle',
    'aizzarli',
    'aizzarlo',
    'aizzarmi',
    'aizzarono',
    'aizzarsi',
    'aizzarti',
    'aizzarvi',
    'aizzasse',
    'aizzassero',
    'aizzassi',
    'aizzassimo',
    'aizzaste',
    'aizzasti',
    'aizzata',
    'aizzate',
    'aizzatevi',
    'aizzati',
    'aizzato',
    'aizzatomi',
    'aizzatore',
    'aizzatori',
    'aizzatoti',
    'aizzatrice',
    'aizzatrici',
    'aizzava',
    'aizzavamo',
    'aizzavano',
    'aizzavate',
    'aizzavi',
    'aizzavo',
    'aizzera',
    'aizzerai',
    'aizzeranno',
    'aizzerebbe',
    'aizzerebbero',
    'aizzerei',
    'aizzeremmo',
    'aizzeremo',
    'aizzereste',
    'aizzeresti',
    'aizzerete',
    'aizzero',
    'aizzi',
    'aizziamo',
    'aizziamoci',
    'aizziate',
    'aizzino',
    'aizzo',
    'ajaccio',
    'ajour',
    'alabama',
    'alabamio',
    'alabarda',
    'alabardata',
    'alabardate',
    'alabardati',
    'alabardato',
    'alabarde',
    'alabardiere',
    'alabardieri',
    'alabastrai',
    'alabastraia',
    'alabastraie',
    'alabastraio',
    'alabastri',
    'alabastrina',
    'alabastrine',
    'alabastrini',
    'alabastrino',
    'alabastro',
    'alabbassi',
    'alabbasso',
    'alacce',
    'alaccia',
    'alacre',
    'alacremente',
    'alacri',
    'alacrita',
    'alacrità',
    'aladina',
    'aladino',
    'alaggi',
    'alaggio',
    'alaghiera',
    'alaghiero',
    'alagille',
    'alai',
    'alala',
    'alalia',
    'alalonga',
    'alalonghe',
    'alalunga',
    'alalunghe',
    'alamanna',
    'alamanne',
    'alamanni',
    'alamanno',
    'alamari',
    'alamaro',
    'alambardata',
    'alambardate',
    'alambicchi',
    'alambicco',
    'alamiro',
    'alammo',
    'alan',
    'alando',
    'alani',
    'alano',
    'alante',
    'alanti',
    'alare',
    'alari',
    'alarico',
    'alarodica',
    'alarodiche',
    'alarodici',
    'alarodico',
    'alarono',
    'alaska',
    'alasse',
    'alassero',
    'alassi',
    'alassimo',
    'alassina',
    'alassine',
    'alassini',
    'alassino',
    'alassio',
    'alaste',
    'alasti',
    'alastrim',
    'alata',
    'alate',
    'alati',
    'alato',
    'alauda',
    'alaude',
    'alaudide',
    'alaudidi',
    'alava',
    'alavamo',
    'alavano',
    'alavate',
    'alavi',
    'alavo',
    'alba',
    'albacora',
    'albacore',
    'albagi',
    'albagia',
    'albagie',
    'albagio',
    'albagiosa',
    'albagiose',
    'albagiosi',
    'albagioso',
    'albana',
    'albane',
    'albanella',
    'albanelle',
    'albanelli',
    'albanello',
    'albanese',
    'albanesi',
    'albani',
    'albania',
    'albanino',
    'albano',
    'albarelli',
    'albarello',
    'albarosa',
    'albasi',
    'albasia',
    'albasie',
    'albasio',
    'albaspina',
    'albaspine',
    'albastrelli',
    'albastrello',
    'albata',
    'albate',
    'albatra',
    'albatre',
    'albatrelli',
    'albatrello',
    'albatri',
    'albatro',
    'albatros',
    'albe',
    'albedine',
    'albedini',
    'albedo',
    'albeggera',
    'albeggerai',
    'albeggeranno',
    'albeggerebbe',
    'albeggerei',
    'albeggeremmo',
    'albeggeremo',
    'albeggereste',
    'albeggeresti',
    'albeggerete',
    'albeggero',
    'albeggi',
    'albeggia',
    'albeggiai',
    'albeggiammo',
    'albeggiamo',
    'albeggiando',
    'albeggiano',
    'albeggiante',
    'albeggianti',
    'albeggiare',
    'albeggiarono',
    'albeggiasse',
    'albeggiassi',
    'albeggiaste',
    'albeggiasti',
    'albeggiata',
    'albeggiate',
    'albeggiati',
    'albeggiato',
    'albeggiava',
    'albeggiavamo',
    'albeggiavano',
    'albeggiavate',
    'albeggiavi',
    'albeggiavo',
    'albeggino',
    'albeggio',
    'albenga',
    'albenganese',
    'albenganesi',
    'albenghina',
    'albenghine',
    'albenghini',
    'albenghino',
    'albera',
    'alberaggi',
    'alberaggio',
    'alberai',
    'alberammo',
    'alberando',
    'alberano',
    'alberante',
    'alberanti',
    'alberare',
    'alberarono',
    'alberasse',
    'alberassero',
    'alberassi',
    'alberassimo',
    'alberaste',
    'alberasti',
    'alberata',
    'alberate',
    'alberati',
    'alberato',
    'alberatura',
    'alberature',
    'alberava',
    'alberavamo',
    'alberavano',
    'alberavate',
    'alberavi',
    'alberavo',
    'albere',
    'alberella',
    'alberelle',
    'alberelli',
    'alberello',
    'alberera',
    'albererai',
    'albereranno',
    'albererebbe',
    'albererei',
    'albereremmo',
    'albereremo',
    'alberereste',
    'albereresti',
    'albererete',
    'alberero',
    'alberese',
    'alberesi',
    'albereta',
    'alberete',
    'albereti',
    'albereto',
    'alberetti',
    'alberetto',
    'alberga',
    'albergacci',
    'albergaccio',
    'albergai',
    'albergammo',
    'albergando',
    'albergano',
    'albergante',
    'alberganti',
    'albergare',
    'albergaria',
    'albergarono',
    'albergasse',
    'albergassero',
    'albergassi',
    'albergassimo',
    'albergaste',
    'albergasti',
    'albergata',
    'albergate',
    'albergati',
    'albergato',
    'albergatore',
    'albergatori',
    'albergatrice',
    'albergatrici',
    'albergava',
    'albergavamo',
    'albergavano',
    'albergavate',
    'albergavi',
    'albergavo',
    'alberghera',
    'albergherai',
    'albergherei',
    'albergheremo',
    'albergherete',
    'albergheria',
    'albergherie',
    'alberghero',
    'alberghetti',
    'alberghetto',
    'alberghi',
    'alberghiamo',
    'alberghiate',
    'alberghiera',
    'alberghiere',
    'alberghieri',
    'alberghiero',
    'alberghino',
    'albergo',
    'albergucci',
    'alberguccio',
    'alberi',
    'alberiamo',
    'alberiate',
    'alberica',
    'alberice',
    'alberico',
    'alberigo',
    'alberini',
    'alberino',
    'albero',
    'alberobello',
    'alberone',
    'alberoni',
    'alberta',
    'alberti',
    'albertina',
    'albertine',
    'albertini',
    'albertino',
    'alberto',
    'albese',
    'albesi',
    'albespine',
    'albi',
    'albica',
    'albicai',
    'albicammo',
    'albicando',
    'albicano',
    'albicans',
    'albicante',
    'albicanti',
    'albicare',
    'albicarono',
    'albicasse',
    'albicassero',
    'albicassi',
    'albicassimo',
    'albicaste',
    'albicasti',
    'albicata',
    'albicate',
    'albicati',
    'albicato',
    'albicatura',
    'albicature',
    'albicava',
    'albicavamo',
    'albicavano',
    'albicavate',
    'albicavi',
    'albicavo',
    'albichera',
    'albicherai',
    'albicheranno',
    'albicherebbe',
    'albicherei',
    'albicheremmo',
    'albicheremo',
    'albichereste',
    'albicheresti',
    'albicherete',
    'albichero',
    'albichi',
    'albichiamo',
    'albichiate',
    'albichino',
    'albico',
    'albicocca',
    'albicocche',
    'albicoccheti',
    'albicoccheto',
    'albicocchi',
    'albicocco',
    'albigatti',
    'albigeismo',
    'albigese',
    'albigesi',
    'albina',
    'albinaggi',
    'albinaggio',
    'albine',
    'albini',
    'albinismi',
    'albinismo',
    'albino',
    'albio',
    'albioli',
    'albiolo',
    'albione',
    'albionica',
    'albioniche',
    'albionici',
    'albionico',
    'albionte',
    'albite',
    'albiti',
    'albitrio',
    'albitro',
    'albizio',
    'albizzia',
    'albizzie',
    'albizzo',
    'albo',
    'albogatto',
    'alboina',
    'alboino',
    'albore',
    'alborella',
    'alborelle',
    'albori',
    'albugine',
    'albuginea',
    'albuginee',
    'albugini',
    'album',
    'albume',
    'albumi',
    'albumina',
    'albumine',
    'albuminemia',
    'albuminemie',
    'albuminoide',
    'albuminoidi',
    'albuminosa',
    'albuminose',
    'albuminosi',
    'albuminoso',
    'albuminuria',
    'albuminurie',
    'alburni',
    'alburno',
    'alca',
    'alcachengi',
    'alcade',
    'alcadi',
    'alcaica',
    'alcaiche',
    'alcaici',
    'alcaico',
    'alcalde',
    'alcaldi',
    'alcalescente',
    'alcalescenti',
    'alcalescenza',
    'alcalescenze',
    'alcali',
    'alcaligenes',
    'alcalimetri',
    'alcalimetria',
    'alcalimetrie',
    'alcalimetro',
    'alcalina',
    'alcaline',
    'alcalini',
    'alcalinita',
    'alcalinità',
    'alcalinizza',
    'alcalinizzai',
    'alcalinizzi',
    'alcalinizzo',
    'alcalino',
    'alcaloide',
    'alcaloidi',
    'alcalosi',
    'alcamese',
    'alcamesi',
    'alcamo',
    'alcani',
    'alcanna',
    'alcanne',
    'alcano',
    'alcaptone',
    'alcaptonuria',
    'alcazar',
    'alcazares',
    'alce',
    'alcea',
    'alcedine',
    'alcedini',
    'alcedinide',
    'alcedinidi',
    'alcelafi',
    'alcelafo',
    'alceo',
    'alcesta',
    'alceste',
    'alcestina',
    'alcesto',
    'alche',
    'alchechengi',
    'alchemica',
    'alchemiche',
    'alchemici',
    'alchemico',
    'alchemilla',
    'alchemille',
    'alchene',
    'alcheni',
    'alchermes',
    'alchilazione',
    'alchilazioni',
    'alchile',
    'alchili',
    'alchilica',
    'alchiliche',
    'alchilici',
    'alchilico',
    'alchimia',
    'alchimiando',
    'alchimiare',
    'alchimiata',
    'alchimiate',
    'alchimiati',
    'alchimiato',
    'alchimica',
    'alchimiche',
    'alchimici',
    'alchimico',
    'alchimie',
    'alchimilla',
    'alchimille',
    'alchimista',
    'alchimiste',
    'alchimisti',
    'alchimistica',
    'alchimistici',
    'alchimistico',
    'alchimizza',
    'alchimizzai',
    'alchimizzano',
    'alchimizzare',
    'alchimizzata',
    'alchimizzate',
    'alchimizzati',
    'alchimizzato',
    'alchimizzava',
    'alchimizzavi',
    'alchimizzavo',
    'alchimizzera',
    'alchimizzero',
    'alchimizzi',
    'alchimizzino',
    'alchimizzo',
    'alci',
    'alcibiade',
    'alcida',
    'alcide',
    'alcidi',
    'alcidio',
    'alcido',
    'alciforme',
    'alciformi',
    'alcina',
    'alcino',
    'alcionacei',
    'alcionaceo',
    'alcionari',
    'alcionario',
    'alcione',
    'alcioni',
    'alcionia',
    'alcionie',
    'alcionii',
    'alcionio',
    'alcisa',
    'alciso',
    'alcmani',
    'alcmania',
    'alcmanie',
    'alcmanio',
    'alcmena',
    'alcol',
    'alcolati',
    'alcolato',
    'alcole',
    'alcolemia',
    'alcolemie',
    'alcoli',
    'alcolica',
    'alcoliche',
    'alcolici',
    'alcolicita',
    'alcolicità',
    'alcolico',
    'alcolimetri',
    'alcolimetria',
    'alcolimetrie',
    'alcolimetro',
    'alcolismi',
    'alcolismo',
    'alcolista',
    'alcoliste',
    'alcolisti',
    'alcolizza',
    'alcolizzai',
    'alcolizzammo',
    'alcolizzando',
    'alcolizzano',
    'alcolizzante',
    'alcolizzanti',
    'alcolizzarci',
    'alcolizzare',
    'alcolizzarmi',
    'alcolizzarsi',
    'alcolizzarti',
    'alcolizzarvi',
    'alcolizzasse',
    'alcolizzassi',
    'alcolizzaste',
    'alcolizzasti',
    'alcolizzata',
    'alcolizzate',
    'alcolizzati',
    'alcolizzato',
    'alcolizzava',
    'alcolizzavi',
    'alcolizzavo',
    'alcolizzera',
    'alcolizzerai',
    'alcolizzerei',
    'alcolizzero',
    'alcolizzi',
    'alcolizziamo',
    'alcolizziate',
    'alcolizzino',
    'alcolizzo',
    'alcologia',
    'alcologie',
    'alcolometri',
    'alcolometria',
    'alcolometro',
    'alcoltest',
    'alcool',
    'alcoolato',
    'alcoole',
    'alcoolica',
    'alcooliche',
    'alcoolici',
    'alcoolicita',
    'alcoolico',
    'alcoolimetri',
    'alcoolimetro',
    'alcoolismi',
    'alcoolismo',
    'alcoolista',
    'alcooliste',
    'alcoolisti',
    'alcoolizzare',
    'alcoolizzata',
    'alcoolizzate',
    'alcoolizzati',
    'alcoolizzato',
    'alcoologia',
    'alcooltest',
    'alcorano',
    'alcova',
    'alcove',
    'alcun',
    'alcuna',
    'alcunche',
    'alcunché',
    'alcune',
    'alcuni',
    'alcuno',
    'alda',
    'aldeandra',
    'aldebrando',
    'aldegarda',
    'aldegardo',
    'aldegonda',
    'aldegondo',
    'aldeide',
    'aldeidi',
    'aldeidica',
    'aldeidiche',
    'aldeidici',
    'aldeidico',
    'aldemara',
    'aldemaro',
    'aldemia',
    'aldemina',
    'aldemio',
    'aldemira',
    'aldemiro',
    'aldemo',
    'alderano',
    'alderica',
    'alderice',
    'alderico',
    'alderigi',
    'alderigo',
    'alderina',
    'alderino',
    'alderio',
    'aldero',
    'aldesina',
    'aldesino',
    'aldesira',
    'aldezza',
    'aldi',
    'aldighiero',
    'aldila',
    'aldilà',
    'aldimaro',
    'aldimiro',
    'aldina',
    'aldine',
    'aldini',
    'aldino',
    'aldio',
    'aldione',
    'aldioni',
    'aldisio',
    'aldiviero',
    'aldo',
    'aldobranda',
    'aldobrandino',
    'aldobrando',
    'aldoesosi',
    'aldoesosio',
    'aldoesoso',
    'aldoino',
    'aldomiro',
    'aldorino',
    'aldosterone',
    'aldosteroni',
    'aldovina',
    'aldovino',
    'aldrich',
    'alduccio',
    'alduina',
    'alduino',
    'alea',
    'alealdo',
    'aleandra',
    'aleandro',
    'alearco',
    'alearda',
    'aleardo',
    'aleatici',
    'aleatico',
    'aleatore',
    'aleatori',
    'aleatoria',
    'aleatorie',
    'aleatorieta',
    'aleatorietà',
    'aleatorii',
    'aleatorio',
    'alee',
    'alef',
    'aleggera',
    'aleggerai',
    'aleggeranno',
    'aleggerebbe',
    'aleggerei',
    'aleggeremmo',
    'aleggeremo',
    'aleggereste',
    'aleggeresti',
    'aleggerete',
    'aleggero',
    'aleggi',
    'aleggia',
    'aleggiai',
    'aleggiammo',
    'aleggiamo',
    'aleggiando',
    'aleggiano',
    'aleggiante',
    'aleggianti',
    'aleggiare',
    'aleggiarmi',
    'aleggiarono',
    'aleggiasse',
    'aleggiassero',
    'aleggiassi',
    'aleggiassimo',
    'aleggiaste',
    'aleggiasti',
    'aleggiata',
    'aleggiate',
    'aleggiati',
    'aleggiato',
    'aleggiava',
    'aleggiavamo',
    'aleggiavano',
    'aleggiavate',
    'aleggiavi',
    'aleggiavo',
    'aleggino',
    'aleggio',
    'alema',
    'alemanna',
    'alemanne',
    'alemanni',
    'alemanno',
    'alemaro',
    'alena',
    'alenare',
    'aleppina',
    'aleppine',
    'aleppini',
    'aleppino',
    'aleppo',
    'alera',
    'alerai',
    'aleramo',
    'aleranno',
    'alerano',
    'alerebbe',
    'alerebbero',
    'alerei',
    'aleremmo',
    'aleremo',
    'alereste',
    'aleresti',
    'alerete',
    'alerino',
    'alerione',
    'alerioni',
    'alero',
    'alerone',
    'aleroni',
    'ales',
    'alesa',
    'alesaggi',
    'alesaggio',
    'alesai',
    'alesammo',
    'alesando',
    'alesano',
    'alesante',
    'alesanti',
    'alesare',
    'alesarono',
    'alesasse',
    'alesassero',
    'alesassi',
    'alesassimo',
    'alesaste',
    'alesasti',
    'alesata',
    'alesate',
    'alesati',
    'alesato',
    'alesatoi',
    'alesatoio',
    'alesatore',
    'alesatori',
    'alesatrice',
    'alesatrici',
    'alesatura',
    'alesature',
    'alesava',
    'alesavamo',
    'alesavano',
    'alesavate',
    'alesavi',
    'alesavo',
    'alesera',
    'aleserai',
    'aleseranno',
    'aleserebbe',
    'aleserebbero',
    'aleserei',
    'aleseremmo',
    'aleseremo',
    'alesereste',
    'aleseresti',
    'aleserete',
    'alesero',
    'alesi',
    'alesia',
    'alesiamo',
    'alesiate',
    'alesino',
    'alesio',
    'aleso',
    'alessandra',
    'alessandria',
    'alessandrina',
    'alessandrine',
    'alessandrini',
    'alessandrino',
    'alessandro',
    'alessi',
    'alessia',
    'alessie',
    'alessina',
    'alessio',
    'aletoscopio',
    'aletta',
    'alettai',
    'alettammo',
    'alettando',
    'alettano',
    'alettante',
    'alettanti',
    'alettare',
    'alettarono',
    'alettasse',
    'alettassero',
    'alettassi',
    'alettassimo',
    'alettaste',
    'alettasti',
    'alettata',
    'alettate',
    'alettati',
    'alettato',
    'alettatura',
    'alettature',
    'alettava',
    'alettavamo',
    'alettavano',
    'alettavate',
    'alettavi',
    'alettavo',
    'alette',
    'alettera',
    'aletterai',
    'aletteranno',
    'aletterebbe',
    'aletterei',
    'aletteremmo',
    'aletteremo',
    'alettereste',
    'aletteresti',
    'aletterete',
    'alettero',
    'aletti',
    'alettiamo',
    'alettiate',
    'alettina',
    'alettine',
    'alettino',
    'aletto',
    'alettone',
    'alettoni',
    'aleurometri',
    'aleurometro',
    'aleurone',
    'aleuroni',
    'aleutina',
    'aleutino',
    'alfa',
    'alfabeta',
    'alfabetando',
    'alfabetano',
    'alfabetare',
    'alfabetari',
    'alfabetario',
    'alfabetarono',
    'alfabetasse',
    'alfabetata',
    'alfabetate',
    'alfabetati',
    'alfabetato',
    'alfabetava',
    'alfabetavano',
    'alfabete',
    'alfabeti',
    'alfabetica',
    'alfabetiche',
    'alfabetici',
    'alfabetico',
    'alfabetiere',
    'alfabetieri',
    'alfabetino',
    'alfabetismi',
    'alfabetismo',
    'alfabetizza',
    'alfabetizzai',
    'alfabetizzi',
    'alfabetizzo',
    'alfabeto',
    'alfalfa',
    'alfamovirus',
    'alfana',
    'alfane',
    'alfano',
    'alfanumerica',
    'alfanumerici',
    'alfanumerico',
    'alfe',
    'alfea',
    'alfeo',
    'alferia',
    'alferino',
    'alferio',
    'alfero',
    'alfetta',
    'alfette',
    'alfia',
    'alfiera',
    'alfiere',
    'alfieresca',
    'alfieresche',
    'alfiereschi',
    'alfieresco',
    'alfieri',
    'alfieriana',
    'alfieriane',
    'alfieriani',
    'alfieriano',
    'alfierina',
    'alfierino',
    'alfiero',
    'alfina',
    'alfine',
    'alfino',
    'alfio',
    'alfista',
    'alfiste',
    'alfisti',
    'alfo',
    'alfonsa',
    'alfonsina',
    'alfonsino',
    'alfonso',
    'alfonza',
    'alfonzina',
    'alfonzo',
    'alfreda',
    'alfredina',
    'alfredino',
    'alfredo',
    'alfrida',
    'alfride',
    'alga',
    'algale',
    'algali',
    'algarese',
    'algaresi',
    'algarrobi',
    'algarrobo',
    'algebra',
    'algebre',
    'algebrica',
    'algebriche',
    'algebrici',
    'algebricita',
    'algebrico',
    'algebrista',
    'algebriste',
    'algebristi',
    'algemiro',
    'algente',
    'algenti',
    'algeo',
    'algere',
    'algeri',
    'algeria',
    'algerina',
    'algerine',
    'algerini',
    'algerino',
    'algero',
    'algesia',
    'algesie',
    'algesimetri',
    'algesimetria',
    'algesimetrie',
    'algesimetro',
    'alghe',
    'algherese',
    'algheresi',
    'alghero',
    'alghicida',
    'alghicide',
    'alghicidi',
    'alghisio',
    'algia',
    'algida',
    'algide',
    'algidi',
    'algido',
    'algie',
    'algimiro',
    'algina',
    'alginata',
    'alginate',
    'alginati',
    'alginato',
    'algine',
    'alginica',
    'alginiche',
    'alginici',
    'alginico',
    'algisa',
    'algisio',
    'algiso',
    'algo',
    'algocoltura',
    'algocolture',
    'algocultura',
    'algoculture',
    'algofilia',
    'algofilie',
    'algofobia',
    'algofobie',
    'algogena',
    'algogene',
    'algogeni',
    'algogeno',
    'algol',
    'algolagnia',
    'algolagnie',
    'algologa',
    'algologhe',
    'algologi',
    'algologia',
    'algologie',
    'algologo',
    'algometria',
    'algometrie',
    'algonchiana',
    'algonchiane',
    'algonchiani',
    'algonchiano',
    'algonchica',
    'algonchiche',
    'algonchici',
    'algonchico',
    'algonchina',
    'algonchine',
    'algonchini',
    'algonchino',
    'algore',
    'algori',
    'algorismo',
    'algoritmi',
    'algoritmica',
    'algoritmiche',
    'algoritmici',
    'algoritmico',
    'algoritmista',
    'algoritmiste',
    'algoritmisti',
    'algoritmo',
    'algosa',
    'algose',
    'algosi',
    'algoso',
    'alia',
    'aliai',
    'aliammo',
    'aliamo',
    'aliando',
    'aliano',
    'aliante',
    'alianti',
    'aliantista',
    'aliantiste',
    'aliantisti',
    'aliare',
    'aliarono',
    'alias',
    'aliasse',
    'aliassero',
    'aliassi',
    'aliassimo',
    'aliaste',
    'aliasti',
    'aliata',
    'aliate',
    'aliati',
    'aliato',
    'aliava',
    'aliavamo',
    'aliavano',
    'aliavate',
    'aliavi',
    'aliavo',
    'aliberto',
    'alibi',
    'alibrando',
    'alicante',
    'alicanti',
    'alice',
    'alicetta',
    'alicette',
    'alici',
    'alicia',
    'aliciclica',
    'alicicliche',
    'aliciclici',
    'aliciclico',
    'alicio',
    'alicorni',
    'alicorno',
    'alida',
    'alidada',
    'alidade',
    'alide',
    'alidea',
    'alideo',
    'alidi',
    'alido',
    'alidora',
    'alidore',
    'alidori',
    'alidoro',
    'alidosi',
    'alidosiana',
    'alidosiane',
    'alidosiani',
    'alidosiano',
    'aliena',
    'alienabile',
    'alienabili',
    'alienabilita',
    'alienabilità',
    'alienai',
    'alienamenti',
    'alienamento',
    'alienammo',
    'alienando',
    'alienandoci',
    'alienandomi',
    'alienandosi',
    'alienandoti',
    'alienandovi',
    'alienano',
    'alienante',
    'alienanti',
    'alienantisi',
    'alienarci',
    'alienare',
    'alienarmi',
    'alienarono',
    'alienarsi',
    'alienarti',
    'alienarvi',
    'alienasse',
    'alienassero',
    'alienassi',
    'alienassimo',
    'alienaste',
    'alienasti',
    'alienata',
    'alienate',
    'alienatevi',
    'alienati',
    'alienato',
    'alienatomi',
    'alienatore',
    'alienatori',
    'alienatoti',
    'alienatrice',
    'alienatrici',
    'alienava',
    'alienavamo',
    'alienavano',
    'alienavate',
    'alienavi',
    'alienavo',
    'alienazione',
    'alienazioni',
    'aliene',
    'alienera',
    'alienerai',
    'alieneranno',
    'alienerebbe',
    'alienerei',
    'alieneremmo',
    'alieneremo',
    'alienereste',
    'alieneresti',
    'alienerete',
    'alienero',
    'alieni',
    'alienia',
    'alieniamo',
    'alieniamoci',
    'alieniate',
    'alienie',
    'alienino',
    'alienista',
    'alieniste',
    'alienisti',
    'alienita',
    'alienità',
    'alieno',
    'aliera',
    'alierai',
    'alieranno',
    'alierebbe',
    'alierebbero',
    'alierei',
    'alieremmo',
    'alieremo',
    'aliereste',
    'alieresti',
    'alierete',
    'aliero',
    'alieutica',
    'alieutiche',
    'alifatica',
    'alifatiche',
    'alifatici',
    'alifatico',
    'aliforme',
    'aliformi',
    'aliga',
    'aligera',
    'aligere',
    'aligeri',
    'aligero',
    'alighiera',
    'alighieri',
    'alighiero',
    'aligi',
    'aligio',
    'aligusta',
    'alimenta',
    'alimentai',
    'alimentammo',
    'alimentando',
    'alimentano',
    'alimentante',
    'alimentanti',
    'alimentarci',
    'alimentare',
    'alimentari',
    'alimentaria',
    'alimentarie',
    'alimentario',
    'alimentarmi',
    'alimentarono',
    'alimentarsi',
    'alimentarti',
    'alimentarvi',
    'alimentasse',
    'alimentassi',
    'alimentaste',
    'alimentasti',
    'alimentata',
    'alimentate',
    'alimentatevi',
    'alimentati',
    'alimentato',
    'alimentatomi',
    'alimentatore',
    'alimentatori',
    'alimentatoti',
    'alimentava',
    'alimentavamo',
    'alimentavano',
    'alimentavate',
    'alimentavi',
    'alimentavo',
    'alimentaz',
    'alimentera',
    'alimenterai',
    'alimenterei',
    'alimenteremo',
    'alimenterete',
    'alimentero',
    'alimenterò',
    'alimenti',
    'alimentiamo',
    'alimentiate',
    'alimentino',
    'alimento',
    'alimi',
    'alimo',
    'alimonia',
    'alimonie',
    'alina',
    'alinda',
    'alindo',
    'alinea',
    'alino',
    'alio',
    'aliossi',
    'aliosso',
    'aliotide',
    'aliotidi',
    'alipede',
    'alipedi',
    'alipia',
    'alipio',
    'aliprando',
    'aliquota',
    'aliquote',
    'alisa',
    'aliscafi',
    'aliscafista',
    'aliscafiste',
    'aliscafisti',
    'aliscafo',
    'alisei',
    'aliseo',
    'alisia',
    'alisio',
    'alisma',
    'alismatacea',
    'alismatacee',
    'alisme',
    'aliso',
    'alissi',
    'alisso',
    'alita',
    'alitai',
    'alitammo',
    'alitando',
    'alitano',
    'alitante',
    'alitanti',
    'alitare',
    'alitarono',
    'alitasse',
    'alitassero',
    'alitassi',
    'alitassimo',
    'alitaste',
    'alitasti',
    'alitata',
    'alitate',
    'alitati',
    'alitato',
    'alitava',
    'alitavamo',
    'alitavano',
    'alitavate',
    'alitavi',
    'alitavo',
    'alite',
    'alitera',
    'aliterai',
    'aliteranno',
    'aliterebbe',
    'aliterebbero',
    'aliterei',
    'aliteremmo',
    'aliteremo',
    'alitereste',
    'aliteresti',
    'aliterete',
    'alitero',
    'aliti',
    'alitiamo',
    'alitiate',
    'alitino',
    'alito',
    'alitosi',
    'aliturgica',
    'aliturgiche',
    'aliturgici',
    'aliturgico',
    'aliviero',
    'alivola',
    'alivole',
    'alivoli',
    'alivolo',
    'alizarina',
    'alizarine',
    'alla',
    'allaccera',
    'allaccerai',
    'allacceranno',
    'allaccerebbe',
    'allaccerei',
    'allacceremmo',
    'allacceremo',
    'allaccereste',
    'allacceresti',
    'allaccerete',
    'allaccero',
    'allacci',
    'allaccia',
    'allacciabile',
    'allacciabili',
    'allacciai',
    'allacciammo',
    'allacciamo',
    'allacciamoci',
    'allacciando',
    'allacciano',
    'allacciante',
    'allaccianti',
    'allacciarci',
    'allacciare',
    'allacciarmi',
    'allacciarono',
    'allacciarsi',
    'allacciarti',
    'allacciarvi',
    'allacciasse',
    'allacciassi',
    'allacciaste',
    'allacciasti',
    'allacciata',
    'allacciate',
    'allacciatevi',
    'allacciati',
    'allacciato',
    'allacciatomi',
    'allacciatoti',
    'allacciatura',
    'allacciature',
    'allacciava',
    'allacciavamo',
    'allacciavano',
    'allacciavate',
    'allacciavi',
    'allacciavo',
    'allaccino',
    'allaccio',
    'allaga',
    'allagai',
    'allagamenti',
    'allagamento',
    'allagammo',
    'allagando',
    'allagandoci',
    'allagandomi',
    'allagandosi',
    'allagandoti',
    'allagandovi',
    'allagano',
    'allagante',
    'allaganti',
    'allagantisi',
    'allagarci',
    'allagare',
    'allagarmi',
    'allagarono',
    'allagarsi',
    'allagarti',
    'allagarvi',
    'allagasse',
    'allagassero',
    'allagassi',
    'allagassimo',
    'allagaste',
    'allagasti',
    'allagata',
    'allagate',
    'allagatevi',
    'allagati',
    'allagato',
    'allagatomi',
    'allagatoti',
    'allagava',
    'allagavamo',
    'allagavano',
    'allagavate',
    'allagavi',
    'allagavo',
    'allaghera',
    'allagherai',
    'allagheranno',
    'allagherebbe',
    'allagherei',
    'allagheremmo',
    'allagheremo',
    'allaghereste',
    'allagheresti',
    'allagherete',
    'allaghero',
    'allaghi',
    'allaghiamo',
    'allaghiamoci',
    'allaghiate',
    'allaghino',
    'allago',
    'allah',
    'allahabad',
    'allali',
    'allalou',
    'allampana',
    'allampanai',
    'allampanammo',
    'allampanando',
    'allampanano',
    'allampanante',
    'allampananti',
    'allampanare',
    'allampanasse',
    'allampanassi',
    'allampanaste',
    'allampanasti',
    'allampanata',
    'allampanate',
    'allampanati',
    'allampanato',
    'allampanava',
    'allampanavi',
    'allampanavo',
    'allampanera',
    'allampanerai',
    'allampanerei',
    'allampanero',
    'allampani',
    'allampaniamo',
    'allampaniate',
    'allampanino',
    'allampano',
    'allantiasi',
    'allantoide',
    'allantoidea',
    'allantoidee',
    'allantoidei',
    'allantoideo',
    'allantoidi',
    'allappa',
    'allappai',
    'allappammo',
    'allappando',
    'allappano',
    'allappante',
    'allappanti',
    'allappare',
    'allapparono',
    'allappasse',
    'allappassero',
    'allappassi',
    'allappassimo',
    'allappaste',
    'allappasti',
    'allappata',
    'allappate',
    'allappati',
    'allappato',
    'allappava',
    'allappavamo',
    'allappavano',
    'allappavate',
    'allappavi',
    'allappavo',
    'allappera',
    'allapperai',
    'allapperanno',
    'allapperebbe',
    'allapperei',
    'allapperemmo',
    'allapperemo',
    'allappereste',
    'allapperesti',
    'allapperete',
    'allappero',
    'allappi',
    'allappiamo',
    'allappiate',
    'allappino',
    'allappo',
    'allarga',
    'allargabile',
    'allargai',
    'allargamenti',
    'allargamento',
    'allargammo',
    'allargando',
    'allargandoci',
    'allargandola',
    'allargandole',
    'allargandoli',
    'allargandolo',
    'allargandomi',
    'allargandosi',
    'allargandoti',
    'allargandovi',
    'allargano',
    'allargante',
    'allarganti',
    'allargantisi',
    'allargarci',
    'allargare',
    'allargarla',
    'allargarle',
    'allargarli',
    'allargarlo',
    'allargarmi',
    'allargarono',
    'allargarsi',
    'allargarti',
    'allargarvi',
    'allargasse',
    'allargassero',
    'allargassi',
    'allargassimo',
    'allargaste',
    'allargasti',
    'allargata',
    'allargate',
    'allargatese',
    'allargatevi',
    'allargati',
    'allargato',
    'allargatoi',
    'allargatoio',
    'allargatomi',
    'allargatore',
    'allargatori',
    'allargatoti',
    'allargatrice',
    'allargatrici',
    'allargatubi',
    'allargatura',
    'allargature',
    'allargava',
    'allargavamo',
    'allargavano',
    'allargavate',
    'allargavi',
    'allargavo',
    'allarghera',
    'allargherai',
    'allargherei',
    'allargheremo',
    'allargherete',
    'allarghero',
    'allarghi',
    'allarghiamo',
    'allarghiate',
    'allarghino',
    'allargo',
    'allarma',
    'allarmai',
    'allarmammo',
    'allarmando',
    'allarmandoci',
    'allarmandola',
    'allarmandole',
    'allarmandoli',
    'allarmandolo',
    'allarmandomi',
    'allarmandosi',
    'allarmandoti',
    'allarmandovi',
    'allarmano',
    'allarmante',
    'allarmanti',
    'allarmantisi',
    'allarmarci',
    'allarmare',
    'allarmarla',
    'allarmarle',
    'allarmarli',
    'allarmarlo',
    'allarmarmi',
    'allarmarono',
    'allarmarsi',
    'allarmarti',
    'allarmarvi',
    'allarmasse',
    'allarmassero',
    'allarmassi',
    'allarmassimo',
    'allarmaste',
    'allarmasti',
    'allarmata',
    'allarmate',
    'allarmatevi',
    'allarmati',
    'allarmato',
    'allarmatomi',
    'allarmatoti',
    'allarmava',
    'allarmavamo',
    'allarmavano',
    'allarmavate',
    'allarmavi',
    'allarmavo',
    'allarme',
    'allarmera',
    'allarmerai',
    'allarmeranno',
    'allarmerebbe',
    'allarmerei',
    'allarmeremmo',
    'allarmeremo',
    'allarmereste',
    'allarmeresti',
    'allarmerete',
    'allarmero',
    'allarmi',
    'allarmiamo',
    'allarmiamoci',
    'allarmiate',
    'allarmino',
    'allarmismi',
    'allarmismo',
    'allarmista',
    'allarmiste',
    'allarmisti',
    'allarmistica',
    'allarmistici',
    'allarmistico',
    'allarmo',
    'allarmò',
    'allasca',
    'allascai',
    'allascammo',
    'allascando',
    'allascano',
    'allascante',
    'allascanti',
    'allascare',
    'allascarono',
    'allascasse',
    'allascassero',
    'allascassi',
    'allascassimo',
    'allascaste',
    'allascasti',
    'allascata',
    'allascate',
    'allascati',
    'allascato',
    'allascava',
    'allascavamo',
    'allascavano',
    'allascavate',
    'allascavi',
    'allascavo',
    'allaschera',
    'allascherai',
    'allascherei',
    'allascheremo',
    'allascherete',
    'allaschero',
    'allaschi',
    'allaschiamo',
    'allaschiate',
    'allaschino',
    'allasco',
    'allata',
    'allativa',
    'allative',
    'allativi',
    'allativo',
    'allato',
    'allatta',
    'allattai',
    'allattamenti',
    'allattamento',
    'allattammo',
    'allattando',
    'allattano',
    'allattante',
    'allattanti',
    'allattare',
    'allattarmi',
    'allattarne',
    'allattarono',
    'allattasse',
    'allattassero',
    'allattassi',
    'allattassimo',
    'allattaste',
    'allattasti',
    'allattata',
    'allattate',
    'allattati',
    'allattato',
    'allattatrice',
    'allattatrici',
    'allattatura',
    'allattature',
    'allattava',
    'allattavamo',
    'allattavano',
    'allattavate',
    'allattavi',
    'allattavo',
    'allattera',
    'allatterai',
    'allatteranno',
    'allatterebbe',
    'allatterei',
    'allatteremmo',
    'allatteremo',
    'allattereste',
    'allatteresti',
    'allatterete',
    'allattero',
    'allatti',
    'allattiamo',
    'allattiate',
    'allattino',
    'allatto',
    'alle',
    'allea',
    'alleai',
    'alleammo',
    'alleando',
    'alleandoci',
    'alleandomi',
    'alleandosi',
    'alleandoti',
    'alleandovi',
    'alleano',
    'alleante',
    'alleanti',
    'alleantisi',
    'alleanza',
    'alleanze',
    'allearci',
    'alleare',
    'allearmi',
    'allearono',
    'allearsi',
    'allearti',
    'allearvi',
    'alleasse',
    'alleassero',
    'alleassi',
    'alleassimo',
    'alleaste',
    'alleasti',
    'alleata',
    'alleate',
    'alleatevi',
    'alleati',
    'alleato',
    'alleatomi',
    'alleatoti',
    'alleava',
    'alleavamo',
    'alleavano',
    'alleavate',
    'alleavi',
    'alleavo',
    'allee',
    'alleera',
    'alleerai',
    'alleeranno',
    'alleerebbe',
    'alleerebbero',
    'alleerei',
    'alleeremmo',
    'alleeremo',
    'alleereste',
    'alleeresti',
    'alleerete',
    'alleero',
    'allega',
    'allegabile',
    'allegabili',
    'allegagione',
    'allegagioni',
    'allegai',
    'allegamenti',
    'allegamento',
    'allegammo',
    'allegando',
    'allegandoci',
    'allegandomi',
    'allegandosi',
    'allegandoti',
    'allegandovi',
    'allegano',
    'allegante',
    'alleganti',
    'allegantisi',
    'allegarci',
    'allegare',
    'allegarmi',
    'allegarono',
    'allegarsi',
    'allegarti',
    'allegarvi',
    'allegasse',
    'allegassero',
    'allegassi',
    'allegassimo',
    'allegaste',
    'allegasti',
    'allegata',
    'allegate',
    'allegatevi',
    'allegati',
    'allegato',
    'allegatomi',
    'allegatoti',
    'allegava',
    'allegavamo',
    'allegavano',
    'allegavate',
    'allegavi',
    'allegavo',
    'allegazione',
    'allegazioni',
    'alleggera',
    'alleggerai',
    'alleggeranno',
    'alleggerebbe',
    'alleggerei',
    'alleggeremmo',
    'alleggeremo',
    'alleggerendo',
    'alleggerente',
    'alleggerenti',
    'alleggereste',
    'alleggeresti',
    'alleggerete',
    'alleggeri',
    'alleggeriamo',
    'alleggeriate',
    'alleggerii',
    'alleggerimmo',
    'alleggerira',
    'alleggerirai',
    'alleggerirci',
    'alleggerire',
    'alleggerirei',
    'alleggerirmi',
    'alleggeriro',
    'alleggerirsi',
    'alleggerirti',
    'alleggerirvi',
    'alleggerisca',
    'alleggerisce',
    'alleggerisci',
    'alleggerisco',
    'alleggerisse',
    'alleggerissi',
    'alleggeriste',
    'alleggeristi',
    'alleggerita',
    'alleggerite',
    'alleggeriti',
    'alleggerito',
    'alleggeriva',
    'alleggerivi',
    'alleggerivo',
    'alleggero',
    'alleggi',
    'alleggia',
    'alleggiai',
    'alleggiammo',
    'alleggiamo',
    'alleggiando',
    'alleggiano',
    'alleggiante',
    'alleggianti',
    'alleggiare',
    'alleggiarono',
    'alleggiasse',
    'alleggiassi',
    'alleggiaste',
    'alleggiasti',
    'alleggiata',
    'alleggiate',
    'alleggiati',
    'alleggiato',
    'alleggiava',
    'alleggiavamo',
    'alleggiavano',
    'alleggiavate',
    'alleggiavi',
    'alleggiavo',
    'alleggino',
    'alleggio',
    'alleghera',
    'allegherai',
    'allegheranno',
    'allegherebbe',
    'allegherei',
    'allegheremmo',
    'allegheremo',
    'alleghereste',
    'allegheresti',
    'allegherete',
    'alleghero',
    'alleghi',
    'alleghiamo',
    'alleghiamoci',
    'alleghiate',
    'alleghino',
    'allego',
    'allegoria',
    'allegorica',
    'allegoriche',
    'allegorici',
    'allegorico',
    'allegorie',
    'allegorismi',
    'allegorismo',
    'allegorista',
    'allegoriste',
    'allegoristi',
    'allegorizza',
    'allegorizzai',
    'allegorizzi',
    'allegorizzo',
    'allegra',
    'allegrai',
    'allegramente',
    'allegrammo',
    'allegrando',
    'allegrandosi',
    'allegrano',
    'allegrante',
    'allegranti',
    'allegranza',
    'allegranze',
    'allegrare',
    'allegrarono',
    'allegrarsi',
    'allegrasse',
    'allegrassero',
    'allegrassi',
    'allegrassimo',
    'allegraste',
    'allegrasti',
    'allegrata',
    'allegrate',
    'allegrati',
    'allegrato',
    'allegrava',
    'allegravamo',
    'allegravano',
    'allegravate',
    'allegravi',
    'allegravo',
    'allegre',
    'allegrera',
    'allegrerai',
    'allegreranno',
    'allegrerebbe',
    'allegrerei',
    'allegreremmo',
    'allegreremo',
    'allegrereste',
    'allegreresti',
    'allegrerete',
    'allegrero',
    'allegretta',
    'allegrette',
    'allegretti',
    'allegretto',
    'allegrezza',
    'allegrezze',
    'allegri',
    'allegria',
    'allegriamo',
    'allegriate',
    'allegrie',
    'allegrina',
    'allegrino',
    'allegro',
    'allegrona',
    'allegrone',
    'allegroni',
    'allegrotta',
    'allegrotte',
    'allegrotti',
    'allegrotto',
    'allei',
    'alleiamo',
    'alleiamoci',
    'alleiate',
    'alleino',
    'allele',
    'alleli',
    'allelica',
    'alleliche',
    'allelici',
    'allelico',
    'allelo',
    'allelomorfa',
    'allelomorfe',
    'allelomorfi',
    'allelomorfo',
    'allelotropa',
    'allelotrope',
    'allelotropi',
    'allelotropia',
    'allelotropo',
    'allelui',
    'alleluia',
    'alleluiai',
    'alleluiammo',
    'alleluiamo',
    'alleluiando',
    'alleluiano',
    'alleluiante',
    'alleluianti',
    'alleluiare',
    'alleluiarono',
    'alleluiasse',
    'alleluiassi',
    'alleluiaste',
    'alleluiasti',
    'alleluiata',
    'alleluiate',
    'alleluiati',
    'alleluiato',
    'alleluiava',
    'alleluiavamo',
    'alleluiavano',
    'alleluiavate',
    'alleluiavi',
    'alleluiavo',
    'alleluiera',
    'alleluierai',
    'alleluierei',
    'alleluieremo',
    'alleluierete',
    'alleluiero',
    'alleluino',
    'alleluio',
    'allemanda',
    'allemande',
    'allen',
    'allena',
    'allenai',
    'allenamenti',
    'allenamento',
    'allenammo',
    'allenando',
    'allenandoci',
    'allenandomi',
    'allenandosi',
    'allenandoti',
    'allenandovi',
    'allenano',
    'allenante',
    'allenanti',
    'allenantisi',
    'allenarci',
    'allenare',
    'allenarmi',
    'allenarono',
    'allenarsi',
    'allenarti',
    'allenarvi',
    'allenasse',
    'allenassero',
    'allenassi',
    'allenassimo',
    'allenaste',
    'allenasti',
    'allenata',
    'allenate',
    'allenatevi',
    'allenati',
    'allenato',
    'allenatomi',
    'allenatore',
    'allenatori',
    'allenatoti',
    'allenatrice',
    'allenatrici',
    'allenava',
    'allenavamo',
    'allenavano',
    'allenavate',
    'allenavi',
    'allenavo',
    'allenendo',
    'allenente',
    'allenenti',
    'allenera',
    'allenerai',
    'alleneranno',
    'allenerebbe',
    'allenerei',
    'alleneremmo',
    'alleneremo',
    'allenereste',
    'alleneresti',
    'allenerete',
    'allenero',
    'alleni',
    'alleniamo',
    'alleniamoci',
    'alleniate',
    'allenii',
    'allenimmo',
    'allenino',
    'allenira',
    'allenirai',
    'alleniranno',
    'allenire',
    'allenirebbe',
    'allenirei',
    'alleniremmo',
    'alleniremo',
    'allenireste',
    'alleniresti',
    'allenirete',
    'alleniro',
    'allenirono',
    'allenirsi',
    'allenisca',
    'alleniscano',
    'allenisce',
    'allenisci',
    'allenisco',
    'alleniscono',
    'allenisse',
    'allenissero',
    'allenissi',
    'allenissimo',
    'alleniste',
    'allenisti',
    'allenita',
    'allenite',
    'alleniti',
    'allenito',
    'alleniva',
    'allenivamo',
    'allenivano',
    'allenivate',
    'allenivi',
    'allenivo',
    'alleno',
    'allenta',
    'allentai',
    'allentamenti',
    'allentamento',
    'allentammo',
    'allentando',
    'allentandoci',
    'allentandomi',
    'allentandosi',
    'allentandoti',
    'allentandovi',
    'allentano',
    'allentante',
    'allentanti',
    'allentantisi',
    'allentarci',
    'allentare',
    'allentarmi',
    'allentarono',
    'allentarsi',
    'allentarti',
    'allentarvi',
    'allentasse',
    'allentassero',
    'allentassi',
    'allentassimo',
    'allentaste',
    'allentasti',
    'allentata',
    'allentate',
    'allentatevi',
    'allentati',
    'allentato',
    'allentatomi',
    'allentatoti',
    'allentava',
    'allentavamo',
    'allentavano',
    'allentavate',
    'allentavi',
    'allentavo',
    'allentera',
    'allenterai',
    'allenteranno',
    'allenterebbe',
    'allenterei',
    'allenteremmo',
    'allenteremo',
    'allentereste',
    'allenteresti',
    'allenterete',
    'allentero',
    'allenti',
    'allentiamo',
    'allentiamoci',
    'allentiate',
    'allentino',
    'allento',
    'alleo',
    'allergene',
    'allergeni',
    'allergenici',
    'allergenico',
    'allergia',
    'allergica',
    'allergiche',
    'allergici',
    'allergico',
    'allergie',
    'allergizza',
    'allergizzai',
    'allergizzano',
    'allergizzare',
    'allergizzata',
    'allergizzate',
    'allergizzati',
    'allergizzato',
    'allergizzava',
    'allergizzavi',
    'allergizzavo',
    'allergizzera',
    'allergizzero',
    'allergizzi',
    'allergizzino',
    'allergizzo',
    'allergologa',
    'allergologhe',
    'allergologi',
    'allergologia',
    'allergologie',
    'allergologo',
    'allergopatia',
    'allergopatie',
    'allerta',
    'allertai',
    'allertammo',
    'allertando',
    'allertano',
    'allertante',
    'allertanti',
    'allertare',
    'allertarono',
    'allertasse',
    'allertassero',
    'allertassi',
    'allertassimo',
    'allertaste',
    'allertasti',
    'allertata',
    'allertate',
    'allertati',
    'allertato',
    'allertava',
    'allertavamo',
    'allertavano',
    'allertavate',
    'allertavi',
    'allertavo',
    'allertera',
    'allerterai',
    'allerteranno',
    'allerterebbe',
    'allerterei',
    'allerteremmo',
    'allerteremo',
    'allertereste',
    'allerteresti',
    'allerterete',
    'allertero',
    'allerti',
    'allertiamo',
    'allertiate',
    'allertino',
    'allerto',
    'allessa',
    'allessai',
    'allessammo',
    'allessando',
    'allessano',
    'allessante',
    'allessanti',
    'allessare',
    'allessarono',
    'allessasse',
    'allessassero',
    'allessassi',
    'allessassimo',
    'allessaste',
    'allessasti',
    'allessata',
    'allessate',
    'allessati',
    'allessato',
    'allessatura',
    'allessature',
    'allessava',
    'allessavamo',
    'allessavano',
    'allessavate',
    'allessavi',
    'allessavo',
    'allesse',
    'allessera',
    'allesserai',
    'allesseranno',
    'allesserebbe',
    'allesserei',
    'allesseremmo',
    'allesseremo',
    'allessereste',
    'allesseresti',
    'allesserete',
    'allessero',
    'allessi',
    'allessiamo',
    'allessiate',
    'allessino',
    'allesso',
    'allestendo',
    'allestendoci',
    'allestendomi',
    'allestendosi',
    'allestendoti',
    'allestendovi',
    'allestente',
    'allestenti',
    'allestentisi',
    'allesti',
    'allestiamo',
    'allestiamoci',
    'allestiate',
    'allestii',
    'allestimenti',
    'allestimento',
    'allestimmo',
    'allestira',
    'allestirai',
    'allestiranno',
    'allestirci',
    'allestire',
    'allestirebbe',
    'allestirei',
    'allestiremmo',
    'allestiremo',
    'allestireste',
    'allestiresti',
    'allestirete',
    'allestirmi',
    'allestiro',
    'allestirono',
    'allestirsi',
    'allestirti',
    'allestirvi',
    'allestisca',
    'allestiscano',
    'allestisce',
    'allestisci',
    'allestisciti',
    'allestisco',
    'allestiscono',
    'allestisse',
    'allestissero',
    'allestissi',
    'allestissimo',
    'allestiste',
    'allestisti',
    'allestita',
    'allestite',
    'allestitevi',
    'allestiti',
    'allestito',
    'allestitomi',
    'allestitore',
    'allestitori',
    'allestitoti',
    'allestitrice',
    'allestitrici',
    'allestiva',
    'allestivamo',
    'allestivano',
    'allestivate',
    'allestivi',
    'allestivo',
    'alletta',
    'allettai',
    'allettamenti',
    'allettamento',
    'allettammo',
    'allettando',
    'allettandoci',
    'allettandomi',
    'allettandosi',
    'allettandoti',
    'allettandovi',
    'allettano',
    'allettante',
    'allettanti',
    'allettantisi',
    'allettarci',
    'allettare',
    'allettarmi',
    'allettarono',
    'allettarsi',
    'allettarti',
    'allettarvi',
    'allettasse',
    'allettassero',
    'allettassi',
    'allettassimo',
    'allettaste',
    'allettasti',
    'allettata',
    'allettate',
    'allettatevi',
    'allettati',
    'allettativa',
    'allettative',
    'allettativi',
    'allettativo',
    'allettato',
    'allettatomi',
    'allettatore',
    'allettatori',
    'allettatoti',
    'allettatrice',
    'allettatrici',
    'allettava',
    'allettavamo',
    'allettavano',
    'allettavate',
    'allettavi',
    'allettavo',
    'allettera',
    'alletterai',
    'alletteranno',
    'alletterebbe',
    'alletterei',
    'alletteremmo',
    'alletteremo',
    'allettereste',
    'alletteresti',
    'alletterete',
    'allettero',
    'allettevole',
    'allettevoli',
    'alletti',
    'allettiamo',
    'allettiamoci',
    'allettiate',
    'allettino',
    'alletto',
    'alleva',
    'allevai',
    'allevamenti',
    'allevamento',
    'allevammo',
    'allevando',
    'allevandoci',
    'allevandola',
    'allevandole',
    'allevandoli',
    'allevandolo',
    'allevandomi',
    'allevandoti',
    'allevandovi',
    'allevano',
    'allevante',
    'allevanti',
    'allevarci',
    'allevare',
    'allevarla',
    'allevarle',
    'allevarli',
    'allevarlo',
    'allevarmi',
    'allevarono',
    'allevarti',
    'allevarvi',
    'allevasse',
    'allevassero',
    'allevassi',
    'allevassimo',
    'allevaste',
    'allevasti',
    'allevata',
    'allevate',
    'allevati',
    'allevato',
    'allevatore',
    'allevatori',
    'allevatrice',
    'allevatrici',
    'allevava',
    'allevavamo',
    'allevavano',
    'allevavate',
    'allevavi',
    'allevavo',
    'allevera',
    'alleverai',
    'alleveranno',
    'alleverebbe',
    'alleverei',
    'alleveremmo',
    'alleveremo',
    'allevereste',
    'alleveresti',
    'alleverete',
    'allevero',
    'allevi',
    'allevia',
    'alleviai',
    'alleviamenti',
    'alleviamento',
    'alleviammo',
    'alleviamo',
    'alleviamoci',
    'alleviando',
    'alleviandoci',
    'alleviandomi',
    'alleviandosi',
    'alleviandoti',
    'alleviandovi',
    'alleviano',
    'alleviante',
    'allevianti',
    'alleviantisi',
    'alleviarci',
    'alleviare',
    'alleviarmi',
    'alleviarono',
    'alleviarsi',
    'alleviarti',
    'alleviarvi',
    'alleviasse',
    'alleviassero',
    'alleviassi',
    'alleviassimo',
    'alleviaste',
    'alleviasti',
    'alleviata',
    'alleviate',
    'alleviatevi',
    'alleviati',
    'alleviato',
    'alleviatomi',
    'alleviatore',
    'alleviatori',
    'alleviatoti',
    'alleviatrice',
    'alleviatrici',
    'alleviava',
    'alleviavamo',
    'alleviavano',
    'alleviavate',
    'alleviavi',
    'alleviavo',
    'alleviera',
    'allevierai',
    'allevieranno',
    'allevierebbe',
    'allevierei',
    'allevieremmo',
    'allevieremo',
    'alleviereste',
    'allevieresti',
    'allevierete',
    'alleviero',
    'allevino',
    'allevio',
    'allevo',
    'alliba',
    'allibai',
    'allibammo',
    'allibando',
    'allibano',
    'allibante',
    'allibanti',
    'allibare',
    'allibarono',
    'allibasse',
    'allibassero',
    'allibassi',
    'allibassimo',
    'allibaste',
    'allibasti',
    'allibata',
    'allibate',
    'allibati',
    'allibato',
    'allibava',
    'allibavamo',
    'allibavano',
    'allibavate',
    'allibavi',
    'allibavo',
    'allibendo',
    'allibente',
    'allibenti',
    'allibera',
    'alliberai',
    'alliberanno',
    'alliberebbe',
    'alliberei',
    'alliberemmo',
    'alliberemo',
    'allibereste',
    'alliberesti',
    'alliberete',
    'allibero',
    'allibi',
    'allibiamo',
    'allibiate',
    'allibii',
    'allibimmo',
    'allibino',
    'allibira',
    'allibirai',
    'allibiranno',
    'allibire',
    'allibirebbe',
    'allibirei',
    'allibiremmo',
    'allibiremo',
    'allibireste',
    'allibiresti',
    'allibirete',
    'allibiro',
    'allibirono',
    'allibisca',
    'allibiscano',
    'allibisce',
    'allibisci',
    'allibisco',
    'allibiscono',
    'allibisse',
    'allibissero',
    'allibissi',
    'allibissimo',
    'allibiste',
    'allibisti',
    'allibita',
    'allibite',
    'allibiti',
    'allibito',
    'allibiva',
    'allibivamo',
    'allibivano',
    'allibivate',
    'allibivi',
    'allibivo',
    'allibo',
    'allibra',
    'allibrai',
    'allibramenti',
    'allibramento',
    'allibrammo',
    'allibrando',
    'allibrano',
    'allibrante',
    'allibranti',
    'allibrare',
    'allibrarono',
    'allibrasse',
    'allibrassero',
    'allibrassi',
    'allibrassimo',
    'allibraste',
    'allibrasti',
    'allibrata',
    'allibrate',
    'allibrati',
    'allibrato',
    'allibratore',
    'allibratori',
    'allibratrice',
    'allibratrici',
    'allibrava',
    'allibravamo',
    'allibravano',
    'allibravate',
    'allibravi',
    'allibravo',
    'allibrera',
    'allibrerai',
    'allibreranno',
    'allibrerebbe',
    'allibrerei',
    'allibreremmo',
    'allibreremo',
    'allibrereste',
    'allibreresti',
    'allibrerete',
    'allibrero',
    'allibri',
    'allibriamo',
    'allibriate',
    'allibrino',
    'allibro',
    'alliccera',
    'alliccerai',
    'allicceranno',
    'alliccerebbe',
    'alliccerei',
    'allicceremmo',
    'allicceremo',
    'alliccereste',
    'allicceresti',
    'alliccerete',
    'alliccero',
    'allicci',
    'alliccia',
    'allicciai',
    'allicciammo',
    'allicciamo',
    'allicciando',
    'allicciano',
    'allicciante',
    'alliccianti',
    'allicciare',
    'allicciarono',
    'allicciasse',
    'allicciassi',
    'allicciaste',
    'allicciasti',
    'allicciata',
    'allicciate',
    'allicciati',
    'allicciato',
    'allicciatura',
    'allicciature',
    'allicciava',
    'allicciavamo',
    'allicciavano',
    'allicciavate',
    'allicciavi',
    'allicciavo',
    'alliccino',
    'alliccio',
    'allidere',
    'allieta',
    'allietai',
    'allietammo',
    'allietando',
    'allietandoci',
    'allietandomi',
    'allietandosi',
    'allietandoti',
    'allietandovi',
    'allietano',
    'allietante',
    'allietanti',
    'allietantisi',
    'allietarci',
    'allietare',
    'allietarmi',
    'allietarono',
    'allietarsi',
    'allietarti',
    'allietarvi',
    'allietasse',
    'allietassero',
    'allietassi',
    'allietassimo',
    'allietaste',
    'allietasti',
    'allietata',
    'allietate',
    'allietatevi',
    'allietati',
    'allietato',
    'allietatomi',
    'allietatoti',
    'allietava',
    'allietavamo',
    'allietavano',
    'allietavate',
    'allietavi',
    'allietavo',
    'allietera',
    'allieterai',
    'allieteranno',
    'allieterebbe',
    'allieterei',
    'allieteremmo',
    'allieteremo',
    'allietereste',
    'allieteresti',
    'allieterete',
    'allietero',
    'allieti',
    'allietiamo',
    'allietiamoci',
    'allietiate',
    'allietino',
    'allieto',
    'allieva',
    'allieve',
    'allievi',
    'allievo',
    'alliga',
    'alligamenti',
    'alligamento',
    'alligando',
    'alligano',
    'alligare',
    'alligarono',
    'alligata',
    'alligate',
    'alligati',
    'alligato',
    'alligatore',
    'alligatori',
    'alligatoride',
    'alligatoridi',
    'alligava',
    'alligavano',
    'alligazione',
    'alligazioni',
    'alligna',
    'allignai',
    'allignamenti',
    'allignamento',
    'allignammo',
    'allignando',
    'allignano',
    'allignante',
    'allignanti',
    'allignare',
    'allignarono',
    'allignasse',
    'allignassero',
    'allignassi',
    'allignassimo',
    'allignaste',
    'allignasti',
    'allignata',
    'allignate',
    'allignati',
    'allignato',
    'allignava',
    'allignavamo',
    'allignavano',
    'allignavate',
    'allignavi',
    'allignavo',
    'allignera',
    'allignerai',
    'alligneranno',
    'allignerebbe',
    'allignerei',
    'alligneremmo',
    'alligneremo',
    'allignereste',
    'alligneresti',
    'allignerete',
    'allignero',
    'alligni',
    'alligniamo',
    'alligniate',
    'allignino',
    'alligno',
    'alligo',
    'allindando',
    'allindare',
    'allindata',
    'allindate',
    'allindati',
    'allindato',
    'allinea',
    'allineai',
    'allineamenti',
    'allineamento',
    'allineammo',
    'allineando',
    'allineandoci',
    'allineandomi',
    'allineandosi',
    'allineandoti',
    'allineandovi',
    'allineano',
    'allineante',
    'allineanti',
    'allineantisi',
    'allinearci',
    'allineare',
    'allinearmi',
    'allinearono',
    'allinearsi',
    'allinearti',
    'allinearvi',
    'allineasse',
    'allineassero',
    'allineassi',
    'allineassimo',
    'allineaste',
    'allineasti',
    'allineata',
    'allineate',
    'allineatevi',
    'allineati',
    'allineato',
    'allineatomi',
    'allineatore',
    'allineatori',
    'allineatoti',
    'allineatrice',
    'allineatrici',
    'allineava',
    'allineavamo',
    'allineavano',
    'allineavate',
    'allineavi',
    'allineavo',
    'allineera',
    'allineerai',
    'allineeranno',
    'allineerebbe',
    'allineerei',
    'allineeremmo',
    'allineeremo',
    'allineereste',
    'allineeresti',
    'allineerete',
    'allineero',
    'allinei',
    'allineiamo',
    'allineiamoci',
    'allineiate',
    'allineino',
    'allineo',
    'alliscera',
    'alliscerai',
    'allisceranno',
    'alliscerebbe',
    'alliscerei',
    'allisceremmo',
    'allisceremo',
    'alliscereste',
    'allisceresti',
    'alliscerete',
    'alliscero',
    'allisci',
    'alliscia',
    'allisciai',
    'allisciammo',
    'allisciamo',
    'allisciando',
    'allisciano',
    'allisciante',
    'alliscianti',
    'allisciare',
    'allisciarono',
    'allisciasse',
    'allisciassi',
    'allisciaste',
    'allisciasti',
    'allisciata',
    'allisciate',
    'allisciati',
    'allisciato',
    'allisciatoi',
    'allisciatoio',
    'allisciava',
    'allisciavamo',
    'allisciavano',
    'allisciavate',
    'allisciavi',
    'allisciavo',
    'alliscino',
    'alliscio',
    'alliterando',
    'alliterarsi',
    'alliterato',
    'allittera',
    'allitterai',
    'allitterammo',
    'allitterando',
    'allitterano',
    'allitterante',
    'allitteranti',
    'allitterare',
    'allitterasse',
    'allitterassi',
    'allitteraste',
    'allitterasti',
    'allitterata',
    'allitterate',
    'allitterati',
    'allitterato',
    'allitterava',
    'allitteravi',
    'allitteravo',
    'allitterera',
    'allittererai',
    'allittererei',
    'allitterero',
    'allitteri',
    'allitteriamo',
    'allitteriate',
    'allitterino',
    'allittero',
    'allium',
    'allivella',
    'allivellai',
    'allivellammo',
    'allivellando',
    'allivellano',
    'allivellante',
    'allivellanti',
    'allivellare',
    'allivellasse',
    'allivellassi',
    'allivellaste',
    'allivellasti',
    'allivellata',
    'allivellate',
    'allivellati',
    'allivellato',
    'allivellava',
    'allivellavi',
    'allivellavo',
    'allivellera',
    'allivellerai',
    'allivellerei',
    'allivellero',
    'allivelli',
    'allivelliamo',
    'allivelliate',
    'allivellino',
    'allivello',
    'allividendo',
    'allividente',
    'allividenti',
    'allividi',
    'allividiamo',
    'allividiate',
    'allividii',
    'allividimmo',
    'allividira',
    'allividirai',
    'allividire',
    'allividirei',
    'allividiremo',
    'allividirete',
    'allividiro',
    'allividirono',
    'allividisca',
    'allividisce',
    'allividisci',
    'allividisco',
    'allividisse',
    'allividissi',
    'allividiste',
    'allividisti',
    'allividita',
    'allividite',
    'allividiti',
    'allividito',
    'allividiva',
    'allividivamo',
    'allividivano',
    'allividivate',
    'allividivi',
    'allividivo',
    'allo',
    'allobiologia',
    'allobiologie',
    'allobroga',
    'allobroghe',
    'allobroghi',
    'allobrogi',
    'allobrogo',
    'alloca',
    'allocabile',
    'allocabili',
    'allocai',
    'allocammo',
    'allocando',
    'allocandola',
    'allocandole',
    'allocandoli',
    'allocandolo',
    'allocano',
    'allocante',
    'allocanti',
    'allocare',
    'allocarla',
    'allocarle',
    'allocarli',
    'allocarlo',
    'allocarono',
    'allocasse',
    'allocassero',
    'allocassi',
    'allocassimo',
    'allocaste',
    'allocasti',
    'allocata',
    'allocate',
    'allocati',
    'allocativa',
    'allocative',
    'allocativi',
    'allocativo',
    'allocato',
    'allocava',
    'allocavamo',
    'allocavano',
    'allocavate',
    'allocavi',
    'allocavo',
    'allocazione',
    'allocazioni',
    'allocca',
    'alloccaggine',
    'alloccaggini',
    'allocche',
    'allocchendo',
    'allocchente',
    'allocchenti',
    'alloccheria',
    'alloccherie',
    'allocchi',
    'allocchiamo',
    'allocchiate',
    'allocchii',
    'allocchimmo',
    'allocchira',
    'allocchirai',
    'allocchire',
    'allocchirei',
    'allocchiremo',
    'allocchirete',
    'allocchiro',
    'allocchirono',
    'allocchisca',
    'allocchisce',
    'allocchisci',
    'allocchisco',
    'allocchisse',
    'allocchissi',
    'allocchiste',
    'allocchisti',
    'allocchita',
    'allocchite',
    'allocchiti',
    'allocchito',
    'allocchiva',
    'allocchivamo',
    'allocchivano',
    'allocchivate',
    'allocchivi',
    'allocchivo',
    'allocco',
    'allochera',
    'allocherai',
    'allocheranno',
    'allocherebbe',
    'allocherei',
    'allocheremmo',
    'allocheremo',
    'allochereste',
    'allocheresti',
    'allocherete',
    'allochero',
    'allochi',
    'allochiamo',
    'allochiate',
    'allochino',
    'alloco',
    'allocoria',
    'allocroica',
    'allocroiche',
    'allocroici',
    'allocroico',
    'allocroismi',
    'allocroismo',
    'allocromasia',
    'allocromasie',
    'alloctona',
    'alloctone',
    'alloctoni',
    'alloctono',
    'allocutari',
    'allocutario',
    'allocutiva',
    'allocutive',
    'allocutivi',
    'allocutivo',
    'allocutore',
    'allocutori',
    'allocutoria',
    'allocutorie',
    'allocutorio',
    'allocutrice',
    'allocutrici',
    'allocuzione',
    'allocuzioni',
    'allodi',
    'allodiale',
    'allodiali',
    'allodio',
    'allodola',
    'allodole',
    'alloerotismo',
    'allofoni',
    'allofono',
    'alloga',
    'allogagione',
    'allogai',
    'allogamenti',
    'allogamento',
    'allogamia',
    'allogamica',
    'allogamiche',
    'allogamici',
    'allogamico',
    'allogamie',
    'allogammo',
    'allogando',
    'allogandoci',
    'allogandomi',
    'allogandosi',
    'allogandoti',
    'allogandovi',
    'allogano',
    'allogante',
    'alloganti',
    'allogantisi',
    'allogarci',
    'allogare',
    'allogarmi',
    'allogarono',
    'allogarsi',
    'allogarti',
    'allogarvi',
    'allogasse',
    'allogassero',
    'allogassi',
    'allogassimo',
    'allogaste',
    'allogasti',
    'allogata',
    'allogate',
    'allogatevi',
    'allogati',
    'allogato',
    'allogatomi',
    'allogatore',
    'allogatori',
    'allogatoti',
    'allogatrice',
    'allogatrici',
    'allogava',
    'allogavamo',
    'allogavano',
    'allogavate',
    'allogavi',
    'allogavo',
    'allogazione',
    'allogazioni',
    'allogena',
    'allogene',
    'allogeni',
    'allogenica',
    'allogeniche',
    'allogenici',
    'allogenico',
    'allogeno',
    'alloggera',
    'alloggerai',
    'alloggeranno',
    'alloggerebbe',
    'alloggerei',
    'alloggeremmo',
    'alloggeremo',
    'alloggereste',
    'alloggeresti',
    'alloggerete',
    'alloggero',
    'alloggetti',
    'alloggetto',
    'alloggi',
    'alloggia',
    'alloggiai',
    'alloggiammo',
    'alloggiamo',
    'alloggiamoci',
    'alloggiando',
    'alloggiano',
    'alloggiante',
    'alloggianti',
    'alloggiarci',
    'alloggiare',
    'alloggiarmi',
    'alloggiarono',
    'alloggiarsi',
    'alloggiarti',
    'alloggiarvi',
    'alloggiasse',
    'alloggiassi',
    'alloggiaste',
    'alloggiasti',
    'alloggiata',
    'alloggiate',
    'alloggiatevi',
    'alloggiati',
    'alloggiato',
    'alloggiatomi',
    'alloggiatoti',
    'alloggiava',
    'alloggiavamo',
    'alloggiavano',
    'alloggiavate',
    'alloggiavi',
    'alloggiavo',
    'alloggino',
    'alloggio',
    'alloghera',
    'allogherai',
    'allogheranno',
    'allogherebbe',
    'allogherei',
    'allogheremmo',
    'allogheremo',
    'alloghereste',
    'allogheresti',
    'allogherete',
    'alloghero',
    'alloghi',
    'alloghiamo',
    'alloghiamoci',
    'alloghiate',
    'alloghino',
    'allogliata',
    'allogliate',
    'allogliati',
    'allogliato',
    'alloglossia',
    'alloglossie',
    'alloglotta',
    'alloglotte',
    'alloglotti',
    'alloglotto',
    'allogo',
    'allografi',
    'allografo',
    'allombata',
    'allombate',
    'allombati',
    'allombato',
    'allomone',
    'allomoni',
    'allomorfi',
    'allomorfo',
    'allonima',
    'allonime',
    'allonimi',
    'allonimo',
    'allontana',
    'allontanai',
    'allontanammo',
    'allontanando',
    'allontanano',
    'allontanante',
    'allontananti',
    'allontanarci',
    'allontanare',
    'allontanarla',
    'allontanarle',
    'allontanarli',
    'allontanarlo',
    'allontanarmi',
    'allontanarsi',
    'allontanarti',
    'allontanarvi',
    'allontanasse',
    'allontanassi',
    'allontanaste',
    'allontanasti',
    'allontanata',
    'allontanate',
    'allontanati',
    'allontanato',
    'allontanava',
    'allontanavi',
    'allontanavo',
    'allontanera',
    'allontanerai',
    'allontanerei',
    'allontanero',
    'allontanerà',
    'allontani',
    'allontaniamo',
    'allontaniate',
    'allontanino',
    'allontano',
    'allopatia',
    'allopatica',
    'allopatiche',
    'allopatici',
    'allopatico',
    'allopatie',
    'alloppi',
    'alloppia',
    'alloppiai',
    'alloppiammo',
    'alloppiamo',
    'alloppiamoci',
    'alloppiando',
    'alloppiano',
    'alloppiante',
    'alloppianti',
    'alloppiarci',
    'alloppiare',
    'alloppiarmi',
    'alloppiarono',
    'alloppiarsi',
    'alloppiarti',
    'alloppiarvi',
    'alloppiasse',
    'alloppiassi',
    'alloppiaste',
    'alloppiasti',
    'alloppiata',
    'alloppiate',
    'alloppiatevi',
    'alloppiati',
    'alloppiato',
    'alloppiatomi',
    'alloppiatoti',
    'alloppiava',
    'alloppiavamo',
    'alloppiavano',
    'alloppiavate',
    'alloppiavi',
    'alloppiavo',
    'alloppiera',
    'alloppierai',
    'alloppierei',
    'alloppieremo',
    'alloppierete',
    'alloppiero',
    'alloppino',
    'alloppio',
    'allora',
    'allorche',
    'allorchè',
    'allorché',
    'allori',
    'alloro',
    'allorquando',
    'allosauro',
    'allosterica',
    'allosterico',
    'allotipi',
    'allotri',
    'allotria',
    'allotrie',
    'allotrio',
    'allotropi',
    'allotropia',
    'allotropica',
    'allotropiche',
    'allotropici',
    'allotropico',
    'allotropie',
    'allotropo',
    'allotta',
    'allottai',
    'allottammo',
    'allottando',
    'allottano',
    'allottante',
    'allottanti',
    'allottare',
    'allottarono',
    'allottasse',
    'allottassero',
    'allottassi',
    'allottassimo',
    'allottaste',
    'allottasti',
    'allottata',
    'allottate',
    'allottati',
    'allottato',
    'allottava',
    'allottavamo',
    'allottavano',
    'allottavate',
    'allottavi',
    'allottavo',
    'allottera',
    'allotterai',
    'allotteranno',
    'allotterebbe',
    'allotterei',
    'allotteremmo',
    'allotteremo',
    'allottereste',
    'allotteresti',
    'allotterete',
    'allottero',
    'allotti',
    'allottiamo',
    'allottiate',
    'allottino',
    'allotto',
    'allozima',
    'allozimi',
    'allucchetto',
    'allucciola',
    'allucciolano',
    'allucciolare',
    'allucciolii',
    'allucciolio',
    'alluce',
    'alluci',
    'allucina',
    'allucinai',
    'allucinammo',
    'allucinando',
    'allucinano',
    'allucinante',
    'allucinanti',
    'allucinarci',
    'allucinare',
    'allucinarmi',
    'allucinarono',
    'allucinarsi',
    'allucinarti',
    'allucinarvi',
    'allucinasse',
    'allucinassi',
    'allucinaste',
    'allucinasti',
    'allucinata',
    'allucinate',
    'allucinatevi',
    'allucinati',
    'allucinato',
    'allucinatomi',
    'allucinatori',
    'allucinatoti',
    'allucinava',
    'allucinavamo',
    'allucinavano',
    'allucinavate',
    'allucinavi',
    'allucinavo',
    'allucinera',
    'allucinerai',
    'allucinerei',
    'allucineremo',
    'allucinerete',
    'allucinero',
    'allucini',
    'alluciniamo',
    'alluciniate',
    'allucinino',
    'allucino',
    'allucinogena',
    'allucinogene',
    'allucinogeni',
    'allucinogeno',
    'allucinosi',
    'alluda',
    'alludano',
    'allude',
    'alludemmo',
    'alludendo',
    'alludente',
    'alludenti',
    'alludera',
    'alluderai',
    'alluderanno',
    'alludere',
    'alluderebbe',
    'alluderei',
    'alluderemmo',
    'alluderemo',
    'alludereste',
    'alluderesti',
    'alluderete',
    'alludero',
    'alludesse',
    'alludessero',
    'alludessi',
    'alludessimo',
    'alludeste',
    'alludesti',
    'alludete',
    'alludeva',
    'alludevamo',
    'alludevano',
    'alludevate',
    'alludevi',
    'alludevo',
    'alludi',
    'alludiamo',
    'alludiate',
    'alludo',
    'alludono',
    'alluma',
    'allumaca',
    'allumacando',
    'allumacano',
    'allumacare',
    'allumacato',
    'allumacatura',
    'allumacature',
    'allumacava',
    'allumacavano',
    'allumai',
    'allumammo',
    'allumando',
    'allumano',
    'allumante',
    'allumanti',
    'allumare',
    'allumarono',
    'allumasse',
    'allumassero',
    'allumassi',
    'allumassimo',
    'allumaste',
    'allumasti',
    'allumata',
    'allumate',
    'allumati',
    'allumato',
    'allumatura',
    'allumature',
    'allumava',
    'allumavamo',
    'allumavano',
    'allumavate',
    'allumavi',
    'allumavo',
    'allume',
    'allumera',
    'allumerai',
    'allumeranno',
    'allumerebbe',
    'allumerei',
    'allumeremmo',
    'allumeremo',
    'allumereste',
    'allumeresti',
    'allumerete',
    'allumero',
    'allumi',
    'allumiamo',
    'allumiate',
    'allumiera',
    'allumiere',
    'allumina',
    'alluminai',
    'alluminammo',
    'alluminando',
    'alluminano',
    'alluminante',
    'alluminanti',
    'alluminar',
    'alluminare',
    'alluminarono',
    'alluminasse',
    'alluminassi',
    'alluminaste',
    'alluminasti',
    'alluminata',
    'alluminate',
    'alluminati',
    'alluminato',
    'alluminatura',
    'alluminature',
    'alluminava',
    'alluminavamo',
    'alluminavano',
    'alluminavate',
    'alluminavi',
    'alluminavo',
    'allumine',
    'alluminera',
    'alluminerai',
    'alluminerei',
    'allumineremo',
    'alluminerete',
    'alluminero',
    'allumini',
    'alluminia',
    'alluminiai',
    'alluminiammo',
    'alluminiamo',
    'alluminiando',
    'alluminiano',
    'alluminiante',
    'alluminianti',
    'alluminiare',
    'alluminiasse',
    'alluminiassi',
    'alluminiaste',
    'alluminiasti',
    'alluminiata',
    'alluminiate',
    'alluminiati',
    'alluminiato',
    'alluminiava',
    'alluminiavi',
    'alluminiavo',
    'alluminica',
    'alluminiche',
    'alluminici',
    'alluminico',
    'alluminiera',
    'alluminierai',
    'alluminierei',
    'alluminieria',
    'alluminierie',
    'alluminiero',
    'alluminifera',
    'alluminifere',
    'alluminiferi',
    'alluminifero',
    'alluminino',
    'alluminio',
    'allumino',
    'alluminosi',
    'allumo',
    'alluna',
    'allunaggi',
    'allunaggio',
    'allunai',
    'allunamenti',
    'allunamento',
    'allunammo',
    'allunando',
    'allunano',
    'allunante',
    'allunanti',
    'allunare',
    'allunarono',
    'allunasse',
    'allunassero',
    'allunassi',
    'allunassimo',
    'allunaste',
    'allunasti',
    'allunata',
    'allunate',
    'allunati',
    'allunato',
    'allunava',
    'allunavamo',
    'allunavano',
    'allunavate',
    'allunavi',
    'allunavo',
    'allunera',
    'allunerai',
    'alluneranno',
    'allunerebbe',
    'allunerei',
    'alluneremmo',
    'alluneremo',
    'allunereste',
    'alluneresti',
    'allunerete',
    'allunero',
    'allunga',
    'allungabile',
    'allungabili',
    'allungai',
    'allungalapis',
    'allungamenti',
    'allungamento',
    'allungammo',
    'allungando',
    'allungandoci',
    'allungandomi',
    'allungandosi',
    'allungandoti',
    'allungandovi',
    'allungano',
    'allungante',
    'allunganti',
    'allungantisi',
    'allungar',
    'allungarci',
    'allungare',
    'allungarmi',
    'allungarono',
    'allungarsi',
    'allungarti',
    'allungarvi',
    'allungasse',
    'allungassero',
    'allungassi',
    'allungassimo',
    'allungaste',
    'allungasti',
    'allungata',
    'allungate',
    'allungatevi',
    'allungati',
    'allungato',
    'allungatomi',
    'allungatoti',
    'allungatura',
    'allungature',
    'allungava',
    'allungavamo',
    'allungavano',
    'allungavate',
    'allungavi',
    'allungavo',
    'allunghe',
    'allunghera',
    'allungherai',
    'allungherei',
    'allungheremo',
    'allungherete',
    'allunghero',
    'allunghi',
    'allunghiamo',
    'allunghiate',
    'allunghino',
    'allungo',
    'alluni',
    'alluniamo',
    'alluniate',
    'allunino',
    'alluno',
    'allupa',
    'allupai',
    'allupammo',
    'allupando',
    'allupano',
    'allupante',
    'allupanti',
    'allupare',
    'alluparono',
    'allupasse',
    'allupassero',
    'allupassi',
    'allupassimo',
    'allupaste',
    'allupasti',
    'allupata',
    'allupate',
    'allupati',
    'allupato',
    'allupava',
    'allupavamo',
    'allupavano',
    'allupavate',
    'allupavi',
    'allupavo',
    'allupera',
    'alluperai',
    'alluperanno',
    'alluperebbe',
    'alluperei',
    'alluperemmo',
    'alluperemo',
    'allupereste',
    'alluperesti',
    'alluperete',
    'allupero',
    'allupi',
    'allupiamo',
    'allupiate',
    'allupino',
    'allupo',
    'allure',
    'allusa',
    'alluse',
    'allusero',
    'allusi',
    'allusione',
    'allusioni',
    'allusiva',
    'allusive',
    'allusivi',
    'allusivita',
    'allusivo',
    'alluso',
    'alluviale',
    'alluviali',
    'alluvionale',
    'alluvionali',
    'alluvionata',
    'alluvionate',
    'alluvionati',
    'alluvionato',
    'alluvione',
    'alluvioni',
    'alluzza',
    'alluzzando',
    'alluzzano',
    'alluzzare',
    'alluzzata',
    'alluzzate',
    'alluzzati',
    'alluzzato',
    'alma',
    'almagesti',
    'almagesto',
    'almanacca',
    'almanaccai',
    'almanaccammo',
    'almanaccando',
    'almanaccano',
    'almanaccante',
    'almanaccanti',
    'almanaccare',
    'almanaccasse',
    'almanaccassi',
    'almanaccaste',
    'almanaccasti',
    'almanaccata',
    'almanaccate',
    'almanaccati',
    'almanaccato',
    'almanaccava',
    'almanaccavi',
    'almanaccavo',
    'almanacchera',
    'almanacchero',
    'almanacchi',
    'almanacchino',
    'almanacco',
    'almanaccona',
    'almanaccone',
    'almanacconi',
    'almanco',
    'almandini',
    'almandino',
    'almarosa',
    'alme',
    'almea',
    'almee',
    'almeno',
    'almente',
    'almeria',
    'almerica',
    'almerico',
    'almerigo',
    'almerina',
    'almerinda',
    'almerindo',
    'almerino',
    'almerio',
    'almeris',
    'almeroa',
    'almeroe',
    'almeroi',
    'almeroo',
    'almi',
    'almiero',
    'almina',
    'almino',
    'almira',
    'almiraglio',
    'almirante',
    'almiranti',
    'almiro',
    'almo',
    'almuzi',
    'almuzia',
    'almuzie',
    'almuzio',
    'alni',
    'alnici',
    'alnico',
    'alno',
    'alnoite',
    'alobate',
    'alobati',
    'alobi',
    'alobia',
    'alobie',
    'alobio',
    'alocasia',
    'alocasie',
    'alodia',
    'aloe',
    'alofauna',
    'alofaune',
    'alofila',
    'alofile',
    'alofili',
    'alofilo',
    'alofita',
    'alofite',
    'aloflora',
    'aloflore',
    'alogena',
    'alogenai',
    'alogenammo',
    'alogenando',
    'alogenano',
    'alogenante',
    'alogenanti',
    'alogenare',
    'alogenarono',
    'alogenasse',
    'alogenassero',
    'alogenassi',
    'alogenassimo',
    'alogenaste',
    'alogenasti',
    'alogenata',
    'alogenate',
    'alogenati',
    'alogenato',
    'alogenava',
    'alogenavamo',
    'alogenavano',
    'alogenavate',
    'alogenavi',
    'alogenavo',
    'alogenazione',
    'alogenazioni',
    'alogene',
    'alogenera',
    'alogenerai',
    'alogeneranno',
    'alogenerebbe',
    'alogenerei',
    'alogeneremmo',
    'alogeneremo',
    'alogenereste',
    'alogeneresti',
    'alogenerete',
    'alogenero',
    'alogeni',
    'alogeniamo',
    'alogeniate',
    'alogenino',
    'alogeno',
    'alogenuri',
    'alogenuro',
    'alogica',
    'alogicamente',
    'alogiche',
    'alogici',
    'alogico',
    'aloha',
    'aloide',
    'aloidi',
    'aloisa',
    'aloise',
    'aloisio',
    'alone',
    'aloni',
    'alonzo',
    'alopecia',
    'alopecie',
    'alosa',
    'alose',
    'alotano',
    'alouatta',
    'alouattinae',
    'alpa',
    'alpaca',
    'alpacca',
    'alpacche',
    'alpaga',
    'alpe',
    'alpeggera',
    'alpeggerai',
    'alpeggeranno',
    'alpeggerebbe',
    'alpeggerei',
    'alpeggeremmo',
    'alpeggeremo',
    'alpeggereste',
    'alpeggeresti',
    'alpeggerete',
    'alpeggero',
    'alpeggi',
    'alpeggia',
    'alpeggiai',
    'alpeggiammo',
    'alpeggiamo',
    'alpeggiando',
    'alpeggiano',
    'alpeggiante',
    'alpeggianti',
    'alpeggiare',
    'alpeggiarono',
    'alpeggiasse',
    'alpeggiassi',
    'alpeggiaste',
    'alpeggiasti',
    'alpeggiata',
    'alpeggiate',
    'alpeggiati',
    'alpeggiato',
    'alpeggiava',
    'alpeggiavamo',
    'alpeggiavano',
    'alpeggiavate',
    'alpeggiavi',
    'alpeggiavo',
    'alpeggino',
    'alpeggio',
    'alpenstoc',
    'alpenstock',
    'alpestre',
    'alpestri',
    'alpestro',
    'alpha',
    'alphavirus',
    'alphorn',
    'alpi',
    'alpicoltura',
    'alpicolture',
    'alpicultura',
    'alpiculture',
    'alpidio',
    'alpigiana',
    'alpigiane',
    'alpigiani',
    'alpigiano',
    'alpina',
    'alpine',
    'alpingo',
    'alpini',
    'alpiniano',
    'alpinismi',
    'alpinismo',
    'alpinista',
    'alpiniste',
    'alpinisti',
    'alpinistica',
    'alpinistiche',
    'alpinistici',
    'alpinistico',
    'alpino',
    'alpinolo',
    'alpo',
    'alquanta',
    'alquante',
    'alquanti',
    'alquanto',
    'alsazia',
    'alsaziana',
    'alsaziane',
    'alsaziani',
    'alsaziano',
    'alse',
    'alsi',
    'alta',
    'altabella',
    'altacassa',
    'altai',
    'altaica',
    'altaiche',
    'altaici',
    'altaico',
    'altalena',
    'altalenai',
    'altalenammo',
    'altalenando',
    'altalenano',
    'altalenante',
    'altalenanti',
    'altalenare',
    'altalenarono',
    'altalenasse',
    'altalenassi',
    'altalenaste',
    'altalenasti',
    'altalenata',
    'altalenate',
    'altalenati',
    'altalenato',
    'altalenava',
    'altalenavamo',
    'altalenavano',
    'altalenavate',
    'altalenavi',
    'altalenavo',
    'altalene',
    'altalenera',
    'altalenerai',
    'altalenerei',
    'altaleneremo',
    'altalenerete',
    'altalenero',
    'altaleni',
    'altaleniamo',
    'altaleniate',
    'altalenino',
    'altaleno',
    'altamente',
    'altamura',
    'altamurana',
    'altamurane',
    'altamurani',
    'altamurano',
    'altana',
    'altane',
    'altante',
    'altare',
    'altari',
    'altarini',
    'altarino',
    'altavilla',
    'altavillo',
    'alte',
    'altea',
    'altecasse',
    'altee',
    'altemio',
    'alteo',
    'alter',
    'altera',
    'alterabile',
    'alterabili',
    'alterabilita',
    'alterai',
    'alteramente',
    'alteramenti',
    'alteramento',
    'alterammo',
    'alterando',
    'alterandoci',
    'alterandola',
    'alterandole',
    'alterandoli',
    'alterandolo',
    'alterandomi',
    'alterandone',
    'alterandosi',
    'alterandoti',
    'alterandovi',
    'alterano',
    'alterante',
    'alteranti',
    'alterantisi',
    'alterarci',
    'alterare',
    'alterarla',
    'alterarle',
    'alterarli',
    'alterarlo',
    'alterarmi',
    'alterarne',
    'alterarono',
    'alterarsi',
    'alterarti',
    'alterarvi',
    'alterasse',
    'alterassero',
    'alterassi',
    'alterassimo',
    'alteraste',
    'alterasti',
    'alterata',
    'alterate',
    'alteratevi',
    'alterati',
    'alterativa',
    'alterative',
    'alterativi',
    'alterativo',
    'alterato',
    'alteratomi',
    'alteratoti',
    'alterava',
    'alteravamo',
    'alteravano',
    'alteravate',
    'alteravi',
    'alteravo',
    'alterazione',
    'alterazioni',
    'alterca',
    'altercai',
    'altercammo',
    'altercando',
    'altercano',
    'altercante',
    'altercanti',
    'altercare',
    'altercarono',
    'altercasse',
    'altercassero',
    'altercassi',
    'altercassimo',
    'altercaste',
    'altercasti',
    'altercata',
    'altercate',
    'altercati',
    'altercato',
    'altercatore',
    'altercatori',
    'altercatrice',
    'altercatrici',
    'altercava',
    'altercavamo',
    'altercavano',
    'altercavate',
    'altercavi',
    'altercavo',
    'altercazione',
    'altercazioni',
    'alterchera',
    'altercherai',
    'altercherei',
    'altercheremo',
    'altercherete',
    'alterchero',
    'alterchi',
    'alterchiamo',
    'alterchiate',
    'alterchino',
    'alterco',
    'altere',
    'alterera',
    'altererai',
    'altereranno',
    'altererebbe',
    'altererei',
    'altereremmo',
    'altereremo',
    'alterereste',
    'altereresti',
    'altererete',
    'alterero',
    'alterezza',
    'alterezze',
    'alteri',
    'alteria',
    'alteriamo',
    'alteriamoci',
    'alteriate',
    'alterige',
    'alterigia',
    'alterigie',
    'alterino',
    'alterio',
    'alterita',
    'alterità',
    'alterna',
    'alternai',
    'alternamente',
    'alternammo',
    'alternando',
    'alternandoci',
    'alternandomi',
    'alternandosi',
    'alternandoti',
    'alternandovi',
    'alternano',
    'alternante',
    'alternanti',
    'alternantisi',
    'alternanza',
    'alternanze',
    'alternarci',
    'alternare',
    'alternaria',
    'alternarmi',
    'alternarono',
    'alternarsi',
    'alternarti',
    'alternarvi',
    'alternasse',
    'alternassero',
    'alternassi',
    'alternassimo',
    'alternaste',
    'alternasti',
    'alternata',
    'alternate',
    'alternatevi',
    'alternati',
    'alternativa',
    'alternative',
    'alternativi',
    'alternativo',
    'alternato',
    'alternatomi',
    'alternatore',
    'alternatori',
    'alternatoti',
    'alternava',
    'alternavamo',
    'alternavano',
    'alternavate',
    'alternavi',
    'alternavo',
    'alternazione',
    'alternazioni',
    'alterne',
    'alternera',
    'alternerai',
    'alterneranno',
    'alternerebbe',
    'alternerei',
    'alterneremmo',
    'alterneremo',
    'alternereste',
    'alterneresti',
    'alternerete',
    'alternero',
    'alterni',
    'alterniamo',
    'alterniamoci',
    'alterniate',
    'alternino',
    'alterno',
    'altero',
    'altezza',
    'altezze',
    'altezzosa',
    'altezzose',
    'altezzosi',
    'altezzosita',
    'altezzosità',
    'altezzoso',
    'alti',
    'altica',
    'alticce',
    'alticci',
    'alticcia',
    'alticcio',
    'altiche',
    'altiera',
    'altiere',
    'altierezza',
    'altieri',
    'altiero',
    'altiforni',
    'altimetri',
    'altimetria',
    'altimetrica',
    'altimetriche',
    'altimetrici',
    'altimetrico',
    'altimetrie',
    'altimetro',
    'altimiro',
    'altina',
    'altine',
    'altini',
    'altino',
    'altipiani',
    'altipiano',
    'altiporti',
    'altiporto',
    'altisonante',
    'altisonanti',
    'altissima',
    'altissime',
    'altissimi',
    'altissimo',
    'altistrati',
    'altitonante',
    'altitonanti',
    'altitudine',
    'altitudini',
    'alto',
    'altoatesina',
    'altoatesine',
    'altoatesini',
    'altoatesino',
    'altobello',
    'altobrando',
    'altocumuli',
    'altocumulo',
    'altoforni',
    'altoforno',
    'altola',
    'altolocata',
    'altolocate',
    'altolocati',
    'altolocato',
    'altomare',
    'altomira',
    'altomiro',
    'altoparlante',
    'altoparlanti',
    'altopiani',
    'altopiano',
    'altoporti',
    'altoporto',
    'altore',
    'altori',
    'altorilievi',
    'altorilievo',
    'altorino',
    'altosonante',
    'altosonanti',
    'altostrati',
    'altostrato',
    'altr',
    'altra',
    'altramente',
    'altramenti',
    'altre',
    'altresi',
    'altressi',
    'altresì',
    'altrettale',
    'altrettali',
    'altrettanta',
    'altrettante',
    'altrettanti',
    'altrettanto',
    'altri',
    'altrice',
    'altrici',
    'altrieri',
    'altrimenti',
    'altro',
    'altroche',
    'altroché',
    'altroieri',
    'altronde',
    'altrove',
    'altrui',
    'altruismi',
    'altruismo',
    'altruista',
    'altruiste',
    'altruisti',
    'altruistica',
    'altruistiche',
    'altruistici',
    'altruistico',
    'altucce',
    'altucci',
    'altuccia',
    'altuccio',
    'altura',
    'alture',
    'alturiera',
    'alturiere',
    'alturieri',
    'alturiero',
    'aluatta',
    'aluatte',
    'alucce',
    'aluccia',
    'alucita',
    'alucite',
    'alula',
    'alule',
    'alunite',
    'aluniti',
    'alunna',
    'alunnati',
    'alunnato',
    'alunne',
    'alunni',
    'alunno',
    'alurgia',
    'alvara',
    'alvarina',
    'alvarino',
    'alvario',
    'alvaro',
    'alveale',
    'alveali',
    'alveante',
    'alveare',
    'alveari',
    'alvei',
    'alveo',
    'alveolante',
    'alveolare',
    'alveolari',
    'alveolata',
    'alveolate',
    'alveolati',
    'alveolato',
    'alveoli',
    'alveolite',
    'alveoliti',
    'alveolo',
    'alvezio',
    'alvi',
    'alvina',
    'alvine',
    'alvini',
    'alvino',
    'alvisa',
    'alvise',
    'alvisia',
    'alvisio',
    'alviso',
    'alvo',
    'alza',
    'alzabandiera',
    'alzabile',
    'alzabili',
    'alzagola',
    'alzagole',
    'alzai',
    'alzaia',
    'alzaie',
    'alzamenti',
    'alzamento',
    'alzammo',
    'alzando',
    'alzandoci',
    'alzandola',
    'alzandole',
    'alzandoli',
    'alzandolo',
    'alzandomi',
    'alzandone',
    'alzandosi',
    'alzandoti',
    'alzandovi',
    'alzano',
    'alzante',
    'alzanti',
    'alzantisi',
    'alzar',
    'alzarci',
    'alzare',
    'alzarla',
    'alzarle',
    'alzarli',
    'alzarlo',
    'alzarmi',
    'alzarne',
    'alzarono',
    'alzarsi',
    'alzarti',
    'alzarvi',
    'alzasse',
    'alzassero',
    'alzassi',
    'alzassimo',
    'alzaste',
    'alzasti',
    'alzata',
    'alzatacce',
    'alzataccia',
    'alzatasi',
    'alzate',
    'alzatesi',
    'alzatevi',
    'alzati',
    'alzatina',
    'alzatine',
    'alzatisi',
    'alzato',
    'alzatomi',
    'alzatore',
    'alzatori',
    'alzatosi',
    'alzatoti',
    'alzatrice',
    'alzatrici',
    'alzava',
    'alzavalvola',
    'alzavamo',
    'alzavano',
    'alzavate',
    'alzavi',
    'alzavo',
    'alzavola',
    'alzavole',
    'alzera',
    'alzerai',
    'alzeranno',
    'alzerebbe',
    'alzerebbero',
    'alzerei',
    'alzeremmo',
    'alzeremo',
    'alzereste',
    'alzeresti',
    'alzerete',
    'alzero',
    'alzheimer',
    'alzi',
    'alziamo',
    'alziamoci',
    'alziate',
    'alzino',
    'alzo',
    'alzò',
    'amabile',
    'amabili',
    'amabilia',
    'amabilio',
    'amabilita',
    'amabilità',
    'amabilmente',
    'amaca',
    'amache',
    'amaddio',
    'amadea',
    'amadeo',
    'amadia',
    'amadio',
    'amadore',
    'amadriade',
    'amadriadi',
    'amagnetica',
    'amagnetiche',
    'amagnetici',
    'amagnetico',
    'amai',
    'amala',
    'amale',
    'amalfa',
    'amalfi',
    'amalfia',
    'amalfio',
    'amalfitana',
    'amalfitane',
    'amalfitani',
    'amalfitano',
    'amalfo',
    'amalgama',
    'amalgamai',
    'amalgamammo',
    'amalgamando',
    'amalgamano',
    'amalgamante',
    'amalgamanti',
    'amalgamarci',
    'amalgamare',
    'amalgamarla',
    'amalgamarle',
    'amalgamarli',
    'amalgamarlo',
    'amalgamarmi',
    'amalgamarono',
    'amalgamarsi',
    'amalgamarti',
    'amalgamarvi',
    'amalgamasse',
    'amalgamassi',
    'amalgamaste',
    'amalgamasti',
    'amalgamata',
    'amalgamate',
    'amalgamatevi',
    'amalgamati',
    'amalgamato',
    'amalgamatomi',
    'amalgamatoti',
    'amalgamava',
    'amalgamavamo',
    'amalgamavano',
    'amalgamavate',
    'amalgamavi',
    'amalgamavo',
    'amalgamera',
    'amalgamerai',
    'amalgamerei',
    'amalgameremo',
    'amalgamerete',
    'amalgamero',
    'amalgami',
    'amalgamiamo',
    'amalgamiate',
    'amalgamino',
    'amalgamo',
    'amali',
    'amalia',
    'amalio',
    'amalo',
    'amamelidacea',
    'amamelidacee',
    'amamelidale',
    'amamelidali',
    'amamelide',
    'amamelidi',
    'amami',
    'amammo',
    'amanda',
    'amandina',
    'amandino',
    'amando',
    'amandoci',
    'amandola',
    'amandole',
    'amandoli',
    'amandolo',
    'amandomi',
    'amandone',
    'amandosi',
    'amandoti',
    'amandovi',
    'amanita',
    'amanite',
    'amano',
    'amante',
    'amantea',
    'amanti',
    'amantigli',
    'amantiglio',
    'amantina',
    'amantino',
    'amantisi',
    'amanto',
    'amanuense',
    'amanuensi',
    'amanza',
    'amanze',
    'amanzia',
    'amanzio',
    'amar',
    'amara',
    'amaramente',
    'amarando',
    'amaranta',
    'amarantacea',
    'amarantacee',
    'amaranti',
    'amarantina',
    'amarantine',
    'amarantini',
    'amarantino',
    'amaranto',
    'amarasca',
    'amarascata',
    'amarascate',
    'amarascati',
    'amarascato',
    'amarasche',
    'amaraschi',
    'amarasco',
    'amarci',
    'amarcord',
    'amare',
    'amareggera',
    'amareggerai',
    'amareggerei',
    'amareggeremo',
    'amareggerete',
    'amareggero',
    'amareggi',
    'amareggia',
    'amareggiai',
    'amareggiammo',
    'amareggiamo',
    'amareggiando',
    'amareggiano',
    'amareggiante',
    'amareggianti',
    'amareggiarci',
    'amareggiare',
    'amareggiarla',
    'amareggiarle',
    'amareggiarli',
    'amareggiarlo',
    'amareggiarmi',
    'amareggiarsi',
    'amareggiarti',
    'amareggiarvi',
    'amareggiasse',
    'amareggiassi',
    'amareggiaste',
    'amareggiasti',
    'amareggiata',
    'amareggiate',
    'amareggiati',
    'amareggiato',
    'amareggiava',
    'amareggiavi',
    'amareggiavo',
    'amareggino',
    'amareggio',
    'amarella',
    'amarelle',
    'amarena',
    'amarene',
    'amareni',
    'amareno',
    'amaretta',
    'amarette',
    'amaretti',
    'amaretto',
    'amarevole',
    'amarevoli',
    'amarezza',
    'amarezze',
    'amari',
    'amarica',
    'amaricai',
    'amaricammo',
    'amaricando',
    'amaricano',
    'amaricante',
    'amaricanti',
    'amaricare',
    'amaricarono',
    'amaricasse',
    'amaricassero',
    'amaricassi',
    'amaricassimo',
    'amaricaste',
    'amaricasti',
    'amaricata',
    'amaricate',
    'amaricati',
    'amaricato',
    'amaricava',
    'amaricavamo',
    'amaricavano',
    'amaricavate',
    'amaricavi',
    'amaricavo',
    'amariche',
    'amarichera',
    'amaricherai',
    'amaricherei',
    'amaricheremo',
    'amaricherete',
    'amarichero',
    'amarichi',
    'amarichiamo',
    'amarichiate',
    'amarichino',
    'amarici',
    'amarico',
    'amarilda',
    'amarilli',
    'amarillide',
    'amarillidi',
    'amario',
    'amarissima',
    'amarissimo',
    'amaritudine',
    'amaritudini',
    'amarla',
    'amarle',
    'amarli',
    'amarlo',
    'amarmi',
    'amarne',
    'amaro',
    'amarogno',
    'amarognola',
    'amarognole',
    'amarognoli',
    'amarognolo',
    'amarone',
    'amaroni',
    'amarono',
    'amarore',
    'amarori',
    'amarra',
    'amarraggio',
    'amarrando',
    'amarrare',
    'amarrato',
    'amarre',
    'amarsi',
    'amarti',
    'amartoma',
    'amartosi',
    'amaru',
    'amarulenta',
    'amarulente',
    'amarulenti',
    'amarulento',
    'amarume',
    'amarumi',
    'amarvi',
    'amasi',
    'amasia',
    'amasie',
    'amasio',
    'amasse',
    'amassero',
    'amassi',
    'amassimo',
    'amaste',
    'amasti',
    'amata',
    'amate',
    'amateli',
    'amateur',
    'amatevi',
    'amati',
    'amatino',
    'amatissima',
    'amatissime',
    'amatissimi',
    'amatissimo',
    'amatista',
    'amatisto',
    'amato',
    'amatomi',
    'amatore',
    'amatori',
    'amatoria',
    'amatoriale',
    'amatoriali',
    'amatorie',
    'amatorio',
    'amatoti',
    'amatrice',
    'amatrici',
    'amatriciana',
    'amatriciane',
    'amatriciani',
    'amatriciano',
    'amatuccio',
    'amaurosi',
    'amaurotica',
    'amaurotiche',
    'amaurotici',
    'amaurotico',
    'amava',
    'amavamo',
    'amavano',
    'amavate',
    'amavi',
    'amavo',
    'amazzone',
    'amazzoni',
    'amazzonia',
    'amazzoniana',
    'amazzoniane',
    'amazzoniani',
    'amazzoniano',
    'amazzonica',
    'amazzoniche',
    'amazzonici',
    'amazzonico',
    'amazzonie',
    'amazzonio',
    'amazzonite',
    'amazzoniti',
    'amba',
    'ambage',
    'ambagi',
    'ambarvali',
    'ambarvalie',
    'ambasce',
    'ambasceria',
    'ambascerie',
    'ambascia',
    'ambasciadore',
    'ambasciadori',
    'ambasciata',
    'ambasciate',
    'ambasciatore',
    'ambasciatori',
    'ambasciosa',
    'ambasciose',
    'ambasciosi',
    'ambascioso',
    'ambata',
    'ambate',
    'ambe',
    'ambedue',
    'ambedui',
    'ambeduo',
    'ambendo',
    'ambente',
    'ambenti',
    'amberlite',
    'amberliti',
    'amberta',
    'amberto',
    'ambi',
    'ambia',
    'ambiadura',
    'ambiadure',
    'ambiai',
    'ambiammo',
    'ambiamo',
    'ambiando',
    'ambianese',
    'ambianesi',
    'ambiano',
    'ambiante',
    'ambianti',
    'ambiare',
    'ambiarono',
    'ambiasse',
    'ambiassero',
    'ambiassi',
    'ambiassimo',
    'ambiaste',
    'ambiasti',
    'ambiata',
    'ambiate',
    'ambiati',
    'ambiato',
    'ambiatore',
    'ambiatori',
    'ambiatrice',
    'ambiatrici',
    'ambiatura',
    'ambiature',
    'ambiava',
    'ambiavamo',
    'ambiavano',
    'ambiavate',
    'ambiavi',
    'ambiavo',
    'ambidestra',
    'ambidestre',
    'ambidestri',
    'ambidestro',
    'ambidue',
    'ambienta',
    'ambientacci',
    'ambientaccio',
    'ambientai',
    'ambientale',
    'ambientali',
    'ambientammo',
    'ambientando',
    'ambientano',
    'ambientante',
    'ambientanti',
    'ambientarci',
    'ambientare',
    'ambientarla',
    'ambientarle',
    'ambientarli',
    'ambientarlo',
    'ambientarmi',
    'ambientarono',
    'ambientarsi',
    'ambientarti',
    'ambientarvi',
    'ambientasse',
    'ambientassi',
    'ambientaste',
    'ambientasti',
    'ambientata',
    'ambientate',
    'ambientatevi',
    'ambientati',
    'ambientato',
    'ambientatomi',
    'ambientatore',
    'ambientatori',
    'ambientatoti',
    'ambientava',
    'ambientavamo',
    'ambientavano',
    'ambientavate',
    'ambientavi',
    'ambientavo',
    'ambiente',
    'ambientera',
    'ambienterai',
    'ambienterei',
    'ambienteremo',
    'ambienterete',
    'ambientero',
    'ambienti',
    'ambientiamo',
    'ambientiate',
    'ambientini',
    'ambientino',
    'ambientista',
    'ambientiste',
    'ambientisti',
    'ambiento',
    'ambiera',
    'ambierai',
    'ambieranno',
    'ambierebbe',
    'ambierebbero',
    'ambierei',
    'ambieremmo',
    'ambieremo',
    'ambiereste',
    'ambieresti',
    'ambierete',
    'ambiero',
    'ambigenere',
    'ambigeneri',
    'ambigua',
    'ambiguamente',
    'ambigue',
    'ambigui',
    'ambiguita',
    'ambiguità',
    'ambiguo',
    'ambii',
    'ambimmo',
    'ambino',
    'ambio',
    'ambipolare',
    'ambipolari',
    'ambira',
    'ambirai',
    'ambiranno',
    'ambire',
    'ambirebbe',
    'ambirebbero',
    'ambirei',
    'ambiremmo',
    'ambiremo',
    'ambireste',
    'ambiresti',
    'ambirete',
    'ambiro',
    'ambirono',
    'ambisca',
    'ambiscano',
    'ambisce',
    'ambisci',
    'ambisco',
    'ambiscono',
    'ambisse',
    'ambissero',
    'ambissi',
    'ambissimo',
    'ambiste',
    'ambisti',
    'ambita',
    'ambite',
    'ambiti',
    'ambito',
    'ambiva',
    'ambivalente',
    'ambivalenti',
    'ambivalenza',
    'ambivalenze',
    'ambivamo',
    'ambivano',
    'ambivate',
    'ambivi',
    'ambivo',
    'ambizione',
    'ambizioni',
    'ambiziosa',
    'ambiziose',
    'ambiziosi',
    'ambizioso',
    'ambliope',
    'ambliopi',
    'ambliopia',
    'ambliopica',
    'ambliopiche',
    'ambliopici',
    'ambliopico',
    'ambliopie',
    'amblioscopi',
    'amblioscopio',
    'ambo',
    'ambodue',
    'ambone',
    'amboni',
    'ambosessi',
    'ambosesso',
    'ambra',
    'ambrata',
    'ambrate',
    'ambrati',
    'ambrato',
    'ambre',
    'ambretta',
    'ambrette',
    'ambro',
    'ambrogetta',
    'ambrogette',
    'ambrogia',
    'ambrogina',
    'ambrogine',
    'ambrogini',
    'ambrogino',
    'ambrogio',
    'ambrosi',
    'ambrosia',
    'ambrosiana',
    'ambrosiane',
    'ambrosiani',
    'ambrosiano',
    'ambrosie',
    'ambrosina',
    'ambrosini',
    'ambrosino',
    'ambrosio',
    'ambula',
    'ambulacrale',
    'ambulacrali',
    'ambulacri',
    'ambulacro',
    'ambulai',
    'ambulammo',
    'ambulando',
    'ambulano',
    'ambulantati',
    'ambulantato',
    'ambulante',
    'ambulanti',
    'ambulanza',
    'ambulanze',
    'ambulare',
    'ambularono',
    'ambulasse',
    'ambulassero',
    'ambulassi',
    'ambulassimo',
    'ambulaste',
    'ambulasti',
    'ambulata',
    'ambulate',
    'ambulati',
    'ambulato',
    'ambulatori',
    'ambulatoria',
    'ambulatorie',
    'ambulatorio',
    'ambulava',
    'ambulavamo',
    'ambulavano',
    'ambulavate',
    'ambulavi',
    'ambulavo',
    'ambulazione',
    'ambulazioni',
    'ambulera',
    'ambulerai',
    'ambuleranno',
    'ambulerebbe',
    'ambulerei',
    'ambuleremmo',
    'ambuleremo',
    'ambulereste',
    'ambuleresti',
    'ambulerete',
    'ambulero',
    'ambuli',
    'ambuliamo',
    'ambuliate',
    'ambulino',
    'ambulo',
    'amburghese',
    'amburghesi',
    'amburgo',
    'ambystoma',
    'ameba',
    'amebe',
    'amebea',
    'amebee',
    'amebei',
    'amebeo',
    'amebiasi',
    'amebica',
    'amebiche',
    'amebici',
    'amebico',
    'ameboide',
    'ameboidi',
    'amedea',
    'amedeo',
    'ameglia',
    'ameglio',
    'amelanotico',
    'amelia',
    'amelie',
    'amelina',
    'amelino',
    'amelio',
    'amelita',
    'amelli',
    'amello',
    'amelogenesi',
    'amen',
    'amena',
    'amenamente',
    'amendue',
    'amene',
    'ameni',
    'amenita',
    'amenità',
    'ameno',
    'amenorrea',
    'amenorree',
    'amensalismi',
    'amensalismo',
    'amentata',
    'amentate',
    'amentati',
    'amentato',
    'amenti',
    'amento',
    'amenza',
    'amenze',
    'amenziale',
    'amenziali',
    'amera',
    'amerai',
    'ameranno',
    'amerasiatica',
    'amerasiatici',
    'amerasiatico',
    'amerebbe',
    'amerebbero',
    'amerei',
    'ameremmo',
    'ameremo',
    'amereste',
    'ameresti',
    'amerete',
    'america',
    'americana',
    'americanata',
    'americanate',
    'americane',
    'americani',
    'americanismi',
    'americanismo',
    'americanista',
    'americaniste',
    'americanisti',
    'americanita',
    'americanizza',
    'americanizzi',
    'americanizzo',
    'americano',
    'americanus',
    'americhe',
    'americi',
    'americio',
    'americo',
    'ameriga',
    'amerigo',
    'amerikana',
    'amerikane',
    'amerikani',
    'amerikano',
    'amerina',
    'amerinda',
    'amerindi',
    'amerindia',
    'amerindiana',
    'amerindiane',
    'amerindiani',
    'amerindiano',
    'amerindie',
    'amerindio',
    'amerindo',
    'amerine',
    'amerini',
    'amerino',
    'amerio',
    'amero',
    'ametabola',
    'ametabole',
    'ametaboli',
    'ametabolo',
    'ametista',
    'ametiste',
    'ametistina',
    'ametistine',
    'ametistini',
    'ametistino',
    'ametrope',
    'ametropi',
    'ametropia',
    'ametropie',
    'amfetamina',
    'amfetamine',
    'amfi',
    'amhara',
    'amiamo',
    'amiamoci',
    'amianti',
    'amianto',
    'amiate',
    'amica',
    'amicabile',
    'amicabili',
    'amicai',
    'amicale',
    'amicali',
    'amicalmente',
    'amicammo',
    'amicando',
    'amicandosi',
    'amicano',
    'amicante',
    'amicanti',
    'amicare',
    'amicarelli',
    'amicarono',
    'amicarsi',
    'amicasse',
    'amicassero',
    'amicassi',
    'amicassimo',
    'amicaste',
    'amicasti',
    'amicata',
    'amicate',
    'amicati',
    'amicato',
    'amicava',
    'amicavamo',
    'amicavano',
    'amicavate',
    'amicavi',
    'amicavo',
    'amiche',
    'amichera',
    'amicherai',
    'amicheranno',
    'amicherebbe',
    'amicherei',
    'amicheremmo',
    'amicheremo',
    'amichereste',
    'amicheresti',
    'amicherete',
    'amichero',
    'amichetta',
    'amichette',
    'amichetti',
    'amichetto',
    'amichevole',
    'amichevoli',
    'amichi',
    'amichiamo',
    'amichiate',
    'amichino',
    'amici',
    'amicissima',
    'amicissime',
    'amicissimi',
    'amicissimo',
    'amicizia',
    'amicizie',
    'amico',
    'amicone',
    'amiconi',
    'amicrobica',
    'amicrobiche',
    'amicrobici',
    'amicrobico',
    'amida',
    'amidacea',
    'amidacee',
    'amidacei',
    'amidaceo',
    'amidatore',
    'amidatori',
    'amidatrice',
    'amidatrici',
    'amidatura',
    'amidature',
    'amide',
    'amidi',
    'amidica',
    'amidiche',
    'amidici',
    'amidico',
    'amido',
    'amiens',
    'amigdala',
    'amigdale',
    'amigdaliana',
    'amigdaliane',
    'amigdaliani',
    'amigdaliano',
    'amigdalina',
    'amigdaline',
    'amigdalite',
    'amigdaliti',
    'amigdaloide',
    'amigdaloidi',
    'amilacea',
    'amilacee',
    'amilacei',
    'amilaceo',
    'amilasemia',
    'amilasemie',
    'amilasi',
    'amilasuria',
    'amilasurie',
    'amilcara',
    'amilcare',
    'amile',
    'amili',
    'amilo',
    'amiloide',
    'amiloidi',
    'amiloidosi',
    'amiloplasti',
    'amiloplasto',
    'amilopsina',
    'amilopsine',
    'amimia',
    'amimie',
    'amina',
    'aminda',
    'amine',
    'aminica',
    'aminiche',
    'aminici',
    'aminico',
    'amino',
    'aminoacidi',
    'aminoacidica',
    'aminoacido',
    'aminopirina',
    'aminta',
    'aminto',
    'amintore',
    'amiotassia',
    'amiotrofia',
    'amiotrofica',
    'amiotrofie',
    'amista',
    'amistade',
    'amistanza',
    'amistanze',
    'amistate',
    'amitosi',
    'amitotica',
    'amitotiche',
    'amitotici',
    'amitotico',
    'amitti',
    'amitto',
    'amleta',
    'amletica',
    'amletiche',
    'amletici',
    'amletico',
    'amletismi',
    'amletismo',
    'amleto',
    'amlira',
    'amlire',
    'ammaca',
    'ammacai',
    'ammacammo',
    'ammacando',
    'ammacano',
    'ammacare',
    'ammacarono',
    'ammacasse',
    'ammacassi',
    'ammacaste',
    'ammacasti',
    'ammacata',
    'ammacate',
    'ammacati',
    'ammacato',
    'ammacava',
    'ammacavamo',
    'ammacavano',
    'ammacavate',
    'ammacavi',
    'ammacavo',
    'ammacca',
    'ammaccabile',
    'ammaccabili',
    'ammaccai',
    'ammaccamenti',
    'ammaccamento',
    'ammaccammo',
    'ammaccando',
    'ammaccandoci',
    'ammaccandola',
    'ammaccandolo',
    'ammaccandomi',
    'ammaccandosi',
    'ammaccandoti',
    'ammaccandovi',
    'ammaccano',
    'ammaccante',
    'ammaccanti',
    'ammaccantisi',
    'ammaccarci',
    'ammaccare',
    'ammaccarla',
    'ammaccarlo',
    'ammaccarmi',
    'ammaccarono',
    'ammaccarsi',
    'ammaccarti',
    'ammaccarvi',
    'ammaccasse',
    'ammaccassero',
    'ammaccassi',
    'ammaccassimo',
    'ammaccaste',
    'ammaccasti',
    'ammaccata',
    'ammaccate',
    'ammaccatevi',
    'ammaccati',
    'ammaccato',
    'ammaccatomi',
    'ammaccatoti',
    'ammaccatura',
    'ammaccature',
    'ammaccava',
    'ammaccavamo',
    'ammaccavano',
    'ammaccavate',
    'ammaccavi',
    'ammaccavo',
    'ammacchera',
    'ammaccherai',
    'ammaccherei',
    'ammaccheremo',
    'ammaccherete',
    'ammacchero',
    'ammacchi',
    'ammacchiamo',
    'ammacchiate',
    'ammacchino',
    'ammacco',
    'ammachera',
    'ammacherai',
    'ammacherei',
    'ammachero',
    'ammachi',
    'ammachiamo',
    'ammachiate',
    'ammachino',
    'ammaco',
    'ammaestra',
    'ammaestrai',
    'ammaestrammo',
    'ammaestrando',
    'ammaestrano',
    'ammaestrante',
    'ammaestranti',
    'ammaestrare',
    'ammaestrarmi',
    'ammaestrasse',
    'ammaestrassi',
    'ammaestraste',
    'ammaestrasti',
    'ammaestrata',
    'ammaestrate',
    'ammaestrati',
    'ammaestrato',
    'ammaestrava',
    'ammaestravi',
    'ammaestravo',
    'ammaestrera',
    'ammaestrerai',
    'ammaestrerei',
    'ammaestrero',
    'ammaestri',
    'ammaestriamo',
    'ammaestriate',
    'ammaestrino',
    'ammaestro',
    'ammagli',
    'ammaglia',
    'ammagliai',
    'ammagliammo',
    'ammagliamo',
    'ammagliando',
    'ammagliano',
    'ammagliante',
    'ammaglianti',
    'ammagliare',
    'ammagliarono',
    'ammagliasse',
    'ammagliassi',
    'ammagliaste',
    'ammagliasti',
    'ammagliata',
    'ammagliate',
    'ammagliati',
    'ammagliato',
    'ammagliatore',
    'ammagliatori',
    'ammagliatura',
    'ammagliature',
    'ammagliava',
    'ammagliavamo',
    'ammagliavano',
    'ammagliavate',
    'ammagliavi',
    'ammagliavo',
    'ammagliera',
    'ammaglierai',
    'ammaglierei',
    'ammaglieremo',
    'ammaglierete',
    'ammagliero',
    'ammaglino',
    'ammaglio',
    'ammaina',
    'ammainai',
    'ammainammo',
    'ammainando',
    'ammainandola',
    'ammainandole',
    'ammainandoli',
    'ammainandolo',
    'ammainano',
    'ammainante',
    'ammainanti',
    'ammainare',
    'ammainarla',
    'ammainarle',
    'ammainarli',
    'ammainarlo',
    'ammainarono',
    'ammainasse',
    'ammainassero',
    'ammainassi',
    'ammainassimo',
    'ammainaste',
    'ammainasti',
    'ammainata',
    'ammainate',
    'ammainati',
    'ammainato',
    'ammainava',
    'ammainavamo',
    'ammainavano',
    'ammainavate',
    'ammainavi',
    'ammainavo',
    'ammainera',
    'ammainerai',
    'ammaineranno',
    'ammainerebbe',
    'ammainerei',
    'ammaineremmo',
    'ammaineremo',
    'ammainereste',
    'ammaineresti',
    'ammainerete',
    'ammainero',
    'ammaini',
    'ammainiamo',
    'ammainiate',
    'ammainino',
    'ammaino',
    'ammala',
    'ammalai',
    'ammalammo',
    'ammalando',
    'ammalandoci',
    'ammalandomi',
    'ammalandosi',
    'ammalandoti',
    'ammalandovi',
    'ammalano',
    'ammalante',
    'ammalanti',
    'ammalantisi',
    'ammalarci',
    'ammalare',
    'ammalarmi',
    'ammalarono',
    'ammalarsi',
    'ammalarti',
    'ammalarvi',
    'ammalasse',
    'ammalassero',
    'ammalassi',
    'ammalassimo',
    'ammalaste',
    'ammalasti',
    'ammalata',
    'ammalate',
    'ammalatevi',
    'ammalati',
    'ammalato',
    'ammalatomi',
    'ammalatoti',
    'ammalava',
    'ammalavamo',
    'ammalavano',
    'ammalavate',
    'ammalavi',
    'ammalavo',
    'ammalazza',
    'ammalazzai',
    'ammalazzammo',
    'ammalazzando',
    'ammalazzano',
    'ammalazzante',
    'ammalazzanti',
    'ammalazzarci',
    'ammalazzare',
    'ammalazzarmi',
    'ammalazzarsi',
    'ammalazzarti',
    'ammalazzarvi',
    'ammalazzasse',
    'ammalazzassi',
    'ammalazzaste',
    'ammalazzasti',
    'ammalazzata',
    'ammalazzate',
    'ammalazzati',
    'ammalazzato',
    'ammalazzava',
    'ammalazzavi',
    'ammalazzavo',
    'ammalazzera',
    'ammalazzerai',
    'ammalazzerei',
    'ammalazzero',
    'ammalazzi',
    'ammalazziamo',
    'ammalazziate',
    'ammalazzino',
    'ammalazzo',
    'ammalera',
    'ammalerai',
    'ammaleranno',
    'ammalerebbe',
    'ammalerei',
    'ammaleremmo',
    'ammaleremo',
    'ammalereste',
    'ammaleresti',
    'ammalerete',
    'ammalero',
    'ammali',
    'ammalia',
    'ammaliai',
    'ammaliamenti',
    'ammaliamento',
    'ammaliammo',
    'ammaliamo',
    'ammaliamoci',
    'ammaliando',
    'ammaliandoci',
    'ammaliandola',
    'ammaliandole',
    'ammaliandoli',
    'ammaliandolo',
    'ammaliandomi',
    'ammaliandoti',
    'ammaliandovi',
    'ammaliano',
    'ammaliante',
    'ammalianti',
    'ammaliarci',
    'ammaliare',
    'ammaliarla',
    'ammaliarle',
    'ammaliarli',
    'ammaliarlo',
    'ammaliarmi',
    'ammaliarono',
    'ammaliarti',
    'ammaliarvi',
    'ammaliasse',
    'ammaliassero',
    'ammaliassi',
    'ammaliassimo',
    'ammaliaste',
    'ammaliasti',
    'ammaliata',
    'ammaliate',
    'ammaliati',
    'ammaliato',
    'ammaliatore',
    'ammaliatori',
    'ammaliatrice',
    'ammaliatrici',
    'ammaliatura',
    'ammaliava',
    'ammaliavamo',
    'ammaliavano',
    'ammaliavate',
    'ammaliavi',
    'ammaliavo',
    'ammaliera',
    'ammalierai',
    'ammalieranno',
    'ammalierebbe',
    'ammalierei',
    'ammalieremmo',
    'ammalieremo',
    'ammaliereste',
    'ammalieresti',
    'ammalierete',
    'ammaliero',
    'ammalinconi',
    'ammalinconii',
    'ammalino',
    'ammalio',
    'ammalizi',
    'ammalizia',
    'ammaliziai',
    'ammaliziammo',
    'ammaliziamo',
    'ammaliziando',
    'ammaliziano',
    'ammaliziante',
    'ammalizianti',
    'ammaliziarci',
    'ammaliziare',
    'ammaliziarmi',
    'ammaliziarsi',
    'ammaliziarti',
    'ammaliziarvi',
    'ammaliziasse',
    'ammaliziassi',
    'ammaliziaste',
    'ammaliziasti',
    'ammaliziata',
    'ammaliziate',
    'ammaliziati',
    'ammaliziato',
    'ammaliziava',
    'ammaliziavi',
    'ammaliziavo',
    'ammaliziera',
    'ammalizierai',
    'ammalizierei',
    'ammaliziero',
    'ammalizino',
    'ammalizio',
    'ammalizzendo',
    'ammalizzente',
    'ammalizzenti',
    'ammalizzi',
    'ammalizziamo',
    'ammalizziate',
    'ammalizzii',
    'ammalizzimmo',
    'ammalizzira',
    'ammalizzirai',
    'ammalizzire',
    'ammalizzirei',
    'ammalizziro',
    'ammalizzisca',
    'ammalizzisce',
    'ammalizzisci',
    'ammalizzisco',
    'ammalizzisse',
    'ammalizzissi',
    'ammalizziste',
    'ammalizzisti',
    'ammalizzita',
    'ammalizzite',
    'ammalizziti',
    'ammalizzito',
    'ammalizziva',
    'ammalizzivi',
    'ammalizzivo',
    'ammalo',
    'ammammola',
    'ammammolai',
    'ammammolano',
    'ammammolarci',
    'ammammolarmi',
    'ammammolarsi',
    'ammammolarti',
    'ammammolarvi',
    'ammammolata',
    'ammammolate',
    'ammammolati',
    'ammammolato',
    'ammammoli',
    'ammammoliamo',
    'ammammoliate',
    'ammammolino',
    'ammammolo',
    'ammanchi',
    'ammanco',
    'ammandorlata',
    'ammandorlate',
    'ammandorlati',
    'ammandorlato',
    'ammanetta',
    'ammanettai',
    'ammanettammo',
    'ammanettando',
    'ammanettano',
    'ammanettante',
    'ammanettanti',
    'ammanettare',
    'ammanettarla',
    'ammanettarle',
    'ammanettarli',
    'ammanettarlo',
    'ammanettasse',
    'ammanettassi',
    'ammanettaste',
    'ammanettasti',
    'ammanettata',
    'ammanettate',
    'ammanettati',
    'ammanettato',
    'ammanettava',
    'ammanettavi',
    'ammanettavo',
    'ammanettera',
    'ammanetterai',
    'ammanetterei',
    'ammanettero',
    'ammanetti',
    'ammanettiamo',
    'ammanettiate',
    'ammanettino',
    'ammanetto',
    'ammanica',
    'ammanicai',
    'ammanicammo',
    'ammanicando',
    'ammanicano',
    'ammanicarci',
    'ammanicare',
    'ammanicarmi',
    'ammanicarono',
    'ammanicarsi',
    'ammanicarti',
    'ammanicarvi',
    'ammanicasse',
    'ammanicassi',
    'ammanicaste',
    'ammanicasti',
    'ammanicata',
    'ammanicate',
    'ammanicatevi',
    'ammanicati',
    'ammanicato',
    'ammanicatomi',
    'ammanicatoti',
    'ammanicava',
    'ammanicavamo',
    'ammanicavano',
    'ammanicavate',
    'ammanicavi',
    'ammanicavo',
    'ammanichera',
    'ammanicherai',
    'ammanicherei',
    'ammanichero',
    'ammanichi',
    'ammanichiamo',
    'ammanichiate',
    'ammanichino',
    'ammanico',
    'ammaniera',
    'ammanierai',
    'ammanierammo',
    'ammanierando',
    'ammanierano',
    'ammanierante',
    'ammanieranti',
    'ammanierare',
    'ammanierarla',
    'ammanierarle',
    'ammanierarli',
    'ammanierarlo',
    'ammanierasse',
    'ammanierassi',
    'ammanieraste',
    'ammanierasti',
    'ammanierata',
    'ammanierate',
    'ammanierati',
    'ammanierato',
    'ammanierava',
    'ammanieravi',
    'ammanieravo',
    'ammanierera',
    'ammaniererai',
    'ammaniererei',
    'ammanierero',
    'ammanieri',
    'ammanieriamo',
    'ammanieriate',
    'ammanierino',
    'ammaniero',
    'ammanigli',
    'ammaniglia',
    'ammanigliai',
    'ammanigliamo',
    'ammanigliano',
    'ammanigliare',
    'ammanigliata',
    'ammanigliate',
    'ammanigliati',
    'ammanigliato',
    'ammanigliava',
    'ammanigliavi',
    'ammanigliavo',
    'ammanigliera',
    'ammanigliero',
    'ammaniglino',
    'ammaniglio',
    'ammanisca',
    'ammaniscano',
    'ammanisce',
    'ammanisci',
    'ammanisco',
    'ammaniscono',
    'ammanna',
    'ammannai',
    'ammannammo',
    'ammannando',
    'ammannano',
    'ammannante',
    'ammannanti',
    'ammannare',
    'ammannarono',
    'ammannasse',
    'ammannassero',
    'ammannassi',
    'ammannassimo',
    'ammannaste',
    'ammannasti',
    'ammannata',
    'ammannate',
    'ammannati',
    'ammannato',
    'ammannava',
    'ammannavamo',
    'ammannavano',
    'ammannavate',
    'ammannavi',
    'ammannavo',
    'ammannella',
    'ammannellano',
    'ammannellare',
    'ammannellata',
    'ammannellate',
    'ammannellati',
    'ammannellato',
    'ammannendo',
    'ammannente',
    'ammannenti',
    'ammannera',
    'ammannerai',
    'ammanneranno',
    'ammannerebbe',
    'ammannerei',
    'ammanneremmo',
    'ammanneremo',
    'ammannereste',
    'ammanneresti',
    'ammannerete',
    'ammannero',
    'ammanni',
    'ammanniamo',
    'ammanniate',
    'ammannii',
    'ammannimmo',
    'ammannino',
    'ammannira',
    'ammannirai',
    'ammanniranno',
    'ammannire',
    'ammannirebbe',
    'ammannirei',
    'ammanniremmo',
    'ammanniremo',
    'ammannireste',
    'ammanniresti',
    'ammannirete',
    'ammannirli',
    'ammanniro',
    'ammannirono',
    'ammannisca',
    'ammanniscano',
    'ammannisce',
    'ammannisci',
    'ammannisco',
    'ammanniscono',
    'ammannisse',
    'ammannissero',
    'ammannissi',
    'ammannissimo',
    'ammanniste',
    'ammannisti',
    'ammannita',
    'ammannite',
    'ammanniti',
    'ammannito',
    'ammannitura',
    'ammanniture',
    'ammanniva',
    'ammannivamo',
    'ammannivano',
    'ammannivate',
    'ammannivi',
    'ammannivo',
    'ammanno',
    'ammansa',
    'ammansai',
    'ammansammo',
    'ammansando',
    'ammansandoci',
    'ammansandomi',
    'ammansandosi',
    'ammansandoti',
    'ammansandovi',
    'ammansano',
    'ammansante',
    'ammansanti',
    'ammansantisi',
    'ammansarci',
    'ammansare',
    'ammansarmi',
    'ammansarono',
    'ammansarsi',
    'ammansarti',
    'ammansarvi',
    'ammansasse',
    'ammansassero',
    'ammansassi',
    'ammansassimo',
    'ammansaste',
    'ammansasti',
    'ammansata',
    'ammansate',
    'ammansatevi',
    'ammansati',
    'ammansato',
    'ammansatomi',
    'ammansatore',
    'ammansatori',
    'ammansatoti',
    'ammansatrice',
    'ammansatrici',
    'ammansava',
    'ammansavamo',
    'ammansavano',
    'ammansavate',
    'ammansavi',
    'ammansavo',
    'ammansendo',
    'ammansendoci',
    'ammansendola',
    'ammansendole',
    'ammansendoli',
    'ammansendolo',
    'ammansendomi',
    'ammansendosi',
    'ammansendoti',
    'ammansendovi',
    'ammansente',
    'ammansenti',
    'ammansentisi',
    'ammansera',
    'ammanserai',
    'ammanseranno',
    'ammanserebbe',
    'ammanserei',
    'ammanseremmo',
    'ammanseremo',
    'ammansereste',
    'ammanseresti',
    'ammanserete',
    'ammansero',
    'ammansi',
    'ammansiamo',
    'ammansiamoci',
    'ammansiate',
    'ammansii',
    'ammansimmo',
    'ammansino',
    'ammansira',
    'ammansirai',
    'ammansiranno',
    'ammansirci',
    'ammansire',
    'ammansirebbe',
    'ammansirei',
    'ammansiremmo',
    'ammansiremo',
    'ammansireste',
    'ammansiresti',
    'ammansirete',
    'ammansirla',
    'ammansirle',
    'ammansirli',
    'ammansirlo',
    'ammansirmi',
    'ammansiro',
    'ammansirono',
    'ammansirsi',
    'ammansirti',
    'ammansirvi',
    'ammansisca',
    'ammansiscano',
    'ammansisce',
    'ammansisci',
    'ammansisciti',
    'ammansisco',
    'ammansiscono',
    'ammansisse',
    'ammansissero',
    'ammansissi',
    'ammansissimo',
    'ammansiste',
    'ammansisti',
    'ammansita',
    'ammansite',
    'ammansitevi',
    'ammansiti',
    'ammansito',
    'ammansitomi',
    'ammansitoti',
    'ammansiva',
    'ammansivamo',
    'ammansivano',
    'ammansivate',
    'ammansivi',
    'ammansivo',
    'ammanso',
    'ammanta',
    'ammantai',
    'ammantammo',
    'ammantando',
    'ammantandoci',
    'ammantandomi',
    'ammantandosi',
    'ammantandoti',
    'ammantandovi',
    'ammantano',
    'ammantante',
    'ammantanti',
    'ammantantisi',
    'ammantarci',
    'ammantare',
    'ammantarmi',
    'ammantarono',
    'ammantarsi',
    'ammantarti',
    'ammantarvi',
    'ammantasse',
    'ammantassero',
    'ammantassi',
    'ammantassimo',
    'ammantaste',
    'ammantasti',
    'ammantata',
    'ammantate',
    'ammantatevi',
    'ammantati',
    'ammantato',
    'ammantatomi',
    'ammantatoti',
    'ammantatura',
    'ammantature',
    'ammantava',
    'ammantavamo',
    'ammantavano',
    'ammantavate',
    'ammantavi',
    'ammantavo',
    'ammantella',
    'ammantellai',
    'ammantellano',
    'ammantellare',
    'ammantellata',
    'ammantellate',
    'ammantellati',
    'ammantellato',
    'ammantellava',
    'ammantellavi',
    'ammantellavo',
    'ammantellera',
    'ammantellero',
    'ammantelli',
    'ammantellino',
    'ammantello',
    'ammantera',
    'ammanterai',
    'ammanteranno',
    'ammanterebbe',
    'ammanterei',
    'ammanteremmo',
    'ammanteremo',
    'ammantereste',
    'ammanteresti',
    'ammanterete',
    'ammantero',
    'ammanti',
    'ammantiamo',
    'ammantiamoci',
    'ammantiate',
    'ammantino',
    'ammanto',
    'ammappa',
    'ammappalo',
    'ammappelo',
    'ammappete',
    'ammara',
    'ammaraggi',
    'ammaraggio',
    'ammarai',
    'ammaramenti',
    'ammaramento',
    'ammarammo',
    'ammarando',
    'ammarano',
    'ammarante',
    'ammaranti',
    'ammarare',
    'ammararono',
    'ammarasse',
    'ammarassero',
    'ammarassi',
    'ammarassimo',
    'ammaraste',
    'ammarasti',
    'ammarata',
    'ammarate',
    'ammarati',
    'ammarato',
    'ammarava',
    'ammaravamo',
    'ammaravano',
    'ammaravate',
    'ammaravi',
    'ammaravo',
    'ammarera',
    'ammarerai',
    'ammareranno',
    'ammarerebbe',
    'ammarerei',
    'ammareremmo',
    'ammareremo',
    'ammarereste',
    'ammareresti',
    'ammarerete',
    'ammarero',
    'ammari',
    'ammariamo',
    'ammariate',
    'ammarino',
    'ammaro',
    'ammarra',
    'ammarraggi',
    'ammarraggio',
    'ammarrai',
    'ammarrammo',
    'ammarrando',
    'ammarrano',
    'ammarrante',
    'ammarranti',
    'ammarrare',
    'ammarrarono',
    'ammarrasse',
    'ammarrassero',
    'ammarrassi',
    'ammarrassimo',
    'ammarraste',
    'ammarrasti',
    'ammarrata',
    'ammarrate',
    'ammarrati',
    'ammarrato',
    'ammarrava',
    'ammarravamo',
    'ammarravano',
    'ammarravate',
    'ammarravi',
    'ammarravo',
    'ammarrera',
    'ammarrerai',
    'ammarreranno',
    'ammarrerebbe',
    'ammarrerei',
    'ammarreremmo',
    'ammarreremo',
    'ammarrereste',
    'ammarreresti',
    'ammarrerete',
    'ammarrero',
    'ammarri',
    'ammarriamo',
    'ammarriate',
    'ammarrino',
    'ammarro',
    'ammassa',
    'ammassai',
    'ammassamenti',
    'ammassamento',
    'ammassammo',
    'ammassando',
    'ammassandoci',
    'ammassandomi',
    'ammassandosi',
    'ammassandoti',
    'ammassandovi',
    'ammassano',
    'ammassante',
    'ammassanti',
    'ammassantisi',
    'ammassarano',
    'ammassarci',
    'ammassare',
    'ammassarmi',
    'ammassarono',
    'ammassarsi',
    'ammassarti',
    'ammassarvi',
    'ammassasse',
    'ammassassero',
    'ammassassi',
    'ammassassimo',
    'ammassaste',
    'ammassasti',
    'ammassata',
    'ammassate',
    'ammassatevi',
    'ammassati',
    'ammassato',
    'ammassatomi',
    'ammassatore',
    'ammassatori',
    'ammassatoti',
    'ammassatrice',
    'ammassatrici',
    'ammassava',
    'ammassavamo',
    'ammassavano',
    'ammassavate',
    'ammassavi',
    'ammassavo',
    'ammassella',
    'ammassellai',
    'ammassellano',
    'ammassellare',
    'ammassellata',
    'ammassellate',
    'ammassellati',
    'ammassellato',
    'ammassellava',
    'ammassellavi',
    'ammassellavo',
    'ammassellera',
    'ammassellero',
    'ammasselli',
    'ammassellino',
    'ammassello',
    'ammassera',
    'ammasserai',
    'ammasseranno',
    'ammasserebbe',
    'ammasserei',
    'ammasseremmo',
    'ammasseremo',
    'ammassereste',
    'ammasseresti',
    'ammasserete',
    'ammassero',
    'ammassi',
    'ammassiamo',
    'ammassiamoci',
    'ammassiate',
    'ammassiccera',
    'ammassiccero',
    'ammassicci',
    'ammassiccia',
    'ammassicciai',
    'ammassiccino',
    'ammassiccio',
    'ammassino',
    'ammasso',
    'ammatassa',
    'ammatassai',
    'ammatassammo',
    'ammatassando',
    'ammatassano',
    'ammatassante',
    'ammatassanti',
    'ammatassare',
    'ammatassasse',
    'ammatassassi',
    'ammatassaste',
    'ammatassasti',
    'ammatassata',
    'ammatassate',
    'ammatassati',
    'ammatassato',
    'ammatassava',
    'ammatassavi',
    'ammatassavo',
    'ammatassera',
    'ammatasserai',
    'ammatasserei',
    'ammatassero',
    'ammatassi',
    'ammatassiamo',
    'ammatassiate',
    'ammatassino',
    'ammatasso',
    'ammattendo',
    'ammattendoci',
    'ammattendomi',
    'ammattendosi',
    'ammattendoti',
    'ammattendovi',
    'ammattente',
    'ammattenti',
    'ammattentisi',
    'ammatti',
    'ammattiamo',
    'ammattiamoci',
    'ammattiate',
    'ammattii',
    'ammattimenti',
    'ammattimento',
    'ammattimmo',
    'ammattira',
    'ammattirai',
    'ammattiranno',
    'ammattirci',
    'ammattire',
    'ammattirebbe',
    'ammattirei',
    'ammattiremmo',
    'ammattiremo',
    'ammattireste',
    'ammattiresti',
    'ammattirete',
    'ammattirmi',
    'ammattiro',
    'ammattirono',
    'ammattirsi',
    'ammattirti',
    'ammattirvi',
    'ammattisca',
    'ammattiscano',
    'ammattisce',
    'ammattisci',
    'ammattisciti',
    'ammattisco',
    'ammattiscono',
    'ammattisse',
    'ammattissero',
    'ammattissi',
    'ammattissimo',
    'ammattiste',
    'ammattisti',
    'ammattita',
    'ammattite',
    'ammattitevi',
    'ammattiti',
    'ammattito',
    'ammattitomi',
    'ammattitoti',
    'ammattiva',
    'ammattivamo',
    'ammattivano',
    'ammattivate',
    'ammattivi',
    'ammattivo',
    'ammattona',
    'ammattonai',
    'ammattonammo',
    'ammattonando',
    'ammattonano',
    'ammattonante',
    'ammattonanti',
    'ammattonare',
    'ammattonasse',
    'ammattonassi',
    'ammattonaste',
    'ammattonasti',
    'ammattonata',
    'ammattonate',
    'ammattonati',
    'ammattonato',
    'ammattonava',
    'ammattonavi',
    'ammattonavo',
    'ammattonera',
    'ammattonerai',
    'ammattonerei',
    'ammattonero',
    'ammattoni',
    'ammattoniamo',
    'ammattoniate',
    'ammattonino',
    'ammattono',
    'ammazza',
    'ammazzacaffe',
    'ammazzai',
    'ammazzala',
    'ammazzale',
    'ammazzali',
    'ammazzalo',
    'ammazzamenti',
    'ammazzamento',
    'ammazzammo',
    'ammazzando',
    'ammazzandoci',
    'ammazzandola',
    'ammazzandole',
    'ammazzandoli',
    'ammazzandolo',
    'ammazzandomi',
    'ammazzandone',
    'ammazzandosi',
    'ammazzandoti',
    'ammazzandovi',
    'ammazzano',
    'ammazzante',
    'ammazzanti',
    'ammazzantisi',
    'ammazzarci',
    'ammazzare',
    'ammazzarla',
    'ammazzarle',
    'ammazzarli',
    'ammazzarlo',
    'ammazzarmi',
    'ammazzarne',
    'ammazzarono',
    'ammazzarsi',
    'ammazzarti',
    'ammazzarvi',
    'ammazzasette',
    'ammazzasse',
    'ammazzassero',
    'ammazzassi',
    'ammazzassimo',
    'ammazzaste',
    'ammazzasti',
    'ammazzata',
    'ammazzate',
    'ammazzatela',
    'ammazzatele',
    'ammazzateli',
    'ammazzatelo',
    'ammazzatemi',
    'ammazzatevi',
    'ammazzati',
    'ammazzatisi',
    'ammazzato',
    'ammazzatoi',
    'ammazzatoio',
    'ammazzatomi',
    'ammazzatore',
    'ammazzatori',
    'ammazzatoti',
    'ammazzatrice',
    'ammazzatrici',
    'ammazzatura',
    'ammazzature',
    'ammazzava',
    'ammazzavamo',
    'ammazzavano',
    'ammazzavate',
    'ammazzavi',
    'ammazzavo',
    'ammazzelo',
    'ammazzera',
    'ammazzerai',
    'ammazzeranno',
    'ammazzerebbe',
    'ammazzerei',
    'ammazzeremmo',
    'ammazzeremo',
    'ammazzereste',
    'ammazzeresti',
    'ammazzerete',
    'ammazzero',
    'ammazzete',
    'ammazzi',
    'ammazziamo',
    'ammazziamoci',
    'ammazziate',
    'ammazzino',
    'ammazzo',
    'ammelmando',
    'ammelmare',
    'ammelmata',
    'ammelmate',
    'ammelmati',
    'ammelmato',
    'ammen',
    'ammencendo',
    'ammencente',
    'ammencenti',
    'ammenci',
    'ammenciamo',
    'ammenciate',
    'ammencii',
    'ammencimmo',
    'ammencira',
    'ammencirai',
    'ammenciranno',
    'ammencire',
    'ammencirebbe',
    'ammencirei',
    'ammenciremmo',
    'ammenciremo',
    'ammencireste',
    'ammenciresti',
    'ammencirete',
    'ammenciro',
    'ammencirono',
    'ammencisca',
    'ammenciscano',
    'ammencisce',
    'ammencisci',
    'ammencisco',
    'ammenciscono',
    'ammencisse',
    'ammencissero',
    'ammencissi',
    'ammencissimo',
    'ammenciste',
    'ammencisti',
    'ammencita',
    'ammencite',
    'ammenciti',
    'ammencito',
    'ammenciva',
    'ammencivamo',
    'ammencivano',
    'ammencivate',
    'ammencivi',
    'ammencivo',
    'ammenda',
    'ammendai',
    'ammendamenti',
    'ammendamento',
    'ammendammo',
    'ammendando',
    'ammendandoci',
    'ammendandomi',
    'ammendandosi',
    'ammendandoti',
    'ammendandovi',
    'ammendano',
    'ammendante',
    'ammendanti',
    'ammendantisi',
    'ammendarci',
    'ammendare',
    'ammendarmi',
    'ammendarono',
    'ammendarsi',
    'ammendarti',
    'ammendarvi',
    'ammendasse',
    'ammendassero',
    'ammendassi',
    'ammendassimo',
    'ammendaste',
    'ammendasti',
    'ammendata',
    'ammendate',
    'ammendatevi',
    'ammendati',
    'ammendato',
    'ammendatomi',
    'ammendatoti',
    'ammendava',
    'ammendavamo',
    'ammendavano',
    'ammendavate',
    'ammendavi',
    'ammendavo',
    'ammende',
    'ammendera',
    'ammenderai',
    'ammenderanno',
    'ammenderebbe',
    'ammenderei',
    'ammenderemmo',
    'ammenderemo',
    'ammendereste',
    'ammenderesti',
    'ammenderete',
    'ammendero',
    'ammendi',
    'ammendiamo',
    'ammendiamoci',
    'ammendiate',
    'ammendino',
    'ammendo',
    'ammennicola',
    'ammennicolai',
    'ammennicoli',
    'ammennicolo',
    'ammessa',
    'ammesse',
    'ammessi',
    'ammesso',
    'ammesta',
    'ammestai',
    'ammestammo',
    'ammestando',
    'ammestano',
    'ammestante',
    'ammestanti',
    'ammestare',
    'ammestarono',
    'ammestasse',
    'ammestassero',
    'ammestassi',
    'ammestassimo',
    'ammestaste',
    'ammestasti',
    'ammestata',
    'ammestate',
    'ammestati',
    'ammestato',
    'ammestava',
    'ammestavamo',
    'ammestavano',
    'ammestavate',
    'ammestavi',
    'ammestavo',
    'ammestera',
    'ammesterai',
    'ammesteranno',
    'ammesterebbe',
    'ammesterei',
    'ammesteremmo',
    'ammesteremo',
    'ammestereste',
    'ammesteresti',
    'ammesterete',
    'ammestero',
    'ammesti',
    'ammestiamo',
    'ammestiate',
    'ammestino',
    'ammesto',
    'ammestona',
    'ammestone',
    'ammestoni',
    'ammeta',
    'ammetai',
    'ammetammo',
    'ammetando',
    'ammetano',
    'ammetante',
    'ammetanti',
    'ammetare',
    'ammetarono',
    'ammetasse',
    'ammetassero',
    'ammetassi',
    'ammetassimo',
    'ammetaste',
    'ammetasti',
    'ammetata',
    'ammetate',
    'ammetati',
    'ammetato',
    'ammetava',
    'ammetavamo',
    'ammetavano',
    'ammetavate',
    'ammetavi',
    'ammetavo',
    'ammetera',
    'ammeterai',
    'ammeteranno',
    'ammeterebbe',
    'ammeterei',
    'ammeteremmo',
    'ammeteremo',
    'ammetereste',
    'ammeteresti',
    'ammeterete',
    'ammetero',
    'ammeti',
    'ammetiamo',
    'ammetiate',
    'ammetino',
    'ammeto',
    'ammetta',
    'ammettano',
    'ammette',
    'ammettemmo',
    'ammettendo',
    'ammettendoci',
    'ammettendola',
    'ammettendole',
    'ammettendoli',
    'ammettendolo',
    'ammettendomi',
    'ammettendoti',
    'ammettendovi',
    'ammettente',
    'ammettenti',
    'ammettenza',
    'ammettenze',
    'ammettera',
    'ammetterai',
    'ammetteranno',
    'ammetterci',
    'ammettere',
    'ammetterebbe',
    'ammetterei',
    'ammetteremmo',
    'ammetteremo',
    'ammettereste',
    'ammetteresti',
    'ammetterete',
    'ammetterla',
    'ammetterle',
    'ammetterli',
    'ammetterlo',
    'ammettermi',
    'ammetterne',
    'ammettero',
    'ammetterti',
    'ammettervi',
    'ammettesse',
    'ammettessero',
    'ammettessi',
    'ammettessimo',
    'ammetteste',
    'ammettesti',
    'ammettete',
    'ammettetela',
    'ammettetele',
    'ammetteteli',
    'ammettetelo',
    'ammetteva',
    'ammettevamo',
    'ammettevano',
    'ammettevate',
    'ammettevi',
    'ammettevo',
    'ammetti',
    'ammettiamo',
    'ammettiamola',
    'ammettiamole',
    'ammettiamoli',
    'ammettiamolo',
    'ammettiate',
    'ammettila',
    'ammettile',
    'ammettili',
    'ammettilo',
    'ammetto',
    'ammettono',
    'ammezza',
    'ammezzai',
    'ammezzamenti',
    'ammezzamento',
    'ammezzammo',
    'ammezzando',
    'ammezzano',
    'ammezzante',
    'ammezzanti',
    'ammezzare',
    'ammezzarono',
    'ammezzasse',
    'ammezzassero',
    'ammezzassi',
    'ammezzassimo',
    'ammezzaste',
    'ammezzasti',
    'ammezzata',
    'ammezzate',
    'ammezzati',
    'ammezzato',
    'ammezzava',
    'ammezzavamo',
    'ammezzavano',
    'ammezzavate',
    'ammezzavi',
    'ammezzavo',
    'ammezzendo',
    'ammezzendoci',
    'ammezzendomi',
    'ammezzendosi',
    'ammezzendoti',
    'ammezzendovi',
    'ammezzente',
    'ammezzenti',
    'ammezzentisi',
    'ammezzera',
    'ammezzerai',
    'ammezzeranno',
    'ammezzerebbe',
    'ammezzerei',
    'ammezzeremmo',
    'ammezzeremo',
    'ammezzereste',
    'ammezzeresti',
    'ammezzerete',
    'ammezzero',
    'ammezzi',
    'ammezziamo',
    'ammezziamoci',
    'ammezziate',
    'ammezzii',
    'ammezzimenti',
    'ammezzimento',
    'ammezzimmo',
    'ammezzino',
    'ammezzira',
    'ammezzirai',
    'ammezziranno',
    'ammezzirci',
    'ammezzire',
    'ammezzirebbe',
    'ammezzirei',
    'ammezziremmo',
    'ammezziremo',
    'ammezzireste',
    'ammezziresti',
    'ammezzirete',
    'ammezzirmi',
    'ammezziro',
    'ammezzirono',
    'ammezzirsi',
    'ammezzirti',
    'ammezzirvi',
    'ammezzisca',
    'ammezziscano',
    'ammezzisce',
    'ammezzisci',
    'ammezzisciti',
    'ammezzisco',
    'ammezziscono',
    'ammezzisse',
    'ammezzissero',
    'ammezzissi',
    'ammezzissimo',
    'ammezziste',
    'ammezzisti',
    'ammezzita',
    'ammezzite',
    'ammezzitevi',
    'ammezziti',
    'ammezzito',
    'ammezzitomi',
    'ammezzitoti',
    'ammezziva',
    'ammezzivamo',
    'ammezzivano',
    'ammezzivate',
    'ammezzivi',
    'ammezzivo',
    'ammezzo',
    'ammicca',
    'ammiccai',
    'ammiccamenti',
    'ammiccamento',
    'ammiccammo',
    'ammiccando',
    'ammiccandole',
    'ammiccano',
    'ammiccante',
    'ammiccanti',
    'ammiccare',
    'ammiccarono',
    'ammiccasse',
    'ammiccassero',
    'ammiccassi',
    'ammiccassimo',
    'ammiccaste',
    'ammiccasti',
    'ammiccata',
    'ammiccate',
    'ammiccati',
    'ammiccato',
    'ammiccava',
    'ammiccavamo',
    'ammiccavano',
    'ammiccavate',
    'ammiccavi',
    'ammiccavo',
    'ammicchera',
    'ammiccherai',
    'ammiccherei',
    'ammiccheremo',
    'ammiccherete',
    'ammicchero',
    'ammicchi',
    'ammicchiamo',
    'ammicchiate',
    'ammicchino',
    'ammicco',
    'ammide',
    'ammidi',
    'ammidica',
    'ammidiche',
    'ammidici',
    'ammidico',
    'ammina',
    'amminazione',
    'ammine',
    'amminica',
    'amminiche',
    'amminici',
    'amminico',
    'amminicola',
    'amminicolare',
    'amminicole',
    'amminicoli',
    'amminicolo',
    'amministra',
    'amministrai',
    'amministrano',
    'amministrare',
    'amministrata',
    'amministrate',
    'amministrati',
    'amministrato',
    'amministrava',
    'amministravi',
    'amministravo',
    'amministrera',
    'amministrero',
    'amministri',
    'amministrino',
    'amministro',
    'ammino',
    'amminoacidi',
    'amminoacido',
    'amminoalcol',
    'amminoplasti',
    'amminoplasto',
    'amminuta',
    'amminutai',
    'amminutammo',
    'amminutando',
    'amminutano',
    'amminutante',
    'amminutanti',
    'amminutare',
    'amminutarono',
    'amminutasse',
    'amminutassi',
    'amminutaste',
    'amminutasti',
    'amminutata',
    'amminutate',
    'amminutati',
    'amminutato',
    'amminutava',
    'amminutavamo',
    'amminutavano',
    'amminutavate',
    'amminutavi',
    'amminutavo',
    'amminutera',
    'amminuterai',
    'amminuterei',
    'amminuteremo',
    'amminuterete',
    'amminutero',
    'amminuti',
    'amminutiamo',
    'amminutiate',
    'amminutino',
    'amminuto',
    'ammira',
    'ammirabile',
    'ammirabili',
    'ammiragli',
    'ammiraglia',
    'ammiragliati',
    'ammiragliato',
    'ammiraglie',
    'ammiraglio',
    'ammirai',
    'ammirammo',
    'ammiranda',
    'ammirande',
    'ammirandi',
    'ammirando',
    'ammirandoci',
    'ammirandola',
    'ammirandole',
    'ammirandoli',
    'ammirandolo',
    'ammirandomi',
    'ammirandone',
    'ammirandosi',
    'ammirandoti',
    'ammirandovi',
    'ammirano',
    'ammirante',
    'ammiranti',
    'ammirantisi',
    'ammirar',
    'ammirarci',
    'ammirare',
    'ammirarla',
    'ammirarle',
    'ammirarli',
    'ammirarlo',
    'ammirarmi',
    'ammirarne',
    'ammirarono',
    'ammirarsi',
    'ammirarti',
    'ammirarvi',
    'ammirasse',
    'ammirassero',
    'ammirassi',
    'ammirassimo',
    'ammiraste',
    'ammirasti',
    'ammirata',
    'ammirate',
    'ammiratevi',
    'ammirati',
    'ammirativa',
    'ammirative',
    'ammirativi',
    'ammirativo',
    'ammirato',
    'ammiratomi',
    'ammiratore',
    'ammiratori',
    'ammiratoti',
    'ammiratrice',
    'ammiratrici',
    'ammirava',
    'ammiravamo',
    'ammiravano',
    'ammiravate',
    'ammiravi',
    'ammiravo',
    'ammirazione',
    'ammirazioni',
    'ammirera',
    'ammirerai',
    'ammireranno',
    'ammirerebbe',
    'ammirerei',
    'ammireremmo',
    'ammireremo',
    'ammirereste',
    'ammireresti',
    'ammirerete',
    'ammirero',
    'ammirevole',
    'ammirevoli',
    'ammiri',
    'ammiriamo',
    'ammiriamoci',
    'ammiriate',
    'ammirino',
    'ammiro',
    'ammise',
    'ammiserendo',
    'ammiserente',
    'ammiserenti',
    'ammiseri',
    'ammiseriamo',
    'ammiseriate',
    'ammiserii',
    'ammiserimmo',
    'ammiserira',
    'ammiserirai',
    'ammiserire',
    'ammiserirei',
    'ammiseriremo',
    'ammiserirete',
    'ammiseriro',
    'ammiserirono',
    'ammiserisca',
    'ammiserisce',
    'ammiserisci',
    'ammiserisco',
    'ammiserisse',
    'ammiserissi',
    'ammiseriste',
    'ammiseristi',
    'ammiserita',
    'ammiserite',
    'ammiseriti',
    'ammiserito',
    'ammiseriva',
    'ammiserivamo',
    'ammiserivano',
    'ammiserivate',
    'ammiserivi',
    'ammiserivo',
    'ammisero',
    'ammisi',
    'ammissibile',
    'ammissibili',
    'ammissione',
    'ammissioni',
    'ammittanza',
    'ammittanze',
    'ammobili',
    'ammobilia',
    'ammobiliai',
    'ammobiliammo',
    'ammobiliamo',
    'ammobiliando',
    'ammobiliano',
    'ammobiliante',
    'ammobilianti',
    'ammobiliare',
    'ammobiliasse',
    'ammobiliassi',
    'ammobiliaste',
    'ammobiliasti',
    'ammobiliata',
    'ammobiliate',
    'ammobiliati',
    'ammobiliato',
    'ammobiliava',
    'ammobiliavi',
    'ammobiliavo',
    'ammobiliera',
    'ammobilierai',
    'ammobilierei',
    'ammobiliero',
    'ammobilino',
    'ammobilio',
    'ammoderna',
    'ammodernai',
    'ammodernammo',
    'ammodernando',
    'ammodernano',
    'ammodernante',
    'ammodernanti',
    'ammodernarci',
    'ammodernare',
    'ammodernarmi',
    'ammodernarsi',
    'ammodernarti',
    'ammodernarvi',
    'ammodernasse',
    'ammodernassi',
    'ammodernaste',
    'ammodernasti',
    'ammodernata',
    'ammodernate',
    'ammodernati',
    'ammodernato',
    'ammodernava',
    'ammodernavi',
    'ammodernavo',
    'ammodernera',
    'ammodernerai',
    'ammodernerei',
    'ammodernero',
    'ammoderni',
    'ammoderniamo',
    'ammoderniate',
    'ammodernino',
    'ammoderno',
    'ammodino',
    'ammodite',
    'ammoditi',
    'ammodo',
    'ammofila',
    'ammofile',
    'ammofili',
    'ammofilo',
    'ammogli',
    'ammoglia',
    'ammogliai',
    'ammogliammo',
    'ammogliamo',
    'ammogliamoci',
    'ammogliando',
    'ammogliano',
    'ammogliante',
    'ammoglianti',
    'ammogliarci',
    'ammogliare',
    'ammogliarmi',
    'ammogliaron',
    'ammogliarono',
    'ammogliarsi',
    'ammogliarti',
    'ammogliarvi',
    'ammogliasse',
    'ammogliassi',
    'ammogliaste',
    'ammogliasti',
    'ammogliata',
    'ammogliate',
    'ammogliatevi',
    'ammogliati',
    'ammogliato',
    'ammogliatomi',
    'ammogliatoti',
    'ammogliava',
    'ammogliavamo',
    'ammogliavano',
    'ammogliavate',
    'ammogliavi',
    'ammogliavo',
    'ammogliera',
    'ammoglierai',
    'ammoglierei',
    'ammoglieremo',
    'ammoglierete',
    'ammogliero',
    'ammoglino',
    'ammoglio',
    'ammoina',
    'ammoinai',
    'ammoinammo',
    'ammoinando',
    'ammoinano',
    'ammoinante',
    'ammoinanti',
    'ammoinare',
    'ammoinarono',
    'ammoinasse',
    'ammoinassero',
    'ammoinassi',
    'ammoinassimo',
    'ammoinaste',
    'ammoinasti',
    'ammoinata',
    'ammoinate',
    'ammoinati',
    'ammoinato',
    'ammoinava',
    'ammoinavamo',
    'ammoinavano',
    'ammoinavate',
    'ammoinavi',
    'ammoinavo',
    'ammoinera',
    'ammoinerai',
    'ammoineranno',
    'ammoinerebbe',
    'ammoinerei',
    'ammoineremmo',
    'ammoineremo',
    'ammoinereste',
    'ammoineresti',
    'ammoinerete',
    'ammoinero',
    'ammoini',
    'ammoiniamo',
    'ammoiniate',
    'ammoinino',
    'ammoino',
    'ammolla',
    'ammollai',
    'ammollamenti',
    'ammollamento',
    'ammollammo',
    'ammollando',
    'ammollandoci',
    'ammollandomi',
    'ammollandosi',
    'ammollandoti',
    'ammollandovi',
    'ammollano',
    'ammollante',
    'ammollanti',
    'ammollantisi',
    'ammollarci',
    'ammollare',
    'ammollarmi',
    'ammollarono',
    'ammollarsi',
    'ammollarti',
    'ammollarvi',
    'ammollasse',
    'ammollassero',
    'ammollassi',
    'ammollassimo',
    'ammollaste',
    'ammollasti',
    'ammollata',
    'ammollate',
    'ammollatevi',
    'ammollati',
    'ammollato',
    'ammollatomi',
    'ammollatoti',
    'ammollava',
    'ammollavamo',
    'ammollavano',
    'ammollavate',
    'ammollavi',
    'ammollavo',
    'ammollendo',
    'ammollendoci',
    'ammollendomi',
    'ammollendosi',
    'ammollendoti',
    'ammollendovi',
    'ammollente',
    'ammollenti',
    'ammollentisi',
    'ammollera',
    'ammollerai',
    'ammolleranno',
    'ammollerebbe',
    'ammollerei',
    'ammolleremmo',
    'ammolleremo',
    'ammollereste',
    'ammolleresti',
    'ammollerete',
    'ammollero',
    'ammolli',
    'ammolliamo',
    'ammolliamoci',
    'ammolliate',
    'ammollii',
    'ammollimenti',
    'ammollimento',
    'ammollimmo',
    'ammollino',
    'ammollira',
    'ammollirai',
    'ammolliranno',
    'ammollirci',
    'ammollire',
    'ammollirebbe',
    'ammollirei',
    'ammolliremmo',
    'ammolliremo',
    'ammollireste',
    'ammolliresti',
    'ammollirete',
    'ammollirmi',
    'ammolliro',
    'ammollirono',
    'ammollirsi',
    'ammollirti',
    'ammollirvi',
    'ammollisca',
    'ammolliscano',
    'ammollisce',
    'ammollisci',
    'ammollisciti',
    'ammollisco',
    'ammolliscono',
    'ammollisse',
    'ammollissero',
    'ammollissi',
    'ammollissimo',
    'ammolliste',
    'ammollisti',
    'ammollita',
    'ammollite',
    'ammollitevi',
    'ammolliti',
    'ammollito',
    'ammollitomi',
    'ammollitoti',
    'ammolliva',
    'ammollivamo',
    'ammollivano',
    'ammollivate',
    'ammollivi',
    'ammollivo',
    'ammollo',
    'ammone',
    'ammonendo',
    'ammonendoci',
    'ammonendola',
    'ammonendole',
    'ammonendoli',
    'ammonendolo',
    'ammonendomi',
    'ammonendoti',
    'ammonendovi',
    'ammonente',
    'ammonenti',
    'ammoni',
    'ammoniaca',
    'ammoniacale',
    'ammoniacali',
    'ammoniacata',
    'ammoniacate',
    'ammoniacati',
    'ammoniacato',
    'ammoniache',
    'ammoniaci',
    'ammoniaco',
    'ammoniamo',
    'ammoniate',
    'ammonica',
    'ammoniche',
    'ammonici',
    'ammonico',
    'ammonii',
    'ammonimenti',
    'ammonimento',
    'ammonimmo',
    'ammonio',
    'ammonira',
    'ammonirai',
    'ammoniranno',
    'ammonirci',
    'ammonire',
    'ammonirebbe',
    'ammonirei',
    'ammoniremmo',
    'ammoniremo',
    'ammonireste',
    'ammoniresti',
    'ammonirete',
    'ammonirla',
    'ammonirle',
    'ammonirli',
    'ammonirlo',
    'ammonirmi',
    'ammoniro',
    'ammonirono',
    'ammonirti',
    'ammonirvi',
    'ammonisca',
    'ammoniscano',
    'ammonisce',
    'ammonisci',
    'ammonisco',
    'ammoniscomo',
    'ammoniscono',
    'ammonisse',
    'ammonissero',
    'ammonissi',
    'ammonissimo',
    'ammoniste',
    'ammonisti',
    'ammonita',
    'ammonite',
    'ammoniti',
    'ammonitiva',
    'ammonitive',
    'ammonitivi',
    'ammonitivo',
    'ammonito',
    'ammonitore',
    'ammonitori',
    'ammonitoria',
    'ammonitorie',
    'ammonitorio',
    'ammonitrice',
    'ammonitrici',
    'ammoniuria',
    'ammoniurie',
    'ammoniva',
    'ammonivamo',
    'ammonivano',
    'ammonivate',
    'ammonivi',
    'ammonivo',
    'ammonizione',
    'ammonizioni',
    'ammonta',
    'ammontai',
    'ammontammo',
    'ammontando',
    'ammontandoci',
    'ammontandomi',
    'ammontandosi',
    'ammontandoti',
    'ammontandovi',
    'ammontano',
    'ammontante',
    'ammontanti',
    'ammontantisi',
    'ammontarci',
    'ammontare',
    'ammontari',
    'ammontarmi',
    'ammontarono',
    'ammontarsi',
    'ammontarti',
    'ammontarvi',
    'ammontasse',
    'ammontassero',
    'ammontassi',
    'ammontassimo',
    'ammontaste',
    'ammontasti',
    'ammontata',
    'ammontate',
    'ammontatevi',
    'ammontati',
    'ammontato',
    'ammontatomi',
    'ammontatoti',
    'ammontava',
    'ammontavamo',
    'ammontavano',
    'ammontavate',
    'ammontavi',
    'ammontavo',
    'ammontera',
    'ammonterai',
    'ammonteranno',
    'ammonterebbe',
    'ammonterei',
    'ammonteremmo',
    'ammonteremo',
    'ammontereste',
    'ammonteresti',
    'ammonterete',
    'ammontero',
    'ammonti',
    'ammontiamo',
    'ammontiamoci',
    'ammontiate',
    'ammonticchi',
    'ammonticchia',
    'ammonticchio',
    'ammontino',
    'ammonto',
    'ammorba',
    'ammorbai',
    'ammorbamenti',
    'ammorbamento',
    'ammorbammo',
    'ammorbando',
    'ammorbano',
    'ammorbante',
    'ammorbanti',
    'ammorbare',
    'ammorbarono',
    'ammorbasse',
    'ammorbassero',
    'ammorbassi',
    'ammorbassimo',
    'ammorbaste',
    'ammorbasti',
    'ammorbata',
    'ammorbate',
    'ammorbati',
    'ammorbato',
    'ammorbatore',
    'ammorbatori',
    'ammorbatrice',
    'ammorbatrici',
    'ammorbava',
    'ammorbavamo',
    'ammorbavano',
    'ammorbavate',
    'ammorbavi',
    'ammorbavo',
    'ammorbera',
    'ammorberai',
    'ammorberanno',
    'ammorberebbe',
    'ammorberei',
    'ammorberemmo',
    'ammorberemo',
    'ammorbereste',
    'ammorberesti',
    'ammorberete',
    'ammorbero',
    'ammorbi',
    'ammorbiamo',
    'ammorbiate',
    'ammorbida',
    'ammorbidai',
    'ammorbidammo',
    'ammorbidando',
    'ammorbidano',
    'ammorbidante',
    'ammorbidanti',
    'ammorbidarci',
    'ammorbidare',
    'ammorbidarmi',
    'ammorbidarsi',
    'ammorbidarti',
    'ammorbidarvi',
    'ammorbidasse',
    'ammorbidassi',
    'ammorbidaste',
    'ammorbidasti',
    'ammorbidata',
    'ammorbidate',
    'ammorbidati',
    'ammorbidato',
    'ammorbidava',
    'ammorbidavi',
    'ammorbidavo',
    'ammorbidendo',
    'ammorbidente',
    'ammorbidenti',
    'ammorbidera',
    'ammorbiderai',
    'ammorbiderei',
    'ammorbidero',
    'ammorbidi',
    'ammorbidiamo',
    'ammorbidiate',
    'ammorbidii',
    'ammorbidimmo',
    'ammorbidino',
    'ammorbidira',
    'ammorbidirai',
    'ammorbidirci',
    'ammorbidire',
    'ammorbidirei',
    'ammorbidirmi',
    'ammorbidiro',
    'ammorbidirsi',
    'ammorbidirti',
    'ammorbidirvi',
    'ammorbidisca',
    'ammorbidisce',
    'ammorbidisci',
    'ammorbidisco',
    'ammorbidisse',
    'ammorbidissi',
    'ammorbidiste',
    'ammorbidisti',
    'ammorbidita',
    'ammorbidite',
    'ammorbiditi',
    'ammorbidito',
    'ammorbidiva',
    'ammorbidivi',
    'ammorbidivo',
    'ammorbido',
    'ammorbino',
    'ammorbo',
    'ammorsa',
    'ammorsai',
    'ammorsammo',
    'ammorsando',
    'ammorsano',
    'ammorsante',
    'ammorsanti',
    'ammorsare',
    'ammorsarono',
    'ammorsasse',
    'ammorsassero',
    'ammorsassi',
    'ammorsassimo',
    'ammorsaste',
    'ammorsasti',
    'ammorsata',
    'ammorsate',
    'ammorsati',
    'ammorsato',
    'ammorsatura',
    'ammorsature',
    'ammorsava',
    'ammorsavamo',
    'ammorsavano',
    'ammorsavate',
    'ammorsavi',
    'ammorsavo',
    'ammorsellata',
    'ammorsellate',
    'ammorsellati',
    'ammorsellato',
    'ammorsera',
    'ammorserai',
    'ammorseranno',
    'ammorserebbe',
    'ammorserei',
    'ammorseremmo',
    'ammorseremo',
    'ammorsereste',
    'ammorseresti',
    'ammorserete',
    'ammorsero',
    'ammorsi',
    'ammorsiamo',
    'ammorsiate',
    'ammorsino',
    'ammorso',
    'ammorta',
    'ammortai',
    'ammortamenti',
    'ammortamento',
    'ammortammo',
    'ammortando',
    'ammortano',
    'ammortante',
    'ammortanti',
    'ammortare',
    'ammortarono',
    'ammortasse',
    'ammortassero',
    'ammortassi',
    'ammortassimo',
    'ammortaste',
    'ammortasti',
    'ammortata',
    'ammortate',
    'ammortati',
    'ammortato',
    'ammortava',
    'ammortavamo',
    'ammortavano',
    'ammortavate',
    'ammortavi',
    'ammortavo',
    'ammortendo',
    'ammortendoci',
    'ammortendomi',
    'ammortendosi',
    'ammortendoti',
    'ammortendovi',
    'ammortente',
    'ammortenti',
    'ammortentisi',
    'ammortera',
    'ammorterai',
    'ammorteranno',
    'ammorterebbe',
    'ammorterei',
    'ammorteremmo',
    'ammorteremo',
    'ammortereste',
    'ammorteresti',
    'ammorterete',
    'ammortero',
    'ammorti',
    'ammortiamo',
    'ammortiamoci',
    'ammortiate',
    'ammortii',
    'ammortimmo',
    'ammortino',
    'ammortira',
    'ammortirai',
    'ammortiranno',
    'ammortirci',
    'ammortire',
    'ammortirebbe',
    'ammortirei',
    'ammortiremmo',
    'ammortiremo',
    'ammortireste',
    'ammortiresti',
    'ammortirete',
    'ammortirmi',
    'ammortiro',
    'ammortirono',
    'ammortirsi',
    'ammortirti',
    'ammortirvi',
    'ammortisca',
    'ammortiscano',
    'ammortisce',
    'ammortisci',
    'ammortisciti',
    'ammortisco',
    'ammortiscono',
    'ammortisse',
    'ammortissero',
    'ammortissi',
    'ammortissimo',
    'ammortiste',
    'ammortisti',
    'ammortita',
    'ammortite',
    'ammortitevi',
    'ammortiti',
    'ammortito',
    'ammortitomi',
    'ammortitoti',
    'ammortiva',
    'ammortivamo',
    'ammortivano',
    'ammortivate',
    'ammortivi',
    'ammortivo',
    'ammortizza',
    'ammortizzai',
    'ammortizzano',
    'ammortizzare',
    'ammortizzata',
    'ammortizzate',
    'ammortizzati',
    'ammortizzato',
    'ammortizzava',
    'ammortizzavi',
    'ammortizzavo',
    'ammortizzera',
    'ammortizzero',
    'ammortizzi',
    'ammortizzino',
    'ammortizzo',
    'ammorto',
    'ammorza',
    'ammorzai',
    'ammorzamenti',
    'ammorzamento',
    'ammorzammo',
    'ammorzando',
    'ammorzandosi',
    'ammorzano',
    'ammorzante',
    'ammorzanti',
    'ammorzare',
    'ammorzarono',
    'ammorzarsi',
    'ammorzasse',
    'ammorzassero',
    'ammorzassi',
    'ammorzassimo',
    'ammorzaste',
    'ammorzasti',
    'ammorzata',
    'ammorzate',
    'ammorzati',
    'ammorzato',
    'ammorzava',
    'ammorzavamo',
    'ammorzavano',
    'ammorzavate',
    'ammorzavi',
    'ammorzavo',
    'ammorzera',
    'ammorzerai',
    'ammorzeranno',
    'ammorzerebbe',
    'ammorzerei',
    'ammorzeremmo',
    'ammorzeremo',
    'ammorzereste',
    'ammorzeresti',
    'ammorzerete',
    'ammorzero',
    'ammorzi',
    'ammorziamo',
    'ammorziate',
    'ammorzino',
    'ammorzo',
    'ammoscendo',
    'ammoscendoci',
    'ammoscendomi',
    'ammoscendosi',
    'ammoscendoti',
    'ammoscendovi',
    'ammoscente',
    'ammoscenti',
    'ammoscentisi',
    'ammoscera',
    'ammoscerai',
    'ammosceranno',
    'ammoscerebbe',
    'ammoscerei',
    'ammosceremmo',
    'ammosceremo',
    'ammoscereste',
    'ammosceresti',
    'ammoscerete',
    'ammoscero',
    'ammosci',
    'ammoscia',
    'ammosciai',
    'ammosciammo',
    'ammosciamo',
    'ammosciamoci',
    'ammosciando',
    'ammosciano',
    'ammosciante',
    'ammoscianti',
    'ammosciarci',
    'ammosciare',
    'ammosciarmi',
    'ammosciarono',
    'ammosciarsi',
    'ammosciarti',
    'ammosciarvi',
    'ammosciasse',
    'ammosciassi',
    'ammosciaste',
    'ammosciasti',
    'ammosciata',
    'ammosciate',
    'ammosciatevi',
    'ammosciati',
    'ammosciato',
    'ammosciatomi',
    'ammosciatoti',
    'ammosciava',
    'ammosciavamo',
    'ammosciavano',
    'ammosciavate',
    'ammosciavi',
    'ammosciavo',
    'ammoscii',
    'ammoscimmo',
    'ammoscino',
    'ammoscio',
    'ammoscira',
    'ammoscirai',
    'ammosciranno',
    'ammoscirci',
    'ammoscire',
    'ammoscirebbe',
    'ammoscirei',
    'ammosciremmo',
    'ammosciremo',
    'ammoscireste',
    'ammosciresti',
    'ammoscirete',
    'ammoscirmi',
    'ammosciro',
    'ammoscirono',
    'ammoscirsi',
    'ammoscirti',
    'ammoscirvi',
    'ammoscisca',
    'ammosciscano',
    'ammoscisce',
    'ammoscisci',
    'ammoscisciti',
    'ammoscisco',
    'ammosciscono',
    'ammoscisse',
    'ammoscissero',
    'ammoscissi',
    'ammoscissimo',
    'ammosciste',
    'ammoscisti',
    'ammoscita',
    'ammoscite',
    'ammoscitevi',
    'ammosciti',
    'ammoscito',
    'ammoscitomi',
    'ammoscitoti',
    'ammosciva',
    'ammoscivamo',
    'ammoscivano',
    'ammoscivate',
    'ammoscivi',
    'ammoscivo',
    'ammosta',
    'ammostai',
    'ammostamenti',
    'ammostamento',
    'ammostammo',
    'ammostando',
    'ammostano',
    'ammostante',
    'ammostanti',
    'ammostare',
    'ammostarono',
    'ammostasse',
    'ammostassero',
    'ammostassi',
    'ammostassimo',
    'ammostaste',
    'ammostasti',
    'ammostata',
    'ammostate',
    'ammostati',
    'ammostato',
    'ammostatoi',
    'ammostatoio',
    'ammostatore',
    'ammostatori',
    'ammostatrice',
    'ammostatrici',
    'ammostatura',
    'ammostature',
    'ammostava',
    'ammostavamo',
    'ammostavano',
    'ammostavate',
    'ammostavi',
    'ammostavo',
    'ammostera',
    'ammosterai',
    'ammosteranno',
    'ammosterebbe',
    'ammosterei',
    'ammosteremmo',
    'ammosteremo',
    'ammostereste',
    'ammosteresti',
    'ammosterete',
    'ammostero',
    'ammosti',
    'ammostiamo',
    'ammostiate',
    'ammostino',
    'ammosto',
    'ammotraghi',
    'ammotrago',
    'ammucchi',
    'ammucchia',
    'ammucchiai',
    'ammucchiammo',
    'ammucchiamo',
    'ammucchiando',
    'ammucchiano',
    'ammucchiante',
    'ammucchianti',
    'ammucchiarci',
    'ammucchiare',
    'ammucchiarle',
    'ammucchiarli',
    'ammucchiarmi',
    'ammucchiarsi',
    'ammucchiarti',
    'ammucchiarvi',
    'ammucchiasse',
    'ammucchiassi',
    'ammucchiaste',
    'ammucchiasti',
    'ammucchiata',
    'ammucchiate',
    'ammucchiati',
    'ammucchiato',
    'ammucchiava',
    'ammucchiavi',
    'ammucchiavo',
    'ammucchiera',
    'ammucchierai',
    'ammucchierei',
    'ammucchiero',
    'ammucchino',
    'ammucchio',
    'ammucidendo',
    'ammucidente',
    'ammucidenti',
    'ammucidi',
    'ammucidiamo',
    'ammucidiate',
    'ammucidii',
    'ammucidimmo',
    'ammucidira',
    'ammucidirai',
    'ammucidirci',
    'ammucidire',
    'ammucidirei',
    'ammucidiremo',
    'ammucidirete',
    'ammucidirmi',
    'ammucidiro',
    'ammucidirono',
    'ammucidirsi',
    'ammucidirti',
    'ammucidirvi',
    'ammucidisca',
    'ammucidisce',
    'ammucidisci',
    'ammucidisco',
    'ammucidisse',
    'ammucidissi',
    'ammucidiste',
    'ammucidisti',
    'ammucidita',
    'ammucidite',
    'ammuciditevi',
    'ammuciditi',
    'ammucidito',
    'ammuciditomi',
    'ammuciditoti',
    'ammucidiva',
    'ammucidivamo',
    'ammucidivano',
    'ammucidivate',
    'ammucidivi',
    'ammucidivo',
    'ammuffendo',
    'ammuffendoci',
    'ammuffendomi',
    'ammuffendosi',
    'ammuffendoti',
    'ammuffendovi',
    'ammuffente',
    'ammuffenti',
    'ammuffentisi',
    'ammuffi',
    'ammuffiamo',
    'ammuffiamoci',
    'ammuffiate',
    'ammuffii',
    'ammuffimenti',
    'ammuffimento',
    'ammuffimmo',
    'ammuffira',
    'ammuffirai',
    'ammuffiranno',
    'ammuffirci',
    'ammuffire',
    'ammuffirebbe',
    'ammuffirei',
    'ammuffiremmo',
    'ammuffiremo',
    'ammuffireste',
    'ammuffiresti',
    'ammuffirete',
    'ammuffirmi',
    'ammuffiro',
    'ammuffirono',
    'ammuffirsi',
    'ammuffirti',
    'ammuffirvi',
    'ammuffisca',
    'ammuffiscano',
    'ammuffisce',
    'ammuffisci',
    'ammuffisciti',
    'ammuffisco',
    'ammuffiscono',
    'ammuffisse',
    'ammuffissero',
    'ammuffissi',
    'ammuffissimo',
    'ammuffiste',
    'ammuffisti',
    'ammuffita',
    'ammuffite',
    'ammuffitevi',
    'ammuffiti',
    'ammuffito',
    'ammuffitomi',
    'ammuffitoti',
    'ammuffiva',
    'ammuffivamo',
    'ammuffivano',
    'ammuffivate',
    'ammuffivi',
    'ammuffivo',
    'ammuina',
    'ammuinai',
    'ammuinammo',
    'ammuinando',
    'ammuinano',
    'ammuinante',
    'ammuinanti',
    'ammuinare',
    'ammuinarono',
    'ammuinasse',
    'ammuinassero',
    'ammuinassi',
    'ammuinassimo',
    'ammuinaste',
    'ammuinasti',
    'ammuinata',
    'ammuinate',
    'ammuinati',
    'ammuinato',
    'ammuinava',
    'ammuinavamo',
    'ammuinavano',
    'ammuinavate',
    'ammuinavi',
    'ammuinavo',
    'ammuinera',
    'ammuinerai',
    'ammuineranno',
    'ammuinerebbe',
    'ammuinerei',
    'ammuineremmo',
    'ammuineremo',
    'ammuinereste',
    'ammuineresti',
    'ammuinerete',
    'ammuinero',
    'ammuini',
    'ammuiniamo',
    'ammuiniate',
    'ammuinino',
    'ammuino',
    'ammulina',
    'ammulinai',
    'ammulinammo',
    'ammulinando',
    'ammulinano',
    'ammulinante',
    'ammulinanti',
    'ammulinare',
    'ammulinarono',
    'ammulinasse',
    'ammulinassi',
    'ammulinaste',
    'ammulinasti',
    'ammulinata',
    'ammulinate',
    'ammulinati',
    'ammulinato',
    'ammulinava',
    'ammulinavamo',
    'ammulinavano',
    'ammulinavate',
    'ammulinavi',
    'ammulinavo',
    'ammulinera',
    'ammulinerai',
    'ammulinerei',
    'ammulineremo',
    'ammulinerete',
    'ammulinero',
    'ammulini',
    'ammuliniamo',
    'ammuliniate',
    'ammulinino',
    'ammulino',
    'ammusa',
    'ammusai',
    'ammusammo',
    'ammusando',
    'ammusandosi',
    'ammusano',
    'ammusante',
    'ammusanti',
    'ammusare',
    'ammusarono',
    'ammusarsi',
    'ammusasse',
    'ammusassero',
    'ammusassi',
    'ammusassimo',
    'ammusaste',
    'ammusasti',
    'ammusata',
    'ammusate',
    'ammusati',
    'ammusato',
    'ammusava',
    'ammusavamo',
    'ammusavano',
    'ammusavate',
    'ammusavi',
    'ammusavo',
    'ammusendo',
    'ammusendoci',
    'ammusendomi',
    'ammusendosi',
    'ammusendoti',
    'ammusendovi',
    'ammusente',
    'ammusenti',
    'ammusentisi',
    'ammusera',
    'ammuserai',
    'ammuseranno',
    'ammuserebbe',
    'ammuserei',
    'ammuseremmo',
    'ammuseremo',
    'ammusereste',
    'ammuseresti',
    'ammuserete',
    'ammusero',
    'ammusi',
    'ammusiamo',
    'ammusiamoci',
    'ammusiate',
    'ammusii',
    'ammusimmo',
    'ammusino',
    'ammusira',
    'ammusirai',
    'ammusiranno',
    'ammusirci',
    'ammusire',
    'ammusirebbe',
    'ammusirei',
    'ammusiremmo',
    'ammusiremo',
    'ammusireste',
    'ammusiresti',
    'ammusirete',
    'ammusirmi',
    'ammusiro',
    'ammusirono',
    'ammusirsi',
    'ammusirti',
    'ammusirvi',
    'ammusisca',
    'ammusiscano',
    'ammusisce',
    'ammusisci',
    'ammusisciti',
    'ammusisco',
    'ammusiscono',
    'ammusisse',
    'ammusissero',
    'ammusissi',
    'ammusissimo',
    'ammusiste',
    'ammusisti',
    'ammusita',
    'ammusite',
    'ammusitevi',
    'ammusiti',
    'ammusito',
    'ammusitomi',
    'ammusitoti',
    'ammusiva',
    'ammusivamo',
    'ammusivano',
    'ammusivate',
    'ammusivi',
    'ammusivo',
    'ammuso',
    'ammusonita',
    'ammusonite',
    'ammusoniti',
    'ammusonito',
    'ammuta',
    'ammutai',
    'ammutammo',
    'ammutando',
    'ammutano',
    'ammutante',
    'ammutanti',
    'ammutare',
    'ammutarono',
    'ammutasse',
    'ammutassero',
    'ammutassi',
    'ammutassimo',
    'ammutaste',
    'ammutasti',
    'ammutata',
    'ammutate',
    'ammutati',
    'ammutato',
    'ammutava',
    'ammutavamo',
    'ammutavano',
    'ammutavate',
    'ammutavi',
    'ammutavo',
    'ammutendo',
    'ammutente',
    'ammutenti',
    'ammutera',
    'ammuterai',
    'ammuteranno',
    'ammuterebbe',
    'ammuterei',
    'ammuteremmo',
    'ammuteremo',
    'ammutereste',
    'ammuteresti',
    'ammuterete',
    'ammutero',
    'ammuti',
    'ammutiamo',
    'ammutiate',
    'ammutii',
    'ammutimmo',
    'ammutina',
    'ammutinai',
    'ammutinammo',
    'ammutinando',
    'ammutinano',
    'ammutinante',
    'ammutinanti',
    'ammutinarci',
    'ammutinare',
    'ammutinarmi',
    'ammutinarono',
    'ammutinarsi',
    'ammutinarti',
    'ammutinarvi',
    'ammutinasse',
    'ammutinassi',
    'ammutinaste',
    'ammutinasti',
    'ammutinata',
    'ammutinate',
    'ammutinatevi',
    'ammutinati',
    'ammutinato',
    'ammutinatomi',
    'ammutinatoti',
    'ammutinava',
    'ammutinavamo',
    'ammutinavano',
    'ammutinavate',
    'ammutinavi',
    'ammutinavo',
    'ammutinera',
    'ammutinerai',
    'ammutinerei',
    'ammutineremo',
    'ammutinerete',
    'ammutinero',
    'ammutini',
    'ammutiniamo',
    'ammutiniate',
    'ammutinino',
    'ammutino',
    'ammutira',
    'ammutirai',
    'ammutiranno',
    'ammutire',
    'ammutirebbe',
    'ammutirei',
    'ammutiremmo',
    'ammutiremo',
    'ammutireste',
    'ammutiresti',
    'ammutirete',
    'ammutiro',
    'ammutirono',
    'ammutisca',
    'ammutiscano',
    'ammutisce',
    'ammutisci',
    'ammutisco',
    'ammutiscono',
    'ammutisse',
    'ammutissero',
    'ammutissi',
    'ammutissimo',
    'ammutiste',
    'ammutisti',
    'ammutita',
    'ammutite',
    'ammutiti',
    'ammutito',
    'ammutiva',
    'ammutivamo',
    'ammutivano',
    'ammutivate',
    'ammutivi',
    'ammutivo',
    'ammuto',
    'ammutolendo',
    'ammutolente',
    'ammutolenti',
    'ammutoli',
    'ammutoliamo',
    'ammutoliate',
    'ammutolii',
    'ammutolimmo',
    'ammutolira',
    'ammutolirai',
    'ammutolire',
    'ammutolirei',
    'ammutoliremo',
    'ammutolirete',
    'ammutoliro',
    'ammutolirono',
    'ammutolirsi',
    'ammutolisca',
    'ammutolisce',
    'ammutolisci',
    'ammutolisco',
    'ammutolisse',
    'ammutolissi',
    'ammutoliste',
    'ammutolisti',
    'ammutolita',
    'ammutolite',
    'ammutoliti',
    'ammutolito',
    'ammutoliva',
    'ammutolivamo',
    'ammutolivano',
    'ammutolivate',
    'ammutolivi',
    'ammutolivo',
    'amnesia',
    'amnesie',
    'amnestica',
    'amnestiche',
    'amnestici',
    'amnestico',
    'amnesty',
    'amni',
    'amnio',
    'amniocentesi',
    'amniografia',
    'amniografie',
    'amniorrea',
    'amniorree',
    'amnios',
    'amnioscopi',
    'amnioscopia',
    'amnioscopica',
    'amnioscopici',
    'amnioscopico',
    'amnioscopie',
    'amnioscopio',
    'amnioti',
    'amniotica',
    'amniotiche',
    'amniotici',
    'amniotico',
    'amnisti',
    'amnistia',
    'amnistiai',
    'amnistiammo',
    'amnistiamo',
    'amnistiando',
    'amnistiano',
    'amnistiante',
    'amnistianti',
    'amnistiare',
    'amnistiarla',
    'amnistiarle',
    'amnistiarli',
    'amnistiarlo',
    'amnistiarono',
    'amnistiasse',
    'amnistiassi',
    'amnistiaste',
    'amnistiasti',
    'amnistiata',
    'amnistiate',
    'amnistiati',
    'amnistiato',
    'amnistiava',
    'amnistiavamo',
    'amnistiavano',
    'amnistiavate',
    'amnistiavi',
    'amnistiavo',
    'amnistie',
    'amnistiera',
    'amnistierai',
    'amnistierei',
    'amnistieremo',
    'amnistierete',
    'amnistiero',
    'amnistii',
    'amnistino',
    'amnistio',
    'amnistiò',
    'amobarbitale',
    'amodeo',
    'amodia',
    'amodio',
    'amoeba',
    'amoebida',
    'amoerre',
    'amoerri',
    'amoerro',
    'amomi',
    'amomo',
    'amonasro',
    'amonastro',
    'amor',
    'amorale',
    'amorali',
    'amoralismi',
    'amoralismo',
    'amoralita',
    'amoralità',
    'amoralmente',
    'amorazzi',
    'amorazzo',
    'amore',
    'amoreggera',
    'amoreggerai',
    'amoreggerei',
    'amoreggeremo',
    'amoreggerete',
    'amoreggero',
    'amoreggi',
    'amoreggia',
    'amoreggiai',
    'amoreggiammo',
    'amoreggiamo',
    'amoreggiando',
    'amoreggiano',
    'amoreggiante',
    'amoreggianti',
    'amoreggiare',
    'amoreggiasse',
    'amoreggiassi',
    'amoreggiaste',
    'amoreggiasti',
    'amoreggiata',
    'amoreggiate',
    'amoreggiati',
    'amoreggiato',
    'amoreggiava',
    'amoreggiavi',
    'amoreggiavo',
    'amoreggino',
    'amoreggio',
    'amoretti',
    'amoretto',
    'amorevole',
    'amorevolezza',
    'amorevolezze',
    'amorevoli',
    'amorfa',
    'amorfamente',
    'amorfe',
    'amorfi',
    'amorfismi',
    'amorfismo',
    'amorfo',
    'amori',
    'amorina',
    'amorini',
    'amorino',
    'amorosa',
    'amorosamente',
    'amorose',
    'amorosi',
    'amoroso',
    'amorucci',
    'amoruccio',
    'amos',
    'amoscina',
    'amoscine',
    'amoscini',
    'amoscino',
    'amostante',
    'amostanti',
    'amovibile',
    'amovibili',
    'amovibilita',
    'amozione',
    'amozioni',
    'amparo',
    'ampeglio',
    'ampelia',
    'ampelidacea',
    'ampelidacee',
    'ampelio',
    'ampellio',
    'ampelo',
    'ampelodesmi',
    'ampelodesmo',
    'ampelografi',
    'ampelografia',
    'ampelografie',
    'ampelografo',
    'ampelologa',
    'ampelologhe',
    'ampelologhi',
    'ampelologi',
    'ampelologia',
    'ampelologie',
    'ampelologo',
    'ampelotecnia',
    'ampelotecnie',
    'amperaggi',
    'amperaggio',
    'ampere',
    'amperio',
    'amperometri',
    'amperometro',
    'amperora',
    'ampersecondo',
    'amperspira',
    'amperspire',
    'ampex',
    'ampezzana',
    'ampezzane',
    'ampezzani',
    'ampezzano',
    'ampezzo',
    'amphibia',
    'ampi',
    'ampia',
    'ampiamente',
    'ampie',
    'ampiezza',
    'ampiezze',
    'ampilio',
    'ampio',
    'ampissima',
    'ampissime',
    'ampissimi',
    'ampissimo',
    'amplessi',
    'amplesso',
    'ampli',
    'amplia',
    'ampliai',
    'ampliamenti',
    'ampliamento',
    'ampliammo',
    'ampliamo',
    'ampliamoci',
    'ampliando',
    'ampliandoci',
    'ampliandola',
    'ampliandole',
    'ampliandoli',
    'ampliandolo',
    'ampliandomi',
    'ampliandosi',
    'ampliandoti',
    'ampliandovi',
    'ampliano',
    'ampliante',
    'amplianti',
    'ampliantisi',
    'ampliarci',
    'ampliare',
    'ampliarla',
    'ampliarle',
    'ampliarli',
    'ampliarlo',
    'ampliarmi',
    'ampliarono',
    'ampliarsi',
    'ampliarti',
    'ampliarvi',
    'ampliasse',
    'ampliassero',
    'ampliassi',
    'ampliassimo',
    'ampliaste',
    'ampliasti',
    'ampliata',
    'ampliate',
    'ampliatevi',
    'ampliati',
    'ampliativa',
    'ampliative',
    'ampliativi',
    'ampliativo',
    'ampliato',
    'ampliatomi',
    'ampliatoti',
    'ampliava',
    'ampliavamo',
    'ampliavano',
    'ampliavate',
    'ampliavi',
    'ampliavo',
    'amplidina',
    'amplidinamo',
    'amplidine',
    'ampliera',
    'amplierai',
    'amplieranno',
    'amplierebbe',
    'amplierei',
    'amplieremmo',
    'amplieremo',
    'ampliereste',
    'amplieresti',
    'amplierete',
    'ampliero',
    'amplifica',
    'amplificai',
    'amplificammo',
    'amplificando',
    'amplificano',
    'amplificante',
    'amplificanti',
    'amplificare',
    'amplificarla',
    'amplificarle',
    'amplificarli',
    'amplificarlo',
    'amplificasse',
    'amplificassi',
    'amplificaste',
    'amplificasti',
    'amplificata',
    'amplificate',
    'amplificati',
    'amplificato',
    'amplificava',
    'amplificavi',
    'amplificavo',
    'amplifichera',
    'amplifichero',
    'amplifichi',
    'amplifichino',
    'amplifico',
    'amplino',
    'amplio',
    'amplissima',
    'amplissime',
    'amplissimi',
    'amplissimo',
    'amplitudine',
    'amplitudini',
    'amplo',
    'ampolla',
    'ampolle',
    'ampolletta',
    'ampollette',
    'ampolliera',
    'ampolliere',
    'ampollina',
    'ampolline',
    'ampollini',
    'ampollino',
    'ampollosa',
    'ampollose',
    'ampollosi',
    'ampollosita',
    'ampollosità',
    'ampolloso',
    'amponamento',
    'amputa',
    'amputabile',
    'amputabili',
    'amputai',
    'amputammo',
    'amputando',
    'amputandola',
    'amputandole',
    'amputandoli',
    'amputandolo',
    'amputano',
    'amputante',
    'amputanti',
    'amputare',
    'amputarla',
    'amputarle',
    'amputarli',
    'amputarlo',
    'amputarono',
    'amputasse',
    'amputassero',
    'amputassi',
    'amputassimo',
    'amputaste',
    'amputasti',
    'amputata',
    'amputate',
    'amputati',
    'amputato',
    'amputava',
    'amputavamo',
    'amputavano',
    'amputavate',
    'amputavi',
    'amputavo',
    'amputazione',
    'amputazioni',
    'amputera',
    'amputerai',
    'amputeranno',
    'amputerebbe',
    'amputerei',
    'amputeremmo',
    'amputeremo',
    'amputereste',
    'amputeresti',
    'amputerete',
    'amputero',
    'amputi',
    'amputiamo',
    'amputiate',
    'amputino',
    'amputo',
    'amsicora',
    'amsterdam',
    'amuleti',
    'amuleto',
    'amulia',
    'amulio',
    'anabaena',
    'anabante',
    'anabanti',
    'anabasi',
    'anabate',
    'anabati',
    'anabatica',
    'anabatiche',
    'anabatici',
    'anabatico',
    'anabattismi',
    'anabattismo',
    'anabattista',
    'anabattiste',
    'anabattisti',
    'anabiosi',
    'anabolica',
    'anaboliche',
    'anabolici',
    'anabolico',
    'anabolismi',
    'anabolismo',
    'anacardi',
    'anacardiacea',
    'anacardiacee',
    'anacardio',
    'anacardo',
    'anace',
    'anacenosi',
    'anaci',
    'anaciata',
    'anaciate',
    'anaciati',
    'anaciato',
    'anaciclica',
    'anacicliche',
    'anaciclici',
    'anaciclico',
    'anacini',
    'anacino',
    'anacio',
    'anaclasi',
    'anaclastica',
    'anaclastiche',
    'anaclastici',
    'anaclastico',
    'anacleta',
    'anacleto',
    'anacloridria',
    'anacoluti',
    'anacoluto',
    'anaconda',
    'anacoresi',
    'anacoreta',
    'anacoreti',
    'anacoretica',
    'anacoretiche',
    'anacoretici',
    'anacoretico',
    'anacoretismi',
    'anacoretismo',
    'anacreonte',
    'anacreontea',
    'anacreontee',
    'anacreontei',
    'anacreonteo',
    'anacreontica',
    'anacreontici',
    'anacreontico',
    'anacromatica',
    'anacromatici',
    'anacromatico',
    'anacronismi',
    'anacronismo',
    'anacrusi',
    'anadiomene',
    'anadiomeni',
    'anadiplosi',
    'anadroma',
    'anadrome',
    'anadromi',
    'anadromo',
    'anaelettrica',
    'anaelettrici',
    'anaelettrico',
    'anaerobi',
    'anaerobica',
    'anaerobiche',
    'anaerobici',
    'anaerobico',
    'anaerobio',
    'anaerobiosi',
    'anafase',
    'anafasi',
    'anafilassi',
    'anafilattica',
    'anafilattici',
    'anafilattico',
    'anafonesi',
    'anafora',
    'anafore',
    'anaforesi',
    'anaforica',
    'anaforiche',
    'anaforici',
    'anaforico',
    'anafrodisia',
    'anafrodisie',
    'anagallide',
    'anagallidi',
    'anagenesi',
    'anagiride',
    'anagiridi',
    'anaglifi',
    'anaglifica',
    'anaglifiche',
    'anaglifici',
    'anaglifico',
    'anaglifo',
    'anagliptica',
    'anagliptico',
    'anaglipto',
    'anaglittica',
    'anaglittiche',
    'anaglittici',
    'anaglittico',
    'anagni',
    'anagogia',
    'anagogica',
    'anagogiche',
    'anagogici',
    'anagogico',
    'anagogie',
    'anagrafe',
    'anagrafi',
    'anagrafica',
    'anagrafiche',
    'anagrafici',
    'anagrafico',
    'anagramma',
    'anagrammai',
    'anagrammammo',
    'anagrammando',
    'anagrammano',
    'anagrammante',
    'anagrammanti',
    'anagrammarci',
    'anagrammare',
    'anagrammarmi',
    'anagrammarsi',
    'anagrammarti',
    'anagrammarvi',
    'anagrammasse',
    'anagrammassi',
    'anagrammaste',
    'anagrammasti',
    'anagrammata',
    'anagrammate',
    'anagrammati',
    'anagrammato',
    'anagrammava',
    'anagrammavi',
    'anagrammavo',
    'anagrammera',
    'anagrammerai',
    'anagrammerei',
    'anagrammero',
    'anagrammi',
    'anagrammiamo',
    'anagrammiate',
    'anagrammino',
    'anagrammista',
    'anagrammiste',
    'anagrammisti',
    'anagrammo',
    'analcolica',
    'analcoliche',
    'analcolici',
    'analcolico',
    'analcoolica',
    'analcooliche',
    'analcoolici',
    'analcoolico',
    'analda',
    'anale',
    'analecta',
    'analessi',
    'analettica',
    'analettiche',
    'analettici',
    'analettico',
    'analfabeta',
    'analfabete',
    'analfabeti',
    'analfabetica',
    'analfabetici',
    'analfabetico',
    'analgesia',
    'analgesica',
    'analgesiche',
    'analgesici',
    'analgesico',
    'analgesie',
    'analgesista',
    'analgesiste',
    'analgesisti',
    'anali',
    'analisi',
    'analista',
    'analiste',
    'analisti',
    'analitica',
    'analitiche',
    'analitici',
    'analiticita',
    'analiticità',
    'analitico',
    'analiziamo',
    'analizza',
    'analizzabile',
    'analizzabili',
    'analizzai',
    'analizzala',
    'analizzale',
    'analizzali',
    'analizzalo',
    'analizzammo',
    'analizzando',
    'analizzano',
    'analizzante',
    'analizzanti',
    'analizzare',
    'analizzarla',
    'analizzarle',
    'analizzarli',
    'analizzarlo',
    'analizzarono',
    'analizzarsi',
    'analizzasse',
    'analizzassi',
    'analizzaste',
    'analizzasti',
    'analizzata',
    'analizzate',
    'analizzati',
    'analizzato',
    'analizzatore',
    'analizzatori',
    'analizzava',
    'analizzavamo',
    'analizzavano',
    'analizzavate',
    'analizzavi',
    'analizzavo',
    'analizzera',
    'analizzerai',
    'analizzerei',
    'analizzeremo',
    'analizzerete',
    'analizzero',
    'analizzi',
    'analizziamo',
    'analizziate',
    'analizzino',
    'analizzo',
    'anallergica',
    'anallergiche',
    'anallergici',
    'anallergico',
    'analoga',
    'analogamente',
    'analoghe',
    'analoghi',
    'analogia',
    'analogica',
    'analogiche',
    'analogici',
    'analogico',
    'analogie',
    'analogismi',
    'analogismo',
    'analogista',
    'analogiste',
    'analogisti',
    'analogo',
    'analysis',
    'anamnesi',
    'anamnestica',
    'anamnestiche',
    'anamnestici',
    'anamnestico',
    'anamni',
    'anamnio',
    'anamorfica',
    'anamorfiche',
    'anamorfici',
    'anamorfico',
    'anamorfosi',
    'ananas',
    'ananasse',
    'ananasso',
    'anancastici',
    'anania',
    'ananio',
    'anapesti',
    'anapestica',
    'anapestiche',
    'anapestici',
    'anapestico',
    'anapesto',
    'anaplasia',
    'anaplasma',
    'anaplasmi',
    'anaplasmosi',
    'anapodittica',
    'anapodittici',
    'anapodittico',
    'anaptissi',
    'anaptittica',
    'anaptittiche',
    'anaptittici',
    'anaptittico',
    'anarchia',
    'anarchica',
    'anarchiche',
    'anarchici',
    'anarchico',
    'anarchie',
    'anarchismi',
    'anarchismo',
    'anarcoide',
    'anarcoidi',
    'anari',
    'anaria',
    'anariana',
    'anariane',
    'anariani',
    'anariano',
    'anarica',
    'anaricadide',
    'anaricadidi',
    'anariche',
    'anarie',
    'anario',
    'anarrica',
    'anarricadidi',
    'anarricadido',
    'anarriche',
    'anas',
    'anasarca',
    'anasarchi',
    'anassagora',
    'anastasia',
    'anastasio',
    'anastatica',
    'anastatiche',
    'anastatici',
    'anastatico',
    'anastomisi',
    'anastomizza',
    'anastomizzai',
    'anastomizzi',
    'anastomizzo',
    'anastomosi',
    'anastrofe',
    'anastrofi',
    'anatasi',
    'anatasio',
    'anatema',
    'anatematismi',
    'anatematismo',
    'anatematizza',
    'anatematizzi',
    'anatematizzo',
    'anatemi',
    'anatemizza',
    'anatemizzai',
    'anatemizzano',
    'anatemizzare',
    'anatemizzata',
    'anatemizzate',
    'anatemizzati',
    'anatemizzato',
    'anatemizzava',
    'anatemizzavi',
    'anatemizzavo',
    'anatemizzera',
    'anatemizzero',
    'anatemizzi',
    'anatemizzino',
    'anatemizzo',
    'anatide',
    'anatidi',
    'anatocismi',
    'anatocismo',
    'anatolia',
    'anatolica',
    'anatoliche',
    'anatolici',
    'anatolico',
    'anatolio',
    'anatomia',
    'anatomica',
    'anatomiche',
    'anatomici',
    'anatomico',
    'anatomie',
    'anatomista',
    'anatomiste',
    'anatomisti',
    'anatomizza',
    'anatomizzai',
    'anatomizzano',
    'anatomizzare',
    'anatomizzata',
    'anatomizzate',
    'anatomizzati',
    'anatomizzato',
    'anatomizzava',
    'anatomizzavi',
    'anatomizzavo',
    'anatomizzera',
    'anatomizzero',
    'anatomizzi',
    'anatomizzino',
    'anatomizzo',
    'anatosauro',
    'anatossina',
    'anatossine',
    'anatra',
    'anatrai',
    'anatrammo',
    'anatrando',
    'anatrano',
    'anatrante',
    'anatranti',
    'anatrare',
    'anatrarono',
    'anatrasse',
    'anatrassero',
    'anatrassi',
    'anatrassimo',
    'anatraste',
    'anatrasti',
    'anatrata',
    'anatrate',
    'anatrati',
    'anatrato',
    'anatrava',
    'anatravamo',
    'anatravano',
    'anatravate',
    'anatravi',
    'anatravo',
    'anatre',
    'anatrella',
    'anatrelle',
    'anatreptica',
    'anatreptiche',
    'anatrera',
    'anatrerai',
    'anatreranno',
    'anatrerebbe',
    'anatrerei',
    'anatreremmo',
    'anatreremo',
    'anatrereste',
    'anatreresti',
    'anatrerete',
    'anatrero',
    'anatrettica',
    'anatrettiche',
    'anatri',
    'anatriamo',
    'anatriate',
    'anatrina',
    'anatrine',
    'anatrino',
    'anatro',
    'anatroccoli',
    'anatroccolo',
    'anatrona',
    'anatrone',
    'anatroni',
    'anatropa',
    'anatrope',
    'anatropi',
    'anatropo',
    'anca',
    'ancata',
    'ancate',
    'ance',
    'ancella',
    'ancelle',
    'ancestrale',
    'ancestrali',
    'anch',
    'anche',
    'ancheggera',
    'ancheggerai',
    'ancheggerei',
    'ancheggeremo',
    'ancheggerete',
    'ancheggero',
    'ancheggi',
    'ancheggia',
    'ancheggiai',
    'ancheggiammo',
    'ancheggiamo',
    'ancheggiando',
    'ancheggiano',
    'ancheggiante',
    'ancheggianti',
    'ancheggiare',
    'ancheggiasse',
    'ancheggiassi',
    'ancheggiaste',
    'ancheggiasti',
    'ancheggiata',
    'ancheggiate',
    'ancheggiati',
    'ancheggiato',
    'ancheggiava',
    'ancheggiavi',
    'ancheggiavo',
    'ancheggino',
    'ancheggio',
    'anchilosa',
    'anchilosai',
    'anchilosammo',
    'anchilosando',
    'anchilosano',
    'anchilosante',
    'anchilosanti',
    'anchilosarci',
    'anchilosare',
    'anchilosarmi',
    'anchilosarsi',
    'anchilosarti',
    'anchilosarvi',
    'anchilosasse',
    'anchilosassi',
    'anchilosaste',
    'anchilosasti',
    'anchilosata',
    'anchilosate',
    'anchilosati',
    'anchilosato',
    'anchilosava',
    'anchilosavi',
    'anchilosavo',
    'anchilosera',
    'anchiloserai',
    'anchiloserei',
    'anchilosero',
    'anchilosi',
    'anchilosiamo',
    'anchilosiate',
    'anchilosino',
    'anchiloso',
    'anchilostoma',
    'anchilostomi',
    'anchina',
    'anchine',
    'anchini',
    'anchino',
    'anchise',
    'anchor',
    'anchorman',
    'anchormen',
    'anchorwoman',
    'anchorwomen',
    'ancia',
    'ancida',
    'ancidano',
    'ancide',
    'ancidemmo',
    'ancidendo',
    'ancidente',
    'ancidenti',
    'ancidera',
    'anciderai',
    'ancideranno',
    'ancidere',
    'anciderebbe',
    'anciderei',
    'ancideremmo',
    'ancideremo',
    'ancidereste',
    'ancideresti',
    'anciderete',
    'ancidero',
    'ancidesse',
    'ancidessero',
    'ancidessi',
    'ancidessimo',
    'ancideste',
    'ancidesti',
    'ancidete',
    'ancideva',
    'ancidevamo',
    'ancidevano',
    'ancidevate',
    'ancidevi',
    'ancidevo',
    'ancidi',
    'ancidiamo',
    'ancidiate',
    'ancido',
    'ancidono',
    'ancile',
    'ancili',
    'ancilla',
    'ancillare',
    'ancillari',
    'ancillo',
    'ancipite',
    'ancipiti',
    'ancirana',
    'ancirane',
    'ancirani',
    'ancirano',
    'ancisa',
    'ancise',
    'ancisero',
    'ancisi',
    'anciso',
    'anco',
    'ancoi',
    'ancomarzio',
    'ancona',
    'ancone',
    'anconei',
    'anconeo',
    'anconetana',
    'anconetane',
    'anconetani',
    'anconetano',
    'anconetta',
    'anconette',
    'anconitana',
    'anconitane',
    'anconitani',
    'anconitano',
    'ancor',
    'ancora',
    'ancorache',
    'ancoraggi',
    'ancoraggio',
    'ancorai',
    'ancoramenti',
    'ancoramento',
    'ancorammo',
    'ancorando',
    'ancorandoci',
    'ancorandola',
    'ancorandole',
    'ancorandoli',
    'ancorandolo',
    'ancorandomi',
    'ancorandosi',
    'ancorandoti',
    'ancorandovi',
    'ancorano',
    'ancorante',
    'ancoranti',
    'ancorantisi',
    'ancorarci',
    'ancorare',
    'ancorarla',
    'ancorarle',
    'ancorarli',
    'ancorarlo',
    'ancorarmi',
    'ancorarono',
    'ancorarsi',
    'ancorarti',
    'ancorarvi',
    'ancorasse',
    'ancorassero',
    'ancorassi',
    'ancorassimo',
    'ancoraste',
    'ancorasti',
    'ancorata',
    'ancorate',
    'ancoratevi',
    'ancorati',
    'ancoratica',
    'ancoratiche',
    'ancoratici',
    'ancoratico',
    'ancorato',
    'ancoratomi',
    'ancoratoti',
    'ancorava',
    'ancoravamo',
    'ancoravano',
    'ancoravate',
    'ancoravi',
    'ancoravo',
    'ancorche',
    'ancorché',
    'ancore',
    'ancorera',
    'ancorerai',
    'ancoreranno',
    'ancorerebbe',
    'ancorerei',
    'ancoreremmo',
    'ancoreremo',
    'ancorereste',
    'ancoreresti',
    'ancorerete',
    'ancorero',
    'ancoressa',
    'ancoresse',
    'ancoretta',
    'ancorette',
    'ancori',
    'ancoriamo',
    'ancoriamoci',
    'ancoriate',
    'ancorino',
    'ancorizza',
    'ancorizzai',
    'ancorizzammo',
    'ancorizzando',
    'ancorizzano',
    'ancorizzante',
    'ancorizzanti',
    'ancorizzare',
    'ancorizzasse',
    'ancorizzassi',
    'ancorizzaste',
    'ancorizzasti',
    'ancorizzata',
    'ancorizzate',
    'ancorizzati',
    'ancorizzato',
    'ancorizzava',
    'ancorizzavi',
    'ancorizzavo',
    'ancorizzera',
    'ancorizzerai',
    'ancorizzerei',
    'ancorizzero',
    'ancorizzi',
    'ancorizziamo',
    'ancorizziate',
    'ancorizzino',
    'ancorizzo',
    'ancoro',
    'ancorotti',
    'ancorotto',
    'ancorquando',
    'ancude',
    'ancudi',
    'ancudine',
    'ancudini',
    'ancylostoma',
    'anda',
    'andai',
    'andalusa',
    'andaluse',
    'andalusi',
    'andalusia',
    'andalusite',
    'andalusiti',
    'andaluso',
    'andamenti',
    'andamento',
    'andammo',
    'andana',
    'andando',
    'andandoci',
    'andandogli',
    'andandola',
    'andandole',
    'andandoli',
    'andandolo',
    'andandomi',
    'andandosene',
    'andandosi',
    'andandoti',
    'andandovi',
    'andane',
    'andante',
    'andantemente',
    'andanti',
    'andantini',
    'andantino',
    'andantisi',
    'andar',
    'andarcene',
    'andarci',
    'andare',
    'andargli',
    'andari',
    'andarla',
    'andarle',
    'andarli',
    'andarlo',
    'andarmene',
    'andarmi',
    'andarne',
    'andarono',
    'andarsene',
    'andarsi',
    'andartene',
    'andarti',
    'andarvene',
    'andarvi',
    'andasse',
    'andassero',
    'andassi',
    'andassimo',
    'andaste',
    'andasti',
    'andata',
    'andatale',
    'andate',
    'andateci',
    'andategli',
    'andatela',
    'andatele',
    'andateli',
    'andatelo',
    'andatevene',
    'andatevi',
    'andati',
    'andato',
    'andatoia',
    'andatoie',
    'andatomi',
    'andatoti',
    'andatura',
    'andature',
    'andava',
    'andavamo',
    'andavano',
    'andavate',
    'andavi',
    'andavo',
    'andazzi',
    'andazzo',
    'ande',
    'andesite',
    'andesiti',
    'andiamo',
    'andiamocene',
    'andiamoci',
    'andiate',
    'andicap',
    'andicappa',
    'andicappando',
    'andicappano',
    'andicappare',
    'andicappasse',
    'andicappata',
    'andicappate',
    'andicappati',
    'andicappato',
    'andicappava',
    'andicappera',
    'andicappi',
    'andicappiamo',
    'andicappiate',
    'andicappino',
    'andicappo',
    'andina',
    'andine',
    'andini',
    'andino',
    'andirivieni',
    'anditi',
    'andito',
    'ando',
    'andorra',
    'andorrana',
    'andorrane',
    'andorrani',
    'andorrano',
    'andra',
    'andrai',
    'andranno',
    'andre',
    'andrea',
    'andreana',
    'andreano',
    'andreatta',
    'andrebbe',
    'andrebbero',
    'andrei',
    'andreina',
    'andreino',
    'andremmo',
    'andremo',
    'andrena',
    'andrene',
    'andreola',
    'andreolo',
    'andreotti',
    'andreste',
    'andresti',
    'andrete',
    'andretta',
    'andrettina',
    'andreuccia',
    'andreuccio',
    'andria',
    'andrienne',
    'andrietta',
    'andrietto',
    'andro',
    'androcei',
    'androceo',
    'androctoni',
    'androctono',
    'androfobia',
    'androfobie',
    'androgamete',
    'androgameti',
    'androgena',
    'androgene',
    'androgenesi',
    'androgeni',
    'androgenica',
    'androgeniche',
    'androgenici',
    'androgenico',
    'androgeno',
    'androgina',
    'androgine',
    'androgini',
    'androginia',
    'androginica',
    'androginiche',
    'androginici',
    'androginico',
    'androginie',
    'androgino',
    'androide',
    'androidi',
    'androloga',
    'androloghe',
    'andrologi',
    'andrologia',
    'andrologie',
    'andrologo',
    'andromaca',
    'andromachi',
    'andromania',
    'andromanie',
    'androne',
    'androni',
    'andronico',
    'andropausa',
    'andropause',
    'androsace',
    'androsaci',
    'androsterone',
    'androsteroni',
    'andrà',
    'andrè',
    'andrò',
    'andò',
    'anecoica',
    'anecoiche',
    'anecoici',
    'anecoico',
    'anecumene',
    'anecumeni',
    'anecumenica',
    'anecumeniche',
    'anecumenici',
    'anecumenico',
    'aneddoti',
    'aneddotica',
    'aneddotiche',
    'aneddotici',
    'aneddotico',
    'aneddotista',
    'aneddotiste',
    'aneddotisti',
    'aneddoto',
    'anela',
    'anelai',
    'anelammo',
    'anelando',
    'anelano',
    'anelante',
    'anelanti',
    'anelare',
    'anelarono',
    'anelasatica',
    'anelasatiche',
    'anelasatici',
    'anelasatico',
    'anelasse',
    'anelassero',
    'anelassi',
    'anelassimo',
    'anelaste',
    'anelasti',
    'anelastica',
    'anelastiche',
    'anelastici',
    'anelasticita',
    'anelastico',
    'anelata',
    'anelate',
    'anelati',
    'anelato',
    'anelava',
    'anelavamo',
    'anelavano',
    'anelavate',
    'anelavi',
    'anelavo',
    'anele',
    'anelera',
    'anelerai',
    'aneleranno',
    'anelerebbe',
    'anelerebbero',
    'anelerei',
    'aneleremmo',
    'aneleremo',
    'anelereste',
    'aneleresti',
    'anelerete',
    'anelero',
    'anelettrica',
    'anelettriche',
    'anelettrici',
    'anelettrico',
    'aneli',
    'aneliamo',
    'aneliate',
    'anelino',
    'aneliti',
    'anelito',
    'anella',
    'anellacci',
    'anellaccio',
    'anellai',
    'anellamenti',
    'anellamento',
    'anellammo',
    'anellando',
    'anellano',
    'anellante',
    'anellanti',
    'anellare',
    'anellarono',
    'anellasse',
    'anellassero',
    'anellassi',
    'anellassimo',
    'anellaste',
    'anellasti',
    'anellata',
    'anellate',
    'anellati',
    'anellato',
    'anellatura',
    'anellava',
    'anellavamo',
    'anellavano',
    'anellavate',
    'anellavi',
    'anellavo',
    'anellazione',
    'anellazioni',
    'anellera',
    'anellerai',
    'anelleranno',
    'anellerebbe',
    'anellerei',
    'anelleremmo',
    'anelleremo',
    'anellereste',
    'anelleresti',
    'anellerete',
    'anellero',
    'anelletti',
    'anelletto',
    'anelli',
    'anelliamo',
    'anelliate',
    'anellide',
    'anellidi',
    'anellina',
    'anellini',
    'anellino',
    'anello',
    'anellone',
    'anelloni',
    'anellucci',
    'anelluccio',
    'anelo',
    'anelusco',
    'anemia',
    'anemica',
    'anemicamente',
    'anemiche',
    'anemici',
    'anemico',
    'anemie',
    'anemo',
    'anemocora',
    'anemocore',
    'anemocori',
    'anemocoria',
    'anemocorie',
    'anemocoro',
    'anemofila',
    'anemofile',
    'anemofili',
    'anemofilia',
    'anemofilie',
    'anemofilo',
    'anemogama',
    'anemogame',
    'anemogami',
    'anemogamia',
    'anemogamo',
    'anemografi',
    'anemografia',
    'anemografie',
    'anemografo',
    'anemometri',
    'anemometria',
    'anemometrica',
    'anemometrici',
    'anemometrico',
    'anemometrie',
    'anemometro',
    'anemone',
    'anemoni',
    'anemoscopi',
    'anemoscopio',
    'anencefalia',
    'anencefalie',
    'anepigrafa',
    'anepigrafe',
    'anepigrafi',
    'anepigrafo',
    'anergia',
    'anergie',
    'anergizzante',
    'anergizzanti',
    'anerobi',
    'anerobica',
    'anerobiche',
    'anerobici',
    'anerobico',
    'anerobio',
    'anerobiosi',
    'aneroide',
    'aneroidi',
    'anerotica',
    'anerotiche',
    'anerotici',
    'anerotico',
    'anesia',
    'anespie',
    'anesteia',
    'anestesia',
    'anestesie',
    'anestesista',
    'anestesiste',
    'anestesisti',
    'anestetica',
    'anestetiche',
    'anestetici',
    'anestetico',
    'anestetizza',
    'anestetizzai',
    'anestetizzi',
    'anestetizzo',
    'anestro',
    'aneti',
    'aneto',
    'aneuploidia',
    'aneurina',
    'aneurine',
    'aneurisma',
    'aneurismi',
    'anfana',
    'anfanai',
    'anfanamenti',
    'anfanamento',
    'anfanammo',
    'anfanando',
    'anfanano',
    'anfanante',
    'anfananti',
    'anfanare',
    'anfanarono',
    'anfanasse',
    'anfanassero',
    'anfanassi',
    'anfanassimo',
    'anfanaste',
    'anfanasti',
    'anfanata',
    'anfanate',
    'anfanati',
    'anfanato',
    'anfanava',
    'anfanavamo',
    'anfanavano',
    'anfanavate',
    'anfanavi',
    'anfanavo',
    'anfaneggi',
    'anfaneggia',
    'anfaneggiano',
    'anfaneggiare',
    'anfaneggiato',
    'anfaneggiava',
    'anfaneggino',
    'anfanera',
    'anfanerai',
    'anfaneranno',
    'anfanerebbe',
    'anfanerei',
    'anfaneremmo',
    'anfaneremo',
    'anfanereste',
    'anfaneresti',
    'anfanerete',
    'anfanero',
    'anfani',
    'anfaniamo',
    'anfaniate',
    'anfanino',
    'anfano',
    'anfesibena',
    'anfetamina',
    'anfetamine',
    'anfetammina',
    'anfetammine',
    'anfi',
    'anfiarao',
    'anfiartrosi',
    'anfibi',
    'anfibia',
    'anfibie',
    'anfibio',
    'anfibiotica',
    'anfibiotiche',
    'anfibiotici',
    'anfibiotico',
    'anfibola',
    'anfibole',
    'anfiboli',
    'anfibolia',
    'anfibolie',
    'anfibolite',
    'anfiboliti',
    'anfibolo',
    'anfibologia',
    'anfibologica',
    'anfibologici',
    'anfibologico',
    'anfibologie',
    'anfibrachi',
    'anfibraco',
    'anfidroma',
    'anfidrome',
    'anfidromi',
    'anfidromo',
    'anfifilica',
    'anfifiliche',
    'anfifilici',
    'anfifilico',
    'anfigonia',
    'anfigonica',
    'anfigoniche',
    'anfigonici',
    'anfigonico',
    'anfigonie',
    'anfimacri',
    'anfimacro',
    'anfineuri',
    'anfineuro',
    'anfiossi',
    'anfiosso',
    'anfipode',
    'anfipodi',
    'anfiprostila',
    'anfiprostile',
    'anfiprostili',
    'anfiprostilo',
    'anfisbena',
    'anfisbene',
    'anfisibena',
    'anfisibene',
    'anfiteatri',
    'anfiteatro',
    'anfitrione',
    'anfitrioni',
    'anfizioni',
    'anfizionia',
    'anfizionica',
    'anfizioniche',
    'anfizionici',
    'anfizionico',
    'anfizionie',
    'anfoliti',
    'anfolito',
    'anfora',
    'anfore',
    'anforetta',
    'anforette',
    'anfotera',
    'anfotere',
    'anfoteri',
    'anfoterismo',
    'anfotero',
    'anfratti',
    'anfratto',
    'anfrattuosa',
    'anfrattuose',
    'anfrattuosi',
    'anfrattuoso',
    'angami',
    'angamo',
    'angar',
    'angari',
    'angaria',
    'angariai',
    'angariammo',
    'angariamo',
    'angariando',
    'angariano',
    'angariante',
    'angarianti',
    'angariare',
    'angariarono',
    'angariasse',
    'angariassero',
    'angariassi',
    'angariassimo',
    'angariaste',
    'angariasti',
    'angariata',
    'angariate',
    'angariati',
    'angariato',
    'angariatore',
    'angariatori',
    'angariatrice',
    'angariatrici',
    'angariava',
    'angariavamo',
    'angariavano',
    'angariavate',
    'angariavi',
    'angariavo',
    'angarie',
    'angariera',
    'angarierai',
    'angarieranno',
    'angarierebbe',
    'angarierei',
    'angarieremmo',
    'angarieremo',
    'angariereste',
    'angarieresti',
    'angarierete',
    'angariero',
    'angarino',
    'angario',
    'ange',
    'angela',
    'angelamaria',
    'angelantonio',
    'angelarosa',
    'angele',
    'angelena',
    'angelene',
    'angeleni',
    'angeleno',
    'angeles',
    'angeletta',
    'angelette',
    'angeli',
    'angelica',
    'angelicale',
    'angelicali',
    'angelicando',
    'angelicare',
    'angelicarsi',
    'angelicata',
    'angelicate',
    'angelicati',
    'angelicato',
    'angeliche',
    'angelici',
    'angelicita',
    'angelico',
    'angelina',
    'angelino',
    'angelita',
    'angelman',
    'angelo',
    'angelolatria',
    'angelolatrie',
    'angelologia',
    'angelologie',
    'angelomaria',
    'angelus',
    'angere',
    'angheria',
    'angherie',
    'angi',
    'angilberto',
    'angina',
    'angine',
    'anginosa',
    'anginose',
    'anginosi',
    'anginoso',
    'angio',
    'angiocarpa',
    'angiocarpe',
    'angiocarpi',
    'angiocarpo',
    'angiocolite',
    'angiocoliti',
    'angioedema',
    'angiofibroma',
    'angiografia',
    'angiografica',
    'angiografici',
    'angiografico',
    'angiografie',
    'angiogramma',
    'angiogrammi',
    'angioidi',
    'angioina',
    'angioine',
    'angioini',
    'angioino',
    'angioite',
    'angioiti',
    'angiola',
    'angiolamaria',
    'angiole',
    'angioletta',
    'angiolette',
    'angioletti',
    'angioletto',
    'angioli',
    'angiolina',
    'angioline',
    'angiolini',
    'angiolino',
    'angiolipoma',
    'angiolo',
    'angiologa',
    'angiologhe',
    'angiologi',
    'angiologia',
    'angiologie',
    'angiologo',
    'angiolone',
    'angioloni',
    'angioma',
    'angiomatosi',
    'angiomatoso',
    'angiomi',
    'angiomioma',
    'angioneurosi',
    'angiopatia',
    'angiopatie',
    'angiopl',
    'angiosarcoma',
    'angiosarcomi',
    'angioscopia',
    'angiospasmi',
    'angiospasmo',
    'angiosperma',
    'angiosperme',
    'angiospermi',
    'angiospermo',
    'angiotensina',
    'angiporti',
    'angiporto',
    'angiò',
    'angla',
    'angle',
    'anglesite',
    'anglesiti',
    'angli',
    'anglica',
    'anglicana',
    'anglicane',
    'anglicani',
    'anglicanismi',
    'anglicanismo',
    'anglicano',
    'angliche',
    'anglici',
    'anglicismi',
    'anglicismo',
    'anglicizza',
    'anglicizzai',
    'anglicizzano',
    'anglicizzare',
    'anglicizzata',
    'anglicizzate',
    'anglicizzati',
    'anglicizzato',
    'anglicizzava',
    'anglicizzavi',
    'anglicizzavo',
    'anglicizzera',
    'anglicizzero',
    'anglicizzi',
    'anglicizzino',
    'anglicizzo',
    'anglico',
    'anglismi',
    'anglismo',
    'anglista',
    'angliste',
    'anglisti',
    'anglistica',
    'anglistiche',
    'anglo',
    'anglobecera',
    'anglobecere',
    'anglobeceri',
    'anglobecero',
    'anglofila',
    'anglofile',
    'anglofili',
    'anglofilia',
    'anglofilie',
    'anglofilo',
    'anglofoba',
    'anglofobe',
    'anglofobi',
    'anglofobia',
    'anglofobie',
    'anglofobo',
    'anglofona',
    'anglofone',
    'anglofoni',
    'anglofono',
    'anglomane',
    'anglomani',
    'anglomania',
    'anglomanie',
    'anglosassone',
    'anglosassoni',
    'angola',
    'angolai',
    'angolammo',
    'angolana',
    'angolando',
    'angolane',
    'angolani',
    'angolano',
    'angolante',
    'angolanti',
    'angolar',
    'angolare',
    'angolari',
    'angolarita',
    'angolarmente',
    'angolarono',
    'angolasse',
    'angolassero',
    'angolassi',
    'angolassimo',
    'angolaste',
    'angolasti',
    'angolata',
    'angolate',
    'angolati',
    'angolato',
    'angolatura',
    'angolature',
    'angolava',
    'angolavamo',
    'angolavano',
    'angolavate',
    'angolavi',
    'angolavo',
    'angolazione',
    'angolazioni',
    'angolera',
    'angolerai',
    'angoleranno',
    'angolerebbe',
    'angolerei',
    'angoleremmo',
    'angoleremo',
    'angolereste',
    'angoleresti',
    'angolerete',
    'angolero',
    'angoletti',
    'angoletto',
    'angoli',
    'angoliamo',
    'angoliate',
    'angoliera',
    'angoliere',
    'angolini',
    'angolino',
    'angolista',
    'angoliste',
    'angolisti',
    'angolo',
    'angoloide',
    'angoloidi',
    'angolosa',
    'angolose',
    'angolosi',
    'angolosita',
    'angolosità',
    'angoloso',
    'angora',
    'angore',
    'angosce',
    'angoscera',
    'angoscerai',
    'angosceranno',
    'angoscerebbe',
    'angoscerei',
    'angosceremmo',
    'angosceremo',
    'angoscereste',
    'angosceresti',
    'angoscerete',
    'angoscero',
    'angosci',
    'angoscia',
    'angosciai',
    'angosciammo',
    'angosciamo',
    'angosciamoci',
    'angosciando',
    'angosciano',
    'angosciante',
    'angoscianti',
    'angosciarci',
    'angosciare',
    'angosciarla',
    'angosciarle',
    'angosciarli',
    'angosciarlo',
    'angosciarmi',
    'angosciarono',
    'angosciarsi',
    'angosciarti',
    'angosciarvi',
    'angosciasse',
    'angosciassi',
    'angosciaste',
    'angosciasti',
    'angosciata',
    'angosciate',
    'angosciatevi',
    'angosciati',
    'angosciato',
    'angosciatomi',
    'angosciatoti',
    'angosciava',
    'angosciavamo',
    'angosciavano',
    'angosciavate',
    'angosciavi',
    'angosciavo',
    'angoscino',
    'angoscio',
    'angosciosa',
    'angosciose',
    'angosciosi',
    'angoscioso',
    'angostura',
    'angosture',
    'angstrom',
    'angue',
    'angui',
    'anguicrinita',
    'anguicrinite',
    'anguicriniti',
    'anguicrinito',
    'anguide',
    'anguidi',
    'anguilla',
    'anguillaia',
    'anguillaie',
    'anguille',
    'anguilleggia',
    'anguilleggio',
    'anguillesca',
    'anguillesche',
    'anguilleschi',
    'anguillesco',
    'anguilletta',
    'anguillette',
    'anguillula',
    'anguillule',
    'anguinaia',
    'anguinaie',
    'anguinea',
    'anguinee',
    'anguinei',
    'anguineo',
    'anguipede',
    'anguipedi',
    'anguistara',
    'anguistare',
    'angulinervi',
    'angulinervia',
    'angulinervie',
    'angulinervio',
    'anguria',
    'angurie',
    'angusta',
    'angustamente',
    'anguste',
    'angusti',
    'angustia',
    'angustiai',
    'angustiammo',
    'angustiamo',
    'angustiamoci',
    'angustiando',
    'angustiano',
    'angustiante',
    'angustianti',
    'angustiarci',
    'angustiare',
    'angustiarla',
    'angustiarle',
    'angustiarli',
    'angustiarlo',
    'angustiarmi',
    'angustiarono',
    'angustiarsi',
    'angustiarti',
    'angustiarvi',
    'angustiasse',
    'angustiassi',
    'angustiaste',
    'angustiasti',
    'angustiata',
    'angustiate',
    'angustiatevi',
    'angustiati',
    'angustiato',
    'angustiatomi',
    'angustiatoti',
    'angustiava',
    'angustiavamo',
    'angustiavano',
    'angustiavate',
    'angustiavi',
    'angustiavo',
    'angusticlavi',
    'angustie',
    'angustiera',
    'angustierai',
    'angustierei',
    'angustieremo',
    'angustierete',
    'angustiero',
    'angustino',
    'angustio',
    'angustiosa',
    'angustiose',
    'angustiosi',
    'angustioso',
    'angusto',
    'angustura',
    'angusture',
    'anice',
    'aniceta',
    'aniceto',
    'anicetta',
    'anici',
    'anicini',
    'anicino',
    'anicione',
    'anicioni',
    'aniconica',
    'aniconiche',
    'aniconici',
    'aniconicita',
    'aniconico',
    'anidra',
    'anidre',
    'anidri',
    'anidride',
    'anidridi',
    'anidrite',
    'anidriti',
    'anidro',
    'anidrosi',
    'anidrotico',
    'aniella',
    'aniello',
    'anile',
    'anili',
    'anilina',
    'aniline',
    'anima',
    'animabile',
    'animabili',
    'animacce',
    'animaccia',
    'animai',
    'animalacci',
    'animalaccio',
    'animale',
    'animaleria',
    'animalerie',
    'animalesca',
    'animalesche',
    'animaleschi',
    'animalesco',
    'animaletti',
    'animaletto',
    'animali',
    'animalini',
    'animalino',
    'animalismi',
    'animalismo',
    'animalista',
    'animaliste',
    'animalisti',
    'animalistica',
    'animalistici',
    'animalistico',
    'animalita',
    'animalità',
    'animalmente',
    'animalone',
    'animaloni',
    'animalucci',
    'animaluccio',
    'animammo',
    'animando',
    'animandoci',
    'animandomi',
    'animandosi',
    'animandoti',
    'animandovi',
    'animano',
    'animante',
    'animanti',
    'animantisi',
    'animarci',
    'animare',
    'animarmi',
    'animarono',
    'animarsi',
    'animarti',
    'animarvi',
    'animasse',
    'animassero',
    'animassi',
    'animassimo',
    'animaste',
    'animasti',
    'animata',
    'animatamente',
    'animate',
    'animatevi',
    'animatezza',
    'animatezze',
    'animati',
    'animato',
    'animatomi',
    'animatore',
    'animatori',
    'animatoti',
    'animatrice',
    'animatrici',
    'animava',
    'animavamo',
    'animavano',
    'animavate',
    'animavi',
    'animavo',
    'animazione',
    'animazioni',
    'anime',
    'animella',
    'animelle',
    'animera',
    'animerai',
    'animeranno',
    'animerebbe',
    'animerebbero',
    'animerei',
    'animeremmo',
    'animeremo',
    'animereste',
    'animeresti',
    'animerete',
    'animero',
    'animetta',
    'animette',
    'animi',
    'animiamo',
    'animiamoci',
    'animiate',
    'animiforme',
    'animiformi',
    'animina',
    'animine',
    'animino',
    'animismi',
    'animismo',
    'animista',
    'animiste',
    'animisti',
    'animistica',
    'animistiche',
    'animistici',
    'animistico',
    'animo',
    'animosa',
    'animosamente',
    'animose',
    'animosi',
    'animosita',
    'animosità',
    'animoso',
    'animucce',
    'animuccia',
    'animula',
    'animule',
    'animò',
    'aninali',
    'aninga',
    'aninghe',
    'anione',
    'anioni',
    'aniridia',
    'anisachiasi',
    'anisakiasi',
    'anisakis',
    'aniseiconia',
    'anisetta',
    'anisette',
    'aniso',
    'anisocitosi',
    'anisocoria',
    'anisocorie',
    'anisofillia',
    'anisofillie',
    'anisogamete',
    'anisogameti',
    'anisogamia',
    'anisogamie',
    'anisoiconia',
    'anisotropa',
    'anisotrope',
    'anisotropi',
    'anisotropia',
    'anisotropie',
    'anisotropo',
    'anita',
    'anito',
    'anitra',
    'anitre',
    'anitroccoli',
    'anitroccolo',
    'anjou',
    'ankara',
    'ankyrin',
    'anna',
    'annabella',
    'annachiara',
    'annacqua',
    'annacquai',
    'annacquammo',
    'annacquando',
    'annacquano',
    'annacquante',
    'annacquanti',
    'annacquare',
    'annacquarono',
    'annacquasse',
    'annacquassi',
    'annacquaste',
    'annacquasti',
    'annacquata',
    'annacquate',
    'annacquati',
    'annacquato',
    'annacquatura',
    'annacquature',
    'annacquava',
    'annacquavamo',
    'annacquavano',
    'annacquavate',
    'annacquavi',
    'annacquavo',
    'annacquera',
    'annacquerai',
    'annacquerei',
    'annacqueremo',
    'annacquerete',
    'annacquero',
    'annacqui',
    'annacquiamo',
    'annacquiate',
    'annacquino',
    'annacquo',
    'annaffi',
    'annaffia',
    'annaffiai',
    'annaffiammo',
    'annaffiamo',
    'annaffiando',
    'annaffiano',
    'annaffiante',
    'annaffianti',
    'annaffiare',
    'annaffiarono',
    'annaffiasse',
    'annaffiassi',
    'annaffiaste',
    'annaffiasti',
    'annaffiata',
    'annaffiate',
    'annaffiati',
    'annaffiatina',
    'annaffiatine',
    'annaffiato',
    'annaffiatoi',
    'annaffiatoio',
    'annaffiatore',
    'annaffiatori',
    'annaffiatura',
    'annaffiature',
    'annaffiava',
    'annaffiavamo',
    'annaffiavano',
    'annaffiavate',
    'annaffiavi',
    'annaffiavo',
    'annaffiera',
    'annaffierai',
    'annaffierei',
    'annaffieremo',
    'annaffierete',
    'annaffiero',
    'annaffino',
    'annaffio',
    'annaflavia',
    'annagrazia',
    'annalaura',
    'annali',
    'annalia',
    'annalisa',
    'annalista',
    'annaliste',
    'annalisti',
    'annalistica',
    'annalistiche',
    'annalistici',
    'annalistico',
    'annaluisa',
    'annam',
    'annamaria',
    'annamita',
    'annamite',
    'annamiti',
    'annamitica',
    'annamitiche',
    'annamitici',
    'annamitico',
    'annarella',
    'annarita',
    'annarosa',
    'annasa',
    'annasando',
    'annasano',
    'annasare',
    'annasato',
    'annaspa',
    'annaspai',
    'annaspammo',
    'annaspando',
    'annaspano',
    'annaspante',
    'annaspanti',
    'annaspare',
    'annasparono',
    'annaspasse',
    'annaspassero',
    'annaspassi',
    'annaspassimo',
    'annaspaste',
    'annaspasti',
    'annaspata',
    'annaspate',
    'annaspati',
    'annaspato',
    'annaspava',
    'annaspavamo',
    'annaspavano',
    'annaspavate',
    'annaspavi',
    'annaspavo',
    'annaspera',
    'annasperai',
    'annasperanno',
    'annasperebbe',
    'annasperei',
    'annasperemmo',
    'annasperemo',
    'annaspereste',
    'annasperesti',
    'annasperete',
    'annaspero',
    'annaspi',
    'annaspiamo',
    'annaspiate',
    'annaspica',
    'annaspicai',
    'annaspicammo',
    'annaspicando',
    'annaspicano',
    'annaspicante',
    'annaspicanti',
    'annaspicare',
    'annaspicasse',
    'annaspicassi',
    'annaspicaste',
    'annaspicasti',
    'annaspicata',
    'annaspicate',
    'annaspicati',
    'annaspicato',
    'annaspicava',
    'annaspicavi',
    'annaspicavo',
    'annaspichera',
    'annaspichero',
    'annaspichi',
    'annaspichino',
    'annaspico',
    'annaspii',
    'annaspino',
    'annaspio',
    'annaspo',
    'annaspona',
    'annaspone',
    'annata',
    'annatacce',
    'annataccia',
    'annate',
    'annatina',
    'annatine',
    'annatti',
    'annatto',
    'anne',
    'annebbi',
    'annebbia',
    'annebbiai',
    'annebbiammo',
    'annebbiamo',
    'annebbiamoci',
    'annebbiando',
    'annebbiano',
    'annebbiante',
    'annebbianti',
    'annebbiarci',
    'annebbiare',
    'annebbiarmi',
    'annebbiarono',
    'annebbiarsi',
    'annebbiarti',
    'annebbiarvi',
    'annebbiasse',
    'annebbiassi',
    'annebbiaste',
    'annebbiasti',
    'annebbiata',
    'annebbiate',
    'annebbiatevi',
    'annebbiati',
    'annebbiato',
    'annebbiatomi',
    'annebbiatoti',
    'annebbiava',
    'annebbiavamo',
    'annebbiavano',
    'annebbiavate',
    'annebbiavi',
    'annebbiavo',
    'annebbiera',
    'annebbierai',
    'annebbierei',
    'annebbieremo',
    'annebbierete',
    'annebbiero',
    'annebbino',
    'annebbio',
    'annega',
    'annegai',
    'annegamenti',
    'annegamento',
    'annegammo',
    'annegando',
    'annegandoci',
    'annegandomi',
    'annegandosi',
    'annegandoti',
    'annegandovi',
    'annegano',
    'annegante',
    'anneganti',
    'annegantisi',
    'annegarci',
    'annegare',
    'annegarmi',
    'annegarono',
    'annegarsi',
    'annegarti',
    'annegarvi',
    'annegasse',
    'annegassero',
    'annegassi',
    'annegassimo',
    'annegaste',
    'annegasti',
    'annegata',
    'annegate',
    'annegatevi',
    'annegati',
    'annegato',
    'annegatomi',
    'annegatoti',
    'annegava',
    'annegavamo',
    'annegavano',
    'annegavate',
    'annegavi',
    'annegavo',
    'annegazione',
    'anneghera',
    'annegherai',
    'annegheranno',
    'annegherebbe',
    'annegherei',
    'annegheremmo',
    'annegheremo',
    'anneghereste',
    'annegheresti',
    'annegherete',
    'anneghero',
    'anneghi',
    'anneghiamo',
    'anneghiamoci',
    'anneghiate',
    'anneghino',
    'anneghitti',
    'anneghittii',
    'anneghittira',
    'anneghittire',
    'anneghittiro',
    'anneghittita',
    'anneghittite',
    'anneghittiti',
    'anneghittito',
    'anneghittiva',
    'anneghittivi',
    'anneghittivo',
    'annego',
    'annelida',
    'annella',
    'annera',
    'annerai',
    'anneramenti',
    'anneramento',
    'annerammo',
    'annerando',
    'annerano',
    'annerante',
    'anneranti',
    'annerare',
    'annerarono',
    'annerasse',
    'annerassero',
    'annerassi',
    'annerassimo',
    'anneraste',
    'annerasti',
    'annerata',
    'annerate',
    'annerati',
    'annerato',
    'annerava',
    'anneravamo',
    'anneravano',
    'anneravate',
    'anneravi',
    'anneravo',
    'annerendo',
    'annerendoci',
    'annerendomi',
    'annerendosi',
    'annerendoti',
    'annerendovi',
    'annerente',
    'annerenti',
    'annerentisi',
    'annerera',
    'annererai',
    'annereranno',
    'annererebbe',
    'annererei',
    'annereremmo',
    'annereremo',
    'annerereste',
    'annereresti',
    'annererete',
    'annerero',
    'anneri',
    'anneriamo',
    'anneriamoci',
    'anneriate',
    'annerii',
    'annerimenti',
    'annerimento',
    'annerimmo',
    'annerino',
    'annerira',
    'annerirai',
    'anneriranno',
    'annerirci',
    'annerire',
    'annerirebbe',
    'annerirei',
    'anneriremmo',
    'anneriremo',
    'annerireste',
    'anneriresti',
    'annerirete',
    'annerirmi',
    'anneriro',
    'annerirono',
    'annerirsi',
    'annerirti',
    'annerirvi',
    'annerisca',
    'anneriscano',
    'annerisce',
    'annerisci',
    'annerisciti',
    'annerisco',
    'anneriscono',
    'annerisse',
    'annerissero',
    'annerissi',
    'annerissimo',
    'anneriste',
    'anneristi',
    'annerita',
    'annerite',
    'anneritevi',
    'anneriti',
    'annerito',
    'anneritomi',
    'anneritoti',
    'anneritura',
    'anneriture',
    'anneriva',
    'annerivamo',
    'annerivano',
    'annerivate',
    'annerivi',
    'annerivo',
    'annero',
    'annessa',
    'annesse',
    'annessi',
    'annessione',
    'annessioni',
    'annessite',
    'annessiti',
    'annesso',
    'annestare',
    'annetta',
    'annettano',
    'annette',
    'annettei',
    'annettemmo',
    'annettendo',
    'annettente',
    'annettenti',
    'annettera',
    'annetterai',
    'annetteranno',
    'annettere',
    'annetterebbe',
    'annetterei',
    'annetteremmo',
    'annetteremo',
    'annettereste',
    'annetteresti',
    'annetterete',
    'annettero',
    'annetterono',
    'annettersi',
    'annettesse',
    'annettessero',
    'annettessi',
    'annettessimo',
    'annetteste',
    'annettesti',
    'annettete',
    'annetteva',
    'annettevamo',
    'annettevano',
    'annettevate',
    'annettevi',
    'annettevo',
    'annetti',
    'annettiamo',
    'annettiate',
    'annettina',
    'annetto',
    'annettono',
    'annevrotiche',
    'annevrotici',
    'anni',
    'annibala',
    'annibale',
    'annibalica',
    'annibaliche',
    'annibalici',
    'annibalico',
    'annibalina',
    'annichila',
    'annichilai',
    'annichilammo',
    'annichilando',
    'annichilano',
    'annichilante',
    'annichilanti',
    'annichilarci',
    'annichilare',
    'annichilarmi',
    'annichilarsi',
    'annichilarti',
    'annichilarvi',
    'annichilasse',
    'annichilassi',
    'annichilaste',
    'annichilasti',
    'annichilata',
    'annichilate',
    'annichilati',
    'annichilato',
    'annichilava',
    'annichilavi',
    'annichilavo',
    'annichilendo',
    'annichilente',
    'annichilenti',
    'annichilera',
    'annichilerai',
    'annichilerei',
    'annichilero',
    'annichili',
    'annichiliamo',
    'annichiliate',
    'annichilii',
    'annichilimmo',
    'annichilino',
    'annichilira',
    'annichilirai',
    'annichilirci',
    'annichilire',
    'annichilirei',
    'annichilirmi',
    'annichiliro',
    'annichilirsi',
    'annichilirti',
    'annichilirvi',
    'annichilisca',
    'annichilisce',
    'annichilisci',
    'annichilisco',
    'annichilisse',
    'annichilissi',
    'annichiliste',
    'annichilisti',
    'annichilita',
    'annichilite',
    'annichiliti',
    'annichilito',
    'annichiliva',
    'annichilivi',
    'annichilivo',
    'annichilo',
    'annico',
    'annida',
    'annidai',
    'annidamenti',
    'annidamento',
    'annidammo',
    'annidando',
    'annidandoci',
    'annidandomi',
    'annidandosi',
    'annidandoti',
    'annidandovi',
    'annidano',
    'annidante',
    'annidanti',
    'annidantisi',
    'annidarci',
    'annidare',
    'annidarmi',
    'annidarono',
    'annidarsi',
    'annidarti',
    'annidarvi',
    'annidasse',
    'annidassero',
    'annidassi',
    'annidassimo',
    'annidaste',
    'annidasti',
    'annidata',
    'annidate',
    'annidatevi',
    'annidati',
    'annidato',
    'annidatomi',
    'annidatoti',
    'annidava',
    'annidavamo',
    'annidavano',
    'annidavate',
    'annidavi',
    'annidavo',
    'annidera',
    'anniderai',
    'annideranno',
    'anniderebbe',
    'anniderei',
    'annideremmo',
    'annideremo',
    'annidereste',
    'annideresti',
    'anniderete',
    'annidero',
    'annidi',
    'annidiamo',
    'annidiamoci',
    'annidiate',
    'annidino',
    'annido',
    'annienta',
    'annientai',
    'annientammo',
    'annientando',
    'annientano',
    'annientante',
    'annientanti',
    'annientarci',
    'annientare',
    'annientarla',
    'annientarle',
    'annientarli',
    'annientarlo',
    'annientarmi',
    'annientarono',
    'annientarsi',
    'annientarti',
    'annientarvi',
    'annientasse',
    'annientassi',
    'annientaste',
    'annientasti',
    'annientata',
    'annientate',
    'annientatevi',
    'annientati',
    'annientato',
    'annientatomi',
    'annientatoti',
    'annientava',
    'annientavamo',
    'annientavano',
    'annientavate',
    'annientavi',
    'annientavo',
    'annientera',
    'annienterai',
    'annienterei',
    'annienteremo',
    'annienterete',
    'annientero',
    'annienti',
    'annientiamo',
    'annientiate',
    'annientino',
    'anniento',
    'annina',
    'annino',
    'annio',
    'annita',
    'annito',
    'annitrendo',
    'annitrente',
    'annitrenti',
    'annitri',
    'annitriamo',
    'annitriate',
    'annitrii',
    'annitrimmo',
    'annitrira',
    'annitrirai',
    'annitriranno',
    'annitrire',
    'annitrirebbe',
    'annitrirei',
    'annitriremmo',
    'annitriremo',
    'annitrireste',
    'annitriresti',
    'annitrirete',
    'annitriro',
    'annitrirono',
    'annitrisca',
    'annitriscano',
    'annitrisce',
    'annitrisci',
    'annitrisco',
    'annitriscono',
    'annitrisse',
    'annitrissero',
    'annitrissi',
    'annitrissimo',
    'annitriste',
    'annitristi',
    'annitrita',
    'annitrite',
    'annitriti',
    'annitrito',
    'annitriva',
    'annitrivamo',
    'annitrivano',
    'annitrivate',
    'annitrivi',
    'annitrivo',
    'anniversari',
    'anniversaria',
    'anniversarie',
    'anniversario',
    'anno',
    'annobilendo',
    'annobilente',
    'annobilenti',
    'annobili',
    'annobiliamo',
    'annobiliate',
    'annobilii',
    'annobilimmo',
    'annobilira',
    'annobilirai',
    'annobilire',
    'annobilirei',
    'annobiliremo',
    'annobilirete',
    'annobiliro',
    'annobilirono',
    'annobilisca',
    'annobilisce',
    'annobilisci',
    'annobilisco',
    'annobilisse',
    'annobilissi',
    'annobiliste',
    'annobilisti',
    'annobilita',
    'annobilite',
    'annobiliti',
    'annobilito',
    'annobiliva',
    'annobilivamo',
    'annobilivano',
    'annobilivate',
    'annobilivi',
    'annobilivo',
    'annocca',
    'annoccai',
    'annoccammo',
    'annoccando',
    'annoccandoci',
    'annoccandomi',
    'annoccandosi',
    'annoccandoti',
    'annoccandovi',
    'annoccano',
    'annoccante',
    'annoccanti',
    'annoccantisi',
    'annoccarci',
    'annoccare',
    'annoccarmi',
    'annoccarono',
    'annoccarsi',
    'annoccarti',
    'annoccarvi',
    'annoccasse',
    'annoccassero',
    'annoccassi',
    'annoccassimo',
    'annoccaste',
    'annoccasti',
    'annoccata',
    'annoccate',
    'annoccatevi',
    'annoccati',
    'annoccato',
    'annoccatomi',
    'annoccatoti',
    'annoccava',
    'annoccavamo',
    'annoccavano',
    'annoccavate',
    'annoccavi',
    'annoccavo',
    'annocchera',
    'annoccherai',
    'annoccherei',
    'annoccheremo',
    'annoccherete',
    'annocchero',
    'annocchi',
    'annocchiamo',
    'annocchiate',
    'annocchino',
    'annocco',
    'annoda',
    'annodai',
    'annodamenti',
    'annodamento',
    'annodammo',
    'annodando',
    'annodandoci',
    'annodandola',
    'annodandole',
    'annodandoli',
    'annodandolo',
    'annodandomi',
    'annodandosi',
    'annodandoti',
    'annodandovi',
    'annodano',
    'annodante',
    'annodanti',
    'annodantisi',
    'annodarci',
    'annodare',
    'annodarla',
    'annodarle',
    'annodarli',
    'annodarlo',
    'annodarmi',
    'annodarono',
    'annodarsi',
    'annodarti',
    'annodarvi',
    'annodasse',
    'annodassero',
    'annodassi',
    'annodassimo',
    'annodaste',
    'annodasti',
    'annodata',
    'annodate',
    'annodatevi',
    'annodati',
    'annodato',
    'annodatomi',
    'annodatoti',
    'annodatura',
    'annodature',
    'annodava',
    'annodavamo',
    'annodavano',
    'annodavate',
    'annodavi',
    'annodavo',
    'annodera',
    'annoderai',
    'annoderanno',
    'annoderebbe',
    'annoderei',
    'annoderemmo',
    'annoderemo',
    'annodereste',
    'annoderesti',
    'annoderete',
    'annodero',
    'annodi',
    'annodiamo',
    'annodiamoci',
    'annodiate',
    'annodino',
    'annodo',
    'annoi',
    'annoia',
    'annoiai',
    'annoiammo',
    'annoiamo',
    'annoiamoci',
    'annoiando',
    'annoiandoci',
    'annoiandola',
    'annoiandole',
    'annoiandoli',
    'annoiandolo',
    'annoiandomi',
    'annoiandosi',
    'annoiandoti',
    'annoiandovi',
    'annoiano',
    'annoiante',
    'annoianti',
    'annoiantisi',
    'annoiarci',
    'annoiare',
    'annoiarla',
    'annoiarle',
    'annoiarli',
    'annoiarlo',
    'annoiarmi',
    'annoiarono',
    'annoiarsi',
    'annoiarti',
    'annoiarvi',
    'annoiasse',
    'annoiassero',
    'annoiassi',
    'annoiassimo',
    'annoiaste',
    'annoiasti',
    'annoiata',
    'annoiate',
    'annoiatemi',
    'annoiatevi',
    'annoiati',
    'annoiato',
    'annoiatomi',
    'annoiatore',
    'annoiatori',
    'annoiatoti',
    'annoiatrice',
    'annoiatrici',
    'annoiava',
    'annoiavamo',
    'annoiavano',
    'annoiavate',
    'annoiavi',
    'annoiavo',
    'annoiera',
    'annoierai',
    'annoieranno',
    'annoierebbe',
    'annoierei',
    'annoieremmo',
    'annoieremo',
    'annoiereste',
    'annoieresti',
    'annoierete',
    'annoiero',
    'annoino',
    'annoio',
    'annona',
    'annonari',
    'annonaria',
    'annonarie',
    'annonario',
    'annone',
    'annosa',
    'annosamente',
    'annose',
    'annosi',
    'annosita',
    'annosità',
    'annoso',
    'annota',
    'annotai',
    'annotala',
    'annotale',
    'annotali',
    'annotalo',
    'annotammo',
    'annotando',
    'annotandola',
    'annotandole',
    'annotandoli',
    'annotandolo',
    'annotano',
    'annotante',
    'annotanti',
    'annotare',
    'annotarla',
    'annotarle',
    'annotarli',
    'annotarlo',
    'annotarono',
    'annotasse',
    'annotassero',
    'annotassi',
    'annotassimo',
    'annotaste',
    'annotasti',
    'annotata',
    'annotate',
    'annotatela',
    'annotatele',
    'annotateli',
    'annotatelo',
    'annotati',
    'annotato',
    'annotatore',
    'annotatori',
    'annotatrice',
    'annotatrici',
    'annotava',
    'annotavamo',
    'annotavano',
    'annotavate',
    'annotavi',
    'annotavo',
    'annotazione',
    'annotazioni',
    'annotera',
    'annoterai',
    'annoteranno',
    'annoterebbe',
    'annoterei',
    'annoteremmo',
    'annoteremo',
    'annotereste',
    'annoteresti',
    'annoterete',
    'annotero',
    'annoti',
    'annotiamo',
    'annotiate',
    'annotino',
    'annoto',
    'annotta',
    'annottando',
    'annottandosi',
    'annottano',
    'annottante',
    'annottare',
    'annottarono',
    'annottarsi',
    'annottasse',
    'annottassero',
    'annottata',
    'annottate',
    'annottati',
    'annottato',
    'annottava',
    'annottavano',
    'annottera',
    'annotteranno',
    'annotterebbe',
    'annotti',
    'annottino',
    'annotto',
    'annovale',
    'annovali',
    'annovera',
    'annoverabile',
    'annoverabili',
    'annoverai',
    'annoverammo',
    'annoverando',
    'annoverano',
    'annoverante',
    'annoveranti',
    'annoverare',
    'annoverarono',
    'annoverarsi',
    'annoverasse',
    'annoverassi',
    'annoveraste',
    'annoverasti',
    'annoverata',
    'annoverate',
    'annoverati',
    'annoverato',
    'annoverava',
    'annoveravamo',
    'annoveravano',
    'annoveravate',
    'annoveravi',
    'annoveravo',
    'annoverera',
    'annovererai',
    'annovererei',
    'annovereremo',
    'annovererete',
    'annoverero',
    'annovererò',
    'annoveri',
    'annoveriamo',
    'annoveriate',
    'annoverino',
    'annovero',
    'annua',
    'annuale',
    'annuali',
    'annualita',
    'annualità',
    'annualmente',
    'annuari',
    'annuario',
    'annuccia',
    'annuccio',
    'annue',
    'annuendo',
    'annuente',
    'annuenti',
    'annuenza',
    'annuenze',
    'annui',
    'annuiamo',
    'annuiate',
    'annuii',
    'annuimmo',
    'annuira',
    'annuirai',
    'annuiranno',
    'annuire',
    'annuirebbe',
    'annuirebbero',
    'annuirei',
    'annuiremmo',
    'annuiremo',
    'annuireste',
    'annuiresti',
    'annuirete',
    'annuiro',
    'annuirono',
    'annuisca',
    'annuiscano',
    'annuisce',
    'annuisci',
    'annuisco',
    'annuiscono',
    'annuisse',
    'annuissero',
    'annuissi',
    'annuissimo',
    'annuiste',
    'annuisti',
    'annuita',
    'annuite',
    'annuiti',
    'annuito',
    'annuiva',
    'annuivamo',
    'annuivano',
    'annuivate',
    'annuivi',
    'annuivo',
    'annulata',
    'annulla',
    'annullabile',
    'annullabili',
    'annullai',
    'annullamenti',
    'annullamento',
    'annullammo',
    'annullando',
    'annullandoci',
    'annullandola',
    'annullandole',
    'annullandoli',
    'annullandolo',
    'annullandomi',
    'annullandosi',
    'annullandoti',
    'annullandovi',
    'annullano',
    'annullante',
    'annullanti',
    'annullantisi',
    'annullarci',
    'annullare',
    'annullarla',
    'annullarle',
    'annullarli',
    'annullarlo',
    'annullarmi',
    'annullarono',
    'annullarsi',
    'annullarti',
    'annullarvi',
    'annullasse',
    'annullassero',
    'annullassi',
    'annullassimo',
    'annullaste',
    'annullasti',
    'annullata',
    'annullate',
    'annullatevi',
    'annullati',
    'annullativa',
    'annullative',
    'annullativi',
    'annullativo',
    'annullato',
    'annullatomi',
    'annullatore',
    'annullatori',
    'annullatoti',
    'annullatrice',
    'annullatrici',
    'annullava',
    'annullavamo',
    'annullavano',
    'annullavate',
    'annullavi',
    'annullavo',
    'annullazione',
    'annullazioni',
    'annullera',
    'annullerai',
    'annulleranno',
    'annullerebbe',
    'annullerei',
    'annulleremmo',
    'annulleremo',
    'annullereste',
    'annulleresti',
    'annullerete',
    'annullero',
    'annulli',
    'annulliamo',
    'annulliamoci',
    'annulliate',
    'annullino',
    'annullo',
    'annumerando',
    'annumerare',
    'annumerata',
    'annumerate',
    'annumerati',
    'annumerato',
    'annuncera',
    'annuncerai',
    'annunceranno',
    'annuncerebbe',
    'annuncerei',
    'annunceremmo',
    'annunceremo',
    'annuncereste',
    'annunceresti',
    'annuncerete',
    'annuncero',
    'annunci',
    'annuncia',
    'annunciai',
    'annunciammo',
    'annunciamo',
    'annunciando',
    'annunciano',
    'annunciante',
    'annuncianti',
    'annunciarci',
    'annunciare',
    'annunciarla',
    'annunciarle',
    'annunciarli',
    'annunciarlo',
    'annunciarmi',
    'annunciarne',
    'annunciarono',
    'annunciarsi',
    'annunciarti',
    'annunciarvi',
    'annunciasse',
    'annunciassi',
    'annunciaste',
    'annunciasti',
    'annunciata',
    'annunciate',
    'annunciati',
    'annunciato',
    'annunciatore',
    'annunciatori',
    'annunciava',
    'annunciavamo',
    'annunciavano',
    'annunciavate',
    'annunciavi',
    'annunciavo',
    'annuncino',
    'annuncio',
    'annunciò',
    'annunzi',
    'annunzia',
    'annunziai',
    'annunziammo',
    'annunziamo',
    'annunziando',
    'annunziano',
    'annunziante',
    'annunziarci',
    'annunziare',
    'annunziarla',
    'annunziarle',
    'annunziarli',
    'annunziarlo',
    'annunziarmi',
    'annunziarne',
    'annunziarono',
    'annunziarsi',
    'annunziarti',
    'annunziarvi',
    'annunziasse',
    'annunziassi',
    'annunziaste',
    'annunziasti',
    'annunziata',
    'annunziate',
    'annunziati',
    'annunziatina',
    'annunziato',
    'annunziatore',
    'annunziatori',
    'annunziava',
    'annunziavamo',
    'annunziavano',
    'annunziavate',
    'annunziavi',
    'annunziavo',
    'annunziera',
    'annunzierai',
    'annunzierei',
    'annunzieremo',
    'annunzierete',
    'annunziero',
    'annunzino',
    'annunzio',
    'annuo',
    'annurca',
    'annurche',
    'annusa',
    'annusai',
    'annusala',
    'annusale',
    'annusali',
    'annusalo',
    'annusammo',
    'annusando',
    'annusandola',
    'annusandole',
    'annusandoli',
    'annusandolo',
    'annusano',
    'annusante',
    'annusanti',
    'annusare',
    'annusarla',
    'annusarle',
    'annusarli',
    'annusarlo',
    'annusarono',
    'annusasse',
    'annusassero',
    'annusassi',
    'annusassimo',
    'annusaste',
    'annusasti',
    'annusata',
    'annusate',
    'annusatela',
    'annusatele',
    'annusateli',
    'annusatelo',
    'annusati',
    'annusato',
    'annusatore',
    'annusatori',
    'annusatrice',
    'annusatrici',
    'annusava',
    'annusavamo',
    'annusavano',
    'annusavate',
    'annusavi',
    'annusavo',
    'annusera',
    'annuserai',
    'annuseranno',
    'annuserebbe',
    'annuserei',
    'annuseremmo',
    'annuseremo',
    'annusereste',
    'annuseresti',
    'annuserete',
    'annusero',
    'annusi',
    'annusiamo',
    'annusiate',
    'annusino',
    'annuso',
    'annuvola',
    'annuvolai',
    'annuvolammo',
    'annuvolando',
    'annuvolano',
    'annuvolante',
    'annuvolanti',
    'annuvolarci',
    'annuvolare',
    'annuvolarmi',
    'annuvolarono',
    'annuvolarsi',
    'annuvolarti',
    'annuvolarvi',
    'annuvolasse',
    'annuvolassi',
    'annuvolaste',
    'annuvolasti',
    'annuvolata',
    'annuvolate',
    'annuvolatevi',
    'annuvolati',
    'annuvolato',
    'annuvolatomi',
    'annuvolatoti',
    'annuvolava',
    'annuvolavamo',
    'annuvolavano',
    'annuvolavate',
    'annuvolavi',
    'annuvolavo',
    'annuvolera',
    'annuvolerai',
    'annuvolerei',
    'annuvoleremo',
    'annuvolerete',
    'annuvolero',
    'annuvoli',
    'annuvoliamo',
    'annuvoliate',
    'annuvolino',
    'annuvolo',
    'anobi',
    'anobio',
    'anodi',
    'anodica',
    'anodiche',
    'anodici',
    'anodico',
    'anodina',
    'anodinamente',
    'anodine',
    'anodini',
    'anodino',
    'anodizza',
    'anodizzai',
    'anodizzammo',
    'anodizzando',
    'anodizzano',
    'anodizzante',
    'anodizzanti',
    'anodizzare',
    'anodizzarono',
    'anodizzasse',
    'anodizzassi',
    'anodizzaste',
    'anodizzasti',
    'anodizzata',
    'anodizzate',
    'anodizzati',
    'anodizzato',
    'anodizzava',
    'anodizzavamo',
    'anodizzavano',
    'anodizzavate',
    'anodizzavi',
    'anodizzavo',
    'anodizzera',
    'anodizzerai',
    'anodizzerei',
    'anodizzeremo',
    'anodizzerete',
    'anodizzero',
    'anodizzi',
    'anodizziamo',
    'anodizziate',
    'anodizzino',
    'anodizzo',
    'anodo',
    'anodonta',
    'anodonte',
    'anodontia',
    'anoetica',
    'anoetiche',
    'anoetici',
    'anoetico',
    'anofele',
    'anofeli',
    'anoftalmia',
    'anoftalmo',
    'anolini',
    'anolino',
    'anom',
    'anomala',
    'anomale',
    'anomali',
    'anomalia',
    'anomalie',
    'anomalista',
    'anomaliste',
    'anomalisti',
    'anomalistica',
    'anomalistici',
    'anomalistico',
    'anomalo',
    'anomia',
    'anomica',
    'anomiche',
    'anomici',
    'anomico',
    'anomie',
    'anona',
    'anonacea',
    'anonacee',
    'anone',
    'anonima',
    'anonimamente',
    'anonimati',
    'anonimato',
    'anonime',
    'anonimi',
    'anonimia',
    'anonimie',
    'anonimo',
    'anopheles',
    'anoplura',
    'anopluri',
    'anopluro',
    'anopsia',
    'anopsie',
    'anorchide',
    'anorchidi',
    'anorchidia',
    'anorchidie',
    'anoressante',
    'anoressanti',
    'anoressia',
    'anoressica',
    'anoressiche',
    'anoressici',
    'anoressico',
    'anoressie',
    'anorettale',
    'anorganica',
    'anorganiche',
    'anorganici',
    'anorganico',
    'anorgasmia',
    'anorgasmica',
    'anorgasmiche',
    'anorgasmici',
    'anorgasmico',
    'anorm',
    'anormale',
    'anormali',
    'anormalita',
    'anormalità',
    'anormalmente',
    'anortite',
    'anortiti',
    'anoscopia',
    'anosia',
    'anosie',
    'anosmia',
    'anosmie',
    'anossemia',
    'anossemie',
    'anossia',
    'anossica',
    'anossie',
    'anossiemia',
    'anossiemie',
    'anotia',
    'anotie',
    'anovulazione',
    'anrico',
    'ansa',
    'ansai',
    'ansalda',
    'ansaldo',
    'ansamenti',
    'ansamento',
    'ansammo',
    'ansando',
    'ansano',
    'ansante',
    'ansanti',
    'ansare',
    'ansarono',
    'ansasse',
    'ansassero',
    'ansassi',
    'ansassimo',
    'ansaste',
    'ansasti',
    'ansata',
    'ansate',
    'ansati',
    'ansato',
    'ansava',
    'ansavamo',
    'ansavano',
    'ansavate',
    'ansavi',
    'ansavo',
    'anse',
    'anseatica',
    'anseatiche',
    'anseatici',
    'anseatico',
    'anselma',
    'anselmina',
    'anselmino',
    'anselmo',
    'ansera',
    'anserai',
    'anseranno',
    'anserebbe',
    'anserebbero',
    'anserei',
    'anseremmo',
    'anseremo',
    'ansereste',
    'anseresti',
    'anserete',
    'anseriforme',
    'anseriformi',
    'anserina',
    'anserine',
    'anserini',
    'anserino',
    'ansero',
    'ansi',
    'ansia',
    'ansiamo',
    'ansiare',
    'ansiate',
    'ansie',
    'ansieta',
    'ansietà',
    'ansima',
    'ansimai',
    'ansimammo',
    'ansimando',
    'ansimano',
    'ansimante',
    'ansimanti',
    'ansimare',
    'ansimarono',
    'ansimasse',
    'ansimassero',
    'ansimassi',
    'ansimassimo',
    'ansimaste',
    'ansimasti',
    'ansimata',
    'ansimate',
    'ansimati',
    'ansimato',
    'ansimava',
    'ansimavamo',
    'ansimavano',
    'ansimavate',
    'ansimavi',
    'ansimavo',
    'ansime',
    'ansimera',
    'ansimerai',
    'ansimeranno',
    'ansimerebbe',
    'ansimerei',
    'ansimeremmo',
    'ansimeremo',
    'ansimereste',
    'ansimeresti',
    'ansimerete',
    'ansimero',
    'ansimi',
    'ansimiamo',
    'ansimiate',
    'ansimino',
    'ansimo',
    'ansino',
    'ansio',
    'ansiogena',
    'ansiogene',
    'ansiogeni',
    'ansiogeno',
    'ansiolitica',
    'ansiolitiche',
    'ansiolitici',
    'ansiolitico',
    'ansiosa',
    'ansiosamente',
    'ansiose',
    'ansiosi',
    'ansioso',
    'ansiti',
    'ansito',
    'anso',
    'ansovino',
    'anspertina',
    'ansperto',
    'ansuina',
    'ansuino',
    'anta',
    'antabuse',
    'antagonismi',
    'antagonismo',
    'antagonista',
    'antagoniste',
    'antagonisti',
    'antagonizza',
    'antagonizzi',
    'antalgica',
    'antalgiche',
    'antalgici',
    'antalgico',
    'antanaclasi',
    'antanella',
    'antanelle',
    'antartica',
    'antartiche',
    'antartici',
    'antartico',
    'antartide',
    'ante',
    'antea',
    'antebellica',
    'antebelliche',
    'antebellici',
    'antebellico',
    'anteceda',
    'antecedano',
    'antecede',
    'antecedei',
    'antecedemmo',
    'antecedendo',
    'antecedente',
    'antecedenti',
    'antecedenza',
    'antecedenze',
    'antecedera',
    'antecederai',
    'antecedere',
    'antecederei',
    'antecederemo',
    'antecederete',
    'antecedero',
    'antecederono',
    'antecedesse',
    'antecedessi',
    'antecedeste',
    'antecedesti',
    'antecedete',
    'antecedette',
    'antecedetti',
    'antecedeva',
    'antecedevamo',
    'antecedevano',
    'antecedevate',
    'antecedevi',
    'antecedevo',
    'antecedi',
    'antecediamo',
    'antecediate',
    'antecedo',
    'antecedono',
    'anteceduta',
    'antecedute',
    'anteceduti',
    'anteceduto',
    'antecesso',
    'antecessora',
    'antecessore',
    'antecessori',
    'antefatti',
    'antefatto',
    'antefissa',
    'antefisse',
    'anteguerra',
    'antela',
    'antelami',
    'antelamica',
    'antelamiche',
    'antelamici',
    'antelamico',
    'antele',
    'anteli',
    'antelio',
    'antelmintica',
    'antelmintici',
    'antelmintico',
    'antelucana',
    'antelucane',
    'antelucani',
    'antelucano',
    'antelunare',
    'antelunari',
    'antemarcia',
    'antemetica',
    'antemetiche',
    'antemetici',
    'antemetico',
    'antemi',
    'antemide',
    'antemidi',
    'antemio',
    'antemurale',
    'antemurali',
    'antenata',
    'antenatale',
    'antenatali',
    'antenate',
    'antenati',
    'antenato',
    'antenna',
    'antennale',
    'antennali',
    'antennaria',
    'antennarie',
    'antenne',
    'antennista',
    'antenniste',
    'antennisti',
    'antennula',
    'antennule',
    'antenora',
    'antenore',
    'anteo',
    'antepartum',
    'antependium',
    'antepoevano',
    'antepone',
    'anteponemmo',
    'anteponendo',
    'anteponente',
    'anteponenti',
    'anteponere',
    'anteponesse',
    'anteponessi',
    'anteponeste',
    'anteponesti',
    'anteponete',
    'anteponeva',
    'anteponevamo',
    'anteponevano',
    'anteponevate',
    'anteponevi',
    'anteponevo',
    'anteponga',
    'antepongano',
    'antepongo',
    'antepongono',
    'anteponi',
    'anteponiamo',
    'anteponiate',
    'anteporla',
    'anteporlo',
    'anteporne',
    'anteporra',
    'anteporrai',
    'anteporranno',
    'anteporre',
    'anteporrebbe',
    'anteporrei',
    'anteporremmo',
    'anteporremo',
    'anteporreste',
    'anteporresti',
    'anteporrete',
    'anteporro',
    'antepose',
    'anteposero',
    'anteposi',
    'anteposta',
    'anteposte',
    'anteposti',
    'anteposto',
    'anteprima',
    'anteprime',
    'antera',
    'antere',
    'anterica',
    'anteriche',
    'anterici',
    'anterico',
    'anteridi',
    'anteridio',
    'anterino',
    'anterio',
    'anteriore',
    'anteriori',
    'anteriorita',
    'anteriorità',
    'antero',
    'anterograda',
    'anterograde',
    'anterogradi',
    'anterogrado',
    'anterozoi',
    'anterozoide',
    'anterozoidi',
    'anterozoo',
    'antesi',
    'antesignana',
    'antesignane',
    'antesignani',
    'antesignano',
    'anthracis',
    'anti',
    'antiacida',
    'antiacide',
    'antiacidi',
    'antiacido',
    'antiacne',
    'antiaderente',
    'antiaderenti',
    'antiadesiva',
    'antiadesive',
    'antiadesivi',
    'antiadesivo',
    'antiaerea',
    'antiaeree',
    'antiaerei',
    'antiaereo',
    'antialcolica',
    'antialcolici',
    'antialcolico',
    'antialghe',
    'antialisei',
    'antialiseo',
    'antialone',
    'antianemica',
    'antianemiche',
    'antianemici',
    'antianemico',
    'antiasmatici',
    'antiastenica',
    'antiastenici',
    'antiastenico',
    'antiatomi',
    'antiatomica',
    'antiatomiche',
    'antiatomici',
    'antiatomico',
    'antiatomo',
    'antibacchei',
    'antibaccheo',
    'antibacchii',
    'antibacchio',
    'antibagni',
    'antibagno',
    'antibecchi',
    'antibecco',
    'antibes',
    'antibiosi',
    'antibiotica',
    'antibiotiche',
    'antibiotici',
    'antibiotico',
    'antibioticus',
    'antiblasfema',
    'antiblasfeme',
    'antiblasfemi',
    'antiblasfemo',
    'antiblastica',
    'antiblastici',
    'antiblastico',
    'antiblocco',
    'antiborghese',
    'antiborghesi',
    'antibraccio',
    'antica',
    'anticaccia',
    'anticaglia',
    'anticaglie',
    'anticamente',
    'anticamera',
    'anticamere',
    'anticancro',
    'anticando',
    'anticano',
    'anticare',
    'anticarie',
    'anticarono',
    'anticarro',
    'anticarsi',
    'anticata',
    'anticate',
    'anticati',
    'anticato',
    'anticatodi',
    'anticatodo',
    'anticava',
    'anticavano',
    'anticeltica',
    'anticeltiche',
    'anticeltici',
    'anticeltico',
    'antiche',
    'anticheggera',
    'anticheggero',
    'anticheggi',
    'anticheggia',
    'anticheggiai',
    'anticheggino',
    'anticheggio',
    'antichi',
    'antichino',
    'antichissima',
    'antichissime',
    'antichissimi',
    'antichissimo',
    'antichista',
    'antichiste',
    'antichisti',
    'antichita',
    'antichità',
    'antichizzata',
    'antichizzate',
    'antichizzati',
    'antichizzato',
    'anticiclica',
    'anticicliche',
    'anticiclici',
    'anticiclico',
    'anticiclone',
    'anticicloni',
    'anticima',
    'anticime',
    'anticipa',
    'anticipai',
    'anticipammo',
    'anticipando',
    'anticipano',
    'anticipante',
    'anticipanti',
    'anticipare',
    'anticiparono',
    'anticipasse',
    'anticipassi',
    'anticipaste',
    'anticipasti',
    'anticipata',
    'anticipate',
    'anticipati',
    'anticipato',
    'anticipatore',
    'anticipatori',
    'anticipava',
    'anticipavamo',
    'anticipavano',
    'anticipavate',
    'anticipavi',
    'anticipavo',
    'anticipera',
    'anticiperai',
    'anticiperei',
    'anticiperemo',
    'anticiperete',
    'anticipero',
    'anticipi',
    'anticipiamo',
    'anticipiate',
    'anticipino',
    'anticipo',
    'anticlimax',
    'anticlinale',
    'anticlinali',
    'anticloro',
    'antico',
    'anticolerica',
    'anticolerici',
    'anticolerico',
    'anticorpale',
    'anticorpi',
    'anticorpo',
    'anticresi',
    'anticrimine',
    'anticristi',
    'anticristo',
    'anticrollo',
    'anticucina',
    'anticucine',
    'antidata',
    'antidatai',
    'antidatammo',
    'antidatando',
    'antidatano',
    'antidatante',
    'antidatanti',
    'antidatare',
    'antidatarla',
    'antidatarle',
    'antidatarli',
    'antidatarlo',
    'antidatarono',
    'antidatasse',
    'antidatassi',
    'antidataste',
    'antidatasti',
    'antidatata',
    'antidatate',
    'antidatati',
    'antidatato',
    'antidatava',
    'antidatavamo',
    'antidatavano',
    'antidatavate',
    'antidatavi',
    'antidatavo',
    'antidate',
    'antidatera',
    'antidaterai',
    'antidaterei',
    'antidateremo',
    'antidaterete',
    'antidatero',
    'antidati',
    'antidatiamo',
    'antidatiate',
    'antidatino',
    'antidato',
    'antideficit',
    'antidisturbo',
    'antidiva',
    'antidive',
    'antidivi',
    'antidivo',
    'antidoping',
    'antidorcade',
    'antidorcadi',
    'antidotari',
    'antidotario',
    'antidoti',
    'antidoto',
    'antidroga',
    'antidromica',
    'antidromiche',
    'antidromici',
    'antidromico',
    'antidumping',
    'antiemetica',
    'antiemetiche',
    'antiemetici',
    'antiemetico',
    'antienzima',
    'antienzimi',
    'antieroe',
    'antieroi',
    'antierrore',
    'antierrori',
    'antiestetica',
    'antiestetici',
    'antiestetico',
    'antifading',
    'antifascismi',
    'antifascismo',
    'antifascista',
    'antifasciste',
    'antifascisti',
    'antifati',
    'antifato',
    'antifebbrile',
    'antifebbrili',
    'antifiamma',
    'antifona',
    'antifonale',
    'antifonali',
    'antifonari',
    'antifonario',
    'antifone',
    'antifonia',
    'antifonie',
    'antiforfora',
    'antifossi',
    'antifosso',
    'antifrasi',
    'antifrastica',
    'antifrastici',
    'antifrastico',
    'antifrizione',
    'antifumo',
    'antifuochi',
    'antifuoco',
    'antifurto',
    'antigas',
    'antigelo',
    'antigene',
    'antigeni',
    'antigenica',
    'antigeniche',
    'antigenici',
    'antigenico',
    'antighiaccio',
    'antigienica',
    'antigieniche',
    'antigienici',
    'antigienico',
    'antigona',
    'antigone',
    'antigono',
    'antigrafa',
    'antigrafe',
    'antigraffio',
    'antigrafi',
    'antigrafo',
    'antigrandine',
    'antigravita',
    'antigravità',
    'antiguardia',
    'antiigienica',
    'antiigienici',
    'antiigienico',
    'antiincendio',
    'antiisterica',
    'antiisterici',
    'antiisterico',
    'antiliberale',
    'antiliberali',
    'antilingua',
    'antilingue',
    'antilipemici',
    'antille',
    'antillide',
    'antillidi',
    'antilocapra',
    'antilocapre',
    'antilogia',
    'antilogica',
    'antilogiche',
    'antilogici',
    'antilogico',
    'antilogie',
    'antilope',
    'antilopi',
    'antiluetica',
    'antiluetiche',
    'antiluetici',
    'antiluetico',
    'antima',
    'antimacchia',
    'antimafia',
    'antimafiosa',
    'antimafiose',
    'antimafiosi',
    'antimafioso',
    'antimalarica',
    'antimalarici',
    'antimalarico',
    'antimateria',
    'antimaterie',
    'antimeri',
    'antimero',
    'antimetabole',
    'antimetaboli',
    'antimicotica',
    'antimicotici',
    'antimicotico',
    'antimina',
    'antimine',
    'antimino',
    'antimissile',
    'antimitotica',
    'antimitotici',
    'antimitotico',
    'antimo',
    'antimoni',
    'antimoniale',
    'antimoniali',
    'antimonica',
    'antimoniche',
    'antimonici',
    'antimonico',
    'antimonio',
    'antimoniosa',
    'antimoniose',
    'antimoniosi',
    'antimonioso',
    'antimonite',
    'antimoniti',
    'antimuffa',
    'antimuri',
    'antimuro',
    'antina',
    'antinave',
    'antinavi',
    'antinazista',
    'antinaziste',
    'antinazisti',
    'antincendio',
    'antinduttiva',
    'antinduttive',
    'antinduttivi',
    'antinduttivo',
    'antine',
    'antinebbia',
    'antineutrini',
    'antineutrino',
    'antineutrone',
    'antineutroni',
    'antineve',
    'antinfettiva',
    'antinfettive',
    'antinfettivi',
    'antinfettivo',
    'antinflativa',
    'antinflative',
    'antinflativi',
    'antinflativo',
    'antinomia',
    'antinomica',
    'antinomiche',
    'antinomici',
    'antinomico',
    'antinomie',
    'antinucleare',
    'antinucleari',
    'antinuclei',
    'antinucleo',
    'antinucleone',
    'antinucleoni',
    'antioca',
    'antiochena',
    'antiochene',
    'antiocheni',
    'antiocheno',
    'antiochia',
    'antioco',
    'antiofidica',
    'antiofidiche',
    'antiofidici',
    'antiofidico',
    'antioncogene',
    'antioncogeni',
    'antiopa',
    'antiope',
    'antiorari',
    'antioraria',
    'antiorarie',
    'antiorario',
    'antiormone',
    'antiormoni',
    'antiossigeni',
    'antiossigeno',
    'antipallage',
    'antipallagi',
    'antipapa',
    'antipapale',
    'antipapali',
    'antipapi',
    'antipapismi',
    'antipapismo',
    'antipapista',
    'antipapiste',
    'antipapisti',
    'antiparte',
    'antiparti',
    'antipartito',
    'antipasti',
    'antipastiera',
    'antipastiere',
    'antipastieri',
    'antipasto',
    'antipate',
    'antipati',
    'antipatia',
    'antipatica',
    'antipatiche',
    'antipatici',
    'antipatico',
    'antipatie',
    'antiperiodi',
    'antiperiodo',
    'antipertosse',
    'antipiega',
    'antipiogena',
    'antipiogene',
    'antipiogeni',
    'antipiogeno',
    'antipiovra',
    'antipiresi',
    'antipiretica',
    'antipiretici',
    'antipiretico',
    'antiplacca',
    'antipode',
    'antipodi',
    'antipodista',
    'antipodiste',
    'antipodisti',
    'antipodo',
    'antipoetica',
    'antipoetiche',
    'antipoetici',
    'antipoetico',
    'antipolio',
    'antipolitica',
    'antipolitici',
    'antipolitico',
    'antipolvere',
    'antipopolare',
    'antipopolari',
    'antiporta',
    'antiporte',
    'antiporti',
    'antiporto',
    'antiprotone',
    'antiprotoni',
    'antiprotozoi',
    'antipsorica',
    'antipsoriche',
    'antipsorici',
    'antipsorico',
    'antipulci',
    'antipurismo',
    'antipurista',
    'antipuriste',
    'antipuristi',
    'antiqua',
    'antiquari',
    'antiquaria',
    'antiquariale',
    'antiquariali',
    'antiquariati',
    'antiquariato',
    'antiquarie',
    'antiquario',
    'antiquarismo',
    'antiquarista',
    'antiquariste',
    'antiquaristi',
    'antiquarium',
    'antiquata',
    'antiquate',
    'antiquati',
    'antiquato',
    'antique',
    'antiqui',
    'antiquita',
    'antiquo',
    'antirabbica',
    'antirabbiche',
    'antirabbici',
    'antirabbico',
    'antirabica',
    'antirabiche',
    'antirabici',
    'antirabico',
    'antiracket',
    'antiradar',
    'antirazzismi',
    'antirazzismo',
    'antirazzista',
    'antirazziste',
    'antirazzisti',
    'antire',
    'antireflusso',
    'antiretorica',
    'antiretorici',
    'antiretorico',
    'antiriflesso',
    'antirock',
    'antirollante',
    'antirollanti',
    'antirollio',
    'antiromanzi',
    'antiromanzo',
    'antirombo',
    'antirrini',
    'antirrino',
    'antiruggine',
    'antirughe',
    'antirumore',
    'antisagoge',
    'antisagogi',
    'antisala',
    'antisale',
    'antiscali',
    'antiscalo',
    'antiscasso',
    'antischegge',
    'antischiuma',
    'antisciopero',
    'antiscippo',
    'antiscivolo',
    'antisemita',
    'antisemite',
    'antisemiti',
    'antisemitica',
    'antisemitici',
    'antisemitico',
    'antisepsi',
    'antisettica',
    'antisettiche',
    'antisettici',
    'antisettico',
    'antisieri',
    'antisiero',
    'antisismica',
    'antisismiche',
    'antisismici',
    'antisismico',
    'antisistema',
    'antisistemi',
    'antiskating',
    'antislump',
    'antismog',
    'antisociale',
    'antisociali',
    'antisolare',
    'antisolari',
    'antisole',
    'antisommossa',
    'antispaccio',
    'antispasti',
    'antispastica',
    'antispastici',
    'antispastico',
    'antispasto',
    'antisportiva',
    'antisportive',
    'antisportivi',
    'antisportivo',
    'antista',
    'antistadi',
    'antistadio',
    'antistai',
    'antistando',
    'antistanno',
    'antistante',
    'antistanti',
    'antistara',
    'antistarai',
    'antistaranno',
    'antistare',
    'antistarebbe',
    'antistarei',
    'antistaremmo',
    'antistaremo',
    'antistareste',
    'antistaresti',
    'antistarete',
    'antistaro',
    'antistata',
    'antistate',
    'antistati',
    'antistatica',
    'antistatiche',
    'antistatici',
    'antistatico',
    'antistato',
    'antistatuale',
    'antistatuali',
    'antistava',
    'antistavamo',
    'antistavano',
    'antistavate',
    'antistavi',
    'antistavo',
    'antistemmo',
    'antisterica',
    'antisteriche',
    'antisterici',
    'antisterico',
    'antisterile',
    'antisterili',
    'antistesse',
    'antistessero',
    'antistessi',
    'antistessimo',
    'antisteste',
    'antistesti',
    'antistette',
    'antistettero',
    'antistetti',
    'antistia',
    'antistiamo',
    'antistiano',
    'antistiate',
    'antistite',
    'antistiti',
    'antisto',
    'antistorica',
    'antistoriche',
    'antistorici',
    'antistorico',
    'antistrappo',
    'antistress',
    'antistrofa',
    'antistrofe',
    'antistrofi',
    'antistupro',
    'antitabacco',
    'antitangenti',
    'antitarlo',
    'antitarma',
    'antitarmica',
    'antitarmiche',
    'antitarmici',
    'antitarmico',
    'antitartaro',
    'antiteatro',
    'antitedesca',
    'antitedesche',
    'antitedeschi',
    'antitedesco',
    'antitempo',
    'antitermica',
    'antitermiche',
    'antitermici',
    'antitermico',
    'antitesi',
    'antitetanica',
    'antitetanici',
    'antitetanico',
    'antiteti',
    'antitetica',
    'antitetiche',
    'antitetici',
    'antitetico',
    'antiteto',
    'antitifica',
    'antitifiche',
    'antitifici',
    'antitifico',
    'antitiroidea',
    'antitiroidee',
    'antitiroidei',
    'antitiroideo',
    'antitosse',
    'antitossica',
    'antitossiche',
    'antitossici',
    'antitossico',
    'antitossina',
    'antitossine',
    'antitripsina',
    'antitrombina',
    'antitrombine',
    'antitrust',
    'antitumorale',
    'antitumorali',
    'antiulcerosa',
    'antiulcerose',
    'antiulcerosi',
    'antiulceroso',
    'antiuomo',
    'antiurica',
    'antiuriche',
    'antiurici',
    'antiurico',
    'antiurto',
    'antiusura',
    'antivaiolosa',
    'antivaiolose',
    'antivaiolosi',
    'antivaioloso',
    'antivamp',
    'antivarici',
    'antiveda',
    'antivedano',
    'antivede',
    'antivedemmo',
    'antivedendo',
    'antivedente',
    'antivedenti',
    'antiveder',
    'antivedere',
    'antivedesse',
    'antivedessi',
    'antivedeste',
    'antivedesti',
    'antivedete',
    'antivedeva',
    'antivedevamo',
    'antivedevano',
    'antivedevate',
    'antivedevi',
    'antivedevo',
    'antivedi',
    'antivediamo',
    'antivediate',
    'antivedo',
    'antivedono',
    'antivedra',
    'antivedrai',
    'antivedranno',
    'antivedrebbe',
    'antivedrei',
    'antivedremmo',
    'antivedremo',
    'antivedreste',
    'antivedresti',
    'antivedrete',
    'antivedro',
    'antiveduta',
    'antivedute',
    'antiveduti',
    'antiveduto',
    'antiveggente',
    'antiveggenti',
    'antiveggenza',
    'antiveggenze',
    'antiveleni',
    'antiveleno',
    'antivelo',
    'antivenendo',
    'antivenerea',
    'antiveneree',
    'antivenerei',
    'antivenereo',
    'antivenga',
    'antivengano',
    'antivengo',
    'antivengono',
    'antiveniamo',
    'antiveniate',
    'antiveniente',
    'antivenienti',
    'antivenimmo',
    'antivenire',
    'antivenisse',
    'antivenissi',
    'antiveniste',
    'antivenisti',
    'antivenite',
    'antiveniva',
    'antivenivamo',
    'antivenivano',
    'antivenivate',
    'antivenivi',
    'antivenivo',
    'antivenne',
    'antivennero',
    'antivenni',
    'antivenuta',
    'antivenute',
    'antivenuti',
    'antivenuto',
    'antiverra',
    'antiverrai',
    'antiverranno',
    'antiverrebbe',
    'antiverrei',
    'antiverremmo',
    'antiverremo',
    'antiverreste',
    'antiverresti',
    'antiverrete',
    'antiverro',
    'antiversione',
    'antiversioni',
    'antivide',
    'antividero',
    'antividi',
    'antiviene',
    'antivieni',
    'antivigilia',
    'antivigilie',
    'antivipera',
    'antivirale',
    'antivirali',
    'antivista',
    'antiviste',
    'antivisti',
    'antivisto',
    'anto',
    'antociana',
    'antociane',
    'antociani',
    'antociano',
    'antofagi',
    'antofago',
    'antofilli',
    'antofillo',
    'antofita',
    'antofite',
    'antografia',
    'antografie',
    'antologia',
    'antologica',
    'antologiche',
    'antologici',
    'antologico',
    'antologie',
    'antologista',
    'antologiste',
    'antologisti',
    'antologizza',
    'antologizzai',
    'antologizzi',
    'antologizzo',
    'antonangelo',
    'antone',
    'antonella',
    'antonelli',
    'antonelliana',
    'antonelliane',
    'antonelliani',
    'antonelliano',
    'antonello',
    'antonetta',
    'antonetto',
    'antoni',
    'antonia',
    'antoniana',
    'antoniane',
    'antoniani',
    'antoniano',
    'antonica',
    'antonico',
    'antonietta',
    'antonietto',
    'antonilla',
    'antonillo',
    'antonima',
    'antonime',
    'antonimi',
    'antonimia',
    'antonimica',
    'antonimiche',
    'antonimici',
    'antonimico',
    'antonimie',
    'antonimo',
    'antonina',
    'antonino',
    'antonio',
    'antonita',
    'antoniuccio',
    'antonmaria',
    'antonomasia',
    'antonomasie',
    'antonomi',
    'antonomo',
    'antoptosi',
    'antozoi',
    'antozoo',
    'antrace',
    'antracene',
    'antraceni',
    'antracenica',
    'antraceniche',
    'antracenici',
    'antracenico',
    'antrachinone',
    'antrachinoni',
    'antraci',
    'antracite',
    'antraciti',
    'antracitica',
    'antracitiche',
    'antracitici',
    'antracitico',
    'antracnosi',
    'antraco',
    'antracosi',
    'antrale',
    'antrali',
    'antri',
    'antro',
    'antronese',
    'antronesi',
    'antropema',
    'antropemi',
    'antropica',
    'antropiche',
    'antropici',
    'antropico',
    'antropizza',
    'antropizzai',
    'antropizzano',
    'antropizzare',
    'antropizzata',
    'antropizzate',
    'antropizzati',
    'antropizzato',
    'antropizzava',
    'antropizzavi',
    'antropizzavo',
    'antropizzera',
    'antropizzero',
    'antropizzi',
    'antropizzino',
    'antropizzo',
    'antropo',
    'antropofaga',
    'antropofaghe',
    'antropofagi',
    'antropofagia',
    'antropofagie',
    'antropofago',
    'antropofobia',
    'antropofobie',
    'antropogonia',
    'antropoide',
    'antropoidi',
    'antropologa',
    'antropologhe',
    'antropologi',
    'antropologia',
    'antropologie',
    'antropologo',
    'antropometri',
    'antropometro',
    'antropomorfa',
    'antropomorfe',
    'antropomorfi',
    'antropomorfo',
    'antroponimi',
    'antroponimia',
    'antroponimie',
    'antroponimo',
    'antroposofia',
    'antroposofie',
    'antropozoica',
    'antropozoici',
    'antropozoico',
    'antrotomia',
    'antrustione',
    'antrustioni',
    'antuono',
    'anturi',
    'anturio',
    'anulante',
    'anulare',
    'anulari',
    'anura',
    'anure',
    'anuresi',
    'anuri',
    'anuria',
    'anurie',
    'anuro',
    'anversa',
    'anxiety',
    'anzi',
    'anzia',
    'anziana',
    'anzianati',
    'anzianato',
    'anziane',
    'anziani',
    'anzianita',
    'anzianità',
    'anziano',
    'anzianotta',
    'anzianotte',
    'anzianotti',
    'anzianotto',
    'anziata',
    'anziate',
    'anziati',
    'anziato',
    'anziche',
    'anzichè',
    'anziché',
    'anzidetta',
    'anzidette',
    'anzidetti',
    'anzidetto',
    'anzio',
    'anzitempo',
    'anzitutto',
    'aocchiare',
    'aombrare',
    'aoni',
    'aonia',
    'aonie',
    'aonio',
    'aoristi',
    'aoristica',
    'aoristiche',
    'aoristici',
    'aoristico',
    'aoristo',
    'aorta',
    'aorte',
    'aortica',
    'aortiche',
    'aortici',
    'aortico',
    'aortite',
    'aortiti',
    'aorto',
    'aortografia',
    'aortografie',
    'aortoiliaca',
    'aortoiliache',
    'aortoiliaci',
    'aortoiliaco',
    'aosta',
    'aostana',
    'aostane',
    'aostani',
    'aostano',
    'aotinae',
    'aotus',
    'apache',
    'apaches',
    'apagoge',
    'apagogi',
    'apagogia',
    'apagogica',
    'apagogiche',
    'apagogici',
    'apagogico',
    'apagogie',
    'apale',
    'apali',
    'apallage',
    'apallagi',
    'apartheid',
    'apartitica',
    'apartitiche',
    'apartitici',
    'apartiticita',
    'apartiticità',
    'apartitico',
    'apatia',
    'apatica',
    'apaticamente',
    'apatiche',
    'apatici',
    'apatico',
    'apatie',
    'apatista',
    'apatiste',
    'apatisti',
    'apatite',
    'apatiti',
    'apatura',
    'apature',
    'apax',
    'apelle',
    'aperiodica',
    'aperiodiche',
    'aperiodici',
    'aperiodicita',
    'aperiodicità',
    'aperiodico',
    'aperitivi',
    'aperitivo',
    'aperse',
    'apersero',
    'apersi',
    'aperta',
    'apertaci',
    'apertagli',
    'apertala',
    'apertalo',
    'apertamente',
    'apertami',
    'apertasi',
    'apertati',
    'apertavi',
    'aperte',
    'aperti',
    'apertissima',
    'apertissimo',
    'aperto',
    'apertola',
    'apertolo',
    'apertomi',
    'apertone',
    'apertosi',
    'apertoti',
    'apertura',
    'aperture',
    'aperturismi',
    'aperturismo',
    'aperturista',
    'aperturiste',
    'aperturisti',
    'apetala',
    'apetale',
    'apetali',
    'apetalo',
    'apgar',
    'aphthovirus',
    'apia',
    'apiacea',
    'apiaceae',
    'apiacee',
    'apiai',
    'apiaia',
    'apiaie',
    'apiaio',
    'apiari',
    'apiaria',
    'apiarie',
    'apiario',
    'apiata',
    'apiate',
    'apiati',
    'apiato',
    'apiatura',
    'apiature',
    'apicale',
    'apicali',
    'apice',
    'apicectomia',
    'apicectomie',
    'apicetti',
    'apicetto',
    'apici',
    'apicoltore',
    'apicoltori',
    'apicoltrice',
    'apicoltrici',
    'apicoltura',
    'apicolture',
    'apicomplexa',
    'apicultore',
    'apicultori',
    'apicultrice',
    'apicultrici',
    'apicultura',
    'apiculture',
    'apide',
    'apidi',
    'apie',
    'apillotomia',
    'apina',
    'apine',
    'apinterapia',
    'apinterapie',
    'apio',
    'apiola',
    'apiole',
    'apioli',
    'apiolo',
    'apione',
    'apioni',
    'apira',
    'apirazione',
    'apire',
    'apirena',
    'apirene',
    'apireni',
    'apirenia',
    'apirenie',
    'apireno',
    'apiressia',
    'apiressie',
    'apiretica',
    'apiretiche',
    'apiretici',
    'apiretico',
    'apiri',
    'apiro',
    'apiscampi',
    'apiscampo',
    'apistica',
    'apistiche',
    'apistici',
    'apistico',
    'apiterapia',
    'apiterapie',
    'apivora',
    'apivore',
    'apivori',
    'apivoro',
    'aplacentale',
    'aplacentali',
    'aplacentata',
    'aplacentate',
    'aplacentati',
    'aplacentato',
    'aplanatica',
    'aplanatiche',
    'aplanatici',
    'aplanatico',
    'aplaneteche',
    'aplanetica',
    'aplanetici',
    'aplanetico',
    'aplasia',
    'aplasie',
    'aplastica',
    'aplestia',
    'aplestie',
    'apliside',
    'aplisidi',
    'aplo',
    'aplodonte',
    'aplodonti',
    'aplografia',
    'aplografie',
    'aploide',
    'aploidi',
    'aploidia',
    'aploidie',
    'aplologia',
    'aplologica',
    'aplologiche',
    'aplologici',
    'aplologico',
    'aplologie',
    'aplomb',
    'aplotipi',
    'aplustre',
    'aplustri',
    'aplustro',
    'aplysia',
    'apnea',
    'apnee',
    'apneista',
    'apneiste',
    'apneisti',
    'apneusi',
    'apnoica',
    'apnoiche',
    'apnoici',
    'apnoico',
    'apocalisse',
    'apocalissi',
    'apocalittic',
    'apocalittica',
    'apocalittici',
    'apocalittico',
    'apocatastasi',
    'apocinacea',
    'apocinacee',
    'apocini',
    'apocino',
    'apocizi',
    'apocizio',
    'apocopa',
    'apocopai',
    'apocopammo',
    'apocopando',
    'apocopano',
    'apocopante',
    'apocopanti',
    'apocopare',
    'apocoparono',
    'apocopasse',
    'apocopassero',
    'apocopassi',
    'apocopassimo',
    'apocopaste',
    'apocopasti',
    'apocopata',
    'apocopate',
    'apocopati',
    'apocopato',
    'apocopava',
    'apocopavamo',
    'apocopavano',
    'apocopavate',
    'apocopavi',
    'apocopavo',
    'apocope',
    'apocopera',
    'apocoperai',
    'apocoperanno',
    'apocoperebbe',
    'apocoperei',
    'apocoperemmo',
    'apocoperemo',
    'apocopereste',
    'apocoperesti',
    'apocoperete',
    'apocopero',
    'apocopi',
    'apocopiamo',
    'apocopiate',
    'apocopino',
    'apocopo',
    'apocrifa',
    'apocrife',
    'apocrifi',
    'apocrifo',
    'apocrina',
    'apocrine',
    'apocrini',
    'apocrino',
    'apocromatica',
    'apocromatici',
    'apocromatico',
    'apoda',
    'apodaca',
    'apode',
    'apodi',
    'apodide',
    'apodidi',
    'apodido',
    'apodiforme',
    'apodiformi',
    'apodissi',
    'apoditeri',
    'apoditerio',
    'apodittica',
    'apodittiche',
    'apodittici',
    'apoditticita',
    'apoditticità',
    'apodittico',
    'apodo',
    'apodosi',
    'apofantica',
    'apofantiche',
    'apofantici',
    'apofantico',
    'apofisi',
    'apofonia',
    'apofonica',
    'apofoniche',
    'apofonici',
    'apofonico',
    'apofonie',
    'apoforeti',
    'apoftegma',
    'apoftegmi',
    'apogei',
    'apogeo',
    'apografa',
    'apografe',
    'apografi',
    'apografo',
    'apoidei',
    'apoideo',
    'apolide',
    'apolidi',
    'apolidia',
    'apolidie',
    'apolitica',
    'apolitiche',
    'apolitici',
    'apoliticita',
    'apoliticità',
    'apolitico',
    'apolli',
    'apollinare',
    'apollinea',
    'apollinee',
    'apollinei',
    'apollineo',
    'apollo',
    'apollonia',
    'apollonio',
    'apologeta',
    'apologete',
    'apologeti',
    'apologetica',
    'apologetiche',
    'apologetici',
    'apologetico',
    'apologhi',
    'apologia',
    'apologie',
    'apologista',
    'apologiste',
    'apologisti',
    'apologistica',
    'apologistici',
    'apologistico',
    'apologizza',
    'apologizzai',
    'apologizzano',
    'apologizzare',
    'apologizzata',
    'apologizzate',
    'apologizzati',
    'apologizzato',
    'apologizzava',
    'apologizzavi',
    'apologizzavo',
    'apologizzera',
    'apologizzero',
    'apologizzi',
    'apologizzino',
    'apologizzo',
    'apologo',
    'aponense',
    'aponensi',
    'aponeurite',
    'aponeurosi',
    'aponeurotica',
    'aponeurotici',
    'aponeurotico',
    'aponevrosi',
    'aponevrotica',
    'aponevrotici',
    'aponevrotico',
    'aponia',
    'aponie',
    'aponte',
    'apontina',
    'apontine',
    'apontini',
    'apontino',
    'apoplessia',
    'apoplessie',
    'apoplettica',
    'apoplettiche',
    'apoplettici',
    'apoplettico',
    'apoptosi',
    'aporema',
    'aporemi',
    'aporetica',
    'aporetiche',
    'aporetici',
    'aporetico',
    'aporia',
    'aporie',
    'aposematismi',
    'aposematismo',
    'aposepala',
    'aposepale',
    'aposepali',
    'aposepalo',
    'aposiopesi',
    'apositana',
    'apositane',
    'apositani',
    'apositano',
    'apostasia',
    'apostasie',
    'apostata',
    'apostatai',
    'apostatammo',
    'apostatando',
    'apostatano',
    'apostatante',
    'apostatanti',
    'apostatare',
    'apostatarono',
    'apostatasse',
    'apostatassi',
    'apostataste',
    'apostatasti',
    'apostatata',
    'apostatate',
    'apostatati',
    'apostatato',
    'apostatava',
    'apostatavamo',
    'apostatavano',
    'apostatavate',
    'apostatavi',
    'apostatavo',
    'apostate',
    'apostatera',
    'apostaterai',
    'apostaterei',
    'apostateremo',
    'apostaterete',
    'apostatero',
    'apostati',
    'apostatiamo',
    'apostatiate',
    'apostatino',
    'apostato',
    'apostema',
    'aposteme',
    'apostemi',
    'apostola',
    'apostolati',
    'apostolato',
    'apostole',
    'apostoli',
    'apostolica',
    'apostoliche',
    'apostolici',
    'apostolicita',
    'apostolico',
    'apostolo',
    'apostrofa',
    'apostrofai',
    'apostrofammo',
    'apostrofando',
    'apostrofano',
    'apostrofante',
    'apostrofanti',
    'apostrofare',
    'apostrofasse',
    'apostrofassi',
    'apostrofaste',
    'apostrofasti',
    'apostrofata',
    'apostrofate',
    'apostrofati',
    'apostrofato',
    'apostrofava',
    'apostrofavi',
    'apostrofavo',
    'apostrofe',
    'apostrofera',
    'apostroferai',
    'apostroferei',
    'apostrofero',
    'apostroferò',
    'apostrofi',
    'apostrofiamo',
    'apostrofiate',
    'apostrofino',
    'apostrofo',
    'apoteca',
    'apoteche',
    'apoteci',
    'apotecio',
    'apotema',
    'apotemi',
    'apoteosi',
    'apotropaica',
    'apotropaiche',
    'apotropaici',
    'apotropaico',
    'apozeugma',
    'apozeugmi',
    'appacera',
    'appacerai',
    'appaceranno',
    'appacerebbe',
    'appacerei',
    'appaceremmo',
    'appaceremo',
    'appacereste',
    'appaceresti',
    'appacerete',
    'appacero',
    'appaci',
    'appacia',
    'appaciai',
    'appaciammo',
    'appaciamo',
    'appaciamoci',
    'appaciando',
    'appaciandoci',
    'appaciandomi',
    'appaciandosi',
    'appaciandoti',
    'appaciandovi',
    'appaciano',
    'appaciante',
    'appacianti',
    'appaciantisi',
    'appaciarci',
    'appaciare',
    'appaciarmi',
    'appaciarono',
    'appaciarsi',
    'appaciarti',
    'appaciarvi',
    'appaciasse',
    'appaciassero',
    'appaciassi',
    'appaciassimo',
    'appaciaste',
    'appaciasti',
    'appaciata',
    'appaciate',
    'appaciatevi',
    'appaciati',
    'appaciato',
    'appaciatomi',
    'appaciatoti',
    'appaciava',
    'appaciavamo',
    'appaciavano',
    'appaciavate',
    'appaciavi',
    'appaciavo',
    'appacifica',
    'appacificai',
    'appacificano',
    'appacificare',
    'appacificata',
    'appacificate',
    'appacificati',
    'appacificato',
    'appacificava',
    'appacificavi',
    'appacificavo',
    'appacifichi',
    'appacifico',
    'appacino',
    'appacio',
    'appaga',
    'appagabile',
    'appagabili',
    'appagai',
    'appagam',
    'appagamenti',
    'appagamento',
    'appagammo',
    'appagando',
    'appagandoci',
    'appagandomi',
    'appagandone',
    'appagandosi',
    'appagandoti',
    'appagandovi',
    'appagano',
    'appagante',
    'appaganti',
    'appagantisi',
    'appagarci',
    'appagare',
    'appagarmi',
    'appagarne',
    'appagarono',
    'appagarsi',
    'appagarti',
    'appagarvi',
    'appagasse',
    'appagassero',
    'appagassi',
    'appagassimo',
    'appagaste',
    'appagasti',
    'appagata',
    'appagate',
    'appagatevi',
    'appagati',
    'appagato',
    'appagatomi',
    'appagatore',
    'appagatori',
    'appagatoti',
    'appagatrice',
    'appagatrici',
    'appagava',
    'appagavamo',
    'appagavano',
    'appagavate',
    'appagavi',
    'appagavo',
    'appaghera',
    'appagherai',
    'appagheranno',
    'appagherebbe',
    'appagherei',
    'appagheremmo',
    'appagheremo',
    'appaghereste',
    'appagheresti',
    'appagherete',
    'appaghero',
    'appagherò',
    'appaghi',
    'appaghiamo',
    'appaghiamoci',
    'appaghiate',
    'appaghino',
    'appago',
    'appai',
    'appaia',
    'appaiai',
    'appaiamenti',
    'appaiamento',
    'appaiammo',
    'appaiamo',
    'appaiamoci',
    'appaiando',
    'appaiandoci',
    'appaiandomi',
    'appaiandosi',
    'appaiandoti',
    'appaiandovi',
    'appaiano',
    'appaiante',
    'appaianti',
    'appaiantisi',
    'appaiarci',
    'appaiare',
    'appaiarmi',
    'appaiarono',
    'appaiarsi',
    'appaiarti',
    'appaiarvi',
    'appaiasse',
    'appaiassero',
    'appaiassi',
    'appaiassimo',
    'appaiaste',
    'appaiasti',
    'appaiata',
    'appaiate',
    'appaiatevi',
    'appaiati',
    'appaiato',
    'appaiatomi',
    'appaiatore',
    'appaiatori',
    'appaiatoti',
    'appaiatrice',
    'appaiatrici',
    'appaiatura',
    'appaiature',
    'appaiava',
    'appaiavamo',
    'appaiavano',
    'appaiavate',
    'appaiavi',
    'appaiavo',
    'appaiera',
    'appaierai',
    'appaieranno',
    'appaierebbe',
    'appaierei',
    'appaieremmo',
    'appaieremo',
    'appaiereste',
    'appaieresti',
    'appaierete',
    'appaiero',
    'appaierò',
    'appaino',
    'appaio',
    'appaiono',
    'appalesa',
    'appalesai',
    'appalesammo',
    'appalesando',
    'appalesano',
    'appalesante',
    'appalesanti',
    'appalesare',
    'appalesarono',
    'appalesasse',
    'appalesassi',
    'appalesaste',
    'appalesasti',
    'appalesata',
    'appalesate',
    'appalesati',
    'appalesato',
    'appalesava',
    'appalesavamo',
    'appalesavano',
    'appalesavate',
    'appalesavi',
    'appalesavo',
    'appalesera',
    'appaleserai',
    'appaleserei',
    'appaleseremo',
    'appaleserete',
    'appalesero',
    'appalesi',
    'appalesiamo',
    'appalesiate',
    'appalesino',
    'appaleso',
    'appallottola',
    'appallottoli',
    'appallottolo',
    'appalmata',
    'appalmate',
    'appalmati',
    'appalmato',
    'appalta',
    'appaltai',
    'appaltammo',
    'appaltando',
    'appaltano',
    'appaltante',
    'appaltanti',
    'appaltare',
    'appaltarono',
    'appaltasse',
    'appaltassero',
    'appaltassi',
    'appaltassimo',
    'appaltaste',
    'appaltasti',
    'appaltata',
    'appaltate',
    'appaltati',
    'appaltato',
    'appaltatore',
    'appaltatori',
    'appaltatrice',
    'appaltatrici',
    'appaltava',
    'appaltavamo',
    'appaltavano',
    'appaltavate',
    'appaltavi',
    'appaltavo',
    'appaltera',
    'appalterai',
    'appalteranno',
    'appalterebbe',
    'appalterei',
    'appalteremmo',
    'appalteremo',
    'appaltereste',
    'appalteresti',
    'appalterete',
    'appaltero',
    'appalterò',
    'appalti',
    'appaltiamo',
    'appaltiate',
    'appaltino',
    'appalto',
    'appaludisca',
    'appaludisce',
    'appaludisci',
    'appaludisco',
    'appanna',
    'appannabile',
    'appannabili',
    'appannaggi',
    'appannaggio',
    'appannai',
    'appannamenti',
    'appannamento',
    'appannammo',
    'appannando',
    'appannandoci',
    'appannandomi',
    'appannandosi',
    'appannandoti',
    'appannandovi',
    'appannano',
    'appannante',
    'appannanti',
    'appannantisi',
    'appannarci',
    'appannare',
    'appannarmi',
    'appannarono',
    'appannarsi',
    'appannarti',
    'appannarvi',
    'appannasse',
    'appannassero',
    'appannassi',
    'appannassimo',
    'appannaste',
    'appannasti',
    'appannata',
    'appannate',
    'appannatevi',
    'appannati',
    'appannato',
    'appannatoi',
    'appannatoio',
    'appannatomi',
    'appannatoti',
    'appannatura',
    'appannature',
    'appannava',
    'appannavamo',
    'appannavano',
    'appannavate',
    'appannavi',
    'appannavo',
    'appannera',
    'appannerai',
    'appanneranno',
    'appannerebbe',
    'appannerei',
    'appanneremmo',
    'appanneremo',
    'appannereste',
    'appanneresti',
    'appannerete',
    'appannero',
    'appannerò',
    'appanni',
    'appanniamo',
    'appanniamoci',
    'appanniate',
    'appannino',
    'appanno',
    'appante',
    'appara',
    'apparai',
    'apparammo',
    'apparando',
    'apparano',
    'apparante',
    'apparanti',
    'apparare',
    'appararono',
    'apparasse',
    'apparassero',
    'apparassi',
    'apparassimo',
    'apparaste',
    'apparasti',
    'apparata',
    'apparate',
    'apparati',
    'apparato',
    'apparatore',
    'apparatori',
    'apparatrice',
    'apparatrici',
    'apparava',
    'apparavamo',
    'apparavano',
    'apparavate',
    'apparavi',
    'apparavo',
    'appare',
    'apparecchi',
    'apparecchia',
    'apparecchiai',
    'apparecchino',
    'apparecchio',
    'apparendo',
    'apparenta',
    'apparentai',
    'apparentammo',
    'apparentando',
    'apparentano',
    'apparentante',
    'apparentanti',
    'apparentarci',
    'apparentare',
    'apparentarmi',
    'apparentarsi',
    'apparentarti',
    'apparentarvi',
    'apparentasse',
    'apparentassi',
    'apparentaste',
    'apparentasti',
    'apparentata',
    'apparentate',
    'apparentati',
    'apparentato',
    'apparentava',
    'apparentavi',
    'apparentavo',
    'apparente',
    'apparentera',
    'apparenterai',
    'apparenterei',
    'apparentero',
    'apparenti',
    'apparentiamo',
    'apparentiate',
    'apparentino',
    'apparento',
    'apparenza',
    'apparenze',
    'apparera',
    'apparerai',
    'appareranno',
    'apparerebbe',
    'apparerei',
    'appareremmo',
    'appareremo',
    'apparereste',
    'appareresti',
    'apparerete',
    'apparero',
    'appareti',
    'appari',
    'appariamo',
    'appariate',
    'apparigli',
    'appariglia',
    'apparigliai',
    'apparigliamo',
    'apparigliano',
    'apparigliare',
    'apparigliata',
    'apparigliate',
    'apparigliati',
    'apparigliato',
    'apparigliava',
    'apparigliavi',
    'apparigliavo',
    'apparigliera',
    'apparigliero',
    'appariglino',
    'appariglio',
    'apparii',
    'apparimenti',
    'apparimento',
    'apparimmo',
    'apparino',
    'apparir',
    'apparira',
    'apparirai',
    'appariranno',
    'apparire',
    'apparirebbe',
    'apparirei',
    'appariremmo',
    'appariremo',
    'apparireste',
    'appariresti',
    'apparirete',
    'appariro',
    'apparirono',
    'apparirsi',
    'apparirà',
    'apparisca',
    'appariscano',
    'apparisce',
    'appariscente',
    'appariscenti',
    'appariscenza',
    'appariscenze',
    'apparisci',
    'apparisco',
    'appariscono',
    'apparisse',
    'apparissero',
    'apparissi',
    'apparissimo',
    'appariste',
    'apparisti',
    'apparita',
    'apparite',
    'appariti',
    'apparito',
    'apparitore',
    'apparitori',
    'appariva',
    'apparivamo',
    'apparivano',
    'apparivate',
    'apparivi',
    'apparivo',
    'apparizio',
    'apparizione',
    'apparizioni',
    'apparo',
    'apparra',
    'apparrai',
    'apparranno',
    'apparremo',
    'apparrete',
    'apparro',
    'apparsa',
    'apparse',
    'apparsero',
    'apparsi',
    'apparso',
    'apparta',
    'appartai',
    'appartamenti',
    'appartamento',
    'appartammo',
    'appartando',
    'appartandoci',
    'appartandomi',
    'appartandosi',
    'appartandoti',
    'appartandovi',
    'appartano',
    'appartante',
    'appartanti',
    'appartantisi',
    'appartarci',
    'appartare',
    'appartarmi',
    'appartarono',
    'appartarsi',
    'appartarti',
    'appartarvi',
    'appartasse',
    'appartassero',
    'appartassi',
    'appartassimo',
    'appartaste',
    'appartasti',
    'appartata',
    'appartate',
    'appartatevi',
    'appartati',
    'appartato',
    'appartatomi',
    'appartatoti',
    'appartava',
    'appartavamo',
    'appartavano',
    'appartavate',
    'appartavi',
    'appartavo',
    'appartene',
    'appartenei',
    'appartenemmo',
    'appartenendo',
    'appartenente',
    'appartenenti',
    'appartenenza',
    'appartenenze',
    'appartenerci',
    'appartenere',
    'appartenerle',
    'appartenermi',
    'appartenersi',
    'appartenerti',
    'appartenervi',
    'appartenesse',
    'appartenessi',
    'apparteneste',
    'appartenesti',
    'appartenete',
    'appartenette',
    'appartenetti',
    'apparteneva',
    'appartenevi',
    'appartenevo',
    'appartenga',
    'appartengano',
    'appartengo',
    'appartengono',
    'apparteniamo',
    'apparteniate',
    'appartenne',
    'appartennero',
    'appartenni',
    'appartente',
    'appartenuta',
    'appartenute',
    'appartenuti',
    'appartenuto',
    'appartera',
    'apparterai',
    'apparteranno',
    'apparterebbe',
    'apparterei',
    'apparteremmo',
    'apparteremo',
    'appartereste',
    'apparteresti',
    'apparterete',
    'appartero',
    'apparterra',
    'apparterrai',
    'apparterrei',
    'apparterremo',
    'apparterrete',
    'apparterro',
    'apparterrà',
    'apparterrò',
    'apparti',
    'appartiamo',
    'appartiamoci',
    'appartiate',
    'appartiene',
    'appartieni',
    'appartino',
    'apparto',
    'apparve',
    'apparvero',
    'apparvi',
    'appassendo',
    'appassendoci',
    'appassendomi',
    'appassendosi',
    'appassendoti',
    'appassendovi',
    'appassente',
    'appassenti',
    'appassentisi',
    'appassi',
    'appassiamo',
    'appassiamoci',
    'appassiate',
    'appassii',
    'appassimenti',
    'appassimento',
    'appassimmo',
    'appassiona',
    'appassionai',
    'appassionano',
    'appassionare',
    'appassionata',
    'appassionate',
    'appassionati',
    'appassionato',
    'appassionava',
    'appassionavi',
    'appassionavo',
    'appassionera',
    'appassionero',
    'appassionerò',
    'appassioni',
    'appassionino',
    'appassiono',
    'appassira',
    'appassirai',
    'appassiranno',
    'appassirci',
    'appassire',
    'appassirebbe',
    'appassirei',
    'appassiremmo',
    'appassiremo',
    'appassireste',
    'appassiresti',
    'appassirete',
    'appassirmi',
    'appassiro',
    'appassirono',
    'appassirsi',
    'appassirti',
    'appassirvi',
    'appassirà',
    'appassisca',
    'appassiscano',
    'appassisce',
    'appassisci',
    'appassisciti',
    'appassisco',
    'appassiscono',
    'appassisse',
    'appassissero',
    'appassissi',
    'appassissimo',
    'appassiste',
    'appassisti',
    'appassita',
    'appassite',
    'appassitevi',
    'appassiti',
    'appassito',
    'appassitomi',
    'appassitoti',
    'appassiva',
    'appassivamo',
    'appassivano',
    'appassivate',
    'appassivi',
    'appassivo',
    'appasta',
    'appastai',
    'appastammo',
    'appastando',
    'appastandoci',
    'appastandomi',
    'appastandosi',
    'appastandoti',
    'appastandovi',
    'appastano',
    'appastante',
    'appastanti',
    'appastantisi',
    'appastarci',
    'appastare',
    'appastarmi',
    'appastarono',
    'appastarsi',
    'appastarti',
    'appastarvi',
    'appastasse',
    'appastassero',
    'appastassi',
    'appastassimo',
    'appastaste',
    'appastasti',
    'appastata',
    'appastate',
    'appastatevi',
    'appastati',
    'appastato',
    'appastatomi',
    'appastatoti',
    'appastava',
    'appastavamo',
    'appastavano',
    'appastavate',
    'appastavi',
    'appastavo',
    'appastella',
    'appastellai',
    'appastellano',
    'appastellare',
    'appastellata',
    'appastellate',
    'appastellati',
    'appastellato',
    'appastellava',
    'appastellavi',
    'appastellavo',
    'appastellera',
    'appastellero',
    'appastelli',
    'appastellino',
    'appastello',
    'appastera',
    'appasterai',
    'appasteranno',
    'appasterebbe',
    'appasterei',
    'appasteremmo',
    'appasteremo',
    'appastereste',
    'appasteresti',
    'appasterete',
    'appastero',
    'appasti',
    'appastiamo',
    'appastiamoci',
    'appastiate',
    'appastino',
    'appasto',
    'appeal',
    'appeasement',
    'appella',
    'appellabile',
    'appellabili',
    'appellai',
    'appellammo',
    'appellando',
    'appellandoci',
    'appellandomi',
    'appellandosi',
    'appellandoti',
    'appellandovi',
    'appellano',
    'appellante',
    'appellanti',
    'appellantisi',
    'appellarci',
    'appellare',
    'appellarmi',
    'appellarono',
    'appellarsi',
    'appellarti',
    'appellarvi',
    'appellasse',
    'appellassero',
    'appellassi',
    'appellassimo',
    'appellaste',
    'appellasti',
    'appellata',
    'appellate',
    'appellatevi',
    'appellati',
    'appellativa',
    'appellative',
    'appellativi',
    'appellativo',
    'appellato',
    'appellatomi',
    'appellatori',
    'appellatoria',
    'appellatorie',
    'appellatorio',
    'appellatoti',
    'appellava',
    'appellavamo',
    'appellavano',
    'appellavate',
    'appellavi',
    'appellavo',
    'appellazione',
    'appellazioni',
    'appellera',
    'appellerai',
    'appelleranno',
    'appellerebbe',
    'appellerei',
    'appelleremmo',
    'appelleremo',
    'appellereste',
    'appelleresti',
    'appellerete',
    'appellero',
    'appellerò',
    'appelli',
    'appelliamo',
    'appelliamoci',
    'appelliate',
    'appellino',
    'appello',
    'appena',
    'appenai',
    'appenammo',
    'appenando',
    'appenandoci',
    'appenandomi',
    'appenandosi',
    'appenandoti',
    'appenandovi',
    'appenano',
    'appenante',
    'appenanti',
    'appenantisi',
    'appenarci',
    'appenare',
    'appenarmi',
    'appenarono',
    'appenarsi',
    'appenarti',
    'appenarvi',
    'appenasse',
    'appenassero',
    'appenassi',
    'appenassimo',
    'appenaste',
    'appenasti',
    'appenata',
    'appenate',
    'appenatevi',
    'appenati',
    'appenato',
    'appenatomi',
    'appenatoti',
    'appenava',
    'appenavamo',
    'appenavano',
    'appenavate',
    'appenavi',
    'appenavo',
    'appenda',
    'appendano',
    'appende',
    'appendemmo',
    'appendendo',
    'appendendoci',
    'appendendomi',
    'appendendosi',
    'appendendoti',
    'appendendovi',
    'appendente',
    'appendenti',
    'appendentisi',
    'appendera',
    'appenderai',
    'appenderanno',
    'appenderci',
    'appendere',
    'appenderebbe',
    'appenderei',
    'appenderemmo',
    'appenderemo',
    'appendereste',
    'appenderesti',
    'appenderete',
    'appendermi',
    'appendero',
    'appendersi',
    'appenderti',
    'appendervi',
    'appenderò',
    'appendesse',
    'appendessero',
    'appendessi',
    'appendessimo',
    'appendeste',
    'appendesti',
    'appendete',
    'appendetevi',
    'appendeva',
    'appendevamo',
    'appendevano',
    'appendevate',
    'appendevi',
    'appendevo',
    'appendi',
    'appendiabiti',
    'appendiabito',
    'appendiamo',
    'appendiamoci',
    'appendiate',
    'appendice',
    'appendici',
    'appendicista',
    'appendiciste',
    'appendicisti',
    'appendicite',
    'appendiciti',
    'appendigonna',
    'appendini',
    'appenditi',
    'appendizi',
    'appendizie',
    'appendo',
    'appendono',
    'appenera',
    'appenerai',
    'appeneranno',
    'appenerebbe',
    'appenerei',
    'appeneremmo',
    'appeneremo',
    'appenereste',
    'appeneresti',
    'appenerete',
    'appenero',
    'appeni',
    'appeniamo',
    'appeniamoci',
    'appeniate',
    'appenino',
    'appennella',
    'appennellai',
    'appennellano',
    'appennellare',
    'appennellata',
    'appennellate',
    'appennellati',
    'appennellato',
    'appennellava',
    'appennellavi',
    'appennellavo',
    'appennellera',
    'appennellero',
    'appennelli',
    'appennellino',
    'appennello',
    'appennina',
    'appennine',
    'appennini',
    'appenninica',
    'appenniniche',
    'appenninici',
    'appenninico',
    'appennino',
    'appeno',
    'apperception',
    'appercettiva',
    'appercettive',
    'appercettivi',
    'appercettivo',
    'appercezione',
    'appercezioni',
    'appert',
    'appertizza',
    'appertizzai',
    'appertizzano',
    'appertizzare',
    'appertizzata',
    'appertizzate',
    'appertizzati',
    'appertizzato',
    'appertizzava',
    'appertizzavi',
    'appertizzavo',
    'appertizzera',
    'appertizzero',
    'appertizzi',
    'appertizzino',
    'appertizzo',
    'appesa',
    'appesantendo',
    'appesantente',
    'appesantenti',
    'appesanti',
    'appesantiamo',
    'appesantiate',
    'appesantii',
    'appesantimmo',
    'appesantira',
    'appesantirai',
    'appesantirci',
    'appesantire',
    'appesantirei',
    'appesantirmi',
    'appesantiro',
    'appesantirsi',
    'appesantirti',
    'appesantirvi',
    'appesantirà',
    'appesantirò',
    'appesantisca',
    'appesantisce',
    'appesantisci',
    'appesantisco',
    'appesantisse',
    'appesantissi',
    'appesantiste',
    'appesantisti',
    'appesantita',
    'appesantite',
    'appesantiti',
    'appesantito',
    'appesantiva',
    'appesantivi',
    'appesantivo',
    'appese',
    'appesero',
    'appesi',
    'appeso',
    'appesomi',
    'appesoti',
    'appesta',
    'appestai',
    'appestammo',
    'appestando',
    'appestano',
    'appestante',
    'appestanti',
    'appestare',
    'appestarono',
    'appestasse',
    'appestassero',
    'appestassi',
    'appestassimo',
    'appestaste',
    'appestasti',
    'appestata',
    'appestate',
    'appestati',
    'appestato',
    'appestatore',
    'appestatori',
    'appestatrice',
    'appestatrici',
    'appestava',
    'appestavamo',
    'appestavano',
    'appestavate',
    'appestavi',
    'appestavo',
    'appestera',
    'appesterai',
    'appesteranno',
    'appesterebbe',
    'appesterei',
    'appesteremmo',
    'appesteremo',
    'appestereste',
    'appesteresti',
    'appesterete',
    'appestero',
    'appesterò',
    'appesti',
    'appestiamo',
    'appestiate',
    'appestino',
    'appesto',
    'appetendo',
    'appetente',
    'appetenti',
    'appetenza',
    'appetenze',
    'appeti',
    'appetiamo',
    'appetiate',
    'appetibile',
    'appetibili',
    'appetibilita',
    'appetibilità',
    'appetii',
    'appetimmo',
    'appetira',
    'appetirai',
    'appetiranno',
    'appetire',
    'appetirebbe',
    'appetirei',
    'appetiremmo',
    'appetiremo',
    'appetireste',
    'appetiresti',
    'appetirete',
    'appetiro',
    'appetirono',
    'appetisca',
    'appetiscano',
    'appetisce',
    'appetisci',
    'appetisco',
    'appetiscono',
    'appetisse',
    'appetissero',
    'appetissi',
    'appetissimo',
    'appetiste',
    'appetisti',
    'appetita',
    'appetite',
    'appetiti',
    'appetitiva',
    'appetitive',
    'appetitivi',
    'appetitivo',
    'appetito',
    'appetitosa',
    'appetitose',
    'appetitosi',
    'appetitoso',
    'appetiva',
    'appetivamo',
    'appetivano',
    'appetivate',
    'appetivi',
    'appetivo',
    'appetizer',
    'appetizing',
    'appetizione',
    'appetizioni',
    'appetta',
    'appettai',
    'appettammo',
    'appettando',
    'appettano',
    'appettante',
    'appettanti',
    'appettare',
    'appettarono',
    'appettasse',
    'appettassero',
    'appettassi',
    'appettassimo',
    'appettaste',
    'appettasti',
    'appettata',
    'appettate',
    'appettati',
    'appettato',
    'appettava',
    'appettavamo',
    'appettavano',
    'appettavate',
    'appettavi',
    'appettavo',
    'appettera',
    'appetterai',
    'appetteranno',
    'appetterebbe',
    'appetterei',
    'appetteremmo',
    'appetteremo',
    'appettereste',
    'appetteresti',
    'appetterete',
    'appettero',
    'appetti',
    'appettiamo',
    'appettiate',
    'appettibile',
    'appettino',
    'appetto',
    'appezza',
    'appezzai',
    'appezzamenti',
    'appezzamento',
    'appezzammo',
    'appezzando',
    'appezzano',
    'appezzante',
    'appezzanti',
    'appezzare',
    'appezzarono',
    'appezzasse',
    'appezzassero',
    'appezzassi',
    'appezzassimo',
    'appezzaste',
    'appezzasti',
    'appezzata',
    'appezzate',
    'appezzati',
    'appezzato',
    'appezzatura',
    'appezzature',
    'appezzava',
    'appezzavamo',
    'appezzavano',
    'appezzavate',
    'appezzavi',
    'appezzavo',
    'appezzera',
    'appezzerai',
    'appezzeranno',
    'appezzerebbe',
    'appezzerei',
    'appezzeremmo',
    'appezzeremo',
    'appezzereste',
    'appezzeresti',
    'appezzerete',
    'appezzero',
    'appezzi',
    'appezziamo',
    'appezziate',
    'appezzino',
    'appezzo',
    'appi',
    'appia',
    'appiacevoli',
    'appiacevolii',
    'appiana',
    'appianabile',
    'appianabili',
    'appianai',
    'appianamenti',
    'appianamento',
    'appianammo',
    'appianando',
    'appianandoci',
    'appianandomi',
    'appianandosi',
    'appianandoti',
    'appianandovi',
    'appianano',
    'appianante',
    'appiananti',
    'appianantisi',
    'appianarci',
    'appianare',
    'appianarmi',
    'appianarono',
    'appianarsi',
    'appianarti',
    'appianarvi',
    'appianasse',
    'appianassero',
    'appianassi',
    'appianassimo',
    'appianaste',
    'appianasti',
    'appianata',
    'appianate',
    'appianatevi',
    'appianati',
    'appianato',
    'appianatoi',
    'appianatoia',
    'appianatoie',
    'appianatoio',
    'appianatomi',
    'appianatoti',
    'appianatura',
    'appianature',
    'appianava',
    'appianavamo',
    'appianavano',
    'appianavate',
    'appianavi',
    'appianavo',
    'appianera',
    'appianerai',
    'appianeranno',
    'appianerebbe',
    'appianerei',
    'appianeremmo',
    'appianeremo',
    'appianereste',
    'appianeresti',
    'appianerete',
    'appianero',
    'appianerò',
    'appiani',
    'appianiamo',
    'appianiamoci',
    'appianiate',
    'appianino',
    'appiano',
    'appiastra',
    'appiastrai',
    'appiastrammo',
    'appiastrando',
    'appiastrano',
    'appiastrante',
    'appiastranti',
    'appiastrarci',
    'appiastrare',
    'appiastrarmi',
    'appiastrarsi',
    'appiastrarti',
    'appiastrarvi',
    'appiastrasse',
    'appiastrassi',
    'appiastraste',
    'appiastrasti',
    'appiastrata',
    'appiastrate',
    'appiastrati',
    'appiastrato',
    'appiastrava',
    'appiastravi',
    'appiastravo',
    'appiastrera',
    'appiastrerai',
    'appiastrerei',
    'appiastrero',
    'appiastri',
    'appiastriamo',
    'appiastriate',
    'appiastricci',
    'appiastrino',
    'appiastro',
    'appiatta',
    'appiattai',
    'appiattammo',
    'appiattando',
    'appiattano',
    'appiattante',
    'appiattanti',
    'appiattarci',
    'appiattare',
    'appiattarmi',
    'appiattarono',
    'appiattarsi',
    'appiattarti',
    'appiattarvi',
    'appiattasse',
    'appiattassi',
    'appiattaste',
    'appiattasti',
    'appiattata',
    'appiattate',
    'appiattatevi',
    'appiattati',
    'appiattato',
    'appiattatomi',
    'appiattatoti',
    'appiattava',
    'appiattavamo',
    'appiattavano',
    'appiattavate',
    'appiattavi',
    'appiattavo',
    'appiattendo',
    'appiattente',
    'appiattenti',
    'appiattera',
    'appiatterai',
    'appiatterei',
    'appiatteremo',
    'appiatterete',
    'appiattero',
    'appiatti',
    'appiattiamo',
    'appiattiate',
    'appiattii',
    'appiattimmo',
    'appiattino',
    'appiattira',
    'appiattirai',
    'appiattirci',
    'appiattire',
    'appiattirei',
    'appiattiremo',
    'appiattirete',
    'appiattirmi',
    'appiattiro',
    'appiattirono',
    'appiattirsi',
    'appiattirti',
    'appiattirvi',
    'appiattirà',
    'appiattirò',
    'appiattisca',
    'appiattisce',
    'appiattisci',
    'appiattisco',
    'appiattisse',
    'appiattissi',
    'appiattiste',
    'appiattisti',
    'appiattita',
    'appiattite',
    'appiattitevi',
    'appiattiti',
    'appiattito',
    'appiattitomi',
    'appiattitoti',
    'appiattiva',
    'appiattivamo',
    'appiattivano',
    'appiattivate',
    'appiattivi',
    'appiattivo',
    'appiatto',
    'appicca',
    'appiccagnoli',
    'appiccagnolo',
    'appiccai',
    'appiccammo',
    'appiccando',
    'appiccandosi',
    'appiccano',
    'appiccante',
    'appiccanti',
    'appiccare',
    'appiccarono',
    'appiccarsi',
    'appiccasse',
    'appiccassero',
    'appiccassi',
    'appiccassimo',
    'appiccaste',
    'appiccasti',
    'appiccata',
    'appiccate',
    'appiccati',
    'appiccato',
    'appiccatoi',
    'appiccatoio',
    'appiccatura',
    'appiccature',
    'appiccava',
    'appiccavamo',
    'appiccavano',
    'appiccavate',
    'appiccavi',
    'appiccavo',
    'appiccera',
    'appiccerai',
    'appicceranno',
    'appiccerebbe',
    'appiccerei',
    'appicceremmo',
    'appicceremo',
    'appiccereste',
    'appicceresti',
    'appiccerete',
    'appiccero',
    'appicchera',
    'appiccherai',
    'appiccherei',
    'appiccheremo',
    'appiccherete',
    'appicchero',
    'appiccherò',
    'appicchi',
    'appicchiamo',
    'appicchiate',
    'appicchino',
    'appicci',
    'appiccia',
    'appicciai',
    'appicciammo',
    'appicciamo',
    'appicciando',
    'appicciano',
    'appicciante',
    'appiccianti',
    'appicciare',
    'appicciarono',
    'appicciasse',
    'appicciassi',
    'appicciaste',
    'appicciasti',
    'appicciata',
    'appicciate',
    'appicciati',
    'appicciato',
    'appicciava',
    'appicciavamo',
    'appicciavano',
    'appicciavate',
    'appicciavi',
    'appicciavo',
    'appiccica',
    'appiccicai',
    'appiccicammo',
    'appiccicando',
    'appiccicano',
    'appiccicante',
    'appiccicanti',
    'appiccicarci',
    'appiccicare',
    'appiccicarmi',
    'appiccicarsi',
    'appiccicarti',
    'appiccicarvi',
    'appiccicasse',
    'appiccicassi',
    'appiccicaste',
    'appiccicasti',
    'appiccicata',
    'appiccicate',
    'appiccicati',
    'appiccicato',
    'appiccicava',
    'appiccicavi',
    'appiccicavo',
    'appiccichera',
    'appiccichero',
    'appiccicherò',
    'appiccichi',
    'appiccichino',
    'appiccico',
    'appiccicosa',
    'appiccicose',
    'appiccicosi',
    'appiccicoso',
    'appiccicume',
    'appiccicumi',
    'appiccino',
    'appiccio',
    'appicco',
    'appiccolente',
    'appiccolire',
    'appiccolisce',
    'appiccolita',
    'appiccolite',
    'appiccoliti',
    'appiccolito',
    'appie',
    'appieda',
    'appiedai',
    'appiedamenti',
    'appiedamento',
    'appiedammo',
    'appiedando',
    'appiedandola',
    'appiedandolo',
    'appiedandomi',
    'appiedano',
    'appiedante',
    'appiedanti',
    'appiedare',
    'appiedarla',
    'appiedarlo',
    'appiedarmi',
    'appiedarono',
    'appiedasse',
    'appiedassero',
    'appiedassi',
    'appiedassimo',
    'appiedaste',
    'appiedasti',
    'appiedata',
    'appiedate',
    'appiedati',
    'appiedato',
    'appiedava',
    'appiedavamo',
    'appiedavano',
    'appiedavate',
    'appiedavi',
    'appiedavo',
    'appiedera',
    'appiederai',
    'appiederanno',
    'appiederebbe',
    'appiederei',
    'appiederemmo',
    'appiederemo',
    'appiedereste',
    'appiederesti',
    'appiederete',
    'appiedero',
    'appiedi',
    'appiediamo',
    'appiediate',
    'appiedino',
    'appiedo',
    'appieno',
    'appigiona',
    'appigionai',
    'appigionammo',
    'appigionando',
    'appigionano',
    'appigionante',
    'appigionanti',
    'appigionare',
    'appigionasi',
    'appigionasse',
    'appigionassi',
    'appigionaste',
    'appigionasti',
    'appigionata',
    'appigionate',
    'appigionati',
    'appigionato',
    'appigionava',
    'appigionavi',
    'appigionavo',
    'appigionera',
    'appigionerai',
    'appigionerei',
    'appigionero',
    'appigioni',
    'appigioniamo',
    'appigioniate',
    'appigionino',
    'appigiono',
    'appigli',
    'appiglia',
    'appigliai',
    'appigliammo',
    'appigliamo',
    'appigliamoci',
    'appigliando',
    'appigliano',
    'appigliarci',
    'appigliare',
    'appigliarmi',
    'appigliarono',
    'appigliarsi',
    'appigliarti',
    'appigliarvi',
    'appigliasse',
    'appigliassi',
    'appigliaste',
    'appigliasti',
    'appigliata',
    'appigliate',
    'appigliatevi',
    'appigliati',
    'appigliato',
    'appigliatomi',
    'appigliatoti',
    'appigliava',
    'appigliavamo',
    'appigliavano',
    'appigliavate',
    'appigliavi',
    'appigliavo',
    'appigliera',
    'appiglierai',
    'appiglierei',
    'appiglieremo',
    'appiglierete',
    'appigliero',
    'appiglierò',
    'appiglino',
    'appiglio',
    'appinza',
    'appinzai',
    'appinzammo',
    'appinzando',
    'appinzano',
    'appinzante',
    'appinzanti',
    'appinzare',
    'appinzarono',
    'appinzasse',
    'appinzassero',
    'appinzassi',
    'appinzassimo',
    'appinzaste',
    'appinzasti',
    'appinzata',
    'appinzate',
    'appinzati',
    'appinzato',
    'appinzava',
    'appinzavamo',
    'appinzavano',
    'appinzavate',
    'appinzavi',
    'appinzavo',
    'appinzera',
    'appinzerai',
    'appinzeranno',
    'appinzerebbe',
    'appinzerei',
    'appinzeremmo',
    'appinzeremo',
    'appinzereste',
    'appinzeresti',
    'appinzerete',
    'appinzero',
    'appinzi',
    'appinziamo',
    'appinziate',
    'appinzino',
    'appinzo',
    'appio',
    'appioclaudio',
    'appiola',
    'appiole',
    'appioli',
    'appiolo',
    'appiomba',
    'appiombando',
    'appiombano',
    'appiombante',
    'appiombare',
    'appiombarono',
    'appiombata',
    'appiombate',
    'appiombati',
    'appiombato',
    'appiombava',
    'appiombavano',
    'appiombi',
    'appiombiamo',
    'appiombiate',
    'appiombino',
    'appiombo',
    'appioppa',
    'appioppai',
    'appioppammo',
    'appioppando',
    'appioppano',
    'appioppante',
    'appioppanti',
    'appiopparci',
    'appioppare',
    'appioppargli',
    'appiopparle',
    'appiopparmi',
    'appiopparono',
    'appiopparti',
    'appiopparvi',
    'appioppasse',
    'appioppassi',
    'appioppaste',
    'appioppasti',
    'appioppata',
    'appioppate',
    'appioppati',
    'appioppato',
    'appioppava',
    'appioppavamo',
    'appioppavano',
    'appioppavate',
    'appioppavi',
    'appioppavo',
    'appioppera',
    'appiopperai',
    'appiopperei',
    'appiopperemo',
    'appiopperete',
    'appioppero',
    'appiopperò',
    'appioppi',
    'appioppiamo',
    'appioppiate',
    'appioppino',
    'appioppo',
    'appisola',
    'appisolai',
    'appisolammo',
    'appisolando',
    'appisolano',
    'appisolarci',
    'appisolare',
    'appisolarmi',
    'appisolarono',
    'appisolarsi',
    'appisolarti',
    'appisolarvi',
    'appisolasse',
    'appisolassi',
    'appisolaste',
    'appisolasti',
    'appisolata',
    'appisolate',
    'appisolatevi',
    'appisolati',
    'appisolato',
    'appisolatomi',
    'appisolatoti',
    'appisolava',
    'appisolavamo',
    'appisolavano',
    'appisolavate',
    'appisolavi',
    'appisolavo',
    'appisolera',
    'appisolerai',
    'appisolerei',
    'appisoleremo',
    'appisolerete',
    'appisolero',
    'appisoli',
    'appisoliamo',
    'appisoliate',
    'appisolino',
    'appisolo',
    'appizza',
    'appizzai',
    'appizzammo',
    'appizzando',
    'appizzano',
    'appizzante',
    'appizzanti',
    'appizzare',
    'appizzarono',
    'appizzasse',
    'appizzassero',
    'appizzassi',
    'appizzassimo',
    'appizzaste',
    'appizzasti',
    'appizzata',
    'appizzate',
    'appizzati',
    'appizzato',
    'appizzava',
    'appizzavamo',
    'appizzavano',
    'appizzavate',
    'appizzavi',
    'appizzavo',
    'appizzera',
    'appizzerai',
    'appizzeranno',
    'appizzerebbe',
    'appizzerei',
    'appizzeremmo',
    'appizzeremo',
    'appizzereste',
    'appizzeresti',
    'appizzerete',
    'appizzero',
    'appizzi',
    'appizziamo',
    'appizziate',
    'appizzino',
    'appizzo',
    'applauda',
    'applaudano',
    'applaude',
    'applaudendo',
    'applaudente',
    'applaudenti',
    'applaudi',
    'applaudiamo',
    'applaudiate',
    'applaudii',
    'applaudimmo',
    'applaudira',
    'applaudirai',
    'applaudire',
    'applaudirei',
    'applaudiremo',
    'applaudirete',
    'applaudiro',
    'applaudirono',
    'applaudirsi',
    'applaudirà',
    'applaudirò',
    'applaudisca',
    'applaudisce',
    'applaudisci',
    'applaudisco',
    'applaudisse',
    'applaudissi',
    'applaudiste',
    'applaudisti',
    'applaudita',
    'applaudite',
    'applauditi',
    'applaudito',
    'applauditore',
    'applauditori',
    'applaudiva',
    'applaudivamo',
    'applaudivano',
    'applaudivate',
    'applaudivi',
    'applaudivo',
    'applaudo',
    'applaudono',
    'applausi',
    'applauso',
    'apple',
    'applica',
    'applicabile',
    'applicabili',
    'applicai',
    'applicala',
    'applicale',
    'applicali',
    'applicalo',
    'applicammo',
    'applicando',
    'applicandoci',
    'applicandola',
    'applicandole',
    'applicandoli',
    'applicandolo',
    'applicandomi',
    'applicandosi',
    'applicandoti',
    'applicandovi',
    'applicano',
    'applicante',
    'applicanti',
    'applicantisi',
    'applicarci',
    'applicare',
    'applicarla',
    'applicarle',
    'applicarli',
    'applicarlo',
    'applicarmi',
    'applicarono',
    'applicarsi',
    'applicarti',
    'applicarvelo',
    'applicarvi',
    'applicarvisi',
    'applicasse',
    'applicassero',
    'applicassi',
    'applicassimo',
    'applicaste',
    'applicasti',
    'applicata',
    'applicate',
    'applicatela',
    'applicatele',
    'applicateli',
    'applicatelo',
    'applicatevi',
    'applicati',
    'applicativa',
    'applicative',
    'applicativi',
    'applicativo',
    'applicato',
    'applicatomi',
    'applicatore',
    'applicatori',
    'applicatoti',
    'applicatrice',
    'applicatrici',
    'applicava',
    'applicavamo',
    'applicavano',
    'applicavate',
    'applicavi',
    'applicavo',
    'applicazione',
    'applicazioni',
    'applichera',
    'applicherai',
    'applicherei',
    'applicheremo',
    'applicherete',
    'applichero',
    'applicherà',
    'applichi',
    'applichiamo',
    'applichiate',
    'applichino',
    'applico',
    'applique',
    'appliques',
    'appo',
    'appodera',
    'appoderai',
    'appoderammo',
    'appoderando',
    'appoderano',
    'appoderante',
    'appoderanti',
    'appoderare',
    'appoderarono',
    'appoderasse',
    'appoderassi',
    'appoderaste',
    'appoderasti',
    'appoderata',
    'appoderate',
    'appoderati',
    'appoderato',
    'appoderava',
    'appoderavamo',
    'appoderavano',
    'appoderavate',
    'appoderavi',
    'appoderavo',
    'appoderera',
    'appodererai',
    'appodererei',
    'appodereremo',
    'appodererete',
    'appoderero',
    'appoderi',
    'appoderiamo',
    'appoderiate',
    'appoderino',
    'appodero',
    'appoevano',
    'appoggera',
    'appoggerai',
    'appoggeranno',
    'appoggerebbe',
    'appoggerei',
    'appoggeremmo',
    'appoggeremo',
    'appoggereste',
    'appoggeresti',
    'appoggerete',
    'appoggero',
    'appoggi',
    'appoggia',
    'appoggiacapo',
    'appoggiai',
    'appoggiala',
    'appoggiale',
    'appoggiali',
    'appoggialo',
    'appoggiamano',
    'appoggiammo',
    'appoggiamo',
    'appoggiamoci',
    'appoggiando',
    'appoggiano',
    'appoggiante',
    'appoggianti',
    'appoggiarci',
    'appoggiare',
    'appoggiarla',
    'appoggiarle',
    'appoggiarli',
    'appoggiarlo',
    'appoggiarmi',
    'appoggiarono',
    'appoggiarsi',
    'appoggiarti',
    'appoggiarvi',
    'appoggiasse',
    'appoggiassi',
    'appoggiaste',
    'appoggiasti',
    'appoggiata',
    'appoggiate',
    'appoggiatela',
    'appoggiatele',
    'appoggiateli',
    'appoggiatelo',
    'appoggiatevi',
    'appoggiati',
    'appoggiato',
    'appoggiatoi',
    'appoggiatoio',
    'appoggiatomi',
    'appoggiatoti',
    'appoggiatura',
    'appoggiature',
    'appoggiava',
    'appoggiavamo',
    'appoggiavano',
    'appoggiavate',
    'appoggiavi',
    'appoggiavo',
    'appoggino',
    'appoggio',
    'appollai',
    'appollaia',
    'appollaiai',
    'appollaiammo',
    'appollaiamo',
    'appollaiando',
    'appollaiano',
    'appollaiarci',
    'appollaiare',
    'appollaiarmi',
    'appollaiarsi',
    'appollaiarti',
    'appollaiarvi',
    'appollaiasse',
    'appollaiassi',
    'appollaiaste',
    'appollaiasti',
    'appollaiata',
    'appollaiate',
    'appollaiati',
    'appollaiato',
    'appollaiava',
    'appollaiavi',
    'appollaiavo',
    'appollaiera',
    'appollaierai',
    'appollaierei',
    'appollaiero',
    'appollaino',
    'appollaio',
    'appone',
    'apponemmo',
    'apponendo',
    'apponendoci',
    'apponendomi',
    'apponendosi',
    'apponendoti',
    'apponendovi',
    'apponente',
    'apponenti',
    'apponentisi',
    'apponesse',
    'apponessero',
    'apponessi',
    'apponessimo',
    'apponeste',
    'apponesti',
    'apponete',
    'apponetevi',
    'apponeva',
    'apponevamo',
    'apponevano',
    'apponevate',
    'apponevi',
    'apponevo',
    'apponga',
    'appongano',
    'appongo',
    'appongono',
    'apponi',
    'apponiamo',
    'apponiamoci',
    'apponiate',
    'apponibile',
    'apponibili',
    'apponibilita',
    'apponibilità',
    'apponiti',
    'apponta',
    'appontaggi',
    'appontaggio',
    'appontai',
    'appontammo',
    'appontando',
    'appontano',
    'appontante',
    'appontanti',
    'appontare',
    'appontarono',
    'appontasse',
    'appontassero',
    'appontassi',
    'appontassimo',
    'appontaste',
    'appontasti',
    'appontata',
    'appontate',
    'appontati',
    'appontato',
    'appontava',
    'appontavamo',
    'appontavano',
    'appontavate',
    'appontavi',
    'appontavo',
    'appontera',
    'apponterai',
    'apponteranno',
    'apponterebbe',
    'apponterei',
    'apponteremmo',
    'apponteremo',
    'appontereste',
    'apponteresti',
    'apponterete',
    'appontero',
    'apponti',
    'appontiamo',
    'appontiate',
    'appontino',
    'apponto',
    'appoppa',
    'appoppai',
    'appoppamenti',
    'appoppamento',
    'appoppammo',
    'appoppando',
    'appoppandoci',
    'appoppandomi',
    'appoppandosi',
    'appoppandoti',
    'appoppandovi',
    'appoppano',
    'appoppante',
    'appoppanti',
    'appoppantisi',
    'appopparci',
    'appoppare',
    'appopparmi',
    'appopparono',
    'appopparsi',
    'appopparti',
    'appopparvi',
    'appoppasse',
    'appoppassero',
    'appoppassi',
    'appoppassimo',
    'appoppaste',
    'appoppasti',
    'appoppata',
    'appoppate',
    'appoppatevi',
    'appoppati',
    'appoppato',
    'appoppatomi',
    'appoppatoti',
    'appoppava',
    'appoppavamo',
    'appoppavano',
    'appoppavate',
    'appoppavi',
    'appoppavo',
    'appoppera',
    'appopperai',
    'appopperanno',
    'appopperebbe',
    'appopperei',
    'appopperemmo',
    'appopperemo',
    'appoppereste',
    'appopperesti',
    'appopperete',
    'appoppero',
    'appoppi',
    'appoppiamo',
    'appoppiamoci',
    'appoppiate',
    'appoppino',
    'appoppo',
    'apporci',
    'apporla',
    'apporle',
    'apporli',
    'apporlo',
    'appormi',
    'apporne',
    'apporra',
    'apporrai',
    'apporranno',
    'apporre',
    'apporrebbe',
    'apporrebbero',
    'apporrei',
    'apporremmo',
    'apporremo',
    'apporreste',
    'apporresti',
    'apporrete',
    'apporro',
    'apporrà',
    'apporrò',
    'apporsi',
    'apporta',
    'apportai',
    'apportamenti',
    'apportamento',
    'apportammo',
    'apportando',
    'apportano',
    'apportante',
    'apportanti',
    'apportare',
    'apportarono',
    'apportasse',
    'apportassero',
    'apportassi',
    'apportassimo',
    'apportaste',
    'apportasti',
    'apportata',
    'apportate',
    'apportati',
    'apportato',
    'apportatore',
    'apportatori',
    'apportatrice',
    'apportatrici',
    'apportava',
    'apportavamo',
    'apportavano',
    'apportavate',
    'apportavi',
    'apportavo',
    'apportera',
    'apporterai',
    'apporteranno',
    'apporterebbe',
    'apporterei',
    'apporteremmo',
    'apporteremo',
    'apportereste',
    'apporteresti',
    'apporterete',
    'apportero',
    'apporterò',
    'apporti',
    'apportiamo',
    'apportiate',
    'apportino',
    'apporto',
    'apporvi',
    'appose',
    'apposero',
    'apposi',
    'apposita',
    'apposite',
    'appositi',
    'appositiva',
    'appositive',
    'appositivi',
    'appositivo',
    'apposito',
    'apposizione',
    'apposizioni',
    'apposta',
    'appostai',
    'appostamenti',
    'appostamento',
    'appostammo',
    'appostando',
    'appostandoci',
    'appostandomi',
    'appostandosi',
    'appostandoti',
    'appostandovi',
    'appostano',
    'appostante',
    'appostanti',
    'appostantisi',
    'appostarci',
    'appostare',
    'appostarmi',
    'appostarono',
    'appostarsi',
    'appostarti',
    'appostarvi',
    'appostasse',
    'appostassero',
    'appostassi',
    'appostassimo',
    'appostaste',
    'appostasti',
    'appostata',
    'appostate',
    'appostatevi',
    'appostati',
    'appostato',
    'appostatomi',
    'appostatoti',
    'appostava',
    'appostavamo',
    'appostavano',
    'appostavate',
    'appostavi',
    'appostavo',
    'apposte',
    'appostera',
    'apposterai',
    'apposteranno',
    'apposterebbe',
    'apposterei',
    'apposteremmo',
    'apposteremo',
    'appostereste',
    'apposteresti',
    'apposterete',
    'appostero',
    'apposterò',
    'apposti',
    'appostiamo',
    'appostiamoci',
    'appostiate',
    'appostino',
    'appostissima',
    'appostissime',
    'appostissimi',
    'appostissimo',
    'apposto',
    'appostomi',
    'appostoti',
    'appozza',
    'appozzai',
    'appozzammo',
    'appozzando',
    'appozzano',
    'appozzante',
    'appozzanti',
    'appozzare',
    'appozzarono',
    'appozzasse',
    'appozzassero',
    'appozzassi',
    'appozzassimo',
    'appozzaste',
    'appozzasti',
    'appozzata',
    'appozzate',
    'appozzati',
    'appozzato',
    'appozzava',
    'appozzavamo',
    'appozzavano',
    'appozzavate',
    'appozzavi',
    'appozzavo',
    'appozzera',
    'appozzerai',
    'appozzeranno',
    'appozzerebbe',
    'appozzerei',
    'appozzeremmo',
    'appozzeremo',
    'appozzereste',
    'appozzeresti',
    'appozzerete',
    'appozzero',
    'appozzi',
    'appozziamo',
    'appozziate',
    'appozzino',
    'appozzo',
    'apppare',
    'appr',
    'appratendo',
    'appratente',
    'appratenti',
    'apprati',
    'appratiamo',
    'appratiate',
    'appratii',
    'appratimenti',
    'appratimento',
    'appratimmo',
    'appratira',
    'appratirai',
    'appratiranno',
    'appratire',
    'appratirebbe',
    'appratirei',
    'appratiremmo',
    'appratiremo',
    'appratireste',
    'appratiresti',
    'appratirete',
    'appratiro',
    'appratirono',
    'appratisca',
    'appratiscano',
    'appratisce',
    'appratisci',
    'appratisco',
    'appratiscono',
    'appratisse',
    'appratissero',
    'appratissi',
    'appratissimo',
    'appratiste',
    'appratisti',
    'appratita',
    'appratite',
    'appratiti',
    'appratito',
    'apprativa',
    'apprativamo',
    'apprativano',
    'apprativate',
    'apprativi',
    'apprativo',
    'apprenda',
    'apprendano',
    'apprende',
    'apprendemmo',
    'apprendendo',
    'apprendente',
    'apprendenti',
    'apprendera',
    'apprenderai',
    'apprenderci',
    'apprendere',
    'apprenderei',
    'apprenderemo',
    'apprenderete',
    'apprenderla',
    'apprenderle',
    'apprenderli',
    'apprenderlo',
    'apprendermi',
    'apprendero',
    'apprendersi',
    'apprenderti',
    'apprendervi',
    'apprenderò',
    'apprendesse',
    'apprendessi',
    'apprendeste',
    'apprendesti',
    'apprendete',
    'apprendetevi',
    'apprendeva',
    'apprendevamo',
    'apprendevano',
    'apprendevate',
    'apprendevi',
    'apprendevo',
    'apprendi',
    'apprendiamo',
    'apprendiate',
    'apprendibile',
    'apprendibili',
    'apprendista',
    'apprendiste',
    'apprendisti',
    'apprenditi',
    'apprendo',
    'apprendono',
    'apprensibile',
    'apprensibili',
    'apprensione',
    'apprensioni',
    'apprensiva',
    'apprensive',
    'apprensivi',
    'apprensivo',
    'appresa',
    'apprese',
    'appresenta',
    'appresentai',
    'appresentano',
    'appresentare',
    'appresentata',
    'appresentate',
    'appresentati',
    'appresentato',
    'appresentava',
    'appresentavi',
    'appresentavo',
    'appresentera',
    'appresentero',
    'appresenti',
    'appresentino',
    'appresento',
    'appresero',
    'appresi',
    'appreso',
    'appresomi',
    'appresoti',
    'appressa',
    'appressai',
    'appressammo',
    'appressando',
    'appressano',
    'appressante',
    'appressanti',
    'appressarci',
    'appressare',
    'appressarmi',
    'appressarne',
    'appressarono',
    'appressarsi',
    'appressarti',
    'appressarvi',
    'appressasse',
    'appressassi',
    'appressaste',
    'appressasti',
    'appressata',
    'appressate',
    'appressati',
    'appressato',
    'appressava',
    'appressavamo',
    'appressavano',
    'appressavate',
    'appressavi',
    'appressavo',
    'appressera',
    'appresserai',
    'appresserei',
    'appresseremo',
    'appresserete',
    'appressero',
    'appressi',
    'appressiamo',
    'appressiate',
    'appressino',
    'appresso',
    'appresta',
    'apprestai',
    'apprestammo',
    'apprestando',
    'apprestano',
    'apprestante',
    'apprestanti',
    'apprestarci',
    'apprestare',
    'apprestarla',
    'apprestarle',
    'apprestarli',
    'apprestarlo',
    'apprestarmi',
    'apprestarono',
    'apprestarsi',
    'apprestarti',
    'apprestarvi',
    'apprestasse',
    'apprestassi',
    'apprestaste',
    'apprestasti',
    'apprestata',
    'apprestate',
    'apprestatevi',
    'apprestati',
    'apprestato',
    'apprestatomi',
    'apprestatoti',
    'apprestava',
    'apprestavamo',
    'apprestavano',
    'apprestavate',
    'apprestavi',
    'apprestavo',
    'apprestera',
    'appresterai',
    'appresterei',
    'appresteremo',
    'appresterete',
    'apprestero',
    'appresterò',
    'appresti',
    'apprestiamo',
    'apprestiate',
    'apprestino',
    'appresto',
    'appretta',
    'apprettai',
    'apprettammo',
    'apprettando',
    'apprettano',
    'apprettante',
    'apprettanti',
    'apprettare',
    'apprettarono',
    'apprettasse',
    'apprettassi',
    'apprettaste',
    'apprettasti',
    'apprettata',
    'apprettate',
    'apprettati',
    'apprettato',
    'apprettatore',
    'apprettatori',
    'apprettatura',
    'apprettature',
    'apprettava',
    'apprettavamo',
    'apprettavano',
    'apprettavate',
    'apprettavi',
    'apprettavo',
    'apprettera',
    'appretterai',
    'appretterei',
    'appretteremo',
    'appretterete',
    'apprettero',
    'appretti',
    'apprettiamo',
    'apprettiate',
    'apprettino',
    'appretto',
    'apprezza',
    'apprezzabile',
    'apprezzabili',
    'apprezzai',
    'apprezzammo',
    'apprezzando',
    'apprezzano',
    'apprezzante',
    'apprezzanti',
    'apprezzarci',
    'apprezzare',
    'apprezzarla',
    'apprezzarle',
    'apprezzarli',
    'apprezzarlo',
    'apprezzarmi',
    'apprezzarono',
    'apprezzarsi',
    'apprezzarti',
    'apprezzarvi',
    'apprezzasse',
    'apprezzassi',
    'apprezzaste',
    'apprezzasti',
    'apprezzata',
    'apprezzate',
    'apprezzati',
    'apprezzativa',
    'apprezzative',
    'apprezzativi',
    'apprezzativo',
    'apprezzato',
    'apprezzatore',
    'apprezzatori',
    'apprezzava',
    'apprezzavamo',
    'apprezzavano',
    'apprezzavate',
    'apprezzavi',
    'apprezzavo',
    'apprezzera',
    'apprezzerai',
    'apprezzerei',
    'apprezzeremo',
    'apprezzerete',
    'apprezzero',
    'apprezzerò',
    'apprezzi',
    'apprezziamo',
    'apprezziate',
    'apprezzino',
    'apprezzo',
    'approbare',
    'approbazione',
    'approbazioni',
    'approcci',
    'approcciando',
    'approcciante',
    'approcciare',
    'approcciarsi',
    'approcciata',
    'approcciate',
    'approcciati',
    'approcciato',
    'approccio',
    'approda',
    'approdai',
    'approdammo',
    'approdando',
    'approdano',
    'approdante',
    'approdanti',
    'approdare',
    'approdarne',
    'approdarono',
    'approdasse',
    'approdassero',
    'approdassi',
    'approdassimo',
    'approdaste',
    'approdasti',
    'approdata',
    'approdate',
    'approdati',
    'approdato',
    'approdatovi',
    'approdava',
    'approdavamo',
    'approdavano',
    'approdavate',
    'approdavi',
    'approdavo',
    'approdera',
    'approderai',
    'approderanno',
    'approderebbe',
    'approderei',
    'approderemmo',
    'approderemo',
    'approdereste',
    'approderesti',
    'approderete',
    'approdero',
    'approderò',
    'approdi',
    'approdiamo',
    'approdiate',
    'approdino',
    'approdo',
    'approfitta',
    'approfittai',
    'approfittano',
    'approfittare',
    'approfittata',
    'approfittate',
    'approfittati',
    'approfittato',
    'approfittava',
    'approfittavi',
    'approfittavo',
    'approfittera',
    'approfittero',
    'approfitti',
    'approfittino',
    'approfitto',
    'approfonda',
    'approfondai',
    'approfondano',
    'approfondare',
    'approfondata',
    'approfondate',
    'approfondati',
    'approfondato',
    'approfondava',
    'approfondavi',
    'approfondavo',
    'approfondera',
    'approfondero',
    'approfondi',
    'approfondii',
    'approfondino',
    'approfondira',
    'approfondire',
    'approfondiro',
    'approfondita',
    'approfondite',
    'approfonditi',
    'approfondito',
    'approfondiva',
    'approfondivi',
    'approfondivo',
    'approfondo',
    'appronta',
    'approntai',
    'approntammo',
    'approntando',
    'approntano',
    'approntante',
    'approntanti',
    'approntare',
    'approntarono',
    'approntasse',
    'approntassi',
    'approntaste',
    'approntasti',
    'approntata',
    'approntate',
    'approntati',
    'approntato',
    'approntatura',
    'approntature',
    'approntava',
    'approntavamo',
    'approntavano',
    'approntavate',
    'approntavi',
    'approntavo',
    'approntera',
    'appronterai',
    'appronterei',
    'appronteremo',
    'appronterete',
    'approntero',
    'appronti',
    'approntiamo',
    'approntiate',
    'approntino',
    'appronto',
    'appropiando',
    'appropiare',
    'appropiata',
    'appropiate',
    'appropiati',
    'appropiato',
    'appropinqua',
    'appropinquai',
    'appropinqui',
    'appropinquo',
    'appropri',
    'appropria',
    'appropriai',
    'appropriammo',
    'appropriamo',
    'appropriando',
    'appropriano',
    'appropriante',
    'approprianti',
    'appropriarci',
    'appropriare',
    'appropriarmi',
    'appropriarsi',
    'appropriarti',
    'appropriarvi',
    'appropriasse',
    'appropriassi',
    'appropriaste',
    'appropriasti',
    'appropriata',
    'appropriate',
    'appropriati',
    'appropriato',
    'appropriava',
    'appropriavi',
    'appropriavo',
    'appropriera',
    'approprierai',
    'approprierei',
    'appropriero',
    'approprierò',
    'approprino',
    'approprio',
    'approssima',
    'approssimai',
    'approssimano',
    'approssimare',
    'approssimata',
    'approssimate',
    'approssimati',
    'approssimato',
    'approssimava',
    'approssimavi',
    'approssimavo',
    'approssimera',
    'approssimero',
    'approssimi',
    'approssimino',
    'approssimo',
    'approva',
    'approvabile',
    'approvabili',
    'approvai',
    'approvammo',
    'approvando',
    'approvandola',
    'approvandole',
    'approvandoli',
    'approvandolo',
    'approvano',
    'approvante',
    'approvanti',
    'approvare',
    'approvarla',
    'approvarle',
    'approvarli',
    'approvarlo',
    'approvarono',
    'approvasse',
    'approvassero',
    'approvassi',
    'approvassimo',
    'approvaste',
    'approvasti',
    'approvata',
    'approvate',
    'approvati',
    'approvativa',
    'approvative',
    'approvativi',
    'approvativo',
    'approvato',
    'approvatore',
    'approvatori',
    'approvatrice',
    'approvatrici',
    'approvava',
    'approvavamo',
    'approvavano',
    'approvavate',
    'approvavi',
    'approvavo',
    'approvazione',
    'approvazioni',
    'approvera',
    'approverai',
    'approveranno',
    'approverebbe',
    'approverei',
    'approveremmo',
    'approveremo',
    'approvereste',
    'approveresti',
    'approverete',
    'approvero',
    'approverà',
    'approverò',
    'approvi',
    'approviamo',
    'approviate',
    'approvino',
    'approvo',
    'apprua',
    'appruai',
    'appruamenti',
    'appruamento',
    'appruammo',
    'appruando',
    'appruandoci',
    'appruandomi',
    'appruandosi',
    'appruandoti',
    'appruandovi',
    'appruano',
    'appruante',
    'appruanti',
    'appruantisi',
    'appruarci',
    'appruare',
    'appruarmi',
    'appruarono',
    'appruarsi',
    'appruarti',
    'appruarvi',
    'appruasse',
    'appruassero',
    'appruassi',
    'appruassimo',
    'appruaste',
    'appruasti',
    'appruata',
    'appruate',
    'appruatevi',
    'appruati',
    'appruato',
    'appruatomi',
    'appruatoti',
    'appruava',
    'appruavamo',
    'appruavano',
    'appruavate',
    'appruavi',
    'appruavo',
    'appruera',
    'appruerai',
    'apprueranno',
    'appruerebbe',
    'appruerei',
    'apprueremmo',
    'apprueremo',
    'appruereste',
    'apprueresti',
    'appruerete',
    'appruero',
    'apprui',
    'appruiamo',
    'appruiamoci',
    'appruiate',
    'appruino',
    'appruo',
    'appulcrare',
    'appulsi',
    'appulso',
    'appunta',
    'appuntabile',
    'appuntabili',
    'appuntai',
    'appuntalapis',
    'appuntamenti',
    'appuntamento',
    'appuntammo',
    'appuntando',
    'appuntandoci',
    'appuntandomi',
    'appuntandosi',
    'appuntandoti',
    'appuntandovi',
    'appuntano',
    'appuntante',
    'appuntanti',
    'appuntantisi',
    'appuntarci',
    'appuntare',
    'appuntarmi',
    'appuntarono',
    'appuntarsi',
    'appuntarti',
    'appuntarvi',
    'appuntasse',
    'appuntassero',
    'appuntassi',
    'appuntassimo',
    'appuntaste',
    'appuntasti',
    'appuntata',
    'appuntate',
    'appuntatevi',
    'appuntati',
    'appuntato',
    'appuntatomi',
    'appuntatore',
    'appuntatori',
    'appuntatoti',
    'appuntatrice',
    'appuntatrici',
    'appuntatura',
    'appuntature',
    'appuntava',
    'appuntavamo',
    'appuntavano',
    'appuntavate',
    'appuntavi',
    'appuntavo',
    'appuntella',
    'appuntellai',
    'appuntellano',
    'appuntellare',
    'appuntellata',
    'appuntellate',
    'appuntellati',
    'appuntellato',
    'appuntellava',
    'appuntellavi',
    'appuntellavo',
    'appuntellera',
    'appuntellero',
    'appuntelli',
    'appuntellino',
    'appuntello',
    'appuntendo',
    'appuntente',
    'appuntenti',
    'appuntera',
    'appunterai',
    'appunteranno',
    'appunterebbe',
    'appunterei',
    'appunteremmo',
    'appunteremo',
    'appuntereste',
    'appunteresti',
    'appunterete',
    'appuntero',
    'appunterò',
    'appunti',
    'appuntiamo',
    'appuntiamoci',
    'appuntiate',
    'appuntii',
    'appuntimmo',
    'appuntino',
    'appuntira',
    'appuntirai',
    'appuntiranno',
    'appuntire',
    'appuntirebbe',
    'appuntirei',
    'appuntiremmo',
    'appuntiremo',
    'appuntireste',
    'appuntiresti',
    'appuntirete',
    'appuntiro',
    'appuntirono',
    'appuntisca',
    'appuntiscano',
    'appuntisce',
    'appuntisci',
    'appuntisco',
    'appuntiscono',
    'appuntisse',
    'appuntissero',
    'appuntissi',
    'appuntissimo',
    'appuntiste',
    'appuntisti',
    'appuntita',
    'appuntite',
    'appuntiti',
    'appuntito',
    'appuntiva',
    'appuntivamo',
    'appuntivano',
    'appuntivate',
    'appuntivi',
    'appuntivo',
    'appunto',
    'appura',
    'appurai',
    'appuramenti',
    'appuramento',
    'appurammo',
    'appurando',
    'appurano',
    'appurante',
    'appuranti',
    'appurare',
    'appurarono',
    'appurasse',
    'appurassero',
    'appurassi',
    'appurassimo',
    'appuraste',
    'appurasti',
    'appurata',
    'appurate',
    'appurati',
    'appurato',
    'appurava',
    'appuravamo',
    'appuravano',
    'appuravate',
    'appuravi',
    'appuravo',
    'appurera',
    'appurerai',
    'appureranno',
    'appurerebbe',
    'appurerei',
    'appureremmo',
    'appureremo',
    'appurereste',
    'appureresti',
    'appurerete',
    'appurero',
    'appurerò',
    'appuri',
    'appuriamo',
    'appuriate',
    'appurino',
    'appuro',
    'appuzza',
    'appuzzai',
    'appuzzammo',
    'appuzzando',
    'appuzzano',
    'appuzzante',
    'appuzzanti',
    'appuzzare',
    'appuzzarono',
    'appuzzasse',
    'appuzzassero',
    'appuzzassi',
    'appuzzassimo',
    'appuzzaste',
    'appuzzasti',
    'appuzzata',
    'appuzzate',
    'appuzzati',
    'appuzzato',
    'appuzzava',
    'appuzzavamo',
    'appuzzavano',
    'appuzzavate',
    'appuzzavi',
    'appuzzavo',
    'appuzzera',
    'appuzzerai',
    'appuzzeranno',
    'appuzzerebbe',
    'appuzzerei',
    'appuzzeremmo',
    'appuzzeremo',
    'appuzzereste',
    'appuzzeresti',
    'appuzzerete',
    'appuzzero',
    'appuzzi',
    'appuzziamo',
    'appuzziate',
    'appuzzino',
    'appuzzo',
    'apra',
    'aprano',
    'aprassia',
    'aprassie',
    'apre',
    'aprendo',
    'aprendoci',
    'aprendogli',
    'aprendola',
    'aprendole',
    'aprendoli',
    'aprendolo',
    'aprendomi',
    'aprendone',
    'aprendosi',
    'aprendoti',
    'aprendovi',
    'aprente',
    'aprenti',
    'aprentisi',
    'apri',
    'apriamo',
    'apriamoci',
    'apriate',
    'apriballe',
    'apribile',
    'apribili',
    'apribocca',
    'aprica',
    'apricasse',
    'apriche',
    'aprichi',
    'aprici',
    'aprico',
    'aprigli',
    'aprii',
    'aprila',
    'aprilante',
    'aprilanti',
    'aprile',
    'aprili',
    'aprilia',
    'aprilina',
    'apriline',
    'aprilini',
    'aprilino',
    'aprilio',
    'aprilo',
    'aprimi',
    'aprimmo',
    'apriorismi',
    'apriorismo',
    'aprioristica',
    'aprioristici',
    'aprioristico',
    'apriorita',
    'apripista',
    'apriporta',
    'aprir',
    'aprira',
    'aprirai',
    'apriranno',
    'aprirci',
    'aprire',
    'aprirebbe',
    'aprirebbero',
    'aprirei',
    'apriremmo',
    'apriremo',
    'aprireste',
    'apriresti',
    'aprirete',
    'aprirla',
    'aprirle',
    'aprirli',
    'aprirlo',
    'aprirmi',
    'apriro',
    'aprirono',
    'aprirsi',
    'aprirti',
    'aprirvi',
    'aprirà',
    'aprirò',
    'apriscatole',
    'aprisse',
    'aprissero',
    'aprissi',
    'aprissimo',
    'apriste',
    'apristi',
    'aprite',
    'apriteci',
    'apritegli',
    'apritela',
    'apritele',
    'apriteli',
    'apritelo',
    'apritemi',
    'apritevi',
    'apriti',
    'apritoi',
    'apritoio',
    'apritura',
    'apriture',
    'apriva',
    'aprivamo',
    'aprivano',
    'aprivate',
    'aprivi',
    'aprivo',
    'apro',
    'aprocheila',
    'aprocheile',
    'aprocheili',
    'aprocheilo',
    'aprono',
    'aprutina',
    'aprutine',
    'aprutini',
    'aprutino',
    'apside',
    'apsidi',
    'aptenodite',
    'aptenoditi',
    'aptera',
    'aptere',
    'apteri',
    'apterigide',
    'apterigidi',
    'apterigoti',
    'apterigoto',
    'aptero',
    'apuana',
    'apuane',
    'apuani',
    'apuania',
    'apuano',
    'apud',
    'apudoma',
    'apula',
    'apule',
    'apuli',
    'apulia',
    'apulo',
    'apurva',
    'aquadro',
    'aquaplaning',
    'aquario',
    'aquascooter',
    'aquatico',
    'aquatile',
    'aquatili',
    'aquila',
    'aquilana',
    'aquilane',
    'aquilani',
    'aquilano',
    'aquilante',
    'aquilaria',
    'aquilarie',
    'aquile',
    'aquilegia',
    'aquilegie',
    'aquileia',
    'aquiletta',
    'aquilette',
    'aquiliana',
    'aquiliane',
    'aquiliani',
    'aquiliano',
    'aquiliferi',
    'aquilifero',
    'aquilina',
    'aquiline',
    'aquilini',
    'aquilino',
    'aquilio',
    'aquilonante',
    'aquilonare',
    'aquilonari',
    'aquilone',
    'aquiloni',
    'aquilotti',
    'aquilotto',
    'aquinate',
    'aquinati',
    'aquino',
    'aquitana',
    'aquitane',
    'aquitani',
    'aquitania',
    'aquitano',
    'aquitrino',
    'araba',
    'arabe',
    'arabella',
    'arabesca',
    'arabescai',
    'arabescammo',
    'arabescando',
    'arabescano',
    'arabescante',
    'arabescanti',
    'arabescare',
    'arabescarono',
    'arabescasse',
    'arabescassi',
    'arabescaste',
    'arabescasti',
    'arabescata',
    'arabescate',
    'arabescati',
    'arabescato',
    'arabescava',
    'arabescavamo',
    'arabescavano',
    'arabescavate',
    'arabescavi',
    'arabescavo',
    'arabesche',
    'arabeschera',
    'arabescherai',
    'arabescherei',
    'arabeschero',
    'arabeschi',
    'arabeschiamo',
    'arabeschiate',
    'arabeschino',
    'arabesco',
    'arabi',
    'arabia',
    'arabica',
    'arabiche',
    'arabici',
    'arabico',
    'arabidopsis',
    'arabile',
    'arabili',
    'arabismi',
    'arabismo',
    'arabista',
    'arabiste',
    'arabisti',
    'arabistica',
    'arabistiche',
    'arabizza',
    'arabizzai',
    'arabizzammo',
    'arabizzando',
    'arabizzano',
    'arabizzante',
    'arabizzanti',
    'arabizzarci',
    'arabizzare',
    'arabizzarmi',
    'arabizzarono',
    'arabizzarsi',
    'arabizzarti',
    'arabizzarvi',
    'arabizzasse',
    'arabizzassi',
    'arabizzaste',
    'arabizzasti',
    'arabizzata',
    'arabizzate',
    'arabizzatevi',
    'arabizzati',
    'arabizzato',
    'arabizzatomi',
    'arabizzatoti',
    'arabizzava',
    'arabizzavamo',
    'arabizzavano',
    'arabizzavate',
    'arabizzavi',
    'arabizzavo',
    'arabizzera',
    'arabizzerai',
    'arabizzerei',
    'arabizzeremo',
    'arabizzerete',
    'arabizzero',
    'arabizzi',
    'arabizziamo',
    'arabizziate',
    'arabizzino',
    'arabizzo',
    'arabo',
    'arac',
    'aracea',
    'aracee',
    'araceli',
    'aracelia',
    'arachide',
    'arachidi',
    'arachnida',
    'aracnea',
    'aracnee',
    'aracnei',
    'aracneo',
    'aracnide',
    'aracnidi',
    'aracnidismi',
    'aracnidismo',
    'aracnoidale',
    'aracnoidali',
    'aracnoide',
    'aracnoidea',
    'aracnoidee',
    'aracnoidei',
    'aracnoideo',
    'aracnoidi',
    'aracnoidismo',
    'aracnoidite',
    'aracnoiditi',
    'arafat',
    'aragona',
    'aragonese',
    'aragonesi',
    'aragonite',
    'aragoniti',
    'aragosta',
    'aragoste',
    'arai',
    'arak',
    'aralda',
    'araldi',
    'araldica',
    'araldiche',
    'araldici',
    'araldico',
    'araldista',
    'araldiste',
    'araldisti',
    'araldo',
    'aralia',
    'araliacea',
    'araliacee',
    'aralie',
    'aram',
    'aramaica',
    'aramaiche',
    'aramaici',
    'aramaico',
    'aramea',
    'aramee',
    'aramei',
    'arameo',
    'arames',
    'aramis',
    'arammo',
    'arance',
    'arancera',
    'arancere',
    'aranceti',
    'aranceto',
    'aranci',
    'arancia',
    'aranciata',
    'aranciate',
    'aranciati',
    'aranciato',
    'aranciera',
    'aranciere',
    'arancina',
    'arancine',
    'arancini',
    'arancino',
    'arancio',
    'arancione',
    'arancioni',
    'aranda',
    'arando',
    'araneide',
    'araneidi',
    'arano',
    'arante',
    'aranti',
    'aranza',
    'arapaima',
    'arapalma',
    'ararat',
    'arare',
    'ararono',
    'arasse',
    'arassero',
    'arassi',
    'arassimo',
    'araste',
    'arasti',
    'arata',
    'arate',
    'arati',
    'arativa',
    'arative',
    'arativi',
    'arativo',
    'arato',
    'aratore',
    'aratori',
    'aratoria',
    'aratorie',
    'aratorio',
    'aratri',
    'aratrice',
    'aratrici',
    'aratro',
    'aratura',
    'arature',
    'araucana',
    'araucane',
    'araucani',
    'araucano',
    'araucaria',
    'araucariacea',
    'araucariacee',
    'araucarie',
    'arava',
    'aravamo',
    'aravano',
    'aravate',
    'aravi',
    'aravo',
    'arazzeria',
    'arazzerie',
    'arazzi',
    'arazziera',
    'arazziere',
    'arazzieri',
    'arazzo',
    'arbace',
    'arbiter',
    'arbitra',
    'arbitraggi',
    'arbitraggio',
    'arbitrai',
    'arbitrale',
    'arbitrali',
    'arbitrammo',
    'arbitrando',
    'arbitrandosi',
    'arbitrano',
    'arbitrante',
    'arbitranti',
    'arbitrare',
    'arbitrari',
    'arbitraria',
    'arbitrarie',
    'arbitrarieta',
    'arbitrarietà',
    'arbitrario',
    'arbitrarono',
    'arbitrarsi',
    'arbitrasse',
    'arbitrassero',
    'arbitrassi',
    'arbitrassimo',
    'arbitraste',
    'arbitrasti',
    'arbitrata',
    'arbitrate',
    'arbitrati',
    'arbitrato',
    'arbitratore',
    'arbitratori',
    'arbitrava',
    'arbitravamo',
    'arbitravano',
    'arbitravate',
    'arbitravi',
    'arbitravo',
    'arbitre',
    'arbitrera',
    'arbitrerai',
    'arbitreranno',
    'arbitrerebbe',
    'arbitrerei',
    'arbitreremmo',
    'arbitreremo',
    'arbitrereste',
    'arbitreresti',
    'arbitrerete',
    'arbitrero',
    'arbitri',
    'arbitriamo',
    'arbitriate',
    'arbitrii',
    'arbitrino',
    'arbitrio',
    'arbitro',
    'arbizzano',
    'arborata',
    'arborate',
    'arborati',
    'arborato',
    'arbore',
    'arborea',
    'arboree',
    'arborei',
    'arboreo',
    'arborescente',
    'arborescenti',
    'arborescenza',
    'arborescenze',
    'arboreti',
    'arboreto',
    'arbori',
    'arboricola',
    'arboricole',
    'arboricoli',
    'arboricolo',
    'arboriforme',
    'arboriformi',
    'arborizzata',
    'arborizzate',
    'arborizzati',
    'arborizzato',
    'arboscelli',
    'arboscello',
    'arbovirus',
    'arbustacea',
    'arbustacee',
    'arbustacei',
    'arbustaceo',
    'arbusti',
    'arbustiva',
    'arbustive',
    'arbustivi',
    'arbustivo',
    'arbusto',
    'arbuti',
    'arbuto',
    'arca',
    'arcacce',
    'arcaccia',
    'arcade',
    'arcadi',
    'arcadia',
    'arcadica',
    'arcadiche',
    'arcadici',
    'arcadico',
    'arcadie',
    'arcadio',
    'arcadore',
    'arcadori',
    'arcai',
    'arcaica',
    'arcaicamente',
    'arcaiche',
    'arcaichi',
    'arcaici',
    'arcaicita',
    'arcaicità',
    'arcaicizza',
    'arcaicizzai',
    'arcaicizzano',
    'arcaicizzare',
    'arcaicizzata',
    'arcaicizzate',
    'arcaicizzati',
    'arcaicizzato',
    'arcaicizzava',
    'arcaicizzavi',
    'arcaicizzavo',
    'arcaicizzera',
    'arcaicizzero',
    'arcaicizzi',
    'arcaicizzino',
    'arcaicizzo',
    'arcaico',
    'arcaismi',
    'arcaismo',
    'arcaista',
    'arcaiste',
    'arcaisti',
    'arcaistica',
    'arcaistiche',
    'arcaistici',
    'arcaistico',
    'arcaizza',
    'arcaizzai',
    'arcaizzammo',
    'arcaizzando',
    'arcaizzano',
    'arcaizzante',
    'arcaizzanti',
    'arcaizzare',
    'arcaizzarono',
    'arcaizzasse',
    'arcaizzassi',
    'arcaizzaste',
    'arcaizzasti',
    'arcaizzata',
    'arcaizzate',
    'arcaizzati',
    'arcaizzato',
    'arcaizzava',
    'arcaizzavamo',
    'arcaizzavano',
    'arcaizzavate',
    'arcaizzavi',
    'arcaizzavo',
    'arcaizzera',
    'arcaizzerai',
    'arcaizzerei',
    'arcaizzeremo',
    'arcaizzerete',
    'arcaizzero',
    'arcaizzi',
    'arcaizziamo',
    'arcaizziate',
    'arcaizzino',
    'arcaizzo',
    'arcale',
    'arcali',
    'arcame',
    'arcami',
    'arcammo',
    'arcana',
    'arcanamente',
    'arcando',
    'arcane',
    'arcangela',
    'arcangeli',
    'arcangelica',
    'arcangelina',
    'arcangelo',
    'arcangiolo',
    'arcani',
    'arcano',
    'arcante',
    'arcanti',
    'arcare',
    'arcarecci',
    'arcareccio',
    'arcarono',
    'arcasse',
    'arcassero',
    'arcassi',
    'arcassimo',
    'arcaste',
    'arcasti',
    'arcata',
    'arcate',
    'arcatella',
    'arcatelle',
    'arcati',
    'arcato',
    'arcatore',
    'arcatori',
    'arcava',
    'arcavamo',
    'arcavano',
    'arcavate',
    'arcavi',
    'arcavo',
    'arcavola',
    'arcavole',
    'arcavoli',
    'arcavolo',
    'arce',
    'arcega',
    'arcella',
    'arcelle',
    'arceo',
    'arcetri',
    'archaea',
    'arche',
    'archeana',
    'archeane',
    'archeani',
    'archeano',
    'archeggera',
    'archeggerai',
    'archeggerei',
    'archeggeremo',
    'archeggerete',
    'archeggero',
    'archeggi',
    'archeggia',
    'archeggiai',
    'archeggiammo',
    'archeggiamo',
    'archeggiando',
    'archeggiano',
    'archeggiante',
    'archeggianti',
    'archeggiare',
    'archeggiasse',
    'archeggiassi',
    'archeggiaste',
    'archeggiasti',
    'archeggiata',
    'archeggiate',
    'archeggiati',
    'archeggiato',
    'archeggiava',
    'archeggiavi',
    'archeggiavo',
    'archeggino',
    'archeggio',
    'archegoni',
    'archegoniata',
    'archegoniate',
    'archegonio',
    'archelao',
    'archeo',
    'archeografa',
    'archeografe',
    'archeografi',
    'archeografia',
    'archeografie',
    'archeografo',
    'archeologa',
    'archeologhe',
    'archeologi',
    'archeologia',
    'archeologica',
    'archeologici',
    'archeologico',
    'archeologie',
    'archeologo',
    'archeometria',
    'archeometrie',
    'archeornite',
    'archeorniti',
    'archeosofia',
    'archeosofica',
    'archeosofici',
    'archeosofico',
    'archeozoica',
    'archeozoiche',
    'archeozoici',
    'archeozoico',
    'archera',
    'archerai',
    'archeranno',
    'archerebbe',
    'archerebbero',
    'archerei',
    'archeremmo',
    'archeremo',
    'archereste',
    'archeresti',
    'archerete',
    'archero',
    'archetipa',
    'archetipale',
    'archetipali',
    'archetipe',
    'archetipi',
    'archetipica',
    'archetipiche',
    'archetipici',
    'archetipico',
    'archetipo',
    'archetti',
    'archetto',
    'archi',
    'archia',
    'archiacuta',
    'archiacute',
    'archiacuti',
    'archiacuto',
    'archiamo',
    'archiate',
    'archiatra',
    'archiatre',
    'archiatri',
    'archiatro',
    'archibald',
    'archibaldo',
    'archibugetti',
    'archibugetto',
    'archibugi',
    'archibugiare',
    'archibugiata',
    'archibugiate',
    'archibugiati',
    'archibugiato',
    'archibugiera',
    'archibugiere',
    'archibugieri',
    'archibugio',
    'archibusata',
    'archibusi',
    'archibusiera',
    'archibusiere',
    'archibuso',
    'archicembali',
    'archicembalo',
    'archidiocesi',
    'archiginnasi',
    'archigonia',
    'archigonie',
    'archilochea',
    'archilochee',
    'archilochei',
    'archilocheo',
    'archimede',
    'archimedea',
    'archimedeo',
    'archimiare',
    'archimiceti',
    'archino',
    'archipendoli',
    'archipendolo',
    'archipenzoli',
    'archipenzolo',
    'archita',
    'architetta',
    'architettai',
    'architettano',
    'architettare',
    'architettata',
    'architettate',
    'architettati',
    'architettato',
    'architettava',
    'architettavi',
    'architettavo',
    'architette',
    'architettera',
    'architettero',
    'architetterò',
    'architetti',
    'architettino',
    'architetto',
    'architettore',
    'architettori',
    'architettura',
    'architetture',
    'architravata',
    'architravate',
    'architravati',
    'architravato',
    'architrave',
    'architravi',
    'archivi',
    'archivia',
    'archiviai',
    'archiviammo',
    'archiviamo',
    'archiviando',
    'archiviano',
    'archiviante',
    'archivianti',
    'archiviare',
    'archiviarla',
    'archiviarle',
    'archiviarli',
    'archiviarlo',
    'archiviarono',
    'archiviasse',
    'archiviassi',
    'archiviaste',
    'archiviasti',
    'archiviata',
    'archiviate',
    'archiviati',
    'archiviato',
    'archiviatore',
    'archiviava',
    'archiviavamo',
    'archiviavano',
    'archiviavate',
    'archiviavi',
    'archiviavo',
    'archiviera',
    'archivierai',
    'archivierei',
    'archivieremo',
    'archivierete',
    'archiviero',
    'archivierò',
    'archivino',
    'archivio',
    'archivista',
    'archiviste',
    'archivisti',
    'archivistica',
    'archivistici',
    'archivistico',
    'archivolti',
    'archivolto',
    'arci',
    'arcibaldo',
    'arcibasilica',
    'arciconsoli',
    'arciconsolo',
    'arcicontenta',
    'arcicontente',
    'arcicontenti',
    'arcicontento',
    'arcide',
    'arcidi',
    'arcidiaconi',
    'arcidiacono',
    'arcidiavoli',
    'arcidiavolo',
    'arcidio',
    'arcidiocesi',
    'arcido',
    'arciduca',
    'arciducale',
    'arciducali',
    'arciducati',
    'arciducato',
    'arciduchessa',
    'arciduchesse',
    'arciduchi',
    'arciera',
    'arciere',
    'arcieri',
    'arcifanfana',
    'arcifanfane',
    'arcifanfani',
    'arcifanfano',
    'arcigna',
    'arcignamente',
    'arcigne',
    'arcigni',
    'arcigno',
    'arcileuto',
    'arciliuti',
    'arciliuto',
    'arcinota',
    'arcinote',
    'arcinoti',
    'arcinoto',
    'arcionata',
    'arcionate',
    'arcionati',
    'arcionato',
    'arcione',
    'arcioni',
    'arcipelaghi',
    'arcipelago',
    'arcipressi',
    'arcipresso',
    'arciprete',
    'arcipreti',
    'arcipretura',
    'arcipreture',
    'arcisa',
    'arcisio',
    'arciso',
    'arcispedale',
    'arcispedali',
    'arcistufa',
    'arcistufe',
    'arcistufi',
    'arcistufo',
    'arcivescovi',
    'arcivescovo',
    'arcnidi',
    'arco',
    'arcobaleni',
    'arcobaleno',
    'arcobalestri',
    'arcobalestro',
    'arcocoseni',
    'arcocoseno',
    'arcola',
    'arcolai',
    'arcolaio',
    'arcologia',
    'arcontati',
    'arcontato',
    'arconte',
    'arconti',
    'arcore',
    'arcosauri',
    'arcosauro',
    'arcoscenici',
    'arcoscenico',
    'arcosecante',
    'arcosecanti',
    'arcoseni',
    'arcoseno',
    'arcosoli',
    'arcosolio',
    'arcotangente',
    'arcotangenti',
    'arcto',
    'arctocebi',
    'arctocebo',
    'arctocefali',
    'arctocefalo',
    'arctoidei',
    'arctoideo',
    'arctostafili',
    'arctostafilo',
    'arcua',
    'arcuai',
    'arcuammo',
    'arcuando',
    'arcuandoci',
    'arcuandomi',
    'arcuandosi',
    'arcuandoti',
    'arcuandovi',
    'arcuano',
    'arcuante',
    'arcuanti',
    'arcuantisi',
    'arcuarci',
    'arcuare',
    'arcuarmi',
    'arcuarono',
    'arcuarsi',
    'arcuarti',
    'arcuarvi',
    'arcuasse',
    'arcuassero',
    'arcuassi',
    'arcuassimo',
    'arcuaste',
    'arcuasti',
    'arcuata',
    'arcuate',
    'arcuatevi',
    'arcuati',
    'arcuato',
    'arcuatomi',
    'arcuatoti',
    'arcuatura',
    'arcuature',
    'arcuava',
    'arcuavamo',
    'arcuavano',
    'arcuavate',
    'arcuavi',
    'arcuavo',
    'arcuera',
    'arcuerai',
    'arcueranno',
    'arcuerebbe',
    'arcuerebbero',
    'arcuerei',
    'arcueremmo',
    'arcueremo',
    'arcuereste',
    'arcueresti',
    'arcuerete',
    'arcuero',
    'arcui',
    'arcuiamo',
    'arcuiamoci',
    'arcuiate',
    'arcuino',
    'arcuo',
    'arda',
    'ardano',
    'arde',
    'ardea',
    'ardeatina',
    'ardeatine',
    'ardeatini',
    'ardeatino',
    'ardee',
    'ardeide',
    'ardeidi',
    'ardemaro',
    'ardemmo',
    'ardendo',
    'ardengo',
    'ardenne',
    'ardente',
    'ardentemente',
    'ardenti',
    'ardentissima',
    'ardentissimo',
    'ardenza',
    'ardenze',
    'ardera',
    'arderai',
    'arderanno',
    'ardere',
    'arderebbe',
    'arderebbero',
    'arderei',
    'arderemmo',
    'arderemo',
    'ardereste',
    'arderesti',
    'arderete',
    'ardero',
    'arderò',
    'ardesia',
    'ardesiaca',
    'ardesiache',
    'ardesiaci',
    'ardesiaco',
    'ardesie',
    'ardesse',
    'ardessero',
    'ardessi',
    'ardessimo',
    'ardeste',
    'ardesti',
    'ardete',
    'ardeva',
    'ardevamo',
    'ardevano',
    'ardevate',
    'ardevi',
    'ardevo',
    'ardi',
    'ardiamo',
    'ardiate',
    'ardica',
    'ardiche',
    'ardiglione',
    'ardiglioni',
    'ardii',
    'ardimenti',
    'ardimento',
    'ardimentosa',
    'ardimentose',
    'ardimentosi',
    'ardimentoso',
    'ardimmo',
    'ardine',
    'ardingo',
    'ardino',
    'ardira',
    'ardirai',
    'ardiranno',
    'ardire',
    'ardirebbe',
    'ardirebbero',
    'ardirei',
    'ardiremmo',
    'ardiremo',
    'ardireste',
    'ardiresti',
    'ardirete',
    'ardiri',
    'ardiro',
    'ardirono',
    'ardirà',
    'ardirò',
    'ardisca',
    'ardiscano',
    'ardisce',
    'ardisci',
    'ardisco',
    'ardiscono',
    'ardisse',
    'ardissero',
    'ardissi',
    'ardissimo',
    'ardiste',
    'ardisti',
    'ardita',
    'arditamente',
    'ardite',
    'arditezza',
    'arditezze',
    'arditi',
    'arditismi',
    'arditismo',
    'ardito',
    'arditore',
    'arditori',
    'ardiva',
    'ardivamo',
    'ardivano',
    'ardivate',
    'ardivi',
    'ardivo',
    'ardo',
    'ardoino',
    'ardolino',
    'ardono',
    'ardore',
    'ardori',
    'ardovino',
    'ardua',
    'arduamente',
    'ardue',
    'ardui',
    'arduilio',
    'arduina',
    'arduino',
    'arduita',
    'arduità',
    'arduo',
    'area',
    'arealdo',
    'areale',
    'areali',
    'arealmente',
    'areante',
    'areare',
    'areata',
    'areate',
    'areati',
    'areato',
    'areatore',
    'areazione',
    'arebalo',
    'areca',
    'areche',
    'aree',
    'areeda',
    'arefatta',
    'arefatte',
    'arefatti',
    'arefatto',
    'areica',
    'areiche',
    'areici',
    'areico',
    'arelatense',
    'arelatensi',
    'areligiosa',
    'areligiose',
    'areligiosi',
    'areligioso',
    'arella',
    'arellano',
    'arelle',
    'arem',
    'aremme',
    'aremorici',
    'arena',
    'arenacea',
    'arenacee',
    'arenacei',
    'arenaceo',
    'arenai',
    'arenamenti',
    'arenamento',
    'arenammo',
    'arenando',
    'arenandoci',
    'arenandomi',
    'arenandosi',
    'arenandoti',
    'arenandovi',
    'arenano',
    'arenante',
    'arenanti',
    'arenantisi',
    'arenarci',
    'arenare',
    'arenari',
    'arenaria',
    'arenarie',
    'arenario',
    'arenarmi',
    'arenarono',
    'arenarsi',
    'arenarti',
    'arenarum',
    'arenarvi',
    'arenasse',
    'arenassero',
    'arenassi',
    'arenassimo',
    'arenaste',
    'arenasti',
    'arenata',
    'arenate',
    'arenatevi',
    'arenati',
    'arenato',
    'arenatomi',
    'arenatoti',
    'arenava',
    'arenavamo',
    'arenavano',
    'arenavate',
    'arenavi',
    'arenaviridae',
    'arenavirus',
    'arenavo',
    'arene',
    'arenera',
    'arenerai',
    'areneranno',
    'arenerebbe',
    'arenerebbero',
    'arenerei',
    'areneremmo',
    'areneremo',
    'arenereste',
    'areneresti',
    'arenerete',
    'arenero',
    'arenerò',
    'arengari',
    'arengario',
    'arenghi',
    'arengo',
    'areni',
    'areniamo',
    'areniamoci',
    'areniana',
    'areniane',
    'areniani',
    'areniano',
    'areniate',
    'arenicola',
    'arenicole',
    'arenicoli',
    'arenicolo',
    'arenile',
    'arenili',
    'arenino',
    'areno',
    'arenosa',
    'arenose',
    'arenosi',
    'arenosita',
    'arenoso',
    'arente',
    'arenti',
    'arenzano',
    'areo',
    'areografi',
    'areografo',
    'areogramma',
    'areogrammi',
    'areola',
    'areolante',
    'areolare',
    'areolari',
    'areolata',
    'areolate',
    'areolati',
    'areolato',
    'areole',
    'areometri',
    'areometria',
    'areometrie',
    'areometro',
    'areomobile',
    'areomobili',
    'areonautica',
    'areopaghi',
    'areopagita',
    'areopagiti',
    'areopagitica',
    'areopagitici',
    'areopagitico',
    'areopago',
    'areoplani',
    'areoplano',
    'areoporti',
    'areoporto',
    'areostili',
    'areostilo',
    'arera',
    'arerai',
    'areranno',
    'arerebbe',
    'arerebbero',
    'arerei',
    'areremmo',
    'areremo',
    'arereste',
    'areresti',
    'arerete',
    'arero',
    'aresiati',
    'aresiato',
    'arete',
    'aretina',
    'aretine',
    'aretini',
    'aretino',
    'aretusa',
    'arezzo',
    'arfasatti',
    'arfasatto',
    'argali',
    'argani',
    'arganista',
    'arganiste',
    'arganisti',
    'argano',
    'argante',
    'arganti',
    'argantina',
    'arge',
    'argea',
    'argemiro',
    'argenta',
    'argentai',
    'argentammo',
    'argentana',
    'argentando',
    'argentane',
    'argentano',
    'argentante',
    'argentanti',
    'argentare',
    'argentari',
    'argentaria',
    'argentarie',
    'argentario',
    'argentarono',
    'argentasse',
    'argentassero',
    'argentassi',
    'argentassimo',
    'argentaste',
    'argentasti',
    'argentata',
    'argentate',
    'argentati',
    'argentato',
    'argentatore',
    'argentatori',
    'argentatrice',
    'argentatrici',
    'argentatura',
    'argentature',
    'argentava',
    'argentavamo',
    'argentavano',
    'argentavate',
    'argentavi',
    'argentavo',
    'argentea',
    'argentee',
    'argentei',
    'argenteo',
    'argentera',
    'argenterai',
    'argenteranno',
    'argenterebbe',
    'argenterei',
    'argenteremmo',
    'argenteremo',
    'argentereste',
    'argenteresti',
    'argenterete',
    'argenteria',
    'argenterie',
    'argentero',
    'argenti',
    'argentiamo',
    'argentiate',
    'argentiera',
    'argentiere',
    'argentieri',
    'argentifera',
    'argentifere',
    'argentiferi',
    'argentifero',
    'argentina',
    'argentine',
    'argentini',
    'argentinide',
    'argentinidi',
    'argentino',
    'argentite',
    'argentiti',
    'argento',
    'argentone',
    'argentoni',
    'argenzia',
    'argeo',
    'arghi',
    'argia',
    'argilla',
    'argillacea',
    'argillacee',
    'argillacei',
    'argillaceo',
    'argille',
    'argillosa',
    'argillose',
    'argillosi',
    'argilloso',
    'argimiro',
    'argina',
    'arginai',
    'arginale',
    'arginali',
    'arginamenti',
    'arginamento',
    'arginammo',
    'arginando',
    'arginano',
    'arginante',
    'arginanti',
    'arginare',
    'arginarono',
    'arginasse',
    'arginassero',
    'arginassi',
    'arginassimo',
    'arginaste',
    'arginasti',
    'arginata',
    'arginate',
    'arginati',
    'arginato',
    'arginatura',
    'arginature',
    'arginava',
    'arginavamo',
    'arginavano',
    'arginavate',
    'arginavi',
    'arginavo',
    'argine',
    'arginera',
    'arginerai',
    'argineranno',
    'arginerebbe',
    'arginerei',
    'argineremmo',
    'argineremo',
    'arginereste',
    'argineresti',
    'arginerete',
    'arginero',
    'arginerò',
    'argini',
    'arginiamo',
    'arginiate',
    'arginino',
    'arginnide',
    'arginnidi',
    'argino',
    'argio',
    'argiope',
    'argiopi',
    'argiopide',
    'argiopidi',
    'argiria',
    'argiriasi',
    'argirie',
    'argirismi',
    'argirismo',
    'argirite',
    'argiriti',
    'argiro',
    'argironeta',
    'argironete',
    'argirosi',
    'argirò',
    'argiva',
    'argive',
    'argivi',
    'argivo',
    'argo',
    'argolica',
    'argoliche',
    'argolici',
    'argolico',
    'argolide',
    'argomenta',
    'argomentai',
    'argomentammo',
    'argomentando',
    'argomentano',
    'argomentante',
    'argomentanti',
    'argomentarci',
    'argomentare',
    'argomentarlo',
    'argomentarmi',
    'argomentarsi',
    'argomentarti',
    'argomentarvi',
    'argomentasse',
    'argomentassi',
    'argomentaste',
    'argomentasti',
    'argomentata',
    'argomentate',
    'argomentati',
    'argomentato',
    'argomentava',
    'argomentavi',
    'argomentavo',
    'argomentera',
    'argomenterai',
    'argomenterei',
    'argomentero',
    'argomenti',
    'argomentiamo',
    'argomentiate',
    'argomentino',
    'argomento',
    'argon',
    'argonauta',
    'argonauti',
    'argot',
    'argots',
    'arguendo',
    'arguente',
    'arguenti',
    'argueso',
    'argui',
    'arguiamo',
    'arguiate',
    'arguii',
    'arguimmo',
    'arguira',
    'arguirai',
    'arguiranno',
    'arguire',
    'arguirebbe',
    'arguirebbero',
    'arguirei',
    'arguiremmo',
    'arguiremo',
    'arguireste',
    'arguiresti',
    'arguirete',
    'arguiro',
    'arguirono',
    'arguirà',
    'arguirò',
    'arguisca',
    'arguiscano',
    'arguisce',
    'arguisci',
    'arguisco',
    'arguiscono',
    'arguisse',
    'arguissero',
    'arguissi',
    'arguissimo',
    'arguiste',
    'arguisti',
    'arguita',
    'arguite',
    'arguiti',
    'arguito',
    'arguiva',
    'arguivamo',
    'arguivano',
    'arguivate',
    'arguivi',
    'arguivo',
    'arguta',
    'argutamente',
    'argute',
    'argutezza',
    'argutezze',
    'arguti',
    'arguto',
    'arguzia',
    'arguzie',
    'aria',
    'ariacce',
    'ariaccia',
    'arialda',
    'arialdo',
    'ariamo',
    'ariana',
    'ariane',
    'arianesimi',
    'arianesimo',
    'ariani',
    'arianizza',
    'arianizzai',
    'arianizzammo',
    'arianizzando',
    'arianizzano',
    'arianizzante',
    'arianizzanti',
    'arianizzare',
    'arianizzasse',
    'arianizzassi',
    'arianizzaste',
    'arianizzasti',
    'arianizzata',
    'arianizzate',
    'arianizzati',
    'arianizzato',
    'arianizzava',
    'arianizzavi',
    'arianizzavo',
    'arianizzera',
    'arianizzerai',
    'arianizzerei',
    'arianizzero',
    'arianizzi',
    'arianizziamo',
    'arianizziate',
    'arianizzino',
    'arianizzo',
    'arianna',
    'arianno',
    'ariano',
    'ariate',
    'ariballi',
    'ariballo',
    'ariberto',
    'arida',
    'aridamente',
    'aride',
    'aridezza',
    'aridezze',
    'aridi',
    'aridita',
    'aridità',
    'arido',
    'aridocoltura',
    'aridocolture',
    'aridocultura',
    'aridoculture',
    'arie',
    'arieccolo',
    'arieggera',
    'arieggerai',
    'arieggeranno',
    'arieggerebbe',
    'arieggerei',
    'arieggeremmo',
    'arieggeremo',
    'arieggereste',
    'arieggeresti',
    'arieggerete',
    'arieggero',
    'arieggi',
    'arieggia',
    'arieggiai',
    'arieggiammo',
    'arieggiamo',
    'arieggiando',
    'arieggiano',
    'arieggiante',
    'arieggianti',
    'arieggiare',
    'arieggiarono',
    'arieggiasse',
    'arieggiassi',
    'arieggiaste',
    'arieggiasti',
    'arieggiata',
    'arieggiate',
    'arieggiati',
    'arieggiato',
    'arieggiava',
    'arieggiavamo',
    'arieggiavano',
    'arieggiavate',
    'arieggiavi',
    'arieggiavo',
    'arieggino',
    'arieggio',
    'ariela',
    'ariele',
    'ariella',
    'ariello',
    'ariento',
    'arienzo',
    'arieta',
    'arietai',
    'arietammo',
    'arietana',
    'arietando',
    'arietane',
    'arietani',
    'arietano',
    'arietante',
    'arietanti',
    'arietare',
    'arietarono',
    'arietasse',
    'arietassero',
    'arietassi',
    'arietassimo',
    'arietaste',
    'arietasti',
    'arietata',
    'arietate',
    'arietati',
    'arietato',
    'arietava',
    'arietavamo',
    'arietavano',
    'arietavate',
    'arietavi',
    'arietavo',
    'ariete',
    'arietera',
    'arieterai',
    'arieteranno',
    'arieterebbe',
    'arieterei',
    'arieteremmo',
    'arieteremo',
    'arietereste',
    'arieteresti',
    'arieterete',
    'arietero',
    'arieti',
    'arietiamo',
    'arietiate',
    'arietino',
    'arieto',
    'arietta',
    'ariette',
    'ariettina',
    'ariettine',
    'arietto',
    'arii',
    'arile',
    'arili',
    'arilica',
    'ariliche',
    'arilici',
    'arilico',
    'arilli',
    'arillo',
    'arimanni',
    'arimannia',
    'arimannie',
    'arimanno',
    'arimondo',
    'arina',
    'aringa',
    'aringare',
    'aringectomia',
    'aringhe',
    'aringhi',
    'aringo',
    'aringotomia',
    'arinia',
    'arinie',
    'arino',
    'ario',
    'arioeuropea',
    'arioeuropee',
    'arioeuropei',
    'arioeuropeo',
    'arionide',
    'arionidi',
    'ariosa',
    'ariosamente',
    'ariose',
    'ariosi',
    'arioso',
    'ariosta',
    'ariostea',
    'ariostee',
    'ariostei',
    'ariosteo',
    'ariostesca',
    'ariostesche',
    'ariosteschi',
    'ariostesco',
    'ariosto',
    'aris',
    'arista',
    'aristarco',
    'aristata',
    'aristate',
    'aristati',
    'aristato',
    'ariste',
    'aristea',
    'aristeo',
    'aristide',
    'aristidina',
    'aristo',
    'aristocrazia',
    'aristocrazie',
    'aristodema',
    'aristodemo',
    'aristofane',
    'aristofanea',
    'aristofanee',
    'aristofanei',
    'aristofaneo',
    'aristofani',
    'aristofania',
    'aristofanie',
    'aristofanii',
    'aristofanio',
    'aristolochia',
    'aristolochie',
    'aristotele',
    'aristotelica',
    'aristotelici',
    'aristotelico',
    'aristotile',
    'aritenoide',
    'aritenoidi',
    'aritenoidite',
    'aritenoiditi',
    'aritmetica',
    'aritmetiche',
    'aritmetici',
    'aritmetico',
    'aritmia',
    'aritmica',
    'aritmiche',
    'aritmici',
    'aritmico',
    'aritmie',
    'aritmogenica',
    'aritmomanzia',
    'arizona',
    'arizonae',
    'arizotonica',
    'arizotoniche',
    'arizotonici',
    'arizotonico',
    'arlecchinata',
    'arlecchinate',
    'arlecchini',
    'arlecchino',
    'arles',
    'arlesiana',
    'arlesiane',
    'arlesiani',
    'arlesiano',
    'arletta',
    'arlotti',
    'arlotto',
    'arma',
    'armacollo',
    'armadi',
    'armadiatura',
    'armadiature',
    'armadietti',
    'armadietto',
    'armadilli',
    'armadillo',
    'armadio',
    'armadione',
    'armadioni',
    'armagnac',
    'armai',
    'armaiola',
    'armaiole',
    'armaioli',
    'armaiolo',
    'armaiuolo',
    'armamentari',
    'armamentario',
    'armamenti',
    'armamento',
    'armammo',
    'armanda',
    'armandina',
    'armandino',
    'armando',
    'armandoci',
    'armandomi',
    'armandosi',
    'armandoti',
    'armandovi',
    'armanno',
    'armano',
    'armante',
    'armanti',
    'armantisi',
    'armarci',
    'armare',
    'armari',
    'armario',
    'armarmi',
    'armarono',
    'armarsi',
    'armarti',
    'armarvi',
    'armasca',
    'armasche',
    'armaschi',
    'armasco',
    'armasse',
    'armassero',
    'armassi',
    'armassimo',
    'armaste',
    'armasti',
    'armata',
    'armatasi',
    'armate',
    'armatesi',
    'armatevi',
    'armati',
    'armatisi',
    'armatissimi',
    'armato',
    'armatomi',
    'armatore',
    'armatori',
    'armatoriale',
    'armatoriali',
    'armatosi',
    'armatoti',
    'armatrice',
    'armatrici',
    'armatura',
    'armature',
    'armava',
    'armavamo',
    'armavano',
    'armavate',
    'armavi',
    'armavo',
    'arme',
    'armeggera',
    'armeggerai',
    'armeggeranno',
    'armeggerebbe',
    'armeggerei',
    'armeggeremmo',
    'armeggeremo',
    'armeggereste',
    'armeggeresti',
    'armeggerete',
    'armeggero',
    'armeggi',
    'armeggia',
    'armeggiai',
    'armeggiammo',
    'armeggiamo',
    'armeggiando',
    'armeggiano',
    'armeggiante',
    'armeggianti',
    'armeggiare',
    'armeggiarono',
    'armeggiasse',
    'armeggiassi',
    'armeggiaste',
    'armeggiasti',
    'armeggiata',
    'armeggiate',
    'armeggiati',
    'armeggiato',
    'armeggiatore',
    'armeggiatori',
    'armeggiava',
    'armeggiavamo',
    'armeggiavano',
    'armeggiavate',
    'armeggiavi',
    'armeggiavo',
    'armeggii',
    'armeggino',
    'armeggio',
    'armeggiona',
    'armeggione',
    'armeggioni',
    'armela',
    'armelina',
    'armelinda',
    'armelindo',
    'armella',
    'armellina',
    'armellinata',
    'armellinate',
    'armellinati',
    'armellinato',
    'armelline',
    'armellini',
    'armellino',
    'armello',
    'armena',
    'armene',
    'armeni',
    'armenia',
    'armenio',
    'armeno',
    'armentari',
    'armentaria',
    'armentarie',
    'armentario',
    'armenti',
    'armentiere',
    'armentieri',
    'armentina',
    'armento',
    'armera',
    'armerai',
    'armeranno',
    'armerebbe',
    'armerebbero',
    'armerei',
    'armeremmo',
    'armeremo',
    'armereste',
    'armeresti',
    'armerete',
    'armeria',
    'armerie',
    'armerina',
    'armerino',
    'armerista',
    'armeristi',
    'armero',
    'armese',
    'armesi',
    'armi',
    'armiamo',
    'armiamoci',
    'armiate',
    'armida',
    'armidio',
    'armido',
    'armiera',
    'armiere',
    'armieri',
    'armigera',
    'armigere',
    'armigeri',
    'armigero',
    'armildo',
    'armilla',
    'armillante',
    'armillare',
    'armillari',
    'armillaria',
    'armillarie',
    'armillata',
    'armillate',
    'armillati',
    'armillato',
    'armille',
    'armina',
    'arminda',
    'armindo',
    'arminia',
    'arminio',
    'armino',
    'armipotente',
    'armipotenti',
    'armirio',
    'armiro',
    'armistizi',
    'armistiziale',
    'armistiziali',
    'armistizio',
    'armo',
    'armoire',
    'armoires',
    'armoni',
    'armonia',
    'armonica',
    'armoniche',
    'armonici',
    'armonicista',
    'armoniciste',
    'armonicisti',
    'armonico',
    'armonie',
    'armonio',
    'armoniosa',
    'armoniose',
    'armoniosi',
    'armonioso',
    'armonista',
    'armoniste',
    'armonisti',
    'armonistica',
    'armonistiche',
    'armonistici',
    'armonistico',
    'armonium',
    'armonizza',
    'armonizzai',
    'armonizzammo',
    'armonizzando',
    'armonizzano',
    'armonizzante',
    'armonizzanti',
    'armonizzare',
    'armonizzarsi',
    'armonizzasse',
    'armonizzassi',
    'armonizzaste',
    'armonizzasti',
    'armonizzata',
    'armonizzate',
    'armonizzati',
    'armonizzato',
    'armonizzava',
    'armonizzavi',
    'armonizzavo',
    'armonizzera',
    'armonizzerai',
    'armonizzerei',
    'armonizzero',
    'armonizzi',
    'armonizziamo',
    'armonizziate',
    'armonizzino',
    'armonizzo',
    'armoracci',
    'armoraccio',
    'armoracia',
    'armoracie',
    'armoricana',
    'armoricane',
    'armoricani',
    'armoricano',
    'armorici',
    'armà',
    'arnalda',
    'arnaldina',
    'arnaldo',
    'arnatto',
    'arnaz',
    'arnese',
    'arnesi',
    'arnetta',
    'arnhem',
    'arnia',
    'arnica',
    'arniche',
    'arnie',
    'arnione',
    'arnioni',
    'arno',
    'arnoglossa',
    'arnoglosse',
    'arnolda',
    'arnoldo',
    'arnolfo',
    'arolda',
    'aroldo',
    'aroma',
    'aromatari',
    'aromatario',
    'aromaterapia',
    'aromatica',
    'aromatiche',
    'aromatici',
    'aromaticita',
    'aromaticità',
    'aromatico',
    'aromatizza',
    'aromatizzai',
    'aromatizzano',
    'aromatizzare',
    'aromatizzata',
    'aromatizzate',
    'aromatizzati',
    'aromatizzato',
    'aromatizzava',
    'aromatizzavi',
    'aromatizzavo',
    'aromatizzera',
    'aromatizzero',
    'aromatizzi',
    'aromatizzino',
    'aromatizzo',
    'aromi',
    'aronne',
    'aronte',
    'arpa',
    'arpacordi',
    'arpacordo',
    'arpagone',
    'arpagoni',
    'arpalice',
    'arpe',
    'arpeggera',
    'arpeggerai',
    'arpeggeranno',
    'arpeggerebbe',
    'arpeggerei',
    'arpeggeremmo',
    'arpeggeremo',
    'arpeggereste',
    'arpeggeresti',
    'arpeggerete',
    'arpeggero',
    'arpeggi',
    'arpeggia',
    'arpeggiai',
    'arpeggiammo',
    'arpeggiamo',
    'arpeggiando',
    'arpeggiano',
    'arpeggiante',
    'arpeggianti',
    'arpeggiare',
    'arpeggiarono',
    'arpeggiasse',
    'arpeggiassi',
    'arpeggiaste',
    'arpeggiasti',
    'arpeggiata',
    'arpeggiate',
    'arpeggiati',
    'arpeggiato',
    'arpeggiatore',
    'arpeggiatori',
    'arpeggiava',
    'arpeggiavamo',
    'arpeggiavano',
    'arpeggiavate',
    'arpeggiavi',
    'arpeggiavo',
    'arpeggii',
    'arpeggino',
    'arpeggio',
    'arpeggione',
    'arpeggioni',
    'arpenti',
    'arpento',
    'arpese',
    'arpesi',
    'arpetta',
    'arpette',
    'arpia',
    'arpicordi',
    'arpicordo',
    'arpie',
    'arpinate',
    'arpinati',
    'arpino',
    'arpiona',
    'arpionai',
    'arpionammo',
    'arpionando',
    'arpionano',
    'arpionante',
    'arpionanti',
    'arpionare',
    'arpionarono',
    'arpionasse',
    'arpionassero',
    'arpionassi',
    'arpionassimo',
    'arpionaste',
    'arpionasti',
    'arpionata',
    'arpionate',
    'arpionati',
    'arpionato',
    'arpionava',
    'arpionavamo',
    'arpionavano',
    'arpionavate',
    'arpionavi',
    'arpionavo',
    'arpione',
    'arpionera',
    'arpionerai',
    'arpioneranno',
    'arpionerebbe',
    'arpionerei',
    'arpioneremmo',
    'arpioneremo',
    'arpionereste',
    'arpioneresti',
    'arpionerete',
    'arpionero',
    'arpioni',
    'arpioniamo',
    'arpioniate',
    'arpioniere',
    'arpionieri',
    'arpionino',
    'arpionismi',
    'arpionismo',
    'arpiono',
    'arpista',
    'arpiste',
    'arpisti',
    'arponante',
    'arponare',
    'arpone',
    'arponi',
    'arponiere',
    'arponieri',
    'arqua',
    'arquebuse',
    'arquà',
    'arra',
    'arrabatta',
    'arrabattai',
    'arrabattammo',
    'arrabattando',
    'arrabattano',
    'arrabattarci',
    'arrabattare',
    'arrabattarmi',
    'arrabattarsi',
    'arrabattarti',
    'arrabattarvi',
    'arrabattasse',
    'arrabattassi',
    'arrabattaste',
    'arrabattasti',
    'arrabattata',
    'arrabattate',
    'arrabattati',
    'arrabattato',
    'arrabattava',
    'arrabattavi',
    'arrabattavo',
    'arrabattera',
    'arrabatterai',
    'arrabatterei',
    'arrabattero',
    'arrabatterò',
    'arrabatti',
    'arrabattiamo',
    'arrabattiate',
    'arrabattino',
    'arrabatto',
    'arrabbi',
    'arrabbia',
    'arrabbiai',
    'arrabbiammo',
    'arrabbiamo',
    'arrabbiamoci',
    'arrabbiando',
    'arrabbiano',
    'arrabbiante',
    'arrabbianti',
    'arrabbiarci',
    'arrabbiare',
    'arrabbiarmi',
    'arrabbiarono',
    'arrabbiarsi',
    'arrabbiarti',
    'arrabbiarvi',
    'arrabbiasse',
    'arrabbiassi',
    'arrabbiaste',
    'arrabbiasti',
    'arrabbiata',
    'arrabbiate',
    'arrabbiatevi',
    'arrabbiati',
    'arrabbiato',
    'arrabbiatomi',
    'arrabbiatoti',
    'arrabbiatura',
    'arrabbiature',
    'arrabbiava',
    'arrabbiavamo',
    'arrabbiavano',
    'arrabbiavate',
    'arrabbiavi',
    'arrabbiavo',
    'arrabbiera',
    'arrabbierai',
    'arrabbierei',
    'arrabbieremo',
    'arrabbierete',
    'arrabbiero',
    'arrabbino',
    'arrabbio',
    'arraffa',
    'arraffai',
    'arraffammo',
    'arraffando',
    'arraffano',
    'arraffante',
    'arraffanti',
    'arraffare',
    'arraffarono',
    'arraffasse',
    'arraffassero',
    'arraffassi',
    'arraffassimo',
    'arraffaste',
    'arraffasti',
    'arraffata',
    'arraffate',
    'arraffati',
    'arraffato',
    'arraffatore',
    'arraffatori',
    'arraffatrice',
    'arraffatrici',
    'arraffava',
    'arraffavamo',
    'arraffavano',
    'arraffavate',
    'arraffavi',
    'arraffavo',
    'arraffera',
    'arrafferai',
    'arrafferanno',
    'arrafferebbe',
    'arrafferei',
    'arrafferemmo',
    'arrafferemo',
    'arraffereste',
    'arrafferesti',
    'arrafferete',
    'arraffero',
    'arraffi',
    'arraffiamo',
    'arraffiare',
    'arraffiate',
    'arraffino',
    'arraffo',
    'arraffona',
    'arraffone',
    'arraffoni',
    'arrak',
    'arrampica',
    'arrampicai',
    'arrampicammo',
    'arrampicando',
    'arrampicano',
    'arrampicante',
    'arrampicanti',
    'arrampicarci',
    'arrampicare',
    'arrampicarmi',
    'arrampicarsi',
    'arrampicarti',
    'arrampicarvi',
    'arrampicasse',
    'arrampicassi',
    'arrampicaste',
    'arrampicasti',
    'arrampicata',
    'arrampicate',
    'arrampicati',
    'arrampicato',
    'arrampicava',
    'arrampicavi',
    'arrampicavo',
    'arrampichera',
    'arrampichero',
    'arrampicherò',
    'arrampichi',
    'arrampichino',
    'arrampico',
    'arranca',
    'arrancai',
    'arrancammo',
    'arrancando',
    'arrancano',
    'arrancante',
    'arrancanti',
    'arrancare',
    'arrancarono',
    'arrancasse',
    'arrancassero',
    'arrancassi',
    'arrancassimo',
    'arrancaste',
    'arrancasti',
    'arrancata',
    'arrancate',
    'arrancati',
    'arrancato',
    'arrancava',
    'arrancavamo',
    'arrancavano',
    'arrancavate',
    'arrancavi',
    'arrancavo',
    'arranchera',
    'arrancherai',
    'arrancherei',
    'arrancheremo',
    'arrancherete',
    'arranchero',
    'arranchi',
    'arranchiamo',
    'arranchiate',
    'arranchino',
    'arranco',
    'arrandella',
    'arrandellano',
    'arrandellare',
    'arrandellata',
    'arrandellate',
    'arrandellati',
    'arrandellato',
    'arrandellava',
    'arrandello',
    'arrangement',
    'arrangera',
    'arrangerai',
    'arrangeranno',
    'arrangerebbe',
    'arrangerei',
    'arrangeremmo',
    'arrangeremo',
    'arrangereste',
    'arrangeresti',
    'arrangerete',
    'arrangero',
    'arrangerò',
    'arrangi',
    'arrangia',
    'arrangiai',
    'arrangiammo',
    'arrangiamo',
    'arrangiamoci',
    'arrangiando',
    'arrangiano',
    'arrangiante',
    'arrangianti',
    'arrangiarci',
    'arrangiare',
    'arrangiarmi',
    'arrangiarono',
    'arrangiarsi',
    'arrangiarti',
    'arrangiarvi',
    'arrangiasse',
    'arrangiassi',
    'arrangiaste',
    'arrangiasti',
    'arrangiata',
    'arrangiate',
    'arrangiatevi',
    'arrangiati',
    'arrangiato',
    'arrangiatomi',
    'arrangiatore',
    'arrangiatori',
    'arrangiatoti',
    'arrangiava',
    'arrangiavamo',
    'arrangiavano',
    'arrangiavate',
    'arrangiavi',
    'arrangiavo',
    'arrangino',
    'arrangio',
    'arrangola',
    'arrangolai',
    'arrangolammo',
    'arrangolando',
    'arrangolano',
    'arrangolante',
    'arrangolanti',
    'arrangolare',
    'arrangolasse',
    'arrangolassi',
    'arrangolaste',
    'arrangolasti',
    'arrangolata',
    'arrangolate',
    'arrangolati',
    'arrangolato',
    'arrangolava',
    'arrangolavi',
    'arrangolavo',
    'arrangolera',
    'arrangolerai',
    'arrangolerei',
    'arrangolero',
    'arrangoli',
    'arrangoliamo',
    'arrangoliate',
    'arrangolino',
    'arrangolo',
    'arrantolata',
    'arrantolate',
    'arrantolati',
    'arrantolato',
    'arrapa',
    'arrapai',
    'arrapamenti',
    'arrapamento',
    'arrapammo',
    'arrapando',
    'arrapandoci',
    'arrapandola',
    'arrapandole',
    'arrapandoli',
    'arrapandolo',
    'arrapandomi',
    'arrapandosi',
    'arrapandoti',
    'arrapandovi',
    'arrapano',
    'arrapante',
    'arrapanti',
    'arrapantisi',
    'arraparci',
    'arrapare',
    'arraparla',
    'arraparle',
    'arraparli',
    'arraparlo',
    'arraparmi',
    'arraparono',
    'arraparsi',
    'arraparti',
    'arraparvi',
    'arrapasse',
    'arrapassero',
    'arrapassi',
    'arrapassimo',
    'arrapaste',
    'arrapasti',
    'arrapata',
    'arrapate',
    'arrapatevi',
    'arrapati',
    'arrapato',
    'arrapatomi',
    'arrapatoti',
    'arrapava',
    'arrapavamo',
    'arrapavano',
    'arrapavate',
    'arrapavi',
    'arrapavo',
    'arrapera',
    'arraperai',
    'arraperanno',
    'arraperebbe',
    'arraperei',
    'arraperemmo',
    'arraperemo',
    'arrapereste',
    'arraperesti',
    'arraperete',
    'arrapero',
    'arrapi',
    'arrapiamo',
    'arrapiamoci',
    'arrapiate',
    'arrapina',
    'arrapinai',
    'arrapinammo',
    'arrapinando',
    'arrapinano',
    'arrapinante',
    'arrapinanti',
    'arrapinarci',
    'arrapinare',
    'arrapinarmi',
    'arrapinarono',
    'arrapinarsi',
    'arrapinarti',
    'arrapinarvi',
    'arrapinasse',
    'arrapinassi',
    'arrapinaste',
    'arrapinasti',
    'arrapinata',
    'arrapinate',
    'arrapinatevi',
    'arrapinati',
    'arrapinato',
    'arrapinatomi',
    'arrapinatoti',
    'arrapinava',
    'arrapinavamo',
    'arrapinavano',
    'arrapinavate',
    'arrapinavi',
    'arrapinavo',
    'arrapinera',
    'arrapinerai',
    'arrapinerei',
    'arrapineremo',
    'arrapinerete',
    'arrapinero',
    'arrapini',
    'arrapiniamo',
    'arrapiniate',
    'arrapinino',
    'arrapino',
    'arrapo',
    'array',
    'arrazza',
    'arrazzai',
    'arrazzammo',
    'arrazzando',
    'arrazzandoci',
    'arrazzandomi',
    'arrazzandosi',
    'arrazzandoti',
    'arrazzandovi',
    'arrazzano',
    'arrazzante',
    'arrazzanti',
    'arrazzantisi',
    'arrazzarci',
    'arrazzare',
    'arrazzarmi',
    'arrazzarono',
    'arrazzarsi',
    'arrazzarti',
    'arrazzarvi',
    'arrazzasse',
    'arrazzassero',
    'arrazzassi',
    'arrazzassimo',
    'arrazzaste',
    'arrazzasti',
    'arrazzata',
    'arrazzate',
    'arrazzatevi',
    'arrazzati',
    'arrazzato',
    'arrazzatomi',
    'arrazzatoti',
    'arrazzava',
    'arrazzavamo',
    'arrazzavano',
    'arrazzavate',
    'arrazzavi',
    'arrazzavo',
    'arrazzera',
    'arrazzerai',
    'arrazzeranno',
    'arrazzerebbe',
    'arrazzerei',
    'arrazzeremmo',
    'arrazzeremo',
    'arrazzereste',
    'arrazzeresti',
    'arrazzerete',
    'arrazzero',
    'arrazzi',
    'arrazziamo',
    'arrazziamoci',
    'arrazziate',
    'arrazzino',
    'arrazzo',
    'arre',
    'arreca',
    'arrecai',
    'arrecammo',
    'arrecando',
    'arrecano',
    'arrecante',
    'arrecanti',
    'arrecare',
    'arrecarono',
    'arrecasse',
    'arrecassero',
    'arrecassi',
    'arrecassimo',
    'arrecaste',
    'arrecasti',
    'arrecata',
    'arrecate',
    'arrecati',
    'arrecato',
    'arrecatoci',
    'arrecatogli',
    'arrecatole',
    'arrecatomi',
    'arrecatore',
    'arrecatori',
    'arrecatoti',
    'arrecatovi',
    'arrecatrice',
    'arrecatrici',
    'arrecava',
    'arrecavamo',
    'arrecavano',
    'arrecavate',
    'arrecavi',
    'arrecavo',
    'arrechera',
    'arrecherai',
    'arrecheranno',
    'arrecherebbe',
    'arrecherei',
    'arrecheremmo',
    'arrecheremo',
    'arrechereste',
    'arrecheresti',
    'arrecherete',
    'arrechero',
    'arrechi',
    'arrechiamo',
    'arrechiate',
    'arrechino',
    'arreco',
    'arreda',
    'arredai',
    'arredamenti',
    'arredamento',
    'arredammo',
    'arredando',
    'arredandola',
    'arredandole',
    'arredandoli',
    'arredandolo',
    'arredano',
    'arredante',
    'arredanti',
    'arredare',
    'arredarla',
    'arredarle',
    'arredarli',
    'arredarlo',
    'arredarono',
    'arredasse',
    'arredassero',
    'arredassi',
    'arredassimo',
    'arredaste',
    'arredasti',
    'arredata',
    'arredate',
    'arredati',
    'arredato',
    'arredatore',
    'arredatori',
    'arredatrice',
    'arredatrici',
    'arredava',
    'arredavamo',
    'arredavano',
    'arredavate',
    'arredavi',
    'arredavo',
    'arredera',
    'arrederai',
    'arrederanno',
    'arrederebbe',
    'arrederei',
    'arrederemmo',
    'arrederemo',
    'arredereste',
    'arrederesti',
    'arrederete',
    'arredero',
    'arrederò',
    'arredi',
    'arrediamo',
    'arrediate',
    'arredino',
    'arredo',
    'arredondo',
    'arremba',
    'arrembaggi',
    'arrembaggio',
    'arrembai',
    'arrembammo',
    'arrembando',
    'arrembandoci',
    'arrembandomi',
    'arrembandosi',
    'arrembandoti',
    'arrembandovi',
    'arrembano',
    'arrembante',
    'arrembanti',
    'arrembantisi',
    'arrembarci',
    'arrembare',
    'arrembarmi',
    'arrembarono',
    'arrembarsi',
    'arrembarti',
    'arrembarvi',
    'arrembasse',
    'arrembassero',
    'arrembassi',
    'arrembassimo',
    'arrembaste',
    'arrembasti',
    'arrembata',
    'arrembate',
    'arrembatevi',
    'arrembati',
    'arrembato',
    'arrembatomi',
    'arrembatoti',
    'arrembatura',
    'arrembature',
    'arrembava',
    'arrembavamo',
    'arrembavano',
    'arrembavate',
    'arrembavi',
    'arrembavo',
    'arrembera',
    'arremberai',
    'arremberanno',
    'arremberebbe',
    'arremberei',
    'arremberemmo',
    'arremberemo',
    'arrembereste',
    'arremberesti',
    'arremberete',
    'arrembero',
    'arrembi',
    'arrembiamo',
    'arrembiamoci',
    'arrembiate',
    'arrembino',
    'arrembo',
    'arrena',
    'arrenai',
    'arrenammo',
    'arrenando',
    'arrenandoci',
    'arrenandomi',
    'arrenandosi',
    'arrenandoti',
    'arrenandovi',
    'arrenano',
    'arrenante',
    'arrenanti',
    'arrenantisi',
    'arrenarci',
    'arrenare',
    'arrenarmi',
    'arrenarono',
    'arrenarsi',
    'arrenarti',
    'arrenarvi',
    'arrenasse',
    'arrenassero',
    'arrenassi',
    'arrenassimo',
    'arrenaste',
    'arrenasti',
    'arrenata',
    'arrenate',
    'arrenatevi',
    'arrenati',
    'arrenato',
    'arrenatomi',
    'arrenatoti',
    'arrenava',
    'arrenavamo',
    'arrenavano',
    'arrenavate',
    'arrenavi',
    'arrenavo',
    'arrenda',
    'arrendamenti',
    'arrendamento',
    'arrendano',
    'arrendatore',
    'arrendatori',
    'arrende',
    'arrendemmo',
    'arrendendo',
    'arrendendoci',
    'arrendendomi',
    'arrendendosi',
    'arrendendoti',
    'arrendendovi',
    'arrendente',
    'arrendenti',
    'arrendentisi',
    'arrendera',
    'arrenderai',
    'arrenderanno',
    'arrenderci',
    'arrendere',
    'arrenderebbe',
    'arrenderei',
    'arrenderemmo',
    'arrenderemo',
    'arrendereste',
    'arrenderesti',
    'arrenderete',
    'arrendermi',
    'arrendero',
    'arrendersi',
    'arrenderti',
    'arrendervi',
    'arrenderò',
    'arrendesse',
    'arrendessero',
    'arrendessi',
    'arrendessimo',
    'arrendeste',
    'arrendesti',
    'arrendete',
    'arrendetevi',
    'arrendeva',
    'arrendevamo',
    'arrendevano',
    'arrendevate',
    'arrendevi',
    'arrendevo',
    'arrendevole',
    'arrendevoli',
    'arrendi',
    'arrendiamo',
    'arrendiamoci',
    'arrendiate',
    'arrenditi',
    'arrendo',
    'arrendono',
    'arrenera',
    'arrenerai',
    'arreneranno',
    'arrenerebbe',
    'arrenerei',
    'arreneremmo',
    'arreneremo',
    'arrenereste',
    'arreneresti',
    'arrenerete',
    'arrenero',
    'arreni',
    'arreniamo',
    'arreniamoci',
    'arreniate',
    'arrenino',
    'arreno',
    'arresa',
    'arrese',
    'arresero',
    'arresi',
    'arresisi',
    'arreso',
    'arresomi',
    'arresoti',
    'arresta',
    'arrestai',
    'arrestala',
    'arrestale',
    'arrestali',
    'arrestalo',
    'arrestamenti',
    'arrestamento',
    'arrestammo',
    'arrestando',
    'arrestandoci',
    'arrestandomi',
    'arrestandosi',
    'arrestandoti',
    'arrestandovi',
    'arrestano',
    'arrestante',
    'arrestanti',
    'arrestantisi',
    'arrestarci',
    'arrestare',
    'arrestarmi',
    'arrestarono',
    'arrestarsi',
    'arrestarti',
    'arrestarvi',
    'arrestasse',
    'arrestassero',
    'arrestassi',
    'arrestassimo',
    'arrestaste',
    'arrestasti',
    'arrestata',
    'arrestate',
    'arrestatela',
    'arrestatele',
    'arrestateli',
    'arrestatelo',
    'arrestatevi',
    'arrestati',
    'arrestato',
    'arrestatoi',
    'arrestatoio',
    'arrestatomi',
    'arrestatoti',
    'arrestava',
    'arrestavamo',
    'arrestavano',
    'arrestavate',
    'arrestavi',
    'arrestavo',
    'arrestera',
    'arresterai',
    'arresteranno',
    'arresterebbe',
    'arresterei',
    'arresteremmo',
    'arresteremo',
    'arrestereste',
    'arresteresti',
    'arresterete',
    'arrestero',
    'arresterò',
    'arresti',
    'arrestiamo',
    'arrestiamoci',
    'arrestiate',
    'arrestino',
    'arresto',
    'arretra',
    'arretrai',
    'arretramenti',
    'arretramento',
    'arretrammo',
    'arretrando',
    'arretrano',
    'arretrante',
    'arretranti',
    'arretrare',
    'arretrarono',
    'arretrarsi',
    'arretrasse',
    'arretrassero',
    'arretrassi',
    'arretrassimo',
    'arretraste',
    'arretrasti',
    'arretrata',
    'arretrate',
    'arretratezza',
    'arretratezze',
    'arretrati',
    'arretrato',
    'arretrava',
    'arretravamo',
    'arretravano',
    'arretravate',
    'arretravi',
    'arretravo',
    'arretrera',
    'arretrerai',
    'arretreranno',
    'arretrerebbe',
    'arretrerei',
    'arretreremmo',
    'arretreremo',
    'arretrereste',
    'arretreresti',
    'arretrerete',
    'arretrero',
    'arretrerò',
    'arretri',
    'arretriamo',
    'arretriate',
    'arretrino',
    'arretro',
    'arri',
    'arriba',
    'arriccera',
    'arriccerai',
    'arricceranno',
    'arriccerebbe',
    'arriccerei',
    'arricceremmo',
    'arricceremo',
    'arriccereste',
    'arricceresti',
    'arriccerete',
    'arriccero',
    'arriccerò',
    'arricchendo',
    'arricchente',
    'arricchenti',
    'arricchi',
    'arricchiamo',
    'arricchiate',
    'arricchii',
    'arricchimmo',
    'arricchira',
    'arricchirai',
    'arricchirci',
    'arricchire',
    'arricchirei',
    'arricchiremo',
    'arricchirete',
    'arricchirmi',
    'arricchiro',
    'arricchirono',
    'arricchirsi',
    'arricchirti',
    'arricchirvi',
    'arricchirà',
    'arricchirò',
    'arricchisca',
    'arricchisce',
    'arricchisci',
    'arricchisco',
    'arricchisse',
    'arricchissi',
    'arricchiste',
    'arricchisti',
    'arricchita',
    'arricchitasi',
    'arricchite',
    'arricchitevi',
    'arricchiti',
    'arricchito',
    'arricchitomi',
    'arricchitoti',
    'arricchiva',
    'arricchivamo',
    'arricchivano',
    'arricchivate',
    'arricchivi',
    'arricchivo',
    'arricci',
    'arriccia',
    'arricciai',
    'arricciammo',
    'arricciamo',
    'arricciamoci',
    'arricciando',
    'arricciano',
    'arricciante',
    'arriccianti',
    'arricciarci',
    'arricciare',
    'arricciarla',
    'arricciarle',
    'arricciarli',
    'arricciarlo',
    'arricciarmi',
    'arricciarono',
    'arricciarsi',
    'arricciarti',
    'arricciarvi',
    'arricciasse',
    'arricciassi',
    'arricciaste',
    'arricciasti',
    'arricciata',
    'arricciate',
    'arricciatevi',
    'arricciati',
    'arricciato',
    'arricciatomi',
    'arricciatoti',
    'arricciatura',
    'arricciature',
    'arricciava',
    'arricciavamo',
    'arricciavano',
    'arricciavate',
    'arricciavi',
    'arricciavo',
    'arriccino',
    'arriccio',
    'arricciola',
    'arricciolai',
    'arricciolano',
    'arricciolare',
    'arricciolata',
    'arricciolate',
    'arricciolati',
    'arricciolato',
    'arricciolava',
    'arricciolavi',
    'arricciolavo',
    'arricciolera',
    'arricciolero',
    'arriccioli',
    'arricciolino',
    'arricciolo',
    'arrida',
    'arridai',
    'arridammo',
    'arridando',
    'arridano',
    'arridante',
    'arridanti',
    'arridare',
    'arridarono',
    'arridasse',
    'arridassero',
    'arridassi',
    'arridassimo',
    'arridaste',
    'arridasti',
    'arridata',
    'arridate',
    'arridati',
    'arridato',
    'arridatoi',
    'arridatoio',
    'arridava',
    'arridavamo',
    'arridavano',
    'arridavate',
    'arridavi',
    'arridavo',
    'arride',
    'arridemmo',
    'arridendo',
    'arridente',
    'arridenti',
    'arridera',
    'arriderai',
    'arrideranno',
    'arridere',
    'arriderebbe',
    'arriderei',
    'arrideremmo',
    'arrideremo',
    'arridereste',
    'arrideresti',
    'arriderete',
    'arridero',
    'arridesse',
    'arridessero',
    'arridessi',
    'arridessimo',
    'arrideste',
    'arridesti',
    'arridete',
    'arrideva',
    'arridevamo',
    'arridevano',
    'arridevate',
    'arridevi',
    'arridevo',
    'arridi',
    'arridiamo',
    'arridiate',
    'arridino',
    'arrido',
    'arridono',
    'arriere',
    'arriffa',
    'arriffai',
    'arriffammo',
    'arriffando',
    'arriffano',
    'arriffante',
    'arriffanti',
    'arriffare',
    'arriffarono',
    'arriffasse',
    'arriffassero',
    'arriffassi',
    'arriffassimo',
    'arriffaste',
    'arriffasti',
    'arriffata',
    'arriffate',
    'arriffati',
    'arriffato',
    'arriffava',
    'arriffavamo',
    'arriffavano',
    'arriffavate',
    'arriffavi',
    'arriffavo',
    'arriffera',
    'arrifferai',
    'arrifferanno',
    'arrifferebbe',
    'arrifferei',
    'arrifferemmo',
    'arrifferemo',
    'arriffereste',
    'arrifferesti',
    'arrifferete',
    'arriffero',
    'arriffi',
    'arriffiamo',
    'arriffiate',
    'arriffino',
    'arriffo',
    'arriga',
    'arrighetto',
    'arrigo',
    'arriguccio',
    'arringa',
    'arringai',
    'arringammo',
    'arringando',
    'arringano',
    'arringante',
    'arringanti',
    'arringare',
    'arringarono',
    'arringasse',
    'arringassero',
    'arringassi',
    'arringassimo',
    'arringaste',
    'arringasti',
    'arringata',
    'arringate',
    'arringati',
    'arringato',
    'arringatore',
    'arringatori',
    'arringatrice',
    'arringatrici',
    'arringava',
    'arringavamo',
    'arringavano',
    'arringavate',
    'arringavi',
    'arringavo',
    'arringhe',
    'arringhera',
    'arringherai',
    'arringherei',
    'arringheremo',
    'arringherete',
    'arringhero',
    'arringhi',
    'arringhiamo',
    'arringhiate',
    'arringhino',
    'arringo',
    'arrisa',
    'arriscare',
    'arrischi',
    'arrischia',
    'arrischiai',
    'arrischiammo',
    'arrischiamo',
    'arrischiando',
    'arrischiano',
    'arrischiante',
    'arrischianti',
    'arrischiarci',
    'arrischiare',
    'arrischiarmi',
    'arrischiarsi',
    'arrischiarti',
    'arrischiarvi',
    'arrischiasse',
    'arrischiassi',
    'arrischiaste',
    'arrischiasti',
    'arrischiata',
    'arrischiate',
    'arrischiati',
    'arrischiato',
    'arrischiava',
    'arrischiavi',
    'arrischiavo',
    'arrischiera',
    'arrischierai',
    'arrischierei',
    'arrischiero',
    'arrischino',
    'arrischio',
    'arrise',
    'arrisemi',
    'arrisero',
    'arrisi',
    'arrisicare',
    'arriso',
    'arriv',
    'arriva',
    'arrivabile',
    'arrivabili',
    'arrivaci',
    'arrivai',
    'arrivammo',
    'arrivando',
    'arrivandoci',
    'arrivandomi',
    'arrivandone',
    'arrivandoti',
    'arrivandovi',
    'arrivano',
    'arrivante',
    'arrivanti',
    'arrivarci',
    'arrivare',
    'arrivarmi',
    'arrivarne',
    'arrivarono',
    'arrivarsene',
    'arrivarti',
    'arrivarvi',
    'arrivasse',
    'arrivassero',
    'arrivassi',
    'arrivassimo',
    'arrivaste',
    'arrivasti',
    'arrivata',
    'arrivate',
    'arrivati',
    'arrivato',
    'arrivatura',
    'arrivature',
    'arrivava',
    'arrivavamo',
    'arrivavano',
    'arrivavate',
    'arrivavi',
    'arrivavo',
    'arrive',
    'arrivedella',
    'arrivedelle',
    'arrivederci',
    'arrivederla',
    'arrivera',
    'arriverai',
    'arriveranno',
    'arriverebbe',
    'arriverei',
    'arriveremmo',
    'arriveremo',
    'arrivereste',
    'arriveresti',
    'arriverete',
    'arrivero',
    'arriverà',
    'arriverò',
    'arrivi',
    'arriviamo',
    'arriviate',
    'arrivillaga',
    'arrivino',
    'arrivismi',
    'arrivismo',
    'arrivista',
    'arriviste',
    'arrivisti',
    'arrivistica',
    'arrivistiche',
    'arrivistici',
    'arrivistico',
    'arrivo',
    'arrivò',
    'arrocca',
    'arroccai',
    'arroccamenti',
    'arroccamento',
    'arroccammo',
    'arroccando',
    'arroccandoci',
    'arroccandomi',
    'arroccandosi',
    'arroccandoti',
    'arroccandovi',
    'arroccano',
    'arroccante',
    'arroccanti',
    'arroccantisi',
    'arroccarci',
    'arroccare',
    'arroccarmi',
    'arroccarono',
    'arroccarsi',
    'arroccarti',
    'arroccarvi',
    'arroccasse',
    'arroccassero',
    'arroccassi',
    'arroccassimo',
    'arroccaste',
    'arroccasti',
    'arroccata',
    'arroccate',
    'arroccatevi',
    'arroccati',
    'arroccato',
    'arroccatomi',
    'arroccatoti',
    'arroccava',
    'arroccavamo',
    'arroccavano',
    'arroccavate',
    'arroccavi',
    'arroccavo',
    'arroccera',
    'arroccerai',
    'arrocceranno',
    'arroccerebbe',
    'arroccerei',
    'arrocceremmo',
    'arrocceremo',
    'arroccereste',
    'arrocceresti',
    'arroccerete',
    'arroccero',
    'arrocchera',
    'arroccherai',
    'arroccherei',
    'arroccheremo',
    'arroccherete',
    'arrocchero',
    'arrocchi',
    'arrocchia',
    'arrocchiai',
    'arrocchiammo',
    'arrocchiamo',
    'arrocchiando',
    'arrocchiano',
    'arrocchiante',
    'arrocchianti',
    'arrocchiare',
    'arrocchiasse',
    'arrocchiassi',
    'arrocchiaste',
    'arrocchiasti',
    'arrocchiata',
    'arrocchiate',
    'arrocchiati',
    'arrocchiato',
    'arrocchiava',
    'arrocchiavi',
    'arrocchiavo',
    'arrocchiera',
    'arrocchierai',
    'arrocchierei',
    'arrocchiero',
    'arrocchino',
    'arrocchio',
    'arrocci',
    'arroccia',
    'arrocciai',
    'arrocciammo',
    'arrocciamo',
    'arrocciamoci',
    'arrocciando',
    'arrocciano',
    'arrocciarci',
    'arrocciare',
    'arrocciarmi',
    'arrocciarono',
    'arrocciarsi',
    'arrocciarti',
    'arrocciarvi',
    'arrocciasse',
    'arrocciassi',
    'arrocciaste',
    'arrocciasti',
    'arrocciata',
    'arrocciate',
    'arrocciatevi',
    'arrocciati',
    'arrocciato',
    'arrocciatomi',
    'arrocciatoti',
    'arrocciava',
    'arrocciavamo',
    'arrocciavano',
    'arrocciavate',
    'arrocciavi',
    'arrocciavo',
    'arroccino',
    'arroccio',
    'arrocco',
    'arrochendo',
    'arrochendoci',
    'arrochendomi',
    'arrochendosi',
    'arrochendoti',
    'arrochendovi',
    'arrochente',
    'arrochenti',
    'arrochentisi',
    'arrochi',
    'arrochiamo',
    'arrochiamoci',
    'arrochiate',
    'arrochii',
    'arrochimenti',
    'arrochimento',
    'arrochimmo',
    'arrochira',
    'arrochirai',
    'arrochiranno',
    'arrochirci',
    'arrochire',
    'arrochirebbe',
    'arrochirei',
    'arrochiremmo',
    'arrochiremo',
    'arrochireste',
    'arrochiresti',
    'arrochirete',
    'arrochirmi',
    'arrochiro',
    'arrochirono',
    'arrochirsi',
    'arrochirti',
    'arrochirvi',
    'arrochisca',
    'arrochiscano',
    'arrochisce',
    'arrochisci',
    'arrochisciti',
    'arrochisco',
    'arrochiscono',
    'arrochisse',
    'arrochissero',
    'arrochissi',
    'arrochissimo',
    'arrochiste',
    'arrochisti',
    'arrochita',
    'arrochite',
    'arrochitevi',
    'arrochiti',
    'arrochito',
    'arrochitomi',
    'arrochitoti',
    'arrochiva',
    'arrochivamo',
    'arrochivano',
    'arrochivate',
    'arrochivi',
    'arrochivo',
    'arroga',
    'arrogai',
    'arrogammo',
    'arrogando',
    'arrogandoci',
    'arrogandomi',
    'arrogandosi',
    'arrogandoti',
    'arrogandovi',
    'arrogano',
    'arrogante',
    'arroganti',
    'arrogantisi',
    'arroganza',
    'arroganze',
    'arrogarci',
    'arrogare',
    'arrogarmi',
    'arrogarono',
    'arrogarsi',
    'arrogarti',
    'arrogarvi',
    'arrogasse',
    'arrogassero',
    'arrogassi',
    'arrogassimo',
    'arrogaste',
    'arrogasti',
    'arrogata',
    'arrogate',
    'arrogatevi',
    'arrogati',
    'arrogato',
    'arrogatomi',
    'arrogatoti',
    'arrogava',
    'arrogavamo',
    'arrogavano',
    'arrogavate',
    'arrogavi',
    'arrogavo',
    'arrogazione',
    'arrogazioni',
    'arroge',
    'arrogere',
    'arroghera',
    'arrogherai',
    'arrogheranno',
    'arrogherebbe',
    'arrogherei',
    'arrogheremmo',
    'arrogheremo',
    'arroghereste',
    'arrogheresti',
    'arrogherete',
    'arroghero',
    'arrogherò',
    'arroghi',
    'arroghiamo',
    'arroghiamoci',
    'arroghiate',
    'arroghino',
    'arrogi',
    'arrogino',
    'arrogo',
    'arrolamento',
    'arrolare',
    'arrolato',
    'arroncigli',
    'arronciglia',
    'arroncigliai',
    'arronciglino',
    'arronciglio',
    'arronza',
    'arronzai',
    'arronzammo',
    'arronzando',
    'arronzandoci',
    'arronzandomi',
    'arronzandosi',
    'arronzandoti',
    'arronzandovi',
    'arronzano',
    'arronzante',
    'arronzanti',
    'arronzantisi',
    'arronzarci',
    'arronzare',
    'arronzarmi',
    'arronzarono',
    'arronzarsi',
    'arronzarti',
    'arronzarvi',
    'arronzasse',
    'arronzassero',
    'arronzassi',
    'arronzassimo',
    'arronzaste',
    'arronzasti',
    'arronzata',
    'arronzate',
    'arronzatevi',
    'arronzati',
    'arronzato',
    'arronzatomi',
    'arronzatore',
    'arronzatori',
    'arronzatoti',
    'arronzatrice',
    'arronzatrici',
    'arronzava',
    'arronzavamo',
    'arronzavano',
    'arronzavate',
    'arronzavi',
    'arronzavo',
    'arronzera',
    'arronzerai',
    'arronzeranno',
    'arronzerebbe',
    'arronzerei',
    'arronzeremmo',
    'arronzeremo',
    'arronzereste',
    'arronzeresti',
    'arronzerete',
    'arronzero',
    'arronzi',
    'arronziamo',
    'arronziamoci',
    'arronziate',
    'arronzino',
    'arronzo',
    'arroso',
    'arrossa',
    'arrossai',
    'arrossamenti',
    'arrossamento',
    'arrossammo',
    'arrossando',
    'arrossandoci',
    'arrossandomi',
    'arrossandosi',
    'arrossandoti',
    'arrossandovi',
    'arrossano',
    'arrossante',
    'arrossanti',
    'arrossantisi',
    'arrossarci',
    'arrossare',
    'arrossarmi',
    'arrossarono',
    'arrossarsi',
    'arrossarti',
    'arrossarvi',
    'arrossasse',
    'arrossassero',
    'arrossassi',
    'arrossassimo',
    'arrossaste',
    'arrossasti',
    'arrossata',
    'arrossate',
    'arrossatevi',
    'arrossati',
    'arrossato',
    'arrossatomi',
    'arrossatoti',
    'arrossava',
    'arrossavamo',
    'arrossavano',
    'arrossavate',
    'arrossavi',
    'arrossavo',
    'arrossendo',
    'arrossente',
    'arrossenti',
    'arrossera',
    'arrosserai',
    'arrosseranno',
    'arrosserebbe',
    'arrosserei',
    'arrosseremmo',
    'arrosseremo',
    'arrossereste',
    'arrosseresti',
    'arrosserete',
    'arrossero',
    'arrossi',
    'arrossiamo',
    'arrossiamoci',
    'arrossiate',
    'arrossii',
    'arrossimenti',
    'arrossimento',
    'arrossimmo',
    'arrossino',
    'arrossira',
    'arrossirai',
    'arrossiranno',
    'arrossire',
    'arrossirebbe',
    'arrossirei',
    'arrossiremmo',
    'arrossiremo',
    'arrossireste',
    'arrossiresti',
    'arrossirete',
    'arrossiro',
    'arrossirono',
    'arrossirà',
    'arrossirò',
    'arrossisca',
    'arrossiscano',
    'arrossisce',
    'arrossisci',
    'arrossisco',
    'arrossiscono',
    'arrossisse',
    'arrossissero',
    'arrossissi',
    'arrossissimo',
    'arrossiste',
    'arrossisti',
    'arrossita',
    'arrossite',
    'arrossiti',
    'arrossito',
    'arrossiva',
    'arrossivamo',
    'arrossivano',
    'arrossivate',
    'arrossivi',
    'arrossivo',
    'arrosso',
    'arrosta',
    'arrostando',
    'arrostandosi',
    'arrostano',
    'arrostante',
    'arrostare',
    'arrostarsi',
    'arrostata',
    'arrostate',
    'arrostati',
    'arrostato',
    'arrostava',
    'arrostavano',
    'arroste',
    'arrostendo',
    'arrostendoci',
    'arrostendomi',
    'arrostendosi',
    'arrostendoti',
    'arrostendovi',
    'arrostente',
    'arrostenti',
    'arrostentisi',
    'arrosti',
    'arrostiamo',
    'arrostiamoci',
    'arrostiate',
    'arrostii',
    'arrostimenti',
    'arrostimento',
    'arrostimmo',
    'arrostini',
    'arrostino',
    'arrostira',
    'arrostirai',
    'arrostiranno',
    'arrostirci',
    'arrostire',
    'arrostirebbe',
    'arrostirei',
    'arrostiremmo',
    'arrostiremo',
    'arrostireste',
    'arrostiresti',
    'arrostirete',
    'arrostirmi',
    'arrostiro',
    'arrostirono',
    'arrostirsi',
    'arrostirti',
    'arrostirvi',
    'arrostirà',
    'arrostirò',
    'arrostisca',
    'arrostiscano',
    'arrostisce',
    'arrostisci',
    'arrostisciti',
    'arrostisco',
    'arrostiscono',
    'arrostisse',
    'arrostissero',
    'arrostissi',
    'arrostissimo',
    'arrostiste',
    'arrostisti',
    'arrostita',
    'arrostite',
    'arrostitevi',
    'arrostiti',
    'arrostito',
    'arrostitomi',
    'arrostitoti',
    'arrostitura',
    'arrostiture',
    'arrostiva',
    'arrostivamo',
    'arrostivano',
    'arrostivate',
    'arrostivi',
    'arrostivo',
    'arrosto',
    'arrota',
    'arrotai',
    'arrotamenti',
    'arrotamento',
    'arrotammo',
    'arrotando',
    'arrotandoci',
    'arrotandomi',
    'arrotandosi',
    'arrotandoti',
    'arrotandovi',
    'arrotano',
    'arrotante',
    'arrotanti',
    'arrotantisi',
    'arrotarci',
    'arrotare',
    'arrotarmi',
    'arrotarono',
    'arrotarsi',
    'arrotarti',
    'arrotarvi',
    'arrotasse',
    'arrotassero',
    'arrotassi',
    'arrotassimo',
    'arrotaste',
    'arrotasti',
    'arrotata',
    'arrotate',
    'arrotatevi',
    'arrotati',
    'arrotato',
    'arrotatomi',
    'arrotatoti',
    'arrotatrice',
    'arrotatrici',
    'arrotatura',
    'arrotature',
    'arrotava',
    'arrotavamo',
    'arrotavano',
    'arrotavate',
    'arrotavi',
    'arrotavo',
    'arrotera',
    'arroterai',
    'arroteranno',
    'arroterebbe',
    'arroterei',
    'arroteremmo',
    'arroteremo',
    'arrotereste',
    'arroteresti',
    'arroterete',
    'arrotero',
    'arroterò',
    'arroti',
    'arrotiamo',
    'arrotiamoci',
    'arrotiate',
    'arrotina',
    'arrotine',
    'arrotini',
    'arrotino',
    'arroto',
    'arrotola',
    'arrotolai',
    'arrotolammo',
    'arrotolando',
    'arrotolano',
    'arrotolante',
    'arrotolanti',
    'arrotolare',
    'arrotolarono',
    'arrotolarsi',
    'arrotolasse',
    'arrotolassi',
    'arrotolaste',
    'arrotolasti',
    'arrotolata',
    'arrotolate',
    'arrotolati',
    'arrotolato',
    'arrotolatore',
    'arrotolatori',
    'arrotolava',
    'arrotolavamo',
    'arrotolavano',
    'arrotolavate',
    'arrotolavi',
    'arrotolavo',
    'arrotolera',
    'arrotolerai',
    'arrotolerei',
    'arrotoleremo',
    'arrotolerete',
    'arrotolero',
    'arrotolerò',
    'arrotoli',
    'arrotoliamo',
    'arrotoliate',
    'arrotolino',
    'arrotolo',
    'arrotonda',
    'arrotondai',
    'arrotondammo',
    'arrotondando',
    'arrotondano',
    'arrotondante',
    'arrotondanti',
    'arrotondarci',
    'arrotondare',
    'arrotondarmi',
    'arrotondarsi',
    'arrotondarti',
    'arrotondarvi',
    'arrotondasse',
    'arrotondassi',
    'arrotondaste',
    'arrotondasti',
    'arrotondata',
    'arrotondate',
    'arrotondati',
    'arrotondato',
    'arrotondava',
    'arrotondavi',
    'arrotondavo',
    'arrotondera',
    'arrotonderai',
    'arrotonderei',
    'arrotondero',
    'arrotonderò',
    'arrotondi',
    'arrotondiamo',
    'arrotondiate',
    'arrotondino',
    'arrotondo',
    'arrovella',
    'arrovellai',
    'arrovellammo',
    'arrovellando',
    'arrovellano',
    'arrovellante',
    'arrovellanti',
    'arrovellarci',
    'arrovellare',
    'arrovellarmi',
    'arrovellarsi',
    'arrovellarti',
    'arrovellarvi',
    'arrovellasse',
    'arrovellassi',
    'arrovellaste',
    'arrovellasti',
    'arrovellata',
    'arrovellate',
    'arrovellati',
    'arrovellato',
    'arrovellava',
    'arrovellavi',
    'arrovellavo',
    'arrovellera',
    'arrovellerai',
    'arrovellerei',
    'arrovellero',
    'arrovelli',
    'arrovelliamo',
    'arrovelliate',
    'arrovellino',
    'arrovello',
    'arroventa',
    'arroventai',
    'arroventammo',
    'arroventando',
    'arroventano',
    'arroventante',
    'arroventanti',
    'arroventarci',
    'arroventare',
    'arroventarmi',
    'arroventarsi',
    'arroventarti',
    'arroventarvi',
    'arroventasse',
    'arroventassi',
    'arroventaste',
    'arroventasti',
    'arroventata',
    'arroventate',
    'arroventati',
    'arroventato',
    'arroventava',
    'arroventavi',
    'arroventavo',
    'arroventera',
    'arroventerai',
    'arroventerei',
    'arroventero',
    'arroventi',
    'arroventiamo',
    'arroventiate',
    'arroventino',
    'arrovento',
    'arrovescera',
    'arrovescerai',
    'arrovescerei',
    'arrovescero',
    'arrovesci',
    'arrovescia',
    'arrovesciai',
    'arrovesciamo',
    'arrovesciano',
    'arrovesciare',
    'arrovesciata',
    'arrovesciate',
    'arrovesciati',
    'arrovesciato',
    'arrovesciava',
    'arrovesciavi',
    'arrovesciavo',
    'arrovescino',
    'arrovescio',
    'arrubina',
    'arrubinai',
    'arrubinammo',
    'arrubinando',
    'arrubinano',
    'arrubinante',
    'arrubinanti',
    'arrubinare',
    'arrubinarono',
    'arrubinasse',
    'arrubinassi',
    'arrubinaste',
    'arrubinasti',
    'arrubinata',
    'arrubinate',
    'arrubinati',
    'arrubinato',
    'arrubinava',
    'arrubinavamo',
    'arrubinavano',
    'arrubinavate',
    'arrubinavi',
    'arrubinavo',
    'arrubinera',
    'arrubinerai',
    'arrubinerei',
    'arrubineremo',
    'arrubinerete',
    'arrubinero',
    'arrubini',
    'arrubiniamo',
    'arrubiniate',
    'arrubinino',
    'arrubino',
    'arruda',
    'arruffa',
    'arruffai',
    'arruffamenti',
    'arruffamento',
    'arruffammo',
    'arruffando',
    'arruffandoci',
    'arruffandomi',
    'arruffandosi',
    'arruffandoti',
    'arruffandovi',
    'arruffano',
    'arruffante',
    'arruffanti',
    'arruffantisi',
    'arruffarci',
    'arruffare',
    'arruffarmi',
    'arruffarono',
    'arruffarsi',
    'arruffarti',
    'arruffarvi',
    'arruffasse',
    'arruffassero',
    'arruffassi',
    'arruffassimo',
    'arruffaste',
    'arruffasti',
    'arruffata',
    'arruffate',
    'arruffatevi',
    'arruffati',
    'arruffato',
    'arruffatomi',
    'arruffatoti',
    'arruffava',
    'arruffavamo',
    'arruffavano',
    'arruffavate',
    'arruffavi',
    'arruffavo',
    'arruffera',
    'arrufferai',
    'arrufferanno',
    'arrufferebbe',
    'arrufferei',
    'arrufferemmo',
    'arrufferemo',
    'arruffereste',
    'arrufferesti',
    'arrufferete',
    'arruffero',
    'arruffi',
    'arruffiamo',
    'arruffiamoci',
    'arruffiana',
    'arruffianai',
    'arruffianano',
    'arruffianare',
    'arruffianata',
    'arruffianate',
    'arruffianati',
    'arruffianato',
    'arruffianava',
    'arruffianavi',
    'arruffianavo',
    'arruffianera',
    'arruffianero',
    'arruffiani',
    'arruffianino',
    'arruffiano',
    'arruffiate',
    'arruffii',
    'arruffino',
    'arruffio',
    'arruffo',
    'arruffona',
    'arruffone',
    'arruffoni',
    'arrugginendo',
    'arrugginente',
    'arrugginenti',
    'arruggini',
    'arrugginiamo',
    'arrugginiate',
    'arrugginii',
    'arrugginimmo',
    'arrugginira',
    'arrugginirai',
    'arrugginirci',
    'arrugginire',
    'arrugginirei',
    'arrugginirmi',
    'arrugginiro',
    'arrugginirsi',
    'arrugginirti',
    'arrugginirvi',
    'arrugginisca',
    'arrugginisce',
    'arrugginisci',
    'arrugginisco',
    'arrugginisse',
    'arrugginissi',
    'arrugginiste',
    'arrugginisti',
    'arrugginita',
    'arrugginite',
    'arrugginiti',
    'arrugginito',
    'arrugginiva',
    'arrugginivi',
    'arrugginivo',
    'arruola',
    'arruolabile',
    'arruolai',
    'arruolamenti',
    'arruolamento',
    'arruolammo',
    'arruolando',
    'arruolandoci',
    'arruolandola',
    'arruolandole',
    'arruolandoli',
    'arruolandolo',
    'arruolandomi',
    'arruolandosi',
    'arruolandoti',
    'arruolandovi',
    'arruolano',
    'arruolante',
    'arruolanti',
    'arruolantisi',
    'arruolarci',
    'arruolare',
    'arruolarla',
    'arruolarle',
    'arruolarli',
    'arruolarlo',
    'arruolarmi',
    'arruolarono',
    'arruolarsi',
    'arruolarti',
    'arruolarvi',
    'arruolasse',
    'arruolassero',
    'arruolassi',
    'arruolassimo',
    'arruolaste',
    'arruolasti',
    'arruolata',
    'arruolate',
    'arruolatevi',
    'arruolati',
    'arruolato',
    'arruolatomi',
    'arruolatoti',
    'arruolava',
    'arruolavamo',
    'arruolavano',
    'arruolavate',
    'arruolavi',
    'arruolavo',
    'arruolera',
    'arruolerai',
    'arruoleranno',
    'arruolerano',
    'arruolerebbe',
    'arruolerei',
    'arruoleremmo',
    'arruoleremo',
    'arruolereste',
    'arruoleresti',
    'arruolerete',
    'arruolero',
    'arruolerò',
    'arruoli',
    'arruoliamo',
    'arruoliamoci',
    'arruoliate',
    'arruolino',
    'arruolo',
    'arruvidendo',
    'arruvidente',
    'arruvidenti',
    'arruvidi',
    'arruvidiamo',
    'arruvidiate',
    'arruvidii',
    'arruvidimmo',
    'arruvidira',
    'arruvidirai',
    'arruvidirci',
    'arruvidire',
    'arruvidirei',
    'arruvidiremo',
    'arruvidirete',
    'arruvidirmi',
    'arruvidiro',
    'arruvidirono',
    'arruvidirsi',
    'arruvidirti',
    'arruvidirvi',
    'arruvidisca',
    'arruvidisce',
    'arruvidisci',
    'arruvidisco',
    'arruvidisse',
    'arruvidissi',
    'arruvidiste',
    'arruvidisti',
    'arruvidita',
    'arruvidite',
    'arruviditevi',
    'arruviditi',
    'arruvidito',
    'arruviditomi',
    'arruviditoti',
    'arruvidiva',
    'arruvidivamo',
    'arruvidivano',
    'arruvidivate',
    'arruvidivi',
    'arruvidivo',
    'arsa',
    'arsamente',
    'arse',
    'arsella',
    'arselle',
    'arsenale',
    'arsenali',
    'arsenalotti',
    'arsenalotto',
    'arsendo',
    'arsenia',
    'arseniati',
    'arseniato',
    'arsenica',
    'arsenicale',
    'arsenicali',
    'arsenicata',
    'arsenicate',
    'arsenicati',
    'arsenicato',
    'arseniche',
    'arsenici',
    'arsenicismi',
    'arsenicismo',
    'arsenico',
    'arsenio',
    'arseniosa',
    'arseniose',
    'arseniosi',
    'arsenioso',
    'arseniuri',
    'arseniuro',
    'arseno',
    'arsenopirite',
    'arsenopiriti',
    'arsente',
    'arsenti',
    'arserio',
    'arsero',
    'arsi',
    'arsiamo',
    'arsiate',
    'arsicce',
    'arsiccera',
    'arsiccerai',
    'arsicceranno',
    'arsiccerebbe',
    'arsiccerei',
    'arsicceremmo',
    'arsicceremo',
    'arsiccereste',
    'arsicceresti',
    'arsiccerete',
    'arsiccero',
    'arsicci',
    'arsiccia',
    'arsicciai',
    'arsicciammo',
    'arsicciamo',
    'arsicciando',
    'arsicciano',
    'arsicciante',
    'arsiccianti',
    'arsicciare',
    'arsicciarono',
    'arsicciasse',
    'arsicciassi',
    'arsicciaste',
    'arsicciasti',
    'arsicciata',
    'arsicciate',
    'arsicciati',
    'arsicciato',
    'arsicciava',
    'arsicciavamo',
    'arsicciavano',
    'arsicciavate',
    'arsicciavi',
    'arsicciavo',
    'arsiccino',
    'arsiccio',
    'arsii',
    'arsilia',
    'arsilio',
    'arsimmo',
    'arsina',
    'arsine',
    'arsione',
    'arsioni',
    'arsira',
    'arsirai',
    'arsiranno',
    'arsire',
    'arsirebbe',
    'arsirebbero',
    'arsirei',
    'arsiremmo',
    'arsiremo',
    'arsireste',
    'arsiresti',
    'arsirete',
    'arsiro',
    'arsirono',
    'arsisca',
    'arsiscano',
    'arsisce',
    'arsisci',
    'arsisco',
    'arsiscono',
    'arsisse',
    'arsissero',
    'arsissi',
    'arsissimo',
    'arsiste',
    'arsisti',
    'arsita',
    'arsite',
    'arsiti',
    'arsito',
    'arsiva',
    'arsivamo',
    'arsivano',
    'arsivate',
    'arsivi',
    'arsivo',
    'arso',
    'arsura',
    'arsure',
    'arta',
    'artale',
    'artaserse',
    'artata',
    'artatamente',
    'artate',
    'artati',
    'artato',
    'arte',
    'arteaga',
    'artefa',
    'artefaccia',
    'artefacciamo',
    'artefacciano',
    'artefacciate',
    'artefaccio',
    'artefacemmo',
    'artefacendo',
    'artefacente',
    'artefacenti',
    'artefacesse',
    'artefacessi',
    'artefaceste',
    'artefacesti',
    'artefaceva',
    'artefacevamo',
    'artefacevano',
    'artefacevate',
    'artefacevi',
    'artefacevo',
    'artefai',
    'artefanno',
    'artefante',
    'artefara',
    'artefarai',
    'artefaranno',
    'artefare',
    'artefarebbe',
    'artefarei',
    'artefaremmo',
    'artefaremo',
    'artefareste',
    'artefaresti',
    'artefarete',
    'artefaro',
    'artefate',
    'artefatta',
    'artefatte',
    'artefatti',
    'artefatto',
    'artefece',
    'artefecero',
    'artefeci',
    'artefice',
    'artefici',
    'artefo',
    'artemesa',
    'artemia',
    'artemide',
    'artemidio',
    'artemino',
    'artemio',
    'artemisia',
    'artemisie',
    'artemisio',
    'artemo',
    'artenia',
    'artenice',
    'artenio',
    'arter',
    'arteria',
    'arteriale',
    'arteriali',
    'arterie',
    'arterio',
    'arteriola',
    'arteriole',
    'arteriologia',
    'arteriopatia',
    'arteriopatie',
    'arteriosa',
    'arteriose',
    'arteriosi',
    'arterioso',
    'arteriotomia',
    'arteriotomie',
    'arterite',
    'arteriti',
    'arterivirus',
    'artero',
    'arterovenosa',
    'arterovenose',
    'arterovenoso',
    'artesiana',
    'artesiane',
    'artesiani',
    'artesiano',
    'artezza',
    'artezze',
    'artglio',
    'arthrobacter',
    'arthur',
    'arthus',
    'arti',
    'artiaga',
    'artic',
    'artica',
    'artiche',
    'artici',
    'artico',
    'articola',
    'articolacci',
    'articolaccio',
    'articolai',
    'articolammo',
    'articolando',
    'articolano',
    'articolante',
    'articolanti',
    'articolarci',
    'articolare',
    'articolari',
    'articolarita',
    'articolarità',
    'articolarmi',
    'articolarono',
    'articolarsi',
    'articolarti',
    'articolarvi',
    'articolasse',
    'articolassi',
    'articolaste',
    'articolasti',
    'articolata',
    'articolate',
    'articolatevi',
    'articolati',
    'articolato',
    'articolatomi',
    'articolatore',
    'articolatori',
    'articolatoti',
    'articolava',
    'articolavamo',
    'articolavano',
    'articolavate',
    'articolavi',
    'articolavo',
    'articolera',
    'articolerai',
    'articolerei',
    'articoleremo',
    'articolerete',
    'articolero',
    'articolerò',
    'articolessa',
    'articolesse',
    'articoletti',
    'articoletto',
    'articoli',
    'articoliamo',
    'articoliate',
    'articolini',
    'articolino',
    'articolista',
    'articoliste',
    'articolisti',
    'articolo',
    'articolone',
    'articoloni',
    'articolucci',
    'articoluccio',
    'artide',
    'artiera',
    'artiere',
    'artieri',
    'artiero',
    'artifici',
    'artificiale',
    'artificiali',
    'artificiata',
    'artificiate',
    'artificiati',
    'artificiato',
    'artificiere',
    'artificieri',
    'artificio',
    'artificiosa',
    'artificiose',
    'artificiosi',
    'artificioso',
    'artifizi',
    'artifiziale',
    'artifiziato',
    'artifizio',
    'artigiana',
    'artigianale',
    'artigianali',
    'artigianati',
    'artigianato',
    'artigiane',
    'artigianella',
    'artigianelle',
    'artigianelli',
    'artigianello',
    'artigianesca',
    'artigianesco',
    'artigiani',
    'artigiano',
    'artigli',
    'artiglia',
    'artigliai',
    'artigliammo',
    'artigliamo',
    'artigliando',
    'artigliano',
    'artigliante',
    'artiglianti',
    'artigliare',
    'artigliarono',
    'artigliasse',
    'artigliassi',
    'artigliaste',
    'artigliasti',
    'artigliata',
    'artigliate',
    'artigliati',
    'artigliato',
    'artigliava',
    'artigliavamo',
    'artigliavano',
    'artigliavate',
    'artigliavi',
    'artigliavo',
    'artigliera',
    'artiglierai',
    'artigliere',
    'artiglierei',
    'artiglieremo',
    'artiglierete',
    'artiglieri',
    'artiglieria',
    'artiglierie',
    'artigliero',
    'artiglino',
    'artiglio',
    'artimina',
    'artimino',
    'artimio',
    'artimone',
    'artimoni',
    'artini',
    'artiodactyla',
    'artiodattila',
    'artiodattile',
    'artiodattili',
    'artiodattilo',
    'artioli',
    'artista',
    'artiste',
    'artisti',
    'artistica',
    'artistiche',
    'artistici',
    'artistico',
    'artistucoli',
    'artistucolo',
    'arto',
    'artoa',
    'artocarpi',
    'artocarpo',
    'artocebi',
    'artocebo',
    'artoe',
    'artoi',
    'artois',
    'artoo',
    'artoprotesi',
    'artralgia',
    'artralgie',
    'artrite',
    'artriti',
    'artritica',
    'artritiche',
    'artritici',
    'artritico',
    'artritismi',
    'artritismo',
    'artrocentesi',
    'artrodesi',
    'artrografia',
    'artrogriposi',
    'artrolisi',
    'artrologia',
    'artrologie',
    'artropatia',
    'artropatie',
    'artropode',
    'artropodi',
    'artroscopia',
    'artrosi',
    'artrotomia',
    'artrotomie',
    'artu',
    'artunduaga',
    'artura',
    'arturiana',
    'arturiane',
    'arturiani',
    'arturiano',
    'arturina',
    'arturino',
    'arturo',
    'aruaca',
    'aruache',
    'aruachi',
    'aruaco',
    'arundine',
    'arundini',
    'aruspicale',
    'aruspicali',
    'aruspicare',
    'aruspice',
    'aruspici',
    'aruspicina',
    'aruspicine',
    'aruspicini',
    'aruspicino',
    'aruspicio',
    'arvale',
    'arvali',
    'arvense',
    'arvensi',
    'arvicola',
    'arvicole',
    'arvilla',
    'arviso',
    'arvizo',
    'arzagola',
    'arzagole',
    'arzana',
    'arzavola',
    'arzavole',
    'arzelio',
    'arzenio',
    'arzente',
    'arzenti',
    'arzignano',
    'arzigogola',
    'arzigogolai',
    'arzigogolano',
    'arzigogolare',
    'arzigogolata',
    'arzigogolate',
    'arzigogolati',
    'arzigogolato',
    'arzigogolava',
    'arzigogolavi',
    'arzigogolavo',
    'arzigogolera',
    'arzigogolero',
    'arzigogoli',
    'arzigogolino',
    'arzigogolo',
    'arzigogolona',
    'arzigogolone',
    'arzigogoloni',
    'arzilla',
    'arzille',
    'arzilli',
    'arzillo',
    'arzinca',
    'arzinche',
    'asari',
    'asaro',
    'asberghi',
    'asbergo',
    'asbesti',
    'asbesto',
    'asbestosi',
    'asburgica',
    'asburgiche',
    'asburgici',
    'asburgico',
    'asburgo',
    'ascalona',
    'ascalonita',
    'ascaloniti',
    'ascania',
    'ascanio',
    'ascari',
    'ascariasi',
    'ascaride',
    'ascaridi',
    'ascaridia',
    'ascaridiasi',
    'ascaridida',
    'ascaridiosi',
    'ascaridoidea',
    'ascaris',
    'ascaro',
    'asce',
    'ascella',
    'ascellante',
    'ascellare',
    'ascellari',
    'ascelle',
    'ascenda',
    'ascendano',
    'ascende',
    'ascendemmo',
    'ascendendo',
    'ascendentale',
    'ascendentali',
    'ascendente',
    'ascendenti',
    'ascendenza',
    'ascendenze',
    'ascendera',
    'ascenderai',
    'ascenderanno',
    'ascendere',
    'ascenderebbe',
    'ascenderei',
    'ascenderemmo',
    'ascenderemo',
    'ascendereste',
    'ascenderesti',
    'ascenderete',
    'ascendero',
    'ascendesse',
    'ascendessero',
    'ascendessi',
    'ascendessimo',
    'ascendeste',
    'ascendesti',
    'ascendete',
    'ascendeva',
    'ascendevamo',
    'ascendevano',
    'ascendevate',
    'ascendevi',
    'ascendevo',
    'ascendi',
    'ascendiamo',
    'ascendiate',
    'ascendo',
    'ascendono',
    'ascensa',
    'ascense',
    'ascensina',
    'ascensionale',
    'ascensionali',
    'ascensione',
    'ascensioni',
    'ascenso',
    'ascensore',
    'ascensori',
    'ascensorista',
    'ascensoriste',
    'ascensoristi',
    'ascenza',
    'ascenzina',
    'ascenzio',
    'ascenzo',
    'ascera',
    'ascerai',
    'asceranno',
    'ascerebbe',
    'ascerebbero',
    'ascerei',
    'asceremmo',
    'asceremo',
    'ascereste',
    'asceresti',
    'ascerete',
    'ascero',
    'ascesa',
    'ascese',
    'ascesero',
    'ascesi',
    'asceso',
    'ascessi',
    'ascesso',
    'ascessuale',
    'ascessuali',
    'asceta',
    'ascete',
    'asceti',
    'ascetica',
    'ascetiche',
    'ascetici',
    'ascetico',
    'ascetismi',
    'ascetismo',
    'ascetta',
    'ascette',
    'aschi',
    'asci',
    'ascia',
    'asciai',
    'asciale',
    'asciali',
    'ascialia',
    'ascialone',
    'ascialoni',
    'asciammo',
    'asciamo',
    'asciando',
    'asciano',
    'asciante',
    'ascianti',
    'asciare',
    'asciarono',
    'asciasse',
    'asciassero',
    'asciassi',
    'asciassimo',
    'asciaste',
    'asciasti',
    'asciata',
    'asciate',
    'asciati',
    'asciatica',
    'asciatiche',
    'asciatici',
    'asciatico',
    'asciato',
    'asciava',
    'asciavamo',
    'asciavano',
    'asciavate',
    'asciavi',
    'asciavo',
    'ascidi',
    'ascidia',
    'ascidiacei',
    'ascidiaceo',
    'ascidiata',
    'ascidiate',
    'ascidiati',
    'ascidiato',
    'ascidie',
    'ascidio',
    'ascidiosi',
    'ascii',
    'ascino',
    'ascio',
    'asciolta',
    'asciolte',
    'asciolti',
    'asciolto',
    'asciolva',
    'asciolvano',
    'asciolve',
    'asciolvei',
    'asciolvemmo',
    'asciolvendo',
    'asciolvente',
    'asciolventi',
    'asciolvera',
    'asciolverai',
    'asciolvere',
    'asciolverei',
    'asciolveremo',
    'asciolverete',
    'asciolveri',
    'asciolvero',
    'asciolverono',
    'asciolvesse',
    'asciolvessi',
    'asciolveste',
    'asciolvesti',
    'asciolvete',
    'asciolvette',
    'asciolvetti',
    'asciolveva',
    'asciolvevamo',
    'asciolvevano',
    'asciolvevate',
    'asciolvevi',
    'asciolvevo',
    'asciolvi',
    'asciolviamo',
    'asciolviate',
    'asciolvo',
    'asciolvono',
    'ascisc',
    'ascissa',
    'ascisse',
    'ascita',
    'ascite',
    'asciti',
    'ascitica',
    'ascitiche',
    'ascitici',
    'ascitico',
    'ascitizi',
    'ascitizia',
    'ascitizie',
    'ascitizio',
    'asciuga',
    'asciugaggine',
    'asciugaggini',
    'asciugai',
    'asciugamani',
    'asciugamano',
    'asciugamenti',
    'asciugamento',
    'asciugammo',
    'asciugando',
    'asciugandoci',
    'asciugandola',
    'asciugandole',
    'asciugandoli',
    'asciugandolo',
    'asciugandomi',
    'asciugandosi',
    'asciugandoti',
    'asciugandovi',
    'asciugano',
    'asciugante',
    'asciuganti',
    'asciugantisi',
    'asciugarci',
    'asciugare',
    'asciugarla',
    'asciugarle',
    'asciugarli',
    'asciugarlo',
    'asciugarmi',
    'asciugarono',
    'asciugarsi',
    'asciugarti',
    'asciugarvi',
    'asciugasse',
    'asciugassero',
    'asciugassi',
    'asciugassimo',
    'asciugaste',
    'asciugasti',
    'asciugata',
    'asciugate',
    'asciugatevi',
    'asciugati',
    'asciugato',
    'asciugatoi',
    'asciugatoio',
    'asciugatomi',
    'asciugatore',
    'asciugatori',
    'asciugatoti',
    'asciugatrice',
    'asciugatrici',
    'asciugatura',
    'asciugature',
    'asciugava',
    'asciugavamo',
    'asciugavano',
    'asciugavate',
    'asciugavi',
    'asciugavo',
    'asciughera',
    'asciugherai',
    'asciugherei',
    'asciugheremo',
    'asciugherete',
    'asciughero',
    'asciughi',
    'asciughiamo',
    'asciughiate',
    'asciughino',
    'asciugo',
    'asciutta',
    'asciutte',
    'asciuttezza',
    'asciuttezze',
    'asciutti',
    'asciutto',
    'asciuttore',
    'asciuttori',
    'asclepiade',
    'asclepiadea',
    'asclepiadee',
    'asclepiadei',
    'asclepiadeo',
    'asclepiadi',
    'asclepiadina',
    'asclepiadine',
    'asclepio',
    'asco',
    'ascocarpi',
    'ascocarpo',
    'ascofora',
    'ascofore',
    'ascofori',
    'ascoforo',
    'ascogoni',
    'ascogonio',
    'ascolana',
    'ascolane',
    'ascolani',
    'ascolano',
    'ascoli',
    'ascoliasmo',
    'ascolichene',
    'ascolicheni',
    'ascolitana',
    'ascolitane',
    'ascolitani',
    'ascolitano',
    'ascolta',
    'ascoltabile',
    'ascoltabili',
    'ascoltaci',
    'ascoltai',
    'ascoltala',
    'ascoltale',
    'ascoltalo',
    'ascoltami',
    'ascoltammo',
    'ascoltando',
    'ascoltandoci',
    'ascoltandola',
    'ascoltandole',
    'ascoltandoli',
    'ascoltandolo',
    'ascoltandomi',
    'ascoltandoti',
    'ascoltandovi',
    'ascoltano',
    'ascoltante',
    'ascoltanti',
    'ascoltar',
    'ascoltarci',
    'ascoltare',
    'ascoltarla',
    'ascoltarle',
    'ascoltarli',
    'ascoltarlo',
    'ascoltarmi',
    'ascoltarono',
    'ascoltarti',
    'ascoltarvi',
    'ascoltasse',
    'ascoltassero',
    'ascoltassi',
    'ascoltassimo',
    'ascoltaste',
    'ascoltasti',
    'ascoltata',
    'ascoltate',
    'ascoltateci',
    'ascoltatela',
    'ascoltatele',
    'ascoltateli',
    'ascoltatelo',
    'ascoltatemi',
    'ascoltati',
    'ascoltato',
    'ascoltatore',
    'ascoltatori',
    'ascoltatrice',
    'ascoltatrici',
    'ascoltava',
    'ascoltavamo',
    'ascoltavano',
    'ascoltavate',
    'ascoltavi',
    'ascoltavo',
    'ascoltazione',
    'ascoltazioni',
    'ascoltera',
    'ascolterai',
    'ascolteranno',
    'ascolterebbe',
    'ascolterei',
    'ascolteremmo',
    'ascolteremo',
    'ascoltereste',
    'ascolteresti',
    'ascolterete',
    'ascoltero',
    'ascolterà',
    'ascolterò',
    'ascolti',
    'ascoltiamo',
    'ascoltiamola',
    'ascoltiamole',
    'ascoltiamoli',
    'ascoltiamolo',
    'ascoltiate',
    'ascoltino',
    'ascolto',
    'ascomicete',
    'ascomiceti',
    'ascomycota',
    'asconda',
    'ascondano',
    'asconde',
    'ascondemmo',
    'ascondendo',
    'ascondente',
    'ascondenti',
    'asconder',
    'ascondera',
    'asconderai',
    'asconderanno',
    'ascondere',
    'asconderebbe',
    'asconderei',
    'asconderemmo',
    'asconderemo',
    'ascondereste',
    'asconderesti',
    'asconderete',
    'ascondero',
    'ascondesse',
    'ascondessero',
    'ascondessi',
    'ascondessimo',
    'ascondeste',
    'ascondesti',
    'ascondete',
    'ascondeva',
    'ascondevamo',
    'ascondevano',
    'ascondevate',
    'ascondevi',
    'ascondevo',
    'ascondi',
    'ascondiamo',
    'ascondiate',
    'ascondo',
    'ascondono',
    'ascorbica',
    'ascorbiche',
    'ascorbici',
    'ascorbico',
    'ascosa',
    'ascosamente',
    'ascose',
    'ascosero',
    'ascosi',
    'ascoso',
    'ascospora',
    'ascospore',
    'ascra',
    'ascrea',
    'ascree',
    'ascrei',
    'ascreo',
    'ascrisse',
    'ascrissero',
    'ascrissi',
    'ascritta',
    'ascritte',
    'ascritti',
    'ascritto',
    'ascriva',
    'ascrivano',
    'ascrive',
    'ascrivemmo',
    'ascrivendo',
    'ascrivente',
    'ascriventi',
    'ascrivera',
    'ascriverai',
    'ascriveranno',
    'ascrivere',
    'ascriverebbe',
    'ascriverei',
    'ascriveremmo',
    'ascriveremo',
    'ascrivereste',
    'ascriveresti',
    'ascriverete',
    'ascrivermi',
    'ascrivero',
    'ascrivesse',
    'ascrivessero',
    'ascrivessi',
    'ascrivessimo',
    'ascriveste',
    'ascrivesti',
    'ascrivete',
    'ascriveva',
    'ascrivevamo',
    'ascrivevano',
    'ascrivevate',
    'ascrivevi',
    'ascrivevo',
    'ascrivi',
    'ascriviamo',
    'ascriviate',
    'ascrivibile',
    'ascrivibili',
    'ascrivo',
    'ascrivono',
    'ascrizione',
    'ascrizioni',
    'asdic',
    'asdrubale',
    'aseita',
    'aseità',
    'aselli',
    'asello',
    'asemantica',
    'asemantiche',
    'asemantici',
    'asemanticita',
    'asemanticità',
    'asemantico',
    'asencio',
    'asepsi',
    'asessuale',
    'asessuali',
    'asessuata',
    'asessuate',
    'asessuati',
    'asessuato',
    'asettica',
    'asettiche',
    'asettici',
    'asettico',
    'asfalta',
    'asfaltai',
    'asfaltammo',
    'asfaltando',
    'asfaltano',
    'asfaltante',
    'asfaltanti',
    'asfaltare',
    'asfaltarono',
    'asfaltarsi',
    'asfaltasse',
    'asfaltassero',
    'asfaltassi',
    'asfaltassimo',
    'asfaltaste',
    'asfaltasti',
    'asfaltata',
    'asfaltate',
    'asfaltati',
    'asfaltato',
    'asfaltatore',
    'asfaltatori',
    'asfaltatrice',
    'asfaltatrici',
    'asfaltatura',
    'asfaltature',
    'asfaltava',
    'asfaltavamo',
    'asfaltavano',
    'asfaltavate',
    'asfaltavi',
    'asfaltavo',
    'asfaltera',
    'asfalterai',
    'asfalteranno',
    'asfalterebbe',
    'asfalterei',
    'asfalteremmo',
    'asfalteremo',
    'asfaltereste',
    'asfalteresti',
    'asfalterete',
    'asfaltero',
    'asfalti',
    'asfaltiamo',
    'asfaltiate',
    'asfaltica',
    'asfaltiche',
    'asfaltici',
    'asfaltico',
    'asfaltino',
    'asfaltista',
    'asfaltiste',
    'asfaltisti',
    'asfalto',
    'asfissi',
    'asfissia',
    'asfissiai',
    'asfissiammo',
    'asfissiamo',
    'asfissiamoci',
    'asfissiando',
    'asfissiano',
    'asfissiante',
    'asfissianti',
    'asfissiarci',
    'asfissiare',
    'asfissiarla',
    'asfissiarle',
    'asfissiarli',
    'asfissiarlo',
    'asfissiarmi',
    'asfissiarono',
    'asfissiarsi',
    'asfissiarti',
    'asfissiarvi',
    'asfissiasse',
    'asfissiassi',
    'asfissiaste',
    'asfissiasti',
    'asfissiata',
    'asfissiate',
    'asfissiateci',
    'asfissiatela',
    'asfissiatele',
    'asfissiateli',
    'asfissiatelo',
    'asfissiatemi',
    'asfissiatevi',
    'asfissiati',
    'asfissiato',
    'asfissiatomi',
    'asfissiatoti',
    'asfissiava',
    'asfissiavamo',
    'asfissiavano',
    'asfissiavate',
    'asfissiavi',
    'asfissiavo',
    'asfissie',
    'asfissiera',
    'asfissierai',
    'asfissierei',
    'asfissieremo',
    'asfissierete',
    'asfissiero',
    'asfissino',
    'asfissio',
    'asfittica',
    'asfittiche',
    'asfittici',
    'asfittico',
    'asfodeli',
    'asfodelo',
    'ashanti',
    'ashkenazita',
    'ashkenazite',
    'ashkenaziti',
    'ashkenazy',
    'asia',
    'asiaca',
    'asiache',
    'asiaci',
    'asiaco',
    'asiago',
    'asialia',
    'asialie',
    'asiana',
    'asiane',
    'asianesimi',
    'asianesimo',
    'asiani',
    'asianismi',
    'asianismo',
    'asiano',
    'asiatica',
    'asiatiche',
    'asiatici',
    'asiatico',
    'asienti',
    'asiento',
    'asigmatica',
    'asigmatiche',
    'asigmatici',
    'asigmatico',
    'asili',
    'asillabica',
    'asillabiche',
    'asillabici',
    'asillabico',
    'asilo',
    'asima',
    'asime',
    'asimmetria',
    'asimmetrica',
    'asimmetriche',
    'asimmetrici',
    'asimmetrico',
    'asimmetrie',
    'asimmmetria',
    'asina',
    'asinacci',
    'asinaccio',
    'asinaggine',
    'asinaggini',
    'asinai',
    'asinaia',
    'asinaie',
    'asinaio',
    'asinamente',
    'asinarteta',
    'asinartete',
    'asinarteti',
    'asinarteto',
    'asinata',
    'asinate',
    'asincrona',
    'asincrone',
    'asincroni',
    'asincronia',
    'asincronie',
    'asincronismi',
    'asincronismo',
    'asincrono',
    'asindeti',
    'asindetica',
    'asindetiche',
    'asindetici',
    'asindetico',
    'asindeto',
    'asine',
    'asineggera',
    'asineggerai',
    'asineggerei',
    'asineggeremo',
    'asineggerete',
    'asineggero',
    'asineggi',
    'asineggia',
    'asineggiai',
    'asineggiammo',
    'asineggiamo',
    'asineggiando',
    'asineggiano',
    'asineggiante',
    'asineggianti',
    'asineggiare',
    'asineggiasse',
    'asineggiassi',
    'asineggiaste',
    'asineggiasti',
    'asineggiata',
    'asineggiate',
    'asineggiati',
    'asineggiato',
    'asineggiava',
    'asineggiavi',
    'asineggiavo',
    'asineggino',
    'asineggio',
    'asinella',
    'asinelle',
    'asinelli',
    'asinello',
    'asinergia',
    'asinergie',
    'asineria',
    'asinerie',
    'asinesca',
    'asinesche',
    'asineschi',
    'asinesco',
    'asini',
    'asinina',
    'asininamente',
    'asinine',
    'asinini',
    'asinino',
    'asinita',
    'asinità',
    'asino',
    'asintattica',
    'asintattiche',
    'asintattici',
    'asintattico',
    'asintomatica',
    'asintomatici',
    'asintomatico',
    'asintoti',
    'asintotica',
    'asintotiche',
    'asintotici',
    'asintotico',
    'asintoto',
    'asismica',
    'asismiche',
    'asismici',
    'asismico',
    'asistolia',
    'askenazita',
    'askenazite',
    'askenaziti',
    'asma',
    'asmara',
    'asmarino',
    'asmaro',
    'asmatica',
    'asmatiche',
    'asmatici',
    'asmatico',
    'asme',
    'asmerino',
    'asmi',
    'asmogena',
    'asmogene',
    'asmogeni',
    'asmogeno',
    'asociale',
    'asociali',
    'asocialita',
    'asocialità',
    'asocialmente',
    'asola',
    'asolai',
    'asolaia',
    'asolaie',
    'asolammo',
    'asolando',
    'asolano',
    'asolante',
    'asolanti',
    'asolare',
    'asolarono',
    'asolasse',
    'asolassero',
    'asolassi',
    'asolassimo',
    'asolaste',
    'asolasti',
    'asolata',
    'asolate',
    'asolati',
    'asolato',
    'asolatrice',
    'asolatrici',
    'asolava',
    'asolavamo',
    'asolavano',
    'asolavate',
    'asolavi',
    'asolavo',
    'asole',
    'asolera',
    'asolerai',
    'asoleranno',
    'asolerebbe',
    'asolerebbero',
    'asolerei',
    'asoleremmo',
    'asoleremo',
    'asolereste',
    'asoleresti',
    'asolerete',
    'asolero',
    'asoli',
    'asoliamo',
    'asoliate',
    'asolino',
    'asolo',
    'asotomia',
    'aspa',
    'asparagacea',
    'asparagacee',
    'asparageti',
    'asparageto',
    'asparagi',
    'asparagiaia',
    'asparagiaie',
    'asparagina',
    'asparagine',
    'asparagio',
    'asparago',
    'asparre',
    'aspasia',
    'aspasio',
    'aspata',
    'aspate',
    'aspatoi',
    'aspatoio',
    'aspatore',
    'aspatori',
    'aspatrice',
    'aspatrici',
    'aspatura',
    'aspature',
    'aspe',
    'aspecifica',
    'aspecifiche',
    'aspecifici',
    'aspecifico',
    'asperella',
    'asperelle',
    'asperga',
    'aspergano',
    'asperge',
    'aspergemmo',
    'aspergendo',
    'aspergente',
    'aspergenti',
    'aspergera',
    'aspergerai',
    'aspergeranno',
    'aspergere',
    'aspergerebbe',
    'aspergerei',
    'aspergeremmo',
    'aspergeremo',
    'aspergereste',
    'aspergeresti',
    'aspergerete',
    'aspergero',
    'asperges',
    'aspergesse',
    'aspergessero',
    'aspergessi',
    'aspergessimo',
    'aspergeste',
    'aspergesti',
    'aspergete',
    'aspergeva',
    'aspergevamo',
    'aspergevano',
    'aspergevate',
    'aspergevi',
    'aspergevo',
    'aspergi',
    'aspergiamo',
    'aspergiate',
    'aspergilli',
    'aspergillo',
    'aspergillosi',
    'aspergillus',
    'aspergo',
    'aspergono',
    'asperita',
    'asperità',
    'aspermia',
    'aspermie',
    'aspero',
    'asperrima',
    'asperrime',
    'asperrimi',
    'asperrimo',
    'aspersa',
    'asperse',
    'aspersero',
    'aspersi',
    'aspersione',
    'aspersioni',
    'asperso',
    'aspersori',
    'aspersorio',
    'asperula',
    'asperule',
    'aspetta',
    'aspettabile',
    'aspettabili',
    'aspettaci',
    'aspettai',
    'aspettala',
    'aspettale',
    'aspettali',
    'aspettalo',
    'aspettami',
    'aspettammo',
    'aspettando',
    'aspettandoci',
    'aspettandola',
    'aspettandole',
    'aspettandoli',
    'aspettandolo',
    'aspettandomi',
    'aspettandone',
    'aspettandosi',
    'aspettandoti',
    'aspettandovi',
    'aspettano',
    'aspettante',
    'aspettanti',
    'aspettantisi',
    'aspettanza',
    'aspettanze',
    'aspettar',
    'aspettarcela',
    'aspettarcelo',
    'aspettarci',
    'aspettare',
    'aspettarla',
    'aspettarle',
    'aspettarli',
    'aspettarlo',
    'aspettarmela',
    'aspettarmelo',
    'aspettarmi',
    'aspettarne',
    'aspettarono',
    'aspettarsela',
    'aspettarselo',
    'aspettarsi',
    'aspettartela',
    'aspettartelo',
    'aspettarti',
    'aspettarvela',
    'aspettarvelo',
    'aspettarvi',
    'aspettasse',
    'aspettassero',
    'aspettassi',
    'aspettassimo',
    'aspettaste',
    'aspettasti',
    'aspettata',
    'aspettate',
    'aspettateci',
    'aspettatela',
    'aspettatele',
    'aspettateli',
    'aspettatelo',
    'aspettatemi',
    'aspettatevi',
    'aspettati',
    'aspettativa',
    'aspettative',
    'aspettato',
    'aspettatomi',
    'aspettatoti',
    'aspettava',
    'aspettavamo',
    'aspettavano',
    'aspettavate',
    'aspettavi',
    'aspettavo',
    'aspettazione',
    'aspettazioni',
    'aspettera',
    'aspetterai',
    'aspetteranno',
    'aspetterebbe',
    'aspetterei',
    'aspetteremmo',
    'aspetteremo',
    'aspettereste',
    'aspetteresti',
    'aspetterete',
    'aspettero',
    'aspetterò',
    'aspetti',
    'aspettiamo',
    'aspettiamoci',
    'aspettiamola',
    'aspettiamole',
    'aspettiamoli',
    'aspettiamolo',
    'aspettiate',
    'aspettino',
    'aspetto',
    'aspettuale',
    'aspettuali',
    'aspi',
    'aspic',
    'aspide',
    'aspidi',
    'aspidistra',
    'aspidistre',
    'aspido',
    'aspira',
    'aspirai',
    'aspirammo',
    'aspirando',
    'aspirandola',
    'aspirandole',
    'aspirandoli',
    'aspirandolo',
    'aspirano',
    'aspirante',
    'aspiranti',
    'aspirare',
    'aspirarla',
    'aspirarle',
    'aspirarli',
    'aspirarlo',
    'aspirarono',
    'aspirasse',
    'aspirassero',
    'aspirassi',
    'aspirassimo',
    'aspiraste',
    'aspirasti',
    'aspirata',
    'aspirate',
    'aspirati',
    'aspirativa',
    'aspirato',
    'aspiratore',
    'aspiratori',
    'aspirava',
    'aspiravamo',
    'aspiravano',
    'aspiravate',
    'aspiravi',
    'aspiravo',
    'aspirazione',
    'aspirazioni',
    'aspirera',
    'aspirerai',
    'aspireranno',
    'aspirerebbe',
    'aspirerei',
    'aspireremmo',
    'aspireremo',
    'aspirereste',
    'aspireresti',
    'aspirerete',
    'aspirero',
    'aspirerò',
    'aspiri',
    'aspiriamo',
    'aspiriate',
    'aspirina',
    'aspirine',
    'aspirino',
    'aspiro',
    'aspleni',
    'asplenio',
    'aspo',
    'asporigeni',
    'asporta',
    'asportabile',
    'asportabili',
    'asportai',
    'asportammo',
    'asportando',
    'asportandola',
    'asportandole',
    'asportandoli',
    'asportandolo',
    'asportano',
    'asportante',
    'asportanti',
    'asportare',
    'asportarla',
    'asportarle',
    'asportarli',
    'asportarlo',
    'asportarono',
    'asportasse',
    'asportassero',
    'asportassi',
    'asportassimo',
    'asportaste',
    'asportasti',
    'asportata',
    'asportate',
    'asportati',
    'asportativa',
    'asportato',
    'asportava',
    'asportavamo',
    'asportavano',
    'asportavate',
    'asportavi',
    'asportavo',
    'asportazione',
    'asportazioni',
    'asportera',
    'asporterai',
    'asporteranno',
    'asporterebbe',
    'asporterei',
    'asporteremmo',
    'asporteremo',
    'asportereste',
    'asporteresti',
    'asporterete',
    'asportero',
    'asporti',
    'asportiamo',
    'asportiate',
    'asportino',
    'asporto',
    'aspra',
    'aspramente',
    'aspre',
    'aspreggera',
    'aspreggerai',
    'aspreggerei',
    'aspreggeremo',
    'aspreggerete',
    'aspreggero',
    'aspreggi',
    'aspreggia',
    'aspreggiai',
    'aspreggiammo',
    'aspreggiamo',
    'aspreggiando',
    'aspreggiano',
    'aspreggiante',
    'aspreggianti',
    'aspreggiare',
    'aspreggiasse',
    'aspreggiassi',
    'aspreggiaste',
    'aspreggiasti',
    'aspreggiata',
    'aspreggiate',
    'aspreggiati',
    'aspreggiato',
    'aspreggiava',
    'aspreggiavi',
    'aspreggiavo',
    'aspreggino',
    'aspreggio',
    'asprella',
    'asprelle',
    'aspretta',
    'asprette',
    'aspretti',
    'aspretto',
    'asprezza',
    'asprezze',
    'aspri',
    'asprigna',
    'asprigne',
    'asprigni',
    'asprigno',
    'asprina',
    'asprine',
    'asprini',
    'asprino',
    'asprissima',
    'asprissime',
    'asprissimi',
    'asprissimo',
    'aspro',
    'aspromonte',
    'asprucce',
    'asprucci',
    'aspruccia',
    'aspruccio',
    'asquino',
    'assabgui',
    'assad',
    'assaetta',
    'assaettai',
    'assaettammo',
    'assaettando',
    'assaettano',
    'assaettante',
    'assaettanti',
    'assaettarci',
    'assaettare',
    'assaettarmi',
    'assaettarono',
    'assaettarsi',
    'assaettarti',
    'assaettarvi',
    'assaettasse',
    'assaettassi',
    'assaettaste',
    'assaettasti',
    'assaettata',
    'assaettate',
    'assaettatevi',
    'assaettati',
    'assaettato',
    'assaettatomi',
    'assaettatoti',
    'assaettava',
    'assaettavamo',
    'assaettavano',
    'assaettavate',
    'assaettavi',
    'assaettavo',
    'assaettera',
    'assaetterai',
    'assaetterei',
    'assaetteremo',
    'assaetterete',
    'assaettero',
    'assaetti',
    'assaettiamo',
    'assaettiate',
    'assaettino',
    'assaetto',
    'assafetida',
    'assafetide',
    'assaggera',
    'assaggerai',
    'assaggeranno',
    'assaggerebbe',
    'assaggerei',
    'assaggeremmo',
    'assaggeremo',
    'assaggereste',
    'assaggeresti',
    'assaggerete',
    'assaggero',
    'assaggi',
    'assaggia',
    'assaggiai',
    'assaggiala',
    'assaggiale',
    'assaggiali',
    'assaggialo',
    'assaggiammo',
    'assaggiamo',
    'assaggiamola',
    'assaggiamole',
    'assaggiamoli',
    'assaggiamolo',
    'assaggiando',
    'assaggiano',
    'assaggiante',
    'assaggianti',
    'assaggiare',
    'assaggiarla',
    'assaggiarle',
    'assaggiarli',
    'assaggiarlo',
    'assaggiarne',
    'assaggiarono',
    'assaggiasse',
    'assaggiassi',
    'assaggiaste',
    'assaggiasti',
    'assaggiata',
    'assaggiate',
    'assaggiatela',
    'assaggiatele',
    'assaggiateli',
    'assaggiatelo',
    'assaggiati',
    'assaggiato',
    'assaggiatolo',
    'assaggiatore',
    'assaggiatori',
    'assaggiatura',
    'assaggiature',
    'assaggiava',
    'assaggiavamo',
    'assaggiavano',
    'assaggiavate',
    'assaggiavi',
    'assaggiavo',
    'assaggini',
    'assaggino',
    'assaggio',
    'assago',
    'assai',
    'assaissimo',
    'assale',
    'assalendo',
    'assalendoci',
    'assalendola',
    'assalendole',
    'assalendoli',
    'assalendolo',
    'assalendomi',
    'assalendoti',
    'assalendovi',
    'assalente',
    'assalenti',
    'assalga',
    'assalgano',
    'assalgo',
    'assalgono',
    'assali',
    'assaliamo',
    'assaliate',
    'assalii',
    'assalimenti',
    'assalimento',
    'assalimmo',
    'assalira',
    'assalirai',
    'assaliranno',
    'assalirci',
    'assalire',
    'assalirebbe',
    'assalirei',
    'assaliremmo',
    'assaliremo',
    'assalireste',
    'assaliresti',
    'assalirete',
    'assalirla',
    'assalirle',
    'assalirli',
    'assalirlo',
    'assalirmi',
    'assaliro',
    'assalirono',
    'assalirti',
    'assalirvi',
    'assalisca',
    'assaliscano',
    'assalisce',
    'assalisci',
    'assalisco',
    'assaliscono',
    'assalisse',
    'assalissero',
    'assalissi',
    'assalissimo',
    'assaliste',
    'assalisti',
    'assalita',
    'assalite',
    'assaliti',
    'assalito',
    'assalitore',
    'assalitori',
    'assalitrice',
    'assalitrici',
    'assaliva',
    'assalivamo',
    'assalivano',
    'assalivate',
    'assalivi',
    'assalivo',
    'assalonne',
    'assalsi',
    'assalta',
    'assaltai',
    'assaltammo',
    'assaltando',
    'assaltano',
    'assaltante',
    'assaltanti',
    'assaltare',
    'assaltarono',
    'assaltasse',
    'assaltassero',
    'assaltassi',
    'assaltassimo',
    'assaltaste',
    'assaltasti',
    'assaltata',
    'assaltate',
    'assaltati',
    'assaltato',
    'assaltatore',
    'assaltatori',
    'assaltatrice',
    'assaltatrici',
    'assaltava',
    'assaltavamo',
    'assaltavano',
    'assaltavate',
    'assaltavi',
    'assaltavo',
    'assaltera',
    'assalterai',
    'assalteranno',
    'assalterebbe',
    'assalterei',
    'assalteremmo',
    'assalteremo',
    'assaltereste',
    'assalteresti',
    'assalterete',
    'assaltero',
    'assalterò',
    'assalti',
    'assaltiamo',
    'assaltiate',
    'assaltino',
    'assalto',
    'assannare',
    'assapora',
    'assaporai',
    'assaporammo',
    'assaporando',
    'assaporano',
    'assaporante',
    'assaporanti',
    'assaporare',
    'assaporarono',
    'assaporasse',
    'assaporassi',
    'assaporaste',
    'assaporasti',
    'assaporata',
    'assaporate',
    'assaporati',
    'assaporato',
    'assaporava',
    'assaporavamo',
    'assaporavano',
    'assaporavate',
    'assaporavi',
    'assaporavo',
    'assaporendo',
    'assaporente',
    'assaporenti',
    'assaporera',
    'assaporerai',
    'assaporerei',
    'assaporeremo',
    'assaporerete',
    'assaporero',
    'assapori',
    'assaporiamo',
    'assaporiate',
    'assaporii',
    'assaporimmo',
    'assaporino',
    'assaporira',
    'assaporirai',
    'assaporire',
    'assaporirei',
    'assaporiremo',
    'assaporirete',
    'assaporiro',
    'assaporirono',
    'assaporisca',
    'assaporisce',
    'assaporisci',
    'assaporisco',
    'assaporisse',
    'assaporissi',
    'assaporiste',
    'assaporisti',
    'assaporita',
    'assaporite',
    'assaporiti',
    'assaporito',
    'assaporiva',
    'assaporivamo',
    'assaporivano',
    'assaporivate',
    'assaporivi',
    'assaporivo',
    'assaporo',
    'assassina',
    'assassinai',
    'assassinammo',
    'assassinando',
    'assassinano',
    'assassinante',
    'assassinanti',
    'assassinarci',
    'assassinare',
    'assassinarla',
    'assassinarle',
    'assassinarli',
    'assassinarlo',
    'assassinarmi',
    'assassinarti',
    'assassinarvi',
    'assassinasse',
    'assassinassi',
    'assassinaste',
    'assassinasti',
    'assassinata',
    'assassinate',
    'assassinati',
    'assassinato',
    'assassinava',
    'assassinavi',
    'assassinavo',
    'assassine',
    'assassinera',
    'assassinerai',
    'assassinerei',
    'assassinero',
    'assassini',
    'assassiniamo',
    'assassiniate',
    'assassinii',
    'assassinino',
    'assassinio',
    'assassino',
    'assatanata',
    'assatanate',
    'assatanati',
    'assatanato',
    'asse',
    'assecchi',
    'assecco',
    'asseconda',
    'assecondai',
    'assecondammo',
    'assecondando',
    'assecondano',
    'assecondante',
    'assecondanti',
    'assecondarci',
    'assecondare',
    'assecondarla',
    'assecondarle',
    'assecondarli',
    'assecondarlo',
    'assecondarmi',
    'assecondarne',
    'assecondarti',
    'assecondarvi',
    'assecondasse',
    'assecondassi',
    'assecondaste',
    'assecondasti',
    'assecondata',
    'assecondate',
    'assecondati',
    'assecondato',
    'assecondava',
    'assecondavi',
    'assecondavo',
    'assecondera',
    'asseconderai',
    'asseconderei',
    'assecondero',
    'asseconderò',
    'assecondi',
    'assecondiamo',
    'assecondiate',
    'assecondino',
    'assecondo',
    'assecurare',
    'assede',
    'assedei',
    'assedemmo',
    'assedendo',
    'assedendosi',
    'assedentesi',
    'assedentisi',
    'assedera',
    'assederai',
    'assederanno',
    'assedere',
    'assederebbe',
    'assederei',
    'assederemmo',
    'assederemo',
    'assedereste',
    'assederesti',
    'assederete',
    'assedero',
    'assederono',
    'assedersi',
    'assedesse',
    'assedessero',
    'assedessi',
    'assedessimo',
    'assedeste',
    'assedesti',
    'assedete',
    'assedetevi',
    'assedette',
    'assedettero',
    'assedetti',
    'assedeva',
    'assedevamo',
    'assedevano',
    'assedevate',
    'assedevi',
    'assedevo',
    'assedi',
    'assedia',
    'assediai',
    'assediammo',
    'assediamo',
    'assediamoci',
    'assediando',
    'assediano',
    'assediante',
    'assedianti',
    'assediare',
    'assediarono',
    'assediasse',
    'assediassero',
    'assediassi',
    'assediassimo',
    'assediaste',
    'assediasti',
    'assediata',
    'assediate',
    'assediati',
    'assediato',
    'assediatore',
    'assediatori',
    'assediatrice',
    'assediatrici',
    'assediava',
    'assediavamo',
    'assediavano',
    'assediavate',
    'assediavi',
    'assediavo',
    'assediera',
    'assedierai',
    'assedieranno',
    'assedierebbe',
    'assedierei',
    'assedieremmo',
    'assedieremo',
    'assediereste',
    'assedieresti',
    'assedierete',
    'assediero',
    'assedierò',
    'assedino',
    'assedio',
    'asseduta',
    'assedute',
    'asseduti',
    'asseduto',
    'assefa',
    'assegna',
    'assegnabile',
    'assegnabili',
    'assegnai',
    'assegnamenti',
    'assegnamento',
    'assegnammo',
    'assegnamo',
    'assegnando',
    'assegnandoci',
    'assegnandola',
    'assegnandole',
    'assegnandoli',
    'assegnandolo',
    'assegnandomi',
    'assegnandone',
    'assegnandoti',
    'assegnandovi',
    'assegnano',
    'assegnante',
    'assegnanti',
    'assegnarci',
    'assegnare',
    'assegnargli',
    'assegnarla',
    'assegnarle',
    'assegnarli',
    'assegnarlo',
    'assegnarmene',
    'assegnarmi',
    'assegnarne',
    'assegnarono',
    'assegnarti',
    'assegnarvi',
    'assegnasse',
    'assegnassero',
    'assegnassi',
    'assegnassimo',
    'assegnaste',
    'assegnasti',
    'assegnata',
    'assegnatagli',
    'assegnatami',
    'assegnatari',
    'assegnataria',
    'assegnatarie',
    'assegnatario',
    'assegnate',
    'assegnati',
    'assegnatigli',
    'assegnato',
    'assegnatogli',
    'assegnatole',
    'assegnatore',
    'assegnatori',
    'assegnatrice',
    'assegnatrici',
    'assegnava',
    'assegnavamo',
    'assegnavano',
    'assegnavate',
    'assegnavi',
    'assegnavo',
    'assegnazione',
    'assegnazioni',
    'assegnera',
    'assegnerai',
    'assegneranno',
    'assegnerebbe',
    'assegnerei',
    'assegneremmo',
    'assegneremo',
    'assegnereste',
    'assegneresti',
    'assegnerete',
    'assegnero',
    'assegnerò',
    'assegni',
    'assegniamo',
    'assegniate',
    'assegnino',
    'assegnista',
    'assegniste',
    'assegnisti',
    'assegno',
    'assegua',
    'asseguano',
    'assegue',
    'asseguendo',
    'asseguente',
    'asseguenti',
    'assegui',
    'asseguiamo',
    'asseguiate',
    'asseguii',
    'asseguimmo',
    'asseguira',
    'asseguirai',
    'asseguiranno',
    'asseguire',
    'asseguirebbe',
    'asseguirei',
    'asseguiremmo',
    'asseguiremo',
    'asseguireste',
    'asseguiresti',
    'asseguirete',
    'asseguiro',
    'asseguirono',
    'asseguisse',
    'asseguissero',
    'asseguissi',
    'asseguissimo',
    'asseguiste',
    'asseguisti',
    'asseguita',
    'asseguite',
    'asseguiti',
    'asseguito',
    'asseguiva',
    'asseguivamo',
    'asseguivano',
    'asseguivate',
    'asseguivi',
    'asseguivo',
    'asseguo',
    'asseguono',
    'asseltine',
    'assembla',
    'assemblage',
    'assemblaggi',
    'assemblaggio',
    'assemblai',
    'assemblammo',
    'assemblando',
    'assemblano',
    'assemblante',
    'assemblanti',
    'assemblare',
    'assemblarono',
    'assemblasse',
    'assemblassi',
    'assemblaste',
    'assemblasti',
    'assemblata',
    'assemblate',
    'assemblati',
    'assemblato',
    'assemblatore',
    'assemblatori',
    'assemblava',
    'assemblavamo',
    'assemblavano',
    'assemblavate',
    'assemblavi',
    'assemblavo',
    'assemblea',
    'assembleante',
    'assembleare',
    'assembleari',
    'assemblee',
    'assemblera',
    'assemblerai',
    'assemblerei',
    'assembleremo',
    'assemblerete',
    'assemblero',
    'assemblerò',
    'assembli',
    'assembliamo',
    'assembliate',
    'assemblino',
    'assemblo',
    'assembra',
    'assembrai',
    'assembrammo',
    'assembrando',
    'assembrano',
    'assembrante',
    'assembranti',
    'assembrarci',
    'assembrare',
    'assembrarmi',
    'assembrarono',
    'assembrarsi',
    'assembrarti',
    'assembrarvi',
    'assembrasse',
    'assembrassi',
    'assembraste',
    'assembrasti',
    'assembrata',
    'assembrate',
    'assembratevi',
    'assembrati',
    'assembrato',
    'assembratomi',
    'assembratoti',
    'assembrava',
    'assembravamo',
    'assembravano',
    'assembravate',
    'assembravi',
    'assembravo',
    'assembrera',
    'assembrerai',
    'assembrerei',
    'assembreremo',
    'assembrerete',
    'assembrero',
    'assembri',
    'assembriamo',
    'assembriate',
    'assembrino',
    'assembro',
    'assempio',
    'assemplare',
    'assemplo',
    'assemprando',
    'assemprare',
    'assemprato',
    'assempri',
    'assempro',
    'assenna',
    'assennai',
    'assennammo',
    'assennando',
    'assennano',
    'assennante',
    'assennanti',
    'assennare',
    'assennarono',
    'assennasse',
    'assennassero',
    'assennassi',
    'assennassimo',
    'assennaste',
    'assennasti',
    'assennata',
    'assennate',
    'assennatezza',
    'assennatezze',
    'assennati',
    'assennato',
    'assennava',
    'assennavamo',
    'assennavano',
    'assennavate',
    'assennavi',
    'assennavo',
    'assennera',
    'assennerai',
    'assenneranno',
    'assennerebbe',
    'assennerei',
    'assenneremmo',
    'assenneremo',
    'assennereste',
    'assenneresti',
    'assennerete',
    'assennero',
    'assenni',
    'assenniamo',
    'assenniate',
    'assennino',
    'assenno',
    'assensi',
    'assenso',
    'assenta',
    'assentai',
    'assentammo',
    'assentando',
    'assentandoci',
    'assentandomi',
    'assentandosi',
    'assentandoti',
    'assentandovi',
    'assentano',
    'assentante',
    'assentanti',
    'assentantisi',
    'assentarci',
    'assentare',
    'assentarmi',
    'assentarono',
    'assentarsi',
    'assentarti',
    'assentarvi',
    'assentasse',
    'assentassero',
    'assentassi',
    'assentassimo',
    'assentaste',
    'assentasti',
    'assentata',
    'assentate',
    'assentatevi',
    'assentati',
    'assentato',
    'assentatomi',
    'assentatoti',
    'assentava',
    'assentavamo',
    'assentavano',
    'assentavate',
    'assentavi',
    'assentavo',
    'assente',
    'assenteismi',
    'assenteismo',
    'assenteista',
    'assenteiste',
    'assenteisti',
    'assentendo',
    'assentente',
    'assentera',
    'assenterai',
    'assenteranno',
    'assenterebbe',
    'assenterei',
    'assenteremmo',
    'assenteremo',
    'assentereste',
    'assenteresti',
    'assenterete',
    'assentero',
    'assenterò',
    'assenti',
    'assentiamo',
    'assentiamoci',
    'assentiate',
    'assentii',
    'assentimenti',
    'assentimento',
    'assentimmo',
    'assentino',
    'assentira',
    'assentirai',
    'assentiranno',
    'assentire',
    'assentirebbe',
    'assentirei',
    'assentiremmo',
    'assentiremo',
    'assentireste',
    'assentiresti',
    'assentirete',
    'assentiro',
    'assentirono',
    'assentirà',
    'assentirò',
    'assentisse',
    'assentissero',
    'assentissi',
    'assentissimo',
    'assentiste',
    'assentisti',
    'assentita',
    'assentite',
    'assentiti',
    'assentito',
    'assentiva',
    'assentivamo',
    'assentivano',
    'assentivate',
    'assentivi',
    'assentivo',
    'assento',
    'assentono',
    'assenza',
    'assenze',
    'assenzi',
    'assenziente',
    'assenzienti',
    'assenzio',
    'assenzo',
    'asserena',
    'asserenando',
    'asserenano',
    'asserenante',
    'asserenare',
    'asserenata',
    'asserenate',
    'asserenati',
    'asserenato',
    'asserendo',
    'asserendolo',
    'asserente',
    'asserenti',
    'asseri',
    'asseriamo',
    'asseriate',
    'asserii',
    'asserimenti',
    'asserimento',
    'asserimmo',
    'asserira',
    'asserirai',
    'asseriranno',
    'asserire',
    'asserirebbe',
    'asserirei',
    'asseriremmo',
    'asseriremo',
    'asserireste',
    'asseriresti',
    'asserirete',
    'asserirlo',
    'asserirne',
    'asseriro',
    'asserirono',
    'asserirsi',
    'asserirà',
    'asserirò',
    'asserisca',
    'asseriscano',
    'asserisce',
    'asserisci',
    'asserisco',
    'asseriscono',
    'asserisse',
    'asserissero',
    'asserissi',
    'asserissimo',
    'asseriste',
    'asseristi',
    'asserita',
    'asserite',
    'asseriti',
    'asserito',
    'asseriva',
    'asserivamo',
    'asserivano',
    'asserivate',
    'asserivi',
    'asserivo',
    'assero',
    'asserpola',
    'asserpolai',
    'asserpolammo',
    'asserpolando',
    'asserpolano',
    'asserpolarci',
    'asserpolare',
    'asserpolarmi',
    'asserpolarsi',
    'asserpolarti',
    'asserpolarvi',
    'asserpolasse',
    'asserpolassi',
    'asserpolaste',
    'asserpolasti',
    'asserpolata',
    'asserpolate',
    'asserpolati',
    'asserpolato',
    'asserpolava',
    'asserpolavi',
    'asserpolavo',
    'asserpolera',
    'asserpolerai',
    'asserpolerei',
    'asserpolero',
    'asserpoli',
    'asserpoliamo',
    'asserpoliate',
    'asserpolii',
    'asserpolino',
    'asserpolio',
    'asserpolo',
    'asserragli',
    'asserraglia',
    'asserragliai',
    'asserraglino',
    'asserraglio',
    'asserti',
    'assertiva',
    'assertive',
    'assertivi',
    'assertivista',
    'assertiviste',
    'assertivisti',
    'assertivita',
    'assertività',
    'assertivo',
    'asserto',
    'assertore',
    'assertori',
    'assertoria',
    'assertorie',
    'assertorio',
    'assertrice',
    'assertrici',
    'asservendo',
    'asservendoci',
    'asservendomi',
    'asservendosi',
    'asservendoti',
    'asservendovi',
    'asservente',
    'asserventi',
    'asserventisi',
    'asservi',
    'asserviamo',
    'asserviamoci',
    'asserviate',
    'asservii',
    'asservimenti',
    'asservimento',
    'asservimmo',
    'asservira',
    'asservirai',
    'asserviranno',
    'asservirci',
    'asservire',
    'asservirebbe',
    'asservirei',
    'asserviremmo',
    'asserviremo',
    'asservireste',
    'asserviresti',
    'asservirete',
    'asservirmi',
    'asserviro',
    'asservirono',
    'asservirsi',
    'asservirti',
    'asservirvi',
    'asservirà',
    'asservirò',
    'asservisca',
    'asserviscano',
    'asservisce',
    'asservisci',
    'asservisciti',
    'asservisco',
    'asserviscono',
    'asservisse',
    'asservissero',
    'asservissi',
    'asservissimo',
    'asserviste',
    'asservisti',
    'asservita',
    'asservite',
    'asservitevi',
    'asserviti',
    'asservito',
    'asservitomi',
    'asservitoti',
    'asserviva',
    'asservivamo',
    'asservivano',
    'asservivate',
    'asservivi',
    'asservivo',
    'asserzione',
    'asserzioni',
    'assessora',
    'assessorati',
    'assessorato',
    'assessore',
    'assessorese',
    'assessori',
    'assessoriale',
    'assessoriali',
    'assessorile',
    'assessorili',
    'assesta',
    'assestai',
    'assestamenti',
    'assestamento',
    'assestammo',
    'assestando',
    'assestandoci',
    'assestandola',
    'assestandole',
    'assestandoli',
    'assestandolo',
    'assestandomi',
    'assestandosi',
    'assestandoti',
    'assestandovi',
    'assestano',
    'assestante',
    'assestanti',
    'assestantisi',
    'assestarci',
    'assestare',
    'assestarla',
    'assestarle',
    'assestarli',
    'assestarlo',
    'assestarmi',
    'assestarono',
    'assestarsi',
    'assestarti',
    'assestarvi',
    'assestasse',
    'assestassero',
    'assestassi',
    'assestassimo',
    'assestaste',
    'assestasti',
    'assestata',
    'assestate',
    'assestatevi',
    'assestatezza',
    'assestatezze',
    'assestati',
    'assestato',
    'assestatomi',
    'assestatoti',
    'assestava',
    'assestavamo',
    'assestavano',
    'assestavate',
    'assestavi',
    'assestavo',
    'assestera',
    'assesterai',
    'assesteranno',
    'assesterebbe',
    'assesterei',
    'assesteremmo',
    'assesteremo',
    'assestereste',
    'assesteresti',
    'assesterete',
    'assestero',
    'assesterò',
    'assesti',
    'assestiamo',
    'assestiamoci',
    'assestiate',
    'assestino',
    'assesto',
    'asseta',
    'assetai',
    'assetammo',
    'assetando',
    'assetano',
    'assetante',
    'assetanti',
    'assetare',
    'assetarono',
    'assetasse',
    'assetassero',
    'assetassi',
    'assetassimo',
    'assetaste',
    'assetasti',
    'assetata',
    'assetate',
    'assetati',
    'assetato',
    'assetava',
    'assetavamo',
    'assetavano',
    'assetavate',
    'assetavi',
    'assetavo',
    'assetera',
    'asseterai',
    'asseteranno',
    'asseterebbe',
    'asseterei',
    'asseteremmo',
    'asseteremo',
    'assetereste',
    'asseteresti',
    'asseterete',
    'assetero',
    'asseti',
    'assetiamo',
    'assetiate',
    'assetino',
    'asseto',
    'assetta',
    'assettai',
    'assettamenti',
    'assettamento',
    'assettammo',
    'assettando',
    'assettandoci',
    'assettandomi',
    'assettandosi',
    'assettandoti',
    'assettandovi',
    'assettano',
    'assettante',
    'assettanti',
    'assettantisi',
    'assettarci',
    'assettare',
    'assettarmi',
    'assettarono',
    'assettarsi',
    'assettarti',
    'assettarvi',
    'assettasse',
    'assettassero',
    'assettassi',
    'assettassimo',
    'assettaste',
    'assettasti',
    'assettata',
    'assettate',
    'assettatevi',
    'assettati',
    'assettato',
    'assettatomi',
    'assettatoti',
    'assettava',
    'assettavamo',
    'assettavano',
    'assettavate',
    'assettavi',
    'assettavo',
    'assettera',
    'assetterai',
    'assetteranno',
    'assetterebbe',
    'assetterei',
    'assetteremmo',
    'assetteremo',
    'assettereste',
    'assetteresti',
    'assetterete',
    'assettero',
    'assetti',
    'assettiamo',
    'assettiamoci',
    'assettiate',
    'assettino',
    'assetto',
    'assevera',
    'asseverai',
    'asseverammo',
    'asseverando',
    'asseverano',
    'asseverante',
    'asseveranti',
    'asseverare',
    'asseverarla',
    'asseverarlo',
    'asseverarono',
    'asseverasse',
    'asseverassi',
    'asseveraste',
    'asseverasti',
    'asseverata',
    'asseverate',
    'asseverati',
    'asseverativa',
    'asseverative',
    'asseverativi',
    'asseverativo',
    'asseverato',
    'asseverava',
    'asseveravamo',
    'asseveravano',
    'asseveravate',
    'asseveravi',
    'asseveravo',
    'asseverera',
    'assevererai',
    'assevererei',
    'assevereremo',
    'assevererete',
    'asseverero',
    'asseveri',
    'asseveriamo',
    'asseveriate',
    'asseverino',
    'assevero',
    'assi',
    'assiale',
    'assiali',
    'assialita',
    'assialmente',
    'assibila',
    'assibilai',
    'assibilammo',
    'assibilando',
    'assibilano',
    'assibilante',
    'assibilanti',
    'assibilarci',
    'assibilare',
    'assibilarmi',
    'assibilarono',
    'assibilarsi',
    'assibilarti',
    'assibilarvi',
    'assibilasse',
    'assibilassi',
    'assibilaste',
    'assibilasti',
    'assibilata',
    'assibilate',
    'assibilatevi',
    'assibilati',
    'assibilato',
    'assibilatomi',
    'assibilatoti',
    'assibilava',
    'assibilavamo',
    'assibilavano',
    'assibilavate',
    'assibilavi',
    'assibilavo',
    'assibilera',
    'assibilerai',
    'assibilerei',
    'assibileremo',
    'assibilerete',
    'assibilero',
    'assibili',
    'assibiliamo',
    'assibiliate',
    'assibilino',
    'assibilo',
    'assicella',
    'assicellati',
    'assicellato',
    'assicelle',
    'assicina',
    'assicine',
    'assicura',
    'assicurabile',
    'assicurabili',
    'assicurai',
    'assicurammo',
    'assicurando',
    'assicurano',
    'assicurante',
    'assicuranti',
    'assicurarci',
    'assicurare',
    'assicurarla',
    'assicurarle',
    'assicurarli',
    'assicurarlo',
    'assicurarmi',
    'assicurarne',
    'assicurarono',
    'assicurarsi',
    'assicurarti',
    'assicurarvi',
    'assicurasse',
    'assicurassi',
    'assicuraste',
    'assicurasti',
    'assicurata',
    'assicurate',
    'assicuratevi',
    'assicurati',
    'assicurativa',
    'assicurative',
    'assicurativi',
    'assicurativo',
    'assicurato',
    'assicuratomi',
    'assicuratore',
    'assicuratori',
    'assicuratoti',
    'assicurava',
    'assicuravamo',
    'assicuravano',
    'assicuravate',
    'assicuravi',
    'assicuravo',
    'assicurera',
    'assicurerai',
    'assicurerei',
    'assicureremo',
    'assicurerete',
    'assicurero',
    'assicurerò',
    'assicuri',
    'assicuriamo',
    'assicuriate',
    'assicurino',
    'assicuro',
    'assida',
    'assidano',
    'asside',
    'assidemmo',
    'assidendo',
    'assidendosi',
    'assidente',
    'assidenti',
    'assidera',
    'assiderai',
    'assiderammo',
    'assiderando',
    'assideranno',
    'assiderano',
    'assiderante',
    'assideranti',
    'assiderarci',
    'assiderare',
    'assiderarmi',
    'assiderarono',
    'assiderarsi',
    'assiderarti',
    'assiderarvi',
    'assiderasse',
    'assiderassi',
    'assideraste',
    'assiderasti',
    'assiderata',
    'assiderate',
    'assideratevi',
    'assiderati',
    'assiderato',
    'assideratomi',
    'assideratoti',
    'assiderava',
    'assideravamo',
    'assideravano',
    'assideravate',
    'assideravi',
    'assideravo',
    'assidere',
    'assiderebbe',
    'assiderei',
    'assideremmo',
    'assideremo',
    'assiderera',
    'assidererai',
    'assidererei',
    'assidereremo',
    'assidererete',
    'assiderero',
    'assidereste',
    'assideresti',
    'assiderete',
    'assideri',
    'assideriamo',
    'assideriate',
    'assiderino',
    'assidero',
    'assidersi',
    'assidesse',
    'assidessero',
    'assidessi',
    'assidessimo',
    'assideste',
    'assidesti',
    'assidete',
    'assideva',
    'assidevamo',
    'assidevano',
    'assidevate',
    'assidevi',
    'assidevo',
    'assidi',
    'assidiamo',
    'assidiate',
    'assido',
    'assidono',
    'assidua',
    'assiduamente',
    'assidue',
    'assidui',
    'assiduita',
    'assiduità',
    'assiduo',
    'assieda',
    'assiedano',
    'assiede',
    'assiederebbe',
    'assiederei',
    'assiederemmo',
    'assiedereste',
    'assiederesti',
    'assiedi',
    'assiediti',
    'assiedo',
    'assiedono',
    'assiemaggi',
    'assiemaggio',
    'assieme',
    'assiepa',
    'assiepai',
    'assiepamenti',
    'assiepamento',
    'assiepammo',
    'assiepando',
    'assiepandoci',
    'assiepandomi',
    'assiepandosi',
    'assiepandoti',
    'assiepandovi',
    'assiepano',
    'assiepante',
    'assiepanti',
    'assiepantisi',
    'assieparci',
    'assiepare',
    'assieparmi',
    'assieparono',
    'assieparsi',
    'assieparti',
    'assieparvi',
    'assiepasse',
    'assiepassero',
    'assiepassi',
    'assiepassimo',
    'assiepaste',
    'assiepasti',
    'assiepata',
    'assiepate',
    'assiepatevi',
    'assiepati',
    'assiepato',
    'assiepatomi',
    'assiepatoti',
    'assiepava',
    'assiepavamo',
    'assiepavano',
    'assiepavate',
    'assiepavi',
    'assiepavo',
    'assiepera',
    'assieperai',
    'assieperanno',
    'assieperebbe',
    'assieperei',
    'assieperemmo',
    'assieperemo',
    'assiepereste',
    'assieperesti',
    'assieperete',
    'assiepero',
    'assiepi',
    'assiepiamo',
    'assiepiamoci',
    'assiepiate',
    'assiepino',
    'assiepo',
    'assile',
    'assili',
    'assilla',
    'assillai',
    'assillammo',
    'assillando',
    'assillandoci',
    'assillandola',
    'assillandole',
    'assillandoli',
    'assillandolo',
    'assillandomi',
    'assillandoti',
    'assillandovi',
    'assillano',
    'assillante',
    'assillanti',
    'assillarci',
    'assillare',
    'assillarla',
    'assillarle',
    'assillarli',
    'assillarlo',
    'assillarmi',
    'assillarono',
    'assillarsi',
    'assillarti',
    'assillarvi',
    'assillasse',
    'assillassero',
    'assillassi',
    'assillassimo',
    'assillaste',
    'assillasti',
    'assillata',
    'assillate',
    'assillati',
    'assillato',
    'assillava',
    'assillavamo',
    'assillavano',
    'assillavate',
    'assillavi',
    'assillavo',
    'assillera',
    'assillerai',
    'assilleranno',
    'assillerebbe',
    'assillerei',
    'assilleremmo',
    'assilleremo',
    'assillereste',
    'assilleresti',
    'assillerete',
    'assillero',
    'assillerò',
    'assilli',
    'assilliamo',
    'assilliate',
    'assillino',
    'assillo',
    'assimigliare',
    'assimila',
    'assimilabile',
    'assimilabili',
    'assimilai',
    'assimilammo',
    'assimilando',
    'assimilano',
    'assimilante',
    'assimilanti',
    'assimilarci',
    'assimilare',
    'assimilarmi',
    'assimilarono',
    'assimilarsi',
    'assimilarti',
    'assimilarvi',
    'assimilasse',
    'assimilassi',
    'assimilaste',
    'assimilasti',
    'assimilata',
    'assimilate',
    'assimilatevi',
    'assimilati',
    'assimilativa',
    'assimilative',
    'assimilativi',
    'assimilativo',
    'assimilato',
    'assimilatomi',
    'assimilatore',
    'assimilatori',
    'assimilatoti',
    'assimilava',
    'assimilavamo',
    'assimilavano',
    'assimilavate',
    'assimilavi',
    'assimilavo',
    'assimilera',
    'assimilerai',
    'assimilerei',
    'assimileremo',
    'assimilerete',
    'assimilero',
    'assimili',
    'assimiliamo',
    'assimiliate',
    'assimilino',
    'assimilo',
    'assioli',
    'assiolo',
    'assiologia',
    'assiologica',
    'assiologiche',
    'assiologici',
    'assiologico',
    'assiologie',
    'assioma',
    'assiomatica',
    'assiomatiche',
    'assiomatici',
    'assiomatico',
    'assiomatizza',
    'assiomatizzi',
    'assiomatizzo',
    'assiometri',
    'assiometro',
    'assiomi',
    'assira',
    'assire',
    'assiri',
    'assiria',
    'assiriologa',
    'assiriologhe',
    'assiriologi',
    'assiriologia',
    'assiriologie',
    'assiriologo',
    'assiro',
    'assisa',
    'assise',
    'assisero',
    'assisi',
    'assisiate',
    'assisiati',
    'assiso',
    'assist',
    'assista',
    'assistano',
    'assiste',
    'assisted',
    'assistei',
    'assistemmo',
    'assistendo',
    'assistendoci',
    'assistendola',
    'assistendole',
    'assistendoli',
    'assistendolo',
    'assistendomi',
    'assistendoti',
    'assistendovi',
    'assistentati',
    'assistentato',
    'assistente',
    'assistenti',
    'assistenza',
    'assistenze',
    'assistera',
    'assisterai',
    'assisteranno',
    'assisterci',
    'assistere',
    'assisterebbe',
    'assisterei',
    'assisteremmo',
    'assisteremo',
    'assistereste',
    'assisteresti',
    'assisterete',
    'assisterla',
    'assisterle',
    'assisterli',
    'assisterlo',
    'assistermi',
    'assistero',
    'assisterono',
    'assistersi',
    'assisterti',
    'assistervi',
    'assisterò',
    'assistesse',
    'assistessero',
    'assistessi',
    'assistessimo',
    'assisteste',
    'assistesti',
    'assistete',
    'assisteteci',
    'assistetela',
    'assistetele',
    'assisteteli',
    'assistetelo',
    'assistetemi',
    'assistette',
    'assistettero',
    'assistetti',
    'assisteva',
    'assistevamo',
    'assistevano',
    'assistevate',
    'assistevi',
    'assistevo',
    'assisti',
    'assistiamo',
    'assistiamola',
    'assistiamole',
    'assistiamoli',
    'assistiamolo',
    'assistiate',
    'assistibile',
    'assistibili',
    'assistici',
    'assistila',
    'assistile',
    'assistili',
    'assistilo',
    'assistimi',
    'assistita',
    'assistite',
    'assistiti',
    'assistito',
    'assisto',
    'assistono',
    'assiti',
    'assito',
    'assiuolo',
    'asso',
    'assocera',
    'assocerai',
    'assoceranno',
    'assocerebbe',
    'assocerei',
    'assoceremmo',
    'assoceremo',
    'assocereste',
    'assoceresti',
    'assocerete',
    'assocero',
    'assocerò',
    'associ',
    'associa',
    'associabile',
    'associabili',
    'associai',
    'associamenti',
    'associamento',
    'associammo',
    'associamo',
    'associamoci',
    'associando',
    'associandoci',
    'associandola',
    'associandole',
    'associandoli',
    'associandolo',
    'associandomi',
    'associandosi',
    'associandoti',
    'associandovi',
    'associano',
    'associante',
    'associanti',
    'associantisi',
    'associarci',
    'associare',
    'associarla',
    'associarle',
    'associarli',
    'associarlo',
    'associarmi',
    'associarono',
    'associarsi',
    'associarti',
    'associarvi',
    'associasse',
    'associassero',
    'associassi',
    'associassimo',
    'associaste',
    'associasti',
    'associata',
    'associate',
    'associatevi',
    'associati',
    'associativa',
    'associative',
    'associativi',
    'associativo',
    'associato',
    'associatomi',
    'associatoti',
    'associava',
    'associavamo',
    'associavano',
    'associavate',
    'associavi',
    'associavo',
    'associazione',
    'associazioni',
    'associno',
    'associo',
    'assoda',
    'assodai',
    'assodamenti',
    'assodamento',
    'assodammo',
    'assodando',
    'assodandoci',
    'assodandomi',
    'assodandone',
    'assodandosi',
    'assodandoti',
    'assodandovi',
    'assodano',
    'assodante',
    'assodanti',
    'assodantisi',
    'assodarci',
    'assodare',
    'assodarmi',
    'assodarne',
    'assodarono',
    'assodarsi',
    'assodarti',
    'assodarvi',
    'assodasse',
    'assodassero',
    'assodassi',
    'assodassimo',
    'assodaste',
    'assodasti',
    'assodata',
    'assodate',
    'assodatevi',
    'assodati',
    'assodato',
    'assodatomi',
    'assodatoti',
    'assodava',
    'assodavamo',
    'assodavano',
    'assodavate',
    'assodavi',
    'assodavo',
    'assodera',
    'assoderai',
    'assoderanno',
    'assoderebbe',
    'assoderei',
    'assoderemmo',
    'assoderemo',
    'assodereste',
    'assoderesti',
    'assoderete',
    'assodero',
    'assodi',
    'assodiamo',
    'assodiamoci',
    'assodiate',
    'assodino',
    'assodo',
    'assoggetta',
    'assoggettai',
    'assoggettano',
    'assoggettare',
    'assoggettata',
    'assoggettate',
    'assoggettati',
    'assoggettato',
    'assoggettava',
    'assoggettavi',
    'assoggettavo',
    'assoggettera',
    'assoggettero',
    'assoggetterò',
    'assoggetti',
    'assoggettino',
    'assoggetto',
    'assoide',
    'assoidi',
    'assola',
    'assolai',
    'assolammo',
    'assolando',
    'assolano',
    'assolante',
    'assolanti',
    'assolare',
    'assolarono',
    'assolasse',
    'assolassero',
    'assolassi',
    'assolassimo',
    'assolaste',
    'assolasti',
    'assolata',
    'assolate',
    'assolati',
    'assolato',
    'assolava',
    'assolavamo',
    'assolavano',
    'assolavate',
    'assolavi',
    'assolavo',
    'assolca',
    'assolcai',
    'assolcammo',
    'assolcando',
    'assolcano',
    'assolcante',
    'assolcanti',
    'assolcare',
    'assolcarono',
    'assolcasse',
    'assolcassero',
    'assolcassi',
    'assolcassimo',
    'assolcaste',
    'assolcasti',
    'assolcata',
    'assolcate',
    'assolcati',
    'assolcato',
    'assolcatore',
    'assolcatori',
    'assolcatura',
    'assolcature',
    'assolcava',
    'assolcavamo',
    'assolcavano',
    'assolcavate',
    'assolcavi',
    'assolcavo',
    'assolchera',
    'assolcherai',
    'assolcherei',
    'assolcheremo',
    'assolcherete',
    'assolchero',
    'assolchi',
    'assolchiamo',
    'assolchiate',
    'assolchino',
    'assolco',
    'assolda',
    'assoldabile',
    'assoldai',
    'assoldamenti',
    'assoldamento',
    'assoldammo',
    'assoldando',
    'assoldano',
    'assoldante',
    'assoldanti',
    'assoldare',
    'assoldarono',
    'assoldasse',
    'assoldassero',
    'assoldassi',
    'assoldassimo',
    'assoldaste',
    'assoldasti',
    'assoldata',
    'assoldate',
    'assoldati',
    'assoldato',
    'assoldava',
    'assoldavamo',
    'assoldavano',
    'assoldavate',
    'assoldavi',
    'assoldavo',
    'assoldera',
    'assolderai',
    'assolderanno',
    'assolderebbe',
    'assolderei',
    'assolderemmo',
    'assolderemo',
    'assoldereste',
    'assolderesti',
    'assolderete',
    'assoldero',
    'assoldi',
    'assoldiamo',
    'assoldiate',
    'assoldino',
    'assoldo',
    'assolera',
    'assolerai',
    'assoleranno',
    'assolerebbe',
    'assolerei',
    'assoleremmo',
    'assoleremo',
    'assolereste',
    'assoleresti',
    'assolerete',
    'assolero',
    'assoli',
    'assoliamo',
    'assoliate',
    'assolino',
    'assolo',
    'assolse',
    'assolsero',
    'assolserono',
    'assolsi',
    'assolta',
    'assolte',
    'assolti',
    'assolto',
    'assoluta',
    'assolute',
    'assolutezza',
    'assolutezze',
    'assoluti',
    'assolutismi',
    'assolutismo',
    'assolutista',
    'assolutiste',
    'assolutisti',
    'assolutizza',
    'assolutizzai',
    'assolutizzi',
    'assolutizzo',
    'assoluto',
    'assolutore',
    'assolutori',
    'assolutoria',
    'assolutorie',
    'assolutorio',
    'assolutrice',
    'assolutrici',
    'assoluzione',
    'assoluzioni',
    'assolva',
    'assolvano',
    'assolve',
    'assolvei',
    'assolvemmo',
    'assolvendo',
    'assolvendoci',
    'assolvendola',
    'assolvendole',
    'assolvendoli',
    'assolvendolo',
    'assolvendomi',
    'assolvendoti',
    'assolvendovi',
    'assolvente',
    'assolventi',
    'assolvera',
    'assolverai',
    'assolveranno',
    'assolverci',
    'assolvere',
    'assolverebbe',
    'assolverei',
    'assolveremmo',
    'assolveremo',
    'assolvereste',
    'assolveresti',
    'assolverete',
    'assolverla',
    'assolverle',
    'assolverli',
    'assolverlo',
    'assolvermi',
    'assolvero',
    'assolverono',
    'assolvervi',
    'assolverò',
    'assolvesse',
    'assolvessero',
    'assolvessi',
    'assolvessimo',
    'assolveste',
    'assolvesti',
    'assolvete',
    'assolvetela',
    'assolvetele',
    'assolveteli',
    'assolvetelo',
    'assolvette',
    'assolvettero',
    'assolvetti',
    'assolveva',
    'assolvevamo',
    'assolvevano',
    'assolvevate',
    'assolvevi',
    'assolvevo',
    'assolvi',
    'assolviamo',
    'assolviate',
    'assolvici',
    'assolvila',
    'assolvile',
    'assolvili',
    'assolvilo',
    'assolvimenti',
    'assolvimento',
    'assolvimi',
    'assolvo',
    'assolvono',
    'assomigli',
    'assomiglia',
    'assomigliai',
    'assomigliamo',
    'assomigliano',
    'assomigliare',
    'assomigliata',
    'assomigliate',
    'assomigliati',
    'assomigliato',
    'assomigliava',
    'assomigliavi',
    'assomigliavo',
    'assomigliera',
    'assomigliero',
    'assomiglino',
    'assomiglio',
    'assomma',
    'assommai',
    'assommammo',
    'assommando',
    'assommandoci',
    'assommandomi',
    'assommandosi',
    'assommandoti',
    'assommandovi',
    'assommano',
    'assommante',
    'assommanti',
    'assommantisi',
    'assommarci',
    'assommare',
    'assommarmi',
    'assommarono',
    'assommarsi',
    'assommarti',
    'assommarvi',
    'assommasse',
    'assommassero',
    'assommassi',
    'assommassimo',
    'assommaste',
    'assommasti',
    'assommata',
    'assommate',
    'assommatevi',
    'assommati',
    'assommato',
    'assommatomi',
    'assommatoti',
    'assommava',
    'assommavamo',
    'assommavano',
    'assommavate',
    'assommavi',
    'assommavo',
    'assommera',
    'assommerai',
    'assommeranno',
    'assommerebbe',
    'assommerei',
    'assommeremmo',
    'assommeremo',
    'assommereste',
    'assommeresti',
    'assommerete',
    'assommero',
    'assommi',
    'assommiamo',
    'assommiamoci',
    'assommiate',
    'assommino',
    'assommo',
    'assona',
    'assonai',
    'assonale',
    'assonammo',
    'assonando',
    'assonano',
    'assonante',
    'assonanti',
    'assonanza',
    'assonanzata',
    'assonanzate',
    'assonanzati',
    'assonanzato',
    'assonanze',
    'assonare',
    'assonarono',
    'assonasse',
    'assonassero',
    'assonassi',
    'assonassimo',
    'assonaste',
    'assonasti',
    'assonata',
    'assonate',
    'assonati',
    'assonato',
    'assonava',
    'assonavamo',
    'assonavano',
    'assonavate',
    'assonavi',
    'assonavo',
    'assone',
    'assonema',
    'assonemi',
    'assonera',
    'assonerai',
    'assoneranno',
    'assonerebbe',
    'assonerei',
    'assoneremmo',
    'assoneremo',
    'assonereste',
    'assoneresti',
    'assonerete',
    'assonero',
    'assoni',
    'assoniamo',
    'assoniate',
    'assonico',
    'assonino',
    'assonna',
    'assonnai',
    'assonnamenti',
    'assonnamento',
    'assonnammo',
    'assonnando',
    'assonnano',
    'assonnante',
    'assonnanti',
    'assonnare',
    'assonnarono',
    'assonnasse',
    'assonnassero',
    'assonnassi',
    'assonnassimo',
    'assonnaste',
    'assonnasti',
    'assonnata',
    'assonnate',
    'assonnati',
    'assonnato',
    'assonnava',
    'assonnavamo',
    'assonnavano',
    'assonnavate',
    'assonnavi',
    'assonnavo',
    'assonnendo',
    'assonnendosi',
    'assonnente',
    'assonnenti',
    'assonnera',
    'assonnerai',
    'assonneranno',
    'assonnerebbe',
    'assonnerei',
    'assonneremmo',
    'assonneremo',
    'assonnereste',
    'assonneresti',
    'assonnerete',
    'assonnero',
    'assonni',
    'assonniamo',
    'assonniate',
    'assonnii',
    'assonnimenti',
    'assonnimento',
    'assonnimmo',
    'assonnino',
    'assonnira',
    'assonnirai',
    'assonniranno',
    'assonnire',
    'assonnirebbe',
    'assonnirei',
    'assonniremmo',
    'assonniremo',
    'assonnireste',
    'assonniresti',
    'assonnirete',
    'assonniro',
    'assonnirono',
    'assonnirsi',
    'assonnisca',
    'assonniscano',
    'assonnisce',
    'assonnisci',
    'assonnisco',
    'assonniscono',
    'assonnisse',
    'assonnissero',
    'assonnissi',
    'assonnissimo',
    'assonniste',
    'assonnisti',
    'assonnita',
    'assonnite',
    'assonniti',
    'assonnito',
    'assonniva',
    'assonnivamo',
    'assonnivano',
    'assonnivate',
    'assonnivi',
    'assonnivo',
    'assonno',
    'assono',
    'assonometria',
    'assonometrie',
    'assopendo',
    'assopendoci',
    'assopendola',
    'assopendole',
    'assopendoli',
    'assopendolo',
    'assopendomi',
    'assopendosi',
    'assopendoti',
    'assopendovi',
    'assopente',
    'assopenti',
    'assopentisi',
    'assopi',
    'assopiamo',
    'assopiamoci',
    'assopiate',
    'assopii',
    'assopimenti',
    'assopimento',
    'assopimmo',
    'assopira',
    'assopirai',
    'assopiranno',
    'assopirci',
    'assopire',
    'assopirebbe',
    'assopirei',
    'assopiremmo',
    'assopiremo',
    'assopireste',
    'assopiresti',
    'assopirete',
    'assopirla',
    'assopirle',
    'assopirli',
    'assopirlo',
    'assopirmi',
    'assopiro',
    'assopirono',
    'assopirsi',
    'assopirti',
    'assopirvi',
    'assopirà',
    'assopirò',
    'assopisca',
    'assopiscano',
    'assopisce',
    'assopisci',
    'assopisciti',
    'assopisco',
    'assopiscono',
    'assopisse',
    'assopissero',
    'assopissi',
    'assopissimo',
    'assopiste',
    'assopisti',
    'assopita',
    'assopite',
    'assopitevi',
    'assopiti',
    'assopito',
    'assopitomi',
    'assopitoti',
    'assopiva',
    'assopivamo',
    'assopivano',
    'assopivate',
    'assopivi',
    'assopivo',
    'assorba',
    'assorbano',
    'assorbe',
    'assorbendo',
    'assorbendola',
    'assorbendole',
    'assorbendoli',
    'assorbendolo',
    'assorbente',
    'assorbenti',
    'assorbi',
    'assorbiamo',
    'assorbiate',
    'assorbii',
    'assorbimenti',
    'assorbimento',
    'assorbimetri',
    'assorbimetro',
    'assorbimmo',
    'assorbira',
    'assorbirai',
    'assorbiranno',
    'assorbire',
    'assorbirebbe',
    'assorbirei',
    'assorbiremmo',
    'assorbiremo',
    'assorbireste',
    'assorbiresti',
    'assorbirete',
    'assorbirla',
    'assorbirle',
    'assorbirli',
    'assorbirlo',
    'assorbiro',
    'assorbirono',
    'assorbirsi',
    'assorbirà',
    'assorbirò',
    'assorbisca',
    'assorbiscano',
    'assorbisce',
    'assorbisci',
    'assorbisco',
    'assorbiscono',
    'assorbisse',
    'assorbissero',
    'assorbissi',
    'assorbissimo',
    'assorbiste',
    'assorbisti',
    'assorbita',
    'assorbite',
    'assorbiti',
    'assorbito',
    'assorbitore',
    'assorbitori',
    'assorbiva',
    'assorbivamo',
    'assorbivano',
    'assorbivate',
    'assorbivi',
    'assorbivo',
    'assorbo',
    'assorbono',
    'assorda',
    'assordai',
    'assordamenti',
    'assordamento',
    'assordammo',
    'assordando',
    'assordandoci',
    'assordandomi',
    'assordandosi',
    'assordandoti',
    'assordandovi',
    'assordano',
    'assordante',
    'assordanti',
    'assordantisi',
    'assordarci',
    'assordare',
    'assordarmi',
    'assordarono',
    'assordarsi',
    'assordarti',
    'assordarvi',
    'assordasse',
    'assordassero',
    'assordassi',
    'assordassimo',
    'assordaste',
    'assordasti',
    'assordata',
    'assordate',
    'assordatevi',
    'assordati',
    'assordato',
    'assordatomi',
    'assordatoti',
    'assordava',
    'assordavamo',
    'assordavano',
    'assordavate',
    'assordavi',
    'assordavo',
    'assordendo',
    'assordendoci',
    'assordendomi',
    'assordendosi',
    'assordendoti',
    'assordendovi',
    'assordente',
    'assordenti',
    'assordentisi',
    'assordera',
    'assorderai',
    'assorderanno',
    'assorderebbe',
    'assorderei',
    'assorderemmo',
    'assorderemo',
    'assordereste',
    'assorderesti',
    'assorderete',
    'assordero',
    'assorderò',
    'assordi',
    'assordiamo',
    'assordiamoci',
    'assordiate',
    'assordii',
    'assordimenti',
    'assordimento',
    'assordimmo',
    'assordino',
    'assordira',
    'assordirai',
    'assordiranno',
    'assordirci',
    'assordire',
    'assordirebbe',
    'assordirei',
    'assordiremmo',
    'assordiremo',
    'assordireste',
    'assordiresti',
    'assordirete',
    'assordirmi',
    'assordiro',
    'assordirono',
    'assordirsi',
    'assordirti',
    'assordirvi',
    'assordisca',
    'assordiscano',
    'assordisce',
    'assordisci',
    'assordisciti',
    'assordisco',
    'assordiscono',
    'assordisse',
    'assordissero',
    'assordissi',
    'assordissimo',
    'assordiste',
    'assordisti',
    'assordita',
    'assordite',
    'assorditevi',
    'assorditi',
    'assordito',
    'assorditomi',
    'assorditoti',
    'assordiva',
    'assordivamo',
    'assordivano',
    'assordivate',
    'assordivi',
    'assordivo',
    'assordo',
    'assorga',
    'assorgano',
    'assorge',
    'assorgemmo',
    'assorgendo',
    'assorgente',
    'assorgenti',
    'assorgera',
    'assorgerai',
    'assorgeranno',
    'assorgere',
    'assorgerebbe',
    'assorgerei',
    'assorgeremmo',
    'assorgeremo',
    'assorgereste',
    'assorgeresti',
    'assorgerete',
    'assorgero',
    'assorgesse',
    'assorgessero',
    'assorgessi',
    'assorgessimo',
    'assorgeste',
    'assorgesti',
    'assorgete',
    'assorgeva',
    'assorgevamo',
    'assorgevano',
    'assorgevate',
    'assorgevi',
    'assorgevo',
    'assorgi',
    'assorgiamo',
    'assorgiate',
    'assorgo',
    'assorgono',
    'assorse',
    'assorsero',
    'assorsi',
    'assorta',
    'assortativa',
    'assortative',
    'assortativi',
    'assortativo',
    'assorte',
    'assortendo',
    'assortente',
    'assortenti',
    'assorti',
    'assortiamo',
    'assortiate',
    'assortii',
    'assortimenti',
    'assortimento',
    'assortimmo',
    'assortira',
    'assortirai',
    'assortiranno',
    'assortire',
    'assortirebbe',
    'assortirei',
    'assortiremmo',
    'assortiremo',
    'assortireste',
    'assortiresti',
    'assortirete',
    'assortiro',
    'assortirono',
    'assortisca',
    'assortiscano',
    'assortisce',
    'assortisci',
    'assortisco',
    'assortiscono',
    'assortisse',
    'assortissero',
    'assortissi',
    'assortissimo',
    'assortiste',
    'assortisti',
    'assortita',
    'assortite',
    'assortiti',
    'assortito',
    'assortitore',
    'assortitori',
    'assortitrice',
    'assortitrici',
    'assortitura',
    'assortiture',
    'assortiva',
    'assortivamo',
    'assortivano',
    'assortivate',
    'assortivi',
    'assortivo',
    'assorto',
    'assottigla',
    'assottigli',
    'assottiglia',
    'assottigliai',
    'assottiglino',
    'assottiglio',
    'assottiglo',
    'assucca',
    'assuccai',
    'assuccammo',
    'assuccando',
    'assuccano',
    'assuccante',
    'assuccanti',
    'assuccare',
    'assuccarono',
    'assuccasse',
    'assuccassero',
    'assuccassi',
    'assuccassimo',
    'assuccaste',
    'assuccasti',
    'assuccata',
    'assuccate',
    'assuccati',
    'assuccato',
    'assuccava',
    'assuccavamo',
    'assuccavano',
    'assuccavate',
    'assuccavi',
    'assuccavo',
    'assucchera',
    'assuccherai',
    'assuccherei',
    'assuccheremo',
    'assuccherete',
    'assucchero',
    'assucchi',
    'assucchiamo',
    'assucchiate',
    'assucchino',
    'assucco',
    'assuefa',
    'assuefaccia',
    'assuefaccio',
    'assuefacemmo',
    'assuefacendo',
    'assuefacente',
    'assuefacenti',
    'assuefacesse',
    'assuefacessi',
    'assuefaceste',
    'assuefacesti',
    'assuefaceva',
    'assuefacevi',
    'assuefacevo',
    'assuefai',
    'assuefanno',
    'assuefante',
    'assuefara',
    'assuefarai',
    'assuefaranno',
    'assuefarci',
    'assuefare',
    'assuefarebbe',
    'assuefarei',
    'assuefaremmo',
    'assuefaremo',
    'assuefareste',
    'assuefaresti',
    'assuefarete',
    'assuefarmi',
    'assuefaro',
    'assuefarsi',
    'assuefarti',
    'assuefarvi',
    'assuefarà',
    'assuefarò',
    'assuefate',
    'assuefatevi',
    'assuefatta',
    'assuefatte',
    'assuefatti',
    'assuefatto',
    'assuefattomi',
    'assuefattoti',
    'assuefazione',
    'assuefazioni',
    'assuefece',
    'assuefecero',
    'assuefeci',
    'assuefo',
    'assuefà',
    'assuera',
    'assuero',
    'assueta',
    'assuete',
    'assueti',
    'assueto',
    'assuma',
    'assumano',
    'assume',
    'assumemmo',
    'assumendo',
    'assumendoci',
    'assumendola',
    'assumendole',
    'assumendoli',
    'assumendolo',
    'assumendomi',
    'assumendone',
    'assumendosi',
    'assumendoti',
    'assumendovi',
    'assumente',
    'assumenti',
    'assumentisi',
    'assumera',
    'assumerai',
    'assumeranno',
    'assumerci',
    'assumere',
    'assumerebbe',
    'assumerei',
    'assumeremmo',
    'assumeremo',
    'assumereste',
    'assumeresti',
    'assumerete',
    'assumerla',
    'assumerle',
    'assumerli',
    'assumerlo',
    'assumermi',
    'assumerne',
    'assumero',
    'assumersene',
    'assumersi',
    'assumerti',
    'assumervi',
    'assumerà',
    'assumerò',
    'assumesse',
    'assumessero',
    'assumessi',
    'assumessimo',
    'assumeste',
    'assumesti',
    'assumete',
    'assumetevi',
    'assumeva',
    'assumevamo',
    'assumevano',
    'assumevate',
    'assumevi',
    'assumevo',
    'assumi',
    'assumiamo',
    'assumiamoci',
    'assumiate',
    'assumibile',
    'assumibili',
    'assumiti',
    'assumo',
    'assumono',
    'assunse',
    'assunsero',
    'assunsi',
    'assunta',
    'assunte',
    'assunti',
    'assuntina',
    'assuntino',
    'assuntiva',
    'assuntive',
    'assuntivi',
    'assuntivo',
    'assunto',
    'assuntomi',
    'assuntore',
    'assuntori',
    'assuntoria',
    'assuntorie',
    'assuntoti',
    'assuntrice',
    'assuntrici',
    'assunzione',
    'assunzioni',
    'assuola',
    'assuolai',
    'assuolammo',
    'assuolando',
    'assuolano',
    'assuolante',
    'assuolanti',
    'assuolare',
    'assuolarono',
    'assuolasse',
    'assuolassero',
    'assuolassi',
    'assuolassimo',
    'assuolaste',
    'assuolasti',
    'assuolata',
    'assuolate',
    'assuolati',
    'assuolato',
    'assuolava',
    'assuolavamo',
    'assuolavano',
    'assuolavate',
    'assuolavi',
    'assuolavo',
    'assuolera',
    'assuolerai',
    'assuoleranno',
    'assuolerebbe',
    'assuolerei',
    'assuoleremmo',
    'assuoleremo',
    'assuolereste',
    'assuoleresti',
    'assuolerete',
    'assuolero',
    'assuoli',
    'assuoliamo',
    'assuoliate',
    'assuolino',
    'assuolo',
    'assuon',
    'assuonano',
    'assuoni',
    'assuonino',
    'assuono',
    'assurda',
    'assurdamente',
    'assurde',
    'assurdi',
    'assurdissimi',
    'assurdita',
    'assurdità',
    'assurdo',
    'assurga',
    'assurgano',
    'assurge',
    'assurgemmo',
    'assurgendo',
    'assurgente',
    'assurgenti',
    'assurgera',
    'assurgerai',
    'assurgeranno',
    'assurgere',
    'assurgerebbe',
    'assurgerei',
    'assurgeremmo',
    'assurgeremo',
    'assurgereste',
    'assurgeresti',
    'assurgerete',
    'assurgero',
    'assurgesse',
    'assurgessero',
    'assurgessi',
    'assurgessimo',
    'assurgeste',
    'assurgesti',
    'assurgete',
    'assurgeva',
    'assurgevamo',
    'assurgevano',
    'assurgevate',
    'assurgevi',
    'assurgevo',
    'assurgi',
    'assurgiamo',
    'assurgiate',
    'assurgo',
    'assurgono',
    'assurse',
    'assursero',
    'assursi',
    'assurta',
    'assurte',
    'assurti',
    'assurto',
    'asta',
    'astabile',
    'astabili',
    'astaci',
    'astaco',
    'astante',
    'astanteria',
    'astanterie',
    'astanti',
    'astata',
    'astate',
    'astati',
    'astatica',
    'astatiche',
    'astatici',
    'astaticita',
    'astaticità',
    'astatico',
    'astato',
    'aste',
    'asteggera',
    'asteggerai',
    'asteggeranno',
    'asteggerebbe',
    'asteggerei',
    'asteggeremmo',
    'asteggeremo',
    'asteggereste',
    'asteggeresti',
    'asteggerete',
    'asteggero',
    'asteggi',
    'asteggia',
    'asteggiai',
    'asteggiammo',
    'asteggiamo',
    'asteggiando',
    'asteggiano',
    'asteggiante',
    'asteggianti',
    'asteggiare',
    'asteggiarono',
    'asteggiasse',
    'asteggiassi',
    'asteggiaste',
    'asteggiasti',
    'asteggiata',
    'asteggiate',
    'asteggiati',
    'asteggiato',
    'asteggiatura',
    'asteggiature',
    'asteggiava',
    'asteggiavamo',
    'asteggiavano',
    'asteggiavate',
    'asteggiavi',
    'asteggiavo',
    'asteggino',
    'asteggio',
    'astemi',
    'astemia',
    'astemie',
    'astemio',
    'astene',
    'astenei',
    'astenemmo',
    'astenendo',
    'astenendoci',
    'astenendomi',
    'astenendosi',
    'astenendoti',
    'astenendovi',
    'astenente',
    'astenenti',
    'astenentisi',
    'astenerci',
    'astenere',
    'astenermi',
    'astenerono',
    'astenersi',
    'astenerti',
    'astenervi',
    'astenesse',
    'astenessero',
    'astenessi',
    'astenessimo',
    'asteneste',
    'astenesti',
    'astenete',
    'astenetevi',
    'astenette',
    'astenettero',
    'astenetti',
    'asteneva',
    'astenevamo',
    'astenevano',
    'astenevate',
    'astenevi',
    'astenevo',
    'astenga',
    'astengano',
    'astengo',
    'astengono',
    'astenia',
    'asteniamo',
    'asteniamoci',
    'asteniate',
    'astenica',
    'asteniche',
    'astenici',
    'astenico',
    'astenie',
    'astenne',
    'astennero',
    'astenni',
    'astenopia',
    'astenopie',
    'astenosfera',
    'astensione',
    'astensioni',
    'astenuta',
    'astenute',
    'astenuti',
    'astenuto',
    'astenutomi',
    'astenutoti',
    'aster',
    'asteraceae',
    'asterga',
    'astergano',
    'asterge',
    'astergemmo',
    'astergendo',
    'astergente',
    'astergenti',
    'astergera',
    'astergerai',
    'astergeranno',
    'astergere',
    'astergerebbe',
    'astergerei',
    'astergeremmo',
    'astergeremo',
    'astergereste',
    'astergeresti',
    'astergerete',
    'astergero',
    'astergesse',
    'astergessero',
    'astergessi',
    'astergessimo',
    'astergeste',
    'astergesti',
    'astergete',
    'astergeva',
    'astergevamo',
    'astergevano',
    'astergevate',
    'astergevi',
    'astergevo',
    'astergi',
    'astergiamo',
    'astergiate',
    'astergo',
    'astergono',
    'asteria',
    'asterie',
    'asterino',
    'asterio',
    'asterisca',
    'asteriscai',
    'asteriscammo',
    'asteriscando',
    'asteriscano',
    'asteriscante',
    'asteriscanti',
    'asteriscare',
    'asteriscasse',
    'asteriscassi',
    'asteriscaste',
    'asteriscasti',
    'asteriscata',
    'asteriscate',
    'asteriscati',
    'asteriscato',
    'asteriscava',
    'asteriscavi',
    'asteriscavo',
    'asterischera',
    'asterischero',
    'asterischi',
    'asterischino',
    'asterisco',
    'astero',
    'asteroidale',
    'asteroidali',
    'asteroide',
    'asteroidei',
    'asteroideo',
    'asteroides',
    'asteroidi',
    'asterra',
    'asterrai',
    'asterranno',
    'asterrebbe',
    'asterrebbero',
    'asterrei',
    'asterremmo',
    'asterremo',
    'asterreste',
    'asterresti',
    'asterrete',
    'asterro',
    'asterrà',
    'asterrò',
    'astersa',
    'asterse',
    'astersero',
    'astersi',
    'astersione',
    'astersioni',
    'asterso',
    'asti',
    'asticciola',
    'asticciole',
    'asticciuola',
    'astice',
    'asticella',
    'asticelle',
    'astici',
    'astiene',
    'astieni',
    'astieniti',
    'astigiana',
    'astigiane',
    'astigiani',
    'astigiano',
    'astigmatica',
    'astigmatiche',
    'astigmatici',
    'astigmatico',
    'astigmatismi',
    'astigmatismo',
    'astigmometri',
    'astigmometro',
    'astila',
    'astile',
    'astili',
    'astilo',
    'astinente',
    'astinenti',
    'astinenza',
    'astinenze',
    'astio',
    'astiosa',
    'astiosamente',
    'astiose',
    'astiosi',
    'astiosita',
    'astiosità',
    'astioso',
    'astista',
    'astiste',
    'astisti',
    'astolfo',
    'aston',
    'astopessi',
    'astore',
    'astorga',
    'astori',
    'astoria',
    'astorino',
    'astorre',
    'astotomia',
    'astra',
    'astracan',
    'astrae',
    'astraemmo',
    'astraendo',
    'astraendoci',
    'astraendomi',
    'astraendosi',
    'astraendoti',
    'astraendovi',
    'astraente',
    'astraenti',
    'astraentisi',
    'astraere',
    'astraesse',
    'astraessero',
    'astraessi',
    'astraessimo',
    'astraeste',
    'astraesti',
    'astraete',
    'astraetela',
    'astraetelo',
    'astraetene',
    'astraetevi',
    'astraeva',
    'astraevamo',
    'astraevano',
    'astraevate',
    'astraevi',
    'astraevo',
    'astragali',
    'astragalo',
    'astragga',
    'astraggano',
    'astraggere',
    'astraggo',
    'astraggono',
    'astrai',
    'astraiamo',
    'astraiamoci',
    'astraiate',
    'astraila',
    'astrailo',
    'astraine',
    'astraiti',
    'astrakan',
    'astrale',
    'astrali',
    'astranzia',
    'astranzie',
    'astrarci',
    'astrarmi',
    'astrarra',
    'astrarrai',
    'astrarranno',
    'astrarre',
    'astrarrebbe',
    'astrarrei',
    'astrarremmo',
    'astrarremo',
    'astrarreste',
    'astrarresti',
    'astrarrete',
    'astrarro',
    'astrarrà',
    'astrarrò',
    'astrarsi',
    'astrarti',
    'astrarvi',
    'astrasse',
    'astrassero',
    'astrassi',
    'astrato',
    'astratta',
    'astratte',
    'astrattezza',
    'astrattezze',
    'astratti',
    'astrattismi',
    'astrattismo',
    'astrattista',
    'astrattiste',
    'astrattisti',
    'astrattiva',
    'astrattive',
    'astrattivi',
    'astrattivo',
    'astratto',
    'astrattomi',
    'astrattoti',
    'astrazione',
    'astrazioni',
    'astrea',
    'astrectomia',
    'astretta',
    'astrette',
    'astretti',
    'astretto',
    'astri',
    'astrignere',
    'astringa',
    'astringano',
    'astringe',
    'astringemmo',
    'astringendo',
    'astringente',
    'astringenti',
    'astringera',
    'astringerai',
    'astringere',
    'astringerei',
    'astringeremo',
    'astringerete',
    'astringero',
    'astringesse',
    'astringessi',
    'astringeste',
    'astringesti',
    'astringete',
    'astringeva',
    'astringevamo',
    'astringevano',
    'astringevate',
    'astringevi',
    'astringevo',
    'astringi',
    'astringiamo',
    'astringiate',
    'astringo',
    'astringono',
    'astrinse',
    'astrinsero',
    'astrinsi',
    'astro',
    'astrobussola',
    'astrobussole',
    'astrochimica',
    'astrociti',
    'astrocitoma',
    'astrofica',
    'astrofiche',
    'astrofici',
    'astrofico',
    'astrofila',
    'astrofile',
    'astrofili',
    'astrofilo',
    'astrofisica',
    'astrofisiche',
    'astrofisici',
    'astrofisico',
    'astrografi',
    'astrografia',
    'astrografie',
    'astrografo',
    'astrolabi',
    'astrolabio',
    'astrolatria',
    'astrolatrie',
    'astrologa',
    'astrologai',
    'astrologammo',
    'astrologando',
    'astrologano',
    'astrologante',
    'astrologanti',
    'astrologare',
    'astrologasse',
    'astrologassi',
    'astrologaste',
    'astrologasti',
    'astrologata',
    'astrologate',
    'astrologati',
    'astrologato',
    'astrologava',
    'astrologavi',
    'astrologavo',
    'astrologhe',
    'astrologhera',
    'astrologhero',
    'astrologhi',
    'astrologhino',
    'astrologi',
    'astrologia',
    'astrologica',
    'astrologiche',
    'astrologici',
    'astrologico',
    'astrologie',
    'astrologo',
    'astrometria',
    'astrometrie',
    'astronauta',
    'astronaute',
    'astronauti',
    'astronautica',
    'astronautici',
    'astronautico',
    'astronave',
    'astronavi',
    'astronoma',
    'astronome',
    'astronomi',
    'astronomia',
    'astronomica',
    'astronomiche',
    'astronomici',
    'astronomico',
    'astronomie',
    'astronomo',
    'astroporti',
    'astroporto',
    'astroscopi',
    'astroscopio',
    'astrotomia',
    'astroviridae',
    'astrovirus',
    'astrusa',
    'astrusaggine',
    'astrusaggini',
    'astrusamente',
    'astruse',
    'astruseria',
    'astruserie',
    'astrusi',
    'astrusissima',
    'astrusissime',
    'astrusissimi',
    'astrusissimo',
    'astrusita',
    'astrusità',
    'astruso',
    'astuccetto',
    'astucci',
    'astucciai',
    'astucciaia',
    'astucciaie',
    'astucciaio',
    'astuccio',
    'astuta',
    'astutamente',
    'astute',
    'astutezza',
    'astutezze',
    'astuti',
    'astutissima',
    'astuto',
    'astuzia',
    'astuzie',
    'asuona',
    'asvero',
    'asylant',
    'atabagica',
    'atabagiche',
    'atabagici',
    'atabagico',
    'atai',
    'ataide',
    'atala',
    'atalanta',
    'atalante',
    'atalantina',
    'atalantine',
    'atalantini',
    'atalantino',
    'atalia',
    'atalo',
    'atamani',
    'atamano',
    'atami',
    'atammo',
    'atanasio',
    'atando',
    'atandoci',
    'atandomi',
    'atandosi',
    'atandoti',
    'atandovi',
    'atano',
    'atante',
    'atanti',
    'atantisi',
    'atarassia',
    'atarassica',
    'atarassiche',
    'atarassici',
    'atarassico',
    'atarassie',
    'atarci',
    'atare',
    'atarmi',
    'atarono',
    'atarsi',
    'atarti',
    'atarvi',
    'atasse',
    'atassero',
    'atassi',
    'atassia',
    'atassica',
    'atassiche',
    'atassici',
    'atassico',
    'atassie',
    'atassimo',
    'ataste',
    'atasti',
    'atata',
    'atate',
    'atatevi',
    'atati',
    'atato',
    'atatomi',
    'atatoti',
    'atava',
    'atavamo',
    'atavano',
    'atavate',
    'atave',
    'atavi',
    'atavica',
    'atavicamente',
    'ataviche',
    'atavici',
    'atavico',
    'atavismi',
    'atavismo',
    'atavistica',
    'atavistiche',
    'atavistici',
    'atavistico',
    'atavo',
    'atciu',
    'atea',
    'atee',
    'atei',
    'ateismi',
    'ateismo',
    'ateista',
    'ateiste',
    'ateisti',
    'ateistica',
    'ateistiche',
    'ateistici',
    'ateistico',
    'atele',
    'atelectasia',
    'atelectasica',
    'atelectasici',
    'atelectasico',
    'atelectasie',
    'atelettasia',
    'atelettasica',
    'atelettasici',
    'atelettasico',
    'atelettasie',
    'ateli',
    'atelia',
    'atelie',
    'atelier',
    'ateliers',
    'atellana',
    'atellane',
    'atematica',
    'atematiche',
    'atematici',
    'atematico',
    'atemi',
    'atemporale',
    'atemporali',
    'atemporalita',
    'atemporalità',
    'atena',
    'atene',
    'atenei',
    'ateneo',
    'ateniese',
    'ateniesi',
    'ateno',
    'atenta',
    'ateo',
    'atera',
    'aterai',
    'ateranno',
    'aterebbe',
    'aterebbero',
    'aterectomia',
    'aterei',
    'ateremmo',
    'ateremo',
    'atereste',
    'ateresti',
    'aterete',
    'aterina',
    'aterine',
    'aterinide',
    'aterinidi',
    'ateriniforme',
    'ateriniformi',
    'atermana',
    'atermane',
    'atermani',
    'atermano',
    'atermica',
    'atermiche',
    'atermici',
    'atermico',
    'atero',
    'aterogenica',
    'ateroma',
    'ateromasia',
    'ateromasie',
    'ateromi',
    'atesina',
    'atesine',
    'atesini',
    'atesino',
    'atestina',
    'atestine',
    'atestini',
    'atestino',
    'atetesi',
    'atetizza',
    'atetizzai',
    'atetizzammo',
    'atetizzando',
    'atetizzano',
    'atetizzante',
    'atetizzanti',
    'atetizzare',
    'atetizzarono',
    'atetizzasse',
    'atetizzassi',
    'atetizzaste',
    'atetizzasti',
    'atetizzata',
    'atetizzate',
    'atetizzati',
    'atetizzato',
    'atetizzava',
    'atetizzavamo',
    'atetizzavano',
    'atetizzavate',
    'atetizzavi',
    'atetizzavo',
    'atetizzera',
    'atetizzerai',
    'atetizzerei',
    'atetizzeremo',
    'atetizzerete',
    'atetizzero',
    'atetizzi',
    'atetizziamo',
    'atetizziate',
    'atetizzino',
    'atetizzo',
    'atetosi',
    'athos',
    'atiamo',
    'atiamoci',
    'atiate',
    'atimia',
    'atimie',
    'atino',
    'atipica',
    'atipicamente',
    'atipiche',
    'atipici',
    'atipicita',
    'atipicità',
    'atipico',
    'atlanta',
    'atlante',
    'atlanti',
    'atlantica',
    'atlantiche',
    'atlantici',
    'atlantico',
    'atlantini',
    'atlantino',
    'atlantismi',
    'atlantismo',
    'atlantista',
    'atlantiste',
    'atlantisti',
    'atlanto',
    'atleta',
    'atlete',
    'atletessa',
    'atleti',
    'atletica',
    'atletiche',
    'atletici',
    'atletico',
    'atletismi',
    'atletismo',
    'atmosfera',
    'atmosfere',
    'atmosferica',
    'atmosferiche',
    'atmosferici',
    'atmosferico',
    'atolli',
    'atollo',
    'atomi',
    'atomica',
    'atomicamente',
    'atomiche',
    'atomici',
    'atomicita',
    'atomicità',
    'atomico',
    'atomismi',
    'atomismo',
    'atomista',
    'atomiste',
    'atomisti',
    'atomistica',
    'atomistiche',
    'atomistici',
    'atomistico',
    'atomizza',
    'atomizzai',
    'atomizzammo',
    'atomizzando',
    'atomizzano',
    'atomizzante',
    'atomizzanti',
    'atomizzare',
    'atomizzarono',
    'atomizzasse',
    'atomizzassi',
    'atomizzaste',
    'atomizzasti',
    'atomizzata',
    'atomizzate',
    'atomizzati',
    'atomizzato',
    'atomizzatore',
    'atomizzatori',
    'atomizzava',
    'atomizzavamo',
    'atomizzavano',
    'atomizzavate',
    'atomizzavi',
    'atomizzavo',
    'atomizzera',
    'atomizzerai',
    'atomizzerei',
    'atomizzeremo',
    'atomizzerete',
    'atomizzero',
    'atomizzi',
    'atomizziamo',
    'atomizziate',
    'atomizzino',
    'atomizzo',
    'atomo',
    'atona',
    'atonale',
    'atonali',
    'atonalita',
    'atonalità',
    'atone',
    'atoni',
    'atonia',
    'atonica',
    'atoniche',
    'atonici',
    'atonicita',
    'atonico',
    'atonie',
    'atono',
    'atopica',
    'atos',
    'atossica',
    'atossiche',
    'atossici',
    'atossico',
    'atout',
    'atouts',
    'atra',
    'atrabile',
    'atrabili',
    'atrabiliante',
    'atrabiliare',
    'atrabiliari',
    'atramente',
    'atramenti',
    'atramento',
    'atrazina',
    'atrazine',
    'atre',
    'atreplice',
    'atreplici',
    'atrepsia',
    'atrepsie',
    'atresia',
    'atresie',
    'atri',
    'atriale',
    'atriali',
    'atrichia',
    'atrichie',
    'atrii',
    'atrio',
    'atriogramma',
    'atriogrammi',
    'atriplice',
    'atriplici',
    'atro',
    'atroce',
    'atrocemente',
    'atroci',
    'atrocissima',
    'atrocissimo',
    'atrocita',
    'atrocità',
    'atrofia',
    'atrofica',
    'atrofiche',
    'atrofici',
    'atrofico',
    'atrofie',
    'atrofizza',
    'atrofizzai',
    'atrofizzammo',
    'atrofizzando',
    'atrofizzano',
    'atrofizzante',
    'atrofizzanti',
    'atrofizzarci',
    'atrofizzare',
    'atrofizzarmi',
    'atrofizzarsi',
    'atrofizzarti',
    'atrofizzarvi',
    'atrofizzasse',
    'atrofizzassi',
    'atrofizzaste',
    'atrofizzasti',
    'atrofizzata',
    'atrofizzate',
    'atrofizzati',
    'atrofizzato',
    'atrofizzava',
    'atrofizzavi',
    'atrofizzavo',
    'atrofizzera',
    'atrofizzerai',
    'atrofizzerei',
    'atrofizzero',
    'atrofizzerò',
    'atrofizzi',
    'atrofizziamo',
    'atrofizziate',
    'atrofizzino',
    'atrofizzo',
    'atropa',
    'atrope',
    'atropi',
    'atropina',
    'atropine',
    'atropo',
    'atta',
    'attacca',
    'attaccabile',
    'attaccabili',
    'attaccagnola',
    'attaccagnole',
    'attaccagnoli',
    'attaccagnolo',
    'attaccai',
    'attaccala',
    'attaccale',
    'attaccali',
    'attaccalite',
    'attaccalo',
    'attaccamani',
    'attaccamano',
    'attaccamenti',
    'attaccamento',
    'attaccammo',
    'attaccando',
    'attaccandoci',
    'attaccandola',
    'attaccandole',
    'attaccandoli',
    'attaccandolo',
    'attaccandomi',
    'attaccandosi',
    'attaccandoti',
    'attaccandovi',
    'attaccano',
    'attaccante',
    'attaccanti',
    'attaccantisi',
    'attaccapanni',
    'attaccarci',
    'attaccare',
    'attaccarla',
    'attaccarle',
    'attaccarli',
    'attaccarlo',
    'attaccarmi',
    'attaccarono',
    'attaccarsi',
    'attaccarti',
    'attaccarvi',
    'attaccasse',
    'attaccassero',
    'attaccassi',
    'attaccassimo',
    'attaccaste',
    'attaccasti',
    'attaccata',
    'attaccate',
    'attaccatela',
    'attaccatele',
    'attaccateli',
    'attaccatelo',
    'attaccatevi',
    'attaccati',
    'attaccaticce',
    'attaccaticci',
    'attaccato',
    'attaccatomi',
    'attaccatoti',
    'attaccatura',
    'attaccature',
    'attaccatutto',
    'attaccava',
    'attaccavamo',
    'attaccavano',
    'attaccavate',
    'attaccavi',
    'attaccavo',
    'attacchera',
    'attaccherai',
    'attaccherei',
    'attaccheremo',
    'attaccherete',
    'attacchero',
    'attacchi',
    'attacchiamo',
    'attacchiate',
    'attacchina',
    'attacchinai',
    'attacchinano',
    'attacchinare',
    'attacchinata',
    'attacchinate',
    'attacchinati',
    'attacchinato',
    'attacchinava',
    'attacchinavi',
    'attacchinavo',
    'attacchine',
    'attacchinera',
    'attacchinero',
    'attacchini',
    'attacchinino',
    'attacchino',
    'attacco',
    'attaccò',
    'attache',
    'attaci',
    'attaco',
    'attagli',
    'attaglia',
    'attagliai',
    'attagliammo',
    'attagliamo',
    'attagliamoci',
    'attagliando',
    'attagliano',
    'attagliante',
    'attaglianti',
    'attagliarci',
    'attagliare',
    'attagliarmi',
    'attagliarono',
    'attagliarsi',
    'attagliarti',
    'attagliarvi',
    'attagliasse',
    'attagliassi',
    'attagliaste',
    'attagliasti',
    'attagliata',
    'attagliate',
    'attagliatevi',
    'attagliati',
    'attagliato',
    'attagliatomi',
    'attagliatoti',
    'attagliava',
    'attagliavamo',
    'attagliavano',
    'attagliavate',
    'attagliavi',
    'attagliavo',
    'attagliera',
    'attaglierai',
    'attaglierei',
    'attaglieremo',
    'attaglierete',
    'attagliero',
    'attaglino',
    'attaglio',
    'attala',
    'attalea',
    'attalee',
    'attalenta',
    'attalentai',
    'attalentammo',
    'attalentando',
    'attalentano',
    'attalentante',
    'attalentanti',
    'attalentare',
    'attalentasse',
    'attalentassi',
    'attalentaste',
    'attalentasti',
    'attalentata',
    'attalentate',
    'attalentati',
    'attalentato',
    'attalentava',
    'attalentavi',
    'attalentavo',
    'attalentera',
    'attalenterai',
    'attalenterei',
    'attalentero',
    'attalenti',
    'attalentiamo',
    'attalentiate',
    'attalentino',
    'attalento',
    'attalo',
    'attanagli',
    'attanaglia',
    'attanagliai',
    'attanagliamo',
    'attanagliano',
    'attanagliare',
    'attanagliata',
    'attanagliate',
    'attanagliati',
    'attanagliato',
    'attanagliava',
    'attanagliavi',
    'attanagliavo',
    'attanagliera',
    'attanagliero',
    'attanaglino',
    'attanaglio',
    'attanasio',
    'attante',
    'attanti',
    'attapina',
    'attapinano',
    'attapinarsi',
    'attapinata',
    'attapinate',
    'attapinati',
    'attapinato',
    'attapinava',
    'attapinavano',
    'attappando',
    'attappare',
    'attappata',
    'attappate',
    'attappati',
    'attappato',
    'attarda',
    'attardai',
    'attardammo',
    'attardando',
    'attardandoci',
    'attardandomi',
    'attardandosi',
    'attardandoti',
    'attardandovi',
    'attardano',
    'attardante',
    'attardanti',
    'attardantisi',
    'attardarci',
    'attardare',
    'attardarmi',
    'attardarono',
    'attardarsi',
    'attardarti',
    'attardarvi',
    'attardasse',
    'attardassero',
    'attardassi',
    'attardassimo',
    'attardaste',
    'attardasti',
    'attardata',
    'attardate',
    'attardatevi',
    'attardati',
    'attardato',
    'attardatomi',
    'attardatoti',
    'attardava',
    'attardavamo',
    'attardavano',
    'attardavate',
    'attardavi',
    'attardavo',
    'attardera',
    'attarderai',
    'attarderanno',
    'attarderebbe',
    'attarderei',
    'attarderemmo',
    'attarderemo',
    'attardereste',
    'attarderesti',
    'attarderete',
    'attardero',
    'attardi',
    'attardiamo',
    'attardiamoci',
    'attardiate',
    'attardino',
    'attardo',
    'atte',
    'attecchendo',
    'attecchente',
    'attecchenti',
    'attecchi',
    'attecchiamo',
    'attecchiate',
    'attecchii',
    'attecchimmo',
    'attecchira',
    'attecchirai',
    'attecchire',
    'attecchirei',
    'attecchiremo',
    'attecchirete',
    'attecchiro',
    'attecchirono',
    'attecchirsi',
    'attecchisca',
    'attecchisce',
    'attecchisci',
    'attecchisco',
    'attecchisse',
    'attecchissi',
    'attecchiste',
    'attecchisti',
    'attecchita',
    'attecchite',
    'attecchiti',
    'attecchito',
    'attecchiva',
    'attecchivamo',
    'attecchivano',
    'attecchivate',
    'attecchivi',
    'attecchivo',
    'attedi',
    'attedia',
    'attediai',
    'attediammo',
    'attediamo',
    'attediamoci',
    'attediando',
    'attediandoci',
    'attediandomi',
    'attediandosi',
    'attediandoti',
    'attediandovi',
    'attediano',
    'attediante',
    'attedianti',
    'attediantisi',
    'attediarci',
    'attediare',
    'attediarmi',
    'attediarono',
    'attediarsi',
    'attediarti',
    'attediarvi',
    'attediasse',
    'attediassero',
    'attediassi',
    'attediassimo',
    'attediaste',
    'attediasti',
    'attediata',
    'attediate',
    'attediatevi',
    'attediati',
    'attediato',
    'attediatomi',
    'attediatoti',
    'attediava',
    'attediavamo',
    'attediavano',
    'attediavate',
    'attediavi',
    'attediavo',
    'attediera',
    'attedierai',
    'attedieranno',
    'attedierebbe',
    'attedierei',
    'attedieremmo',
    'attedieremo',
    'attediereste',
    'attedieresti',
    'attedierete',
    'attediero',
    'attedino',
    'attedio',
    'atteggera',
    'atteggerai',
    'atteggeranno',
    'atteggerebbe',
    'atteggerei',
    'atteggeremmo',
    'atteggeremo',
    'atteggereste',
    'atteggeresti',
    'atteggerete',
    'atteggero',
    'atteggerò',
    'atteggi',
    'atteggia',
    'atteggiai',
    'atteggiammo',
    'atteggiamo',
    'atteggiamoci',
    'atteggiando',
    'atteggiano',
    'atteggiante',
    'atteggianti',
    'atteggiarci',
    'atteggiare',
    'atteggiarmi',
    'atteggiarono',
    'atteggiarsi',
    'atteggiarti',
    'atteggiarvi',
    'atteggiasse',
    'atteggiassi',
    'atteggiaste',
    'atteggiasti',
    'atteggiata',
    'atteggiate',
    'atteggiatevi',
    'atteggiati',
    'atteggiato',
    'atteggiatomi',
    'atteggiatoti',
    'atteggiava',
    'atteggiavamo',
    'atteggiavano',
    'atteggiavate',
    'atteggiavi',
    'atteggiavo',
    'atteggino',
    'atteggio',
    'attempa',
    'attempandomi',
    'attempandosi',
    'attempano',
    'attemparmi',
    'attemparsi',
    'attempata',
    'attempate',
    'attempatella',
    'attempatelle',
    'attempatelli',
    'attempatello',
    'attempati',
    'attempato',
    'attempi',
    'attempiamo',
    'attempiate',
    'attempino',
    'attempo',
    'attenda',
    'attendai',
    'attendamenti',
    'attendamento',
    'attendammo',
    'attendando',
    'attendandoci',
    'attendandomi',
    'attendandosi',
    'attendandoti',
    'attendandovi',
    'attendano',
    'attendantesi',
    'attendantisi',
    'attendarci',
    'attendare',
    'attendarmi',
    'attendarono',
    'attendarsi',
    'attendarti',
    'attendarvi',
    'attendasse',
    'attendassero',
    'attendassi',
    'attendassimo',
    'attendaste',
    'attendasti',
    'attendata',
    'attendate',
    'attendatevi',
    'attendati',
    'attendato',
    'attendatomi',
    'attendatoti',
    'attendava',
    'attendavamo',
    'attendavano',
    'attendavate',
    'attendavi',
    'attendavo',
    'attende',
    'attendemmo',
    'attendendo',
    'attendendoci',
    'attendendola',
    'attendendole',
    'attendendoli',
    'attendendolo',
    'attendendomi',
    'attendendone',
    'attendendoti',
    'attendendovi',
    'attendente',
    'attendenti',
    'attendera',
    'attenderai',
    'attenderanno',
    'attenderci',
    'attendere',
    'attenderebbe',
    'attenderei',
    'attenderemmo',
    'attenderemo',
    'attendereste',
    'attenderesti',
    'attenderete',
    'attenderla',
    'attenderle',
    'attenderli',
    'attenderlo',
    'attendermi',
    'attenderne',
    'attendero',
    'attendersi',
    'attenderti',
    'attendervi',
    'attenderò',
    'attendesse',
    'attendessero',
    'attendessi',
    'attendessimo',
    'attendeste',
    'attendesti',
    'attendete',
    'attendeteci',
    'attendetela',
    'attendetelo',
    'attendetemi',
    'attendetevi',
    'attendeva',
    'attendevamo',
    'attendevano',
    'attendevate',
    'attendevi',
    'attendevo',
    'attendi',
    'attendiamo',
    'attendiamoci',
    'attendiate',
    'attendibile',
    'attendibili',
    'attendimi',
    'attendino',
    'attendismi',
    'attendismo',
    'attendista',
    'attendiste',
    'attendisti',
    'attendo',
    'attendono',
    'attene',
    'attenebra',
    'attenebrai',
    'attenebrammo',
    'attenebrando',
    'attenebrano',
    'attenebrante',
    'attenebranti',
    'attenebrare',
    'attenebrasse',
    'attenebrassi',
    'attenebraste',
    'attenebrasti',
    'attenebrata',
    'attenebrate',
    'attenebrati',
    'attenebrato',
    'attenebrava',
    'attenebravi',
    'attenebravo',
    'attenebrera',
    'attenebrerai',
    'attenebrerei',
    'attenebrero',
    'attenebri',
    'attenebriamo',
    'attenebriate',
    'attenebrino',
    'attenebro',
    'attenei',
    'attenemmo',
    'attenendo',
    'attenendoci',
    'attenendomi',
    'attenendosi',
    'attenendoti',
    'attenendovi',
    'attenente',
    'attenenti',
    'attenentisi',
    'attenenza',
    'attenerci',
    'attenere',
    'attenermi',
    'attenerono',
    'attenersi',
    'attenerti',
    'attenervi',
    'attenervisi',
    'attenesse',
    'attenessero',
    'attenessi',
    'attenessimo',
    'atteneste',
    'attenesti',
    'attenete',
    'attenetevi',
    'attenette',
    'attenettero',
    'attenetti',
    'atteneva',
    'attenevamo',
    'attenevano',
    'attenevate',
    'attenevi',
    'attenevo',
    'attenga',
    'attengano',
    'attengo',
    'attengono',
    'atteniamo',
    'atteniamoci',
    'atteniate',
    'attenne',
    'attennero',
    'attenni',
    'attenta',
    'attentai',
    'attentamente',
    'attentammo',
    'attentando',
    'attentandoci',
    'attentandomi',
    'attentandosi',
    'attentandoti',
    'attentandovi',
    'attentano',
    'attentante',
    'attentanti',
    'attentantisi',
    'attentarci',
    'attentare',
    'attentarmi',
    'attentarono',
    'attentarsi',
    'attentarti',
    'attentarvi',
    'attentasse',
    'attentassero',
    'attentassi',
    'attentassimo',
    'attentaste',
    'attentasti',
    'attentata',
    'attentate',
    'attentatevi',
    'attentati',
    'attentato',
    'attentatomi',
    'attentatore',
    'attentatori',
    'attentatoti',
    'attentatrice',
    'attentatrici',
    'attentava',
    'attentavamo',
    'attentavano',
    'attentavate',
    'attentavi',
    'attentavo',
    'attente',
    'attentera',
    'attenterai',
    'attenteranno',
    'attenterebbe',
    'attenterei',
    'attenteremmo',
    'attenteremo',
    'attentereste',
    'attenteresti',
    'attenterete',
    'attentero',
    'attenterò',
    'attenti',
    'attentiamo',
    'attentiamoci',
    'attentiate',
    'attentino',
    'attentissimo',
    'attento',
    'attenua',
    'attenuai',
    'attenuamenti',
    'attenuamento',
    'attenuammo',
    'attenuando',
    'attenuandoci',
    'attenuandomi',
    'attenuandosi',
    'attenuandoti',
    'attenuandovi',
    'attenuano',
    'attenuante',
    'attenuanti',
    'attenuantisi',
    'attenuarci',
    'attenuare',
    'attenuarmi',
    'attenuarono',
    'attenuarsi',
    'attenuarti',
    'attenuarvi',
    'attenuasse',
    'attenuassero',
    'attenuassi',
    'attenuassimo',
    'attenuaste',
    'attenuasti',
    'attenuata',
    'attenuate',
    'attenuatevi',
    'attenuati',
    'attenuativa',
    'attenuative',
    'attenuativi',
    'attenuativo',
    'attenuato',
    'attenuatomi',
    'attenuatoti',
    'attenuava',
    'attenuavamo',
    'attenuavano',
    'attenuavate',
    'attenuavi',
    'attenuavo',
    'attenuazione',
    'attenuazioni',
    'attenuera',
    'attenuerai',
    'attenueranno',
    'attenuerebbe',
    'attenuerei',
    'attenueremmo',
    'attenueremo',
    'attenuereste',
    'attenueresti',
    'attenuerete',
    'attenuero',
    'attenuerò',
    'attenui',
    'attenuiamo',
    'attenuiamoci',
    'attenuiate',
    'attenuino',
    'attenuo',
    'attenuta',
    'attenute',
    'attenuti',
    'attenuto',
    'attenutomi',
    'attenutoti',
    'attenzione',
    'attenzioni',
    'attera',
    'attere',
    'atterga',
    'attergai',
    'attergammo',
    'attergando',
    'attergandoci',
    'attergandomi',
    'attergandosi',
    'attergandoti',
    'attergandovi',
    'attergano',
    'attergante',
    'atterganti',
    'attergantisi',
    'attergarci',
    'attergare',
    'attergarmi',
    'attergarono',
    'attergarsi',
    'attergarti',
    'attergarvi',
    'attergasse',
    'attergassero',
    'attergassi',
    'attergassimo',
    'attergaste',
    'attergasti',
    'attergata',
    'attergate',
    'attergatevi',
    'attergati',
    'attergato',
    'attergatomi',
    'attergatoti',
    'attergava',
    'attergavamo',
    'attergavano',
    'attergavate',
    'attergavi',
    'attergavo',
    'atterghera',
    'attergherai',
    'attergherei',
    'attergheremo',
    'attergherete',
    'atterghero',
    'atterghi',
    'atterghiamo',
    'atterghiate',
    'atterghino',
    'attergo',
    'atteri',
    'atterige',
    'atterigi',
    'atterigoti',
    'atterigoto',
    'atterismi',
    'atterismo',
    'attero',
    'atterra',
    'atterraggi',
    'atterraggio',
    'atterrai',
    'atterramenti',
    'atterramento',
    'atterrammo',
    'atterrando',
    'atterrandoci',
    'atterrandomi',
    'atterrandosi',
    'atterrandoti',
    'atterrandovi',
    'atterranno',
    'atterrano',
    'atterrante',
    'atterranti',
    'atterrantisi',
    'atterrarci',
    'atterrare',
    'atterrarmi',
    'atterrarono',
    'atterrarsi',
    'atterrarti',
    'atterrarvi',
    'atterrasse',
    'atterrassero',
    'atterrassi',
    'atterrassimo',
    'atterraste',
    'atterrasti',
    'atterrata',
    'atterrate',
    'atterratevi',
    'atterrati',
    'atterrato',
    'atterratomi',
    'atterratoti',
    'atterrava',
    'atterravamo',
    'atterravano',
    'atterravate',
    'atterravi',
    'atterravo',
    'atterrebbe',
    'atterrebbero',
    'atterrei',
    'atterremmo',
    'atterremo',
    'atterrendo',
    'atterrendoci',
    'atterrendola',
    'atterrendole',
    'atterrendoli',
    'atterrendolo',
    'atterrendomi',
    'atterrendosi',
    'atterrendoti',
    'atterrendovi',
    'atterrente',
    'atterrenti',
    'atterrentisi',
    'atterrera',
    'atterrerai',
    'atterreranno',
    'atterrerebbe',
    'atterrerei',
    'atterreremmo',
    'atterreremo',
    'atterrereste',
    'atterreresti',
    'atterrerete',
    'atterrero',
    'atterrerò',
    'atterreste',
    'atterresti',
    'atterrete',
    'atterri',
    'atterriamo',
    'atterriamoci',
    'atterriate',
    'atterrii',
    'atterrimenti',
    'atterrimento',
    'atterrimmo',
    'atterrino',
    'atterrira',
    'atterrirai',
    'atterriranno',
    'atterrirci',
    'atterrire',
    'atterrirebbe',
    'atterrirei',
    'atterriremmo',
    'atterriremo',
    'atterrireste',
    'atterriresti',
    'atterrirete',
    'atterrirla',
    'atterrirle',
    'atterrirli',
    'atterrirlo',
    'atterrirmi',
    'atterriro',
    'atterrirono',
    'atterrirsi',
    'atterrirti',
    'atterrirvi',
    'atterrirà',
    'atterrirò',
    'atterrisca',
    'atterriscano',
    'atterrisce',
    'atterrisci',
    'atterrisciti',
    'atterrisco',
    'atterriscono',
    'atterrisse',
    'atterrissero',
    'atterrissi',
    'atterrissimo',
    'atterriste',
    'atterristi',
    'atterrita',
    'atterrite',
    'atterritevi',
    'atterriti',
    'atterrito',
    'atterritomi',
    'atterritoti',
    'atterriva',
    'atterrivamo',
    'atterrivano',
    'atterrivate',
    'atterrivi',
    'atterrivo',
    'atterro',
    'atterzare',
    'attesa',
    'attese',
    'attesero',
    'attesi',
    'attesismi',
    'attesismo',
    'attesista',
    'attesiste',
    'attesisti',
    'atteso',
    'attesoche',
    'attesta',
    'attestabile',
    'attestabili',
    'attestai',
    'attestamenti',
    'attestamento',
    'attestammo',
    'attestando',
    'attestandoci',
    'attestandomi',
    'attestandosi',
    'attestandoti',
    'attestandovi',
    'attestano',
    'attestante',
    'attestanti',
    'attestantisi',
    'attestarci',
    'attestare',
    'attestarmi',
    'attestarono',
    'attestarsi',
    'attestarti',
    'attestarvi',
    'attestasse',
    'attestassero',
    'attestassi',
    'attestassimo',
    'attestaste',
    'attestasti',
    'attestata',
    'attestate',
    'attestatevi',
    'attestati',
    'attestato',
    'attestatomi',
    'attestatore',
    'attestatori',
    'attestatoti',
    'attestatrice',
    'attestatrici',
    'attestatura',
    'attestature',
    'attestava',
    'attestavamo',
    'attestavano',
    'attestavate',
    'attestavi',
    'attestavo',
    'attestazione',
    'attestazioni',
    'attestera',
    'attesterai',
    'attesteranno',
    'attesterebbe',
    'attesterei',
    'attesteremmo',
    'attesteremo',
    'attestereste',
    'attesteresti',
    'attesterete',
    'attestero',
    'attesterò',
    'attesti',
    'attestiamo',
    'attestiamoci',
    'attestiate',
    'attestino',
    'attesto',
    'attettola',
    'attettolando',
    'attettolano',
    'attettolante',
    'attettolare',
    'attettolata',
    'attettolate',
    'attettolati',
    'attettolato',
    'attettolava',
    'atti',
    'attica',
    'atticamente',
    'atticciata',
    'atticciate',
    'atticciati',
    'atticciato',
    'attiche',
    'attici',
    'atticismi',
    'atticismo',
    'atticista',
    'atticiste',
    'atticisti',
    'atticizza',
    'atticizzai',
    'atticizzammo',
    'atticizzando',
    'atticizzano',
    'atticizzante',
    'atticizzanti',
    'atticizzare',
    'atticizzasse',
    'atticizzassi',
    'atticizzaste',
    'atticizzasti',
    'atticizzata',
    'atticizzate',
    'atticizzati',
    'atticizzato',
    'atticizzava',
    'atticizzavi',
    'atticizzavo',
    'atticizzera',
    'atticizzerai',
    'atticizzerei',
    'atticizzero',
    'atticizzi',
    'atticizziamo',
    'atticizziate',
    'atticizzino',
    'atticizzo',
    'attico',
    'attiene',
    'attieni',
    'attieniti',
    'attignere',
    'attigua',
    'attiguamente',
    'attigue',
    'attigui',
    'attiguita',
    'attiguità',
    'attiguo',
    'attila',
    'attilia',
    'attiliana',
    'attiliano',
    'attilio',
    'attilla',
    'attillai',
    'attillammo',
    'attillando',
    'attillandoci',
    'attillandomi',
    'attillandosi',
    'attillandoti',
    'attillandovi',
    'attillano',
    'attillante',
    'attillanti',
    'attillantisi',
    'attillarci',
    'attillare',
    'attillarmi',
    'attillarono',
    'attillarsi',
    'attillarti',
    'attillarvi',
    'attillasse',
    'attillassero',
    'attillassi',
    'attillassimo',
    'attillaste',
    'attillasti',
    'attillata',
    'attillate',
    'attillatevi',
    'attillatezza',
    'attillatezze',
    'attillati',
    'attillatina',
    'attillatine',
    'attillatini',
    'attillatino',
    'attillato',
    'attillatomi',
    'attillatoti',
    'attillatura',
    'attillature',
    'attillava',
    'attillavamo',
    'attillavano',
    'attillavate',
    'attillavi',
    'attillavo',
    'attillera',
    'attillerai',
    'attilleranno',
    'attillerebbe',
    'attillerei',
    'attilleremmo',
    'attilleremo',
    'attillereste',
    'attilleresti',
    'attillerete',
    'attillero',
    'attilli',
    'attilliamo',
    'attilliamoci',
    'attilliate',
    'attillino',
    'attillo',
    'attimi',
    'attimini',
    'attimino',
    'attimo',
    'attinente',
    'attinenti',
    'attinenza',
    'attinenze',
    'attinga',
    'attingano',
    'attinge',
    'attingemmo',
    'attingendo',
    'attingente',
    'attingenti',
    'attingera',
    'attingerai',
    'attingeranno',
    'attingere',
    'attingerebbe',
    'attingerei',
    'attingeremmo',
    'attingeremo',
    'attingereste',
    'attingeresti',
    'attingerete',
    'attingerne',
    'attingero',
    'attingersi',
    'attingesse',
    'attingessero',
    'attingessi',
    'attingessimo',
    'attingeste',
    'attingesti',
    'attingete',
    'attingeva',
    'attingevamo',
    'attingevano',
    'attingevate',
    'attingevi',
    'attingevo',
    'attingi',
    'attingiamo',
    'attingiate',
    'attingibile',
    'attingibili',
    'attingimenti',
    'attingimento',
    'attingitoi',
    'attingitoio',
    'attingo',
    'attingono',
    'attini',
    'attinia',
    'attiniari',
    'attiniaro',
    'attinica',
    'attiniche',
    'attinici',
    'attinicita',
    'attinico',
    'attinide',
    'attinidi',
    'attinie',
    'attinio',
    'attino',
    'attinografi',
    'attinografia',
    'attinografie',
    'attinografo',
    'attinologia',
    'attinometri',
    'attinometria',
    'attinometrie',
    'attinometro',
    'attinomicete',
    'attinomiceti',
    'attinomicosi',
    'attinomorfa',
    'attinomorfe',
    'attinomorfi',
    'attinomorfo',
    'attinon',
    'attinse',
    'attinsero',
    'attinsi',
    'attinta',
    'attinte',
    'attinti',
    'attinto',
    'attintura',
    'attinture',
    'attira',
    'attirai',
    'attirammo',
    'attirando',
    'attirandoci',
    'attirandola',
    'attirandole',
    'attirandoli',
    'attirandolo',
    'attirandomi',
    'attirandosi',
    'attirandoti',
    'attirandovi',
    'attirano',
    'attirante',
    'attiranti',
    'attirantisi',
    'attirarare',
    'attirarci',
    'attirare',
    'attirarla',
    'attirarle',
    'attirarli',
    'attirarlo',
    'attirarmi',
    'attirarono',
    'attirarsi',
    'attirarti',
    'attirarvi',
    'attirasse',
    'attirassero',
    'attirassi',
    'attirassimo',
    'attiraste',
    'attirasti',
    'attirata',
    'attirate',
    'attiratevi',
    'attirati',
    'attirato',
    'attiratomi',
    'attiratoti',
    'attirava',
    'attiravamo',
    'attiravano',
    'attiravate',
    'attiravi',
    'attiravo',
    'attirera',
    'attirerai',
    'attireranno',
    'attirerebbe',
    'attirerei',
    'attireremmo',
    'attireremo',
    'attirereste',
    'attireresti',
    'attirerete',
    'attirero',
    'attirerò',
    'attiri',
    'attiriamo',
    'attiriamoci',
    'attiriate',
    'attirino',
    'attiro',
    'attitudina',
    'attitudinale',
    'attitudinali',
    'attitudine',
    'attitudini',
    'attitudino',
    'attiva',
    'attivabile',
    'attivabili',
    'attivai',
    'attivamente',
    'attivammo',
    'attivando',
    'attivandoci',
    'attivandomi',
    'attivandosi',
    'attivandoti',
    'attivandovi',
    'attivano',
    'attivante',
    'attivanti',
    'attivantisi',
    'attivarci',
    'attivare',
    'attivarmi',
    'attivarono',
    'attivarsi',
    'attivarti',
    'attivarvi',
    'attivasse',
    'attivassero',
    'attivassi',
    'attivassimo',
    'attivaste',
    'attivasti',
    'attivata',
    'attivate',
    'attivatevi',
    'attivati',
    'attivato',
    'attivatomi',
    'attivatore',
    'attivatori',
    'attivatoti',
    'attivatrice',
    'attivatrici',
    'attivava',
    'attivavamo',
    'attivavano',
    'attivavate',
    'attivavi',
    'attivavo',
    'attivazione',
    'attivazioni',
    'attive',
    'attivera',
    'attiverai',
    'attiveranno',
    'attiverebbe',
    'attiverei',
    'attiveremmo',
    'attiveremo',
    'attivereste',
    'attiveresti',
    'attiverete',
    'attivero',
    'attiverò',
    'attivi',
    'attiviamo',
    'attiviamoci',
    'attiviate',
    'attivino',
    'attivismi',
    'attivismo',
    'attivissima',
    'attivissimo',
    'attivista',
    'attiviste',
    'attivisti',
    'attivistica',
    'attivistiche',
    'attivistici',
    'attivistico',
    'attivita',
    'attività',
    'attivizza',
    'attivizzai',
    'attivizzammo',
    'attivizzando',
    'attivizzano',
    'attivizzante',
    'attivizzanti',
    'attivizzare',
    'attivizzasse',
    'attivizzassi',
    'attivizzaste',
    'attivizzasti',
    'attivizzata',
    'attivizzate',
    'attivizzati',
    'attivizzato',
    'attivizzava',
    'attivizzavi',
    'attivizzavo',
    'attivizzera',
    'attivizzerai',
    'attivizzerei',
    'attivizzero',
    'attivizzi',
    'attivizziamo',
    'attivizziate',
    'attivizzino',
    'attivizzo',
    'attivo',
    'attizza',
    'attizzai',
    'attizzamenti',
    'attizzamento',
    'attizzammo',
    'attizzando',
    'attizzano',
    'attizzante',
    'attizzanti',
    'attizzare',
    'attizzarono',
    'attizzasse',
    'attizzassero',
    'attizzassi',
    'attizzassimo',
    'attizzaste',
    'attizzasti',
    'attizzata',
    'attizzate',
    'attizzati',
    'attizzato',
    'attizzatoi',
    'attizzatoio',
    'attizzatore',
    'attizzatori',
    'attizzatrice',
    'attizzatrici',
    'attizzava',
    'attizzavamo',
    'attizzavano',
    'attizzavate',
    'attizzavi',
    'attizzavo',
    'attizzera',
    'attizzerai',
    'attizzeranno',
    'attizzerebbe',
    'attizzerei',
    'attizzeremmo',
    'attizzeremo',
    'attizzereste',
    'attizzeresti',
    'attizzerete',
    'attizzero',
    'attizzi',
    'attizziamo',
    'attizziate',
    'attizzino',
    'attizzo',
    'atto',
    'attolla',
    'attollano',
    'attolle',
    'attollei',
    'attollemmo',
    'attollendo',
    'attollente',
    'attollenti',
    'attollera',
    'attollerai',
    'attolleranno',
    'attollere',
    'attollerebbe',
    'attollerei',
    'attolleremmo',
    'attolleremo',
    'attollereste',
    'attolleresti',
    'attollerete',
    'attollero',
    'attollerono',
    'attollesse',
    'attollessero',
    'attollessi',
    'attollessimo',
    'attolleste',
    'attollesti',
    'attollete',
    'attolleva',
    'attollevamo',
    'attollevano',
    'attollevate',
    'attollevi',
    'attollevo',
    'attolli',
    'attolliamo',
    'attolliate',
    'attollo',
    'attollono',
    'attone',
    'attonimenti',
    'attonimento',
    'attonita',
    'attonite',
    'attoniti',
    'attonito',
    'attorca',
    'attorcano',
    'attorce',
    'attorcemmo',
    'attorcendo',
    'attorcendoci',
    'attorcendomi',
    'attorcendosi',
    'attorcendoti',
    'attorcendovi',
    'attorcente',
    'attorcenti',
    'attorcentisi',
    'attorcera',
    'attorcerai',
    'attorceranno',
    'attorcerci',
    'attorcere',
    'attorcerebbe',
    'attorcerei',
    'attorceremmo',
    'attorceremo',
    'attorcereste',
    'attorceresti',
    'attorcerete',
    'attorcermi',
    'attorcero',
    'attorcersi',
    'attorcerti',
    'attorcervi',
    'attorcesse',
    'attorcessero',
    'attorcessi',
    'attorcessimo',
    'attorceste',
    'attorcesti',
    'attorcete',
    'attorcetevi',
    'attorceva',
    'attorcevamo',
    'attorcevano',
    'attorcevate',
    'attorcevi',
    'attorcevo',
    'attorci',
    'attorciamo',
    'attorciamoci',
    'attorciate',
    'attorcigli',
    'attorciglia',
    'attorcigliai',
    'attorciglino',
    'attorciglio',
    'attorcimenti',
    'attorcimento',
    'attorciti',
    'attorcitura',
    'attorciture',
    'attorco',
    'attorcono',
    'attore',
    'attorea',
    'attoree',
    'attorei',
    'attorelli',
    'attorello',
    'attoreo',
    'attori',
    'attoria',
    'attoriale',
    'attoriali',
    'attorialita',
    'attorie',
    'attorii',
    'attorini',
    'attorino',
    'attorio',
    'attorni',
    'attornia',
    'attorniai',
    'attorniammo',
    'attorniamo',
    'attorniamoci',
    'attorniando',
    'attorniano',
    'attorniante',
    'attornianti',
    'attorniarci',
    'attorniare',
    'attorniarmi',
    'attorniarono',
    'attorniarsi',
    'attorniarti',
    'attorniarvi',
    'attorniasse',
    'attorniassi',
    'attorniaste',
    'attorniasti',
    'attorniata',
    'attorniate',
    'attorniatevi',
    'attorniati',
    'attorniato',
    'attorniatomi',
    'attorniatoti',
    'attorniava',
    'attorniavamo',
    'attorniavano',
    'attorniavate',
    'attorniavi',
    'attorniavo',
    'attorniera',
    'attornierai',
    'attornierei',
    'attornieremo',
    'attornierete',
    'attorniero',
    'attornino',
    'attornio',
    'attorno',
    'attorse',
    'attorsero',
    'attorsi',
    'attorta',
    'attorte',
    'attorti',
    'attortigli',
    'attortiglia',
    'attortigliai',
    'attortiglino',
    'attortiglio',
    'attorto',
    'attortomi',
    'attortoti',
    'attorucci',
    'attoruccio',
    'attorucoli',
    'attorucolo',
    'attosca',
    'attoscai',
    'attoscammo',
    'attoscando',
    'attoscano',
    'attoscante',
    'attoscanti',
    'attoscare',
    'attoscarono',
    'attoscasse',
    'attoscassero',
    'attoscassi',
    'attoscassimo',
    'attoscaste',
    'attoscasti',
    'attoscata',
    'attoscate',
    'attoscati',
    'attoscato',
    'attoscava',
    'attoscavamo',
    'attoscavano',
    'attoscavate',
    'attoscavi',
    'attoscavo',
    'attoschera',
    'attoscherai',
    'attoscherei',
    'attoscheremo',
    'attoscherete',
    'attoschero',
    'attoschi',
    'attoschiamo',
    'attoschiate',
    'attoschino',
    'attosco',
    'attossica',
    'attossicai',
    'attossicammo',
    'attossicando',
    'attossicano',
    'attossicante',
    'attossicanti',
    'attossicare',
    'attossicasse',
    'attossicassi',
    'attossicaste',
    'attossicasti',
    'attossicata',
    'attossicate',
    'attossicati',
    'attossicato',
    'attossicava',
    'attossicavi',
    'attossicavo',
    'attossichera',
    'attossichero',
    'attossichi',
    'attossichino',
    'attossico',
    'attr',
    'attracca',
    'attraccaggi',
    'attraccaggio',
    'attraccai',
    'attraccammo',
    'attraccando',
    'attraccano',
    'attraccante',
    'attraccanti',
    'attraccare',
    'attraccarono',
    'attraccasse',
    'attraccassi',
    'attraccaste',
    'attraccasti',
    'attraccata',
    'attraccate',
    'attraccati',
    'attraccato',
    'attraccava',
    'attraccavamo',
    'attraccavano',
    'attraccavate',
    'attraccavi',
    'attraccavo',
    'attracchera',
    'attraccherai',
    'attraccherei',
    'attracchero',
    'attracchi',
    'attracchiamo',
    'attracchiate',
    'attracchino',
    'attracco',
    'attrae',
    'attraemmo',
    'attraendo',
    'attraendoci',
    'attraendola',
    'attraendole',
    'attraendoli',
    'attraendolo',
    'attraendomi',
    'attraendosi',
    'attraendoti',
    'attraendovi',
    'attraente',
    'attraenti',
    'attraentisi',
    'attraere',
    'attraesse',
    'attraessero',
    'attraessi',
    'attraessimo',
    'attraeste',
    'attraesti',
    'attraete',
    'attraetevi',
    'attraeva',
    'attraevamo',
    'attraevano',
    'attraevate',
    'attraevi',
    'attraevo',
    'attragga',
    'attraggano',
    'attraggo',
    'attraggono',
    'attrai',
    'attraiamo',
    'attraiamoci',
    'attraiate',
    'attraiti',
    'attrappa',
    'attrappando',
    'attrappano',
    'attrappante',
    'attrappare',
    'attrapparono',
    'attrapparsi',
    'attrappata',
    'attrappate',
    'attrappati',
    'attrappato',
    'attrappava',
    'attrappavano',
    'attrappendo',
    'attrappente',
    'attrappenti',
    'attrappi',
    'attrappiamo',
    'attrappiate',
    'attrappii',
    'attrappimmo',
    'attrappira',
    'attrappirai',
    'attrappirci',
    'attrappire',
    'attrappirei',
    'attrappiremo',
    'attrappirete',
    'attrappirmi',
    'attrappiro',
    'attrappirono',
    'attrappirsi',
    'attrappirti',
    'attrappirvi',
    'attrappisca',
    'attrappisce',
    'attrappisci',
    'attrappisco',
    'attrappisse',
    'attrappissi',
    'attrappiste',
    'attrappisti',
    'attrappita',
    'attrappite',
    'attrappitevi',
    'attrappiti',
    'attrappito',
    'attrappitomi',
    'attrappitoti',
    'attrappiva',
    'attrappivamo',
    'attrappivano',
    'attrappivate',
    'attrappivi',
    'attrappivo',
    'attrappo',
    'attrarci',
    'attrarla',
    'attrarle',
    'attrarli',
    'attrarlo',
    'attrarmi',
    'attrarra',
    'attrarrai',
    'attrarranno',
    'attrarre',
    'attrarrebbe',
    'attrarrei',
    'attrarremmo',
    'attrarremo',
    'attrarreste',
    'attrarresti',
    'attrarrete',
    'attrarro',
    'attrarsi',
    'attrarti',
    'attrarvi',
    'attrasse',
    'attrassero',
    'attrassi',
    'attraste',
    'attrasti',
    'attratta',
    'attratte',
    'attratti',
    'attrattiva',
    'attrattive',
    'attrattivi',
    'attrattivo',
    'attratto',
    'attrattomi',
    'attrattore',
    'attrattori',
    'attrattoti',
    'attravero',
    'attraversa',
    'attraversai',
    'attraversano',
    'attraversare',
    'attraversata',
    'attraversate',
    'attraversati',
    'attraversato',
    'attraversava',
    'attraversavi',
    'attraversavo',
    'attraversera',
    'attraversero',
    'attraverserò',
    'attraversi',
    'attraversino',
    'attraverso',
    'attraversò',
    'attrazione',
    'attrazioni',
    'attrezza',
    'attrezzaggi',
    'attrezzaggio',
    'attrezzai',
    'attrezzammo',
    'attrezzando',
    'attrezzano',
    'attrezzante',
    'attrezzanti',
    'attrezzarci',
    'attrezzare',
    'attrezzarla',
    'attrezzarle',
    'attrezzarli',
    'attrezzarlo',
    'attrezzarmi',
    'attrezzarono',
    'attrezzarsi',
    'attrezzarti',
    'attrezzarvi',
    'attrezzasse',
    'attrezzassi',
    'attrezzaste',
    'attrezzasti',
    'attrezzata',
    'attrezzate',
    'attrezzatevi',
    'attrezzati',
    'attrezzato',
    'attrezzatomi',
    'attrezzatoti',
    'attrezzatura',
    'attrezzature',
    'attrezzava',
    'attrezzavamo',
    'attrezzavano',
    'attrezzavate',
    'attrezzavi',
    'attrezzavo',
    'attrezzera',
    'attrezzerai',
    'attrezzerei',
    'attrezzeremo',
    'attrezzerete',
    'attrezzeria',
    'attrezzerie',
    'attrezzero',
    'attrezzerò',
    'attrezzi',
    'attrezziamo',
    'attrezziate',
    'attrezzino',
    'attrezzista',
    'attrezziste',
    'attrezzisti',
    'attrezzo',
    'attribuendo',
    'attribuente',
    'attribuenti',
    'attribui',
    'attribuiamo',
    'attribuiate',
    'attribuibile',
    'attribuibili',
    'attribuii',
    'attribuimmo',
    'attribuira',
    'attribuirai',
    'attribuirci',
    'attribuire',
    'attribuirei',
    'attribuiremo',
    'attribuirete',
    'attribuirla',
    'attribuirmi',
    'attribuiro',
    'attribuirono',
    'attribuirsi',
    'attribuirti',
    'attribuirvi',
    'attribuirà',
    'attribuirò',
    'attribuisca',
    'attribuisce',
    'attribuisci',
    'attribuisco',
    'attribuisse',
    'attribuissi',
    'attribuiste',
    'attribuisti',
    'attribuita',
    'attribuite',
    'attribuitevi',
    'attribuiti',
    'attribuito',
    'attribuitomi',
    'attribuitoti',
    'attribuiva',
    'attribuivamo',
    'attribuivano',
    'attribuivate',
    'attribuivi',
    'attribuivo',
    'attributi',
    'attributiva',
    'attributive',
    'attributivi',
    'attributivo',
    'attributo',
    'attribuzione',
    'attribuzioni',
    'attrice',
    'attricetta',
    'attricette',
    'attrici',
    'attrista',
    'attristai',
    'attristammo',
    'attristando',
    'attristano',
    'attristante',
    'attristanti',
    'attristare',
    'attristarono',
    'attristarsi',
    'attristasse',
    'attristassi',
    'attristaste',
    'attristasti',
    'attristata',
    'attristate',
    'attristati',
    'attristato',
    'attristava',
    'attristavamo',
    'attristavano',
    'attristavate',
    'attristavi',
    'attristavo',
    'attristendo',
    'attristente',
    'attristenti',
    'attristera',
    'attristerai',
    'attristerei',
    'attristeremo',
    'attristerete',
    'attristero',
    'attristerò',
    'attristi',
    'attristiamo',
    'attristiate',
    'attristii',
    'attristimmo',
    'attristino',
    'attristira',
    'attristirai',
    'attristirci',
    'attristire',
    'attristirei',
    'attristiremo',
    'attristirete',
    'attristirmi',
    'attristiro',
    'attristirono',
    'attristirsi',
    'attristirti',
    'attristirvi',
    'attristisca',
    'attristisce',
    'attristisci',
    'attristisco',
    'attristisse',
    'attristissi',
    'attrististe',
    'attrististi',
    'attristita',
    'attristite',
    'attristitevi',
    'attristiti',
    'attristito',
    'attristitomi',
    'attristitoti',
    'attristiva',
    'attristivamo',
    'attristivano',
    'attristivate',
    'attristivi',
    'attristivo',
    'attristo',
    'attrita',
    'attrite',
    'attriti',
    'attrito',
    'attrizione',
    'attrizioni',
    'attruppa',
    'attruppai',
    'attruppammo',
    'attruppando',
    'attruppano',
    'attruppante',
    'attruppanti',
    'attrupparci',
    'attruppare',
    'attrupparmi',
    'attrupparono',
    'attrupparsi',
    'attrupparti',
    'attrupparvi',
    'attruppasse',
    'attruppassi',
    'attruppaste',
    'attruppasti',
    'attruppata',
    'attruppate',
    'attruppatevi',
    'attruppati',
    'attruppato',
    'attruppatomi',
    'attruppatoti',
    'attruppava',
    'attruppavamo',
    'attruppavano',
    'attruppavate',
    'attruppavi',
    'attruppavo',
    'attruppera',
    'attrupperai',
    'attrupperei',
    'attrupperemo',
    'attrupperete',
    'attruppero',
    'attruppi',
    'attruppiamo',
    'attruppiate',
    'attruppino',
    'attruppo',
    'attua',
    'attuabile',
    'attuabili',
    'attuabilita',
    'attuabilità',
    'attuai',
    'attuale',
    'attuali',
    'attualismi',
    'attualismo',
    'attualissima',
    'attualissime',
    'attualissimi',
    'attualissimo',
    'attualista',
    'attualiste',
    'attualisti',
    'attualistica',
    'attualistici',
    'attualistico',
    'attualita',
    'attualità',
    'attualizza',
    'attualizzai',
    'attualizzano',
    'attualizzare',
    'attualizzata',
    'attualizzate',
    'attualizzati',
    'attualizzato',
    'attualizzava',
    'attualizzavi',
    'attualizzavo',
    'attualizzera',
    'attualizzero',
    'attualizzi',
    'attualizzino',
    'attualizzo',
    'attualmente',
    'attuamenti',
    'attuamento',
    'attuammo',
    'attuando',
    'attuandoci',
    'attuandola',
    'attuandole',
    'attuandoli',
    'attuandolo',
    'attuandomi',
    'attuandosi',
    'attuandoti',
    'attuandovi',
    'attuano',
    'attuante',
    'attuanti',
    'attuantisi',
    'attuarci',
    'attuare',
    'attuari',
    'attuaria',
    'attuariale',
    'attuariali',
    'attuarie',
    'attuario',
    'attuarla',
    'attuarle',
    'attuarli',
    'attuarmi',
    'attuarono',
    'attuarsi',
    'attuarti',
    'attuarvi',
    'attuasse',
    'attuassero',
    'attuassi',
    'attuassimo',
    'attuaste',
    'attuasti',
    'attuata',
    'attuate',
    'attuatevi',
    'attuati',
    'attuativa',
    'attuative',
    'attuativi',
    'attuativo',
    'attuato',
    'attuatomi',
    'attuatore',
    'attuatori',
    'attuatoti',
    'attuava',
    'attuavamo',
    'attuavano',
    'attuavate',
    'attuavi',
    'attuavo',
    'attuazione',
    'attuazioni',
    'attuera',
    'attuerai',
    'attueranno',
    'attuerebbe',
    'attuerebbero',
    'attuerei',
    'attueremmo',
    'attueremo',
    'attuereste',
    'attueresti',
    'attuerete',
    'attuero',
    'attuerà',
    'attuerò',
    'attufata',
    'attufate',
    'attufati',
    'attufato',
    'attuffa',
    'attuffando',
    'attuffandosi',
    'attuffano',
    'attuffante',
    'attuffare',
    'attuffarono',
    'attuffarsi',
    'attuffata',
    'attuffate',
    'attuffati',
    'attuffato',
    'attuffava',
    'attuffavano',
    'attuffi',
    'attuffino',
    'attuffo',
    'attui',
    'attuiamo',
    'attuiamoci',
    'attuiate',
    'attuino',
    'attuo',
    'attuosa',
    'attuose',
    'attuosi',
    'attuoso',
    'attuta',
    'attutando',
    'attutandosi',
    'attutano',
    'attutante',
    'attutare',
    'attutarsi',
    'attutata',
    'attutate',
    'attutati',
    'attutato',
    'attutendo',
    'attutendoci',
    'attutendomi',
    'attutendosi',
    'attutendoti',
    'attutendovi',
    'attutente',
    'attutenti',
    'attutentisi',
    'attuti',
    'attutiamo',
    'attutiamoci',
    'attutiate',
    'attutii',
    'attutimenti',
    'attutimento',
    'attutimmo',
    'attutino',
    'attutira',
    'attutirai',
    'attutiranno',
    'attutirci',
    'attutire',
    'attutirebbe',
    'attutirei',
    'attutiremmo',
    'attutiremo',
    'attutireste',
    'attutiresti',
    'attutirete',
    'attutirmi',
    'attutiro',
    'attutirono',
    'attutirsi',
    'attutirti',
    'attutirvi',
    'attutisca',
    'attutiscano',
    'attutisce',
    'attutisci',
    'attutisciti',
    'attutisco',
    'attutiscono',
    'attutisse',
    'attutissero',
    'attutissi',
    'attutissimo',
    'attutiste',
    'attutisti',
    'attutita',
    'attutite',
    'attutitevi',
    'attutiti',
    'attutito',
    'attutitomi',
    'attutitoti',
    'attutiva',
    'attutivamo',
    'attutivano',
    'attutivate',
    'attutivi',
    'attutivo',
    'attuto',
    'attuò',
    'atys',
    'aucuba',
    'aucube',
    'aucupi',
    'aucupio',
    'audace',
    'audacemente',
    'audaci',
    'audacia',
    'audacie',
    'audagna',
    'audelia',
    'audenzia',
    'audenzio',
    'audese',
    'audesi',
    'audette',
    'audi',
    'audiberti',
    'audience',
    'audienza',
    'audimetri',
    'audimetro',
    'audino',
    'audio',
    'audiogramma',
    'audiogrammi',
    'audiolesa',
    'audiolese',
    'audiolesi',
    'audioleso',
    'audiolibri',
    'audiolibro',
    'audiologa',
    'audiologhe',
    'audiologhi',
    'audiologi',
    'audiologia',
    'audiologica',
    'audiologiche',
    'audiologici',
    'audiologico',
    'audiologie',
    'audiologo',
    'audiometri',
    'audiometria',
    'audiometrica',
    'audiometrici',
    'audiometrico',
    'audiometrie',
    'audiometro',
    'audioprotesi',
    'audiovideo',
    'audiovisiva',
    'audiovisive',
    'audiovisivi',
    'audiovisivo',
    'audiovisuale',
    'audiovisuali',
    'audire',
    'audisio',
    'audit',
    'auditel',
    'auditing',
    'auditiva',
    'auditive',
    'auditivi',
    'auditivo',
    'auditor',
    'auditore',
    'auditori',
    'auditoria',
    'auditorio',
    'auditorium',
    'auditrice',
    'auditrici',
    'audits',
    'audizione',
    'audizioni',
    'auff',
    'auffa',
    'auge',
    'augella',
    'augelle',
    'augelletti',
    'augelletto',
    'augelli',
    'augellini',
    'augellino',
    'augello',
    'augendi',
    'augendo',
    'auggiare',
    'augi',
    'augite',
    'augiti',
    'augna',
    'augnai',
    'augnammo',
    'augnando',
    'augnano',
    'augnante',
    'augnanti',
    'augnare',
    'augnarono',
    'augnasse',
    'augnassero',
    'augnassi',
    'augnassimo',
    'augnaste',
    'augnasti',
    'augnata',
    'augnate',
    'augnati',
    'augnato',
    'augnatura',
    'augnature',
    'augnava',
    'augnavamo',
    'augnavano',
    'augnavate',
    'augnavi',
    'augnavo',
    'augnera',
    'augnerai',
    'augneranno',
    'augnerebbe',
    'augnerebbero',
    'augnerei',
    'augneremmo',
    'augneremo',
    'augnereste',
    'augneresti',
    'augnerete',
    'augnero',
    'augni',
    'augniamo',
    'augniate',
    'augnino',
    'augno',
    'augumentare',
    'augumento',
    'augura',
    'augurabile',
    'augurabili',
    'augurai',
    'augurale',
    'augurali',
    'auguralmente',
    'augurammo',
    'augurando',
    'augurandoci',
    'augurandogli',
    'augurandole',
    'augurandomi',
    'augurandosi',
    'augurandoti',
    'augurandovi',
    'augurano',
    'augurante',
    'auguranti',
    'augurantisi',
    'augurarci',
    'augurare',
    'augurargli',
    'augurarle',
    'augurarmi',
    'augurarono',
    'augurarsi',
    'augurarti',
    'augurarvi',
    'augurasse',
    'augurassero',
    'augurassi',
    'augurassimo',
    'auguraste',
    'augurasti',
    'augurata',
    'augurate',
    'auguratevi',
    'augurati',
    'augurato',
    'auguratomi',
    'auguratore',
    'auguratori',
    'auguratoti',
    'auguratrice',
    'auguratrici',
    'augurava',
    'auguravamo',
    'auguravano',
    'auguravate',
    'auguravi',
    'auguravo',
    'augure',
    'augurera',
    'augurerai',
    'augureranno',
    'augurerebbe',
    'augurerei',
    'augureremmo',
    'augureremo',
    'augurereste',
    'augureresti',
    'augurerete',
    'augurero',
    'augurerò',
    'auguri',
    'auguriamo',
    'auguriamoci',
    'auguriate',
    'augurino',
    'augurio',
    'auguro',
    'augurosa',
    'augurose',
    'augurosi',
    'auguroso',
    'augusta',
    'augustale',
    'augustali',
    'augustana',
    'augustane',
    'augustani',
    'augustano',
    'auguste',
    'augustea',
    'augustee',
    'augustei',
    'augusteo',
    'augusti',
    'augustina',
    'augustino',
    'augusto',
    'aukland',
    'aula',
    'aule',
    'aulendo',
    'aulente',
    'aulenti',
    'auleta',
    'aulete',
    'auleti',
    'auletica',
    'auletiche',
    'auletici',
    'auletico',
    'auletride',
    'auletridi',
    'auletta',
    'aulette',
    'auliamo',
    'aulica',
    'aulicamente',
    'auliche',
    'aulici',
    'aulico',
    'auliffe',
    'aulire',
    'aulisce',
    'aulisci',
    'aulisco',
    'auliscono',
    'aulite',
    'aulito',
    'auliva',
    'aulivamo',
    'aulivano',
    'aulivate',
    'aulivi',
    'aulivo',
    'aulo',
    'auloi',
    'aulos',
    'aumenta',
    'aumentabile',
    'aumentabili',
    'aumentai',
    'aumentammo',
    'aumentando',
    'aumentandoci',
    'aumentandola',
    'aumentandole',
    'aumentandoli',
    'aumentandolo',
    'aumentandomi',
    'aumentandosi',
    'aumentandoti',
    'aumentandovi',
    'aumentano',
    'aumentante',
    'aumentanti',
    'aumentantisi',
    'aumentarci',
    'aumentare',
    'aumentarla',
    'aumentarle',
    'aumentarli',
    'aumentarlo',
    'aumentarmi',
    'aumentarne',
    'aumentarono',
    'aumentarsi',
    'aumentarti',
    'aumentarvi',
    'aumentasse',
    'aumentassero',
    'aumentassi',
    'aumentassimo',
    'aumentaste',
    'aumentasti',
    'aumentata',
    'aumentate',
    'aumentatevi',
    'aumentati',
    'aumentativa',
    'aumentative',
    'aumentativi',
    'aumentativo',
    'aumentato',
    'aumentatomi',
    'aumentatore',
    'aumentatori',
    'aumentatoti',
    'aumentatrice',
    'aumentatrici',
    'aumentava',
    'aumentavamo',
    'aumentavano',
    'aumentavate',
    'aumentavi',
    'aumentavo',
    'aumentazione',
    'aumentazioni',
    'aumentera',
    'aumenterai',
    'aumenteranno',
    'aumenterebbe',
    'aumenterei',
    'aumenteremmo',
    'aumenteremo',
    'aumentereste',
    'aumenteresti',
    'aumenterete',
    'aumentero',
    'aumenterà',
    'aumenti',
    'aumentiamo',
    'aumentiamoci',
    'aumentiate',
    'aumentino',
    'aumentista',
    'aumentiste',
    'aumentisti',
    'aumento',
    'aumoniere',
    'auna',
    'aunare',
    'aune',
    'aunghiare',
    'aura',
    'aurale',
    'aurali',
    'aurata',
    'aurate',
    'aurati',
    'aurato',
    'aure',
    'aurea',
    'auree',
    'aurei',
    'aurelia',
    'aureliana',
    'aureliano',
    'aurelio',
    'aureo',
    'aureofaciens',
    'aureola',
    'aureolai',
    'aureolammo',
    'aureolando',
    'aureolano',
    'aureolante',
    'aureolanti',
    'aureolare',
    'aureolari',
    'aureolarono',
    'aureolasse',
    'aureolassero',
    'aureolassi',
    'aureolassimo',
    'aureolaste',
    'aureolasti',
    'aureolata',
    'aureolate',
    'aureolati',
    'aureolato',
    'aureolava',
    'aureolavamo',
    'aureolavano',
    'aureolavate',
    'aureolavi',
    'aureolavo',
    'aureole',
    'aureolera',
    'aureolerai',
    'aureoleranno',
    'aureolerebbe',
    'aureolerei',
    'aureoleremmo',
    'aureoleremo',
    'aureolereste',
    'aureoleresti',
    'aureolerete',
    'aureolero',
    'aureoli',
    'aureoliamo',
    'aureoliate',
    'aureolino',
    'aureolo',
    'aureomicina',
    'aureomicine',
    'auretta',
    'aurette',
    'aureus',
    'auri',
    'aurica',
    'auricalco',
    'auriche',
    'aurici',
    'aurico',
    'auricola',
    'auricolante',
    'auricolare',
    'auricolari',
    'auricole',
    'aurifera',
    'aurifere',
    'auriferi',
    'aurifero',
    'auriga',
    'aurighi',
    'aurignac',
    'aurignaciana',
    'aurignaciane',
    'aurignaciani',
    'aurignaciano',
    'aurignaziana',
    'aurignaziane',
    'aurignaziani',
    'aurignaziano',
    'aurino',
    'aurismo',
    'aurita',
    'aurite',
    'auriti',
    'aurito',
    'auro',
    'aurora',
    'aurorale',
    'aurorali',
    'auroralita',
    'aurore',
    'auroterapia',
    'ausa',
    'ausante',
    'ausare',
    'auschwitz',
    'ausculta',
    'auscultai',
    'auscultammo',
    'auscultando',
    'auscultano',
    'auscultante',
    'auscultanti',
    'auscultare',
    'auscultarono',
    'auscultasse',
    'auscultassi',
    'auscultaste',
    'auscultasti',
    'auscultata',
    'auscultate',
    'auscultati',
    'auscultato',
    'auscultava',
    'auscultavamo',
    'auscultavano',
    'auscultavate',
    'auscultavi',
    'auscultavo',
    'auscultera',
    'ausculterai',
    'ausculterei',
    'ausculteremo',
    'ausculterete',
    'auscultero',
    'ausculti',
    'auscultiamo',
    'auscultiate',
    'auscultino',
    'ausculto',
    'ause',
    'ausi',
    'ausiello',
    'ausili',
    'ausilia',
    'ausiliante',
    'ausiliare',
    'ausiliari',
    'ausiliaria',
    'ausiliarie',
    'ausiliarii',
    'ausiliario',
    'ausiliatore',
    'ausiliatori',
    'ausiliatrice',
    'ausiliatrici',
    'ausilio',
    'auso',
    'ausoni',
    'ausonia',
    'ausonie',
    'ausonio',
    'auspica',
    'auspicabile',
    'auspicabili',
    'auspicai',
    'auspicale',
    'auspicali',
    'auspicammo',
    'auspicando',
    'auspicano',
    'auspicante',
    'auspicanti',
    'auspicare',
    'auspicarono',
    'auspicasse',
    'auspicassero',
    'auspicassi',
    'auspicassimo',
    'auspicaste',
    'auspicasti',
    'auspicata',
    'auspicate',
    'auspicati',
    'auspicato',
    'auspicava',
    'auspicavamo',
    'auspicavano',
    'auspicavate',
    'auspicavi',
    'auspicavo',
    'auspice',
    'auspichera',
    'auspicherai',
    'auspicherei',
    'auspicheremo',
    'auspicherete',
    'auspichero',
    'auspichi',
    'auspichiamo',
    'auspichiate',
    'auspichino',
    'auspici',
    'auspicii',
    'auspicio',
    'auspico',
    'auspizi',
    'auspizio',
    'aussenzio',
    'aussina',
    'austera',
    'austeramente',
    'austere',
    'austeri',
    'austerita',
    'austerity',
    'austerità',
    'austero',
    'austori',
    'austorio',
    'australe',
    'australi',
    'australia',
    'australiana',
    'australiane',
    'australiani',
    'australiano',
    'australide',
    'australidi',
    'australoide',
    'australoidi',
    'austri',
    'austria',
    'austriaca',
    'austriacante',
    'austriacanti',
    'austriache',
    'austriaci',
    'austriaco',
    'austro',
    'autambulanza',
    'autambulanze',
    'autarchia',
    'autarchica',
    'autarchiche',
    'autarchici',
    'autarchico',
    'autarchie',
    'autarchizza',
    'autarchizzai',
    'autarchizzi',
    'autarchizzo',
    'autentica',
    'autenticai',
    'autenticammo',
    'autenticando',
    'autenticano',
    'autenticante',
    'autenticanti',
    'autenticare',
    'autenticarti',
    'autenticasse',
    'autenticassi',
    'autenticaste',
    'autenticasti',
    'autenticata',
    'autenticate',
    'autenticati',
    'autenticato',
    'autenticava',
    'autenticavi',
    'autenticavo',
    'autentiche',
    'autentichera',
    'autentichero',
    'autentichi',
    'autentichino',
    'autentici',
    'autenticita',
    'autenticità',
    'autentico',
    'autentifica',
    'autentificai',
    'autentifichi',
    'autentifico',
    'authorities',
    'authority',
    'autiere',
    'autieri',
    'autismi',
    'autismo',
    'autista',
    'autiste',
    'autisti',
    'autistica',
    'autistiche',
    'autistici',
    'autistico',
    'auto',
    'autoaccusa',
    'autoaccusata',
    'autoaccusate',
    'autoaccusati',
    'autoaccusato',
    'autoaccuse',
    'autoadesiva',
    'autoadesive',
    'autoadesivi',
    'autoadesivo',
    'autoalimenta',
    'autoanalisi',
    'autoassicura',
    'autoassicuri',
    'autoassicuro',
    'autobiografa',
    'autobiografe',
    'autobiografi',
    'autobiografo',
    'autoblinda',
    'autoblindata',
    'autoblindate',
    'autoblindati',
    'autoblindato',
    'autoblinde',
    'autoblindo',
    'autoblu',
    'autobomba',
    'autobotte',
    'autobotti',
    'autobruchi',
    'autobruco',
    'autobus',
    'autocalmiere',
    'autocalmieri',
    'autocalunnia',
    'autocalunnie',
    'autocampeggi',
    'autocandidò',
    'autocaravan',
    'autocarrata',
    'autocarrate',
    'autocarrati',
    'autocarrato',
    'autocarri',
    'autocarro',
    'autocattura',
    'autocatture',
    'autocefala',
    'autocefale',
    'autocefali',
    'autocefalia',
    'autocefalie',
    'autocefalo',
    'autocensura',
    'autocensure',
    'autocentri',
    'autocentro',
    'autocercante',
    'autocercanti',
    'autocestelli',
    'autocestello',
    'autocisterna',
    'autocisterne',
    'autocita',
    'autocitai',
    'autocitammo',
    'autocitando',
    'autocitano',
    'autocitarci',
    'autocitare',
    'autocitarmi',
    'autocitarono',
    'autocitarsi',
    'autocitarti',
    'autocitarvi',
    'autocitasse',
    'autocitassi',
    'autocitaste',
    'autocitasti',
    'autocitata',
    'autocitate',
    'autocitatevi',
    'autocitati',
    'autocitato',
    'autocitatomi',
    'autocitatoti',
    'autocitava',
    'autocitavamo',
    'autocitavano',
    'autocitavate',
    'autocitavi',
    'autocitavo',
    'autocitera',
    'autociterai',
    'autociterei',
    'autociteremo',
    'autociterete',
    'autocitero',
    'autociti',
    'autocitiamo',
    'autocitiate',
    'autocitino',
    'autocito',
    'autocivetta',
    'autoclave',
    'autoclavi',
    'autoclavista',
    'autoclaviste',
    'autoclavisti',
    'autocolonna',
    'autocolonne',
    'autocomandi',
    'autocomando',
    'autoconsumi',
    'autoconsumo',
    'autoconvinta',
    'autoconvoca',
    'autoconvoco',
    'autoconvogli',
    'autocopiante',
    'autocopianti',
    'autocora',
    'autocore',
    'autocori',
    'autocoria',
    'autocorie',
    'autocoro',
    'autocorriera',
    'autocorriere',
    'autocrate',
    'autocrati',
    'autocratica',
    'autocratiche',
    'autocratici',
    'autocratico',
    'autocrazia',
    'autocrazie',
    'autocrina',
    'autocritica',
    'autocritiche',
    'autocritici',
    'autocritico',
    'autocross',
    'autoctisi',
    'autoctona',
    'autoctone',
    'autoctoni',
    'autoctonia',
    'autoctonie',
    'autoctonismi',
    'autoctonismo',
    'autoctono',
    'autodafe',
    'autodefini',
    'autodefinii',
    'autodefinira',
    'autodefinire',
    'autodefiniro',
    'autodefinita',
    'autodefinite',
    'autodefiniti',
    'autodefinito',
    'autodefiniva',
    'autodefinivi',
    'autodefinivo',
    'autodenigra',
    'autodenigri',
    'autodenigro',
    'autodenunce',
    'autodenunci',
    'autodenuncia',
    'autodenuncie',
    'autodenuncio',
    'autodenunzia',
    'autodenunzie',
    'autodiagnosi',
    'autodidatta',
    'autodidatte',
    'autodidatti',
    'autodifesa',
    'autodifese',
    'autodina',
    'autodine',
    'autodromi',
    'autodromo',
    'autoeccita',
    'autoeccitai',
    'autoeccitano',
    'autoeccitare',
    'autoeccitata',
    'autoeccitate',
    'autoeccitati',
    'autoeccitato',
    'autoeccitava',
    'autoeccitavi',
    'autoeccitavo',
    'autoeccitera',
    'autoeccitero',
    'autoecciti',
    'autoeccitino',
    'autoeccito',
    'autoemoteca',
    'autoemoteche',
    'autoerotismi',
    'autoerotismo',
    'autoesame',
    'autoescluda',
    'autoesclude',
    'autoescludi',
    'autoescludo',
    'autoesclusa',
    'autoescluse',
    'autoesclusi',
    'autoescluso',
    'autofaga',
    'autofaghe',
    'autofagi',
    'autofagia',
    'autofagie',
    'autofago',
    'autofagosoma',
    'autofagosomi',
    'autofattura',
    'autofatture',
    'autofficina',
    'autofficine',
    'autofinanzi',
    'autofinanzia',
    'autofinanzio',
    'autoflagelli',
    'autoflagello',
    'autofocus',
    'autofurgone',
    'autofurgoni',
    'autogamia',
    'autogamie',
    'autogena',
    'autogene',
    'autogenesi',
    'autogeni',
    'autogeno',
    'autogestendo',
    'autogestente',
    'autogestenti',
    'autogesti',
    'autogestiamo',
    'autogestiate',
    'autogestii',
    'autogestimmo',
    'autogestione',
    'autogestioni',
    'autogestira',
    'autogestirai',
    'autogestirci',
    'autogestire',
    'autogestirei',
    'autogestirmi',
    'autogestiro',
    'autogestirsi',
    'autogestirti',
    'autogestirvi',
    'autogestisca',
    'autogestisce',
    'autogestisci',
    'autogestisco',
    'autogestisse',
    'autogestissi',
    'autogestiste',
    'autogestisti',
    'autogestita',
    'autogestite',
    'autogestiti',
    'autogestito',
    'autogestiva',
    'autogestivi',
    'autogestivo',
    'autogiri',
    'autogiro',
    'autogol',
    'autogonia',
    'autogoverna',
    'autogovernai',
    'autogoverni',
    'autogoverno',
    'autografa',
    'autografai',
    'autografammo',
    'autografando',
    'autografano',
    'autografante',
    'autografanti',
    'autografare',
    'autografasse',
    'autografassi',
    'autografaste',
    'autografasti',
    'autografata',
    'autografate',
    'autografati',
    'autografato',
    'autografava',
    'autografavi',
    'autografavo',
    'autografe',
    'autografera',
    'autograferai',
    'autograferei',
    'autografero',
    'autografi',
    'autografia',
    'autografiamo',
    'autografiate',
    'autografica',
    'autografiche',
    'autografici',
    'autografico',
    'autografie',
    'autografino',
    'autografo',
    'autogrill',
    'autogru',
    'autogruista',
    'autogruiste',
    'autogruisti',
    'autoguida',
    'autoguidata',
    'autoguidate',
    'autoguidati',
    'autoguidato',
    'autoguide',
    'autoica',
    'autoiche',
    'autoici',
    'autoicismo',
    'autoico',
    'autoimmmuni',
    'autoimmune',
    'autoimmuni',
    'autoimmunita',
    'autoimmunità',
    'autoimpone',
    'autoimporsi',
    'autoimpose',
    'autoimposero',
    'autoimposta',
    'autoimposte',
    'autoimposti',
    'autoimposto',
    'autoincendi',
    'autoincendio',
    'autoincensa',
    'autoincensai',
    'autoincensi',
    'autoincenso',
    'autoindotta',
    'autoindotte',
    'autoindotti',
    'autoindotto',
    'autoinganni',
    'autoinganno',
    'autoinnesti',
    'autoinnesto',
    'autoipnosi',
    'autoironia',
    'autoironica',
    'autoironiche',
    'autoironici',
    'autoironico',
    'autoironie',
    'autolatra',
    'autolatri',
    'autolatria',
    'autolatrie',
    'autolavaggi',
    'autolavaggio',
    'autolesione',
    'autolesioni',
    'autolesiva',
    'autolesive',
    'autolesivi',
    'autolesivo',
    'autolettiga',
    'autolettighe',
    'autolibri',
    'autolibro',
    'autolinea',
    'autolinee',
    'autolisi',
    'autolisosoma',
    'autolisosomi',
    'autolivelli',
    'autolivello',
    'autologa',
    'autologhe',
    'autologhi',
    'autologo',
    'automa',
    'automatica',
    'automatiche',
    'automatici',
    'automaticita',
    'automaticità',
    'automatico',
    'automatismi',
    'automatismo',
    'automatizza',
    'automatizzai',
    'automatizzi',
    'automatizzo',
    'automato',
    'automazione',
    'automazioni',
    'automedonte',
    'automedonti',
    'automezzi',
    'automezzo',
    'automi',
    'automobile',
    'automobili',
    'automobilina',
    'automobiline',
    'automontata',
    'automontate',
    'automontati',
    'automontato',
    'automorfa',
    'automorfe',
    'automorfi',
    'automorfismi',
    'automorfismo',
    'automorfo',
    'automostra',
    'automotore',
    'automotori',
    'automotrice',
    'automotrici',
    'autonica',
    'autoniche',
    'autonoleggi',
    'autonoleggio',
    'autonoma',
    'autonome',
    'autonomi',
    'autonomia',
    'autonomie',
    'autonomismi',
    'autonomismo',
    'autonomista',
    'autonomiste',
    'autonomisti',
    'autonomo',
    'autoparchi',
    'autoparco',
    'autoparodia',
    'autoparodie',
    'autopiani',
    'autopiano',
    'autopilota',
    'autopiloti',
    'autopista',
    'autopiste',
    'autoplastia',
    'autoplastie',
    'autopoiesi',
    'autopoietica',
    'autopoietici',
    'autopoietico',
    'autopompa',
    'autopompe',
    'autoportante',
    'autoportanti',
    'autoportata',
    'autoportate',
    'autoportati',
    'autoportato',
    'autoporti',
    'autoporto',
    'autopropulsa',
    'autopropulse',
    'autopropulsi',
    'autopropulso',
    'autopsia',
    'autopsie',
    'autoptica',
    'autoptiche',
    'autoptici',
    'autoptico',
    'autopubblica',
    'autopulente',
    'autopulenti',
    'autopullman',
    'autopullmann',
    'autopunitiva',
    'autopunitive',
    'autopunitivi',
    'autopunitivo',
    'autoradio',
    'autoraduni',
    'autoraduno',
    'autore',
    'autoreattore',
    'autoreattori',
    'autoreggente',
    'autoreggenti',
    'autoregolata',
    'autoregolate',
    'autoregolati',
    'autoregolato',
    'autoreparti',
    'autoreparto',
    'autorete',
    'autoreti',
    'autoreverse',
    'autorevole',
    'autorevoli',
    'autori',
    'autoriale',
    'autoriali',
    'autoricambi',
    'autoricambio',
    'autoricrea',
    'autoridotta',
    'autoridotte',
    'autoridotti',
    'autoridotto',
    'autoridurre',
    'autoridursi',
    'autoriforma',
    'autoriforme',
    'autorimessa',
    'autorimesse',
    'autorio',
    'autorita',
    'autoritari',
    'autoritaria',
    'autoritarie',
    'autoritario',
    'autoritativa',
    'autoritative',
    'autoritativi',
    'autoritativo',
    'autoritratti',
    'autoritratto',
    'autorità',
    'autorizza',
    'autorizzai',
    'autorizzammo',
    'autorizzando',
    'autorizzano',
    'autorizzante',
    'autorizzanti',
    'autorizzarci',
    'autorizzare',
    'autorizzarla',
    'autorizzarle',
    'autorizzarli',
    'autorizzarlo',
    'autorizzarmi',
    'autorizzarsi',
    'autorizzarti',
    'autorizzarvi',
    'autorizzasse',
    'autorizzassi',
    'autorizzaste',
    'autorizzasti',
    'autorizzata',
    'autorizzate',
    'autorizzati',
    'autorizzato',
    'autorizzava',
    'autorizzavi',
    'autorizzavo',
    'autorizzera',
    'autorizzerai',
    'autorizzerei',
    'autorizzero',
    'autorizzerò',
    'autorizzi',
    'autorizziamo',
    'autorizziate',
    'autorizzino',
    'autorizzo',
    'autorizzò',
    'autorucci',
    'autoruccio',
    'autorucoli',
    'autorucolo',
    'autosalone',
    'autosaloni',
    'autoscafi',
    'autoscafo',
    'autoscala',
    'autoscale',
    'autoscatti',
    'autoscatto',
    'autoscontri',
    'autoscontro',
    'autoscuola',
    'autoscuole',
    'autoservizi',
    'autoservizio',
    'autosili',
    'autosilo',
    'autosita',
    'autositi',
    'autoslitta',
    'autoslitte',
    'autosnodati',
    'autosnodato',
    'autosoccorsi',
    'autosoccorso',
    'autosole',
    'autosomica',
    'autosomiche',
    'autosospesa',
    'autosospese',
    'autosospesi',
    'autosospeso',
    'autospeaker',
    'autossita',
    'autostarter',
    'autostazione',
    'autostazioni',
    'autostelli',
    'autostello',
    'autostima',
    'autostop',
    'autostrada',
    'autostradale',
    'autostradali',
    'autostrade',
    'autotassa',
    'autotassai',
    'autotassammo',
    'autotassando',
    'autotassano',
    'autotassarci',
    'autotassare',
    'autotassarmi',
    'autotassarsi',
    'autotassarti',
    'autotassarvi',
    'autotassasse',
    'autotassassi',
    'autotassaste',
    'autotassasti',
    'autotassata',
    'autotassate',
    'autotassati',
    'autotassato',
    'autotassava',
    'autotassavi',
    'autotassavo',
    'autotassera',
    'autotasserai',
    'autotasserei',
    'autotassero',
    'autotassi',
    'autotassiamo',
    'autotassiate',
    'autotassino',
    'autotasso',
    'autotelai',
    'autotelaio',
    'autotelefoni',
    'autotelefono',
    'autotest',
    'autotomia',
    'autotomie',
    'autotrainata',
    'autotrainate',
    'autotrainati',
    'autotrainato',
    'autotraini',
    'autotraino',
    'autotreni',
    'autotrenista',
    'autotreniste',
    'autotrenisti',
    'autotreno',
    'autotrofa',
    'autotrofe',
    'autotrofi',
    'autotrofia',
    'autotrofie',
    'autotrofismi',
    'autotrofismo',
    'autotrofo',
    'autotutela',
    'autotutele',
    'autovaccini',
    'autovaccino',
    'autovalore',
    'autoveicoli',
    'autoveicolo',
    'autovelox',
    'autovettura',
    'autovetture',
    'autrice',
    'autrici',
    'autunite',
    'autuniti',
    'autunnale',
    'autunnali',
    'autunni',
    'autunno',
    'auvergne',
    'auxina',
    'auxine',
    'auxo',
    'auxologa',
    'auxologhe',
    'auxologi',
    'auxologia',
    'auxologica',
    'auxologiche',
    'auxologici',
    'auxologico',
    'auxologie',
    'auxologo',
    'auxometria',
    'auxometrie',
    'auxopatia',
    'auxopatie',
    'avaccera',
    'avaccerai',
    'avacceranno',
    'avaccerebbe',
    'avaccerei',
    'avacceremmo',
    'avacceremo',
    'avaccereste',
    'avacceresti',
    'avaccerete',
    'avaccero',
    'avacci',
    'avaccia',
    'avacciai',
    'avacciammo',
    'avacciamo',
    'avacciando',
    'avacciano',
    'avacciante',
    'avaccianti',
    'avacciare',
    'avacciarono',
    'avacciarsi',
    'avacciasse',
    'avacciassero',
    'avacciassi',
    'avacciassimo',
    'avacciaste',
    'avacciasti',
    'avacciata',
    'avacciate',
    'avacciati',
    'avacciato',
    'avacciava',
    'avacciavamo',
    'avacciavano',
    'avacciavate',
    'avacciavi',
    'avacciavo',
    'avaccino',
    'avaccio',
    'avalla',
    'avallai',
    'avallammo',
    'avallando',
    'avallano',
    'avallante',
    'avallanti',
    'avallare',
    'avallarono',
    'avallasse',
    'avallassero',
    'avallassi',
    'avallassimo',
    'avallaste',
    'avallasti',
    'avallata',
    'avallate',
    'avallati',
    'avallato',
    'avallava',
    'avallavamo',
    'avallavano',
    'avallavate',
    'avallavi',
    'avallavo',
    'avallera',
    'avallerai',
    'avalleranno',
    'avallerebbe',
    'avallerei',
    'avalleremmo',
    'avalleremo',
    'avallereste',
    'avalleresti',
    'avallerete',
    'avallero',
    'avallerò',
    'avalli',
    'avalliamo',
    'avalliate',
    'avallino',
    'avallo',
    'avalutativo',
    'avam',
    'avambagni',
    'avambagno',
    'avambecchi',
    'avambecco',
    'avambracci',
    'avambraccio',
    'avampare',
    'avampiede',
    'avamporti',
    'avamporto',
    'avamposti',
    'avamposto',
    'avan',
    'avana',
    'avancarica',
    'avancariche',
    'avance',
    'avances',
    'avancini',
    'avancorpi',
    'avancorpo',
    'avanese',
    'avanesi',
    'avanguardia',
    'avanguardie',
    'avania',
    'avanie',
    'avannotti',
    'avannotto',
    'avanscena',
    'avanscene',
    'avanscoperta',
    'avanscoperte',
    'avanscorta',
    'avanscorte',
    'avant',
    'avantaggio',
    'avante',
    'avantesti',
    'avantesto',
    'avanti',
    'avantielenco',
    'avantieri',
    'avantreni',
    'avantreno',
    'avanvomere',
    'avanvomeri',
    'avanza',
    'avanzai',
    'avanzamenti',
    'avanzamento',
    'avanzammo',
    'avanzando',
    'avanzandoci',
    'avanzandola',
    'avanzandole',
    'avanzandoli',
    'avanzandolo',
    'avanzandomi',
    'avanzandosi',
    'avanzandoti',
    'avanzandovi',
    'avanzano',
    'avanzante',
    'avanzanti',
    'avanzantisi',
    'avanzarci',
    'avanzare',
    'avanzarla',
    'avanzarle',
    'avanzarli',
    'avanzarlo',
    'avanzarmi',
    'avanzarono',
    'avanzarsi',
    'avanzarti',
    'avanzarvi',
    'avanzasse',
    'avanzassero',
    'avanzassi',
    'avanzassimo',
    'avanzaste',
    'avanzasti',
    'avanzata',
    'avanzate',
    'avanzatevi',
    'avanzati',
    'avanzaticci',
    'avanzaticcio',
    'avanzato',
    'avanzatomi',
    'avanzatoti',
    'avanzava',
    'avanzavamo',
    'avanzavano',
    'avanzavate',
    'avanzavi',
    'avanzavo',
    'avanzera',
    'avanzerai',
    'avanzeranno',
    'avanzerebbe',
    'avanzerei',
    'avanzeremmo',
    'avanzeremo',
    'avanzereste',
    'avanzeresti',
    'avanzerete',
    'avanzero',
    'avanzerà',
    'avanzerò',
    'avanzi',
    'avanziamo',
    'avanziamoci',
    'avanziate',
    'avanzino',
    'avanzo',
    'avanzume',
    'avanzumi',
    'avara',
    'avaracce',
    'avaracci',
    'avaraccia',
    'avaraccio',
    'avaramente',
    'avarami',
    'avare',
    'avari',
    'avaria',
    'avariai',
    'avariammo',
    'avariamo',
    'avariamoci',
    'avariando',
    'avariandoci',
    'avariandomi',
    'avariandosi',
    'avariandoti',
    'avariandovi',
    'avariano',
    'avariante',
    'avarianti',
    'avariantisi',
    'avariarci',
    'avariare',
    'avariarmi',
    'avariarono',
    'avariarsi',
    'avariarti',
    'avariarvi',
    'avariasse',
    'avariassero',
    'avariassi',
    'avariassimo',
    'avariaste',
    'avariasti',
    'avariata',
    'avariate',
    'avariatevi',
    'avariati',
    'avariato',
    'avariatomi',
    'avariatoti',
    'avariava',
    'avariavamo',
    'avariavano',
    'avariavate',
    'avariavi',
    'avariavo',
    'avarie',
    'avariera',
    'avarierai',
    'avarieranno',
    'avarierebbe',
    'avarierei',
    'avarieremmo',
    'avarieremo',
    'avariereste',
    'avarieresti',
    'avarierete',
    'avariero',
    'avarino',
    'avario',
    'avarizia',
    'avarizie',
    'avaro',
    'avarone',
    'avaroni',
    'avarucce',
    'avarucci',
    'avaruccia',
    'avaruccio',
    'avea',
    'avean',
    'aveano',
    'avelia',
    'avelina',
    'avelino',
    'avelio',
    'avellana',
    'avellane',
    'avellani',
    'avellano',
    'avellente',
    'avellere',
    'avelli',
    'avellina',
    'avellinese',
    'avellinesi',
    'avellino',
    'avello',
    'avelse',
    'avemaria',
    'avemarie',
    'avemmaria',
    'avemmarie',
    'avemmo',
    'avena',
    'avendo',
    'avendocelo',
    'avendoci',
    'avendogliele',
    'avendola',
    'avendole',
    'avendoli',
    'avendolo',
    'avendomi',
    'avendone',
    'avendosi',
    'avendoti',
    'avendovi',
    'avendrace',
    'avene',
    'avente',
    'aventesi',
    'aventi',
    'aventina',
    'aventini',
    'aventiniana',
    'aventiniane',
    'aventiniani',
    'aventiniano',
    'aventinismi',
    'aventinismo',
    'aventinista',
    'aventiniste',
    'aventinisti',
    'aventino',
    'aventisi',
    'aver',
    'averaldo',
    'averardo',
    'avercela',
    'avercelo',
    'avercene',
    'averci',
    'avere',
    'avergli',
    'avergliene',
    'averi',
    'averina',
    'averino',
    'averio',
    'averla',
    'averle',
    'averli',
    'averlo',
    'avermi',
    'avernale',
    'avernali',
    'averne',
    'averni',
    'averno',
    'averroe',
    'averroismi',
    'averroismo',
    'averroista',
    'averroiste',
    'averroisti',
    'averroistica',
    'averroistici',
    'averroistico',
    'averroè',
    'aversa',
    'aversano',
    'aversi',
    'aversiva',
    'avertelo',
    'avertere',
    'averti',
    'avervi',
    'aves',
    'avesse',
    'avessero',
    'avessi',
    'avessimo',
    'avesta',
    'aveste',
    'avesti',
    'avestica',
    'avestiche',
    'avestici',
    'avestico',
    'avete',
    'aveva',
    'avevamo',
    'avevano',
    'avevate',
    'avevi',
    'avevo',
    'avezzano',
    'aviano',
    'aviari',
    'aviaria',
    'aviarie',
    'aviario',
    'aviatore',
    'aviatori',
    'aviatoria',
    'aviatorie',
    'aviatorio',
    'aviatrice',
    'aviatrici',
    'aviazione',
    'aviazioni',
    'avicenna',
    'avicola',
    'avicole',
    'avicoli',
    'avicolo',
    'avicoltore',
    'avicoltori',
    'avicoltrice',
    'avicoltrici',
    'avicoltura',
    'avicolture',
    'avicultore',
    'avicultori',
    'avicultrice',
    'avicultrici',
    'avicultura',
    'aviculture',
    'avicunicola',
    'avicunicole',
    'avicunicoli',
    'avicunicolo',
    'avida',
    'avidamente',
    'avide',
    'avidi',
    'avidita',
    'avidità',
    'avido',
    'aviere',
    'avieri',
    'aviero',
    'avifauna',
    'avifaune',
    'avignone',
    'avignonese',
    'avignonesi',
    'avilla',
    'avincere',
    'avio',
    'aviocisterna',
    'aviocisterne',
    'aviogetti',
    'aviogetto',
    'avioimbarchi',
    'avioimbarco',
    'aviolancera',
    'aviolancerai',
    'aviolancerei',
    'aviolancero',
    'aviolanci',
    'aviolancia',
    'aviolanciai',
    'aviolanciamo',
    'aviolanciano',
    'aviolanciare',
    'aviolanciata',
    'aviolanciate',
    'aviolanciati',
    'aviolanciato',
    'aviolanciava',
    'aviolanciavi',
    'aviolanciavo',
    'aviolancino',
    'aviolancio',
    'aviolinea',
    'aviolinee',
    'avionica',
    'avioniche',
    'avionici',
    'avionico',
    'avioraduni',
    'avioraduno',
    'aviorimessa',
    'aviorimesse',
    'aviosbarchi',
    'aviosbarco',
    'aviotruppa',
    'aviotruppe',
    'avipoxvirus',
    'avis',
    'avita',
    'avitaminosi',
    'avite',
    'aviti',
    'avito',
    'avium',
    'avizzano',
    'avoca',
    'avocadi',
    'avocado',
    'avocados',
    'avocai',
    'avocammo',
    'avocando',
    'avocano',
    'avocante',
    'avocanti',
    'avocare',
    'avocarono',
    'avocasse',
    'avocassero',
    'avocassi',
    'avocassimo',
    'avocaste',
    'avocasti',
    'avocata',
    'avocate',
    'avocati',
    'avocato',
    'avocatori',
    'avocatoria',
    'avocatorie',
    'avocatorio',
    'avocava',
    'avocavamo',
    'avocavano',
    'avocavate',
    'avocavi',
    'avocavo',
    'avocazione',
    'avocazioni',
    'avocetta',
    'avocette',
    'avochera',
    'avocherai',
    'avocheranno',
    'avocherebbe',
    'avocherei',
    'avocheremmo',
    'avocheremo',
    'avochereste',
    'avocheresti',
    'avocherete',
    'avochero',
    'avochi',
    'avochiamo',
    'avochiate',
    'avochino',
    'avoco',
    'avogadore',
    'avogadori',
    'avola',
    'avole',
    'avoli',
    'avolo',
    'avolterare',
    'avoltoio',
    'avoltore',
    'avori',
    'avorio',
    'avornelli',
    'avornello',
    'avornielli',
    'avorniello',
    'avra',
    'avrai',
    'avran',
    'avranno',
    'avrebbe',
    'avrebbero',
    'avrei',
    'avremmo',
    'avremo',
    'avreste',
    'avresti',
    'avrete',
    'avro',
    'avrà',
    'avrò',
    'avulsa',
    'avulse',
    'avulsi',
    'avulsione',
    'avulsioni',
    'avulsiva',
    'avulsive',
    'avulsivi',
    'avulsivo',
    'avulso',
    'avuncolati',
    'avuncolato',
    'avunculato',
    'avuta',
    'avutasi',
    'avute',
    'avutesi',
    'avuti',
    'avutisi',
    'avuto',
    'avutolo',
    'avutosi',
    'avvale',
    'avvalemmo',
    'avvalendo',
    'avvalendoci',
    'avvalendomi',
    'avvalendosi',
    'avvalendoti',
    'avvalendovi',
    'avvalente',
    'avvalentesi',
    'avvalenti',
    'avvalentisi',
    'avvalerci',
    'avvalere',
    'avvalermene',
    'avvalermi',
    'avvalersene',
    'avvalersi',
    'avvalerti',
    'avvalervi',
    'avvalesse',
    'avvalessero',
    'avvalessi',
    'avvalessimo',
    'avvaleste',
    'avvalesti',
    'avvalete',
    'avvaletevi',
    'avvaleva',
    'avvalevamo',
    'avvalevano',
    'avvalevate',
    'avvalevi',
    'avvalevo',
    'avvalga',
    'avvalgano',
    'avvalgo',
    'avvalgono',
    'avvali',
    'avvaliamo',
    'avvaliamoci',
    'avvaliate',
    'avvalimenti',
    'avvalimento',
    'avvalino',
    'avvaliti',
    'avvalla',
    'avvallai',
    'avvallamenti',
    'avvallamento',
    'avvallammo',
    'avvallando',
    'avvallandoci',
    'avvallandomi',
    'avvallandosi',
    'avvallandoti',
    'avvallandovi',
    'avvallano',
    'avvallante',
    'avvallanti',
    'avvallantisi',
    'avvallarci',
    'avvallare',
    'avvallarmi',
    'avvallarono',
    'avvallarsi',
    'avvallarti',
    'avvallarvi',
    'avvallasse',
    'avvallassero',
    'avvallassi',
    'avvallassimo',
    'avvallaste',
    'avvallasti',
    'avvallata',
    'avvallate',
    'avvallatevi',
    'avvallati',
    'avvallato',
    'avvallatomi',
    'avvallatoti',
    'avvallatura',
    'avvallature',
    'avvallava',
    'avvallavamo',
    'avvallavano',
    'avvallavate',
    'avvallavi',
    'avvallavo',
    'avvallera',
    'avvallerai',
    'avvalleranno',
    'avvallerebbe',
    'avvallerei',
    'avvalleremmo',
    'avvalleremo',
    'avvallereste',
    'avvalleresti',
    'avvallerete',
    'avvallero',
    'avvalli',
    'avvalliamo',
    'avvalliamoci',
    'avvalliate',
    'avvallino',
    'avvallo',
    'avvalora',
    'avvalorai',
    'avvalorammo',
    'avvalorando',
    'avvalorano',
    'avvalorante',
    'avvaloranti',
    'avvalorarci',
    'avvalorare',
    'avvalorarmi',
    'avvalorarono',
    'avvalorarsi',
    'avvalorarti',
    'avvalorarvi',
    'avvalorasse',
    'avvalorassi',
    'avvaloraste',
    'avvalorasti',
    'avvalorata',
    'avvalorate',
    'avvaloratevi',
    'avvalorati',
    'avvalorato',
    'avvaloratomi',
    'avvaloratoti',
    'avvalorava',
    'avvaloravamo',
    'avvaloravano',
    'avvaloravate',
    'avvaloravi',
    'avvaloravo',
    'avvalorera',
    'avvalorerai',
    'avvalorerei',
    'avvaloreremo',
    'avvalorerete',
    'avvalorero',
    'avvalori',
    'avvaloriamo',
    'avvaloriate',
    'avvalorino',
    'avvaloro',
    'avvalsa',
    'avvalse',
    'avvalsero',
    'avvalsi',
    'avvalso',
    'avvalsomi',
    'avvalsoti',
    'avvampa',
    'avvampai',
    'avvampamenti',
    'avvampamento',
    'avvampammo',
    'avvampando',
    'avvampano',
    'avvampante',
    'avvampanti',
    'avvampare',
    'avvamparono',
    'avvampasse',
    'avvampassero',
    'avvampassi',
    'avvampassimo',
    'avvampaste',
    'avvampasti',
    'avvampata',
    'avvampate',
    'avvampati',
    'avvampato',
    'avvampava',
    'avvampavamo',
    'avvampavano',
    'avvampavate',
    'avvampavi',
    'avvampavo',
    'avvampera',
    'avvamperai',
    'avvamperanno',
    'avvamperebbe',
    'avvamperei',
    'avvamperemmo',
    'avvamperemo',
    'avvampereste',
    'avvamperesti',
    'avvamperete',
    'avvampero',
    'avvampi',
    'avvampiamo',
    'avvampiate',
    'avvampino',
    'avvampo',
    'avvantaggera',
    'avvantaggero',
    'avvantaggi',
    'avvantaggia',
    'avvantaggiai',
    'avvantaggino',
    'avvantaggio',
    'avvarra',
    'avvarrai',
    'avvarranno',
    'avvarrebbe',
    'avvarrebbero',
    'avvarrei',
    'avvarremmo',
    'avvarremo',
    'avvarreste',
    'avvarresti',
    'avvarrete',
    'avvarro',
    'avveda',
    'avvedano',
    'avvede',
    'avvedemmo',
    'avvedendo',
    'avvedendoci',
    'avvedendomi',
    'avvedendosi',
    'avvedendoti',
    'avvedendovi',
    'avvedentesi',
    'avvedentisi',
    'avvederci',
    'avvedere',
    'avvedermi',
    'avvedersene',
    'avvedersi',
    'avvederti',
    'avvedervi',
    'avvedesse',
    'avvedessero',
    'avvedessi',
    'avvedessimo',
    'avvedeste',
    'avvedesti',
    'avvedete',
    'avvedetevi',
    'avvedeva',
    'avvedevamo',
    'avvedevano',
    'avvedevate',
    'avvedevi',
    'avvedevo',
    'avvedi',
    'avvediamo',
    'avvediamoci',
    'avvediate',
    'avvedimenti',
    'avvedimento',
    'avvediti',
    'avvedo',
    'avvedono',
    'avvedra',
    'avvedrai',
    'avvedranno',
    'avvedrebbe',
    'avvedrebbero',
    'avvedrei',
    'avvedremmo',
    'avvedremo',
    'avvedreste',
    'avvedresti',
    'avvedrete',
    'avvedro',
    'avvedrà',
    'avveduta',
    'avvedutasi',
    'avvedute',
    'avvedutezza',
    'avvedutezze',
    'avveduti',
    'avvedutisi',
    'avveduto',
    'avvedutomi',
    'avvedutoti',
    'avvegnache',
    'avvelena',
    'avvelenai',
    'avvelenammo',
    'avvelenando',
    'avvelenano',
    'avvelenante',
    'avvelenanti',
    'avvelenarci',
    'avvelenare',
    'avvelenarla',
    'avvelenarlo',
    'avvelenarmi',
    'avvelenarono',
    'avvelenarsi',
    'avvelenarti',
    'avvelenarvi',
    'avvelenasse',
    'avvelenassi',
    'avvelenaste',
    'avvelenasti',
    'avvelenata',
    'avvelenate',
    'avvelenatevi',
    'avvelenati',
    'avvelenato',
    'avvelenatomi',
    'avvelenatore',
    'avvelenatori',
    'avvelenatoti',
    'avvelenava',
    'avvelenavamo',
    'avvelenavano',
    'avvelenavate',
    'avvelenavi',
    'avvelenavo',
    'avvelenera',
    'avvelenerai',
    'avvelenerei',
    'avveleneremo',
    'avvelenerete',
    'avvelenero',
    'avvelenerò',
    'avveleni',
    'avveleniamo',
    'avveleniate',
    'avvelenino',
    'avveleno',
    'avvenendo',
    'avvenendoci',
    'avvenendomi',
    'avvenendosi',
    'avvenendoti',
    'avvenendovi',
    'avvenente',
    'avvenenti',
    'avvenenza',
    'avvenenze',
    'avvenevole',
    'avvenevoli',
    'avvenga',
    'avvengano',
    'avvengo',
    'avvengono',
    'avveniamo',
    'avveniamoci',
    'avveniate',
    'avveniente',
    'avvenienti',
    'avvenientisi',
    'avvenimenti',
    'avvenimento',
    'avvenimmo',
    'avvenirci',
    'avvenire',
    'avveniri',
    'avvenirismi',
    'avvenirismo',
    'avvenirista',
    'avveniriste',
    'avveniristi',
    'avvenirmi',
    'avvenirsi',
    'avvenirti',
    'avvenirvi',
    'avvenisse',
    'avvenissero',
    'avvenissi',
    'avvenissimo',
    'avveniste',
    'avvenisti',
    'avvenite',
    'avvenitevi',
    'avveniticce',
    'avveniticci',
    'avveniticcia',
    'avveniticcio',
    'avveniva',
    'avvenivamo',
    'avvenivano',
    'avvenivate',
    'avvenivi',
    'avvenivo',
    'avvenne',
    'avvennero',
    'avvenni',
    'avventa',
    'avventai',
    'avventamenti',
    'avventamento',
    'avventammo',
    'avventando',
    'avventandoci',
    'avventandomi',
    'avventandosi',
    'avventandoti',
    'avventandovi',
    'avventano',
    'avventante',
    'avventanti',
    'avventantisi',
    'avventarci',
    'avventare',
    'avventarmi',
    'avventarono',
    'avventarsi',
    'avventarti',
    'avventarvi',
    'avventasse',
    'avventassero',
    'avventassi',
    'avventassimo',
    'avventaste',
    'avventasti',
    'avventata',
    'avventate',
    'avventatevi',
    'avventatezza',
    'avventatezze',
    'avventati',
    'avventato',
    'avventatomi',
    'avventatoti',
    'avventava',
    'avventavamo',
    'avventavano',
    'avventavate',
    'avventavi',
    'avventavo',
    'avventera',
    'avventerai',
    'avventeranno',
    'avventerebbe',
    'avventerei',
    'avventeremmo',
    'avventeremo',
    'avventereste',
    'avventeresti',
    'avventerete',
    'avventero',
    'avventerò',
    'avventi',
    'avventiamo',
    'avventiamoci',
    'avventiate',
    'avventiccio',
    'avventina',
    'avventino',
    'avventista',
    'avventiste',
    'avventisti',
    'avventizi',
    'avventizia',
    'avventiziata',
    'avventiziate',
    'avventiziati',
    'avventiziato',
    'avventizie',
    'avventizio',
    'avvento',
    'avventora',
    'avventore',
    'avventori',
    'avventrice',
    'avventrici',
    'avventura',
    'avventurai',
    'avventurammo',
    'avventurando',
    'avventurano',
    'avventurante',
    'avventuranti',
    'avventurarci',
    'avventurare',
    'avventurarmi',
    'avventurarsi',
    'avventurarti',
    'avventurarvi',
    'avventurasse',
    'avventurassi',
    'avventuraste',
    'avventurasti',
    'avventurata',
    'avventurate',
    'avventurati',
    'avventurato',
    'avventurava',
    'avventuravi',
    'avventuravo',
    'avventure',
    'avventurera',
    'avventurerai',
    'avventurerei',
    'avventurero',
    'avventuretta',
    'avventurette',
    'avventuri',
    'avventuriamo',
    'avventuriate',
    'avventuriera',
    'avventuriere',
    'avventurieri',
    'avventuriero',
    'avventurina',
    'avventurine',
    'avventurino',
    'avventurismi',
    'avventurismo',
    'avventurista',
    'avventuriste',
    'avventuristi',
    'avventuro',
    'avventurosa',
    'avventurose',
    'avventurosi',
    'avventuroso',
    'avvenuta',
    'avvenute',
    'avvenuti',
    'avvenuto',
    'avvenutomi',
    'avvenutoti',
    'avvera',
    'avverabile',
    'avverabili',
    'avverai',
    'avveramenti',
    'avveramento',
    'avverammo',
    'avverando',
    'avverandoci',
    'avverandomi',
    'avverandosi',
    'avverandoti',
    'avverandovi',
    'avverano',
    'avverante',
    'avveranti',
    'avverantisi',
    'avverarci',
    'avverare',
    'avverarmi',
    'avverarono',
    'avverarsi',
    'avverarti',
    'avverarvi',
    'avverasse',
    'avverassero',
    'avverassi',
    'avverassimo',
    'avveraste',
    'avverasti',
    'avverata',
    'avverate',
    'avveratevi',
    'avverati',
    'avverato',
    'avveratomi',
    'avveratoti',
    'avverava',
    'avveravamo',
    'avveravano',
    'avveravate',
    'avveravi',
    'avveravo',
    'avverbi',
    'avverbiale',
    'avverbiali',
    'avverbio',
    'avverera',
    'avvererai',
    'avvereranno',
    'avvererebbe',
    'avvererei',
    'avvereremmo',
    'avvereremo',
    'avverereste',
    'avvereresti',
    'avvererete',
    'avverero',
    'avvererò',
    'avveri',
    'avveriamo',
    'avveriamoci',
    'avveriate',
    'avverino',
    'avvero',
    'avverra',
    'avverrai',
    'avverranno',
    'avverrebbe',
    'avverrebbero',
    'avverrei',
    'avverremmo',
    'avverremo',
    'avverreste',
    'avverresti',
    'avverrete',
    'avverro',
    'avverrà',
    'avversa',
    'avversai',
    'avversamente',
    'avversammo',
    'avversando',
    'avversandoci',
    'avversandomi',
    'avversandosi',
    'avversandoti',
    'avversandovi',
    'avversano',
    'avversante',
    'avversanti',
    'avversantisi',
    'avversarci',
    'avversare',
    'avversari',
    'avversaria',
    'avversarie',
    'avversario',
    'avversarmi',
    'avversaro',
    'avversarono',
    'avversarsi',
    'avversarti',
    'avversarvi',
    'avversasse',
    'avversassero',
    'avversassi',
    'avversassimo',
    'avversaste',
    'avversasti',
    'avversata',
    'avversate',
    'avversatevi',
    'avversati',
    'avversativa',
    'avversative',
    'avversativi',
    'avversativo',
    'avversato',
    'avversatomi',
    'avversatore',
    'avversatori',
    'avversatoti',
    'avversatrice',
    'avversatrici',
    'avversava',
    'avversavamo',
    'avversavano',
    'avversavate',
    'avversavi',
    'avversavo',
    'avverse',
    'avversera',
    'avverserai',
    'avverseranno',
    'avverserebbe',
    'avverserei',
    'avverseremmo',
    'avverseremo',
    'avversereste',
    'avverseresti',
    'avverserete',
    'avversero',
    'avversi',
    'avversiamo',
    'avversiamoci',
    'avversiate',
    'avversino',
    'avversione',
    'avversioni',
    'avversita',
    'avversità',
    'avverso',
    'avverta',
    'avvertano',
    'avverte',
    'avvertendo',
    'avvertendoci',
    'avvertendola',
    'avvertendole',
    'avvertendoli',
    'avvertendolo',
    'avvertendomi',
    'avvertendoti',
    'avvertendovi',
    'avvertente',
    'avvertenti',
    'avvertenza',
    'avvertenze',
    'avverti',
    'avvertiamo',
    'avvertiate',
    'avvertibile',
    'avvertibili',
    'avvertii',
    'avvertila',
    'avvertile',
    'avvertili',
    'avvertilo',
    'avvertimenti',
    'avvertimento',
    'avvertimi',
    'avvertimmo',
    'avvertira',
    'avvertirai',
    'avvertiranno',
    'avvertirci',
    'avvertire',
    'avvertirebbe',
    'avvertirei',
    'avvertiremmo',
    'avvertiremo',
    'avvertireste',
    'avvertiresti',
    'avvertirete',
    'avvertirla',
    'avvertirle',
    'avvertirli',
    'avvertirlo',
    'avvertirmi',
    'avvertiro',
    'avvertirono',
    'avvertirsi',
    'avvertirti',
    'avvertirvi',
    'avvertirà',
    'avvertirò',
    'avvertisse',
    'avvertissero',
    'avvertissi',
    'avvertissimo',
    'avvertiste',
    'avvertisti',
    'avvertita',
    'avvertite',
    'avvertitela',
    'avvertitele',
    'avvertiteli',
    'avvertitelo',
    'avvertiti',
    'avvertito',
    'avvertiva',
    'avvertivamo',
    'avvertivano',
    'avvertivate',
    'avvertivi',
    'avvertivo',
    'avverto',
    'avvertono',
    'avvertì',
    'avverà',
    'avvezione',
    'avvezioni',
    'avvezza',
    'avvezzai',
    'avvezzamenti',
    'avvezzamento',
    'avvezzammo',
    'avvezzando',
    'avvezzandoci',
    'avvezzandomi',
    'avvezzandosi',
    'avvezzandoti',
    'avvezzandovi',
    'avvezzano',
    'avvezzante',
    'avvezzanti',
    'avvezzantisi',
    'avvezzarci',
    'avvezzare',
    'avvezzarmi',
    'avvezzarono',
    'avvezzarsi',
    'avvezzarti',
    'avvezzarvi',
    'avvezzasse',
    'avvezzassero',
    'avvezzassi',
    'avvezzassimo',
    'avvezzaste',
    'avvezzasti',
    'avvezzata',
    'avvezzate',
    'avvezzatevi',
    'avvezzati',
    'avvezzato',
    'avvezzatomi',
    'avvezzatoti',
    'avvezzava',
    'avvezzavamo',
    'avvezzavano',
    'avvezzavate',
    'avvezzavi',
    'avvezzavo',
    'avvezze',
    'avvezzera',
    'avvezzerai',
    'avvezzeranno',
    'avvezzerebbe',
    'avvezzerei',
    'avvezzeremmo',
    'avvezzeremo',
    'avvezzereste',
    'avvezzeresti',
    'avvezzerete',
    'avvezzero',
    'avvezzi',
    'avvezziamo',
    'avvezziamoci',
    'avvezziate',
    'avvezzino',
    'avvezzo',
    'avvia',
    'avviai',
    'avviamenti',
    'avviamento',
    'avviammo',
    'avviamo',
    'avviamoci',
    'avviando',
    'avviandoci',
    'avviandomi',
    'avviandosi',
    'avviandoti',
    'avviandovi',
    'avviano',
    'avviante',
    'avvianti',
    'avviantisi',
    'avviarci',
    'avviare',
    'avviarmi',
    'avviarono',
    'avviarsi',
    'avviarti',
    'avviarvi',
    'avviasse',
    'avviassero',
    'avviassi',
    'avviassimo',
    'avviaste',
    'avviasti',
    'avviata',
    'avviate',
    'avviatevi',
    'avviati',
    'avviatissima',
    'avviato',
    'avviatomi',
    'avviatore',
    'avviatori',
    'avviatoti',
    'avviatura',
    'avviature',
    'avviava',
    'avviavamo',
    'avviavano',
    'avviavate',
    'avviavi',
    'avviavo',
    'avvicenda',
    'avvicendai',
    'avvicendammo',
    'avvicendando',
    'avvicendano',
    'avvicendante',
    'avvicendanti',
    'avvicendarci',
    'avvicendare',
    'avvicendarmi',
    'avvicendarsi',
    'avvicendarti',
    'avvicendarvi',
    'avvicendasse',
    'avvicendassi',
    'avvicendaste',
    'avvicendasti',
    'avvicendata',
    'avvicendate',
    'avvicendati',
    'avvicendato',
    'avvicendava',
    'avvicendavi',
    'avvicendavo',
    'avvicendera',
    'avvicenderai',
    'avvicenderei',
    'avvicendero',
    'avvicendi',
    'avvicendiamo',
    'avvicendiate',
    'avvicendino',
    'avvicendo',
    'avvicina',
    'avvicinabile',
    'avvicinabili',
    'avvicinai',
    'avvicinammo',
    'avvicinando',
    'avvicinano',
    'avvicinante',
    'avvicinanti',
    'avvicinarci',
    'avvicinare',
    'avvicinarmi',
    'avvicinarono',
    'avvicinarsi',
    'avvicinarti',
    'avvicinarvi',
    'avvicinasse',
    'avvicinassi',
    'avvicinaste',
    'avvicinasti',
    'avvicinata',
    'avvicinate',
    'avvicinatevi',
    'avvicinati',
    'avvicinatisi',
    'avvicinato',
    'avvicinatomi',
    'avvicinatoti',
    'avvicinava',
    'avvicinavamo',
    'avvicinavano',
    'avvicinavate',
    'avvicinavi',
    'avvicinavo',
    'avvicinera',
    'avvicinerai',
    'avvicinerei',
    'avvicineremo',
    'avvicinerete',
    'avvicinero',
    'avvicinerò',
    'avvicini',
    'avviciniamo',
    'avviciniate',
    'avvicinino',
    'avvicino',
    'avvide',
    'avvidero',
    'avvidi',
    'avviene',
    'avvieni',
    'avvieniti',
    'avviera',
    'avvierai',
    'avvieranno',
    'avvierebbe',
    'avvierebbero',
    'avvierei',
    'avvieremmo',
    'avvieremo',
    'avviereste',
    'avvieresti',
    'avvierete',
    'avviero',
    'avvierà',
    'avvierò',
    'avvigna',
    'avvignai',
    'avvignammo',
    'avvignando',
    'avvignano',
    'avvignante',
    'avvignanti',
    'avvignare',
    'avvignarono',
    'avvignasse',
    'avvignassero',
    'avvignassi',
    'avvignassimo',
    'avvignaste',
    'avvignasti',
    'avvignata',
    'avvignate',
    'avvignati',
    'avvignato',
    'avvignava',
    'avvignavamo',
    'avvignavano',
    'avvignavate',
    'avvignavi',
    'avvignavo',
    'avvignera',
    'avvignerai',
    'avvigneranno',
    'avvignerebbe',
    'avvignerei',
    'avvigneremmo',
    'avvigneremo',
    'avvignereste',
    'avvigneresti',
    'avvignerete',
    'avvignero',
    'avvigni',
    'avvigniamo',
    'avvigniate',
    'avvignino',
    'avvigno',
    'avvii',
    'avviino',
    'avvilendo',
    'avvilendoci',
    'avvilendomi',
    'avvilendosi',
    'avvilendoti',
    'avvilendovi',
    'avvilente',
    'avvilenti',
    'avvilentisi',
    'avvili',
    'avviliamo',
    'avviliamoci',
    'avviliate',
    'avvilii',
    'avvilimenti',
    'avvilimento',
    'avvilimmo',
    'avvilira',
    'avvilirai',
    'avviliranno',
    'avvilirci',
    'avvilire',
    'avvilirebbe',
    'avvilirei',
    'avviliremmo',
    'avviliremo',
    'avvilireste',
    'avviliresti',
    'avvilirete',
    'avvilirmi',
    'avviliro',
    'avvilirono',
    'avvilirsi',
    'avvilirti',
    'avvilirvi',
    'avvilirà',
    'avvilirò',
    'avvilisca',
    'avviliscano',
    'avvilisce',
    'avvilisci',
    'avvilisciti',
    'avvilisco',
    'avviliscono',
    'avvilisse',
    'avvilissero',
    'avvilissi',
    'avvilissimo',
    'avviliste',
    'avvilisti',
    'avvilita',
    'avvilite',
    'avvilitevi',
    'avviliti',
    'avvilito',
    'avvilitomi',
    'avvilitoti',
    'avviliva',
    'avvilivamo',
    'avvilivano',
    'avvilivate',
    'avvilivi',
    'avvilivo',
    'avvilucchia',
    'avviluppa',
    'avviluppai',
    'avviluppammo',
    'avviluppando',
    'avviluppano',
    'avviluppante',
    'avviluppanti',
    'avvilupparci',
    'avviluppare',
    'avvilupparmi',
    'avvilupparsi',
    'avvilupparti',
    'avvilupparvi',
    'avviluppasse',
    'avviluppassi',
    'avviluppaste',
    'avviluppasti',
    'avviluppata',
    'avviluppate',
    'avviluppati',
    'avviluppato',
    'avviluppava',
    'avviluppavi',
    'avviluppavo',
    'avviluppera',
    'avvilupperai',
    'avvilupperei',
    'avviluppero',
    'avvilupperò',
    'avviluppi',
    'avviluppiamo',
    'avviluppiate',
    'avviluppino',
    'avviluppo',
    'avvina',
    'avvinai',
    'avvinammo',
    'avvinando',
    'avvinano',
    'avvinante',
    'avvinanti',
    'avvinare',
    'avvinarono',
    'avvinasse',
    'avvinassero',
    'avvinassi',
    'avvinassimo',
    'avvinaste',
    'avvinasti',
    'avvinata',
    'avvinate',
    'avvinati',
    'avvinato',
    'avvinatore',
    'avvinatori',
    'avvinava',
    'avvinavamo',
    'avvinavano',
    'avvinavate',
    'avvinavi',
    'avvinavo',
    'avvinazza',
    'avvinazzai',
    'avvinazzammo',
    'avvinazzando',
    'avvinazzano',
    'avvinazzante',
    'avvinazzanti',
    'avvinazzarci',
    'avvinazzare',
    'avvinazzarmi',
    'avvinazzarsi',
    'avvinazzarti',
    'avvinazzarvi',
    'avvinazzasse',
    'avvinazzassi',
    'avvinazzaste',
    'avvinazzasti',
    'avvinazzata',
    'avvinazzate',
    'avvinazzati',
    'avvinazzato',
    'avvinazzava',
    'avvinazzavi',
    'avvinazzavo',
    'avvinazzera',
    'avvinazzerai',
    'avvinazzerei',
    'avvinazzero',
    'avvinazzi',
    'avvinazziamo',
    'avvinazziate',
    'avvinazzino',
    'avvinazzo',
    'avvinca',
    'avvincano',
    'avvince',
    'avvincemmo',
    'avvincendo',
    'avvincente',
    'avvincenti',
    'avvincera',
    'avvincerai',
    'avvinceranno',
    'avvincere',
    'avvincerebbe',
    'avvincerei',
    'avvinceremmo',
    'avvinceremo',
    'avvincereste',
    'avvinceresti',
    'avvincerete',
    'avvincero',
    'avvincersi',
    'avvincerà',
    'avvincerò',
    'avvincesse',
    'avvincessero',
    'avvincessi',
    'avvincessimo',
    'avvinceste',
    'avvincesti',
    'avvincete',
    'avvincetela',
    'avvincetelo',
    'avvincetene',
    'avvinceva',
    'avvincevamo',
    'avvincevano',
    'avvincevate',
    'avvincevi',
    'avvincevo',
    'avvinchiare',
    'avvinci',
    'avvinciamo',
    'avvinciate',
    'avvincila',
    'avvincilo',
    'avvincinate',
    'avvinco',
    'avvincolare',
    'avvincono',
    'avvinera',
    'avvinerai',
    'avvineranno',
    'avvinerebbe',
    'avvinerei',
    'avvineremmo',
    'avvineremo',
    'avvinereste',
    'avvineresti',
    'avvinerete',
    'avvinero',
    'avvinghi',
    'avvinghia',
    'avvinghiai',
    'avvinghiammo',
    'avvinghiamo',
    'avvinghiando',
    'avvinghiano',
    'avvinghiante',
    'avvinghianti',
    'avvinghiarci',
    'avvinghiare',
    'avvinghiarmi',
    'avvinghiarsi',
    'avvinghiarti',
    'avvinghiarvi',
    'avvinghiasse',
    'avvinghiassi',
    'avvinghiaste',
    'avvinghiasti',
    'avvinghiata',
    'avvinghiate',
    'avvinghiati',
    'avvinghiato',
    'avvinghiava',
    'avvinghiavi',
    'avvinghiavo',
    'avvinghiera',
    'avvinghierai',
    'avvinghierei',
    'avvinghiero',
    'avvinghino',
    'avvinghio',
    'avvini',
    'avviniamo',
    'avviniate',
    'avvinino',
    'avvino',
    'avvinse',
    'avvinsero',
    'avvinsi',
    'avvinta',
    'avvinte',
    'avvinti',
    'avvinto',
    'avvio',
    'avvisa',
    'avvisaglia',
    'avvisaglie',
    'avvisai',
    'avvisala',
    'avvisalo',
    'avvisami',
    'avvisammo',
    'avvisando',
    'avvisandoci',
    'avvisandola',
    'avvisandole',
    'avvisandoli',
    'avvisandolo',
    'avvisandomi',
    'avvisandosi',
    'avvisandoti',
    'avvisandovi',
    'avvisano',
    'avvisante',
    'avvisanti',
    'avvisantisi',
    'avvisar',
    'avvisarci',
    'avvisare',
    'avvisarla',
    'avvisarle',
    'avvisarli',
    'avvisarlo',
    'avvisarmi',
    'avvisarono',
    'avvisarsi',
    'avvisarti',
    'avvisarvi',
    'avvisasse',
    'avvisassero',
    'avvisassi',
    'avvisassimo',
    'avvisaste',
    'avvisasti',
    'avvisata',
    'avvisate',
    'avvisatela',
    'avvisatelo',
    'avvisatemi',
    'avvisatevi',
    'avvisati',
    'avvisato',
    'avvisatomi',
    'avvisatore',
    'avvisatori',
    'avvisatoti',
    'avvisatrice',
    'avvisatrici',
    'avvisava',
    'avvisavamo',
    'avvisavano',
    'avvisavate',
    'avvisavi',
    'avvisavo',
    'avvisera',
    'avviserai',
    'avviseranno',
    'avviserebbe',
    'avviserei',
    'avviseremmo',
    'avviseremo',
    'avvisereste',
    'avviseresti',
    'avviserete',
    'avvisero',
    'avviserò',
    'avvisi',
    'avvisiamo',
    'avvisiamoci',
    'avvisiate',
    'avvisino',
    'avviso',
    'avvista',
    'avvistai',
    'avvistamenti',
    'avvistamento',
    'avvistammo',
    'avvistando',
    'avvistano',
    'avvistante',
    'avvistanti',
    'avvistare',
    'avvistarono',
    'avvistasse',
    'avvistassero',
    'avvistassi',
    'avvistassimo',
    'avvistaste',
    'avvistasti',
    'avvistata',
    'avvistate',
    'avvistati',
    'avvistato',
    'avvistava',
    'avvistavamo',
    'avvistavano',
    'avvistavate',
    'avvistavi',
    'avvistavo',
    'avviste',
    'avvistera',
    'avvisterai',
    'avvisteranno',
    'avvisterebbe',
    'avvisterei',
    'avvisteremmo',
    'avvisteremo',
    'avvistereste',
    'avvisteresti',
    'avvisterete',
    'avvistero',
    'avvisterò',
    'avvisti',
    'avvistiamo',
    'avvistiate',
    'avvistino',
    'avvisto',
    'avvistomi',
    'avvistoti',
    'avvita',
    'avvitai',
    'avvitamenti',
    'avvitamento',
    'avvitammo',
    'avvitando',
    'avvitandoci',
    'avvitandola',
    'avvitandole',
    'avvitandoli',
    'avvitandolo',
    'avvitandomi',
    'avvitandosi',
    'avvitandoti',
    'avvitandovi',
    'avvitano',
    'avvitante',
    'avvitanti',
    'avvitantisi',
    'avvitarci',
    'avvitare',
    'avvitarla',
    'avvitarle',
    'avvitarli',
    'avvitarlo',
    'avvitarmi',
    'avvitarono',
    'avvitarsi',
    'avvitarti',
    'avvitarvi',
    'avvitasse',
    'avvitassero',
    'avvitassi',
    'avvitassimo',
    'avvitaste',
    'avvitasti',
    'avvitata',
    'avvitate',
    'avvitatevi',
    'avvitati',
    'avvitato',
    'avvitatomi',
    'avvitatore',
    'avvitatori',
    'avvitatoti',
    'avvitatrice',
    'avvitatrici',
    'avvitatura',
    'avvitature',
    'avvitava',
    'avvitavamo',
    'avvitavano',
    'avvitavate',
    'avvitavi',
    'avvitavo',
    'avvitera',
    'avviterai',
    'avviteranno',
    'avviterebbe',
    'avviterei',
    'avviteremmo',
    'avviteremo',
    'avvitereste',
    'avviteresti',
    'avviterete',
    'avvitero',
    'avviterò',
    'avviti',
    'avvitiamo',
    'avvitiamoci',
    'avvitiate',
    'avviticchi',
    'avviticchia',
    'avviticchiai',
    'avviticchino',
    'avviticchio',
    'avvitino',
    'avvitire',
    'avvito',
    'avvitta',
    'avvittamenti',
    'avvittamento',
    'avvittando',
    'avvittano',
    'avvittante',
    'avvittare',
    'avvittato',
    'avviva',
    'avvivai',
    'avvivamento',
    'avvivammo',
    'avvivando',
    'avvivandoci',
    'avvivandomi',
    'avvivandosi',
    'avvivandoti',
    'avvivandovi',
    'avvivano',
    'avvivante',
    'avvivanti',
    'avvivantisi',
    'avvivarci',
    'avvivare',
    'avvivarmi',
    'avvivarono',
    'avvivarsi',
    'avvivarti',
    'avvivarvi',
    'avvivasse',
    'avvivassero',
    'avvivassi',
    'avvivassimo',
    'avvivaste',
    'avvivasti',
    'avvivata',
    'avvivate',
    'avvivatevi',
    'avvivati',
    'avvivato',
    'avvivatomi',
    'avvivatoti',
    'avvivava',
    'avvivavamo',
    'avvivavano',
    'avvivavate',
    'avvivavi',
    'avvivavo',
    'avvivera',
    'avviverai',
    'avviveranno',
    'avviverebbe',
    'avviverei',
    'avviveremmo',
    'avviveremo',
    'avvivereste',
    'avviveresti',
    'avviverete',
    'avvivero',
    'avvivi',
    'avviviamo',
    'avviviamoci',
    'avviviate',
    'avvivino',
    'avvivo',
    'avvizzendo',
    'avvizzente',
    'avvizzenti',
    'avvizzi',
    'avvizziamo',
    'avvizziate',
    'avvizzii',
    'avvizzimenti',
    'avvizzimento',
    'avvizzimmo',
    'avvizzira',
    'avvizzirai',
    'avvizziranno',
    'avvizzire',
    'avvizzirebbe',
    'avvizzirei',
    'avvizziremmo',
    'avvizziremo',
    'avvizzireste',
    'avvizziresti',
    'avvizzirete',
    'avvizziro',
    'avvizzirono',
    'avvizzisca',
    'avvizziscano',
    'avvizzisce',
    'avvizzisci',
    'avvizzisco',
    'avvizziscono',
    'avvizzisse',
    'avvizzissero',
    'avvizzissi',
    'avvizzissimo',
    'avvizziste',
    'avvizzisti',
    'avvizzita',
    'avvizzite',
    'avvizziti',
    'avvizzito',
    'avvizziva',
    'avvizzivamo',
    'avvizzivano',
    'avvizzivate',
    'avvizzivi',
    'avvizzivo',
    'avviò',
    'avvocata',
    'avvocate',
    'avvocateria',
    'avvocaterie',
    'avvocatesca',
    'avvocatesche',
    'avvocateschi',
    'avvocatesco',
    'avvocatessa',
    'avvocatesse',
    'avvocati',
    'avvocaticchi',
    'avvocatini',
    'avvocatino',
    'avvocato',
    'avvocatone',
    'avvocatoni',
    'avvocatore',
    'avvocatori',
    'avvocatucci',
    'avvocatuccio',
    'avvocatucoli',
    'avvocatucolo',
    'avvocatura',
    'avvocature',
    'avvocatuzzi',
    'avvocatuzzo',
    'avvogadore',
    'avvogadori',
    'avvolga',
    'avvolgano',
    'avvolge',
    'avvolgemmo',
    'avvolgendo',
    'avvolgendoci',
    'avvolgendola',
    'avvolgendole',
    'avvolgendoli',
    'avvolgendolo',
    'avvolgendomi',
    'avvolgendosi',
    'avvolgendoti',
    'avvolgendovi',
    'avvolgente',
    'avvolgenti',
    'avvolgentisi',
    'avvolgera',
    'avvolgerai',
    'avvolgeranno',
    'avvolgerci',
    'avvolgere',
    'avvolgerebbe',
    'avvolgerei',
    'avvolgeremmo',
    'avvolgeremo',
    'avvolgereste',
    'avvolgeresti',
    'avvolgerete',
    'avvolgerla',
    'avvolgerle',
    'avvolgerli',
    'avvolgerlo',
    'avvolgermi',
    'avvolgero',
    'avvolgersi',
    'avvolgerti',
    'avvolgervi',
    'avvolgesse',
    'avvolgessero',
    'avvolgessi',
    'avvolgessimo',
    'avvolgeste',
    'avvolgesti',
    'avvolgete',
    'avvolgetevi',
    'avvolgeva',
    'avvolgevamo',
    'avvolgevano',
    'avvolgevate',
    'avvolgevi',
    'avvolgevo',
    'avvolgi',
    'avvolgiamo',
    'avvolgiamoci',
    'avvolgiate',
    'avvolgibile',
    'avvolgibili',
    'avvolgimenti',
    'avvolgimento',
    'avvolgiti',
    'avvolgitore',
    'avvolgitori',
    'avvolgitrice',
    'avvolgitrici',
    'avvolgo',
    'avvolgono',
    'avvolse',
    'avvolsero',
    'avvolsi',
    'avvolta',
    'avvolte',
    'avvolti',
    'avvolticchia',
    'avvolto',
    'avvoltoi',
    'avvoltoio',
    'avvoltola',
    'avvoltolai',
    'avvoltolammo',
    'avvoltolando',
    'avvoltolano',
    'avvoltolante',
    'avvoltolanti',
    'avvoltolarci',
    'avvoltolare',
    'avvoltolarmi',
    'avvoltolarsi',
    'avvoltolarti',
    'avvoltolarvi',
    'avvoltolasse',
    'avvoltolassi',
    'avvoltolaste',
    'avvoltolasti',
    'avvoltolata',
    'avvoltolate',
    'avvoltolati',
    'avvoltolato',
    'avvoltolava',
    'avvoltolavi',
    'avvoltolavo',
    'avvoltolera',
    'avvoltolerai',
    'avvoltolerei',
    'avvoltolero',
    'avvoltoli',
    'avvoltoliamo',
    'avvoltoliate',
    'avvoltolino',
    'avvoltolo',
    'avvoltomi',
    'avvoltoti',
    'avvolvere',
    'axeroftoli',
    'axeroftolo',
    'axiologia',
    'axiologica',
    'axiologiche',
    'axiologici',
    'axiologico',
    'axolotl',
    'axone',
    'axoni',
    'ayatollah',
    'azalea',
    'azalee',
    'azar',
    'azaria',
    'azedarach',
    'azeglia',
    'azeglio',
    'azelia',
    'azelio',
    'azelma',
    'azera',
    'azerbaigian',
    'azere',
    'azeri',
    'azero',
    'azia',
    'azienda',
    'aziendale',
    'aziendali',
    'aziendalismi',
    'aziendalismo',
    'aziendalista',
    'aziendaliste',
    'aziendalisti',
    'aziendalizza',
    'aziendalizzi',
    'aziendalizzo',
    'aziende',
    'azigos',
    'azil',
    'aziliana',
    'aziliane',
    'aziliani',
    'aziliano',
    'azima',
    'azime',
    'azimi',
    'azimo',
    'azimut',
    'azimutale',
    'azimutali',
    'azio',
    'aziona',
    'azionabile',
    'azionabili',
    'azionabilita',
    'azionacce',
    'azionaccia',
    'azionai',
    'azionamenti',
    'azionamento',
    'azionammo',
    'azionando',
    'azionano',
    'azionante',
    'azionanti',
    'azionare',
    'azionari',
    'azionaria',
    'azionariati',
    'azionariato',
    'azionarie',
    'azionario',
    'azionarono',
    'azionarsi',
    'azionasse',
    'azionassero',
    'azionassi',
    'azionassimo',
    'azionaste',
    'azionasti',
    'azionata',
    'azionate',
    'azionati',
    'azionato',
    'azionatore',
    'azionatori',
    'azionatrice',
    'azionatrici',
    'azionava',
    'azionavamo',
    'azionavano',
    'azionavate',
    'azionavi',
    'azionavo',
    'azioncella',
    'azioncelle',
    'azione',
    'azionera',
    'azionerai',
    'azioneranno',
    'azionerebbe',
    'azionerei',
    'azioneremmo',
    'azioneremo',
    'azionereste',
    'azioneresti',
    'azionerete',
    'azionero',
    'azioni',
    'azioniamo',
    'azioniate',
    'azionino',
    'azionista',
    'azioniste',
    'azionisti',
    'azionistica',
    'azionistiche',
    'azionistici',
    'azionistico',
    'aziono',
    'azocoloranti',
    'azocomposti',
    'azocomposto',
    'azoica',
    'azoiche',
    'azoici',
    'azoico',
    'azolino',
    'azolla',
    'azolle',
    'azoni',
    'azonio',
    'azoospermia',
    'azoospermie',
    'azospirillum',
    'azota',
    'azotai',
    'azotammo',
    'azotando',
    'azotano',
    'azotante',
    'azotanti',
    'azotare',
    'azotarono',
    'azotasse',
    'azotassero',
    'azotassi',
    'azotassimo',
    'azotaste',
    'azotasti',
    'azotata',
    'azotate',
    'azotati',
    'azotato',
    'azotatura',
    'azotature',
    'azotava',
    'azotavamo',
    'azotavano',
    'azotavate',
    'azotavi',
    'azotavo',
    'azotemia',
    'azotemie',
    'azotera',
    'azoterai',
    'azoteranno',
    'azoterebbe',
    'azoterebbero',
    'azoterei',
    'azoteremmo',
    'azoteremo',
    'azotereste',
    'azoteresti',
    'azoterete',
    'azotero',
    'azoti',
    'azotiamo',
    'azotiate',
    'azotica',
    'azotiche',
    'azotici',
    'azotico',
    'azotino',
    'azotiprite',
    'azotipriti',
    'azoto',
    'azotobacter',
    'azotobatteri',
    'azotoiprite',
    'azotoipriti',
    'azoturi',
    'azoturia',
    'azoturie',
    'azoturo',
    'azov',
    'azteca',
    'azteche',
    'aztechi',
    'azteco',
    'azulejo',
    'azulene',
    'azuleni',
    'azurmendi',
    'azza',
    'azzanna',
    'azzannai',
    'azzannammo',
    'azzannando',
    'azzannandoci',
    'azzannandola',
    'azzannandolo',
    'azzannandomi',
    'azzannandosi',
    'azzannandoti',
    'azzannandovi',
    'azzannano',
    'azzannante',
    'azzannanti',
    'azzannantisi',
    'azzannarci',
    'azzannare',
    'azzannarla',
    'azzannarlo',
    'azzannarmi',
    'azzannarono',
    'azzannarsi',
    'azzannarti',
    'azzannarvi',
    'azzannasse',
    'azzannassero',
    'azzannassi',
    'azzannassimo',
    'azzannaste',
    'azzannasti',
    'azzannata',
    'azzannate',
    'azzannatevi',
    'azzannati',
    'azzannato',
    'azzannatomi',
    'azzannatoti',
    'azzannatura',
    'azzannature',
    'azzannava',
    'azzannavamo',
    'azzannavano',
    'azzannavate',
    'azzannavi',
    'azzannavo',
    'azzannera',
    'azzannerai',
    'azzanneranno',
    'azzannerebbe',
    'azzannerei',
    'azzanneremmo',
    'azzanneremo',
    'azzannereste',
    'azzanneresti',
    'azzannerete',
    'azzannero',
    'azzanni',
    'azzanniamo',
    'azzanniamoci',
    'azzanniate',
    'azzannino',
    'azzanno',
    'azzano',
    'azzarda',
    'azzardai',
    'azzardammo',
    'azzardando',
    'azzardandoci',
    'azzardandomi',
    'azzardandosi',
    'azzardandoti',
    'azzardandovi',
    'azzardano',
    'azzardante',
    'azzardanti',
    'azzardantisi',
    'azzardarci',
    'azzardare',
    'azzardarmi',
    'azzardarono',
    'azzardarsi',
    'azzardarti',
    'azzardarvi',
    'azzardasse',
    'azzardassero',
    'azzardassi',
    'azzardassimo',
    'azzardaste',
    'azzardasti',
    'azzardata',
    'azzardate',
    'azzardatevi',
    'azzardati',
    'azzardato',
    'azzardatomi',
    'azzardatoti',
    'azzardava',
    'azzardavamo',
    'azzardavano',
    'azzardavate',
    'azzardavi',
    'azzardavo',
    'azzardera',
    'azzarderai',
    'azzarderanno',
    'azzarderebbe',
    'azzarderei',
    'azzarderemmo',
    'azzarderemo',
    'azzardereste',
    'azzarderesti',
    'azzarderete',
    'azzardero',
    'azzardi',
    'azzardiamo',
    'azzardiamoci',
    'azzardiate',
    'azzardino',
    'azzardo',
    'azzardosa',
    'azzardose',
    'azzardosi',
    'azzardoso',
    'azzaruolo',
    'azze',
    'azzecca',
    'azzeccai',
    'azzeccammo',
    'azzeccando',
    'azzeccandola',
    'azzeccandolo',
    'azzeccandosi',
    'azzeccano',
    'azzeccante',
    'azzeccanti',
    'azzeccare',
    'azzeccarla',
    'azzeccarlo',
    'azzeccarono',
    'azzeccarsi',
    'azzeccasse',
    'azzeccassero',
    'azzeccassi',
    'azzeccassimo',
    'azzeccaste',
    'azzeccasti',
    'azzeccata',
    'azzeccate',
    'azzeccati',
    'azzeccato',
    'azzeccava',
    'azzeccavamo',
    'azzeccavano',
    'azzeccavate',
    'azzeccavi',
    'azzeccavo',
    'azzecchera',
    'azzeccherai',
    'azzeccherei',
    'azzeccheremo',
    'azzeccherete',
    'azzecchero',
    'azzecchi',
    'azzecchiamo',
    'azzecchiate',
    'azzecchino',
    'azzecco',
    'azzeccò',
    'azzeglio',
    'azzelino',
    'azzella',
    'azzello',
    'azzera',
    'azzerai',
    'azzeramenti',
    'azzeramento',
    'azzerammo',
    'azzerando',
    'azzerandola',
    'azzerandolo',
    'azzerano',
    'azzerante',
    'azzeranti',
    'azzerare',
    'azzerarla',
    'azzerarlo',
    'azzerarono',
    'azzerasse',
    'azzerassero',
    'azzerassi',
    'azzerassimo',
    'azzeraste',
    'azzerasti',
    'azzerata',
    'azzerate',
    'azzerati',
    'azzerato',
    'azzerava',
    'azzeravamo',
    'azzeravano',
    'azzeravate',
    'azzeravi',
    'azzeravo',
    'azzerera',
    'azzererai',
    'azzereranno',
    'azzererebbe',
    'azzererei',
    'azzereremmo',
    'azzereremo',
    'azzerereste',
    'azzereresti',
    'azzererete',
    'azzerero',
    'azzeri',
    'azzeriamo',
    'azzeriate',
    'azzerino',
    'azzero',
    'azzeruolo',
    'azzima',
    'azzimai',
    'azzimammo',
    'azzimando',
    'azzimandoci',
    'azzimandomi',
    'azzimandosi',
    'azzimandoti',
    'azzimandovi',
    'azzimano',
    'azzimante',
    'azzimanti',
    'azzimantisi',
    'azzimarci',
    'azzimare',
    'azzimarmi',
    'azzimarono',
    'azzimarsi',
    'azzimarti',
    'azzimarvi',
    'azzimasse',
    'azzimassero',
    'azzimassi',
    'azzimassimo',
    'azzimaste',
    'azzimasti',
    'azzimata',
    'azzimate',
    'azzimatevi',
    'azzimati',
    'azzimato',
    'azzimatomi',
    'azzimatoti',
    'azzimava',
    'azzimavamo',
    'azzimavano',
    'azzimavate',
    'azzimavi',
    'azzimavo',
    'azzime',
    'azzimera',
    'azzimerai',
    'azzimeranno',
    'azzimerebbe',
    'azzimerei',
    'azzimeremmo',
    'azzimeremo',
    'azzimereste',
    'azzimeresti',
    'azzimerete',
    'azzimero',
    'azzimi',
    'azzimiamo',
    'azzimiamoci',
    'azzimiate',
    'azzimino',
    'azzimo',
    'azzio',
    'azzitta',
    'azzittai',
    'azzittammo',
    'azzittando',
    'azzittandoci',
    'azzittandomi',
    'azzittandosi',
    'azzittandoti',
    'azzittandovi',
    'azzittano',
    'azzittante',
    'azzittanti',
    'azzittantisi',
    'azzittarci',
    'azzittare',
    'azzittarmi',
    'azzittarono',
    'azzittarsi',
    'azzittarti',
    'azzittarvi',
    'azzittasse',
    'azzittassero',
    'azzittassi',
    'azzittassimo',
    'azzittaste',
    'azzittasti',
    'azzittata',
    'azzittate',
    'azzittatevi',
    'azzittati',
    'azzittato',
    'azzittatomi',
    'azzittatoti',
    'azzittava',
    'azzittavamo',
    'azzittavano',
    'azzittavate',
    'azzittavi',
    'azzittavo',
    'azzittendo',
    'azzittendoci',
    'azzittendomi',
    'azzittendosi',
    'azzittendoti',
    'azzittendovi',
    'azzittente',
    'azzittenti',
    'azzittentisi',
    'azzittera',
    'azzitterai',
    'azzitteranno',
    'azzitterebbe',
    'azzitterei',
    'azzitteremmo',
    'azzitteremo',
    'azzittereste',
    'azzitteresti',
    'azzitterete',
    'azzittero',
    'azzitti',
    'azzittiamo',
    'azzittiamoci',
    'azzittiate',
    'azzittii',
    'azzittimmo',
    'azzittino',
    'azzittira',
    'azzittirai',
    'azzittiranno',
    'azzittirci',
    'azzittire',
    'azzittirebbe',
    'azzittirei',
    'azzittiremmo',
    'azzittiremo',
    'azzittireste',
    'azzittiresti',
    'azzittirete',
    'azzittirmi',
    'azzittiro',
    'azzittirono',
    'azzittirsi',
    'azzittirti',
    'azzittirvi',
    'azzittisca',
    'azzittiscano',
    'azzittisce',
    'azzittisci',
    'azzittisciti',
    'azzittisco',
    'azzittiscono',
    'azzittisse',
    'azzittissero',
    'azzittissi',
    'azzittissimo',
    'azzittiste',
    'azzittisti',
    'azzittita',
    'azzittite',
    'azzittitevi',
    'azzittiti',
    'azzittito',
    'azzittitomi',
    'azzittitoti',
    'azzittiva',
    'azzittivamo',
    'azzittivano',
    'azzittivate',
    'azzittivi',
    'azzittivo',
    'azzitto',
    'azzo',
    'azzolina',
    'azzolini',
    'azzolino',
    'azzonamenti',
    'azzonamento',
    'azzoppa',
    'azzoppai',
    'azzoppamenti',
    'azzoppamento',
    'azzoppammo',
    'azzoppando',
    'azzoppandoci',
    'azzoppandomi',
    'azzoppandosi',
    'azzoppandoti',
    'azzoppandovi',
    'azzoppano',
    'azzoppante',
    'azzoppanti',
    'azzoppantisi',
    'azzopparci',
    'azzoppare',
    'azzopparmi',
    'azzopparono',
    'azzopparsi',
    'azzopparti',
    'azzopparvi',
    'azzoppasse',
    'azzoppassero',
    'azzoppassi',
    'azzoppassimo',
    'azzoppaste',
    'azzoppasti',
    'azzoppata',
    'azzoppate',
    'azzoppatevi',
    'azzoppati',
    'azzoppato',
    'azzoppatomi',
    'azzoppatoti',
    'azzoppava',
    'azzoppavamo',
    'azzoppavano',
    'azzoppavate',
    'azzoppavi',
    'azzoppavo',
    'azzoppendo',
    'azzoppendoci',
    'azzoppendomi',
    'azzoppendosi',
    'azzoppendoti',
    'azzoppendovi',
    'azzoppente',
    'azzoppenti',
    'azzoppentisi',
    'azzoppera',
    'azzopperai',
    'azzopperanno',
    'azzopperebbe',
    'azzopperei',
    'azzopperemmo',
    'azzopperemo',
    'azzoppereste',
    'azzopperesti',
    'azzopperete',
    'azzoppero',
    'azzopperò',
    'azzoppi',
    'azzoppiamo',
    'azzoppiamoci',
    'azzoppiate',
    'azzoppii',
    'azzoppimenti',
    'azzoppimento',
    'azzoppimmo',
    'azzoppino',
    'azzoppira',
    'azzoppirai',
    'azzoppiranno',
    'azzoppirci',
    'azzoppire',
    'azzoppirebbe',
    'azzoppirei',
    'azzoppiremmo',
    'azzoppiremo',
    'azzoppireste',
    'azzoppiresti',
    'azzoppirete',
    'azzoppirmi',
    'azzoppiro',
    'azzoppirono',
    'azzoppirsi',
    'azzoppirti',
    'azzoppirvi',
    'azzoppisca',
    'azzoppiscano',
    'azzoppisce',
    'azzoppisci',
    'azzoppisciti',
    'azzoppisco',
    'azzoppiscono',
    'azzoppisse',
    'azzoppissero',
    'azzoppissi',
    'azzoppissimo',
    'azzoppiste',
    'azzoppisti',
    'azzoppita',
    'azzoppite',
    'azzoppitevi',
    'azzoppiti',
    'azzoppito',
    'azzoppitomi',
    'azzoppitoti',
    'azzoppiva',
    'azzoppivamo',
    'azzoppivano',
    'azzoppivate',
    'azzoppivi',
    'azzoppivo',
    'azzoppo',
    'azzorre',
    'azzuffa',
    'azzuffai',
    'azzuffamenti',
    'azzuffamento',
    'azzuffammo',
    'azzuffando',
    'azzuffandoci',
    'azzuffandomi',
    'azzuffandosi',
    'azzuffandoti',
    'azzuffandovi',
    'azzuffano',
    'azzuffante',
    'azzuffanti',
    'azzuffantisi',
    'azzuffarci',
    'azzuffare',
    'azzuffarmi',
    'azzuffarono',
    'azzuffarsi',
    'azzuffarti',
    'azzuffarvi',
    'azzuffasse',
    'azzuffassero',
    'azzuffassi',
    'azzuffassimo',
    'azzuffaste',
    'azzuffasti',
    'azzuffata',
    'azzuffate',
    'azzuffatevi',
    'azzuffati',
    'azzuffato',
    'azzuffatomi',
    'azzuffatoti',
    'azzuffava',
    'azzuffavamo',
    'azzuffavano',
    'azzuffavate',
    'azzuffavi',
    'azzuffavo',
    'azzuffera',
    'azzufferai',
    'azzufferanno',
    'azzufferebbe',
    'azzufferei',
    'azzufferemmo',
    'azzufferemo',
    'azzuffereste',
    'azzufferesti',
    'azzufferete',
    'azzuffero',
    'azzuffi',
    'azzuffiamo',
    'azzuffiamoci',
    'azzuffiate',
    'azzuffino',
    'azzuffo',
    'azzurra',
    'azzurrabile',
    'azzurrabili',
    'azzurraggi',
    'azzurraggio',
    'azzurrai',
    'azzurramenti',
    'azzurramento',
    'azzurrammo',
    'azzurrando',
    'azzurrandoci',
    'azzurrandomi',
    'azzurrandosi',
    'azzurrandoti',
    'azzurrandovi',
    'azzurrano',
    'azzurrante',
    'azzurranti',
    'azzurrantisi',
    'azzurrarci',
    'azzurrare',
    'azzurrarmi',
    'azzurrarono',
    'azzurrarsi',
    'azzurrarti',
    'azzurrarvi',
    'azzurrasse',
    'azzurrassero',
    'azzurrassi',
    'azzurrassimo',
    'azzurraste',
    'azzurrasti',
    'azzurrata',
    'azzurrate',
    'azzurratevi',
    'azzurrati',
    'azzurrato',
    'azzurratomi',
    'azzurratoti',
    'azzurrava',
    'azzurravamo',
    'azzurravano',
    'azzurravate',
    'azzurravi',
    'azzurravo',
    'azzurre',
    'azzurreggera',
    'azzurreggero',
    'azzurreggi',
    'azzurreggia',
    'azzurreggiai',
    'azzurreggino',
    'azzurreggio',
    'azzurrera',
    'azzurrerai',
    'azzurreranno',
    'azzurrerebbe',
    'azzurrerei',
    'azzurreremmo',
    'azzurreremo',
    'azzurrereste',
    'azzurreresti',
    'azzurrerete',
    'azzurrero',
    'azzurri',
    'azzurriamo',
    'azzurriamoci',
    'azzurriate',
    'azzurricce',
    'azzurricci',
    'azzurriccia',
    'azzurriccio',
    'azzurrigna',
    'azzurrigne',
    'azzurrigni',
    'azzurrigno',
    'azzurrina',
    'azzurrine',
    'azzurrini',
    'azzurrino',
    'azzurrita',
    'azzurrite',
    'azzurriti',
    'azzurrità',
    'azzurro',
    'azzurrognola',
    'azzurrognole',
    'azzurrognoli',
    'azzurrognolo',
    'baal',
    'baastrup',
    'baba',
    'babaismi',
    'babaismo',
    'babaista',
    'babaiste',
    'babaisti',
    'babassu',
    'babau',
    'babbacciona',
    'babbaccione',
    'babbaccioni',
    'babbagigi',
    'babbalea',
    'babbalee',
    'babbalei',
    'babbaleo',
    'babbea',
    'babbee',
    'babbei',
    'babbeo',
    'babbi',
    'babbia',
    'babbie',
    'babbimorti',
    'babbini',
    'babbino',
    'babbio',
    'babbiona',
    'babbione',
    'babbioni',
    'babbo',
    'babbomorto',
    'babbuassa',
    'babbuasse',
    'babbuassi',
    'babbuasso',
    'babbucce',
    'babbucci',
    'babbuccia',
    'babbuccio',
    'babbuina',
    'babbuine',
    'babbuini',
    'babbuino',
    'babele',
    'babeli',
    'babelica',
    'babeliche',
    'babelici',
    'babelico',
    'babelle',
    'babesia',
    'babesiosi',
    'babetto',
    'babeuf',
    'babies',
    'babila',
    'babilo',
    'babilonese',
    'babilonesi',
    'babilonia',
    'babilonica',
    'babiloniche',
    'babilonici',
    'babilonico',
    'babilonie',
    'babinski',
    'babinsky',
    'babirussa',
    'babismi',
    'babismo',
    'babista',
    'babiste',
    'babisti',
    'babordi',
    'babordo',
    'babuini',
    'babuino',
    'babuvismi',
    'babuvismo',
    'baby',
    'baca',
    'bacacci',
    'bacaccio',
    'bacai',
    'bacaia',
    'bacaie',
    'bacaio',
    'bacalare',
    'bacalari',
    'bacalaro',
    'bacamenti',
    'bacamento',
    'bacammo',
    'bacando',
    'bacandoci',
    'bacandomi',
    'bacandosi',
    'bacandoti',
    'bacandovi',
    'bacano',
    'bacante',
    'bacanti',
    'bacantisi',
    'bacarci',
    'bacare',
    'bacarmi',
    'bacarono',
    'bacarozzi',
    'bacarozzo',
    'bacarsi',
    'bacarti',
    'bacarvi',
    'bacasse',
    'bacassero',
    'bacassi',
    'bacassimo',
    'bacaste',
    'bacasti',
    'bacata',
    'bacate',
    'bacatevi',
    'bacati',
    'bacato',
    'bacatomi',
    'bacatoti',
    'bacatura',
    'bacature',
    'bacava',
    'bacavamo',
    'bacavano',
    'bacavate',
    'bacavi',
    'bacavo',
    'bacca',
    'baccagli',
    'baccaglia',
    'baccagliai',
    'baccagliammo',
    'baccagliamo',
    'baccagliando',
    'baccagliano',
    'baccagliante',
    'baccaglianti',
    'baccagliare',
    'baccagliasse',
    'baccagliassi',
    'baccagliaste',
    'baccagliasti',
    'baccagliata',
    'baccagliate',
    'baccagliati',
    'baccagliato',
    'baccagliava',
    'baccagliavi',
    'baccagliavo',
    'baccagliera',
    'baccaglierai',
    'baccaglierei',
    'baccagliero',
    'baccaglino',
    'baccaglio',
    'baccala',
    'baccalare',
    'baccalari',
    'baccalaro',
    'baccalauri',
    'baccalauro',
    'baccalà',
    'baccanale',
    'baccanali',
    'baccanella',
    'baccanelle',
    'baccani',
    'baccano',
    'baccante',
    'baccanti',
    'baccara',
    'baccarat',
    'baccare',
    'baccarina',
    'baccarine',
    'baccellai',
    'baccellaia',
    'baccellaie',
    'baccellaio',
    'baccellata',
    'baccellate',
    'baccellati',
    'baccellato',
    'baccellatura',
    'baccellature',
    'baccelleria',
    'baccellerie',
    'baccelletti',
    'baccelletto',
    'baccelli',
    'baccelliera',
    'baccelliere',
    'baccellieri',
    'baccellina',
    'baccelline',
    'baccellini',
    'baccellino',
    'baccello',
    'baccellona',
    'baccellone',
    'baccelloni',
    'bacche',
    'baccheggera',
    'baccheggerai',
    'baccheggerei',
    'baccheggero',
    'baccheggi',
    'baccheggia',
    'baccheggiai',
    'baccheggiamo',
    'baccheggiano',
    'baccheggiare',
    'baccheggiata',
    'baccheggiate',
    'baccheggiati',
    'baccheggiato',
    'baccheggiava',
    'baccheggiavi',
    'baccheggiavo',
    'baccheggino',
    'baccheggio',
    'bacchei',
    'baccheo',
    'baccherina',
    'baccherine',
    'bacchetta',
    'bacchettai',
    'bacchettammo',
    'bacchettando',
    'bacchettano',
    'bacchettante',
    'bacchettanti',
    'bacchettare',
    'bacchettarsi',
    'bacchettasse',
    'bacchettassi',
    'bacchettaste',
    'bacchettasti',
    'bacchettata',
    'bacchettate',
    'bacchettati',
    'bacchettato',
    'bacchettava',
    'bacchettavi',
    'bacchettavo',
    'bacchette',
    'bacchettera',
    'bacchetterai',
    'bacchetterei',
    'bacchettero',
    'bacchetti',
    'bacchettiamo',
    'bacchettiate',
    'bacchettiera',
    'bacchettiere',
    'bacchettina',
    'bacchettine',
    'bacchettini',
    'bacchettino',
    'bacchetto',
    'bacchettona',
    'bacchettone',
    'bacchettoni',
    'bacchi',
    'bacchia',
    'bacchiai',
    'bacchiammo',
    'bacchiamo',
    'bacchiando',
    'bacchiano',
    'bacchiante',
    'bacchianti',
    'bacchiare',
    'bacchiarono',
    'bacchiarsi',
    'bacchiasse',
    'bacchiassero',
    'bacchiassi',
    'bacchiassimo',
    'bacchiaste',
    'bacchiasti',
    'bacchiata',
    'bacchiate',
    'bacchiati',
    'bacchiato',
    'bacchiatore',
    'bacchiatori',
    'bacchiatrice',
    'bacchiatrici',
    'bacchiatura',
    'bacchiature',
    'bacchiava',
    'bacchiavamo',
    'bacchiavano',
    'bacchiavate',
    'bacchiavi',
    'bacchiavo',
    'bacchica',
    'bacchiche',
    'bacchici',
    'bacchico',
    'bacchiera',
    'bacchierai',
    'bacchieranno',
    'bacchierebbe',
    'bacchierei',
    'bacchieremmo',
    'bacchieremo',
    'bacchiereste',
    'bacchieresti',
    'bacchierete',
    'bacchiero',
    'bacchii',
    'bacchillona',
    'bacchillone',
    'bacchilloni',
    'bacchino',
    'bacchio',
    'bacchisio',
    'baccifera',
    'baccifere',
    'bacciferi',
    'baccifero',
    'bacciforme',
    'bacciformi',
    'baccio',
    'bacco',
    'bacera',
    'bacerai',
    'baceranno',
    'bacerebbe',
    'bacerebbero',
    'bacerei',
    'baceremmo',
    'baceremo',
    'bacereste',
    'baceresti',
    'bacerete',
    'bacero',
    'bacetti',
    'bacetto',
    'bach',
    'bacheca',
    'bacheche',
    'bachelite',
    'bacheliti',
    'bachera',
    'bacherai',
    'bacheranno',
    'bacherebbe',
    'bacherebbero',
    'bacherei',
    'bacherelli',
    'bacherello',
    'bacheremmo',
    'bacheremo',
    'bachereste',
    'bacheresti',
    'bacherete',
    'bacheria',
    'bacherie',
    'bachero',
    'bacherozzi',
    'bacherozzo',
    'bacherozzoli',
    'bacherozzolo',
    'bachi',
    'bachiamo',
    'bachiamoci',
    'bachiate',
    'bachicoltore',
    'bachicoltori',
    'bachicoltura',
    'bachicolture',
    'bachicultore',
    'bachicultori',
    'bachicultura',
    'bachiculture',
    'bachino',
    'bachisia',
    'bachisio',
    'baci',
    'bacia',
    'baciabassi',
    'baciabasso',
    'baciaci',
    'baciai',
    'baciala',
    'baciale',
    'baciali',
    'bacialo',
    'baciamani',
    'baciamano',
    'baciamenti',
    'baciamento',
    'baciami',
    'baciammo',
    'baciamo',
    'baciamoci',
    'baciando',
    'baciandoci',
    'baciandola',
    'baciandole',
    'baciandoli',
    'baciandolo',
    'baciandomi',
    'baciandosi',
    'baciandoti',
    'baciandovi',
    'baciano',
    'baciante',
    'bacianti',
    'baciantisi',
    'baciapile',
    'baciapolvere',
    'baciar',
    'baciarci',
    'baciare',
    'baciari',
    'baciarla',
    'b