use strict;
use warnings;

package App::Embra::Role::FilePruner;
$App::Embra::Role::FilePruner::VERSION = '0.001'; # TRIAL
# ABSTRACT: something that stops files from appearing in a site

use List::MoreUtils qw< part >;
use Method::Signatures;
use Moo::Role;


with 'App::Embra::Role::Plugin';

requires 'exclude_file';


method prune_files {
    my $files = $self->embra->files;
    my ($remove, $keep) = part { ! $self->exclude_file( $_ ) } @{ $files };

    $self->debug( "pruning $_" ) for @{ $remove };
    splice @{ $files }, 0, @{ $files }, @{ $keep };

    return;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::Embra::Role::FilePruner - something that stops files from appearing in a site

=head1 VERSION

version 0.001

=head1 DESCRIPTION

This role should be implemented by any plugin which prevents files from appearing in your site. It provides one method (C<L</prune_files>>), and requires plugins provide an C<exclude_file> method, which accepts a single L<App::Embra::File> object and return true if the file should be removed.

C<prune_files> will be called after all L<FileGatherer|App::Embra::Role::FileGatherer>-type plugins have added files, and will remove from the site all files which cause C<L</exclude_file>> to return true.

=head1 METHODS

=head2 prune_files

    $plugin->prune_files;

Passes each of the site's files to the plugin's C<exclude_file> method, and removes the file from the site if the method returns true.

=head1 AUTHOR

Daniel Holz <dgholz@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Daniel Holz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
