#!/usr/bin/perl -w -I ../../../lib

use 5.018;

use strict;

use Carp;

{ package Audio::Signal::Effect::Flanger;

    use Moose;
    use Moose::Util::TypeConstraints;

    extends 'Audio::Signal::Effect';
    
    enum 'Form', [qw(sine triangle)];
    
    our %gencmd_form = ('sine' => 'sin','triangle' => 'tri');
    our %gencmd_interp = ('linear' => 'lin','quadratic' => 'quad');
    
    has 'delay' => (
        is => 'rw',
        isa => 'Num',
    );
    
    has 'depth' => (
        is => 'rw',
        isa => 'Num',
    );
    
    has 'regen' => (
        is => 'rw',
        isa => 'Num',
    );
    
    has 'width' => (
        is => 'rw',
        isa => 'Num',
    );

    has 'speed' => (
        is => 'rw',
        isa => 'Num',
    );

    has 'phase' => (
        is => 'rw',
        isa => 'Num',
    );

    has 'interpolation' => (
        is => 'rw',
        isa => 'Str',
    );

    has 'form' => (
        is => 'rw',
        isa => 'Str',
    );

    sub gencmd {
        my $self = shift;        
        my $ret = sprintf("%s %s %s %s %s %s %s %s %s",$self->fx,$self->delay,$self->depth,$self->regen,$self->width,$self->speed,$Audio::Signal::Effect::Flanger::gencmd_form{$self->form},$self->phase,$Audio::Signal::Effect::Flanger::gencmd_interp{$self->interpolation});
        return($ret);
    }
}

1;
