package ZooZ::Base;
$ZooZ::Base::VERSION = '1.9.0';
# This package acts as a base package for the following
# classes:
#   ZooZ::Callbacks
#   ZooZ::varRefs
#
# It basically keeps track of which widgets are associated
# with those objects so when we delete something (ex. a callback
# or a variable), we can update the corresponding widget.

use strict;

# ABSTRACT: Perl Tk GUI builder.

1;

sub addWidget {
  my ($self, $key, $widget) = @_;

  $self->{WIDGET}{$key} = $widget;
}

sub removeWidget {
  my ($self, $key) = @_;

  my $w = delete $self->{WIDGET}{$key};
  $w    = undef;
}

__END__

=pod

=encoding UTF-8

=head1 NAME

ZooZ::Base - Perl Tk GUI builder.

=head1 VERSION

version 1.9.0

=head1 AUTHOR

Ala Qumsieh, faraco <skelic3@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2004-2005, 2018 by Ala Qumsieh, faraco.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
