package App::Manoc::Form::IfNotes;
#ABSTRACT: Manoc Form for entering interface notes.

use HTML::FormHandler::Moose;

our $VERSION = '2.99.2'; ##TRIAL VERSION

extends 'App::Manoc::Form::Base';

has '+name'        => ( default => 'form-ifnotes' );
has '+html_prefix' => ( default => 1 );

has 'device' => (
    is       => 'ro',
    isa      => 'Int',
    required => 1,
);

has 'interface' => (
    is       => 'ro',
    isa      => 'Str',
    required => 1,
);

has_field 'notes' => (
    type  => 'TextArea',
    label => 'Notes',
);

has_field 'save' => (
    type           => 'Submit',
    widget         => 'ButtonTag',
    element_attr   => { class => [ 'btn', 'btn-primary' ] },
    widget_wrapper => 'None',
    value          => "Save"
);

override 'update_model' => sub {
    my $self   = shift;
    my $values = $self->values;

    if ( $values->{notes} =~ /^\s*$/o && $self->item->in_storage ) {
        $self->item->delete();
        return 1;
    }

    $values->{device}    = $self->{device};
    $values->{interface} = $self->{interface};    #
    $self->_set_value($values);

    super();
};

__PACKAGE__->meta->make_immutable;

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::Form::IfNotes - Manoc Form for entering interface notes.

=head1 VERSION

version 2.99.2

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
