package App::Manoc::Form::VirtualInfr;
use HTML::FormHandler::Moose;

our $VERSION = '2.99.2'; ##TRIAL VERSION

use namespace::autoclean;

extends 'App::Manoc::Form::Base';
with
    'App::Manoc::Form::TraitFor::SaveButton',
    'App::Manoc::Form::TraitFor::Horizontal';

has '+item_class'  => ( default => 'VirtualInfr' );
has '+name'        => ( default => 'form-virtualinfr' );
has '+html_prefix' => ( default => 1 );

has_field 'name' => (
    type  => 'Text',
    size  => 32,
    label => 'Name',
);

has_field 'description' => (
    type  => 'Text',
    size  => 64,
    label => 'Description',
);

has_field 'notes' => ( type => 'TextArea' );

__PACKAGE__->meta->make_immutable;
no HTML::FormHandler::Moose;

__END__

=pod

=head1 NAME

App::Manoc::Form::VirtualInfr

=head1 VERSION

version 2.99.2

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
