package App::Manoc::Search::Driver::Server;

use Moose;

our $VERSION = '2.99.2'; ##TRIAL VERSION

use App::Manoc::Search::Item::Server;

extends 'App::Manoc::Search::Driver';

sub search_inventory {
    shift->search_server(@_);
}

sub search_server {
    my ( $self, $query, $result ) = @_;

    my $rs = $self->_search_addr($query);
    while ( my $e = $rs->next ) {
        my $item = App::Manoc::Search::Item::Server->new(
            {
                server => $e,
                match  => $e->address->address,
            }
        );
        $result->add_item($item);
    }

    $rs = $self->_search_name($query);
    while ( my $e = $rs->next ) {
        my $item = App::Manoc::Search::Item::Server->new(
            {
                server => $e,
                match  => $e->hostname,
            }
        );
        $result->add_item($item);
    }
}

sub search_ipaddr {
    my ( $self, $query, $result ) = @_;
    my $rs = $self->_search_addr($query);

    while ( my $e = $rs->next ) {
        my $item = App::Manoc::Search::Item::Server->new(
            {
                server => $e,
                match  => $e->address->address,
            }
        );
        $result->add_item($item);
    }
}

sub _search_addr {
    my ( $self, $query ) = @_;
    my $pattern = $query->sql_pattern;
    my $schema  = $self->engine->schema;
    return $schema->resultset('Server')
        ->search( { 'address' => { -like => $pattern } }, { order_by => ['name'] }, );
}

sub _search_name {
    my ( $self, $query ) = @_;
    my $pattern = $query->sql_pattern;
    my $schema  = $self->engine->schema;
    return $schema->resultset('Server')
        ->search( { hostname => { -like => $pattern } }, { order_by => 'name' }, );
}

no Moose;
__PACKAGE__->meta->make_immutable;

__END__

=pod

=head1 NAME

App::Manoc::Search::Driver::Server

=head1 VERSION

version 2.99.2

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
