use strict;
use warnings;
use utf8;
use File::Basename 'dirname';
use File::Spec::Functions qw{catdir splitdir rel2abs canonpath};
use lib catdir(dirname(__FILE__), '../lib');
use lib catdir(dirname(__FILE__), 'lib');
use Test::More;
use WWW::Crawler::Mojo;

use Test::More tests => 8;

my $bot = WWW::Crawler::Mojo->new;
$bot->enqueue('http://example.com/');
is ref $bot->queue->[0], 'WWW::Crawler::Mojo::Job';
is $bot->queue->[0]->resolved_uri, 'http://example.com/';
is @{$bot->queue}, 1, 'right number';
$bot->enqueue(Mojo::URL->new('http://example.com/2'));
is ref $bot->queue->[1], 'WWW::Crawler::Mojo::Job';
is $bot->queue->[1]->resolved_uri, 'http://example.com/2';
is @{$bot->queue}, 2, 'right number';

my $job = shift @{$bot->queue};
$bot->enqueue($job);
is @{$bot->queue}, 1, 'right number';
$bot->requeue($job);
is @{$bot->queue}, 2, 'right number';
