/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.handler;

import com.javonet.core.handler.AbstractHandler;
import com.javonet.core.handler.loadlibrary.JarAdder;
import com.javonet.core.handler.loadlibrary.JvmClassLoader;
import com.javonet.utils.Command;
import com.javonet.utils.exceptions.JavonetArgumentsMismatchException;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.HashSet;

public class LoadLibraryHandler
extends AbstractHandler {
    private final int requiredArgumentsCount = 1;
    private final JvmClassLoader jvmClassLoader = new JvmClassLoader(new URL[0], this.getClass().getClassLoader());
    private static HashSet<String> loadedLibraries = new HashSet();

    @Override
    public Object process(Command command) throws Exception {
        return this.loadLibrary(command);
    }

    private Object loadLibrary(Command command) throws Exception {
        if (command.getPayload().length < 1) {
            throw new JavonetArgumentsMismatchException(this.getClass().getName(), 1);
        }
        String assemblyName = command.getPayload()[0].toString();
        File jarFile = new File(assemblyName);
        if (!jarFile.exists()) {
            throw new FileNotFoundException(assemblyName);
        }
        String javaVersion = System.getProperty("java.version");
        if (!javaVersion.startsWith("1.8")) {
            throw new UnsupportedOperationException("Java version " + javaVersion + " does not support dynamic class loading.\nLibrary " + assemblyName + " cannot be loaded. \nPlease use Java 1.8 or\nLoad all libraries at the beginning of application");
        }
        this.jvmClassLoader.addUrl(jarFile.toURI().toURL());
        JarAdder.addJarToClasspath(jarFile);
        loadedLibraries.add(assemblyName);
        return 0;
    }

    public static HashSet<String> getLoadedLibraries() {
        return loadedLibraries;
    }
}

