/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk;

import com.javonet.core.transmitter.Transmitter;
import com.javonet.sdk.ConfigRuntimeFactory;
import com.javonet.sdk.RuntimeFactory;
import com.javonet.sdk.tools.ActivationHelper;
import com.javonet.sdk.tools.BinariesUnloader;
import com.javonet.sdk.tools.SdkMessageHelper;
import com.javonet.utils.RuntimeLogger;
import com.javonet.utils.connectiondata.InMemoryConnectionData;
import com.javonet.utils.connectiondata.TcpConnectionData;
import com.javonet.utils.connectiondata.WsConnectionData;

public final class Javonet {
    public static RuntimeFactory inMemory() {
        return new RuntimeFactory(new InMemoryConnectionData());
    }

    public static RuntimeFactory tcp(TcpConnectionData connectionData) {
        return new RuntimeFactory(connectionData);
    }

    public static RuntimeFactory webSocket(WsConnectionData connectionData) {
        return new RuntimeFactory(connectionData);
    }

    public static ConfigRuntimeFactory withConfig(String path) {
        try {
            Javonet.extractNativeBinaries();
            return new ConfigRuntimeFactory(path);
        }
        catch (Exception e) {
            SdkMessageHelper.GetInstance().sendMessageToAppInsights("SdkException", "WithConfig exception: " + e.getMessage());
            throw e;
        }
    }

    public static int activate(String licenseKey) {
        ActivationHelper.setTemporaryLicenseKey(licenseKey);
        Javonet.extractNativeBinaries();
        SdkMessageHelper.GetInstance().sendMessageToAppInsights("SdkMessage", "Activation");
        return Transmitter.activate(licenseKey);
    }

    public static String getRuntimeInfo() {
        return RuntimeLogger.getRuntimeInfo();
    }

    public static void setConfigSource(String configSource) {
        try {
            Javonet.extractNativeBinaries();
            Transmitter.setConfigSource(configSource);
        }
        catch (Exception e) {
            SdkMessageHelper.GetInstance().sendMessageToAppInsights("SdkException", "SetConfigSource exception: " + e.getMessage());
            throw e;
        }
    }

    private static void extractNativeBinaries() {
        BinariesUnloader.extractBinariesFromJar("Native");
    }

    static {
        SdkMessageHelper.GetInstance().sendMessageToAppInsights("SdkMessage", "Javonet SDK initialized");
    }
}

