package Business::EDI::CodeList::QuantityTypeCodeQualifier;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.01;
my $list_number = 6063;
my $usage       = 'C';

# 6063  Quantity type code qualifier                            [C]
# Desc: Code qualifying the type of quantity.
# Repr: an..3

my %code_hash = (
'1' => [ 'Discrete quantity',
    'Individually separated and distinct quantity.' ],
'2' => [ 'Charge',
    'Quantity relevant for charge.' ],
'3' => [ 'Cumulative quantity',
    'Quantity accumulated.' ],
'4' => [ 'Interest for overdrawn account',
    'Interest for overdrawing the account.' ],
'5' => [ 'Active ingredient dose per unit',
    'The dosage of active ingredient per unit.' ],
'6' => [ 'Auditor',
    'The number of entities that audit accounts.' ],
'7' => [ 'Branch locations, leased',
    'The number of branch locations being leased by an entity.' ],
'8' => [ "Inventory quantity at supplier's subject to inspection by",
    'customer Quantity of goods which the customer requires the supplier to have in inventory and which may be inspected by the customer if desired.' ],
'9' => [ 'Branch locations, owned',
    'The number of branch locations owned by an entity.' ],
'10' => [ 'Judgements registered',
    'The number of judgements registered against an entity.' ],
'11' => [ 'Split quantity',
    'Part of the whole quantity.' ],
'12' => [ 'Despatch quantity',
    'Quantity despatched by the seller.' ],
'13' => [ 'Liens registered',
    'The number of liens registered against an entity.' ],
'14' => [ 'Livestock',
    'The number of animals kept for use or profit.' ],
'15' => [ 'Insufficient funds returned cheques',
    'The number of cheques returned due to insufficient funds.' ],
'16' => [ 'Stolen cheques',
    'The number of stolen cheques.' ],
'17' => [ 'Quantity on hand',
    'The total quantity of a product on hand at a location. This includes as well units awaiting return to manufacturer, units unavailable due to inspection procedures and undamaged stock available for despatch, resale or use.' ],
'18' => [ 'Previous quantity',
    'Quantity previously referenced.' ],
'19' => [ 'Paid-in security shares',
    'The number of security shares issued and for which full payment has been made.' ],
'20' => [ 'Unusable quantity',
    'Quantity not usable.' ],
'21' => [ 'Ordered quantity',
    '[6024] The quantity which has been ordered.' ],
'22' => [ 'Quantity at 100%',
    'Equivalent quantity at 100% purity.' ],
'23' => [ 'Active ingredient',
    'Quantity at 100% active agent content.' ],
'24' => [ "Inventory quantity at supplier's not subject to inspection",
    'by customer Quantity of goods which the customer requires the supplier to have in inventory but which will not be checked by the customer.' ],
'25' => [ 'Retail sales',
    'Quantity of retail point of sale activity.' ],
'26' => [ 'Promotion quantity',
    'A quantity associated with a promotional event.' ],
'27' => [ 'On hold for shipment',
    'Article received which cannot be shipped in its present form.' ],
'28' => [ 'Military sales quantity',
    'Quantity of goods or services sold to a military organization.' ],
'29' => [ 'On premises sales',
    'Sale of product in restaurants or bars.' ],
'30' => [ 'Off premises sales',
    'Sale of product directly to a store.' ],
'31' => [ 'Estimated annual volume',
    'Volume estimated for a year.' ],
'32' => [ 'Minimum delivery batch',
    'Minimum quantity of goods delivered at one time.' ],
'33' => [ 'Maximum delivery batch',
    'Maximum quantity of goods delivered at one time.' ],
'34' => [ 'Pipes',
    'The number of tubes used to convey a substance.' ],
'35' => [ 'Price break from',
    'The minimum quantity of a quantity range for a specified (unit) price.' ],
'36' => [ 'Price break to',
    'Maximum quantity to which the price break applies.' ],
'37' => [ 'Poultry',
    'The number of domestic fowl.' ],
'38' => [ 'Secured charges registered',
    'The number of secured charges registered against an entity.' ],
'39' => [ 'Total properties owned',
    'The total number of properties owned by an entity.' ],
'40' => [ 'Normal delivery',
    'Quantity normally delivered by the seller.' ],
'41' => [ 'Sales quantity not included in the replenishment',
    'calculation Sales which will not be included in the calculation of replenishment requirements.' ],
'42' => [ 'Maximum supply quantity, supplier endorsed',
    'Maximum supply quantity endorsed by a supplier.' ],
'43' => [ 'Buyer',
    'The number of buyers.' ],
'44' => [ 'Debenture bond',
    'The number of fixed-interest bonds of an entity backed by general credit rather than specified assets.' ],
'45' => [ 'Debentures filed against directors',
    "The number of notices of indebtedness filed against an entity's directors." ],
'46' => [ 'Pieces delivered',
    'Number of pieces actually received at the final destination.' ],
'47' => [ 'Invoiced quantity',
    'The quantity as per invoice.' ],
'48' => [ 'Received quantity',
    'The quantity which has been received.' ],
'49' => [ 'Chargeable distance',
    '[6110] The distance between two points for which a specific tariff applies.' ],
'50' => [ 'Disposition undetermined quantity',
    'Product quantity that has not yet had its disposition determined.' ],
'51' => [ 'Inventory category transfer',
    'Inventory that has been moved from one inventory category to another.' ],
'52' => [ 'Quantity per pack',
    'Quantity for each pack.' ],
'53' => [ 'Minimum order quantity',
    'Minimum quantity of goods for an order.' ],
'54' => [ 'Maximum order quantity',
    'Maximum quantity of goods for an order.' ],
'55' => [ 'Total sales',
    'The summation of total quantity sales.' ],
'56' => [ 'Wholesaler to wholesaler sales',
    'Sale of product to other wholesalers by a wholesaler.' ],
'57' => [ 'In transit quantity',
    'A quantity that is en route.' ],
'58' => [ 'Quantity withdrawn',
    'Quantity withdrawn from a location.' ],
'59' => [ 'Numbers of consumer units in the traded unit',
    'Number of units for consumer sales in a unit for trading.' ],
'60' => [ 'Current inventory quantity available for shipment',
    'Current inventory quantity available for shipment.' ],
'61' => [ 'Return quantity',
    'Quantity of goods returned.' ],
'62' => [ 'Sorted quantity',
    'The quantity that is sorted.' ],
'63' => [ 'Sorted quantity rejected',
    'The sorted quantity that is rejected.' ],
'64' => [ 'Scrap quantity',
    'Remainder of the total quantity after split deliveries.' ],
'65' => [ 'Destroyed quantity',
    'Quantity of goods destroyed.' ],
'66' => [ 'Committed quantity',
    'Quantity a party is committed to.' ],
'67' => [ 'Estimated reading quantity',
    'The value that is estimated to be the reading of a measuring device (e.g. meter).' ],
'68' => [ 'End quantity',
    'The quantity recorded at the end of an agreement or period.' ],
'69' => [ 'Start quantity',
    'The quantity recorded at the start of an agreement or period.' ],
'70' => [ 'Cumulative quantity received',
    'Cumulative quantity of all deliveries of this article received by the buyer.' ],
'71' => [ 'Cumulative quantity ordered',
    'Cumulative quantity of all deliveries, outstanding and scheduled orders.' ],
'72' => [ 'Cumulative quantity received end of prior year',
    'Cumulative quantity of all deliveries of the product received by the buyer till end of prior year.' ],
'73' => [ 'Outstanding quantity',
    'Difference between quantity ordered and quantity received.' ],
'74' => [ 'Latest cumulative quantity',
    'Cumulative quantity after complete delivery of all scheduled quantities of the product.' ],
'75' => [ 'Previous highest cumulative quantity',
    'Cumulative quantity after complete delivery of all scheduled quantities of the product from a prior schedule period.' ],
'76' => [ 'Adjusted corrector reading',
    'A corrector reading after it has been adjusted.' ],
'77' => [ 'Work days',
    'Number of work days, e.g. per respective period.' ],
'78' => [ 'Cumulative quantity scheduled',
    'Adding the quantity actually scheduled to previous cumulative quantity.' ],
'79' => [ 'Previous cumulative quantity',
    'Cumulative quantity prior the actual order.' ],
'80' => [ 'Unadjusted corrector reading',
    'A corrector reading before it has been adjusted.' ],
'81' => [ 'Extra unplanned delivery',
    'Non scheduled additional quantity.' ],
'82' => [ 'Quantity requirement for sample inspection',
    'Required quantity for sample inspection.' ],
'83' => [ 'Backorder quantity',
    'The quantity of goods that is on back-order.' ],
'84' => [ 'Urgent delivery quantity',
    'Quantity for urgent delivery.' ],
'85' => [ 'Previous order quantity to be cancelled',
    'Quantity ordered previously to be cancelled.' ],
'86' => [ 'Normal reading quantity',
    'The value recorded or read from a measuring device (e.g. meter) in the normal conditions.' ],
'87' => [ 'Customer reading quantity',
    'The value recorded or read from a measuring device (e.g. meter) by the customer.' ],
'88' => [ 'Information reading quantity',
    'The value recorded or read from a measuring device (e.g. meter) for information purposes.' ],
'89' => [ 'Quality control held',
    'Quantity of goods held pending completion of a quality control assessment.' ],
'90' => [ 'As is quantity',
    'Quantity as it is in the existing circumstances.' ],
'91' => [ 'Open quantity',
    'Quantity remaining after partial delivery.' ],
'92' => [ 'Final delivery quantity',
    'Quantity of final delivery to a respective order.' ],
'93' => [ 'Subsequent delivery quantity',
    "Quantity delivered to a respective order after it's final delivery." ],
'94' => [ 'Substitutional quantity',
    'Quantity delivered replacing previous deliveries.' ],
'95' => [ 'Redelivery after post processing',
    'Quantity redelivered after post processing.' ],
'96' => [ 'Quality control failed',
    'Quantity of goods which have failed quality control.' ],
'97' => [ 'Minimum inventory',
    'Minimum stock quantity on which replenishment is based.' ],
'98' => [ 'Maximum inventory',
    'Maximum stock quantity on which replenishment is based.' ],
'99' => [ 'Estimated quantity',
    'Quantity estimated.' ],
'100' => [ 'Chargeable weight',
    'The weight on which charges are based.' ],
'101' => [ 'Chargeable gross weight',
    'The gross weight on which charges are based.' ],
'102' => [ 'Chargeable tare weight',
    'The tare weight on which charges are based.' ],
'103' => [ 'Chargeable number of axles',
    'The number of axles on which charges are based.' ],
'104' => [ 'Chargeable number of containers',
    'The number of containers on which charges are based.' ],
'105' => [ 'Chargeable number of rail wagons',
    'The number of rail wagons on which charges are based.' ],
'106' => [ 'Chargeable number of packages',
    'The number of packages on which charges are based.' ],
'107' => [ 'Chargeable number of units',
    'The number of units on which charges are based.' ],
'108' => [ 'Chargeable period',
    'The period of time on which charges are based.' ],
'109' => [ 'Chargeable volume',
    'The volume on which charges are based.' ],
'110' => [ 'Chargeable cubic measurements',
    'The cubic measurements on which charges are based.' ],
'111' => [ 'Chargeable surface',
    'The surface area on which charges are based.' ],
'112' => [ 'Chargeable length',
    'The length on which charges are based.' ],
'113' => [ 'Quantity to be delivered',
    'The quantity to be delivered.' ],
'114' => [ 'Number of passengers',
    'Total number of passengers on the conveyance.' ],
'115' => [ 'Number of crew',
    'Total number of crew members on the conveyance.' ],
'116' => [ 'Number of transport documents',
    'Total number of air waybills, bills of lading, etc. being reported for a specific conveyance.' ],
'117' => [ 'Quantity landed',
    'Quantity of goods actually arrived.' ],
'118' => [ 'Quantity manifested',
    'Quantity of goods contracted for delivery by the carrier.' ],
'119' => [ 'Short shipped',
    'Indication that part of the consignment was not shipped.' ],
'120' => [ 'Split shipment',
    'Indication that the consignment has been split into two or more shipments.' ],
'121' => [ 'Over shipped',
    'The quantity of goods shipped that exceeds the quantity contracted.' ],
'122' => [ 'Short-landed goods',
    'If quantity of goods actually landed is less than the quantity which appears in the documentation. This quantity is the difference between these quantities.' ],
'123' => [ 'Surplus goods',
    'If quantity of goods actually landed is more than the quantity which appears in the documentation. This quantity is the difference between these quantities.' ],
'124' => [ 'Damaged goods',
    'Quantity of goods which have deteriorated in transport such that they cannot be used for the purpose for which they were originally intended.' ],
'125' => [ 'Pilferage goods',
    'Quantity of goods stolen during transport.' ],
'126' => [ 'Lost goods',
    'Quantity of goods that disappeared in transport.' ],
'127' => [ 'Report difference',
    'The quantity concerning the same transaction differs between two documents/messages and the source of this difference is a typing error.' ],
'128' => [ 'Quantity loaded',
    'Quantity of goods loaded onto a means of transport.' ],
'129' => [ 'Units per unit price',
    'Number of units per unit price.' ],
'130' => [ 'Allowance',
    'Quantity relevant for allowance.' ],
'131' => [ 'Delivery quantity',
    'Quantity required by buyer to be delivered.' ],
'132' => [ 'Cumulative quantity, preceding period, planned',
    'Cumulative quantity originally planned for the preceding period.' ],
'133' => [ 'Cumulative quantity, preceding period, reached',
    'Cumulative quantity reached in the preceding period.' ],
'134' => [ 'Cumulative quantity, actual planned',
    'Cumulative quantity planned for now.' ],
'135' => [ 'Period quantity, planned',
    'Quantity planned for this period.' ],
'136' => [ 'Period quantity, reached',
    'Quantity reached during this period.' ],
'137' => [ 'Cumulative quantity, preceding period, estimated',
    'Estimated cumulative quantity reached in the preceding period.' ],
'138' => [ 'Cumulative quantity, actual estimated',
    'Estimated cumulative quantity reached now.' ],
'139' => [ 'Cumulative quantity, preceding period, measured',
    'Surveyed cumulative quantity reached in the preceding period.' ],
'140' => [ 'Cumulative quantity, actual measured',
    'Surveyed cumulative quantity reached now.' ],
'141' => [ 'Period quantity, measured',
    'Surveyed quantity reached during this period.' ],
'142' => [ 'Total quantity, planned',
    'Total quantity planned.' ],
'143' => [ 'Quantity, remaining',
    'Quantity remaining.' ],
'144' => [ 'Tolerance',
    'Plus or minus tolerance expressed as a monetary amount.' ],
'145' => [ 'Actual stock',
    'The stock on hand, undamaged, and available for despatch, sale or use.' ],
'146' => [ 'Model or target stock',
    'The stock quantity required or planned to have on hand, undamaged and available for use.' ],
'147' => [ 'Direct shipment quantity',
    'Quantity to be shipped directly to a customer from a manufacturing site.' ],
'148' => [ 'Amortization total quantity',
    'Indication of final quantity for amortization.' ],
'149' => [ 'Amortization order quantity',
    'Indication of actual share of the order quantity for amortization.' ],
'150' => [ 'Amortization cumulated quantity',
    'Indication of actual cumulated quantity of previous and actual amortization order quantity.' ],
'151' => [ 'Quantity advised',
    'Quantity advised by supplier or shipper, in contrast to quantity actually received.' ],
'152' => [ 'Consignment stock',
    'Quantity of goods with an external customer which is still the property of the supplier. Payment for these goods is only made to the supplier when the ownership has been transferred between the trading partners.' ],
'153' => [ 'Statistical sales quantity',
    'Quantity of goods sold in a specified period.' ],
'154' => [ 'Sales quantity planned',
    'Quantity of goods required to meet future demands. - Market intelligence quantity.' ],
'155' => [ 'Replenishment quantity',
    'Quantity required to maintain the requisite on-hand stock of goods.' ],
'156' => [ 'Inventory movement quantity',
    'To specify the quantity of an inventory movement.' ],
'157' => [ 'Opening stock balance quantity',
    'To specify the quantity of an opening stock balance.' ],
'158' => [ 'Closing stock balance quantity',
    'To specify the quantity of a closing stock balance.' ],
'159' => [ 'Number of stops',
    'Number of times a means of transport stops before arriving at destination.' ],
'160' => [ 'Minimum production batch',
    'The quantity specified is the minimum output from a single production run.' ],
'161' => [ 'Dimensional sample quantity',
    'The quantity defined is a sample for the purpose of validating dimensions.' ],
'162' => [ 'Functional sample quantity',
    'The quantity defined is a sample for the purpose of validating function and performance.' ],
'163' => [ 'Pre-production quantity',
    'Quantity of the referenced item required prior to full production.' ],
'164' => [ 'Delivery batch',
    'Quantity of the referenced item which constitutes a standard batch for deliver purposes.' ],
'165' => [ 'Delivery batch multiple',
    'The multiples in which delivery batches can be supplied.' ],
'166' => [ 'All time buy',
    'The total quantity of the referenced covering all future needs. Further orders of the referenced item are not expected.' ],
'167' => [ 'Total delivery quantity',
    'The total quantity required by the buyer to be delivered.' ],
'168' => [ 'Single delivery quantity',
    'The quantity required by the buyer to be delivered in a single shipment.' ],
'169' => [ 'Supplied quantity',
    'Quantity of the referenced item actually shipped.' ],
'170' => [ 'Allocated quantity',
    'Quantity of the referenced item allocated from available stock for delivery.' ],
'171' => [ 'Maximum stackability',
    'The number of pallets/handling units which can be safely stacked one on top of another.' ],
'172' => [ 'Amortisation quantity',
    'The quantity of the referenced item which has a cost for tooling amortisation included in the item price.' ],
'173' => [ 'Previously amortised quantity',
    'The cumulative quantity of the referenced item which had a cost for tooling amortisation included in the item price.' ],
'174' => [ 'Total amortisation quantity',
    'The total quantity of the referenced item which has a cost for tooling amortisation included in the item price.' ],
'175' => [ 'Number of moulds',
    'The number of pressing moulds contained within a single piece of the referenced tooling.' ],
'176' => [ 'Concurrent item output of tooling',
    'The number of related items which can be produced simultaneously with a single piece of the referenced tooling.' ],
'177' => [ 'Periodic capacity of tooling',
    'Maximum production output of the referenced tool over a period of time.' ],
'178' => [ 'Lifetime capacity of tooling',
    'Maximum production output of the referenced tool over its productive lifetime.' ],
'179' => [ 'Number of deliveries per despatch period',
    'The number of deliveries normally expected to be despatched within each despatch period.' ],
'180' => [ 'Provided quantity',
    'The quantity of a referenced component supplied by the buyer for manufacturing of an ordered item.' ],
'181' => [ 'Maximum production batch',
    'The quantity specified is the maximum output from a single production run.' ],
'182' => [ 'Cancelled quantity',
    'Quantity of the referenced item which has previously been ordered and is now cancelled.' ],
'183' => [ 'No delivery requirement in this instruction',
    'This delivery instruction does not contain any delivery requirements.' ],
'184' => [ 'Quantity of material in ordered time',
    'Quantity of the referenced material within the ordered time.' ],
'185' => [ 'Rejected quantity',
    'The quantity of received goods rejected for quantity reasons.' ],
'186' => [ 'Cumulative quantity scheduled up to accumulation start date',
    'The cumulative quantity scheduled up to the accumulation start date.' ],
'187' => [ 'Quantity scheduled',
    'The quantity scheduled for delivery.' ],
'188' => [ 'Number of identical handling units',
    'Number of identical handling units in terms of type and contents.' ],
'189' => [ 'Number of packages in handling unit',
    'The number of packages contained in one handling unit.' ],
'190' => [ 'Despatch note quantity',
    'The item quantity specified on the despatch note.' ],
'191' => [ 'Adjustment to inventory quantity',
    'An adjustment to inventory quantity.' ],
'192' => [ 'Free goods quantity',
    'Quantity of goods which are free of charge.' ],
'193' => [ 'Free quantity included',
    'Quantity included to which no charge is applicable.' ],
'194' => [ 'Received and accepted',
    'Quantity which has been received and accepted at a given location.' ],
'195' => [ 'Received, not accepted, to be returned',
    'Quantity which has been received but not accepted at a given location and which will consequently be returned to the relevant party.' ],
'196' => [ 'Received, not accepted, to be destroyed',
    'Quantity which has been received but not accepted at a given location and which will consequently be destroyed.' ],
'197' => [ 'Reordering level',
    'Quantity at which an order may be triggered to replenish.' ],
'199' => [ 'Inventory withdrawal quantity',
    'Quantity which has been withdrawn from inventory since the last inventory report.' ],
'200' => [ 'Free quantity not included',
    'Free quantity not included in ordered quantity.' ],
'201' => [ 'Recommended overhaul and repair quantity',
    'To indicate the recommended quantity of an article required to support overhaul and repair activities.' ],
'202' => [ 'Quantity per next higher assembly',
    'To indicate the quantity required for the next higher assembly.' ],
'203' => [ 'Quantity per unit of issue',
    'Provides the standard quantity of an article in which one unit can be issued.' ],
'204' => [ 'Cumulative scrap quantity',
    'Provides the cumulative quantity of an item which has been identified as scrapped.' ],
'205' => [ 'Publication turn size',
    'The quantity of magazines or newspapers grouped together with the spine facing alternate directions in a bundle.' ],
'206' => [ 'Recommended maintenance quantity',
    'Recommended quantity of an article which is required to meet an agreed level of maintenance.' ],
'207' => [ 'Labour hours',
    'Number of labour hours.' ],
'208' => [ 'Quantity requirement for maintenance and repair of',
    'equipment Quantity of the material needed to maintain and repair equipment.' ],
'209' => [ 'Additional replenishment demand quantity',
    'Incremental needs over and above normal replenishment calculations, but not intended to permanently change the model parameters.' ],
'210' => [ 'Returned by consumer quantity',
    'Quantity returned by a consumer.' ],
'211' => [ 'Replenishment override quantity',
    'Quantity to override the normal replenishment model calculations, but not intended to permanently change the model parameters.' ],
'212' => [ 'Quantity sold, net',
    'Net quantity sold which includes returns of saleable inventory and other adjustments.' ],
'213' => [ 'Transferred out quantity',
    'Quantity which was transferred out of this location.' ],
'214' => [ 'Transferred in quantity',
    'Quantity which was transferred into this location.' ],
'215' => [ 'Unsaleable quantity',
    'Quantity of inventory received which cannot be sold in its present condition.' ],
'216' => [ 'Consumer reserved quantity',
    'Quantity reserved for consumer delivery or pickup and not yet withdrawn from inventory.' ],
'217' => [ 'Out of inventory quantity',
    'Quantity of inventory which was requested but was not available.' ],
'218' => [ 'Quantity returned, defective or damaged',
    'Quantity returned in a damaged or defective condition.' ],
'219' => [ 'Taxable quantity',
    'Quantity subject to taxation.' ],
'220' => [ 'Meter reading',
    'The numeric value of measure units counted by a meter.' ],
'221' => [ 'Maximum requestable quantity',
    'The maximum quantity which may be requested.' ],
'222' => [ 'Minimum requestable quantity',
    'The minimum quantity which may be requested.' ],
'223' => [ 'Daily average quantity',
    'The quantity for a defined period divided by the number of days of the period.' ],
'224' => [ 'Budgeted hours',
    'The number of budgeted hours.' ],
'225' => [ 'Actual hours',
    'The number of actual hours.' ],
'226' => [ 'Earned value hours',
    'The number of earned value hours.' ],
'227' => [ 'Estimated hours',
    'The number of estimated hours.' ],
'228' => [ 'Level resource task quantity',
    'Quantity of a resource that is level for the duration of the task.' ],
'229' => [ 'Available resource task quantity',
    'Quantity of a resource available to complete a task.' ],
'230' => [ 'Work time units',
    'Quantity of work units of time.' ],
'231' => [ 'Daily work shifts',
    'Quantity of work shifts per day.' ],
'232' => [ 'Work time units per shift',
    'Work units of time per work shift.' ],
'233' => [ 'Work calendar units',
    'Work calendar units of time.' ],
'234' => [ 'Elapsed duration',
    'Quantity representing the elapsed duration.' ],
'235' => [ 'Remaining duration',
    'Quantity representing the remaining duration.' ],
'236' => [ 'Original duration',
    'Quantity representing the original duration.' ],
'237' => [ 'Current duration',
    'Quantity representing the current duration.' ],
'238' => [ 'Total float time',
    'Quantity representing the total float time.' ],
'239' => [ 'Free float time',
    'Quantity representing the free float time.' ],
'240' => [ 'Lag time',
    'Quantity representing lag time.' ],
'241' => [ 'Lead time',
    'Quantity representing lead time.' ],
'242' => [ 'Number of months',
    'The number of months.' ],
'243' => [ 'Reserved quantity customer direct delivery sales',
    'Quantity of products reserved for sales delivered direct to the customer.' ],
'244' => [ 'Reserved quantity retail sales',
    'Quantity of products reserved for retail sales.' ],
'245' => [ 'Consolidated discount inventory',
    'A quantity of inventory supplied at consolidated discount terms.' ],
'246' => [ 'Returns replacement quantity',
    'A quantity of goods issued as a replacement for a returned quantity.' ],
'247' => [ 'Additional promotion sales forecast quantity',
    'A forecast of additional quantity which will be sold during a period of promotional activity.' ],
'248' => [ 'Reserved quantity',
    'Quantity reserved for specific purposes.' ],
'249' => [ 'Quantity displayed not available for sale',
    'Quantity displayed within a retail outlet but not available for sale.' ],
'250' => [ 'Inventory discrepancy',
    'The difference recorded between theoretical and physical inventory.' ],
'251' => [ 'Incremental order quantity',
    'The incremental quantity by which ordering is carried out.' ],
'252' => [ 'Quantity requiring manipulation before despatch',
    'A quantity of goods which needs manipulation before despatch.' ],
'253' => [ 'Quantity in quarantine',
    'A quantity of goods which are held in a restricted area for quarantine purposes.' ],
'254' => [ 'Quantity withheld by owner of goods',
    'A quantity of goods which has been withheld by the owner of the goods.' ],
'255' => [ 'Quantity not available for despatch',
    'A quantity of goods not available for despatch.' ],
'256' => [ 'Quantity awaiting delivery',
    'Quantity of goods which are awaiting delivery.' ],
'257' => [ 'Quantity in physical inventory',
    'A quantity of goods held in physical inventory.' ],
'258' => [ 'Quantity held by logistic service provider',
    'Quantity of goods under the control of a logistic service provider.' ],
'259' => [ 'Optimal quantity',
    'The optimal quantity for a given purpose.' ],
'260' => [ 'Delivery quantity balance',
    'The difference between the scheduled quantity and the quantity delivered to the consignee at a given date.' ],
'261' => [ 'Cumulative quantity shipped',
    'Cumulative quantity of all shipments.' ],
'262' => [ 'Quantity suspended',
    'The quantity of something which is suspended.' ],
'263' => [ 'Control quantity',
    'The quantity designated for control purposes.' ],
'264' => [ 'Equipment quantity',
    'A count of a quantity of equipment.' ],
'265' => [ 'Factor',
    'Number by which the measured unit has to be multiplied to calculate the units used.' ],
'266' => [ 'Unsold quantity held by wholesaler',
    'Unsold quantity held by the wholesaler.' ],
'267' => [ 'Quantity held by delivery vehicle',
    'Quantity of goods held by the delivery vehicle.' ],
'268' => [ 'Quantity held by retail outlet',
    'Quantity held by the retail outlet.' ],
'269' => [ 'Rejected return quantity',
    'A quantity for return which has been rejected.' ],
'270' => [ 'Accounts',
    'The number of accounts.' ],
'271' => [ 'Accounts placed for collection',
    'The number of accounts placed for collection.' ],
'272' => [ 'Activity codes',
    'The number of activity codes.' ],
'273' => [ 'Agents',
    'The number of agents.' ],
'274' => [ 'Airline attendants',
    'The number of airline attendants.' ],
'275' => [ 'Authorised shares',
    'The number of shares authorised for issue.' ],
'276' => [ 'Employee average',
    'The average number of employees.' ],
'277' => [ 'Branch locations',
    'The number of branch locations.' ],
'278' => [ 'Capital changes',
    'The number of capital changes made.' ],
'279' => [ 'Clerks',
    'The number of clerks.' ],
'280' => [ 'Companies in same activity',
    'The number of companies doing business in the same activity category.' ],
'281' => [ 'Companies included in consolidated financial statement',
    'The number of companies included in a consolidated financial statement.' ],
'282' => [ 'Cooperative shares',
    'The number of cooperative shares.' ],
'283' => [ 'Creditors',
    'The number of creditors.' ],
'284' => [ 'Departments',
    'The number of departments.' ],
'285' => [ 'Design employees',
    'The number of employees involved in the design process.' ],
'286' => [ 'Physicians',
    'The number of medical doctors.' ],
'287' => [ 'Domestic affiliated companies',
    'The number of affiliated companies located within the country.' ],
'288' => [ 'Drivers',
    'The number of drivers.' ],
'289' => [ 'Employed at location',
    'The number of employees at the specified location.' ],
'290' => [ 'Employed by this company',
    'The number of employees at the specified company.' ],
'291' => [ 'Total employees',
    'The total number of employees.' ],
'292' => [ 'Employees shared',
    'The number of employees shared among entities.' ],
'293' => [ 'Engineers',
    'The number of engineers.' ],
'294' => [ 'Estimated accounts',
    'The estimated number of accounts.' ],
'295' => [ 'Estimated employees at location',
    'The estimated number of employees at the specified location.' ],
'296' => [ 'Estimated total employees',
    'The total estimated number of employees.' ],
'297' => [ 'Executives',
    'The number of executives.' ],
'298' => [ 'Agricultural workers',
    'The number of agricultural workers.' ],
'299' => [ 'Financial institutions',
    'The number of financial institutions.' ],
'300' => [ 'Floors occupied',
    'The number of floors occupied.' ],
'301' => [ 'Foreign related entities',
    'The number of related entities located outside the country.' ],
'302' => [ 'Group employees',
    'The number of employees within the group.' ],
'303' => [ 'Indirect employees',
    'The number of employees not associated with direct production.' ],
'304' => [ 'Installers',
    'The number of employees involved with the installation process.' ],
'305' => [ 'Invoices',
    'The number of invoices.' ],
'306' => [ 'Issued shares',
    'The number of shares actually issued.' ],
'307' => [ 'Labourers',
    'The number of labourers.' ],
'308' => [ 'Manufactured units',
    'The number of units manufactured.' ],
'309' => [ 'Maximum number of employees',
    'The maximum number of people employed.' ],
'310' => [ 'Maximum number of employees at location',
    'The maximum number of people employed at a location.' ],
'311' => [ 'Members in group',
    'The number of members within a group.' ],
'312' => [ 'Minimum number of employees at location',
    'The minimum number of people employed at a location.' ],
'313' => [ 'Minimum number of employees',
    'The minimum number of people employed.' ],
'314' => [ 'Non-union employees',
    'The number of employees not belonging to a labour union.' ],
'315' => [ 'Floors',
    'The number of floors in a building.' ],
'316' => [ 'Nurses',
    'The number of nurses.' ],
'317' => [ 'Office workers',
    'The number of workers in an office.' ],
'318' => [ 'Other employees',
    'The number of employees otherwise categorised.' ],
'319' => [ 'Part time employees',
    'The number of employees working on a part time basis.' ],
'320' => [ 'Accounts payable average overdue days',
    'The average number of days accounts payable are overdue.' ],
'321' => [ 'Pilots',
    'The number of pilots.' ],
'322' => [ 'Plant workers',
    'The number of workers within a plant.' ],
'323' => [ 'Previous number of accounts',
    'The number of accounts which preceded the current count.' ],
'324' => [ 'Previous number of branch locations',
    'The number of branch locations which preceded the current count.' ],
'325' => [ 'Principals included as employees',
    'The number of principals which are included in the count of employees.' ],
'326' => [ 'Protested bills',
    'The number of bills which are protested.' ],
'327' => [ 'Registered brands distributed',
    'The number of registered brands which are being distributed.' ],
'328' => [ 'Registered brands manufactured',
    'The number of registered brands which are being manufactured.' ],
'329' => [ 'Related business entities',
    'The number of related business entities.' ],
'330' => [ 'Relatives employed',
    'The number of relatives which are counted as employees.' ],
'331' => [ 'Rooms',
    'The number of rooms.' ],
'332' => [ 'Salespersons',
    'The number of salespersons.' ],
'333' => [ 'Seats',
    'The number of seats.' ],
'334' => [ 'Shareholders',
    'The number of shareholders.' ],
'335' => [ 'Shares of common stock',
    'The number of shares of common stock.' ],
'336' => [ 'Shares of preferred stock',
    'The number of shares of preferred stock.' ],
'337' => [ 'Silent partners',
    'The number of silent partners.' ],
'338' => [ 'Subcontractors',
    'The number of subcontractors.' ],
'339' => [ 'Subsidiaries',
    'The number of subsidiaries.' ],
'340' => [ 'Law suits',
    'The number of law suits.' ],
'341' => [ 'Suppliers',
    'The number of suppliers.' ],
'342' => [ 'Teachers',
    'The number of teachers.' ],
'343' => [ 'Technicians',
    'The number of technicians.' ],
'344' => [ 'Trainees',
    'The number of trainees.' ],
'345' => [ 'Union employees',
    'The number of employees who are members of a labour union.' ],
'346' => [ 'Number of units',
    'The quantity of units.' ],
'347' => [ 'Warehouse employees',
    'The number of employees who work in a warehouse setting.' ],
'348' => [ 'Shareholders holding remainder of shares',
    'Number of shareholders owning the remainder of shares.' ],
'349' => [ 'Payment orders filed',
    'Number of payment orders filed.' ],
'350' => [ 'Uncovered cheques',
    'Number of uncovered cheques.' ],
'351' => [ 'Auctions',
    'Number of auctions.' ],
'352' => [ 'Units produced',
    'The number of units produced.' ],
'353' => [ 'Added employees',
    'Number of employees that were added to the workforce.' ],
'354' => [ 'Number of added locations',
    'Number of locations that were added.' ],
'355' => [ 'Total number of foreign subsidiaries not included in',
    'financial statement The total number of foreign subsidiaries not included in the financial statement.' ],
'356' => [ 'Number of closed locations',
    'Number of locations that were closed.' ],
'357' => [ 'Counter clerks',
    'The number of clerks that work behind a flat-topped fitment.' ],
'358' => [ 'Payment experiences in the last 3 months',
    'The number of payment experiences received for an entity over the last 3 months.' ],
'359' => [ 'Payment experiences in the last 12 months',
    'The number of payment experiences received for an entity over the last 12 months.' ],
'360' => [ 'Total number of subsidiaries not included in the financial',
    'statement The total number of subsidiaries not included in the financial statement.' ],
'361' => [ 'Paid-in common shares',
    'The number of paid-in common shares.' ],
'362' => [ 'Total number of domestic subsidiaries not included in',
    'financial statement The total number of domestic subsidiaries not included in the financial statement.' ],
'363' => [ 'Total number of foreign subsidiaries included in financial',
    'statement The total number of foreign subsidiaries included in the financial statement.' ],
'364' => [ 'Total number of domestic subsidiaries included in financial',
    'statement The total number of domestic subsidiaries included in the financial statement.' ],
'365' => [ 'Total transactions',
    'The total number of transactions.' ],
'366' => [ 'Paid-in preferred shares',
    'The number of paid-in preferred shares.' ],
'367' => [ 'Employees',
    'Code specifying the quantity of persons working for a company, whose services are used for pay.' ],
'368' => [ 'Active ingredient dose per unit, dispensed',
    'The dosage of active ingredient per dispensed unit.' ],
'369' => [ 'Budget',
    'Budget quantity.' ],
'370' => [ 'Budget, cumulative to date',
    'Budget quantity, cumulative to date.' ],
'371' => [ 'Actual units',
    'The number of actual units.' ],
'372' => [ 'Actual units, cumulative to date',
    'The number of cumulative to date actual units.' ],
'373' => [ 'Earned value',
    'Earned value quantity.' ],
'374' => [ 'Earned value, cumulative to date',
    'Earned value quantity accumulated to date.' ],
'375' => [ 'At completion quantity, estimated',
    'The estimated quantity when a project is complete.' ],
'376' => [ 'To complete quantity, estimated',
    'The estimated quantity required to complete a project.' ],
'377' => [ 'Adjusted units',
    'The number of adjusted units.' ],
'378' => [ 'Number of limited partnership shares',
    'Number of shares held in a limited partnership.' ],
'379' => [ 'National business failure incidences',
    'Number of firms in a country that discontinued with a loss to creditors.' ],
'380' => [ 'Industry business failure incidences',
    'Number of firms in a specific industry that discontinued with a loss to creditors.' ],
'381' => [ 'Business class failure incidences',
    'Number of firms in a specific class that discontinued with a loss to creditors.' ],
'382' => [ 'Mechanics',
    'Number of mechanics.' ],
'383' => [ 'Messengers',
    'Number of messengers.' ],
'384' => [ 'Primary managers',
    'Number of primary managers.' ],
'385' => [ 'Secretaries',
    'Number of secretaries.' ],
'386' => [ 'Detrimental legal filings',
    'Number of detrimental legal filings.' ],
'387' => [ 'Branch office locations, estimated',
    'Estimated number of branch office locations.' ],
'388' => [ 'Previous number of employees',
    'The number of employees for a previous period.' ],
'389' => [ 'Asset seizers',
    'Number of entities that seize assets of another entity.' ],
'390' => [ 'Out-turned quantity',
    'The quantity discharged.' ],
'391' => [ 'Material on-board quantity, prior to loading',
    'The material in vessel tanks, void spaces, and pipelines prior to loading.' ],
'392' => [ 'Supplier estimated previous meter reading',
    'Previous meter reading estimated by the supplier.' ],
'393' => [ 'Supplier estimated latest meter reading',
    'Latest meter reading estimated by the supplier.' ],
'394' => [ 'Customer estimated previous meter reading',
    'Previous meter reading estimated by the customer.' ],
'395' => [ 'Customer estimated latest meter reading',
    'Latest meter reading estimated by the customer.' ],
'396' => [ 'Supplier previous meter reading',
    'Previous meter reading done by the supplier.' ],
'397' => [ 'Supplier latest meter reading',
    'Latest meter reading recorded by the supplier.' ],
'398' => [ 'Maximum number of purchase orders allowed',
    'Maximum number of purchase orders that are allowed.' ],
'399' => [ 'File size before compression',
    'The size of a file before compression.' ],
'400' => [ 'File size after compression',
    'The size of a file after compression.' ],
'401' => [ 'Securities shares',
    'Number of shares of securities.' ],
'402' => [ 'Patients',
    'Number of patients.' ],
'403' => [ 'Completed projects',
    'Number of completed projects.' ],
'404' => [ 'Promoters',
    'Number of entities who finance or organize an event or a production.' ],
'405' => [ 'Administrators',
    'Number of administrators.' ],
'406' => [ 'Supervisors',
    'Number of supervisors.' ],
'407' => [ 'Professionals',
    'Number of professionals.' ],
'408' => [ 'Debt collectors',
    'Number of debt collectors.' ],
'409' => [ 'Inspectors',
    'Number of individuals who perform inspections.' ],
'410' => [ 'Operators',
    'Number of operators.' ],
'411' => [ 'Trainers',
    'Number of trainers.' ],
'412' => [ 'Active accounts',
    'Number of accounts in a current or active status.' ],
'413' => [ 'Trademarks used',
    'Number of trademarks used.' ],
'414' => [ 'Machines',
    'Number of machines.' ],
'415' => [ 'Fuel pumps',
    'Number of fuel pumps.' ],
'416' => [ 'Tables available',
    'Number of tables available for use.' ],
'417' => [ 'Directors',
    'Number of directors.' ],
'418' => [ 'Freelance debt collectors',
    'Number of debt collectors who work on a freelance basis.' ],
'419' => [ 'Freelance salespersons',
    'Number of salespersons who work on a freelance basis.' ],
'420' => [ 'Travelling employees',
    'Number of travelling employees.' ],
'421' => [ 'Foremen',
    'Number of workers with limited supervisory responsibilities.' ],
'422' => [ 'Production workers',
    'Number of employees engaged in production.' ],
'423' => [ 'Employees not including owners',
    'Number of employees excluding business owners.' ],
'424' => [ 'Beds',
    'Number of beds.' ],
'425' => [ 'Resting quantity',
    'A quantity of product that is at rest before it can be used.' ],
'426' => [ 'Production requirements',
    'Quantity needed to meet production requirements.' ],
'427' => [ 'Corrected quantity',
    'The quantity has been corrected.' ],
'428' => [ 'Operating divisions',
    'Number of divisions operating.' ],
'429' => [ 'Quantitative incentive scheme base',
    'Quantity constituting the base for the quantitative incentive scheme.' ],
'430' => [ 'Petitions filed',
    'Number of petitions that have been filed.' ],
'431' => [ 'Bankruptcy petitions filed',
    'Number of bankruptcy petitions that have been filed.' ],
'432' => [ 'Projects in process',
    'Number of projects in process.' ],
'433' => [ 'Changes in capital structure',
    'Number of modifications made to the capital structure of an entity.' ],
'434' => [ 'Detrimental legal filings against directors',
    'The number of legal filings that are of a detrimental nature that have been filed against the directors.' ],
'435' => [ 'Number of failed businesses of directors',
    'The number of failed businesses with which the directors have been associated.' ],
'436' => [ 'Professor',
    'The number of professors.' ],
'437' => [ 'Seller',
    'The number of sellers.' ],
'438' => [ 'Skilled worker',
    'The number of skilled workers.' ],
'439' => [ 'Trademark represented',
    'The number of trademarks represented.' ],
'440' => [ 'Number of quantitative incentive scheme units',
    'Number of units allocated to a quantitative incentive scheme.' ],
'441' => [ 'Quantity in manufacturing process',
    'Quantity currently in the manufacturing process.' ],
'442' => [ 'Number of units in the width of a layer',
    'Number of units which make up the width of a layer.' ],
'443' => [ 'Number of units in the depth of a layer',
    'Number of units which make up the depth of a layer.' ],
'444' => [ 'Return to warehouse',
    'A quantity of products sent back to the warehouse.' ],
'445' => [ 'Return to the manufacturer',
    'A quantity of products sent back from the manufacturer.' ],
'446' => [ 'Delta quantity',
    'An increment or decrement to a quantity.' ],
'447' => [ 'Quantity moved between outlets',
    'A quantity of products moved between outlets.' ],
'448' => [ 'Pre-paid invoice annual consumption, estimated',
    'The estimated annual consumption used for a prepayment invoice.' ],
'449' => [ 'Total quoted quantity',
    'The sum of quoted quantities.' ],
'450' => [ 'Requests pertaining to entity in last 12 months',
    'Number of requests received in last 12 months pertaining to the entity.' ],
'451' => [ 'Total inquiry matches',
    'Number of instances which correspond with the inquiry.' ],
'452' => [ 'En route to warehouse quantity',
    'A quantity of products that is en route to a warehouse.' ],
'453' => [ 'En route from warehouse quantity',
    'A quantity of products that is en route from a warehouse.' ],
'454' => [ 'Quantity ordered but not yet allocated from stock',
    'A quantity of products which has been ordered but which has not yet been allocated from stock.' ],
'455' => [ 'Not yet ordered quantity',
    'The quantity which has not yet been ordered.' ],
'456' => [ 'Net reserve power',
    'The reserve power available for the net.' ],
'457' => [ 'Maximum number of units per shelf',
    'Maximum number of units of a product that can be placed on a shelf.' ],
'458' => [ 'Stowaway',
    'Number of stowaway(s) on a conveyance.' ],
'459' => [ 'Tug',
    'The number of tugboat(s).' ],
'460' => [ 'Maximum quantity capability of the package',
    'Maximum quantity of a product that can be contained in a package.' ],
'461' => [ 'Calculated',
    'The calculated quantity.' ],
'462' => [ 'Monthly volume, estimated',
    'Volume estimated for a month.' ],
'463' => [ 'Total number of persons',
    'Quantity representing the total number of persons.' ],
'464' => [ 'Tariff Quantity',
    'Quantity of the goods in the unit as required by Customs for duty/tax/fee assessment. These quantities may also be used for other fiscal or statistical purposes.' ],
'465' => [ 'Deducted tariff quantity',
    'Quantity deducted from tariff quantity to reckon duty/tax/fee assessment bases.' ],
'466' => [ 'Advised but not arrived',
    'Goods are advised by the consignor or supplier, but have not yet arrived at the destination.' ],
'467' => [ 'Received but not available',
    'Goods have been received in the arrival area but are not yet available.' ],
'468' => [ 'Goods blocked for transshipment process',
    'Goods are physically present, but can not be ordered because they are scheduled for a transshipment process.' ],
'469' => [ 'Goods blocked for cross docking process',
    'Goods are physically present, but can not be ordered because they are scheduled for a cross docking process.' ],
'470' => [ 'Chargeable number of trailers',
    'The number of trailers on which charges are based.' ],
'471' => [ 'Number of packages for a set',
    'Number of packages used to pack the individual items in a grouping of merchandise that is sold together as a single trade item.' ],
'472' => [ 'Number of items in a set',
    'The number of individual items in a grouping of merchandise that is sold together as a single trade item.' ],
'473' => [ 'Order sizing factor',
    'A trade item specification other than gross, net weight, or volume for a trade item or a transaction, used for order sizing and pricing purposes.' ],
'474' => [ 'Number of different next lower level trade items',
    'Value indicates the number of differrent next lower level trade items contained in a complex trade item.' ],
'475' => [ 'Agreed maximum buying quantity',
    'The agreed maximum quantity of the trade item that may be purchased.' ],
'476' => [ 'Agreed minimum buying quantity',
    'The agreed minimum quantity of the trade item that may be purchased.' ],
'477' => [ 'Free quantity of next lower level trade item',
    'The numeric quantity of free items in a combination pack. The unit of measure used for the free quantity of the next lower level must be the same as the unit of measure of the Net Content of the Child Trade Item.' ],
'478' => [ 'Marine Diesel Oil bunkers on board, on arrival',
    'Number of Marine diesel oil (MDO) bunkers on board when the vessel arrives in the port.' ],
'479' => [ 'Marine Diesel Oil bunkers, loaded',
    'Number of Marine Diesel Oil (MDO) bunkers taken on in the port.' ],
'480' => [ 'Intermediate Fuel Oil bunkers on board, on arrival',
    'Number of Intermediate Fuel Oil (IFO) bunkers on board when the vessel arrives in the port.' ],
'481' => [ 'Intermediate Fuel Oil bunkers, loaded',
    'Number of Intermediate Fuel Oil (IFO) bunkers taken on in the port.' ],
'482' => [ 'Bunker C bunkers on board, on arrival',
    'Number of Bunker C, or Number 6 fuel oil bunkers on board when the vessel arrives in the port.' ],
'483' => [ 'Bunker C bunkers, loaded',
    'Number of Bunker C, or Number 6 fuel oil bunkers, taken on in the port.' ],
'484' => [ 'Number of individual units within the smallest packaging',
    'unit Total number of individual units contained within the smallest unit of packaging.' ],
'485' => [ 'Percentage of constituent element',
    'The part of a product or material that is composed of the constituent element, as a percentage.' ],
'486' => [ 'Quantity to be decremented (LPCO)',
    'Quantity to be decremented from the allowable quantity on a License, Permit, Certificate, or Other document (LPCO).' ],
'487' => [ 'Regulated commodity count',
    'The number of regulated items.' ],
'488' => [ 'Number of passengers, embarking',
    'The number of passengers going aboard a conveyance.' ],
'489' => [ 'Number of passengers, disembarking',
    'The number of passengers disembarking the conveyance.' ],
'490' => [ 'Constituent element or component quantity',
    'The specific quantity of the identified constituent element.' ],
'ZZZ' => [ 'Mutually defined',
    'As agreed by the trading partners.' ],
);
sub get_codes { return \%code_hash; }

1;
