package Alien::libdeflate;

use strict;
use warnings;
use base qw{ Alien::Base };

our $VERSION = '0.01';

1;

__END__

=pod

=encoding UTF-8

=begin html

<a href="https://www.perl.org/get.html">
  <img src="https://img.shields.io/badge/perl-5.8.9+-blue.svg"
       alt="Requires Perl 5.8.9+" />
</a>
<!-- CPAN -->
<a href="https://metacpan.org/pod/Alien::libdeflate">
  <img src="https://img.shields.io/cpan/v/Alien-libdeflate.svg"
       alt="CPAN" />
</a>
<!-- Travis -->
<a href="https://travis-ci.org/kiwiroy/alien-libdeflate">
  <img src="https://travis-ci.org/kiwiroy/alien-libdeflate.svg?branch=master"
       alt="Travis Buils Status" />
</a>

=end html

=head1 NAME

Alien::libdeflate - Fetch/build/stash the libdeflate headers and libs for
L<libdeflate|https://github.com/ebiggers/libdeflate>

=head1 SYNOPSIS

In your C<Makefile.PL> with L<ExtUtils::MakeMaker>.

  use Alien::libdeflate;
  use ExtUtils::MakeMaker;
  use Alien::Base::Wrapper qw( Alien::libdeflate !export );
  use Config;

  WriteMakefile(
    # ...
    Alien::Base::Wrapper->mm_args,
    # ...
    );

In your script or module.

  use Alien::libdeflate;
  use Env qw( @PATH );

  unshift @PATH, Alien::libdeflate->bin_dir;

=head1 DESCRIPTION

Download, build, and install the libdeflate C headers and libraries into a
well-known location, C<<< Alien::libdeflate->dist_dir >>>, from whence other
packages can make use of them.

The version installed will be the latest release on the master branch from
the libdeflate GitHub L<repository|https://github.com/ebiggers/libdeflate>.

=head1 AUTHOR

kiwiroy

=cut
