package Monitoring::GLPlugin::SNMP::MibsAndOids::MMBCOMMIB;

$Monitoring::GLPlugin::SNMP::MibsAndOids::origin->{'MMB-COM-MIB'} = {
  url => 'http://jp.fujitsu.com/platform/server/primequest/download/2000/mib/PQ2000_MIBs-20150407.zip',
  name => 'MMB-COM-MIB',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::mib_ids->{'MMB-COM-MIB'} =
    '1.3.6.1.4.1.211.1.31.1.1';

$Monitoring::GLPlugin::SNMP::MibsAndOids::mibs_and_oids->{'MMB-COM-MIB'} = {
  fujitsu => '1.3.6.1.4.1.211',
  products => '1.3.6.1.4.1.211.1',
  iaServer => '1.3.6.1.4.1.211.1.31',
  primequest => '1.3.6.1.4.1.211.1.31.1',
  mmb => '1.3.6.1.4.1.211.1.31.1.1',
  sysInfo => '1.3.6.1.4.1.211.1.31.1.1.1',
  agentInfo => '1.3.6.1.4.1.211.1.31.1.1.1.1',
  agentId => '1.3.6.1.4.1.211.1.31.1.1.1.1.1',
  agentCompany => '1.3.6.1.4.1.211.1.31.1.1.1.1.2',
  agentVersion => '1.3.6.1.4.1.211.1.31.1.1.1.1.3',
  agentBuild => '1.3.6.1.4.1.211.1.31.1.1.1.1.4',
  agentWriteAllowed => '1.3.6.1.4.1.211.1.31.1.1.1.1.5',
  agentWriteAllowedDefinition => 'MMB-COM-MIB::agentWriteAllowed',
  agentShutdownAllowed => '1.3.6.1.4.1.211.1.31.1.1.1.1.6',
  agentShutdownAllowedDefinition => 'MMB-COM-MIB::agentShutdownAllowed',
  unitInformation => '1.3.6.1.4.1.211.1.31.1.1.1.2',
  localServerUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.2.1',
  psPowerSupplyLoad => '1.3.6.1.4.1.211.1.31.1.1.1.2.1.6',
  numberUnits => '1.3.6.1.4.1.211.1.31.1.1.1.2.2',
  unitTable => '1.3.6.1.4.1.211.1.31.1.1.1.2.3',
  unitEntry => '1.3.6.1.4.1.211.1.31.1.1.1.2.3.1',
  units => '1.3.6.1.4.1.211.1.31.1.1.1.2.3.1',
  uUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.2.3.1.1',
  unitClass => '1.3.6.1.4.1.211.1.31.1.1.1.2.3.1.2',
  unitClassDefinition => 'MMB-COM-MIB::unitClass',
  unitCainetNr => '1.3.6.1.4.1.211.1.31.1.1.1.2.3.1.3',
  unitDesignation => '1.3.6.1.4.1.211.1.31.1.1.1.2.3.1.4',
  unitModelName => '1.3.6.1.4.1.211.1.31.1.1.1.2.3.1.5',
  unitManufacturer => '1.3.6.1.4.1.211.1.31.1.1.1.2.3.1.6',
  unitSerialNumber => '1.3.6.1.4.1.211.1.31.1.1.1.2.3.1.7',
  unitLocation => '1.3.6.1.4.1.211.1.31.1.1.1.2.3.1.8',
  unitContact => '1.3.6.1.4.1.211.1.31.1.1.1.2.3.1.9',
  unitAdminURL => '1.3.6.1.4.1.211.1.31.1.1.1.2.3.1.10',
  frontDoorStatus => '1.3.6.1.4.1.211.1.31.1.1.1.2.3.1.11',
  frontDoorStatusDefinition => 'MMB-COM-MIB::frontDoorStatus',
  housingOpenStatus => '1.3.6.1.4.1.211.1.31.1.1.1.2.3.1.12',
  housingOpenStatusDefinition => 'MMB-COM-MIB::housingOpenStatus',
  msgLogLanguages => '1.3.6.1.4.1.211.1.31.1.1.1.2.3.1.13',
  unitWorldWideName => '1.3.6.1.4.1.211.1.31.1.1.1.2.3.1.14',
  remcsId => '1.3.6.1.4.1.211.1.31.1.1.1.2.3.1.15',
  assetTag => '1.3.6.1.4.1.211.1.31.1.1.1.2.3.1.16',
  unitManagementIpAddress => '1.3.6.1.4.1.211.1.31.1.1.1.2.3.1.18',
  unitManagementIpAddressV6 => '1.3.6.1.4.1.211.1.31.1.1.1.2.3.1.20',
  unitTableUpdateCount => '1.3.6.1.4.1.211.1.31.1.1.1.2.4',
  unitParentTable => '1.3.6.1.4.1.211.1.31.1.1.1.2.5',
  unitParentEntry => '1.3.6.1.4.1.211.1.31.1.1.1.2.5.1',
  unitParents => '1.3.6.1.4.1.211.1.31.1.1.1.2.5.1',
  pUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.2.5.1.1',
  pParentNr => '1.3.6.1.4.1.211.1.31.1.1.1.2.5.1.2',
  parentUnit => '1.3.6.1.4.1.211.1.31.1.1.1.2.5.1.3',
  parentUnitClass => '1.3.6.1.4.1.211.1.31.1.1.1.2.5.1.4',
  parentUnitClassDefinition => 'MMB-COM-MIB::parentUnitClass',
  unitChildTable => '1.3.6.1.4.1.211.1.31.1.1.1.2.6',
  unitChildEntry => '1.3.6.1.4.1.211.1.31.1.1.1.2.6.1',
  unitChilds => '1.3.6.1.4.1.211.1.31.1.1.1.2.6.1',
  cUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.2.6.1.1',
  cChildNr => '1.3.6.1.4.1.211.1.31.1.1.1.2.6.1.2',
  childUnit => '1.3.6.1.4.1.211.1.31.1.1.1.2.6.1.3',
  childUnitClass => '1.3.6.1.4.1.211.1.31.1.1.1.2.6.1.4',
  childUnitClassDefinition => 'MMB-COM-MIB::childUnitClass',
  parentChildTableUpdateCount => '1.3.6.1.4.1.211.1.31.1.1.1.2.7',
  management => '1.3.6.1.4.1.211.1.31.1.1.1.3',
  managementNodeTable => '1.3.6.1.4.1.211.1.31.1.1.1.3.1',
  managementNodeEntry => '1.3.6.1.4.1.211.1.31.1.1.1.3.1.1',
  managementNodes => '1.3.6.1.4.1.211.1.31.1.1.1.3.1.1',
  mnUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.3.1.1.1',
  mnNodeNr => '1.3.6.1.4.1.211.1.31.1.1.1.3.1.1.2',
  unitNodeIfType => '1.3.6.1.4.1.211.1.31.1.1.1.3.1.1.3',
  unitNodeIfTypeDefinition => 'MMB-COM-MIB::unitNodeIfType',
  unitNodeAddress => '1.3.6.1.4.1.211.1.31.1.1.1.3.1.1.4',
  unitNodeIpNetmask => '1.3.6.1.4.1.211.1.31.1.1.1.3.1.1.5',
  unitNodeGateway => '1.3.6.1.4.1.211.1.31.1.1.1.3.1.1.6',
  unitNodeName => '1.3.6.1.4.1.211.1.31.1.1.1.3.1.1.7',
  unitNodeClass => '1.3.6.1.4.1.211.1.31.1.1.1.3.1.1.8',
  unitNodeClassDefinition => 'MMB-COM-MIB::unitNodeClass',
  unitNodeMacAddress => '1.3.6.1.4.1.211.1.31.1.1.1.3.1.1.9',
  unitNodeUseDHCP => '1.3.6.1.4.1.211.1.31.1.1.1.3.1.1.10',
  unitNodeUseDHCPDefinition => 'MMB-COM-MIB::unitNodeUseDHCP',
  unitNodeControllerType => '1.3.6.1.4.1.211.1.31.1.1.1.3.1.1.11',
  unitNodeControllerModel => '1.3.6.1.4.1.211.1.31.1.1.1.3.1.1.12',
  unitNodeControllerFWVersion => '1.3.6.1.4.1.211.1.31.1.1.1.3.1.1.13',
  nodeTableUpdateCount => '1.3.6.1.4.1.211.1.31.1.1.1.3.2',
  managementChannelType => '1.3.6.1.4.1.211.1.31.1.1.1.3.3',
  managementChannelTypeDefinition => 'MMB-COM-MIB::managementChannelType',
  managementProcessorTable => '1.3.6.1.4.1.211.1.31.1.1.1.3.4',
  managementProcessorEntry => '1.3.6.1.4.1.211.1.31.1.1.1.3.4.1',
  managementProcessors => '1.3.6.1.4.1.211.1.31.1.1.1.3.4.1',
  spUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.3.4.1.1',
  spProcessorNr => '1.3.6.1.4.1.211.1.31.1.1.1.3.4.1.2',
  spModelName => '1.3.6.1.4.1.211.1.31.1.1.1.3.4.1.3',
  spFirmwareVersion => '1.3.6.1.4.1.211.1.31.1.1.1.3.4.1.4',
  spBatteryStatus => '1.3.6.1.4.1.211.1.31.1.1.1.3.4.1.5',
  spBatteryStatusDefinition => 'MMB-COM-MIB::spBatteryStatus',
  spBatteryDischargeTime => '1.3.6.1.4.1.211.1.31.1.1.1.3.4.1.6',
  spTimeOnBattery => '1.3.6.1.4.1.211.1.31.1.1.1.3.4.1.7',
  spDoBatteryChargeCycle => '1.3.6.1.4.1.211.1.31.1.1.1.3.4.1.8',
  spBatteryChargeLevel => '1.3.6.1.4.1.211.1.31.1.1.1.3.4.1.9',
  managedUpsNodeTable => '1.3.6.1.4.1.211.1.31.1.1.1.3.5',
  managedUpsNodeEntry => '1.3.6.1.4.1.211.1.31.1.1.1.3.5.1',
  managedUpsNodes => '1.3.6.1.4.1.211.1.31.1.1.1.3.5.1',
  upsUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.3.5.1.1',
  upsNr => '1.3.6.1.4.1.211.1.31.1.1.1.3.5.1.2',
  upsVendorName => '1.3.6.1.4.1.211.1.31.1.1.1.3.5.1.3',
  upsModelName => '1.3.6.1.4.1.211.1.31.1.1.1.3.5.1.4',
  upsIpAddress => '1.3.6.1.4.1.211.1.31.1.1.1.3.5.1.5',
  upsMibRoot => '1.3.6.1.4.1.211.1.31.1.1.1.3.5.1.6',
  upsSnmpCommunity => '1.3.6.1.4.1.211.1.31.1.1.1.3.5.1.7',
  upsHttpPort => '1.3.6.1.4.1.211.1.31.1.1.1.3.5.1.8',
  managementTimeZone => '1.3.6.1.4.1.211.1.31.1.1.1.3.6',
  serverInformation => '1.3.6.1.4.1.211.1.31.1.1.1.4',
  serverTable => '1.3.6.1.4.1.211.1.31.1.1.1.4.1',
  serverEntry => '1.3.6.1.4.1.211.1.31.1.1.1.4.1.1',
  servers => '1.3.6.1.4.1.211.1.31.1.1.1.4.1.1',
  srvUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.4.1.1.1',
  srvPhysicalMemory => '1.3.6.1.4.1.211.1.31.1.1.1.4.1.1.2',
  srvLastBootResult => '1.3.6.1.4.1.211.1.31.1.1.1.4.1.1.3',
  srvLastBootResultDefinition => 'MMB-COM-MIB::srvLastBootResult',
  srvCurrentBootStatus => '1.3.6.1.4.1.211.1.31.1.1.1.4.1.1.4',
  srvCurrentBootStatusDefinition => 'MMB-COM-MIB::srvCurrentBootStatus',
  srvShutdownCommand => '1.3.6.1.4.1.211.1.31.1.1.1.4.1.1.5',
  srvShutdownCommandDefinition => 'MMB-COM-MIB::srvShutdownCommand',
  srvShutdownDelay => '1.3.6.1.4.1.211.1.31.1.1.1.4.1.1.6',
  srvUUID => '1.3.6.1.4.1.211.1.31.1.1.1.4.1.1.7',
  srvPhysicalMemoryOs => '1.3.6.1.4.1.211.1.31.1.1.1.4.1.1.8',
  srvTpmMode => '1.3.6.1.4.1.211.1.31.1.1.1.4.1.1.9',
  srvTpmModeDefinition => 'MMB-COM-MIB::srvTpmMode',
  srvManagementIP => '1.3.6.1.4.1.211.1.31.1.1.1.4.1.1.10',
  unitPowerOnOffTable => '1.3.6.1.4.1.211.1.31.1.1.1.4.2',
  unitPowerOnOffEntry => '1.3.6.1.4.1.211.1.31.1.1.1.4.2.1',
  unitPowerOnOff => '1.3.6.1.4.1.211.1.31.1.1.1.4.2.1',
  ooUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.4.2.1.1',
  powerOnOffStatus => '1.3.6.1.4.1.211.1.31.1.1.1.4.2.1.2',
  powerOnOffStatusDefinition => 'MMB-COM-MIB::powerOnOffStatus',
  lastPowerOffSource => '1.3.6.1.4.1.211.1.31.1.1.1.4.2.1.3',
  lastPowerOffSourceDefinition => 'MMB-COM-MIB::lastPowerOffSource',
  lastPowerOnSource => '1.3.6.1.4.1.211.1.31.1.1.1.4.2.1.4',
  lastPowerOnSourceDefinition => 'MMB-COM-MIB::lastPowerOnSource',
  lastPowerOnTime => '1.3.6.1.4.1.211.1.31.1.1.1.4.2.1.5',
  powerOnCounts => '1.3.6.1.4.1.211.1.31.1.1.1.4.2.1.6',
  powerOnDuration => '1.3.6.1.4.1.211.1.31.1.1.1.4.2.1.7',
  powerOffDuration => '1.3.6.1.4.1.211.1.31.1.1.1.4.2.1.8',
  powerFailRecovery => '1.3.6.1.4.1.211.1.31.1.1.1.4.2.1.9',
  powerFailRecoveryDefinition => 'MMB-COM-MIB::powerFailRecovery',
  powerCommand => '1.3.6.1.4.1.211.1.31.1.1.1.4.2.1.10',
  powerCommandDefinition => 'MMB-COM-MIB::powerCommand',
  powerSupplyRedundancy => '1.3.6.1.4.1.211.1.31.1.1.1.4.2.1.11',
  performanceTable => '1.3.6.1.4.1.211.1.31.1.1.1.4.3',
  performanceEntry => '1.3.6.1.4.1.211.1.31.1.1.1.4.3.1',
  performance => '1.3.6.1.4.1.211.1.31.1.1.1.4.3.1',
  perfUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.4.3.1.1',
  perfNr => '1.3.6.1.4.1.211.1.31.1.1.1.4.3.1.2',
  perfType => '1.3.6.1.4.1.211.1.31.1.1.1.4.3.1.3',
  perfTypeDefinition => 'MMB-COM-MIB::perfType',
  performanceValue => '1.3.6.1.4.1.211.1.31.1.1.1.4.3.1.4',
  performanceName => '1.3.6.1.4.1.211.1.31.1.1.1.4.3.1.5',
  timerOnOffTable => '1.3.6.1.4.1.211.1.31.1.1.1.4.4',
  timerOnOffEntry => '1.3.6.1.4.1.211.1.31.1.1.1.4.4.1',
  timerOnOff => '1.3.6.1.4.1.211.1.31.1.1.1.4.4.1',
  tooUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.4.4.1.1',
  tooDayOfWeek => '1.3.6.1.4.1.211.1.31.1.1.1.4.4.1.2',
  onTime => '1.3.6.1.4.1.211.1.31.1.1.1.4.4.1.3',
  offTime => '1.3.6.1.4.1.211.1.31.1.1.1.4.4.1.4',
  powerMonitoringTable => '1.3.6.1.4.1.211.1.31.1.1.1.4.5',
  powerMonitoringEntry => '1.3.6.1.4.1.211.1.31.1.1.1.4.5.1',
  powerMonitoring => '1.3.6.1.4.1.211.1.31.1.1.1.4.5.1',
  pmUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.4.5.1.1',
  pmCurrentPowerMonitoringAvailable => '1.3.6.1.4.1.211.1.31.1.1.1.4.5.1.2',
  pmCurrentPowerMonitoringAvailableDefinition => 'MMB-COM-MIB::TrueFalse',
  pmCurrentPowerMonitoringEnabled => '1.3.6.1.4.1.211.1.31.1.1.1.4.5.1.3',
  pmCurrentPowerMonitoringEnabledDefinition => 'MMB-COM-MIB::TrueFalse',
  pmNominalPowerConsumption => '1.3.6.1.4.1.211.1.31.1.1.1.4.5.1.4',
  pmCurrentPowerConsumption => '1.3.6.1.4.1.211.1.31.1.1.1.4.5.1.5',
  pmCurrentPowerControl => '1.3.6.1.4.1.211.1.31.1.1.1.4.5.1.6',
  pmCurrentPowerControlDefinition => 'MMB-COM-MIB::pmCurrentPowerControl',
  pmPowerLimitThreshold => '1.3.6.1.4.1.211.1.31.1.1.1.4.5.1.8',
  pmPowerControlMode => '1.3.6.1.4.1.211.1.31.1.1.1.4.5.1.11',
  pmPowerControlModeDefinition => 'MMB-COM-MIB::pmPowerControlMode',
  pmPowerDisplayUnit => '1.3.6.1.4.1.211.1.31.1.1.1.4.5.1.12',
  pmPowerDisplayUnitDefinition => 'MMB-COM-MIB::pmPowerDisplayUnit',
  utilizationHistoryTable => '1.3.6.1.4.1.211.1.31.1.1.1.4.6',
  utilizationHistoryEntry => '1.3.6.1.4.1.211.1.31.1.1.1.4.6.1',
  utilizationHistory => '1.3.6.1.4.1.211.1.31.1.1.1.4.6.1',
  uthUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.4.6.1.1',
  uthEntity => '1.3.6.1.4.1.211.1.31.1.1.1.4.6.1.2',
  uthEntityDefinition => 'MMB-COM-MIB::uthEntity',
  uthTimeStamp => '1.3.6.1.4.1.211.1.31.1.1.1.4.6.1.3',
  uthHardwareUUID => '1.3.6.1.4.1.211.1.31.1.1.1.4.6.1.4',
  uthAverageValue => '1.3.6.1.4.1.211.1.31.1.1.1.4.6.1.5',
  uthMinValue => '1.3.6.1.4.1.211.1.31.1.1.1.4.6.1.6',
  uthMaxValue => '1.3.6.1.4.1.211.1.31.1.1.1.4.6.1.7',
  powerSourceInformationTable => '1.3.6.1.4.1.211.1.31.1.1.1.4.7',
  powerSourceInformationEntry => '1.3.6.1.4.1.211.1.31.1.1.1.4.7.1',
  powerSourceInformation => '1.3.6.1.4.1.211.1.31.1.1.1.4.7.1',
  psiUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.4.7.1.1',
  psiPowerSourceType => '1.3.6.1.4.1.211.1.31.1.1.1.4.7.1.2',
  psiPowerSourcePhase => '1.3.6.1.4.1.211.1.31.1.1.1.4.7.1.3',
  psiPowerSourcePhaseDefinition => 'MMB-COM-MIB::psiPowerSourcePhase',
  psiPowerSourceVoltage => '1.3.6.1.4.1.211.1.31.1.1.1.4.7.1.4',
  environment => '1.3.6.1.4.1.211.1.31.1.1.1.5',
  temperatureSensorTable => '1.3.6.1.4.1.211.1.31.1.1.1.5.1',
  temperatureSensorEntry => '1.3.6.1.4.1.211.1.31.1.1.1.5.1.1',
  temperatureSensors => '1.3.6.1.4.1.211.1.31.1.1.1.5.1.1',
  tempUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.5.1.1.1',
  tempSensorNr => '1.3.6.1.4.1.211.1.31.1.1.1.5.1.1.2',
  tempSensorDesignation => '1.3.6.1.4.1.211.1.31.1.1.1.5.1.1.3',
  tempSensorIdentifier => '1.3.6.1.4.1.211.1.31.1.1.1.5.1.1.4',
  tempSensorStatus => '1.3.6.1.4.1.211.1.31.1.1.1.5.1.1.5',
  tempSensorStatusDefinition => 'MMB-COM-MIB::tempSensorStatus',
  tempCurrentTemperature => '1.3.6.1.4.1.211.1.31.1.1.1.5.1.1.6',
  tempWarningLevel => '1.3.6.1.4.1.211.1.31.1.1.1.5.1.1.7',
  tempCriticalLevel => '1.3.6.1.4.1.211.1.31.1.1.1.5.1.1.8',
  tempCriticalReaction => '1.3.6.1.4.1.211.1.31.1.1.1.5.1.1.9',
  tempCriticalReactionDefinition => 'MMB-COM-MIB::tempCriticalReaction',
  fanTable => '1.3.6.1.4.1.211.1.31.1.1.1.5.2',
  fanEntry => '1.3.6.1.4.1.211.1.31.1.1.1.5.2.1',
  fans => '1.3.6.1.4.1.211.1.31.1.1.1.5.2.1',
  fanUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.5.2.1.1',
  fanNr => '1.3.6.1.4.1.211.1.31.1.1.1.5.2.1.2',
  fanDesignation => '1.3.6.1.4.1.211.1.31.1.1.1.5.2.1.3',
  fanIdentifier => '1.3.6.1.4.1.211.1.31.1.1.1.5.2.1.4',
  fanStatus => '1.3.6.1.4.1.211.1.31.1.1.1.5.2.1.5',
  fanStatusDefinition => 'MMB-COM-MIB::fanStatus',
  fanCurrentSpeed => '1.3.6.1.4.1.211.1.31.1.1.1.5.2.1.6',
  fanQuality => '1.3.6.1.4.1.211.1.31.1.1.1.5.2.1.7',
  fanFailReaction => '1.3.6.1.4.1.211.1.31.1.1.1.5.2.1.8',
  fanFailReactionDefinition => 'MMB-COM-MIB::fanFailReaction',
  fanFailShutdownDelay => '1.3.6.1.4.1.211.1.31.1.1.1.5.2.1.9',
  airflowTable => '1.3.6.1.4.1.211.1.31.1.1.1.5.3',
  airflowEntry => '1.3.6.1.4.1.211.1.31.1.1.1.5.3.1',
  airflow => '1.3.6.1.4.1.211.1.31.1.1.1.5.3.1',
  afUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.5.3.1.1',
  afExhaustAirflowVolume => '1.3.6.1.4.1.211.1.31.1.1.1.5.3.1.2',
  afExhaustAirflowVolumeUnit => '1.3.6.1.4.1.211.1.31.1.1.1.5.3.1.3',
  hardware => '1.3.6.1.4.1.211.1.31.1.1.1.6',
  systemBoardTable => '1.3.6.1.4.1.211.1.31.1.1.1.6.1',
  systemBoardEntry => '1.3.6.1.4.1.211.1.31.1.1.1.6.1.1',
  systemBoard => '1.3.6.1.4.1.211.1.31.1.1.1.6.1.1',
  sbUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.6.1.1.1',
  systemBoardModelName => '1.3.6.1.4.1.211.1.31.1.1.1.6.1.1.2',
  systemBoardProductNumber => '1.3.6.1.4.1.211.1.31.1.1.1.6.1.1.3',
  systemBoardRevision => '1.3.6.1.4.1.211.1.31.1.1.1.6.1.1.4',
  systemBoardSerialNumber => '1.3.6.1.4.1.211.1.31.1.1.1.6.1.1.5',
  powerSupplyTable => '1.3.6.1.4.1.211.1.31.1.1.1.6.2',
  powerSupplyEntry => '1.3.6.1.4.1.211.1.31.1.1.1.6.2.1',
  powerSupply => '1.3.6.1.4.1.211.1.31.1.1.1.6.2.1',
  psUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.6.2.1.1',
  psPowerSupplyNr => '1.3.6.1.4.1.211.1.31.1.1.1.6.2.1.2',
  powerSupplyDesignation => '1.3.6.1.4.1.211.1.31.1.1.1.6.2.1.3',
  powerSupplyIdentifier => '1.3.6.1.4.1.211.1.31.1.1.1.6.2.1.4',
  powerSupplyStatus => '1.3.6.1.4.1.211.1.31.1.1.1.6.2.1.5',
  powerSupplyStatusDefinition => 'MMB-COM-MIB::powerSupplyStatus',
  voltageTable => '1.3.6.1.4.1.211.1.31.1.1.1.6.3',
  voltageEntry => '1.3.6.1.4.1.211.1.31.1.1.1.6.3.1',
  voltages => '1.3.6.1.4.1.211.1.31.1.1.1.6.3.1',
  voUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.6.3.1.1',
  voSensorNr => '1.3.6.1.4.1.211.1.31.1.1.1.6.3.1.2',
  voltageDesignation => '1.3.6.1.4.1.211.1.31.1.1.1.6.3.1.3',
  voltageStatus => '1.3.6.1.4.1.211.1.31.1.1.1.6.3.1.4',
  voltageStatusDefinition => 'MMB-COM-MIB::voltageStatus',
  voltageCurrentValue => '1.3.6.1.4.1.211.1.31.1.1.1.6.3.1.5',
  voltageNominalValue => '1.3.6.1.4.1.211.1.31.1.1.1.6.3.1.6',
  voltageMinimumLevel => '1.3.6.1.4.1.211.1.31.1.1.1.6.3.1.7',
  voltageMaximumLevel => '1.3.6.1.4.1.211.1.31.1.1.1.6.3.1.8',
  voltageCurrentLoad => '1.3.6.1.4.1.211.1.31.1.1.1.6.3.1.9',
  cpuTable => '1.3.6.1.4.1.211.1.31.1.1.1.6.4',
  cpuEntry => '1.3.6.1.4.1.211.1.31.1.1.1.6.4.1',
  cpus => '1.3.6.1.4.1.211.1.31.1.1.1.6.4.1',
  cpuUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.6.4.1.1',
  cpuNr => '1.3.6.1.4.1.211.1.31.1.1.1.6.4.1.2',
  cpuDesignation => '1.3.6.1.4.1.211.1.31.1.1.1.6.4.1.3',
  cpuStatus => '1.3.6.1.4.1.211.1.31.1.1.1.6.4.1.4',
  cpuStatusDefinition => 'MMB-COM-MIB::cpuStatus',
  cpuModelName => '1.3.6.1.4.1.211.1.31.1.1.1.6.4.1.5',
  cpuManufacturer => '1.3.6.1.4.1.211.1.31.1.1.1.6.4.1.6',
  cpuStep => '1.3.6.1.4.1.211.1.31.1.1.1.6.4.1.7',
  cpuCurrentSpeed => '1.3.6.1.4.1.211.1.31.1.1.1.6.4.1.8',
  cpuNumberLogicals => '1.3.6.1.4.1.211.1.31.1.1.1.6.4.1.9',
  cpuCacheL1Size => '1.3.6.1.4.1.211.1.31.1.1.1.6.4.1.10',
  cpuCacheL2Size => '1.3.6.1.4.1.211.1.31.1.1.1.6.4.1.11',
  cpuCacheL3Size => '1.3.6.1.4.1.211.1.31.1.1.1.6.4.1.12',
  cpuNumberCores => '1.3.6.1.4.1.211.1.31.1.1.1.6.4.1.13',
  cpuFamily => '1.3.6.1.4.1.211.1.31.1.1.1.6.4.1.14',
  cpuEnabledCores => '1.3.6.1.4.1.211.1.31.1.1.1.6.4.1.15',
  memoryModuleTable => '1.3.6.1.4.1.211.1.31.1.1.1.6.5',
  memoryModuleEntry => '1.3.6.1.4.1.211.1.31.1.1.1.6.5.1',
  memoryModules => '1.3.6.1.4.1.211.1.31.1.1.1.6.5.1',
  memUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.6.5.1.1',
  memModuleNr => '1.3.6.1.4.1.211.1.31.1.1.1.6.5.1.2',
  memModuleDesignation => '1.3.6.1.4.1.211.1.31.1.1.1.6.5.1.3',
  memModuleStatus => '1.3.6.1.4.1.211.1.31.1.1.1.6.5.1.4',
  memModuleStatusDefinition => 'MMB-COM-MIB::memModuleStatus',
  memModuleBank => '1.3.6.1.4.1.211.1.31.1.1.1.6.5.1.5',
  memModuleCapacity => '1.3.6.1.4.1.211.1.31.1.1.1.6.5.1.6',
  memModuleStartAddress => '1.3.6.1.4.1.211.1.31.1.1.1.6.5.1.7',
  memModuleForm => '1.3.6.1.4.1.211.1.31.1.1.1.6.5.1.8',
  memModuleType => '1.3.6.1.4.1.211.1.31.1.1.1.6.5.1.9',
  memModuleCorrErrors => '1.3.6.1.4.1.211.1.31.1.1.1.6.5.1.10',
  memModuleUncorrErrors => '1.3.6.1.4.1.211.1.31.1.1.1.6.5.1.11',
  memModuleApproved => '1.3.6.1.4.1.211.1.31.1.1.1.6.5.1.12',
  memModuleApprovedDefinition => 'MMB-COM-MIB::memModuleApproved',
  memModuleConfiguration => '1.3.6.1.4.1.211.1.31.1.1.1.6.5.1.13',
  memModuleConfigurationDefinition => 'MMB-COM-MIB::memModuleConfiguration',
  memModuleFrequency => '1.3.6.1.4.1.211.1.31.1.1.1.6.5.1.14',
  memModuleMaxFrequency => '1.3.6.1.4.1.211.1.31.1.1.1.6.5.1.15',
  memModuleVoltInterface => '1.3.6.1.4.1.211.1.31.1.1.1.6.5.1.16',
  cpuMultithreadEnable => '1.3.6.1.4.1.211.1.31.1.1.1.6.6',
  cpuMultithreadEnableDefinition => 'MMB-COM-MIB::cpuMultithreadEnable',
  componentPowerConsumptionTable => '1.3.6.1.4.1.211.1.31.1.1.1.6.7',
  componentPowerConsumptionEntry => '1.3.6.1.4.1.211.1.31.1.1.1.6.7.1',
  componentPowerConsumption => '1.3.6.1.4.1.211.1.31.1.1.1.6.7.1',
  cpcUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.6.7.1.1',
  cpcComponentClass => '1.3.6.1.4.1.211.1.31.1.1.1.6.7.1.2',
  cpcComponentClassDefinition => 'MMB-COM-MIB::cpcComponentClass',
  cpcComponentIndex => '1.3.6.1.4.1.211.1.31.1.1.1.6.7.1.3',
  cpcDesignation => '1.3.6.1.4.1.211.1.31.1.1.1.6.7.1.4',
  cpcCurrentValue => '1.3.6.1.4.1.211.1.31.1.1.1.6.7.1.5',
  trustedPlatformModuleTable => '1.3.6.1.4.1.211.1.31.1.1.1.6.8',
  trustedPlatformModuleEntry => '1.3.6.1.4.1.211.1.31.1.1.1.6.8.1',
  trustedPlatformModule => '1.3.6.1.4.1.211.1.31.1.1.1.6.8.1',
  tpmUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.6.8.1.1',
  tpmHardwareAvailable => '1.3.6.1.4.1.211.1.31.1.1.1.6.8.1.2',
  tpmHardwareAvailableDefinition => 'MMB-COM-MIB::TrueFalseUnknown',
  tpmBiosEnabled => '1.3.6.1.4.1.211.1.31.1.1.1.6.8.1.3',
  tpmBiosEnabledDefinition => 'MMB-COM-MIB::TrueFalseUnknown',
  tpmEnabled => '1.3.6.1.4.1.211.1.31.1.1.1.6.8.1.4',
  tpmEnabledDefinition => 'MMB-COM-MIB::TrueFalseUnknown',
  tpmActivated => '1.3.6.1.4.1.211.1.31.1.1.1.6.8.1.5',
  tpmActivatedDefinition => 'MMB-COM-MIB::TrueFalseUnknown',
  tpmOwnership => '1.3.6.1.4.1.211.1.31.1.1.1.6.8.1.6',
  tpmOwnershipDefinition => 'MMB-COM-MIB::TrueFalseUnknown',
  recovery => '1.3.6.1.4.1.211.1.31.1.1.1.7',
  messageLogTable => '1.3.6.1.4.1.211.1.31.1.1.1.7.1',
  messageLogEntry => '1.3.6.1.4.1.211.1.31.1.1.1.7.1.1',
  messageLogs => '1.3.6.1.4.1.211.1.31.1.1.1.7.1.1',
  msgUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.7.1.1.1',
  msgLogEntryNr => '1.3.6.1.4.1.211.1.31.1.1.1.7.1.1.2',
  msgLogEntryData => '1.3.6.1.4.1.211.1.31.1.1.1.7.1.1.3',
  watchdogTable => '1.3.6.1.4.1.211.1.31.1.1.1.7.2',
  watchdogEntry => '1.3.6.1.4.1.211.1.31.1.1.1.7.2.1',
  watchdogs => '1.3.6.1.4.1.211.1.31.1.1.1.7.2.1',
  wdUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.7.2.1.1',
  watchdogType => '1.3.6.1.4.1.211.1.31.1.1.1.7.2.1.2',
  watchdogTypeDefinition => 'MMB-COM-MIB::watchdogType',
  watchdogStatus => '1.3.6.1.4.1.211.1.31.1.1.1.7.2.1.3',
  watchdogStatusDefinition => 'MMB-COM-MIB::watchdogStatus',
  watchdogEnable => '1.3.6.1.4.1.211.1.31.1.1.1.7.2.1.4',
  watchdogEnableDefinition => 'MMB-COM-MIB::watchdogEnable',
  watchdogTime => '1.3.6.1.4.1.211.1.31.1.1.1.7.2.1.5',
  watchdogAction => '1.3.6.1.4.1.211.1.31.1.1.1.7.2.1.6',
  watchdogActionDefinition => 'MMB-COM-MIB::watchdogAction',
  recoverySettingTable => '1.3.6.1.4.1.211.1.31.1.1.1.7.3',
  recoverySettingEntry => '1.3.6.1.4.1.211.1.31.1.1.1.7.3.1',
  recoverySettings => '1.3.6.1.4.1.211.1.31.1.1.1.7.3.1',
  asrUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.7.3.1.1',
  asrNrRebootRetries => '1.3.6.1.4.1.211.1.31.1.1.1.7.3.1.2',
  asrDefaultRebootRetries => '1.3.6.1.4.1.211.1.31.1.1.1.7.3.1.3',
  asrNextBootSource => '1.3.6.1.4.1.211.1.31.1.1.1.7.3.1.4',
  asrNextBootSourceDefinition => 'MMB-COM-MIB::asrNextBootSource',
  asrRebootFailAction => '1.3.6.1.4.1.211.1.31.1.1.1.7.3.1.5',
  asrRebootFailActionDefinition => 'MMB-COM-MIB::asrRebootFailAction',
  asrRestartDelay => '1.3.6.1.4.1.211.1.31.1.1.1.7.3.1.6',
  asrPostErrorHalt => '1.3.6.1.4.1.211.1.31.1.1.1.7.3.1.7',
  asrPostErrorHaltDefinition => 'MMB-COM-MIB::asrPostErrorHalt',
  messageTextLogTable => '1.3.6.1.4.1.211.1.31.1.1.1.7.4',
  messageTextLogEntry => '1.3.6.1.4.1.211.1.31.1.1.1.7.4.1',
  messageTextLogs => '1.3.6.1.4.1.211.1.31.1.1.1.7.4.1',
  msgTextLogUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.7.4.1.1',
  msgTextLogLanguage => '1.3.6.1.4.1.211.1.31.1.1.1.7.4.1.2',
  msgTextLogSeqNr => '1.3.6.1.4.1.211.1.31.1.1.1.7.4.1.3',
  msgTextLogTimestamp => '1.3.6.1.4.1.211.1.31.1.1.1.7.4.1.4',
  msgTextLogMessage => '1.3.6.1.4.1.211.1.31.1.1.1.7.4.1.5',
  msgTextLogErrorCode => '1.3.6.1.4.1.211.1.31.1.1.1.7.4.1.6',
  msgTextLogSeverity => '1.3.6.1.4.1.211.1.31.1.1.1.7.4.1.7',
  msgTextLogSeverityDefinition => 'MMB-COM-MIB::msgTextLogSeverity',
  msgTextLogCSSComponent => '1.3.6.1.4.1.211.1.31.1.1.1.7.4.1.8',
  msgTextLogCSSComponentDefinition => 'MMB-COM-MIB::TrueFalse',
  messageLogActionHintTable => '1.3.6.1.4.1.211.1.31.1.1.1.7.5',
  messageLogActionHintEntry => '1.3.6.1.4.1.211.1.31.1.1.1.7.5.1',
  messageLogActionHints => '1.3.6.1.4.1.211.1.31.1.1.1.7.5.1',
  mlaLanguage => '1.3.6.1.4.1.211.1.31.1.1.1.7.5.1.1',
  mlaErrorCode => '1.3.6.1.4.1.211.1.31.1.1.1.7.5.1.2',
  mlaType => '1.3.6.1.4.1.211.1.31.1.1.1.7.5.1.3',
  mlaTypeDefinition => 'MMB-COM-MIB::mlaType',
  mlaIndex => '1.3.6.1.4.1.211.1.31.1.1.1.7.5.1.4',
  mlaMessage => '1.3.6.1.4.1.211.1.31.1.1.1.7.5.1.5',
  status => '1.3.6.1.4.1.211.1.31.1.1.1.8',
  agentStatus => '1.3.6.1.4.1.211.1.31.1.1.1.8.1',
  agentStatusDefinition => 'MMB-COM-MIB::agentStatus',
  statusComponentTable => '1.3.6.1.4.1.211.1.31.1.1.1.8.2',
  statusComponentEntry => '1.3.6.1.4.1.211.1.31.1.1.1.8.2.1',
  statusComponents => '1.3.6.1.4.1.211.1.31.1.1.1.8.2.1',
  csUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.8.2.1.1',
  csType => '1.3.6.1.4.1.211.1.31.1.1.1.8.2.1.2',
  csTypeDefinition => 'MMB-COM-MIB::csType',
  componentStatusValue => '1.3.6.1.4.1.211.1.31.1.1.1.8.2.1.3',
  componentStatusValueDefinition => 'MMB-COM-MIB::componentStatusValue',
  componentStatusSensorTable => '1.3.6.1.4.1.211.1.31.1.1.1.8.3',
  componentStatusSensorEntry => '1.3.6.1.4.1.211.1.31.1.1.1.8.3.1',
  componentStatusSensors => '1.3.6.1.4.1.211.1.31.1.1.1.8.3.1',
  cssUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.8.3.1.1',
  cssSensorNumber => '1.3.6.1.4.1.211.1.31.1.1.1.8.3.1.2',
  cssSensorDesignation => '1.3.6.1.4.1.211.1.31.1.1.1.8.3.1.3',
  cssSensorDevice => '1.3.6.1.4.1.211.1.31.1.1.1.8.3.1.4',
  cssSensorDeviceInstance => '1.3.6.1.4.1.211.1.31.1.1.1.8.3.1.5',
  cssSensorPhysicalLed => '1.3.6.1.4.1.211.1.31.1.1.1.8.3.1.6',
  cssSensorPhysicalLedDefinition => 'MMB-COM-MIB::TrueFalse',
  cssSensorCssComponent => '1.3.6.1.4.1.211.1.31.1.1.1.8.3.1.7',
  cssSensorCssComponentDefinition => 'MMB-COM-MIB::TrueFalse',
  cssSensorStatus => '1.3.6.1.4.1.211.1.31.1.1.1.8.3.1.8',
  cssSensorStatusDefinition => 'MMB-COM-MIB::cssSensorStatus',
  cssComponentServicePartId => '1.3.6.1.4.1.211.1.31.1.1.1.8.3.1.9',
  cssTableSize => '1.3.6.1.4.1.211.1.31.1.1.1.8.4',
  maintenance => '1.3.6.1.4.1.211.1.31.1.1.1.9',
  maintenanceObjectTable => '1.3.6.1.4.1.211.1.31.1.1.1.9.1',
  maintenanceObjectEntry => '1.3.6.1.4.1.211.1.31.1.1.1.9.1.1',
  maintenanceObjects => '1.3.6.1.4.1.211.1.31.1.1.1.9.1.1',
  mtUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.9.1.1.1',
  errorCounterStartTime => '1.3.6.1.4.1.211.1.31.1.1.1.9.1.1.2',
  sendTestTrap => '1.3.6.1.4.1.211.1.31.1.1.1.9.1.1.3',
  addTrapDestination => '1.3.6.1.4.1.211.1.31.1.1.1.9.1.1.4',
  mtMaintenanceStatus => '1.3.6.1.4.1.211.1.31.1.1.1.9.1.1.5',
  mtMaintenanceStatusDefinition => 'MMB-COM-MIB::mtMaintenanceStatus',
  firmwareVersionTable => '1.3.6.1.4.1.211.1.31.1.1.1.9.2',
  firmwareVersionEntry => '1.3.6.1.4.1.211.1.31.1.1.1.9.2.1',
  firmwareVersions => '1.3.6.1.4.1.211.1.31.1.1.1.9.2.1',
  fwUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.9.2.1.1',
  fwType => '1.3.6.1.4.1.211.1.31.1.1.1.9.2.1.2',
  fwTypeDefinition => 'MMB-COM-MIB::fwType',
  fwModelName => '1.3.6.1.4.1.211.1.31.1.1.1.9.2.1.3',
  fwVersion => '1.3.6.1.4.1.211.1.31.1.1.1.9.2.1.4',
  fwLocation => '1.3.6.1.4.1.211.1.31.1.1.1.9.2.1.5',
  deployment => '1.3.6.1.4.1.211.1.31.1.1.1.10',
  deployInfoTable => '1.3.6.1.4.1.211.1.31.1.1.1.10.1',
  deployInfoEntry => '1.3.6.1.4.1.211.1.31.1.1.1.10.1.1',
  deployInfo => '1.3.6.1.4.1.211.1.31.1.1.1.10.1.1',
  dplInfoUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.10.1.1.1',
  deployInfoChassisId => '1.3.6.1.4.1.211.1.31.1.1.1.10.1.1.2',
  deployInfoMacAddr1 => '1.3.6.1.4.1.211.1.31.1.1.1.10.1.1.3',
  deployInfoMacAddr2 => '1.3.6.1.4.1.211.1.31.1.1.1.10.1.1.4',
  deployInfoMacAddr3 => '1.3.6.1.4.1.211.1.31.1.1.1.10.1.1.5',
  deployInfoMacAddr4 => '1.3.6.1.4.1.211.1.31.1.1.1.10.1.1.6',
  deployInfoIpAddr1 => '1.3.6.1.4.1.211.1.31.1.1.1.10.1.1.7',
  deployInfoIpAddr2 => '1.3.6.1.4.1.211.1.31.1.1.1.10.1.1.8',
  deployInfoIpAddr3 => '1.3.6.1.4.1.211.1.31.1.1.1.10.1.1.9',
  deployInfoIpAddr4 => '1.3.6.1.4.1.211.1.31.1.1.1.10.1.1.10',
  deployInfoNetMask1 => '1.3.6.1.4.1.211.1.31.1.1.1.10.1.1.11',
  deployInfoNetMask2 => '1.3.6.1.4.1.211.1.31.1.1.1.10.1.1.12',
  deployInfoNetMask3 => '1.3.6.1.4.1.211.1.31.1.1.1.10.1.1.13',
  deployInfoNetMask4 => '1.3.6.1.4.1.211.1.31.1.1.1.10.1.1.14',
  deployInfoGateway1 => '1.3.6.1.4.1.211.1.31.1.1.1.10.1.1.15',
  deployInfoGateway2 => '1.3.6.1.4.1.211.1.31.1.1.1.10.1.1.16',
  deployInfoGateway3 => '1.3.6.1.4.1.211.1.31.1.1.1.10.1.1.17',
  deployInfoGateway4 => '1.3.6.1.4.1.211.1.31.1.1.1.10.1.1.18',
  deployInfoHostname => '1.3.6.1.4.1.211.1.31.1.1.1.10.1.1.19',
  deployInfoMasterImageReference => '1.3.6.1.4.1.211.1.31.1.1.1.10.1.1.20',
  deployInfoStatusOfBlade => '1.3.6.1.4.1.211.1.31.1.1.1.10.1.1.21',
  deployInfoStatusOfBladeDefinition => 'MMB-COM-MIB::deployInfoStatusOfBlade',
  deployInfoLanStatusOfSlot => '1.3.6.1.4.1.211.1.31.1.1.1.10.1.1.22',
  deployInfoLanStatusOfSlotDefinition => 'MMB-COM-MIB::deployInfoLanStatusOfSlot',
  deployInfoAutomaticRecovery => '1.3.6.1.4.1.211.1.31.1.1.1.10.1.1.23',
  deployInfoAutomaticRecoveryDefinition => 'MMB-COM-MIB::deployInfoAutomaticRecovery',
  deployInfoStatusOfCloning => '1.3.6.1.4.1.211.1.31.1.1.1.10.1.1.24',
  deployInfoStatusOfCloningDefinition => 'MMB-COM-MIB::deployInfoStatusOfCloning',
  deployInfoBootMode => '1.3.6.1.4.1.211.1.31.1.1.1.10.1.1.25',
  deployInfoBootModeDefinition => 'MMB-COM-MIB::deployInfoBootMode',
  oemDeployInfoTable => '1.3.6.1.4.1.211.1.31.1.1.1.10.2',
  oemDeployInfoEntry => '1.3.6.1.4.1.211.1.31.1.1.1.10.2.1',
  oemDeployInfo => '1.3.6.1.4.1.211.1.31.1.1.1.10.2.1',
  odplInfoUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.10.2.1.1',
  odplParamId => '1.3.6.1.4.1.211.1.31.1.1.1.10.2.1.2',
  oemDeployInfoParamData => '1.3.6.1.4.1.211.1.31.1.1.1.10.2.1.3',
  deployLanInterfaceTable => '1.3.6.1.4.1.211.1.31.1.1.1.10.3',
  deployLanInterfaceEntry => '1.3.6.1.4.1.211.1.31.1.1.1.10.3.1',
  deployLanInterfaces => '1.3.6.1.4.1.211.1.31.1.1.1.10.3.1',
  dplLanUnitId => '1.3.6.1.4.1.211.1.31.1.1.1.10.3.1.1',
  dplLanInterfaceNr => '1.3.6.1.4.1.211.1.31.1.1.1.10.3.1.2',
  dplLanMacAddress => '1.3.6.1.4.1.211.1.31.1.1.1.10.3.1.3',
  partition => '1.3.6.1.4.1.211.1.31.1.2',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::definitions->{'MMB-COM-MIB'} = {
  tempSensorStatus => {
    '1' => 'unknown',
    '2' => 'not-available',
    '3' => 'ok',
    '5' => 'failed',
    '6' => 'temperature-warning',
    '7' => 'temperature-critical',
  },
  unitNodeIfType => {
    '1' => 'unknown',
    '2' => 'ip',
    '3' => 'ipx',
    '4' => 'ipv6-ip',
    '5' => 'virtual-ip',
    '6' => 'ipv6-virtual-ip',
  },
  watchdogEnable => {
    '1' => 'unknown',
    '2' => 'disable',
    '3' => 'enable',
  },
  asrRebootFailAction => {
    '1' => 'unknown',
    '2' => 'switch-off',
    '3' => 'boot-diag-system',
    '4' => 'no-diag-system',
  },
  fwType => {
    '1' => 'bios',
    '2' => 'management-controller',
    '3' => 'remote-management-controller',
    '4' => 'pal',
    '5' => 'sal',
    '6' => 'efi',
    '7' => 'baseboard-management-controller',
    '8' => 'gswb-offline0',
    '9' => 'gswb-offline1',
    '10' => 'gswb-online0',
    '11' => 'gswb-online1',
    '20' => 'total',
  },
  deployInfoStatusOfCloning => {
    '1' => 'unknown',
    '2' => 'not-cloned',
    '3' => 'cloning',
    '4' => 'cloned',
  },
  srvShutdownCommand => {
    '1' => 'unknown',
    '2' => 'power-off',
    '3' => 'power-on',
    '4' => 'power-cycle',
    '5' => 'shutdown-and-off',
    '6' => 'shutdown-and-reset',
    '7' => 'shutdown-and-power-cycle',
    '8' => 'raise-nmi',
    '9' => 'abort-pending-command',
    '10' => 'reset',
  },
  perfType => {
    '1' => 'cpu',
    '2' => 'cpu-pverall',
    '3' => 'pci-load',
    '4' => 'pci-efficiency',
    '5' => 'pci-transfer',
    '6' => 'memory-physical',
    '7' => 'memory-total',
    '8' => 'memory-percent',
  },
  tempCriticalReaction => {
    '1' => 'unknown',
    '2' => 'continue',
    '3' => 'shutdown-and-poweroff',
  },
  csType => {
    '1' => 'system-boot',
    '2' => 'power',
    '3' => 'temperatures',
    '4' => 'fans',
    '5' => 'power-supplies',
    '6' => 'voltages',
    '7' => 'cpus',
    '8' => 'memory-modules',
    '9' => 'total',
    '10' => 'fan-redundancy',
    '11' => 'power-supply-redundancy',
  },
  unitClass => {
    '1' => 'chassis',
    '2' => 'partition',
    '3' => 'free-pool',
    '4' => 'sb',
    '7' => 'iou',
    '8' => 'iou-divided',
    '9' => 'iou-nodivided',
    '10' => 'pci-box',
    '17' => 'fan-tray',
    '20' => 'op-panel',
    '21' => 'mmb',
    '28' => 'gspb',
    '29' => 'gspb-divided',
    '30' => 'gspb-nodivided',
    '31' => 'sas-unit',
    '32' => 'psu',
    '33' => 'dvdb',
    '34' => 'lpci-box',
    '35' => 'fan',
    '36' => 'du',
  },
  srvCurrentBootStatus => {
    '1' => 'unknown',
    '2' => 'off',
    '3' => 'no-boot-cpu',
    '4' => 'self-test',
    '5' => 'setup',
    '6' => 'os-boot',
    '7' => 'diagnostic-boot',
    '8' => 'os-running',
    '9' => 'diagnostic-running',
    '10' => 'os-shutdown',
    '11' => 'diagnostic-shutdown',
    '12' => 'reset',
    '13' => 'panic',
    '14' => 'check-stop',
    '15' => 'dumping',
    '16' => 'halt',
    '17' => 'extended-partitioning-firmware-running',
  },
  deployInfoLanStatusOfSlot => {
    '1' => 'unknown',
    '2' => 'false',
    '3' => 'true',
  },
  srvTpmMode => {
    '1' => 'disable',
    '2' => 'enable',
  },
  asrPostErrorHalt => {
    '1' => 'unknown',
    '2' => 'halt-on-any-error',
    '3' => 'no-halt-on-any-error',
    '4' => 'other',
  },
  unitNodeUseDHCP => {
    '1' => 'unknown',
    '2' => 'use-fixed-address',
    '3' => 'use-dhcp',
  },
  deployInfoAutomaticRecovery => {
    '1' => 'unknown',
    '2' => 'false',
    '3' => 'true',
  },
  agentWriteAllowed => {
    '1' => 'unknown',
    '2' => 'write-not-allowed',
    '3' => 'write-allowed',
  },
  parentUnitClass => {
    '1' => 'chassis',
    '2' => 'partition',
    '3' => 'free-pool',
    '4' => 'sb',
    '7' => 'iou',
    '8' => 'iou-divided',
    '9' => 'iou-nodivided',
    '10' => 'pci-box',
    '17' => 'fan-tray',
    '20' => 'op-panel',
    '21' => 'mmb',
    '28' => 'gspb',
    '29' => 'gspb-divided',
    '30' => 'gspb-nodivided',
    '31' => 'sas-unit',
    '32' => 'psu',
    '33' => 'dvdb',
    '34' => 'lpci-box',
    '35' => 'fan',
    '36' => 'du',
  },
  unitNodeClass => {
    '1' => 'unknown',
    '2' => 'primery',
    '3' => 'secondary',
    '4' => 'manegement-blade',
    '5' => 'secondary-remote',
    '6' => 'secondary-remote-backup',
    '7' => 'baseboard-controller',
    '8' => 'secondary-manegement-blade',
  },
  cpuStatus => {
    '1' => 'unknown',
    '2' => 'not-present',
    '3' => 'ok',
    '4' => 'disabled',
    '5' => 'error',
    '6' => 'failed',
    '7' => 'missing-termination',
    '8' => 'prefailed-warning',
  },
  watchdogStatus => {
    '1' => 'unknown',
    '2' => 'disable',
    '3' => 'enable',
    '4' => 'not-available',
  },
  pmCurrentPowerControl => {
    '1' => 'unknown',
    '2' => 'disabled',
    '3' => 'best-performance',
    '4' => 'minimum-power',
    '5' => 'automatic',
    '6' => 'scheduled',
    '7' => 'limited',
  },
  psiPowerSourcePhase => {
    '1' => 'unknown',
    '2' => 'single-phase',
    '3' => 'three-phase',
  },
  cpcComponentClass => {
    '3' => 'processor',
    '4' => 'disk',
    '8' => 'memory-unit',
    '9' => 'processor-module',
    '23' => 'chassis',
    '24' => 'sub-chassis',
    '26' => 'disk-bay',
    '29' => 'cooling-device',
    '30' => 'cooling-unit',
    '32' => 'memory-device',
  },
  TrueFalse => {
    '1' => 'false',
    '2' => 'true',
  },
  deployInfoStatusOfBlade => {
    '1' => 'unknown',
    '2' => 'power-down',
    '3' => 'standby',
    '4' => 'system-boot-failure',
    '5' => 'bios-setup',
    '6' => 'booting',
  },
  spBatteryStatus => {
    '1' => 'unknown',
    '2' => 'not-present',
    '3' => 'ok',
    '4' => 'on-battery',
    '5' => 'recharging',
    '6' => 'failed',
    '7' => 'discharging',
  },
  agentShutdownAllowed => {
    '1' => 'unknown',
    '2' => 'shutdown-not-allowed',
    '3' => 'shutdown-allowed',
  },
  uthEntity => {
    '1' => 'powerConsumptionDay',
    '2' => 'powerConsumptionMonth',
    '3' => 'powerConsumptionYear',
  },
  pmPowerDisplayUnit => {
    '1' => 'unknown',
    '2' => 'watt',
    '3' => 'btu',
  },
  memModuleStatus => {
    '1' => 'unknown',
    '2' => 'not-present',
    '3' => 'ok',
    '4' => 'failed-disabled',
    '5' => 'error',
    '7' => 'warning',
    '8' => 'hot-spare',
    '9' => 'configuration-error',
  },
  cssSensorStatus => {
    '1' => 'unknown',
    '2' => 'ok',
    '3' => 'identify',
    '4' => 'prefailure-warning',
    '5' => 'failure',
    '6' => 'not-present',
  },
  memModuleApproved => {
    '1' => 'unknown',
    '2' => 'no',
    '3' => 'yes',
  },
  msgTextLogSeverity => {
    '1' => 'informational',
    '2' => 'minor',
    '3' => 'major',
    '4' => 'critical',
  },
  agentStatus => {
    '1' => 'ok',
    '2' => 'degraded',
    '3' => 'error',
    '4' => 'failed',
    '5' => 'unknown',
  },
  managementChannelType => {
    '1' => 'unknown',
    '2' => 'primery',
    '3' => 'secondary',
  },
  housingOpenStatus => {
    '1' => 'unknown',
    '2' => 'open',
    '3' => 'close',
    '4' => 'opened-and-closed',
  },
  watchdogType => {
    '1' => 'other',
    '2' => 'hardware',
    '3' => 'software',
    '4' => 'bios',
    '5' => 'boot',
    '6' => 'management-controller',
    '7' => 'remote-management-controller',
    '8' => 'management-soft',
  },
  watchdogAction => {
    '1' => 'unknown',
    '2' => 'continue',
    '3' => 'reboot',
    '4' => 'nmi',
    '5' => 'power-cycle',
    '6' => 'power-down',
    '7' => 'hardware-reset',
  },
  srvLastBootResult => {
    '1' => 'unknown',
    '2' => 'os-boot-successful',
    '3' => 'diagnostic-boot-successful',
    '4' => 'no-boot-cpu',
    '5' => 'no-bootable-media',
    '6' => 'os-failed-load',
    '7' => 'diagnostic-boot-failed',
    '8' => 'hardware-failure',
  },
  TrueFalseUnknown => {
    '1' => 'false',
    '2' => 'true',
    '3' => 'unknown',
  },
  powerCommand => {
    '1' => 'unknown',
    '2' => 'off',
    '3' => 'on',
    '4' => 'power-cycle',
  },
  lastPowerOffSource => {
    '1' => 'unknown',
    '2' => 'swoff-command',
    '3' => 'power-button',
    '4' => 'ac-fail',
    '5' => 'clock',
    '6' => 'fan-fail',
    '7' => 'temperature-critical',
    '8' => 'temperature-damage',
    '9' => 'power-supply-failure',
    '10' => 'watchdog',
    '11' => 'remote-off',
    '12' => 'hardware-fail',
    '13' => 'peripheral-bus-error',
    '14' => 'cpu-error',
    '20' => 'nmi',
    '23' => 'hardware-reset',
    '24' => 'warmstart',
    '25' => 'reset-button',
    '26' => 'ac-fail-reboot',
    '29' => 'keyboard',
    '31' => 'remote-manager',
    '32' => 'remote-manager-reset',
    '35' => 'power-limiting',
    '36' => 'mmb-continuous-operation',
    '37' => 'watchdog-power-cycle',
    '242' => 'firmware-restart',
    '243' => 'housing-opened',
  },
  powerOnOffStatus => {
    '1' => 'unknown',
    '2' => 'off',
    '3' => 'on',
  },
  powerFailRecovery => {
    '1' => 'unknown',
    '2' => 'not-available',
    '3' => 'as-before',
    '4' => 'remain-off',
    '5' => 'switch-on',
    '6' => 'schedule-sync',
  },
  deployInfoBootMode => {
    '1' => 'unknown',
    '2' => 'normal',
    '3' => 'pxeBiosSetup',
    '4' => 'pxeLan0',
    '5' => 'pxeLan1',
    '6' => 'pxeLan2',
    '7' => 'pxeLan3',
  },
  mtMaintenanceStatus => {
    '1' => 'off',
    '2' => 'on',
  },
  powerSupplyStatus => {
    '1' => 'unknown',
    '2' => 'not-present',
    '3' => 'ok',
    '4' => 'failed',
    '5' => 'ac-fail',
    '6' => 'dc-fail',
    '7' => 'critical-temperature',
    '8' => 'not-manageable',
    '9' => 'predictive-fail',
  },
  mlaType => {
    '1' => 'summary',
    '2' => 'cause',
    '3' => 'resolution',
  },
  fanStatus => {
    '1' => 'unknown',
    '2' => 'disabled',
    '3' => 'ok',
    '4' => 'failed',
    '5' => 'prefailed-predicted',
    '6' => 'redundant-fan-failed',
    '7' => 'not-manageable',
    '8' => 'not-present',
  },
  fanFailReaction => {
    '1' => 'unknown',
    '2' => 'continue',
    '3' => 'shutdown-and-poweroff',
  },
  childUnitClass => {
    '1' => 'chassis',
    '2' => 'partition',
    '3' => 'free-pool',
    '4' => 'sb',
    '7' => 'iou',
    '8' => 'iou-divided',
    '9' => 'iou-nodivided',
    '10' => 'pci-box',
    '17' => 'fan-tray',
    '20' => 'op-panel',
    '21' => 'mmb',
    '28' => 'gspb',
    '29' => 'gspb-divided',
    '30' => 'gspb-nodivided',
    '31' => 'sas-unit',
    '32' => 'psu',
    '33' => 'dvdb',
    '34' => 'lpci-box',
    '35' => 'fan',
    '36' => 'du',
  },
  memModuleConfiguration => {
    '1' => 'unknown',
    '2' => 'normal',
    '3' => 'disabled',
    '4' => 'hotSpare',
    '5' => 'mirror',
    '6' => 'raid',
    '7' => 'notUsable',
  },
  cpuMultithreadEnable => {
    '1' => 'unknown',
    '2' => 'disabled',
    '3' => 'enabled',
  },
  voltageStatus => {
    '1' => 'unknown',
    '2' => 'not-available',
    '3' => 'ok',
    '4' => 'too-low',
    '5' => 'too-high',
    '6' => 'sensor-failed',
    '7' => 'low-warning',
    '8' => 'high-warning',
  },
  frontDoorStatus => {
    '1' => 'unknown',
    '2' => 'open',
    '3' => 'close',
  },
  pmPowerControlMode => {
    '1' => 'unknown',
    '2' => 'disabled',
    '3' => 'best-performance',
    '4' => 'minimum-power',
    '5' => 'automatic',
    '6' => 'scheduled',
    '7' => 'limited',
    '8' => 'low-noise',
  },
  componentStatusValue => {
    '1' => 'ok',
    '2' => 'degraded',
    '3' => 'error',
    '4' => 'failed',
    '5' => 'unknown',
  },
  asrNextBootSource => {
    '1' => 'unknown',
    '2' => 'operating-system',
    '3' => 'reserved',
    '4' => 'diag-system',
    '5' => 'remote-disk',
  },
  lastPowerOnSource => {
    '1' => 'unknown',
    '2' => 'swoff-command',
    '3' => 'power-button',
    '4' => 'ac-fail',
    '5' => 'clock',
    '6' => 'fan-fail',
    '7' => 'temperature-critical',
    '8' => 'temperature-damage',
    '9' => 'power-supply-failure',
    '10' => 'watchdog',
    '11' => 'remote-on',
    '12' => 'hardware-fail',
    '13' => 'peripheral-bus-error',
    '14' => 'cpu-error',
    '20' => 'nmi',
    '23' => 'hardware-reset',
    '24' => 'warmstart',
    '25' => 'reset-button',
    '26' => 'ac-fail-reboot',
    '27' => 'mgmt-processor-fail',
    '28' => 'pci-pme',
    '29' => 'keyboard',
    '30' => 'chipcard-reader',
    '31' => 'remote-manager',
    '32' => 'remote-manager-reset',
    '33' => 'power-cycle',
    '242' => 'firmware-restart',
    '243' => 'housing-opened',
  },
};
