use v6;
use NativeCall;
use Test;

use Gnome::Gtk3::FileChooser;
use Gnome::Gtk3::FileChooserButton;

#use Gnome::N::X;
#Gnome::N::debug(:on);
use Gnome::N::GlibToRakuTypes;

#-------------------------------------------------------------------------------
my Gnome::Gtk3::FileChooserButton $fcb;
#-------------------------------------------------------------------------------
subtest 'ISA test', {
  $fcb .= new(
    :title('test to select'),
    :action(GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER)
  );
  isa-ok $fcb, Gnome::Gtk3::FileChooserButton, '.new( :title, :action)';
}

#-------------------------------------------------------------------------------
unless %*ENV<raku_test_all>:exists {
  done-testing;
  exit;
}

#-------------------------------------------------------------------------------
subtest 'Manipulations', {
  $fcb.set-title('abc');
  is $fcb.get-title, 'abc', '.set-title() / .get-title()';

  $fcb.set-width-chars(10);
  is $fcb.get-width-chars, 10, '.set-width-chars() / .get-width-chars()';
}

#-------------------------------------------------------------------------------
subtest 'Inherit Gnome::Gtk3::FileChooserButton', {
  class MyClass is Gnome::Gtk3::FileChooserButton {
    method new ( |c ) {
      self.bless( :GtkFileChooserButton, |c);
    }

    submethod BUILD ( *%options ) {

    }
  }

  my MyClass $mgc .= new;
  isa-ok $mgc, Gnome::Gtk3::FileChooserButton, '.new()';
}

#-------------------------------------------------------------------------------
subtest 'Properties ...', {
  my Gnome::Gtk3::FileChooserButton $fcb .= new(:title('test to select'));
  $fcb.set-width-chars(10);

  my @r = $fcb.get-properties( 'title', Str, 'width-chars', Int);
  is-deeply @r, [ 'test to select', 10], "properties: 'title', 'width-chars'";
}

#`{{
#-------------------------------------------------------------------------------
subtest 'Inherit Gnome::Gtk3::FileChooserButton', {
  class MyClass is Gnome::Gtk3::FileChooserButton {
    method new ( |c ) {
      self.bless( :GtkFileChooserButton, |c);
    }

    submethod BUILD ( *%options ) {

    }
  }

  my MyClass $mgc .= new;
  isa-ok $mgc, Gnome::Gtk3::FileChooserButton, '.new()';
}

#-------------------------------------------------------------------------------
subtest 'Interface ...', {
}

#-------------------------------------------------------------------------------
subtest 'Themes ...', {
}

#-------------------------------------------------------------------------------
subtest 'Signals ...', {
  #use Gnome::Glib::Main;
  use Gnome::Gtk3::Main;

  my Gnome::Gtk3::Main $main .= new;

  class SignalHandlers {
    has Bool $!signal-processed = False;

    method ... ( 'any-args', Gnome::Gtk3::FileChooserButton :$widget #`{{ --> ...}} ) {

      isa-ok $widget, Gnome::Gtk3::FileChooserButton;
      $!signal-processed = True;
    }

    method signal-emitter ( Gnome::Gtk3::FileChooserButton :$widget --> Str ) {

      while $main.gtk-events-pending() { $main.iteration-do(False); }

      $widget.emit-by-name(
        'signal',
      #  'any-args',
      #  :return-type(int32),
      #  :parameters([int32,])
      );
      is $!signal-processed, True, '\'...\' signal processed';

      while $main.gtk-events-pending() { $main.iteration-do(False); }

      #$!signal-processed = False;
      #$widget.emit-by-name(
      #  'signal',
      #  'any-args',
      #  :return-type(int32),
      #  :parameters([int32,])
      #);
      #is $!signal-processed, True, '\'...\' signal processed';

      while $main.gtk-events-pending() { $main.iteration-do(False); }
      sleep(0.4);
      $main.gtk-main-quit;

      'done'
    }
  }

  my Gnome::Gtk3::FileChooserButton $fcb .= new;

  #my Gnome::Gtk3::Window $w .= new;
  #$w.add($m);

  my SignalHandlers $sh .= new;
  $fcb.register-signal( $sh, 'method', 'signal');

  my Promise $p = $fcb.start-thread(
    $sh, 'signal-emitter',
    # G_PRIORITY_DEFAULT,       # enable 'use Gnome::Glib::Main'
    # :!new-context,
    # :start-time(now + 1)
  );

  is $main.gtk-main-level, 0, "loop level 0";
  $main.gtk-main;
  #is $main.gtk-main-level, 0, "loop level is 0 again";

  is $p.result, 'done', 'emitter finished';
}
}}

#-------------------------------------------------------------------------------
done-testing;
