#!/bin/bash

#
# Script to start PML-TQ HTTP servers
#

VERSION=0.2
PRINT_USAGE=0
PRINT_HELP=0
PRINT_VERSION=0
start=1
kill=0
restart=0
list=0;
logs=0

pmltq_http_opts=''

while [ $# -gt 0 ]; do
    case "$1" in
	-s|--start) start=1; kill=0; status=0; shift ;;
	-k|--kill|--stop) kill=1; start=0; status=0; shift ;;
	-L|--logs) logs=1; start=0; shift ;;
	-a|--status) start=0; kill=0; status=1; shift ;;
	-r|--restart) kill=1; start=1; shift ;;
	-l|--list) start=0; list=1; shift ;;

	-u|--usage) PRINT_USAGE=1; shift ;;
	-h|--help) PRINT_HELP=1; shift ;;
	-v|--version) PRINT_VERSION=1; shift ;;
	--) shift ; break ;;
	-*) echo "Unrecognized option $1!" ; exit 1 ;;
	*) break ;;
    esac
done

function usage () {
    cat <<USAGE
    run.sh -s|--start [<names>]
    run.sh -k|--kill|--stop [<names>]
    run.sh -r|--restart [<names>]
    run.sh -l|--list
    run.sh -h|--help|-u|--usage|-v|--version
USAGE
}

function help () {
    echo "run.sh version $VERSION"
    cat <<'HELP'

  USAGE:

HELP
    usage
    cat <<'HELP'

  DESCRIPTION:

    Start or stop PML-TQ HTTP servers or query their status.

  OPTIONS:
      -l|--list  - list available servers

      -s|--start - start listed (or all) servers
      -k|--kill|--stop - stop listed (or all) servers
      -a|--status - get status info about listed (or all) servers

      -h|--help    - print this help and exit
      -u|--usage   - print a short usage and exit
      -v|--version - print version and exit

  CONFIGURATION:

      The servers configuration script 'run.conf' must exists
      in the same directtory as 'run.sh'. The script must set
      the following variables:

        # PML-TQ HTTP authorization file (optional):
        auth_file="${pmltq_dir}/config/.authorization"

        # list of configured servers:
        all=(pdt pedt)

        # for each defined treebank specify the port and number of http servers to fork:
        pdt=8082,5        # PDT 2.0
        pedt=8083,2       # PEDT
        # .. etc

  AUTHOR:
      Copyright by pajas@ufal.mff.cuni.cz
HELP
}

if [ $PRINT_VERSION = 1 ]; then echo Version: $VERSION; exit; fi
if [ $PRINT_HELP = 1 ]; then help; exit; fi
if [ $PRINT_USAGE = 1 ]; then usage; exit; fi


function fail { echo "$@" >&2; exit 1; }

function log_rotate {
    log="$1"
    if [ -f "${log}" ]; then
	lnum=$(ls "${log}."* |wc -l)
	mv "${log}" "${log}.${lnum}"
    fi
}

function grep_kill {
    regexp="$1"
    shift;
    while ps aux | grep -q "$regexp"; do
	ps aux | grep "$regexp" \
	    | sed 's/  */ /g' | cut -f2 -d' ' | sort -n | xargs -r -n1 kill "$@"
    done
}

rundir=$(dirname $(readlink -f "$0"))
pmltq_dir=$(readlink -f "$rundir/..")
config_file="${pmltq_dir}/config/pmltq_cgi.conf"
query_log_dir="$rundir/query_logs"
log_dir="$rundir/logs"
tmp_dir="$rundir/tmp"
pid_dir=running

cd "$rundir" || fail "Cannot change directory to $rundir: $!"

. "${rundir}/run.conf"

[ -d "$log_dir" ] || mkdir "$log_dir"
[ -d "$query_log_dir" ] || mkdir "$query_log_dir"
[ -d "$tmp_dir" ] || mkdir "$tmp_dir"

if [[ "$list" == 1 ]]; then
    echo "${all[@]}"
    exit 0;
fi

if [ -n "$1" ]; then
    run=("$@")
else
    run=("print" "${all[@]}")
fi

if [[ "$logs" == 1 ]]; then
    logs=()
    for s in "${run[@]}"; do
	logs=("${logs[@]}" "$log_dir/$s.log")
    done
    less "${logs[@]}"
fi

for id in "${run[@]}"; do
    if [ "$id" = "print" ]; then
	id='print'
	if [[ "$kill" == 1 ]]; then
            echo "Stopping print service" >&2
	    grep_kill "[p]rint_srvr_simple.btred" -9
            echo "Executing $on_print_service_stop" >&2
	    if [[ -n $on_print_service_stop ]]; then
              eval "$on_print_service_stop"
            fi
	fi
	if [[ "$start" == 1 ]]; then
            echo "Starting print service" >&2
	    log_rotate "${log_dir}/print.log"
	    data_paths=$(
                for id in "${all[@]}" ; do # loop needed: xmllint shell does not support long commands
                    echo 'cat /*/*/*["'"$id"'"=@id]'\
                     '/*[local-name()="sources"]/descendant-or-self::*[@schema]/text()'
                done | xmllint --shell "$config_file" \
                    | grep -Ev '(/ >.*)|(^ *?(--*)?$)' \
		    | cut -f2 -d= | sort -u | perl -e 'print join(":",do { chomp(@f = <STDIN> ); @f })'
                )
	    [ -d "${rundir}/svg_cache" ] || mkdir "${rundir}/svg_cache"
	    nohup $print_service -o --allow-paths "$tmp_dir:$data_paths" --cache-dir "${rundir}/svg_cache" -- > "${log_dir}/print.log" 2>&1 &
	fi
	if [[ "$status" == 1 ]]; then
	    echo -n "print-service: running instances:"
	    ps aux | grep "[p]rint_srvr_simple.btred" | wc -l
	fi
    else
	port_num="${!id}"
	if [ -n "${port_num}" ]; then
	    port=${port_num%,*}
	    num=3
	    if [[ "$port" != "$port_num" ]]; then
		num=${port_num#*,}
	    fi
	    no_auth="no_auth_$id"
	    if [ "${!no_auth}" == 1 ]; then
		auth_file=
	    fi
	    if [[ "$kill" == 1 ]]; then
		echo "Stopping $id on port $port" >&2
		grep_kill "[p]mltq_http -D --port ${port}" -9
		if [[ "$start" == 1 ]]; then
		    sleep 2;
		fi
		[ -d "$pid_dir" ] && rm -f "$pid_dir/pmltq_cgi_"*".$id"
	    fi
	    if [[ "$start" == 1 ]]; then
		[ -d "$pid_dir" ] && rm -f "$pid_dir/pmltq_cgi_"*".$id"
		echo "Starting $num instances of $id on port $port" >&2
		qlog_dir="$query_log_dir/${id}.queries"
		[ -d "$qlog_dir" ] || mkdir -p "$qlog_dir" || fail "Cannot create query log directory $qlog_dir: $!"

		log_rotate "${log_dir}/${id}.log"

		auth=()
		if [ -n "$auth_file" ]; then
		    auth=(-a "$auth_file")
		fi
		[ -d $pid_dir ] || mkdir $pid_dir
		"${pmltq_dir}"/pmltq_http -D --port "${port}" --forking "$num" -c "$config_file" --tmp-dir "$tmp_dir" -d "$qlog_dir" --pid-dir $pid_dir "${auth[@]}" -s "$id" $pmltq_http_opts > "${log_dir}/${id}.log"  2>&1  &
	    fi
	    if [[ "$status" == 1 ]]; then
		echo -n "${id}: running instances:"
		ps aux | grep "[p]mltq_http -D --port ${port}" |wc -l
	    fi
	else
	    echo "Warning: treebank $id not defined (skipping)!" >&2
	fi
    fi
done
