#!/usr/bin/perl

use strict;
use warnings;
$|=1; # force flush

use FindBin;
use File::Spec;
use lib (glob(File::Spec->catfile(${FindBin::RealBin},'..','..','libs','*','')));
use Treex::PML;
use Treex::PML::Schema;
use Benchmark;
use Data::Dumper;
use Tree_Query::Common;

use Getopt::Long;
Getopt::Long::Configure ("bundling");
my %opts;
GetOptions(\%opts,
   'trace|T',
   'user-defined-relations|U=s',
   'pmlrf-relations|R=s',
);

if ($opts{trace}) {
  $::RD_TRACE=1;
}
sub _mk_regexp {
  my $names = shift;
  return '\b(?:'.join('|',map quotemeta, sort { $b cmp $a } @$names).')\b';
}
if ($opts{'pmlrf-relations'}) {
  $Tree_Query::pmlrf_relations = _mk_regexp([split /,/,$opts{'pmlrf-relations'}]);
}
if ($opts{'user-defined-relations'}) {
  $Tree_Query::user_defined = _mk_regexp([split /,/,$opts{'user_defined_relations'}]);
} else {
  $Tree_Query::user_defined = '\b(?:echild|eparent|a/lex.rf\|a/aux.rf|a/lex.rf|a/aux.rf|coref_gram.rf|coref_text.rf|coref_text|coref_gram|compl)\b'; 
}

my $string=$ARGV[0];
if (!@ARGV or $string eq '-') {
  local $/;
  $string=<STDIN>;
}
shift;

my $t0 = new Benchmark;
my $parser = Tree_Query::Common->query_parser or die "Cannot create parser\n";
my $t1 = new Benchmark;
my $time = timestr(timediff($t1,$t0));
print "Creating parser took: $time\n";

$t0 = new Benchmark;
my $result = $parser->parse_query($string);
$t1 = new Benchmark;
$time = timestr(timediff($t1,$t0));
print "Parsing took: $time\n";

print Dumper($result);

__END__

=head1 NAME

grammar.pl

=head1 SYNOPSIS



=head1 DESCRIPTION

Stub documentation for grammar.pl, 
created by template.el.

It looks like the author of this script was negligent 
enough to leave the stub unedited.

=head1 AUTHOR

Petr Pajas, E<lt>pajas@stain.ms.mff.cuni.czE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008 by Petr Pajas

This program is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.2 or,
at your option, any later version of Perl 5 you may have available.

=head1 BUGS

None reported... yet.

=cut