package Hyperscan::Database;
$Hyperscan::Database::VERSION = '0.03';
# ABSTRACT: database class

use strict;
use warnings;

use Hyperscan;

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Hyperscan::Database - database class

=head1 VERSION

version 0.03

=head2 CONSTRUCTORS

=head3 compile( $expression, $flags, $mode )

The basic regular expression compiler.

L<hs_compile|https://intel.github.io/hyperscan/dev-reference/api_files.html#c.hs_compile>

=head3 compile_ext_multi( $expressions, $flags, $ids, $ext, $mode )

The multiple regular expression compiler with extended parameter support.

L<hs_compile_ext_multi|https://intel.github.io/hyperscan/dev-reference/api_files.html#c.hs_compile_ext_multi>

=head3 compile_lit( $expression, $flags, $mode )

The basic pure literal expression compiler.

L<hs_compile_lit|https://intel.github.io/hyperscan/dev-reference/api_files.html#c.hs_compile_lit>

=head3 compile_lit_multi( $expressions, $flags, $ids, $mode )

L<hs_compile_lit_multi|https://intel.github.io/hyperscan/dev-reference/api_files.html#c.hs_compile_lit_multi>

=head3 compile_multi( $expressions, $flags, $ids, $mode )

The multiple regular expression compiler.

L<hs_compile_multi|https://intel.github.io/hyperscan/dev-reference/api_files.html#c.hs_compile_multi>

=head3 deserialize( $bytes )

Reconstruct a pattern database from a stream of bytes previously generated by
L</serialize()>.

L<hs_deserialize_database|https://intel.github.io/hyperscan/dev-reference/api_files.html#c.hs_deserialize_database>

=head2 METHODS

=head3 alloc_scratch()

Allocate a "scratch" space for use by Hyperscan. Returns a
L<Hyperscan::Scratch>.

L<hs_alloc_scratch|https://intel.github.io/hyperscan/dev-reference/api_files.html#c.hs_alloc_scratch>

=head3 info()

Utility function providing information about a database.

L<hs_database_info|https://intel.github.io/hyperscan/dev-reference/api_files.html#c.hs_database_info>

=head3 open_stream()

Open and initialise a stream. Returns a L<Hyperscan::Stream>.

L<hs_open_stream|https://intel.github.io/hyperscan/dev-reference/api_files.html#c.hs_open_stream>

=head3 scan( $data, $flags, $scratch, $callback )

The block (non-streaming) regular expression scanner.

L<hs_scan|https://intel.github.io/hyperscan/dev-reference/api_files.html#c.hs_scan>

=head3 scan_vector( $data, $flags, $scratch, $callback )

The vectored regular expression scanner.

L<hs_scan_vector|https://intel.github.io/hyperscan/dev-reference/api_files.html#c.hs_scan_vector>

=head3 serialize()

Serialize a pattern database to a stream of bytes.

L<hs_serialize_database|https://intel.github.io/hyperscan/dev-reference/api_files.html#c.hs_serialize_database>

=head3 size()

Provides the size of the given database in bytes.

L<hs_database_size|https://intel.github.io/hyperscan/dev-reference/api_files.html#c.hs_database_size>

=head3 stream_size()

Provides the size of the stream state allocated by a single stream opened
against the given database.

L<hs_stream_size|https://intel.github.io/hyperscan/dev-reference/api_files.html#c.hs_stream_size>

=head1 AUTHOR

Mark Sikora <marknsikora@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by Mark Sikora.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
