#!perl -T

use warnings;
use strict;

use Test::More tests => 2;
use Test::Exception;

use Test::MockFile::Light module => 'main';

my $file_name = 'data.txt';
my $content = "1\n";
my $fh;

{
	open $fh, '>>', $file_name;

	print $fh 'q';

	close $fh;

	local $/;

	open $fh, '<', $file_name;

	is(<$fh>, 'q', 'checking that >> creates file');

	close $fh;

	undefine_file_mocker($file_name);
}

{
	define_file_mocker($file_name, $content);

	open $fh, '>>', $file_name;

	print $fh 'q';

	close $fh;

	local $/;

	open $fh, '<', $file_name;

	is(<$fh>, "1\nq", 'checking that >> appends to existing file');

	close $fh;

	undefine_file_mocker($file_name);
}
