#!perl -T

use warnings;
use strict;

use Test::More tests => 6;
use Test::Exception;

use Test::MockFile::Light module => 'main';

my $file_name = 'data.txt';
my $content = "1\n";
my $fh;

can_ok('main', 'get_file_mocker_content');

throws_ok {
	get_file_mocker_content();
} qr/The first parameter should be the name of the file mocker/
, 'attempting to call get_file_mocker_content() with invalid parameter';

throws_ok {
	get_file_mocker_content($file_name);
} qr/No such file or directory/
, 'attempting to get the content of a nonexisting file';

define_file_mocker($file_name, $content);

my $read_content;

lives_ok {
	$read_content = get_file_mocker_content($file_name);
} 'reading the content of a file';

is ($read_content, $content, 'checking the content (1/2)');

open $fh, '>>', $file_name;
print $fh "2\n";
close $fh;

$read_content = get_file_mocker_content($file_name);

is ($read_content, "1\n2\n", 'checking the content (2/2)');
