/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.evpull.ComplexContentProcessor;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.EventIteratorToReceiver;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.lib.SaxonOutputKeys;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.SequenceWrapper;
import net.sf.saxon.query.UpdateAgent;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.value.Value;

public class XQueryExpression
implements Container {
    private Expression expression;
    private SlotManager stackFrameMap;
    private Executable executable;
    private QueryModule staticContext;
    private PathMap pathMap;
    private boolean allowDocumentProjection;
    private boolean isUpdating;

    protected XQueryExpression(Expression exp, Executable exec, QueryModule mainModule, Configuration config) throws XPathException {
        this.stackFrameMap = config.makeSlotManager();
        this.executable = exec;
        exp.setContainer(this);
        Optimizer optimizer = config.obtainOptimizer();
        try {
            ExpressionVisitor visitor = ExpressionVisitor.make(mainModule, exec);
            visitor.setExecutable(exec);
            exp = visitor.simplify(exp);
            exp.checkForUpdatingSubexpressions();
            ExpressionVisitor.ContextItemType cit = new ExpressionVisitor.ContextItemType(mainModule.getUserQueryContext().getRequiredContextItemType(), true);
            exp = visitor.typeCheck(exp, cit);
            if (optimizer.getOptimizationLevel() != 0) {
                exp = exp.optimize(visitor, cit);
            }
        }
        catch (XPathException err) {
            mainModule.reportFatalError(err);
            throw err;
        }
        ExpressionTool.allocateSlots(exp, 0, this.stackFrameMap);
        if (((Boolean)config.getConfigurationProperty("http://saxon.sf.net/feature/generateByteCode")).booleanValue() && config.isLicensedFeature(4)) {
            Expression cexp;
            if (config.isTiming()) {
                config.getStandardErrorOutput().println("Generating byte code...");
            }
            if ((cexp = optimizer.compileToByteCode(exp, "main", 6)) != null) {
                exp = cexp;
            }
        }
        this.expression = exp;
        this.executable.setConfiguration(config);
        this.executable.setCollationMap(mainModule.getUserQueryContext().getAllCollations());
        this.staticContext = mainModule;
        this.isUpdating = exp.isUpdatingExpression();
    }

    public Expression getExpression() {
        return this.expression;
    }

    public int getContainerGranularity() {
        return 2;
    }

    public boolean usesContextItem() {
        if (ExpressionTool.dependsOnFocus(this.expression)) {
            return true;
        }
        HashMap<StructuredQName, GlobalVariable> map = this.executable.getCompiledGlobalVariables();
        if (map != null) {
            for (GlobalVariable var : map.values()) {
                Expression select = var.getSelectExpression();
                if (select == null || !ExpressionTool.dependsOnFocus(select)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isUpdateQuery() {
        return this.isUpdating;
    }

    public SlotManager getStackFrameMap() {
        return this.stackFrameMap;
    }

    public QueryModule getStaticContext() {
        return this.staticContext;
    }

    public StructuredQName[] getExternalVariableNames() {
        List<StructuredQName> list = this.stackFrameMap.getVariableMap();
        StructuredQName[] names = new StructuredQName[this.stackFrameMap.getNumberOfVariables()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = list.get(i);
        }
        return names;
    }

    public List evaluate(DynamicQueryContext env) throws XPathException {
        if (this.isUpdating) {
            throw new XPathException("Cannot call evaluate() on an updating query");
        }
        SequenceIterator iterator = this.iterator(env);
        ArrayList<Object> list = new ArrayList<Object>(100);
        Object item;
        while ((item = iterator.next()) != null) {
            list.add(Value.convertToJava(item));
        }
        return list;
    }

    public Object evaluateSingle(DynamicQueryContext env) throws XPathException {
        if (this.isUpdating) {
            throw new XPathException("Cannot call evaluateSingle() on an updating query");
        }
        SequenceIterator iterator = this.iterator(env);
        Object item = iterator.next();
        if (item == null) {
            return null;
        }
        return Value.convertToJava(item);
    }

    public SequenceIterator iterator(DynamicQueryContext env) throws XPathException {
        if (this.isUpdating) {
            throw new XPathException("Cannot call iterator() on an updating query");
        }
        if (!env.getConfiguration().isCompatible(this.getExecutable().getConfiguration())) {
            throw new XPathException("The query must be compiled and executed under the same Configuration");
        }
        Controller controller = this.newController();
        env.initializeController(controller);
        try {
            Item contextItem = env.getContextItem();
            if (contextItem instanceof DocumentInfo && ((DocumentInfo)contextItem).isTyped() && !this.getExecutable().isSchemaAware()) {
                throw new XPathException("A typed input document can only be used with a schema-aware query");
            }
            controller.defineGlobalParameters();
            XPathContextMajor context = controller.newXPathContext();
            if (contextItem != null) {
                if (!this.staticContext.getUserQueryContext().getRequiredContextItemType().matchesItem(contextItem, false, env.getConfiguration())) {
                    throw new XPathException("The supplied context item does not match the required context item type");
                }
                UnfailingIterator<Item> single = SingletonIterator.makeIterator(contextItem);
                single.next();
                context.setCurrentIterator(single);
                controller.setInitialContextItem(contextItem);
            }
            if (controller.getTraceListener() != null) {
                controller.preEvaluateGlobals(context);
            }
            context.openStackFrame(this.stackFrameMap);
            SequenceIterator<? extends Item> iterator = this.expression.iterate(context);
            return new ErrorReportingIterator(iterator, controller.getErrorListener());
        }
        catch (XPathException err) {
            TransformerException terr = err;
            while (terr.getException() instanceof TransformerException) {
                terr = (TransformerException)terr.getException();
            }
            XPathException de = XPathException.makeXPathException(terr);
            controller.reportFatalError(de);
            throw de;
        }
    }

    public void run(DynamicQueryContext env, Result result, Properties outputProperties) throws XPathException {
        OutputStream os;
        if (this.isUpdating) {
            throw new XPathException("Cannot call run() on an updating query");
        }
        if (!env.getConfiguration().isCompatible(this.getExecutable().getConfiguration())) {
            throw new XPathException("The query must be compiled and executed under the same Configuration");
        }
        Item contextItem = env.getContextItem();
        if (contextItem instanceof DocumentInfo && ((DocumentInfo)contextItem).isTyped() && !this.getExecutable().isSchemaAware()) {
            throw new XPathException("A typed input document can only be used with a schema-aware query");
        }
        Controller controller = this.newController();
        env.initializeController(controller);
        if (this.allowDocumentProjection) {
            controller.setUseDocumentProjection(this.getPathMap());
        }
        Properties actualProperties = this.validateOutputProperties(controller, outputProperties);
        XPathContextMajor context = this.initialContext(env, controller);
        TraceListener tracer = controller.getTraceListener();
        if (tracer != null) {
            controller.preEvaluateGlobals(context);
            tracer.open(controller);
        }
        context.openStackFrame(this.stackFrameMap);
        boolean mustClose = result instanceof StreamResult && ((StreamResult)result).getOutputStream() == null;
        SerializerFactory sf = context.getConfiguration().getSerializerFactory();
        PipelineConfiguration pipe = controller.makePipelineConfiguration();
        pipe.setHostLanguage(51);
        Receiver receiver = sf.getReceiver(result, pipe, actualProperties);
        context.changeOutputDestination(receiver, 3, null);
        context.getReceiver().open();
        try {
            this.expression.process(context);
        }
        catch (XPathException err) {
            controller.reportFatalError(err);
            throw err;
        }
        if (tracer != null) {
            tracer.close();
        }
        context.getReceiver().close();
        if (mustClose && (os = ((StreamResult)result).getOutputStream()) != null) {
            try {
                os.close();
            }
            catch (IOException err) {
                throw new XPathException(err);
            }
        }
    }

    private Properties validateOutputProperties(Controller controller, Properties outputProperties) throws XPathException {
        Properties baseProperties = controller.getOutputProperties();
        if (outputProperties != null) {
            Enumeration<?> iter = outputProperties.propertyNames();
            while (iter.hasMoreElements()) {
                String key = (String)iter.nextElement();
                String value = outputProperties.getProperty(key);
                try {
                    SaxonOutputKeys.checkOutputProperty(key, value, controller.getConfiguration());
                    baseProperties.setProperty(key, value);
                }
                catch (XPathException dynamicError) {
                    try {
                        outputProperties.remove(key);
                        controller.getErrorListener().warning(dynamicError);
                    }
                    catch (TransformerException err2) {
                        throw XPathException.makeXPathException(err2);
                    }
                }
            }
        }
        if (baseProperties.getProperty("method") == null) {
            baseProperties.setProperty("method", "xml");
        }
        return baseProperties;
    }

    public void pull(DynamicQueryContext dynamicEnv, Result destination, Properties outputProperties) throws XPathException {
        if (this.isUpdating) {
            throw new XPathException("Cannot call pull() on an updating query");
        }
        Configuration config = dynamicEnv.getConfiguration();
        try {
            Controller controller = this.newController();
            EventIterator iter = this.iterateEvents(controller, dynamicEnv);
            Properties actualProperties = this.validateOutputProperties(controller, outputProperties);
            SerializerFactory sf = config.getSerializerFactory();
            PipelineConfiguration pipe = config.makePipelineConfiguration();
            pipe.setSerializing(true);
            Receiver receiver = sf.getReceiver(destination, pipe, actualProperties);
            receiver = new NamespaceReducer(receiver);
            receiver = "yes".equals(actualProperties.getProperty("{http://saxon.sf.net/}wrap-result-sequence")) ? new SequenceWrapper(receiver) : new TreeReceiver(receiver);
            EventIteratorToReceiver.copy(iter, (SequenceReceiver)receiver);
        }
        catch (XPathException err) {
            config.reportFatalError(err);
            throw err;
        }
    }

    public EventIterator iterateEvents(Controller controller, DynamicQueryContext dynamicEnv) throws XPathException {
        if (this.isUpdating) {
            throw new XPathException("Cannot call iterateEvents() on an updating query");
        }
        dynamicEnv.initializeController(controller);
        XPathContextMajor context = this.initialContext(dynamicEnv, controller);
        if (controller.getTraceListener() != null) {
            controller.preEvaluateGlobals(context);
        }
        context.openStackFrame(this.stackFrameMap);
        Configuration config = this.executable.getConfiguration();
        EventIterator ei = this.expression.iterateEvents(context);
        return new ComplexContentProcessor(config, ei);
    }

    public Set runUpdate(DynamicQueryContext dynamicEnv) throws XPathException {
        if (!this.isUpdating) {
            throw new XPathException("Calling runUpdate() on a non-updating query");
        }
        Configuration config = this.executable.getConfiguration();
        Controller controller = this.newController();
        dynamicEnv.initializeController(controller);
        XPathContextMajor context = this.initialContext(dynamicEnv, controller);
        try {
            PendingUpdateList pul = config.newPendingUpdateList();
            context.openStackFrame(this.stackFrameMap);
            this.expression.evaluatePendingUpdates(context, pul);
            pul.apply(context, this.staticContext.getRevalidationMode());
            return pul.getAffectedTrees();
        }
        catch (XPathException e) {
            if (!e.hasBeenReported()) {
                try {
                    controller.getErrorListener().fatalError(e);
                }
                catch (TransformerException e2) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public void runUpdate(DynamicQueryContext dynamicEnv, UpdateAgent agent) throws XPathException {
        if (!this.isUpdating) {
            throw new XPathException("Calling runUpdate() on a non-updating query");
        }
        Configuration config = this.executable.getConfiguration();
        Controller controller = this.newController();
        dynamicEnv.initializeController(controller);
        XPathContextMajor context = this.initialContext(dynamicEnv, controller);
        try {
            PendingUpdateList pul = config.newPendingUpdateList();
            context.openStackFrame(this.stackFrameMap);
            this.expression.evaluatePendingUpdates(context, pul);
            pul.apply(context, this.staticContext.getRevalidationMode());
            for (NodeInfo node : pul.getAffectedTrees()) {
                agent.update(node, controller);
            }
        }
        catch (XPathException e) {
            if (!e.hasBeenReported()) {
                try {
                    controller.getErrorListener().fatalError(e);
                }
                catch (TransformerException e2) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    private XPathContextMajor initialContext(DynamicQueryContext dynamicEnv, Controller controller) throws XPathException {
        Item contextItem = dynamicEnv.getContextItem();
        XPathContextMajor context = controller.newXPathContext();
        if (contextItem != null) {
            if (!this.staticContext.getUserQueryContext().getRequiredContextItemType().matchesItem(contextItem, false, dynamicEnv.getConfiguration())) {
                throw new XPathException("The supplied context item does not match the required context item type");
            }
            StructuredQName varQName = this.executable.getInitialContextItemVariableName();
            if (varQName != null) {
                GlobalVariable var = this.executable.getGlobalVariable(varQName);
                if (var == null) {
                    throw new IllegalStateException("Context item variable not found in executable");
                }
                controller.setParameter(varQName, contextItem);
                try {
                    controller.getBindery().useGlobalParameter(varQName, var.getSlotNumber(), var.getRequiredType(), context);
                }
                catch (XPathException err) {
                    err.maybeSetLocation(var);
                    if (!err.hasBeenReported()) {
                        try {
                            controller.getErrorListener().fatalError(err);
                        }
                        catch (TransformerException e) {
                            // empty catch block
                        }
                    }
                    throw err;
                }
            }
            UnfailingIterator<Item> single = SingletonIterator.makeIterator(contextItem);
            single.next();
            context.setCurrentIterator(single);
            controller.setInitialContextItem(contextItem);
        } else {
            StructuredQName varQName = this.executable.getInitialContextItemVariableName();
            if (varQName != null) {
                GlobalVariable var = this.executable.getGlobalVariable(varQName);
                if (var == null) {
                    throw new IllegalStateException("Context item variable not found in executable");
                }
                try {
                    controller.getBindery().useGlobalParameter(varQName, var.getSlotNumber(), var.getRequiredType(), context);
                }
                catch (XPathException err) {
                    err.maybeSetLocation(var);
                    if (!err.hasBeenReported()) {
                        try {
                            controller.getErrorListener().fatalError(err);
                        }
                        catch (TransformerException e) {
                            // empty catch block
                        }
                    }
                    throw err;
                }
                ValueRepresentation val = var.getSelectValue(context);
                contextItem = Value.asItem(val);
                UnfailingIterator<Item> single = SingletonIterator.makeIterator(contextItem);
                single.next();
                context.setCurrentIterator(single);
                controller.setInitialContextItem(contextItem);
            }
        }
        controller.defineGlobalParameters();
        return context;
    }

    public Controller newController() {
        Controller controller = new Controller(this.executable.getConfiguration(), this.executable);
        this.executable.initializeBindery(controller.getBindery());
        if (this.isUpdating && controller.getModel() == TreeModel.TINY_TREE) {
            controller.setModel(TreeModel.LINKED_TREE);
        }
        return controller;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("query");
        this.getExecutable().getKeyManager().explainKeys(out);
        this.getExecutable().explainGlobalVariables(out);
        this.staticContext.explainGlobalFunctions(out);
        out.startElement("body");
        this.expression.explain(out);
        out.endElement();
        out.endElement();
        out.close();
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public PathMap getPathMap() {
        HashMap<StructuredQName, GlobalVariable> map;
        if (this.pathMap == null) {
            this.pathMap = new PathMap(this.expression);
        }
        if ((map = this.executable.getCompiledGlobalVariables()) != null) {
            for (GlobalVariable var : map.values()) {
                Expression select = var.getSelectExpression();
                if (select == null) continue;
                select.addToPathMap(this.pathMap, null);
            }
        }
        return this.pathMap;
    }

    public LocationProvider getLocationProvider() {
        return this.executable.getLocationMap();
    }

    public void setAllowDocumentProjection(boolean allowed) {
        this.allowDocumentProjection = allowed;
    }

    public boolean isDocumentProjectionAllowed() {
        return this.allowDocumentProjection;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return null;
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    public int getHostLanguage() {
        return 51;
    }

    private class ErrorReportingIterator
    implements SequenceIterator {
        private SequenceIterator base;
        private ErrorListener listener;

        public ErrorReportingIterator(SequenceIterator base, ErrorListener listener) {
            this.base = base;
            this.listener = listener;
        }

        public Item next() throws XPathException {
            try {
                return this.base.next();
            }
            catch (XPathException e1) {
                e1.maybeSetLocation(XQueryExpression.this.expression);
                try {
                    this.listener.fatalError(e1);
                }
                catch (TransformerException transformerException) {
                    // empty catch block
                }
                e1.setHasBeenReported(true);
                throw e1;
            }
        }

        public Item current() {
            return this.base.current();
        }

        public int position() {
            return this.base.position();
        }

        public void close() {
            this.base.close();
        }

        public SequenceIterator getAnother() throws XPathException {
            return new ErrorReportingIterator(this.base.getAnother(), this.listener);
        }

        public int getProperties() {
            return 0;
        }
    }
}

