<!-- DO NOT EDIT: File generated by docs/Generate.sh -->

NAME
====

Net::Packet::UDP

SYNOPSIS
========

    use Net::Packet::UDP :short;

    my $buf = Buf.new([...]);
    my $udp = UDP.decode($buf);

    say sprintf '%d -> %d: %d\n',
        $udp.src_port, $udp.dst_port, $udp.length;

Prints '53 -> 49875: 90'

EXPORTS
=======

    Net::Packet::UDP

:short trait adds exports:

    constant UDP ::= Net::Packet::UDP;

DESCRIPTION
===========

Net::Packet::UDP takes a byte buffer and returns a corresponding packet object. The byte buffer can be of the builtin Buf type or the C_Buf type of Net::Pcap.

class Net::Packet::UDP
----------------------

    is Net::Packet::Base

### Attributes

    $.src_port  is rw is Int
    $.dst_port  is rw is Int
      Source/Destination port fields.

    $.length    is rw is Int
      Packet length in bytes including header and data.

    $.chksum    is rw is Int
      Checksum field for erro checking of the header and data.

    $.data      is rw is Buf/C_Buf
      UDP data following the UDP header. Type is the same as the $frame given to .decode().

### Methods

    .decode($frame, Net::Packet::Base $parent?) returns Net::Packet::UDP
      Returns the UDP packet corresponding to $frame.
