#!perl

use strict;
use warnings;
use Test::More tests => 19;

use Finance::Bank::DE::NetBank;
use_ok('Finance::Bank::DE::NetBank');

# generic
can_ok('Finance::Bank::DE::NetBank', 'Version');
can_ok('Finance::Bank::DE::NetBank', 'Debug');

# methods
can_ok('Finance::Bank::DE::NetBank', 'login');
can_ok('Finance::Bank::DE::NetBank', 'new');
can_ok('Finance::Bank::DE::NetBank', 'connect');
can_ok('Finance::Bank::DE::NetBank', 'login');
can_ok('Finance::Bank::DE::NetBank', 'saldo');
can_ok('Finance::Bank::DE::NetBank', 'statement');
can_ok('Finance::Bank::DE::NetBank', 'transfer');
can_ok('Finance::Bank::DE::NetBank', 'logout');

# accessors, generated by Class::Accessor
can_ok('Finance::Bank::DE::NetBank', 'BASE_URL');
can_ok('Finance::Bank::DE::NetBank', 'BLZ');
can_ok('Finance::Bank::DE::NetBank', 'CUSTOMER_ID');
can_ok('Finance::Bank::DE::NetBank', 'PASSWORD');
can_ok('Finance::Bank::DE::NetBank', 'AGENT_TYPE');
can_ok('Finance::Bank::DE::NetBank', 'AGENT');
can_ok('Finance::Bank::DE::NetBank', 'ACCOUNT');

# opposite...
ok( !Finance::Bank::DE::NetBank->can('Victory_Joe'), 'can\'t Finance::Bank::DE::NetBank->can(\'Victory_Joe\')');

