// This file is part of MorphoDiTa.
//
// Copyright 2013 by Institute of Formal and Applied Linguistics, Faculty of
// Mathematics and Physics, Charles University in Prague, Czech Republic.
//
// MorphoDiTa is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation, either version 3 of
// the License, or (at your option) any later version.
//
// MorphoDiTa is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with MorphoDiTa.  If not, see <http://www.gnu.org/licenses/>.

#include <cstring>
#include <unordered_set>

#include "english_tokenizer.h"
#include "../unilib/unicode.h"
#include "../unilib/utf8.h"

namespace ufal {
namespace morphodita {


static const char _english_tokenizer_cond_offsets[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2
};

static const char _english_tokenizer_cond_lengths[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 2, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0
};

static const short _english_tokenizer_cond_keys[] = {
	43u, 43u, 45u, 45u, 0
};

static const char _english_tokenizer_cond_spaces[] = {
	1, 0, 0
};

static const short _english_tokenizer_key_offsets[] = {
	0, 0, 1, 2, 3, 5, 8, 9, 
	10, 45, 76, 77, 81, 113, 144, 175, 
	206, 236, 243, 247, 257, 278, 280, 296, 
	324, 356, 382, 384, 385, 387, 397, 399, 
	403, 404, 436, 464, 472, 480, 488, 496, 
	513, 519, 521, 522, 540, 541, 542, 545, 
	552, 558, 569, 572, 574, 586, 607, 617, 
	618, 619, 629, 634, 657, 671, 685, 713, 
	735, 740, 741, 748, 754, 758, 761, 764, 
	765, 767, 768, 784, 788, 792, 804, 806, 
	818, 825, 829, 831, 835, 839, 843, 846, 
	848, 850, 852, 853, 855, 865, 867, 884, 
	893, 896, 897, 908, 922, 934, 947, 956, 
	964, 971, 979, 985, 993, 1010, 1012, 1020, 
	1029, 1037, 1046, 1054, 1063, 1071, 1079, 1090, 
	1100, 1108, 1116, 1127, 1137, 1145, 1153, 1164, 
	1174, 1190, 1192, 1193, 1195, 1196, 1198, 1207, 
	1213, 1216, 1217, 1220, 1227, 1233, 1244, 1247, 
	1257, 1258, 1270, 1275, 1276, 1282, 1289, 1291, 
	1294, 1325, 1343, 1359, 1375, 1391, 1392, 1393, 
	1408, 1430, 1452, 1474, 1496, 1520, 1542, 1544, 
	1546, 1548, 1561, 1563, 1565, 1575, 1577, 1581, 
	1587, 1591, 1592, 1596, 1597, 1606, 1608, 1610, 
	1611, 1613, 1615, 1627, 1637, 1639, 1641, 1654, 
	1656, 1658, 1668, 1670, 1674, 1680, 1684, 1685, 
	1689, 1690, 1699, 1701, 1703, 1704, 1706, 1708, 
	1718, 1728, 1738, 1740, 1742, 1755, 1757, 1759, 
	1769, 1771, 1775, 1781, 1785, 1786, 1790, 1791, 
	1800, 1802, 1804, 1805, 1807, 1809, 1811, 1813, 
	1826, 1828, 1830, 1840, 1842, 1846, 1852, 1856, 
	1857, 1861, 1862, 1871, 1873, 1875, 1876, 1878, 
	1880, 1882, 1884, 1897, 1899, 1901, 1911, 1913, 
	1917, 1923, 1927, 1928, 1932, 1933, 1942, 1944, 
	1946, 1947, 1949, 1959, 1974, 1990, 2004, 2020, 
	2035, 2049, 2065, 2077, 2093, 2109, 2126, 2142, 
	2159, 2184, 2201, 2217, 2234, 2251, 2268, 2285, 
	2305, 2324, 2340, 2356, 2375, 2393, 2418, 2441, 
	2463, 2488, 2511, 2513, 2515, 2517, 2530, 2532, 
	2534, 2544, 2546, 2550, 2556, 2560, 2561, 2565, 
	2566, 2575, 2577, 2579, 2580, 2582, 2608, 2624, 
	2640, 2643, 2655, 2657, 2659, 2665, 2667, 2675, 
	2682, 2690, 2694, 2698, 2702, 2707, 2712, 2721, 
	2725, 2729, 2740, 2742, 2746, 2748, 2751, 2783, 
	2785, 2787, 2789, 2791, 2795, 2810, 2823, 2842, 
	2854, 2870, 2879, 2895, 2908, 2929, 2937, 2949, 
	2961, 2975, 2988, 2998, 3009, 3018, 3028, 3030, 
	3032, 3053, 3060, 3068, 3074, 3080, 3081, 3125, 
	3131, 3139, 3150, 3160, 3167, 3173, 3177, 3181, 
	3183, 3185, 3189, 3193, 3197, 3203, 3211, 3216, 
	3220, 3222, 3226, 3228, 3234, 3238, 3242, 3244, 
	3248, 3253, 3256, 3260, 3264, 3266, 3270, 3276, 
	3280, 3286, 3297, 3302, 3316, 3332, 3333, 3343, 
	3351, 3359, 3363, 3367, 3371, 3373, 3378, 3380, 
	3383, 3385, 3410, 3412, 3418, 3423, 3427, 3431, 
	3435, 3443, 3445, 3447, 3452, 3456, 3460, 3466, 
	3468, 3474, 3482, 3494, 3500, 3504, 3508, 3512, 
	3516, 3535, 3539, 3541, 3552, 3558, 3560, 3562, 
	3566, 3570, 3574, 3578, 3580, 3582, 3586, 3588, 
	3596, 3609, 3643, 3652, 3656, 3658, 3659, 3663, 
	3666, 3670, 3675, 3679, 3683, 3685, 3689, 3691, 
	3695, 3704, 3708, 3710, 3714, 3718, 3731, 3733, 
	3735, 3739, 3743, 3745, 3747, 3770, 3773, 3775, 
	3778, 3781, 3785, 3787, 3800, 3803, 3807, 3808, 
	3810, 3812, 3815, 3817, 3820, 3822, 3825, 3827, 
	3838, 3844, 3846, 3850, 3852, 3856, 3858, 3862, 
	3868, 3884, 3890, 3896, 3898, 3902, 3916, 3920, 
	3932, 3939, 3943, 3950, 3956, 3962, 3968, 3972, 
	3978, 3982, 3996, 4022, 4032, 4035, 4037, 4041, 
	4044, 4045, 4048, 4050, 4066, 4067, 4079, 4081, 
	4083, 4085, 4087, 4089, 4105, 4108, 4110, 4114, 
	4118, 4122, 4128, 4132, 4142, 4152, 4153, 4169, 
	4170, 4181, 4182, 4197, 4213, 4230, 4246, 4263, 
	4279, 4296, 4312, 4328, 4347, 4365, 4381, 4397, 
	4416, 4434, 4450, 4466, 4485, 4503, 4519, 4520, 
	4536, 4537, 4538, 4539, 4543, 4545, 4547, 4549, 
	4634, 4642, 4649, 4655, 4662, 4670, 4671, 4679, 
	4680, 4688, 4719, 4729, 4746, 4749, 4759, 4769, 
	4779, 4789, 4802, 4814, 4828, 4846, 4860, 4874, 
	4906, 4933, 4951, 4975, 4997, 5007, 5019, 5023, 
	5040, 5054, 5071, 5097, 5123, 5147, 5173, 5199, 
	5228, 5256, 5283, 5307, 5321, 5348, 5375, 5405, 
	5434, 5450, 5502, 5565, 5615, 5666, 5717, 5782, 
	5833, 5874, 5927, 5927, 5927, 5967, 6008, 6063, 
	6104, 6157, 6198, 6241, 6282, 6325, 6325, 6325, 
	6368, 6409, 6452, 6507, 6560, 6611, 6664, 6715, 
	6767, 6819, 6871, 6923, 6940, 6957, 6974, 6994, 
	7013, 7065, 7117, 7171, 7223, 7275, 7329, 7383, 
	7435, 7487, 7552, 7605, 7660, 7703, 7759, 7813, 
	7867, 7921, 7973, 8027, 8079, 8133, 8187, 8241, 
	8295, 8349, 8403, 8457, 8509, 8572, 8623, 8676, 
	8717, 8771, 8823, 8825, 8827, 8833, 8843, 8886, 
	8890, 8892, 8906, 8916, 8924, 8927, 8933, 8936, 
	8943, 8947, 8957, 8961, 8972, 8988, 9006, 9013, 
	9017, 9022, 9033, 9065, 9072, 9076, 9082, 9089, 
	9101, 9123, 9137, 9155, 9170, 9182, 9193, 9211, 
	9223, 9253, 9260, 9270, 9284, 9295, 9309, 9318, 
	9331, 9343, 9351, 9357, 9365, 9392, 9405, 9412, 
	9417, 9423, 9469, 9474, 9497, 9508, 9517, 9530, 
	9543, 9551, 9558, 9562, 9568, 9572, 9575, 9581, 
	9588, 9596, 9605, 9614, 9618, 9626, 9634, 9638, 
	9645, 9649, 9653, 9665, 9669, 9678, 9684, 9688, 
	9697, 9703, 9713, 9725, 9729, 9733, 9745, 9756, 
	9766, 9782, 9787, 9811, 9828, 9836, 9840, 9846, 
	9864, 9869, 9875, 9898, 9905, 9911, 9914, 9917, 
	9929, 9937, 9942, 9952, 9959, 9962, 9974, 9989, 
	9996, 9999, 10007, 10015, 10019, 10023, 10025, 10028, 
	10032, 10059, 10065, 10077, 10082, 10088, 10096, 10109, 
	10113, 10120, 10126, 10137, 10145, 10153, 10159, 10174, 
	10178, 10194, 10207, 10224, 10241, 10250, 10258, 10264, 
	10270, 10278, 10299, 10305, 10309, 10324, 10328, 10332, 
	10336, 10340, 10344, 10350, 10358, 10363, 10367, 10377, 
	10384, 10387, 10405, 10422, 10461, 10467, 10475, 10479, 
	10485, 10489, 10495, 10504, 10512, 10520, 10526, 10530, 
	10538, 10550, 10558, 10566, 10572, 10581, 10587, 10591, 
	10596, 10604, 10608, 10612, 10637, 10643, 10649, 10655, 
	10665, 10673, 10680, 10686, 10696, 10701, 10709, 10715, 
	10719, 10730, 10734, 10741, 10745, 10749, 10756, 10760, 
	10765, 10770, 10785, 10792, 10798, 10812, 10816, 10821, 
	10827, 10833, 10837, 10845, 10853, 10870, 10873, 10888, 
	10891, 10902, 10910, 10916, 10921, 10925, 10929, 10933, 
	10940, 10950, 10954, 10969, 10998, 11009, 11012, 11016, 
	11022, 11026, 11033, 11048, 11071, 11097
};

static const short _english_tokenizer_trans_keys[] = {
	160u, 154u, 128u, 128u, 129u, 175u, 128u, 138u, 
	159u, 128u, 13u, 32u, 34u, 40u, 91u, 96u, 
	123u, 194u, 195u, 196u, 197u, 198u, 199u, 200u, 
	201u, 205u, 206u, 207u, 208u, 209u, 210u, 211u, 
	212u, 213u, 224u, 225u, 226u, 227u, 234u, 239u, 
	240u, 9u, 10u, 65u, 90u, 34u, 40u, 91u, 
	96u, 123u, 194u, 195u, 196u, 197u, 198u, 199u, 
	200u, 201u, 205u, 206u, 207u, 208u, 209u, 210u, 
	211u, 212u, 213u, 224u, 225u, 226u, 227u, 234u, 
	239u, 240u, 65u, 90u, 171u, 128u, 150u, 152u, 
	158u, 128u, 130u, 132u, 134u, 136u, 138u, 140u, 
	142u, 144u, 146u, 148u, 150u, 152u, 154u, 156u, 
	158u, 160u, 162u, 164u, 166u, 168u, 170u, 172u, 
	174u, 176u, 178u, 180u, 182u, 185u, 187u, 189u, 
	191u, 129u, 131u, 133u, 135u, 138u, 140u, 142u, 
	144u, 146u, 148u, 150u, 152u, 154u, 156u, 158u, 
	160u, 162u, 164u, 166u, 168u, 170u, 172u, 174u, 
	176u, 178u, 180u, 182u, 187u, 189u, 184u, 185u, 
	132u, 162u, 164u, 169u, 172u, 181u, 188u, 129u, 
	130u, 134u, 135u, 137u, 139u, 142u, 145u, 147u, 
	148u, 150u, 152u, 156u, 157u, 159u, 160u, 166u, 
	167u, 174u, 175u, 177u, 179u, 183u, 184u, 141u, 
	143u, 145u, 147u, 149u, 151u, 153u, 155u, 158u, 
	160u, 162u, 164u, 166u, 168u, 170u, 172u, 174u, 
	180u, 186u, 188u, 190u, 132u, 133u, 135u, 136u, 
	138u, 139u, 177u, 178u, 182u, 184u, 128u, 130u, 
	132u, 134u, 136u, 138u, 140u, 142u, 144u, 146u, 
	148u, 150u, 152u, 154u, 156u, 158u, 160u, 162u, 
	164u, 166u, 168u, 170u, 172u, 174u, 176u, 178u, 
	186u, 187u, 189u, 190u, 129u, 136u, 138u, 140u, 
	142u, 131u, 134u, 176u, 178u, 182u, 191u, 134u, 
	140u, 136u, 138u, 142u, 143u, 145u, 161u, 163u, 
	171u, 143u, 152u, 154u, 156u, 158u, 160u, 162u, 
	164u, 166u, 168u, 170u, 172u, 174u, 180u, 183u, 
	146u, 148u, 185u, 186u, 189u, 191u, 128u, 175u, 
	160u, 162u, 164u, 166u, 168u, 170u, 172u, 174u, 
	176u, 178u, 180u, 182u, 184u, 186u, 188u, 190u, 
	128u, 138u, 140u, 142u, 144u, 146u, 148u, 150u, 
	152u, 154u, 156u, 158u, 160u, 162u, 164u, 166u, 
	168u, 170u, 172u, 174u, 176u, 178u, 180u, 182u, 
	184u, 186u, 188u, 190u, 131u, 133u, 135u, 137u, 
	139u, 141u, 144u, 146u, 148u, 150u, 152u, 154u, 
	156u, 158u, 160u, 162u, 164u, 166u, 168u, 170u, 
	172u, 174u, 176u, 178u, 180u, 182u, 184u, 186u, 
	188u, 190u, 128u, 129u, 128u, 130u, 132u, 134u, 
	136u, 138u, 140u, 142u, 144u, 146u, 148u, 150u, 
	152u, 154u, 156u, 158u, 160u, 162u, 164u, 166u, 
	168u, 170u, 172u, 174u, 177u, 191u, 128u, 150u, 
	188u, 186u, 188u, 130u, 131u, 154u, 186u, 188u, 
	189u, 190u, 191u, 184u, 187u, 160u, 191u, 135u, 
	141u, 128u, 133u, 155u, 128u, 130u, 132u, 134u, 
	136u, 138u, 140u, 142u, 144u, 146u, 148u, 150u, 
	152u, 154u, 156u, 158u, 160u, 162u, 164u, 166u, 
	168u, 170u, 172u, 174u, 176u, 178u, 180u, 182u, 
	184u, 186u, 188u, 190u, 128u, 130u, 132u, 134u, 
	136u, 138u, 140u, 142u, 144u, 146u, 148u, 158u, 
	160u, 162u, 164u, 166u, 168u, 170u, 172u, 174u, 
	176u, 178u, 180u, 182u, 184u, 186u, 188u, 190u, 
	136u, 143u, 152u, 157u, 168u, 175u, 184u, 191u, 
	153u, 155u, 157u, 159u, 136u, 141u, 168u, 175u, 
	136u, 143u, 152u, 159u, 168u, 175u, 184u, 188u, 
	136u, 140u, 152u, 155u, 168u, 172u, 184u, 188u, 
	128u, 129u, 130u, 132u, 133u, 134u, 140u, 157u, 
	159u, 166u, 167u, 176u, 177u, 178u, 179u, 184u, 
	185u, 152u, 185u, 154u, 156u, 158u, 159u, 133u, 
	189u, 141u, 130u, 135u, 149u, 164u, 166u, 168u, 
	139u, 141u, 144u, 146u, 153u, 157u, 170u, 173u, 
	176u, 179u, 190u, 191u, 133u, 131u, 136u, 138u, 
	169u, 168u, 170u, 172u, 174u, 176u, 178u, 180u, 
	133u, 166u, 168u, 170u, 172u, 174u, 131u, 133u, 
	135u, 137u, 139u, 141u, 143u, 145u, 147u, 149u, 
	151u, 152u, 154u, 188u, 128u, 174u, 160u, 167u, 
	169u, 171u, 178u, 181u, 162u, 164u, 173u, 176u, 
	190u, 191u, 128u, 130u, 132u, 134u, 136u, 138u, 
	140u, 142u, 144u, 146u, 148u, 150u, 152u, 154u, 
	156u, 158u, 160u, 162u, 171u, 173u, 178u, 130u, 
	132u, 137u, 140u, 156u, 160u, 162u, 164u, 166u, 
	168u, 130u, 128u, 136u, 138u, 140u, 142u, 144u, 
	148u, 150u, 152u, 154u, 157u, 153u, 154u, 156u, 
	157u, 158u, 128u, 130u, 132u, 134u, 136u, 138u, 
	140u, 142u, 144u, 146u, 148u, 150u, 152u, 154u, 
	156u, 158u, 160u, 162u, 164u, 166u, 168u, 170u, 
	172u, 128u, 130u, 132u, 134u, 136u, 138u, 140u, 
	142u, 144u, 146u, 148u, 150u, 152u, 154u, 162u, 
	164u, 166u, 168u, 170u, 172u, 174u, 178u, 180u, 
	182u, 184u, 186u, 188u, 190u, 128u, 130u, 132u, 
	134u, 136u, 138u, 140u, 142u, 144u, 146u, 148u, 
	150u, 152u, 154u, 156u, 158u, 160u, 162u, 164u, 
	166u, 168u, 170u, 172u, 174u, 185u, 187u, 189u, 
	190u, 128u, 130u, 132u, 134u, 139u, 141u, 144u, 
	146u, 150u, 152u, 154u, 156u, 158u, 160u, 162u, 
	164u, 166u, 168u, 170u, 173u, 176u, 177u, 180u, 
	184u, 185u, 188u, 189u, 191u, 151u, 181u, 183u, 
	185u, 187u, 189u, 191u, 129u, 131u, 135u, 153u, 
	155u, 157u, 136u, 187u, 161u, 186u, 155u, 159u, 
	162u, 144u, 145u, 157u, 144u, 128u, 167u, 162u, 
	144u, 145u, 146u, 147u, 148u, 149u, 150u, 151u, 
	152u, 153u, 154u, 155u, 156u, 157u, 158u, 159u, 
	128u, 153u, 180u, 191u, 128u, 141u, 168u, 191u, 
	156u, 162u, 128u, 129u, 158u, 159u, 165u, 166u, 
	169u, 172u, 174u, 181u, 144u, 169u, 132u, 133u, 
	135u, 138u, 141u, 148u, 150u, 156u, 184u, 185u, 
	187u, 190u, 134u, 128u, 132u, 138u, 144u, 172u, 
	191u, 128u, 133u, 160u, 185u, 148u, 173u, 136u, 
	161u, 188u, 191u, 128u, 149u, 176u, 191u, 128u, 
	137u, 168u, 191u, 128u, 162u, 186u, 156u, 180u, 
	150u, 174u, 144u, 168u, 138u, 160u, 171u, 130u, 
	131u, 154u, 186u, 188u, 189u, 190u, 191u, 184u, 
	187u, 128u, 155u, 128u, 129u, 130u, 132u, 133u, 
	134u, 140u, 157u, 159u, 166u, 167u, 176u, 177u, 
	178u, 179u, 184u, 185u, 152u, 175u, 185u, 128u, 
	138u, 154u, 156u, 158u, 159u, 133u, 159u, 189u, 
	128u, 128u, 136u, 138u, 140u, 142u, 144u, 148u, 
	150u, 152u, 154u, 157u, 33u, 58u, 64u, 95u, 
	36u, 37u, 39u, 46u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 95u, 36u, 37u, 39u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 64u, 
	95u, 36u, 37u, 39u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 48u, 49u, 50u, 51u, 57u, 
	65u, 90u, 97u, 122u, 45u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 45u, 48u, 57u, 65u, 
	90u, 97u, 122u, 45u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 48u, 57u, 65u, 90u, 97u, 
	122u, 45u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 39u, 41u, 61u, 95u, 36u, 47u, 
	48u, 57u, 58u, 59u, 63u, 64u, 65u, 90u, 
	97u, 122u, 48u, 57u, 45u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 48u, 49u, 50u, 51u, 
	57u, 65u, 90u, 97u, 122u, 45u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 48u, 49u, 50u, 
	51u, 57u, 65u, 90u, 97u, 122u, 45u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 48u, 49u, 
	50u, 51u, 57u, 65u, 90u, 97u, 122u, 45u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 45u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 45u, 
	46u, 53u, 48u, 52u, 54u, 57u, 65u, 90u, 
	97u, 122u, 45u, 46u, 48u, 53u, 54u, 57u, 
	65u, 90u, 97u, 122u, 45u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 45u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 45u, 46u, 53u, 48u, 
	52u, 54u, 57u, 65u, 90u, 97u, 122u, 45u, 
	46u, 48u, 53u, 54u, 57u, 65u, 90u, 97u, 
	122u, 45u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 45u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 45u, 46u, 53u, 48u, 52u, 54u, 57u, 
	65u, 90u, 97u, 122u, 45u, 46u, 48u, 53u, 
	54u, 57u, 65u, 90u, 97u, 122u, 13u, 32u, 
	34u, 39u, 41u, 59u, 93u, 125u, 194u, 224u, 
	225u, 226u, 227u, 239u, 9u, 10u, 160u, 187u, 
	188u, 187u, 189u, 154u, 128u, 156u, 128u, 129u, 
	130u, 140u, 157u, 159u, 166u, 167u, 184u, 153u, 
	157u, 175u, 186u, 128u, 138u, 134u, 159u, 190u, 
	142u, 137u, 139u, 170u, 169u, 171u, 173u, 175u, 
	177u, 179u, 181u, 134u, 167u, 169u, 171u, 173u, 
	175u, 132u, 134u, 136u, 138u, 140u, 142u, 144u, 
	146u, 148u, 150u, 152u, 153u, 155u, 189u, 131u, 
	133u, 138u, 141u, 157u, 161u, 163u, 165u, 167u, 
	169u, 128u, 128u, 137u, 139u, 141u, 143u, 145u, 
	149u, 151u, 153u, 155u, 158u, 159u, 180u, 184u, 
	185u, 188u, 189u, 190u, 152u, 182u, 184u, 186u, 
	188u, 190u, 128u, 130u, 132u, 136u, 154u, 156u, 
	158u, 137u, 189u, 157u, 160u, 163u, 13u, 32u, 
	33u, 34u, 40u, 58u, 59u, 64u, 93u, 95u, 
	125u, 194u, 224u, 225u, 226u, 227u, 239u, 9u, 
	10u, 36u, 37u, 39u, 41u, 42u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 58u, 64u, 
	73u, 87u, 95u, 105u, 119u, 36u, 37u, 39u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	58u, 64u, 83u, 95u, 115u, 36u, 37u, 39u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	58u, 64u, 65u, 95u, 97u, 36u, 37u, 39u, 
	46u, 48u, 57u, 66u, 90u, 98u, 122u, 33u, 
	58u, 64u, 83u, 95u, 115u, 36u, 37u, 39u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 128u, 
	153u, 33u, 46u, 58u, 64u, 95u, 36u, 37u, 
	39u, 45u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 58u, 64u, 95u, 217u, 219u, 223u, 224u, 
	225u, 234u, 239u, 240u, 36u, 37u, 39u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 58u, 
	64u, 95u, 217u, 219u, 223u, 224u, 225u, 234u, 
	239u, 240u, 36u, 37u, 39u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 58u, 64u, 95u, 
	217u, 219u, 223u, 224u, 225u, 234u, 239u, 240u, 
	36u, 37u, 39u, 46u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 58u, 64u, 95u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 36u, 37u, 
	39u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 43u, 45u, 58u, 64u, 95u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 36u, 37u, 
	39u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 58u, 64u, 95u, 217u, 219u, 223u, 224u, 
	225u, 234u, 239u, 240u, 36u, 37u, 39u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 160u, 169u, 
	176u, 185u, 128u, 137u, 165u, 167u, 169u, 171u, 
	173u, 175u, 177u, 179u, 181u, 183u, 185u, 187u, 
	188u, 166u, 175u, 144u, 153u, 129u, 130u, 159u, 
	160u, 165u, 167u, 170u, 173u, 174u, 177u, 134u, 
	143u, 128u, 137u, 144u, 153u, 152u, 163u, 164u, 
	167u, 169u, 175u, 144u, 153u, 176u, 185u, 188u, 
	144u, 145u, 150u, 157u, 146u, 129u, 131u, 132u, 
	135u, 139u, 147u, 153u, 155u, 163u, 182u, 191u, 
	169u, 173u, 159u, 142u, 191u, 160u, 169u, 43u, 
	45u, 217u, 219u, 223u, 224u, 225u, 234u, 239u, 
	240u, 48u, 57u, 217u, 219u, 223u, 224u, 225u, 
	234u, 239u, 240u, 48u, 57u, 176u, 185u, 128u, 
	137u, 165u, 167u, 169u, 171u, 173u, 175u, 177u, 
	179u, 181u, 183u, 185u, 187u, 188u, 166u, 175u, 
	144u, 153u, 129u, 130u, 159u, 160u, 165u, 167u, 
	170u, 173u, 174u, 177u, 134u, 143u, 128u, 137u, 
	144u, 153u, 152u, 163u, 164u, 167u, 169u, 175u, 
	144u, 153u, 176u, 185u, 188u, 144u, 145u, 150u, 
	157u, 146u, 129u, 131u, 132u, 135u, 139u, 147u, 
	153u, 155u, 163u, 182u, 191u, 169u, 173u, 159u, 
	142u, 191u, 160u, 169u, 217u, 219u, 223u, 224u, 
	225u, 234u, 239u, 240u, 48u, 57u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 48u, 57u, 
	217u, 219u, 223u, 224u, 225u, 234u, 239u, 240u, 
	48u, 57u, 176u, 185u, 128u, 137u, 165u, 167u, 
	169u, 171u, 173u, 175u, 177u, 179u, 181u, 183u, 
	185u, 187u, 188u, 166u, 175u, 144u, 153u, 129u, 
	130u, 159u, 160u, 165u, 167u, 170u, 173u, 174u, 
	177u, 134u, 143u, 128u, 137u, 144u, 153u, 152u, 
	163u, 164u, 167u, 169u, 175u, 144u, 153u, 176u, 
	185u, 188u, 144u, 145u, 150u, 157u, 146u, 129u, 
	131u, 132u, 135u, 139u, 147u, 153u, 155u, 163u, 
	182u, 191u, 169u, 173u, 159u, 142u, 191u, 160u, 
	169u, 176u, 185u, 128u, 137u, 165u, 167u, 169u, 
	171u, 173u, 175u, 177u, 179u, 181u, 183u, 185u, 
	187u, 188u, 166u, 175u, 144u, 153u, 129u, 130u, 
	159u, 160u, 165u, 167u, 170u, 173u, 174u, 177u, 
	134u, 143u, 128u, 137u, 144u, 153u, 152u, 163u, 
	164u, 167u, 169u, 175u, 144u, 153u, 176u, 185u, 
	188u, 144u, 145u, 150u, 157u, 146u, 129u, 131u, 
	132u, 135u, 139u, 147u, 153u, 155u, 163u, 182u, 
	191u, 169u, 173u, 159u, 142u, 191u, 160u, 169u, 
	176u, 185u, 128u, 137u, 165u, 167u, 169u, 171u, 
	173u, 175u, 177u, 179u, 181u, 183u, 185u, 187u, 
	188u, 166u, 175u, 144u, 153u, 129u, 130u, 159u, 
	160u, 165u, 167u, 170u, 173u, 174u, 177u, 134u, 
	143u, 128u, 137u, 144u, 153u, 152u, 163u, 164u, 
	167u, 169u, 175u, 144u, 153u, 176u, 185u, 188u, 
	144u, 145u, 150u, 157u, 146u, 129u, 131u, 132u, 
	135u, 139u, 147u, 153u, 155u, 163u, 182u, 191u, 
	169u, 173u, 159u, 142u, 191u, 217u, 219u, 223u, 
	224u, 225u, 234u, 239u, 240u, 48u, 57u, 33u, 
	45u, 58u, 64u, 95u, 36u, 37u, 39u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 58u, 
	64u, 95u, 36u, 37u, 39u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 58u, 64u, 
	95u, 36u, 37u, 39u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 58u, 64u, 95u, 36u, 
	37u, 39u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 95u, 36u, 37u, 39u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	47u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 47u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	48u, 49u, 50u, 58u, 64u, 95u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 36u, 37u, 
	39u, 46u, 51u, 57u, 65u, 90u, 97u, 122u, 
	33u, 48u, 49u, 50u, 58u, 64u, 95u, 36u, 
	37u, 39u, 46u, 51u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 48u, 49u, 50u, 58u, 64u, 95u, 
	36u, 37u, 39u, 46u, 51u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 47u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 47u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 47u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	47u, 53u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 52u, 54u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 47u, 58u, 64u, 95u, 
	36u, 37u, 39u, 44u, 48u, 53u, 54u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 53u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	52u, 54u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 53u, 54u, 57u, 65u, 90u, 97u, 
	122u, 33u, 43u, 45u, 46u, 58u, 64u, 95u, 
	217u, 219u, 223u, 224u, 225u, 234u, 239u, 240u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 58u, 64u, 95u, 217u, 
	219u, 223u, 224u, 225u, 234u, 239u, 240u, 36u, 
	37u, 39u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 58u, 64u, 95u, 217u, 219u, 223u, 
	224u, 225u, 234u, 239u, 240u, 36u, 37u, 39u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	43u, 45u, 46u, 58u, 64u, 95u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 58u, 64u, 95u, 217u, 219u, 223u, 
	224u, 225u, 234u, 239u, 240u, 36u, 37u, 39u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 160u, 
	169u, 176u, 185u, 128u, 137u, 165u, 167u, 169u, 
	171u, 173u, 175u, 177u, 179u, 181u, 183u, 185u, 
	187u, 188u, 166u, 175u, 144u, 153u, 129u, 130u, 
	159u, 160u, 165u, 167u, 170u, 173u, 174u, 177u, 
	134u, 143u, 128u, 137u, 144u, 153u, 152u, 163u, 
	164u, 167u, 169u, 175u, 144u, 153u, 176u, 185u, 
	188u, 144u, 145u, 150u, 157u, 146u, 129u, 131u, 
	132u, 135u, 139u, 147u, 153u, 155u, 163u, 182u, 
	191u, 169u, 173u, 159u, 142u, 191u, 33u, 58u, 
	64u, 68u, 76u, 77u, 82u, 83u, 86u, 95u, 
	100u, 108u, 109u, 114u, 115u, 118u, 36u, 37u, 
	39u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 58u, 64u, 76u, 95u, 108u, 36u, 37u, 
	39u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 58u, 64u, 69u, 95u, 101u, 36u, 37u, 
	39u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	170u, 181u, 186u, 68u, 76u, 77u, 82u, 83u, 
	86u, 100u, 108u, 109u, 114u, 115u, 118u, 76u, 
	108u, 69u, 101u, 128u, 150u, 152u, 182u, 184u, 
	191u, 128u, 191u, 172u, 174u, 128u, 129u, 134u, 
	145u, 160u, 164u, 191u, 128u, 180u, 182u, 183u, 
	186u, 189u, 134u, 140u, 136u, 138u, 142u, 161u, 
	163u, 191u, 128u, 181u, 183u, 191u, 128u, 129u, 
	131u, 191u, 128u, 175u, 177u, 191u, 153u, 128u, 
	150u, 161u, 191u, 191u, 128u, 135u, 145u, 189u, 
	135u, 129u, 130u, 132u, 133u, 144u, 170u, 176u, 
	178u, 144u, 154u, 160u, 191u, 128u, 159u, 174u, 
	191u, 191u, 128u, 147u, 149u, 156u, 159u, 168u, 
	170u, 175u, 186u, 188u, 144u, 191u, 128u, 138u, 
	141u, 191u, 128u, 177u, 186u, 138u, 181u, 160u, 
	161u, 162u, 163u, 164u, 165u, 166u, 167u, 168u, 
	169u, 170u, 171u, 172u, 173u, 174u, 175u, 176u, 
	177u, 178u, 179u, 180u, 181u, 182u, 183u, 184u, 
	185u, 186u, 187u, 188u, 189u, 190u, 191u, 128u, 
	173u, 128u, 155u, 160u, 178u, 164u, 191u, 128u, 
	163u, 177u, 191u, 178u, 128u, 131u, 133u, 140u, 
	143u, 144u, 147u, 168u, 170u, 176u, 182u, 185u, 
	188u, 191u, 151u, 128u, 132u, 135u, 136u, 139u, 
	142u, 156u, 157u, 159u, 163u, 176u, 177u, 188u, 
	129u, 131u, 133u, 138u, 143u, 144u, 147u, 168u, 
	170u, 176u, 178u, 179u, 181u, 182u, 184u, 185u, 
	190u, 191u, 145u, 158u, 128u, 130u, 135u, 136u, 
	139u, 141u, 153u, 156u, 176u, 181u, 129u, 131u, 
	133u, 141u, 143u, 145u, 147u, 168u, 170u, 176u, 
	178u, 179u, 181u, 185u, 188u, 191u, 144u, 128u, 
	133u, 135u, 137u, 139u, 141u, 160u, 163u, 129u, 
	131u, 133u, 140u, 143u, 144u, 147u, 168u, 170u, 
	176u, 178u, 179u, 181u, 185u, 188u, 191u, 177u, 
	128u, 132u, 135u, 136u, 139u, 141u, 150u, 151u, 
	156u, 157u, 159u, 163u, 156u, 130u, 131u, 133u, 
	138u, 142u, 144u, 146u, 149u, 153u, 154u, 158u, 
	159u, 163u, 164u, 168u, 170u, 174u, 185u, 190u, 
	191u, 144u, 151u, 128u, 130u, 134u, 136u, 138u, 
	141u, 128u, 131u, 133u, 140u, 142u, 144u, 146u, 
	168u, 170u, 185u, 189u, 191u, 128u, 132u, 134u, 
	136u, 138u, 141u, 149u, 150u, 152u, 153u, 160u, 
	163u, 129u, 131u, 133u, 140u, 142u, 144u, 146u, 
	168u, 170u, 179u, 181u, 185u, 188u, 191u, 158u, 
	128u, 132u, 134u, 136u, 138u, 141u, 149u, 150u, 
	160u, 163u, 177u, 178u, 129u, 131u, 133u, 140u, 
	142u, 144u, 146u, 186u, 189u, 191u, 151u, 128u, 
	132u, 134u, 136u, 138u, 142u, 160u, 163u, 186u, 
	191u, 189u, 130u, 131u, 133u, 150u, 154u, 177u, 
	179u, 187u, 138u, 150u, 128u, 134u, 143u, 148u, 
	152u, 159u, 178u, 179u, 129u, 186u, 128u, 142u, 
	132u, 138u, 141u, 165u, 167u, 129u, 130u, 135u, 
	136u, 148u, 151u, 153u, 159u, 161u, 163u, 170u, 
	171u, 173u, 185u, 187u, 189u, 134u, 128u, 132u, 
	136u, 141u, 156u, 159u, 128u, 181u, 183u, 185u, 
	152u, 153u, 190u, 191u, 128u, 135u, 137u, 172u, 
	177u, 191u, 128u, 132u, 134u, 151u, 153u, 188u, 
	134u, 129u, 130u, 131u, 137u, 138u, 139u, 140u, 
	141u, 142u, 143u, 144u, 153u, 154u, 155u, 156u, 
	157u, 159u, 160u, 161u, 162u, 163u, 164u, 165u, 
	166u, 167u, 168u, 169u, 170u, 172u, 173u, 174u, 
	175u, 176u, 177u, 179u, 183u, 188u, 189u, 190u, 
	191u, 128u, 158u, 180u, 187u, 128u, 143u, 154u, 
	157u, 160u, 191u, 135u, 141u, 128u, 133u, 144u, 
	186u, 188u, 191u, 152u, 128u, 136u, 138u, 141u, 
	144u, 150u, 154u, 157u, 160u, 191u, 128u, 136u, 
	138u, 141u, 144u, 176u, 178u, 181u, 184u, 190u, 
	128u, 130u, 133u, 136u, 150u, 152u, 191u, 128u, 
	144u, 146u, 149u, 152u, 191u, 128u, 154u, 157u, 
	159u, 128u, 143u, 160u, 191u, 128u, 180u, 129u, 
	191u, 128u, 172u, 175u, 191u, 129u, 154u, 160u, 
	191u, 128u, 170u, 177u, 184u, 128u, 140u, 142u, 
	148u, 160u, 180u, 128u, 147u, 160u, 172u, 174u, 
	176u, 178u, 179u, 151u, 128u, 147u, 156u, 157u, 
	139u, 141u, 160u, 191u, 128u, 183u, 128u, 170u, 
	176u, 191u, 128u, 181u, 128u, 158u, 160u, 171u, 
	176u, 187u, 144u, 173u, 176u, 180u, 128u, 171u, 
	176u, 191u, 128u, 137u, 128u, 155u, 160u, 191u, 
	191u, 128u, 158u, 160u, 188u, 167u, 176u, 190u, 
	128u, 139u, 171u, 179u, 128u, 175u, 186u, 191u, 
	128u, 179u, 141u, 143u, 154u, 189u, 144u, 146u, 
	148u, 182u, 184u, 185u, 128u, 181u, 188u, 191u, 
	128u, 149u, 152u, 157u, 160u, 191u, 153u, 155u, 
	157u, 128u, 133u, 136u, 141u, 144u, 151u, 159u, 
	189u, 190u, 128u, 180u, 182u, 188u, 130u, 132u, 
	134u, 140u, 144u, 147u, 150u, 155u, 160u, 172u, 
	178u, 180u, 182u, 188u, 128u, 129u, 130u, 131u, 
	132u, 133u, 134u, 176u, 177u, 178u, 179u, 180u, 
	181u, 182u, 183u, 184u, 153u, 128u, 129u, 130u, 
	131u, 132u, 133u, 134u, 135u, 144u, 191u, 133u, 
	134u, 170u, 175u, 177u, 181u, 187u, 188u, 128u, 
	150u, 153u, 154u, 157u, 159u, 161u, 191u, 128u, 
	186u, 188u, 191u, 133u, 173u, 177u, 191u, 128u, 
	142u, 160u, 186u, 176u, 191u, 182u, 128u, 181u, 
	184u, 191u, 128u, 191u, 191u, 128u, 190u, 128u, 
	140u, 146u, 147u, 152u, 153u, 154u, 155u, 156u, 
	158u, 159u, 160u, 161u, 163u, 164u, 165u, 167u, 
	168u, 169u, 171u, 172u, 173u, 175u, 128u, 170u, 
	176u, 191u, 144u, 189u, 128u, 140u, 144u, 159u, 
	170u, 171u, 191u, 128u, 178u, 180u, 189u, 128u, 
	157u, 159u, 191u, 128u, 165u, 176u, 177u, 151u, 
	159u, 162u, 191u, 128u, 136u, 139u, 142u, 144u, 
	173u, 176u, 177u, 183u, 191u, 128u, 167u, 187u, 
	128u, 132u, 160u, 183u, 138u, 173u, 176u, 191u, 
	128u, 147u, 160u, 188u, 128u, 143u, 160u, 175u, 
	186u, 190u, 128u, 182u, 128u, 141u, 160u, 182u, 
	186u, 191u, 128u, 130u, 155u, 157u, 160u, 175u, 
	178u, 182u, 129u, 134u, 137u, 142u, 145u, 150u, 
	160u, 166u, 168u, 174u, 176u, 191u, 128u, 154u, 
	156u, 159u, 164u, 165u, 128u, 170u, 172u, 173u, 
	158u, 159u, 128u, 157u, 128u, 163u, 176u, 191u, 
	128u, 134u, 139u, 187u, 169u, 171u, 172u, 173u, 
	174u, 175u, 180u, 181u, 182u, 183u, 184u, 185u, 
	187u, 188u, 189u, 190u, 191u, 164u, 186u, 128u, 
	173u, 176u, 191u, 128u, 153u, 190u, 128u, 134u, 
	147u, 151u, 157u, 168u, 170u, 182u, 184u, 188u, 
	128u, 129u, 131u, 132u, 134u, 191u, 147u, 191u, 
	128u, 189u, 128u, 143u, 146u, 191u, 128u, 135u, 
	176u, 187u, 128u, 143u, 160u, 173u, 176u, 180u, 
	182u, 191u, 128u, 188u, 161u, 186u, 129u, 154u, 
	166u, 191u, 128u, 190u, 130u, 135u, 138u, 143u, 
	146u, 151u, 154u, 156u, 144u, 145u, 146u, 147u, 
	150u, 155u, 157u, 158u, 170u, 171u, 175u, 160u, 
	169u, 128u, 129u, 130u, 131u, 135u, 138u, 139u, 
	140u, 141u, 142u, 143u, 146u, 148u, 149u, 156u, 
	157u, 160u, 161u, 162u, 164u, 166u, 168u, 169u, 
	170u, 171u, 172u, 173u, 174u, 176u, 177u, 144u, 
	145u, 152u, 155u, 191u, 128u, 139u, 141u, 166u, 
	168u, 186u, 188u, 189u, 128u, 141u, 144u, 157u, 
	128u, 186u, 189u, 128u, 156u, 160u, 191u, 160u, 
	128u, 144u, 128u, 159u, 176u, 191u, 128u, 130u, 
	137u, 144u, 186u, 128u, 157u, 160u, 191u, 128u, 
	131u, 136u, 143u, 128u, 157u, 128u, 167u, 176u, 
	191u, 128u, 163u, 128u, 149u, 160u, 167u, 136u, 
	188u, 191u, 128u, 133u, 138u, 181u, 183u, 184u, 
	128u, 149u, 160u, 182u, 128u, 158u, 128u, 149u, 
	160u, 185u, 128u, 183u, 190u, 191u, 191u, 128u, 
	131u, 133u, 134u, 140u, 147u, 149u, 151u, 153u, 
	179u, 184u, 186u, 160u, 188u, 128u, 156u, 128u, 
	135u, 137u, 166u, 128u, 149u, 160u, 178u, 128u, 
	145u, 128u, 136u, 129u, 130u, 131u, 132u, 133u, 
	135u, 136u, 138u, 139u, 140u, 141u, 146u, 147u, 
	150u, 151u, 152u, 153u, 154u, 162u, 163u, 171u, 
	128u, 134u, 191u, 128u, 134u, 144u, 168u, 182u, 
	144u, 179u, 154u, 128u, 132u, 128u, 145u, 147u, 
	183u, 128u, 170u, 151u, 128u, 132u, 135u, 136u, 
	139u, 141u, 157u, 163u, 166u, 172u, 176u, 180u, 
	135u, 128u, 133u, 128u, 181u, 184u, 191u, 128u, 
	128u, 132u, 160u, 191u, 191u, 128u, 159u, 128u, 
	184u, 142u, 128u, 141u, 128u, 152u, 144u, 128u, 
	143u, 128u, 174u, 168u, 169u, 171u, 172u, 173u, 
	174u, 188u, 189u, 190u, 160u, 167u, 128u, 131u, 
	163u, 183u, 189u, 191u, 128u, 143u, 128u, 132u, 
	144u, 190u, 143u, 159u, 128u, 176u, 177u, 178u, 
	128u, 129u, 128u, 170u, 176u, 188u, 128u, 136u, 
	144u, 153u, 157u, 158u, 133u, 134u, 137u, 145u, 
	146u, 147u, 148u, 149u, 154u, 155u, 156u, 157u, 
	158u, 159u, 144u, 153u, 165u, 169u, 173u, 178u, 
	187u, 191u, 128u, 130u, 133u, 139u, 170u, 173u, 
	130u, 132u, 128u, 148u, 150u, 191u, 162u, 187u, 
	128u, 156u, 158u, 159u, 165u, 166u, 169u, 172u, 
	174u, 185u, 189u, 191u, 128u, 131u, 133u, 191u, 
	128u, 133u, 135u, 138u, 141u, 148u, 150u, 156u, 
	158u, 185u, 187u, 190u, 134u, 128u, 132u, 138u, 
	144u, 146u, 191u, 128u, 165u, 168u, 191u, 128u, 
	130u, 154u, 156u, 186u, 188u, 191u, 128u, 148u, 
	150u, 180u, 182u, 191u, 128u, 142u, 144u, 174u, 
	176u, 191u, 128u, 136u, 138u, 168u, 170u, 191u, 
	128u, 130u, 132u, 139u, 163u, 184u, 185u, 186u, 
	160u, 162u, 128u, 132u, 144u, 150u, 164u, 167u, 
	185u, 187u, 128u, 131u, 133u, 159u, 161u, 162u, 
	169u, 178u, 180u, 183u, 130u, 135u, 137u, 139u, 
	148u, 151u, 153u, 155u, 157u, 159u, 164u, 190u, 
	141u, 143u, 145u, 146u, 161u, 162u, 167u, 170u, 
	172u, 178u, 180u, 183u, 185u, 188u, 128u, 137u, 
	139u, 155u, 161u, 163u, 165u, 169u, 171u, 187u, 
	155u, 128u, 191u, 128u, 150u, 156u, 160u, 128u, 
	159u, 168u, 160u, 167u, 160u, 135u, 132u, 134u, 
	128u, 175u, 128u, 129u, 130u, 131u, 132u, 133u, 
	134u, 176u, 177u, 178u, 179u, 180u, 181u, 182u, 
	183u, 184u, 153u, 68u, 76u, 77u, 82u, 83u, 
	86u, 100u, 108u, 109u, 114u, 115u, 118u, 76u, 
	108u, 69u, 101u, 177u, 191u, 144u, 156u, 144u, 
	176u, 130u, 135u, 149u, 164u, 166u, 168u, 138u, 
	147u, 153u, 157u, 170u, 173u, 175u, 185u, 188u, 
	191u, 142u, 133u, 137u, 131u, 132u, 128u, 174u, 
	176u, 191u, 128u, 158u, 160u, 191u, 128u, 164u, 
	171u, 179u, 167u, 173u, 128u, 165u, 176u, 191u, 
	175u, 191u, 128u, 167u, 128u, 150u, 160u, 166u, 
	168u, 174u, 176u, 182u, 184u, 190u, 128u, 134u, 
	136u, 142u, 144u, 150u, 152u, 158u, 160u, 191u, 
	175u, 128u, 129u, 130u, 131u, 132u, 133u, 134u, 
	176u, 177u, 178u, 179u, 180u, 181u, 182u, 183u, 
	184u, 153u, 33u, 47u, 95u, 36u, 37u, 39u, 
	57u, 65u, 90u, 97u, 122u, 47u, 33u, 48u, 
	49u, 50u, 95u, 36u, 37u, 39u, 46u, 51u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 48u, 49u, 
	50u, 58u, 64u, 95u, 36u, 37u, 39u, 46u, 
	51u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 48u, 
	49u, 50u, 58u, 64u, 95u, 36u, 37u, 39u, 
	46u, 51u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	48u, 49u, 50u, 58u, 64u, 95u, 36u, 37u, 
	39u, 46u, 51u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 53u, 58u, 64u, 95u, 36u, 
	37u, 39u, 44u, 48u, 52u, 54u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 53u, 54u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	53u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 52u, 54u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 46u, 58u, 64u, 95u, 36u, 37u, 
	39u, 44u, 48u, 53u, 54u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 95u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 58u, 64u, 95u, 
	36u, 37u, 39u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 53u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 52u, 54u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	53u, 54u, 57u, 65u, 90u, 97u, 122u, 128u, 
	129u, 130u, 131u, 132u, 133u, 134u, 176u, 177u, 
	178u, 179u, 180u, 181u, 182u, 183u, 184u, 153u, 
	128u, 129u, 130u, 131u, 132u, 133u, 134u, 176u, 
	177u, 178u, 179u, 180u, 181u, 182u, 183u, 184u, 
	153u, 128u, 152u, 73u, 87u, 105u, 119u, 83u, 
	115u, 65u, 97u, 83u, 115u, 9u, 10u, 13u, 
	32u, 33u, 38u, 39u, 44u, 46u, 47u, 48u, 
	49u, 50u, 63u, 67u, 68u, 71u, 76u, 77u, 
	87u, 95u, 96u, 99u, 100u, 103u, 108u, 109u, 
	119u, 194u, 195u, 203u, 204u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 301u, 557u, 
	811u, 1067u, 0u, 35u, 36u, 42u, 51u, 57u, 
	58u, 64u, 65u, 90u, 91u, 94u, 97u, 122u, 
	123u, 127u, 128u, 193u, 196u, 218u, 229u, 236u, 
	238u, 255u, 9u, 10u, 13u, 32u, 194u, 225u, 
	226u, 227u, 9u, 13u, 32u, 194u, 225u, 226u, 
	227u, 9u, 32u, 194u, 225u, 226u, 227u, 9u, 
	10u, 32u, 194u, 225u, 226u, 227u, 9u, 10u, 
	13u, 32u, 194u, 225u, 226u, 227u, 13u, 9u, 
	10u, 13u, 32u, 194u, 225u, 226u, 227u, 10u, 
	9u, 10u, 13u, 32u, 194u, 225u, 226u, 227u, 
	13u, 32u, 33u, 34u, 40u, 58u, 59u, 64u, 
	93u, 95u, 125u, 194u, 224u, 225u, 226u, 227u, 
	239u, 9u, 10u, 36u, 37u, 39u, 41u, 42u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 45u, 
	46u, 47u, 58u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 39u, 41u, 61u, 95u, 36u, 47u, 
	48u, 57u, 58u, 59u, 63u, 64u, 65u, 90u, 
	97u, 122u, 47u, 48u, 57u, 45u, 46u, 47u, 
	58u, 48u, 57u, 65u, 90u, 97u, 122u, 45u, 
	46u, 47u, 58u, 48u, 57u, 65u, 90u, 97u, 
	122u, 45u, 46u, 47u, 58u, 48u, 57u, 65u, 
	90u, 97u, 122u, 45u, 46u, 47u, 58u, 48u, 
	57u, 65u, 90u, 97u, 122u, 45u, 46u, 47u, 
	53u, 58u, 48u, 52u, 54u, 57u, 65u, 90u, 
	97u, 122u, 45u, 46u, 47u, 58u, 48u, 53u, 
	54u, 57u, 65u, 90u, 97u, 122u, 33u, 58u, 
	64u, 95u, 36u, 37u, 39u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 39u, 58u, 64u, 
	84u, 95u, 116u, 226u, 36u, 37u, 40u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 58u, 
	64u, 95u, 36u, 37u, 39u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 58u, 64u, 95u, 
	36u, 37u, 39u, 46u, 48u, 57u, 65u, 90u, 
	97u, 122u, 13u, 32u, 33u, 34u, 40u, 46u, 
	58u, 59u, 64u, 93u, 95u, 125u, 194u, 224u, 
	225u, 226u, 227u, 239u, 9u, 10u, 36u, 37u, 
	39u, 41u, 42u, 45u, 48u, 57u, 65u, 90u, 
	97u, 122u, 33u, 44u, 45u, 46u, 58u, 64u, 
	69u, 95u, 101u, 217u, 219u, 223u, 224u, 225u, 
	234u, 239u, 240u, 36u, 37u, 39u, 43u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 44u, 46u, 
	58u, 64u, 69u, 95u, 101u, 36u, 37u, 39u, 
	45u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	58u, 64u, 69u, 95u, 101u, 217u, 219u, 223u, 
	224u, 225u, 234u, 239u, 240u, 36u, 37u, 39u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	58u, 64u, 95u, 217u, 219u, 223u, 224u, 225u, 
	234u, 239u, 240u, 36u, 37u, 39u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 217u, 219u, 223u, 
	224u, 225u, 234u, 239u, 240u, 48u, 57u, 69u, 
	101u, 217u, 219u, 223u, 224u, 225u, 234u, 239u, 
	240u, 48u, 57u, 44u, 46u, 69u, 101u, 33u, 
	45u, 46u, 47u, 58u, 64u, 95u, 36u, 37u, 
	39u, 44u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 47u, 64u, 95u, 36u, 37u, 39u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 47u, 58u, 64u, 95u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 58u, 64u, 69u, 95u, 101u, 217u, 
	219u, 223u, 224u, 225u, 234u, 239u, 240u, 36u, 
	37u, 39u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 45u, 46u, 58u, 64u, 69u, 95u, 
	101u, 217u, 219u, 223u, 224u, 225u, 234u, 239u, 
	240u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 217u, 219u, 223u, 224u, 225u, 234u, 239u, 
	240u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	69u, 95u, 101u, 217u, 219u, 223u, 224u, 225u, 
	234u, 239u, 240u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	58u, 64u, 69u, 95u, 101u, 217u, 219u, 223u, 
	224u, 225u, 234u, 239u, 240u, 36u, 37u, 39u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	45u, 46u, 53u, 58u, 64u, 69u, 95u, 101u, 
	217u, 219u, 223u, 224u, 225u, 234u, 239u, 240u, 
	36u, 37u, 39u, 44u, 48u, 52u, 54u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 58u, 
	64u, 69u, 95u, 101u, 217u, 219u, 223u, 224u, 
	225u, 234u, 239u, 240u, 36u, 37u, 39u, 44u, 
	48u, 53u, 54u, 57u, 65u, 90u, 97u, 122u, 
	33u, 44u, 45u, 46u, 58u, 64u, 69u, 95u, 
	101u, 217u, 219u, 223u, 224u, 225u, 234u, 239u, 
	240u, 36u, 37u, 39u, 43u, 48u, 57u, 65u, 
	90u, 97u, 122u, 33u, 45u, 46u, 58u, 64u, 
	95u, 217u, 219u, 223u, 224u, 225u, 234u, 239u, 
	240u, 36u, 37u, 39u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 44u, 46u, 69u, 101u, 217u, 
	219u, 223u, 224u, 225u, 234u, 239u, 240u, 48u, 
	57u, 33u, 44u, 45u, 46u, 58u, 64u, 69u, 
	95u, 101u, 217u, 219u, 223u, 224u, 225u, 234u, 
	239u, 240u, 36u, 37u, 39u, 43u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 44u, 45u, 46u, 
	58u, 64u, 69u, 95u, 101u, 217u, 219u, 223u, 
	224u, 225u, 234u, 239u, 240u, 36u, 37u, 39u, 
	43u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	44u, 45u, 46u, 53u, 58u, 64u, 69u, 95u, 
	101u, 217u, 219u, 223u, 224u, 225u, 234u, 239u, 
	240u, 36u, 37u, 39u, 43u, 48u, 52u, 54u, 
	57u, 65u, 90u, 97u, 122u, 33u, 44u, 45u, 
	46u, 58u, 64u, 69u, 95u, 101u, 217u, 219u, 
	223u, 224u, 225u, 234u, 239u, 240u, 36u, 37u, 
	39u, 43u, 48u, 53u, 54u, 57u, 65u, 90u, 
	97u, 122u, 13u, 32u, 34u, 39u, 41u, 59u, 
	93u, 125u, 194u, 224u, 225u, 226u, 227u, 239u, 
	9u, 10u, 33u, 39u, 45u, 46u, 58u, 64u, 
	78u, 95u, 110u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 40u, 44u, 48u, 57u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 33u, 39u, 
	45u, 58u, 64u, 68u, 76u, 77u, 78u, 82u, 
	83u, 86u, 95u, 100u, 108u, 109u, 110u, 114u, 
	115u, 118u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 40u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 39u, 58u, 
	64u, 78u, 95u, 110u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 40u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	39u, 45u, 58u, 64u, 78u, 95u, 110u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 36u, 37u, 40u, 46u, 
	48u, 57u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 33u, 39u, 45u, 58u, 64u, 78u, 
	95u, 110u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 40u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 39u, 45u, 
	58u, 64u, 68u, 76u, 77u, 78u, 82u, 83u, 
	84u, 86u, 95u, 100u, 108u, 109u, 110u, 114u, 
	115u, 116u, 118u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	36u, 37u, 40u, 46u, 48u, 57u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 33u, 39u, 
	45u, 58u, 64u, 78u, 95u, 110u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 40u, 46u, 48u, 
	57u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 39u, 45u, 78u, 110u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 39u, 45u, 68u, 76u, 77u, 78u, 
	82u, 83u, 86u, 100u, 108u, 109u, 110u, 114u, 
	115u, 118u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 39u, 
	78u, 110u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 39u, 
	45u, 78u, 110u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	39u, 45u, 68u, 76u, 77u, 78u, 82u, 83u, 
	84u, 86u, 100u, 108u, 109u, 110u, 114u, 115u, 
	116u, 118u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 39u, 
	45u, 78u, 110u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	39u, 45u, 68u, 76u, 77u, 78u, 82u, 83u, 
	86u, 100u, 108u, 109u, 110u, 114u, 115u, 118u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 39u, 45u, 78u, 
	110u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 65u, 90u, 
	97u, 122u, 196u, 218u, 229u, 236u, 39u, 45u, 
	76u, 78u, 108u, 110u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 39u, 45u, 78u, 110u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 65u, 90u, 97u, 122u, 196u, 218u, 
	229u, 236u, 39u, 45u, 69u, 78u, 101u, 110u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 39u, 45u, 76u, 
	78u, 108u, 110u, 194u, 195u, 203u, 205u, 206u, 
	207u, 210u, 212u, 213u, 214u, 215u, 216u, 217u, 
	219u, 220u, 221u, 222u, 223u, 224u, 225u, 226u, 
	227u, 228u, 233u, 234u, 237u, 239u, 240u, 243u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	39u, 45u, 78u, 110u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 39u, 45u, 69u, 78u, 101u, 110u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 39u, 45u, 68u, 76u, 
	77u, 78u, 82u, 83u, 84u, 86u, 100u, 108u, 
	109u, 110u, 114u, 115u, 116u, 118u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 65u, 90u, 97u, 122u, 196u, 
	218u, 229u, 236u, 33u, 39u, 45u, 58u, 64u, 
	76u, 78u, 95u, 108u, 110u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 40u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	33u, 39u, 45u, 58u, 64u, 78u, 95u, 110u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 40u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 196u, 
	218u, 229u, 236u, 33u, 39u, 45u, 58u, 64u, 
	69u, 78u, 95u, 101u, 110u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 40u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	33u, 39u, 45u, 58u, 64u, 78u, 95u, 110u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 40u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 196u, 
	218u, 229u, 236u, 33u, 39u, 45u, 46u, 58u, 
	64u, 78u, 95u, 110u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 40u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	39u, 45u, 46u, 58u, 64u, 78u, 95u, 110u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 40u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 196u, 
	218u, 229u, 236u, 33u, 39u, 45u, 46u, 58u, 
	64u, 78u, 95u, 110u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 40u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	39u, 45u, 46u, 58u, 64u, 78u, 95u, 110u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 40u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 196u, 
	218u, 229u, 236u, 33u, 45u, 46u, 47u, 58u, 
	64u, 95u, 36u, 37u, 39u, 44u, 48u, 57u, 
	65u, 90u, 97u, 122u, 33u, 45u, 46u, 47u, 
	58u, 64u, 95u, 36u, 37u, 39u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 33u, 45u, 46u, 
	47u, 58u, 64u, 95u, 36u, 37u, 39u, 44u, 
	48u, 57u, 65u, 90u, 97u, 122u, 33u, 45u, 
	46u, 47u, 53u, 58u, 64u, 95u, 36u, 37u, 
	39u, 44u, 48u, 52u, 54u, 57u, 65u, 90u, 
	97u, 122u, 33u, 45u, 46u, 47u, 58u, 64u, 
	95u, 36u, 37u, 39u, 44u, 48u, 53u, 54u, 
	57u, 65u, 90u, 97u, 122u, 33u, 39u, 45u, 
	46u, 58u, 64u, 78u, 95u, 110u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 40u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 33u, 39u, 45u, 46u, 58u, 64u, 78u, 
	95u, 110u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 40u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 39u, 45u, 
	46u, 58u, 64u, 65u, 78u, 95u, 97u, 110u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 40u, 
	44u, 48u, 57u, 66u, 90u, 98u, 122u, 196u, 
	218u, 229u, 236u, 33u, 39u, 45u, 46u, 58u, 
	64u, 78u, 95u, 110u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 40u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	39u, 45u, 46u, 58u, 64u, 78u, 95u, 110u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 40u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 196u, 
	218u, 229u, 236u, 33u, 39u, 45u, 46u, 58u, 
	64u, 78u, 79u, 95u, 110u, 111u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 40u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 33u, 39u, 45u, 46u, 58u, 64u, 78u, 
	84u, 95u, 110u, 116u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 40u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	39u, 45u, 46u, 58u, 64u, 78u, 95u, 110u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 40u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 196u, 
	218u, 229u, 236u, 33u, 39u, 45u, 46u, 58u, 
	64u, 78u, 95u, 110u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 40u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	39u, 45u, 58u, 64u, 68u, 76u, 77u, 78u, 
	82u, 83u, 86u, 89u, 95u, 100u, 108u, 109u, 
	110u, 114u, 115u, 118u, 121u, 194u, 195u, 203u, 
	205u, 206u, 207u, 210u, 212u, 213u, 214u, 215u, 
	216u, 217u, 219u, 220u, 221u, 222u, 223u, 224u, 
	225u, 226u, 227u, 228u, 233u, 234u, 237u, 239u, 
	240u, 243u, 36u, 37u, 40u, 46u, 48u, 57u, 
	65u, 90u, 97u, 122u, 196u, 218u, 229u, 236u, 
	33u, 39u, 45u, 58u, 64u, 69u, 78u, 95u, 
	101u, 110u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 40u, 46u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 39u, 45u, 68u, 
	76u, 77u, 78u, 82u, 83u, 86u, 89u, 100u, 
	108u, 109u, 110u, 114u, 115u, 118u, 121u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 39u, 45u, 69u, 78u, 
	101u, 110u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	39u, 45u, 46u, 58u, 64u, 73u, 78u, 79u, 
	95u, 105u, 110u, 111u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 40u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	39u, 45u, 46u, 58u, 64u, 77u, 78u, 95u, 
	109u, 110u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 40u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 39u, 45u, 
	46u, 58u, 64u, 77u, 78u, 95u, 109u, 110u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 40u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 196u, 
	218u, 229u, 236u, 33u, 39u, 45u, 46u, 58u, 
	64u, 69u, 78u, 95u, 101u, 110u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 40u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 33u, 39u, 45u, 46u, 58u, 64u, 78u, 
	95u, 110u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 40u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 39u, 45u, 
	46u, 58u, 64u, 78u, 84u, 95u, 110u, 116u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 40u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 196u, 
	218u, 229u, 236u, 33u, 39u, 45u, 46u, 58u, 
	64u, 78u, 95u, 110u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 40u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	39u, 45u, 46u, 58u, 64u, 65u, 78u, 95u, 
	97u, 110u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 40u, 44u, 48u, 57u, 66u, 90u, 98u, 
	122u, 196u, 218u, 229u, 236u, 33u, 39u, 45u, 
	46u, 58u, 64u, 78u, 84u, 95u, 110u, 116u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 40u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 196u, 
	218u, 229u, 236u, 33u, 39u, 45u, 46u, 58u, 
	64u, 65u, 78u, 95u, 97u, 110u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 40u, 44u, 48u, 
	57u, 66u, 90u, 98u, 122u, 196u, 218u, 229u, 
	236u, 33u, 39u, 45u, 46u, 58u, 64u, 69u, 
	78u, 95u, 101u, 110u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 40u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 33u, 
	39u, 45u, 46u, 58u, 64u, 78u, 79u, 95u, 
	110u, 111u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 40u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 39u, 45u, 
	46u, 58u, 64u, 78u, 82u, 95u, 110u, 114u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 40u, 
	44u, 48u, 57u, 65u, 90u, 97u, 122u, 196u, 
	218u, 229u, 236u, 33u, 39u, 45u, 46u, 58u, 
	64u, 69u, 78u, 95u, 101u, 110u, 194u, 195u, 
	203u, 205u, 206u, 207u, 210u, 212u, 213u, 214u, 
	215u, 216u, 217u, 219u, 220u, 221u, 222u, 223u, 
	224u, 225u, 226u, 227u, 228u, 233u, 234u, 237u, 
	239u, 240u, 243u, 36u, 37u, 40u, 44u, 48u, 
	57u, 65u, 90u, 97u, 122u, 196u, 218u, 229u, 
	236u, 33u, 39u, 45u, 46u, 58u, 64u, 78u, 
	95u, 110u, 194u, 195u, 203u, 205u, 206u, 207u, 
	210u, 212u, 213u, 214u, 215u, 216u, 217u, 219u, 
	220u, 221u, 222u, 223u, 224u, 225u, 226u, 227u, 
	228u, 233u, 234u, 237u, 239u, 240u, 243u, 36u, 
	37u, 40u, 44u, 48u, 57u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 39u, 45u, 
	58u, 64u, 68u, 76u, 77u, 78u, 82u, 83u, 
	86u, 95u, 100u, 108u, 109u, 110u, 114u, 115u, 
	118u, 194u, 195u, 203u, 205u, 206u, 207u, 210u, 
	212u, 213u, 214u, 215u, 216u, 217u, 219u, 220u, 
	221u, 222u, 223u, 224u, 225u, 226u, 227u, 228u, 
	233u, 234u, 237u, 239u, 240u, 243u, 36u, 37u, 
	40u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 33u, 39u, 45u, 58u, 
	64u, 78u, 95u, 110u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 40u, 46u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 39u, 
	45u, 68u, 76u, 77u, 78u, 82u, 83u, 86u, 
	100u, 108u, 109u, 110u, 114u, 115u, 118u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 65u, 90u, 97u, 122u, 
	196u, 218u, 229u, 236u, 39u, 45u, 78u, 110u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 65u, 90u, 97u, 
	122u, 196u, 218u, 229u, 236u, 33u, 39u, 45u, 
	46u, 58u, 64u, 65u, 78u, 95u, 97u, 110u, 
	194u, 195u, 203u, 205u, 206u, 207u, 210u, 212u, 
	213u, 214u, 215u, 216u, 217u, 219u, 220u, 221u, 
	222u, 223u, 224u, 225u, 226u, 227u, 228u, 233u, 
	234u, 237u, 239u, 240u, 243u, 36u, 37u, 40u, 
	44u, 48u, 57u, 66u, 90u, 98u, 122u, 196u, 
	218u, 229u, 236u, 33u, 39u, 45u, 46u, 58u, 
	64u, 78u, 95u, 110u, 194u, 195u, 203u, 205u, 
	206u, 207u, 210u, 212u, 213u, 214u, 215u, 216u, 
	217u, 219u, 220u, 221u, 222u, 223u, 224u, 225u, 
	226u, 227u, 228u, 233u, 234u, 237u, 239u, 240u, 
	243u, 36u, 37u, 40u, 44u, 48u, 57u, 65u, 
	90u, 97u, 122u, 196u, 218u, 229u, 236u, 96u, 
	226u, 128u, 191u, 160u, 170u, 181u, 186u, 128u, 
	191u, 9u, 10u, 13u, 32u, 194u, 225u, 226u, 
	227u, 128u, 191u, 39u, 45u, 78u, 110u, 194u, 
	195u, 203u, 205u, 206u, 207u, 210u, 212u, 213u, 
	214u, 215u, 216u, 217u, 219u, 220u, 221u, 222u, 
	223u, 224u, 225u, 226u, 227u, 228u, 233u, 234u, 
	237u, 239u, 240u, 243u, 65u, 90u, 97u, 122u, 
	128u, 191u, 196u, 218u, 229u, 236u, 151u, 183u, 
	128u, 191u, 128u, 191u, 172u, 174u, 128u, 129u, 
	130u, 133u, 134u, 145u, 146u, 159u, 160u, 164u, 
	165u, 191u, 181u, 190u, 128u, 175u, 176u, 183u, 
	184u, 185u, 186u, 191u, 134u, 139u, 141u, 162u, 
	128u, 135u, 136u, 191u, 182u, 128u, 191u, 128u, 
	129u, 130u, 137u, 138u, 191u, 176u, 128u, 191u, 
	153u, 128u, 150u, 151u, 160u, 161u, 191u, 128u, 
	135u, 136u, 191u, 128u, 143u, 144u, 170u, 171u, 
	175u, 176u, 178u, 179u, 191u, 128u, 159u, 160u, 
	191u, 176u, 128u, 138u, 139u, 159u, 160u, 169u, 
	170u, 173u, 174u, 191u, 44u, 46u, 69u, 101u, 
	217u, 219u, 223u, 224u, 225u, 234u, 239u, 240u, 
	48u, 57u, 128u, 191u, 148u, 191u, 128u, 149u, 
	150u, 164u, 165u, 166u, 167u, 173u, 174u, 175u, 
	176u, 185u, 186u, 188u, 189u, 190u, 144u, 128u, 
	145u, 146u, 175u, 176u, 191u, 128u, 140u, 141u, 
	191u, 177u, 128u, 165u, 166u, 191u, 186u, 128u, 
	137u, 138u, 170u, 171u, 179u, 180u, 181u, 182u, 
	191u, 160u, 161u, 162u, 164u, 165u, 166u, 167u, 
	168u, 169u, 170u, 171u, 172u, 173u, 174u, 175u, 
	176u, 177u, 178u, 179u, 180u, 181u, 182u, 183u, 
	184u, 185u, 186u, 187u, 188u, 189u, 190u, 128u, 
	191u, 154u, 164u, 168u, 128u, 149u, 150u, 191u, 
	128u, 152u, 153u, 191u, 128u, 159u, 160u, 178u, 
	179u, 191u, 189u, 128u, 131u, 132u, 185u, 186u, 
	191u, 144u, 176u, 128u, 151u, 152u, 161u, 162u, 
	165u, 166u, 175u, 177u, 191u, 128u, 169u, 177u, 
	189u, 129u, 132u, 133u, 140u, 141u, 142u, 143u, 
	144u, 145u, 146u, 147u, 178u, 179u, 181u, 182u, 
	185u, 186u, 191u, 142u, 158u, 128u, 155u, 156u, 
	161u, 162u, 165u, 166u, 175u, 176u, 177u, 178u, 
	191u, 169u, 177u, 180u, 183u, 128u, 132u, 133u, 
	138u, 139u, 142u, 143u, 144u, 145u, 146u, 147u, 
	185u, 186u, 191u, 157u, 128u, 152u, 153u, 158u, 
	159u, 165u, 166u, 175u, 176u, 177u, 178u, 180u, 
	181u, 191u, 142u, 146u, 169u, 177u, 180u, 189u, 
	128u, 132u, 133u, 185u, 186u, 191u, 144u, 128u, 
	159u, 160u, 161u, 162u, 165u, 166u, 175u, 176u, 
	191u, 169u, 177u, 180u, 189u, 128u, 132u, 133u, 
	140u, 141u, 142u, 143u, 144u, 145u, 146u, 147u, 
	185u, 186u, 191u, 158u, 177u, 128u, 155u, 156u, 
	161u, 162u, 165u, 166u, 175u, 176u, 191u, 131u, 
	145u, 155u, 157u, 128u, 132u, 133u, 138u, 139u, 
	141u, 142u, 149u, 150u, 152u, 153u, 159u, 160u, 
	162u, 163u, 164u, 165u, 167u, 168u, 170u, 171u, 
	173u, 174u, 185u, 186u, 191u, 144u, 128u, 165u, 
	166u, 175u, 176u, 191u, 141u, 145u, 169u, 189u, 
	128u, 132u, 133u, 185u, 186u, 191u, 128u, 151u, 
	152u, 153u, 154u, 159u, 160u, 161u, 162u, 165u, 
	166u, 175u, 176u, 191u, 141u, 145u, 169u, 180u, 
	189u, 128u, 132u, 133u, 185u, 186u, 191u, 158u, 
	176u, 128u, 159u, 160u, 161u, 162u, 165u, 166u, 
	175u, 177u, 178u, 179u, 191u, 141u, 145u, 189u, 
	128u, 132u, 133u, 186u, 187u, 191u, 142u, 128u, 
	159u, 160u, 161u, 162u, 165u, 166u, 175u, 176u, 
	185u, 186u, 191u, 178u, 188u, 128u, 132u, 133u, 
	150u, 151u, 153u, 154u, 189u, 190u, 191u, 128u, 
	134u, 135u, 165u, 166u, 175u, 176u, 191u, 128u, 
	177u, 129u, 179u, 180u, 191u, 128u, 134u, 135u, 
	143u, 144u, 153u, 154u, 191u, 128u, 131u, 137u, 
	141u, 152u, 160u, 164u, 166u, 172u, 177u, 189u, 
	129u, 132u, 133u, 134u, 135u, 138u, 139u, 147u, 
	148u, 167u, 168u, 169u, 170u, 179u, 180u, 191u, 
	133u, 128u, 134u, 135u, 143u, 144u, 153u, 154u, 
	155u, 156u, 159u, 160u, 191u, 128u, 129u, 159u, 
	160u, 169u, 170u, 191u, 136u, 128u, 172u, 173u, 
	191u, 128u, 135u, 136u, 140u, 141u, 191u, 128u, 
	129u, 130u, 131u, 137u, 138u, 139u, 140u, 141u, 
	142u, 143u, 144u, 153u, 154u, 155u, 156u, 157u, 
	158u, 159u, 160u, 161u, 162u, 163u, 164u, 165u, 
	166u, 167u, 168u, 169u, 170u, 171u, 172u, 173u, 
	174u, 175u, 176u, 177u, 178u, 179u, 183u, 188u, 
	189u, 190u, 191u, 132u, 187u, 191u, 128u, 170u, 
	171u, 190u, 161u, 128u, 137u, 138u, 143u, 144u, 
	149u, 150u, 153u, 154u, 157u, 158u, 164u, 165u, 
	166u, 167u, 173u, 174u, 176u, 177u, 180u, 181u, 
	191u, 142u, 128u, 129u, 130u, 143u, 144u, 153u, 
	154u, 159u, 160u, 191u, 134u, 141u, 187u, 128u, 
	135u, 136u, 143u, 144u, 191u, 137u, 151u, 153u, 
	128u, 141u, 142u, 143u, 144u, 157u, 158u, 159u, 
	160u, 191u, 137u, 177u, 191u, 128u, 141u, 142u, 
	143u, 144u, 181u, 182u, 183u, 184u, 190u, 129u, 
	151u, 128u, 133u, 134u, 135u, 136u, 191u, 145u, 
	128u, 149u, 150u, 151u, 152u, 191u, 128u, 154u, 
	155u, 191u, 128u, 143u, 144u, 159u, 160u, 191u, 
	128u, 180u, 181u, 191u, 128u, 129u, 191u, 128u, 
	172u, 173u, 174u, 175u, 191u, 128u, 129u, 154u, 
	155u, 159u, 160u, 191u, 128u, 170u, 171u, 176u, 
	177u, 184u, 185u, 191u, 141u, 128u, 145u, 146u, 
	159u, 160u, 177u, 178u, 191u, 173u, 128u, 145u, 
	146u, 159u, 160u, 176u, 177u, 191u, 128u, 179u, 
	180u, 191u, 151u, 156u, 128u, 159u, 160u, 169u, 
	170u, 191u, 128u, 143u, 144u, 153u, 154u, 159u, 
	160u, 191u, 128u, 183u, 184u, 191u, 169u, 128u, 
	170u, 171u, 175u, 176u, 191u, 128u, 181u, 182u, 
	191u, 128u, 158u, 159u, 191u, 128u, 133u, 134u, 
	143u, 144u, 173u, 174u, 175u, 176u, 180u, 181u, 
	191u, 128u, 171u, 172u, 191u, 128u, 129u, 135u, 
	136u, 143u, 144u, 153u, 154u, 191u, 128u, 150u, 
	151u, 159u, 160u, 191u, 128u, 148u, 149u, 191u, 
	167u, 128u, 137u, 138u, 143u, 144u, 153u, 154u, 
	191u, 128u, 132u, 133u, 179u, 180u, 191u, 128u, 
	132u, 133u, 139u, 140u, 143u, 144u, 153u, 154u, 
	191u, 128u, 130u, 131u, 160u, 161u, 173u, 174u, 
	175u, 176u, 185u, 186u, 191u, 128u, 165u, 166u, 
	191u, 128u, 163u, 164u, 191u, 128u, 137u, 138u, 
	140u, 141u, 143u, 144u, 153u, 154u, 189u, 190u, 
	191u, 173u, 128u, 168u, 169u, 177u, 178u, 180u, 
	181u, 182u, 183u, 191u, 128u, 149u, 150u, 151u, 
	152u, 157u, 158u, 159u, 160u, 191u, 152u, 154u, 
	156u, 158u, 128u, 133u, 134u, 135u, 136u, 141u, 
	142u, 143u, 144u, 189u, 190u, 191u, 181u, 189u, 
	191u, 128u, 190u, 133u, 181u, 128u, 129u, 130u, 
	140u, 141u, 143u, 144u, 147u, 148u, 149u, 150u, 
	155u, 156u, 159u, 160u, 172u, 173u, 177u, 178u, 
	188u, 189u, 191u, 128u, 129u, 130u, 132u, 133u, 
	134u, 176u, 177u, 178u, 179u, 180u, 181u, 182u, 
	183u, 184u, 131u, 191u, 152u, 153u, 166u, 175u, 
	128u, 138u, 139u, 191u, 96u, 226u, 128u, 191u, 
	39u, 84u, 116u, 226u, 128u, 191u, 13u, 32u, 
	34u, 39u, 41u, 59u, 93u, 125u, 194u, 224u, 
	225u, 226u, 227u, 239u, 9u, 10u, 128u, 191u, 
	159u, 177u, 191u, 128u, 190u, 128u, 143u, 144u, 
	156u, 157u, 191u, 130u, 135u, 148u, 164u, 166u, 
	168u, 174u, 128u, 137u, 138u, 149u, 150u, 152u, 
	153u, 157u, 158u, 169u, 170u, 185u, 186u, 187u, 
	188u, 191u, 142u, 128u, 132u, 133u, 137u, 138u, 
	191u, 128u, 130u, 131u, 132u, 133u, 191u, 175u, 
	128u, 191u, 159u, 128u, 191u, 128u, 164u, 165u, 
	170u, 171u, 174u, 175u, 177u, 178u, 179u, 180u, 
	191u, 166u, 173u, 128u, 167u, 168u, 175u, 176u, 
	191u, 175u, 128u, 167u, 168u, 191u, 167u, 175u, 
	183u, 191u, 128u, 150u, 151u, 159u, 160u, 190u, 
	135u, 143u, 151u, 128u, 158u, 159u, 191u, 175u, 
	128u, 191u, 128u, 129u, 130u, 131u, 132u, 133u, 
	134u, 135u, 136u, 143u, 144u, 191u, 128u, 129u, 
	132u, 133u, 134u, 135u, 176u, 177u, 181u, 182u, 
	186u, 187u, 188u, 189u, 191u, 160u, 128u, 150u, 
	151u, 156u, 157u, 191u, 187u, 128u, 191u, 128u, 
	132u, 133u, 173u, 174u, 176u, 177u, 191u, 128u, 
	142u, 143u, 159u, 160u, 186u, 187u, 191u, 128u, 
	175u, 176u, 191u, 182u, 183u, 128u, 191u, 128u, 
	191u, 191u, 128u, 190u, 128u, 140u, 141u, 191u, 
	146u, 147u, 152u, 153u, 154u, 155u, 156u, 158u, 
	159u, 160u, 161u, 162u, 163u, 164u, 165u, 166u, 
	167u, 168u, 169u, 170u, 171u, 172u, 173u, 174u, 
	175u, 128u, 191u, 128u, 143u, 144u, 189u, 190u, 
	191u, 128u, 140u, 141u, 143u, 144u, 159u, 160u, 
	169u, 170u, 171u, 172u, 191u, 191u, 128u, 174u, 
	175u, 190u, 128u, 157u, 158u, 159u, 160u, 191u, 
	128u, 150u, 151u, 159u, 160u, 161u, 162u, 191u, 
	143u, 128u, 136u, 137u, 138u, 139u, 173u, 174u, 
	175u, 176u, 177u, 178u, 191u, 128u, 182u, 183u, 
	191u, 130u, 134u, 139u, 128u, 162u, 163u, 191u, 
	128u, 129u, 130u, 179u, 180u, 191u, 187u, 128u, 
	143u, 144u, 153u, 154u, 177u, 178u, 183u, 184u, 
	191u, 128u, 137u, 138u, 165u, 166u, 175u, 176u, 
	191u, 128u, 134u, 135u, 159u, 160u, 188u, 189u, 
	191u, 128u, 131u, 132u, 178u, 179u, 191u, 143u, 
	165u, 191u, 128u, 142u, 144u, 153u, 154u, 159u, 
	160u, 175u, 176u, 185u, 186u, 190u, 128u, 168u, 
	169u, 191u, 131u, 186u, 128u, 139u, 140u, 143u, 
	144u, 153u, 154u, 159u, 160u, 182u, 183u, 189u, 
	190u, 191u, 176u, 128u, 177u, 178u, 180u, 181u, 
	182u, 183u, 184u, 185u, 189u, 190u, 191u, 129u, 
	128u, 130u, 131u, 154u, 155u, 157u, 158u, 159u, 
	160u, 170u, 171u, 177u, 178u, 180u, 181u, 191u, 
	128u, 167u, 175u, 129u, 134u, 135u, 136u, 137u, 
	142u, 143u, 144u, 145u, 150u, 151u, 159u, 160u, 
	191u, 155u, 128u, 159u, 160u, 163u, 164u, 165u, 
	166u, 191u, 128u, 162u, 163u, 175u, 176u, 185u, 
	186u, 191u, 158u, 159u, 128u, 157u, 160u, 191u, 
	128u, 163u, 164u, 175u, 176u, 191u, 128u, 134u, 
	135u, 138u, 139u, 187u, 188u, 191u, 169u, 171u, 
	172u, 173u, 174u, 175u, 180u, 181u, 182u, 183u, 
	184u, 185u, 187u, 188u, 189u, 190u, 191u, 128u, 
	163u, 164u, 186u, 128u, 173u, 174u, 175u, 176u, 
	191u, 128u, 153u, 154u, 191u, 157u, 169u, 183u, 
	189u, 191u, 128u, 134u, 135u, 146u, 147u, 151u, 
	152u, 158u, 159u, 190u, 130u, 133u, 128u, 191u, 
	128u, 177u, 178u, 191u, 128u, 146u, 147u, 191u, 
	128u, 189u, 190u, 191u, 128u, 143u, 144u, 191u, 
	128u, 143u, 144u, 145u, 146u, 191u, 128u, 135u, 
	136u, 175u, 176u, 187u, 188u, 191u, 181u, 128u, 
	175u, 176u, 191u, 128u, 188u, 189u, 191u, 128u, 
	143u, 144u, 153u, 154u, 160u, 161u, 186u, 187u, 
	191u, 128u, 129u, 154u, 155u, 165u, 166u, 191u, 
	191u, 128u, 190u, 128u, 129u, 130u, 135u, 136u, 
	137u, 138u, 143u, 144u, 145u, 146u, 151u, 152u, 
	153u, 154u, 156u, 157u, 191u, 144u, 145u, 146u, 
	147u, 150u, 155u, 157u, 158u, 170u, 171u, 175u, 
	128u, 159u, 160u, 169u, 172u, 191u, 128u, 129u, 
	130u, 131u, 138u, 139u, 140u, 141u, 142u, 143u, 
	146u, 148u, 149u, 156u, 157u, 160u, 161u, 162u, 
	164u, 166u, 168u, 169u, 170u, 171u, 172u, 173u, 
	174u, 176u, 177u, 132u, 137u, 144u, 145u, 147u, 
	151u, 152u, 155u, 158u, 191u, 140u, 167u, 187u, 
	190u, 128u, 191u, 128u, 141u, 142u, 143u, 144u, 
	157u, 158u, 191u, 128u, 186u, 187u, 191u, 128u, 
	156u, 157u, 159u, 160u, 191u, 128u, 144u, 145u, 
	191u, 128u, 159u, 160u, 175u, 176u, 191u, 129u, 
	128u, 137u, 138u, 143u, 144u, 181u, 182u, 191u, 
	128u, 131u, 132u, 135u, 136u, 143u, 144u, 191u, 
	128u, 157u, 158u, 159u, 160u, 169u, 170u, 191u, 
	128u, 167u, 168u, 175u, 176u, 191u, 128u, 182u, 
	183u, 191u, 128u, 149u, 150u, 159u, 160u, 167u, 
	168u, 191u, 136u, 182u, 188u, 191u, 128u, 133u, 
	134u, 137u, 138u, 184u, 185u, 190u, 128u, 149u, 
	150u, 159u, 160u, 182u, 183u, 191u, 128u, 149u, 
	150u, 159u, 160u, 185u, 186u, 191u, 128u, 183u, 
	184u, 189u, 190u, 191u, 128u, 148u, 152u, 129u, 
	143u, 144u, 179u, 180u, 191u, 128u, 159u, 160u, 
	188u, 189u, 191u, 128u, 156u, 157u, 191u, 136u, 
	128u, 164u, 165u, 191u, 128u, 149u, 150u, 159u, 
	160u, 178u, 179u, 191u, 128u, 145u, 146u, 191u, 
	128u, 136u, 137u, 191u, 128u, 129u, 130u, 131u, 
	132u, 133u, 134u, 135u, 136u, 138u, 139u, 140u, 
	141u, 146u, 147u, 150u, 152u, 153u, 154u, 155u, 
	162u, 163u, 171u, 137u, 191u, 128u, 130u, 131u, 
	183u, 184u, 191u, 128u, 165u, 166u, 175u, 176u, 
	191u, 128u, 130u, 131u, 175u, 176u, 191u, 128u, 
	143u, 144u, 168u, 169u, 175u, 176u, 185u, 186u, 
	191u, 128u, 130u, 131u, 166u, 167u, 181u, 182u, 
	191u, 182u, 128u, 143u, 144u, 178u, 179u, 191u, 
	128u, 130u, 131u, 178u, 179u, 191u, 128u, 154u, 
	129u, 132u, 133u, 143u, 144u, 153u, 155u, 191u, 
	146u, 128u, 171u, 172u, 191u, 128u, 158u, 159u, 
	175u, 176u, 185u, 186u, 191u, 128u, 156u, 157u, 
	161u, 162u, 191u, 128u, 175u, 176u, 191u, 134u, 
	128u, 131u, 132u, 135u, 136u, 143u, 144u, 153u, 
	154u, 191u, 128u, 174u, 175u, 191u, 132u, 128u, 
	143u, 144u, 153u, 154u, 191u, 128u, 170u, 171u, 
	191u, 128u, 137u, 138u, 191u, 191u, 128u, 159u, 
	160u, 169u, 170u, 190u, 128u, 184u, 185u, 191u, 
	142u, 128u, 141u, 143u, 191u, 144u, 128u, 143u, 
	145u, 191u, 168u, 169u, 171u, 172u, 173u, 174u, 
	188u, 189u, 190u, 128u, 159u, 160u, 167u, 170u, 
	191u, 159u, 128u, 158u, 160u, 169u, 170u, 191u, 
	128u, 143u, 144u, 173u, 174u, 191u, 128u, 131u, 
	132u, 143u, 144u, 153u, 154u, 162u, 163u, 183u, 
	184u, 188u, 189u, 191u, 128u, 143u, 144u, 191u, 
	144u, 128u, 132u, 133u, 191u, 128u, 146u, 147u, 
	159u, 160u, 191u, 128u, 176u, 177u, 178u, 129u, 
	191u, 128u, 129u, 130u, 191u, 128u, 170u, 171u, 
	175u, 176u, 188u, 189u, 191u, 128u, 136u, 137u, 
	143u, 144u, 153u, 154u, 191u, 145u, 146u, 147u, 
	148u, 149u, 154u, 155u, 156u, 157u, 158u, 159u, 
	128u, 143u, 144u, 153u, 160u, 191u, 149u, 128u, 
	191u, 157u, 162u, 173u, 186u, 188u, 128u, 159u, 
	160u, 164u, 165u, 166u, 167u, 168u, 169u, 191u, 
	132u, 128u, 191u, 134u, 149u, 157u, 186u, 191u, 
	128u, 138u, 139u, 140u, 141u, 190u, 133u, 145u, 
	128u, 134u, 135u, 137u, 138u, 191u, 128u, 165u, 
	166u, 167u, 168u, 191u, 129u, 155u, 187u, 128u, 
	191u, 149u, 181u, 128u, 191u, 143u, 175u, 128u, 
	191u, 137u, 169u, 128u, 191u, 131u, 128u, 139u, 
	140u, 141u, 142u, 191u, 163u, 184u, 185u, 186u, 
	128u, 159u, 160u, 162u, 164u, 191u, 128u, 132u, 
	133u, 191u, 132u, 160u, 163u, 167u, 179u, 184u, 
	186u, 128u, 164u, 165u, 168u, 169u, 187u, 188u, 
	191u, 130u, 135u, 137u, 139u, 144u, 147u, 151u, 
	153u, 155u, 157u, 159u, 163u, 171u, 179u, 184u, 
	189u, 191u, 128u, 140u, 141u, 148u, 149u, 160u, 
	161u, 164u, 165u, 166u, 167u, 190u, 138u, 164u, 
	170u, 128u, 155u, 156u, 160u, 161u, 187u, 188u, 
	191u, 155u, 128u, 191u, 128u, 150u, 151u, 191u, 
	156u, 160u, 128u, 159u, 161u, 191u, 128u, 157u, 
	158u, 191u, 168u, 128u, 159u, 160u, 167u, 169u, 
	191u, 33u, 45u, 58u, 64u, 95u, 36u, 37u, 
	39u, 46u, 48u, 57u, 65u, 90u, 97u, 122u, 
	33u, 45u, 58u, 64u, 95u, 217u, 219u, 223u, 
	224u, 225u, 234u, 239u, 240u, 36u, 37u, 39u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 33u, 
	44u, 46u, 58u, 64u, 69u, 95u, 101u, 217u, 
	219u, 223u, 224u, 225u, 234u, 239u, 240u, 36u, 
	37u, 39u, 45u, 48u, 57u, 65u, 90u, 97u, 
	122u, 33u, 58u, 64u, 95u, 217u, 219u, 223u, 
	224u, 225u, 234u, 239u, 240u, 36u, 37u, 39u, 
	46u, 48u, 57u, 65u, 90u, 97u, 122u, 0
};

static const char _english_tokenizer_single_lengths[] = {
	0, 1, 1, 1, 2, 1, 1, 1, 
	31, 29, 1, 0, 32, 29, 7, 21, 
	26, 5, 4, 2, 15, 0, 16, 28, 
	30, 24, 0, 1, 2, 8, 0, 2, 
	1, 32, 28, 0, 4, 0, 0, 17, 
	2, 2, 1, 6, 1, 1, 3, 7, 
	6, 11, 3, 0, 6, 21, 10, 1, 
	1, 10, 5, 23, 14, 14, 26, 18, 
	5, 1, 7, 6, 2, 3, 3, 1, 
	0, 1, 16, 0, 0, 2, 0, 0, 
	1, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 1, 2, 8, 2, 17, 3, 
	3, 1, 11, 4, 2, 3, 3, 2, 
	1, 2, 0, 2, 5, 0, 2, 3, 
	2, 3, 2, 3, 2, 2, 3, 2, 
	2, 2, 3, 2, 2, 2, 3, 2, 
	14, 2, 1, 2, 1, 2, 9, 4, 
	3, 1, 3, 7, 6, 11, 3, 10, 
	1, 10, 5, 1, 6, 7, 2, 3, 
	17, 8, 6, 6, 6, 1, 1, 5, 
	12, 12, 12, 12, 14, 12, 0, 0, 
	0, 13, 0, 0, 10, 0, 0, 6, 
	0, 1, 4, 1, 9, 0, 2, 1, 
	0, 0, 10, 8, 0, 0, 13, 0, 
	0, 10, 0, 0, 6, 0, 1, 4, 
	1, 9, 0, 2, 1, 0, 0, 8, 
	8, 8, 0, 0, 13, 0, 0, 10, 
	0, 0, 6, 0, 1, 4, 1, 9, 
	0, 2, 1, 0, 0, 0, 0, 13, 
	0, 0, 10, 0, 0, 6, 0, 1, 
	4, 1, 9, 0, 2, 1, 0, 0, 
	0, 0, 13, 0, 0, 10, 0, 0, 
	6, 0, 1, 4, 1, 9, 0, 2, 
	1, 0, 8, 5, 6, 4, 6, 5, 
	4, 6, 2, 6, 6, 7, 6, 7, 
	15, 7, 6, 7, 7, 7, 7, 8, 
	7, 6, 6, 7, 6, 15, 13, 12, 
	15, 13, 0, 0, 0, 13, 0, 0, 
	10, 0, 0, 6, 0, 1, 4, 1, 
	9, 0, 2, 1, 0, 16, 6, 6, 
	3, 12, 2, 2, 0, 0, 2, 1, 
	2, 0, 0, 0, 1, 1, 1, 0, 
	0, 1, 0, 0, 0, 1, 32, 0, 
	0, 0, 0, 0, 1, 1, 1, 2, 
	0, 1, 0, 1, 1, 2, 0, 0, 
	0, 1, 0, 1, 1, 2, 0, 0, 
	5, 1, 4, 0, 0, 1, 40, 0, 
	2, 1, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 1, 0, 0, 0, 0, 0, 0, 
	0, 3, 1, 0, 16, 1, 8, 0, 
	0, 0, 0, 0, 0, 1, 0, 1, 
	0, 21, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 2, 0, 
	0, 0, 0, 0, 0, 2, 0, 0, 
	17, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	11, 30, 1, 0, 0, 1, 0, 1, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	3, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 21, 1, 0, 1, 
	1, 0, 0, 1, 1, 0, 1, 2, 
	0, 1, 0, 1, 0, 1, 0, 9, 
	0, 0, 0, 0, 4, 0, 0, 0, 
	14, 0, 0, 0, 0, 2, 0, 0, 
	1, 0, 1, 0, 0, 0, 0, 4, 
	0, 4, 12, 0, 1, 0, 2, 1, 
	1, 1, 0, 16, 1, 12, 2, 2, 
	2, 0, 0, 6, 1, 0, 0, 0, 
	0, 2, 2, 0, 0, 1, 16, 1, 
	3, 1, 5, 6, 7, 6, 7, 6, 
	7, 6, 6, 7, 6, 6, 6, 7, 
	6, 6, 6, 7, 6, 16, 1, 16, 
	1, 1, 1, 4, 2, 2, 2, 61, 
	8, 7, 6, 7, 8, 1, 8, 1, 
	8, 17, 4, 5, 1, 4, 4, 4, 
	4, 5, 4, 4, 8, 4, 4, 18, 
	17, 8, 14, 12, 8, 10, 4, 7, 
	4, 7, 16, 16, 14, 16, 16, 17, 
	16, 17, 14, 12, 17, 17, 18, 17, 
	14, 38, 49, 36, 37, 37, 51, 37, 
	33, 45, 0, 0, 32, 33, 47, 33, 
	45, 33, 35, 33, 35, 0, 0, 35, 
	33, 35, 47, 39, 37, 39, 37, 38, 
	38, 38, 38, 7, 7, 7, 8, 7, 
	38, 38, 40, 38, 38, 40, 40, 38, 
	38, 51, 39, 47, 35, 42, 40, 40, 
	40, 38, 40, 38, 40, 40, 40, 40, 
	40, 40, 40, 38, 49, 37, 45, 33, 
	40, 38, 2, 0, 4, 8, 33, 2, 
	0, 2, 2, 4, 1, 0, 1, 1, 
	0, 0, 0, 1, 12, 2, 1, 0, 
	1, 1, 30, 3, 0, 0, 1, 2, 
	4, 2, 4, 1, 6, 1, 4, 2, 
	4, 1, 4, 0, 5, 2, 3, 1, 
	2, 0, 2, 0, 11, 1, 1, 1, 
	0, 44, 1, 1, 1, 3, 3, 3, 
	2, 1, 0, 0, 0, 1, 0, 1, 
	0, 1, 1, 0, 2, 0, 0, 1, 
	0, 0, 0, 0, 1, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	4, 3, 2, 15, 4, 2, 4, 14, 
	3, 0, 7, 1, 0, 1, 1, 0, 
	2, 1, 4, 3, 1, 8, 1, 1, 
	1, 0, 0, 0, 2, 0, 1, 0, 
	25, 0, 0, 1, 0, 0, 1, 0, 
	3, 0, 1, 0, 0, 0, 3, 0, 
	2, 1, 1, 3, 1, 0, 2, 0, 
	0, 17, 0, 0, 5, 2, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 1, 
	1, 0, 11, 29, 4, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	4, 0, 0, 0, 3, 0, 0, 1, 
	0, 0, 0, 23, 0, 0, 0, 0, 
	0, 1, 0, 2, 1, 0, 0, 0, 
	1, 0, 1, 0, 0, 1, 0, 1, 
	1, 9, 1, 0, 0, 0, 1, 0, 
	4, 0, 0, 0, 11, 1, 5, 1, 
	5, 2, 0, 3, 2, 2, 2, 1, 
	4, 0, 7, 17, 3, 1, 0, 2, 
	0, 1, 5, 13, 16, 12
};

static const char _english_tokenizer_range_lengths[] = {
	0, 0, 0, 0, 0, 1, 0, 0, 
	2, 1, 0, 2, 0, 1, 12, 5, 
	2, 1, 0, 4, 3, 1, 0, 0, 
	1, 1, 1, 0, 0, 1, 1, 1, 
	0, 0, 0, 4, 2, 4, 4, 0, 
	2, 0, 0, 6, 0, 0, 0, 0, 
	0, 0, 0, 1, 3, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 2, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	1, 0, 0, 2, 2, 5, 1, 6, 
	3, 2, 1, 2, 2, 2, 1, 1, 
	1, 1, 0, 0, 1, 0, 0, 3, 
	0, 0, 0, 5, 5, 5, 3, 3, 
	3, 3, 3, 3, 6, 1, 3, 3, 
	3, 3, 3, 3, 3, 3, 4, 4, 
	3, 3, 4, 4, 3, 3, 4, 4, 
	1, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	7, 5, 5, 5, 5, 0, 0, 5, 
	5, 5, 5, 5, 5, 5, 1, 1, 
	1, 0, 1, 1, 0, 1, 2, 0, 
	2, 0, 0, 0, 0, 1, 0, 0, 
	1, 1, 1, 1, 1, 1, 0, 1, 
	1, 0, 1, 2, 0, 2, 0, 0, 
	0, 0, 1, 0, 0, 1, 1, 1, 
	1, 1, 1, 1, 0, 1, 1, 0, 
	1, 2, 0, 2, 0, 0, 0, 0, 
	1, 0, 0, 1, 1, 1, 1, 0, 
	1, 1, 0, 1, 2, 0, 2, 0, 
	0, 0, 0, 1, 0, 0, 1, 1, 
	1, 1, 0, 1, 1, 0, 1, 2, 
	0, 2, 0, 0, 0, 0, 1, 0, 
	0, 1, 1, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 6, 
	6, 5, 5, 6, 6, 5, 5, 5, 
	5, 5, 1, 1, 1, 0, 1, 1, 
	0, 1, 2, 0, 2, 0, 0, 0, 
	0, 1, 0, 0, 1, 5, 5, 5, 
	0, 0, 0, 0, 3, 1, 3, 3, 
	3, 2, 2, 2, 2, 2, 4, 2, 
	2, 5, 1, 2, 1, 1, 0, 1, 
	1, 1, 1, 2, 7, 6, 9, 5, 
	8, 4, 8, 6, 10, 3, 6, 6, 
	7, 6, 5, 5, 4, 4, 1, 1, 
	8, 3, 2, 3, 3, 0, 2, 3, 
	3, 5, 5, 3, 3, 2, 2, 1, 
	1, 2, 2, 2, 3, 4, 2, 2, 
	1, 2, 1, 3, 2, 2, 1, 2, 
	2, 1, 2, 2, 1, 2, 3, 2, 
	3, 4, 2, 7, 0, 0, 1, 4, 
	4, 2, 2, 2, 1, 2, 1, 1, 
	1, 2, 1, 3, 2, 2, 2, 2, 
	4, 1, 1, 2, 2, 2, 2, 1, 
	3, 4, 6, 3, 2, 1, 2, 2, 
	1, 2, 1, 5, 3, 1, 1, 2, 
	2, 2, 2, 1, 1, 2, 1, 4, 
	1, 2, 4, 2, 1, 0, 2, 1, 
	2, 2, 2, 2, 1, 2, 1, 2, 
	3, 2, 1, 2, 2, 6, 1, 1, 
	2, 2, 1, 1, 1, 1, 1, 1, 
	1, 2, 1, 6, 1, 2, 0, 0, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	3, 1, 2, 1, 0, 1, 2, 3, 
	1, 3, 3, 1, 2, 6, 2, 6, 
	3, 2, 3, 3, 3, 3, 2, 1, 
	2, 5, 7, 5, 1, 1, 1, 1, 
	0, 1, 1, 0, 0, 0, 0, 0, 
	0, 1, 1, 5, 1, 1, 2, 2, 
	2, 2, 1, 5, 5, 0, 0, 0, 
	4, 0, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 6, 6, 5, 5, 6, 
	6, 5, 5, 6, 6, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 12, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 7, 3, 6, 1, 3, 3, 3, 
	3, 4, 4, 5, 5, 5, 5, 7, 
	5, 5, 5, 5, 1, 1, 0, 5, 
	5, 5, 5, 5, 5, 5, 5, 6, 
	6, 5, 5, 1, 5, 5, 6, 6, 
	1, 7, 7, 7, 7, 7, 7, 7, 
	4, 4, 0, 0, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 0, 0, 4, 
	4, 4, 4, 7, 7, 7, 7, 7, 
	7, 7, 7, 5, 5, 5, 6, 6, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 4, 4, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 4, 4, 
	7, 7, 0, 1, 1, 1, 5, 1, 
	1, 6, 4, 2, 1, 3, 1, 3, 
	2, 5, 2, 5, 2, 8, 3, 2, 
	2, 5, 1, 2, 2, 3, 3, 5, 
	9, 6, 7, 7, 3, 5, 7, 5, 
	13, 3, 3, 7, 3, 6, 3, 6, 
	5, 4, 2, 4, 8, 6, 3, 2, 
	3, 1, 2, 11, 5, 3, 5, 5, 
	3, 3, 2, 3, 2, 1, 3, 3, 
	4, 4, 4, 2, 3, 4, 2, 3, 
	2, 2, 6, 2, 4, 3, 2, 4, 
	3, 5, 6, 2, 2, 6, 5, 5, 
	6, 1, 11, 1, 2, 1, 1, 2, 
	1, 3, 8, 3, 3, 1, 1, 6, 
	3, 2, 3, 2, 1, 2, 7, 3, 
	1, 4, 4, 2, 1, 1, 1, 2, 
	1, 3, 6, 2, 3, 4, 6, 2, 
	2, 3, 5, 4, 4, 3, 6, 2, 
	7, 6, 8, 7, 4, 4, 2, 3, 
	4, 2, 3, 2, 5, 1, 2, 2, 
	2, 2, 3, 4, 2, 2, 5, 3, 
	1, 9, 3, 5, 1, 4, 2, 3, 
	2, 3, 4, 4, 4, 3, 2, 4, 
	4, 4, 4, 3, 3, 3, 2, 2, 
	4, 2, 2, 1, 3, 3, 3, 5, 
	4, 3, 3, 4, 2, 4, 3, 2, 
	5, 2, 3, 2, 2, 3, 2, 2, 
	2, 3, 3, 3, 7, 2, 2, 3, 
	1, 2, 4, 4, 3, 1, 5, 1, 
	3, 3, 3, 1, 1, 1, 1, 3, 
	3, 2, 4, 6, 4, 1, 2, 2, 
	2, 3, 5, 5, 5, 5
};

static const short _english_tokenizer_index_offsets[] = {
	0, 0, 2, 4, 6, 9, 12, 14, 
	16, 50, 81, 83, 86, 119, 150, 170, 
	197, 226, 233, 238, 245, 264, 266, 283, 
	312, 344, 370, 372, 374, 377, 387, 389, 
	393, 395, 428, 457, 462, 469, 474, 479, 
	497, 502, 505, 507, 520, 522, 524, 528, 
	536, 543, 555, 559, 561, 571, 593, 604, 
	606, 608, 619, 625, 649, 664, 679, 707, 
	728, 734, 736, 744, 751, 755, 759, 763, 
	765, 767, 769, 786, 789, 792, 800, 802, 
	809, 814, 817, 819, 822, 825, 828, 831, 
	833, 835, 837, 839, 842, 852, 855, 873, 
	880, 884, 886, 898, 908, 916, 925, 932, 
	938, 943, 949, 953, 959, 971, 973, 979, 
	986, 992, 999, 1005, 1012, 1018, 1024, 1032, 
	1039, 1045, 1051, 1059, 1066, 1072, 1078, 1086, 
	1093, 1109, 1112, 1114, 1117, 1119, 1122, 1132, 
	1138, 1142, 1144, 1148, 1156, 1163, 1175, 1179, 
	1190, 1192, 1204, 1210, 1212, 1219, 1227, 1230, 
	1234, 1259, 1273, 1285, 1297, 1309, 1311, 1313, 
	1324, 1342, 1360, 1378, 1396, 1416, 1434, 1436, 
	1438, 1440, 1454, 1456, 1458, 1469, 1471, 1474, 
	1481, 1484, 1486, 1491, 1493, 1503, 1505, 1508, 
	1510, 1512, 1514, 1526, 1536, 1538, 1540, 1554, 
	1556, 1558, 1569, 1571, 1574, 1581, 1584, 1586, 
	1591, 1593, 1603, 1605, 1608, 1610, 1612, 1614, 
	1624, 1634, 1644, 1646, 1648, 1662, 1664, 1666, 
	1677, 1679, 1682, 1689, 1692, 1694, 1699, 1701, 
	1711, 1713, 1716, 1718, 1720, 1722, 1724, 1726, 
	1740, 1742, 1744, 1755, 1757, 1760, 1767, 1770, 
	1772, 1777, 1779, 1789, 1791, 1794, 1796, 1798, 
	1800, 1802, 1804, 1818, 1820, 1822, 1833, 1835, 
	1838, 1845, 1848, 1850, 1855, 1857, 1867, 1869, 
	1872, 1874, 1876, 1886, 1897, 1909, 1919, 1931, 
	1942, 1952, 1964, 1972, 1984, 1996, 2009, 2021, 
	2034, 2055, 2068, 2080, 2093, 2106, 2119, 2132, 
	2147, 2161, 2173, 2185, 2199, 2212, 2233, 2252, 
	2270, 2291, 2310, 2312, 2314, 2316, 2330, 2332, 
	2334, 2345, 2347, 2350, 2357, 2360, 2362, 2367, 
	2369, 2379, 2381, 2384, 2386, 2388, 2410, 2422, 
	2434, 2438, 2451, 2454, 2457, 2461, 2463, 2469, 
	2474, 2480, 2483, 2486, 2489, 2493, 2497, 2503, 
	2506, 2509, 2516, 2518, 2521, 2523, 2526, 2559, 
	2561, 2563, 2565, 2567, 2570, 2579, 2587, 2598, 
	2606, 2615, 2621, 2630, 2638, 2650, 2656, 2663, 
	2670, 2678, 2686, 2692, 2699, 2705, 2712, 2714, 
	2716, 2730, 2735, 2742, 2746, 2750, 2752, 2795, 
	2799, 2805, 2812, 2818, 2823, 2827, 2830, 2833, 
	2835, 2837, 2840, 2843, 2846, 2850, 2855, 2859, 
	2862, 2864, 2867, 2869, 2873, 2876, 2879, 2881, 
	2884, 2888, 2891, 2894, 2897, 2899, 2902, 2906, 
	2909, 2913, 2921, 2925, 2933, 2950, 2952, 2962, 
	2967, 2972, 2975, 2978, 2981, 2983, 2987, 2989, 
	2992, 2994, 3018, 3020, 3024, 3028, 3031, 3034, 
	3037, 3042, 3044, 3046, 3050, 3053, 3056, 3061, 
	3063, 3067, 3072, 3079, 3083, 3086, 3090, 3093, 
	3096, 3115, 3118, 3120, 3127, 3131, 3133, 3135, 
	3138, 3141, 3144, 3147, 3149, 3151, 3154, 3156, 
	3161, 3174, 3207, 3213, 3216, 3218, 3220, 3223, 
	3226, 3229, 3233, 3236, 3239, 3241, 3244, 3246, 
	3249, 3256, 3259, 3261, 3264, 3267, 3275, 3277, 
	3279, 3282, 3285, 3287, 3289, 3312, 3315, 3317, 
	3320, 3323, 3326, 3328, 3336, 3339, 3342, 3344, 
	3347, 3349, 3352, 3354, 3357, 3359, 3362, 3364, 
	3375, 3379, 3381, 3384, 3386, 3391, 3393, 3396, 
	3400, 3416, 3420, 3424, 3426, 3429, 3438, 3441, 
	3448, 3453, 3456, 3461, 3465, 3469, 3473, 3476, 
	3482, 3485, 3495, 3515, 3521, 3524, 3526, 3530, 
	3533, 3535, 3538, 3540, 3557, 3559, 3572, 3575, 
	3578, 3581, 3583, 3585, 3597, 3600, 3602, 3605, 
	3608, 3611, 3616, 3620, 3626, 3632, 3634, 3651, 
	3653, 3661, 3663, 3674, 3686, 3699, 3711, 3724, 
	3736, 3749, 3761, 3773, 3787, 3800, 3812, 3824, 
	3838, 3851, 3863, 3875, 3889, 3902, 3919, 3921, 
	3938, 3940, 3942, 3944, 3949, 3952, 3955, 3958, 
	4032, 4041, 4049, 4056, 4064, 4073, 4075, 4084, 
	4086, 4095, 4120, 4128, 4140, 4143, 4151, 4159, 
	4167, 4175, 4185, 4194, 4204, 4218, 4228, 4238, 
	4264, 4287, 4301, 4321, 4339, 4349, 4361, 4366, 
	4379, 4389, 4402, 4424, 4446, 4466, 4488, 4510, 
	4534, 4557, 4580, 4600, 4614, 4637, 4660, 4685, 
	4709, 4725, 4771, 4828, 4872, 4917, 4962, 5021, 
	5066, 5104, 5154, 5155, 5156, 5193, 5231, 5283, 
	5321, 5371, 5409, 5449, 5487, 5527, 5528, 5529, 
	5569, 5607, 5647, 5699, 5746, 5791, 5838, 5883, 
	5929, 5975, 6021, 6067, 6080, 6093, 6106, 6121, 
	6135, 6181, 6227, 6275, 6321, 6367, 6415, 6463, 
	6509, 6555, 6614, 6661, 6713, 6753, 6803, 6851, 
	6899, 6947, 6993, 7041, 7087, 7135, 7183, 7231, 
	7279, 7327, 7375, 7423, 7469, 7526, 7571, 7621, 
	7659, 7707, 7753, 7756, 7758, 7764, 7774, 7813, 
	7817, 7819, 7828, 7835, 7842, 7845, 7849, 7852, 
	7857, 7860, 7866, 7869, 7876, 7891, 7902, 7907, 
	7910, 7914, 7921, 7953, 7959, 7962, 7966, 7971, 
	7979, 7993, 8002, 8014, 8023, 8033, 8040, 8052, 
	8060, 8078, 8083, 8091, 8099, 8108, 8117, 8124, 
	8132, 8140, 8145, 8150, 8155, 8175, 8183, 8188, 
	8192, 8196, 8242, 8246, 8259, 8266, 8273, 8282, 
	8291, 8297, 8302, 8305, 8309, 8312, 8315, 8319, 
	8324, 8329, 8335, 8341, 8344, 8350, 8355, 8358, 
	8363, 8366, 8369, 8376, 8379, 8385, 8389, 8392, 
	8398, 8402, 8408, 8415, 8418, 8421, 8428, 8435, 
	8441, 8452, 8457, 8471, 8488, 8495, 8499, 8505, 
	8522, 8527, 8531, 8547, 8552, 8556, 8559, 8562, 
	8569, 8575, 8579, 8587, 8593, 8596, 8607, 8616, 
	8621, 8624, 8629, 8634, 8637, 8641, 8643, 8646, 
	8649, 8676, 8680, 8687, 8691, 8695, 8700, 8708, 
	8711, 8717, 8721, 8728, 8733, 8738, 8742, 8752, 
	8755, 8765, 8773, 8783, 8794, 8800, 8805, 8810, 
	8814, 8819, 8839, 8843, 8846, 8857, 8861, 8864, 
	8867, 8870, 8873, 8877, 8882, 8886, 8889, 8895, 
	8900, 8903, 8913, 8928, 8963, 8969, 8974, 8977, 
	8981, 8984, 8988, 8994, 8999, 9004, 9008, 9011, 
	9016, 9025, 9030, 9035, 9039, 9046, 9050, 9053, 
	9057, 9062, 9065, 9068, 9093, 9097, 9101, 9105, 
	9111, 9116, 9121, 9125, 9132, 9136, 9141, 9145, 
	9148, 9155, 9158, 9163, 9166, 9169, 9174, 9177, 
	9181, 9185, 9198, 9203, 9207, 9215, 9218, 9222, 
	9226, 9232, 9235, 9240, 9245, 9260, 9263, 9274, 
	9277, 9286, 9292, 9296, 9301, 9305, 9309, 9313, 
	9318, 9326, 9329, 9341, 9365, 9373, 9376, 9379, 
	9384, 9387, 9392, 9403, 9422, 9444
};

static const short _english_tokenizer_indicies[] = {
	1, 0, 2, 0, 1, 0, 3, 4, 
	0, 1, 1, 0, 1, 0, 2, 0, 
	6, 6, 7, 7, 7, 7, 7, 9, 
	10, 11, 12, 13, 14, 15, 16, 17, 
	18, 19, 20, 21, 22, 23, 24, 25, 
	26, 27, 28, 29, 30, 31, 32, 6, 
	8, 5, 7, 7, 7, 7, 7, 33, 
	10, 11, 12, 13, 14, 15, 16, 17, 
	18, 19, 20, 21, 22, 23, 24, 25, 
	26, 34, 35, 36, 30, 31, 32, 8, 
	5, 7, 5, 8, 8, 5, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 5, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 5, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 5, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 5, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 5, 8, 8, 8, 8, 8, 8, 
	5, 8, 8, 8, 8, 5, 8, 8, 
	8, 8, 8, 8, 5, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 5, 
	8, 5, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 5, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 5, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 5, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 5, 8, 5, 37, 5, 7, 7, 
	5, 38, 39, 40, 42, 43, 44, 45, 
	46, 41, 5, 8, 5, 8, 8, 8, 
	5, 7, 5, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 5, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	5, 8, 8, 8, 8, 5, 8, 8, 
	8, 8, 8, 8, 5, 8, 8, 8, 
	8, 5, 8, 8, 8, 8, 5, 47, 
	48, 49, 50, 51, 52, 53, 54, 55, 
	56, 57, 58, 59, 41, 60, 61, 62, 
	5, 7, 7, 7, 7, 5, 7, 7, 
	5, 7, 5, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 5, 
	8, 5, 8, 5, 7, 7, 7, 5, 
	7, 7, 7, 7, 7, 7, 7, 5, 
	7, 7, 7, 7, 7, 7, 5, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 5, 7, 7, 7, 5, 8, 
	5, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 5, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	5, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 5, 7, 5, 63, 5, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 5, 64, 65, 66, 67, 68, 
	5, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	5, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 5, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 5, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 5, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 8, 
	8, 8, 8, 8, 8, 8, 8, 5, 
	69, 70, 71, 72, 73, 5, 7, 5, 
	7, 7, 7, 7, 7, 7, 7, 5, 
	7, 7, 7, 7, 7, 7, 5, 7, 
	7, 8, 5, 7, 7, 7, 5, 74, 
	75, 76, 5, 77, 5, 8, 5, 38, 
	5, 78, 79, 80, 81, 82, 83, 84, 
	85, 86, 87, 88, 89, 90, 91, 92, 
	93, 5, 8, 8, 5, 8, 8, 5, 
	8, 8, 8, 8, 8, 8, 8, 5, 
	8, 5, 8, 8, 8, 8, 8, 8, 
	5, 8, 8, 8, 8, 5, 8, 8, 
	5, 8, 5, 8, 8, 5, 8, 8, 
	5, 8, 8, 5, 8, 8, 5, 8, 
	5, 8, 5, 8, 5, 8, 5, 6, 
	7, 5, 38, 39, 94, 42, 43, 44, 
	45, 46, 41, 5, 6, 7, 5, 95, 
	96, 49, 50, 51, 52, 53, 54, 55, 
	56, 57, 58, 59, 41, 60, 61, 62, 
	5, 7, 6, 7, 6, 7, 7, 5, 
	7, 6, 7, 5, 97, 5, 6, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 5, 99, 100, 101, 99, 99, 99, 
	99, 99, 99, 98, 102, 102, 102, 102, 
	102, 102, 102, 98, 102, 101, 102, 102, 
	102, 102, 102, 102, 98, 103, 104, 105, 
	106, 107, 107, 98, 108, 109, 107, 107, 
	107, 98, 108, 107, 107, 107, 98, 108, 
	110, 107, 107, 107, 98, 107, 111, 112, 
	98, 108, 110, 107, 113, 107, 98, 114, 
	115, 115, 114, 114, 114, 115, 114, 114, 
	115, 115, 5, 116, 5, 108, 110, 107, 
	107, 117, 98, 118, 119, 120, 121, 111, 
	112, 98, 108, 122, 107, 107, 107, 98, 
	123, 124, 125, 126, 111, 112, 98, 108, 
	127, 107, 107, 107, 98, 128, 129, 130, 
	131, 111, 112, 98, 108, 127, 126, 107, 
	107, 98, 108, 127, 123, 107, 107, 98, 
	108, 127, 132, 126, 123, 107, 107, 98, 
	108, 127, 123, 107, 107, 107, 98, 108, 
	122, 121, 107, 107, 98, 108, 122, 118, 
	107, 107, 98, 108, 122, 133, 121, 118, 
	107, 107, 98, 108, 122, 118, 107, 107, 
	107, 98, 108, 109, 106, 107, 107, 98, 
	108, 109, 103, 107, 107, 98, 108, 109, 
	134, 106, 103, 107, 107, 98, 108, 109, 
	103, 107, 107, 107, 98, 135, 135, 136, 
	136, 136, 136, 136, 136, 137, 138, 139, 
	140, 141, 142, 135, 5, 6, 136, 5, 
	143, 5, 136, 136, 5, 144, 5, 6, 
	136, 5, 145, 146, 147, 148, 149, 150, 
	151, 152, 153, 5, 136, 136, 6, 136, 
	6, 5, 136, 6, 136, 5, 136, 5, 
	136, 136, 136, 5, 136, 136, 136, 136, 
	136, 136, 136, 5, 136, 136, 136, 136, 
	136, 136, 5, 136, 136, 136, 136, 136, 
	136, 136, 136, 136, 136, 136, 5, 136, 
	136, 136, 5, 136, 136, 136, 136, 136, 
	136, 136, 136, 136, 136, 5, 154, 5, 
	6, 136, 136, 136, 136, 136, 136, 136, 
	136, 136, 136, 5, 155, 156, 157, 158, 
	159, 5, 136, 5, 136, 136, 136, 136, 
	136, 136, 5, 136, 136, 136, 136, 136, 
	136, 136, 5, 136, 136, 5, 136, 136, 
	136, 5, 135, 135, 99, 136, 99, 100, 
	136, 101, 136, 99, 136, 137, 138, 139, 
	140, 141, 142, 135, 99, 160, 99, 99, 
	99, 99, 5, 99, 100, 101, 161, 162, 
	99, 161, 162, 99, 99, 99, 99, 99, 
	5, 99, 100, 101, 163, 99, 163, 99, 
	99, 99, 99, 99, 5, 99, 100, 101, 
	164, 99, 164, 99, 99, 99, 99, 99, 
	5, 99, 100, 101, 165, 99, 165, 99, 
	99, 99, 99, 99, 5, 166, 5, 167, 
	5, 99, 168, 100, 101, 99, 99, 99, 
	99, 99, 99, 5, 99, 100, 101, 99, 
	170, 171, 172, 173, 174, 175, 176, 177, 
	99, 99, 169, 99, 99, 5, 99, 100, 
	101, 99, 179, 180, 181, 182, 183, 184, 
	185, 186, 99, 99, 178, 99, 99, 5, 
	99, 100, 101, 99, 188, 189, 190, 191, 
	192, 193, 194, 195, 99, 99, 187, 99, 
	99, 5, 99, 100, 101, 99, 197, 198, 
	199, 200, 201, 202, 203, 204, 99, 99, 
	196, 99, 99, 5, 99, 205, 205, 100, 
	101, 99, 207, 208, 209, 210, 211, 212, 
	213, 214, 99, 99, 206, 99, 99, 5, 
	99, 100, 101, 99, 207, 208, 209, 210, 
	211, 212, 213, 214, 99, 99, 206, 99, 
	99, 5, 215, 5, 215, 5, 215, 5, 
	216, 216, 216, 216, 216, 216, 216, 216, 
	216, 216, 217, 217, 207, 5, 215, 5, 
	215, 5, 209, 217, 207, 217, 218, 217, 
	219, 217, 208, 219, 5, 215, 5, 215, 
	215, 5, 207, 217, 209, 220, 217, 208, 
	5, 215, 215, 5, 217, 5, 221, 222, 
	223, 224, 5, 207, 5, 216, 208, 225, 
	217, 208, 217, 217, 209, 207, 5, 215, 
	5, 207, 217, 5, 226, 5, 215, 5, 
	227, 5, 228, 228, 207, 208, 209, 210, 
	211, 212, 213, 214, 215, 5, 207, 208, 
	209, 210, 211, 212, 213, 214, 215, 5, 
	227, 5, 227, 5, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 230, 230, 
	197, 5, 227, 5, 227, 5, 199, 230, 
	197, 230, 231, 230, 232, 230, 198, 232, 
	5, 227, 5, 227, 227, 5, 197, 230, 
	199, 233, 230, 198, 5, 227, 227, 5, 
	230, 5, 234, 235, 236, 237, 5, 197, 
	5, 229, 198, 238, 230, 198, 230, 230, 
	199, 197, 5, 227, 5, 197, 230, 5, 
	239, 5, 227, 5, 240, 5, 170, 171, 
	172, 173, 174, 175, 176, 177, 241, 5, 
	179, 180, 181, 182, 183, 184, 185, 186, 
	242, 5, 188, 189, 190, 191, 192, 193, 
	194, 195, 240, 5, 240, 5, 240, 5, 
	243, 243, 243, 243, 243, 243, 243, 243, 
	243, 243, 244, 244, 188, 5, 240, 5, 
	240, 5, 190, 244, 188, 244, 245, 244, 
	246, 244, 189, 246, 5, 240, 5, 240, 
	240, 5, 188, 244, 190, 247, 244, 189, 
	5, 240, 240, 5, 244, 5, 248, 249, 
	250, 251, 5, 188, 5, 243, 189, 252, 
	244, 189, 244, 244, 190, 188, 5, 240, 
	5, 188, 244, 5, 253, 5, 240, 5, 
	242, 5, 242, 5, 242, 5, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	255, 255, 179, 5, 242, 5, 242, 5, 
	181, 255, 179, 255, 256, 255, 257, 255, 
	180, 257, 5, 242, 5, 242, 242, 5, 
	179, 255, 181, 258, 255, 180, 5, 242, 
	242, 5, 255, 5, 259, 260, 261, 262, 
	5, 179, 5, 254, 180, 263, 255, 180, 
	255, 255, 181, 179, 5, 242, 5, 179, 
	255, 5, 264, 5, 242, 5, 241, 5, 
	241, 5, 241, 5, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 266, 266, 
	170, 5, 241, 5, 241, 5, 172, 266, 
	170, 266, 267, 266, 268, 266, 171, 268, 
	5, 241, 5, 241, 241, 5, 170, 266, 
	172, 269, 266, 171, 5, 241, 241, 5, 
	266, 5, 270, 271, 272, 273, 5, 170, 
	5, 265, 171, 274, 266, 171, 266, 266, 
	172, 170, 5, 241, 5, 170, 266, 5, 
	275, 5, 241, 5, 197, 198, 199, 200, 
	201, 202, 203, 204, 227, 5, 99, 276, 
	100, 101, 99, 99, 99, 277, 277, 277, 
	98, 99, 276, 278, 100, 101, 99, 99, 
	99, 277, 277, 277, 98, 99, 100, 101, 
	99, 99, 99, 279, 280, 281, 98, 99, 
	282, 283, 100, 101, 99, 99, 99, 279, 
	279, 279, 98, 99, 282, 100, 101, 99, 
	99, 99, 279, 279, 279, 98, 99, 100, 
	101, 99, 99, 99, 279, 284, 285, 98, 
	99, 282, 283, 100, 101, 99, 99, 99, 
	279, 286, 279, 98, 102, 102, 102, 102, 
	287, 102, 102, 98, 99, 282, 283, 100, 
	101, 99, 99, 99, 279, 279, 288, 98, 
	99, 282, 283, 100, 101, 99, 99, 99, 
	279, 289, 279, 98, 99, 282, 283, 115, 
	290, 101, 99, 99, 99, 279, 289, 279, 
	98, 99, 282, 283, 100, 101, 99, 99, 
	99, 279, 279, 291, 98, 99, 282, 283, 
	115, 290, 101, 99, 99, 99, 279, 279, 
	291, 98, 99, 292, 293, 294, 100, 101, 
	99, 197, 198, 199, 200, 201, 202, 203, 
	204, 99, 99, 295, 280, 281, 5, 99, 
	296, 297, 298, 100, 101, 99, 99, 99, 
	299, 284, 285, 5, 99, 282, 300, 100, 
	101, 99, 99, 99, 279, 279, 279, 5, 
	99, 301, 302, 303, 100, 101, 99, 99, 
	99, 304, 284, 285, 5, 99, 282, 283, 
	115, 290, 101, 99, 99, 99, 279, 279, 
	279, 5, 99, 282, 283, 115, 290, 101, 
	99, 99, 99, 304, 279, 279, 5, 99, 
	282, 283, 115, 290, 101, 99, 99, 99, 
	301, 279, 279, 5, 99, 282, 283, 115, 
	305, 290, 101, 99, 99, 99, 304, 301, 
	279, 279, 5, 99, 282, 283, 115, 290, 
	101, 99, 99, 99, 301, 279, 279, 279, 
	5, 99, 282, 300, 100, 101, 99, 99, 
	99, 299, 279, 279, 5, 99, 282, 300, 
	100, 101, 99, 99, 99, 296, 279, 279, 
	5, 99, 282, 300, 306, 100, 101, 99, 
	99, 99, 299, 296, 279, 279, 5, 99, 
	282, 300, 100, 101, 99, 99, 99, 296, 
	279, 279, 279, 5, 99, 205, 307, 283, 
	100, 101, 99, 207, 208, 209, 210, 211, 
	212, 213, 214, 99, 99, 308, 279, 279, 
	5, 99, 282, 100, 101, 99, 207, 208, 
	209, 210, 211, 212, 213, 214, 99, 99, 
	308, 279, 279, 5, 99, 100, 101, 99, 
	197, 198, 199, 200, 201, 202, 203, 204, 
	99, 99, 309, 280, 281, 5, 99, 205, 
	310, 278, 100, 101, 99, 207, 208, 209, 
	210, 211, 212, 213, 214, 99, 99, 311, 
	277, 277, 5, 99, 276, 100, 101, 99, 
	207, 208, 209, 210, 211, 212, 213, 214, 
	99, 99, 311, 277, 277, 5, 312, 5, 
	312, 5, 312, 5, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 314, 314, 
	315, 5, 312, 5, 312, 5, 316, 314, 
	315, 314, 317, 314, 318, 314, 319, 318, 
	5, 312, 5, 312, 312, 5, 315, 314, 
	316, 320, 314, 319, 5, 312, 312, 5, 
	314, 5, 321, 322, 323, 324, 5, 315, 
	5, 313, 319, 325, 314, 319, 314, 314, 
	316, 315, 5, 312, 5, 315, 314, 5, 
	326, 5, 312, 5, 99, 100, 101, 163, 
	327, 163, 328, 163, 328, 99, 163, 327, 
	163, 328, 163, 328, 99, 99, 99, 99, 
	99, 5, 99, 100, 101, 165, 99, 165, 
	99, 99, 99, 99, 99, 5, 99, 100, 
	101, 165, 99, 165, 99, 99, 99, 99, 
	99, 5, 329, 329, 329, 98, 330, 331, 
	330, 332, 330, 332, 330, 331, 330, 332, 
	330, 332, 5, 333, 333, 5, 333, 333, 
	5, 329, 329, 329, 98, 329, 98, 329, 
	329, 329, 329, 329, 98, 329, 329, 329, 
	329, 98, 329, 329, 329, 329, 329, 98, 
	329, 329, 98, 329, 329, 98, 329, 329, 
	98, 329, 329, 329, 98, 329, 329, 329, 
	98, 329, 329, 329, 329, 329, 98, 329, 
	329, 98, 329, 329, 98, 329, 329, 329, 
	329, 329, 329, 98, 329, 98, 329, 329, 
	98, 329, 98, 329, 329, 98, 334, 335, 
	336, 337, 338, 339, 340, 341, 342, 343, 
	344, 345, 346, 347, 348, 349, 350, 351, 
	352, 353, 354, 355, 356, 357, 358, 359, 
	360, 361, 362, 363, 364, 365, 98, 329, 
	98, 329, 98, 329, 98, 329, 98, 329, 
	329, 98, 329, 329, 329, 329, 329, 329, 
	329, 329, 98, 329, 329, 329, 329, 329, 
	329, 329, 98, 329, 329, 329, 329, 329, 
	329, 329, 329, 329, 329, 98, 329, 329, 
	329, 329, 329, 329, 329, 98, 329, 329, 
	329, 329, 329, 329, 329, 329, 98, 329, 
	329, 329, 329, 329, 98, 329, 329, 329, 
	329, 329, 329, 329, 329, 98, 329, 329, 
	329, 329, 329, 329, 329, 98, 329, 329, 
	329, 329, 329, 329, 329, 329, 329, 329, 
	329, 98, 329, 329, 329, 329, 329, 98, 
	329, 329, 329, 329, 329, 329, 98, 329, 
	329, 329, 329, 329, 329, 98, 329, 329, 
	329, 329, 329, 329, 329, 98, 329, 329, 
	329, 329, 329, 329, 329, 98, 329, 329, 
	329, 329, 329, 98, 329, 329, 329, 329, 
	329, 329, 98, 329, 329, 329, 329, 329, 
	98, 329, 329, 329, 329, 329, 329, 98, 
	329, 98, 329, 98, 329, 329, 329, 329, 
	329, 329, 329, 329, 329, 329, 329, 329, 
	329, 98, 329, 329, 329, 329, 98, 329, 
	329, 329, 329, 329, 329, 98, 329, 329, 
	329, 98, 329, 329, 329, 98, 329, 98, 
	366, 367, 368, 369, 370, 371, 372, 373, 
	374, 375, 376, 377, 378, 379, 380, 381, 
	382, 383, 384, 385, 386, 387, 388, 389, 
	390, 391, 392, 393, 338, 394, 395, 396, 
	384, 397, 398, 399, 400, 401, 402, 403, 
	338, 338, 98, 329, 329, 329, 98, 329, 
	329, 329, 329, 329, 98, 329, 329, 329, 
	329, 329, 329, 98, 329, 329, 329, 329, 
	329, 98, 329, 329, 329, 329, 98, 329, 
	329, 329, 98, 329, 329, 98, 329, 329, 
	98, 329, 98, 329, 98, 329, 329, 98, 
	329, 329, 98, 329, 329, 98, 329, 329, 
	329, 98, 329, 329, 329, 329, 98, 329, 
	329, 329, 98, 329, 329, 98, 329, 98, 
	329, 329, 98, 329, 98, 329, 329, 329, 
	98, 329, 329, 98, 329, 329, 98, 329, 
	98, 329, 329, 98, 329, 329, 329, 98, 
	329, 329, 98, 329, 329, 98, 329, 329, 
	98, 329, 98, 329, 329, 98, 329, 329, 
	329, 98, 329, 329, 98, 329, 329, 329, 
	98, 329, 329, 329, 329, 329, 329, 329, 
	98, 329, 329, 329, 98, 329, 329, 329, 
	329, 329, 329, 329, 98, 404, 405, 406, 
	407, 408, 409, 410, 411, 412, 338, 413, 
	414, 415, 416, 417, 418, 98, 419, 98, 
	420, 376, 421, 422, 423, 338, 424, 425, 
	338, 98, 329, 329, 329, 329, 98, 329, 
	329, 329, 329, 98, 329, 329, 98, 329, 
	329, 98, 329, 329, 98, 329, 98, 386, 
	338, 338, 98, 338, 98, 426, 338, 98, 
	329, 98, 426, 427, 428, 429, 430, 431, 
	432, 433, 434, 435, 396, 436, 437, 438, 
	439, 440, 441, 442, 443, 444, 445, 338, 
	338, 98, 329, 98, 329, 329, 329, 98, 
	329, 329, 329, 98, 329, 329, 98, 329, 
	329, 98, 329, 329, 98, 329, 329, 329, 
	329, 98, 329, 98, 329, 98, 329, 329, 
	329, 98, 329, 329, 98, 329, 329, 98, 
	329, 329, 329, 329, 98, 329, 98, 329, 
	329, 329, 98, 329, 329, 329, 329, 98, 
	329, 329, 329, 329, 329, 329, 98, 329, 
	329, 329, 98, 329, 329, 98, 446, 447, 
	338, 98, 329, 329, 98, 329, 329, 98, 
	448, 449, 450, 451, 452, 453, 454, 366, 
	455, 456, 457, 458, 459, 460, 461, 462, 
	463, 338, 98, 329, 329, 98, 329, 98, 
	329, 329, 329, 329, 329, 329, 98, 329, 
	329, 329, 98, 329, 98, 329, 98, 329, 
	329, 98, 329, 329, 98, 329, 329, 98, 
	329, 329, 98, 329, 98, 329, 98, 329, 
	329, 98, 329, 98, 329, 329, 329, 329, 
	98, 464, 465, 466, 467, 468, 469, 470, 
	471, 473, 474, 475, 472, 98, 476, 477, 
	338, 478, 479, 480, 481, 482, 483, 484, 
	485, 486, 487, 488, 440, 489, 490, 491, 
	492, 493, 494, 495, 496, 497, 498, 386, 
	499, 500, 338, 501, 338, 338, 98, 329, 
	329, 329, 329, 329, 98, 329, 329, 98, 
	329, 98, 329, 98, 329, 329, 98, 329, 
	329, 98, 329, 329, 98, 329, 329, 329, 
	98, 329, 329, 98, 329, 329, 98, 329, 
	98, 329, 329, 98, 329, 98, 329, 329, 
	98, 329, 329, 329, 329, 329, 329, 98, 
	329, 329, 98, 329, 98, 329, 329, 98, 
	329, 329, 98, 329, 329, 329, 329, 329, 
	329, 329, 98, 329, 98, 329, 98, 329, 
	329, 98, 329, 329, 98, 329, 98, 329, 
	98, 502, 478, 503, 375, 504, 505, 506, 
	425, 507, 346, 508, 338, 509, 510, 511, 
	338, 512, 384, 513, 514, 515, 338, 98, 
	329, 329, 98, 329, 98, 329, 329, 98, 
	329, 329, 98, 329, 329, 98, 329, 98, 
	329, 329, 329, 329, 329, 329, 329, 98, 
	329, 329, 98, 329, 329, 98, 329, 98, 
	329, 329, 98, 329, 98, 329, 329, 98, 
	329, 98, 516, 338, 98, 329, 98, 517, 
	338, 98, 329, 98, 515, 492, 388, 440, 
	518, 519, 338, 520, 521, 338, 98, 329, 
	329, 329, 98, 329, 98, 329, 329, 98, 
	329, 98, 522, 338, 523, 524, 98, 329, 
	98, 329, 329, 98, 329, 329, 329, 98, 
	525, 526, 527, 528, 529, 530, 531, 532, 
	533, 534, 535, 536, 537, 538, 338, 98, 
	329, 329, 329, 98, 329, 329, 329, 98, 
	329, 98, 329, 329, 98, 329, 329, 329, 
	329, 329, 329, 329, 329, 98, 329, 329, 
	98, 329, 329, 329, 329, 329, 329, 98, 
	329, 329, 329, 329, 98, 329, 329, 98, 
	329, 329, 329, 329, 98, 329, 329, 329, 
	98, 329, 329, 329, 98, 329, 329, 329, 
	98, 329, 329, 98, 539, 540, 541, 542, 
	338, 98, 329, 329, 98, 329, 329, 329, 
	329, 329, 329, 329, 329, 329, 98, 329, 
	329, 329, 329, 329, 329, 329, 329, 329, 
	329, 329, 329, 329, 329, 329, 329, 329, 
	329, 329, 98, 329, 329, 329, 329, 329, 
	98, 543, 338, 98, 329, 98, 375, 486, 
	338, 98, 486, 338, 98, 544, 98, 545, 
	338, 98, 329, 98, 546, 405, 406, 407, 
	408, 409, 410, 411, 412, 338, 413, 414, 
	415, 416, 417, 418, 5, 547, 5, 548, 
	549, 548, 550, 548, 550, 548, 549, 548, 
	550, 548, 550, 5, 551, 551, 5, 551, 
	551, 5, 329, 329, 98, 329, 98, 329, 
	98, 329, 329, 329, 329, 329, 329, 329, 
	329, 329, 329, 329, 98, 329, 329, 98, 
	329, 98, 329, 329, 98, 329, 329, 98, 
	329, 329, 98, 329, 329, 329, 329, 98, 
	329, 329, 329, 98, 329, 329, 329, 329, 
	329, 98, 329, 329, 329, 329, 329, 98, 
	329, 98, 552, 405, 406, 407, 408, 409, 
	410, 411, 412, 338, 413, 414, 415, 416, 
	417, 418, 98, 553, 98, 102, 554, 102, 
	102, 102, 102, 102, 98, 555, 98, 99, 
	556, 557, 558, 99, 99, 99, 559, 279, 
	279, 98, 99, 282, 560, 100, 101, 99, 
	99, 99, 279, 279, 279, 98, 99, 561, 
	562, 563, 100, 101, 99, 99, 99, 564, 
	284, 285, 98, 99, 282, 565, 100, 101, 
	99, 99, 99, 279, 279, 279, 98, 99, 
	566, 567, 568, 100, 101, 99, 99, 99, 
	569, 284, 285, 98, 99, 282, 570, 100, 
	101, 99, 99, 99, 279, 279, 279, 98, 
	99, 571, 572, 573, 100, 101, 99, 99, 
	99, 574, 284, 285, 98, 99, 282, 570, 
	100, 101, 99, 99, 99, 569, 279, 279, 
	98, 99, 282, 570, 100, 101, 99, 99, 
	99, 566, 279, 279, 98, 99, 282, 570, 
	575, 100, 101, 99, 99, 99, 569, 566, 
	279, 279, 98, 99, 282, 570, 100, 101, 
	99, 99, 99, 566, 279, 279, 279, 98, 
	99, 282, 565, 100, 101, 99, 99, 99, 
	564, 279, 279, 98, 99, 282, 565, 100, 
	101, 99, 99, 99, 561, 279, 279, 98, 
	99, 282, 565, 576, 100, 101, 99, 99, 
	99, 564, 561, 279, 279, 98, 99, 282, 
	565, 100, 101, 99, 99, 99, 561, 279, 
	279, 279, 98, 99, 282, 560, 100, 101, 
	99, 99, 99, 559, 279, 279, 98, 99, 
	282, 560, 100, 101, 99, 99, 99, 556, 
	279, 279, 98, 99, 282, 560, 577, 100, 
	101, 99, 99, 99, 559, 556, 279, 279, 
	98, 99, 282, 560, 100, 101, 99, 99, 
	99, 556, 279, 279, 279, 98, 578, 405, 
	406, 407, 408, 409, 410, 411, 412, 338, 
	413, 414, 415, 416, 417, 418, 5, 579, 
	5, 580, 405, 406, 407, 408, 409, 410, 
	411, 412, 338, 413, 414, 415, 416, 417, 
	418, 5, 581, 5, 582, 5, 167, 5, 
	583, 584, 583, 584, 5, 330, 330, 5, 
	585, 585, 5, 333, 333, 5, 1, 586, 
	587, 1, 588, 167, 589, 168, 591, 167, 
	592, 593, 594, 596, 598, 599, 600, 601, 
	602, 603, 168, 604, 598, 599, 600, 601, 
	602, 603, 606, 607, 609, 605, 610, 611, 
	612, 613, 614, 615, 616, 617, 618, 619, 
	620, 621, 622, 623, 624, 625, 626, 627, 
	628, 629, 631, 632, 633, 634, 635, 636, 
	637, 168, 638, 167, 168, 595, 167, 597, 
	167, 597, 167, 605, 608, 630, 605, 590, 
	1, 640, 641, 1, 642, 643, 644, 645, 
	639, 1, 646, 1, 642, 643, 644, 645, 
	639, 1, 1, 642, 643, 644, 645, 639, 
	1, 646, 1, 642, 643, 644, 645, 639, 
	1, 647, 648, 1, 642, 643, 644, 645, 
	639, 650, 649, 1, 647, 651, 1, 642, 
	643, 644, 645, 639, 650, 649, 1, 648, 
	651, 1, 642, 643, 644, 645, 639, 135, 
	135, 99, 136, 99, 100, 136, 101, 136, 
	99, 136, 137, 138, 139, 140, 141, 142, 
	135, 99, 160, 99, 99, 99, 99, 652, 
	108, 110, 115, 653, 107, 113, 107, 652, 
	114, 115, 115, 114, 114, 114, 115, 114, 
	114, 115, 115, 652, 115, 116, 652, 108, 
	110, 115, 653, 107, 107, 117, 652, 108, 
	110, 115, 653, 107, 107, 107, 652, 108, 
	110, 115, 653, 131, 107, 107, 652, 108, 
	110, 115, 653, 128, 107, 107, 652, 108, 
	110, 115, 654, 653, 131, 128, 107, 107, 
	652, 108, 110, 115, 653, 128, 107, 107, 
	107, 652, 99, 100, 101, 99, 99, 99, 
	99, 99, 99, 652, 99, 168, 100, 101, 
	655, 99, 655, 656, 99, 99, 99, 99, 
	99, 652, 658, 659, 660, 658, 658, 658, 
	658, 658, 658, 657, 662, 663, 664, 662, 
	662, 662, 662, 662, 662, 661, 135, 135, 
	99, 136, 99, 665, 100, 136, 101, 136, 
	99, 136, 137, 138, 139, 140, 141, 142, 
	135, 99, 160, 99, 99, 99, 99, 652, 
	99, 666, 276, 667, 100, 101, 669, 99, 
	669, 315, 319, 316, 670, 671, 672, 673, 
	674, 99, 99, 668, 277, 277, 652, 99, 
	666, 675, 100, 101, 676, 99, 676, 99, 
	99, 99, 99, 99, 652, 99, 100, 101, 
	676, 99, 676, 197, 198, 199, 200, 201, 
	202, 203, 204, 99, 99, 196, 99, 99, 
	652, 99, 100, 101, 99, 207, 208, 209, 
	210, 211, 212, 213, 214, 99, 99, 206, 
	99, 99, 652, 207, 208, 209, 210, 211, 
	212, 213, 214, 215, 652, 677, 677, 197, 
	198, 199, 200, 201, 202, 203, 204, 227, 
	652, 678, 679, 677, 677, 652, 99, 282, 
	283, 115, 290, 101, 99, 99, 99, 279, 
	286, 279, 652, 102, 115, 101, 102, 102, 
	102, 287, 102, 102, 652, 99, 282, 283, 
	115, 290, 101, 99, 99, 99, 279, 279, 
	288, 652, 99, 282, 680, 100, 101, 681, 
	99, 681, 197, 198, 199, 200, 201, 202, 
	203, 204, 99, 99, 309, 279, 279, 652, 
	99, 282, 283, 100, 101, 681, 99, 681, 
	197, 198, 199, 200, 201, 202, 203, 204, 
	99, 99, 309, 279, 279, 652, 99, 282, 
	283, 100, 101, 99, 207, 208, 209, 210, 
	211, 212, 213, 214, 99, 99, 308, 279, 
	279, 652, 99, 282, 680, 100, 101, 681, 
	99, 681, 197, 198, 199, 200, 201, 202, 
	203, 204, 99, 99, 295, 279, 279, 652, 
	99, 282, 680, 100, 101, 681, 99, 681, 
	197, 198, 199, 200, 201, 202, 203, 204, 
	99, 99, 292, 279, 279, 652, 99, 282, 
	680, 682, 100, 101, 681, 99, 681, 197, 
	198, 199, 200, 201, 202, 203, 204, 99, 
	99, 295, 292, 279, 279, 652, 99, 282, 
	680, 100, 101, 681, 99, 681, 197, 198, 
	199, 200, 201, 202, 203, 204, 99, 99, 
	292, 309, 279, 279, 652, 99, 666, 276, 
	683, 100, 101, 669, 99, 669, 315, 319, 
	316, 670, 671, 672, 673, 674, 99, 99, 
	668, 277, 277, 652, 99, 276, 278, 100, 
	101, 99, 207, 208, 209, 210, 211, 212, 
	213, 214, 99, 99, 311, 277, 277, 652, 
	678, 679, 677, 677, 315, 319, 316, 670, 
	671, 672, 673, 674, 312, 652, 99, 666, 
	276, 667, 100, 101, 669, 99, 669, 315, 
	319, 316, 670, 671, 672, 673, 674, 99, 
	99, 595, 277, 277, 652, 99, 666, 276, 
	667, 100, 101, 669, 99, 669, 315, 319, 
	316, 670, 671, 672, 673, 674, 99, 99, 
	592, 277, 277, 652, 99, 666, 276, 667, 
	684, 100, 101, 669, 99, 669, 315, 319, 
	316, 670, 671, 672, 673, 674, 99, 99, 
	595, 592, 277, 277, 652, 99, 666, 276, 
	667, 100, 101, 669, 99, 669, 315, 319, 
	316, 670, 671, 672, 673, 674, 99, 99, 
	592, 668, 277, 277, 652, 135, 135, 136, 
	136, 136, 136, 136, 136, 137, 138, 139, 
	140, 141, 142, 135, 652, 99, 685, 686, 
	278, 100, 101, 688, 99, 688, 689, 690, 
	691, 692, 693, 694, 695, 696, 697, 698, 
	699, 700, 701, 702, 366, 703, 452, 704, 
	705, 706, 707, 708, 709, 710, 711, 712, 
	713, 714, 715, 99, 99, 277, 687, 687, 
	338, 472, 652, 99, 716, 717, 100, 101, 
	719, 720, 719, 721, 722, 719, 722, 99, 
	719, 720, 719, 721, 722, 719, 722, 689, 
	690, 691, 692, 693, 694, 695, 696, 697, 
	698, 699, 700, 701, 702, 366, 703, 452, 
	704, 705, 706, 723, 708, 709, 710, 711, 
	712, 713, 714, 715, 99, 99, 99, 718, 
	718, 338, 472, 652, 99, 685, 100, 101, 
	721, 99, 721, 689, 690, 691, 692, 693, 
	694, 695, 696, 697, 698, 699, 700, 701, 
	702, 366, 703, 452, 704, 705, 706, 707, 
	708, 709, 710, 711, 712, 713, 714, 715, 
	99, 99, 99, 718, 718, 338, 472, 652, 
	99, 685, 717, 100, 101, 721, 99, 721, 
	689, 690, 691, 692, 693, 694, 695, 696, 
	697, 698, 699, 700, 701, 702, 366, 703, 
	452, 704, 705, 706, 707, 708, 709, 710, 
	711, 712, 713, 714, 715, 99, 99, 99, 
	718, 718, 338, 472, 652, 99, 724, 717, 
	100, 101, 721, 99, 721, 689, 690, 691, 
	692, 693, 694, 695, 696, 697, 698, 699, 
	700, 701, 702, 366, 703, 452, 704, 705, 
	706, 725, 708, 709, 710, 711, 712, 713, 
	714, 715, 99, 99, 99, 718, 718, 338, 
	472, 652, 99, 716, 717, 100, 101, 719, 
	720, 719, 721, 722, 719, 726, 722, 99, 
	719, 720, 719, 721, 722, 719, 726, 722, 
	689, 690, 691, 692, 693, 694, 695, 696, 
	697, 698, 699, 700, 701, 702, 366, 703, 
	452, 704, 705, 706, 723, 708, 709, 710, 
	711, 712, 713, 714, 715, 99, 99, 99, 
	718, 718, 338, 472, 652, 658, 685, 717, 
	659, 660, 721, 658, 721, 689, 690, 691, 
	692, 693, 694, 695, 696, 697, 698, 699, 
	700, 701, 702, 366, 703, 452, 704, 705, 
	706, 707, 708, 709, 710, 711, 712, 713, 
	714, 715, 658, 658, 658, 718, 718, 338, 
	472, 657, 727, 728, 729, 729, 689, 690, 
	691, 692, 693, 694, 695, 696, 697, 698, 
	699, 700, 701, 702, 366, 703, 452, 704, 
	705, 706, 707, 708, 709, 710, 711, 712, 
	713, 714, 715, 329, 329, 338, 472, 652, 
	730, 728, 731, 732, 731, 729, 733, 731, 
	733, 731, 732, 731, 729, 733, 731, 733, 
	689, 690, 691, 692, 693, 694, 695, 696, 
	697, 698, 699, 700, 701, 702, 366, 703, 
	452, 704, 705, 706, 723, 708, 709, 710, 
	711, 712, 713, 714, 715, 329, 329, 338, 
	472, 652, 657, 661, 727, 729, 729, 689, 
	690, 691, 692, 693, 694, 695, 696, 697, 
	698, 699, 700, 701, 702, 366, 703, 452, 
	704, 705, 706, 707, 708, 709, 710, 711, 
	712, 713, 714, 715, 329, 329, 338, 472, 
	652, 734, 728, 729, 729, 689, 690, 691, 
	692, 693, 694, 695, 696, 697, 698, 699, 
	700, 701, 702, 366, 703, 452, 704, 705, 
	706, 725, 708, 709, 710, 711, 712, 713, 
	714, 715, 329, 329, 338, 472, 652, 730, 
	728, 731, 732, 731, 729, 733, 731, 735, 
	733, 731, 732, 731, 729, 733, 731, 735, 
	733, 689, 690, 691, 692, 693, 694, 695, 
	696, 697, 698, 699, 700, 701, 702, 366, 
	703, 452, 704, 705, 706, 723, 708, 709, 
	710, 711, 712, 713, 714, 715, 329, 329, 
	338, 472, 652, 727, 728, 729, 729, 689, 
	690, 691, 692, 693, 694, 695, 696, 697, 
	698, 699, 700, 701, 702, 366, 703, 452, 
	704, 705, 706, 707, 708, 709, 710, 711, 
	712, 713, 714, 715, 329, 329, 338, 472, 
	657, 730, 728, 736, 737, 736, 729, 738, 
	736, 738, 736, 737, 736, 729, 738, 736, 
	738, 689, 690, 691, 692, 693, 694, 695, 
	696, 697, 698, 699, 700, 701, 702, 366, 
	703, 452, 704, 705, 706, 723, 708, 709, 
	710, 711, 712, 713, 714, 715, 329, 329, 
	338, 472, 652, 727, 728, 729, 729, 689, 
	690, 691, 692, 693, 694, 695, 696, 697, 
	698, 699, 700, 701, 702, 366, 703, 452, 
	704, 705, 706, 707, 708, 709, 710, 711, 
	712, 713, 714, 715, 329, 329, 338, 472, 
	739, 727, 728, 740, 729, 740, 729, 689, 
	690, 691, 692, 693, 694, 695, 696, 697, 
	698, 699, 700, 701, 702, 366, 703, 452, 
	704, 705, 706, 707, 708, 709, 710, 711, 
	712, 713, 714, 715, 329, 329, 338, 472, 
	652, 727, 728, 729, 729, 689, 690, 691, 
	692, 693, 694, 695, 696, 697, 698, 699, 
	700, 701, 702, 366, 703, 452, 704, 705, 
	706, 707, 708, 709, 710, 711, 712, 713, 
	714, 715, 329, 329, 338, 472, 741, 727, 
	728, 740, 729, 740, 729, 689, 690, 691, 
	692, 693, 694, 695, 696, 697, 698, 699, 
	700, 701, 702, 366, 703, 452, 704, 705, 
	706, 707, 708, 709, 710, 711, 712, 713, 
	714, 715, 329, 329, 338, 472, 652, 739, 
	741, 727, 728, 735, 729, 735, 729, 689, 
	690, 691, 692, 693, 694, 695, 696, 697, 
	698, 699, 700, 701, 702, 366, 703, 452, 
	704, 705, 706, 707, 708, 709, 710, 711, 
	712, 713, 714, 715, 329, 329, 338, 472, 
	652, 727, 728, 729, 729, 689, 690, 691, 
	692, 693, 694, 695, 696, 697, 698, 699, 
	700, 701, 702, 366, 703, 452, 704, 705, 
	706, 707, 708, 709, 710, 711, 712, 713, 
	714, 715, 329, 329, 338, 472, 661, 727, 
	728, 735, 729, 735, 729, 689, 690, 691, 
	692, 693, 694, 695, 696, 697, 698, 699, 
	700, 701, 702, 366, 703, 452, 704, 705, 
	706, 707, 708, 709, 710, 711, 712, 713, 
	714, 715, 329, 329, 338, 472, 652, 730, 
	728, 736, 737, 736, 729, 738, 736, 740, 
	738, 736, 737, 736, 729, 738, 736, 740, 
	738, 689, 690, 691, 692, 693, 694, 695, 
	696, 697, 698, 699, 700, 701, 702, 366, 
	703, 452, 704, 705, 706, 723, 708, 709, 
	710, 711, 712, 713, 714, 715, 329, 329, 
	338, 472, 652, 99, 685, 717, 100, 101, 
	726, 721, 99, 726, 721, 689, 690, 691, 
	692, 693, 694, 695, 696, 697, 698, 699, 
	700, 701, 702, 366, 703, 452, 704, 705, 
	706, 707, 708, 709, 710, 711, 712, 713, 
	714, 715, 99, 99, 99, 718, 718, 338, 
	472, 652, 662, 685, 717, 663, 664, 721, 
	662, 721, 689, 690, 691, 692, 693, 694, 
	695, 696, 697, 698, 699, 700, 701, 702, 
	366, 703, 452, 704, 705, 706, 707, 708, 
	709, 710, 711, 712, 713, 714, 715, 662, 
	662, 662, 718, 718, 338, 472, 661, 99, 
	685, 717, 100, 101, 726, 721, 99, 726, 
	721, 689, 690, 691, 692, 693, 694, 695, 
	696, 697, 698, 699, 700, 701, 702, 366, 
	703, 452, 704, 705, 706, 707, 708, 709, 
	710, 711, 712, 713, 714, 715, 99, 99, 
	99, 718, 718, 338, 472, 652, 99, 685, 
	276, 100, 101, 743, 99, 743, 689, 690, 
	691, 692, 693, 694, 695, 696, 697, 698, 
	699, 700, 701, 702, 366, 703, 452, 704, 
	705, 706, 707, 708, 709, 710, 711, 712, 
	713, 714, 715, 99, 99, 277, 742, 742, 
	338, 472, 652, 99, 685, 686, 278, 100, 
	101, 743, 99, 743, 689, 690, 691, 692, 
	693, 694, 695, 696, 697, 698, 699, 700, 
	701, 702, 366, 703, 452, 704, 705, 706, 
	707, 708, 709, 710, 711, 712, 713, 714, 
	715, 99, 99, 277, 742, 742, 338, 472, 
	652, 99, 724, 686, 278, 100, 101, 743, 
	99, 743, 689, 690, 691, 692, 693, 694, 
	695, 696, 697, 698, 699, 700, 701, 702, 
	366, 703, 452, 704, 705, 706, 725, 708, 
	709, 710, 711, 712, 713, 714, 715, 99, 
	99, 277, 742, 742, 338, 472, 652, 99, 
	685, 686, 278, 100, 101, 745, 99, 745, 
	689, 690, 691, 692, 693, 694, 695, 696, 
	697, 698, 699, 700, 701, 702, 366, 703, 
	452, 704, 705, 706, 707, 708, 709, 710, 
	711, 712, 713, 714, 715, 99, 99, 277, 
	744, 744, 338, 472, 652, 99, 685, 686, 
	278, 746, 101, 745, 99, 745, 689, 690, 
	691, 692, 693, 694, 695, 696, 697, 698, 
	699, 700, 701, 702, 366, 703, 452, 704, 
	705, 706, 707, 708, 709, 710, 711, 712, 
	713, 714, 715, 99, 99, 277, 744, 744, 
	338, 472, 652, 99, 282, 283, 115, 290, 
	101, 99, 99, 99, 279, 279, 279, 652, 
	99, 282, 283, 115, 290, 101, 99, 99, 
	99, 574, 279, 279, 652, 99, 282, 283, 
	115, 290, 101, 99, 99, 99, 571, 279, 
	279, 652, 99, 282, 283, 115, 747, 290, 
	101, 99, 99, 99, 574, 571, 279, 279, 
	652, 99, 282, 283, 115, 290, 101, 99, 
	99, 99, 571, 279, 279, 279, 652, 99, 
	724, 686, 278, 746, 101, 745, 99, 745, 
	689, 690, 691, 692, 693, 694, 695, 696, 
	697, 698, 699, 700, 701, 702, 366, 703, 
	452, 704, 705, 706, 725, 708, 709, 710, 
	711, 712, 713, 714, 715, 99, 99, 277, 
	744, 744, 338, 472, 652, 99, 724, 686, 
	278, 100, 101, 745, 99, 745, 689, 690, 
	691, 692, 693, 694, 695, 696, 697, 698, 
	699, 700, 701, 702, 366, 703, 452, 704, 
	705, 706, 725, 708, 709, 710, 711, 712, 
	713, 714, 715, 99, 99, 277, 744, 744, 
	338, 472, 652, 99, 685, 686, 278, 100, 
	101, 748, 688, 99, 748, 688, 689, 690, 
	691, 692, 693, 694, 695, 696, 697, 698, 
	699, 700, 701, 702, 366, 703, 452, 704, 
	705, 706, 707, 708, 709, 710, 711, 712, 
	713, 714, 715, 99, 99, 277, 687, 687, 
	338, 472, 652, 99, 685, 686, 278, 100, 
	101, 749, 99, 749, 689, 690, 691, 692, 
	693, 694, 695, 696, 697, 698, 699, 700, 
	701, 702, 366, 703, 452, 704, 705, 706, 
	707, 708, 709, 710, 711, 712, 713, 714, 
	715, 99, 99, 277, 744, 744, 338, 472, 
	652, 99, 724, 686, 278, 746, 101, 750, 
	99, 750, 689, 690, 691, 692, 693, 694, 
	695, 696, 697, 698, 699, 700, 701, 702, 
	366, 703, 452, 704, 705, 706, 725, 708, 
	709, 710, 711, 712, 713, 714, 715, 99, 
	99, 277, 744, 744, 338, 472, 652, 99, 
	724, 686, 278, 746, 101, 745, 751, 99, 
	745, 751, 689, 690, 691, 692, 693, 694, 
	695, 696, 697, 698, 699, 700, 701, 702, 
	366, 703, 452, 704, 705, 706, 725, 708, 
	709, 710, 711, 712, 713, 714, 715, 99, 
	99, 277, 744, 744, 338, 472, 652, 99, 
	685, 686, 278, 746, 101, 745, 752, 99, 
	745, 752, 689, 690, 691, 692, 693, 694, 
	695, 696, 697, 698, 699, 700, 701, 702, 
	366, 703, 452, 704, 705, 706, 707, 708, 
	709, 710, 711, 712, 713, 714, 715, 99, 
	99, 277, 744, 744, 338, 472, 652, 662, 
	685, 686, 753, 755, 664, 745, 662, 745, 
	689, 690, 691, 692, 693, 694, 695, 696, 
	697, 698, 699, 700, 701, 702, 366, 703, 
	452, 704, 705, 706, 707, 708, 709, 710, 
	711, 712, 713, 714, 715, 662, 662, 754, 
	744, 744, 338, 472, 661, 99, 756, 686, 
	278, 100, 101, 688, 99, 688, 689, 690, 
	691, 692, 693, 694, 695, 696, 697, 698, 
	699, 700, 701, 702, 366, 703, 452, 704, 
	705, 706, 757, 708, 709, 710, 711, 712, 
	713, 714, 715, 99, 99, 277, 687, 687, 
	338, 472, 652, 99, 716, 717, 100, 101, 
	719, 720, 719, 721, 722, 719, 722, 758, 
	99, 719, 720, 719, 721, 722, 719, 722, 
	758, 689, 690, 691, 692, 693, 694, 695, 
	696, 697, 698, 699, 700, 701, 702, 366, 
	703, 452, 704, 705, 706, 723, 708, 709, 
	710, 711, 712, 713, 714, 715, 99, 99, 
	99, 718, 718, 338, 472, 652, 99, 685, 
	717, 100, 101, 719, 721, 99, 719, 721, 
	689, 690, 691, 692, 693, 694, 695, 696, 
	697, 698, 699, 700, 701, 702, 366, 703, 
	452, 704, 705, 706, 707, 708, 709, 710, 
	711, 712, 713, 714, 715, 99, 99, 99, 
	718, 718, 338, 472, 652, 730, 728, 736, 
	737, 736, 729, 738, 736, 738, 759, 736, 
	737, 736, 729, 738, 736, 738, 759, 689, 
	690, 691, 692, 693, 694, 695, 696, 697, 
	698, 699, 700, 701, 702, 366, 703, 452, 
	704, 705, 706, 723, 708, 709, 710, 711, 
	712, 713, 714, 715, 329, 329, 338, 472, 
	652, 727, 728, 731, 729, 731, 729, 689, 
	690, 691, 692, 693, 694, 695, 696, 697, 
	698, 699, 700, 701, 702, 366, 703, 452, 
	704, 705, 706, 707, 708, 709, 710, 711, 
	712, 713, 714, 715, 329, 329, 338, 472, 
	652, 99, 685, 686, 278, 100, 101, 760, 
	688, 761, 99, 760, 688, 761, 689, 690, 
	691, 692, 693, 694, 695, 696, 697, 698, 
	699, 700, 701, 702, 366, 703, 452, 704, 
	705, 706, 707, 708, 709, 710, 711, 712, 
	713, 714, 715, 99, 99, 277, 687, 687, 
	338, 472, 652, 99, 685, 686, 278, 100, 
	101, 762, 745, 99, 762, 745, 689, 690, 
	691, 692, 693, 694, 695, 696, 697, 698, 
	699, 700, 701, 702, 366, 703, 452, 704, 
	705, 706, 707, 708, 709, 710, 711, 712, 
	713, 714, 715, 99, 99, 277, 744, 744, 
	338, 472, 652, 99, 685, 686, 278, 746, 
	101, 763, 745, 99, 763, 745, 689, 690, 
	691, 692, 693, 694, 695, 696, 697, 698, 
	699, 700, 701, 702, 366, 703, 452, 704, 
	705, 706, 707, 708, 709, 710, 711, 712, 
	713, 714, 715, 99, 99, 277, 744, 744, 
	338, 472, 652, 99, 685, 686, 278, 746, 
	101, 764, 745, 99, 764, 745, 689, 690, 
	691, 692, 693, 694, 695, 696, 697, 698, 
	699, 700, 701, 702, 366, 703, 452, 704, 
	705, 706, 707, 708, 709, 710, 711, 712, 
	713, 714, 715, 99, 99, 277, 744, 744, 
	338, 472, 652, 658, 685, 686, 765, 767, 
	660, 745, 658, 745, 689, 690, 691, 692, 
	693, 694, 695, 696, 697, 698, 699, 700, 
	701, 702, 366, 703, 452, 704, 705, 706, 
	707, 708, 709, 710, 711, 712, 713, 714, 
	715, 658, 658, 766, 744, 744, 338, 472, 
	657, 99, 685, 686, 278, 100, 101, 768, 
	769, 99, 768, 769, 689, 690, 691, 692, 
	693, 694, 695, 696, 697, 698, 699, 700, 
	701, 702, 366, 703, 452, 704, 705, 706, 
	707, 708, 709, 710, 711, 712, 713, 714, 
	715, 99, 99, 277, 744, 744, 338, 472, 
	652, 99, 724, 686, 278, 746, 101, 770, 
	99, 770, 689, 690, 691, 692, 693, 694, 
	695, 696, 697, 698, 699, 700, 701, 702, 
	366, 703, 452, 704, 705, 706, 725, 708, 
	709, 710, 711, 712, 713, 714, 715, 99, 
	99, 277, 744, 744, 338, 472, 652, 99, 
	724, 686, 278, 746, 101, 764, 745, 99, 
	764, 745, 689, 690, 691, 692, 693, 694, 
	695, 696, 697, 698, 699, 700, 701, 702, 
	366, 703, 452, 704, 705, 706, 725, 708, 
	709, 710, 711, 712, 713, 714, 715, 99, 
	99, 277, 744, 744, 338, 472, 652, 99, 
	685, 686, 278, 746, 101, 745, 771, 99, 
	745, 771, 689, 690, 691, 692, 693, 694, 
	695, 696, 697, 698, 699, 700, 701, 702, 
	366, 703, 452, 704, 705, 706, 707, 708, 
	709, 710, 711, 712, 713, 714, 715, 99, 
	99, 277, 744, 744, 338, 472, 652, 99, 
	685, 686, 278, 746, 101, 764, 745, 99, 
	764, 745, 689, 690, 691, 692, 693, 694, 
	695, 696, 697, 698, 699, 700, 701, 702, 
	366, 703, 452, 704, 705, 706, 707, 708, 
	709, 710, 711, 712, 713, 714, 715, 99, 
	99, 277, 744, 744, 338, 472, 652, 99, 
	685, 686, 278, 100, 101, 760, 688, 99, 
	760, 688, 689, 690, 691, 692, 693, 694, 
	695, 696, 697, 698, 699, 700, 701, 702, 
	366, 703, 452, 704, 705, 706, 707, 708, 
	709, 710, 711, 712, 713, 714, 715, 99, 
	99, 277, 687, 687, 338, 472, 652, 99, 
	685, 686, 278, 100, 101, 688, 772, 99, 
	688, 772, 689, 690, 691, 692, 693, 694, 
	695, 696, 697, 698, 699, 700, 701, 702, 
	366, 703, 452, 704, 705, 706, 707, 708, 
	709, 710, 711, 712, 713, 714, 715, 99, 
	99, 277, 687, 687, 338, 472, 652, 99, 
	685, 686, 278, 100, 101, 745, 773, 99, 
	745, 773, 689, 690, 691, 692, 693, 694, 
	695, 696, 697, 698, 699, 700, 701, 702, 
	366, 703, 452, 704, 705, 706, 707, 708, 
	709, 710, 711, 712, 713, 714, 715, 99, 
	99, 277, 744, 744, 338, 472, 652, 99, 
	685, 686, 278, 746, 101, 774, 745, 99, 
	774, 745, 689, 690, 691, 692, 693, 694, 
	695, 696, 697, 698, 699, 700, 701, 702, 
	366, 703, 452, 704, 705, 706, 707, 708, 
	709, 710, 711, 712, 713, 714, 715, 99, 
	99, 277, 744, 744, 338, 472, 652, 99, 
	775, 686, 278, 746, 101, 745, 99, 745, 
	689, 690, 691, 692, 693, 694, 695, 696, 
	697, 698, 699, 700, 701, 702, 366, 703, 
	452, 704, 705, 706, 776, 708, 709, 710, 
	711, 712, 713, 714, 715, 99, 99, 277, 
	744, 744, 338, 472, 652, 99, 716, 717, 
	100, 101, 719, 720, 719, 777, 722, 719, 
	722, 99, 719, 720, 719, 777, 722, 719, 
	722, 689, 690, 691, 692, 693, 694, 695, 
	696, 697, 698, 699, 700, 701, 702, 366, 
	703, 452, 704, 705, 706, 723, 708, 709, 
	710, 711, 712, 713, 714, 715, 99, 99, 
	99, 718, 718, 338, 472, 652, 658, 724, 
	717, 659, 660, 721, 658, 721, 689, 690, 
	691, 692, 693, 694, 695, 696, 697, 698, 
	699, 700, 701, 702, 366, 703, 452, 704, 
	705, 706, 725, 708, 709, 710, 711, 712, 
	713, 714, 715, 658, 658, 658, 718, 718, 
	338, 472, 657, 730, 728, 736, 737, 736, 
	778, 738, 736, 738, 736, 737, 736, 778, 
	738, 736, 738, 689, 690, 691, 692, 693, 
	694, 695, 696, 697, 698, 699, 700, 701, 
	702, 366, 703, 452, 704, 705, 706, 723, 
	708, 709, 710, 711, 712, 713, 714, 715, 
	329, 329, 338, 472, 652, 734, 728, 729, 
	729, 689, 690, 691, 692, 693, 694, 695, 
	696, 697, 698, 699, 700, 701, 702, 366, 
	703, 452, 704, 705, 706, 725, 708, 709, 
	710, 711, 712, 713, 714, 715, 329, 329, 
	338, 472, 739, 99, 685, 686, 278, 100, 
	101, 779, 688, 99, 779, 688, 689, 690, 
	691, 692, 693, 694, 695, 696, 697, 698, 
	699, 700, 701, 702, 366, 703, 452, 704, 
	705, 706, 707, 708, 709, 710, 711, 712, 
	713, 714, 715, 99, 99, 277, 687, 687, 
	338, 472, 652, 99, 685, 686, 278, 100, 
	101, 768, 99, 768, 689, 690, 691, 692, 
	693, 694, 695, 696, 697, 698, 699, 700, 
	701, 702, 366, 703, 452, 704, 705, 706, 
	707, 708, 709, 710, 711, 712, 713, 714, 
	715, 99, 99, 277, 744, 744, 338, 472, 
	652, 167, 780, 652, 605, 652, 781, 782, 
	782, 782, 605, 652, 1, 640, 641, 1, 
	642, 643, 644, 645, 605, 639, 727, 728, 
	729, 729, 689, 690, 691, 692, 693, 694, 
	695, 696, 697, 698, 699, 700, 701, 702, 
	366, 703, 452, 704, 705, 706, 707, 708, 
	709, 710, 711, 712, 713, 714, 715, 329, 
	329, 605, 338, 472, 652, 605, 605, 782, 
	652, 782, 652, 782, 782, 782, 605, 782, 
	605, 782, 605, 652, 605, 605, 605, 782, 
	605, 782, 652, 782, 605, 605, 605, 605, 
	782, 652, 605, 782, 652, 782, 605, 782, 
	652, 605, 782, 652, 782, 782, 605, 782, 
	652, 782, 605, 652, 605, 782, 605, 782, 
	605, 652, 605, 782, 652, 605, 782, 605, 
	783, 605, 782, 652, 678, 679, 677, 677, 
	315, 319, 316, 670, 671, 672, 673, 674, 
	312, 605, 652, 605, 782, 782, 605, 782, 
	605, 782, 783, 782, 605, 652, 782, 605, 
	782, 605, 652, 605, 782, 652, 782, 782, 
	605, 652, 782, 783, 782, 605, 782, 605, 
	652, 784, 785, 786, 787, 788, 789, 790, 
	791, 792, 793, 794, 795, 796, 797, 798, 
	799, 800, 801, 802, 803, 804, 805, 806, 
	807, 808, 809, 810, 811, 812, 813, 605, 
	652, 782, 782, 782, 782, 605, 652, 782, 
	605, 652, 605, 782, 605, 652, 782, 605, 
	782, 605, 652, 782, 605, 605, 782, 605, 
	783, 782, 652, 782, 605, 605, 782, 605, 
	782, 605, 782, 605, 782, 605, 782, 605, 
	652, 782, 605, 605, 782, 605, 783, 782, 
	605, 652, 605, 605, 605, 605, 605, 782, 
	605, 782, 605, 782, 605, 652, 605, 605, 
	782, 605, 783, 605, 782, 605, 652, 605, 
	605, 605, 605, 605, 782, 605, 782, 605, 
	652, 782, 605, 782, 605, 783, 605, 652, 
	605, 605, 605, 782, 605, 782, 605, 782, 
	605, 782, 605, 652, 605, 782, 605, 782, 
	605, 783, 605, 652, 782, 605, 605, 605, 
	605, 782, 605, 782, 605, 782, 605, 782, 
	605, 782, 605, 782, 605, 652, 782, 605, 
	783, 605, 652, 605, 605, 605, 782, 605, 
	782, 605, 652, 605, 782, 605, 782, 605, 
	783, 605, 652, 605, 605, 605, 605, 782, 
	605, 782, 605, 652, 782, 605, 605, 782, 
	605, 783, 782, 605, 652, 605, 605, 782, 
	605, 782, 605, 652, 782, 605, 782, 605, 
	783, 605, 782, 652, 605, 605, 605, 782, 
	605, 782, 605, 652, 782, 605, 783, 605, 
	652, 605, 605, 782, 605, 652, 782, 605, 
	783, 605, 652, 605, 605, 605, 782, 605, 
	605, 605, 605, 605, 605, 782, 782, 605, 
	782, 605, 782, 605, 782, 605, 652, 605, 
	782, 605, 783, 605, 782, 605, 652, 782, 
	605, 783, 605, 652, 605, 782, 605, 652, 
	605, 782, 605, 652, 814, 815, 816, 817, 
	818, 819, 820, 821, 822, 823, 824, 825, 
	826, 827, 828, 829, 830, 831, 832, 833, 
	834, 835, 836, 837, 838, 839, 840, 841, 
	842, 843, 605, 844, 845, 846, 847, 848, 
	849, 605, 850, 605, 851, 852, 853, 854, 
	608, 652, 782, 782, 605, 652, 782, 783, 
	605, 782, 605, 782, 605, 782, 605, 782, 
	605, 782, 652, 782, 782, 605, 783, 605, 
	782, 652, 605, 782, 605, 782, 605, 782, 
	652, 605, 605, 605, 782, 605, 782, 605, 
	782, 652, 605, 605, 605, 782, 605, 782, 
	605, 782, 652, 605, 605, 782, 605, 782, 
	652, 605, 782, 605, 782, 652, 782, 605, 
	652, 782, 605, 782, 652, 782, 605, 652, 
	605, 782, 652, 782, 605, 782, 652, 781, 
	782, 605, 782, 652, 782, 605, 782, 605, 
	652, 605, 782, 605, 782, 605, 652, 605, 
	782, 605, 782, 605, 652, 782, 605, 652, 
	782, 782, 605, 783, 605, 652, 605, 783, 
	605, 782, 652, 782, 605, 652, 605, 782, 
	605, 782, 652, 782, 605, 652, 782, 605, 
	652, 605, 783, 782, 605, 782, 605, 652, 
	782, 605, 652, 605, 782, 605, 783, 605, 
	652, 782, 605, 782, 652, 782, 605, 652, 
	782, 783, 605, 783, 605, 652, 605, 782, 
	605, 652, 605, 782, 605, 783, 605, 652, 
	605, 782, 605, 782, 783, 782, 652, 782, 
	605, 652, 782, 605, 652, 783, 605, 782, 
	783, 782, 605, 652, 605, 605, 782, 605, 
	782, 605, 652, 782, 605, 782, 605, 782, 
	652, 605, 605, 605, 605, 782, 605, 782, 
	605, 782, 605, 652, 605, 605, 605, 782, 
	652, 605, 605, 605, 782, 605, 782, 605, 
	782, 605, 782, 605, 782, 605, 652, 855, 
	856, 857, 858, 859, 860, 861, 862, 608, 
	863, 864, 865, 866, 867, 868, 605, 652, 
	869, 870, 871, 781, 781, 605, 652, 167, 
	780, 605, 652, 167, 872, 872, 656, 605, 
	652, 135, 135, 136, 136, 136, 136, 136, 
	136, 137, 138, 139, 140, 141, 142, 135, 
	605, 652, 781, 782, 782, 605, 652, 605, 
	782, 605, 652, 782, 782, 605, 782, 782, 
	782, 605, 605, 782, 605, 782, 605, 782, 
	605, 782, 652, 782, 605, 782, 605, 652, 
	605, 782, 605, 652, 605, 782, 652, 605, 
	782, 652, 782, 605, 782, 605, 782, 605, 
	652, 605, 782, 782, 605, 782, 652, 782, 
	782, 605, 652, 605, 605, 605, 605, 782, 
	605, 782, 652, 605, 605, 605, 782, 605, 
	652, 782, 605, 652, 873, 825, 874, 875, 
	876, 608, 877, 878, 605, 608, 652, 781, 
	605, 782, 605, 782, 605, 782, 605, 652, 
	605, 782, 605, 782, 652, 605, 782, 652, 
	605, 782, 605, 782, 652, 782, 605, 782, 
	605, 652, 605, 782, 652, 836, 605, 608, 
	652, 608, 652, 879, 608, 652, 782, 605, 
	652, 879, 880, 881, 882, 883, 847, 884, 
	885, 886, 887, 831, 888, 889, 890, 891, 
	892, 893, 894, 895, 896, 897, 898, 899, 
	605, 900, 608, 652, 605, 782, 605, 652, 
	782, 605, 782, 783, 782, 605, 652, 782, 
	782, 605, 652, 782, 605, 782, 652, 605, 
	782, 605, 782, 652, 605, 782, 605, 782, 
	605, 782, 605, 652, 605, 782, 652, 605, 
	605, 605, 782, 605, 652, 605, 782, 605, 
	652, 782, 605, 783, 605, 782, 605, 652, 
	783, 782, 605, 782, 652, 782, 605, 782, 
	605, 652, 605, 782, 605, 652, 782, 605, 
	605, 605, 783, 605, 782, 783, 782, 652, 
	782, 605, 652, 605, 782, 782, 605, 783, 
	605, 782, 605, 782, 652, 605, 782, 605, 
	782, 605, 782, 605, 652, 605, 782, 605, 
	782, 605, 782, 605, 782, 605, 652, 605, 
	605, 605, 782, 605, 782, 605, 782, 605, 
	782, 652, 605, 782, 605, 782, 605, 652, 
	782, 605, 783, 605, 652, 901, 902, 608, 
	605, 652, 782, 605, 782, 652, 782, 605, 
	782, 605, 652, 903, 904, 905, 906, 907, 
	908, 909, 910, 911, 912, 605, 913, 914, 
	915, 916, 917, 918, 605, 608, 652, 782, 
	605, 782, 652, 782, 605, 652, 782, 605, 
	605, 605, 605, 782, 605, 782, 605, 782, 
	652, 605, 605, 782, 652, 782, 605, 652, 
	605, 782, 652, 782, 605, 652, 605, 782, 
	652, 782, 605, 782, 652, 782, 605, 782, 
	605, 652, 605, 605, 782, 652, 782, 605, 
	652, 605, 783, 605, 782, 605, 652, 605, 
	782, 605, 782, 652, 605, 782, 652, 605, 
	782, 605, 782, 605, 782, 605, 782, 605, 
	652, 919, 920, 921, 922, 923, 924, 925, 
	926, 927, 928, 929, 605, 630, 605, 652, 
	930, 931, 608, 932, 933, 934, 935, 936, 
	883, 937, 938, 939, 848, 940, 941, 942, 
	943, 837, 944, 945, 946, 947, 948, 949, 
	836, 950, 951, 608, 952, 605, 608, 605, 
	608, 605, 652, 605, 605, 605, 605, 782, 
	652, 782, 605, 782, 605, 652, 782, 605, 
	652, 782, 605, 782, 652, 782, 605, 652, 
	782, 605, 782, 652, 605, 782, 605, 782, 
	605, 652, 782, 605, 782, 605, 652, 782, 
	605, 783, 605, 652, 782, 605, 782, 652, 
	782, 605, 652, 782, 605, 782, 605, 652, 
	782, 605, 782, 782, 782, 605, 782, 605, 
	652, 782, 605, 782, 605, 652, 782, 605, 
	782, 605, 652, 782, 605, 782, 652, 782, 
	605, 605, 605, 782, 605, 652, 605, 782, 
	605, 652, 782, 605, 652, 605, 782, 605, 
	652, 782, 605, 782, 605, 652, 782, 605, 
	652, 782, 605, 652, 953, 954, 955, 956, 
	957, 958, 959, 960, 961, 878, 962, 795, 
	963, 964, 965, 966, 964, 967, 968, 969, 
	618, 970, 971, 605, 652, 605, 782, 605, 
	652, 605, 783, 605, 652, 605, 782, 605, 
	652, 605, 782, 605, 783, 605, 652, 605, 
	782, 605, 783, 652, 782, 605, 782, 605, 
	652, 605, 782, 605, 652, 605, 782, 782, 
	605, 783, 605, 652, 605, 782, 605, 652, 
	782, 605, 783, 605, 652, 605, 782, 605, 
	652, 782, 605, 652, 605, 605, 782, 605, 
	783, 605, 652, 782, 605, 652, 782, 605, 
	783, 605, 652, 782, 605, 652, 783, 605, 
	652, 782, 782, 783, 605, 652, 782, 605, 
	652, 785, 608, 605, 652, 966, 608, 605, 
	652, 971, 972, 973, 964, 974, 975, 608, 
	976, 977, 605, 608, 605, 652, 605, 782, 
	783, 605, 652, 605, 782, 605, 652, 782, 
	605, 783, 605, 782, 605, 782, 652, 782, 
	605, 652, 782, 782, 605, 652, 605, 782, 
	605, 652, 978, 608, 979, 980, 605, 652, 
	782, 605, 652, 782, 605, 782, 605, 652, 
	782, 605, 782, 605, 652, 981, 982, 983, 
	984, 985, 986, 987, 988, 989, 990, 991, 
	605, 608, 605, 652, 605, 782, 652, 605, 
	782, 605, 605, 605, 782, 605, 782, 605, 
	782, 652, 605, 782, 652, 605, 605, 605, 
	605, 605, 782, 605, 782, 652, 605, 605, 
	782, 605, 782, 652, 782, 605, 782, 652, 
	605, 605, 605, 782, 652, 605, 605, 782, 
	652, 605, 605, 782, 652, 605, 605, 782, 
	652, 605, 782, 605, 783, 652, 992, 993, 
	994, 995, 605, 608, 605, 652, 782, 605, 
	652, 605, 605, 605, 782, 605, 605, 605, 
	782, 605, 782, 605, 652, 782, 782, 782, 
	782, 605, 605, 782, 782, 782, 782, 782, 
	605, 605, 605, 605, 605, 605, 605, 782, 
	605, 782, 605, 782, 652, 605, 605, 605, 
	782, 605, 782, 605, 652, 996, 608, 652, 
	782, 605, 652, 824, 997, 608, 605, 652, 
	782, 605, 652, 997, 605, 608, 605, 652, 
	99, 168, 100, 101, 99, 99, 99, 99, 
	99, 99, 652, 99, 168, 100, 101, 99, 
	315, 319, 316, 670, 671, 672, 673, 674, 
	99, 99, 998, 99, 99, 652, 99, 666, 
	675, 100, 101, 676, 99, 676, 315, 319, 
	316, 670, 671, 672, 673, 674, 99, 99, 
	998, 99, 99, 652, 99, 100, 101, 99, 
	315, 319, 316, 670, 671, 672, 673, 674, 
	99, 99, 998, 99, 99, 652, 0
};

static const short _english_tokenizer_trans_targs[] = {
	599, 600, 3, 5, 6, 599, 8, 9, 
	599, 91, 11, 12, 13, 14, 15, 16, 
	17, 18, 19, 20, 21, 22, 23, 24, 
	25, 26, 27, 92, 94, 97, 58, 64, 
	70, 10, 29, 39, 56, 28, 30, 31, 
	32, 33, 34, 35, 36, 37, 38, 40, 
	41, 42, 43, 44, 45, 46, 47, 48, 
	49, 50, 51, 52, 53, 54, 55, 57, 
	59, 60, 61, 62, 63, 65, 66, 67, 
	68, 69, 71, 73, 74, 72, 75, 76, 
	77, 78, 79, 80, 81, 82, 83, 84, 
	85, 86, 87, 88, 89, 90, 93, 95, 
	96, 98, 599, 99, 100, 102, 101, 103, 
	124, 126, 125, 105, 104, 111, 106, 107, 
	110, 610, 108, 611, 612, 613, 112, 120, 
	122, 121, 113, 114, 116, 118, 117, 115, 
	614, 615, 617, 616, 119, 123, 127, 8, 
	128, 129, 130, 132, 134, 144, 146, 131, 
	133, 135, 136, 137, 138, 139, 140, 141, 
	142, 143, 145, 147, 148, 149, 150, 151, 
	152, 154, 155, 621, 156, 622, 158, 599, 
	619, 161, 247, 248, 249, 250, 253, 256, 
	258, 259, 162, 228, 229, 230, 231, 234, 
	237, 239, 240, 625, 206, 210, 211, 212, 
	215, 218, 220, 221, 626, 185, 188, 189, 
	190, 193, 196, 198, 199, 165, 627, 166, 
	167, 168, 169, 172, 175, 177, 178, 628, 
	170, 171, 173, 174, 176, 179, 180, 182, 
	183, 181, 184, 629, 187, 191, 192, 194, 
	195, 197, 200, 201, 203, 204, 202, 205, 
	630, 208, 209, 213, 214, 216, 217, 219, 
	222, 223, 225, 226, 224, 227, 232, 233, 
	235, 236, 238, 241, 242, 244, 245, 243, 
	246, 251, 252, 254, 255, 257, 260, 261, 
	263, 264, 262, 265, 267, 268, 269, 270, 
	276, 278, 271, 272, 273, 275, 631, 632, 
	633, 277, 274, 279, 634, 637, 639, 638, 
	282, 289, 291, 290, 283, 284, 285, 287, 
	286, 288, 292, 294, 636, 635, 297, 642, 
	643, 302, 303, 298, 300, 305, 306, 299, 
	308, 311, 312, 314, 315, 313, 316, 318, 
	319, 656, 658, 322, 323, 659, 343, 344, 
	345, 346, 325, 347, 348, 349, 350, 351, 
	352, 353, 354, 355, 356, 357, 358, 359, 
	360, 361, 362, 363, 364, 365, 366, 367, 
	368, 369, 370, 371, 372, 373, 338, 375, 
	376, 377, 378, 379, 380, 381, 382, 383, 
	384, 385, 386, 387, 388, 389, 390, 391, 
	392, 393, 394, 395, 396, 397, 398, 399, 
	400, 401, 402, 403, 404, 405, 406, 407, 
	408, 409, 410, 411, 413, 552, 553, 554, 
	555, 556, 557, 558, 559, 560, 561, 562, 
	563, 564, 565, 664, 415, 416, 417, 418, 
	419, 420, 424, 426, 427, 428, 429, 430, 
	431, 432, 433, 434, 435, 436, 437, 438, 
	439, 440, 441, 442, 443, 444, 446, 447, 
	449, 450, 451, 452, 340, 453, 454, 455, 
	456, 457, 458, 459, 460, 461, 462, 463, 
	465, 492, 507, 509, 511, 516, 520, 535, 
	422, 540, 542, 543, 466, 467, 468, 469, 
	470, 471, 472, 473, 474, 475, 476, 477, 
	478, 479, 480, 481, 482, 483, 484, 485, 
	486, 487, 488, 489, 490, 491, 493, 494, 
	495, 496, 497, 498, 499, 500, 501, 502, 
	503, 504, 505, 506, 508, 510, 512, 513, 
	514, 515, 517, 518, 519, 521, 522, 523, 
	524, 525, 526, 527, 528, 529, 530, 531, 
	532, 533, 534, 536, 537, 538, 539, 541, 
	545, 546, 548, 549, 669, 550, 551, 670, 
	567, 674, 569, 570, 571, 585, 587, 586, 
	572, 573, 581, 583, 582, 574, 575, 577, 
	579, 578, 576, 683, 684, 686, 685, 580, 
	584, 588, 590, 699, 592, 718, 594, 596, 
	597, 598, 604, 608, 609, 620, 0, 623, 
	624, 644, 646, 645, 648, 649, 690, 696, 
	701, 711, 712, 720, 722, 723, 724, 727, 
	728, 729, 730, 731, 732, 733, 734, 735, 
	736, 737, 738, 739, 741, 742, 743, 744, 
	745, 746, 777, 819, 837, 844, 845, 846, 
	848, 870, 873, 890, 970, 971, 973, 599, 
	601, 603, 1, 2, 4, 7, 602, 605, 
	606, 599, 599, 607, 599, 109, 618, 153, 
	157, 599, 99, 100, 102, 599, 99, 100, 
	102, 159, 160, 280, 641, 296, 301, 304, 
	307, 309, 310, 163, 164, 186, 207, 266, 
	281, 293, 640, 295, 647, 650, 678, 681, 
	689, 320, 324, 326, 327, 328, 329, 330, 
	331, 332, 333, 334, 335, 336, 337, 339, 
	341, 342, 374, 412, 414, 421, 423, 425, 
	445, 448, 464, 544, 317, 651, 652, 655, 
	675, 653, 677, 547, 654, 566, 676, 657, 
	660, 661, 321, 663, 671, 673, 662, 672, 
	665, 666, 668, 599, 667, 599, 679, 680, 
	682, 688, 568, 687, 691, 692, 693, 694, 
	695, 269, 268, 568, 697, 589, 698, 700, 
	702, 706, 703, 704, 705, 269, 268, 568, 
	707, 709, 708, 710, 713, 714, 715, 716, 
	591, 717, 719, 721, 593, 725, 726, 740, 
	747, 748, 749, 750, 751, 752, 753, 754, 
	755, 756, 757, 758, 759, 760, 761, 762, 
	763, 764, 765, 766, 767, 768, 769, 770, 
	771, 772, 773, 774, 775, 776, 778, 779, 
	780, 781, 782, 783, 784, 785, 786, 787, 
	788, 789, 790, 791, 792, 793, 794, 795, 
	796, 797, 798, 799, 800, 801, 802, 803, 
	804, 805, 806, 807, 808, 809, 810, 811, 
	812, 813, 814, 815, 816, 817, 818, 820, 
	824, 825, 826, 827, 828, 829, 830, 831, 
	832, 833, 834, 835, 836, 821, 822, 823, 
	595, 838, 839, 840, 841, 842, 843, 847, 
	849, 850, 851, 852, 853, 854, 855, 856, 
	857, 858, 859, 860, 861, 862, 863, 864, 
	865, 866, 867, 868, 869, 871, 872, 874, 
	875, 876, 877, 878, 879, 880, 881, 882, 
	883, 884, 885, 886, 887, 888, 889, 891, 
	915, 935, 936, 937, 944, 948, 960, 965, 
	967, 969, 892, 893, 894, 895, 896, 897, 
	898, 899, 900, 901, 902, 903, 904, 905, 
	906, 907, 908, 909, 910, 911, 912, 913, 
	914, 916, 917, 918, 919, 920, 921, 922, 
	923, 924, 925, 926, 927, 928, 929, 930, 
	931, 932, 933, 934, 938, 939, 940, 941, 
	942, 943, 945, 946, 947, 949, 950, 951, 
	952, 953, 954, 955, 956, 957, 958, 959, 
	961, 962, 963, 964, 966, 968, 972
};

static const char _english_tokenizer_trans_actions[] = {
	1, 2, 0, 0, 0, 3, 0, 0, 
	4, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 5, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 6, 0, 2, 0, 6, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	6, 6, 6, 6, 0, 0, 0, 7, 
	0, 7, 0, 7, 7, 7, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 8, 0, 8, 0, 9, 
	6, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 6, 0, 0, 0, 0, 
	0, 0, 0, 0, 6, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 6, 0, 
	0, 0, 0, 0, 0, 0, 0, 2, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 2, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	2, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 6, 6, 
	6, 0, 0, 0, 6, 6, 6, 6, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 6, 6, 0, 6, 
	2, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 6, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 6, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 6, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 6, 6, 6, 6, 0, 
	0, 0, 0, 6, 0, 6, 0, 0, 
	0, 0, 2, 2, 6, 6, 0, 6, 
	6, 6, 6, 6, 2, 6, 6, 6, 
	6, 6, 6, 6, 2, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 6, 6, 6, 12, 
	2, 2, 0, 0, 0, 0, 2, 0, 
	2, 13, 14, 0, 15, 0, 6, 0, 
	0, 16, 17, 17, 17, 18, 19, 19, 
	19, 0, 0, 0, 6, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 6, 0, 6, 6, 6, 6, 
	6, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 6, 6, 8, 
	6, 6, 6, 0, 6, 0, 8, 6, 
	6, 6, 0, 8, 6, 6, 6, 8, 
	8, 6, 6, 20, 8, 21, 6, 6, 
	6, 6, 0, 6, 6, 6, 6, 6, 
	8, 19, 19, 19, 6, 0, 6, 6, 
	6, 6, 6, 6, 8, 17, 17, 17, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	0, 8, 8, 6, 0, 2, 6, 2, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 2, 2, 2, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 6
};

static const char _english_tokenizer_to_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 10, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0
};

static const char _english_tokenizer_from_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 11, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0
};

static const short _english_tokenizer_eof_trans[] = {
	0, 1, 1, 1, 1, 1, 1, 1, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 6, 6, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 6, 
	99, 6, 6, 6, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 6, 6, 6, 6, 6, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 6, 6, 6, 
	6, 6, 6, 6, 6, 6, 6, 0, 
	640, 640, 640, 640, 640, 650, 640, 650, 
	640, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 658, 662, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 658, 
	653, 653, 658, 662, 653, 653, 653, 658, 
	653, 740, 653, 742, 653, 740, 742, 653, 
	662, 653, 653, 653, 662, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 662, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 658, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 658, 653, 740, 
	653, 653, 653, 653, 653, 640, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653, 653, 653, 
	653, 653, 653, 653, 653, 653
};

static const int english_tokenizer_start = 599;





// The list of lower cased words that when preceding eos do not end sentence.
static unordered_set<string> eos_word_exceptions = {
  // Titles
  "adj", "adm", "adv", "assoc", "asst", "bart", "bldg", "brig", "bros", "capt",
  "cmdr", "col", "comdr", "con", "corp", "cpl", "d", "dr", "dr", "drs", "ens",
  "gen", "gov", "hon", "hosp", "hr", "insp", "lt", "mm", "mr", "mrs", "ms",
  "maj", "messrs", "mlle", "mme", "mr", "mrs", "ms", "msgr", "op", "ord",
  "pfc", "ph", "phd", "prof", "pvt", "rep", "reps", "res", "rev", "rt", "sen",
  "sens", "sfc", "sgt", "sr", "st", "supt", "surg", "univ",
  // Common abbrevs
  "addr", "approx", "apr", "aug", "calif", "co", "corp", "dec", "def", "e",
  "e.g", "eg", "feb", "fla", "ft", "gen", "gov", "hrs", "i.", "i.e", "ie",
  "inc", "jan", "jr", "ltd", "mar", "max", "min", "mph", "mt", "n", "nov",
  "oct", "ont", "pa", "pres", "rep", "rev", "s", "sec", "sen", "sep", "sept",
  "sgt", "sr", "tel", "un", "univ", "v", "va", "vs", "w", "yrs",
};

bool english_tokenizer::next_sentence(vector<string_piece>& forms) {
  int cs, act;
  const char* ts, *te;
  const char* text_start = text;

  const char* unary_text;
  const char* whitespace = nullptr; // Suppress "may be uninitialized" warning
  unsigned split_len = 0; // Suppress "may be uninitialized" warning
  
	{
	cs = english_tokenizer_start;
	ts = 0;
	te = 0;
	act = 0;
	}

	{
	int _klen;
	const short *_keys;
	int _trans;
	short _widec;

	if ( ( text) == ( text_end) )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	switch ( _english_tokenizer_from_state_actions[cs] ) {
	case 11:
	{ts = ( text);}
	break;
	}

	_widec = ( (unsigned char)*text);
	_klen = _english_tokenizer_cond_lengths[cs];
	_keys = _english_tokenizer_cond_keys + (_english_tokenizer_cond_offsets[cs]*2);
	if ( _klen > 0 ) {
		const short *_lower = _keys;
		const short *_mid;
		const short *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( _widec < _mid[0] )
				_upper = _mid - 2;
			else if ( _widec > _mid[1] )
				_lower = _mid + 2;
			else {
				switch ( _english_tokenizer_cond_spaces[_english_tokenizer_cond_offsets[cs] + ((_mid - _keys)>>1)] ) {
	case 0: {
		_widec = (short)(256u + (( (unsigned char)*text) - 0u));
		if ( 
 text == text_start || (utf8_back(unary_text=text, text_start), unicode::category(utf8::first(unary_text, text - unary_text)) & ~(unicode::L | unicode::M | unicode::N | unicode::Pd))  ) _widec += 256;
		break;
	}
	case 1: {
		_widec = (short)(768u + (( (unsigned char)*text) - 0u));
		if ( 
 text == text_start || (utf8_back(unary_text=text, text_start), unicode::category(utf8::first(unary_text, text - unary_text)) & ~(unicode::L | unicode::M | unicode::N) && *unary_text != '+')  ) _widec += 256;
		break;
	}
				}
				break;
			}
		}
	}

	_keys = _english_tokenizer_trans_keys + _english_tokenizer_key_offsets[cs];
	_trans = _english_tokenizer_index_offsets[cs];

	_klen = _english_tokenizer_single_lengths[cs];
	if ( _klen > 0 ) {
		const short *_lower = _keys;
		const short *_mid;
		const short *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( _widec < *_mid )
				_upper = _mid - 1;
			else if ( _widec > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _english_tokenizer_range_lengths[cs];
	if ( _klen > 0 ) {
		const short *_lower = _keys;
		const short *_mid;
		const short *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( _widec < _mid[0] )
				_upper = _mid - 2;
			else if ( _widec > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	_trans = _english_tokenizer_indicies[_trans];
_eof_trans:
	cs = _english_tokenizer_trans_targs[_trans];

	if ( _english_tokenizer_trans_actions[_trans] == 0 )
		goto _again;

	switch ( _english_tokenizer_trans_actions[_trans] ) {
	case 17:
	{ split_len = 2; }
	break;
	case 19:
	{ split_len = 3; }
	break;
	case 7:
	{ whitespace = text; }
	break;
	case 2:
	{te = ( text)+1;}
	break;
	case 9:
	{te = ( text)+1;{ forms.emplace_back(ts, te - ts);

          if (emergency_sentence_split(forms)) {( text)++; goto _out; }
        }}
	break;
	case 4:
	{te = ( text)+1;{
          // Does this eos character marks end of sentence?
          bool eos_word_exception = false;
          if (!forms.empty()) {
            // Is it single Lut?
            string_piece form = forms.back();
            eos_word_exception = unicode::category(utf8::decode(form.str, form.len)) & unicode::Lut && !form.len;

            // Is the lower case variant in eos_word_exceptions?
            buffer.clear();
            utf8::map(unicode::lowercase, forms.back().str, forms.back().len, buffer);
            eos_word_exception |= eos_word_exceptions.count(buffer);
          }

          // Add all characters until first space to forms and break if eos.
          for (text = ts; text < whitespace; forms.emplace_back(ts, text - ts), ts = text) utf8_advance(text, whitespace);
          {( text) = (( whitespace))-1;}
          if (!eos_word_exception) {( text)++; goto _out; }
        }}
	break;
	case 14:
	{te = ( text)+1;{ if (!forms.empty()) {( text)++; goto _out; } }}
	break;
	case 15:
	{te = ( text);( text)--;{ forms.emplace_back(ts, te - ts);

          if (emergency_sentence_split(forms)) {( text)++; goto _out; }
        }}
	break;
	case 12:
	{te = ( text);( text)--;}
	break;
	case 13:
	{te = ( text);( text)--;{ if (!forms.empty()) {( text)++; goto _out; } }}
	break;
	case 3:
	{{( text) = ((te))-1;}{ forms.emplace_back(ts, te - ts);

          if (emergency_sentence_split(forms)) {( text)++; goto _out; }
        }}
	break;
	case 1:
	{{( text) = ((te))-1;}}
	break;
	case 5:
	{	switch( act ) {
	case 1:
	{{( text) = ((te))-1;} forms.emplace_back(ts, te - split_len - ts);
          forms.emplace_back(te - split_len, split_len);

          if (emergency_sentence_split(forms)) {( text)++; goto _out; }
        }
	break;
	case 2:
	{{( text) = ((te))-1;} forms.emplace_back(ts, te - ts);

          if (emergency_sentence_split(forms)) {( text)++; goto _out; }
        }
	break;
	}
	}
	break;
	case 16:
	{ split_len = 2; }
	{te = ( text);( text)--;{ forms.emplace_back(ts, te - split_len - ts);
          forms.emplace_back(te - split_len, split_len);

          if (emergency_sentence_split(forms)) {( text)++; goto _out; }
        }}
	break;
	case 18:
	{ split_len = 3; }
	{te = ( text);( text)--;{ forms.emplace_back(ts, te - split_len - ts);
          forms.emplace_back(te - split_len, split_len);

          if (emergency_sentence_split(forms)) {( text)++; goto _out; }
        }}
	break;
	case 20:
	{ split_len = 4; }
	{te = ( text);( text)--;{ forms.emplace_back(ts, te - split_len - ts);
          forms.emplace_back(te - split_len, split_len);

          if (emergency_sentence_split(forms)) {( text)++; goto _out; }
        }}
	break;
	case 21:
	{ split_len = 5; }
	{te = ( text);( text)--;{ forms.emplace_back(ts, te - split_len - ts);
          forms.emplace_back(te - split_len, split_len);

          if (emergency_sentence_split(forms)) {( text)++; goto _out; }
        }}
	break;
	case 8:
	{te = ( text)+1;}
	{act = 1;}
	break;
	case 6:
	{te = ( text)+1;}
	{act = 2;}
	break;
	}

_again:
	switch ( _english_tokenizer_to_state_actions[cs] ) {
	case 10:
	{ts = 0;}
	break;
	}

	if ( cs == 0 )
		goto _out;
	if ( ++( text) != ( text_end) )
		goto _resume;
	_test_eof: {}
	if ( ( text) == ( text_end) )
	{
	if ( _english_tokenizer_eof_trans[cs] > 0 ) {
		_trans = _english_tokenizer_eof_trans[cs] - 1;
		goto _eof_trans;
	}
	}

	_out: {}
	}


  (void)act; // Suppress unused variable warning

  return !forms.empty();
}

} // namespace morphodita
} // namespace ufal


