/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.TGLensSet;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.interaction.GLEditUI;
import com.touchgraph.graphlayout.interaction.GLNavigateUI;
import com.touchgraph.graphlayout.interaction.HVScroll;
import com.touchgraph.graphlayout.interaction.LocalityScroll;
import com.touchgraph.graphlayout.interaction.RotateScroll;
import com.touchgraph.graphlayout.interaction.TGUIManager;
import com.touchgraph.graphlayout.interaction.ZoomScroll;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;

public class GLPanel
extends JPanel {
    public String zoomLabel = "Zoom";
    public String rotateLabel = "Rotate";
    public String localityLabel = "Locality";
    public HVScroll hvScroll;
    public ZoomScroll zoomScroll;
    public RotateScroll rotateScroll;
    public LocalityScroll localityScroll;
    public JPopupMenu glPopup;
    public Hashtable scrollBarHash;
    protected TGPanel tgPanel;
    protected TGLensSet tgLensSet;
    protected TGUIManager tgUIManager;
    private Color defaultColor = Color.lightGray;

    public GLPanel() {
        this.scrollBarHash = new Hashtable();
        this.tgLensSet = new TGLensSet();
        this.tgPanel = new TGPanel();
        this.hvScroll = new HVScroll(this.tgPanel, this.tgLensSet);
        this.zoomScroll = new ZoomScroll(this.tgPanel);
        this.rotateScroll = new RotateScroll(this.tgPanel);
        this.localityScroll = new LocalityScroll(this.tgPanel);
        this.initialize();
    }

    public GLPanel(Color color) {
        this.defaultColor = color;
        this.setBackground(color);
        this.scrollBarHash = new Hashtable();
        this.tgLensSet = new TGLensSet();
        this.tgPanel = new TGPanel();
        this.tgPanel.setBackground(color);
        this.hvScroll = new HVScroll(this.tgPanel, this.tgLensSet);
        this.zoomScroll = new ZoomScroll(this.tgPanel);
        this.rotateScroll = new RotateScroll(this.tgPanel);
        this.localityScroll = new LocalityScroll(this.tgPanel);
        this.initialize();
    }

    public void initialize() {
        this.buildPanel();
        this.buildLens();
        this.tgPanel.setLensSet(this.tgLensSet);
        this.addUIs();
        try {
            this.randomGraph();
        }
        catch (TGException tGException) {
            System.err.println(tGException.getMessage());
            tGException.printStackTrace(System.err);
        }
        this.tgPanel.setSelect(this.tgPanel.getGES().getFirstNode());
        this.setVisible(true);
    }

    public TGPanel getTGPanel() {
        return this.tgPanel;
    }

    public HVScroll getHVScroll() {
        return this.hvScroll;
    }

    public void setOffset(Point point) {
        this.hvScroll.setOffset(point);
    }

    public Point getOffset() {
        return this.hvScroll.getOffset();
    }

    public RotateScroll getRotateScroll() {
        return this.rotateScroll;
    }

    public void setRotationAngle(int n) {
        this.rotateScroll.setRotationAngle(n);
    }

    public int getRotationAngle() {
        return this.rotateScroll.getRotationAngle();
    }

    public LocalityScroll getLocalityScroll() {
        return this.localityScroll;
    }

    public void setLocalityRadius(int n) {
        this.localityScroll.setLocalityRadius(n);
    }

    public int getLocalityRadius() {
        return this.localityScroll.getLocalityRadius();
    }

    public ZoomScroll getZoomScroll() {
        return this.zoomScroll;
    }

    public void setZoomValue(int n) {
        this.zoomScroll.setZoomValue(n);
    }

    public int getZoomValue() {
        return this.zoomScroll.getZoomValue();
    }

    public JPopupMenu getGLPopup() {
        return this.glPopup;
    }

    public void buildLens() {
        this.tgLensSet.addLens(this.hvScroll.getLens());
        this.tgLensSet.addLens(this.zoomScroll.getLens());
        this.tgLensSet.addLens(this.rotateScroll.getLens());
        this.tgLensSet.addLens(this.tgPanel.getAdjustOriginLens());
    }

    public void buildPanel() {
        final JScrollBar jScrollBar = this.hvScroll.getHorizontalSB();
        final JScrollBar jScrollBar2 = this.hvScroll.getVerticalSB();
        JScrollBar jScrollBar3 = this.zoomScroll.getZoomSB();
        JScrollBar jScrollBar4 = this.rotateScroll.getRotateSB();
        JScrollBar jScrollBar5 = this.localityScroll.getLocalitySB();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.defaultColor);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(this.defaultColor);
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        AbstractAction abstractAction = new AbstractAction("Navigate"){

            public void actionPerformed(ActionEvent actionEvent) {
                GLPanel.this.tgUIManager.activate("Navigate");
            }
        };
        AbstractAction abstractAction2 = new AbstractAction("Edit"){

            public void actionPerformed(ActionEvent actionEvent) {
                GLPanel.this.tgUIManager.activate("Edit");
            }
        };
        JRadioButton jRadioButton = new JRadioButton(abstractAction);
        jRadioButton.setBackground(this.defaultColor);
        jRadioButton.setSelected(true);
        JRadioButton jRadioButton2 = new JRadioButton(abstractAction2);
        jRadioButton2.setBackground(this.defaultColor);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        jPanel2.add(jRadioButton);
        jPanel2.add(jRadioButton2);
        final JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(this.defaultColor);
        jPanel3.setLayout(new GridBagLayout());
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        jPanel3.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.scrollBarHash.put(this.zoomLabel, jScrollBar3);
        this.scrollBarHash.put(this.rotateLabel, jScrollBar4);
        this.scrollBarHash.put(this.localityLabel, jScrollBar5);
        JPanel jPanel4 = this.scrollSelectPanel(new String[]{this.zoomLabel, this.rotateLabel, this.localityLabel});
        jPanel4.setBackground(this.defaultColor);
        jPanel3.add((Component)jPanel4, gridBagConstraints);
        this.add((Component)jPanel3, "North");
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.tgPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jScrollBar2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)jScrollBar, gridBagConstraints);
        this.add((Component)jPanel, "Center");
        this.glPopup = new JPopupMenu();
        this.glPopup.setBackground(this.defaultColor);
        JMenuItem jMenuItem = new JMenuItem("Toggle Controls");
        ActionListener actionListener = new ActionListener(){
            boolean controlsVisible = true;

            public void actionPerformed(ActionEvent actionEvent) {
                this.controlsVisible = !this.controlsVisible;
                jScrollBar.setVisible(this.controlsVisible);
                jScrollBar2.setVisible(this.controlsVisible);
                jPanel3.setVisible(this.controlsVisible);
            }
        };
        jMenuItem.addActionListener(actionListener);
        this.glPopup.add(jMenuItem);
    }

    protected JPanel scrollSelectPanel(String[] stringArray) {
        final JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setBackground(this.defaultColor);
        jComboBox.setPreferredSize(new Dimension(80, 20));
        jComboBox.setSelectedIndex(0);
        final JScrollBar jScrollBar = (JScrollBar)this.scrollBarHash.get(stringArray[0]);
        jComboBox.addActionListener(new ActionListener(){
            JScrollBar currentSB;
            {
                this.currentSB = jScrollBar;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollBar jScrollBar2 = (JScrollBar)GLPanel.this.scrollBarHash.get((String)jComboBox.getSelectedItem());
                if (this.currentSB != null) {
                    this.currentSB.setVisible(false);
                }
                if (jScrollBar2 != null) {
                    jScrollBar2.setVisible(true);
                }
                this.currentSB = jScrollBar2;
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(this.defaultColor);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add(jComboBox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 17);
        gridBagConstraints.fill = 2;
        int n = 0;
        while (n < stringArray.length) {
            JScrollBar jScrollBar2 = (JScrollBar)this.scrollBarHash.get(stringArray[n]);
            if (jScrollBar2 != null) {
                if (n != 0) {
                    jScrollBar2.setVisible(false);
                }
                jPanel.add((Component)jScrollBar2, gridBagConstraints);
            }
            ++n;
        }
        return jPanel;
    }

    public void addUIs() {
        this.tgUIManager = new TGUIManager();
        GLEditUI gLEditUI = new GLEditUI(this);
        GLNavigateUI gLNavigateUI = new GLNavigateUI(this);
        this.tgUIManager.addUI(gLEditUI, "Edit");
        this.tgUIManager.addUI(gLNavigateUI, "Navigate");
        this.tgUIManager.activate("Navigate");
    }

    public void randomGraph() throws TGException {
        Node node = this.tgPanel.addNode();
        node.setType(0);
        int n = 0;
        while (n < 249) {
            Node node2 = this.tgPanel.getGES().getRandomNode();
            Node node3 = this.tgPanel.addNode();
            node3.setType(0);
            if (this.tgPanel.findEdge(node2, node3) == null) {
                this.tgPanel.addEdge(node2, node3, Edge.DEFAULT_LENGTH);
            }
            if (n % 2 == 0 && this.tgPanel.findEdge(node2 = this.tgPanel.getGES().getRandomNode(), node3) == null) {
                this.tgPanel.addEdge(node2, node3, Edge.DEFAULT_LENGTH);
            }
            ++n;
        }
        this.tgPanel.setLocale(node, 2);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Graph Layout");
        GLPanel gLPanel = new GLPanel();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.getContentPane().add("Center", gLPanel);
        ((Component)jFrame).setSize(500, 500);
        ((Component)jFrame).setVisible(true);
    }
}

