#!/usr/bin/perl

package eBay::API::XML::Call::RelistItem::RelistItemRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. RelistItemRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::RelistItem::RelistItemRequestType

=head1 DESCRIPTION

Enables a seller to take a single item (or a single multi-item
listing) that ended without bidders or buyers and re-list it on a
specified eBay site. The listing may be re-listed with the same item
properties as the original or the seller may change a number of the
item's defining properties at re-listing time. The new listing will
have a different item ID than the original one. RelistItem re-lists a
single item (or a single multi-item listing) that has already ended.
To re-list multiple items (multiple listings) that have ended,
execute RelistItem once for each ended listing.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::RelistItem::RelistItemRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::ItemType;


my @gaProperties = ( [ 'DeletedField', 'xs:string', '1', '', '' ]
	, [ 'Item', 'ns:ItemType', ''
	     ,'eBay::API::XML::DataType::ItemType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDeletedField()

Specifies the name of the field to delete from a listing.
See the eBay Web Services guide for rules on deleting values when relisting items.
Also see the relevant field descriptions to determine when to use DeletedField (and potential consequences).
The request can contain zero, one, or many instances of DeletedField (one for each field to be deleted).
DeletedField accepts the following path names, which delete the corresponding nodes:<br><br>
Item.ApplicationData<br>
Item.AttributeSetArray<br>
Item.BuyItNowPrice<br>
Item.Charity<br>
Item.ItemSpecifics<br>
Item.ListingCheckoutRedirectPreference.ProStoresStoreName<br>
Item.ListingCheckoutRedirectPreference.SellerThirdPartyUsername<br>
Item.ListingDesigner.LayoutID<br>
Item.ListingDesigner.ThemeID<br>
Item.ListingDetails.LocalListingDistance<br>
Item.ListingDetails.MinimumBestOfferMessage<br>
Item.ListingDetails.MinimumBestOfferPrice<br>
Item.ListingEnhancement[Value]<br>
Item.PayPalEmailAddress<br>
Item.PictureDetails.GalleryURL<br>
Item.PictureDetails.PictureURL<br>
Item.PostalCode<br>
Item.ProductListingDetails<br>
Item.SecondaryCategory<br>
Item.SellerContactDetails<br>
Item.SellerContactDetails.CompanyName<br>
Item.SellerContactDetails.County<br>
Item.SellerContactDetails.InternationalStreet<br>
Item.SellerContactDetails.Phone2AreaOrCityCode<br>
Item.SellerContactDetails.Phone2CountryCode<br>
Item.SellerContactDetails.Phone2CountryPrefix<br>
Item.SellerContactDetails.Phone2LocalNumber<br>
Item.SellerContactDetails.PhoneAreaOrCityCode<br>
Item.SellerContactDetails.PhoneCountryCode<br>
Item.SellerContactDetails.PhoneCountryPrefix<br>
Item.SellerContactDetails.PhoneLocalNumber<br>
Item.SellerContactDetails.Street<br>
Item.SellerContactDetails.Street2<br>
Item.ShippingDetails.PaymentInstructions<br>
Item.SKU<br>
Item.SubTitle<br>
These values are case-sensitive. Use values that match the case of the schema element names
(Item.PictureDetails.GalleryURL) or make the initial letter of each field name lowercase (item.pictureDetails.galleryURL).
However, do not change the case of letters in the middle of a field name.
For example, item.picturedetails.galleryUrl is not allowed.<br><br>
To delete a listing enhancement like Featured, specify the value you are deleting;
for example, Item.ListingEnhancement[Featured].

  RequiredInput: Conditionally
#    Argument: reference to an array  
                      of 'xs:string'

=cut

sub setDeletedField {
  my $self = shift;
  $self->{'DeletedField'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getDeletedField()

#    Returns: reference to an array  
                      of 'xs:string'

=cut

sub getDeletedField {
  my $self = shift;
  return $self->_getDataTypeArray('DeletedField');
}


=head2 setItem()

Child elements hold the values for item properties that change for the
item re-list. Item is a required input. At a minimum, the Item.ItemID
property must be set to the ID of the listing being re-listed (a
listing that ended in the past 90 days). By default, the new listing's
Item object properties are the same as those of the original (ended)
listing. By setting a new value in the Item object, the new listing
uses the new value rather than the corresponding value from the old
listing.

  RequiredInput: Yes
#    Argument: 'ns:ItemType'

=cut

sub setItem {
  my $self = shift;
  $self->{'Item'} = shift
}

=head2 getItem()

#    Returns: 'ns:ItemType'

=cut

sub getItem {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Item'
		,'eBay::API::XML::DataType::ItemType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
