# -*- cperl -*-
# ABSTRACT: LaTeX Realnumber object


use strict;
use warnings;
package SpeL::Object::Realnumber;

use parent 'Exporter';
use Carp;

use SpeL::I18n;

use Data::Dumper;



sub read {
  my $self = shift;
  my ( $level ) = @_;
  my $sign = '';
  if ( exists $self->{Sign} ) {
    $sign .= $self->{Sign} eq '+' ? $SpeL::I18n::lh->maketext('+') . ' ' : '';
    $sign .= $self->{Sign} eq '-' ? $SpeL::I18n::lh->maketext('-') . ' ' : '';
  }
  $self->{Value} =~ /pi/ and return $sign . $SpeL::I18n::lh->maketext('pi');
  $self->{Value} =~ /infty/ and return $sign . $SpeL::I18n::lh->maketext('infty');
  return $sign . $self->{Value};
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SpeL::Object::Realnumber - LaTeX Realnumber object

=head1 VERSION

version 20240619.1728

=head1 METHODS

=head2 new()

We keep the default method, as the object is generated by the parser.

=head2 read( level )

returns a string with the spoken version of the node

=over 4

=item level: parsing level

=back

=head1 SYNOPSYS

Represents a LaTeX Realnumber

=head1 AUTHOR

Walter Daems <wdaems@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2024 by Walter Daems.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=head1 CONTRIBUTOR

=for stopwords Paul Levrie

Paul Levrie

=cut
