/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.Url;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMapData {
    private final StringBuilder stringBuilder = new StringBuilder();

    public String asString(String string) {
        return "<map id=\"" + string + "_map\" name=\"" + string + "_map\">\n" + this.stringBuilder.toString() + "</map>\n";
    }

    public boolean containsData() {
        return this.stringBuilder.length() > 0;
    }

    public void appendString(String string) {
        this.stringBuilder.append(string);
    }

    public void appendLong(long l) {
        this.stringBuilder.append(l);
    }

    public void appendUrl(int n, Url url, double d) {
        this.appendString("<area shape=\"rect\" id=\"id");
        this.appendLong(n);
        this.appendString("\" href=\"");
        this.appendString(url.getUrl());
        this.appendString("\" title=\"");
        this.appendString(url.getTooltip());
        this.appendString("\" alt=\"\" coords=\"");
        this.appendString(url.getCoords(d));
        this.appendString("\"/>");
        this.appendString("\n");
    }

    public static CMapData cmapString(Set<Url> set, double d) {
        CMapData cMapData = new CMapData();
        ArrayList<Url> arrayList = new ArrayList<Url>(set);
        Collections.sort(arrayList, Url.SURFACE_COMPARATOR);
        int n = 1;
        for (Url url : arrayList) {
            cMapData.appendUrl(n, url, d);
            ++n;
        }
        return cMapData;
    }
}

