# Generated by default/object.tt
package Paws::Honeycode::Cell;
  use Moose;
  has Format => (is => 'ro', isa => 'Str', request_name => 'format', traits => ['NameInRequest']);
  has FormattedValue => (is => 'ro', isa => 'Str', request_name => 'formattedValue', traits => ['NameInRequest']);
  has Formula => (is => 'ro', isa => 'Str', request_name => 'formula', traits => ['NameInRequest']);
  has RawValue => (is => 'ro', isa => 'Str', request_name => 'rawValue', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Honeycode::Cell

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Honeycode::Cell object:

  $service_obj->Method(Att1 => { Format => $value, ..., RawValue => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Honeycode::Cell object:

  $result = $service_obj->Method(...);
  $result->Att1->Format

=head1 DESCRIPTION

An object that represents a single cell in a table.

=head1 ATTRIBUTES


=head2 Format => Str

The format of the cell. If this field is empty, then the format is
either not specified in the workbook or the format is set to AUTO.


=head2 FormattedValue => Str

The formatted value of the cell. This is the value that you see
displayed in the cell in the UI.

Note that the formatted value of a cell is always represented as a
string irrespective of the data that is stored in the cell. For
example, if a cell contains a date, the formatted value of the cell is
the string representation of the formatted date being shown in the cell
in the UI. See details in the rawValue field below for how cells of
different formats will have different raw and formatted values.


=head2 Formula => Str

The formula contained in the cell. This field is empty if a cell does
not have a formula.


=head2 RawValue => Str

The raw value of the data contained in the cell. The raw value depends
on the format of the data in the cell. However the attribute in the API
return value is always a string containing the raw value.

Cells with format DATE, DATE_TIME or TIME have the raw value as a
floating point number where the whole number represents the number of
days since 1/1/1900 and the fractional part represents the fraction of
the day since midnight. For example, a cell with date 11/3/2020 has the
raw value "44138". A cell with the time 9:00 AM has the raw value
"0.375" and a cell with date/time value of 11/3/2020 9:00 AM has the
raw value "44138.375". Notice that even though the raw value is a
number in all three cases, it is still represented as a string.

Cells with format NUMBER, CURRENCY, PERCENTAGE and ACCOUNTING have the
raw value of the data as the number representing the data being
displayed. For example, the number 1.325 with two decimal places in the
format will have it's raw value as "1.325" and formatted value as
"1.33". A currency value for $10 will have the raw value as "10" and
formatted value as "$10.00". A value representing 20% with two decimal
places in the format will have its raw value as "0.2" and the formatted
value as "20.00%". An accounting value of -$25 will have "-25" as the
raw value and "$ (25.00)" as the formatted value.

Cells with format TEXT will have the raw text as the raw value. For
example, a cell with text "John Smith" will have "John Smith" as both
the raw value and the formatted value.

Cells with format CONTACT will have the name of the contact as a
formatted value and the email address of the contact as the raw value.
For example, a contact for John Smith will have "John Smith" as the
formatted value and "john.smith@example.com" as the raw value.

Cells with format ROWLINK (aka picklist) will have the first column of
the linked row as the formatted value and the row id of the linked row
as the raw value. For example, a cell containing a picklist to a table
that displays task status might have "Completed" as the formatted value
and
"row:dfcefaee-5b37-4355-8f28-40c3e4ff5dd4/ca432b2f-b8eb-431d-9fb5-cbe0342f9f03"
as the raw value.

Cells with format AUTO or cells without any format that are
auto-detected as one of the formats above will contain the raw and
formatted values as mentioned above, based on the auto-detected
formats. If there is no auto-detected format, the raw and formatted
values will be the same as the data in the cell.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Honeycode>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

