# Generated by default/object.tt
package Paws::LookoutMetrics::MetricSource;
  use Moose;
  has AppFlowConfig => (is => 'ro', isa => 'Paws::LookoutMetrics::AppFlowConfig');
  has CloudWatchConfig => (is => 'ro', isa => 'Paws::LookoutMetrics::CloudWatchConfig');
  has RDSSourceConfig => (is => 'ro', isa => 'Paws::LookoutMetrics::RDSSourceConfig');
  has RedshiftSourceConfig => (is => 'ro', isa => 'Paws::LookoutMetrics::RedshiftSourceConfig');
  has S3SourceConfig => (is => 'ro', isa => 'Paws::LookoutMetrics::S3SourceConfig');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LookoutMetrics::MetricSource

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LookoutMetrics::MetricSource object:

  $service_obj->Method(Att1 => { AppFlowConfig => $value, ..., S3SourceConfig => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LookoutMetrics::MetricSource object:

  $result = $service_obj->Method(...);
  $result->Att1->AppFlowConfig

=head1 DESCRIPTION

Contains information about source data used to generate a metric.

=head1 ATTRIBUTES


=head2 AppFlowConfig => L<Paws::LookoutMetrics::AppFlowConfig>

An object containing information about the AppFlow configuration.


=head2 CloudWatchConfig => L<Paws::LookoutMetrics::CloudWatchConfig>

An object containing information about the Amazon CloudWatch monitoring
configuration.


=head2 RDSSourceConfig => L<Paws::LookoutMetrics::RDSSourceConfig>

An object containing information about the Amazon Relational Database
Service (RDS) configuration.


=head2 RedshiftSourceConfig => L<Paws::LookoutMetrics::RedshiftSourceConfig>

An object containing information about the Amazon Redshift database
configuration.


=head2 S3SourceConfig => L<Paws::LookoutMetrics::S3SourceConfig>





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LookoutMetrics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

