# Generated by default/object.tt
package Paws::MediaConnect::InputConfigurationRequest;
  use Moose;
  has InputPort => (is => 'ro', isa => 'Int', request_name => 'inputPort', traits => ['NameInRequest'], required => 1);
  has Interface => (is => 'ro', isa => 'Paws::MediaConnect::InterfaceRequest', request_name => 'interface', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaConnect::InputConfigurationRequest

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaConnect::InputConfigurationRequest object:

  $service_obj->Method(Att1 => { InputPort => $value, ..., Interface => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaConnect::InputConfigurationRequest object:

  $result = $service_obj->Method(...);
  $result->Att1->InputPort

=head1 DESCRIPTION

The transport parameters that you want to associate with an incoming
media stream.

=head1 ATTRIBUTES


=head2 B<REQUIRED> InputPort => Int

The port that you want the flow to listen on for an incoming media
stream.


=head2 B<REQUIRED> Interface => L<Paws::MediaConnect::InterfaceRequest>

The VPC interface that you want to use for the incoming media stream.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaConnect>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

