# Generated by default/object.tt
package Paws::CodeGuruProfiler::Recommendation;
  use Moose;
  has AllMatchesCount => (is => 'ro', isa => 'Int', request_name => 'allMatchesCount', traits => ['NameInRequest'], required => 1);
  has AllMatchesSum => (is => 'ro', isa => 'Num', request_name => 'allMatchesSum', traits => ['NameInRequest'], required => 1);
  has EndTime => (is => 'ro', isa => 'Str', request_name => 'endTime', traits => ['NameInRequest'], required => 1);
  has Pattern => (is => 'ro', isa => 'Paws::CodeGuruProfiler::Pattern', request_name => 'pattern', traits => ['NameInRequest'], required => 1);
  has StartTime => (is => 'ro', isa => 'Str', request_name => 'startTime', traits => ['NameInRequest'], required => 1);
  has TopMatches => (is => 'ro', isa => 'ArrayRef[Paws::CodeGuruProfiler::Match]', request_name => 'topMatches', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeGuruProfiler::Recommendation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeGuruProfiler::Recommendation object:

  $service_obj->Method(Att1 => { AllMatchesCount => $value, ..., TopMatches => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeGuruProfiler::Recommendation object:

  $result = $service_obj->Method(...);
  $result->Att1->AllMatchesCount

=head1 DESCRIPTION

A potential improvement that was found from analyzing the profiling
data.

=head1 ATTRIBUTES


=head2 B<REQUIRED> AllMatchesCount => Int

How many different places in the profile graph triggered a match.


=head2 B<REQUIRED> AllMatchesSum => Num

How much of the total sample count is potentially affected.


=head2 B<REQUIRED> EndTime => Str

End time of the profile that was used by this analysis. This is
specified using the ISO 8601 format. For example,
2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020
1:15:02 PM UTC.


=head2 B<REQUIRED> Pattern => L<Paws::CodeGuruProfiler::Pattern>

The pattern that analysis recognized in the profile to make this
recommendation.


=head2 B<REQUIRED> StartTime => Str

The start time of the profile that was used by this analysis. This is
specified using the ISO 8601 format. For example,
2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020
1:15:02 PM UTC.


=head2 B<REQUIRED> TopMatches => ArrayRef[L<Paws::CodeGuruProfiler::Match>]

List of the matches with most impact.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeGuruProfiler>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

