# Generated by default/object.tt
package Paws::ECS::EnvironmentFile;
  use Moose;
  has Type => (is => 'ro', isa => 'Str', request_name => 'type', traits => ['NameInRequest'], required => 1);
  has Value => (is => 'ro', isa => 'Str', request_name => 'value', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ECS::EnvironmentFile

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ECS::EnvironmentFile object:

  $service_obj->Method(Att1 => { Type => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ECS::EnvironmentFile object:

  $result = $service_obj->Method(...);
  $result->Att1->Type

=head1 DESCRIPTION

A list of files containing the environment variables to pass to a
container. You can specify up to ten environment files. The file must
have a C<.env> file extension. Each line in an environment file should
contain an environment variable in C<VARIABLE=VALUE> format. Lines
beginning with C<#> are treated as comments and are ignored. For more
information on the environment variable file syntax, see Declare
default environment variables in file
(https://docs.docker.com/compose/env-file/).

If there are environment variables specified using the C<environment>
parameter in a container definition, they take precedence over the
variables contained within an environment file. If multiple environment
files are specified that contain the same variable, they are processed
from the top down. It is recommended to use unique variable names. For
more information, see Specifying environment variables
(https://docs.aws.amazon.com/AmazonECS/latest/developerguide/taskdef-envfiles.html)
in the I<Amazon Elastic Container Service Developer Guide>.

This field is only valid for containers in Fargate tasks that use
platform version C<1.4.0> or later.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Type => Str

The file type to use. The only supported value is C<s3>.


=head2 B<REQUIRED> Value => Str

The Amazon Resource Name (ARN) of the Amazon S3 object containing the
environment variable file.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ECS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

