# Generated by default/object.tt
package Paws::Macie2::Cell;
  use Moose;
  has CellReference => (is => 'ro', isa => 'Str', request_name => 'cellReference', traits => ['NameInRequest']);
  has Column => (is => 'ro', isa => 'Int', request_name => 'column', traits => ['NameInRequest']);
  has ColumnName => (is => 'ro', isa => 'Str', request_name => 'columnName', traits => ['NameInRequest']);
  has Row => (is => 'ro', isa => 'Int', request_name => 'row', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::Cell

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::Cell object:

  $service_obj->Method(Att1 => { CellReference => $value, ..., Row => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::Cell object:

  $result = $service_obj->Method(...);
  $result->Att1->CellReference

=head1 DESCRIPTION

Specifies the location of an occurrence of sensitive data in a
Microsoft Excel workbook, CSV file, or TSV file.

=head1 ATTRIBUTES


=head2 CellReference => Str

The location of the cell, as an absolute cell reference, that contains
the sensitive data, for example Sheet2!C5 for cell C5 on Sheet2 in a
Microsoft Excel workbook. This value is null for CSV and TSV files.


=head2 Column => Int

The column number of the column that contains the sensitive data. For a
Microsoft Excel workbook, this value correlates to the alphabetical
character(s) for a column identifier, for example: 1 for column A, 2
for column B, and so on.


=head2 ColumnName => Str

The name of the column that contains the sensitive data, if available.


=head2 Row => Int

The row number of the row that contains the sensitive data.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

