# Generated by default/object.tt
package Paws::Macie2::JobScopeTerm;
  use Moose;
  has SimpleScopeTerm => (is => 'ro', isa => 'Paws::Macie2::SimpleScopeTerm', request_name => 'simpleScopeTerm', traits => ['NameInRequest']);
  has TagScopeTerm => (is => 'ro', isa => 'Paws::Macie2::TagScopeTerm', request_name => 'tagScopeTerm', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::JobScopeTerm

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::JobScopeTerm object:

  $service_obj->Method(Att1 => { SimpleScopeTerm => $value, ..., TagScopeTerm => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::JobScopeTerm object:

  $result = $service_obj->Method(...);
  $result->Att1->SimpleScopeTerm

=head1 DESCRIPTION

Specifies a property- or tag-based condition that defines criteria for
including or excluding S3 objects from a classification job. A
JobScopeTerm object can contain only one simpleScopeTerm object or one
tagScopeTerm object.

=head1 ATTRIBUTES


=head2 SimpleScopeTerm => L<Paws::Macie2::SimpleScopeTerm>

A property-based condition that defines a property, operator, and one
or more values for including or excluding objects from the job.


=head2 TagScopeTerm => L<Paws::Macie2::TagScopeTerm>

A tag-based condition that defines the operator and tag keys or tag key
and value pairs for including or excluding objects from the job.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

