# Generated by default/object.tt
package Paws::NetworkFirewall::MatchAttributes;
  use Moose;
  has DestinationPorts => (is => 'ro', isa => 'ArrayRef[Paws::NetworkFirewall::PortRange]');
  has Destinations => (is => 'ro', isa => 'ArrayRef[Paws::NetworkFirewall::Address]');
  has Protocols => (is => 'ro', isa => 'ArrayRef[Int]');
  has SourcePorts => (is => 'ro', isa => 'ArrayRef[Paws::NetworkFirewall::PortRange]');
  has Sources => (is => 'ro', isa => 'ArrayRef[Paws::NetworkFirewall::Address]');
  has TCPFlags => (is => 'ro', isa => 'ArrayRef[Paws::NetworkFirewall::TCPFlagField]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::NetworkFirewall::MatchAttributes

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NetworkFirewall::MatchAttributes object:

  $service_obj->Method(Att1 => { DestinationPorts => $value, ..., TCPFlags => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NetworkFirewall::MatchAttributes object:

  $result = $service_obj->Method(...);
  $result->Att1->DestinationPorts

=head1 DESCRIPTION

Criteria for Network Firewall to use to inspect an individual packet in
stateless rule inspection. Each match attributes set can include one or
more items such as IP address, CIDR range, port number, protocol, and
TCP flags.

=head1 ATTRIBUTES


=head2 DestinationPorts => ArrayRef[L<Paws::NetworkFirewall::PortRange>]

The destination ports to inspect for. If not specified, this matches
with any destination port. This setting is only used for protocols 6
(TCP) and 17 (UDP).

You can specify individual ports, for example C<1994> and you can
specify port ranges, for example C<1990-1994>.


=head2 Destinations => ArrayRef[L<Paws::NetworkFirewall::Address>]

The destination IP addresses and address ranges to inspect for, in CIDR
notation. If not specified, this matches with any destination address.


=head2 Protocols => ArrayRef[Int]

The protocols to inspect for, specified using each protocol's assigned
internet protocol number (IANA). If not specified, this matches with
any protocol.


=head2 SourcePorts => ArrayRef[L<Paws::NetworkFirewall::PortRange>]

The source ports to inspect for. If not specified, this matches with
any source port. This setting is only used for protocols 6 (TCP) and 17
(UDP).

You can specify individual ports, for example C<1994> and you can
specify port ranges, for example C<1990-1994>.


=head2 Sources => ArrayRef[L<Paws::NetworkFirewall::Address>]

The source IP addresses and address ranges to inspect for, in CIDR
notation. If not specified, this matches with any source address.


=head2 TCPFlags => ArrayRef[L<Paws::NetworkFirewall::TCPFlagField>]

The TCP flags and masks to inspect for. If not specified, this matches
with any settings. This setting is only used for protocol 6 (TCP).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NetworkFirewall>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

