# Generated by default/object.tt
package Paws::SSM::Patch;
  use Moose;
  has AdvisoryIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has Arch => (is => 'ro', isa => 'Str');
  has BugzillaIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has Classification => (is => 'ro', isa => 'Str');
  has ContentUrl => (is => 'ro', isa => 'Str');
  has CVEIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has Description => (is => 'ro', isa => 'Str');
  has Epoch => (is => 'ro', isa => 'Int');
  has Id => (is => 'ro', isa => 'Str');
  has KbNumber => (is => 'ro', isa => 'Str');
  has Language => (is => 'ro', isa => 'Str');
  has MsrcNumber => (is => 'ro', isa => 'Str');
  has MsrcSeverity => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');
  has Product => (is => 'ro', isa => 'Str');
  has ProductFamily => (is => 'ro', isa => 'Str');
  has Release => (is => 'ro', isa => 'Str');
  has ReleaseDate => (is => 'ro', isa => 'Str');
  has Repository => (is => 'ro', isa => 'Str');
  has Severity => (is => 'ro', isa => 'Str');
  has Title => (is => 'ro', isa => 'Str');
  has Vendor => (is => 'ro', isa => 'Str');
  has Version => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSM::Patch

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSM::Patch object:

  $service_obj->Method(Att1 => { AdvisoryIds => $value, ..., Version => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSM::Patch object:

  $result = $service_obj->Method(...);
  $result->Att1->AdvisoryIds

=head1 DESCRIPTION

Represents metadata about a patch.

=head1 ATTRIBUTES


=head2 AdvisoryIds => ArrayRef[Str|Undef]

The Advisory ID of the patch. For example, C<RHSA-2020:3779>. Applies
to Linux-based instances only.


=head2 Arch => Str

The architecture of the patch. For example, in
C<example-pkg-0.710.10-2.7.abcd.x86_64>, the architecture is indicated
by C<x86_64>. Applies to Linux-based instances only.


=head2 BugzillaIds => ArrayRef[Str|Undef]

The Bugzilla ID of the patch. For example, C<1600646>. Applies to
Linux-based instances only.


=head2 Classification => Str

The classification of the patch. For example, C<SecurityUpdates>,
C<Updates>, or C<CriticalUpdates>.


=head2 ContentUrl => Str

The URL where more information can be obtained about the patch.


=head2 CVEIds => ArrayRef[Str|Undef]

The Common Vulnerabilities and Exposures (CVE) ID of the patch. For
example, C<CVE-2011-3192>. Applies to Linux-based instances only.


=head2 Description => Str

The description of the patch.


=head2 Epoch => Int

The epoch of the patch. For example in
C<pkg-example-EE-20180914-2.2.amzn1.noarch>, the epoch value is
C<20180914-2>. Applies to Linux-based instances only.


=head2 Id => Str

The ID of the patch. Applies to Windows patches only.

This ID is not the same as the Microsoft Knowledge Base ID.


=head2 KbNumber => Str

The Microsoft Knowledge Base ID of the patch. Applies to Windows
patches only.


=head2 Language => Str

The language of the patch if it's language-specific.


=head2 MsrcNumber => Str

The ID of the Microsoft Security Response Center (MSRC) bulletin the
patch is related to. For example, C<MS14-045>. Applies to Windows
patches only.


=head2 MsrcSeverity => Str

The severity of the patch, such as C<Critical>, C<Important>, or
C<Moderate>. Applies to Windows patches only.


=head2 Name => Str

The name of the patch. Applies to Linux-based instances only.


=head2 Product => Str

The specific product the patch is applicable for. For example,
C<WindowsServer2016> or C<AmazonLinux2018.03>.


=head2 ProductFamily => Str

The product family the patch is applicable for. For example, C<Windows>
or C<Amazon Linux 2>.


=head2 Release => Str

The particular release of a patch. For example, in
C<pkg-example-EE-20180914-2.2.amzn1.noarch>, the release is C<2.amaz1>.
Applies to Linux-based instances only.


=head2 ReleaseDate => Str

The date the patch was released.


=head2 Repository => Str

The source patch repository for the operating system and version, such
as C<trusty-security> for Ubuntu Server 14.04 LTE and C<focal-security>
for Ubuntu Server 20.04 LTE. Applies to Linux-based instances only.


=head2 Severity => Str

The severity level of the patch. For example, C<CRITICAL> or
C<MODERATE>.


=head2 Title => Str

The title of the patch.


=head2 Vendor => Str

The name of the vendor providing the patch.


=head2 Version => Str

The version number of the patch. For example, in
C<example-pkg-1.710.10-2.7.abcd.x86_64>, the version number is
indicated by C<-1>. Applies to Linux-based instances only.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSM>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

