# Generated by default/object.tt
package Paws::StorageGateway::AutomaticTapeCreationPolicyInfo;
  use Moose;
  has AutomaticTapeCreationRules => (is => 'ro', isa => 'ArrayRef[Paws::StorageGateway::AutomaticTapeCreationRule]');
  has GatewayARN => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::StorageGateway::AutomaticTapeCreationPolicyInfo

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::StorageGateway::AutomaticTapeCreationPolicyInfo object:

  $service_obj->Method(Att1 => { AutomaticTapeCreationRules => $value, ..., GatewayARN => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::StorageGateway::AutomaticTapeCreationPolicyInfo object:

  $result = $service_obj->Method(...);
  $result->Att1->AutomaticTapeCreationRules

=head1 DESCRIPTION

Information about the gateway's automatic tape creation policies,
including the automatic tape creation rules and the gateway that is
using the policies.

=head1 ATTRIBUTES


=head2 AutomaticTapeCreationRules => ArrayRef[L<Paws::StorageGateway::AutomaticTapeCreationRule>]

An automatic tape creation policy consists of a list of automatic tape
creation rules. This returns the rules that determine when and how to
automatically create new tapes.


=head2 GatewayARN => Str





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::StorageGateway>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

