# Generated by default/object.tt
package Paws::Kendra::ConfluenceAttachmentConfiguration;
  use Moose;
  has AttachmentFieldMappings => (is => 'ro', isa => 'ArrayRef[Paws::Kendra::ConfluenceAttachmentToIndexFieldMapping]');
  has CrawlAttachments => (is => 'ro', isa => 'Bool');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Kendra::ConfluenceAttachmentConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Kendra::ConfluenceAttachmentConfiguration object:

  $service_obj->Method(Att1 => { AttachmentFieldMappings => $value, ..., CrawlAttachments => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Kendra::ConfluenceAttachmentConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AttachmentFieldMappings

=head1 DESCRIPTION

Specifies the attachment settings for the Confluence data source.
Attachment settings are optional, if you don't specify settings
attachments, Amazon Kendra won't index them.

=head1 ATTRIBUTES


=head2 AttachmentFieldMappings => ArrayRef[L<Paws::Kendra::ConfluenceAttachmentToIndexFieldMapping>]

Defines how attachment metadata fields should be mapped to index
fields. Before you can map a field, you must first create an index
field with a matching type using the console or the C<UpdateIndex>
operation.

If you specify the C<AttachentFieldMappings> parameter, you must
specify at least one field mapping.


=head2 CrawlAttachments => Bool

Indicates whether Amazon Kendra indexes attachments to the pages and
blogs in the Confluence data source.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Kendra>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

