######################################################################
#
# JIS78GL_by_JIS83GL.pl
#
# Copyright (c) 2018 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

# Understanding Japanese Information Processing
# J Character Lists and Mapping Tables

use strict;

my %JIS78GL_by_JIS83GL = (

# JIS C 6226-1978 Versus JIS X 0208-1983
# Category 1

    '223A' => '',
    '223B' => '',
    '223C' => '',
    '223D' => '',
    '223E' => '',
    '223F' => '',
    '2240' => '',
    '2241' => '',
    '224A' => '',
    '224B' => '',
    '224C' => '',
    '224D' => '',
    '224E' => '',
    '224F' => '',
    '2250' => '',
    '225C' => '',
    '225D' => '',
    '225E' => '',
    '225F' => '',
    '2260' => '',
    '2261' => '',
    '2262' => '',
    '2263' => '',
    '2264' => '',

    '2265' => '',
    '2266' => '',
    '2267' => '',
    '2268' => '',
    '2269' => '',
    '226A' => '',
    '2272' => '',
    '2273' => '',
    '2274' => '',
    '2275' => '',
    '2276' => '',
    '2277' => '',
    '2278' => '',
    '2279' => '',
    '227E' => '',
    '2821' => '',
    '2822' => '',
    '2823' => '',
    '2824' => '',
    '2825' => '',
    '2826' => '',
    '2827' => '',
    '2828' => '',
    '2829' => '',

    '282A' => '',
    '282B' => '',
    '282C' => '',
    '282D' => '',
    '282E' => '',
    '282F' => '',
    '2830' => '',
    '2831' => '',
    '2832' => '',
    '2833' => '',
    '2834' => '',
    '2835' => '',
    '2836' => '',
    '2837' => '',
    '2838' => '',
    '2839' => '',
    '283A' => '',
    '283B' => '',
    '283C' => '',
    '283D' => '',
    '283E' => '',
    '283F' => '',
    '2840' => '',

# JIS C 6226-1978 Versus JIS X 0208-1983
# Category 2

    '7421' => '3646',
    '7422' => '4B6A',
    '7423' => '4D5A',
    '7424' => '6076',

# JIS C 6226-1978 Versus JIS X 0208-1983
# Category 3

    '3033' => '724D', # 1
    '3229' => '7274', # 2
    '3342' => '695A', # 3
    '3349' => '5978', # 4
    '3376' => '635E', # 5
    '3443' => '5E75', # 6
    '3452' => '6B5D', # 7
    '375B' => '7074', # 8
    '395C' => '6268', # 9
    '3C49' => '6922', # 10
    '3F59' => '7057', # 11

    '4128' => '6C4D', # 12
    '445B' => '5464', # 13
    '4557' => '626A', # 14
    '456E' => '5B6D', # 15
    '4573' => '5E39', # 16
    '4676' => '6D6E', # 17
    '4768' => '6A24', # 18
    '4930' => '5B58', # 19
    '4B79' => '5056', # 20
    '4C79' => '692E', # 21
    '4F36' => '6446', # 22

    '724D' => '3033', # 23
    '7274' => '3229', # 24
    '695A' => '3342', # 25
    '5978' => '3349', # 26
    '635E' => '3376', # 27
    '5E75' => '3443', # 28
    '6B5D' => '3452', # 29
    '7074' => '375B', # 30
    '6268' => '395C', # 31
    '6922' => '3C49', # 32
    '7057' => '3F59', # 33

    '6C4D' => '4128', # 34
    '5464' => '445B', # 35
    '626A' => '4557', # 36
    '5B6D' => '456E', # 37
    '5E39' => '4573', # 38
    '6D6E' => '4676', # 39
    '6A24' => '4768', # 40
    '5B58' => '4930', # 41
    '5056' => '4B79', # 42
    '692E' => '4C79', # 43
    '6446' => '4F36', # 44

# JIS C 6226-1978 Versus JIS X 0208-1983
# Category 4

# JIS X 0208-1983 Versus JIS X 0208-1990

    '7425' => '',
    '7426' => '',

);

sub JIS78GL_by_JIS83GL {
    my($jis83) = @_;
    return $JIS78GL_by_JIS83GL{$jis83};
}

sub keys_of_JIS78GL_by_JIS83GL {
    return keys %JIS78GL_by_JIS83GL;
}

sub values_of_JIS78GL_by_JIS83GL {
    return values %JIS78GL_by_JIS83GL;
}

1;

__END__
