# automatically generated file, don't edit



# Copyright 2025 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JP;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20250913135858;

my $formatters = [
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '00777[01]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '000',
                  'pattern' => '(\\d{8,10})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            (?:
              12|
              57|
              99
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              267|
              3(?:
                7[247]|
                9[278]
              )|
              466|
              5(?:
                47|
                58|
                64
              )|
              6(?:
                3[245]|
                48|
                5[4-68]
              )
            )|
            499[2468]|
            5(?:
              769|
              979[2-69]
            )|
            7468|
            8(?:
              3(?:
                8[7-9]|
                96[2457-9]
              )|
              477|
              51[2-9]
            )|
            9(?:
              802|
              9(?:
                1[23]|
                69
              )
            )|
            1(?:
              45|
              58
            )[67]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d)(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '60',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            3|
            4(?:
              2(?:
                0|
                9[02-69]
              )|
              7(?:
                0[019]|
                1
              )
            )|
            6[1-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              1|
              5(?:
                4[018]|
                5[017]
              )|
              77|
              88|
              9[69]
            )|
            2(?:
              2[127]|
              3[0-269]|
              4[59]|
              5(?:
                [1-3]|
                5[0-69]|
                9(?:
                  17|
                  99
                )
              )|
              6(?:
                2|
                4[016-9]
              )|
              7(?:
                [1-35]|
                8[0189]
              )|
              8(?:
                [16]|
                3[0134]|
                9[0-5]
              )|
              9(?:
                [028]|
                17
              )
            )|
            4(?:
              2(?:
                [13-79]|
                8[014-6]
              )|
              3[0-57]|
              [45]|
              6[248]|
              7[2-47]|
              9[29]
            )|
            5(?:
              2|
              3(?:
                [045]|
                9(?:
                  [0-58]|
                  6[4-9]|
                  7[0-35689]
                )
              )|
              4[0-369]|
              5[29]|
              8[02389]|
              9[0-3]
            )|
            7(?:
              2[02-46-9]|
              34|
              [58]|
              6[0249]|
              7[57]|
              9(?:
                [23]|
                4[0-59]|
                5[01569]|
                6[0167]
              )
            )|
            8(?:
              2(?:
                [1258]|
                4[0-39]|
                9[0169]
              )|
              3(?:
                [29]|
                60|
                7(?:
                  [017-9]|
                  6[6-8]
                )
              )|
              49|
              51|
              6(?:
                [0-24]|
                36[2-57-9]|
                5(?:
                  [0-389]|
                  5[23]
                )|
                6(?:
                  [01]|
                  9[178]
                )|
                7(?:
                  2[2-468]|
                  3[78]
                )|
                9[0145]
              )|
              7[0-468]|
              8[68]
            )|
            9(?:
              4[15]|
              5[138]|
              7[156]|
              8[189]|
              9(?:
                [1289]|
                3(?:
                  31|
                  4[357]
                )|
                4[0178]
              )
            )|
            (?:
              8294|
              96
            )[1-3]|
            2(?:
              57|
              93
            )[015-9]|
            (?:
              223|
              8699
            )[014-9]|
            (?:
              25[0468]|
              422|
              838
            )[01]|
            (?:
              48|
              8292|
              9[23]
            )[1-9]|
            (?:
              47[59]|
              59[89]|
              8(?:
                68|
                9
              )
            )[019]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [14]|
            [289][2-9]|
            5[3-9]|
            7[2-4679]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '0077',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '008',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '[25-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{5})(\\d{5,6})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{6})(\\d{6,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'geographic' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'mobile' => '
          (?:
            601[0-4]0|
            [7-9]0[1-9]\\d\\d
          )\\d{5}
        ',
                'pager' => '20\\d{8}',
                'personal_number' => '60\\d{7}',
                'specialrate' => '(990\\d{6})|(570\\d{6})',
                'toll_free' => '
          00777(?:
            [01]|
            5\\d
          )\\d\\d|
          (?:
            00(?:
              7778|
              882[1245]
            )|
            (?:
              120|
              800\\d
            )\\d\\d
          )\\d{4}|
          00(?:
            37|
            66|
            78
          )\\d{6,13}
        ',
                'voip' => '50[1-9]\\d{7}'
              };
my %areanames = ();
$areanames{en} = {"8126174", "Omachi\,\ Nagano",
"81892", "Kumakogen\,\ Ehime",
"812615", "Omachi\,\ Nagano",
"81545", "Fuji\,\ Shizuoka",
"814776", "Funabashi\,\ Chiba",
"81182", "Yokote\,\ Akita",
"817735", "Fukuchiyama\,\ Kyoto",
"817905", "Fukusaki\,\ Hyogo",
"811953", "Ninohe\,\ Iwate",
"812793", "Shibukawa\,\ Gunma",
"81488", "Urawa\,\ Saitama",
"817352", "Shingu\,\ Fukuoka",
"812914", "Hokota\,\ Ibaraki",
"81721", "Tondabayashi\,\ Osaka",
"812834", "Utsunomiya\,\ Tochigi",
"815367", "Shitara\,\ Aichi",
"8183768", "Shimonoseki\,\ Yamaguchi",
"819556", "Karatsu\,\ Saga",
"815766", "Gero\,\ Gifu",
"811868", "Takanosu\,\ Akita",
"819723", "Saiki\,\ Oita",
"818679", "Niimi\,\ Okayama",
"818362", "Ube\,\ Yamaguchi",
"8145", "Yokohama\,\ Kanagawa",
"818698", "Bizen\,\ Okayama",
"812879", "Nasukarasuyama\,\ Tochigi",
"812898", "Kanuma\,\ Tochigi",
"8153964", "Hamamatsu\,\ Shizuoka",
"819747", "Taketa\,\ Oita",
"81250", "Niitsu\,\ Niigata",
"812836", "Sano\,\ Tochigi",
"81986", "Miyakonojo\,\ Miyazaki",
"819554", "Imari\,\ Saga",
"815764", "Gero\,\ Gifu",
"812587", "Nagaoka\,\ Niigata",
"817230", "Neyagawa\,\ Osaka",
"81236", "Yamagata\,\ Yamagata",
"819737", "Kusu\,\ Oita",
"819828", "Takachiho\,\ Miyazaki",
"818945", "Yawatahama\,\ Ehime",
"819809", "Yaeyama\ District\,\ Okinawa",
"812653", "Iida\,\ Nagano",
"81998", "Kagoshima\,\ Kagoshima",
"819662", "Hitoyoshi\,\ Kumamoto",
"811558", "Hiroo\,\ Hokkaido",
"81934", "Kitakyushu\,\ Fukuoka",
"817483", "Yokaichi\,\ Shiga",
"811453", "Hayakita\,\ Hokkaido",
"812789", "Maebashi\,\ Gunma",
"811583", "Monbetsu\,\ Hokkaido",
"811973", "Mizusawa\,\ Iwate",
"815393", "Hamamatsu\,\ Shizuoka",
"814756", "Togane\,\ Chiba",
"81547", "Shimada\,\ Shizuoka",
"818873", "Aki\,\ Kochi",
"812414", "Yanaizu\,\ Fukushima",
"818385", "Hagi\,\ Yamaguchi",
"811394", "Matsumae\,\ Hokkaido",
"815974", "Owase\,\ Mie",
"815584", "Shimoda\,\ Shizuoka",
"81933", "Kitakyushu\,\ Fukuoka",
"818563", "Masuda\,\ Shimane",
"819576", "Shimabara\,\ Nagasaki",
"8125480", "Murakami\,\ Niigata",
"817712", "Kameoka\,\ Kyoto",
"81284", "Ashikaga\,\ Tochigi",
"817687", "Noto\,\ Ishikawa",
"811365", "Kutchan\,\ Hokkaido",
"8112392", "Yubari\,\ Hokkaido",
"812957", "Daigo\,\ Ibaraki",
"818832", "Kamojima\,\ Tokushima",
"819574", "Isahaya\,\ Nagasaki",
"811932", "Kamaishi\,\ Iwate",
"81864", "Kurashiki\,\ Okayama",
"811396", "Esashi\,\ Hokkaido",
"815586", "Shimoda\,\ Shizuoka",
"819685", "Tamana\,\ Kumamoto",
"812477", "Miharu\,\ Fukushima",
"812859", "Oyama\,\ Tochigi",
"812930", "Mito\,\ Ibaraki",
"818842", "Anan\,\ Tokushima",
"814754", "Mobara\,\ Chiba",
"812673", "Komoro\,\ Nagano",
"81863", "Tamano\,\ Okayama",
"811942", "Iwaizumi\,\ Iwate",
"812416", "Tajima\,\ Fukushima",
"818293", "Hatsukaichi\,\ Hiroshima",
"81948", "Iizuka\,\ Fukuoka",
"817724", "Miyazu\,\ Kyoto",
"811974", "Mizusawa\,\ Iwate",
"818652", "Kurashiki\,\ Okayama",
"815394", "Hamamatsu\,\ Shizuoka",
"811584", "Engaru\,\ Hokkaido",
"812676", "Saku\,\ Nagano",
"818874", "Aki\,\ Kochi",
"818296", "Hiroshima\,\ Hiroshima",
"812413", "Kitakata\,\ Fukushima",
"81423", "Kokubunji\,\ Tokyo",
"817484", "Yokaichi\,\ Shiga",
"811454", "Mukawa\,\ Hokkaido",
"818564", "Masuda\,\ Shimane",
"81798", "Nishinomiya\,\ Hyogo",
"817992", "Sumoto\,\ Hyogo",
"81885", "Komatsushima\,\ Tokushima",
"8153976", "Hamamatsu\,\ Shizuoka",
"819542", "Takeo\,\ Saga",
"818248", "Shobara\,\ Hiroshima",
"815583", "Shimoda\,\ Shizuoka",
"817737", "Maizuru\,\ Kyoto",
"811393", "Matsumae\,\ Hokkaido",
"815973", "Owase\,\ Mie",
"818595", "Yonago\,\ Tottori",
"812649", "Nagano\,\ Nagano",
"812782", "Numata\,\ Gunma",
"81176", "Towada\,\ Aomori",
"8166", "Osaka\,\ Osaka",
"8186553", "Kurashiki\,\ Okayama",
"819735", "Hita\,\ Oita",
"818947", "Uwajima\,\ Ehime",
"819573", "Isahaya\,\ Nagasaki",
"81878", "Takamatsu\,\ Kagawa",
"812585", "Nagaoka\,\ Niigata",
"811939", "Miyako\,\ Iwate",
"817486", "Minakuchi\,\ Shiga",
"817723", "Miyazu\,\ Kyoto",
"812852", "Oyama\,\ Tochigi",
"814753", "Mobara\,\ Chiba",
"811586", "Nakayubetsu\,\ Hokkaido",
"811976", "Kitakami\,\ Iwate",
"812674", "Komoro\,\ Nagano",
"818294", "Hatsukaichi\,\ Hiroshima",
"81561", "Seto\,\ Aichi",
"811367", "Suttsu\,\ Hokkaido",
"817685", "Wajima\,\ Ishikawa",
"812794", "Shibukawa\,\ Gunma",
"811655", "Nayoro\,\ Hokkaido",
"812913", "Hokota\,\ Ibaraki",
"818369", "Ube\,\ Yamaguchi",
"812656", "Ina\,\ Nagano",
"811954", "Ninohe\,\ Iwate",
"818387", "Tamagawa\,\ Yamaguchi",
"819724", "Saiki\,\ Oita",
"817492", "Hikone\,\ Shiga",
"81582", "Gifu\,\ Gifu",
"812833", "Utsunomiya\,\ Tochigi",
"814298", "Hanno\,\ Saitama",
"8125483", "Murakami\,\ Niigata",
"812562", "Sanjo\,\ Niigata",
"819553", "Imari\,\ Saga",
"815763", "Gero\,\ Gifu",
"812748", "Tomioka\,\ Gunma",
"81734", "Wakayama\,\ Wakayama",
"819726", "Usuki\,\ Oita",
"819802", "Minamidaito\,\ Okinawa",
"819978", "Tokunoshima\,\ Kagoshima",
"819687", "Tamana\,\ Kumamoto",
"812475", "Ishikawa\,\ Fukushima",
"817618", "Kaga\,\ Ishikawa",
"8112398", "Kuriyama\,\ Hokkaido",
"812654", "Iida\,\ Nagano",
"811956", "Iwate\,\ Iwate",
"812872", "Otawara\,\ Tochigi",
"812796", "Shibukawa\,\ Gunma",
"812955", "Hitachi\-Omiya\,\ Ibaraki",
"819432", "Yame\,\ Fukuoka",
"817675", "Nanao\,\ Ishikawa",
"817454", "Yamatotakada\,\ Nara",
"818682", "Tsuyama\,\ Okayama",
"811554", "Obihiro\,\ Hokkaido",
"81227", "Sendai\,\ Miyagi",
"81896", "Iyomishima\,\ Ehime",
"8199345", "Kagoshima\,\ Kagoshima",
"818807", "Sukumo\,\ Kochi",
"8153972", "Hamamatsu\,\ Shizuoka",
"811336", "Ishikari\,\ Hokkaido",
"81492", "Kawagoe\,\ Saitama",
"818464", "Takehara\,\ Hiroshima",
"818377", "Shimonoseki\,\ Yamaguchi",
"818243", "Higashi\-ku\,\ Hiroshima",
"811398", "Kumaishi\,\ Hokkaido",
"81157", "Kitami\,\ Hokkaido",
"815978", "Kumano\,\ Mie",
"81888", "Kochi\,\ Kochi",
"8161", "Osaka\,\ Osaka",
"818892", "Sakawa\,\ Kochi",
"815999", "Tsu\,\ Mie",
"814289", "Ome\,\ Tokyo",
"819953", "Okuchi\,\ Kagoshima",
"812962", "Shimodate\,\ Ibaraki",
"81268", "Ueda\,\ Nagano",
"812692", "Nakano\,\ Nagano",
"817949", "Kakogawa\,\ Hyogo",
"819578", "Shimabara\,\ Nagasaki",
"81939", "Kitakyushu\,\ Fukuoka",
"81776", "Fukui\,\ Fukui",
"818466", "Mima\,\ Tokushima",
"819599", "Oseto\,\ Nagasaki",
"811556", "Obihiro\,\ Hokkaido",
"818391", "Ogori\,\ Yamaguchi",
"814705", "Tateyama\,\ Chiba",
"812485", "Shirakawa\,\ Fukushima",
"8147950", "Yokaichiba\,\ Chiba",
"812555", "Itoigawa\,\ Niigata",
"814758", "Togane\,\ Chiba",
"81875", "Kan\'onji\,\ Kagawa",
"8183766", "Shimonoseki\,\ Yamaguchi",
"817456", "Yamatotakada\,\ Nara",
"819932", "Ibusuki\,\ Kagoshima",
"8178", "Kobe\,\ Hyogo",
"817954", "Nishiwaki\,\ Hyogo",
"81225", "Ishinomaki\,\ Miyagi",
"819826", "Hyuga\,\ Miyazaki",
"811984", "Hanamaki\,\ Iwate",
"817367", "Iwade\,\ Wakayama",
"815745", "Minokamo\,\ Gifu",
"8162", "Osaka\,\ Osaka",
"811864", "Odate\,\ Akita",
"8198299", "Hyuga\,\ Miyazaki",
"81797", "Nishinomiya\,\ Hyogo",
"812896", "Kanuma\,\ Tochigi",
"818694", "Okayama\,\ Okayama",
"815958", "Kameyama\,\ Mie",
"812838", "Sano\,\ Tochigi",
"818665", "Takahashi\,\ Okayama",
"815983", "Matsusaka\,\ Mie",
"815735", "Ena\,\ Gifu",
"81134", "Otaru\,\ Hokkaido",
"81463", "Hiratsuka\,\ Kanagawa",
"819558", "Karatsu\,\ Saga",
"812239", "Sendai\,\ Miyagi",
"811549", "Kushiro\,\ Hokkaido",
"812743", "Fujioka\,\ Gunma",
"815768", "Gero\,\ Gifu",
"811866", "Takanosu\,\ Akita",
"812894", "Utsunomiya\,\ Tochigi",
"818696", "Bizen\,\ Okayama",
"818547", "Kakeya\,\ Shimane",
"81464", "Atsugi\,\ Kanagawa",
"817476", "Shimonoseki\,\ Yamaguchi",
"817613", "Komatsu\,\ Ishikawa",
"81877", "Marugame\,\ Kagawa",
"812575", "Tokamachi\,\ Niigata",
"81572", "Tajimi\,\ Gifu",
"817956", "Sanda\,\ Hyogo",
"8186999", "Seto\,\ Okayama",
"811986", "Tono\,\ Iwate",
"819824", "Nobeoka\,\ Miyazaki",
"81485", "Kumagaya\,\ Saitama",
"817616", "Komatsu\,\ Ishikawa",
"811352", "Yoichi\,\ Hokkaido",
"81555", "Fujiyoshida\,\ Yamanashi",
"811958", "Iwate\,\ Iwate",
"81739", "Tanabe\,\ Wakayama",
"81548", "Haibara\,\ Shizuoka",
"812798", "Naganohara\,\ Gunma",
"818375", "Mine\,\ Yamaguchi",
"811735", "Goshogawara\,\ Aomori",
"817953", "Nishiwaki\,\ Hyogo",
"811983", "Hanamaki\,\ Iwate",
"815984", "Matsusaka\,\ Mie",
"812746", "Tomioka\,\ Gunma",
"817677", "Nanao\,\ Ishikawa",
"811863", "Kazuno\,\ Akita",
"8144", "Kawasaki\,\ Kanagawa",
"819728", "Usuki\,\ Oita",
"81823", "Kure\,\ Hiroshima",
"818693", "Oku\,\ Okayama",
"819976", "Naze\,\ Kagoshima",
"811532", "Nemuro\,\ Hokkaido",
"81533", "Toyohashi\,\ Aichi",
"812242", "Shiroishi\,\ Miyagi",
"812893", "Utsunomiya\,\ Tochigi",
"814792", "Choshi\,\ Chiba",
"819974", "Yakushima\,\ Kagoshima",
"81478", "Sawara\,\ Chiba",
"812487", "Sukagawa\,\ Fukushima",
"81172", "Hirosaki\,\ Aomori",
"815986", "Matsusaka\,\ Mie",
"812744", "Fujioka\,\ Gunma",
"812232", "Iwanuma\,\ Miyagi",
"81534", "Hamamatsu\,\ Shizuoka",
"811542", "Kushiro\,\ Hokkaido",
"817915", "Aioi\,\ Hyogo",
"819823", "Nobeoka\,\ Miyazaki",
"818512", "Okinoshima\,\ Shimane",
"8153978", "Hamamatsu\,\ Shizuoka",
"817614", "Komatsu\,\ Ishikawa",
"812658", "Ina\,\ Nagano",
"81947", "Tagawa\,\ Fukuoka",
"8153967", "Hamamatsu\,\ Shizuoka",
"811553", "Obihiro\,\ Hokkaido",
"8198291", "Nobeoka\,\ Miyazaki",
"815737", "Nakatsugawa\,\ Gifu",
"817488", "Minakuchi\,\ Shiga",
"81852", "Matsue\,\ Shimane",
"818667", "Ibara\,\ Okayama",
"8186995", "Seto\,\ Okayama",
"811588", "Okoppe\,\ Hokkaido",
"81557", "Ito\,\ Shizuoka",
"811978", "Kitakami\,\ Iwate",
"815398", "Hamamatsu\,\ Shizuoka",
"815992", "Toba\,\ Mie",
"811372", "Shikabe\,\ Hokkaido",
"817453", "Yamatotakada\,\ Nara",
"81487", "Urawa\,\ Saitama",
"818244", "Miyoshi\,\ Hiroshima",
"819956", "Kajiki\,\ Kagoshima",
"818568", "Tsuwano\,\ Shimane",
"8112396", "Kuriyama\,\ Hokkaido",
"81586", "Ichinomiya\,\ Aichi",
"818689", "Okayama\,\ Okayama",
"818463", "Takehara\,\ Hiroshima",
"8199331", "Kagoshima\,\ Kagoshima",
"81273", "Takasaki\,\ Gunma",
"8198295", "Hyuga\,\ Miyazaki",
"811333", "Tobetsu\,\ Hokkaido",
"819954", "Kajiki\,\ Kagoshima",
"818246", "Miyoshi\,\ Hiroshima",
"812577", "Muika\,\ Niigata",
"817702", "Tsuruga\,\ Fukui",
"818545", "Kisuki\,\ Shimane",
"812678", "Saku\,\ Nagano",
"81429", "Tokorozawa\,\ Saitama",
"814282", "Ome\,\ Tokyo",
"818298", "Hatsukaichi\,\ Hiroshima",
"819592", "Oseto\,\ Nagasaki",
"81958", "Nagasaki\,\ Nagasaki",
"817942", "Kakogawa\,\ Hyogo",
"812474", "Ishikawa\,\ Fukushima",
"812655", "Iida\,\ Nagano",
"817686", "Noto\,\ Ishikawa",
"811656", "Bifuka\,\ Hokkaido",
"81725", "Izumi\,\ Osaka",
"819577", "Shimabara\,\ Nagasaki",
"818943", "Yawatahama\,\ Ehime",
"81245", "Fukushima\,\ Fukushima",
"812389", "Yonezawa\,\ Yamagata",
"8164", "Osaka\,\ Osaka",
"814757", "Togane\,\ Chiba",
"811562", "Honbetsu\,\ Hokkaido",
"819725", "Saiki\,\ Oita",
"81167", "Furano\,\ Hokkaido",
"814281", "Sagamihara\,\ Kanagawa",
"812560", "Itoigawa\,\ Niigata",
"817239", "Neyagawa\,\ Osaka",
"81471", "Kashiwa\,\ Chiba",
"81480", "Kuki\,\ Saitama",
"812795", "Shibukawa\,\ Gunma",
"818808", "Tosashimizu\,\ Kochi",
"817684", "Wajima\,\ Ishikawa",
"818378", "Shimonoseki\,\ Yamaguchi",
"818582", "Kurayoshi\,\ Tottori",
"818972", "Niihama\,\ Ehime",
"811654", "Nayoro\,\ Hokkaido",
"812956", "Hitachi\-Omiya\,\ Ibaraki",
"81550", "Gotenba\,\ Shizuoka",
"812476", "Miharu\,\ Fukushima",
"812613", "Omachi\,\ Nagano",
"817733", "Fukuchiyama\,\ Kyoto",
"817903", "Fukusaki\,\ Hyogo",
"811397", "Okushiri\,\ Hokkaido",
"815977", "Kumano\,\ Mie",
"811955", "Ninohe\,\ Iwate",
"819557", "Karatsu\,\ Saga",
"81591", "Tsu\,\ Mie",
"812584", "Nagaoka\,\ Niigata",
"81727", "Ikeda\,\ Osaka",
"815767", "Gero\,\ Gifu",
"8183767", "Shimonoseki\,\ Yamaguchi",
"81940", "Munakata\,\ Fukuoka",
"815366", "Shitara\,\ Aichi",
"819744", "Mie\,\ Oita",
"812675", "Saku\,\ Nagano",
"81584", "Ogaki\,\ Gifu",
"818295", "Hatsukaichi\,\ Hiroshima",
"814777", "Funabashi\,\ Chiba",
"8125481", "Murakami\,\ Niigata",
"818596", "Yonago\,\ Tottori",
"819683", "Yamaga\,\ Kumamoto",
"812780", "Maebashi\,\ Gunma",
"819232", "Maebaru\,\ Fukuoka",
"8169", "Osaka\,\ Osaka",
"819734", "Hita\,\ Oita",
"81583", "Gifu\,\ Gifu",
"81179", "Sannohe\,\ Aomori",
"818565", "Masuda\,\ Shimane",
"811541", "Teshikaga\,\ Hokkaido",
"812917", "Mito\,\ Ibaraki",
"81276", "Ota\,\ Gunma",
"811363", "Kutchan\,\ Hokkaido",
"817962", "Toyooka\,\ Hyogo",
"818594", "Yonago\,\ Tottori",
"817368", "Iwade\,\ Wakayama",
"8125485", "Tsugawa\,\ Niigata",
"811585", "Engaru\,\ Hokkaido",
"811975", "Mizusawa\,\ Iwate",
"815395", "Hamamatsu\,\ Shizuoka",
"819746", "Taketa\,\ Oita",
"812939", "Mito\,\ Ibaraki",
"818383", "Hagi\,\ Yamaguchi",
"811852", "Oga\,\ Akita",
"812586", "Nagaoka\,\ Niigata",
"818952", "Uwajima\,\ Ehime",
"812837", "Sano\,\ Tochigi",
"817485", "Yokaichi\,\ Shiga",
"811455", "Mukawa\,\ Hokkaido",
"819743", "Mie\,\ Oita",
"812640", "Nagano\,\ Nagano",
"814755", "Togane\,\ Chiba",
"812583", "Nagaoka\,\ Niigata",
"818263", "Kake\,\ Hiroshima",
"81893", "Ozu\,\ Ehime",
"812488", "Sukagawa\,\ Fukushima",
"817725", "Miyazu\,\ Kyoto",
"81183", "Yuzawa\,\ Akita",
"819733", "Hita\,\ Oita",
"819575", "Isahaya\,\ Nagasaki",
"81191", "Ichinoseki\,\ Iwate",
"811366", "Suttsu\,\ Hokkaido",
"811632", "Teshio\,\ Hokkaido",
"81184", "Yurihonjo\,\ Akita",
"819684", "Yamaga\,\ Kumamoto",
"812657", "Ina\,\ Nagano",
"811957", "Iwate\,\ Iwate",
"811395", "Esashi\,\ Hokkaido",
"815585", "Shimoda\,\ Shizuoka",
"81925", "Fukuoka\,\ Fukuoka",
"8112397", "Kuriyama\,\ Hokkaido",
"819686", "Tamana\,\ Kumamoto",
"818593", "Yonago\,\ Tottori",
"812932", "Takahagi\,\ Ibaraki",
"818479", "Tojo\,\ Hiroshima",
"812797", "Shibukawa\,\ Gunma",
"811364", "Kutchan\,\ Hokkaido",
"815363", "Shinshiro\,\ Aichi",
"81774", "Uji\,\ Kyoto",
"817969", "Hamasaka\,\ Hyogo",
"817678", "Nanao\,\ Ishikawa",
"81565", "Toyota\,\ Aichi",
"812415", "Yanaizu\,\ Fukushima",
"818384", "Hagi\,\ Yamaguchi",
"819727", "Usuki\,\ Oita",
"819962", "Satsumasendai\,\ Kagoshima",
"8153966", "Hamamatsu\,\ Shizuoka",
"81282", "Tochigi\,\ Tochigi",
"8125489", "Tsugawa\,\ Niigata",
"818944", "Yawatahama\,\ Ehime",
"812473", "Ishikawa\,\ Fukushima",
"812616", "Omachi\,\ Nagano",
"817736", "Maizuru\,\ Kyoto",
"814775", "Funabashi\,\ Chiba",
"812382", "Yonezawa\,\ Yamagata",
"812578", "Muika\,\ Niigata",
"812677", "Saku\,\ Nagano",
"818297", "Hatsukaichi\,\ Hiroshima",
"818360", "Ogori\,\ Yamaguchi",
"81989", "Naha\,\ Okinawa",
"818202", "Yanai\,\ Yamaguchi",
"819555", "Karatsu\,\ Saga",
"81932", "Kitakyushu\,\ Fukuoka",
"815765", "Gero\,\ Gifu",
"8182920", "Hatsukaichi\,\ Hiroshima",
"812835", "Sano\,\ Tochigi",
"817487", "Minakuchi\,\ Shiga",
"81466", "Fujisawa\,\ Kanagawa",
"818668", "Ibara\,\ Okayama",
"8126176", "Omachi\,\ Nagano",
"815738", "Nakatsugawa\,\ Gifu",
"81740", "Imazu\,\ Shiga",
"81927", "Fukuoka\,\ Fukuoka",
"811587", "Nakayubetsu\,\ Hokkaido",
"811977", "Kitakami\,\ Iwate",
"81567", "Tsushima\,\ Aichi",
"812614", "Omachi\,\ Nagano",
"817734", "Fukuchiyama\,\ Kyoto",
"817904", "Fukusaki\,\ Hyogo",
"817683", "Wajima\,\ Ishikawa",
"811653", "Shibetsu\,\ Hokkaido",
"818567", "Tsuwano\,\ Shimane",
"818946", "Uwajima\,\ Ehime",
"81862", "Okayama\,\ Okayama",
"812553", "Joetsu\,\ Niigata",
"812897", "Kanuma\,\ Tochigi",
"818544", "Kisuki\,\ Shimane",
"815752", "Sekigahara\,\ Gifu",
"812588", "Nagaoka\,\ Niigata",
"814703", "Tateyama\,\ Chiba",
"812372", "Murayama\,\ Yamagata",
"81426", "Hachioji\,\ Tokyo",
"812483", "Shirakawa\,\ Fukushima",
"812999", "Itako\,\ Ibaraki",
"819738", "Kusu\,\ Oita",
"819827", "Takachiho\,\ Miyazaki",
"8186691", "Kurashiki\,\ Okayama",
"81822", "Hiroshima\,\ Hiroshima",
"819955", "Kajiki\,\ Kagoshima",
"8147955", "Yokaichiba\,\ Chiba",
"817366", "Iwade\,\ Wakayama",
"81260", "Anan\,\ Nagano",
"818245", "Miyoshi\,\ Hiroshima",
"818493", "Onomichi\,\ Hiroshima",
"81532", "Toyohashi\,\ Aichi",
"811987", "Tono\,\ Iwate",
"811522", "Shari\,\ Hokkaido",
"81928", "Fukuoka\,\ Fukuoka",
"81174", "Kanita\,\ Aomori",
"817940", "Kakogawa\,\ Hyogo",
"81568", "Kasugai\,\ Aichi",
"815368", "Shitara\,\ Aichi",
"818697", "Bizen\,\ Okayama",
"818546", "Kakeya\,\ Shimane",
"8112394", "Yubari\,\ Hokkaido",
"811867", "Takanosu\,\ Akita",
"817673", "Hakui\,\ Ishikawa",
"814280", "Tachikawa\,\ Tokyo",
"818806", "Sukumo\,\ Kochi",
"811337", "Ishikari\,\ Hokkaido",
"818376", "Mine\,\ Yamaguchi",
"817914", "Aioi\,\ Hyogo",
"811736", "Goshogawara\,\ Aomori",
"8182942", "Hiroshima\,\ Hiroshima",
"812478", "Miharu\,\ Fukushima",
"81965", "Yatsushiro\,\ Kumamoto",
"817615", "Komatsu\,\ Ishikawa",
"81853", "Izumo\,\ Shimane",
"812573", "Kashiwazaki\,\ Niigata",
"8188099", "Tosashimizu\,\ Kochi",
"819975", "Naze\,\ Kagoshima",
"8186993", "Bizen\,\ Okayama",
"812745", "Fujioka\,\ Gunma",
"819676", "Takamori\,\ Kumamoto",
"818663", "Soja\,\ Okayama",
"815985", "Matsusaka\,\ Mie",
"8126172", "Omachi\,\ Nagano",
"815733", "Ena\,\ Gifu",
"81272", "Maebashi\,\ Gunma",
"81835", "Hofu\,\ Yamaguchi",
"817457", "Yamatotakada\,\ Nara",
"818559", "Kawamoto\,\ Shimane",
"811232", "Chitose\,\ Hokkaido",
"8198293", "Nobeoka\,\ Miyazaki",
"812542", "Shibata\,\ Niigata",
"815743", "Minokamo\,\ Gifu",
"8128798", "Otawara\,\ Tochigi",
"812230", "Sendai\,\ Miyagi",
"817688", "Noto\,\ Ishikawa",
"818374", "Nagato\,\ Yamaguchi",
"81979", "Nakatsu\,\ Oita",
"818467", "Mima\,\ Tokushima",
"819782", "Bungotakada\,\ Oita",
"811658", "Kamikawa\,\ Hokkaido",
"811734", "Goshogawara\,\ Aomori",
"81551", "Nirasaki\,\ Yamanashi",
"819957", "Kajiki\,\ Kagoshima",
"81125", "Takikawa\,\ Hokkaido",
"815746", "Minokamo\,\ Gifu",
"81728", "Neyagawa\,\ Osaka",
"812574", "Kashiwazaki\,\ Niigata",
"81494", "Chichibu\,\ Saitama",
"819825", "Hyuga\,\ Miyazaki",
"818948", "Uwajima\,\ Ehime",
"818666", "Ibara\,\ Okayama",
"815736", "Nakatsugawa\,\ Gifu",
"819940", "Shibushi\,\ Kagoshima",
"8199343", "Kagoshima\,\ Kagoshima",
"812895", "Utsunomiya\,\ Tochigi",
"81493", "Higashimatsuyama\,\ Saitama",
"8165", "Osaka\,\ Osaka",
"81234", "Sakata\,\ Yamagata",
"811865", "Odate\,\ Akita",
"812549", "Tsugawa\,\ Niigata",
"811462", "Urakawa\,\ Hokkaido",
"818695", "Seto\,\ Okayama",
"818664", "Takahashi\,\ Okayama",
"81983", "Takanabe\,\ Miyazaki",
"819789", "Kitsuki\,\ Oita",
"815734", "Ena\,\ Gifu",
"818373", "Nagato\,\ Yamaguchi",
"81233", "Shinjo\,\ Yamagata",
"81849", "Fukuyama\,\ Hiroshima",
"811733", "Goshogawara\,\ Aomori",
"817955", "Sanda\,\ Hyogo",
"817475", "Shimonoseki\,\ Yamaguchi",
"81984", "Kobayashi\,\ Miyazaki",
"818552", "Hamada\,\ Shimane",
"812618", "Omachi\,\ Nagano",
"815744", "Minokamo\,\ Gifu",
"818247", "Shobara\,\ Hiroshima",
"817738", "Maizuru\,\ Kyoto",
"812576", "Tokamachi\,\ Niigata",
"814704", "Tateyama\,\ Chiba",
"818680", "Okayama\,\ Okayama",
"81950", "Hirado\,\ Nagasaki",
"812747", "Tomioka\,\ Gunma",
"814297", "Hanno\,\ Saitama",
"812484", "Shirakawa\,\ Fukushima",
"812554", "Joetsu\,\ Niigata",
"8198290", "Nobeoka\,\ Miyazaki",
"8126178", "Omachi\,\ Nagano",
"818543", "Yasugi\,\ Shimane",
"819977", "Setouchi\,\ Kagoshima",
"817676", "Nanao\,\ Ishikawa",
"81286", "Utsunomiya\,\ Tochigi",
"819688", "Tamana\,\ Kumamoto",
"811752", "Mutsu\,\ Aomori",
"81936", "Kitakyushu\,\ Fukuoka",
"81779", "Ono\,\ Gifu",
"817617", "Kaga\,\ Ishikawa",
"81298", "Tsuchiura\,\ Ibaraki",
"812992", "Ishioka\,\ Ibaraki",
"81765", "Uozu\,\ Toyama",
"8188095", "Tosashimizu\,\ Kochi",
"81462", "Atsugi\,\ Kanagawa",
"8153968", "Hamamatsu\,\ Shizuoka",
"812556", "Itoigawa\,\ Niigata",
"817674", "Hakui\,\ Ishikawa",
"814998", "Ogasawara\,\ Tokyo",
"81438", "Kisarazu\,\ Chiba",
"818388", "Tamagawa\,\ Yamaguchi",
"81899", "Matsuyama\,\ Ehime",
"817455", "Yamatotakada\,\ Nara",
"811555", "Obihiro\,\ Hokkaido",
"812486", "Sukagawa\,\ Fukushima",
"81222", "Sendai\,\ Miyagi",
"817468", "Kamikitayama\,\ Nara",
"818687", "Mimasaka\,\ Okayama",
"81569", "Handa\,\ Aichi",
"81596", "Ise\,\ Mie",
"811463", "Urakawa\,\ Hokkaido",
"819437", "Tanushimaru\,\ Fukuoka",
"812544", "Shibata\,\ Niigata",
"811234", "Chitose\,\ Hokkaido",
"818553", "Hamada\,\ Shimane",
"81929", "Fukuoka\,\ Fukuoka",
"819784", "Bungotakada\,\ Oita",
"81742", "Nara\,\ Nara",
"818978", "Hakata\,\ Ehime",
"818588", "Koge\,\ Tottori",
"818372", "Nagato\,\ Yamaguchi",
"811878", "Omagari\,\ Akita",
"811732", "Goshogawara\,\ Aomori",
"818669", "Soja\,\ Okayama",
"811545", "Kushiro\,\ Hokkaido",
"812235", "Sendai\,\ Miyagi",
"819786", "Kitsuki\,\ Oita",
"817912", "Aioi\,\ Hyogo",
"811236", "Chitose\,\ Hokkaido",
"812546", "Murakami\,\ Niigata",
"812697", "Iiyama\,\ Nagano",
"812967", "Kasama\,\ Ibaraki",
"81930", "Yukuhashi\,\ Fukuoka",
"81763", "Fukuno\,\ Toyama",
"81987", "Nichinan\,\ Miyazaki",
"812245", "Ogawara\,\ Miyagi",
"811535", "Akkeshi\,\ Hokkaido",
"81280", "Koga\,\ Ibaraki",
"814795", "Choshi\,\ Chiba",
"81956", "Sasebo\,\ Nagasaki",
"8112399", "Kuriyama\,\ Hokkaido",
"81764", "Toyama\,\ Toyama",
"817968", "Hamasaka\,\ Hyogo",
"811524", "Abashiri\,\ Hokkaido",
"81546", "Shizuoka\,\ Shizuoka",
"819937", "Kaseda\,\ Kagoshima",
"812376", "Sagae\,\ Yamagata",
"811858", "Noshiro\,\ Akita",
"81495", "Honjo\,\ Saitama",
"818958", "Misho\,\ Ehime",
"8125487", "Tsugawa\,\ Niigata",
"815995", "Ago\,\ Mie",
"811375", "Yakumo\,\ Hokkaido",
"818478", "Tojo\,\ Hiroshima",
"81792", "Himeji\,\ Hyogo",
"819947", "Shibushi\,\ Kagoshima",
"81253", "Niigata\,\ Niigata",
"81124", "Ashibetsu\,\ Hokkaido",
"81985", "Miyazaki\,\ Miyazaki",
"818542", "Yasugi\,\ Shimane",
"815754", "Sekigahara\,\ Gifu",
"814285", "Sagamihara\,\ Kanagawa",
"81476", "Narita\,\ Chiba",
"812374", "Murayama\,\ Yamagata",
"81531", "Tahara\,\ Aichi",
"817945", "Kakogawa\,\ Hyogo",
"812489", "Sukagawa\,\ Fukushima",
"811526", "Abashiri\,\ Hokkaido",
"8163", "Osaka\,\ Osaka",
"812993", "Ishioka\,\ Ibaraki",
"81577", "Takayama\,\ Gifu",
"814709", "Kamogawa\,\ Chiba",
"81235", "Tsuruoka\,\ Yamagata",
"818240", "Higashi\-ku\,\ Hiroshima",
"812559", "Yasuzuka\,\ Niigata",
"817705", "Obama\,\ Fukui",
"811753", "Mutsu\,\ Aomori",
"811523", "Shari\,\ Hokkaido",
"81963", "Kumamoto\,\ Kumamoto",
"812996", "Itako\,\ Ibaraki",
"81848", "Onomichi\,\ Hiroshima",
"811357", "Iwanai\,\ Hokkaido",
"8112395", "Kuriyama\,\ Hokkaido",
"814771", "Ichikawa\,\ Chiba",
"818895", "Susaki\,\ Kochi",
"812938", "Mito\,\ Ibaraki",
"811756", "Noheji\,\ Aomori",
"819435", "Yame\,\ Fukuoka",
"817672", "Hakui\,\ Ishikawa",
"8186996", "Seto\,\ Okayama",
"818685", "Tsuyama\,\ Okayama",
"812373", "Murayama\,\ Yamagata",
"814702", "Tateyama\,\ Chiba",
"81833", "Kudamatsu\,\ Yamaguchi",
"812482", "Shirakawa\,\ Fukushima",
"81177", "Aomori\,\ Aomori",
"81249", "Koriyama\,\ Fukushima",
"814797", "Yokaichiba\,\ Chiba",
"812552", "Joetsu\,\ Niigata",
"815753", "Sekigahara\,\ Gifu",
"811537", "Nakashibetsu\,\ Hokkaido",
"812247", "Ogawara\,\ Miyagi",
"8112391", "Yubari\,\ Hokkaido",
"81834", "Tokuyama\,\ Yamaguchi",
"8198296", "Hyuga\,\ Miyazaki",
"81942", "Kurume\,\ Fukuoka",
"812695", "Nakano\,\ Nagano",
"811754", "Mutsu\,\ Aomori",
"812965", "Shimodate\,\ Ibaraki",
"81729", "Yao\,\ Osaka",
"812994", "Ishioka\,\ Ibaraki",
"812911", "Hokota\,\ Ibaraki",
"812237", "Sendai\,\ Miyagi",
"811547", "Shiranuka\,\ Hokkaido",
"81482", "Kawaguchi\,\ Saitama",
"819945", "Kanoya\,\ Kagoshima",
"815997", "Ago\,\ Mie",
"811464", "Shizunai\,\ Hokkaido",
"81552", "Kofu\,\ Yamanashi",
"812890", "Utsunomiya\,\ Tochigi",
"811377", "Yakumo\,\ Hokkaido",
"818662", "Takahashi\,\ Okayama",
"818398", "Ogori\,\ Yamaguchi",
"81898", "Imabari\,\ Ehime",
"81857", "Tottori\,\ Tottori",
"81439", "Kisarazu\,\ Chiba",
"815732", "Ena\,\ Gifu",
"81188", "Akita\,\ Akita",
"819783", "Bungotakada\,\ Oita",
"817238", "Neyagawa\,\ Osaka",
"819935", "Kaseda\,\ Kagoshima",
"812543", "Shibata\,\ Niigata",
"81196", "Morioka\,\ Iwate",
"811233", "Chitose\,\ Hokkaido",
"818554", "Hamada\,\ Shimane",
"81886", "Tokushima\,\ Tokushima",
"815742", "Minokamo\,\ Gifu",
"818556", "Gotsu\,\ Shimane",
"817707", "Obama\,\ Fukui",
"812572", "Kashiwazaki\,\ Niigata",
"812388", "Nagai\,\ Yamagata",
"81266", "Suwa\,\ Nagano",
"819968", "Izumi\,\ Kagoshima",
"81778", "Takefu\,\ Fukui",
"817950", "Sanda\,\ Hyogo",
"819679", "Takamori\,\ Kumamoto",
"817947", "Miki\,\ Hyogo",
"81420", "Tokorozawa\,\ Saitama",
"81992", "Kagoshima\,\ Kagoshima",
"819597", "Fukue\,\ Nagasaki",
"814287", "Ome\,\ Tokyo",
"811466", "Erimo\,\ Hokkaido",
"818690", "Okayama\,\ Okayama",
"811528", "Bihoro\,\ Hokkaido",
"81592", "Tsu\,\ Mie",
"817995", "Sumoto\,\ Hyogo",
"81845", "Innoshima\,\ Hiroshima",
"817357", "Kushimoto\,\ Wakayama",
"8182943", "Hiroshima\,\ Hiroshima",
"812785", "Numata\,\ Gunma",
"812933", "Takahagi\,\ Ibaraki",
"818592", "Yonago\,\ Tottori",
"817964", "Toyooka\,\ Hyogo",
"81226", "Kesennuma\,\ Miyagi",
"818655", "Kamogata\,\ Okayama",
"818474", "Fuchu\,\ Hiroshima",
"818367", "Ube\,\ Yamaguchi",
"818290", "Hiroshima\,\ Hiroshima",
"81460", "Odawara\,\ Kanagawa",
"814291", "Hanno\,\ Saitama",
"8186992", "Bizen\,\ Okayama",
"811854", "Oga\,\ Akita",
"815362", "Shinshiro\,\ Aichi",
"8186697", "Kurashiki\,\ Okayama",
"818954", "Uwajima\,\ Ehime",
"812378", "Sagae\,\ Yamagata",
"81259", "Sado\,\ Niigata",
"818262", "Kake\,\ Hiroshima",
"812582", "Nagaoka\,\ Niigata",
"811856", "Noshiro\,\ Akita",
"8126173", "Omachi\,\ Nagano",
"818956", "Uwajima\,\ Ehime",
"819742", "Mie\,\ Oita",
"812855", "Oyama\,\ Tochigi",
"818476", "Fuchu\,\ Hiroshima",
"8198292", "Nobeoka\,\ Miyazaki",
"819667", "Minamata\,\ Kumamoto",
"81952", "Saga\,\ Saga",
"8147957", "Yokaichiba\,\ Chiba",
"819732", "Hita\,\ Oita",
"817495", "Nagahama\,\ Shiga",
"81542", "Shizuoka\,\ Shizuoka",
"811564", "Kamishihoro\,\ Hokkaido",
"812647", "Nagano\,\ Nagano",
"812619", "Omachi\,\ Nagano",
"817464", "Yoshino\,\ Nara",
"819788", "Kunisaki\,\ Oita",
"818974", "Niihama\,\ Ehime",
"818584", "Kurayoshi\,\ Tottori",
"811652", "Shibetsu\,\ Hokkaido",
"817717", "Sonobe\,\ Kyoto",
"817682", "Wajima\,\ Ishikawa",
"8175", "Kyoto\,\ Kyoto",
"811874", "Kakunodate\,\ Akita",
"811238", "Kuriyama\,\ Hokkaido",
"818675", "Kuse\,\ Okayama",
"81775", "Otsu\,\ Shiga",
"81178", "Hachinohe\,\ Aomori",
"812472", "Ishikawa\,\ Fukushima",
"812875", "Otawara\,\ Tochigi",
"812383", "Yonezawa\,\ Yamagata",
"81564", "Okazaki\,\ Aichi",
"818976", "Niihama\,\ Ehime",
"818586", "Kurayoshi\,\ Tottori",
"81923", "Fukuoka\,\ Fukuoka",
"819963", "Satsumasendai\,\ Kagoshima",
"811937", "Miyako\,\ Iwate",
"811876", "Omagari\,\ Akita",
"814240", "Kokubunji\,\ Tokyo",
"818203", "Yanai\,\ Yamaguchi",
"8153979", "Hamamatsu\,\ Shizuoka",
"818949", "Uwajima\,\ Ehime",
"812565", "Sanjo\,\ Niigata",
"817466", "Totsukawa\,\ Nara",
"81563", "Nishio\,\ Aichi",
"811947", "Kuji\,\ Iwate",
"81924", "Fukuoka\,\ Fukuoka",
"819805", "Nago\,\ Okinawa",
"818206", "Yanai\,\ Yamaguchi",
"81977", "Beppu\,\ Oita",
"8124196", "Yanaizu\,\ Fukushima",
"817463", "Yoshino\,\ Nara",
"81281", "Utsunomiya\,\ Tochigi",
"811563", "Honbetsu\,\ Hokkaido",
"81294", "Hitachiota\,\ Ibaraki",
"818657", "Kasaoka\,\ Okayama",
"818365", "Ube\,\ Yamaguchi",
"81142", "Date\,\ Hokkaido",
"812612", "Omachi\,\ Nagano",
"812787", "Numata\,\ Gunma",
"818558", "Kawamoto\,\ Shimane",
"812386", "Nagai\,\ Yamagata",
"814770", "Ichikawa\,\ Chiba",
"817732", "Fukuchiyama\,\ Kyoto",
"817902", "Fukusaki\,\ Hyogo",
"81585", "Ibigawa\,\ Gifu",
"818973", "Niihama\,\ Ehime",
"818583", "Kurayoshi\,\ Tottori",
"819547", "Kashima\,\ Saga",
"81270", "Isesaki\,\ Gunma",
"819966", "Izumi\,\ Kagoshima",
"8126170", "Omachi\,\ Nagano",
"8198298", "Hyuga\,\ Miyazaki",
"811873", "Kakunodate\,\ Akita",
"817355", "Shingu\,\ Fukuoka",
"817997", "Tsuna\,\ Hyogo",
"819964", "Satsumasendai\,\ Kagoshima",
"81434", "Chiba\,\ Chiba",
"818942", "Yawatahama\,\ Ehime",
"815566", "Minobu\,\ Yamanashi",
"819665", "Hitoyoshi\,\ Kumamoto",
"812384", "Yonezawa\,\ Yamagata",
"81578", "Kamioka\,\ Akita",
"8186998", "Seto\,\ Okayama",
"812857", "Mooka\,\ Tochigi",
"81433", "Chiba\,\ Chiba",
"818204", "Yanai\,\ Yamaguchi",
"812830", "Utsunomiya\,\ Tochigi",
"818797", "Tonosho\,\ Kagawa",
"81946", "Amagi\,\ Fukuoka",
"818677", "Niimi\,\ Okayama",
"81723", "Sakai\,\ Osaka",
"812934", "Takahagi\,\ Ibaraki",
"8153975", "Hamamatsu\,\ Shizuoka",
"817963", "Toyooka\,\ Hyogo",
"8125484", "Murakami\,\ Niigata",
"81244", "Hobara\,\ Fukushima",
"81486", "Urawa\,\ Saitama",
"8188097", "Tosashimizu\,\ Kochi",
"81975", "Oita\,\ Oita",
"811362", "Kutchan\,\ Hokkaido",
"817715", "Kameoka\,\ Kyoto",
"81192", "Ofunato\,\ Iwate",
"811646", "Haboro\,\ Hokkaido",
"811853", "Oga\,\ Akita",
"818953", "Uwajima\,\ Ehime",
"81587", "Ichinomiya\,\ Aichi",
"81243", "Nihonmatsu\,\ Fukushima",
"818382", "Hagi\,\ Yamaguchi",
"817497", "Nagahama\,\ Shiga",
"81839", "Yamaguchi\,\ Yamaguchi",
"8153971", "Hamamatsu\,\ Shizuoka",
"811945", "Kuji\,\ Iwate",
"81988", "Naha\,\ Okinawa",
"811644", "Rumoi\,\ Hokkaido",
"81262", "Nagano\,\ Nagano",
"818835", "Mima\,\ Tokushima",
"812998", "Itako\,\ Ibaraki",
"811935", "Kamaishi\,\ Iwate",
"812589", "Nagaoka\,\ Niigata",
"811634", "Hamatonbetsu\,\ Hokkaido",
"812877", "Kuroiso\,\ Tochigi",
"819233", "Maebaru\,\ Fukuoka",
"819682", "Yamaga\,\ Kumamoto",
"812936", "Mito\,\ Ibaraki",
"81969", "Amakusa\,\ Kumamoto",
"818660", "Seto\,\ Okayama",
"812377", "Sagae\,\ Yamagata",
"819946", "Kanoya\,\ Kagoshima",
"813", "Tokyo",
"81962", "Kumamoto\,\ Kumamoto",
"812243", "Shiroishi\,\ Miyagi",
"811533", "Nemuro\,\ Hokkaido",
"814793", "Choshi\,\ Chiba",
"8125488", "Tsugawa\,\ Niigata",
"81288", "Imabari\,\ Ehime",
"812892", "Utsunomiya\,\ Tochigi",
"819979", "Tokunoshima\,\ Kagoshima",
"819668", "Minamata\,\ Kumamoto",
"81938", "Kitakyushu\,\ Fukuoka",
"811543", "Kushiro\,\ Hokkaido",
"81827", "Iwakuni\,\ Yamaguchi",
"812233", "Iwanuma\,\ Miyagi",
"819936", "Kaseda\,\ Kagoshima",
"819822", "Nobeoka\,\ Miyazaki",
"8112393", "Yubari\,\ Hokkaido",
"819934", "Ibusuki\,\ Kagoshima",
"8167", "Osaka\,\ Osaka",
"811982", "Hanamaki\,\ Iwate",
"81537", "Kakegawa\,\ Shizuoka",
"81199", "Morioka\,\ Iwate",
"811527", "Bihoro\,\ Hokkaido",
"81166", "Asahikawa\,\ Hokkaido",
"817952", "Nishiwaki\,\ Hyogo",
"818555", "Gotsu\,\ Shimane",
"81832", "Shimonoseki\,\ Yamaguchi",
"81944", "Setaka\,\ Fukuoka",
"811353", "Yoichi\,\ Hokkaido",
"819944", "Kanoya\,\ Kagoshima",
"811862", "Kazuno\,\ Akita",
"818692", "Oku\,\ Okayama",
"811465", "Shizunai\,\ Hokkaido",
"81436", "Ichihara\,\ Chiba",
"818368", "Ube\,\ Yamaguchi",
"818490", "Onomichi\,\ Hiroshima",
"812694", "Nakano\,\ Nagano",
"817703", "Tsuruga\,\ Fukui",
"812964", "Shimodate\,\ Ibaraki",
"818896", "Susaki\,\ Kochi",
"81726", "Ibaraki\,\ Osaka",
"812995", "Ishioka\,\ Ibaraki",
"811938", "Miyako\,\ Iwate",
"81553", "Yamanashi\,\ Yamanashi",
"811332", "Tobetsu\,\ Hokkaido",
"818686", "Tsuyama\,\ Okayama",
"819593", "Oseto\,\ Nagasaki",
"8198294", "Nobeoka\,\ Miyazaki",
"817943", "Kakogawa\,\ Hyogo",
"81825", "Hiroshima\,\ Hiroshima",
"81484", "Kawaguchi\,\ Saitama",
"81246", "Iwaki\,\ Fukushima",
"8111", "Sapporo\,\ Hokkaido",
"814283", "Ome\,\ Tokyo",
"81554", "Otsuki\,\ Yamanashi",
"819434", "Yame\,\ Fukuoka",
"815993", "Toba\,\ Mie",
"812550", "Yasuzuka\,\ Niigata",
"812648", "Nagano\,\ Nagano",
"817452", "Yamatotakada\,\ Nara",
"818249", "Higashi\-ku\,\ Hiroshima",
"81277", "Kiryu\,\ Gunma",
"81535", "Hamamatsu\,\ Shizuoka",
"811552", "Obihiro\,\ Hokkaido",
"818684", "Tsuyama\,\ Okayama",
"814700", "Kamogawa\,\ Chiba",
"818462", "Takehara\,\ Hiroshima",
"819787", "Kunisaki\,\ Oita",
"817718", "Sonobe\,\ Kyoto",
"8186994", "Seto\,\ Okayama",
"811237", "Kuriyama\,\ Hokkaido",
"812547", "Murakami\,\ Niigata",
"812696", "Iiyama\,\ Nagano",
"818894", "Susaki\,\ Kochi",
"81744", "Yamatotakada\,\ Nara",
"819952", "Okuchi\,\ Kagoshima",
"812693", "Nakano\,\ Nagano",
"817704", "Tsuruga\,\ Fukui",
"812963", "Shimodate\,\ Ibaraki",
"811376", "Yakumo\,\ Hokkaido",
"815996", "Ago\,\ Mie",
"81743", "Nara\,\ Nara",
"812858", "Mooka\,\ Tochigi",
"815755", "Sekigahara\,\ Gifu",
"814284", "Tachikawa\,\ Tokyo",
"812375", "Murayama\,\ Yamagata",
"818798", "Tonosho\,\ Kagawa",
"817944", "Kakogawa\,\ Hyogo",
"8125482", "Murakami\,\ Niigata",
"819596", "Fukue\,\ Nagasaki",
"818683", "Tsuyama\,\ Okayama",
"81762", "Kanazawa\,\ Ishikawa",
"817946", "Miki\,\ Hyogo",
"8112390", "Yubari\,\ Hokkaido",
"819433", "Yame\,\ Fukuoka",
"811374", "Mori\,\ Hokkaido",
"815994", "Ago\,\ Mie",
"81465", "Odawara\,\ Kanagawa",
"814286", "Sagamihara\,\ Kanagawa",
"818242", "Higashi\-ku\,\ Hiroshima",
"812788", "Maebashi\,\ Gunma",
"8188096", "Tosashimizu\,\ Kochi",
"81549", "Shizuoka\,\ Shizuoka",
"818893", "Sakawa\,\ Kochi",
"818557", "Kawamoto\,\ Shimane",
"817706", "Obama\,\ Fukui",
"811525", "Abashiri\,\ Hokkaido",
"81738", "Gobo\,\ Wakayama",
"817998", "Tsuna\,\ Hyogo",
"811559", "Obihiro\,\ Hokkaido",
"812244", "Shiroishi\,\ Miyagi",
"811534", "Nakashibetsu\,\ Hokkaido",
"814794", "Choshi\,\ Chiba",
"819808", "Yaeyama\ District\,\ Okinawa",
"812742", "Fujioka\,\ Gunma",
"811544", "Kushiro\,\ Hokkaido",
"812234", "Sendai\,\ Miyagi",
"81793", "Himeji\,\ Hyogo",
"812997", "Itako\,\ Ibaraki",
"81252", "Niigata\,\ Niigata",
"812899", "Kanuma\,\ Tochigi",
"817612", "Komatsu\,\ Ishikawa",
"8152", "Nagoya\,\ Aichi",
"818514", "Ama\,\ Shimane",
"811757", "Noheji\,\ Aomori",
"812878", "Nasukarasuyama\,\ Tochigi",
"811356", "Iwanai\,\ Hokkaido",
"812545", "Murakami\,\ Niigata",
"811235", "Yubari\,\ Hokkaido",
"811869", "Odate\,\ Akita",
"818678", "Niimi\,\ Okayama",
"811354", "Yoichi\,\ Hokkaido",
"81467", "Fujisawa\,\ Kanagawa",
"819785", "Bungotakada\,\ Oita",
"812236", "Sendai\,\ Miyagi",
"811546", "Kushiro\,\ Hokkaido",
"819933", "Ibusuki\,\ Kagoshima",
"8186552", "Kurashiki\,\ Okayama",
"81926", "Fukuoka\,\ Fukuoka",
"817959", "Sanda\,\ Hyogo",
"81566", "Kariya\,\ Aichi",
"815982", "Matsusaka\,\ Mie",
"817498", "Nagahama\,\ Shiga",
"819943", "Kanoya\,\ Kagoshima",
"811536", "Akkeshi\,\ Hokkaido",
"8124197", "Yanaizu\,\ Fukushima",
"812246", "Ogawara\,\ Miyagi",
"814796", "Yokaichiba\,\ Chiba",
"819572", "Isahaya\,\ Nagasaki",
"8126179", "Omachi\,\ Nagano",
"818834", "Kamojima\,\ Tokushima",
"811934", "Kamaishi\,\ Iwate",
"817716", "Sonobe\,\ Kyoto",
"81144", "Tomakomai\,\ Hokkaido",
"811635", "Hamatonbetsu\,\ Hokkaido",
"812679", "Saku\,\ Nagano",
"818299", "Hiroshima\,\ Hiroshima",
"812698", "Iiyama\,\ Nagano",
"81427", "Sagamihara\,\ Kanagawa",
"812968", "Kasama\,\ Ibaraki",
"814752", "Mobara\,\ Chiba",
"818844", "Anan\,\ Tokushima",
"81292", "Mito\,\ Ibaraki",
"812646", "Nagano\,\ Nagano",
"812853", "Oyama\,\ Tochigi",
"811944", "Iwaizumi\,\ Iwate",
"811645", "Rumoi\,\ Hokkaido",
"81143", "Muroran\,\ Hokkaido",
"817722", "Miyazu\,\ Kyoto",
"8125486", "Tsugawa\,\ Niigata",
"81468", "Yokosuka\,\ Kanagawa",
"8199347", "Kagoshima\,\ Kagoshima",
"818688", "Mimasaka\,\ Okayama",
"8153969", "Hamamatsu\,\ Shizuoka",
"819438", "Tanushimaru\,\ Fukuoka",
"81162", "Wakkanai\,\ Hokkaido",
"811946", "Kuji\,\ Iwate",
"812412", "Kitakata\,\ Fukushima",
"81138", "Hakodate\,\ Hokkaido",
"81559", "Numazu\,\ Shizuoka",
"818879", "Muroto\,\ Kochi",
"815972", "Owase\,\ Mie",
"815582", "Shimoda\,\ Shizuoka",
"811392", "Kikonai\,\ Hokkaido",
"812783", "Numata\,\ Gunma",
"812935", "Mito\,\ Ibaraki",
"81489", "Soka\,\ Saitama",
"811589", "Okoppe\,\ Hokkaido",
"812571", "Muika\,\ Niigata",
"811877", "Omagari\,\ Akita",
"817993", "Sumoto\,\ Hyogo",
"818836", "Mima\,\ Tokushima",
"81432", "Chiba\,\ Chiba",
"819543", "Takeo\,\ Saga",
"818587", "Koge\,\ Tottori",
"818977", "Hakata\,\ Ehime",
"811936", "Miyako\,\ Iwate",
"817714", "Kameoka\,\ Kyoto",
"81425", "Tachikawa\,\ Tokyo",
"81949", "Nogata\,\ Fukuoka",
"812659", "Ina\,\ Nagano",
"818366", "Ube\,\ Yamaguchi",
"819803", "Nago\,\ Okinawa",
"8186698", "Kurashiki\,\ Okayama",
"818205", "Yanai\,\ Yamaguchi",
"812563", "Sanjo\,\ Niigata",
"815762", "Gero\,\ Gifu",
"81722", "Sakai\,\ Osaka",
"819552", "Imari\,\ Saga",
"81242", "Aizuwakamatsu\,\ Fukushima",
"819965", "Satsumasendai\,\ Kagoshima",
"8153973", "Hamamatsu\,\ Shizuoka",
"817356", "Kushimoto\,\ Wakayama",
"812873", "Otawara\,\ Tochigi",
"819664", "Hitoyoshi\,\ Kumamoto",
"812385", "Yonezawa\,\ Yamagata",
"814772", "Ichikawa\,\ Chiba",
"819666", "Minamata\,\ Kumamoto",
"81263", "Matsumoto\,\ Nagano",
"819938", "Kaseda\,\ Kagoshima",
"817354", "Shingu\,\ Fukuoka",
"818957", "Misho\,\ Ehime",
"814701", "Kamogawa\,\ Chiba",
"812832", "Sano\,\ Tochigi",
"812799", "Naganohara\,\ Gunma",
"811857", "Noshiro\,\ Akita",
"817493", "Hikone\,\ Shiga",
"812551", "Joetsu\,\ Niigata",
"819948", "Shibushi\,\ Kagoshima",
"818477", "Tojo\,\ Hiroshima",
"818364", "Ube\,\ Yamaguchi",
"81737", "Yuasa\,\ Wakayama",
"812564", "Sanjo\,\ Niigata",
"811647", "Haboro\,\ Hokkaido",
"817496", "Nagahama\,\ Shiga",
"812248", "Ogawara\,\ Miyagi",
"81593", "Yokkaichi\,\ Mie",
"814798", "Yokaichiba\,\ Chiba",
"8168", "Osaka\,\ Osaka",
"819804", "Nago\,\ Okinawa",
"812652", "Iida\,\ Nagano",
"8153965", "Hamamatsu\,\ Shizuoka",
"8126171", "Omachi\,\ Nagano",
"812874", "Otawara\,\ Tochigi",
"819663", "Hitoyoshi\,\ Kumamoto",
"818676", "Kuse\,\ Okayama",
"81594", "Kuwana\,\ Mie",
"811548", "Teshikaga\,\ Hokkaido",
"812238", "Sendai\,\ Miyagi",
"8188098", "Tosashimizu\,\ Kochi",
"815769", "Shokawa\,\ Gifu",
"81935", "Kitakyushu\,\ Fukuoka",
"818585", "Kurayoshi\,\ Tottori",
"818975", "Niihama\,\ Ehime",
"812792", "Shibukawa\,\ Gunma",
"811875", "Kakunodate\,\ Akita",
"812839", "Sano\,\ Tochigi",
"817353", "Shingu\,\ Fukuoka",
"815959", "Kameyama\,\ Mie",
"812937", "Mito\,\ Ibaraki",
"812876", "Kuroiso\,\ Tochigi",
"81766", "Takaoka\,\ Toyama",
"818674", "Kuse\,\ Okayama",
"811952", "Ninohe\,\ Iwate",
"817494", "Hikone\,\ Shiga",
"819722", "Saiki\,\ Oita",
"8182941", "Hiroshima\,\ Hiroshima",
"8126175", "Omachi\,\ Nagano",
"818363", "Ube\,\ Yamaguchi",
"812566", "Sanjo\,\ Niigata",
"817465", "Yoshino\,\ Nara",
"812387", "Nagai\,\ Yamagata",
"812786", "Numata\,\ Gunma",
"81543", "Shizuoka\,\ Shizuoka",
"818833", "Kamojima\,\ Tokushima",
"8198297", "Hyuga\,\ Miyazaki",
"817996", "Tsuna\,\ Hyogo",
"819546", "Kashima\,\ Saga",
"819967", "Izumi\,\ Kagoshima",
"811933", "Kamaishi\,\ Iwate",
"81126", "Iwamizawa\,\ Hokkaido",
"81937", "Kitakyushu\,\ Fukuoka",
"819598", "Fukue\,\ Nagasaki",
"817948", "Miki\,\ Hyogo",
"818656", "Kasaoka\,\ Okayama",
"818843", "Anan\,\ Tokushima",
"81544", "Fujinomiya\,\ Shizuoka",
"812854", "Oyama\,\ Tochigi",
"818292", "Hiroshima\,\ Hiroshima",
"814288", "Ome\,\ Tokyo",
"811943", "Iwaizumi\,\ Iwate",
"81828", "Hiroshima\,\ Hiroshima",
"812672", "Komoro\,\ Nagano",
"81538", "Iwata\,\ Shizuoka",
"815998", "Ago\,\ Mie",
"811378", "Imakane\,\ Hokkaido",
"818654", "Kamogata\,\ Okayama",
"81922", "Fukuoka\,\ Fukuoka",
"815392", "Hamamatsu\,\ Shizuoka",
"811972", "Mizusawa\,\ Iwate",
"811582", "Monbetsu\,\ Hokkaido",
"812856", "Mooka\,\ Tochigi",
"818475", "Fuchu\,\ Hiroshima",
"8186997", "Seto\,\ Okayama",
"815979", "Kumano\,\ Mie",
"818872", "Muroto\,\ Kochi",
"81473", "Ichikawa\,\ Chiba",
"818796", "Tonosho\,\ Kagawa",
"811855", "Noshiro\,\ Akita",
"812580", "Tokamachi\,\ Niigata",
"811452", "Hayakita\,\ Hokkaido",
"8153970", "Hamamatsu\,\ Shizuoka",
"817482", "Yokaichi\,\ Shiga",
"818397", "Ogori\,\ Yamaguchi",
"818955", "Uwajima\,\ Ehime",
"817994", "Sumoto\,\ Hyogo",
"818562", "Masuda\,\ Shimane",
"819544", "Takeo\,\ Saga",
"81474", "Funabashi\,\ Chiba",
"814220", "Kokubunji\,\ Tokyo",
"817713", "Kameoka\,\ Kyoto",
"812419", "Tajima\,\ Fukushima",
"812784", "Numata\,\ Gunma",
"817965", "Toyooka\,\ Hyogo",};
$areanames{ja} = {"815363", "新城",
"817678", "七尾",
"812415", "柳津",
"814994", "三宅",
"819727", "臼杵",
"818384", "萩",
"817969", "浜坂",
"8112397", "栗山",
"819686", "玉名",
"815585", "下田",
"811957", "岩手",
"811364", "倶知安",
"811366", "寿都",
"819733", "日田",
"81191", "一関",
"819684", "山鹿",
"812657", "伊那",
"814996", "八丈島",
"812558", "新井",
"819743", "三重",
"814755", "東金",
"818263", "加計",
"81893", "大洲",
"81220", "迫",
"817734", "福知山",
"81567", "津島",
"81862", "岡山",
"817683", "輪島",
"811653", "士別",
"817487", "水口",
"811457", "門別富川",
"81927", "福岡",
"815397", "浜松",
"81740", "今津",
"818877", "嶺北",
"818360", "小郡",
"81989", "那覇",
"818297", "廿日市",
"81932", "北九州",
"819555", "唐津",
"815765", "下呂",
"8182920", "廿日市",
"819962", "川内",
"817736", "舞鶴",
"812382", "米沢",
"811738", "鰺ケ沢",
"81550", "御殿場",
"81480", "久喜",
"818808", "土佐清水",
"818582", "倉吉",
"818972", "新居浜",
"815587", "修善寺大仁",
"817903", "福崎",
"811955", "二戸",
"815977", "熊野",
"812476", "三春",
"812613", "大町",
"811562", "本別",
"819725", "佐伯",
"812417", "会津山口",
"81471", "柏",
"817239", "寝屋川",
"812560", "糸魚川",
"81245", "福島",
"814757", "東金",
"812474", "石川",
"812655", "飯田",
"81725", "和泉",
"818943", "八幡浜",
"818875", "土佐山田",
"8153974", "天竜",
"818472", "甲山",
"815395", "浜松",
"812939", "水戸",
"817485", "八日市",
"811455", "鵡川",
"811852", "男鹿",
"812976", "竜ケ崎",
"812586", "長岡",
"814226", "武蔵野三鷹",
"812917", "水戸",
"818594", "米子",
"817368", "岩出",
"818596", "米子",
"812780", "前橋",
"819232", "前原",
"81583", "岐阜",
"814224", "武蔵野三鷹",
"819557", "唐津",
"812584", "長岡",
"812974", "水海道",
"815767", "下呂",
"811639", "利尻礼文",
"81584", "大垣",
"818295", "廿日市",
"818548", "石見大田",
"817955", "三田",
"81849", "福山",
"818373", "長門",
"817738", "舞鶴",
"818247", "庄原",
"81984", "小林",
"818552", "浜田",
"818695", "岡山瀬戸",
"819789", "杵築",
"81983", "高鍋",
"819673", "熊本一の宮",
"8165", "大阪",
"819940", "志布志",
"8199343", "鹿児島",
"81551", "韮崎",
"81125", "滝川",
"81728", "寝屋川",
"819825", "日向",
"817674", "羽咋",
"81438", "木更津",
"814998", "小笠原",
"818388", "田万川",
"817455", "大和高田",
"81899", "松山",
"812556", "糸魚川",
"81765", "魚津",
"8188095", "土佐清水",
"8153977", "天竜",
"811752", "むつ",
"819688", "玉名",
"81936", "北九州",
"817617", "加賀",
"81298", "土浦",
"8188091", "窪川",
"81950", "平戸",
"817676", "七尾",
"812554", "上越",
"819977", "瀬戸内",
"814280", "立川",
"818546", "掛合",
"818697", "備前",
"8112394", "夕張",
"818598", "根雨",
"817364", "和歌山橋本",
"818245", "三次",
"818493", "尾道",
"817957", "丹波柏原",
"811987", "遠野",
"81532", "豊橋",
"811522", "斜里",
"814228", "武蔵野三鷹",
"81822", "広島",
"819827", "高千穂",
"81260", "阿南町",
"817366", "岩出",
"818544", "木次",
"812483", "白河",
"812999", "潮来",
"812588", "長岡",
"814703", "館山",
"812978", "竜ケ崎",
"815743", "美濃加茂",
"8128798", "大田原",
"8198293", "延岡",
"812542", "新発田",
"811734", "五所川原",
"818804", "土佐中村",
"818467", "木江",
"81979", "中津",
"815733", "恵那",
"818663", "総社",
"817457", "大和高田",
"819975", "名瀬",
"8188099", "土佐清水",
"8186993", "備前",
"811736", "五所川原",
"8182942", "広島",
"818806", "宿毛",
"8153962", "天竜",
"812573", "柏崎",
"812478", "三春",
"817615", "小松",
"817486", "水口",
"811456", "門別富川",
"817723", "宮津",
"81878", "高松",
"812975", "水海道",
"812585", "長岡",
"818294", "廿日市",
"818876", "土佐山田",
"81561", "瀬戸",
"815396", "浜松",
"8166", "大阪",
"817960", "八鹿",
"81176", "十和田",
"814225", "武蔵野三鷹",
"819573", "諫早",
"81885", "小松島",
"819542", "武雄",
"817992", "洲本",
"818595", "米子",
"811393", "松前",
"817737", "舞鶴",
"818248", "庄原",
"81424", "武蔵野三鷹",
"818296", "広島",
"818874", "安芸",
"818652", "倉敷",
"815394", "浜松",
"817484", "八日市",
"811454", "鵡川",
"81423", "国分寺",
"811956", "岩手",
"812872", "大田原",
"812475", "石川",
"819687", "玉名",
"817618", "加賀",
"812654", "飯田",
"819802", "南大東",
"819978", "徳之島",
"81734", "和歌山",
"819726", "臼杵",
"815953", "上野",
"819724", "佐伯",
"818387", "田万川",
"817492", "彦根",
"812833", "宇都宮",
"811367", "寿都",
"811954", "二戸",
"812656", "伊那",
"818369", "宇部",
"819828", "高千穂",
"812569", "巻",
"817230", "寝屋川",
"81236", "山形",
"814227", "武蔵野三鷹",
"81998", "鹿児島",
"81250", "新津",
"819554", "伊万里",
"815764", "下呂",
"812977", "竜ケ崎",
"812587", "長岡",
"819556", "唐津",
"8183768", "下関",
"815766", "下呂",
"818698", "備前",
"818679", "新見",
"81182", "横手",
"817735", "福知山",
"818597", "根雨",
"81545", "富士",
"812914", "鉾田",
"817958", "丹波柏原",
"812793", "渋川",
"812673", "小諸",
"811942", "岩泉",
"812416", "田島",
"814754", "茂原",
"81948", "飯塚",
"811932", "釜石",
"819685", "玉名",
"812477", "三春",
"812859", "小山",
"812930", "水戸",
"815586", "下田",
"815584", "下田",
"815974", "尾鷲",
"81284", "足利",
"811365", "倶知安",
"8112392", "夕張",
"818563", "益田",
"8125480", "村上",
"812414", "柳津",
"817458", "大和榛原",
"818385", "萩",
"812642", "木曾福島",
"812789", "前橋",
"811583", "紋別",
"811973", "水沢",
"814756", "東金",
"812232", "岩沼",
"817614", "小松",
"812658", "伊那",
"812893", "宇都宮",
"812557", "新井",
"819974", "屋久島",
"814792", "銚子",
"812242", "白石",
"81172", "弘前",
"819976", "名瀬",
"811863", "鹿角",
"8144", "川崎",
"817677", "七尾",
"819728", "臼杵",
"819949", "大根占",
"811958", "岩手",
"81739", "田辺",
"817473", "五条",
"817616", "小松",
"811735", "五所川原",
"81548", "榛原",
"818805", "土佐中村",
"81429", "所沢",
"818298", "廿日市",
"818545", "木次",
"817942", "加古川",
"819592", "大瀬戸",
"811333", "当別",
"81273", "高崎",
"8198295", "日向",
"818246", "三次",
"817365", "和歌山橋本",
"818244", "三次",
"8112396", "栗山",
"817488", "水口",
"81852", "松江",
"811553", "帯広",
"8198291", "延岡",
"818878", "嶺北",
"81487", "浦和",
"8186995", "岡山瀬戸",
"81557", "伊東",
"815398", "浜松",
"811372", "鹿部",
"8147950", "八日市場",
"818391", "小郡",
"817456", "大和高田",
"812555", "糸魚川",
"814758", "東金",
"81875", "観音寺",
"812962", "下館",
"812692", "中野",
"819953", "大口",
"814289", "青梅",
"818466", "木江",
"81776", "福井",
"818807", "宿毛",
"81492", "川越",
"818464", "竹原",
"811737", "鰺ケ沢",
"81888", "高知",
"815999", "津",
"815588", "修善寺大仁",
"815978", "熊野",
"817675", "七尾",
"812418", "会津山口",
"817454", "大和高田",
"818682", "津山",
"81227", "仙台",
"8199345", "鹿児島",
"8188093", "窪川",
"811539", "根室標津",
"81464", "厚木",
"817956", "三田",
"8186999", "岡山瀬戸",
"811986", "遠野",
"819824", "延岡",
"819558", "唐津",
"811549", "釧路",
"812743", "藤岡",
"815768", "下呂",
"81134", "小樽",
"81463", "平塚",
"818547", "掛合",
"818696", "備前",
"8198299", "日向",
"81797", "西宮",
"818694", "岡山",
"815983", "松阪",
"817954", "西脇",
"819826", "日向",
"811984", "花巻",
"8178", "神戸",
"8162", "大阪",
"817367", "岩出",
"81549", "静岡",
"818893", "佐川",
"818557", "川本",
"818242", "東広島",
"811559", "帯広",
"811525", "網走",
"81738", "御坊",
"817998", "津名",
"817946", "三木",
"8112390", "夕張",
"8125482", "村上",
"819596", "福江",
"811374", "森",
"819433", "八女",
"81465", "小田原",
"811376", "八雲",
"817944", "加古川",
"819594", "有川",
"81566", "刈谷",
"814796", "八日市場",
"817498", "長浜",
"819943", "鹿屋",
"812246", "大河原",
"811869", "大館",
"812545", "村上",
"812236", "仙台",
"819933", "指宿",
"8186552", "倉敷",
"81926", "福岡",
"81252", "新潟",
"812234", "仙台",
"812878", "烏山",
"812899", "鹿沼",
"817612", "小松",
"8152", "名古屋",
"811757", "野辺地",
"814794", "銚子",
"819972", "種子島",
"819808", "八重山",
"812244", "白石",
"818692", "邑久",
"811982", "花巻",
"81537", "掛川",
"811527", "美幌",
"817952", "西脇",
"81944", "瀬高",
"812570", "小出",
"811353", "余市",
"818555", "江津",
"81832", "下関",
"819822", "延岡",
"81827", "岩国",
"811543", "釧路",
"818660", "岡山瀬戸",
"81288", "今市",
"81962", "熊本",
"811533", "根室",
"818462", "竹原",
"812696", "飯山",
"812547", "村上",
"817452", "大和高田",
"815993", "鳥羽",
"812648", "長野",
"814700", "鴨川",
"818684", "津山",
"818686", "津山",
"814283", "青梅",
"8111", "札幌",
"812694", "中野",
"817703", "敦賀",
"812964", "下館",
"818490", "尾道",
"811938", "宮古",
"819806", "沖縄宮古",
"818363", "宇部",
"817494", "彦根",
"819722", "佐伯",
"812839", "佐野",
"817353", "新宮",
"818585", "倉吉",
"818975", "新居浜",
"812876", "黒磯",
"811952", "二戸",
"815959", "亀山",
"812874", "大田原",
"819663", "人吉",
"812652", "飯田",
"81594", "桑名",
"812238", "仙台",
"8188098", "土佐清水",
"814798", "八日市場",
"819804", "名護",
"817496", "長浜",
"812248", "大河原",
"81593", "四日市",
"819544", "武雄",
"817713", "亀岡",
"817994", "洲本",
"81562", "尾張横須賀",
"818872", "室戸",
"811378", "今金",
"81922", "福岡",
"815392", "浜松",
"818654", "鴨方",
"818475", "府中",
"811452", "早来",
"817482", "八日市",
"818397", "小郡",
"811855", "能代",
"817948", "三木",
"81937", "北九州",
"819598", "福江",
"818292", "広島",
"818656", "笠岡",
"818843", "阿南",
"81544", "富士宮",
"812387", "長井",
"819546", "鹿島",
"819967", "出水",
"81543", "静岡",
"818833", "鴨島",
"817996", "津名",
"812783", "沼田",
"811589", "興部",
"81138", "函館",
"815972", "尾鷲",
"815582", "下田",
"818587", "郡家",
"818977", "伯方",
"811936", "宮古",
"8125486", "津川",
"81468", "横須賀",
"818688", "美作",
"811946", "久慈",
"812412", "喜多方",
"811567", "十勝清水",
"812644", "木曾福島",
"811944", "岩泉",
"814752", "茂原",
"812646", "長野",
"812853", "小山",
"818793", "三本松",
"811934", "釜石",
"812698", "飯山",
"812968", "笠間",
"812679", "佐久",
"812799", "長野原",
"811857", "能代",
"818477", "東城",
"812551", "上越",
"818673", "福渡",
"819965", "川内",
"812385", "米沢",
"81425", "立川",
"81949", "直方",
"815762", "下呂",
"819552", "伊万里",
"812563", "三条",
"812695", "中野",
"811754", "むつ",
"812965", "下館",
"812237", "仙台",
"812911", "鉾田",
"81729", "八尾",
"81177", "青森",
"81249", "郡山",
"812373", "村山",
"815753", "関",
"812247", "大河原",
"814797", "八日市場",
"812552", "上越",
"817672", "羽咋",
"818685", "津山",
"811756", "野辺地",
"81848", "尾道",
"819912", "中之島",
"819597", "福江",
"817947", "三木",
"812388", "長井",
"81266", "諏訪",
"818556", "江津",
"819679", "高森",
"819968", "出水",
"819783", "豊後高田",
"81196", "盛岡",
"811233", "千歳",
"818554", "浜田",
"812890", "宇都宮",
"811377", "八雲",
"81552", "甲府",
"81482", "川口",
"81898", "今治",
"818398", "小郡",
"81857", "鳥取",
"81439", "木更津",
"814795", "銚子",
"812245", "大河原",
"812579", "小出",
"81764", "富山",
"81956", "佐世保",
"812235", "仙台",
"81930", "行橋",
"81763", "福野",
"812546", "村上",
"812697", "飯山",
"812967", "笠間",
"812544", "新発田",
"818669", "総社",
"811732", "五所川原",
"818588", "郡家",
"818978", "伯方",
"81742", "奈良",
"818802", "窪川",
"81222", "仙台",
"818687", "美作",
"811463", "浦河",
"814709", "鴨川",
"812489", "須賀川",
"811526", "網走",
"812993", "石岡",
"8163", "大阪",
"81476", "成田",
"81985", "宮崎",
"818542", "安来",
"817945", "加古川",
"81531", "田原",
"819595", "有川",
"811858", "能代",
"81124", "芦別",
"811375", "八雲",
"8125487", "津川",
"81792", "姫路",
"818478", "東城",
"817362", "和歌山橋本",
"811524", "網走",
"8186998", "岡山瀬戸",
"81433", "千葉",
"81578", "神岡",
"8153960", "天竜",
"812830", "宇都宮",
"81434", "千葉",
"819964", "川内",
"812384", "米沢",
"812386", "長井",
"814770", "市川",
"81585", "揖斐川",
"817732", "福知山",
"81142", "伊達",
"818558", "川本",
"811873", "角館",
"8198298", "日向",
"817997", "津名",
"819547", "鹿島",
"819966", "出水",
"817463", "吉野",
"818657", "笠岡",
"81294", "常陸太田",
"811935", "釜石",
"819682", "山鹿",
"812877", "黒磯",
"811945", "久慈",
"819807", "沖縄宮古",
"81262", "長野",
"81988", "那覇",
"81724", "岸和田貝塚",
"818953", "宇和島",
"81192", "大船渡",
"818382", "萩",
"814992", "伊豆大島",
"817497", "長浜",
"812645", "木曾福島",
"81243", "二本松",
"81723", "堺",
"8125484", "村上",
"817963", "豊岡",
"81975", "大分",
"811362", "倶知安",
"81244", "原町",
"81486", "浦和",
"8147957", "八日市場",
"81952", "佐賀",
"814222", "武蔵野三鷹",
"812972", "水海道",
"812582", "長岡",
"811856", "能代",
"811643", "石狩深川",
"818476", "府中",
"818655", "鴨方",
"818474", "府中",
"8186697", "倉敷",
"811854", "男鹿",
"811528", "美幌",
"817995", "洲本",
"81845", "因島",
"812933", "高萩",
"818592", "米子",
"81226", "気仙沼",
"818203", "柳井",
"818949", "宇和",
"819805", "名護",
"811947", "久慈",
"811566", "十勝清水",
"812875", "大田原",
"812472", "石川",
"814240", "国分寺",
"818976", "新居浜",
"818586", "倉吉",
"811937", "宮古",
"818584", "倉吉",
"818974", "新居浜",
"815563", "鰍沢青柳",
"812647", "長野",
"812619", "大町",
"817495", "長浜",
"811564", "上士幌",
"81565", "豊田",
"81774", "宇治",
"812932", "高萩",
"818593", "米子",
"818479", "東城",
"811395", "江差",
"81925", "福岡",
"812797", "渋川",
"814223", "武蔵野三鷹",
"819575", "諫早",
"81184", "本荘",
"811632", "天塩",
"812640", "長野",
"812488", "須賀川",
"817725", "宮津",
"81183", "湯沢",
"811642", "石狩深川",
"812973", "水海道",
"812583", "長岡",
"814708", "大原",
"815748", "美濃白川",
"817904", "福崎",
"812614", "大町",
"815562", "鰍沢青柳",
"818567", "津和野",
"818946", "宇和",
"815738", "中津川",
"812835", "佐野",
"81466", "藤沢",
"818668", "井原",
"815955", "上野",
"811587", "中湧別",
"811977", "北上",
"812677", "佐久",
"818202", "柳井",
"81282", "栃木",
"8125489", "津川",
"818944", "八幡浜",
"817906", "播磨山崎",
"814775", "船橋",
"812578", "六日町",
"812473", "石川",
"812616", "大町",
"812956", "常陸大宮",
"812795", "渋川",
"817684", "輪島",
"818378", "下関",
"811654", "名寄",
"817733", "福知山",
"811397", "奥尻",
"814281", "相模原",
"81167", "富良野",
"819969", "中甑",
"819678", "矢部",
"817727", "峰山",
"812389", "米沢",
"8164", "大阪",
"819577", "島原",
"817686", "能都",
"811656", "美深",
"818383", "萩",
"8125485", "津川",
"815957", "上野",
"811585", "遠軽",
"811975", "水沢",
"819746", "竹田",
"818952", "宇和島",
"812837", "佐野",
"818266", "千代田",
"811363", "倶知安",
"811541", "弟子屈",
"818565", "益田",
"81276", "太田",
"817962", "豊岡",
"819683", "山鹿",
"814777", "船橋",
"8125481", "村上",
"81179", "三戸",
"8169", "大阪",
"819734", "日田",
"81940", "宗像",
"815366", "設楽",
"81591", "津",
"81727", "池田",
"818264", "安芸吉田",
"8183767", "下関",
"812675", "佐久",
"819744", "三重",
"811733", "五所川原",
"818803", "土佐中村",
"81233", "新庄",
"815744", "美濃加茂",
"817908", "播磨山崎",
"819205", "厳原",
"812576", "十日町",
"817475", "下市",
"812618", "大町",
"812549", "津川",
"811462", "浦河",
"81234", "酒田",
"811865", "大館",
"815734", "恵那",
"818664", "高梁",
"815736", "中津川",
"818666", "井原",
"812895", "宇都宮",
"81493", "東松山",
"819957", "加治木",
"815746", "美濃加茂",
"812574", "柏崎",
"81494", "秩父",
"818948", "宇和",
"812486", "須賀川",
"815987", "三瀬谷",
"811555", "帯広",
"814706", "大原",
"817363", "和歌山橋本",
"81462", "厚木",
"81779", "大野",
"812992", "石岡",
"814297", "飯能",
"812484", "白河",
"818680", "岡山",
"814704", "館山",
"812747", "富岡",
"81286", "宇都宮",
"8198290", "延岡",
"818543", "安来",
"81568", "春日井",
"817940", "加古川",
"815368", "設楽",
"81174", "蟹田",
"811867", "鷹巣",
"817673", "羽咋",
"819913", "硫黄島",
"81928", "福岡",
"8186691", "倉敷",
"819738", "玖珠",
"8147955", "八日市場",
"819955", "加治木",
"815752", "関",
"812553", "上越",
"812897", "鹿沼",
"818268", "千代田",
"812372", "村山",
"81426", "八王子",
"811232", "千歳",
"817916", "竜野",
"812230", "仙台",
"817688", "能都",
"818374", "長門",
"819782", "豊後高田",
"811658", "上川",
"811557", "十勝池田",
"815985", "松阪",
"819676", "高森",
"818559", "川本",
"81272", "前橋",
"81835", "防府",
"812745", "藤岡",
"819674", "熊本一の宮",
"817914", "相生",
"811337", "石狩",
"818376", "美祢",
"81853", "出雲",
"81965", "八代",
"818792", "三本松",
"818265", "安芸吉田",
"811939", "宮古",
"812674", "小諸",
"812852", "小山",
"814753", "茂原",
"811586", "中湧別",
"811976", "北上",
"8186553", "倉敷",
"819735", "日田",
"818947", "宇和",
"81798", "西宮",
"818564", "益田",
"812649", "長野",
"812617", "大町",
"812782", "沼田",
"817907", "播磨山崎",
"815973", "尾鷲",
"815583", "下田",
"812676", "佐久",
"812413", "喜多方",
"811584", "遠軽",
"811974", "水沢",
"8112398", "栗山",
"812955", "常陸大宮",
"812796", "渋川",
"819553", "伊万里",
"812748", "富岡",
"815763", "下呂",
"812562", "三条",
"8125483", "村上",
"814298", "飯能",
"81582", "岐阜",
"815988", "三瀬谷",
"812913", "鉾田",
"817685", "輪島",
"812794", "渋川",
"811655", "名寄",
"818672", "福渡",
"81228", "築館",
"819737", "玖珠",
"818945", "八幡浜",
"819662", "人吉",
"819809", "八重山",
"812653", "飯田",
"812898", "鹿沼",
"815956", "上野",
"819747", "竹田",
"812879", "烏山",
"818267", "千代田",
"812836", "佐野",
"81986", "都城",
"812834", "宇都宮",
"815367", "設楽",
"818362", "宇部",
"8145", "横浜",
"815954", "上野",
"811868", "鷹巣",
"819723", "佐伯",
"814776", "船橋",
"817905", "福崎",
"811953", "二戸",
"819208", "対馬佐賀",
"81892", "久万",
"812615", "大町",
"817352", "新宮",
"81721", "富田林",
"81488", "浦和",
"81863", "玉野",
"818293", "廿日市",
"818842", "阿南",
"817724", "宮津",
"81864", "倉敷",
"812957", "大子",
"818832", "鴨島",
"819574", "諫早",
"811396", "江差",
"81933", "北九州",
"811394", "松前",
"817712", "亀岡",
"817687", "能都",
"819576", "島原",
"81934", "北九州",
"817483", "八日市",
"817726", "峰山",
"811453", "早来",
"811558", "広尾",
"81547", "島田",
"818873", "安芸",
"815393", "浜松",
"817915", "相生",
"819823", "延岡",
"81534", "浜松",
"811542", "釧路",
"818512", "隠岐の島",
"81947", "田川",
"81478", "佐原",
"81240", "磐城富岡",
"811532", "根室",
"81533", "豊橋",
"815986", "松阪",
"812744", "藤岡",
"814707", "大原",
"819675", "熊本一の宮",
"812487", "須賀川",
"815984", "松阪",
"812746", "富岡",
"81823", "呉",
"818693", "邑久",
"8126177", "長野",
"811352", "余市",
"81555", "吉田",
"81485", "熊谷",
"817953", "西脇",
"811983", "花巻",
"812798", "長野原",
"818375", "美祢",
"812678", "佐久",
"814282", "青梅",
"81958", "長崎",
"8199331", "鹿児島",
"817702", "敦賀",
"819954", "加治木",
"812577", "六日町",
"819956", "加治木",
"815747", "美濃白川",
"81586", "一宮",
"818689", "岡山",
"818463", "竹原",
"818568", "津和野",
"818667", "井原",
"815737", "中津川",
"8188090", "窪川",
"817453", "大和高田",
"811588", "興部",
"811978", "北上",
"815992", "鳥羽",
"812485", "白河",
"819677", "矢部",
"817728", "峰山",
"811556", "帯広",
"814705", "館山",
"8183766", "下関",
"81268", "上田",
"819599", "大瀬戸",
"817949", "加古川",
"817917", "竜野",
"81939", "北九州",
"819578", "島原",
"811336", "石狩",
"818377", "下関",
"8161", "大阪",
"818892", "佐川",
"818243", "東広島",
"811398", "熊石",
"81157", "北見",
"819432", "八女",
"811554", "帯広",
"81896", "伊予三島",
"81877", "丸亀",
"812575", "十日町",
"817476", "下市",
"817613", "小松",
"81572", "多治見",
"812239", "仙台",
"812894", "宇都宮",
"819973", "種子島",
"811866", "鷹巣",
"812896", "鹿沼",
"815958", "亀山",
"811864", "大館",
"819942", "大根占",
"815735", "恵那",
"812838", "佐野",
"818665", "高梁",
"81225", "石巻",
"819932", "指宿",
"815745", "美濃加茂",
"819204", "郷ノ浦",
"817474", "五条",
"8188096", "土佐清水",
"812788", "前橋",
"817706", "小浜",
"817459", "大和榛原",
"81762", "金沢",
"818683", "津山",
"814286", "相模原",
"815994", "阿児",
"814284", "立川",
"815755", "関",
"815996", "阿児",
"81743", "奈良",
"812858", "真岡",
"812375", "村山",
"818798", "土庄",
"81744", "大和高田",
"812693", "中野",
"817704", "敦賀",
"812963", "下館",
"819952", "大口",
"815982", "松阪",
"817959", "三田",
"811536", "厚岸",
"8124197", "柳津",
"818678", "新見",
"81467", "藤沢",
"811354", "余市",
"811235", "夕張",
"819785", "豊後高田",
"811546", "釧路",
"812997", "潮来",
"811544", "釧路",
"81793", "姫路",
"811356", "岩内",
"818514", "海士",
"811534", "中標津",
"812742", "藤岡",
"812568", "巻",
"811465", "静内",
"81436", "市原",
"818368", "宇部",
"819944", "鹿屋",
"811862", "鹿角",
"81199", "盛岡",
"81166", "旭川",
"819934", "指宿",
"8167", "大阪",
"817472", "五条",
"819668", "水俣",
"81938", "北九州",
"819979", "徳之島",
"8112393", "夕張",
"812233", "岩沼",
"819936", "加世田",
"812377", "寒河江",
"814793", "銚子",
"8125488", "津川",
"812892", "宇都宮",
"819946", "鹿屋",
"813", "東京",
"815757", "郡上八幡",
"812243", "白石",
"819787", "国東",
"817718", "園部",
"8186994", "岡山瀬戸",
"811237", "栗山",
"818894", "須崎",
"818249", "東広島",
"81277", "桐生",
"819434", "八女",
"812550", "安塚",
"81535", "浜松",
"811552", "帯広",
"8198294", "延岡",
"817943", "加古川",
"81825", "広島",
"819593", "大瀬戸",
"81554", "大月",
"81484", "川口",
"818848", "牟岐",
"81246", "いわき",
"818896", "須崎",
"81726", "茨木",
"81553", "山梨",
"811332", "当別",
"812995", "石岡",
"818838", "阿波池田",
"8182941", "広島",
"8153961", "天竜",
"817465", "吉野",
"812566", "三条",
"811875", "角館",
"812792", "渋川",
"81766", "高岡",
"818674", "久世",
"812937", "水戸",
"811637", "北見枝幸",
"81581", "高富",
"818676", "久世",
"81935", "北九州",
"811548", "弟子屈",
"815769", "荘川",
"811647", "羽幌",
"812564", "三条",
"8168", "大阪",
"811538", "根室標津",
"81474", "船橋",
"814220", "国分寺",
"81229", "古川",
"818562", "益田",
"812784", "沼田",
"817965", "豊岡",
"812419", "田島",
"815979", "熊野",
"815589", "修善寺大仁",
"81473", "市川",
"815998", "阿児",
"81538", "磐田",
"811972", "水沢",
"811582", "紋別",
"812856", "真岡",
"812643", "木曾福島",
"8186997", "岡山瀬戸",
"818955", "宇和島",
"818796", "土庄",
"812580", "十日町",
"818207", "久賀",
"818794", "三本松",
"814288", "青梅",
"811943", "岩泉",
"81828", "広島",
"812672", "小諸",
"812854", "小山",
"812786", "沼田",
"811933", "釜石",
"81126", "岩見沢",
"8198297", "日向",
"8188092", "窪川",
"812935", "水戸",
"815399", "天竜",
"81489", "草加",
"812571", "六日町",
"81559", "沼津",
"818879", "室戸",
"811392", "木古内",
"819543", "武雄",
"81432", "千葉",
"817714", "亀岡",
"811877", "大曲",
"817993", "洲本",
"818836", "脇町",
"8199347", "鹿児島",
"81162", "稚内",
"818846", "丹生谷",
"819438", "田主丸",
"818844", "阿南",
"81292", "水戸",
"817722", "宮津",
"811645", "留萌",
"81143", "室蘭",
"817716", "園部",
"819572", "諫早",
"818834", "鴨島",
"81427", "相模原",
"81144", "苫小牧",
"811635", "浜頓別",
"818299", "広島",
"818957", "御荘",
"814701", "鴨川",
"812832", "佐野",
"815952", "上野",
"818364", "宇部",
"81737", "湯浅",
"817493", "彦根",
"819948", "志布志",
"819666", "水俣",
"81263", "松本",
"815565", "鰍沢青柳",
"817967", "八鹿",
"817354", "新宮",
"819938", "加世田",
"817356", "串本",
"81242", "会津若松",
"812873", "大田原",
"819664", "人吉",
"814772", "市川",
"812659", "伊那",
"818366", "宇部",
"819803", "名護",
"81722", "堺",
"8186698", "倉敷",
"818205", "柳井",
"81942", "久留米",
"818549", "石見大田",
"811638", "利尻礼文",
"81834", "徳山",
"8198296", "日向",
"811547", "白糠",
"812994", "石岡",
"812482", "白河",
"814702", "館山",
"81833", "下松",
"811648", "焼尻",
"811537", "中標津",
"8112391", "夕張",
"819435", "八女",
"81964", "松橋",
"8186996", "岡山瀬戸",
"811523", "斜里",
"812996", "潮来",
"81963", "熊本",
"8112395", "栗山",
"814771", "市川",
"818895", "須崎",
"812938", "水戸",
"811357", "岩内",
"81992", "鹿児島",
"818208", "久賀",
"81420", "所沢",
"811466", "えりも",
"818690", "岡山",
"814287", "青梅",
"812572", "柏崎",
"817707", "小浜",
"817950", "三田",
"81778", "武生",
"817238", "寝屋川",
"819935", "加世田",
"81886", "徳島",
"815742", "美濃加茂",
"812543", "新発田",
"815997", "阿児",
"811464", "静内",
"819945", "鹿屋",
"815732", "恵那",
"81188", "秋田",
"818662", "高梁",
"81280", "古河",
"811535", "厚岸",
"8112399", "栗山",
"819672", "熊本一の宮",
"817912", "相生",
"811545", "釧路",
"819786", "杵築",
"81987", "日南",
"811236", "千歳",
"81929", "福岡",
"811234", "千歳",
"818553", "浜田",
"811878", "大曲",
"819784", "豊後高田",
"818372", "長門",
"817468", "上北山",
"819437", "田主丸",
"81569", "半田",
"81596", "伊勢",
"81577", "高山",
"812559", "安塚",
"817705", "小浜",
"811753", "むつ",
"81235", "鶴岡",
"818240", "東広島",
"815754", "関",
"814285", "相模原",
"812374", "村山",
"81495", "本庄",
"818958", "御荘",
"812376", "寒河江",
"8188094", "窪川",
"819947", "志布志",
"81253", "新潟",
"815756", "郡上八幡",
"815995", "阿児",
"817968", "浜坂",
"819937", "加世田",
"81546", "静岡",
"812857", "真岡",
"818797", "土庄",
"81946", "甘木",
"818204", "柳井",
"811551", "十勝池田",
"818942", "八幡浜",
"819665", "人吉",
"815566", "身延",
"817902", "福崎",
"815564", "鰍沢青柳",
"812612", "大町",
"812787", "沼田",
"817355", "新宮",
"818583", "倉吉",
"818973", "新居浜",
"81270", "伊勢崎",
"81281", "宇都宮",
"818206", "柳井",
"81977", "別府",
"8124196", "柳津",
"818365", "宇部",
"811563", "本別",
"812979", "竜ケ崎",
"812589", "長岡",
"812998", "潮来",
"818835", "脇町",
"819233", "前原",
"812936", "水戸",
"81969", "天草",
"811634", "浜頓別",
"818845", "丹生谷",
"812567", "巻",
"811644", "留萌",
"814229", "武蔵野三鷹",
"811646", "羽幌",
"811853", "男鹿",
"81839", "山口",
"81587", "一宮",
"818473", "甲山",
"812934", "高萩",
"811636", "北見枝幸",
"818677", "新見",
"8188097", "土佐清水",
"817715", "亀岡",
"817966", "八鹿",
"819667", "水俣",
"8198292", "延岡",
"819732", "日田",
"818956", "宇和島",
"812378", "寒河江",
"81259", "佐渡",
"818262", "加計",
"818795", "三本松",
"815758", "郡上八幡",
"819742", "三重",
"812855", "小山",
"818290", "広島",
"818367", "宇部",
"815362", "新城",
"818954", "宇和島",
"81460", "小田原",
"814291", "飯能",
"8186992", "備前",
"8182943", "広島",
"81592", "津",
"8153963", "天竜",
"817357", "串本",
"812785", "沼田",
"817964", "豊岡",
"817466", "十津川",
"81563", "西尾",
"812565", "三条",
"818847", "牟岐",
"81924", "福岡",
"812383", "米沢",
"81564", "岡崎",
"81775", "大津",
"81178", "八戸",
"811876", "大曲",
"818837", "阿波池田",
"81923", "福岡",
"819963", "川内",
"811874", "角館",
"819788", "国東",
"811652", "士別",
"817717", "園部",
"817682", "輪島",
"8175", "京都",
"818675", "久世",
"811238", "栗山",
"81542", "静岡",
"817464", "吉野",};
my $timezones = {
               '' => [
                       'Asia/Tokyo'
                     ],
               '70859' => [
                            'Asia/Tokyo'
                          ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+81|\D)//g;
      my $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      my $prefix = qr/^(?:(000[2569]\d{4,6})$|(?:(?:003768)0?)|0)/;
      my @matches = $number =~ /$prefix/;
      if (defined $matches[-1]) {
        no warnings 'uninitialized';
        $number =~ s/$prefix/$1/;
      }
      else {
        $number =~ s/$prefix//;
      }
      $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;