# Generated by default/object.tt
package Paws::Kendra::DocumentInfo;
  use Moose;
  has Attributes => (is => 'ro', isa => 'ArrayRef[Paws::Kendra::DocumentAttribute]');
  has DocumentId => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Kendra::DocumentInfo

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Kendra::DocumentInfo object:

  $service_obj->Method(Att1 => { Attributes => $value, ..., DocumentId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Kendra::DocumentInfo object:

  $result = $service_obj->Method(...);
  $result->Att1->Attributes

=head1 DESCRIPTION

Identifies a document for which to retrieve status information

=head1 ATTRIBUTES


=head2 Attributes => ArrayRef[L<Paws::Kendra::DocumentAttribute>]

Attributes that identify a specific version of a document to check.

The only valid attributes are:

=over

=item *

version

=item *

datasourceId

=item *

jobExecutionId

=back

The attributes follow these rules:

=over

=item *

C<dataSourceId> and C<jobExecutionId> must be used together.

=item *

C<version> is ignored if C<dataSourceId> and C<jobExecutionId> are not
provided.

=item *

If C<dataSourceId> and C<jobExecutionId> are provided, but C<version>
is not, the version defaults to "0".

=back



=head2 B<REQUIRED> DocumentId => Str

The unique identifier of the document.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Kendra>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

