/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import java.util.HashMap;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.DecimalSymbols;
import net.sf.saxon.trans.XPathException;

public class DecimalFormatManager
implements Serializable {
    private DecimalSymbols defaultDFS;
    private HashMap<StructuredQName, DecimalFormatInfo> formatTable = new HashMap(10);
    private boolean usingOriginalDefault = true;
    public static final StructuredQName DEFAULT_NAME = new StructuredQName("saxon", "http://saxon.sf.net/", "default-decimal-format");

    public DecimalFormatManager() {
        this.defaultDFS = new DecimalSymbols();
    }

    public void setDefaultDecimalFormat(DecimalSymbols dfs, int precedence) throws XPathException {
        this.usingOriginalDefault = false;
        this.setNamedDecimalFormat(DEFAULT_NAME, dfs, precedence);
        this.defaultDFS = this.getNamedDecimalFormat(DEFAULT_NAME);
    }

    public void fixupDefaultDefault() throws XPathException {
        if (this.usingOriginalDefault) {
            this.setNamedDecimalFormat(DEFAULT_NAME, this.defaultDFS, -1000);
        }
    }

    public DecimalSymbols getDefaultDecimalFormat() {
        return this.defaultDFS;
    }

    public void setNamedDecimalFormat(StructuredQName qName, DecimalSymbols dfs, int precedence) throws XPathException {
        DecimalFormatInfo o = this.formatTable.get(qName);
        if (o != null) {
            DecimalFormatInfo info = o;
            DecimalSymbols old = info.dfs;
            int oldPrecedence = info.precedence;
            if (precedence < oldPrecedence) {
                return;
            }
            if (precedence == oldPrecedence && !dfs.equals(old)) {
                XPathException err = new XPathException("There are two conflicting definitions of the " + (qName.equals(DEFAULT_NAME) ? "unnamed" : "named") + " decimal-format");
                err.setErrorCode("XTSE1290");
                err.setIsStaticError(true);
                throw err;
            }
        }
        DecimalFormatInfo dfi = new DecimalFormatInfo();
        dfi.dfs = dfs;
        dfi.precedence = precedence;
        this.formatTable.put(qName, dfi);
    }

    public DecimalSymbols getNamedDecimalFormat(StructuredQName qName) {
        DecimalFormatInfo dfi = this.formatTable.get(qName);
        if (dfi == null) {
            return null;
        }
        return dfi.dfs;
    }

    public DecimalSymbols obtainNamedDecimalFormat(StructuredQName qName) throws XPathException {
        DecimalFormatInfo dfi = this.formatTable.get(qName);
        if (dfi == null) {
            DecimalSymbols symbols = new DecimalSymbols();
            this.setNamedDecimalFormat(qName, symbols, 0);
            return symbols;
        }
        return dfi.dfs;
    }

    private static class DecimalFormatInfo
    implements Serializable {
        public DecimalSymbols dfs;
        public int precedence;

        private DecimalFormatInfo() {
        }
    }
}

