/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.cli;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.SystemUtils;

class BatchCommandLineBuilder {
    static Pattern JVM_OPTS_PATTERN = Pattern.compile("^(--?)J(.+)");

    BatchCommandLineBuilder() {
    }

    protected static String[] build(String[] args) throws IOException {
        LinkedHashMap<String, String> processArgs = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> jvmOpts = new LinkedHashMap<String, String>();
        BatchCommandLineBuilder.mapifyArgs(args, processArgs, jvmOpts);
        BatchCommandLineBuilder.translateCommandLine(args, processArgs);
        if (!jvmOpts.containsKey("-cp") && !jvmOpts.containsKey("--classpath")) {
            String cp = System.getProperty("java.class.path");
            jvmOpts.put("-cp", cp);
        }
        boolean hasLog4j = false;
        for (String k : jvmOpts.keySet()) {
            if (!k.startsWith("-Dlog4j.configuration=")) continue;
            hasLog4j = true;
            break;
        }
        if (!hasLog4j) {
            jvmOpts.put("-Dlog4j.configuration=log4j_batch_process.properties", "");
        }
        ArrayList<String> fullCommand = new ArrayList<String>();
        fullCommand.add("java");
        boolean foundHeadlessOption = false;
        for (Map.Entry e : jvmOpts.entrySet()) {
            fullCommand.add((String)e.getKey());
            if (((String)e.getValue()).length() > 0) {
                fullCommand.add(BatchCommandLineBuilder.commandLineSafe((String)e.getValue()));
            }
            if (!((String)e.getKey()).contains("java.awt.headless")) continue;
            foundHeadlessOption = true;
        }
        if (!foundHeadlessOption) {
            fullCommand.add("-Djava.awt.headless=true");
        }
        fullCommand.add("org.apache.tika.batch.fs.FSBatchProcessCLI");
        for (Map.Entry e : processArgs.entrySet()) {
            fullCommand.add((String)e.getKey());
            if (((String)e.getValue()).length() <= 0) continue;
            fullCommand.add(BatchCommandLineBuilder.commandLineSafe((String)e.getValue()));
        }
        return fullCommand.toArray(new String[fullCommand.size()]);
    }

    protected static String commandLineSafe(String arg) {
        if (arg == null) {
            return arg;
        }
        if (arg.contains(" ") && SystemUtils.IS_OS_WINDOWS) {
            arg = "\"" + arg + "\"";
        }
        return arg;
    }

    private static void mapifyArgs(String[] args, Map<String, String> commandLine, Map<String, String> jvmArgs) {
        if (args.length == 0) {
            return;
        }
        Matcher matcher = JVM_OPTS_PATTERN.matcher("");
        for (int i = 0; i < args.length; ++i) {
            String v;
            if (matcher.reset(args[i]).find()) {
                String jvmArg = matcher.group(1) + matcher.group(2);
                v = "";
                if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                    v = args[i + 1];
                    ++i;
                }
                jvmArgs.put(jvmArg, v);
                continue;
            }
            if (!args[i].startsWith("-")) continue;
            String k = args[i];
            v = "";
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                v = args[i + 1];
                ++i;
            }
            commandLine.put(k, v);
        }
    }

    private static void translateCommandLine(String[] args, Map<String, String> map) throws IOException {
        if (args.length == 2 && !args[0].startsWith("-") && !args[1].startsWith("-")) {
            Path path = Paths.get(args[0], new String[0]);
            Path candOutput = Paths.get(args[1], new String[0]);
            if (Files.isRegularFile(candOutput, new LinkOption[0])) {
                throw new IllegalArgumentException("Can't specify an existing file as the second argument for the output directory of a batch process");
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                map.put("-inputDir", args[0]);
                map.put("-outputDir", args[1]);
            }
        }
        for (String arg : args) {
            if (!arg.startsWith("--config=")) continue;
            String configPath = arg.substring("--config=".length());
            map.put("-c", configPath);
            break;
        }
        if (map.containsKey("-h") || map.containsKey("--html")) {
            map.remove("-h");
            map.remove("--html");
            map.put("-basicHandlerType", "html");
        } else if (map.containsKey("-x") || map.containsKey("--xml")) {
            map.remove("-x");
            map.remove("--xml");
            map.put("-basicHandlerType", "xml");
        } else if (map.containsKey("-t") || map.containsKey("--text")) {
            map.remove("-t");
            map.remove("--text");
            map.put("-basicHandlerType", "text");
        } else if (map.containsKey("-m") || map.containsKey("--metadata")) {
            map.remove("-m");
            map.remove("--metadata");
            map.put("-basicHandlerType", "ignore");
        } else if (map.containsKey("-T") || map.containsKey("--text-main")) {
            map.remove("-T");
            map.remove("--text-main");
            map.put("-basicHandlerType", "body");
        }
        if (map.containsKey("-J") || map.containsKey("--jsonRecursive")) {
            map.remove("-J");
            map.remove("--jsonRecursive");
            map.put("-recursiveParserWrapper", "true");
        }
        if (map.containsKey("--inputDir") || map.containsKey("-i")) {
            String string = map.remove("--inputDir");
            String v2 = map.remove("-i");
            String v = string == null ? v2 : string;
            map.put("-inputDir", v);
        }
        if (map.containsKey("--outputDir") || map.containsKey("-o")) {
            String string = map.remove("--outputDir");
            String v2 = map.remove("-o");
            String v = string == null ? v2 : string;
            map.put("-outputDir", v);
        }
    }
}

