/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.util.NoSuchElementException;
import org.apache.uima.internal.util.IntListIterator;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.PositiveIntSet;

public class IntSet
implements PositiveIntSet {
    private IntVector iVec;

    public IntSet() {
        this.iVec = new IntVector();
    }

    public IntSet(int capacity) {
        this.iVec = new IntVector(capacity);
    }

    @Override
    public boolean add(int element) {
        if (!this.iVec.contains(element)) {
            this.iVec.add(element);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(int element) {
        return this.iVec.contains(element);
    }

    @Override
    public int find(int element) {
        return this.iVec.indexOf(element);
    }

    @Override
    public int size() {
        return this.iVec.size();
    }

    @Override
    public int get(int n) {
        return this.iVec.get(n);
    }

    public void removeElementAt(int n) {
        this.iVec.remove(n);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof IntSet)) {
            return false;
        }
        IntSet s = (IntSet)o;
        int size = this.size();
        if (size == s.size()) {
            int i;
            int sum1 = 0;
            int sum2 = 0;
            IntVector v1 = this.iVec;
            IntVector v2 = s.iVec;
            for (i = 0; i < size; ++i) {
                sum1 += v1.get(i);
                sum2 += v2.get(i);
            }
            if (sum1 != sum2) {
                return false;
            }
            for (i = 0; i < size; ++i) {
                if (s.contains(v1.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.iVec == null) {
            return 0;
        }
        int sum = 0;
        for (int i = 0; i < this.size(); ++i) {
            sum += this.iVec.get(i);
        }
        return sum;
    }

    public int indexOf(int element) {
        return this.iVec.indexOf(element);
    }

    @Override
    public void clear() {
        this.iVec.removeAllElements();
    }

    @Override
    public boolean remove(int key) {
        int i = this.iVec.indexOfOptimizeAscending(key);
        if (i != -1) {
            this.iVec.remove(i);
        }
        return i != -1;
    }

    @Override
    public IntSetIterator iterator() {
        return new IntSetIterator();
    }

    @Override
    public int moveToFirst() {
        return this.size() == 0 ? -1 : 0;
    }

    @Override
    public int moveToLast() {
        return this.size() - 1;
    }

    @Override
    public int moveToNext(int position) {
        if (position < 0) {
            return -1;
        }
        int r = position + 1;
        return this.size() <= r ? -1 : r;
    }

    @Override
    public int moveToPrevious(int position) {
        if (position >= this.size()) {
            return -1;
        }
        return position < 0 ? -1 : position - 1;
    }

    @Override
    public boolean isValid(int position) {
        return position >= 0 && position < this.size();
    }

    @Override
    public void bulkAddTo(IntVector v) {
        v.addBulk(this.iVec);
    }

    @Override
    public int[] toIntArray() {
        return this.iVec.toIntArray();
    }

    public String toString() {
        return String.format("IntSet [iVec=%s]", this.iVec);
    }

    private class IntSetIterator
    implements IntListIterator {
        protected int pos = 0;

        protected IntSetIterator() {
        }

        @Override
        public final boolean hasNext() {
            return this.pos >= 0 && this.pos < IntSet.this.size();
        }

        @Override
        public final int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return IntSet.this.iVec.get(this.pos++);
        }

        @Override
        public boolean hasPrevious() {
            int posm1 = this.pos - 1;
            return posm1 >= 0 && posm1 < IntSet.this.size();
        }

        @Override
        public int previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return IntSet.this.iVec.get(this.pos--);
        }

        @Override
        public void moveToEnd() {
            this.pos = IntSet.this.size() - 1;
        }

        @Override
        public void moveToStart() {
            this.pos = 0;
        }
    }
}

