/*
 * Decompiled with CFR 0.152.
 */
package libsvm;

import libsvm.QMatrix;
import libsvm.svm;

class Solver {
    int active_size;
    byte[] y;
    double[] G;
    static final byte LOWER_BOUND = 0;
    static final byte UPPER_BOUND = 1;
    static final byte FREE = 2;
    byte[] alpha_status;
    double[] alpha;
    QMatrix Q;
    float[] QD;
    double eps;
    double Cp;
    double Cn;
    double[] p;
    int[] active_set;
    double[] G_bar;
    int l;
    boolean unshrink;
    static final double INF = Double.POSITIVE_INFINITY;

    Solver() {
    }

    double get_C(int n) {
        return this.y[n] > 0 ? this.Cp : this.Cn;
    }

    void update_alpha_status(int n) {
        this.alpha_status[n] = this.alpha[n] >= this.get_C(n) ? 1 : (this.alpha[n] <= 0.0 ? 0 : 2);
    }

    boolean is_upper_bound(int n) {
        return this.alpha_status[n] == 1;
    }

    boolean is_lower_bound(int n) {
        return this.alpha_status[n] == 0;
    }

    boolean is_free(int n) {
        return this.alpha_status[n] == 2;
    }

    void swap_index(int n, int n2) {
        this.Q.swap_index(n, n2);
        byte by = this.y[n];
        this.y[n] = this.y[n2];
        this.y[n2] = by;
        double d = this.G[n];
        this.G[n] = this.G[n2];
        this.G[n2] = d;
        byte by2 = this.alpha_status[n];
        this.alpha_status[n] = this.alpha_status[n2];
        this.alpha_status[n2] = by2;
        double d2 = this.alpha[n];
        this.alpha[n] = this.alpha[n2];
        this.alpha[n2] = d2;
        d2 = this.p[n];
        this.p[n] = this.p[n2];
        this.p[n2] = d2;
        int n3 = this.active_set[n];
        this.active_set[n] = this.active_set[n2];
        this.active_set[n2] = n3;
        double d3 = this.G_bar[n];
        this.G_bar[n] = this.G_bar[n2];
        this.G_bar[n2] = d3;
    }

    void reconstruct_gradient() {
        int n;
        if (this.active_size == this.l) {
            return;
        }
        int n2 = 0;
        for (n = this.active_size; n < this.l; ++n) {
            this.G[n] = this.G_bar[n] + this.p[n];
        }
        for (n = 0; n < this.active_size; ++n) {
            if (!this.is_free(n)) continue;
            ++n2;
        }
        if (2 * n2 < this.active_size) {
            svm.info("\nWarning: using -h 0 may be faster\n");
        }
        if (n2 * this.l > 2 * this.active_size * (this.l - this.active_size)) {
            for (int i = this.active_size; i < this.l; ++i) {
                float[] fArray = this.Q.get_Q(i, this.active_size);
                for (n = 0; n < this.active_size; ++n) {
                    if (!this.is_free(n)) continue;
                    int n3 = i;
                    this.G[n3] = this.G[n3] + this.alpha[n] * (double)fArray[n];
                }
            }
        } else {
            for (int i = 0; i < this.active_size; ++i) {
                if (!this.is_free(i)) continue;
                float[] fArray = this.Q.get_Q(i, this.l);
                double d = this.alpha[i];
                for (n = this.active_size; n < this.l; ++n) {
                    int n4 = n;
                    this.G[n4] = this.G[n4] + d * (double)fArray[n];
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void Solve(int var1_1, QMatrix var2_2, double[] var3_3, byte[] var4_4, double[] var5_5, double var6_6, double var8_7, double var10_8, SolutionInfo var12_9, int var13_10) {
        this.l = var1_1;
        this.Q = var2_2;
        this.QD = var2_2.get_QD();
        this.p = (double[])var3_3.clone();
        this.y = (byte[])var4_4.clone();
        this.alpha = (double[])var5_5.clone();
        this.Cp = var6_6;
        this.Cn = var8_7;
        this.eps = var10_8;
        this.unshrink = false;
        this.alpha_status = new byte[var1_1];
        for (var14_11 = 0; var14_11 < var1_1; ++var14_11) {
            this.update_alpha_status(var14_11);
        }
        this.active_set = new int[var1_1];
        for (var14_11 = 0; var14_11 < var1_1; ++var14_11) {
            this.active_set[var14_11] = var14_11;
        }
        this.active_size = var1_1;
        this.G = new double[var1_1];
        this.G_bar = new double[var1_1];
        for (var14_11 = 0; var14_11 < var1_1; ++var14_11) {
            this.G[var14_11] = this.p[var14_11];
            this.G_bar[var14_11] = 0.0;
        }
        for (var14_11 = 0; var14_11 < var1_1; ++var14_11) {
            if (this.is_lower_bound(var14_11)) continue;
            var15_12 = var2_2.get_Q(var14_11, var1_1);
            var16_14 = this.alpha[var14_11];
            for (var18_16 = 0; var18_16 < var1_1; ++var18_16) {
                v0 = var18_16;
                this.G[v0] = this.G[v0] + var16_14 * (double)var15_12[var18_16];
            }
            if (!this.is_upper_bound(var14_11)) continue;
            for (var18_16 = 0; var18_16 < var1_1; ++var18_16) {
                v1 = var18_16;
                this.G_bar[v1] = this.G_bar[v1] + this.get_C(var14_11) * (double)var15_12[var18_16];
            }
        }
        var14_11 = 0;
        var15_13 = Math.min(var1_1, 1000) + 1;
        var16_15 = new int[2];
        block6: while (true) {
            if (--var15_13 == 0) {
                var15_13 = Math.min(var1_1, 1000);
                if (var13_10 != 0) {
                    this.do_shrinking();
                }
                svm.info(".");
            }
            if (this.select_working_set(var16_15) != 0) {
                this.reconstruct_gradient();
                this.active_size = var1_1;
                svm.info("*");
                if (this.select_working_set(var16_15) != 0) break;
                var15_13 = 1;
            }
            var17_17 = var16_15[0];
            var18_16 = var16_15[1];
            ++var14_11;
            var19_20 = var2_2.get_Q(var17_17, this.active_size);
            var20_22 = var2_2.get_Q(var18_16, this.active_size);
            var21_23 = this.get_C(var17_17);
            var23_24 = this.get_C(var18_16);
            var25_25 = this.alpha[var17_17];
            var27_26 = this.alpha[var18_16];
            if (this.y[var17_17] != this.y[var18_16]) {
                var29_27 = var19_20[var17_17] + var20_22[var18_16] + 2.0f * var19_20[var18_16];
                if (var29_27 <= 0.0) {
                    var29_27 = 1.0E-12;
                }
                var31_28 = (-this.G[var17_17] - this.G[var18_16]) / var29_27;
                var33_30 = this.alpha[var17_17] - this.alpha[var18_16];
                v2 = var17_17;
                this.alpha[v2] = this.alpha[v2] + var31_28;
                v3 = var18_16;
                this.alpha[v3] = this.alpha[v3] + var31_28;
                if (var33_30 > 0.0) {
                    if (this.alpha[var18_16] < 0.0) {
                        this.alpha[var18_16] = 0.0;
                        this.alpha[var17_17] = var33_30;
                    }
                } else if (this.alpha[var17_17] < 0.0) {
                    this.alpha[var17_17] = 0.0;
                    this.alpha[var18_16] = -var33_30;
                }
                if (var33_30 > var21_23 - var23_24) {
                    if (this.alpha[var17_17] > var21_23) {
                        this.alpha[var17_17] = var21_23;
                        this.alpha[var18_16] = var21_23 - var33_30;
                    }
                } else if (this.alpha[var18_16] > var23_24) {
                    this.alpha[var18_16] = var23_24;
                    this.alpha[var17_17] = var23_24 + var33_30;
                }
            } else {
                var29_27 = var19_20[var17_17] + var20_22[var18_16] - 2.0f * var19_20[var18_16];
                if (var29_27 <= 0.0) {
                    var29_27 = 1.0E-12;
                }
                var31_28 = (this.G[var17_17] - this.G[var18_16]) / var29_27;
                var33_30 = this.alpha[var17_17] + this.alpha[var18_16];
                v4 = var17_17;
                this.alpha[v4] = this.alpha[v4] - var31_28;
                v5 = var18_16;
                this.alpha[v5] = this.alpha[v5] + var31_28;
                if (var33_30 > var21_23) {
                    if (this.alpha[var17_17] > var21_23) {
                        this.alpha[var17_17] = var21_23;
                        this.alpha[var18_16] = var33_30 - var21_23;
                    }
                } else if (this.alpha[var18_16] < 0.0) {
                    this.alpha[var18_16] = 0.0;
                    this.alpha[var17_17] = var33_30;
                }
                if (var33_30 > var23_24) {
                    if (this.alpha[var18_16] > var23_24) {
                        this.alpha[var18_16] = var23_24;
                        this.alpha[var17_17] = var33_30 - var23_24;
                    }
                } else if (this.alpha[var17_17] < 0.0) {
                    this.alpha[var17_17] = 0.0;
                    this.alpha[var18_16] = var33_30;
                }
            }
            var29_27 = this.alpha[var17_17] - var25_25;
            var31_28 = this.alpha[var18_16] - var27_26;
            for (var33_29 = 0; var33_29 < this.active_size; ++var33_29) {
                v6 = var33_29;
                this.G[v6] = this.G[v6] + ((double)var19_20[var33_29] * var29_27 + (double)var20_22[var33_29] * var31_28);
            }
            var33_29 = (int)this.is_upper_bound(var17_17);
            var34_31 = this.is_upper_bound(var18_16);
            this.update_alpha_status(var17_17);
            this.update_alpha_status(var18_16);
            if (var33_29 != this.is_upper_bound(var17_17)) {
                var19_20 = var2_2.get_Q(var17_17, var1_1);
                if (var33_29 != 0) {
                    for (var35_32 = 0; var35_32 < var1_1; ++var35_32) {
                        v7 = var35_32;
                        this.G_bar[v7] = this.G_bar[v7] - var21_23 * (double)var19_20[var35_32];
                    }
                } else {
                    for (var35_32 = 0; var35_32 < var1_1; ++var35_32) {
                        v8 = var35_32;
                        this.G_bar[v8] = this.G_bar[v8] + var21_23 * (double)var19_20[var35_32];
                    }
                }
            }
            if (var34_31 == this.is_upper_bound(var18_16)) continue;
            var20_22 = var2_2.get_Q(var18_16, var1_1);
            if (var34_31) {
                var35_32 = 0;
                while (true) {
                    if (var35_32 >= var1_1) continue block6;
                    v9 = var35_32;
                    this.G_bar[v9] = this.G_bar[v9] - var23_24 * (double)var20_22[var35_32];
                    ++var35_32;
                }
            }
            var35_32 = 0;
            while (true) {
                if (var35_32 < var1_1) ** break;
                continue block6;
                v10 = var35_32;
                this.G_bar[v10] = this.G_bar[v10] + var23_24 * (double)var20_22[var35_32];
                ++var35_32;
            }
            break;
        }
        var12_9.rho = this.calculate_rho();
        var17_18 = 0.0;
        for (var19_21 = 0; var19_21 < var1_1; ++var19_21) {
            var17_18 += this.alpha[var19_21] * (this.G[var19_21] + this.p[var19_21]);
        }
        var12_9.obj = var17_18 / 2.0;
        for (var17_19 = 0; var17_19 < var1_1; ++var17_19) {
            var5_5[this.active_set[var17_19]] = this.alpha[var17_19];
        }
        var12_9.upper_bound_p = var6_6;
        var12_9.upper_bound_n = var8_7;
        svm.info("\noptimization finished, #iter = " + var14_11 + "\n");
    }

    int select_working_set(int[] nArray) {
        int n;
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        int n2 = -1;
        int n3 = -1;
        double d3 = Double.POSITIVE_INFINITY;
        for (n = 0; n < this.active_size; ++n) {
            if (this.y[n] == 1) {
                if (this.is_upper_bound(n) || !(-this.G[n] >= d)) continue;
                d = -this.G[n];
                n2 = n;
                continue;
            }
            if (this.is_lower_bound(n) || !(this.G[n] >= d)) continue;
            d = this.G[n];
            n2 = n;
        }
        n = n2;
        float[] fArray = null;
        if (n != -1) {
            fArray = this.Q.get_Q(n, this.active_size);
        }
        for (int i = 0; i < this.active_size; ++i) {
            double d4;
            double d5;
            double d6;
            if (this.y[i] == 1) {
                if (this.is_lower_bound(i)) continue;
                d6 = d + this.G[i];
                if (this.G[i] >= d2) {
                    d2 = this.G[i];
                }
                if (!(d6 > 0.0) || !((d5 = (d4 = (double)(fArray[n] + this.QD[i]) - 2.0 * (double)this.y[n] * (double)fArray[i]) > 0.0 ? -(d6 * d6) / d4 : -(d6 * d6) / 1.0E-12) <= d3)) continue;
                n3 = i;
                d3 = d5;
                continue;
            }
            if (this.is_upper_bound(i)) continue;
            d6 = d - this.G[i];
            if (-this.G[i] >= d2) {
                d2 = -this.G[i];
            }
            if (!(d6 > 0.0) || !((d5 = (d4 = (double)(fArray[n] + this.QD[i]) + 2.0 * (double)this.y[n] * (double)fArray[i]) > 0.0 ? -(d6 * d6) / d4 : -(d6 * d6) / 1.0E-12) <= d3)) continue;
            n3 = i;
            d3 = d5;
        }
        if (d + d2 < this.eps) {
            return 1;
        }
        nArray[0] = n2;
        nArray[1] = n3;
        return 0;
    }

    private boolean be_shrunk(int n, double d, double d2) {
        if (this.is_upper_bound(n)) {
            if (this.y[n] == 1) {
                return -this.G[n] > d;
            }
            return -this.G[n] > d2;
        }
        if (this.is_lower_bound(n)) {
            if (this.y[n] == 1) {
                return this.G[n] > d2;
            }
            return this.G[n] > d;
        }
        return false;
    }

    void do_shrinking() {
        int n;
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        for (n = 0; n < this.active_size; ++n) {
            if (this.y[n] == 1) {
                if (!this.is_upper_bound(n) && -this.G[n] >= d) {
                    d = -this.G[n];
                }
                if (this.is_lower_bound(n) || !(this.G[n] >= d2)) continue;
                d2 = this.G[n];
                continue;
            }
            if (!this.is_upper_bound(n) && -this.G[n] >= d2) {
                d2 = -this.G[n];
            }
            if (this.is_lower_bound(n) || !(this.G[n] >= d)) continue;
            d = this.G[n];
        }
        if (!this.unshrink && d + d2 <= this.eps * 10.0) {
            this.unshrink = true;
            this.reconstruct_gradient();
            this.active_size = this.l;
        }
        block1: for (n = 0; n < this.active_size; ++n) {
            if (!this.be_shrunk(n, d, d2)) continue;
            --this.active_size;
            while (this.active_size > n) {
                if (!this.be_shrunk(this.active_size, d, d2)) {
                    this.swap_index(n, this.active_size);
                    continue block1;
                }
                --this.active_size;
            }
        }
    }

    double calculate_rho() {
        int n = 0;
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = 0.0;
        for (int i = 0; i < this.active_size; ++i) {
            double d4 = (double)this.y[i] * this.G[i];
            if (this.is_lower_bound(i)) {
                if (this.y[i] > 0) {
                    d = Math.min(d, d4);
                    continue;
                }
                d2 = Math.max(d2, d4);
                continue;
            }
            if (this.is_upper_bound(i)) {
                if (this.y[i] < 0) {
                    d = Math.min(d, d4);
                    continue;
                }
                d2 = Math.max(d2, d4);
                continue;
            }
            ++n;
            d3 += d4;
        }
        double d5 = n > 0 ? d3 / (double)n : (d + d2) / 2.0;
        return d5;
    }

    static class SolutionInfo {
        double obj;
        double rho;
        double upper_bound_p;
        double upper_bound_n;
        double r;

        SolutionInfo() {
        }
    }
}

